; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mtriple=powerpc-aix- < %s | \
; RUN:   FileCheck %s
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mtriple=powerpc64le-- < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK_LE
; RUN: llc -verify-machineinstrs -mcpu=pwr8 -mtriple=powerpc64le-- < %s | \
; RUN:   FileCheck %s --check-prefix=CHECK_P8LE
define i1 @shufeq(<2 x i64> %a) #0 {
; CHECK-LABEL: shufeq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd 35, 34
; CHECK-NEXT:    lwz 3, L..C0(2) # %const.0
; CHECK-NEXT:    vcmpequw 2, 2, 3
; CHECK-NEXT:    lxvw4x 35, 0, 3
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    vperm 3, 2, 2, 3
; CHECK-NEXT:    xxland 0, 35, 34
; CHECK-NEXT:    stxvw4x 0, 0, 3
; CHECK-NEXT:    lwz 3, -12(1)
; CHECK-NEXT:    blr
;
; CHECK_LE-LABEL: shufeq:
; CHECK_LE:       # %bb.0: # %entry
; CHECK_LE-NEXT:    xxswapd 35, 34
; CHECK_LE-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; CHECK_LE-NEXT:    addi 3, 3, .LCPI0_0@toc@l
; CHECK_LE-NEXT:    lxvd2x 0, 0, 3
; CHECK_LE-NEXT:    addi 3, 1, -16
; CHECK_LE-NEXT:    vcmpequw 2, 2, 3
; CHECK_LE-NEXT:    xxswapd 35, 0
; CHECK_LE-NEXT:    vperm 3, 2, 2, 3
; CHECK_LE-NEXT:    xxland 0, 35, 34
; CHECK_LE-NEXT:    xxswapd 0, 0
; CHECK_LE-NEXT:    stxvd2x 0, 0, 3
; CHECK_LE-NEXT:    ld 3, -16(1)
; CHECK_LE-NEXT:    blr
;
; CHECK_P8LE-LABEL: shufeq:
; CHECK_P8LE:       # %bb.0: # %entry
; CHECK_P8LE-NEXT:    xxswapd 35, 34
; CHECK_P8LE-NEXT:    vcmpequd 2, 2, 3
; CHECK_P8LE-NEXT:    xxswapd 0, 34
; CHECK_P8LE-NEXT:    mffprd 3, 0
; CHECK_P8LE-NEXT:    blr
entry:
  %0 = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 undef>
  %1 = icmp eq <2 x i64> %a, %0
  %2 = extractelement <2 x i1> %1, i32 0
  ret i1 %2
}

define i1 @shufne(<2 x i64> %a) #0 {
; CHECK-LABEL: shufne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xxswapd 35, 34
; CHECK-NEXT:    lwz 3, L..C1(2) # %const.0
; CHECK-NEXT:    vcmpequw 2, 2, 3
; CHECK-NEXT:    lxvw4x 35, 0, 3
; CHECK-NEXT:    addi 3, 1, -16
; CHECK-NEXT:    vperm 3, 2, 2, 3
; CHECK-NEXT:    xxland 0, 35, 34
; CHECK-NEXT:    stxvw4x 0, 0, 3
; CHECK-NEXT:    lwz 3, -12(1)
; CHECK-NEXT:    blr
;
; CHECK_LE-LABEL: shufne:
; CHECK_LE:       # %bb.0: # %entry
; CHECK_LE-NEXT:    xxswapd 35, 34
; CHECK_LE-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; CHECK_LE-NEXT:    addi 3, 3, .LCPI1_0@toc@l
; CHECK_LE-NEXT:    lxvd2x 0, 0, 3
; CHECK_LE-NEXT:    addi 3, 1, -16
; CHECK_LE-NEXT:    vcmpequw 2, 2, 3
; CHECK_LE-NEXT:    xxswapd 35, 0
; CHECK_LE-NEXT:    vperm 3, 2, 2, 3
; CHECK_LE-NEXT:    xxland 0, 35, 34
; CHECK_LE-NEXT:    xxswapd 0, 0
; CHECK_LE-NEXT:    stxvd2x 0, 0, 3
; CHECK_LE-NEXT:    ld 3, -16(1)
; CHECK_LE-NEXT:    blr
;
; CHECK_P8LE-LABEL: shufne:
; CHECK_P8LE:       # %bb.0: # %entry
; CHECK_P8LE-NEXT:    xxswapd 35, 34
; CHECK_P8LE-NEXT:    vcmpequd 2, 2, 3
; CHECK_P8LE-NEXT:    xxswapd 0, 34
; CHECK_P8LE-NEXT:    mffprd 3, 0
; CHECK_P8LE-NEXT:    blr
entry:
  %0 = shufflevector <2 x i64> %a, <2 x i64> poison, <2 x i32> <i32 1, i32 undef>
  %1 = icmp eq <2 x i64> %a, %0
  %2 = extractelement <2 x i1> %1, i32 0
  ret i1 %2
}

define <2 x i64> @cmpeq(<2 x i64> noundef %a, <2 x i64> noundef %b) {
; CHECK-LABEL: cmpeq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lwz 3, L..C2(2) # %const.0
; CHECK-NEXT:    vcmpequw 2, 2, 3
; CHECK-NEXT:    lxvw4x 35, 0, 3
; CHECK-NEXT:    vperm 3, 2, 2, 3
; CHECK-NEXT:    xxland 34, 35, 34
; CHECK-NEXT:    blr
;
; CHECK_LE-LABEL: cmpeq:
; CHECK_LE:       # %bb.0: # %entry
; CHECK_LE-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; CHECK_LE-NEXT:    vcmpequw 2, 2, 3
; CHECK_LE-NEXT:    addi 3, 3, .LCPI2_0@toc@l
; CHECK_LE-NEXT:    lxvd2x 0, 0, 3
; CHECK_LE-NEXT:    xxswapd 35, 0
; CHECK_LE-NEXT:    vperm 3, 2, 2, 3
; CHECK_LE-NEXT:    xxland 34, 35, 34
; CHECK_LE-NEXT:    blr
;
; CHECK_P8LE-LABEL: cmpeq:
; CHECK_P8LE:       # %bb.0: # %entry
; CHECK_P8LE-NEXT:    vcmpequd 2, 2, 3
; CHECK_P8LE-NEXT:    blr
entry:
  %cmp = icmp eq <2 x i64> %a, %b
  %sext = sext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %sext
}

define <2 x i64> @cmpne(<2 x i64> noundef %a, <2 x i64> noundef %b) {
; CHECK-LABEL: cmpne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vcmpequw 2, 2, 3
; CHECK-NEXT:    lwz 3, L..C3(2) # %const.0
; CHECK-NEXT:    lxvw4x 35, 0, 3
; CHECK-NEXT:    xxlnor 34, 34, 34
; CHECK-NEXT:    vperm 3, 2, 2, 3
; CHECK-NEXT:    xxlor 34, 35, 34
; CHECK-NEXT:    blr
;
; CHECK_LE-LABEL: cmpne:
; CHECK_LE:       # %bb.0: # %entry
; CHECK_LE-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK_LE-NEXT:    vcmpequw 2, 2, 3
; CHECK_LE-NEXT:    addi 3, 3, .LCPI3_0@toc@l
; CHECK_LE-NEXT:    lxvd2x 0, 0, 3
; CHECK_LE-NEXT:    xxswapd 35, 0
; CHECK_LE-NEXT:    xxlnor 34, 34, 34
; CHECK_LE-NEXT:    vperm 3, 2, 2, 3
; CHECK_LE-NEXT:    xxlor 34, 35, 34
; CHECK_LE-NEXT:    blr
;
; CHECK_P8LE-LABEL: cmpne:
; CHECK_P8LE:       # %bb.0: # %entry
; CHECK_P8LE-NEXT:    vcmpequd 2, 2, 3
; CHECK_P8LE-NEXT:    xxlnor 34, 34, 34
; CHECK_P8LE-NEXT:    blr
entry:
  %cmp = icmp ne <2 x i64> %a, %b
  %sext = sext <2 x i1> %cmp to <2 x i64>
  ret <2 x i64> %sext
}

