from typing import Dict, Optional, Sequence, Union

from weaviate.collections.tenants.types import (
    TenantCreateInputType,
    TenantInputType,
    TenantOutputType,
    TenantUpdateInputType,
)
from weaviate.connect.v4 import ConnectionAsync

from .executor import _TenantsExecutor

class _TenantsAsync(_TenantsExecutor[ConnectionAsync]):
    async def create(
        self, tenants: Union[TenantCreateInputType, Sequence[TenantCreateInputType]]
    ) -> None: ...
    async def remove(self, tenants: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
    async def get(self) -> Dict[str, TenantOutputType]: ...
    async def get_by_names(
        self, tenants: Sequence[TenantInputType]
    ) -> Dict[str, TenantOutputType]: ...
    async def get_by_name(self, tenant: TenantInputType) -> Optional[TenantOutputType]: ...
    async def update(
        self, tenants: Union[TenantUpdateInputType, Sequence[TenantUpdateInputType]]
    ) -> None: ...
    async def exists(self, tenant: TenantInputType) -> bool: ...
    async def activate(self, tenant: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
    async def deactivate(
        self, tenant: Union[TenantInputType, Sequence[TenantInputType]]
    ) -> None: ...
    async def offload(self, tenant: Union[TenantInputType, Sequence[TenantInputType]]) -> None: ...
