// Auto-generated file. Do not edit!
//   Template: src/f32-ppmm/8x8-aarch64-neonfma-cortex-a75.S.in
//   Generator: tools/xngen
//
// Copyright 2023 Google LLC
//
// This source code is licensed under the BSD-style license found in the
// LICENSE file in the root directory of this source tree.

#include <xnnpack/assembly.h>

# void xnn_f32_ppmm_minmax_ukernel_8x8__asm_aarch64_neonfma_cortex_a75(
#     size_t mr,                x0
#     size_t nc,                x1
#     size_t kc,                x2 / x0
#     const uint8_t* restrict a, x3
#     const void* restrict w,    x4
#     uint8_t* restrict c,       x5
#     size_t cm_stride,         x6
#     size_t cn_stride,         x7
#     const union xnn_f32_minmax_params params[restrict XNN_MIN_ELEMENTS(1)])  [sp] -> x8

# d8-d15, x19-x30 need to be preserved if used. x18 is reserved by the OS.

# Vector register usage
# A    x3  v0 v1
# B    x4  v4 v5
# C0   x5  v16 v17
# C1  x12  v18 v19
# C2  x13  v20 v21
# C3  x14  v22 v23
# C4  x15  v24 v25
# C5  x16  v26 v27
# C6  x17  v28 v29
# C7   x6  v30 v31
# Clamp    v6 v7

BEGIN_FUNCTION xnn_f32_ppmm_minmax_ukernel_8x8__asm_aarch64_neonfma_cortex_a75

        # Load params pointer
        LDR         x8, [sp]

        # Clamp A and C pointers
        CMP         x0, 2                   // if mr < 2
        ADD         x12, x5, x6             // c1 = c0 + cm_stride
        CSEL        x12, x5, x12, LO        //   c1 = c0
        ADD         x13, x12, x6            // c2 = c1 + cm_stride
                                            // if mr <= 2
        CSEL        x13, x12, x13, LS       //   c2 = c1
        CMP         x0, 4                   // if mr < 4
        ADD         x14, x13, x6            // c3 = c2 + cm_stride
        CSEL        x14, x13, x14, LO       //   c3 = c2

        # Load min/max values
        LD2R        {v6.4s, v7.4s}, [x8]

        ADD         x15, x14, x6            // c4 = c3 + cm_stride
                                            // if mr <= 4
        CSEL        x15, x14, x15, LS       //   c4 = c3
        CMP         x0, 6                   // if mr < 6
        ADD         x16, x15, x6            // c5 = c4 + cm_stride
        CSEL        x16, x15, x16, LO       //   c5 = c4
        ADD         x17, x16, x6            // c6 = c5 + cm_stride
                                            // if mr <= 4
        CSEL        x17, x16, x17, LS       //   c6 = c5
        CMP         x0, 8                   // if mr < 8
        ADD         x6, x17, x6             // c7 = c6 + cm_stride
        CSEL        x6, x17, x6, LO         //   c7 = c6

0:
        # Load initial bias from w into accumulators
        LDR         q16, [x4], 16
        LDR         q17, [x4], 16
        MOV         v18.16b, v16.16b
        MOV         v20.16b, v16.16b
        LDR         q0, [x3], 16            // Prologue - loads for main loop
        MOV         v22.16b, v16.16b
        MOV         v24.16b, v16.16b
        LDR         q4, [x4], 16
        MOV         v26.16b, v16.16b
        MOV         v28.16b, v16.16b
        MOV         v30.16b, v16.16b
        MOV         v19.16b, v17.16b
        MOV         v21.16b, v17.16b
        MOV         v23.16b, v17.16b
        SUBS        x0, x2, 8               // k = kc - 8
        MOV         v25.16b, v17.16b
        MOV         v27.16b, v17.16b
        MOV         v29.16b, v17.16b
        MOV         v31.16b, v17.16b

        # Is there at least 2 floats (8 bytes) for mainloop + epilogue?
        B.LO        2f

        # Main loop - 2 float of A (8 bytes)
1:
        LDR         q1, [x3], 16
        FMLA        v16.4s, v4.4s, v0.s[0]
        LDR         q5, [x4], 16
        FMLA        v18.4s, v4.4s, v0.s[1]
        FMLA        v20.4s, v4.4s, v0.s[2]
        FMLA        v22.4s, v4.4s, v0.s[3]
        FMLA        v24.4s, v4.4s, v1.s[0]
        FMLA        v26.4s, v4.4s, v1.s[1]
        FMLA        v28.4s, v4.4s, v1.s[2]
        FMLA        v30.4s, v4.4s, v1.s[3]
        FMLA        v17.4s, v5.4s, v0.s[0]
        LDR         q4, [x4], 16
        FMLA        v19.4s, v5.4s, v0.s[1]
        FMLA        v21.4s, v5.4s, v0.s[2]
        FMLA        v23.4s, v5.4s, v0.s[3]
        FMLA        v25.4s, v5.4s, v1.s[0]
        LDR         q0, [x3], 16
        FMLA        v27.4s, v5.4s, v1.s[1]
        SUBS        x0, x0, 4
        FMLA        v29.4s, v5.4s, v1.s[2]
        FMLA        v31.4s, v5.4s, v1.s[3]
        B.HS        1b

        # Epilogue
2:
        LDR         q1, [x3], 16
        FMLA        v16.4s, v4.4s, v0.s[0]
        LDR         q5, [x4], 16
        FMLA        v18.4s, v4.4s, v0.s[1]
        FMLA        v20.4s, v4.4s, v0.s[2]
        FMLA        v22.4s, v4.4s, v0.s[3]
        FMLA        v24.4s, v4.4s, v1.s[0]
        FMLA        v26.4s, v4.4s, v1.s[1]
        FMLA        v28.4s, v4.4s, v1.s[2]
        FMLA        v30.4s, v4.4s, v1.s[3]
        FMLA        v17.4s, v5.4s, v0.s[0]
        FMLA        v19.4s, v5.4s, v0.s[1]
        FMLA        v21.4s, v5.4s, v0.s[2]
        FMLA        v23.4s, v5.4s, v0.s[3]
        FMLA        v25.4s, v5.4s, v1.s[0]
        FMLA        v27.4s, v5.4s, v1.s[1]
        FMLA        v29.4s, v5.4s, v1.s[2]
        FMLA        v31.4s, v5.4s, v1.s[3]

        # Clamp
        FMAX        v16.4s, v16.4s, v6.4s
        FMAX        v17.4s, v17.4s, v6.4s
        FMAX        v18.4s, v18.4s, v6.4s
        FMAX        v19.4s, v19.4s, v6.4s
        FMAX        v20.4s, v20.4s, v6.4s
        FMAX        v21.4s, v21.4s, v6.4s
        FMAX        v22.4s, v22.4s, v6.4s
        FMAX        v23.4s, v23.4s, v6.4s
        FMAX        v24.4s, v24.4s, v6.4s
        FMAX        v25.4s, v25.4s, v6.4s
        FMAX        v26.4s, v26.4s, v6.4s
        FMAX        v27.4s, v27.4s, v6.4s
        FMAX        v28.4s, v28.4s, v6.4s
        FMAX        v29.4s, v29.4s, v6.4s
        FMAX        v30.4s, v30.4s, v6.4s
        FMAX        v31.4s, v31.4s, v6.4s
        SUBS        x1, x1, 8
        FMIN        v16.4s, v16.4s, v7.4s
        FMIN        v17.4s, v17.4s, v7.4s
        FMIN        v18.4s, v18.4s, v7.4s
        FMIN        v19.4s, v19.4s, v7.4s
        FMIN        v20.4s, v20.4s, v7.4s
        FMIN        v21.4s, v21.4s, v7.4s
        FMIN        v22.4s, v22.4s, v7.4s
        FMIN        v23.4s, v23.4s, v7.4s
        FMIN        v24.4s, v24.4s, v7.4s
        FMIN        v25.4s, v25.4s, v7.4s
        FMIN        v26.4s, v26.4s, v7.4s
        FMIN        v27.4s, v27.4s, v7.4s
        FMIN        v28.4s, v28.4s, v7.4s
        FMIN        v29.4s, v29.4s, v7.4s
        FMIN        v30.4s, v30.4s, v7.4s
        FMIN        v31.4s, v31.4s, v7.4s

        # Store full 8 x 8
        B.LO        3f

        ST1         {v16.16b, v17.16b},  [x5], x7
        ST1         {v18.16b, v19.16b}, [x12], x7
        ST1         {v20.16b, v21.16b}, [x13], x7
        ST1         {v22.16b, v23.16b}, [x14], x7
        SUB         x3, x3, x2, lsl #3              // a0 -= kc * 8
        ST1         {v24.16b, v25.16b}, [x15], x7
        ST1         {v26.16b, v27.16b}, [x16], x7
        ST1         {v28.16b, v29.16b}, [x17], x7
        ST1         {v30.16b, v31.16b},  [x6], x7
        B.HI        0b
        RET

        # Store odd width
3:
        TBZ         x1, 2, 4f
        STR         q16,  [x5], 16
        STR         q18, [x12], 16
        MOV         v16.16b, v17.16b
        MOV         v18.16b, v19.16b
        STR         q20, [x13], 16
        STR         q22, [x14], 16
        MOV         v20.16b, v21.16b
        MOV         v22.16b, v23.16b
        STR         q24, [x15], 16
        STR         q26, [x16], 16
        MOV         v24.16b, v25.16b
        MOV         v26.16b, v27.16b
        STR         q28, [x17], 16
        STR         q30,  [x6], 16
        MOV         v28.16b, v29.16b
        MOV         v30.16b, v31.16b
4:
        TBZ         x1, 1, 5f
        STR         d16,  [x5], 8
        STR         d18, [x12], 8
        DUP         d16, v16.d[1]
        DUP         d18, v18.d[1]
        STR         d20, [x13], 8
        STR         d22, [x14], 8
        DUP         d20, v20.d[1]
        DUP         d22, v22.d[1]
        STR         d24, [x15], 8
        STR         d26, [x16], 8
        DUP         d24, v24.d[1]
        DUP         d26, v26.d[1]
        STR         d28, [x17], 8
        STR         d30,  [x6], 8
        DUP         d28, v28.d[1]
        DUP         d30, v30.d[1]

5:
        TBZ         x1, 0, 6f
        STR         s16,  [x5]
        STR         s18, [x12]
        STR         s20, [x13]
        STR         s22, [x14]
        STR         s24, [x15]
        STR         s26, [x16]
        STR         s28, [x17]
        STR         s30,  [x6]

6:
        RET

END_FUNCTION xnn_f32_ppmm_minmax_ukernel_8x8__asm_aarch64_neonfma_cortex_a75

#ifdef __ELF__
.section ".note.GNU-stack","",%progbits
#endif
