#------------------------------------------------------------------------------
# Copyright (c) 2020, 2025, Oracle and/or its affiliates.
#
# This software is dual-licensed to you under the Universal Permissive License
# (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl and Apache License
# 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose
# either license.
#
# If you elect to accept the software under the Apache License, Version 2.0,
# the following applies:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# constants.pxi
#
# Cython file defining constants used by the thin implementation classes
# (embedded in thin_impl.pyx).
#------------------------------------------------------------------------------

# packet types
cdef enum:
    TNS_PACKET_TYPE_CONNECT = 1
    TNS_PACKET_TYPE_ACCEPT = 2
    TNS_PACKET_TYPE_REFUSE = 4
    TNS_PACKET_TYPE_DATA = 6
    TNS_PACKET_TYPE_RESEND = 11
    TNS_PACKET_TYPE_MARKER = 12
    TNS_PACKET_TYPE_CONTROL = 14
    TNS_PACKET_TYPE_REDIRECT = 5

# packet flags
cdef enum:
    TNS_PACKET_FLAG_REDIRECT = 0x04
    TNS_PACKET_FLAG_TLS_RENEG = 0x08

# data flags
cdef enum:
    TNS_DATA_FLAGS_BEGIN_PIPELINE = 0x1000
    TNS_DATA_FLAGS_END_OF_REQUEST = 0x800
    TNS_DATA_FLAGS_END_OF_RESPONSE = 0x2000
    TNS_DATA_FLAGS_EOF = 0x0040

# marker types
cdef enum:
    TNS_MARKER_TYPE_BREAK = 1
    TNS_MARKER_TYPE_RESET = 2
    TNS_MARKER_TYPE_INTERRUPT = 3

# AQ delivery modes
cdef enum:
    TNS_AQ_MSG_BUFFERED = 2
    TNS_AQ_MSG_PERSISTENT = 1
    TNS_AQ_MSG_PERSISTENT_OR_BUFFERED = 3

# AQ dequeue modes
cdef enum:
    TNS_AQ_DEQ_BROWSE = 1
    TNS_AQ_DEQ_LOCKED = 2
    TNS_AQ_DEQ_REMOVE = 3
    TNS_AQ_DEQ_REMOVE_NODATA = 4

# AQ dequeue navigation modes
cdef enum:
    TNS_AQ_DEQ_FIRST_MSG = 1
    TNS_AQ_DEQ_NEXT_MSG = 3
    TNS_AQ_DEQ_NEXT_TRANSACTION = 2

# AQ dequeue visibility modes
cdef enum:
    TNS_AQ_DEQ_IMMEDIATE = 1
    TNS_AQ_DEQ_ON_COMMIT = 2

# AQ dequeue wait modes
cdef enum:
    TNS_AQ_DEQ_NO_WAIT = 0
    TNS_AQ_DEQ_WAIT_FOREVER = <uint32_t>-1

# AQ enqueue visibility modes
cdef enum:
    TNS_AQ_ENQ_IMMEDIATE = 1
    TNS_AQ_ENQ_ON_COMMIT = 2

# AQ message states
cdef enum:
    TNS_AQ_MSG_EXPIRED = 3
    TNS_AQ_MSG_PROCESSED = 2
    TNS_AQ_MSG_READY = 0
    TNS_AQ_MSG_WAITING = 1

# AQ other constants
cdef enum:
    TNS_AQ_MSG_NO_DELAY = 0
    TNS_AQ_MSG_NO_EXPIRATION = -1
    TNS_AQ_ARRAY_ENQ = 0x01
    TNS_AQ_ARRAY_DEQ = 0x02
    TNS_AQ_ARRAY_FLAGS_RETURN_MESSAGE_ID = 0x01
    TNS_TTC_ENQ_STREAMING_ENABLED = 0x00000001
    TNS_TTC_ENQ_STREAMING_DISABLED = 0x00000000

# AQ flags
cdef enum:
    TNS_KPD_AQ_BUFMSG = 0x02
    TNS_KPD_AQ_EITHER = 0x10

# errors
cdef enum:
    TNS_ERR_INCONSISTENT_DATA_TYPES = 932
    TNS_ERR_VAR_NOT_IN_SELECT_LIST = 1007
    TNS_ERR_INBAND_MESSAGE = 12573
    TNS_ERR_INVALID_SERVICE_NAME = 12514
    TNS_ERR_INVALID_SID = 12505
    TNS_ERR_NO_DATA_FOUND = 1403
    TNS_ERR_SESSION_SHUTDOWN = 12572
    TNS_ERR_ARRAY_DML_ERRORS = 24381
    TNS_ERR_EXCEEDED_IDLE_TIME = 2396
    TNS_ERR_NO_MESSAGES_FOUND = 25228

# message types
cdef enum:
    TNS_MSG_TYPE_PROTOCOL = 1
    TNS_MSG_TYPE_DATA_TYPES = 2
    TNS_MSG_TYPE_FUNCTION = 3
    TNS_MSG_TYPE_ERROR = 4
    TNS_MSG_TYPE_ROW_HEADER = 6
    TNS_MSG_TYPE_ROW_DATA = 7
    TNS_MSG_TYPE_PARAMETER = 8
    TNS_MSG_TYPE_STATUS = 9
    TNS_MSG_TYPE_IO_VECTOR = 11
    TNS_MSG_TYPE_LOB_DATA = 14
    TNS_MSG_TYPE_WARNING = 15
    TNS_MSG_TYPE_DESCRIBE_INFO = 16
    TNS_MSG_TYPE_PIGGYBACK = 17
    TNS_MSG_TYPE_FLUSH_OUT_BINDS = 19
    TNS_MSG_TYPE_BIT_VECTOR = 21
    TNS_MSG_TYPE_SERVER_SIDE_PIGGYBACK = 23
    TNS_MSG_TYPE_ONEWAY_FN = 26
    TNS_MSG_TYPE_IMPLICIT_RESULTSET = 27
    TNS_MSG_TYPE_RENEGOTIATE = 28
    TNS_MSG_TYPE_END_OF_RESPONSE = 29
    TNS_MSG_TYPE_TOKEN = 33
    TNS_MSG_TYPE_FAST_AUTH = 34

# parameter keyword numbers
cdef enum:
    TNS_KEYWORD_NUM_CURRENT_SCHEMA = 168
    TNS_KEYWORD_NUM_EDITION = 172
    TNS_KEYWORD_NUM_TRANSACTION_ID = 201

# bind flags
cdef enum:
    TNS_BIND_USE_INDICATORS = 0x0001
    TNS_BIND_ARRAY = 0x0040

# bind directions
cdef enum:
    TNS_BIND_DIR_OUTPUT = 16
    TNS_BIND_DIR_INPUT = 32
    TNS_BIND_DIR_INPUT_OUTPUT = 48

# database object image flags
cdef enum:
    TNS_OBJ_IS_VERSION_81 = 0x80
    TNS_OBJ_IS_DEGENERATE = 0x10
    TNS_OBJ_IS_COLLECTION = 0x08
    TNS_OBJ_NO_PREFIX_SEG = 0x04
    TNS_OBJ_IMAGE_VERSION = 1

# database object flags
cdef enum:
    TNS_OBJ_MAX_SHORT_LENGTH = 245
    TNS_OBJ_ATOMIC_NULL = 253
    TNS_OBJ_NON_NULL_OID = 0x02
    TNS_OBJ_HAS_EXTENT_OID = 0x08
    TNS_OBJ_TOP_LEVEL = 0x01
    TNS_OBJ_HAS_INDEXES = 0x10

# database object collection types
cdef enum:
    TNS_OBJ_PLSQL_INDEX_TABLE = 1
    TNS_OBJ_NESTED_TABLE = 2
    TNS_OBJ_VARRAY = 3

# database object TDS type codes
cdef enum:
    TNS_OBJ_TDS_TYPE_CHAR = 1
    TNS_OBJ_TDS_TYPE_DATE = 2
    TNS_OBJ_TDS_TYPE_FLOAT = 5
    TNS_OBJ_TDS_TYPE_NUMBER = 6
    TNS_OBJ_TDS_TYPE_VARCHAR = 7
    TNS_OBJ_TDS_TYPE_BOOLEAN = 8
    TNS_OBJ_TDS_TYPE_RAW = 19
    TNS_OBJ_TDS_TYPE_TIMESTAMP = 21
    TNS_OBJ_TDS_TYPE_TIMESTAMP_TZ = 23
    TNS_OBJ_TDS_TYPE_OBJ = 27
    TNS_OBJ_TDS_TYPE_COLL = 28
    TNS_OBJ_TDS_TYPE_CLOB = 29
    TNS_OBJ_TDS_TYPE_BLOB = 30
    TNS_OBJ_TDS_TYPE_TIMESTAMP_LTZ = 33
    TNS_OBJ_TDS_TYPE_BINARY_FLOAT = 37
    TNS_OBJ_TDS_TYPE_START_EMBED_ADT = 39
    TNS_OBJ_TDS_TYPE_END_EMBED_ADT = 40
    TNS_OBJ_TDS_TYPE_SUBTYPE_MARKER = 43
    TNS_OBJ_TDS_TYPE_EMBED_ADT_INFO = 44
    TNS_OBJ_TDS_TYPE_BINARY_DOUBLE = 45

# xml type constants
cdef enum:
    TNS_XML_TYPE_LOB = 0x0001
    TNS_XML_TYPE_STRING = 0x0004
    TNS_XML_TYPE_FLAG_SKIP_NEXT_4 = 0x100000

# execute options
cdef enum:
    TNS_EXEC_OPTION_PARSE = 0x01
    TNS_EXEC_OPTION_BIND = 0x08
    TNS_EXEC_OPTION_DEFINE = 0x10
    TNS_EXEC_OPTION_EXECUTE = 0x20
    TNS_EXEC_OPTION_FETCH = 0x40
    TNS_EXEC_OPTION_COMMIT = 0x100
    TNS_EXEC_OPTION_COMMIT_REEXECUTE = 0x1
    TNS_EXEC_OPTION_PLSQL_BIND = 0x400
    TNS_EXEC_OPTION_NOT_PLSQL = 0x8000
    TNS_EXEC_OPTION_DESCRIBE = 0x20000
    TNS_EXEC_OPTION_NO_COMPRESSED_FETCH = 0x40000
    TNS_EXEC_OPTION_BATCH_ERRORS = 0x80000

# execute flags
cdef enum:
    TNS_EXEC_FLAGS_DML_ROWCOUNTS = 0x4000
    TNS_EXEC_FLAGS_IMPLICIT_RESULTSET = 0x8000
    TNS_EXEC_FLAGS_NO_CANCEL_ON_EOF = 0x80
    TNS_EXEC_FLAGS_SCROLLABLE = 0x02

# fetch orientations
cdef enum:
    TNS_FETCH_ORIENTATION_ABSOLUTE = 0x20
    TNS_FETCH_ORIENTATION_CURRENT = 0x01
    TNS_FETCH_ORIENTATION_FIRST = 0x04
    TNS_FETCH_ORIENTATION_LAST = 0x08
    TNS_FETCH_ORIENTATION_NEXT = 0x02
    TNS_FETCH_ORIENTATION_PRIOR = 0x10
    TNS_FETCH_ORIENTATION_RELATIVE = 0x40

# server side piggyback op codes
cdef enum:
    TNS_SERVER_PIGGYBACK_QUERY_CACHE_INVALIDATION = 1
    TNS_SERVER_PIGGYBACK_OS_PID_MTS = 2
    TNS_SERVER_PIGGYBACK_TRACE_EVENT = 3
    TNS_SERVER_PIGGYBACK_SESS_RET = 4
    TNS_SERVER_PIGGYBACK_SYNC = 5
    TNS_SERVER_PIGGYBACK_LTXID = 7
    TNS_SERVER_PIGGYBACK_AC_REPLAY_CONTEXT = 8
    TNS_SERVER_PIGGYBACK_EXT_SYNC = 9
    TNS_SERVER_PIGGYBACK_SESS_SIGNATURE = 10

# session return constants
cdef enum:
    TNS_SESSGET_SESSION_CHANGED = 4

# LOB operations
cdef enum:
    TNS_LOB_OP_GET_LENGTH = 0x0001
    TNS_LOB_OP_READ = 0x0002
    TNS_LOB_OP_TRIM = 0x0020
    TNS_LOB_OP_WRITE = 0x0040
    TNS_LOB_OP_GET_CHUNK_SIZE = 0x4000
    TNS_LOB_OP_CREATE_TEMP = 0x0110
    TNS_LOB_OP_FREE_TEMP = 0x0111
    TNS_LOB_OP_OPEN = 0x8000
    TNS_LOB_OP_CLOSE = 0x10000
    TNS_LOB_OP_IS_OPEN = 0x11000
    TNS_LOB_OP_ARRAY = 0x80000
    TNS_LOB_OP_FILE_EXISTS = 0x0800
    TNS_LOB_OP_FILE_OPEN = 0x0100
    TNS_LOB_OP_FILE_CLOSE = 0x0200
    TNS_LOB_OP_FILE_ISOPEN = 0x0400

# LOB locator constants
cdef enum:
    TNS_LOB_LOC_OFFSET_FLAG_1 = 4
    TNS_LOB_LOC_OFFSET_FLAG_3 = 6
    TNS_LOB_LOC_OFFSET_FLAG_4 = 7
    TNS_LOB_QLOCATOR_VERSION = 4
    TNS_LOB_LOC_FIXED_OFFSET = 16

# LOB locator flags (byte 1)
cdef enum:
    TNS_LOB_LOC_FLAGS_BLOB = 0x01
    TNS_LOB_LOC_FLAGS_VALUE_BASED = 0x20
    TNS_LOB_LOC_FLAGS_ABSTRACT = 0x40

# LOB locator flags (byte 2)
cdef enum:
    TNS_LOB_LOC_FLAGS_INIT = 0x08

# LOB locator flags (byte 4)
cdef enum:
    TNS_LOB_LOC_FLAGS_TEMP = 0x01
    TNS_LOB_LOC_FLAGS_VAR_LENGTH_CHARSET = 0x80

# other LOB constants
cdef enum:
    TNS_LOB_OPEN_READ_WRITE = 2
    TNS_LOB_OPEN_READ_ONLY = 11
    TNS_LOB_PREFETCH_FLAG = 0x2000000

# end-to-end metrics
cdef enum:
    TNS_END_TO_END_ACTION = 0x0010
    TNS_END_TO_END_CLIENT_IDENTIFIER = 0x0001
    TNS_END_TO_END_CLIENT_INFO = 0x0100
    TNS_END_TO_END_DBOP = 0x0200
    TNS_END_TO_END_MODULE = 0x0008

# versions
cdef enum:
    TNS_VERSION_DESIRED = 319
    TNS_VERSION_MINIMUM = 300
    TNS_VERSION_MIN_ACCEPTED = 315      # 12.1
    TNS_VERSION_MIN_LARGE_SDU = 315
    TNS_VERSION_MIN_OOB_CHECK = 318
    TNS_VERSION_MIN_END_OF_RESPONSE = 319

# control packet types
cdef enum:
    TNS_CONTROL_TYPE_INBAND_NOTIFICATION = 8
    TNS_CONTROL_TYPE_RESET_OOB = 9

# connect flags
cdef enum:
    TNS_GSO_DONT_CARE = 0x0001
    TNS_GSO_CAN_RECV_ATTENTION = 0x0400
    TNS_NSI_NA_REQUIRED = 0x10
    TNS_NSI_DISABLE_NA = 0x04
    TNS_NSI_SUPPORT_SECURITY_RENEG = 0x80

# other connection constants
cdef enum:
    TNS_PROTOCOL_CHARACTERISTICS = 0x4f98
    TNS_CHECK_OOB = 0x01

# TTC functions
cdef enum:
    TNS_FUNC_AUTH_PHASE_ONE = 118
    TNS_FUNC_AUTH_PHASE_TWO = 115
    TNS_FUNC_CLOSE_CURSORS = 105
    TNS_FUNC_COMMIT = 14
    TNS_FUNC_DIRECT_PATH_LOAD_STREAM = 129
    TNS_FUNC_DIRECT_PATH_OP = 130
    TNS_FUNC_DIRECT_PATH_PREPARE = 128
    TNS_FUNC_EXECUTE = 94
    TNS_FUNC_FETCH = 5
    TNS_FUNC_LOB_OP = 96
    TNS_FUNC_AQ_ENQ = 121
    TNS_FUNC_AQ_DEQ = 122
    TNS_FUNC_ARRAY_AQ = 145
    TNS_FUNC_LOGOFF = 9
    TNS_FUNC_PING = 147
    TNS_FUNC_PIPELINE_BEGIN = 199
    TNS_FUNC_PIPELINE_END = 200
    TNS_FUNC_ROLLBACK = 15
    TNS_FUNC_SET_END_TO_END_ATTR = 135
    TNS_FUNC_REEXECUTE = 4
    TNS_FUNC_REEXECUTE_AND_FETCH = 78
    TNS_FUNC_SESSION_GET = 162
    TNS_FUNC_SESSION_RELEASE = 163
    TNS_FUNC_SESSION_STATE = 176
    TNS_FUNC_SET_SCHEMA = 152
    TNS_FUNC_TPC_TXN_SWITCH = 103
    TNS_FUNC_TPC_TXN_CHANGE_STATE = 104

# TTC authentication modes
cdef enum:
    TNS_AUTH_MODE_LOGON = 0x00000001
    TNS_AUTH_MODE_CHANGE_PASSWORD = 0x00000002
    TNS_AUTH_MODE_SYSDBA = 0x00000020
    TNS_AUTH_MODE_SYSOPER = 0x00000040
    TNS_AUTH_MODE_WITH_PASSWORD = 0x00000100
    TNS_AUTH_MODE_SYSASM = 0x00400000
    TNS_AUTH_MODE_SYSBKP = 0x01000000
    TNS_AUTH_MODE_SYSDGD = 0x02000000
    TNS_AUTH_MODE_SYSKMT = 0x04000000
    TNS_AUTH_MODE_SYSRAC = 0x08000000
    TNS_AUTH_MODE_IAM_TOKEN = 0x20000000

# character sets and encodings
cdef enum:
    TNS_CHARSET_UTF8 = 873
    TNS_CHARSET_UTF16 = 2000
    TNS_ENCODING_MULTI_BYTE = 0x01
    TNS_ENCODING_CONV_LENGTH = 0x02

# compile time capability indices
cdef enum:
    TNS_CCAP_SQL_VERSION = 0
    TNS_CCAP_LOGON_TYPES = 4
    TNS_CCAP_FEATURE_BACKPORT = 5
    TNS_CCAP_FIELD_VERSION = 7
    TNS_CCAP_SERVER_DEFINE_CONV = 8
    TNS_CCAP_DEQUEUE_WITH_SELECTOR = 9
    TNS_CCAP_TTC1 = 15
    TNS_CCAP_OCI1 = 16
    TNS_CCAP_TDS_VERSION = 17
    TNS_CCAP_RPC_VERSION = 18
    TNS_CCAP_RPC_SIG = 19
    TNS_CCAP_DBF_VERSION = 21
    TNS_CCAP_LOB = 23
    TNS_CCAP_TTC2 = 26
    TNS_CCAP_UB2_DTY = 27
    TNS_CCAP_OCI2 = 31
    TNS_CCAP_CLIENT_FN = 34
    TNS_CCAP_OCI3 = 35
    TNS_CCAP_TTC3 = 37
    TNS_CCAP_SESS_SIGNATURE_VERSION = 39
    TNS_CCAP_TTC4 = 40
    TNS_CCAP_LOB2 = 42
    TNS_CCAP_TTC5 = 44
    TNS_CCAP_VECTOR_FEATURES = 52
    TNS_CCAP_MAX = 53

# compile time capability values
cdef enum:
    TNS_CCAP_SQL_VERSION_MAX = 6
    TNS_CCAP_FIELD_VERSION_11_2 = 6
    TNS_CCAP_FIELD_VERSION_12_1 = 7
    TNS_CCAP_FIELD_VERSION_12_2 = 8
    TNS_CCAP_FIELD_VERSION_12_2_EXT1 = 9
    TNS_CCAP_FIELD_VERSION_18_1 = 10
    TNS_CCAP_FIELD_VERSION_18_1_EXT_1 = 11
    TNS_CCAP_FIELD_VERSION_19_1 = 12
    TNS_CCAP_FIELD_VERSION_19_1_EXT_1 = 13
    TNS_CCAP_FIELD_VERSION_20_1 = 14
    TNS_CCAP_FIELD_VERSION_20_1_EXT_1 = 15
    TNS_CCAP_FIELD_VERSION_21_1 = 16
    TNS_CCAP_FIELD_VERSION_23_1 = 17
    TNS_CCAP_FIELD_VERSION_23_1_EXT_1 = 18
    TNS_CCAP_FIELD_VERSION_23_1_EXT_2 = 19
    TNS_CCAP_FIELD_VERSION_23_1_EXT_3 = 20
    TNS_CCAP_FIELD_VERSION_23_1_EXT_4 = 21
    TNS_CCAP_FIELD_VERSION_23_1_EXT_5 = 22
    TNS_CCAP_FIELD_VERSION_23_3_EXT_6 = 23
    TNS_CCAP_FIELD_VERSION_23_4 = 24
    TNS_CCAP_FIELD_VERSION_MAX = 24
    TNS_CCAP_O5LOGON = 8
    TNS_CCAP_O5LOGON_NP = 2
    TNS_CCAP_O7LOGON = 32
    TNS_CCAP_O8LOGON_LONG_IDENTIFIER = 64
    TNS_CCAP_O9LOGON_LONG_PASSWORD = 0x80
    TNS_CCAP_CTB_IMPLICIT_POOL = 0x08
    TNS_CCAP_CTB_OAUTH_MSG_ON_ERR = 0x10
    TNS_CCAP_END_OF_CALL_STATUS = 0x01
    TNS_CCAP_IND_RCD = 0x08
    TNS_CCAP_FAST_BVEC = 0x20
    TNS_CCAP_FAST_SESSION_PROPAGATE = 0x10
    TNS_CCAP_APP_CTX_PIGGYBACK = 0x80
    TNS_CCAP_TDS_VERSION_MAX = 3
    TNS_CCAP_RPC_VERSION_MAX = 7
    TNS_CCAP_RPC_SIG_VALUE = 3
    TNS_CCAP_DBF_VERSION_MAX = 1
    TNS_CCAP_LTXID = 0x08
    TNS_CCAP_IMPLICIT_RESULTS = 0x10
    TNS_CCAP_BIG_CHUNK_CLR = 0x20
    TNS_CCAP_KEEP_OUT_ORDER = 0x80
    TNS_CCAP_LOB_UB8_SIZE = 0x01
    TNS_CCAP_LOB_ENCS = 0x02
    TNS_CCAP_LOB_PREFETCH_DATA = 0x04
    TNS_CCAP_LOB_TEMP_SIZE = 0x08
    TNS_CCAP_LOB_PREFETCH_LENGTH = 0x40
    TNS_CCAP_LOB_12C = 0x80
    TNS_CCAP_LOB2_QUASI = 0x01
    TNS_CCAP_LOB2_2GB_PREFETCH = 0x04
    TNS_CCAP_DRCP = 0x10
    TNS_CCAP_ZLNP = 0x04
    TNS_CCAP_INBAND_NOTIFICATION = 0x04
    TNS_CCAP_EXPLICIT_BOUNDARY = 0x40
    TNS_CCAP_END_OF_RESPONSE = 0x20
    TNS_CCAP_CLIENT_FN_MAX = 12
    TNS_CCAP_VECTOR_SUPPORT = 0x08
    TNS_CCAP_TOKEN_SUPPORTED = 0x02
    TNS_CCAP_PIPELINING_SUPPORT = 0x04
    TNS_CCAP_PIPELINING_BREAK = 0x10
    TNS_CCAP_VECTOR_FEATURE_BINARY = 0x01
    TNS_CCAP_VECTOR_FEATURE_SPARSE = 0x02
    TNS_CCAP_TTC5_SESSIONLESS_TXNS = 0x20
    TNS_CCAP_OCI3_OCSSYNC = 0x20

# runtime capability indices
cdef enum:
    TNS_RCAP_COMPAT = 0
    TNS_RCAP_TTC = 6
    TNS_RCAP_MAX = 11

# runtime capability values
cdef enum:
    TNS_RCAP_COMPAT_81 = 2
    TNS_RCAP_TTC_ZERO_COPY = 0x01
    TNS_RCAP_TTC_32K = 0x04
    TNS_RCAP_TTC_SESSION_STATE_OPS = 0x10

# verifier types
cdef enum:
    TNS_VERIFIER_TYPE_11G_1 = 0xb152
    TNS_VERIFIER_TYPE_11G_2 = 0x1b25
    TNS_VERIFIER_TYPE_12C = 0x4815

# UDS flags
cdef enum:
    TNS_UDS_FLAGS_IS_JSON = 0x00000100
    TNS_UDS_FLAGS_IS_OSON = 0x00000800

# end of call status flags
cdef enum:
    TNS_EOCS_FLAGS_TXN_IN_PROGRESS = 0x00000002
    TNS_EOCS_FLAGS_SESS_RELEASE = 0x00008000

# accept flags
cdef enum:
    TNS_ACCEPT_FLAG_CHECK_OOB = 0x00000001
    TNS_ACCEPT_FLAG_FAST_AUTH = 0x10000000
    TNS_ACCEPT_FLAG_HAS_END_OF_RESPONSE = 0x02000000

# transaction switching op codes
cdef enum:
    TNS_TPC_TXN_START = 0x01
    TNS_TPC_TXN_DETACH = 0x02
    TNS_TPC_TXN_POST_DETACH = 0x04

# transaction change state op codes
cdef enum:
    TNS_TPC_TXN_COMMIT = 0x01
    TNS_TPC_TXN_ABORT = 0x02
    TNS_TPC_TXN_PREPARE = 0x03
    TNS_TPC_TXN_FORGET = 0x04

# sessionless server states
cdef enum:
    TNS_TPC_TXNID_SYNC_SET = 0x40
    TNS_TPC_TXNID_SYNC_UNSET = 0x80

# sessionless state reason
cdef enum:
    TNS_TPC_TXNID_SYNC_SERVER = 0x01
    TNS_TPC_TXNID_SYNC_CLIENT = 0x02

# transaction states
cdef enum:
    TNS_TPC_TXN_STATE_PREPARE = 0
    TNS_TPC_TXN_STATE_REQUIRES_COMMIT = 1
    TNS_TPC_TXN_STATE_COMMITTED = 2
    TNS_TPC_TXN_STATE_ABORTED = 3
    TNS_TPC_TXN_STATE_READ_ONLY = 4
    TNS_TPC_TXN_STATE_FORGOTTEN = 5

# pipeline modes
cdef enum:
    TNS_PIPELINE_MODE_CONTINUE_ON_ERROR = 1
    TNS_PIPELINE_MODE_ABORT_ON_ERROR = 2

# AQ extension keywords
cdef enum:
    TNS_AQ_EXT_KEYWORD_AGENT_NAME = 64
    TNS_AQ_EXT_KEYWORD_AGENT_ADDRESS = 65
    TNS_AQ_EXT_KEYWORD_AGENT_PROTOCOL = 66
    TNS_AQ_EXT_KEYWORD_ORIGINAL_MSGID = 69

# session state flags
cdef enum:
    TNS_SESSION_STATE_REQUEST_BEGIN = 0x04
    TNS_SESSION_STATE_REQUEST_END = 0x08
    TNS_SESSION_STATE_EXPLICIT_BOUNDARY = 0x40

# direct path constants
cdef enum:
    TNS_DP_INTERFACE_VERSION = 400
    TNS_DP_STREAM_VERSION = 400

# direct path op codes
cdef enum:
    TNS_DPP_OP_CODE_LOAD = 1
    TNS_DPP_OP_CODE_UNLOAD = 2
    TNS_DPP_OP_CODE_CONVERT = 3

# direct path prepare input indexes
cdef enum:
    TNS_DPP_IN_INDEX_INTERFACE_VERSION = 0
    TNS_DPP_IN_INDEX_STREAM_VERSION = 1
    TNS_DPP_IN_INDEX_LOCK_WAIT = 14
    TNS_DPP_IN_MAX_PARAMS = 36

# direct path prepare keyword indexes
cdef enum:
    TNS_DPP_KW_INDEX_OBJECT_NAME = 1
    TNS_DPP_KW_INDEX_SUBOBJECT_NAME = 2
    TNS_DPP_KW_INDEX_SCHEMA_NAME = 3
    TNS_DPP_KW_INDEX_COLUMN_NAME = 4
    TNS_DPP_KW_INDEX_VARRAY_TABLE = 15
    TNS_DPP_KW_INDEX_NFOBJ_OID_POS = 11
    TNS_DPP_KW_INDEX_NFOBJ_SID_POS = 16
    TNS_DPP_KW_INDEX_NFOBJ_VARRAY_INDEX = 17

# direct path prepare output indexes
cdef enum:
    TNS_DPP_OUT_INDEX_CURSOR = 3
    TNS_DPP_OUT_MAX_PARAMS = 14

# direct path row header flags
cdef enum:
    TNS_DPLS_ROW_HEADER_FAST_PIECE = 0x10
    TNS_DPLS_ROW_HEADER_FAST_ROW = 0x20
    TNS_DPLS_ROW_HEADER_FIRST = 0x08
    TNS_DPLS_ROW_HEADER_LAST = 0x04
    TNS_DPLS_ROW_HEADER_SPLIT_WITH_PREV = 0x02
    TNS_DPLS_ROW_HEADER_SPLIT_WITH_NEXT = 0x01

# other direct path load stream constants
cdef enum:
    TNS_DPLS_MAX_MESSAGE_SIZE = 1_073_728_895
    TNS_DPLS_MAX_SHORT_LENGTH = 0xfa
    TNS_DPLS_MAX_PIECE_SIZE = 0xfff0
    TNS_DPLS_FAST_HEADER_SIZE = 4
    TNS_DPLS_SLOW_HEADER_SIZE = 2

# direct path operation codes
cdef enum:
    TNS_DP_OP_ABORT = 1
    TNS_DP_OP_FINISH = 2

# other constants
cdef enum:
    TNS_ESCAPE_CHAR = 253
    TNS_MAX_ROWID_LENGTH = 18
    TNS_DURATION_SESSION = 10
    TNS_MAX_LONG_LENGTH = 0x7fffffff
    TNS_MAX_CONNECT_DATA = 230
    TNS_MAX_UROWID_LENGTH = 5267
    TNS_SERVER_CONVERTS_CHARS = 0x01
    TNS_JSON_MAX_LENGTH = 32 * 1024 * 1024
    TNS_VECTOR_MAX_LENGTH = 1 * 1024 * 1024
    TNS_AQ_MESSAGE_ID_LENGTH = 16
    TNS_AQ_MESSAGE_VERSION = 1

# base 64 encoding alphabet
cdef bytes TNS_BASE64_ALPHABET = \
        b'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
cdef bytearray TNS_BASE64_ALPHABET_ARRAY = \
        bytearray(TNS_BASE64_ALPHABET)
cdef bytes TNS_EXTENT_OID = bytes.fromhex('00000000000000000000000000010001')

# drcp release mode
cdef enum:
    DRCP_DEAUTHENTICATE = 0x00000002
