# Ulysses, by James Joyce

## — I —
### [ 1 ]

Stately, plump Buck Mulligan came from the stairhead, bearing a bowl of lather on which a mirror and a razor lay crossed. A yellow dressinggown, ungirdled, was sustained gently behind him on the mild morning air. He held the bowl aloft and intoned:

—Introibo ad altare Dei.

Halted, he peered down the dark winding stairs and called out coarsely:

—Come up, Kinch! Come up, you fearful jesuit!

Solemnly he came forward and mounted the round gunrest. He faced about and blessed gravely thrice the tower, the surrounding land and the awaking mountains. Then, catching sight of Stephen Dedalus, he bent towards him and made rapid crosses in the air, gurgling in his throat and shaking his head. Stephen Dedalus, displeased and sleepy, leaned his arms on the top of the staircase and looked coldly at the shaking gurgling face that blessed him, equine in its length, and at the light untonsured hair, grained and hued like pale oak.

Buck Mulligan peeped an instant under the mirror and then covered the bowl smartly.

—Back to barracks! he said sternly.

He added in a preacher’s tone:

—For this, O dearly beloved, is the genuine Christine: body and soul and blood and ouns. Slow music, please. Shut your eyes, gents. One moment. A little trouble about those white corpuscles. Silence, all.

He peered sideways up and gave a long slow whistle of call, then paused awhile in rapt attention, his even white teeth glistening here and there with gold points. Chrysostomos. Two strong shrill whistles answered through the calm.

—Thanks, old chap, he cried briskly. That will do nicely. Switch off the current, will you?

He skipped off the gunrest and looked gravely at his watcher, gathering about his legs the loose folds of his gown. The plump shadowed face and sullen oval jowl recalled a prelate, patron of arts in the middle ages. A pleasant smile broke quietly over his lips.

—The mockery of it! he said gaily. Your absurd name, an ancient Greek!

He pointed his finger in friendly jest and went over to the parapet, laughing to himself. Stephen Dedalus stepped up, followed him wearily halfway and sat down on the edge of the gunrest, watching him still as he propped his mirror on the parapet, dipped the brush in the bowl and lathered cheeks and neck.

Buck Mulligan’s gay voice went on.

—My name is absurd too: Malachi Mulligan, two dactyls. But it has a Hellenic ring, hasn’t it? Tripping and sunny like the buck himself. We must go to Athens. Will you come if I can get the aunt to fork out twenty quid?

He laid the brush aside and, laughing with delight, cried:

—Will he come? The jejune jesuit!

Ceasing, he began to shave with care.

—Tell me, Mulligan, Stephen said quietly.

—Yes, my love?

—How long is Haines going to stay in this tower?

Buck Mulligan showed a shaven cheek over his right shoulder.

—God, isn’t he dreadful? he said frankly. A ponderous Saxon. He thinks you’re not a gentleman. God, these bloody English! Bursting with money and indigestion. Because he comes from Oxford. You know, Dedalus, you have the real Oxford manner. He can’t make you out. O, my name for you is the best: Kinch, the knife-blade.

He shaved warily over his chin.

—He was raving all night about a black panther, Stephen said. Where is his guncase?

—A woful lunatic! Mulligan said. Were you in a funk?

—I was, Stephen said with energy and growing fear. Out here in the dark with a man I don’t know raving and moaning to himself about shooting a black panther. You saved men from drowning. I’m not a hero, however. If he stays on here I am off.

Buck Mulligan frowned at the lather on his razorblade. He hopped down from his perch and began to search his trouser pockets hastily.

—Scutter! he cried thickly.

He came over to the gunrest and, thrusting a hand into Stephen’s upper pocket, said:

—Lend us a loan of your noserag to wipe my razor.

Stephen suffered him to pull out and hold up on show by its corner a dirty crumpled handkerchief. Buck Mulligan wiped the razorblade neatly. Then, gazing over the handkerchief, he said:

—The bard’s noserag! A new art colour for our Irish poets: snotgreen. You can almost taste it, can’t you?

He mounted to the parapet again and gazed out over Dublin bay, his fair oakpale hair stirring slightly.

—God! he said quietly. Isn’t the sea what Algy calls it: a great sweet mother? The snotgreen sea. The scrotumtightening sea. Epi oinopa ponton. Ah, Dedalus, the Greeks! I must teach you. You must read them in the original. Thalatta! Thalatta! She is our great sweet mother. Come and look.

Stephen stood up and went over to the parapet. Leaning on it he looked down on the water and on the mailboat clearing the harbourmouth of Kingstown.

—Our mighty mother! Buck Mulligan said.

He turned abruptly his grey searching eyes from the sea to Stephen’s face.

—The aunt thinks you killed your mother, he said. That’s why she won’t let me have anything to do with you.

—Someone killed her, Stephen said gloomily.

—You could have knelt down, damn it, Kinch, when your dying mother asked you, Buck Mulligan said. I’m hyperborean as much as you. But to think of your mother begging you with her last breath to kneel down and pray for her. And you refused. There is something sinister in you....

He broke off and lathered again lightly his farther cheek. A tolerant smile curled his lips.

—But a lovely mummer! he murmured to himself. Kinch, the loveliest mummer of them all!

He shaved evenly and with care, in silence, seriously.

Stephen, an elbow rested on the jagged granite, leaned his palm against his brow and gazed at the fraying edge of his shiny black coat-sleeve. Pain, that was not yet the pain of love, fretted his heart. Silently, in a dream she had come to him after her death, her wasted body within its loose brown graveclothes giving off an odour of wax and rosewood, her breath, that had bent upon him, mute, reproachful, a faint odour of wetted ashes. Across the threadbare cuffedge he saw the sea hailed as a great sweet mother by the wellfed voice beside him. The ring of bay and skyline held a dull green mass of liquid. A bowl of white china had stood beside her deathbed holding the green sluggish bile which she had torn up from her rotting liver by fits of loud groaning vomiting.

Buck Mulligan wiped again his razorblade.

—Ah, poor dogsbody! he said in a kind voice. I must give you a shirt and a few noserags. How are the secondhand breeks?

—They fit well enough, Stephen answered.

Buck Mulligan attacked the hollow beneath his underlip.

—The mockery of it, he said contentedly. Secondleg they should be. God knows what poxy bowsy left them off. I have a lovely pair with a hair stripe, grey. You’ll look spiffing in them. I’m not joking, Kinch. You look damn well when you’re dressed.

—Thanks, Stephen said. I can’t wear them if they are grey.

—He can’t wear them, Buck Mulligan told his face in the mirror. Etiquette is etiquette. He kills his mother but he can’t wear grey trousers.

He folded his razor neatly and with stroking palps of fingers felt the smooth skin.

Stephen turned his gaze from the sea and to the plump face with its smokeblue mobile eyes.

—That fellow I was with in the Ship last night, said Buck Mulligan, says you have g. p. i. He’s up in Dottyville with Connolly Norman. General paralysis of the insane!

He swept the mirror a half circle in the air to flash the tidings abroad in sunlight now radiant on the sea. His curling shaven lips laughed and the edges of his white glittering teeth. Laughter seized all his strong wellknit trunk.

—Look at yourself, he said, you dreadful bard!

Stephen bent forward and peered at the mirror held out to him, cleft by a crooked crack. Hair on end. As he and others see me. Who chose this face for me? This dogsbody to rid of vermin. It asks me too.

—I pinched it out of the skivvy’s room, Buck Mulligan said. It does her all right. The aunt always keeps plainlooking servants for Malachi. Lead him not into temptation. And her name is Ursula.

Laughing again, he brought the mirror away from Stephen’s peering eyes.

—The rage of Caliban at not seeing his face in a mirror, he said. If Wilde were only alive to see you!

Drawing back and pointing, Stephen said with bitterness:

—It is a symbol of Irish art. The cracked lookingglass of a servant.

Buck Mulligan suddenly linked his arm in Stephen’s and walked with him round the tower, his razor and mirror clacking in the pocket where he had thrust them.

—It’s not fair to tease you like that, Kinch, is it? he said kindly. God knows you have more spirit than any of them.

Parried again. He fears the lancet of my art as I fear that of his. The cold steel pen.

—Cracked lookingglass of a servant! Tell that to the oxy chap downstairs and touch him for a guinea. He’s stinking with money and thinks you’re not a gentleman. His old fellow made his tin by selling jalap to Zulus or some bloody swindle or other. God, Kinch, if you and I could only work together we might do something for the island. Hellenise it.

Cranly’s arm. His arm.

—And to think of your having to beg from these swine. I’m the only one that knows what you are. Why don’t you trust me more? What have you up your nose against me? Is it Haines? If he makes any noise here I’ll bring down Seymour and we’ll give him a ragging worse than they gave Clive Kempthorpe.

Young shouts of moneyed voices in Clive Kempthorpe’s rooms. Palefaces: they hold their ribs with laughter, one clasping another. O, I shall expire! Break the news to her gently, Aubrey! I shall die! With slit ribbons of his shirt whipping the air he hops and hobbles round the table, with trousers down at heels, chased by Ades of Magdalen with the tailor’s shears. A scared calf’s face gilded with marmalade. I don’t want to be debagged! Don’t you play the giddy ox with me!

Shouts from the open window startling evening in the quadrangle. A deaf gardener, aproned, masked with Matthew Arnold’s face, pushes his mower on the sombre lawn watching narrowly the dancing motes of grasshalms.

To ourselves... new paganism... omphalos.

—Let him stay, Stephen said. There’s nothing wrong with him except at night.

—Then what is it? Buck Mulligan asked impatiently. Cough it up. I’m quite frank with you. What have you against me now?

They halted, looking towards the blunt cape of Bray Head that lay on the water like the snout of a sleeping whale. Stephen freed his arm quietly.

—Do you wish me to tell you? he asked.

—Yes, what is it? Buck Mulligan answered. I don’t remember anything.

He looked in Stephen’s face as he spoke. A light wind passed his brow, fanning softly his fair uncombed hair and stirring silver points of anxiety in his eyes.

Stephen, depressed by his own voice, said:

—Do you remember the first day I went to your house after my mother’s death?

Buck Mulligan frowned quickly and said:

—What? Where? I can’t remember anything. I remember only ideas and sensations. Why? What happened in the name of God?

—You were making tea, Stephen said, and went across the landing to get more hot water. Your mother and some visitor came out of the drawingroom. She asked you who was in your room.

—Yes? Buck Mulligan said. What did I say? I forget.

—You said, Stephen answered, O, it’s only Dedalus whose mother is beastly dead.

A flush which made him seem younger and more engaging rose to Buck Mulligan’s cheek.

—Did I say that? he asked. Well? What harm is that?

He shook his constraint from him nervously.

—And what is death, he asked, your mother’s or yours or my own? You saw only your mother die. I see them pop off every day in the Mater and Richmond and cut up into tripes in the dissectingroom. It’s a beastly thing and nothing else. It simply doesn’t matter. You wouldn’t kneel down to pray for your mother on her deathbed when she asked you. Why? Because you have the cursed jesuit strain in you, only it’s injected the wrong way. To me it’s all a mockery and beastly. Her cerebral lobes are not functioning. She calls the doctor sir Peter Teazle and picks buttercups off the quilt. Humour her till it’s over. You crossed her last wish in death and yet you sulk with me because I don’t whinge like some hired mute from Lalouette’s. Absurd! I suppose I did say it. I didn’t mean to offend the memory of your mother.

He had spoken himself into boldness. Stephen, shielding the gaping wounds which the words had left in his heart, said very coldly:

—I am not thinking of the offence to my mother.

—Of what then? Buck Mulligan asked.

—Of the offence to me, Stephen answered.

Buck Mulligan swung round on his heel.

—O, an impossible person! he exclaimed.

He walked off quickly round the parapet. Stephen stood at his post, gazing over the calm sea towards the headland. Sea and headland now grew dim. Pulses were beating in his eyes, veiling their sight, and he felt the fever of his cheeks.

A voice within the tower called loudly:

—Are you up there, Mulligan?

—I’m coming, Buck Mulligan answered.

He turned towards Stephen and said:

—Look at the sea. What does it care about offences? Chuck Loyola, Kinch, and come on down. The Sassenach wants his morning rashers.

His head halted again for a moment at the top of the staircase, level with the roof:

—Don’t mope over it all day, he said. I’m inconsequent. Give up the moody brooding.

His head vanished but the drone of his descending voice boomed out of the stairhead:

And no more turn aside and brood
Upon love’s bitter mystery
For Fergus rules the brazen cars.

Woodshadows floated silently by through the morning peace from the stairhead seaward where he gazed. Inshore and farther out the mirror of water whitened, spurned by lightshod hurrying feet. White breast of the dim sea. The twining stresses, two by two. A hand plucking the harpstrings, merging their twining chords. Wavewhite wedded words shimmering on the dim tide.

A cloud began to cover the sun slowly, wholly, shadowing the bay in deeper green. It lay beneath him, a bowl of bitter waters. Fergus’ song: I sang it alone in the house, holding down the long dark chords. Her door was open: she wanted to hear my music. Silent with awe and pity I went to her bedside. She was crying in her wretched bed. For those words, Stephen: love’s bitter mystery.

Where now?

Her secrets: old featherfans, tasselled dancecards, powdered with musk, a gaud of amber beads in her locked drawer. A birdcage hung in the sunny window of her house when she was a girl. She heard old Royce sing in the pantomime of Turko the Terrible and laughed with others when he sang:

I am the boy
That can enjoy
Invisibility.

Phantasmal mirth, folded away: muskperfumed.

And no more turn aside and brood.

Folded away in the memory of nature with her toys. Memories beset his brooding brain. Her glass of water from the kitchen tap when she had approached the sacrament. A cored apple, filled with brown sugar, roasting for her at the hob on a dark autumn evening. Her shapely fingernails reddened by the blood of squashed lice from the children’s shirts.

In a dream, silently, she had come to him, her wasted body within its loose graveclothes giving off an odour of wax and rosewood, her breath, bent over him with mute secret words, a faint odour of wetted ashes.

Her glazing eyes, staring out of death, to shake and bend my soul. On me alone. The ghostcandle to light her agony. Ghostly light on the tortured face. Her hoarse loud breath rattling in horror, while all prayed on their knees. Her eyes on me to strike me down. Liliata rutilantium te confessorum turma circumdet: iubilantium te virginum chorus excipiat.

Ghoul! Chewer of corpses!

No, mother! Let me be and let me live.

—Kinch ahoy!

Buck Mulligan’s voice sang from within the tower. It came nearer up the staircase, calling again. Stephen, still trembling at his soul’s cry, heard warm running sunlight and in the air behind him friendly words.

—Dedalus, come down, like a good mosey. Breakfast is ready. Haines is apologising for waking us last night. It’s all right.

—I’m coming, Stephen said, turning.

—Do, for Jesus’ sake, Buck Mulligan said. For my sake and for all our sakes.

His head disappeared and reappeared.

—I told him your symbol of Irish art. He says it’s very clever. Touch him for a quid, will you? A guinea, I mean.

—I get paid this morning, Stephen said.

—The school kip? Buck Mulligan said. How much? Four quid? Lend us one.

—If you want it, Stephen said.

—Four shining sovereigns, Buck Mulligan cried with delight. We’ll have a glorious drunk to astonish the druidy druids. Four omnipotent sovereigns.

He flung up his hands and tramped down the stone stairs, singing out of tune with a Cockney accent:

O, won’t we have a merry time,
Drinking whisky, beer and wine!
On coronation,
Coronation day!
O, won’t we have a merry time
On coronation day!

Warm sunshine merrying over the sea. The nickel shavingbowl shone, forgotten, on the parapet. Why should I bring it down? Or leave it there all day, forgotten friendship?

He went over to it, held it in his hands awhile, feeling its coolness, smelling the clammy slaver of the lather in which the brush was stuck. So I carried the boat of incense then at Clongowes. I am another now and yet the same. A servant too. A server of a servant.

In the gloomy domed livingroom of the tower Buck Mulligan’s gowned form moved briskly to and fro about the hearth, hiding and revealing its yellow glow. Two shafts of soft daylight fell across the flagged floor from the high barbacans: and at the meeting of their rays a cloud of coalsmoke and fumes of fried grease floated, turning.

—We’ll be choked, Buck Mulligan said. Haines, open that door, will you?

Stephen laid the shavingbowl on the locker. A tall figure rose from the hammock where it had been sitting, went to the doorway and pulled open the inner doors.

—Have you the key? a voice asked.

—Dedalus has it, Buck Mulligan said. Janey Mack, I’m choked!

He howled, without looking up from the fire:

—Kinch!

—It’s in the lock, Stephen said, coming forward.

The key scraped round harshly twice and, when the heavy door had been set ajar, welcome light and bright air entered. Haines stood at the doorway, looking out. Stephen haled his upended valise to the table and sat down to wait. Buck Mulligan tossed the fry on to the dish beside him. Then he carried the dish and a large teapot over to the table, set them down heavily and sighed with relief.

—I’m melting, he said, as the candle remarked when... But, hush! Not a word more on that subject! Kinch, wake up! Bread, butter, honey. Haines, come in. The grub is ready. Bless us, O Lord, and these thy gifts. Where’s the sugar? O, jay, there’s no milk.

Stephen fetched the loaf and the pot of honey and the buttercooler from the locker. Buck Mulligan sat down in a sudden pet.

—What sort of a kip is this? he said. I told her to come after eight.

—We can drink it black, Stephen said thirstily. There’s a lemon in the locker.

—O, damn you and your Paris fads! Buck Mulligan said. I want Sandycove milk.

Haines came in from the doorway and said quietly:

—That woman is coming up with the milk.

—The blessings of God on you! Buck Mulligan cried, jumping up from his chair. Sit down. Pour out the tea there. The sugar is in the bag. Here, I can’t go fumbling at the damned eggs.

He hacked through the fry on the dish and slapped it out on three plates, saying:

—In nomine Patris et Filii et Spiritus Sancti.

Haines sat down to pour out the tea.

—I’m giving you two lumps each, he said. But, I say, Mulligan, you do make strong tea, don’t you?

Buck Mulligan, hewing thick slices from the loaf, said in an old woman’s wheedling voice:

—When I makes tea I makes tea, as old mother Grogan said. And when I makes water I makes water.

—By Jove, it is tea, Haines said.

Buck Mulligan went on hewing and wheedling:

—So I do, Mrs Cahill, says she. Begob, ma’am, says Mrs Cahill, God send you don’t make them in the one pot.

He lunged towards his messmates in turn a thick slice of bread, impaled on his knife.

—That’s folk, he said very earnestly, for your book, Haines. Five lines of text and ten pages of notes about the folk and the fishgods of Dundrum. Printed by the weird sisters in the year of the big wind.

He turned to Stephen and asked in a fine puzzled voice, lifting his brows:

—Can you recall, brother, is mother Grogan’s tea and water pot spoken of in the Mabinogion or is it in the Upanishads?

—I doubt it, said Stephen gravely.

—Do you now? Buck Mulligan said in the same tone. Your reasons, pray?

—I fancy, Stephen said as he ate, it did not exist in or out of the Mabinogion. Mother Grogan was, one imagines, a kinswoman of Mary Ann.

Buck Mulligan’s face smiled with delight.

—Charming! he said in a finical sweet voice, showing his white teeth and blinking his eyes pleasantly. Do you think she was? Quite charming!

Then, suddenly overclouding all his features, he growled in a hoarsened rasping voice as he hewed again vigorously at the loaf:

—For old Mary Ann
She doesn’t care a damn.
But, hising up her petticoats...

He crammed his mouth with fry and munched and droned.

The doorway was darkened by an entering form.

—The milk, sir!

—Come in, ma’am, Mulligan said. Kinch, get the jug.

An old woman came forward and stood by Stephen’s elbow.

—That’s a lovely morning, sir, she said. Glory be to God.

—To whom? Mulligan said, glancing at her. Ah, to be sure!

Stephen reached back and took the milkjug from the locker.

—The islanders, Mulligan said to Haines casually, speak frequently of the collector of prepuces.

—How much, sir? asked the old woman.

—A quart, Stephen said.

He watched her pour into the measure and thence into the jug rich white milk, not hers. Old shrunken paps. She poured again a measureful and a tilly. Old and secret she had entered from a morning world, maybe a messenger. She praised the goodness of the milk, pouring it out. Crouching by a patient cow at daybreak in the lush field, a witch on her toadstool, her wrinkled fingers quick at the squirting dugs. They lowed about her whom they knew, dewsilky cattle. Silk of the kine and poor old woman, names given her in old times. A wandering crone, lowly form of an immortal serving her conqueror and her gay betrayer, their common cuckquean, a messenger from the secret morning. To serve or to upbraid, whether he could not tell: but scorned to beg her favour.

—It is indeed, ma’am, Buck Mulligan said, pouring milk into their cups.

—Taste it, sir, she said.

He drank at her bidding.

—If we could live on good food like that, he said to her somewhat loudly, we wouldn’t have the country full of rotten teeth and rotten guts. Living in a bogswamp, eating cheap food and the streets paved with dust, horsedung and consumptives’ spits.

—Are you a medical student, sir? the old woman asked.

—I am, ma’am, Buck Mulligan answered.

—Look at that now, she said.

Stephen listened in scornful silence. She bows her old head to a voice that speaks to her loudly, her bonesetter, her medicineman: me she slights. To the voice that will shrive and oil for the grave all there is of her but her woman’s unclean loins, of man’s flesh made not in God’s likeness, the serpent’s prey. And to the loud voice that now bids her be silent with wondering unsteady eyes.

—Do you understand what he says? Stephen asked her.

—Is it French you are talking, sir? the old woman said to Haines.

Haines spoke to her again a longer speech, confidently.

—Irish, Buck Mulligan said. Is there Gaelic on you?

—I thought it was Irish, she said, by the sound of it. Are you from the west, sir?

—I am an Englishman, Haines answered.

—He’s English, Buck Mulligan said, and he thinks we ought to speak Irish in Ireland.

—Sure we ought to, the old woman said, and I’m ashamed I don’t speak the language myself. I’m told it’s a grand language by them that knows.

—Grand is no name for it, said Buck Mulligan. Wonderful entirely. Fill us out some more tea, Kinch. Would you like a cup, ma’am?

—No, thank you, sir, the old woman said, slipping the ring of the milkcan on her forearm and about to go.

Haines said to her:

—Have you your bill? We had better pay her, Mulligan, hadn’t we?

Stephen filled again the three cups.

—Bill, sir? she said, halting. Well, it’s seven mornings a pint at twopence is seven twos is a shilling and twopence over and these three mornings a quart at fourpence is three quarts is a shilling. That’s a shilling and one and two is two and two, sir.

Buck Mulligan sighed and, having filled his mouth with a crust thickly buttered on both sides, stretched forth his legs and began to search his trouser pockets.

—Pay up and look pleasant, Haines said to him, smiling.

Stephen filled a third cup, a spoonful of tea colouring faintly the thick rich milk. Buck Mulligan brought up a florin, twisted it round in his fingers and cried:

—A miracle!

He passed it along the table towards the old woman, saying:

—Ask nothing more of me, sweet. All I can give you I give.

Stephen laid the coin in her uneager hand.

—We’ll owe twopence, he said.

—Time enough, sir, she said, taking the coin. Time enough. Good morning, sir.

She curtseyed and went out, followed by Buck Mulligan’s tender chant:

—Heart of my heart, were it more,
More would be laid at your feet.

He turned to Stephen and said:

—Seriously, Dedalus. I’m stony. Hurry out to your school kip and bring us back some money. Today the bards must drink and junket. Ireland expects that every man this day will do his duty.

—That reminds me, Haines said, rising, that I have to visit your national library today.

—Our swim first, Buck Mulligan said.

He turned to Stephen and asked blandly:

—Is this the day for your monthly wash, Kinch?

Then he said to Haines:

—The unclean bard makes a point of washing once a month.

—All Ireland is washed by the gulfstream, Stephen said as he let honey trickle over a slice of the loaf.

Haines from the corner where he was knotting easily a scarf about the loose collar of his tennis shirt spoke:

—I intend to make a collection of your sayings if you will let me.

Speaking to me. They wash and tub and scrub. Agenbite of inwit. Conscience. Yet here’s a spot.

—That one about the cracked lookingglass of a servant being the symbol of Irish art is deuced good.

Buck Mulligan kicked Stephen’s foot under the table and said with warmth of tone:

—Wait till you hear him on Hamlet, Haines.

—Well, I mean it, Haines said, still speaking to Stephen. I was just thinking of it when that poor old creature came in.

—Would I make any money by it? Stephen asked.

Haines laughed and, as he took his soft grey hat from the holdfast of the hammock, said:

—I don’t know, I’m sure.

He strolled out to the doorway. Buck Mulligan bent across to Stephen and said with coarse vigour:

—You put your hoof in it now. What did you say that for?

—Well? Stephen said. The problem is to get money. From whom? From the milkwoman or from him. It’s a toss up, I think.

—I blow him out about you, Buck Mulligan said, and then you come along with your lousy leer and your gloomy jesuit jibes.

—I see little hope, Stephen said, from her or from him.

Buck Mulligan sighed tragically and laid his hand on Stephen’s arm.

—From me, Kinch, he said.

In a suddenly changed tone he added:

—To tell you the God’s truth I think you’re right. Damn all else they are good for. Why don’t you play them as I do? To hell with them all. Let us get out of the kip.

He stood up, gravely ungirdled and disrobed himself of his gown, saying resignedly:

—Mulligan is stripped of his garments.

He emptied his pockets on to the table.

—There’s your snotrag, he said.

And putting on his stiff collar and rebellious tie he spoke to them, chiding them, and to his dangling watchchain. His hands plunged and rummaged in his trunk while he called for a clean handkerchief. God, we’ll simply have to dress the character. I want puce gloves and green boots. Contradiction. Do I contradict myself? Very well then, I contradict myself. Mercurial Malachi. A limp black missile flew out of his talking hands.

—And there’s your Latin quarter hat, he said.

Stephen picked it up and put it on. Haines called to them from the doorway:

—Are you coming, you fellows?

—I’m ready, Buck Mulligan answered, going towards the door. Come out, Kinch. You have eaten all we left, I suppose. Resigned he passed out with grave words and gait, saying, wellnigh with sorrow:

—And going forth he met Butterly.

Stephen, taking his ashplant from its leaningplace, followed them out and, as they went down the ladder, pulled to the slow iron door and locked it. He put the huge key in his inner pocket.

At the foot of the ladder Buck Mulligan asked:

—Did you bring the key?

—I have it, Stephen said, preceding them.

He walked on. Behind him he heard Buck Mulligan club with his heavy bathtowel the leader shoots of ferns or grasses.

—Down, sir! How dare you, sir!

Haines asked:

—Do you pay rent for this tower?

—Twelve quid, Buck Mulligan said.

—To the secretary of state for war, Stephen added over his shoulder.

They halted while Haines surveyed the tower and said at last:

—Rather bleak in wintertime, I should say. Martello you call it?

—Billy Pitt had them built, Buck Mulligan said, when the French were on the sea. But ours is the omphalos.

—What is your idea of Hamlet? Haines asked Stephen.

—No, no, Buck Mulligan shouted in pain. I’m not equal to Thomas Aquinas and the fiftyfive reasons he has made out to prop it up. Wait till I have a few pints in me first.

He turned to Stephen, saying, as he pulled down neatly the peaks of his primrose waistcoat:

—You couldn’t manage it under three pints, Kinch, could you?

—It has waited so long, Stephen said listlessly, it can wait longer.

—You pique my curiosity, Haines said amiably. Is it some paradox?

—Pooh! Buck Mulligan said. We have grown out of Wilde and paradoxes. It’s quite simple. He proves by algebra that Hamlet’s grandson is Shakespeare’s grandfather and that he himself is the ghost of his own father.

—What? Haines said, beginning to point at Stephen. He himself?

Buck Mulligan slung his towel stolewise round his neck and, bending in loose laughter, said to Stephen’s ear:

—O, shade of Kinch the elder! Japhet in search of a father!

—We’re always tired in the morning, Stephen said to Haines. And it is rather long to tell.

Buck Mulligan, walking forward again, raised his hands.

—The sacred pint alone can unbind the tongue of Dedalus, he said.

—I mean to say, Haines explained to Stephen as they followed, this tower and these cliffs here remind me somehow of Elsinore. That beetles o’er his base into the sea, isn’t it?

Buck Mulligan turned suddenly for an instant towards Stephen but did not speak. In the bright silent instant Stephen saw his own image in cheap dusty mourning between their gay attires.

—It’s a wonderful tale, Haines said, bringing them to halt again.

Eyes, pale as the sea the wind had freshened, paler, firm and prudent. The seas’ ruler, he gazed southward over the bay, empty save for the smokeplume of the mailboat vague on the bright skyline and a sail tacking by the Muglins.

—I read a theological interpretation of it somewhere, he said bemused. The Father and the Son idea. The Son striving to be atoned with the Father.

Buck Mulligan at once put on a blithe broadly smiling face. He looked at them, his wellshaped mouth open happily, his eyes, from which he had suddenly withdrawn all shrewd sense, blinking with mad gaiety. He moved a doll’s head to and fro, the brims of his Panama hat quivering, and began to chant in a quiet happy foolish voice:

—I’m the queerest young fellow that ever you heard.
My mother’s a jew, my father’s a bird.
With Joseph the joiner I cannot agree.
So here’s to disciples and Calvary.

He held up a forefinger of warning.

—If anyone thinks that I amn’t divine
He’ll get no free drinks when I’m making the wine
But have to drink water and wish it were plain
That I make when the wine becomes water again.

He tugged swiftly at Stephen’s ashplant in farewell and, running forward to a brow of the cliff, fluttered his hands at his sides like fins or wings of one about to rise in the air, and chanted:

—Goodbye, now, goodbye! Write down all I said
And tell Tom, Dick and Harry I rose from the dead.
What’s bred in the bone cannot fail me to fly
And Olivet’s breezy... Goodbye, now, goodbye!

He capered before them down towards the fortyfoot hole, fluttering his winglike hands, leaping nimbly, Mercury’s hat quivering in the fresh wind that bore back to them his brief birdsweet cries.

Haines, who had been laughing guardedly, walked on beside Stephen and said:

—We oughtn’t to laugh, I suppose. He’s rather blasphemous. I’m not a believer myself, that is to say. Still his gaiety takes the harm out of it somehow, doesn’t it? What did he call it? Joseph the Joiner?

—The ballad of joking Jesus, Stephen answered.

—O, Haines said, you have heard it before?

—Three times a day, after meals, Stephen said drily.

—You’re not a believer, are you? Haines asked. I mean, a believer in the narrow sense of the word. Creation from nothing and miracles and a personal God.

—There’s only one sense of the word, it seems to me, Stephen said.

Haines stopped to take out a smooth silver case in which twinkled a green stone. He sprang it open with his thumb and offered it.

—Thank you, Stephen said, taking a cigarette.

Haines helped himself and snapped the case to. He put it back in his sidepocket and took from his waistcoatpocket a nickel tinderbox, sprang it open too, and, having lit his cigarette, held the flaming spunk towards Stephen in the shell of his hands.

—Yes, of course, he said, as they went on again. Either you believe or you don’t, isn’t it? Personally I couldn’t stomach that idea of a personal God. You don’t stand for that, I suppose?

—You behold in me, Stephen said with grim displeasure, a horrible example of free thought.

He walked on, waiting to be spoken to, trailing his ashplant by his side. Its ferrule followed lightly on the path, squealing at his heels. My familiar, after me, calling, Steeeeeeeeeeeephen! A wavering line along the path. They will walk on it tonight, coming here in the dark. He wants that key. It is mine. I paid the rent. Now I eat his salt bread. Give him the key too. All. He will ask for it. That was in his eyes.

—After all, Haines began...

Stephen turned and saw that the cold gaze which had measured him was not all unkind.

—After all, I should think you are able to free yourself. You are your own master, it seems to me.

—I am a servant of two masters, Stephen said, an English and an Italian.

—Italian? Haines said.

A crazy queen, old and jealous. Kneel down before me.

—And a third, Stephen said, there is who wants me for odd jobs.

—Italian? Haines said again. What do you mean?

—The imperial British state, Stephen answered, his colour rising, and the holy Roman catholic and apostolic church.

Haines detached from his underlip some fibres of tobacco before he spoke.

—I can quite understand that, he said calmly. An Irishman must think like that, I daresay. We feel in England that we have treated you rather unfairly. It seems history is to blame.

The proud potent titles clanged over Stephen’s memory the triumph of their brazen bells: et unam sanctam catholicam et apostolicam ecclesiam: the slow growth and change of rite and dogma like his own rare thoughts, a chemistry of stars. Symbol of the apostles in the mass for pope Marcellus, the voices blended, singing alone loud in affirmation: and behind their chant the vigilant angel of the church militant disarmed and menaced her heresiarchs. A horde of heresies fleeing with mitres awry: Photius and the brood of mockers of whom Mulligan was one, and Arius, warring his life long upon the consubstantiality of the Son with the Father, and Valentine, spurning Christ’s terrene body, and the subtle African heresiarch Sabellius who held that the Father was Himself His own Son. Words Mulligan had spoken a moment since in mockery to the stranger. Idle mockery. The void awaits surely all them that weave the wind: a menace, a disarming and a worsting from those embattled angels of the church, Michael’s host, who defend her ever in the hour of conflict with their lances and their shields.

Hear, hear! Prolonged applause. Zut! Nom de Dieu!

—Of course I’m a Britisher, Haines’s voice said, and I feel as one. I don’t want to see my country fall into the hands of German jews either. That’s our national problem, I’m afraid, just now.

Two men stood at the verge of the cliff, watching: businessman, boatman.

—She’s making for Bullock harbour.

The boatman nodded towards the north of the bay with some disdain.

—There’s five fathoms out there, he said. It’ll be swept up that way when the tide comes in about one. It’s nine days today.

The man that was drowned. A sail veering about the blank bay waiting for a swollen bundle to bob up, roll over to the sun a puffy face, saltwhite. Here I am.

They followed the winding path down to the creek. Buck Mulligan stood on a stone, in shirtsleeves, his unclipped tie rippling over his shoulder. A young man clinging to a spur of rock near him, moved slowly frogwise his green legs in the deep jelly of the water.

—Is the brother with you, Malachi?

—Down in Westmeath. With the Bannons.

—Still there? I got a card from Bannon. Says he found a sweet young thing down there. Photo girl he calls her.

—Snapshot, eh? Brief exposure.

Buck Mulligan sat down to unlace his boots. An elderly man shot up near the spur of rock a blowing red face. He scrambled up by the stones, water glistening on his pate and on its garland of grey hair, water rilling over his chest and paunch and spilling jets out of his black sagging loincloth.

Buck Mulligan made way for him to scramble past and, glancing at Haines and Stephen, crossed himself piously with his thumbnail at brow and lips and breastbone.

—Seymour’s back in town, the young man said, grasping again his spur of rock. Chucked medicine and going in for the army.

—Ah, go to God! Buck Mulligan said.

—Going over next week to stew. You know that red Carlisle girl, Lily?

—Yes.

—Spooning with him last night on the pier. The father is rotto with money.

—Is she up the pole?

—Better ask Seymour that.

—Seymour a bleeding officer! Buck Mulligan said.

He nodded to himself as he drew off his trousers and stood up, saying tritely:

—Redheaded women buck like goats.

He broke off in alarm, feeling his side under his flapping shirt.

—My twelfth rib is gone, he cried. I’m the Übermensch. Toothless Kinch and I, the supermen.

He struggled out of his shirt and flung it behind him to where his clothes lay.

—Are you going in here, Malachi?

—Yes. Make room in the bed.

The young man shoved himself backward through the water and reached the middle of the creek in two long clean strokes. Haines sat down on a stone, smoking.

—Are you not coming in? Buck Mulligan asked.

—Later on, Haines said. Not on my breakfast.

Stephen turned away.

—I’m going, Mulligan, he said.

—Give us that key, Kinch, Buck Mulligan said, to keep my chemise flat.

Stephen handed him the key. Buck Mulligan laid it across his heaped clothes.

—And twopence, he said, for a pint. Throw it there.

Stephen threw two pennies on the soft heap. Dressing, undressing. Buck Mulligan erect, with joined hands before him, said solemnly:

—He who stealeth from the poor lendeth to the Lord. Thus spake Zarathustra.

His plump body plunged.

—We’ll see you again, Haines said, turning as Stephen walked up the path and smiling at wild Irish.

Horn of a bull, hoof of a horse, smile of a Saxon.

—The Ship, Buck Mulligan cried. Half twelve.

—Good, Stephen said.

He walked along the upwardcurving path.

Liliata rutilantium.
Turma circumdet.
Iubilantium te virginum.

The priest’s grey nimbus in a niche where he dressed discreetly. I will not sleep here tonight. Home also I cannot go.

A voice, sweettoned and sustained, called to him from the sea. Turning the curve he waved his hand. It called again. A sleek brown head, a seal’s, far out on the water, round.

Usurper.

### [ 2 ]
—You, Cochrane, what city sent for him?

—Tarentum, sir.

—Very good. Well?

—There was a battle, sir.

—Very good. Where?

The boy’s blank face asked the blank window.

Fabled by the daughters of memory. And yet it was in some way if not as memory fabled it. A phrase, then, of impatience, thud of Blake’s wings of excess. I hear the ruin of all space, shattered glass and toppling masonry, and time one livid final flame. What’s left us then?

—I forget the place, sir. 279 B. C.

—Asculum, Stephen said, glancing at the name and date in the gorescarred book.

—Yes, sir. And he said: Another victory like that and we are done for.

That phrase the world had remembered. A dull ease of the mind. From a hill above a corpsestrewn plain a general speaking to his officers, leaned upon his spear. Any general to any officers. They lend ear.

—You, Armstrong, Stephen said. What was the end of Pyrrhus?

—End of Pyrrhus, sir?

—I know, sir. Ask me, sir, Comyn said.

—Wait. You, Armstrong. Do you know anything about Pyrrhus?

A bag of figrolls lay snugly in Armstrong’s satchel. He curled them between his palms at whiles and swallowed them softly. Crumbs adhered to the tissue of his lips. A sweetened boy’s breath. Welloff people, proud that their eldest son was in the navy. Vico Road, Dalkey.

—Pyrrhus, sir? Pyrrhus, a pier.

All laughed. Mirthless high malicious laughter. Armstrong looked round at his classmates, silly glee in profile. In a moment they will laugh more loudly, aware of my lack of rule and of the fees their papas pay.

—Tell me now, Stephen said, poking the boy’s shoulder with the book, what is a pier.

—A pier, sir, Armstrong said. A thing out in the water. A kind of a bridge. Kingstown pier, sir.

Some laughed again: mirthless but with meaning. Two in the back bench whispered. Yes. They knew: had never learned nor ever been innocent. All. With envy he watched their faces: Edith, Ethel, Gerty, Lily. Their likes: their breaths, too, sweetened with tea and jam, their bracelets tittering in the struggle.

—Kingstown pier, Stephen said. Yes, a disappointed bridge.

The words troubled their gaze.

—How, sir? Comyn asked. A bridge is across a river.

For Haines’s chapbook. No-one here to hear. Tonight deftly amid wild drink and talk, to pierce the polished mail of his mind. What then? A jester at the court of his master, indulged and disesteemed, winning a clement master’s praise. Why had they chosen all that part? Not wholly for the smooth caress. For them too history was a tale like any other too often heard, their land a pawnshop.

Had Pyrrhus not fallen by a beldam’s hand in Argos or Julius Caesar not been knifed to death. They are not to be thought away. Time has branded them and fettered they are lodged in the room of the infinite possibilities they have ousted. But can those have been possible seeing that they never were? Or was that only possible which came to pass? Weave, weaver of the wind.

—Tell us a story, sir.

—O, do, sir. A ghoststory.

—Where do you begin in this? Stephen asked, opening another book.

—Weep no more, Comyn said.

—Go on then, Talbot.

—And the story, sir?

—After, Stephen said. Go on, Talbot.

A swarthy boy opened a book and propped it nimbly under the breastwork of his satchel. He recited jerks of verse with odd glances at the text:

—Weep no more, woful shepherds, weep no more
For Lycidas, your sorrow, is not dead,
Sunk though he be beneath the watery floor...

It must be a movement then, an actuality of the possible as possible. Aristotle’s phrase formed itself within the gabbled verses and floated out into the studious silence of the library of Saint Genevieve where he had read, sheltered from the sin of Paris, night by night. By his elbow a delicate Siamese conned a handbook of strategy. Fed and feeding brains about me: under glowlamps, impaled, with faintly beating feelers: and in my mind’s darkness a sloth of the underworld, reluctant, shy of brightness, shifting her dragon scaly folds. Thought is the thought of thought. Tranquil brightness. The soul is in a manner all that is: the soul is the form of forms. Tranquility sudden, vast, candescent: form of forms.

Talbot repeated:

—Through the dear might of Him that walked the waves,
Through the dear might...

—Turn over, Stephen said quietly. I don’t see anything.

—What, sir? Talbot asked simply, bending forward.

His hand turned the page over. He leaned back and went on again, having just remembered. Of him that walked the waves. Here also over these craven hearts his shadow lies and on the scoffer’s heart and lips and on mine. It lies upon their eager faces who offered him a coin of the tribute. To Caesar what is Caesar’s, to God what is God’s. A long look from dark eyes, a riddling sentence to be woven and woven on the church’s looms. Ay.

Riddle me, riddle me, randy ro.
My father gave me seeds to sow.

Talbot slid his closed book into his satchel.

—Have I heard all? Stephen asked.

—Yes, sir. Hockey at ten, sir.

—Half day, sir. Thursday.

—Who can answer a riddle? Stephen asked.

They bundled their books away, pencils clacking, pages rustling. Crowding together they strapped and buckled their satchels, all gabbling gaily:

—A riddle, sir? Ask me, sir.

—O, ask me, sir.

—A hard one, sir.

—This is the riddle, Stephen said:

The cock crew,
The sky was blue:
The bells in heaven
Were striking eleven.
’Tis time for this poor soul
To go to heaven.

What is that?

—What, sir?

—Again, sir. We didn’t hear.

Their eyes grew bigger as the lines were repeated. After a silence Cochrane said:

—What is it, sir? We give it up.

Stephen, his throat itching, answered:

—The fox burying his grandmother under a hollybush.

He stood up and gave a shout of nervous laughter to which their cries echoed dismay.

A stick struck the door and a voice in the corridor called:

—Hockey!

They broke asunder, sidling out of their benches, leaping them. Quickly they were gone and from the lumberroom came the rattle of sticks and clamour of their boots and tongues.

Sargent who alone had lingered came forward slowly, showing an open copybook. His tangled hair and scraggy neck gave witness of unreadiness and through his misty glasses weak eyes looked up pleading. On his cheek, dull and bloodless, a soft stain of ink lay, dateshaped, recent and damp as a snail’s bed.

He held out his copybook. The word Sums was written on the headline. Beneath were sloping figures and at the foot a crooked signature with blind loops and a blot. Cyril Sargent: his name and seal.

—Mr Deasy told me to write them out all again, he said, and show them to you, sir.

Stephen touched the edges of the book. Futility.

—Do you understand how to do them now? he asked.

—Numbers eleven to fifteen, Sargent answered. Mr Deasy said I was to copy them off the board, sir.

—Can you do them yourself? Stephen asked.

—No, sir.

Ugly and futile: lean neck and tangled hair and a stain of ink, a snail’s bed. Yet someone had loved him, borne him in her arms and in her heart. But for her the race of the world would have trampled him underfoot, a squashed boneless snail. She had loved his weak watery blood drained from her own. Was that then real? The only true thing in life? His mother’s prostrate body the fiery Columbanus in holy zeal bestrode. She was no more: the trembling skeleton of a twig burnt in the fire, an odour of rosewood and wetted ashes. She had saved him from being trampled underfoot and had gone, scarcely having been. A poor soul gone to heaven: and on a heath beneath winking stars a fox, red reek of rapine in his fur, with merciless bright eyes scraped in the earth, listened, scraped up the earth, listened, scraped and scraped.

Sitting at his side Stephen solved out the problem. He proves by algebra that Shakespeare’s ghost is Hamlet’s grandfather. Sargent peered askance through his slanted glasses. Hockeysticks rattled in the lumberroom: the hollow knock of a ball and calls from the field.

Across the page the symbols moved in grave morrice, in the mummery of their letters, wearing quaint caps of squares and cubes. Give hands, traverse, bow to partner: so: imps of fancy of the Moors. Gone too from the world, Averroes and Moses Maimonides, dark men in mien and movement, flashing in their mocking mirrors the obscure soul of the world, a darkness shining in brightness which brightness could not comprehend.

—Do you understand now? Can you work the second for yourself?

—Yes, sir.

In long shaky strokes Sargent copied the data. Waiting always for a word of help his hand moved faithfully the unsteady symbols, a faint hue of shame flickering behind his dull skin. Amor matris: subjective and objective genitive. With her weak blood and wheysour milk she had fed him and hid from sight of others his swaddling bands.

Like him was I, these sloping shoulders, this gracelessness. My childhood bends beside me. Too far for me to lay a hand there once or lightly. Mine is far and his secret as our eyes. Secrets, silent, stony sit in the dark palaces of both our hearts: secrets weary of their tyranny: tyrants, willing to be dethroned.

The sum was done.

—It is very simple, Stephen said as he stood up.

—Yes, sir. Thanks, Sargent answered.

He dried the page with a sheet of thin blottingpaper and carried his copybook back to his bench.

—You had better get your stick and go out to the others, Stephen said as he followed towards the door the boy’s graceless form.

—Yes, sir.

In the corridor his name was heard, called from the playfield.

—Sargent!

—Run on, Stephen said. Mr Deasy is calling you.

He stood in the porch and watched the laggard hurry towards the scrappy field where sharp voices were in strife. They were sorted in teams and Mr Deasy came away stepping over wisps of grass with gaitered feet. When he had reached the schoolhouse voices again contending called to him. He turned his angry white moustache.

—What is it now? he cried continually without listening.

—Cochrane and Halliday are on the same side, sir, Stephen said.

—Will you wait in my study for a moment, Mr Deasy said, till I restore order here.

And as he stepped fussily back across the field his old man’s voice cried sternly:

—What is the matter? What is it now?

Their sharp voices cried about him on all sides: their many forms closed round him, the garish sunshine bleaching the honey of his illdyed head.

Stale smoky air hung in the study with the smell of drab abraded leather of its chairs. As on the first day he bargained with me here. As it was in the beginning, is now. On the sideboard the tray of Stuart coins, base treasure of a bog: and ever shall be. And snug in their spooncase of purple plush, faded, the twelve apostles having preached to all the gentiles: world without end.

A hasty step over the stone porch and in the corridor. Blowing out his rare moustache Mr Deasy halted at the table.

—First, our little financial settlement, he said.

He brought out of his coat a pocketbook bound by a leather thong. It slapped open and he took from it two notes, one of joined halves, and laid them carefully on the table.

—Two, he said, strapping and stowing his pocketbook away.

And now his strongroom for the gold. Stephen’s embarrassed hand moved over the shells heaped in the cold stone mortar: whelks and money cowries and leopard shells: and this, whorled as an emir’s turban, and this, the scallop of saint James. An old pilgrim’s hoard, dead treasure, hollow shells.

A sovereign fell, bright and new, on the soft pile of the tablecloth.

—Three, Mr Deasy said, turning his little savingsbox about in his hand. These are handy things to have. See. This is for sovereigns. This is for shillings. Sixpences, halfcrowns. And here crowns. See.

He shot from it two crowns and two shillings.

—Three twelve, he said. I think you’ll find that’s right.

—Thank you, sir, Stephen said, gathering the money together with shy haste and putting it all in a pocket of his trousers.

—No thanks at all, Mr Deasy said. You have earned it.

Stephen’s hand, free again, went back to the hollow shells. Symbols too of beauty and of power. A lump in my pocket: symbols soiled by greed and misery.

—Don’t carry it like that, Mr Deasy said. You’ll pull it out somewhere and lose it. You just buy one of these machines. You’ll find them very handy.

Answer something.

—Mine would be often empty, Stephen said.

The same room and hour, the same wisdom: and I the same. Three times now. Three nooses round me here. Well? I can break them in this instant if I will.

—Because you don’t save, Mr Deasy said, pointing his finger. You don’t know yet what money is. Money is power. When you have lived as long as I have. I know, I know. If youth but knew. But what does Shakespeare say? Put but money in thy purse.

—Iago, Stephen murmured.

He lifted his gaze from the idle shells to the old man’s stare.

—He knew what money was, Mr Deasy said. He made money. A poet, yes, but an Englishman too. Do you know what is the pride of the English? Do you know what is the proudest word you will ever hear from an Englishman’s mouth?

The seas’ ruler. His seacold eyes looked on the empty bay: it seems history is to blame: on me and on my words, unhating.

—That on his empire, Stephen said, the sun never sets.

—Ba! Mr Deasy cried. That’s not English. A French Celt said that. He tapped his savingsbox against his thumbnail.

—I will tell you, he said solemnly, what is his proudest boast. I paid my way.

Good man, good man.

—I paid my way. I never borrowed a shilling in my life. Can you feel that? I owe nothing. Can you?

Mulligan, nine pounds, three pairs of socks, one pair brogues, ties. Curran, ten guineas. McCann, one guinea. Fred Ryan, two shillings. Temple, two lunches. Russell, one guinea, Cousins, ten shillings, Bob Reynolds, half a guinea, Koehler, three guineas, Mrs MacKernan, five weeks’ board. The lump I have is useless.

—For the moment, no, Stephen answered.

Mr Deasy laughed with rich delight, putting back his savingsbox.

—I knew you couldn’t, he said joyously. But one day you must feel it. We are a generous people but we must also be just.

—I fear those big words, Stephen said, which make us so unhappy.

Mr Deasy stared sternly for some moments over the mantelpiece at the shapely bulk of a man in tartan fillibegs: Albert Edward, prince of Wales.

—You think me an old fogey and an old tory, his thoughtful voice said. I saw three generations since O’Connell’s time. I remember the famine in ’46. Do you know that the orange lodges agitated for repeal of the union twenty years before O’Connell did or before the prelates of your communion denounced him as a demagogue? You fenians forget some things.

Glorious, pious and immortal memory. The lodge of Diamond in Armagh the splendid behung with corpses of papishes. Hoarse, masked and armed, the planters’ covenant. The black north and true blue bible. Croppies lie down.

Stephen sketched a brief gesture.

—I have rebel blood in me too, Mr Deasy said. On the spindle side. But I am descended from sir John Blackwood who voted for the union. We are all Irish, all kings’ sons.

—Alas, Stephen said.

—Per vias rectas, Mr Deasy said firmly, was his motto. He voted for it and put on his topboots to ride to Dublin from the Ards of Down to do so.

Lal the ral the ra
The rocky road to Dublin.

A gruff squire on horseback with shiny topboots. Soft day, sir John! Soft day, your honour!... Day!... Day!... Two topboots jog dangling on to Dublin. Lal the ral the ra. Lal the ral the raddy.

—That reminds me, Mr Deasy said. You can do me a favour, Mr Dedalus, with some of your literary friends. I have a letter here for the press. Sit down a moment. I have just to copy the end.

He went to the desk near the window, pulled in his chair twice and read off some words from the sheet on the drum of his typewriter.

—Sit down. Excuse me, he said over his shoulder, the dictates of common sense. Just a moment.

He peered from under his shaggy brows at the manuscript by his elbow and, muttering, began to prod the stiff buttons of the keyboard slowly, sometimes blowing as he screwed up the drum to erase an error.

Stephen seated himself noiselessly before the princely presence. Framed around the walls images of vanished horses stood in homage, their meek heads poised in air: lord Hastings’ Repulse, the duke of Westminster’s Shotover, the duke of Beaufort’s Ceylon, prix de Paris, 1866. Elfin riders sat them, watchful of a sign. He saw their speeds, backing king’s colours, and shouted with the shouts of vanished crowds.

—Full stop, Mr Deasy bade his keys. But prompt ventilation of this allimportant question...

Where Cranly led me to get rich quick, hunting his winners among the mudsplashed brakes, amid the bawls of bookies on their pitches and reek of the canteen, over the motley slush. Even money Fair Rebel. Ten to one the field. Dicers and thimbleriggers we hurried by after the hoofs, the vying caps and jackets and past the meatfaced woman, a butcher’s dame, nuzzling thirstily her clove of orange.

Shouts rang shrill from the boys’ playfield and a whirring whistle.

Again: a goal. I am among them, among their battling bodies in a medley, the joust of life. You mean that knockkneed mother’s darling who seems to be slightly crawsick? Jousts. Time shocked rebounds, shock by shock. Jousts, slush and uproar of battles, the frozen deathspew of the slain, a shout of spearspikes baited with men’s bloodied guts.

—Now then, Mr Deasy said, rising.

He came to the table, pinning together his sheets. Stephen stood up.

—I have put the matter into a nutshell, Mr Deasy said. It’s about the foot and mouth disease. Just look through it. There can be no two opinions on the matter.

May I trespass on your valuable space. That doctrine of laissez faire which so often in our history. Our cattle trade. The way of all our old industries. Liverpool ring which jockeyed the Galway harbour scheme. European conflagration. Grain supplies through the narrow waters of the channel. The pluterperfect imperturbability of the department of agriculture. Pardoned a classical allusion. Cassandra. By a woman who was no better than she should be. To come to the point at issue.

—I don’t mince words, do I? Mr Deasy asked as Stephen read on.

Foot and mouth disease. Known as Koch’s preparation. Serum and virus. Percentage of salted horses. Rinderpest. Emperor’s horses at Mürzsteg, lower Austria. Veterinary surgeons. Mr Henry Blackwood Price. Courteous offer a fair trial. Dictates of common sense. Allimportant question. In every sense of the word take the bull by the horns. Thanking you for the hospitality of your columns.

—I want that to be printed and read, Mr Deasy said. You will see at the next outbreak they will put an embargo on Irish cattle. And it can be cured. It is cured. My cousin, Blackwood Price, writes to me it is regularly treated and cured in Austria by cattledoctors there. They offer to come over here. I am trying to work up influence with the department. Now I’m going to try publicity. I am surrounded by difficulties, by... intrigues by... backstairs influence by...

He raised his forefinger and beat the air oldly before his voice spoke.

—Mark my words, Mr Dedalus, he said. England is in the hands of the jews. In all the highest places: her finance, her press. And they are the signs of a nation’s decay. Wherever they gather they eat up the nation’s vital strength. I have seen it coming these years. As sure as we are standing here the jew merchants are already at their work of destruction. Old England is dying.

He stepped swiftly off, his eyes coming to blue life as they passed a broad sunbeam. He faced about and back again.

—Dying, he said again, if not dead by now.

The harlot’s cry from street to street
Shall weave old England’s windingsheet.

His eyes open wide in vision stared sternly across the sunbeam in which he halted.

—A merchant, Stephen said, is one who buys cheap and sells dear, jew or gentile, is he not?

—They sinned against the light, Mr Deasy said gravely. And you can see the darkness in their eyes. And that is why they are wanderers on the earth to this day.

On the steps of the Paris stock exchange the goldskinned men quoting prices on their gemmed fingers. Gabble of geese. They swarmed loud, uncouth about the temple, their heads thickplotting under maladroit silk hats. Not theirs: these clothes, this speech, these gestures. Their full slow eyes belied the words, the gestures eager and unoffending, but knew the rancours massed about them and knew their zeal was vain. Vain patience to heap and hoard. Time surely would scatter all. A hoard heaped by the roadside: plundered and passing on. Their eyes knew their years of wandering and, patient, knew the dishonours of their flesh.

—Who has not? Stephen said.

—What do you mean? Mr Deasy asked.

He came forward a pace and stood by the table. His underjaw fell sideways open uncertainly. Is this old wisdom? He waits to hear from me.

—History, Stephen said, is a nightmare from which I am trying to awake.

From the playfield the boys raised a shout. A whirring whistle: goal. What if that nightmare gave you a back kick?

—The ways of the Creator are not our ways, Mr Deasy said. All human history moves towards one great goal, the manifestation of God.

Stephen jerked his thumb towards the window, saying:

—That is God.

Hooray! Ay! Whrrwhee!

—What? Mr Deasy asked.

—A shout in the street, Stephen answered, shrugging his shoulders.

Mr Deasy looked down and held for awhile the wings of his nose tweaked between his fingers. Looking up again he set them free.

—I am happier than you are, he said. We have committed many errors and many sins. A woman brought sin into the world. For a woman who was no better than she should be, Helen, the runaway wife of Menelaus, ten years the Greeks made war on Troy. A faithless wife first brought the strangers to our shore here, MacMurrough’s wife and her leman, O’Rourke, prince of Breffni. A woman too brought Parnell low. Many errors, many failures but not the one sin. I am a struggler now at the end of my days. But I will fight for the right till the end.

For Ulster will fight
And Ulster will be right.

Stephen raised the sheets in his hand.

—Well, sir, he began.

—I foresee, Mr Deasy said, that you will not remain here very long at this work. You were not born to be a teacher, I think. Perhaps I am wrong.

—A learner rather, Stephen said.

And here what will you learn more?

Mr Deasy shook his head.

—Who knows? he said. To learn one must be humble. But life is the great teacher.

Stephen rustled the sheets again.

—As regards these, he began.

—Yes, Mr Deasy said. You have two copies there. If you can have them published at once.

Telegraph. Irish Homestead.

—I will try, Stephen said, and let you know tomorrow. I know two editors slightly.

—That will do, Mr Deasy said briskly. I wrote last night to Mr Field, M.P. There is a meeting of the cattletraders’ association today at the City Arms hotel. I asked him to lay my letter before the meeting. You see if you can get it into your two papers. What are they?

—The Evening Telegraph...

—That will do, Mr Deasy said. There is no time to lose. Now I have to answer that letter from my cousin.

—Good morning, sir, Stephen said, putting the sheets in his pocket. Thank you.

—Not at all, Mr Deasy said as he searched the papers on his desk. I like to break a lance with you, old as I am.

—Good morning, sir, Stephen said again, bowing to his bent back.

He went out by the open porch and down the gravel path under the trees, hearing the cries of voices and crack of sticks from the playfield. The lions couchant on the pillars as he passed out through the gate: toothless terrors. Still I will help him in his fight. Mulligan will dub me a new name: the bullockbefriending bard.

—Mr Dedalus!

Running after me. No more letters, I hope.

—Just one moment.

—Yes, sir, Stephen said, turning back at the gate.

Mr Deasy halted, breathing hard and swallowing his breath.

—I just wanted to say, he said. Ireland, they say, has the honour of being the only country which never persecuted the jews. Do you know that? No. And do you know why?

He frowned sternly on the bright air.

—Why, sir? Stephen asked, beginning to smile.

—Because she never let them in, Mr Deasy said solemnly.

A coughball of laughter leaped from his throat dragging after it a rattling chain of phlegm. He turned back quickly, coughing, laughing, his lifted arms waving to the air.

—She never let them in, he cried again through his laughter as he stamped on gaitered feet over the gravel of the path. That’s why.

On his wise shoulders through the checkerwork of leaves the sun flung spangles, dancing coins.

### [ 3 ]
Ineluctable modality of the visible: at least that if no more, thought through my eyes. Signatures of all things I am here to read, seaspawn and seawrack, the nearing tide, that rusty boot. Snotgreen, bluesilver, rust: coloured signs. Limits of the diaphane. But he adds: in bodies. Then he was aware of them bodies before of them coloured. How? By knocking his sconce against them, sure. Go easy. Bald he was and a millionaire, maestro di color che sanno. Limit of the diaphane in. Why in? Diaphane, adiaphane. If you can put your five fingers through it it is a gate, if not a door. Shut your eyes and see.

Stephen closed his eyes to hear his boots crush crackling wrack and shells. You are walking through it howsomever. I am, a stride at a time. A very short space of time through very short times of space. Five, six: the nacheinander. Exactly: and that is the ineluctable modality of the audible. Open your eyes. No. Jesus! If I fell over a cliff that beetles o’er his base, fell through the nebeneinander ineluctably! I am getting on nicely in the dark. My ash sword hangs at my side. Tap with it: they do. My two feet in his boots are at the ends of his legs, nebeneinander. Sounds solid: made by the mallet of Los Demiurgos. Am I walking into eternity along Sandymount strand? Crush, crack, crick, crick. Wild sea money. Dominie Deasy kens them a’.

Won’t you come to Sandymount,
Madeline the mare?

Rhythm begins, you see. I hear. A catalectic tetrameter of iambs marching. No, agallop: deline the mare.

Open your eyes now. I will. One moment. Has all vanished since? If I open and am for ever in the black adiaphane. Basta! I will see if I can see.

See now. There all the time without you: and ever shall be, world without end.

They came down the steps from Leahy’s terrace prudently, Frauenzimmer: and down the shelving shore flabbily, their splayed feet sinking in the silted sand. Like me, like Algy, coming down to our mighty mother. Number one swung lourdily her midwife’s bag, the other’s gamp poked in the beach. From the liberties, out for the day. Mrs Florence MacCabe, relict of the late Patk MacCabe, deeply lamented, of Bride Street. One of her sisterhood lugged me squealing into life. Creation from nothing. What has she in the bag? A misbirth with a trailing navelcord, hushed in ruddy wool. The cords of all link back, strandentwining cable of all flesh. That is why mystic monks. Will you be as gods? Gaze in your omphalos. Hello. Kinch here. Put me on to Edenville. Aleph, alpha: nought, nought, one.

Spouse and helpmate of Adam Kadmon: Heva, naked Eve. She had no navel. Gaze. Belly without blemish, bulging big, a buckler of taut vellum, no, whiteheaped corn, orient and immortal, standing from everlasting to everlasting. Womb of sin.

Wombed in sin darkness I was too, made not begotten. By them, the man with my voice and my eyes and a ghostwoman with ashes on her breath. They clasped and sundered, did the coupler’s will. From before the ages He willed me and now may not will me away or ever. A lex eterna stays about Him. Is that then the divine substance wherein Father and Son are consubstantial? Where is poor dear Arius to try conclusions? Warring his life long upon the contransmagnificandjewbangtantiality. Illstarred heresiarch! In a Greek watercloset he breathed his last: euthanasia. With beaded mitre and with crozier, stalled upon his throne, widower of a widowed see, with upstiffed omophorion, with clotted hinderparts.

Airs romped round him, nipping and eager airs. They are coming, waves. The whitemaned seahorses, champing, brightwindbridled, the steeds of Mananaan.

I mustn’t forget his letter for the press. And after? The Ship, half twelve. By the way go easy with that money like a good young imbecile. Yes, I must.

His pace slackened. Here. Am I going to aunt Sara’s or not? My consubstantial father’s voice. Did you see anything of your artist brother Stephen lately? No? Sure he’s not down in Strasburg terrace with his aunt Sally? Couldn’t he fly a bit higher than that, eh? And and and and tell us, Stephen, how is uncle Si? O, weeping God, the things I married into! De boys up in de hayloft. The drunken little costdrawer and his brother, the cornet player. Highly respectable gondoliers! And skeweyed Walter sirring his father, no less! Sir. Yes, sir. No, sir. Jesus wept: and no wonder, by Christ!

I pull the wheezy bell of their shuttered cottage: and wait. They take me for a dun, peer out from a coign of vantage.

—It’s Stephen, sir.

—Let him in. Let Stephen in.

A bolt drawn back and Walter welcomes me.

—We thought you were someone else.

In his broad bed nuncle Richie, pillowed and blanketed, extends over the hillock of his knees a sturdy forearm. Cleanchested. He has washed the upper moiety.

—Morrow, nephew.

He lays aside the lapboard whereon he drafts his bills of costs for the eyes of master Goff and master Shapland Tandy, filing consents and common searches and a writ of Duces Tecum. A bogoak frame over his bald head: Wilde’s Requiescat. The drone of his misleading whistle brings Walter back.

—Yes, sir?

—Malt for Richie and Stephen, tell mother. Where is she?

—Bathing Crissie, sir.

Papa’s little bedpal. Lump of love.

—No, uncle Richie...

—Call me Richie. Damn your lithia water. It lowers. Whusky!

—Uncle Richie, really...

—Sit down or by the law Harry I’ll knock you down.

Walter squints vainly for a chair.

—He has nothing to sit down on, sir.

—He has nowhere to put it, you mug. Bring in our chippendale chair. Would you like a bite of something? None of your damned lawdeedaw airs here. The rich of a rasher fried with a herring? Sure? So much the better. We have nothing in the house but backache pills.

All’erta!

He drones bars of Ferrando’s aria di sortita. The grandest number, Stephen, in the whole opera. Listen.

His tuneful whistle sounds again, finely shaded, with rushes of the air, his fists bigdrumming on his padded knees.

This wind is sweeter.

Houses of decay, mine, his and all. You told the Clongowes gentry you had an uncle a judge and an uncle a general in the army. Come out of them, Stephen. Beauty is not there. Nor in the stagnant bay of Marsh’s library where you read the fading prophecies of Joachim Abbas. For whom? The hundredheaded rabble of the cathedral close. A hater of his kind ran from them to the wood of madness, his mane foaming in the moon, his eyeballs stars. Houyhnhnm, horsenostrilled. The oval equine faces, Temple, Buck Mulligan, Foxy Campbell, Lanternjaws. Abbas father, furious dean, what offence laid fire to their brains? Paff! Descende, calve, ut ne nimium decalveris. A garland of grey hair on his comminated head see him me clambering down to the footpace (descende!), clutching a monstrance, basiliskeyed. Get down, baldpoll! A choir gives back menace and echo, assisting about the altar’s horns, the snorted Latin of jackpriests moving burly in their albs, tonsured and oiled and gelded, fat with the fat of kidneys of wheat.

And at the same instant perhaps a priest round the corner is elevating it. Dringdring! And two streets off another locking it into a pyx. Dringadring! And in a ladychapel another taking housel all to his own cheek. Dringdring! Down, up, forward, back. Dan Occam thought of that, invincible doctor. A misty English morning the imp hypostasis tickled his brain. Bringing his host down and kneeling he heard twine with his second bell the first bell in the transept (he is lifting his) and, rising, heard (now I am lifting) their two bells (he is kneeling) twang in diphthong.

Cousin Stephen, you will never be a saint. Isle of saints. You were awfully holy, weren’t you? You prayed to the Blessed Virgin that you might not have a red nose. You prayed to the devil in Serpentine avenue that the fubsy widow in front might lift her clothes still more from the wet street. O si, certo! Sell your soul for that, do, dyed rags pinned round a squaw. More tell me, more still! On the top of the Howth tram alone crying to the rain: Naked women! Naked women! What about that, eh?

What about what? What else were they invented for?

Reading two pages apiece of seven books every night, eh? I was young. You bowed to yourself in the mirror, stepping forward to applause earnestly, striking face. Hurray for the Goddamned idiot! Hray! No-one saw: tell no-one. Books you were going to write with letters for titles. Have you read his F? O yes, but I prefer Q. Yes, but W is wonderful. O yes, W. Remember your epiphanies written on green oval leaves, deeply deep, copies to be sent if you died to all the great libraries of the world, including Alexandria? Someone was to read them there after a few thousand years, a mahamanvantara. Pico della Mirandola like. Ay, very like a whale. When one reads these strange pages of one long gone one feels that one is at one with one who once...

The grainy sand had gone from under his feet. His boots trod again a damp crackling mast, razorshells, squeaking pebbles, that on the unnumbered pebbles beats, wood sieved by the shipworm, lost Armada. Unwholesome sandflats waited to suck his treading soles, breathing upward sewage breath, a pocket of seaweed smouldered in seafire under a midden of man’s ashes. He coasted them, walking warily. A porterbottle stood up, stogged to its waist, in the cakey sand dough. A sentinel: isle of dreadful thirst. Broken hoops on the shore; at the land a maze of dark cunning nets; farther away chalkscrawled backdoors and on the higher beach a dryingline with two crucified shirts. Ringsend: wigwams of brown steersmen and master mariners. Human shells.

He halted. I have passed the way to aunt Sara’s. Am I not going there? Seems not. No-one about. He turned northeast and crossed the firmer sand towards the Pigeonhouse.

—Qui vous a mis dans cette fichue position?

—C’est le pigeon, Joseph.

Patrice, home on furlough, lapped warm milk with me in the bar MacMahon. Son of the wild goose, Kevin Egan of Paris. My father’s a bird, he lapped the sweet lait chaud with pink young tongue, plump bunny’s face. Lap, lapin. He hopes to win in the gros lots. About the nature of women he read in Michelet. But he must send me La Vie de Jésus by M. Léo Taxil. Lent it to his friend.

—C’est tordant, vous savez. Moi, je suis socialiste. Je ne crois pas en l’existence de Dieu. Faut pas le dire à mon père.

—Il croit?

—Mon père, oui.

Schluss. He laps.

My Latin quarter hat. God, we simply must dress the character. I want puce gloves. You were a student, weren’t you? Of what in the other devil’s name? Paysayenn. P. C. N., you know: physiques, chimiques et naturelles. Aha. Eating your groatsworth of mou en civet, fleshpots of Egypt, elbowed by belching cabmen. Just say in the most natural tone: when I was in Paris; boul’ Mich’, I used to. Yes, used to carry punched tickets to prove an alibi if they arrested you for murder somewhere. Justice. On the night of the seventeenth of February 1904 the prisoner was seen by two witnesses. Other fellow did it: other me. Hat, tie, overcoat, nose. Lui, c’est moi. You seem to have enjoyed yourself.

Proudly walking. Whom were you trying to walk like? Forget: a dispossessed. With mother’s money order, eight shillings, the banging door of the post office slammed in your face by the usher. Hunger toothache. Encore deux minutes. Look clock. Must get. Fermé. Hired dog! Shoot him to bloody bits with a bang shotgun, bits man spattered walls all brass buttons. Bits all khrrrrklak in place clack back. Not hurt? O, that’s all right. Shake hands. See what I meant, see? O, that’s all right. Shake a shake. O, that’s all only all right.

You were going to do wonders, what? Missionary to Europe after fiery Columbanus. Fiacre and Scotus on their creepystools in heaven spilt from their pintpots, loudlatinlaughing: Euge! Euge! Pretending to speak broken English as you dragged your valise, porter threepence, across the slimy pier at Newhaven. Comment? Rich booty you brought back; Le Tutu, five tattered numbers of Pantalon Blanc et Culotte Rouge; a blue French telegram, curiosity to show:

—Mother dying come home father.

The aunt thinks you killed your mother. That’s why she won’t.

Then here’s a health to Mulligan’s aunt
And I’ll tell you the reason why.
She always kept things decent in
The Hannigan famileye.

His feet marched in sudden proud rhythm over the sand furrows, along by the boulders of the south wall. He stared at them proudly, piled stone mammoth skulls. Gold light on sea, on sand, on boulders. The sun is there, the slender trees, the lemon houses.

Paris rawly waking, crude sunlight on her lemon streets. Moist pith of farls of bread, the froggreen wormwood, her matin incense, court the air. Belluomo rises from the bed of his wife’s lover’s wife, the kerchiefed housewife is astir, a saucer of acetic acid in her hand. In Rodot’s Yvonne and Madeleine newmake their tumbled beauties, shattering with gold teeth chaussons of pastry, their mouths yellowed with the pus of flan bréton. Faces of Paris men go by, their wellpleased pleasers, curled conquistadores.

Noon slumbers. Kevin Egan rolls gunpowder cigarettes through fingers smeared with printer’s ink, sipping his green fairy as Patrice his white. About us gobblers fork spiced beans down their gullets. Un demi sétier! A jet of coffee steam from the burnished caldron. She serves me at his beck. Il est irlandais. Hollandais? Non fromage. Deux irlandais, nous, Irlande, vous savez ah, oui! She thought you wanted a cheese hollandais. Your postprandial, do you know that word? Postprandial. There was a fellow I knew once in Barcelona, queer fellow, used to call it his postprandial. Well: slainte! Around the slabbed tables the tangle of wined breaths and grumbling gorges. His breath hangs over our saucestained plates, the green fairy’s fang thrusting between his lips. Of Ireland, the Dalcassians, of hopes, conspiracies, of Arthur Griffith now, A E, pimander, good shepherd of men. To yoke me as his yokefellow, our crimes our common cause. You’re your father’s son. I know the voice. His fustian shirt, sanguineflowered, trembles its Spanish tassels at his secrets. M. Drumont, famous journalist, Drumont, know what he called queen Victoria? Old hag with the yellow teeth. Vieille ogresse with the dents jaunes. Maud Gonne, beautiful woman, La Patrie, M. Millevoye, Félix Faure, know how he died? Licentious men. The froeken, bonne à tout faire, who rubs male nakedness in the bath at Upsala. Moi faire, she said, Tous les messieurs. Not this Monsieur, I said. Most licentious custom. Bath a most private thing. I wouldn’t let my brother, not even my own brother, most lascivious thing. Green eyes, I see you. Fang, I feel. Lascivious people.

The blue fuse burns deadly between hands and burns clear. Loose tobaccoshreds catch fire: a flame and acrid smoke light our corner. Raw facebones under his peep of day boy’s hat. How the head centre got away, authentic version. Got up as a young bride, man, veil, orangeblossoms, drove out the road to Malahide. Did, faith. Of lost leaders, the betrayed, wild escapes. Disguises, clutched at, gone, not here.

Spurned lover. I was a strapping young gossoon at that time, I tell you. I’ll show you my likeness one day. I was, faith. Lover, for her love he prowled with colonel Richard Burke, tanist of his sept, under the walls of Clerkenwell and, crouching, saw a flame of vengeance hurl them upward in the fog. Shattered glass and toppling masonry. In gay Paree he hides, Egan of Paris, unsought by any save by me. Making his day’s stations, the dingy printingcase, his three taverns, the Montmartre lair he sleeps short night in, rue de la Goutte-d’Or, damascened with flyblown faces of the gone. Loveless, landless, wifeless. She is quite nicey comfy without her outcast man, madame in rue Gît-le-Cœur, canary and two buck lodgers. Peachy cheeks, a zebra skirt, frisky as a young thing’s. Spurned and undespairing. Tell Pat you saw me, won’t you? I wanted to get poor Pat a job one time. Mon fils, soldier of France. I taught him to sing The boys of Kilkenny are stout roaring blades. Know that old lay? I taught Patrice that. Old Kilkenny: saint Canice, Strongbow’s castle on the Nore. Goes like this. O, O. He takes me, Napper Tandy, by the hand.

O, O the boys of
Kilkenny...

Weak wasting hand on mine. They have forgotten Kevin Egan, not he them. Remembering thee, O Sion.

He had come nearer the edge of the sea and wet sand slapped his boots. The new air greeted him, harping in wild nerves, wind of wild air of seeds of brightness. Here, I am not walking out to the Kish lightship, am I? He stood suddenly, his feet beginning to sink slowly in the quaking soil. Turn back.

Turning, he scanned the shore south, his feet sinking again slowly in new sockets. The cold domed room of the tower waits. Through the barbacans the shafts of light are moving ever, slowly ever as my feet are sinking, creeping duskward over the dial floor. Blue dusk, nightfall, deep blue night. In the darkness of the dome they wait, their pushedback chairs, my obelisk valise, around a board of abandoned platters. Who to clear it? He has the key. I will not sleep there when this night comes. A shut door of a silent tower, entombing their blind bodies, the panthersahib and his pointer. Call: no answer. He lifted his feet up from the suck and turned back by the mole of boulders. Take all, keep all. My soul walks with me, form of forms. So in the moon’s midwatches I pace the path above the rocks, in sable silvered, hearing Elsinore’s tempting flood.

The flood is following me. I can watch it flow past from here. Get back then by the Poolbeg road to the strand there. He climbed over the sedge and eely oarweeds and sat on a stool of rock, resting his ashplant in a grike.

A bloated carcass of a dog lay lolled on bladderwrack. Before him the gunwale of a boat, sunk in sand. Un coche ensablé Louis Veuillot called Gautier’s prose. These heavy sands are language tide and wind have silted here. And these, the stoneheaps of dead builders, a warren of weasel rats. Hide gold there. Try it. You have some. Sands and stones. Heavy of the past. Sir Lout’s toys. Mind you don’t get one bang on the ear. I’m the bloody well gigant rolls all them bloody well boulders, bones for my steppingstones. Feefawfum. I zmellz de bloodz odz an Iridzman.

A point, live dog, grew into sight running across the sweep of sand. Lord, is he going to attack me? Respect his liberty. You will not be master of others or their slave. I have my stick. Sit tight. From farther away, walking shoreward across from the crested tide, figures, two. The two maries. They have tucked it safe mong the bulrushes. Peekaboo. I see you. No, the dog. He is running back to them. Who?

Galleys of the Lochlanns ran here to beach, in quest of prey, their bloodbeaked prows riding low on a molten pewter surf. Dane vikings, torcs of tomahawks aglitter on their breasts when Malachi wore the collar of gold. A school of turlehide whales stranded in hot noon, spouting, hobbling in the shallows. Then from the starving cagework city a horde of jerkined dwarfs, my people, with flayers’ knives, running, scaling, hacking in green blubbery whalemeat. Famine, plague and slaughters. Their blood is in me, their lusts my waves. I moved among them on the frozen Liffey, that I, a changeling, among the spluttering resin fires. I spoke to no-one: none to me.

The dog’s bark ran towards him, stopped, ran back. Dog of my enemy. I just simply stood pale, silent, bayed about. Terribilia meditans. A primrose doublet, fortune’s knave, smiled on my fear. For that are you pining, the bark of their applause? Pretenders: live their lives. The Bruce’s brother, Thomas Fitzgerald, silken knight, Perkin Warbeck, York’s false scion, in breeches of silk of whiterose ivory, wonder of a day, and Lambert Simnel, with a tail of nans and sutlers, a scullion crowned. All kings’ sons. Paradise of pretenders then and now. He saved men from drowning and you shake at a cur’s yelping. But the courtiers who mocked Guido in Or san Michele were in their own house. House of... We don’t want any of your medieval abstrusiosities. Would you do what he did? A boat would be near, a lifebuoy. Natürlich, put there for you. Would you or would you not? The man that was drowned nine days ago off Maiden’s rock. They are waiting for him now. The truth, spit it out. I would want to. I would try. I am not a strong swimmer. Water cold soft. When I put my face into it in the basin at Clongowes. Can’t see! Who’s behind me? Out quickly, quickly! Do you see the tide flowing quickly in on all sides, sheeting the lows of sand quickly, shellcocoacoloured? If I had land under my feet. I want his life still to be his, mine to be mine. A drowning man. His human eyes scream to me out of horror of his death. I... With him together down... I could not save her. Waters: bitter death: lost.

A woman and a man. I see her skirties. Pinned up, I bet.

Their dog ambled about a bank of dwindling sand, trotting, sniffing on all sides. Looking for something lost in a past life. Suddenly he made off like a bounding hare, ears flung back, chasing the shadow of a lowskimming gull. The man’s shrieked whistle struck his limp ears. He turned, bounded back, came nearer, trotted on twinkling shanks. On a field tenney a buck, trippant, proper, unattired. At the lacefringe of the tide he halted with stiff forehoofs, seawardpointed ears. His snout lifted barked at the wavenoise, herds of seamorse. They serpented towards his feet, curling, unfurling many crests, every ninth, breaking, plashing, from far, from farther out, waves and waves.

Cocklepickers. They waded a little way in the water and, stooping, soused their bags and, lifting them again, waded out. The dog yelped running to them, reared up and pawed them, dropping on all fours, again reared up at them with mute bearish fawning. Unheeded he kept by them as they came towards the drier sand, a rag of wolf’s tongue redpanting from his jaws. His speckled body ambled ahead of them and then loped off at a calf’s gallop. The carcass lay on his path. He stopped, sniffed, stalked round it, brother, nosing closer, went round it, sniffling rapidly like a dog all over the dead dog’s bedraggled fell. Dogskull, dogsniff, eyes on the ground, moves to one great goal. Ah, poor dogsbody! Here lies poor dogsbody’s body.

—Tatters! Out of that, you mongrel!

The cry brought him skulking back to his master and a blunt bootless kick sent him unscathed across a spit of sand, crouched in flight. He slunk back in a curve. Doesn’t see me. Along by the edge of the mole he lolloped, dawdled, smelt a rock and from under a cocked hindleg pissed against it. He trotted forward and, lifting again his hindleg, pissed quick short at an unsmelt rock. The simple pleasures of the poor. His hindpaws then scattered the sand: then his forepaws dabbled and delved. Something he buried there, his grandmother. He rooted in the sand, dabbling, delving and stopped to listen to the air, scraped up the sand again with a fury of his claws, soon ceasing, a pard, a panther, got in spousebreach, vulturing the dead.

After he woke me last night same dream or was it? Wait. Open hallway. Street of harlots. Remember. Haroun al Raschid. I am almosting it. That man led me, spoke. I was not afraid. The melon he had he held against my face. Smiled: creamfruit smell. That was the rule, said. In. Come. Red carpet spread. You will see who.

Shouldering their bags they trudged, the red Egyptians. His blued feet out of turnedup trousers slapped the clammy sand, a dull brick muffler strangling his unshaven neck. With woman steps she followed: the ruffian and his strolling mort. Spoils slung at her back. Loose sand and shellgrit crusted her bare feet. About her windraw face hair trailed. Behind her lord, his helpmate, bing awast to Romeville. When night hides her body’s flaws calling under her brown shawl from an archway where dogs have mired. Her fancyman is treating two Royal Dublins in O’Loughlin’s of Blackpitts. Buss her, wap in rogues’ rum lingo, for, O, my dimber wapping dell! A shefiend’s whiteness under her rancid rags. Fumbally’s lane that night: the tanyard smells.

White thy fambles, red thy gan
And thy quarrons dainty is.
Couch a hogshead with me then.
In the darkmans clip and kiss.

Morose delectation Aquinas tunbelly calls this, frate porcospino. Unfallen Adam rode and not rutted. Call away let him: thy quarrons dainty is. Language no whit worse than his. Monkwords, marybeads jabber on their girdles: roguewords, tough nuggets patter in their pockets.

Passing now.

A side eye at my Hamlet hat. If I were suddenly naked here as I sit? I am not. Across the sands of all the world, followed by the sun’s flaming sword, to the west, trekking to evening lands. She trudges, schlepps, trains, drags, trascines her load. A tide westering, moondrawn, in her wake. Tides, myriadislanded, within her, blood not mine, oinopa ponton, a winedark sea. Behold the handmaid of the moon. In sleep the wet sign calls her hour, bids her rise. Bridebed, childbed, bed of death, ghostcandled. Omnis caro ad te veniet. He comes, pale vampire, through storm his eyes, his bat sails bloodying the sea, mouth to her mouth’s kiss.

Here. Put a pin in that chap, will you? My tablets. Mouth to her kiss. No. Must be two of em. Glue em well. Mouth to her mouth’s kiss.

His lips lipped and mouthed fleshless lips of air: mouth to her moomb. Oomb, allwombing tomb. His mouth moulded issuing breath, unspeeched: ooeeehah: roar of cataractic planets, globed, blazing, roaring wayawayawayawayaway. Paper. The banknotes, blast them. Old Deasy’s letter. Here. Thanking you for the hospitality tear the blank end off. Turning his back to the sun he bent over far to a table of rock and scribbled words. That’s twice I forgot to take slips from the library counter.

His shadow lay over the rocks as he bent, ending. Why not endless till the farthest star? Darkly they are there behind this light, darkness shining in the brightness, delta of Cassiopeia, worlds. Me sits there with his augur’s rod of ash, in borrowed sandals, by day beside a livid sea, unbeheld, in violet night walking beneath a reign of uncouth stars. I throw this ended shadow from me, manshape ineluctable, call it back. Endless, would it be mine, form of my form? Who watches me here? Who ever anywhere will read these written words? Signs on a white field. Somewhere to someone in your flutiest voice. The good bishop of Cloyne took the veil of the temple out of his shovel hat: veil of space with coloured emblems hatched on its field. Hold hard. Coloured on a flat: yes, that’s right. Flat I see, then think distance, near, far, flat I see, east, back. Ah, see now! Falls back suddenly, frozen in stereoscope. Click does the trick. You find my words dark. Darkness is in our souls do you not think? Flutier. Our souls, shamewounded by our sins, cling to us yet more, a woman to her lover clinging, the more the more.

She trusts me, her hand gentle, the longlashed eyes. Now where the blue hell am I bringing her beyond the veil? Into the ineluctable modality of the ineluctable visuality. She, she, she. What she? The virgin at Hodges Figgis’ window on Monday looking in for one of the alphabet books you were going to write. Keen glance you gave her. Wrist through the braided jesse of her sunshade. She lives in Leeson park with a grief and kickshaws, a lady of letters. Talk that to someone else, Stevie: a pickmeup. Bet she wears those curse of God stays suspenders and yellow stockings, darned with lumpy wool. Talk about apple dumplings, piuttosto. Where are your wits?

Touch me. Soft eyes. Soft soft soft hand. I am lonely here. O, touch me soon, now. What is that word known to all men? I am quiet here alone. Sad too. Touch, touch me.

He lay back at full stretch over the sharp rocks, cramming the scribbled note and pencil into a pocket, his hat tilted down on his eyes. That is Kevin Egan’s movement I made, nodding for his nap, sabbath sleep. Et vidit Deus. Et erant valde bona. Alo! Bonjour. Welcome as the flowers in May. Under its leaf he watched through peacocktwittering lashes the southing sun. I am caught in this burning scene. Pan’s hour, the faunal noon. Among gumheavy serpentplants, milkoozing fruits, where on the tawny waters leaves lie wide. Pain is far.

And no more turn aside and brood.

His gaze brooded on his broadtoed boots, a buck’s castoffs, nebeneinander. He counted the creases of rucked leather wherein another’s foot had nested warm. The foot that beat the ground in tripudium, foot I dislove. But you were delighted when Esther Osvalt’s shoe went on you: girl I knew in Paris. Tiens, quel petit pied! Staunch friend, a brother soul: Wilde’s love that dare not speak its name. His arm: Cranly’s arm. He now will leave me. And the blame? As I am. As I am. All or not at all.

In long lassoes from the Cock lake the water flowed full, covering greengoldenly lagoons of sand, rising, flowing. My ashplant will float away. I shall wait. No, they will pass on, passing, chafing against the low rocks, swirling, passing. Better get this job over quick. Listen: a fourworded wavespeech: seesoo, hrss, rsseeiss, ooos. Vehement breath of waters amid seasnakes, rearing horses, rocks. In cups of rocks it slops: flop, slop, slap: bounded in barrels. And, spent, its speech ceases. It flows purling, widely flowing, floating foampool, flower unfurling.

Under the upswelling tide he saw the writhing weeds lift languidly and sway reluctant arms, hising up their petticoats, in whispering water swaying and upturning coy silver fronds. Day by day: night by night: lifted, flooded and let fall. Lord, they are weary; and, whispered to, they sigh. Saint Ambrose heard it, sigh of leaves and waves, waiting, awaiting the fullness of their times, diebus ac noctibus iniurias patiens ingemiscit. To no end gathered; vainly then released, forthflowing, wending back: loom of the moon. Weary too in sight of lovers, lascivious men, a naked woman shining in her courts, she draws a toil of waters.

Five fathoms out there. Full fathom five thy father lies. At one, he said. Found drowned. High water at Dublin bar. Driving before it a loose drift of rubble, fanshoals of fishes, silly shells. A corpse rising saltwhite from the undertow, bobbing a pace a pace a porpoise landward. There he is. Hook it quick. Pull. Sunk though he be beneath the watery floor. We have him. Easy now.

Bag of corpsegas sopping in foul brine. A quiver of minnows, fat of a spongy titbit, flash through the slits of his buttoned trouserfly. God becomes man becomes fish becomes barnacle goose becomes featherbed mountain. Dead breaths I living breathe, tread dead dust, devour a urinous offal from all dead. Hauled stark over the gunwale he breathes upward the stench of his green grave, his leprous nosehole snoring to the sun.

A seachange this, brown eyes saltblue. Seadeath, mildest of all deaths known to man. Old Father Ocean. Prix de Paris: beware of imitations. Just you give it a fair trial. We enjoyed ourselves immensely.

Come. I thirst. Clouding over. No black clouds anywhere, are there? Thunderstorm. Allbright he falls, proud lightning of the intellect, Lucifer, dico, qui nescit occasum. No. My cockle hat and staff and hismy sandal shoon. Where? To evening lands. Evening will find itself.

He took the hilt of his ashplant, lunging with it softly, dallying still. Yes, evening will find itself in me, without me. All days make their end. By the way next when is it Tuesday will be the longest day. Of all the glad new year, mother, the rum tum tiddledy tum. Lawn Tennyson, gentleman poet. Già. For the old hag with the yellow teeth. And Monsieur Drumont, gentleman journalist. Già. My teeth are very bad. Why, I wonder. Feel. That one is going too. Shells. Ought I go to a dentist, I wonder, with that money? That one. This. Toothless Kinch, the superman. Why is that, I wonder, or does it mean something perhaps?

My handkerchief. He threw it. I remember. Did I not take it up?

His hand groped vainly in his pockets. No, I didn’t. Better buy one.

He laid the dry snot picked from his nostril on a ledge of rock, carefully. For the rest let look who will.

Behind. Perhaps there is someone.

He turned his face over a shoulder, rere regardant. Moving through the air high spars of a threemaster, her sails brailed up on the crosstrees, homing, upstream, silently moving, a silent ship.

## — II —
### [ 4 ]

Mr Leopold Bloom ate with relish the inner organs of beasts and fowls. He liked thick giblet soup, nutty gizzards, a stuffed roast heart, liverslices fried with crustcrumbs, fried hencods’ roes. Most of all he liked grilled mutton kidneys which gave to his palate a fine tang of faintly scented urine.

Kidneys were in his mind as he moved about the kitchen softly, righting her breakfast things on the humpy tray. Gelid light and air were in the kitchen but out of doors gentle summer morning everywhere. Made him feel a bit peckish.

The coals were reddening.

Another slice of bread and butter: three, four: right. She didn’t like her plate full. Right. He turned from the tray, lifted the kettle off the hob and set it sideways on the fire. It sat there, dull and squat, its spout stuck out. Cup of tea soon. Good. Mouth dry. The cat walked stiffly round a leg of the table with tail on high.

—Mkgnao!

—O, there you are, Mr Bloom said, turning from the fire.

The cat mewed in answer and stalked again stiffly round a leg of the table, mewing. Just how she stalks over my writingtable. Prr. Scratch my head. Prr.

Mr Bloom watched curiously, kindly the lithe black form. Clean to see: the gloss of her sleek hide, the white button under the butt of her tail, the green flashing eyes. He bent down to her, his hands on his knees.

—Milk for the pussens, he said.

—Mrkgnao! the cat cried.

They call them stupid. They understand what we say better than we understand them. She understands all she wants to. Vindictive too. Cruel. Her nature. Curious mice never squeal. Seem to like it. Wonder what I look like to her. Height of a tower? No, she can jump me.

—Afraid of the chickens she is, he said mockingly. Afraid of the chookchooks. I never saw such a stupid pussens as the pussens.

—Mrkrgnao! the cat said loudly.

She blinked up out of her avid shameclosing eyes, mewing plaintively and long, showing him her milkwhite teeth. He watched the dark eyeslits narrowing with greed till her eyes were green stones. Then he went to the dresser, took the jug Hanlon’s milkman had just filled for him, poured warmbubbled milk on a saucer and set it slowly on the floor.

—Gurrhr! she cried, running to lap.

He watched the bristles shining wirily in the weak light as she tipped three times and licked lightly. Wonder is it true if you clip them they can’t mouse after. Why? They shine in the dark, perhaps, the tips. Or kind of feelers in the dark, perhaps.

He listened to her licking lap. Ham and eggs, no. No good eggs with this drouth. Want pure fresh water. Thursday: not a good day either for a mutton kidney at Buckley’s. Fried with butter, a shake of pepper. Better a pork kidney at Dlugacz’s. While the kettle is boiling. She lapped slower, then licking the saucer clean. Why are their tongues so rough? To lap better, all porous holes. Nothing she can eat? He glanced round him. No.

On quietly creaky boots he went up the staircase to the hall, paused by the bedroom door. She might like something tasty. Thin bread and butter she likes in the morning. Still perhaps: once in a way.

He said softly in the bare hall:

—I’m going round the corner. Be back in a minute.

And when he had heard his voice say it he added:

—You don’t want anything for breakfast?

A sleepy soft grunt answered:

—Mn.

No. She didn’t want anything. He heard then a warm heavy sigh, softer, as she turned over and the loose brass quoits of the bedstead jingled. Must get those settled really. Pity. All the way from Gibraltar. Forgotten any little Spanish she knew. Wonder what her father gave for it. Old style. Ah yes! of course. Bought it at the governor’s auction. Got a short knock. Hard as nails at a bargain, old Tweedy. Yes, sir. At Plevna that was. I rose from the ranks, sir, and I’m proud of it. Still he had brains enough to make that corner in stamps. Now that was farseeing.

His hand took his hat from the peg over his initialled heavy overcoat and his lost property office secondhand waterproof. Stamps: stickyback pictures. Daresay lots of officers are in the swim too. Course they do. The sweated legend in the crown of his hat told him mutely: Plasto’s high grade ha. He peeped quickly inside the leather headband. White slip of paper. Quite safe.

On the doorstep he felt in his hip pocket for the latchkey. Not there. In the trousers I left off. Must get it. Potato I have. Creaky wardrobe. No use disturbing her. She turned over sleepily that time. He pulled the halldoor to after him very quietly, more, till the footleaf dropped gently over the threshold, a limp lid. Looked shut. All right till I come back anyhow.

He crossed to the bright side, avoiding the loose cellarflap of number seventyfive. The sun was nearing the steeple of George’s church. Be a warm day I fancy. Specially in these black clothes feel it more. Black conducts, reflects, (refracts is it?), the heat. But I couldn’t go in that light suit. Make a picnic of it. His eyelids sank quietly often as he walked in happy warmth. Boland’s breadvan delivering with trays our daily but she prefers yesterday’s loaves turnovers crisp crowns hot. Makes you feel young. Somewhere in the east: early morning: set off at dawn. Travel round in front of the sun, steal a day’s march on him. Keep it up for ever never grow a day older technically. Walk along a strand, strange land, come to a city gate, sentry there, old ranker too, old Tweedy’s big moustaches, leaning on a long kind of a spear. Wander through awned streets. Turbaned faces going by. Dark caves of carpet shops, big man, Turko the terrible, seated crosslegged, smoking a coiled pipe. Cries of sellers in the streets. Drink water scented with fennel, sherbet. Dander along all day. Might meet a robber or two. Well, meet him. Getting on to sundown. The shadows of the mosques among the pillars: priest with a scroll rolled up. A shiver of the trees, signal, the evening wind. I pass on. Fading gold sky. A mother watches me from her doorway. She calls her children home in their dark language. High wall: beyond strings twanged. Night sky, moon, violet, colour of Molly’s new garters. Strings. Listen. A girl playing one of those instruments what do you call them: dulcimers. I pass.

Probably not a bit like it really. Kind of stuff you read: in the track of the sun. Sunburst on the titlepage. He smiled, pleasing himself. What Arthur Griffith said about the headpiece over the Freeman leader: a homerule sun rising up in the northwest from the laneway behind the bank of Ireland. He prolonged his pleased smile. Ikey touch that: homerule sun rising up in the northwest.

He approached Larry O’Rourke’s. From the cellar grating floated up the flabby gush of porter. Through the open doorway the bar squirted out whiffs of ginger, teadust, biscuitmush. Good house, however: just the end of the city traffic. For instance M’Auley’s down there: n. g. as position. Of course if they ran a tramline along the North Circular from the cattlemarket to the quays value would go up like a shot.

Baldhead over the blind. Cute old codger. No use canvassing him for an ad. Still he knows his own business best. There he is, sure enough, my bold Larry, leaning against the sugarbin in his shirtsleeves watching the aproned curate swab up with mop and bucket. Simon Dedalus takes him off to a tee with his eyes screwed up. Do you know what I’m going to tell you? What’s that, Mr O’Rourke? Do you know what? The Russians, they’d only be an eight o’clock breakfast for the Japanese.

Stop and say a word: about the funeral perhaps. Sad thing about poor Dignam, Mr O’Rourke.

Turning into Dorset street he said freshly in greeting through the doorway:

—Good day, Mr O’Rourke.

—Good day to you.

—Lovely weather, sir.

—’Tis all that.

Where do they get the money? Coming up redheaded curates from the county Leitrim, rinsing empties and old man in the cellar. Then, lo and behold, they blossom out as Adam Findlaters or Dan Tallons. Then think of the competition. General thirst. Good puzzle would be cross Dublin without passing a pub. Save it they can’t. Off the drunks perhaps. Put down three and carry five. What is that, a bob here and there, dribs and drabs. On the wholesale orders perhaps. Doing a double shuffle with the town travellers. Square it you with the boss and we’ll split the job, see?

How much would that tot to off the porter in the month? Say ten barrels of stuff. Say he got ten per cent off. O more. Fifteen. He passed Saint Joseph’s National school. Brats’ clamour. Windows open. Fresh air helps memory. Or a lilt. Ahbeesee defeegee kelomen opeecue rustyouvee doubleyou. Boys are they? Yes. Inishturk. Inishark. Inishboffin. At their joggerfry. Mine. Slieve Bloom.

He halted before Dlugacz’s window, staring at the hanks of sausages, polonies, black and white. Fifteen multiplied by. The figures whitened in his mind, unsolved: displeased, he let them fade. The shiny links, packed with forcemeat, fed his gaze and he breathed in tranquilly the lukewarm breath of cooked spicy pigs’ blood.

A kidney oozed bloodgouts on the willowpatterned dish: the last. He stood by the nextdoor girl at the counter. Would she buy it too, calling the items from a slip in her hand? Chapped: washingsoda. And a pound and a half of Denny’s sausages. His eyes rested on her vigorous hips. Woods his name is. Wonder what he does. Wife is oldish. New blood. No followers allowed. Strong pair of arms. Whacking a carpet on the clothesline. She does whack it, by George. The way her crooked skirt swings at each whack.

The ferreteyed porkbutcher folded the sausages he had snipped off with blotchy fingers, sausagepink. Sound meat there: like a stallfed heifer.

He took a page up from the pile of cut sheets: the model farm at Kinnereth on the lakeshore of Tiberias. Can become ideal winter sanatorium. Moses Montefiore. I thought he was. Farmhouse, wall round it, blurred cattle cropping. He held the page from him: interesting: read it nearer, the title, the blurred cropping cattle, the page rustling. A young white heifer. Those mornings in the cattlemarket, the beasts lowing in their pens, branded sheep, flop and fall of dung, the breeders in hobnailed boots trudging through the litter, slapping a palm on a ripemeated hindquarter, there’s a prime one, unpeeled switches in their hands. He held the page aslant patiently, bending his senses and his will, his soft subject gaze at rest. The crooked skirt swinging, whack by whack by whack.

The porkbutcher snapped two sheets from the pile, wrapped up her prime sausages and made a red grimace.

—Now, my miss, he said.

She tendered a coin, smiling boldly, holding her thick wrist out.

—Thank you, my miss. And one shilling threepence change. For you, please?

Mr Bloom pointed quickly. To catch up and walk behind her if she went slowly, behind her moving hams. Pleasant to see first thing in the morning. Hurry up, damn it. Make hay while the sun shines. She stood outside the shop in sunlight and sauntered lazily to the right. He sighed down his nose: they never understand. Sodachapped hands. Crusted toenails too. Brown scapulars in tatters, defending her both ways. The sting of disregard glowed to weak pleasure within his breast. For another: a constable off duty cuddling her in Eccles’ Lane. They like them sizeable. Prime sausage. O please, Mr Policeman, I’m lost in the wood.

—Threepence, please.

His hand accepted the moist tender gland and slid it into a sidepocket. Then it fetched up three coins from his trousers’ pocket and laid them on the rubber prickles. They lay, were read quickly and quickly slid, disc by disc, into the till.

—Thank you, sir. Another time.

A speck of eager fire from foxeyes thanked him. He withdrew his gaze after an instant. No: better not: another time.

—Good morning, he said, moving away.

—Good morning, sir.

No sign. Gone. What matter?

He walked back along Dorset street, reading gravely. Agendath Netaim: planters’ company. To purchase waste sandy tracts from Turkish government and plant with eucalyptus trees. Excellent for shade, fuel and construction. Orangegroves and immense melonfields north of Jaffa. You pay eighty marks and they plant a dunam of land for you with olives, oranges, almonds or citrons. Olives cheaper: oranges need artificial irrigation. Every year you get a sending of the crop. Your name entered for life as owner in the book of the union. Can pay ten down and the balance in yearly instalments. Bleibtreustrasse 34, Berlin, W. 15.

Nothing doing. Still an idea behind it.

He looked at the cattle, blurred in silver heat. Silverpowdered olivetrees. Quiet long days: pruning, ripening. Olives are packed in jars, eh? I have a few left from Andrews. Molly spitting them out. Knows the taste of them now. Oranges in tissue paper packed in crates. Citrons too. Wonder is poor Citron still in Saint Kevin’s parade. And Mastiansky with the old cither. Pleasant evenings we had then. Molly in Citron’s basketchair. Nice to hold, cool waxen fruit, hold in the hand, lift it to the nostrils and smell the perfume. Like that, heavy, sweet, wild perfume. Always the same, year after year. They fetched high prices too, Moisel told me. Arbutus place: Pleasants street: pleasant old times. Must be without a flaw, he said. Coming all that way: Spain, Gibraltar, Mediterranean, the Levant. Crates lined up on the quayside at Jaffa, chap ticking them off in a book, navvies handling them barefoot in soiled dungarees. There’s whatdoyoucallhim out of. How do you? Doesn’t see. Chap you know just to salute bit of a bore. His back is like that Norwegian captain’s. Wonder if I’ll meet him today. Watering cart. To provoke the rain. On earth as it is in heaven.

A cloud began to cover the sun slowly, wholly. Grey. Far.

No, not like that. A barren land, bare waste. Vulcanic lake, the dead sea: no fish, weedless, sunk deep in the earth. No wind could lift those waves, grey metal, poisonous foggy waters. Brimstone they called it raining down: the cities of the plain: Sodom, Gomorrah, Edom. All dead names. A dead sea in a dead land, grey and old. Old now. It bore the oldest, the first race. A bent hag crossed from Cassidy’s, clutching a naggin bottle by the neck. The oldest people. Wandered far away over all the earth, captivity to captivity, multiplying, dying, being born everywhere. It lay there now. Now it could bear no more. Dead: an old woman’s: the grey sunken cunt of the world.

Desolation.

Grey horror seared his flesh. Folding the page into his pocket he turned into Eccles street, hurrying homeward. Cold oils slid along his veins, chilling his blood: age crusting him with a salt cloak. Well, I am here now. Yes, I am here now. Morning mouth bad images. Got up wrong side of the bed. Must begin again those Sandow’s exercises. On the hands down. Blotchy brown brick houses. Number eighty still unlet. Why is that? Valuation is only twentyeight. Towers, Battersby, North, MacArthur: parlour windows plastered with bills. Plasters on a sore eye. To smell the gentle smoke of tea, fume of the pan, sizzling butter. Be near her ample bedwarmed flesh. Yes, yes.

Quick warm sunlight came running from Berkeley road, swiftly, in slim sandals, along the brightening footpath. Runs, she runs to meet me, a girl with gold hair on the wind.

Two letters and a card lay on the hallfloor. He stooped and gathered them. Mrs Marion Bloom. His quickened heart slowed at once. Bold hand. Mrs Marion.

—Poldy!

Entering the bedroom he halfclosed his eyes and walked through warm yellow twilight towards her tousled head.

—Who are the letters for?

He looked at them. Mullingar. Milly.

—A letter for me from Milly, he said carefully, and a card to you. And a letter for you.

He laid her card and letter on the twill bedspread near the curve of her knees.

—Do you want the blind up?

Letting the blind up by gentle tugs halfway his backward eye saw her glance at the letter and tuck it under her pillow.

—That do? he asked, turning.

She was reading the card, propped on her elbow.

—She got the things, she said.

He waited till she had laid the card aside and curled herself back slowly with a snug sigh.

—Hurry up with that tea, she said. I’m parched.

—The kettle is boiling, he said.

But he delayed to clear the chair: her striped petticoat, tossed soiled linen: and lifted all in an armful on to the foot of the bed.

As he went down the kitchen stairs she called:

—Poldy!

—What?

—Scald the teapot.

On the boil sure enough: a plume of steam from the spout. He scalded and rinsed out the teapot and put in four full spoons of tea, tilting the kettle then to let the water flow in. Having set it to draw he took off the kettle, crushed the pan flat on the live coals and watched the lump of butter slide and melt. While he unwrapped the kidney the cat mewed hungrily against him. Give her too much meat she won’t mouse. Say they won’t eat pork. Kosher. Here. He let the bloodsmeared paper fall to her and dropped the kidney amid the sizzling butter sauce. Pepper. He sprinkled it through his fingers ringwise from the chipped eggcup.

Then he slit open his letter, glancing down the page and over. Thanks: new tam: Mr Coghlan: lough Owel picnic: young student: Blazes Boylan’s seaside girls.

The tea was drawn. He filled his own moustachecup, sham crown Derby, smiling. Silly Milly’s birthday gift. Only five she was then. No, wait: four. I gave her the amberoid necklace she broke. Putting pieces of folded brown paper in the letterbox for her. He smiled, pouring.

O, Milly Bloom, you are my darling.
You are my lookingglass from night to morning.
I’d rather have you without a farthing
Than Katey Keogh with her ass and garden.

Poor old professor Goodwin. Dreadful old case. Still he was a courteous old chap. Oldfashioned way he used to bow Molly off the platform. And the little mirror in his silk hat. The night Milly brought it into the parlour. O, look what I found in professor Goodwin’s hat! All we laughed. Sex breaking out even then. Pert little piece she was.

He prodded a fork into the kidney and slapped it over: then fitted the teapot on the tray. Its hump bumped as he took it up. Everything on it? Bread and butter, four, sugar, spoon, her cream. Yes. He carried it upstairs, his thumb hooked in the teapot handle.

Nudging the door open with his knee he carried the tray in and set it on the chair by the bedhead.

—What a time you were! she said.

She set the brasses jingling as she raised herself briskly, an elbow on the pillow. He looked calmly down on her bulk and between her large soft bubs, sloping within her nightdress like a shegoat’s udder. The warmth of her couched body rose on the air, mingling with the fragrance of the tea she poured.

A strip of torn envelope peeped from under the dimpled pillow. In the act of going he stayed to straighten the bedspread.

—Who was the letter from? he asked.

Bold hand. Marion.

—O, Boylan, she said. He’s bringing the programme.

—What are you singing?

—Là ci darem with J. C. Doyle, she said, and Love’s Old Sweet Song.

Her full lips, drinking, smiled. Rather stale smell that incense leaves next day. Like foul flowerwater.

—Would you like the window open a little?

She doubled a slice of bread into her mouth, asking:

—What time is the funeral?

—Eleven, I think, he answered. I didn’t see the paper.

Following the pointing of her finger he took up a leg of her soiled drawers from the bed. No? Then, a twisted grey garter looped round a stocking: rumpled, shiny sole.

—No: that book.

Other stocking. Her petticoat.

—It must have fell down, she said.

He felt here and there. Voglio e non vorrei. Wonder if she pronounces that right: voglio. Not in the bed. Must have slid down. He stooped and lifted the valance. The book, fallen, sprawled against the bulge of the orangekeyed chamberpot.

—Show here, she said. I put a mark in it. There’s a word I wanted to ask you.

She swallowed a draught of tea from her cup held by nothandle and, having wiped her fingertips smartly on the blanket, began to search the text with the hairpin till she reached the word.

—Met him what? he asked.

—Here, she said. What does that mean?

He leaned downward and read near her polished thumbnail.

—Metempsychosis?

—Yes. Who’s he when he’s at home?

—Metempsychosis, he said, frowning. It’s Greek: from the Greek. That means the transmigration of souls.

—O, rocks! she said. Tell us in plain words.

He smiled, glancing askance at her mocking eyes. The same young eyes. The first night after the charades. Dolphin’s Barn. He turned over the smudged pages. Ruby: the Pride of the Ring. Hello. Illustration. Fierce Italian with carriagewhip. Must be Ruby pride of the on the floor naked. Sheet kindly lent. The monster Maffei desisted and flung his victim from him with an oath. Cruelty behind it all. Doped animals. Trapeze at Hengler’s. Had to look the other way. Mob gaping. Break your neck and we’ll break our sides. Families of them. Bone them young so they metamspychosis. That we live after death. Our souls. That a man’s soul after he dies. Dignam’s soul...

—Did you finish it? he asked.

—Yes, she said. There’s nothing smutty in it. Is she in love with the first fellow all the time?

—Never read it. Do you want another?

—Yes. Get another of Paul de Kock’s. Nice name he has.

She poured more tea into her cup, watching it flow sideways.

Must get that Capel street library book renewed or they’ll write to Kearney, my guarantor. Reincarnation: that’s the word.

—Some people believe, he said, that we go on living in another body after death, that we lived before. They call it reincarnation. That we all lived before on the earth thousands of years ago or some other planet. They say we have forgotten it. Some say they remember their past lives.

The sluggish cream wound curdling spirals through her tea. Better remind her of the word: metempsychosis. An example would be better. An example?

The Bath of the Nymph over the bed. Given away with the Easter number of Photo Bits: Splendid masterpiece in art colours. Tea before you put milk in. Not unlike her with her hair down: slimmer. Three and six I gave for the frame. She said it would look nice over the bed. Naked nymphs: Greece: and for instance all the people that lived then.

He turned the pages back.

—Metempsychosis, he said, is what the ancient Greeks called it. They used to believe you could be changed into an animal or a tree, for instance. What they called nymphs, for example.

Her spoon ceased to stir up the sugar. She gazed straight before her, inhaling through her arched nostrils.

—There’s a smell of burn, she said. Did you leave anything on the fire?

—The kidney! he cried suddenly.

He fitted the book roughly into his inner pocket and, stubbing his toes against the broken commode, hurried out towards the smell, stepping hastily down the stairs with a flurried stork’s legs. Pungent smoke shot up in an angry jet from a side of the pan. By prodding a prong of the fork under the kidney he detached it and turned it turtle on its back. Only a little burnt. He tossed it off the pan on to a plate and let the scanty brown gravy trickle over it.

Cup of tea now. He sat down, cut and buttered a slice of the loaf. He shore away the burnt flesh and flung it to the cat. Then he put a forkful into his mouth, chewing with discernment the toothsome pliant meat. Done to a turn. A mouthful of tea. Then he cut away dies of bread, sopped one in the gravy and put it in his mouth. What was that about some young student and a picnic? He creased out the letter at his side, reading it slowly as he chewed, sopping another die of bread in the gravy and raising it to his mouth.


Dearest Papli

Thanks ever so much for the lovely birthday present. It suits me splendid. Everyone says I am quite the belle in my new tam. I got mummy’s lovely box of creams and am writing. They are lovely. I am getting on swimming in the photo business now. Mr Coghlan took one of me and Mrs. Will send when developed. We did great biz yesterday. Fair day and all the beef to the heels were in. We are going to lough Owel on Monday with a few friends to make a scrap picnic. Give my love to mummy and to yourself a big kiss and thanks. I hear them at the piano downstairs. There is to be a concert in the Greville Arms on Saturday. There is a young student comes here some evenings named Bannon his cousins or something are big swells and he sings Boylan’s (I was on the pop of writing Blazes Boylan’s) song about those seaside girls. Tell him silly Milly sends my best respects. I must now close with fondest love

                    Your fond daughter

                        Milly

P. S. Excuse bad writing am in hurry. Byby.

                        M.


Fifteen yesterday. Curious, fifteenth of the month too. Her first birthday away from home. Separation. Remember the summer morning she was born, running to knock up Mrs Thornton in Denzille street. Jolly old woman. Lot of babies she must have helped into the world. She knew from the first poor little Rudy wouldn’t live. Well, God is good, sir. She knew at once. He would be eleven now if he had lived.

His vacant face stared pityingly at the postscript. Excuse bad writing. Hurry. Piano downstairs. Coming out of her shell. Row with her in the XL Café about the bracelet. Wouldn’t eat her cakes or speak or look. Saucebox. He sopped other dies of bread in the gravy and ate piece after piece of kidney. Twelve and six a week. Not much. Still, she might do worse. Music hall stage. Young student. He drank a draught of cooler tea to wash down his meal. Then he read the letter again: twice.

O, well: she knows how to mind herself. But if not? No, nothing has happened. Of course it might. Wait in any case till it does. A wild piece of goods. Her slim legs running up the staircase. Destiny. Ripening now. Vain: very.

He smiled with troubled affection at the kitchen window. Day I caught her in the street pinching her cheeks to make them red. Anemic a little. Was given milk too long. On the Erin’s King that day round the Kish. Damned old tub pitching about. Not a bit funky. Her pale blue scarf loose in the wind with her hair.

All dimpled cheeks and curls,
Your head it simply swirls.

Seaside girls. Torn envelope. Hands stuck in his trousers’ pockets, jarvey off for the day, singing. Friend of the family. Swurls, he says. Pier with lamps, summer evening, band.

Those girls, those girls,
Those lovely seaside girls.

Milly too. Young kisses: the first. Far away now past. Mrs Marion. Reading, lying back now, counting the strands of her hair, smiling, braiding.

A soft qualm, regret, flowed down his backbone, increasing. Will happen, yes. Prevent. Useless: can’t move. Girl’s sweet light lips. Will happen too. He felt the flowing qualm spread over him. Useless to move now. Lips kissed, kissing, kissed. Full gluey woman’s lips.

Better where she is down there: away. Occupy her. Wanted a dog to pass the time. Might take a trip down there. August bank holiday, only two and six return. Six weeks off, however. Might work a press pass. Or through M’Coy.

The cat, having cleaned all her fur, returned to the meatstained paper, nosed at it and stalked to the door. She looked back at him, mewing. Wants to go out. Wait before a door sometime it will open. Let her wait. Has the fidgets. Electric. Thunder in the air. Was washing at her ear with her back to the fire too.

He felt heavy, full: then a gentle loosening of his bowels. He stood up, undoing the waistband of his trousers. The cat mewed to him.

—Miaow! he said in answer. Wait till I’m ready.

Heaviness: hot day coming. Too much trouble to fag up the stairs to the landing.

A paper. He liked to read at stool. Hope no ape comes knocking just as I’m.

In the tabledrawer he found an old number of Titbits. He folded it under his armpit, went to the door and opened it. The cat went up in soft bounds. Ah, wanted to go upstairs, curl up in a ball on the bed.

Listening, he heard her voice:

—Come, come, pussy. Come.

He went out through the backdoor into the garden: stood to listen towards the next garden. No sound. Perhaps hanging clothes out to dry. The maid was in the garden. Fine morning.

He bent down to regard a lean file of spearmint growing by the wall. Make a summerhouse here. Scarlet runners. Virginia creepers. Want to manure the whole place over, scabby soil. A coat of liver of sulphur. All soil like that without dung. Household slops. Loam, what is this that is? The hens in the next garden: their droppings are very good top dressing. Best of all though are the cattle, especially when they are fed on those oilcakes. Mulch of dung. Best thing to clean ladies’ kid gloves. Dirty cleans. Ashes too. Reclaim the whole place. Grow peas in that corner there. Lettuce. Always have fresh greens then. Still gardens have their drawbacks. That bee or bluebottle here Whitmonday.

He walked on. Where is my hat, by the way? Must have put it back on the peg. Or hanging up on the floor. Funny I don’t remember that. Hallstand too full. Four umbrellas, her raincloak. Picking up the letters. Drago’s shopbell ringing. Queer I was just thinking that moment. Brown brillantined hair over his collar. Just had a wash and brushup. Wonder have I time for a bath this morning. Tara street. Chap in the paybox there got away James Stephens, they say. O’Brien.

Deep voice that fellow Dlugacz has. Agendath what is it? Now, my miss. Enthusiast.

He kicked open the crazy door of the jakes. Better be careful not to get these trousers dirty for the funeral. He went in, bowing his head under the low lintel. Leaving the door ajar, amid the stench of mouldy limewash and stale cobwebs he undid his braces. Before sitting down he peered through a chink up at the nextdoor windows. The king was in his countinghouse. Nobody.

Asquat on the cuckstool he folded out his paper, turning its pages over on his bared knees. Something new and easy. No great hurry. Keep it a bit. Our prize titbit: Matcham’s Masterstroke. Written by Mr Philip Beaufoy, Playgoers’ Club, London. Payment at the rate of one guinea a column has been made to the writer. Three and a half. Three pounds three. Three pounds, thirteen and six.

Quietly he read, restraining himself, the first column and, yielding but resisting, began the second. Midway, his last resistance yielding, he allowed his bowels to ease themselves quietly as he read, reading still patiently that slight constipation of yesterday quite gone. Hope it’s not too big bring on piles again. No, just right. So. Ah! Costive. One tabloid of cascara sagrada. Life might be so. It did not move or touch him but it was something quick and neat. Print anything now. Silly season. He read on, seated calm above his own rising smell. Neat certainly. Matcham often thinks of the masterstroke by which he won the laughing witch who now. Begins and ends morally. Hand in hand. Smart. He glanced back through what he had read and, while feeling his water flow quietly, he envied kindly Mr Beaufoy who had written it and received payment of three pounds, thirteen and six.

Might manage a sketch. By Mr and Mrs L. M. Bloom. Invent a story for some proverb. Which? Time I used to try jotting down on my cuff what she said dressing. Dislike dressing together. Nicked myself shaving. Biting her nether lip, hooking the placket of her skirt. Timing her. 9.15. Did Roberts pay you yet? 9.20. What had Gretta Conroy on? 9.23. What possessed me to buy this comb? 9.24. I’m swelled after that cabbage. A speck of dust on the patent leather of her boot.

Rubbing smartly in turn each welt against her stockinged calf. Morning after the bazaar dance when May’s band played Ponchielli’s dance of the hours. Explain that: morning hours, noon, then evening coming on, then night hours. Washing her teeth. That was the first night. Her head dancing. Her fansticks clicking. Is that Boylan well off? He has money. Why? I noticed he had a good rich smell off his breath dancing. No use humming then. Allude to it. Strange kind of music that last night. The mirror was in shadow. She rubbed her handglass briskly on her woollen vest against her full wagging bub. Peering into it. Lines in her eyes. It wouldn’t pan out somehow.

Evening hours, girls in grey gauze. Night hours then: black with daggers and eyemasks. Poetical idea: pink, then golden, then grey, then black. Still, true to life also. Day: then the night.

He tore away half the prize story sharply and wiped himself with it. Then he girded up his trousers, braced and buttoned himself. He pulled back the jerky shaky door of the jakes and came forth from the gloom into the air.

In the bright light, lightened and cooled in limb, he eyed carefully his black trousers: the ends, the knees, the houghs of the knees. What time is the funeral? Better find out in the paper.

A creak and a dark whirr in the air high up. The bells of George’s church. They tolled the hour: loud dark iron.

Heigho! Heigho!
Heigho! Heigho!
Heigho! Heigho!

Quarter to. There again: the overtone following through the air. A third.

Poor Dignam!

### [ 5 ]
By lorries along sir John Rogerson’s quay Mr Bloom walked soberly, past Windmill lane, Leask’s the linseed crusher, the postal telegraph office. Could have given that address too. And past the sailors’ home. He turned from the morning noises of the quayside and walked through Lime street. By Brady’s cottages a boy for the skins lolled, his bucket of offal linked, smoking a chewed fagbutt. A smaller girl with scars of eczema on her forehead eyed him, listlessly holding her battered caskhoop. Tell him if he smokes he won’t grow. O let him! His life isn’t such a bed of roses. Waiting outside pubs to bring da home. Come home to ma, da. Slack hour: won’t be many there. He crossed Townsend street, passed the frowning face of Bethel. El, yes: house of: Aleph, Beth. And past Nichols’ the undertaker. At eleven it is. Time enough. Daresay Corny Kelleher bagged the job for O’Neill’s. Singing with his eyes shut. Corny. Met her once in the park. In the dark. What a lark. Police tout. Her name and address she then told with my tooraloom tooraloom tay. O, surely he bagged it. Bury him cheap in a whatyoumaycall. With my tooraloom, tooraloom, tooraloom, tooraloom.

In Westland row he halted before the window of the Belfast and Oriental Tea Company and read the legends of leadpapered packets: choice blend, finest quality, family tea. Rather warm. Tea. Must get some from Tom Kernan. Couldn’t ask him at a funeral, though. While his eyes still read blandly he took off his hat quietly inhaling his hairoil and sent his right hand with slow grace over his brow and hair. Very warm morning. Under their dropped lids his eyes found the tiny bow of the leather headband inside his high grade ha. Just there. His right hand came down into the bowl of his hat. His fingers found quickly a card behind the headband and transferred it to his waistcoat pocket.

So warm. His right hand once more more slowly went over his brow and hair. Then he put on his hat again, relieved: and read again: choice blend, made of the finest Ceylon brands. The far east. Lovely spot it must be: the garden of the world, big lazy leaves to float about on, cactuses, flowery meads, snaky lianas they call them. Wonder is it like that. Those Cinghalese lobbing about in the sun in dolce far niente, not doing a hand’s turn all day. Sleep six months out of twelve. Too hot to quarrel. Influence of the climate. Lethargy. Flowers of idleness. The air feeds most. Azotes. Hothouse in Botanic gardens. Sensitive plants. Waterlilies. Petals too tired to. Sleeping sickness in the air. Walk on roseleaves. Imagine trying to eat tripe and cowheel. Where was the chap I saw in that picture somewhere? Ah yes, in the dead sea floating on his back, reading a book with a parasol open. Couldn’t sink if you tried: so thick with salt. Because the weight of the water, no, the weight of the body in the water is equal to the weight of the what? Or is it the volume is equal to the weight? It’s a law something like that. Vance in High school cracking his fingerjoints, teaching. The college curriculum. Cracking curriculum. What is weight really when you say the weight? Thirtytwo feet per second per second. Law of falling bodies: per second per second. They all fall to the ground. The earth. It’s the force of gravity of the earth is the weight.

He turned away and sauntered across the road. How did she walk with her sausages? Like that something. As he walked he took the folded Freeman from his sidepocket, unfolded it, rolled it lengthwise in a baton and tapped it at each sauntering step against his trouserleg. Careless air: just drop in to see. Per second per second. Per second for every second it means. From the curbstone he darted a keen glance through the door of the postoffice. Too late box. Post here. No-one. In.

He handed the card through the brass grill.

—Are there any letters for me? he asked.

While the postmistress searched a pigeonhole he gazed at the recruiting poster with soldiers of all arms on parade: and held the tip of his baton against his nostrils, smelling freshprinted rag paper. No answer probably. Went too far last time.

The postmistress handed him back through the grill his card with a letter. He thanked her and glanced rapidly at the typed envelope.

Henry Flower Esq,
c/o P. O. Westland Row,
            City.

Answered anyhow. He slipped card and letter into his sidepocket, reviewing again the soldiers on parade. Where’s old Tweedy’s regiment? Castoff soldier. There: bearskin cap and hackle plume. No, he’s a grenadier. Pointed cuffs. There he is: royal Dublin fusiliers. Redcoats. Too showy. That must be why the women go after them. Uniform. Easier to enlist and drill. Maud Gonne’s letter about taking them off O’Connell street at night: disgrace to our Irish capital. Griffith’s paper is on the same tack now: an army rotten with venereal disease: overseas or halfseasover empire. Half baked they look: hypnotised like. Eyes front. Mark time. Table: able. Bed: ed. The King’s own. Never see him dressed up as a fireman or a bobby. A mason, yes.

He strolled out of the postoffice and turned to the right. Talk: as if that would mend matters. His hand went into his pocket and a forefinger felt its way under the flap of the envelope, ripping it open in jerks. Women will pay a lot of heed, I don’t think. His fingers drew forth the letter the letter and crumpled the envelope in his pocket. Something pinned on: photo perhaps. Hair? No.

M’Coy. Get rid of him quickly. Take me out of my way. Hate company when you.

—Hello, Bloom. Where are you off to?

—Hello, M’Coy. Nowhere in particular.

—How’s the body?

—Fine. How are you?

—Just keeping alive, M’Coy said.

His eyes on the black tie and clothes he asked with low respect:

—Is there any... no trouble I hope? I see you’re...

—O, no, Mr Bloom said. Poor Dignam, you know. The funeral is today.

—To be sure, poor fellow. So it is. What time?

A photo it isn’t. A badge maybe.

—E...eleven, Mr Bloom answered.

—I must try to get out there, M’Coy said. Eleven, is it? I only heard it last night. Who was telling me? Holohan. You know Hoppy?

—I know.

Mr Bloom gazed across the road at the outsider drawn up before the door of the Grosvenor. The porter hoisted the valise up on the well. She stood still, waiting, while the man, husband, brother, like her, searched his pockets for change. Stylish kind of coat with that roll collar, warm for a day like this, looks like blanketcloth. Careless stand of her with her hands in those patch pockets. Like that haughty creature at the polo match. Women all for caste till you touch the spot. Handsome is and handsome does. Reserved about to yield. The honourable Mrs and Brutus is an honourable man. Possess her once take the starch out of her.

—I was with Bob Doran, he’s on one of his periodical bends, and what do you call him Bantam Lyons. Just down there in Conway’s we were.

Doran Lyons in Conway’s. She raised a gloved hand to her hair. In came Hoppy. Having a wet. Drawing back his head and gazing far from beneath his vailed eyelids he saw the bright fawn skin shine in the glare, the braided drums. Clearly I can see today. Moisture about gives long sight perhaps. Talking of one thing or another. Lady’s hand. Which side will she get up?

—And he said: Sad thing about our poor friend Paddy! What Paddy? I said. Poor little Paddy Dignam, he said.

Off to the country: Broadstone probably. High brown boots with laces dangling. Wellturned foot. What is he foostering over that change for? Sees me looking. Eye out for other fellow always. Good fallback. Two strings to her bow.

—Why? I said. What’s wrong with him? I said.

Proud: rich: silk stockings.

—Yes, Mr Bloom said.

He moved a little to the side of M’Coy’s talking head. Getting up in a minute.

—What’s wrong with him? He said. He’s dead, he said. And, faith, he filled up. Is it Paddy Dignam? I said. I couldn’t believe it when I heard it. I was with him no later than Friday last or Thursday was it in the Arch. Yes, he said. He’s gone. He died on Monday, poor fellow.

Watch! Watch! Silk flash rich stockings white. Watch!

A heavy tramcar honking its gong slewed between.

Lost it. Curse your noisy pugnose. Feels locked out of it. Paradise and the peri. Always happening like that. The very moment. Girl in Eustace street hallway Monday was it settling her garter. Her friend covering the display of. Esprit de corps. Well, what are you gaping at?

—Yes, yes, Mr Bloom said after a dull sigh. Another gone.

—One of the best, M’Coy said.

The tram passed. They drove off towards the Loop Line bridge, her rich gloved hand on the steel grip. Flicker, flicker: the laceflare of her hat in the sun: flicker, flick.

—Wife well, I suppose? M’Coy’s changed voice said.

—O, yes, Mr Bloom said. Tiptop, thanks.

He unrolled the newspaper baton idly and read idly:

What is home without
Plumtree’s Potted Meat?
Incomplete.
With it an abode of bliss.

—My missus has just got an engagement. At least it’s not settled yet.

Valise tack again. By the way no harm. I’m off that, thanks.

Mr Bloom turned his largelidded eyes with unhasty friendliness.

—My wife too, he said. She’s going to sing at a swagger affair in the Ulster Hall, Belfast, on the twentyfifth.

—That so? M’Coy said. Glad to hear that, old man. Who’s getting it up?

Mrs Marion Bloom. Not up yet. Queen was in her bedroom eating bread and. No book. Blackened court cards laid along her thigh by sevens. Dark lady and fair man. Letter. Cat furry black ball. Torn strip of envelope.

Love’s
Old
Sweet
Song
Comes lo-ove’s old...

—It’s a kind of a tour, don’t you see, Mr Bloom said thoughtfully. Sweeeet song. There’s a committee formed. Part shares and part profits.

M’Coy nodded, picking at his moustache stubble.

—O, well, he said. That’s good news.

He moved to go.

—Well, glad to see you looking fit, he said. Meet you knocking around.

—Yes, Mr Bloom said.

—Tell you what, M’Coy said. You might put down my name at the funeral, will you? I’d like to go but I mightn’t be able, you see. There’s a drowning case at Sandycove may turn up and then the coroner and myself would have to go down if the body is found. You just shove in my name if I’m not there, will you?

—I’ll do that, Mr Bloom said, moving to get off. That’ll be all right.

—Right, M’Coy said brightly. Thanks, old man. I’d go if I possibly could. Well, tolloll. Just C. P. M’Coy will do.

—That will be done, Mr Bloom answered firmly.

Didn’t catch me napping that wheeze. The quick touch. Soft mark. I’d like my job. Valise I have a particular fancy for. Leather. Capped corners, rivetted edges, double action lever lock. Bob Cowley lent him his for the Wicklow regatta concert last year and never heard tidings of it from that good day to this.

Mr Bloom, strolling towards Brunswick street, smiled. My missus has just got an. Reedy freckled soprano. Cheeseparing nose. Nice enough in its way: for a little ballad. No guts in it. You and me, don’t you know: in the same boat. Softsoaping. Give you the needle that would. Can’t he hear the difference? Think he’s that way inclined a bit. Against my grain somehow. Thought that Belfast would fetch him. I hope that smallpox up there doesn’t get worse. Suppose she wouldn’t let herself be vaccinated again. Your wife and my wife.

Wonder is he pimping after me?

Mr Bloom stood at the corner, his eyes wandering over the multicoloured hoardings. Cantrell and Cochrane’s Ginger Ale (Aromatic). Clery’s Summer Sale. No, he’s going on straight. Hello. Leah tonight. Mrs Bandmann Palmer. Like to see her again in that. Hamlet she played last night. Male impersonator. Perhaps he was a woman. Why Ophelia committed suicide. Poor papa! How he used to talk of Kate Bateman in that. Outside the Adelphi in London waited all the afternoon to get in. Year before I was born that was: sixtyfive. And Ristori in Vienna. What is this the right name is? By Mosenthal it is. Rachel, is it? No. The scene he was always talking about where the old blind Abraham recognises the voice and puts his fingers on his face.

Nathan’s voice! His son’s voice! I hear the voice of Nathan who left his father to die of grief and misery in my arms, who left the house of his father and left the God of his father.

Every word is so deep, Leopold.

Poor papa! Poor man! I’m glad I didn’t go into the room to look at his face. That day! O, dear! O, dear! Ffoo! Well, perhaps it was best for him.

Mr Bloom went round the corner and passed the drooping nags of the hazard. No use thinking of it any more. Nosebag time. Wish I hadn’t met that M’Coy fellow.

He came nearer and heard a crunching of gilded oats, the gently champing teeth. Their full buck eyes regarded him as he went by, amid the sweet oaten reek of horsepiss. Their Eldorado. Poor jugginses! Damn all they know or care about anything with their long noses stuck in nosebags. Too full for words. Still they get their feed all right and their doss. Gelded too: a stump of black guttapercha wagging limp between their haunches. Might be happy all the same that way. Good poor brutes they look. Still their neigh can be very irritating.

He drew the letter from his pocket and folded it into the newspaper he carried. Might just walk into her here. The lane is safer.

He passed the cabman’s shelter. Curious the life of drifting cabbies. All weathers, all places, time or setdown, no will of their own. Voglio e non. Like to give them an odd cigarette. Sociable. Shout a few flying syllables as they pass. He hummed:

Là ci darem la mano
La la lala la la.

He turned into Cumberland street and, going on some paces, halted in the lee of the station wall. No-one. Meade’s timberyard. Piled balks. Ruins and tenements. With careful tread he passed over a hopscotch court with its forgotten pickeystone. Not a sinner. Near the timberyard a squatted child at marbles, alone, shooting the taw with a cunnythumb. A wise tabby, a blinking sphinx, watched from her warm sill. Pity to disturb them. Mohammed cut a piece out of his mantle not to wake her. Open it. And once I played marbles when I went to that old dame’s school. She liked mignonette. Mrs Ellis’s. And Mr? He opened the letter within the newspaper.

A flower. I think it’s a. A yellow flower with flattened petals. Not annoyed then? What does she say?


Dear Henry

I got your last letter to me and thank you very much for it. I am sorry you did not like my last letter. Why did you enclose the stamps? I am awfully angry with you. I do wish I could punish you for that. I called you naughty boy because I do not like that other world. Please tell me what is the real meaning of that word? Are you not happy in your home you poor little naughty boy? I do wish I could do something for you. Please tell me what you think of poor me. I often think of the beautiful name you have. Dear Henry, when will we meet? I think of you so often you have no idea. I have never felt myself so much drawn to a man as you. I feel so bad about. Please write me a long letter and tell me more. Remember if you do not I will punish you. So now you know what I will do to you, you naughty boy, if you do not wrote. O how I long to meet you. Henry dear, do not deny my request before my patience are exhausted. Then I will tell you all. Goodbye now, naughty darling, I have such a bad headache. today. and write by return to your longing

Martha

P. S. Do tell me what kind of perfume does your wife use. I want to know.


He tore the flower gravely from its pinhold smelt its almost no smell and placed it in his heart pocket. Language of flowers. They like it because no-one can hear. Or a poison bouquet to strike him down. Then walking slowly forward he read the letter again, murmuring here and there a word. Angry tulips with you darling manflower punish your cactus if you don’t please poor forgetmenot how I long violets to dear roses when we soon anemone meet all naughty nightstalk wife Martha’s perfume. Having read it all he took it from the newspaper and put it back in his sidepocket.

Weak joy opened his lips. Changed since the first letter. Wonder did she wrote it herself. Doing the indignant: a girl of good family like me, respectable character. Could meet one Sunday after the rosary. Thank you: not having any. Usual love scrimmage. Then running round corners. Bad as a row with Molly. Cigar has a cooling effect. Narcotic. Go further next time. Naughty boy: punish: afraid of words, of course. Brutal, why not? Try it anyhow. A bit at a time.

Fingering still the letter in his pocket he drew the pin out of it. Common pin, eh? He threw it on the road. Out of her clothes somewhere: pinned together. Queer the number of pins they always have. No roses without thorns.

Flat Dublin voices bawled in his head. Those two sluts that night in the Coombe, linked together in the rain.

O, Mairy lost the pin of her drawers.
She didn’t know what to do
To keep it up,
To keep it up.

It? Them. Such a bad headache. Has her roses probably. Or sitting all day typing. Eyefocus bad for stomach nerves. What perfume does your wife use. Now could you make out a thing like that?

To keep it up.

Martha, Mary. I saw that picture somewhere I forget now old master or faked for money. He is sitting in their house, talking. Mysterious. Also the two sluts in the Coombe would listen.

To keep it up.

Nice kind of evening feeling. No more wandering about. Just loll there: quiet dusk: let everything rip. Forget. Tell about places you have been, strange customs. The other one, jar on her head, was getting the supper: fruit, olives, lovely cool water out of a well, stonecold like the hole in the wall at Ashtown. Must carry a paper goblet next time I go to the trottingmatches. She listens with big dark soft eyes. Tell her: more and more: all. Then a sigh: silence. Long long long rest.

Going under the railway arch he took out the envelope, tore it swiftly in shreds and scattered them towards the road. The shreds fluttered away, sank in the dank air: a white flutter, then all sank.

Henry Flower. You could tear up a cheque for a hundred pounds in the same way. Simple bit of paper. Lord Iveagh once cashed a sevenfigure cheque for a million in the bank of Ireland. Shows you the money to be made out of porter. Still the other brother lord Ardilaun has to change his shirt four times a day, they say. Skin breeds lice or vermin. A million pounds, wait a moment. Twopence a pint, fourpence a quart, eightpence a gallon of porter, no, one and fourpence a gallon of porter. One and four into twenty: fifteen about. Yes, exactly. Fifteen millions of barrels of porter.

What am I saying barrels? Gallons. About a million barrels all the same.

An incoming train clanked heavily above his head, coach after coach. Barrels bumped in his head: dull porter slopped and churned inside. The bungholes sprang open and a huge dull flood leaked out, flowing together, winding through mudflats all over the level land, a lazy pooling swirl of liquor bearing along wideleaved flowers of its froth.

He had reached the open backdoor of All Hallows. Stepping into the porch he doffed his hat, took the card from his pocket and tucked it again behind the leather headband. Damn it. I might have tried to work M’Coy for a pass to Mullingar.

Same notice on the door. Sermon by the very reverend John Conmee S. J. on saint Peter Claver S. J. and the African Mission. Prayers for the conversion of Gladstone they had too when he was almost unconscious. The protestants are the same. Convert Dr William J. Walsh D.D. to the true religion. Save China’s millions. Wonder how they explain it to the heathen Chinee. Prefer an ounce of opium. Celestials. Rank heresy for them. Buddha their god lying on his side in the museum. Taking it easy with hand under his cheek. Josssticks burning. Not like Ecce Homo. Crown of thorns and cross. Clever idea Saint Patrick the shamrock. Chopsticks? Conmee: Martin Cunningham knows him: distinguishedlooking. Sorry I didn’t work him about getting Molly into the choir instead of that Father Farley who looked a fool but wasn’t. They’re taught that. He’s not going out in bluey specs with the sweat rolling off him to baptise blacks, is he? The glasses would take their fancy, flashing. Like to see them sitting round in a ring with blub lips, entranced, listening. Still life. Lap it up like milk, I suppose.

The cold smell of sacred stone called him. He trod the worn steps, pushed the swingdoor and entered softly by the rere.

Something going on: some sodality. Pity so empty. Nice discreet place to be next some girl. Who is my neighbour? Jammed by the hour to slow music. That woman at midnight mass. Seventh heaven. Women knelt in the benches with crimson halters round their necks, heads bowed. A batch knelt at the altarrails. The priest went along by them, murmuring, holding the thing in his hands. He stopped at each, took out a communion, shook a drop or two (are they in water?) off it and put it neatly into her mouth. Her hat and head sank. Then the next one. Her hat sank at once. Then the next one: a small old woman. The priest bent down to put it into her mouth, murmuring all the time. Latin. The next one. Shut your eyes and open your mouth. What? Corpus: body. Corpse. Good idea the Latin. Stupefies them first. Hospice for the dying. They don’t seem to chew it: only swallow it down. Rum idea: eating bits of a corpse. Why the cannibals cotton to it.

He stood aside watching their blind masks pass down the aisle, one by one, and seek their places. He approached a bench and seated himself in its corner, nursing his hat and newspaper. These pots we have to wear. We ought to have hats modelled on our heads. They were about him here and there, with heads still bowed in their crimson halters, waiting for it to melt in their stomachs. Something like those mazzoth: it’s that sort of bread: unleavened shewbread. Look at them. Now I bet it makes them feel happy. Lollipop. It does. Yes, bread of angels it’s called. There’s a big idea behind it, kind of kingdom of God is within you feel. First communicants. Hokypoky penny a lump. Then feel all like one family party, same in the theatre, all in the same swim. They do. I’m sure of that. Not so lonely. In our confraternity. Then come out a bit spreeish. Let off steam. Thing is if you really believe in it. Lourdes cure, waters of oblivion, and the Knock apparition, statues bleeding. Old fellow asleep near that confessionbox. Hence those snores. Blind faith. Safe in the arms of kingdom come. Lulls all pain. Wake this time next year.

He saw the priest stow the communion cup away, well in, and kneel an instant before it, showing a large grey bootsole from under the lace affair he had on. Suppose he lost the pin of his. He wouldn’t know what to do to. Bald spot behind. Letters on his back: I.N.R.I? No: I.H.S. Molly told me one time I asked her. I have sinned: or no: I have suffered, it is. And the other one? Iron nails ran in.

Meet one Sunday after the rosary. Do not deny my request. Turn up with a veil and black bag. Dusk and the light behind her. She might be here with a ribbon round her neck and do the other thing all the same on the sly. Their character. That fellow that turned queen’s evidence on the invincibles he used to receive the, Carey was his name, the communion every morning. This very church. Peter Carey, yes. No, Peter Claver I am thinking of. Denis Carey. And just imagine that. Wife and six children at home. And plotting that murder all the time. Those crawthumpers, now that’s a good name for them, there’s always something shiftylooking about them. They’re not straight men of business either. O, no, she’s not here: the flower: no, no. By the way, did I tear up that envelope? Yes: under the bridge.

The priest was rinsing out the chalice: then he tossed off the dregs smartly. Wine. Makes it more aristocratic than for example if he drank what they are used to Guinness’s porter or some temperance beverage Wheatley’s Dublin hop bitters or Cantrell and Cochrane’s ginger ale (aromatic). Doesn’t give them any of it: shew wine: only the other. Cold comfort. Pious fraud but quite right: otherwise they’d have one old booser worse than another coming along, cadging for a drink. Queer the whole atmosphere of the. Quite right. Perfectly right that is.

Mr Bloom looked back towards the choir. Not going to be any music. Pity. Who has the organ here I wonder? Old Glynn he knew how to make that instrument talk, the vibrato: fifty pounds a year they say he had in Gardiner street. Molly was in fine voice that day, the Stabat Mater of Rossini. Father Bernard Vaughan’s sermon first. Christ or Pilate? Christ, but don’t keep us all night over it. Music they wanted. Footdrill stopped. Could hear a pin drop. I told her to pitch her voice against that corner. I could feel the thrill in the air, the full, the people looking up:

Quis est homo.

Some of that old sacred music splendid. Mercadante: seven last words. Mozart’s twelfth mass: Gloria in that. Those old popes keen on music, on art and statues and pictures of all kinds. Palestrina for example too. They had a gay old time while it lasted. Healthy too, chanting, regular hours, then brew liqueurs. Benedictine. Green Chartreuse. Still, having eunuchs in their choir that was coming it a bit thick. What kind of voice is it? Must be curious to hear after their own strong basses. Connoisseurs. Suppose they wouldn’t feel anything after. Kind of a placid. No worry. Fall into flesh, don’t they? Gluttons, tall, long legs. Who knows? Eunuch. One way out of it.

He saw the priest bend down and kiss the altar and then face about and bless all the people. All crossed themselves and stood up. Mr Bloom glanced about him and then stood up, looking over the risen hats. Stand up at the gospel of course. Then all settled down on their knees again and he sat back quietly in his bench. The priest came down from the altar, holding the thing out from him, and he and the massboy answered each other in Latin. Then the priest knelt down and began to read off a card:

—O God, our refuge and our strength...

Mr Bloom put his face forward to catch the words. English. Throw them the bone. I remember slightly. How long since your last mass? Glorious and immaculate virgin. Joseph, her spouse. Peter and Paul. More interesting if you understood what it was all about. Wonderful organisation certainly, goes like clockwork. Confession. Everyone wants to. Then I will tell you all. Penance. Punish me, please. Great weapon in their hands. More than doctor or solicitor. Woman dying to. And I schschschschschsch. And did you chachachachacha? And why did you? Look down at her ring to find an excuse. Whispering gallery walls have ears. Husband learn to his surprise. God’s little joke. Then out she comes. Repentance skindeep. Lovely shame. Pray at an altar. Hail Mary and Holy Mary. Flowers, incense, candles melting. Hide her blushes. Salvation army blatant imitation. Reformed prostitute will address the meeting. How I found the Lord. Squareheaded chaps those must be in Rome: they work the whole show. And don’t they rake in the money too? Bequests also: to the P.P. for the time being in his absolute discretion. Masses for the repose of my soul to be said publicly with open doors. Monasteries and convents. The priest in that Fermanagh will case in the witnessbox. No browbeating him. He had his answer pat for everything. Liberty and exaltation of our holy mother the church. The doctors of the church: they mapped out the whole theology of it.

The priest prayed:

—Blessed Michael, archangel, defend us in the hour of conflict. Be our safeguard against the wickedness and snares of the devil (may God restrain him, we humbly pray!): and do thou, O prince of the heavenly host, by the power of God thrust Satan down to hell and with him those other wicked spirits who wander through the world for the ruin of souls.

The priest and the massboy stood up and walked off. All over. The women remained behind: thanksgiving.

Better be shoving along. Brother Buzz. Come around with the plate perhaps. Pay your Easter duty.

He stood up. Hello. Were those two buttons of my waistcoat open all the time? Women enjoy it. Never tell you. But we. Excuse, miss, there’s a (whh!) just a (whh!) fluff. Or their skirt behind, placket unhooked. Glimpses of the moon. Annoyed if you don’t. Why didn’t you tell me before. Still like you better untidy. Good job it wasn’t farther south. He passed, discreetly buttoning, down the aisle and out through the main door into the light. He stood a moment unseeing by the cold black marble bowl while before him and behind two worshippers dipped furtive hands in the low tide of holy water. Trams: a car of Prescott’s dyeworks: a widow in her weeds. Notice because I’m in mourning myself. He covered himself. How goes the time? Quarter past. Time enough yet. Better get that lotion made up. Where is this? Ah yes, the last time. Sweny’s in Lincoln place. Chemists rarely move. Their green and gold beaconjars too heavy to stir. Hamilton Long’s, founded in the year of the flood. Huguenot churchyard near there. Visit some day.

He walked southward along Westland row. But the recipe is in the other trousers. O, and I forgot that latchkey too. Bore this funeral affair. O well, poor fellow, it’s not his fault. When was it I got it made up last? Wait. I changed a sovereign I remember. First of the month it must have been or the second. O, he can look it up in the prescriptions book.

The chemist turned back page after page. Sandy shrivelled smell he seems to have. Shrunken skull. And old. Quest for the philosopher’s stone. The alchemists. Drugs age you after mental excitement. Lethargy then. Why? Reaction. A lifetime in a night. Gradually changes your character. Living all the day among herbs, ointments, disinfectants. All his alabaster lilypots. Mortar and pestle. Aq. Dist. Fol. Laur. Te Virid. Smell almost cure you like the dentist’s doorbell. Doctor Whack. He ought to physic himself a bit. Electuary or emulsion. The first fellow that picked an herb to cure himself had a bit of pluck. Simples. Want to be careful. Enough stuff here to chloroform you. Test: turns blue litmus paper red. Chloroform. Overdose of laudanum. Sleeping draughts. Lovephiltres. Paragoric poppysyrup bad for cough. Clogs the pores or the phlegm. Poisons the only cures. Remedy where you least expect it. Clever of nature.

—About a fortnight ago, sir?

—Yes, Mr Bloom said.

He waited by the counter, inhaling slowly the keen reek of drugs, the dusty dry smell of sponges and loofahs. Lot of time taken up telling your aches and pains.

—Sweet almond oil and tincture of benzoin, Mr Bloom said, and then orangeflower water...

It certainly did make her skin so delicate white like wax.

—And white wax also, he said.

Brings out the darkness of her eyes. Looking at me, the sheet up to her eyes, Spanish, smelling herself, when I was fixing the links in my cuffs. Those homely recipes are often the best: strawberries for the teeth: nettles and rainwater: oatmeal they say steeped in buttermilk. Skinfood. One of the old queen’s sons, duke of Albany was it? had only one skin. Leopold, yes. Three we have. Warts, bunions and pimples to make it worse. But you want a perfume too. What perfume does your? Peau d’Espagne. That orangeflower water is so fresh. Nice smell these soaps have. Pure curd soap. Time to get a bath round the corner. Hammam. Turkish. Massage. Dirt gets rolled up in your navel. Nicer if a nice girl did it. Also I think I. Yes I. Do it in the bath. Curious longing I. Water to water. Combine business with pleasure. Pity no time for massage. Feel fresh then all the day. Funeral be rather glum.

—Yes, sir, the chemist said. That was two and nine. Have you brought a bottle?

—No, Mr Bloom said. Make it up, please. I’ll call later in the day and I’ll take one of these soaps. How much are they?

—Fourpence, sir.

Mr Bloom raised a cake to his nostrils. Sweet lemony wax.

—I’ll take this one, he said. That makes three and a penny.

—Yes, sir, the chemist said. You can pay all together, sir, when you come back.

—Good, Mr Bloom said.

He strolled out of the shop, the newspaper baton under his armpit, the coolwrappered soap in his left hand.

At his armpit Bantam Lyons’ voice and hand said:

—Hello, Bloom. What’s the best news? Is that today’s? Show us a minute.

Shaved off his moustache again, by Jove! Long cold upper lip. To look younger. He does look balmy. Younger than I am.

Bantam Lyons’s yellow blacknailed fingers unrolled the baton. Wants a wash too. Take off the rough dirt. Good morning, have you used Pears’ soap? Dandruff on his shoulders. Scalp wants oiling.

—I want to see about that French horse that’s running today, Bantam Lyons said. Where the bugger is it?

He rustled the pleated pages, jerking his chin on his high collar. Barber’s itch. Tight collar he’ll lose his hair. Better leave him the paper and get shut of him.

—You can keep it, Mr Bloom said.

—Ascot. Gold cup. Wait, Bantam Lyons muttered. Half a mo. Maximum the second.

—I was just going to throw it away, Mr Bloom said.

Bantam Lyons raised his eyes suddenly and leered weakly.

—What’s that? his sharp voice said.

—I say you can keep it, Mr Bloom answered. I was going to throw it away that moment.

Bantam Lyons doubted an instant, leering: then thrust the outspread sheets back on Mr Bloom’s arms.

—I’ll risk it, he said. Here, thanks.

He sped off towards Conway’s corner. God speed scut.

Mr Bloom folded the sheets again to a neat square and lodged the soap in it, smiling. Silly lips of that chap. Betting. Regular hotbed of it lately. Messenger boys stealing to put on sixpence. Raffle for large tender turkey. Your Christmas dinner for threepence. Jack Fleming embezzling to gamble then smuggled off to America. Keeps a hotel now. They never come back. Fleshpots of Egypt.

He walked cheerfully towards the mosque of the baths. Remind you of a mosque, redbaked bricks, the minarets. College sports today I see. He eyed the horseshoe poster over the gate of college park: cyclist doubled up like a cod in a pot. Damn bad ad. Now if they had made it round like a wheel. Then the spokes: sports, sports, sports: and the hub big: college. Something to catch the eye.

There’s Hornblower standing at the porter’s lodge. Keep him on hands: might take a turn in there on the nod. How do you do, Mr Hornblower? How do you do, sir?

Heavenly weather really. If life was always like that. Cricket weather. Sit around under sunshades. Over after over. Out. They can’t play it here. Duck for six wickets. Still Captain Culler broke a window in the Kildare street club with a slog to square leg. Donnybrook fair more in their line. And the skulls we were acracking when M’Carthy took the floor. Heatwave. Won’t last. Always passing, the stream of life, which in the stream of life we trace is dearer than them all.

Enjoy a bath now: clean trough of water, cool enamel, the gentle tepid stream. This is my body.

He foresaw his pale body reclined in it at full, naked, in a womb of warmth, oiled by scented melting soap, softly laved. He saw his trunk and limbs riprippled over and sustained, buoyed lightly upward, lemonyellow: his navel, bud of flesh: and saw the dark tangled curls of his bush floating, floating hair of the stream around the limp father of thousands, a languid floating flower.

### [ 6 ]
Martin Cunningham, first, poked his silkhatted head into the creaking carriage and, entering deftly, seated himself. Mr Power stepped in after him, curving his height with care.

—Come on, Simon.

—After you, Mr Bloom said.

Mr Dedalus covered himself quickly and got in, saying:

—Yes, yes.

—Are we all here now? Martin Cunningham asked. Come along, Bloom.

Mr Bloom entered and sat in the vacant place. He pulled the door to after him and slammed it twice till it shut tight. He passed an arm through the armstrap and looked seriously from the open carriagewindow at the lowered blinds of the avenue. One dragged aside: an old woman peeping. Nose whiteflattened against the pane. Thanking her stars she was passed over. Extraordinary the interest they take in a corpse. Glad to see us go we give them such trouble coming. Job seems to suit them. Huggermugger in corners. Slop about in slipperslappers for fear he’d wake. Then getting it ready. Laying it out. Molly and Mrs Fleming making the bed. Pull it more to your side. Our windingsheet. Never know who will touch you dead. Wash and shampoo. I believe they clip the nails and the hair. Keep a bit in an envelope. Grows all the same after. Unclean job.

All waited. Nothing was said. Stowing in the wreaths probably. I am sitting on something hard. Ah, that soap: in my hip pocket. Better shift it out of that. Wait for an opportunity.

All waited. Then wheels were heard from in front, turning: then nearer: then horses’ hoofs. A jolt. Their carriage began to move, creaking and swaying. Other hoofs and creaking wheels started behind. The blinds of the avenue passed and number nine with its craped knocker, door ajar. At walking pace.

They waited still, their knees jogging, till they had turned and were passing along the tramtracks. Tritonville road. Quicker. The wheels rattled rolling over the cobbled causeway and the crazy glasses shook rattling in the doorframes.

—What way is he taking us? Mr Power asked through both windows.

—Irishtown, Martin Cunningham said. Ringsend. Brunswick street.

Mr Dedalus nodded, looking out.

—That’s a fine old custom, he said. I am glad to see it has not died out.

All watched awhile through their windows caps and hats lifted by passers. Respect. The carriage swerved from the tramtrack to the smoother road past Watery lane. Mr Bloom at gaze saw a lithe young man, clad in mourning, a wide hat.

—There’s a friend of yours gone by, Dedalus, he said.

—Who is that?

—Your son and heir.

—Where is he? Mr Dedalus said, stretching over across.

The carriage, passing the open drains and mounds of rippedup roadway before the tenement houses, lurched round the corner and, swerving back to the tramtrack, rolled on noisily with chattering wheels. Mr Dedalus fell back, saying:

—Was that Mulligan cad with him? His fidus Achates!

—No, Mr Bloom said. He was alone.

—Down with his aunt Sally, I suppose, Mr Dedalus said, the Goulding faction, the drunken little costdrawer and Crissie, papa’s little lump of dung, the wise child that knows her own father.

Mr Bloom smiled joylessly on Ringsend road. Wallace Bros: the bottleworks: Dodder bridge.

Richie Goulding and the legal bag. Goulding, Collis and Ward he calls the firm. His jokes are getting a bit damp. Great card he was. Waltzing in Stamer street with Ignatius Gallaher on a Sunday morning, the landlady’s two hats pinned on his head. Out on the rampage all night. Beginning to tell on him now: that backache of his, I fear. Wife ironing his back. Thinks he’ll cure it with pills. All breadcrumbs they are. About six hundred per cent profit.

—He’s in with a lowdown crowd, Mr Dedalus snarled. That Mulligan is a contaminated bloody doubledyed ruffian by all accounts. His name stinks all over Dublin. But with the help of God and His blessed mother I’ll make it my business to write a letter one of those days to his mother or his aunt or whatever she is that will open her eye as wide as a gate. I’ll tickle his catastrophe, believe you me.

He cried above the clatter of the wheels:

—I won’t have her bastard of a nephew ruin my son. A counterjumper’s son. Selling tapes in my cousin, Peter Paul M’Swiney’s. Not likely.

He ceased. Mr Bloom glanced from his angry moustache to Mr Power’s mild face and Martin Cunningham’s eyes and beard, gravely shaking. Noisy selfwilled man. Full of his son. He is right. Something to hand on. If little Rudy had lived. See him grow up. Hear his voice in the house. Walking beside Molly in an Eton suit. My son. Me in his eyes. Strange feeling it would be. From me. Just a chance. Must have been that morning in Raymond terrace she was at the window watching the two dogs at it by the wall of the cease to do evil. And the sergeant grinning up. She had that cream gown on with the rip she never stitched. Give us a touch, Poldy. God, I’m dying for it. How life begins.

Got big then. Had to refuse the Greystones concert. My son inside her. I could have helped him on in life. I could. Make him independent. Learn German too.

—Are we late? Mr Power asked.

—Ten minutes, Martin Cunningham said, looking at his watch.

Molly. Milly. Same thing watered down. Her tomboy oaths. O jumping Jupiter! Ye gods and little fishes! Still, she’s a dear girl. Soon be a woman. Mullingar. Dearest Papli. Young student. Yes, yes: a woman too. Life, life.

The carriage heeled over and back, their four trunks swaying.

—Corny might have given us a more commodious yoke, Mr Power said.

—He might, Mr Dedalus said, if he hadn’t that squint troubling him. Do you follow me?

He closed his left eye. Martin Cunningham began to brush away crustcrumbs from under his thighs.

—What is this, he said, in the name of God? Crumbs?

—Someone seems to have been making a picnic party here lately, Mr Power said.

All raised their thighs and eyed with disfavour the mildewed buttonless leather of the seats. Mr Dedalus, twisting his nose, frowned downward and said:

—Unless I’m greatly mistaken. What do you think, Martin?

—It struck me too, Martin Cunningham said.

Mr Bloom set his thigh down. Glad I took that bath. Feel my feet quite clean. But I wish Mrs Fleming had darned these socks better.

Mr Dedalus sighed resignedly.

—After all, he said, it’s the most natural thing in the world.

—Did Tom Kernan turn up? Martin Cunningham asked, twirling the peak of his beard gently.

—Yes, Mr Bloom answered. He’s behind with Ned Lambert and Hynes.

—And Corny Kelleher himself? Mr Power asked.

—At the cemetery, Martin Cunningham said.

—I met M’Coy this morning, Mr Bloom said. He said he’d try to come.

The carriage halted short.

—What’s wrong?

—We’re stopped.

—Where are we?

Mr Bloom put his head out of the window.

—The grand canal, he said.

Gasworks. Whooping cough they say it cures. Good job Milly never got it. Poor children! Doubles them up black and blue in convulsions. Shame really. Got off lightly with illnesses compared. Only measles. Flaxseed tea. Scarlatina, influenza epidemics. Canvassing for death. Don’t miss this chance. Dogs’ home over there. Poor old Athos! Be good to Athos, Leopold, is my last wish. Thy will be done. We obey them in the grave. A dying scrawl. He took it to heart, pined away. Quiet brute. Old men’s dogs usually are.

A raindrop spat on his hat. He drew back and saw an instant of shower spray dots over the grey flags. Apart. Curious. Like through a colander. I thought it would. My boots were creaking I remember now.

—The weather is changing, he said quietly.

—A pity it did not keep up fine, Martin Cunningham said.

—Wanted for the country, Mr Power said. There’s the sun again coming out.

Mr Dedalus, peering through his glasses towards the veiled sun, hurled a mute curse at the sky.

—It’s as uncertain as a child’s bottom, he said.

—We’re off again.

The carriage turned again its stiff wheels and their trunks swayed gently. Martin Cunningham twirled more quickly the peak of his beard.

—Tom Kernan was immense last night, he said. And Paddy Leonard taking him off to his face.

—O, draw him out, Martin, Mr Power said eagerly. Wait till you hear him, Simon, on Ben Dollard’s singing of The Croppy Boy.

—Immense, Martin Cunningham said pompously. His singing of that simple ballad, Martin, is the most trenchant rendering I ever heard in the whole course of my experience.

—Trenchant, Mr Power said laughing. He’s dead nuts on that. And the retrospective arrangement.

—Did you read Dan Dawson’s speech? Martin Cunningham asked.

—I did not then, Mr Dedalus said. Where is it?

—In the paper this morning.

Mr Bloom took the paper from his inside pocket. That book I must change for her.

—No, no, Mr Dedalus said quickly. Later on please.

Mr Bloom’s glance travelled down the edge of the paper, scanning the deaths: Callan, Coleman, Dignam, Fawcett, Lowry, Naumann, Peake, what Peake is that? is it the chap was in Crosbie and Alleyne’s? no, Sexton, Urbright. Inked characters fast fading on the frayed breaking paper. Thanks to the Little Flower. Sadly missed. To the inexpressible grief of his. Aged 88 after a long and tedious illness. Month’s mind: Quinlan. On whose soul Sweet Jesus have mercy.

It is now a month since dear Henry fled
To his home up above in the sky
While his family weeps and mourns his loss
Hoping some day to meet him on high.

I tore up the envelope? Yes. Where did I put her letter after I read it in the bath? He patted his waistcoatpocket. There all right. Dear Henry fled. Before my patience are exhausted.

National school. Meade’s yard. The hazard. Only two there now. Nodding. Full as a tick. Too much bone in their skulls. The other trotting round with a fare. An hour ago I was passing there. The jarvies raised their hats.

A pointsman’s back straightened itself upright suddenly against a tramway standard by Mr Bloom’s window. Couldn’t they invent something automatic so that the wheel itself much handier? Well but that fellow would lose his job then? Well but then another fellow would get a job making the new invention?

Antient concert rooms. Nothing on there. A man in a buff suit with a crape armlet. Not much grief there. Quarter mourning. People in law perhaps.

They went past the bleak pulpit of saint Mark’s, under the railway bridge, past the Queen’s theatre: in silence. Hoardings: Eugene Stratton, Mrs Bandmann Palmer. Could I go to see Leah tonight, I wonder. I said I. Or the Lily of Killarney? Elster Grimes Opera Company. Big powerful change. Wet bright bills for next week. Fun on the Bristol. Martin Cunningham could work a pass for the Gaiety. Have to stand a drink or two. As broad as it’s long.

He’s coming in the afternoon. Her songs.

Plasto’s. Sir Philip Crampton’s memorial fountain bust. Who was he?

—How do you do? Martin Cunningham said, raising his palm to his brow in salute.

—He doesn’t see us, Mr Power said. Yes, he does. How do you do?

—Who? Mr Dedalus asked.

—Blazes Boylan, Mr Power said. There he is airing his quiff.

Just that moment I was thinking.

Mr Dedalus bent across to salute. From the door of the Red Bank the white disc of a straw hat flashed reply: spruce figure: passed.

Mr Bloom reviewed the nails of his left hand, then those of his right hand. The nails, yes. Is there anything more in him that they she sees? Fascination. Worst man in Dublin. That keeps him alive. They sometimes feel what a person is. Instinct. But a type like that. My nails. I am just looking at them: well pared. And after: thinking alone. Body getting a bit softy. I would notice that: from remembering. What causes that? I suppose the skin can’t contract quickly enough when the flesh falls off. But the shape is there. The shape is there still. Shoulders. Hips. Plump. Night of the dance dressing. Shift stuck between the cheeks behind.

He clasped his hands between his knees and, satisfied, sent his vacant glance over their faces.

Mr Power asked:

—How is the concert tour getting on, Bloom?

—O, very well, Mr Bloom said. I hear great accounts of it. It’s a good idea, you see...

—Are you going yourself?

—Well no, Mr Bloom said. In point of fact I have to go down to the county Clare on some private business. You see the idea is to tour the chief towns. What you lose on one you can make up on the other.

—Quite so, Martin Cunningham said. Mary Anderson is up there now.

Have you good artists?

—Louis Werner is touring her, Mr Bloom said. O yes, we’ll have all topnobbers. J. C. Doyle and John MacCormack I hope and. The best, in fact.

—And Madame, Mr Power said smiling. Last but not least.

Mr Bloom unclasped his hands in a gesture of soft politeness and clasped them. Smith O’Brien. Someone has laid a bunch of flowers there. Woman. Must be his deathday. For many happy returns. The carriage wheeling by Farrell’s statue united noiselessly their unresisting knees.

Oot: a dullgarbed old man from the curbstone tendered his wares, his mouth opening: oot.

—Four bootlaces for a penny.

Wonder why he was struck off the rolls. Had his office in Hume street. Same house as Molly’s namesake, Tweedy, crown solicitor for Waterford. Has that silk hat ever since. Relics of old decency. Mourning too. Terrible comedown, poor wretch! Kicked about like snuff at a wake. O’Callaghan on his last legs.

And Madame. Twenty past eleven. Up. Mrs Fleming is in to clean. Doing her hair, humming: voglio e non vorrei. No: vorrei e non. Looking at the tips of her hairs to see if they are split. Mi trema un poco il. Beautiful on that tre her voice is: weeping tone. A thrush. A throstle. There is a word throstle that expresses that.

His eyes passed lightly over Mr Power’s goodlooking face. Greyish over the ears. Madame: smiling. I smiled back. A smile goes a long way. Only politeness perhaps. Nice fellow. Who knows is that true about the woman he keeps? Not pleasant for the wife. Yet they say, who was it told me, there is no carnal. You would imagine that would get played out pretty quick. Yes, it was Crofton met him one evening bringing her a pound of rumpsteak. What is this she was? Barmaid in Jury’s. Or the Moira, was it?

They passed under the hugecloaked Liberator’s form.

Martin Cunningham nudged Mr Power.

—Of the tribe of Reuben, he said.

A tall blackbearded figure, bent on a stick, stumping round the corner of Elvery’s Elephant house, showed them a curved hand open on his spine.

—In all his pristine beauty, Mr Power said.

Mr Dedalus looked after the stumping figure and said mildly:

—The devil break the hasp of your back!

Mr Power, collapsing in laughter, shaded his face from the window as the carriage passed Gray’s statue.

—We have all been there, Martin Cunningham said broadly.

His eyes met Mr Bloom’s eyes. He caressed his beard, adding:

—Well, nearly all of us.

Mr Bloom began to speak with sudden eagerness to his companions’ faces.

—That’s an awfully good one that’s going the rounds about Reuben J and the son.

—About the boatman? Mr Power asked.

—Yes. Isn’t it awfully good?

—What is that? Mr Dedalus asked. I didn’t hear it.

—There was a girl in the case, Mr Bloom began, and he determined to send him to the Isle of Man out of harm’s way but when they were both.....

—What? Mr Dedalus asked. That confirmed bloody hobbledehoy is it?

—Yes, Mr Bloom said. They were both on the way to the boat and he tried to drown.....

—Drown Barabbas! Mr Dedalus cried. I wish to Christ he did!

Mr Power sent a long laugh down his shaded nostrils.

—No, Mr Bloom said, the son himself.....

Martin Cunningham thwarted his speech rudely:

—Reuben J and the son were piking it down the quay next the river on their way to the Isle of Man boat and the young chiseller suddenly got loose and over the wall with him into the Liffey.

—For God’s sake! Mr Dedalus exclaimed in fright. Is he dead?

—Dead! Martin Cunningham cried. Not he! A boatman got a pole and fished him out by the slack of the breeches and he was landed up to the father on the quay more dead than alive. Half the town was there.

—Yes, Mr Bloom said. But the funny part is.....

—And Reuben J, Martin Cunningham said, gave the boatman a florin for saving his son’s life.

A stifled sigh came from under Mr Power’s hand.

—O, he did, Martin Cunningham affirmed. Like a hero. A silver florin.

—Isn’t it awfully good? Mr Bloom said eagerly.

—One and eightpence too much, Mr Dedalus said drily.

Mr Power’s choked laugh burst quietly in the carriage.

Nelson’s pillar.

—Eight plums a penny! Eight for a penny!

—We had better look a little serious, Martin Cunningham said.

Mr Dedalus sighed.

—Ah then indeed, he said, poor little Paddy wouldn’t grudge us a laugh. Many a good one he told himself.

—The Lord forgive me! Mr Power said, wiping his wet eyes with his fingers. Poor Paddy! I little thought a week ago when I saw him last and he was in his usual health that I’d be driving after him like this. He’s gone from us.

—As decent a little man as ever wore a hat, Mr Dedalus said. He went very suddenly.

—Breakdown, Martin Cunningham said. Heart.

He tapped his chest sadly.

Blazing face: redhot. Too much John Barleycorn. Cure for a red nose. Drink like the devil till it turns adelite. A lot of money he spent colouring it.

Mr Power gazed at the passing houses with rueful apprehension.

—He had a sudden death, poor fellow, he said.

—The best death, Mr Bloom said.

Their wide open eyes looked at him.

—No suffering, he said. A moment and all is over. Like dying in sleep.

No-one spoke.

Dead side of the street this. Dull business by day, land agents, temperance hotel, Falconer’s railway guide, civil service college, Gill’s, catholic club, the industrious blind. Why? Some reason. Sun or wind. At night too. Chummies and slaveys. Under the patronage of the late Father Mathew. Foundation stone for Parnell. Breakdown. Heart.

White horses with white frontlet plumes came round the Rotunda corner, galloping. A tiny coffin flashed by. In a hurry to bury. A mourning coach. Unmarried. Black for the married. Piebald for bachelors. Dun for a nun.

—Sad, Martin Cunningham said. A child.

A dwarf’s face, mauve and wrinkled like little Rudy’s was. Dwarf’s body, weak as putty, in a whitelined deal box. Burial friendly society pays. Penny a week for a sod of turf. Our. Little. Beggar. Baby. Meant nothing. Mistake of nature. If it’s healthy it’s from the mother. If not from the man. Better luck next time.

—Poor little thing, Mr Dedalus said. It’s well out of it.

The carriage climbed more slowly the hill of Rutland square. Rattle his bones. Over the stones. Only a pauper. Nobody owns.

—In the midst of life, Martin Cunningham said.

—But the worst of all, Mr Power said, is the man who takes his own life.

Martin Cunningham drew out his watch briskly, coughed and put it back.

—The greatest disgrace to have in the family, Mr Power added.

—Temporary insanity, of course, Martin Cunningham said decisively. We must take a charitable view of it.

—They say a man who does it is a coward, Mr Dedalus said.

—It is not for us to judge, Martin Cunningham said.

Mr Bloom, about to speak, closed his lips again. Martin Cunningham’s large eyes. Looking away now. Sympathetic human man he is. Intelligent. Like Shakespeare’s face. Always a good word to say. They have no mercy on that here or infanticide. Refuse christian burial. They used to drive a stake of wood through his heart in the grave. As if it wasn’t broken already. Yet sometimes they repent too late. Found in the riverbed clutching rushes. He looked at me. And that awful drunkard of a wife of his. Setting up house for her time after time and then pawning the furniture on him every Saturday almost. Leading him the life of the damned. Wear the heart out of a stone, that. Monday morning. Start afresh. Shoulder to the wheel. Lord, she must have looked a sight that night Dedalus told me he was in there. Drunk about the place and capering with Martin’s umbrella.

And they call me the jewel of Asia,
Of Asia,
The geisha.

He looked away from me. He knows. Rattle his bones.

That afternoon of the inquest. The redlabelled bottle on the table. The room in the hotel with hunting pictures. Stuffy it was. Sunlight through the slats of the Venetian blind. The coroner’s sunlit ears, big and hairy. Boots giving evidence. Thought he was asleep first. Then saw like yellow streaks on his face. Had slipped down to the foot of the bed. Verdict: overdose. Death by misadventure. The letter. For my son Leopold.

No more pain. Wake no more. Nobody owns.

The carriage rattled swiftly along Blessington street. Over the stones.

—We are going the pace, I think, Martin Cunningham said.

—God grant he doesn’t upset us on the road, Mr Power said.

—I hope not, Martin Cunningham said. That will be a great race tomorrow in Germany. The Gordon Bennett.

—Yes, by Jove, Mr Dedalus said. That will be worth seeing, faith.

As they turned into Berkeley street a streetorgan near the Basin sent over and after them a rollicking rattling song of the halls. Has anybody here seen Kelly? Kay ee double ell wy. Dead March from Saul. He’s as bad as old Antonio. He left me on my ownio. Pirouette! The Mater Misericordiae. Eccles street. My house down there. Big place. Ward for incurables there. Very encouraging. Our Lady’s Hospice for the dying. Deadhouse handy underneath. Where old Mrs Riordan died. They look terrible the women. Her feeding cup and rubbing her mouth with the spoon. Then the screen round her bed for her to die. Nice young student that was dressed that bite the bee gave me. He’s gone over to the lying-in hospital they told me. From one extreme to the other.

The carriage galloped round a corner: stopped.

—What’s wrong now?

A divided drove of branded cattle passed the windows, lowing, slouching by on padded hoofs, whisking their tails slowly on their clotted bony croups. Outside them and through them ran raddled sheep bleating their fear.

—Emigrants, Mr Power said.

—Huuuh! the drover’s voice cried, his switch sounding on their flanks. Huuuh! out of that!

Thursday, of course. Tomorrow is killing day. Springers. Cuffe sold them about twentyseven quid each. For Liverpool probably. Roastbeef for old England. They buy up all the juicy ones. And then the fifth quarter lost: all that raw stuff, hide, hair, horns. Comes to a big thing in a year. Dead meat trade. Byproducts of the slaughterhouses for tanneries, soap, margarine. Wonder if that dodge works now getting dicky meat off the train at Clonsilla.

The carriage moved on through the drove.

—I can’t make out why the corporation doesn’t run a tramline from the parkgate to the quays, Mr Bloom said. All those animals could be taken in trucks down to the boats.

—Instead of blocking up the thoroughfare, Martin Cunningham said. Quite right. They ought to.

—Yes, Mr Bloom said, and another thing I often thought, is to have municipal funeral trams like they have in Milan, you know. Run the line out to the cemetery gates and have special trams, hearse and carriage and all. Don’t you see what I mean?

—O, that be damned for a story, Mr Dedalus said. Pullman car and saloon diningroom.

—A poor lookout for Corny, Mr Power added.

—Why? Mr Bloom asked, turning to Mr Dedalus. Wouldn’t it be more decent than galloping two abreast?

—Well, there’s something in that, Mr Dedalus granted.

—And, Martin Cunningham said, we wouldn’t have scenes like that when the hearse capsized round Dunphy’s and upset the coffin on to the road.

—That was terrible, Mr Power’s shocked face said, and the corpse fell about the road. Terrible!

—First round Dunphy’s, Mr Dedalus said, nodding. Gordon Bennett cup.

—Praises be to God! Martin Cunningham said piously.

Bom! Upset. A coffin bumped out on to the road. Burst open. Paddy Dignam shot out and rolling over stiff in the dust in a brown habit too large for him. Red face: grey now. Mouth fallen open. Asking what’s up now. Quite right to close it. Looks horrid open. Then the insides decompose quickly. Much better to close up all the orifices. Yes, also. With wax. The sphincter loose. Seal up all.

—Dunphy’s, Mr Power announced as the carriage turned right.

Dunphy’s corner. Mourning coaches drawn up, drowning their grief. A pause by the wayside. Tiptop position for a pub. Expect we’ll pull up here on the way back to drink his health. Pass round the consolation. Elixir of life.

But suppose now it did happen. Would he bleed if a nail say cut him in the knocking about? He would and he wouldn’t, I suppose. Depends on where. The circulation stops. Still some might ooze out of an artery. It would be better to bury them in red: a dark red.

In silence they drove along Phibsborough road. An empty hearse trotted by, coming from the cemetery: looks relieved.

Crossguns bridge: the royal canal.

Water rushed roaring through the sluices. A man stood on his dropping barge, between clamps of turf. On the towpath by the lock a slacktethered horse. Aboard of the Bugabu.

Their eyes watched him. On the slow weedy waterway he had floated on his raft coastward over Ireland drawn by a haulage rope past beds of reeds, over slime, mudchoked bottles, carrion dogs. Athlone, Mullingar, Moyvalley, I could make a walking tour to see Milly by the canal. Or cycle down. Hire some old crock, safety. Wren had one the other day at the auction but a lady’s. Developing waterways. James M’Cann’s hobby to row me o’er the ferry. Cheaper transit. By easy stages. Houseboats. Camping out. Also hearses. To heaven by water. Perhaps I will without writing. Come as a surprise, Leixlip, Clonsilla. Dropping down lock by lock to Dublin. With turf from the midland bogs. Salute. He lifted his brown straw hat, saluting Paddy Dignam.

They drove on past Brian Boroimhe house. Near it now.

—I wonder how is our friend Fogarty getting on, Mr Power said.

—Better ask Tom Kernan, Mr Dedalus said.

—How is that? Martin Cunningham said. Left him weeping, I suppose?

—Though lost to sight, Mr Dedalus said, to memory dear.

The carriage steered left for Finglas road.

The stonecutter’s yard on the right. Last lap. Crowded on the spit of land silent shapes appeared, white, sorrowful, holding out calm hands, knelt in grief, pointing. Fragments of shapes, hewn. In white silence: appealing. The best obtainable. Thos. H. Dennany, monumental builder and sculptor.

Passed.

On the curbstone before Jimmy Geary, the sexton’s, an old tramp sat, grumbling, emptying the dirt and stones out of his huge dustbrown yawning boot. After life’s journey.

Gloomy gardens then went by: one by one: gloomy houses.

Mr Power pointed.

—That is where Childs was murdered, he said. The last house.

—So it is, Mr Dedalus said. A gruesome case. Seymour Bushe got him off. Murdered his brother. Or so they said.

—The crown had no evidence, Mr Power said.

—Only circumstantial, Martin Cunningham added. That’s the maxim of the law. Better for ninetynine guilty to escape than for one innocent person to be wrongfully condemned.

They looked. Murderer’s ground. It passed darkly. Shuttered, tenantless, unweeded garden. Whole place gone to hell. Wrongfully condemned. Murder. The murderer’s image in the eye of the murdered. They love reading about it. Man’s head found in a garden. Her clothing consisted of. How she met her death. Recent outrage. The weapon used. Murderer is still at large. Clues. A shoelace. The body to be exhumed. Murder will out.

Cramped in this carriage. She mightn’t like me to come that way without letting her know. Must be careful about women. Catch them once with their pants down. Never forgive you after. Fifteen.

The high railings of Prospect rippled past their gaze. Dark poplars, rare white forms. Forms more frequent, white shapes thronged amid the trees, white forms and fragments streaming by mutely, sustaining vain gestures on the air.

The felly harshed against the curbstone: stopped. Martin Cunningham put out his arm and, wrenching back the handle, shoved the door open with his knee. He stepped out. Mr Power and Mr Dedalus followed.

Change that soap now. Mr Bloom’s hand unbuttoned his hip pocket swiftly and transferred the paperstuck soap to his inner handkerchief pocket. He stepped out of the carriage, replacing the newspaper his other hand still held.

Paltry funeral: coach and three carriages. It’s all the same. Pallbearers, gold reins, requiem mass, firing a volley. Pomp of death. Beyond the hind carriage a hawker stood by his barrow of cakes and fruit. Simnel cakes those are, stuck together: cakes for the dead. Dogbiscuits. Who ate them? Mourners coming out.

He followed his companions. Mr Kernan and Ned Lambert followed, Hynes walking after them. Corny Kelleher stood by the opened hearse and took out the two wreaths. He handed one to the boy.

Where is that child’s funeral disappeared to?

A team of horses passed from Finglas with toiling plodding tread, dragging through the funereal silence a creaking waggon on which lay a granite block. The waggoner marching at their head saluted.

Coffin now. Got here before us, dead as he is. Horse looking round at it with his plume skeowways. Dull eye: collar tight on his neck, pressing on a bloodvessel or something. Do they know what they cart out here every day? Must be twenty or thirty funerals every day. Then Mount Jerome for the protestants. Funerals all over the world everywhere every minute. Shovelling them under by the cartload doublequick. Thousands every hour. Too many in the world.

Mourners came out through the gates: woman and a girl. Leanjawed harpy, hard woman at a bargain, her bonnet awry. Girl’s face stained with dirt and tears, holding the woman’s arm, looking up at her for a sign to cry. Fish’s face, bloodless and livid.

The mutes shouldered the coffin and bore it in through the gates. So much dead weight. Felt heavier myself stepping out of that bath. First the stiff: then the friends of the stiff. Corny Kelleher and the boy followed with their wreaths. Who is that beside them? Ah, the brother-in-law.

All walked after.

Martin Cunningham whispered:

—I was in mortal agony with you talking of suicide before Bloom.

—What? Mr Power whispered. How so?

—His father poisoned himself, Martin Cunningham whispered. Had the Queen’s hotel in Ennis. You heard him say he was going to Clare. Anniversary.

—O God! Mr Power whispered. First I heard of it. Poisoned himself?

He glanced behind him to where a face with dark thinking eyes followed towards the cardinal’s mausoleum. Speaking.

—Was he insured? Mr Bloom asked.

—I believe so, Mr Kernan answered. But the policy was heavily mortgaged. Martin is trying to get the youngster into Artane.

—How many children did he leave?

—Five. Ned Lambert says he’ll try to get one of the girls into Todd’s.

—A sad case, Mr Bloom said gently. Five young children.

—A great blow to the poor wife, Mr Kernan added.

—Indeed yes, Mr Bloom agreed.

Has the laugh at him now.

He looked down at the boots he had blacked and polished. She had outlived him. Lost her husband. More dead for her than for me. One must outlive the other. Wise men say. There are more women than men in the world. Condole with her. Your terrible loss. I hope you’ll soon follow him. For Hindu widows only. She would marry another. Him? No. Yet who knows after. Widowhood not the thing since the old queen died. Drawn on a guncarriage. Victoria and Albert. Frogmore memorial mourning. But in the end she put a few violets in her bonnet. Vain in her heart of hearts. All for a shadow. Consort not even a king. Her son was the substance. Something new to hope for not like the past she wanted back, waiting. It never comes. One must go first: alone, under the ground: and lie no more in her warm bed.

—How are you, Simon? Ned Lambert said softly, clasping hands. Haven’t seen you for a month of Sundays.

—Never better. How are all in Cork’s own town?

—I was down there for the Cork park races on Easter Monday, Ned Lambert said. Same old six and eightpence. Stopped with Dick Tivy.

—And how is Dick, the solid man?

—Nothing between himself and heaven, Ned Lambert answered.

—By the holy Paul! Mr Dedalus said in subdued wonder. Dick Tivy bald?

—Martin is going to get up a whip for the youngsters, Ned Lambert said, pointing ahead. A few bob a skull. Just to keep them going till the insurance is cleared up.

—Yes, yes, Mr Dedalus said dubiously. Is that the eldest boy in front?

—Yes, Ned Lambert said, with the wife’s brother. John Henry Menton is behind. He put down his name for a quid.

—I’ll engage he did, Mr Dedalus said. I often told poor Paddy he ought to mind that job. John Henry is not the worst in the world.

—How did he lose it? Ned Lambert asked. Liquor, what?

—Many a good man’s fault, Mr Dedalus said with a sigh.

They halted about the door of the mortuary chapel. Mr Bloom stood behind the boy with the wreath looking down at his sleekcombed hair and at the slender furrowed neck inside his brandnew collar. Poor boy! Was he there when the father? Both unconscious. Lighten up at the last moment and recognise for the last time. All he might have done. I owe three shillings to O’Grady. Would he understand? The mutes bore the coffin into the chapel. Which end is his head?

After a moment he followed the others in, blinking in the screened light. The coffin lay on its bier before the chancel, four tall yellow candles at its corners. Always in front of us. Corny Kelleher, laying a wreath at each fore corner, beckoned to the boy to kneel. The mourners knelt here and there in prayingdesks. Mr Bloom stood behind near the font and, when all had knelt, dropped carefully his unfolded newspaper from his pocket and knelt his right knee upon it. He fitted his black hat gently on his left knee and, holding its brim, bent over piously.

A server bearing a brass bucket with something in it came out through a door. The whitesmocked priest came after him, tidying his stole with one hand, balancing with the other a little book against his toad’s belly. Who’ll read the book? I, said the rook.

They halted by the bier and the priest began to read out of his book with a fluent croak.

Father Coffey. I knew his name was like a coffin. Dominenamine. Bully about the muzzle he looks. Bosses the show. Muscular christian. Woe betide anyone that looks crooked at him: priest. Thou art Peter. Burst sideways like a sheep in clover Dedalus says he will. With a belly on him like a poisoned pup. Most amusing expressions that man finds. Hhhn: burst sideways.

—Non intres in judicium cum servo tuo, Domine.

Makes them feel more important to be prayed over in Latin. Requiem mass. Crape weepers. Blackedged notepaper. Your name on the altarlist. Chilly place this. Want to feed well, sitting in there all the morning in the gloom kicking his heels waiting for the next please. Eyes of a toad too. What swells him up that way? Molly gets swelled after cabbage. Air of the place maybe. Looks full up of bad gas. Must be an infernal lot of bad gas round the place. Butchers, for instance: they get like raw beefsteaks. Who was telling me? Mervyn Browne. Down in the vaults of saint Werburgh’s lovely old organ hundred and fifty they have to bore a hole in the coffins sometimes to let out the bad gas and burn it. Out it rushes: blue. One whiff of that and you’re a goner.

My kneecap is hurting me. Ow. That’s better.

The priest took a stick with a knob at the end of it out of the boy’s bucket and shook it over the coffin. Then he walked to the other end and shook it again. Then he came back and put it back in the bucket. As you were before you rested. It’s all written down: he has to do it.

—Et ne nos inducas in tentationem.

The server piped the answers in the treble. I often thought it would be better to have boy servants. Up to fifteen or so. After that, of course ...

Holy water that was, I expect. Shaking sleep out of it. He must be fed up with that job, shaking that thing over all the corpses they trot up. What harm if he could see what he was shaking it over. Every mortal day a fresh batch: middleaged men, old women, children, women dead in childbirth, men with beards, baldheaded businessmen, consumptive girls with little sparrows’ breasts. All the year round he prayed the same thing over them all and shook water on top of them: sleep. On Dignam now.

—In paradisum.

Said he was going to paradise or is in paradise. Says that over everybody. Tiresome kind of a job. But he has to say something.

The priest closed his book and went off, followed by the server. Corny Kelleher opened the sidedoors and the gravediggers came in, hoisted the coffin again, carried it out and shoved it on their cart. Corny Kelleher gave one wreath to the boy and one to the brother-in-law. All followed them out of the sidedoors into the mild grey air. Mr Bloom came last folding his paper again into his pocket. He gazed gravely at the ground till the coffincart wheeled off to the left. The metal wheels ground the gravel with a sharp grating cry and the pack of blunt boots followed the trundled barrow along a lane of sepulchres.

The ree the ra the ree the ra the roo. Lord, I mustn’t lilt here.

—The O’Connell circle, Mr Dedalus said about him.

Mr Power’s soft eyes went up to the apex of the lofty cone.

—He’s at rest, he said, in the middle of his people, old Dan O’. But his heart is buried in Rome. How many broken hearts are buried here, Simon!

—Her grave is over there, Jack, Mr Dedalus said. I’ll soon be stretched beside her. Let Him take me whenever He likes.

Breaking down, he began to weep to himself quietly, stumbling a little in his walk. Mr Power took his arm.

—She’s better where she is, he said kindly.

—I suppose so, Mr Dedalus said with a weak gasp. I suppose she is in heaven if there is a heaven.

Corny Kelleher stepped aside from his rank and allowed the mourners to plod by.

—Sad occasions, Mr Kernan began politely.

Mr Bloom closed his eyes and sadly twice bowed his head.

—The others are putting on their hats, Mr Kernan said. I suppose we can do so too. We are the last. This cemetery is a treacherous place.

They covered their heads.

—The reverend gentleman read the service too quickly, don’t you think? Mr Kernan said with reproof.

Mr Bloom nodded gravely looking in the quick bloodshot eyes. Secret eyes, secretsearching. Mason, I think: not sure. Beside him again. We are the last. In the same boat. Hope he’ll say something else.

Mr Kernan added:

—The service of the Irish church used in Mount Jerome is simpler, more impressive I must say.

Mr Bloom gave prudent assent. The language of course was another thing.

Mr Kernan said with solemnity:

—I am the resurrection and the life. That touches a man’s inmost heart.

—It does, Mr Bloom said.

Your heart perhaps but what price the fellow in the six feet by two with his toes to the daisies? No touching that. Seat of the affections. Broken heart. A pump after all, pumping thousands of gallons of blood every day. One fine day it gets bunged up: and there you are. Lots of them lying around here: lungs, hearts, livers. Old rusty pumps: damn the thing else. The resurrection and the life. Once you are dead you are dead. That last day idea. Knocking them all up out of their graves. Come forth, Lazarus! And he came fifth and lost the job. Get up! Last day! Then every fellow mousing around for his liver and his lights and the rest of his traps. Find damn all of himself that morning. Pennyweight of powder in a skull. Twelve grammes one pennyweight. Troy measure.

Corny Kelleher fell into step at their side.

—Everything went off A1, he said. What?

He looked on them from his drawling eye. Policeman’s shoulders. With your tooraloom tooraloom.

—As it should be, Mr Kernan said.

—What? Eh? Corny Kelleher said.

Mr Kernan assured him.

—Who is that chap behind with Tom Kernan? John Henry Menton asked. I know his face.

Ned Lambert glanced back.

—Bloom, he said, Madame Marion Tweedy that was, is, I mean, the soprano. She’s his wife.

—O, to be sure, John Henry Menton said. I haven’t seen her for some time. She was a finelooking woman. I danced with her, wait, fifteen seventeen golden years ago, at Mat Dillon’s in Roundtown. And a good armful she was.

He looked behind through the others.

—What is he? he asked. What does he do? Wasn’t he in the stationery line? I fell foul of him one evening, I remember, at bowls.

Ned Lambert smiled.

—Yes, he was, he said, in Wisdom Hely’s. A traveller for blottingpaper.

—In God’s name, John Henry Menton said, what did she marry a coon like that for? She had plenty of game in her then.

—Has still, Ned Lambert said. He does some canvassing for ads.

John Henry Menton’s large eyes stared ahead.

The barrow turned into a side lane. A portly man, ambushed among the grasses, raised his hat in homage. The gravediggers touched their caps.

—John O’Connell, Mr Power said pleased. He never forgets a friend.

Mr O’Connell shook all their hands in silence. Mr Dedalus said:

—I am come to pay you another visit.

—My dear Simon, the caretaker answered in a low voice. I don’t want your custom at all.

Saluting Ned Lambert and John Henry Menton he walked on at Martin Cunningham’s side puzzling two long keys at his back.

—Did you hear that one, he asked them, about Mulcahy from the Coombe?

—I did not, Martin Cunningham said.

They bent their silk hats in concert and Hynes inclined his ear. The caretaker hung his thumbs in the loops of his gold watchchain and spoke in a discreet tone to their vacant smiles.

—They tell the story, he said, that two drunks came out here one foggy evening to look for the grave of a friend of theirs. They asked for Mulcahy from the Coombe and were told where he was buried. After traipsing about in the fog they found the grave sure enough. One of the drunks spelt out the name: Terence Mulcahy. The other drunk was blinking up at a statue of Our Saviour the widow had got put up.

The caretaker blinked up at one of the sepulchres they passed. He resumed:

—And, after blinking up at the sacred figure, Not a bloody bit like the man, says he. That’s not Mulcahy, says he, whoever done it.

Rewarded by smiles he fell back and spoke with Corny Kelleher, accepting the dockets given him, turning them over and scanning them as he walked.

—That’s all done with a purpose, Martin Cunningham explained to Hynes.

—I know, Hynes said. I know that.

—To cheer a fellow up, Martin Cunningham said. It’s pure goodheartedness: damn the thing else.

Mr Bloom admired the caretaker’s prosperous bulk. All want to be on good terms with him. Decent fellow, John O’Connell, real good sort. Keys: like Keyes’s ad: no fear of anyone getting out. No passout checks. Habeas corpus. I must see about that ad after the funeral. Did I write Ballsbridge on the envelope I took to cover when she disturbed me writing to Martha? Hope it’s not chucked in the dead letter office. Be the better of a shave. Grey sprouting beard. That’s the first sign when the hairs come out grey. And temper getting cross. Silver threads among the grey. Fancy being his wife. Wonder he had the gumption to propose to any girl. Come out and live in the graveyard. Dangle that before her. It might thrill her first. Courting death. Shades of night hovering here with all the dead stretched about. The shadows of the tombs when churchyards yawn and Daniel O’Connell must be a descendant I suppose who is this used to say he was a queer breedy man great catholic all the same like a big giant in the dark. Will o’ the wisp. Gas of graves. Want to keep her mind off it to conceive at all. Women especially are so touchy. Tell her a ghost story in bed to make her sleep. Have you ever seen a ghost? Well, I have. It was a pitchdark night. The clock was on the stroke of twelve. Still they’d kiss all right if properly keyed up. Whores in Turkish graveyards. Learn anything if taken young. You might pick up a young widow here. Men like that. Love among the tombstones. Romeo. Spice of pleasure. In the midst of death we are in life. Both ends meet. Tantalising for the poor dead. Smell of grilled beefsteaks to the starving. Gnawing their vitals. Desire to grig people. Molly wanting to do it at the window. Eight children he has anyway.

He has seen a fair share go under in his time, lying around him field after field. Holy fields. More room if they buried them standing. Sitting or kneeling you couldn’t. Standing? His head might come up some day above ground in a landslip with his hand pointing. All honeycombed the ground must be: oblong cells. And very neat he keeps it too: trim grass and edgings. His garden Major Gamble calls Mount Jerome. Well, so it is. Ought to be flowers of sleep. Chinese cemeteries with giant poppies growing produce the best opium Mastiansky told me. The Botanic Gardens are just over there. It’s the blood sinking in the earth gives new life. Same idea those jews they said killed the christian boy. Every man his price. Well preserved fat corpse, gentleman, epicure, invaluable for fruit garden. A bargain. By carcass of William Wilkinson, auditor and accountant, lately deceased, three pounds thirteen and six. With thanks.

I daresay the soil would be quite fat with corpsemanure, bones, flesh, nails. Charnelhouses. Dreadful. Turning green and pink decomposing. Rot quick in damp earth. The lean old ones tougher. Then a kind of a tallowy kind of a cheesy. Then begin to get black, black treacle oozing out of them. Then dried up. Deathmoths. Of course the cells or whatever they are go on living. Changing about. Live for ever practically. Nothing to feed on feed on themselves.

But they must breed a devil of a lot of maggots. Soil must be simply swirling with them. Your head it simply swurls. Those pretty little seaside gurls. He looks cheerful enough over it. Gives him a sense of power seeing all the others go under first. Wonder how he looks at life. Cracking his jokes too: warms the cockles of his heart. The one about the bulletin. Spurgeon went to heaven 4 a.m. this morning. 11 p.m. (closing time). Not arrived yet. Peter. The dead themselves the men anyhow would like to hear an odd joke or the women to know what’s in fashion. A juicy pear or ladies’ punch, hot, strong and sweet. Keep out the damp. You must laugh sometimes so better do it that way. Gravediggers in Hamlet. Shows the profound knowledge of the human heart. Daren’t joke about the dead for two years at least. De mortuis nil nisi prius. Go out of mourning first. Hard to imagine his funeral. Seems a sort of a joke. Read your own obituary notice they say you live longer. Gives you second wind. New lease of life.

—How many have you for tomorrow? the caretaker asked.

—Two, Corny Kelleher said. Half ten and eleven.

The caretaker put the papers in his pocket. The barrow had ceased to trundle. The mourners split and moved to each side of the hole, stepping with care round the graves. The gravediggers bore the coffin and set its nose on the brink, looping the bands round it.

Burying him. We come to bury Cæsar. His ides of March or June. He doesn’t know who is here nor care. Now who is that lankylooking galoot over there in the macintosh? Now who is he I’d like to know? Now I’d give a trifle to know who he is. Always someone turns up you never dreamt of. A fellow could live on his lonesome all his life. Yes, he could. Still he’d have to get someone to sod him after he died though he could dig his own grave. We all do. Only man buries. No, ants too. First thing strikes anybody. Bury the dead. Say Robinson Crusoe was true to life. Well then Friday buried him. Every Friday buries a Thursday if you come to look at it.

O, poor Robinson Crusoe!
How could you possibly do so?

Poor Dignam! His last lie on the earth in his box. When you think of them all it does seem a waste of wood. All gnawed through. They could invent a handsome bier with a kind of panel sliding, let it down that way. Ay but they might object to be buried out of another fellow’s. They’re so particular. Lay me in my native earth. Bit of clay from the holy land. Only a mother and deadborn child ever buried in the one coffin. I see what it means. I see. To protect him as long as possible even in the earth. The Irishman’s house is his coffin. Embalming in catacombs, mummies the same idea.

Mr Bloom stood far back, his hat in his hand, counting the bared heads. Twelve. I’m thirteen. No. The chap in the macintosh is thirteen. Death’s number. Where the deuce did he pop out of? He wasn’t in the chapel, that I’ll swear. Silly superstition that about thirteen.

Nice soft tweed Ned Lambert has in that suit. Tinge of purple. I had one like that when we lived in Lombard street west. Dressy fellow he was once. Used to change three suits in the day. Must get that grey suit of mine turned by Mesias. Hello. It’s dyed. His wife I forgot he’s not married or his landlady ought to have picked out those threads for him.

The coffin dived out of sight, eased down by the men straddled on the gravetrestles. They struggled up and out: and all uncovered. Twenty.

Pause.

If we were all suddenly somebody else.

Far away a donkey brayed. Rain. No such ass. Never see a dead one, they say. Shame of death. They hide. Also poor papa went away.

Gentle sweet air blew round the bared heads in a whisper. Whisper. The boy by the gravehead held his wreath with both hands staring quietly in the black open space. Mr Bloom moved behind the portly kindly caretaker. Wellcut frockcoat. Weighing them up perhaps to see which will go next. Well, it is a long rest. Feel no more. It’s the moment you feel. Must be damned unpleasant. Can’t believe it at first. Mistake must be: someone else. Try the house opposite. Wait, I wanted to. I haven’t yet. Then darkened deathchamber. Light they want. Whispering around you. Would you like to see a priest? Then rambling and wandering. Delirium all you hid all your life. The death struggle. His sleep is not natural. Press his lower eyelid. Watching is his nose pointed is his jaw sinking are the soles of his feet yellow. Pull the pillow away and finish it off on the floor since he’s doomed. Devil in that picture of sinner’s death showing him a woman. Dying to embrace her in his shirt. Last act of Lucia. Shall I nevermore behold thee? Bam! He expires. Gone at last. People talk about you a bit: forget you. Don’t forget to pray for him. Remember him in your prayers. Even Parnell. Ivy day dying out. Then they follow: dropping into a hole, one after the other.

We are praying now for the repose of his soul. Hoping you’re well and not in hell. Nice change of air. Out of the fryingpan of life into the fire of purgatory.

Does he ever think of the hole waiting for himself? They say you do when you shiver in the sun. Someone walking over it. Callboy’s warning. Near you. Mine over there towards Finglas, the plot I bought. Mamma, poor mamma, and little Rudy.

The gravediggers took up their spades and flung heavy clods of clay in on the coffin. Mr Bloom turned away his face. And if he was alive all the time? Whew! By jingo, that would be awful! No, no: he is dead, of course. Of course he is dead. Monday he died. They ought to have some law to pierce the heart and make sure or an electric clock or a telephone in the coffin and some kind of a canvas airhole. Flag of distress. Three days. Rather long to keep them in summer. Just as well to get shut of them as soon as you are sure there’s no.

The clay fell softer. Begin to be forgotten. Out of sight, out of mind.

The caretaker moved away a few paces and put on his hat. Had enough of it. The mourners took heart of grace, one by one, covering themselves without show. Mr Bloom put on his hat and saw the portly figure make its way deftly through the maze of graves. Quietly, sure of his ground, he traversed the dismal fields.

Hynes jotting down something in his notebook. Ah, the names. But he knows them all. No: coming to me.

—I am just taking the names, Hynes said below his breath. What is your christian name? I’m not sure.

—L, Mr Bloom said. Leopold. And you might put down M’Coy’s name too. He asked me to.

—Charley, Hynes said writing. I know. He was on the Freeman once.

So he was before he got the job in the morgue under Louis Byrne. Good idea a postmortem for doctors. Find out what they imagine they know. He died of a Tuesday. Got the run. Levanted with the cash of a few ads. Charley, you’re my darling. That was why he asked me to. O well, does no harm. I saw to that, M’Coy. Thanks, old chap: much obliged. Leave him under an obligation: costs nothing.

—And tell us, Hynes said, do you know that fellow in the, fellow was over there in the...

He looked around.

—Macintosh. Yes, I saw him, Mr Bloom said. Where is he now?

—M’Intosh, Hynes said scribbling. I don’t know who he is. Is that his name?

He moved away, looking about him.

—No, Mr Bloom began, turning and stopping. I say, Hynes!

Didn’t hear. What? Where has he disappeared to? Not a sign. Well of all the. Has anybody here seen? Kay ee double ell. Become invisible. Good Lord, what became of him?

A seventh gravedigger came beside Mr Bloom to take up an idle spade.

—O, excuse me!

He stepped aside nimbly.

Clay, brown, damp, began to be seen in the hole. It rose. Nearly over. A mound of damp clods rose more, rose, and the gravediggers rested their spades. All uncovered again for a few instants. The boy propped his wreath against a corner: the brother-in-law his on a lump. The gravediggers put on their caps and carried their earthy spades towards the barrow. Then knocked the blades lightly on the turf: clean. One bent to pluck from the haft a long tuft of grass. One, leaving his mates, walked slowly on with shouldered weapon, its blade blueglancing. Silently at the gravehead another coiled the coffinband. His navelcord. The brother-in-law, turning away, placed something in his free hand. Thanks in silence. Sorry, sir: trouble. Headshake. I know that. For yourselves just.

The mourners moved away slowly without aim, by devious paths, staying at whiles to read a name on a tomb.

—Let us go round by the chief’s grave, Hynes said. We have time.

—Let us, Mr Power said.

They turned to the right, following their slow thoughts. With awe Mr Power’s blank voice spoke:

—Some say he is not in that grave at all. That the coffin was filled with stones. That one day he will come again.

Hynes shook his head.

—Parnell will never come again, he said. He’s there, all that was mortal of him. Peace to his ashes.

Mr Bloom walked unheeded along his grove by saddened angels, crosses, broken pillars, family vaults, stone hopes praying with upcast eyes, old Ireland’s hearts and hands. More sensible to spend the money on some charity for the living. Pray for the repose of the soul of. Does anybody really? Plant him and have done with him. Like down a coalshoot. Then lump them together to save time. All souls’ day. Twentyseventh I’ll be at his grave. Ten shillings for the gardener. He keeps it free of weeds. Old man himself. Bent down double with his shears clipping. Near death’s door. Who passed away. Who departed this life. As if they did it of their own accord. Got the shove, all of them. Who kicked the bucket. More interesting if they told you what they were. So and So, wheelwright. I travelled for cork lino. I paid five shillings in the pound. Or a woman’s with her saucepan. I cooked good Irish stew. Eulogy in a country churchyard it ought to be that poem of whose is it Wordsworth or Thomas Campbell. Entered into rest the protestants put it. Old Dr Murren’s. The great physician called him home. Well it’s God’s acre for them. Nice country residence. Newly plastered and painted. Ideal spot to have a quiet smoke and read the Church Times. Marriage ads they never try to beautify. Rusty wreaths hung on knobs, garlands of bronzefoil. Better value that for the money. Still, the flowers are more poetical. The other gets rather tiresome, never withering. Expresses nothing. Immortelles.

A bird sat tamely perched on a poplar branch. Like stuffed. Like the wedding present alderman Hooper gave us. Hoo! Not a budge out of him. Knows there are no catapults to let fly at him. Dead animal even sadder. Silly-Milly burying the little dead bird in the kitchen matchbox, a daisychain and bits of broken chainies on the grave.

The Sacred Heart that is: showing it. Heart on his sleeve. Ought to be sideways and red it should be painted like a real heart. Ireland was dedicated to it or whatever that. Seems anything but pleased. Why this infliction? Would birds come then and peck like the boy with the basket of fruit but he said no because they ought to have been afraid of the boy. Apollo that was.

How many! All these here once walked round Dublin. Faithful departed. As you are now so once were we.

Besides how could you remember everybody? Eyes, walk, voice. Well, the voice, yes: gramophone. Have a gramophone in every grave or keep it in the house. After dinner on a Sunday. Put on poor old greatgrandfather. Kraahraark! Hellohellohello amawfullyglad kraark awfullygladaseeagain hellohello amawf krpthsth. Remind you of the voice like the photograph reminds you of the face. Otherwise you couldn’t remember the face after fifteen years, say. For instance who? For instance some fellow that died when I was in Wisdom Hely’s.

Rtststr! A rattle of pebbles. Wait. Stop!

He looked down intently into a stone crypt. Some animal. Wait. There he goes.

An obese grey rat toddled along the side of the crypt, moving the pebbles. An old stager: greatgrandfather: he knows the ropes. The grey alive crushed itself in under the plinth, wriggled itself in under it. Good hidingplace for treasure.

Who lives there? Are laid the remains of Robert Emery. Robert Emmet was buried here by torchlight, wasn’t he? Making his rounds.

Tail gone now.

One of those chaps would make short work of a fellow. Pick the bones clean no matter who it was. Ordinary meat for them. A corpse is meat gone bad. Well and what’s cheese? Corpse of milk. I read in that Voyages in China that the Chinese say a white man smells like a corpse. Cremation better. Priests dead against it. Devilling for the other firm. Wholesale burners and Dutch oven dealers. Time of the plague. Quicklime feverpits to eat them. Lethal chamber. Ashes to ashes. Or bury at sea. Where is that Parsee tower of silence? Eaten by birds. Earth, fire, water. Drowning they say is the pleasantest. See your whole life in a flash. But being brought back to life no. Can’t bury in the air however. Out of a flying machine. Wonder does the news go about whenever a fresh one is let down. Underground communication. We learned that from them. Wouldn’t be surprised. Regular square feed for them. Flies come before he’s well dead. Got wind of Dignam. They wouldn’t care about the smell of it. Saltwhite crumbling mush of corpse: smell, taste like raw white turnips.

The gates glimmered in front: still open. Back to the world again. Enough of this place. Brings you a bit nearer every time. Last time I was here was Mrs Sinico’s funeral. Poor papa too. The love that kills. And even scraping up the earth at night with a lantern like that case I read of to get at fresh buried females or even putrefied with running gravesores. Give you the creeps after a bit. I will appear to you after death. You will see my ghost after death. My ghost will haunt you after death. There is another world after death named hell. I do not like that other world she wrote. No more do I. Plenty to see and hear and feel yet. Feel live warm beings near you. Let them sleep in their maggoty beds. They are not going to get me this innings. Warm beds: warm fullblooded life.

Martin Cunningham emerged from a sidepath, talking gravely.

Solicitor, I think. I know his face. Menton, John Henry, solicitor, commissioner for oaths and affidavits. Dignam used to be in his office. Mat Dillon’s long ago. Jolly Mat. Convivial evenings. Cold fowl, cigars, the Tantalus glasses. Heart of gold really. Yes, Menton. Got his rag out that evening on the bowlinggreen because I sailed inside him. Pure fluke of mine: the bias. Why he took such a rooted dislike to me. Hate at first sight. Molly and Floey Dillon linked under the lilactree, laughing. Fellow always like that, mortified if women are by.

Got a dinge in the side of his hat. Carriage probably.

—Excuse me, sir, Mr Bloom said beside them.

They stopped.

—Your hat is a little crushed, Mr Bloom said pointing.

John Henry Menton stared at him for an instant without moving.

—There, Martin Cunningham helped, pointing also.

John Henry Menton took off his hat, bulged out the dinge and smoothed the nap with care on his coatsleeve. He clapped the hat on his head again.

—It’s all right now, Martin Cunningham said.

John Henry Menton jerked his head down in acknowledgment.

—Thank you, he said shortly.

They walked on towards the gates. Mr Bloom, chapfallen, drew behind a few paces so as not to overhear. Martin laying down the law. Martin could wind a sappyhead like that round his little finger, without his seeing it.

Oyster eyes. Never mind. Be sorry after perhaps when it dawns on him. Get the pull over him that way.

Thank you. How grand we are this morning!

### [ 7 ]
IN THE HEART OF THE HIBERNIAN METROPOLIS
Before Nelson’s pillar trams slowed, shunted, changed trolley, started for Blackrock, Kingstown and Dalkey, Clonskea, Rathgar and Terenure, Palmerston Park and upper Rathmines, Sandymount Green, Rathmines, Ringsend and Sandymount Tower, Harold’s Cross. The hoarse Dublin United Tramway Company’s timekeeper bawled them off:

—Rathgar and Terenure!

—Come on, Sandymount Green!

Right and left parallel clanging ringing a doubledecker and a singledeck moved from their railheads, swerved to the down line, glided parallel.

—Start, Palmerston Park!

THE WEARER OF THE CROWN
Under the porch of the general post office shoeblacks called and polished. Parked in North Prince’s street His Majesty’s vermilion mailcars, bearing on their sides the royal initials, E. R., received loudly flung sacks of letters, postcards, lettercards, parcels, insured and paid, for local, provincial, British and overseas delivery.

GENTLEMEN OF THE PRESS
Grossbooted draymen rolled barrels dullthudding out of Prince’s stores and bumped them up on the brewery float. On the brewery float bumped dullthudding barrels rolled by grossbooted draymen out of Prince’s stores.

—There it is, Red Murray said. Alexander Keyes.

—Just cut it out, will you? Mr Bloom said, and I’ll take it round to the Telegraph office.

The door of Ruttledge’s office creaked again. Davy Stephens, minute in a large capecoat, a small felt hat crowning his ringlets, passed out with a roll of papers under his cape, a king’s courier.

Red Murray’s long shears sliced out the advertisement from the newspaper in four clean strokes. Scissors and paste.

—I’ll go through the printingworks, Mr Bloom said, taking the cut square.

—Of course, if he wants a par, Red Murray said earnestly, a pen behind his ear, we can do him one.

—Right, Mr Bloom said with a nod. I’ll rub that in.

We.

WILLIAM BRAYDEN, ESQUIRE, OF OAKLANDS, SANDYMOUNT
Red Murray touched Mr Bloom’s arm with the shears and whispered:

—Brayden.

Mr Bloom turned and saw the liveried porter raise his lettered cap as a stately figure entered between the newsboards of the Weekly Freeman and National Press and the Freeman’s Journal and National Press. Dullthudding Guinness’s barrels. It passed statelily up the staircase, steered by an umbrella, a solemn beardframed face. The broadcloth back ascended each step: back. All his brains are in the nape of his neck, Simon Dedalus says. Welts of flesh behind on him. Fat folds of neck, fat, neck, fat, neck.

—Don’t you think his face is like Our Saviour? Red Murray whispered.

The door of Ruttledge’s office whispered: ee: cree. They always build one door opposite another for the wind to. Way in. Way out.

Our Saviour: beardframed oval face: talking in the dusk. Mary, Martha. Steered by an umbrella sword to the footlights: Mario the tenor.

—Or like Mario, Mr Bloom said.

—Yes, Red Murray agreed. But Mario was said to be the picture of Our Saviour.

Jesusmario with rougy cheeks, doublet and spindle legs. Hand on his heart. In Martha.

Co-ome thou lost one,
Co-ome thou dear one!

THE CROZIER AND THE PEN
—His grace phoned down twice this morning, Red Murray said gravely.

They watched the knees, legs, boots vanish. Neck.

A telegram boy stepped in nimbly, threw an envelope on the counter and stepped off posthaste with a word:

—Freeman!

Mr Bloom said slowly:

—Well, he is one of our saviours also.

A meek smile accompanied him as he lifted the counterflap, as he passed in through a sidedoor and along the warm dark stairs and passage, along the now reverberating boards. But will he save the circulation? Thumping. Thumping.

He pushed in the glass swingdoor and entered, stepping over strewn packing paper. Through a lane of clanking drums he made his way towards Nannetti’s reading closet.

WITH UNFEIGNED REGRET IT IS WE ANNOUNCE THE DISSOLUTION OF A MOST RESPECTED DUBLIN BURGESS
Hynes here too: account of the funeral probably. Thumping. Thump. This morning the remains of the late Mr Patrick Dignam. Machines. Smash a man to atoms if they got him caught. Rule the world today. His machineries are pegging away too. Like these, got out of hand: fermenting. Working away, tearing away. And that old grey rat tearing to get in.

HOW A GREAT DAILY ORGAN IS TURNED OUT
Mr Bloom halted behind the foreman’s spare body, admiring a glossy crown.

Strange he never saw his real country. Ireland my country. Member for College green. He boomed that workaday worker tack for all it was worth. It’s the ads and side features sell a weekly, not the stale news in the official gazette. Queen Anne is dead. Published by authority in the year one thousand and. Demesne situate in the townland of Rosenallis, barony of Tinnahinch. To all whom it may concern schedule pursuant to statute showing return of number of mules and jennets exported from Ballina. Nature notes. Cartoons. Phil Blake’s weekly Pat and Bull story. Uncle Toby’s page for tiny tots. Country bumpkin’s queries. Dear Mr Editor, what is a good cure for flatulence? I’d like that part. Learn a lot teaching others. The personal note. M. A. P. Mainly all pictures. Shapely bathers on golden strand. World’s biggest balloon. Double marriage of sisters celebrated. Two bridegrooms laughing heartily at each other. Cuprani too, printer. More Irish than the Irish.

The machines clanked in threefour time. Thump, thump, thump. Now if he got paralysed there and no-one knew how to stop them they’d clank on and on the same, print it over and over and up and back. Monkeydoodle the whole thing. Want a cool head.

—Well, get it into the evening edition, councillor, Hynes said.

Soon be calling him my lord mayor. Long John is backing him, they say.

The foreman, without answering, scribbled press on a corner of the sheet and made a sign to a typesetter. He handed the sheet silently over the dirty glass screen.

—Right: thanks, Hynes said moving off.

Mr Bloom stood in his way.

—If you want to draw the cashier is just going to lunch, he said, pointing backward with his thumb.

—Did you? Hynes asked.

—Mm, Mr Bloom said. Look sharp and you’ll catch him.

—Thanks, old man, Hynes said. I’ll tap him too.

He hurried on eagerly towards the Freeman’s Journal.

Three bob I lent him in Meagher’s. Three weeks. Third hint.

WE SEE THE CANVASSER AT WORK
Mr Bloom laid his cutting on Mr Nannetti’s desk.

—Excuse me, councillor, he said. This ad, you see. Keyes, you remember?

Mr Nannetti considered the cutting awhile and nodded.

—He wants it in for July, Mr Bloom said.

The foreman moved his pencil towards it.

—But wait, Mr Bloom said. He wants it changed. Keyes, you see. He wants two keys at the top.

Hell of a racket they make. He doesn’t hear it. Nannan. Iron nerves. Maybe he understands what I.

The foreman turned round to hear patiently and, lifting an elbow, began to scratch slowly in the armpit of his alpaca jacket.

—Like that, Mr Bloom said, crossing his forefingers at the top.

Let him take that in first.

Mr Bloom, glancing sideways up from the cross he had made, saw the foreman’s sallow face, think he has a touch of jaundice, and beyond the obedient reels feeding in huge webs of paper. Clank it. Clank it. Miles of it unreeled. What becomes of it after? O, wrap up meat, parcels: various uses, thousand and one things.

Slipping his words deftly into the pauses of the clanking he drew swiftly on the scarred woodwork.

HOUSE OF KEY(E)S
—Like that, see. Two crossed keys here. A circle. Then here the name. Alexander Keyes, tea, wine and spirit merchant. So on.

Better not teach him his own business.

—You know yourself, councillor, just what he wants. Then round the top in leaded: the house of keys. You see? Do you think that’s a good idea?

The foreman moved his scratching hand to his lower ribs and scratched there quietly.

—The idea, Mr Bloom said, is the house of keys. You know, councillor, the Manx parliament. Innuendo of home rule. Tourists, you know, from the isle of Man. Catches the eye, you see. Can you do that?

I could ask him perhaps about how to pronounce that voglio. But then if he didn’t know only make it awkward for him. Better not.

—We can do that, the foreman said. Have you the design?

—I can get it, Mr Bloom said. It was in a Kilkenny paper. He has a house there too. I’ll just run out and ask him. Well, you can do that and just a little par calling attention. You know the usual. Highclass licensed premises. Longfelt want. So on.

The foreman thought for an instant.

—We can do that, he said. Let him give us a three months’ renewal.

A typesetter brought him a limp galleypage. He began to check it silently. Mr Bloom stood by, hearing the loud throbs of cranks, watching the silent typesetters at their cases.

ORTHOGRAPHICAL
Want to be sure of his spelling. Proof fever. Martin Cunningham forgot to give us his spellingbee conundrum this morning. It is amusing to view the unpar one ar alleled embarra two ars is it? double ess ment of a harassed pedlar while gauging au the symmetry with a y of a peeled pear under a cemetery wall. Silly, isn’t it? Cemetery put in of course on account of the symmetry.

I should have said when he clapped on his topper. Thank you. I ought to have said something about an old hat or something. No. I could have said. Looks as good as new now. See his phiz then.

Sllt. The nethermost deck of the first machine jogged forward its flyboard with sllt the first batch of quirefolded papers. Sllt. Almost human the way it sllt to call attention. Doing its level best to speak. That door too sllt creaking, asking to be shut. Everything speaks in its own way. Sllt.

NOTED CHURCHMAN AN OCCASIONAL CONTRIBUTOR
The foreman handed back the galleypage suddenly, saying:

—Wait. Where’s the archbishop’s letter? It’s to be repeated in the Telegraph. Where’s what’s his name?

He looked about him round his loud unanswering machines.

—Monks, sir? a voice asked from the castingbox.

—Ay. Where’s Monks?

—Monks!

Mr Bloom took up his cutting. Time to get out.

—Then I’ll get the design, Mr Nannetti, he said, and you’ll give it a good place I know.

—Monks!

—Yes, sir.

Three months’ renewal. Want to get some wind off my chest first. Try it anyhow. Rub in August: good idea: horseshow month. Ballsbridge. Tourists over for the show.

A DAYFATHER
He walked on through the caseroom passing an old man, bowed, spectacled, aproned. Old Monks, the dayfather. Queer lot of stuff he must have put through his hands in his time: obituary notices, pubs’ ads, speeches, divorce suits, found drowned. Nearing the end of his tether now. Sober serious man with a bit in the savingsbank I’d say. Wife a good cook and washer. Daughter working the machine in the parlour. Plain Jane, no damn nonsense.

AND IT WAS THE FEAST OF THE PASSOVER
He stayed in his walk to watch a typesetter neatly distributing type. Reads it backwards first. Quickly he does it. Must require some practice that. mangiD kcirtaP. Poor papa with his hagadah book, reading backwards with his finger to me. Pessach. Next year in Jerusalem. Dear, O dear! All that long business about that brought us out of the land of Egypt and into the house of bondage alleluia. Shema Israel Adonai Elohenu. No, that’s the other. Then the twelve brothers, Jacob’s sons. And then the lamb and the cat and the dog and the stick and the water and the butcher. And then the angel of death kills the butcher and he kills the ox and the dog kills the cat. Sounds a bit silly till you come to look into it well. Justice it means but it’s everybody eating everyone else. That’s what life is after all. How quickly he does that job. Practice makes perfect. Seems to see with his fingers.

Mr Bloom passed on out of the clanking noises through the gallery on to the landing. Now am I going to tram it out all the way and then catch him out perhaps. Better phone him up first. Number? Yes. Same as Citron’s house. Twentyeight. Twentyeight double four.

ONLY ONCE MORE THAT SOAP
He went down the house staircase. Who the deuce scrawled all over those walls with matches? Looks as if they did it for a bet. Heavy greasy smell there always is in those works. Lukewarm glue in Thom’s next door when I was there.

He took out his handkerchief to dab his nose. Citronlemon? Ah, the soap I put there. Lose it out of that pocket. Putting back his handkerchief he took out the soap and stowed it away, buttoned, into the hip pocket of his trousers.

What perfume does your wife use? I could go home still: tram: something I forgot. Just to see: before: dressing. No. Here. No.

A sudden screech of laughter came from the Evening Telegraph office. Know who that is. What’s up? Pop in a minute to phone. Ned Lambert it is.

He entered softly.

ERIN, GREEN GEM OF THE SILVER SEA
—The ghost walks, professor MacHugh murmured softly, biscuitfully to the dusty windowpane.

Mr Dedalus, staring from the empty fireplace at Ned Lambert’s quizzing face, asked of it sourly:

—Agonising Christ, wouldn’t it give you a heartburn on your arse?

Ned Lambert, seated on the table, read on:

—Or again, note the meanderings of some purling rill as it babbles on its way, tho’ quarrelling with the stony obstacles, to the tumbling waters of Neptune’s blue domain, ’mid mossy banks, fanned by gentlest zephyrs, played on by the glorious sunlight or ’neath the shadows cast o’er its pensive bosom by the overarching leafage of the giants of the forest. What about that, Simon? he asked over the fringe of his newspaper. How’s that for high?

—Changing his drink, Mr Dedalus said.

Ned Lambert, laughing, struck the newspaper on his knees, repeating:

—The pensive bosom and the overarsing leafage. O boys! O boys!

—And Xenophon looked upon Marathon, Mr Dedalus said, looking again on the fireplace and to the window, and Marathon looked on the sea.

—That will do, professor MacHugh cried from the window. I don’t want to hear any more of the stuff.

He ate off the crescent of water biscuit he had been nibbling and, hungered, made ready to nibble the biscuit in his other hand.

High falutin stuff. Bladderbags. Ned Lambert is taking a day off I see. Rather upsets a man’s day, a funeral does. He has influence they say. Old Chatterton, the vicechancellor, is his granduncle or his greatgranduncle. Close on ninety they say. Subleader for his death written this long time perhaps. Living to spite them. Might go first himself. Johnny, make room for your uncle. The right honourable Hedges Eyre Chatterton. Daresay he writes him an odd shaky cheque or two on gale days. Windfall when he kicks out. Alleluia.

—Just another spasm, Ned Lambert said.

—What is it? Mr Bloom asked.

—A recently discovered fragment of Cicero, professor MacHugh answered with pomp of tone. Our lovely land.

SHORT BUT TO THE POINT
—Whose land? Mr Bloom said simply.

—Most pertinent question, the professor said between his chews. With an accent on the whose.

—Dan Dawson’s land Mr Dedalus said.

—Is it his speech last night? Mr Bloom asked.

Ned Lambert nodded.

—But listen to this, he said.

The doorknob hit Mr Bloom in the small of the back as the door was pushed in.

—Excuse me, J. J. O’Molloy said, entering.

Mr Bloom moved nimbly aside.

—I beg yours, he said.

—Good day, Jack.

—Come in. Come in.

—Good day.

—How are you, Dedalus?

—Well. And yourself?

J. J. O’Molloy shook his head.

SAD
Cleverest fellow at the junior bar he used to be. Decline, poor chap. That hectic flush spells finis for a man. Touch and go with him. What’s in the wind, I wonder. Money worry.

—Or again if we but climb the serried mountain peaks.

—You’re looking extra.

—Is the editor to be seen? J. J. O’Molloy asked, looking towards the inner door.

—Very much so, professor MacHugh said. To be seen and heard. He’s in his sanctum with Lenehan.

J. J. O’Molloy strolled to the sloping desk and began to turn back the pink pages of the file.

Practice dwindling. A mighthavebeen. Losing heart. Gambling. Debts of honour. Reaping the whirlwind. Used to get good retainers from D. and T. Fitzgerald. Their wigs to show the grey matter. Brains on their sleeve like the statue in Glasnevin. Believe he does some literary work for the Express with Gabriel Conroy. Wellread fellow. Myles Crawford began on the Independent. Funny the way those newspaper men veer about when they get wind of a new opening. Weathercocks. Hot and cold in the same breath. Wouldn’t know which to believe. One story good till you hear the next. Go for one another baldheaded in the papers and then all blows over. Hail fellow well met the next moment.

—Ah, listen to this for God’ sake, Ned Lambert pleaded. Or again if we but climb the serried mountain peaks...

—Bombast! the professor broke in testily. Enough of the inflated windbag!

—Peaks, Ned Lambert went on, towering high on high, to bathe our souls, as it were...

—Bathe his lips, Mr Dedalus said. Blessed and eternal God! Yes? Is he taking anything for it?

—As ’twere, in the peerless panorama of Ireland’s portfolio, unmatched, despite their wellpraised prototypes in other vaunted prize regions, for very beauty, of bosky grove and undulating plain and luscious pastureland of vernal green, steeped in the transcendent translucent glow of our mild mysterious Irish twilight...

HIS NATIVE DORIC
—The moon, professor MacHugh said. He forgot Hamlet.

—That mantles the vista far and wide and wait till the glowing orb of the moon shine forth to irradiate her silver effulgence...

—O! Mr Dedalus cried, giving vent to a hopeless groan. Shite and onions! That’ll do, Ned. Life is too short.

He took off his silk hat and, blowing out impatiently his bushy moustache, welshcombed his hair with raking fingers.

Ned Lambert tossed the newspaper aside, chuckling with delight. An instant after a hoarse bark of laughter burst over professor MacHugh’s unshaven blackspectacled face.

—Doughy Daw! he cried.

WHAT WETHERUP SAID
All very fine to jeer at it now in cold print but it goes down like hot cake that stuff. He was in the bakery line too, wasn’t he? Why they call him Doughy Daw. Feathered his nest well anyhow. Daughter engaged to that chap in the inland revenue office with the motor. Hooked that nicely. Entertainments. Open house. Big blowout. Wetherup always said that. Get a grip of them by the stomach.

The inner door was opened violently and a scarlet beaked face, crested by a comb of feathery hair, thrust itself in. The bold blue eyes stared about them and the harsh voice asked:

—What is it?

—And here comes the sham squire himself! professor MacHugh said grandly.

—Getonouthat, you bloody old pedagogue! the editor said in recognition.

—Come, Ned, Mr Dedalus said, putting on his hat. I must get a drink after that.

—Drink! the editor cried. No drinks served before mass.

—Quite right too, Mr Dedalus said, going out. Come on, Ned.

Ned Lambert sidled down from the table. The editor’s blue eyes roved towards Mr Bloom’s face, shadowed by a smile.

—Will you join us, Myles? Ned Lambert asked.

MEMORABLE BATTLES RECALLED
—North Cork militia! the editor cried, striding to the mantelpiece. We won every time! North Cork and Spanish officers!

—Where was that, Myles? Ned Lambert asked with a reflective glance at his toecaps.

—In Ohio! the editor shouted.

—So it was, begad, Ned Lambert agreed.

Passing out he whispered to J. J. O’Molloy:

—Incipient jigs. Sad case.

—Ohio! the editor crowed in high treble from his uplifted scarlet face. My Ohio!

—A perfect cretic! the professor said. Long, short and long.

O, HARP EOLIAN!
He took a reel of dental floss from his waistcoat pocket and, breaking off a piece, twanged it smartly between two and two of his resonant unwashed teeth.

—Bingbang, bangbang.

Mr Bloom, seeing the coast clear, made for the inner door.

—Just a moment, Mr Crawford, he said. I just want to phone about an ad.

He went in.

—What about that leader this evening? professor MacHugh asked, coming to the editor and laying a firm hand on his shoulder.

—That’ll be all right, Myles Crawford said more calmly. Never you fret. Hello, Jack. That’s all right.

—Good day, Myles, J. J. O’Molloy said, letting the pages he held slip limply back on the file. Is that Canada swindle case on today?

The telephone whirred inside.

—Twentyeight... No, twenty... Double four... Yes.

SPOT THE WINNER
Lenehan came out of the inner office with Sport’s tissues.

—Who wants a dead cert for the Gold cup? he asked. Sceptre with O. Madden up.

He tossed the tissues on to the table.

Screams of newsboys barefoot in the hall rushed near and the door was flung open.

—Hush, Lenehan said. I hear feetstoops.

Professor MacHugh strode across the room and seized the cringing urchin by the collar as the others scampered out of the hall and down the steps. The tissues rustled up in the draught, floated softly in the air blue scrawls and under the table came to earth.

—It wasn’t me, sir. It was the big fellow shoved me, sir.

—Throw him out and shut the door, the editor said. There’s a hurricane blowing.

Lenehan began to paw the tissues up from the floor, grunting as he stooped twice.

—Waiting for the racing special, sir, the newsboy said. It was Pat Farrell shoved me, sir.

He pointed to two faces peering in round the doorframe.

—Him, sir.

—Out of this with you, professor MacHugh said gruffly.

He hustled the boy out and banged the door to.

J. J. O’Molloy turned the files crackingly over, murmuring, seeking:

—Continued on page six, column four.

—Yes, Evening Telegraph here, Mr Bloom phoned from the inner office. Is the boss...? Yes, Telegraph... To where? Aha! Which auction rooms?... Aha! I see... Right. I’ll catch him.

A COLLISION ENSUES
The bell whirred again as he rang off. He came in quickly and bumped against Lenehan who was struggling up with the second tissue.

—Pardon, monsieur, Lenehan said, clutching him for an instant and making a grimace.

—My fault, Mr Bloom said, suffering his grip. Are you hurt? I’m in a hurry.

—Knee, Lenehan said.

He made a comic face and whined, rubbing his knee:

—The accumulation of the anno Domini.

—Sorry, Mr Bloom said.

He went to the door and, holding it ajar, paused. J. J. O’Molloy slapped the heavy pages over. The noise of two shrill voices, a mouthorgan, echoed in the bare hallway from the newsboys squatted on the doorsteps:

We are the boys of Wexford
Who fought with heart and hand.

EXIT BLOOM
—I’m just running round to Bachelor’s walk, Mr Bloom said, about this ad of Keyes’s. Want to fix it up. They tell me he’s round there in Dillon’s.

He looked indecisively for a moment at their faces. The editor who, leaning against the mantelshelf, had propped his head on his hand, suddenly stretched forth an arm amply.

—Begone! he said. The world is before you.

—Back in no time, Mr Bloom said, hurrying out.

J. J. O’Molloy took the tissues from Lenehan’s hand and read them, blowing them apart gently, without comment.

—He’ll get that advertisement, the professor said, staring through his blackrimmed spectacles over the crossblind. Look at the young scamps after him.

—Show. Where? Lenehan cried, running to the window.

A STREET CORTÈGE
Both smiled over the crossblind at the file of capering newsboys in Mr Bloom’s wake, the last zigzagging white on the breeze a mocking kite, a tail of white bowknots.

—Look at the young guttersnipe behind him hue and cry, Lenehan said, and you’ll kick. O, my rib risible! Taking off his flat spaugs and the walk. Small nines. Steal upon larks.

He began to mazurka in swift caricature across the floor on sliding feet past the fireplace to J. J. O’Molloy who placed the tissues in his receiving hands.

—What’s that? Myles Crawford said with a start. Where are the other two gone?

—Who? the professor said, turning. They’re gone round to the Oval for a drink. Paddy Hooper is there with Jack Hall. Came over last night.

—Come on then, Myles Crawford said. Where’s my hat?

He walked jerkily into the office behind, parting the vent of his jacket, jingling his keys in his back pocket. They jingled then in the air and against the wood as he locked his desk drawer.

—He’s pretty well on, professor MacHugh said in a low voice.

—Seems to be, J. J. O’Molloy said, taking out a cigarettecase in murmuring meditation, but it is not always as it seems. Who has the most matches?

THE CALUMET OF PEACE
He offered a cigarette to the professor and took one himself. Lenehan promptly struck a match for them and lit their cigarettes in turn. J. J. O’Molloy opened his case again and offered it.

—Thanky vous, Lenehan said, helping himself.

The editor came from the inner office, a straw hat awry on his brow. He declaimed in song, pointing sternly at professor MacHugh:

’Twas rank and fame that tempted thee,
’Twas empire charmed thy heart.

The professor grinned, locking his long lips.

—Eh? You bloody old Roman empire? Myles Crawford said.

He took a cigarette from the open case. Lenehan, lighting it for him with quick grace, said:

—Silence for my brandnew riddle!

—Imperium romanum, J. J. O’Molloy said gently. It sounds nobler than British or Brixton. The word reminds one somehow of fat in the fire.

Myles Crawford blew his first puff violently towards the ceiling.

—That’s it, he said. We are the fat. You and I are the fat in the fire. We haven’t got the chance of a snowball in hell.

THE GRANDEUR THAT WAS ROME
—Wait a moment, professor MacHugh said, raising two quiet claws. We mustn’t be led away by words, by sounds of words. We think of Rome, imperial, imperious, imperative.

He extended elocutionary arms from frayed stained shirtcuffs, pausing:

—What was their civilisation? Vast, I allow: but vile. Cloacae: sewers. The Jews in the wilderness and on the mountaintop said: It is meet to be here. Let us build an altar to Jehovah. The Roman, like the Englishman who follows in his footsteps, brought to every new shore on which he set his foot (on our shore he never set it) only his cloacal obsession. He gazed about him in his toga and he said: It is meet to be here. Let us construct a watercloset.

—Which they accordingly did do, Lenehan said. Our old ancient ancestors, as we read in the first chapter of Guinness’s, were partial to the running stream.

—They were nature’s gentlemen, J. J. O’Molloy murmured. But we have also Roman law.

—And Pontius Pilate is its prophet, professor MacHugh responded.

—Do you know that story about chief baron Palles? J. J. O’Molloy asked. It was at the royal university dinner. Everything was going swimmingly ...

—First my riddle, Lenehan said. Are you ready?

Mr O’Madden Burke, tall in copious grey of Donegal tweed, came in from the hallway. Stephen Dedalus, behind him, uncovered as he entered.

—Entrez, mes enfants! Lenehan cried.

—I escort a suppliant, Mr O’Madden Burke said melodiously. Youth led by Experience visits Notoriety.

—How do you do? the editor said, holding out a hand. Come in. Your governor is just gone.

???
Lenehan said to all:

—Silence! What opera resembles a railwayline? Reflect, ponder, excogitate, reply.

Stephen handed over the typed sheets, pointing to the title and signature.

—Who? the editor asked.

Bit torn off.

—Mr Garrett Deasy, Stephen said.

—That old pelters, the editor said. Who tore it? Was he short taken?

On swift sail flaming
From storm and south
He comes, pale vampire,
Mouth to my mouth.

—Good day, Stephen, the professor said, coming to peer over their shoulders. Foot and mouth? Are you turned...?

Bullockbefriending bard.

SHINDY IN WELLKNOWN RESTAURANT
—Good day, sir, Stephen answered blushing. The letter is not mine. Mr Garrett Deasy asked me to...

—O, I know him, Myles Crawford said, and I knew his wife too. The bloodiest old tartar God ever made. By Jesus, she had the foot and mouth disease and no mistake! The night she threw the soup in the waiter’s face in the Star and Garter. Oho!

A woman brought sin into the world. For Helen, the runaway wife of Menelaus, ten years the Greeks. O’Rourke, prince of Breffni.

—Is he a widower? Stephen asked.

—Ay, a grass one, Myles Crawford said, his eye running down the typescript. Emperor’s horses. Habsburg. An Irishman saved his life on the ramparts of Vienna. Don’t you forget! Maximilian Karl O’Donnell, graf von Tirconnell in Ireland. Sent his heir over to make the king an Austrian fieldmarshal now. Going to be trouble there one day. Wild geese. O yes, every time. Don’t you forget that!

—The moot point is did he forget it, J. J. O’Molloy said quietly, turning a horseshoe paperweight. Saving princes is a thank you job.

Professor MacHugh turned on him.

—And if not? he said.

—I’ll tell you how it was, Myles Crawford began. A Hungarian it was one day...

LOST CAUSES NOBLE MARQUESS MENTIONED
—We were always loyal to lost causes, the professor said. Success for us is the death of the intellect and of the imagination. We were never loyal to the successful. We serve them. I teach the blatant Latin language. I speak the tongue of a race the acme of whose mentality is the maxim: time is money. Material domination. Dominus! Lord! Where is the spirituality? Lord Jesus? Lord Salisbury? A sofa in a westend club. But the Greek!

KYRIE ELEISON!
A smile of light brightened his darkrimmed eyes, lengthened his long lips.

—The Greek! he said again. Kyrios! Shining word! The vowels the Semite and the Saxon know not. Kyrie! The radiance of the intellect. I ought to profess Greek, the language of the mind. Kyrie eleison! The closetmaker and the cloacamaker will never be lords of our spirit. We are liege subjects of the catholic chivalry of Europe that foundered at Trafalgar and of the empire of the spirit, not an imperium, that went under with the Athenian fleets at Aegospotami. Yes, yes. They went under. Pyrrhus, misled by an oracle, made a last attempt to retrieve the fortunes of Greece. Loyal to a lost cause.

He strode away from them towards the window.

—They went forth to battle, Mr O’Madden Burke said greyly, but they always fell.

—Boohoo! Lenehan wept with a little noise. Owing to a brick received in the latter half of the matinée. Poor, poor, poor Pyrrhus!

He whispered then near Stephen’s ear:

LENEHAN’S LIMERICK
—There’s a ponderous pundit MacHugh
Who wears goggles of ebony hue.
As he mostly sees double
To wear them why trouble?
I can’t see the Joe Miller. Can you?


In mourning for Sallust, Mulligan says. Whose mother is beastly dead.

Myles Crawford crammed the sheets into a sidepocket.

—That’ll be all right, he said. I’ll read the rest after. That’ll be all right.

Lenehan extended his hands in protest.

—But my riddle! he said. What opera is like a railwayline?

—Opera? Mr O’Madden Burke’s sphinx face reriddled.

Lenehan announced gladly:

—The Rose of Castile. See the wheeze? Rows of cast steel. Gee!

He poked Mr O’Madden Burke mildly in the spleen. Mr O’Madden Burke fell back with grace on his umbrella, feigning a gasp.

—Help! he sighed. I feel a strong weakness.

Lenehan, rising to tiptoe, fanned his face rapidly with the rustling tissues.

The professor, returning by way of the files, swept his hand across Stephen’s and Mr O’Madden Burke’s loose ties.

—Paris, past and present, he said. You look like communards.

—Like fellows who had blown up the Bastile, J. J. O’Molloy said in quiet mockery. Or was it you shot the lord lieutenant of Finland between you? You look as though you had done the deed. General Bobrikoff.

OMNIUM GATHERUM
—We were only thinking about it, Stephen said.

—All the talents, Myles Crawford said. Law, the classics...

—The turf, Lenehan put in.

—Literature, the press.

—If Bloom were here, the professor said. The gentle art of advertisement.

—And Madam Bloom, Mr O’Madden Burke added. The vocal muse. Dublin’s prime favourite.

Lenehan gave a loud cough.

—Ahem! he said very softly. O, for a fresh of breath air! I caught a cold in the park. The gate was open.

“YOU CAN DO IT!”
The editor laid a nervous hand on Stephen’s shoulder.

—I want you to write something for me, he said. Something with a bite in it. You can do it. I see it in your face. In the lexicon of youth...

See it in your face. See it in your eye. Lazy idle little schemer.

—Foot and mouth disease! the editor cried in scornful invective. Great nationalist meeting in Borris-in-Ossory. All balls! Bulldosing the public! Give them something with a bite in it. Put us all into it, damn its soul. Father, Son and Holy Ghost and Jakes M’Carthy.

—We can all supply mental pabulum, Mr O’Madden Burke said.

Stephen raised his eyes to the bold unheeding stare.

—He wants you for the pressgang, J. J. O’Molloy said.

THE GREAT GALLAHER
—You can do it, Myles Crawford repeated, clenching his hand in emphasis. Wait a minute. We’ll paralyse Europe as Ignatius Gallaher used to say when he was on the shaughraun, doing billiardmarking in the Clarence. Gallaher, that was a pressman for you. That was a pen. You know how he made his mark? I’ll tell you. That was the smartest piece of journalism ever known. That was in eightyone, sixth of May, time of the invincibles, murder in the Phoenix park, before you were born, I suppose. I’ll show you.

He pushed past them to the files.

—Look at here, he said turning. The New York World cabled for a special. Remember that time?

Professor MacHugh nodded.

—New York World, the editor said, excitedly pushing back his straw hat. Where it took place. Tim Kelly, or Kavanagh I mean. Joe Brady and the rest of them. Where Skin-the-Goat drove the car. Whole route, see?

—Skin-the-Goat, Mr O’Madden Burke said. Fitzharris. He has that cabman’s shelter, they say, down there at Butt bridge. Holohan told me. You know Holohan?

—Hop and carry one, is it? Myles Crawford said.

—And poor Gumley is down there too, so he told me, minding stones for the corporation. A night watchman.

Stephen turned in surprise.

—Gumley? he said. You don’t say so? A friend of my father’s, is it?

—Never mind Gumley, Myles Crawford cried angrily. Let Gumley mind the stones, see they don’t run away. Look at here. What did Ignatius Gallaher do? I’ll tell you. Inspiration of genius. Cabled right away. Have you Weekly Freeman of 17 March? Right. Have you got that?

He flung back pages of the files and stuck his finger on a point.

—Take page four, advertisement for Bransome’s coffee, let us say. Have you got that? Right.

The telephone whirred.

A DISTANT VOICE
—I’ll answer it, the professor said, going.

—B is parkgate. Good.

His finger leaped and struck point after point, vibrating.

—T is viceregal lodge. C is where murder took place. K is Knockmaroon gate.

The loose flesh of his neck shook like a cock’s wattles. An illstarched dicky jutted up and with a rude gesture he thrust it back into his waistcoat.

—Hello? Evening Telegraph here... Hello?... Who’s there?... Yes... Yes... Yes.

—F to P is the route Skin-the-Goat drove the car for an alibi, Inchicore, Roundtown, Windy Arbour, Palmerston Park, Ranelagh. F.A.B.P. Got that? X is Davy’s publichouse in upper Leeson street.

The professor came to the inner door.

—Bloom is at the telephone, he said.

—Tell him go to hell, the editor said promptly. X is Davy’s publichouse, see?

CLEVER, VERY
—Clever, Lenehan said. Very.

—Gave it to them on a hot plate, Myles Crawford said, the whole bloody history.

Nightmare from which you will never awake.

—I saw it, the editor said proudly. I was present. Dick Adams, the besthearted bloody Corkman the Lord ever put the breath of life in, and myself.

Lenehan bowed to a shape of air, announcing:

—Madam, I’m Adam. And Able was I ere I saw Elba.

—History! Myles Crawford cried. The Old Woman of Prince’s street was there first. There was weeping and gnashing of teeth over that. Out of an advertisement. Gregor Grey made the design for it. That gave him the leg up. Then Paddy Hooper worked Tay Pay who took him on to the Star. Now he’s got in with Blumenfeld. That’s press. That’s talent. Pyatt! He was all their daddies!

—The father of scare journalism, Lenehan confirmed, and the brother-in-law of Chris Callinan.

—Hello?... Are you there?... Yes, he’s here still. Come across yourself.

—Where do you find a pressman like that now, eh? the editor cried.

He flung the pages down.

—Clamn dever, Lenehan said to Mr O’Madden Burke.

—Very smart, Mr O’Madden Burke said.

Professor MacHugh came from the inner office.

—Talking about the invincibles, he said, did you see that some hawkers were up before the recorder...

—O yes, J. J. O’Molloy said eagerly. Lady Dudley was walking home through the park to see all the trees that were blown down by that cyclone last year and thought she’d buy a view of Dublin. And it turned out to be a commemoration postcard of Joe Brady or Number One or Skin-the-Goat. Right outside the viceregal lodge, imagine!

—They’re only in the hook and eye department, Myles Crawford said. Psha! Press and the bar! Where have you a man now at the bar like those fellows, like Whiteside, like Isaac Butt, like silvertongued O’Hagan. Eh? Ah, bloody nonsense. Psha! Only in the halfpenny place.

His mouth continued to twitch unspeaking in nervous curls of disdain.

Would anyone wish that mouth for her kiss? How do you know? Why did you write it then?

RHYMES AND REASONS
Mouth, south. Is the mouth south someway? Or the south a mouth? Must be some. South, pout, out, shout, drouth. Rhymes: two men dressed the same, looking the same, two by two.

........................ la tua pace
.................. che parlar ti piace
Mentre che il vento, come fa, si tace.

He saw them three by three, approaching girls, in green, in rose, in russet, entwining, per l’aer perso, in mauve, in purple, quella pacifica oriafiamma, gold of oriflamme, di rimirar fè più ardenti. But I old men, penitent, leadenfooted, underdarkneath the night: mouth south: tomb womb.

—Speak up for yourself, Mr O’Madden Burke said.

SUFFICIENT FOR THE DAY...
J. J. O’Molloy, smiling palely, took up the gage.

—My dear Myles, he said, flinging his cigarette aside, you put a false construction on my words. I hold no brief, as at present advised, for the third profession qua profession but your Cork legs are running away with you. Why not bring in Henry Grattan and Flood and Demosthenes and Edmund Burke? Ignatius Gallaher we all know and his Chapelizod boss, Harmsworth of the farthing press, and his American cousin of the Bowery guttersheet not to mention Paddy Kelly’s Budget, Pue’s Occurrences and our watchful friend The Skibbereen Eagle. Why bring in a master of forensic eloquence like Whiteside? Sufficient for the day is the newspaper thereof.

LINKS WITH BYGONE DAYS OF YORE
—Grattan and Flood wrote for this very paper, the editor cried in his face. Irish volunteers. Where are you now? Established 1763. Dr Lucas. Who have you now like John Philpot Curran? Psha!

—Well, J. J. O’Molloy said, Bushe K.C., for example.

—Bushe? the editor said. Well, yes: Bushe, yes. He has a strain of it in his blood. Kendal Bushe or I mean Seymour Bushe.

—He would have been on the bench long ago, the professor said, only for .... But no matter.

J. J. O’Molloy turned to Stephen and said quietly and slowly:

—One of the most polished periods I think I ever listened to in my life fell from the lips of Seymour Bushe. It was in that case of fratricide, the Childs murder case. Bushe defended him.

And in the porches of mine ear did pour.

By the way how did he find that out? He died in his sleep. Or the other story, beast with two backs?

—What was that? the professor asked.

ITALIA, MAGISTRA ARTIUM
—He spoke on the law of evidence, J. J. O’Molloy said, of Roman justice as contrasted with the earlier Mosaic code, the lex talionis. And he cited the Moses of Michelangelo in the vatican.

—Ha.

—A few wellchosen words, Lenehan prefaced. Silence!

Pause. J. J. O’Molloy took out his cigarettecase.

False lull. Something quite ordinary.

Messenger took out his matchbox thoughtfully and lit his cigar.

I have often thought since on looking back over that strange time that it was that small act, trivial in itself, that striking of that match, that determined the whole aftercourse of both our lives.

A POLISHED PERIOD
J. J. O’Molloy resumed, moulding his words:

—He said of it: that stony effigy in frozen music, horned and terrible, of the human form divine, that eternal symbol of wisdom and of prophecy which, if aught that the imagination or the hand of sculptor has wrought in marble of soultransfigured and of soultransfiguring deserves to live, deserves to live.

His slim hand with a wave graced echo and fall.

—Fine! Myles Crawford said at once.

—The divine afflatus, Mr O’Madden Burke said.

—You like it? J. J. O’Molloy asked Stephen.

Stephen, his blood wooed by grace of language and gesture, blushed. He took a cigarette from the case. J. J. O’Molloy offered his case to Myles Crawford. Lenehan lit their cigarettes as before and took his trophy, saying:

—Muchibus thankibus.

A MAN OF HIGH MORALE
—Professor Magennis was speaking to me about you, J. J. O’Molloy said to Stephen. What do you think really of that hermetic crowd, the opal hush poets: A. E. the mastermystic? That Blavatsky woman started it. She was a nice old bag of tricks. A. E. has been telling some yankee interviewer that you came to him in the small hours of the morning to ask him about planes of consciousness. Magennis thinks you must have been pulling A. E.’s leg. He is a man of the very highest morale, Magennis.

Speaking about me. What did he say? What did he say? What did he say about me? Don’t ask.

—No, thanks, professor MacHugh said, waving the cigarettecase aside. Wait a moment. Let me say one thing. The finest display of oratory I ever heard was a speech made by John F Taylor at the college historical society. Mr Justice Fitzgibbon, the present lord justice of appeal, had spoken and the paper under debate was an essay (new for those days), advocating the revival of the Irish tongue.

He turned towards Myles Crawford and said:

—You know Gerald Fitzgibbon. Then you can imagine the style of his discourse.

—He is sitting with Tim Healy, J. J. O’Molloy said, rumour has it, on the Trinity college estates commission.

—He is sitting with a sweet thing, Myles Crawford said, in a child’s frock. Go on. Well?

—It was the speech, mark you, the professor said, of a finished orator, full of courteous haughtiness and pouring in chastened diction I will not say the vials of his wrath but pouring the proud man’s contumely upon the new movement. It was then a new movement. We were weak, therefore worthless.

He closed his long thin lips an instant but, eager to be on, raised an outspanned hand to his spectacles and, with trembling thumb and ringfinger touching lightly the black rims, steadied them to a new focus.

IMPROMPTU
In ferial tone he addressed J. J. O’Molloy:

—Taylor had come there, you must know, from a sickbed. That he had prepared his speech I do not believe for there was not even one shorthandwriter in the hall. His dark lean face had a growth of shaggy beard round it. He wore a loose white silk neckcloth and altogether he looked (though he was not) a dying man.

His gaze turned at once but slowly from J. J. O’Molloy’s towards Stephen’s face and then bent at once to the ground, seeking. His unglazed linen collar appeared behind his bent head, soiled by his withering hair. Still seeking, he said:

—When Fitzgibbon’s speech had ended John F Taylor rose to reply. Briefly, as well as I can bring them to mind, his words were these.

He raised his head firmly. His eyes bethought themselves once more. Witless shellfish swam in the gross lenses to and fro, seeking outlet.

He began:

—Mr Chairman, ladies and gentlemen: Great was my admiration in listening to the remarks addressed to the youth of Ireland a moment since by my learned friend. It seemed to me that I had been transported into a country far away from this country, into an age remote from this age, that I stood in ancient Egypt and that I was listening to the speech of some highpriest of that land addressed to the youthful Moses.

His listeners held their cigarettes poised to hear, their smokes ascending in frail stalks that flowered with his speech. And let our crooked smokes. Noble words coming. Look out. Could you try your hand at it yourself?

—And it seemed to me that I heard the voice of that Egyptian highpriest raised in a tone of like haughtiness and like pride. I heard his words and their meaning was revealed to me.

FROM THE FATHERS
It was revealed to me that those things are good which yet are corrupted which neither if they were supremely good nor unless they were good could be corrupted. Ah, curse you! That’s saint Augustine.

—Why will you jews not accept our culture, our religion and our language? You are a tribe of nomad herdsmen: we are a mighty people. You have no cities nor no wealth: our cities are hives of humanity and our galleys, trireme and quadrireme, laden with all manner merchandise furrow the waters of the known globe. You have but emerged from primitive conditions: we have a literature, a priesthood, an agelong history and a polity.

Nile.

Child, man, effigy.

By the Nilebank the babemaries kneel, cradle of bulrushes: a man supple in combat: stonehorned, stonebearded, heart of stone.

—You pray to a local and obscure idol: our temples, majestic and mysterious, are the abodes of Isis and Osiris, of Horus and Ammon Ra. Yours serfdom, awe and humbleness: ours thunder and the seas. Israel is weak and few are her children: Egypt is an host and terrible are her arms. Vagrants and daylabourers are you called: the world trembles at our name.

A dumb belch of hunger cleft his speech. He lifted his voice above it boldly:

—But, ladies and gentlemen, had the youthful Moses listened to and accepted that view of life, had he bowed his head and bowed his will and bowed his spirit before that arrogant admonition he would never have brought the chosen people out of their house of bondage, nor followed the pillar of the cloud by day. He would never have spoken with the Eternal amid lightnings on Sinai’s mountaintop nor ever have come down with the light of inspiration shining in his countenance and bearing in his arms the tables of the law, graven in the language of the outlaw.

He ceased and looked at them, enjoying a silence.

OMINOUS—FOR HIM!
J. J. O’Molloy said not without regret:

—And yet he died without having entered the land of promise.

—A—sudden—at—the—moment—though—from—lingering—illness—often—previously—expectorated—demise, Lenehan added. And with a great future behind him.

The troop of bare feet was heard rushing along the hallway and pattering up the staircase.

—That is oratory, the professor said uncontradicted.

Gone with the wind. Hosts at Mullaghmast and Tara of the kings. Miles of ears of porches. The tribune’s words, howled and scattered to the four winds. A people sheltered within his voice. Dead noise. Akasic records of all that ever anywhere wherever was. Love and laud him: me no more.

I have money.

—Gentlemen, Stephen said. As the next motion on the agenda paper may I suggest that the house do now adjourn?

—You take my breath away. It is not perchance a French compliment? Mr O’Madden Burke asked. ’Tis the hour, methinks, when the winejug, metaphorically speaking, is most grateful in Ye ancient hostelry.

—That it be and hereby is resolutely resolved. All that are in favour say ay, Lenehan announced. The contrary no. I declare it carried. To which particular boosing shed...? My casting vote is: Mooney’s!

He led the way, admonishing:

—We will sternly refuse to partake of strong waters, will we not? Yes, we will not. By no manner of means.

Mr O’Madden Burke, following close, said with an ally’s lunge of his umbrella:

—Lay on, Macduff!

—Chip of the old block! the editor cried, clapping Stephen on the shoulder. Let us go. Where are those blasted keys?

He fumbled in his pocket pulling out the crushed typesheets.

—Foot and mouth. I know. That’ll be all right. That’ll go in. Where are they? That’s all right.

He thrust the sheets back and went into the inner office.

LET US HOPE
J. J. O’Molloy, about to follow him in, said quietly to Stephen:

—I hope you will live to see it published. Myles, one moment.

He went into the inner office, closing the door behind him.

—Come along, Stephen, the professor said. That is fine, isn’t it? It has the prophetic vision. Fuit Ilium! The sack of windy Troy. Kingdoms of this world. The masters of the Mediterranean are fellaheen today.

The first newsboy came pattering down the stairs at their heels and rushed out into the street, yelling:

—Racing special!

Dublin. I have much, much to learn.

They turned to the left along Abbey street.

—I have a vision too, Stephen said.

—Yes? the professor said, skipping to get into step. Crawford will follow.

Another newsboy shot past them, yelling as he ran:

—Racing special!

DEAR DIRTY DUBLIN
Dubliners.

—Two Dublin vestals, Stephen said, elderly and pious, have lived fifty and fiftythree years in Fumbally’s lane.

—Where is that? the professor asked.

—Off Blackpitts, Stephen said.

Damp night reeking of hungry dough. Against the wall. Face glistering tallow under her fustian shawl. Frantic hearts. Akasic records. Quicker, darlint!

On now. Dare it. Let there be life.

—They want to see the views of Dublin from the top of Nelson’s pillar. They save up three and tenpence in a red tin letterbox moneybox. They shake out the threepenny bits and sixpences and coax out the pennies with the blade of a knife. Two and three in silver and one and seven in coppers. They put on their bonnets and best clothes and take their umbrellas for fear it may come on to rain.

—Wise virgins, professor MacHugh said.

LIFE ON THE RAW
—They buy one and fourpenceworth of brawn and four slices of panloaf at the north city diningrooms in Marlborough street from Miss Kate Collins, proprietress... They purchase four and twenty ripe plums from a girl at the foot of Nelson’s pillar to take off the thirst of the brawn. They give two threepenny bits to the gentleman at the turnstile and begin to waddle slowly up the winding staircase, grunting, encouraging each other, afraid of the dark, panting, one asking the other have you the brawn, praising God and the Blessed Virgin, threatening to come down, peeping at the airslits. Glory be to God. They had no idea it was that high.

Their names are Anne Kearns and Florence MacCabe. Anne Kearns has the lumbago for which she rubs on Lourdes water, given her by a lady who got a bottleful from a passionist father. Florence MacCabe takes a crubeen and a bottle of double X for supper every Saturday.

—Antithesis, the professor said nodding twice. Vestal virgins. I can see them. What’s keeping our friend?

He turned.

A bevy of scampering newsboys rushed down the steps, scattering in all directions, yelling, their white papers fluttering. Hard after them Myles Crawford appeared on the steps, his hat aureoling his scarlet face, talking with J. J. O’Molloy.

—Come along, the professor cried, waving his arm.

He set off again to walk by Stephen’s side.

RETURN OF BLOOM
—Yes, he said. I see them.

Mr Bloom, breathless, caught in a whirl of wild newsboys near the offices of the Irish Catholic and Dublin Penny Journal, called:

—Mr Crawford! A moment!

—Telegraph! Racing special!

—What is it? Myles Crawford said, falling back a pace.

A newsboy cried in Mr Bloom’s face:

—Terrible tragedy in Rathmines! A child bit by a bellows!

INTERVIEW WITH THE EDITOR
—Just this ad, Mr Bloom said, pushing through towards the steps, puffing, and taking the cutting from his pocket. I spoke with Mr Keyes just now. He’ll give a renewal for two months, he says. After he’ll see. But he wants a par to call attention in the Telegraph too, the Saturday pink. And he wants it copied if it’s not too late I told councillor Nannetti from the Kilkenny People. I can have access to it in the national library. House of keys, don’t you see? His name is Keyes. It’s a play on the name. But he practically promised he’d give the renewal. But he wants just a little puff. What will I tell him, Mr Crawford?

K.M.A.
—Will you tell him he can kiss my arse? Myles Crawford said throwing out his arm for emphasis. Tell him that straight from the stable.

A bit nervy. Look out for squalls. All off for a drink. Arm in arm. Lenehan’s yachting cap on the cadge beyond. Usual blarney. Wonder is that young Dedalus the moving spirit. Has a good pair of boots on him today. Last time I saw him he had his heels on view. Been walking in muck somewhere. Careless chap. What was he doing in Irishtown?

—Well, Mr Bloom said, his eyes returning, if I can get the design I suppose it’s worth a short par. He’d give the ad, I think. I’ll tell him...

K.M.R.I.A.
—He can kiss my royal Irish arse, Myles Crawford cried loudly over his shoulder. Any time he likes, tell him.

While Mr Bloom stood weighing the point and about to smile he strode on jerkily.

RAISING THE WIND
—Nulla bona, Jack, he said, raising his hand to his chin. I’m up to here. I’ve been through the hoop myself. I was looking for a fellow to back a bill for me no later than last week. Sorry, Jack. You must take the will for the deed. With a heart and a half if I could raise the wind anyhow.

J. J. O’Molloy pulled a long face and walked on silently. They caught up on the others and walked abreast.

—When they have eaten the brawn and the bread and wiped their twenty fingers in the paper the bread was wrapped in they go nearer to the railings.

—Something for you, the professor explained to Myles Crawford. Two old Dublin women on the top of Nelson’s pillar.

SOME COLUMN!—THAT’S WHAT WADDLER ONE SAID
—That’s new, Myles Crawford said. That’s copy. Out for the waxies’ Dargle. Two old trickies, what?

—But they are afraid the pillar will fall, Stephen went on. They see the roofs and argue about where the different churches are: Rathmines’ blue dome, Adam and Eve’s, saint Laurence O’Toole’s. But it makes them giddy to look so they pull up their skirts...

THOSE SLIGHTLY RAMBUNCTIOUS FEMALES
—Easy all, Myles Crawford said. No poetic licence. We’re in the archdiocese here.

—And settle down on their striped petticoats, peering up at the statue of the onehandled adulterer.

—Onehandled adulterer! the professor cried. I like that. I see the idea. I see what you mean.

DAMES DONATE DUBLIN’S CITS SPEEDPILLS VELOCITOUS AEROLITHS, BELIEF
—It gives them a crick in their necks, Stephen said, and they are too tired to look up or down or to speak. They put the bag of plums between them and eat the plums out of it, one after another, wiping off with their handkerchiefs the plumjuice that dribbles out of their mouths and spitting the plumstones slowly out between the railings.

He gave a sudden loud young laugh as a close. Lenehan and Mr O’Madden Burke, hearing, turned, beckoned and led on across towards Mooney’s.

—Finished? Myles Crawford said. So long as they do no worse.

SOPHIST WALLOPS HAUGHTY HELEN SQUARE ON PROBOSCIS. SPARTANS GNASH MOLARS. ITHACANS VOW PEN IS CHAMP.
—You remind me of Antisthenes, the professor said, a disciple of Gorgias, the sophist. It is said of him that none could tell if he were bitterer against others or against himself. He was the son of a noble and a bondwoman. And he wrote a book in which he took away the palm of beauty from Argive Helen and handed it to poor Penelope.

Poor Penelope. Penelope Rich.

They made ready to cross O’Connell street.

HELLO THERE, CENTRAL!
At various points along the eight lines tramcars with motionless trolleys stood in their tracks, bound for or from Rathmines, Rathfarnham, Blackrock, Kingstown and Dalkey, Sandymount Green, Ringsend and Sandymount Tower, Donnybrook, Palmerston Park and Upper Rathmines, all still, becalmed in short circuit. Hackney cars, cabs, delivery waggons, mailvans, private broughams, aerated mineral water floats with rattling crates of bottles, rattled, rolled, horsedrawn, rapidly.

WHAT?—AND LIKEWISE—WHERE?
—But what do you call it? Myles Crawford asked. Where did they get the plums?

VIRGILIAN, SAYS PEDAGOGUE. SOPHOMORE PLUMPS FOR OLD MAN MOSES.
—Call it, wait, the professor said, opening his long lips wide to reflect. Call it, let me see. Call it: deus nobis hæc otia fecit.

—No, Stephen said. I call it A Pisgah Sight of Palestine or The Parable of The Plums.

—I see, the professor said.

He laughed richly.

—I see, he said again with new pleasure. Moses and the promised land. We gave him that idea, he added to J. J. O’Molloy.

HORATIO IS CYNOSURE THIS FAIR JUNE DAY
J. J. O’Molloy sent a weary sidelong glance towards the statue and held his peace.

—I see, the professor said.

He halted on sir John Gray’s pavement island and peered aloft at Nelson through the meshes of his wry smile.

DIMINISHED DIGITS PROVE TOO TITILLATING FOR FRISKY FRUMPS. ANNE WIMBLES, FLO WANGLES—YET CAN YOU BLAME THEM?
—Onehandled adulterer, he said smiling grimly. That tickles me, I must say.

—Tickled the old ones too, Myles Crawford said, if the God Almighty’s truth was known.

### [ 8 ]
Pineapple rock, lemon platt, butter scotch. A sugarsticky girl shovelling scoopfuls of creams for a christian brother. Some school treat. Bad for their tummies. Lozenge and comfit manufacturer to His Majesty the King. God. Save. Our. Sitting on his throne sucking red jujubes white.

A sombre Y. M. C. A. young man, watchful among the warm sweet fumes of Graham Lemon’s, placed a throwaway in a hand of Mr Bloom.

Heart to heart talks.

Bloo... Me? No.

Blood of the Lamb.

His slow feet walked him riverward, reading. Are you saved? All are washed in the blood of the lamb. God wants blood victim. Birth, hymen, martyr, war, foundation of a building, sacrifice, kidney burntoffering, druids’ altars. Elijah is coming. Dr John Alexander Dowie restorer of the church in Zion is coming.

Is coming! Is coming!! Is coming!!!
All heartily welcome.

Paying game. Torry and Alexander last year. Polygamy. His wife will put the stopper on that. Where was that ad some Birmingham firm the luminous crucifix. Our Saviour. Wake up in the dead of night and see him on the wall, hanging. Pepper’s ghost idea. Iron Nails Ran In.

Phosphorus it must be done with. If you leave a bit of codfish for instance. I could see the bluey silver over it. Night I went down to the pantry in the kitchen. Don’t like all the smells in it waiting to rush out. What was it she wanted? The Malaga raisins. Thinking of Spain. Before Rudy was born. The phosphorescence, that bluey greeny. Very good for the brain.

From Butler’s monument house corner he glanced along Bachelor’s walk. Dedalus’ daughter there still outside Dillon’s auctionrooms. Must be selling off some old furniture. Knew her eyes at once from the father. Lobbing about waiting for him. Home always breaks up when the mother goes. Fifteen children he had. Birth every year almost. That’s in their theology or the priest won’t give the poor woman the confession, the absolution. Increase and multiply. Did you ever hear such an idea? Eat you out of house and home. No families themselves to feed. Living on the fat of the land. Their butteries and larders. I’d like to see them do the black fast Yom Kippur. Crossbuns. One meal and a collation for fear he’d collapse on the altar. A housekeeper of one of those fellows if you could pick it out of her. Never pick it out of her. Like getting £. s. d. out of him. Does himself well. No guests. All for number one. Watching his water. Bring your own bread and butter. His reverence: mum’s the word.

Good Lord, that poor child’s dress is in flitters. Underfed she looks too. Potatoes and marge, marge and potatoes. It’s after they feel it. Proof of the pudding. Undermines the constitution.

As he set foot on O’Connell bridge a puffball of smoke plumed up from the parapet. Brewery barge with export stout. England. Sea air sours it, I heard. Be interesting some day get a pass through Hancock to see the brewery. Regular world in itself. Vats of porter wonderful. Rats get in too. Drink themselves bloated as big as a collie floating. Dead drunk on the porter. Drink till they puke again like christians. Imagine drinking that! Rats: vats. Well, of course, if we knew all the things.

Looking down he saw flapping strongly, wheeling between the gaunt quaywalls, gulls. Rough weather outside. If I threw myself down? Reuben J’s son must have swallowed a good bellyful of that sewage. One and eightpence too much. Hhhhm. It’s the droll way he comes out with the things. Knows how to tell a story too.

They wheeled lower. Looking for grub. Wait.

He threw down among them a crumpled paper ball. Elijah thirtytwo feet per sec is com. Not a bit. The ball bobbed unheeded on the wake of swells, floated under by the bridgepiers. Not such damn fools. Also the day I threw that stale cake out of the Erin’s King picked it up in the wake fifty yards astern. Live by their wits. They wheeled, flapping.

The hungry famished gull
Flaps o’er the waters dull.

That is how poets write, the similar sounds. But then Shakespeare has no rhymes: blank verse. The flow of the language it is. The thoughts. Solemn.

Hamlet, I am thy father’s spirit
Doomed for a certain time to walk the earth.

—Two apples a penny! Two for a penny!

His gaze passed over the glazed apples serried on her stand. Australians they must be this time of year. Shiny peels: polishes them up with a rag or a handkerchief.

Wait. Those poor birds.

He halted again and bought from the old applewoman two Banbury cakes for a penny and broke the brittle paste and threw its fragments down into the Liffey. See that? The gulls swooped silently, two, then all from their heights, pouncing on prey. Gone. Every morsel.

Aware of their greed and cunning he shook the powdery crumb from his hands. They never expected that. Manna. Live on fish, fishy flesh they have, all seabirds, gulls, seagoose. Swans from Anna Liffey swim down here sometimes to preen themselves. No accounting for tastes. Wonder what kind is swanmeat. Robinson Crusoe had to live on them.

They wheeled flapping weakly. I’m not going to throw any more. Penny quite enough. Lot of thanks I get. Not even a caw. They spread foot and mouth disease too. If you cram a turkey say on chestnutmeal it tastes like that. Eat pig like pig. But then why is it that saltwater fish are not salty? How is that?

His eyes sought answer from the river and saw a rowboat rock at anchor on the treacly swells lazily its plastered board.

Kino’s
11/—
Trousers

Good idea that. Wonder if he pays rent to the corporation. How can you own water really? It’s always flowing in a stream, never the same, which in the stream of life we trace. Because life is a stream. All kinds of places are good for ads. That quack doctor for the clap used to be stuck up in all the greenhouses. Never see it now. Strictly confidential. Dr Hy Franks. Didn’t cost him a red like Maginni the dancing master self advertisement. Got fellows to stick them up or stick them up himself for that matter on the q. t. running in to loosen a button. Flybynight. Just the place too. POST NO BILLS. POST 110 PILLS. Some chap with a dose burning him.

If he...?

O!

Eh?

No... No.

No, no. I don’t believe it. He wouldn’t surely?

No, no.

Mr Bloom moved forward, raising his troubled eyes. Think no more about that. After one. Timeball on the ballastoffice is down. Dunsink time. Fascinating little book that is of sir Robert Ball’s. Parallax. I never exactly understood. There’s a priest. Could ask him. Par it’s Greek: parallel, parallax. Met him pike hoses she called it till I told her about the transmigration. O rocks!

Mr Bloom smiled O rocks at two windows of the ballastoffice. She’s right after all. Only big words for ordinary things on account of the sound. She’s not exactly witty. Can be rude too. Blurt out what I was thinking. Still, I don’t know. She used to say Ben Dollard had a base barreltone voice. He has legs like barrels and you’d think he was singing into a barrel. Now, isn’t that wit. They used to call him big Ben. Not half as witty as calling him base barreltone. Appetite like an albatross. Get outside of a baron of beef. Powerful man he was at stowing away number one Bass. Barrel of Bass. See? It all works out.

A procession of whitesmocked sandwichmen marched slowly towards him along the gutter, scarlet sashes across their boards. Bargains. Like that priest they are this morning: we have sinned: we have suffered. He read the scarlet letters on their five tall white hats: H. E. L. Y. S. Wisdom Hely’s. Y lagging behind drew a chunk of bread from under his foreboard, crammed it into his mouth and munched as he walked. Our staple food. Three bob a day, walking along the gutters, street after street. Just keep skin and bone together, bread and skilly. They are not Boyl: no, M’Glade’s men. Doesn’t bring in any business either. I suggested to him about a transparent showcart with two smart girls sitting inside writing letters, copybooks, envelopes, blottingpaper. I bet that would have caught on. Smart girls writing something catch the eye at once. Everyone dying to know what she’s writing. Get twenty of them round you if you stare at nothing. Have a finger in the pie. Women too. Curiosity. Pillar of salt. Wouldn’t have it of course because he didn’t think of it himself first. Or the inkbottle I suggested with a false stain of black celluloid. His ideas for ads like Plumtree’s potted under the obituaries, cold meat department. You can’t lick ’em. What? Our envelopes. Hello, Jones, where are you going? Can’t stop, Robinson, I am hastening to purchase the only reliable inkeraser Kansell, sold by Hely’s Ltd, 85 Dame street. Well out of that ruck I am. Devil of a job it was collecting accounts of those convents. Tranquilla convent. That was a nice nun there, really sweet face. Wimple suited her small head. Sister? Sister? I am sure she was crossed in love by her eyes. Very hard to bargain with that sort of a woman. I disturbed her at her devotions that morning. But glad to communicate with the outside world. Our great day, she said. Feast of Our Lady of Mount Carmel. Sweet name too: caramel. She knew I, I think she knew by the way she. If she had married she would have changed. I suppose they really were short of money. Fried everything in the best butter all the same. No lard for them. My heart’s broke eating dripping. They like buttering themselves in and out. Molly tasting it, her veil up. Sister? Pat Claffey, the pawnbroker’s daughter. It was a nun they say invented barbed wire.

He crossed Westmoreland street when apostrophe S had plodded by. Rover cycleshop. Those races are on today. How long ago is that? Year Phil Gilligan died. We were in Lombard street west. Wait: was in Thom’s. Got the job in Wisdom Hely’s year we married. Six years. Ten years ago: ninetyfour he died yes that’s right the big fire at Arnott’s. Val Dillon was lord mayor. The Glencree dinner. Alderman Robert O’Reilly emptying the port into his soup before the flag fell. Bobbob lapping it for the inner alderman. Couldn’t hear what the band played. For what we have already received may the Lord make us. Milly was a kiddy then. Molly had that elephantgrey dress with the braided frogs. Mantailored with selfcovered buttons. She didn’t like it because I sprained my ankle first day she wore choir picnic at the Sugarloaf. As if that. Old Goodwin’s tall hat done up with some sticky stuff. Flies’ picnic too. Never put a dress on her back like it. Fitted her like a glove, shoulders and hips. Just beginning to plump it out well. Rabbitpie we had that day. People looking after her.

Happy. Happier then. Snug little room that was with the red wallpaper. Dockrell’s, one and ninepence a dozen. Milly’s tubbing night. American soap I bought: elderflower. Cosy smell of her bathwater. Funny she looked soaped all over. Shapely too. Now photography. Poor papa’s daguerreotype atelier he told me of. Hereditary taste.

He walked along the curbstone.

Stream of life. What was the name of that priestylooking chap was always squinting in when he passed? Weak eyes, woman. Stopped in Citron’s saint Kevin’s parade. Pen something. Pendennis? My memory is getting. Pen ...? Of course it’s years ago. Noise of the trams probably. Well, if he couldn’t remember the dayfather’s name that he sees every day.

Bartell d’Arcy was the tenor, just coming out then. Seeing her home after practice. Conceited fellow with his waxedup moustache. Gave her that song Winds that blow from the south.

Windy night that was I went to fetch her there was that lodge meeting on about those lottery tickets after Goodwin’s concert in the supperroom or oakroom of the Mansion house. He and I behind. Sheet of her music blew out of my hand against the High school railings. Lucky it didn’t. Thing like that spoils the effect of a night for her. Professor Goodwin linking her in front. Shaky on his pins, poor old sot. His farewell concerts. Positively last appearance on any stage. May be for months and may be for never. Remember her laughing at the wind, her blizzard collar up. Corner of Harcourt road remember that gust. Brrfoo! Blew up all her skirts and her boa nearly smothered old Goodwin. She did get flushed in the wind. Remember when we got home raking up the fire and frying up those pieces of lap of mutton for her supper with the Chutney sauce she liked. And the mulled rum. Could see her in the bedroom from the hearth unclamping the busk of her stays: white.

Swish and soft flop her stays made on the bed. Always warm from her. Always liked to let her self out. Sitting there after till near two taking out her hairpins. Milly tucked up in beddyhouse. Happy. Happy. That was the night...

—O, Mr Bloom, how do you do?

—O, how do you do, Mrs Breen?

—No use complaining. How is Molly those times? Haven’t seen her for ages.

—In the pink, Mr Bloom said gaily. Milly has a position down in Mullingar, you know.

—Go away! Isn’t that grand for her?

—Yes. In a photographer’s there. Getting on like a house on fire. How are all your charges?

—All on the baker’s list, Mrs Breen said.

How many has she? No other in sight.

—You’re in black, I see. You have no...

—No, Mr Bloom said. I have just come from a funeral.

Going to crop up all day, I foresee. Who’s dead, when and what did he die of? Turn up like a bad penny.

—O, dear me, Mrs Breen said. I hope it wasn’t any near relation.

May as well get her sympathy.

—Dignam, Mr Bloom said. An old friend of mine. He died quite suddenly, poor fellow. Heart trouble, I believe. Funeral was this morning.

Your funeral’s tomorrow
While you’re coming through the rye.
Diddlediddle dumdum
Diddlediddle...

—Sad to lose the old friends, Mrs Breen’s womaneyes said melancholily.

Now that’s quite enough about that. Just: quietly: husband.

—And your lord and master?

Mrs Breen turned up her two large eyes. Hasn’t lost them anyhow.

—O, don’t be talking! she said. He’s a caution to rattlesnakes. He’s in there now with his lawbooks finding out the law of libel. He has me heartscalded. Wait till I show you.

Hot mockturtle vapour and steam of newbaked jampuffs rolypoly poured out from Harrison’s. The heavy noonreek tickled the top of Mr Bloom’s gullet. Want to make good pastry, butter, best flour, Demerara sugar, or they’d taste it with the hot tea. Or is it from her? A barefoot arab stood over the grating, breathing in the fumes. Deaden the gnaw of hunger that way. Pleasure or pain is it? Penny dinner. Knife and fork chained to the table.

Opening her handbag, chipped leather. Hatpin: ought to have a guard on those things. Stick it in a chap’s eye in the tram. Rummaging. Open. Money. Please take one. Devils if they lose sixpence. Raise Cain. Husband barging. Where’s the ten shillings I gave you on Monday? Are you feeding your little brother’s family? Soiled handkerchief: medicinebottle. Pastille that was fell. What is she?...

—There must be a new moon out, she said. He’s always bad then. Do you know what he did last night?

Her hand ceased to rummage. Her eyes fixed themselves on him, wide in alarm, yet smiling.

—What? Mr Bloom asked.

Let her speak. Look straight in her eyes. I believe you. Trust me.

—Woke me up in the night, she said. Dream he had, a nightmare.

Indiges.

—Said the ace of spades was walking up the stairs.

—The ace of spades! Mr Bloom said.

She took a folded postcard from her handbag.

—Read that, she said. He got it this morning.

—What is it? Mr Bloom asked, taking the card. U. P.?

—U. p: up, she said. Someone taking a rise out of him. It’s a great shame for them whoever he is.

—Indeed it is, Mr Bloom said.

She took back the card, sighing.

—And now he’s going round to Mr Menton’s office. He’s going to take an action for ten thousand pounds, he says.

She folded the card into her untidy bag and snapped the catch.

Same blue serge dress she had two years ago, the nap bleaching. Seen its best days. Wispish hair over her ears. And that dowdy toque: three old grapes to take the harm out of it. Shabby genteel. She used to be a tasty dresser. Lines round her mouth. Only a year or so older than Molly.

See the eye that woman gave her, passing. Cruel. The unfair sex.

He looked still at her, holding back behind his look his discontent. Pungent mockturtle oxtail mulligatawny. I’m hungry too. Flakes of pastry on the gusset of her dress: daub of sugary flour stuck to her cheek. Rhubarb tart with liberal fillings, rich fruit interior. Josie Powell that was. In Luke Doyle’s long ago. Dolphin’s Barn, the charades. U. p: up.

Change the subject.

—Do you ever see anything of Mrs Beaufoy? Mr Bloom asked.

—Mina Purefoy? she said.

Philip Beaufoy I was thinking. Playgoers’ Club. Matcham often thinks of the masterstroke. Did I pull the chain? Yes. The last act.

—Yes.

—I just called to ask on the way in is she over it. She’s in the lying-in hospital in Holles street. Dr Horne got her in. She’s three days bad now.

—O, Mr Bloom said. I’m sorry to hear that.

—Yes, Mrs Breen said. And a houseful of kids at home. It’s a very stiff birth, the nurse told me.

—O, Mr Bloom said.

His heavy pitying gaze absorbed her news. His tongue clacked in compassion. Dth! Dth!

—I’m sorry to hear that, he said. Poor thing! Three days! That’s terrible for her.

Mrs Breen nodded.

—She was taken bad on the Tuesday...

Mr Bloom touched her funnybone gently, warning her:

—Mind! Let this man pass.

A bony form strode along the curbstone from the river staring with a rapt gaze into the sunlight through a heavystringed glass. Tight as a skullpiece a tiny hat gripped his head. From his arm a folded dustcoat, a stick and an umbrella dangled to his stride.

—Watch him, Mr Bloom said. He always walks outside the lampposts. Watch!

—Who is he if it’s a fair question? Mrs Breen asked. Is he dotty?

—His name is Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell, Mr Bloom said smiling. Watch!

—He has enough of them, she said. Denis will be like that one of these days.

She broke off suddenly.

—There he is, she said. I must go after him. Goodbye. Remember me to Molly, won’t you?

—I will, Mr Bloom said.

He watched her dodge through passers towards the shopfronts. Denis Breen in skimpy frockcoat and blue canvas shoes shuffled out of Harrison’s hugging two heavy tomes to his ribs. Blown in from the bay. Like old times. He suffered her to overtake him without surprise and thrust his dull grey beard towards her, his loose jaw wagging as he spoke earnestly.

Meshuggah. Off his chump.

Mr Bloom walked on again easily, seeing ahead of him in sunlight the tight skullpiece, the dangling stickumbrelladustcoat. Going the two days. Watch him! Out he goes again. One way of getting on in the world. And that other old mosey lunatic in those duds. Hard time she must have with him.

U. p: up. I’ll take my oath that’s Alf Bergan or Richie Goulding. Wrote it for a lark in the Scotch house I bet anything. Round to Menton’s office. His oyster eyes staring at the postcard. Be a feast for the gods.

He passed the Irish Times. There might be other answers lying there. Like to answer them all. Good system for criminals. Code. At their lunch now. Clerk with the glasses there doesn’t know me. O, leave them there to simmer. Enough bother wading through fortyfour of them. Wanted, smart lady typist to aid gentleman in literary work. I called you naughty darling because I do not like that other world. Please tell me what is the meaning. Please tell me what perfume does your wife. Tell me who made the world. The way they spring those questions on you. And the other one Lizzie Twigg. My literary efforts have had the good fortune to meet with the approval of the eminent poet A. E. (Mr Geo. Russell). No time to do her hair drinking sloppy tea with a book of poetry.

Best paper by long chalks for a small ad. Got the provinces now. Cook and general, exc. cuisine, housemaid kept. Wanted live man for spirit counter. Resp. girl (R.C.) wishes to hear of post in fruit or pork shop. James Carlisle made that. Six and a half per cent dividend. Made a big deal on Coates’s shares. Ca’ canny. Cunning old Scotch hunks. All the toady news. Our gracious and popular vicereine. Bought the Irish Field now. Lady Mountcashel has quite recovered after her confinement and rode out with the Ward Union staghounds at the enlargement yesterday at Rathoath. Uneatable fox. Pothunters too. Fear injects juices make it tender enough for them. Riding astride. Sit her horse like a man. Weightcarrying huntress. No sidesaddle or pillion for her, not for Joe. First to the meet and in at the death. Strong as a brood mare some of those horsey women. Swagger around livery stables. Toss off a glass of brandy neat while you’d say knife. That one at the Grosvenor this morning. Up with her on the car: wishswish. Stonewall or fivebarred gate put her mount to it. Think that pugnosed driver did it out of spite. Who is this she was like? O yes! Mrs Miriam Dandrade that sold me her old wraps and black underclothes in the Shelbourne hotel. Divorced Spanish American. Didn’t take a feather out of her my handling them. As if I was her clotheshorse. Saw her in the viceregal party when Stubbs the park ranger got me in with Whelan of the Express. Scavenging what the quality left. High tea. Mayonnaise I poured on the plums thinking it was custard. Her ears ought to have tingled for a few weeks after. Want to be a bull for her. Born courtesan. No nursery work for her, thanks.

Poor Mrs Purefoy! Methodist husband. Method in his madness. Saffron bun and milk and soda lunch in the educational dairy. Y. M. C. A. Eating with a stopwatch, thirtytwo chews to the minute. And still his muttonchop whiskers grew. Supposed to be well connected. Theodore’s cousin in Dublin Castle. One tony relative in every family. Hardy annuals he presents her with. Saw him out at the Three Jolly Topers marching along bareheaded and his eldest boy carrying one in a marketnet. The squallers. Poor thing! Then having to give the breast year after year all hours of the night. Selfish those t.t’s are. Dog in the manger. Only one lump of sugar in my tea, if you please.

He stood at Fleet street crossing. Luncheon interval. A sixpenny at Rowe’s? Must look up that ad in the national library. An eightpenny in the Burton. Better. On my way.

He walked on past Bolton’s Westmoreland house. Tea. Tea. Tea. I forgot to tap Tom Kernan.

Sss. Dth, dth, dth! Three days imagine groaning on a bed with a vinegared handkerchief round her forehead, her belly swollen out. Phew! Dreadful simply! Child’s head too big: forceps. Doubled up inside her trying to butt its way out blindly, groping for the way out. Kill me that would. Lucky Molly got over hers lightly. They ought to invent something to stop that. Life with hard labour. Twilight sleep idea: queen Victoria was given that. Nine she had. A good layer. Old woman that lived in a shoe she had so many children. Suppose he was consumptive. Time someone thought about it instead of gassing about the what was it the pensive bosom of the silver effulgence. Flapdoodle to feed fools on. They could easily have big establishments whole thing quite painless out of all the taxes give every child born five quid at compound interest up to twentyone five per cent is a hundred shillings and five tiresome pounds multiply by twenty decimal system encourage people to put by money save hundred and ten and a bit twentyone years want to work it out on paper come to a tidy sum more than you think.

Not stillborn of course. They are not even registered. Trouble for nothing.

Funny sight two of them together, their bellies out. Molly and Mrs Moisel. Mothers’ meeting. Phthisis retires for the time being, then returns. How flat they look all of a sudden after. Peaceful eyes. Weight off their mind. Old Mrs Thornton was a jolly old soul. All my babies, she said. The spoon of pap in her mouth before she fed them. O, that’s nyumnyum. Got her hand crushed by old Tom Wall’s son. His first bow to the public. Head like a prize pumpkin. Snuffy Dr Murren. People knocking them up at all hours. For God’ sake, doctor. Wife in her throes. Then keep them waiting months for their fee. To attendance on your wife. No gratitude in people. Humane doctors, most of them.

Before the huge high door of the Irish house of parliament a flock of pigeons flew. Their little frolic after meals. Who will we do it on? I pick the fellow in black. Here goes. Here’s good luck. Must be thrilling from the air. Apjohn, myself and Owen Goldberg up in the trees near Goose green playing the monkeys. Mackerel they called me.

A squad of constables debouched from College street, marching in Indian file. Goosestep. Foodheated faces, sweating helmets, patting their truncheons. After their feed with a good load of fat soup under their belts. Policeman’s lot is oft a happy one. They split up in groups and scattered, saluting, towards their beats. Let out to graze. Best moment to attack one in pudding time. A punch in his dinner. A squad of others, marching irregularly, rounded Trinity railings making for the station. Bound for their troughs. Prepare to receive cavalry. Prepare to receive soup.

He crossed under Tommy Moore’s roguish finger. They did right to put him up over a urinal: meeting of the waters. Ought to be places for women. Running into cakeshops. Settle my hat straight. There is not in this wide world a vallee. Great song of Julia Morkan’s. Kept her voice up to the very last. Pupil of Michael Balfe’s, wasn’t she?

He gazed after the last broad tunic. Nasty customers to tackle. Jack Power could a tale unfold: father a G man. If a fellow gave them trouble being lagged they let him have it hot and heavy in the bridewell. Can’t blame them after all with the job they have especially the young hornies. That horsepoliceman the day Joe Chamberlain was given his degree in Trinity he got a run for his money. My word he did! His horse’s hoofs clattering after us down Abbey street. Lucky I had the presence of mind to dive into Manning’s or I was souped. He did come a wallop, by George. Must have cracked his skull on the cobblestones. I oughtn’t to have got myself swept along with those medicals. And the Trinity jibs in their mortarboards. Looking for trouble. Still I got to know that young Dixon who dressed that sting for me in the Mater and now he’s in Holles street where Mrs Purefoy. Wheels within wheels. Police whistle in my ears still. All skedaddled. Why he fixed on me. Give me in charge. Right here it began.

—Up the Boers!

—Three cheers for De Wet!

—We’ll hang Joe Chamberlain on a sourapple tree.

Silly billies: mob of young cubs yelling their guts out. Vinegar hill. The Butter exchange band. Few years’ time half of them magistrates and civil servants. War comes on: into the army helterskelter: same fellows used to. Whether on the scaffold high.

Never know who you’re talking to. Corny Kelleher he has Harvey Duff in his eye. Like that Peter or Denis or James Carey that blew the gaff on the invincibles. Member of the corporation too. Egging raw youths on to get in the know all the time drawing secret service pay from the castle. Drop him like a hot potato. Why those plainclothes men are always courting slaveys. Easily twig a man used to uniform. Squarepushing up against a backdoor. Maul her a bit. Then the next thing on the menu. And who is the gentleman does be visiting there? Was the young master saying anything? Peeping Tom through the keyhole. Decoy duck. Hotblooded young student fooling round her fat arms ironing.

—Are those yours, Mary?

—I don’t wear such things... Stop or I’ll tell the missus on you. Out half the night.

—There are great times coming, Mary. Wait till you see.

—Ah, gelong with your great times coming.

Barmaids too. Tobaccoshopgirls.

James Stephens’ idea was the best. He knew them. Circles of ten so that a fellow couldn’t round on more than his own ring. Sinn Fein. Back out you get the knife. Hidden hand. Stay in. The firing squad. Turnkey’s daughter got him out of Richmond, off from Lusk. Putting up in the Buckingham Palace hotel under their very noses. Garibaldi.

You must have a certain fascination: Parnell. Arthur Griffith is a squareheaded fellow but he has no go in him for the mob. Or gas about our lovely land. Gammon and spinach. Dublin Bakery Company’s tearoom. Debating societies. That republicanism is the best form of government. That the language question should take precedence of the economic question. Have your daughters inveigling them to your house. Stuff them up with meat and drink. Michaelmas goose. Here’s a good lump of thyme seasoning under the apron for you. Have another quart of goosegrease before it gets too cold. Halffed enthusiasts. Penny roll and a walk with the band. No grace for the carver. The thought that the other chap pays best sauce in the world. Make themselves thoroughly at home. Show us over those apricots, meaning peaches. The not far distant day. Homerule sun rising up in the northwest.

His smile faded as he walked, a heavy cloud hiding the sun slowly, shadowing Trinity’s surly front. Trams passed one another, ingoing, outgoing, clanging. Useless words. Things go on same, day after day: squads of police marching out, back: trams in, out. Those two loonies mooching about. Dignam carted off. Mina Purefoy swollen belly on a bed groaning to have a child tugged out of her. One born every second somewhere. Other dying every second. Since I fed the birds five minutes. Three hundred kicked the bucket. Other three hundred born, washing the blood off, all are washed in the blood of the lamb, bawling maaaaaa.

Cityful passing away, other cityful coming, passing away too: other coming on, passing on. Houses, lines of houses, streets, miles of pavements, piledup bricks, stones. Changing hands. This owner, that. Landlord never dies they say. Other steps into his shoes when he gets his notice to quit. They buy the place up with gold and still they have all the gold. Swindle in it somewhere. Piled up in cities, worn away age after age. Pyramids in sand. Built on bread and onions. Slaves Chinese wall. Babylon. Big stones left. Round towers. Rest rubble, sprawling suburbs, jerrybuilt. Kerwan’s mushroom houses built of breeze. Shelter, for the night.

No-one is anything.

This is the very worst hour of the day. Vitality. Dull, gloomy: hate this hour. Feel as if I had been eaten and spewed.

Provost’s house. The reverend Dr Salmon: tinned salmon. Well tinned in there. Like a mortuary chapel. Wouldn’t live in it if they paid me. Hope they have liver and bacon today. Nature abhors a vacuum.

The sun freed itself slowly and lit glints of light among the silverware opposite in Walter Sexton’s window by which John Howard Parnell passed, unseeing.

There he is: the brother. Image of him. Haunting face. Now that’s a coincidence. Course hundreds of times you think of a person and don’t meet him. Like a man walking in his sleep. No-one knows him. Must be a corporation meeting today. They say he never put on the city marshal’s uniform since he got the job. Charley Kavanagh used to come out on his high horse, cocked hat, puffed, powdered and shaved. Look at the woebegone walk of him. Eaten a bad egg. Poached eyes on ghost. I have a pain. Great man’s brother: his brother’s brother. He’d look nice on the city charger. Drop into the D.B.C. probably for his coffee, play chess there. His brother used men as pawns. Let them all go to pot. Afraid to pass a remark on him. Freeze them up with that eye of his. That’s the fascination: the name. All a bit touched. Mad Fanny and his other sister Mrs Dickinson driving about with scarlet harness. Bolt upright like surgeon M’Ardle. Still David Sheehy beat him for south Meath. Apply for the Chiltern Hundreds and retire into public life. The patriot’s banquet. Eating orangepeels in the park. Simon Dedalus said when they put him in parliament that Parnell would come back from the grave and lead him out of the house of commons by the arm.

—Of the twoheaded octopus, one of whose heads is the head upon which the ends of the world have forgotten to come while the other speaks with a Scotch accent. The tentacles...

They passed from behind Mr Bloom along the curbstone. Beard and bicycle. Young woman.

And there he is too. Now that’s really a coincidence: second time. Coming events cast their shadows before. With the approval of the eminent poet, Mr Geo. Russell. That might be Lizzie Twigg with him. A. E.: what does that mean? Initials perhaps. Albert Edward, Arthur Edmund, Alphonsus Eb Ed El Esquire. What was he saying? The ends of the world with a Scotch accent. Tentacles: octopus. Something occult: symbolism. Holding forth. She’s taking it all in. Not saying a word. To aid gentleman in literary work.

His eyes followed the high figure in homespun, beard and bicycle, a listening woman at his side. Coming from the vegetarian. Only weggebobbles and fruit. Don’t eat a beefsteak. If you do the eyes of that cow will pursue you through all eternity. They say it’s healthier. Windandwatery though. Tried it. Keep you on the run all day. Bad as a bloater. Dreams all night. Why do they call that thing they gave me nutsteak? Nutarians. Fruitarians. To give you the idea you are eating rumpsteak. Absurd. Salty too. They cook in soda. Keep you sitting by the tap all night.

Her stockings are loose over her ankles. I detest that: so tasteless. Those literary etherial people they are all. Dreamy, cloudy, symbolistic. Esthetes they are. I wouldn’t be surprised if it was that kind of food you see produces the like waves of the brain the poetical. For example one of those policemen sweating Irish stew into their shirts you couldn’t squeeze a line of poetry out of him. Don’t know what poetry is even. Must be in a certain mood.

The dreamy cloudy gull
Waves o’er the waters dull.

He crossed at Nassau street corner and stood before the window of Yeates and Son, pricing the fieldglasses. Or will I drop into old Harris’s and have a chat with young Sinclair? Wellmannered fellow. Probably at his lunch. Must get those old glasses of mine set right. Goerz lenses six guineas. Germans making their way everywhere. Sell on easy terms to capture trade. Undercutting. Might chance on a pair in the railway lost property office. Astonishing the things people leave behind them in trains and cloakrooms. What do they be thinking about? Women too. Incredible. Last year travelling to Ennis had to pick up that farmer’s daughter’s bag and hand it to her at Limerick junction. Unclaimed money too. There’s a little watch up there on the roof of the bank to test those glasses by.

His lids came down on the lower rims of his irides. Can’t see it. If you imagine it’s there you can almost see it. Can’t see it.

He faced about and, standing between the awnings, held out his right hand at arm’s length towards the sun. Wanted to try that often. Yes: completely. The tip of his little finger blotted out the sun’s disk. Must be the focus where the rays cross. If I had black glasses. Interesting. There was a lot of talk about those sunspots when we were in Lombard street west. Looking up from the back garden. Terrific explosions they are. There will be a total eclipse this year: autumn some time.

Now that I come to think of it that ball falls at Greenwich time. It’s the clock is worked by an electric wire from Dunsink. Must go out there some first Saturday of the month. If I could get an introduction to professor Joly or learn up something about his family. That would do to: man always feels complimented. Flattery where least expected. Nobleman proud to be descended from some king’s mistress. His foremother. Lay it on with a trowel. Cap in hand goes through the land. Not go in and blurt out what you know you’re not to: what’s parallax? Show this gentleman the door.

Ah.

His hand fell to his side again.

Never know anything about it. Waste of time. Gasballs spinning about, crossing each other, passing. Same old dingdong always. Gas: then solid: then world: then cold: then dead shell drifting around, frozen rock, like that pineapple rock. The moon. Must be a new moon out, she said. I believe there is.

He went on by la maison Claire.

Wait. The full moon was the night we were Sunday fortnight exactly there is a new moon. Walking down by the Tolka. Not bad for a Fairview moon. She was humming. The young May moon she’s beaming, love. He other side of her. Elbow, arm. He. Glowworm’s la-amp is gleaming, love. Touch. Fingers. Asking. Answer. Yes.

Stop. Stop. If it was it was. Must.

Mr Bloom, quickbreathing, slowlier walking passed Adam court.

With a keep quiet relief his eyes took note this is the street here middle of the day of Bob Doran’s bottle shoulders. On his annual bend, M’Coy said. They drink in order to say or do something or cherchez la femme. Up in the Coombe with chummies and streetwalkers and then the rest of the year sober as a judge.

Yes. Thought so. Sloping into the Empire. Gone. Plain soda would do him good. Where Pat Kinsella had his Harp theatre before Whitbred ran the Queen’s. Broth of a boy. Dion Boucicault business with his harvestmoon face in a poky bonnet. Three Purty Maids from School. How time flies, eh? Showing long red pantaloons under his skirts. Drinkers, drinking, laughed spluttering, their drink against their breath. More power, Pat. Coarse red: fun for drunkards: guffaw and smoke. Take off that white hat. His parboiled eyes. Where is he now? Beggar somewhere. The harp that once did starve us all.

I was happier then. Or was that I? Or am I now I? Twentyeight I was. She twentythree. When we left Lombard street west something changed. Could never like it again after Rudy. Can’t bring back time. Like holding water in your hand. Would you go back to then? Just beginning then. Would you? Are you not happy in your home you poor little naughty boy? Wants to sew on buttons for me. I must answer. Write it in the library.

Grafton street gay with housed awnings lured his senses. Muslin prints, silkdames and dowagers, jingle of harnesses, hoofthuds lowringing in the baking causeway. Thick feet that woman has in the white stockings. Hope the rain mucks them up on her. Countrybred chawbacon. All the beef to the heels were in. Always gives a woman clumsy feet. Molly looks out of plumb.

He passed, dallying, the windows of Brown Thomas, silk mercers. Cascades of ribbons. Flimsy China silks. A tilted urn poured from its mouth a flood of bloodhued poplin: lustrous blood. The huguenots brought that here. La causa è santa! Tara tara. Great chorus that. Taree tara. Must be washed in rainwater. Meyerbeer. Tara: bom bom bom.

Pincushions. I’m a long time threatening to buy one. Sticking them all over the place. Needles in window curtains.

He bared slightly his left forearm. Scrape: nearly gone. Not today anyhow. Must go back for that lotion. For her birthday perhaps. Junejulyaugseptember eighth. Nearly three months off. Then she mightn’t like it. Women won’t pick up pins. Say it cuts lo.

Gleaming silks, petticoats on slim brass rails, rays of flat silk stockings.

Useless to go back. Had to be. Tell me all.

High voices. Sunwarm silk. Jingling harnesses. All for a woman, home and houses, silkwebs, silver, rich fruits spicy from Jaffa. Agendath Netaim. Wealth of the world.

A warm human plumpness settled down on his brain. His brain yielded. Perfume of embraces all him assailed. With hungered flesh obscurely, he mutely craved to adore.

Duke street. Here we are. Must eat. The Burton. Feel better then.

He turned Combridge’s corner, still pursued. Jingling, hoofthuds. Perfumed bodies, warm, full. All kissed, yielded: in deep summer fields, tangled pressed grass, in trickling hallways of tenements, along sofas, creaking beds.

—Jack, love!

—Darling!

—Kiss me, Reggy!

—My boy!

—Love!

His heart astir he pushed in the door of the Burton restaurant. Stink gripped his trembling breath: pungent meatjuice, slush of greens. See the animals feed.

Men, men, men.

Perched on high stools by the bar, hats shoved back, at the tables calling for more bread no charge, swilling, wolfing gobfuls of sloppy food, their eyes bulging, wiping wetted moustaches. A pallid suetfaced young man polished his tumbler knife fork and spoon with his napkin. New set of microbes. A man with an infant’s saucestained napkin tucked round him shovelled gurgling soup down his gullet. A man spitting back on his plate: halfmasticated gristle: gums: no teeth to chewchewchew it. Chump chop from the grill. Bolting to get it over. Sad booser’s eyes. Bitten off more than he can chew. Am I like that? See ourselves as others see us. Hungry man is an angry man. Working tooth and jaw. Don’t! O! A bone! That last pagan king of Ireland Cormac in the schoolpoem choked himself at Sletty southward of the Boyne. Wonder what he was eating. Something galoptious. Saint Patrick converted him to Christianity. Couldn’t swallow it all however.

—Roast beef and cabbage.

—One stew.

Smells of men. Spat-on sawdust, sweetish warmish cigarettesmoke, reek of plug, spilt beer, men’s beery piss, the stale of ferment.

His gorge rose.

Couldn’t eat a morsel here. Fellow sharpening knife and fork to eat all before him, old chap picking his tootles. Slight spasm, full, chewing the cud. Before and after. Grace after meals. Look on this picture then on that. Scoffing up stewgravy with sopping sippets of bread. Lick it off the plate, man! Get out of this.

He gazed round the stooled and tabled eaters, tightening the wings of his nose.

—Two stouts here.

—One corned and cabbage.

That fellow ramming a knifeful of cabbage down as if his life depended on it. Good stroke. Give me the fidgets to look. Safer to eat from his three hands. Tear it limb from limb. Second nature to him. Born with a silver knife in his mouth. That’s witty, I think. Or no. Silver means born rich. Born with a knife. But then the allusion is lost.

An illgirt server gathered sticky clattering plates. Rock, the head bailiff, standing at the bar blew the foamy crown from his tankard. Well up: it splashed yellow near his boot. A diner, knife and fork upright, elbows on table, ready for a second helping stared towards the foodlift across his stained square of newspaper. Other chap telling him something with his mouth full. Sympathetic listener. Table talk. I munched hum un thu Unchster Bunk un Munchday. Ha? Did you, faith?

Mr Bloom raised two fingers doubtfully to his lips. His eyes said:

—Not here. Don’t see him.

Out. I hate dirty eaters.

He backed towards the door. Get a light snack in Davy Byrne’s. Stopgap. Keep me going. Had a good breakfast.

—Roast and mashed here.

—Pint of stout.

Every fellow for his own, tooth and nail. Gulp. Grub. Gulp. Gobstuff.

He came out into clearer air and turned back towards Grafton street. Eat or be eaten. Kill! Kill!

Suppose that communal kitchen years to come perhaps. All trotting down with porringers and tommycans to be filled. Devour contents in the street. John Howard Parnell example the provost of Trinity every mother’s son don’t talk of your provosts and provost of Trinity women and children cabmen priests parsons fieldmarshals archbishops. From Ailesbury road, Clyde road, artisans’ dwellings, north Dublin union, lord mayor in his gingerbread coach, old queen in a bathchair. My plate’s empty. After you with our incorporated drinkingcup. Like sir Philip Crampton’s fountain. Rub off the microbes with your handkerchief. Next chap rubs on a new batch with his. Father O’Flynn would make hares of them all. Have rows all the same. All for number one. Children fighting for the scrapings of the pot. Want a souppot as big as the Phoenix park. Harpooning flitches and hindquarters out of it. Hate people all round you. City Arms hotel table d’hôte she called it. Soup, joint and sweet. Never know whose thoughts you’re chewing. Then who’d wash up all the plates and forks? Might be all feeding on tabloids that time. Teeth getting worse and worse.

After all there’s a lot in that vegetarian fine flavour of things from the earth garlic of course it stinks after Italian organgrinders crisp of onions mushrooms truffles. Pain to the animal too. Pluck and draw fowl. Wretched brutes there at the cattlemarket waiting for the poleaxe to split their skulls open. Moo. Poor trembling calves. Meh. Staggering bob. Bubble and squeak. Butchers’ buckets wobbly lights. Give us that brisket off the hook. Plup. Rawhead and bloody bones. Flayed glasseyed sheep hung from their haunches, sheepsnouts bloodypapered snivelling nosejam on sawdust. Top and lashers going out. Don’t maul them pieces, young one.

Hot fresh blood they prescribe for decline. Blood always needed. Insidious. Lick it up smokinghot, thick sugary. Famished ghosts.

Ah, I’m hungry.

He entered Davy Byrne’s. Moral pub. He doesn’t chat. Stands a drink now and then. But in leapyear once in four. Cashed a cheque for me once.

What will I take now? He drew his watch. Let me see now. Shandygaff?

—Hello, Bloom, Nosey Flynn said from his nook.

—Hello, Flynn.

—How’s things?

—Tiptop... Let me see. I’ll take a glass of burgundy and... let me see.

Sardines on the shelves. Almost taste them by looking. Sandwich? Ham and his descendants musterred and bred there. Potted meats. What is home without Plumtree’s potted meat? Incomplete. What a stupid ad! Under the obituary notices they stuck it. All up a plumtree. Dignam’s potted meat. Cannibals would with lemon and rice. White missionary too salty. Like pickled pork. Expect the chief consumes the parts of honour. Ought to be tough from exercise. His wives in a row to watch the effect. There was a right royal old nigger. Who ate or something the somethings of the reverend Mr MacTrigger. With it an abode of bliss. Lord knows what concoction. Cauls mouldy tripes windpipes faked and minced up. Puzzle find the meat. Kosher. No meat and milk together. Hygiene that was what they call now. Yom Kippur fast spring cleaning of inside. Peace and war depend on some fellow’s digestion. Religions. Christmas turkeys and geese. Slaughter of innocents. Eat drink and be merry. Then casual wards full after. Heads bandaged. Cheese digests all but itself. Mity cheese.

—Have you a cheese sandwich?

—Yes, sir.

Like a few olives too if they had them. Italian I prefer. Good glass of burgundy take away that. Lubricate. A nice salad, cool as a cucumber, Tom Kernan can dress. Puts gusto into it. Pure olive oil. Milly served me that cutlet with a sprig of parsley. Take one Spanish onion. God made food, the devil the cooks. Devilled crab.

—Wife well?

—Quite well, thanks... A cheese sandwich, then. Gorgonzola, have you?

—Yes, sir.

Nosey Flynn sipped his grog.

—Doing any singing those times?

Look at his mouth. Could whistle in his own ear. Flap ears to match. Music. Knows as much about it as my coachman. Still better tell him. Does no harm. Free ad.

—She’s engaged for a big tour end of this month. You may have heard perhaps.

—No. O, that’s the style. Who’s getting it up?

The curate served.

—How much is that?

—Seven d., sir... Thank you, sir.

Mr Bloom cut his sandwich into slender strips. Mr MacTrigger. Easier than the dreamy creamy stuff. His five hundred wives. Had the time of their lives.

—Mustard, sir?

—Thank you.

He studded under each lifted strip yellow blobs. Their lives. I have it. It grew bigger and bigger and bigger.

—Getting it up? he said. Well, it’s like a company idea, you see. Part shares and part profits.

—Ay, now I remember, Nosey Flynn said, putting his hand in his pocket to scratch his groin. Who is this was telling me? Isn’t Blazes Boylan mixed up in it?

A warm shock of air heat of mustard hanched on Mr Bloom’s heart. He raised his eyes and met the stare of a bilious clock. Two. Pub clock five minutes fast. Time going on. Hands moving. Two. Not yet.

His midriff yearned then upward, sank within him, yearned more longly, longingly.

Wine.

He smellsipped the cordial juice and, bidding his throat strongly to speed it, set his wineglass delicately down.

—Yes, he said. He’s the organiser in point of fact.

No fear: no brains.

Nosey Flynn snuffled and scratched. Flea having a good square meal.

—He had a good slice of luck, Jack Mooney was telling me, over that boxingmatch Myler Keogh won again that soldier in the Portobello barracks. By God, he had the little kipper down in the county Carlow he was telling me...

Hope that dewdrop doesn’t come down into his glass. No, snuffled it up.

—For near a month, man, before it came off. Sucking duck eggs by God till further orders. Keep him off the boose, see? O, by God, Blazes is a hairy chap.

Davy Byrne came forward from the hindbar in tuckstitched shirtsleeves, cleaning his lips with two wipes of his napkin. Herring’s blush. Whose smile upon each feature plays with such and such replete. Too much fat on the parsnips.

—And here’s himself and pepper on him, Nosey Flynn said. Can you give us a good one for the Gold cup?

—I’m off that, Mr Flynn, Davy Byrne answered. I never put anything on a horse.

—You’re right there, Nosey Flynn said.

Mr Bloom ate his strips of sandwich, fresh clean bread, with relish of disgust pungent mustard, the feety savour of green cheese. Sips of his wine soothed his palate. Not logwood that. Tastes fuller this weather with the chill off.

Nice quiet bar. Nice piece of wood in that counter. Nicely planed. Like the way it curves there.

—I wouldn’t do anything at all in that line, Davy Byrne said. It ruined many a man, the same horses.

Vintners’ sweepstake. Licensed for the sale of beer, wine and spirits for consumption on the premises. Heads I win tails you lose.

—True for you, Nosey Flynn said. Unless you’re in the know. There’s no straight sport going now. Lenehan gets some good ones. He’s giving Sceptre today. Zinfandel’s the favourite, Lord Howard de Walden’s, won at Epsom. Morny Cannon is riding him. I could have got seven to one against Saint Amant a fortnight before.

—That so? Davy Byrne said...

He went towards the window and, taking up the pettycash book, scanned its pages.

—I could, faith, Nosey Flynn said, snuffling. That was a rare bit of horseflesh. Saint Frusquin was her sire. She won in a thunderstorm, Rothschild’s filly, with wadding in her ears. Blue jacket and yellow cap. Bad luck to big Ben Dollard and his John O’Gaunt. He put me off it. Ay.

He drank resignedly from his tumbler, running his fingers down the flutes.

—Ay, he said, sighing.

Mr Bloom, champing, standing, looked upon his sigh. Nosey numbskull. Will I tell him that horse Lenehan? He knows already. Better let him forget. Go and lose more. Fool and his money. Dewdrop coming down again. Cold nose he’d have kissing a woman. Still they might like. Prickly beards they like. Dogs’ cold noses. Old Mrs Riordan with the rumbling stomach’s Skye terrier in the City Arms hotel. Molly fondling him in her lap. O, the big doggybowwowsywowsy!

Wine soaked and softened rolled pith of bread mustard a moment mawkish cheese. Nice wine it is. Taste it better because I’m not thirsty. Bath of course does that. Just a bite or two. Then about six o’clock I can. Six. Six. Time will be gone then. She...

Mild fire of wine kindled his veins. I wanted that badly. Felt so off colour. His eyes unhungrily saw shelves of tins: sardines, gaudy lobsters’ claws. All the odd things people pick up for food. Out of shells, periwinkles with a pin, off trees, snails out of the ground the French eat, out of the sea with bait on a hook. Silly fish learn nothing in a thousand years. If you didn’t know risky putting anything into your mouth. Poisonous berries. Johnny Magories. Roundness you think good. Gaudy colour warns you off. One fellow told another and so on. Try it on the dog first. Led on by the smell or the look. Tempting fruit. Ice cones. Cream. Instinct. Orangegroves for instance. Need artificial irrigation. Bleibtreustrasse. Yes but what about oysters. Unsightly like a clot of phlegm. Filthy shells. Devil to open them too. Who found them out? Garbage, sewage they feed on. Fizz and Red bank oysters. Effect on the sexual. Aphrodis. He was in the Red Bank this morning. Was he oysters old fish at table perhaps he young flesh in bed no June has no ar no oysters. But there are people like things high. Tainted game. Jugged hare. First catch your hare. Chinese eating eggs fifty years old, blue and green again. Dinner of thirty courses. Each dish harmless might mix inside. Idea for a poison mystery. That archduke Leopold was it no yes or was it Otto one of those Habsburgs? Or who was it used to eat the scruff off his own head? Cheapest lunch in town. Of course aristocrats, then the others copy to be in the fashion. Milly too rock oil and flour. Raw pastry I like myself. Half the catch of oysters they throw back in the sea to keep up the price. Cheap no-one would buy. Caviare. Do the grand. Hock in green glasses. Swell blowout. Lady this. Powdered bosom pearls. The élite. Crème de la crème. They want special dishes to pretend they’re. Hermit with a platter of pulse keep down the stings of the flesh. Know me come eat with me. Royal sturgeon high sheriff, Coffey, the butcher, right to venisons of the forest from his ex. Send him back the half of a cow. Spread I saw down in the Master of the Rolls’ kitchen area. Whitehatted chef like a rabbi. Combustible duck. Curly cabbage à la duchesse de Parme. Just as well to write it on the bill of fare so you can know what you’ve eaten. Too many drugs spoil the broth. I know it myself. Dosing it with Edwards’ desiccated soup. Geese stuffed silly for them. Lobsters boiled alive. Do ptake some ptarmigan. Wouldn’t mind being a waiter in a swell hotel. Tips, evening dress, halfnaked ladies. May I tempt you to a little more filleted lemon sole, miss Dubedat? Yes, do bedad. And she did bedad. Huguenot name I expect that. A miss Dubedat lived in Killiney, I remember. Du de la is French. Still it’s the same fish perhaps old Micky Hanlon of Moore street ripped the guts out of making money hand over fist finger in fishes’ gills can’t write his name on a cheque think he was painting the landscape with his mouth twisted. Moooikill A Aitcha Ha ignorant as a kish of brogues, worth fifty thousand pounds.

Stuck on the pane two flies buzzed, stuck.

Glowing wine on his palate lingered swallowed. Crushing in the winepress grapes of Burgundy. Sun’s heat it is. Seems to a secret touch telling me memory. Touched his sense moistened remembered. Hidden under wild ferns on Howth below us bay sleeping: sky. No sound. The sky. The bay purple by the Lion’s head. Green by Drumleck. Yellowgreen towards Sutton. Fields of undersea, the lines faint brown in grass, buried cities. Pillowed on my coat she had her hair, earwigs in the heather scrub my hand under her nape, you’ll toss me all. O wonder! Coolsoft with ointments her hand touched me, caressed: her eyes upon me did not turn away. Ravished over her I lay, full lips full open, kissed her mouth. Yum. Softly she gave me in my mouth the seedcake warm and chewed. Mawkish pulp her mouth had mumbled sweetsour of her spittle. Joy: I ate it: joy. Young life, her lips that gave me pouting. Soft warm sticky gumjelly lips. Flowers her eyes were, take me, willing eyes. Pebbles fell. She lay still. A goat. No-one. High on Ben Howth rhododendrons a nannygoat walking surefooted, dropping currants. Screened under ferns she laughed warmfolded. Wildly I lay on her, kissed her: eyes, her lips, her stretched neck beating, woman’s breasts full in her blouse of nun’s veiling, fat nipples upright. Hot I tongued her. She kissed me. I was kissed. All yielding she tossed my hair. Kissed, she kissed me.

Me. And me now.

Stuck, the flies buzzed.

His downcast eyes followed the silent veining of the oaken slab. Beauty: it curves: curves are beauty. Shapely goddesses, Venus, Juno: curves the world admires. Can see them library museum standing in the round hall, naked goddesses. Aids to digestion. They don’t care what man looks. All to see. Never speaking. I mean to say to fellows like Flynn. Suppose she did Pygmalion and Galatea what would she say first? Mortal! Put you in your proper place. Quaffing nectar at mess with gods golden dishes, all ambrosial. Not like a tanner lunch we have, boiled mutton, carrots and turnips, bottle of Allsop. Nectar imagine it drinking electricity: gods’ food. Lovely forms of women sculped Junonian. Immortal lovely. And we stuffing food in one hole and out behind: food, chyle, blood, dung, earth, food: have to feed it like stoking an engine. They have no. Never looked. I’ll look today. Keeper won’t see. Bend down let something fall see if she.

Dribbling a quiet message from his bladder came to go to do not to do there to do. A man and ready he drained his glass to the lees and walked, to men too they gave themselves, manly conscious, lay with men lovers, a youth enjoyed her, to the yard.

When the sound of his boots had ceased Davy Byrne said from his book:

—What is this he is? Isn’t he in the insurance line?

—He’s out of that long ago, Nosey Flynn said. He does canvassing for the Freeman.

—I know him well to see, Davy Byrne said. Is he in trouble?

—Trouble? Nosey Flynn said. Not that I heard of. Why?

—I noticed he was in mourning.

—Was he? Nosey Flynn said. So he was, faith. I asked him how was all at home. You’re right, by God. So he was.

—I never broach the subject, Davy Byrne said humanely, if I see a gentleman is in trouble that way. It only brings it up fresh in their minds.

—It’s not the wife anyhow, Nosey Flynn said. I met him the day before yesterday and he coming out of that Irish farm dairy John Wyse Nolan’s wife has in Henry street with a jar of cream in his hand taking it home to his better half. She’s well nourished, I tell you. Plovers on toast.

—And is he doing for the Freeman? Davy Byrne said.

Nosey Flynn pursed his lips.

—He doesn’t buy cream on the ads he picks up. You can make bacon of that.

—How so? Davy Byrne asked, coming from his book.

Nosey Flynn made swift passes in the air with juggling fingers. He winked.

—He’s in the craft, he said.

—Do you tell me so? Davy Byrne said.

—Very much so, Nosey Flynn said. Ancient free and accepted order. He’s an excellent brother. Light, life and love, by God. They give him a leg up. I was told that by a—well, I won’t say who.

—Is that a fact?

—O, it’s a fine order, Nosey Flynn said. They stick to you when you’re down. I know a fellow was trying to get into it. But they’re as close as damn it. By God they did right to keep the women out of it.

Davy Byrne smiledyawnednodded all in one:

—Iiiiiichaaaaaaach!

—There was one woman, Nosey Flynn said, hid herself in a clock to find out what they do be doing. But be damned but they smelt her out and swore her in on the spot a master mason. That was one of the saint Legers of Doneraile.

Davy Byrne, sated after his yawn, said with tearwashed eyes:

—And is that a fact? Decent quiet man he is. I often saw him in here and I never once saw him—you know, over the line.

—God Almighty couldn’t make him drunk, Nosey Flynn said firmly. Slips off when the fun gets too hot. Didn’t you see him look at his watch? Ah, you weren’t there. If you ask him to have a drink first thing he does he outs with the watch to see what he ought to imbibe. Declare to God he does.

—There are some like that, Davy Byrne said. He’s a safe man, I’d say.

—He’s not too bad, Nosey Flynn said, snuffling it up. He’s been known to put his hand down too to help a fellow. Give the devil his due. O, Bloom has his good points. But there’s one thing he’ll never do.

His hand scrawled a dry pen signature beside his grog.

—I know, Davy Byrne said.

—Nothing in black and white, Nosey Flynn said.

Paddy Leonard and Bantam Lyons came in. Tom Rochford followed frowning, a plaining hand on his claret waistcoat.

—Day, Mr Byrne.

—Day, gentlemen.

They paused at the counter.

—Who’s standing? Paddy Leonard asked.

—I’m sitting anyhow, Nosey Flynn answered.

—Well, what’ll it be? Paddy Leonard asked.

—I’ll take a stone ginger, Bantam Lyons said.

—How much? Paddy Leonard cried. Since when, for God’ sake? What’s yours, Tom?

—How is the main drainage? Nosey Flynn asked, sipping.

For answer Tom Rochford pressed his hand to his breastbone and hiccupped.

—Would I trouble you for a glass of fresh water, Mr Byrne? he said.

—Certainly, sir.

Paddy Leonard eyed his alemates.

—Lord love a duck, he said. Look at what I’m standing drinks to! Cold water and gingerpop! Two fellows that would suck whisky off a sore leg. He has some bloody horse up his sleeve for the Gold cup. A dead snip.

—Zinfandel is it? Nosey Flynn asked.

Tom Rochford spilt powder from a twisted paper into the water set before him.

—That cursed dyspepsia, he said before drinking.

—Breadsoda is very good, Davy Byrne said.

Tom Rochford nodded and drank.

—Is it Zinfandel?

—Say nothing! Bantam Lyons winked. I’m going to plunge five bob on my own.

—Tell us if you’re worth your salt and be damned to you, Paddy Leonard said. Who gave it to you?

Mr Bloom on his way out raised three fingers in greeting.

—So long! Nosey Flynn said.

The others turned.

—That’s the man now that gave it to me, Bantam Lyons whispered.

—Prrwht! Paddy Leonard said with scorn. Mr Byrne, sir, we’ll take two of your small Jamesons after that and a...

—Stone ginger, Davy Byrne added civilly.

—Ay, Paddy Leonard said. A suckingbottle for the baby.

Mr Bloom walked towards Dawson street, his tongue brushing his teeth smooth. Something green it would have to be: spinach, say. Then with those Röntgen rays searchlight you could.

At Duke lane a ravenous terrier choked up a sick knuckly cud on the cobblestones and lapped it with new zest. Surfeit. Returned with thanks having fully digested the contents. First sweet then savoury. Mr Bloom coasted warily. Ruminants. His second course. Their upper jaw they move. Wonder if Tom Rochford will do anything with that invention of his? Wasting time explaining it to Flynn’s mouth. Lean people long mouths. Ought to be a hall or a place where inventors could go in and invent free. Course then you’d have all the cranks pestering.

He hummed, prolonging in solemn echo the closes of the bars:

Don Giovanni, a cenar teco
M’invitasti.

Feel better. Burgundy. Good pick me up. Who distilled first? Some chap in the blues. Dutch courage. That Kilkenny People in the national library now I must.

Bare clean closestools waiting in the window of William Miller, plumber, turned back his thoughts. They could: and watch it all the way down, swallow a pin sometimes come out of the ribs years after, tour round the body changing biliary duct spleen squirting liver gastric juice coils of intestines like pipes. But the poor buffer would have to stand all the time with his insides entrails on show. Science.

—A cenar teco.

What does that teco mean? Tonight perhaps.

Don Giovanni, thou hast me invited
To come to supper tonight,
The rum the rumdum.

Doesn’t go properly.

Keyes: two months if I get Nannetti to. That’ll be two pounds ten about two pounds eight. Three Hynes owes me. Two eleven. Prescott’s dyeworks van over there. If I get Billy Prescott’s ad: two fifteen. Five guineas about. On the pig’s back.

Could buy one of those silk petticoats for Molly, colour of her new garters.

Today. Today. Not think.

Tour the south then. What about English wateringplaces? Brighton, Margate. Piers by moonlight. Her voice floating out. Those lovely seaside girls. Against John Long’s a drowsing loafer lounged in heavy thought, gnawing a crusted knuckle. Handy man wants job. Small wages. Will eat anything.

Mr Bloom turned at Gray’s confectioner’s window of unbought tarts and passed the reverend Thomas Connellan’s bookstore. Why I left the church of Rome? Birds’ Nest. Women run him. They say they used to give pauper children soup to change to protestants in the time of the potato blight. Society over the way papa went to for the conversion of poor jews. Same bait. Why we left the church of Rome.

A blind stripling stood tapping the curbstone with his slender cane. No tram in sight. Wants to cross.

—Do you want to cross? Mr Bloom asked.

The blind stripling did not answer. His wallface frowned weakly. He moved his head uncertainly.

—You’re in Dawson street, Mr Bloom said. Molesworth street is opposite. Do you want to cross? There’s nothing in the way.

The cane moved out trembling to the left. Mr Bloom’s eye followed its line and saw again the dyeworks’ van drawn up before Drago’s. Where I saw his brillantined hair just when I was. Horse drooping. Driver in John Long’s. Slaking his drouth.

—There’s a van there, Mr Bloom said, but it’s not moving. I’ll see you across. Do you want to go to Molesworth street?

—Yes, the stripling answered. South Frederick street.

—Come, Mr Bloom said.

He touched the thin elbow gently: then took the limp seeing hand to guide it forward.

Say something to him. Better not do the condescending. They mistrust what you tell them. Pass a common remark.

—The rain kept off.

No answer.

Stains on his coat. Slobbers his food, I suppose. Tastes all different for him. Have to be spoonfed first. Like a child’s hand, his hand. Like Milly’s was. Sensitive. Sizing me up I daresay from my hand. Wonder if he has a name. Van. Keep his cane clear of the horse’s legs: tired drudge get his doze. That’s right. Clear. Behind a bull: in front of a horse.

—Thanks, sir.

Knows I’m a man. Voice.

—Right now? First turn to the left.

The blind stripling tapped the curbstone and went on his way, drawing his cane back, feeling again.

Mr Bloom walked behind the eyeless feet, a flatcut suit of herringbone tweed. Poor young fellow! How on earth did he know that van was there? Must have felt it. See things in their forehead perhaps: kind of sense of volume. Weight or size of it, something blacker than the dark. Wonder would he feel it if something was removed. Feel a gap. Queer idea of Dublin he must have, tapping his way round by the stones. Could he walk in a beeline if he hadn’t that cane? Bloodless pious face like a fellow going in to be a priest.

Penrose! That was that chap’s name.

Look at all the things they can learn to do. Read with their fingers. Tune pianos. Or we are surprised they have any brains. Why we think a deformed person or a hunchback clever if he says something we might say. Of course the other senses are more. Embroider. Plait baskets. People ought to help. Workbasket I could buy for Molly’s birthday. Hates sewing. Might take an objection. Dark men they call them.

Sense of smell must be stronger too. Smells on all sides, bunched together. Each street different smell. Each person too. Then the spring, the summer: smells. Tastes? They say you can’t taste wines with your eyes shut or a cold in the head. Also smoke in the dark they say get no pleasure.

And with a woman, for instance. More shameless not seeing. That girl passing the Stewart institution, head in the air. Look at me. I have them all on. Must be strange not to see her. Kind of a form in his mind’s eye. The voice, temperatures: when he touches her with his fingers must almost see the lines, the curves. His hands on her hair, for instance. Say it was black, for instance. Good. We call it black. Then passing over her white skin. Different feel perhaps. Feeling of white.

Postoffice. Must answer. Fag today. Send her a postal order two shillings, half a crown. Accept my little present. Stationer’s just here too. Wait. Think over it.

With a gentle finger he felt ever so slowly the hair combed back above his ears. Again. Fibres of fine fine straw. Then gently his finger felt the skin of his right cheek. Downy hair there too. Not smooth enough. The belly is the smoothest. No-one about. There he goes into Frederick street. Perhaps to Levenston’s dancing academy piano. Might be settling my braces.

Walking by Doran’s publichouse he slid his hand between his waistcoat and trousers and, pulling aside his shirt gently, felt a slack fold of his belly. But I know it’s whitey yellow. Want to try in the dark to see.

He withdrew his hand and pulled his dress to.

Poor fellow! Quite a boy. Terrible. Really terrible. What dreams would he have, not seeing? Life a dream for him. Where is the justice being born that way? All those women and children excursion beanfeast burned and drowned in New York. Holocaust. Karma they call that transmigration for sins you did in a past life the reincarnation met him pike hoses. Dear, dear, dear. Pity, of course: but somehow you can’t cotton on to them someway.

Sir Frederick Falkiner going into the freemasons’ hall. Solemn as Troy. After his good lunch in Earlsfort terrace. Old legal cronies cracking a magnum. Tales of the bench and assizes and annals of the bluecoat school. I sentenced him to ten years. I suppose he’d turn up his nose at that stuff I drank. Vintage wine for them, the year marked on a dusty bottle. Has his own ideas of justice in the recorder’s court. Wellmeaning old man. Police chargesheets crammed with cases get their percentage manufacturing crime. Sends them to the rightabout. The devil on moneylenders. Gave Reuben J a great strawcalling. Now he’s really what they call a dirty jew. Power those judges have. Crusty old topers in wigs. Bear with a sore paw. And may the Lord have mercy on your soul.

Hello, placard. Mirus bazaar. His Excellency the lord lieutenant. Sixteenth. Today it is. In aid of funds for Mercer’s hospital. The Messiah was first given for that. Yes. Handel. What about going out there: Ballsbridge. Drop in on Keyes. No use sticking to him like a leech. Wear out my welcome. Sure to know someone on the gate.

Mr Bloom came to Kildare street. First I must. Library.

Straw hat in sunlight. Tan shoes. Turnedup trousers. It is. It is.

His heart quopped softly. To the right. Museum. Goddesses. He swerved to the right.

Is it? Almost certain. Won’t look. Wine in my face. Why did I? Too heady. Yes, it is. The walk. Not see. Get on.

Making for the museum gate with long windy steps he lifted his eyes. Handsome building. Sir Thomas Deane designed. Not following me?

Didn’t see me perhaps. Light in his eyes.

The flutter of his breath came forth in short sighs. Quick. Cold statues: quiet there. Safe in a minute.

No. Didn’t see me. After two. Just at the gate.

My heart!

His eyes beating looked steadfastly at cream curves of stone. Sir Thomas Deane was the Greek architecture.

Look for something I.

His hasty hand went quick into a pocket, took out, read unfolded Agendath Netaim. Where did I?

Busy looking.

He thrust back quick Agendath.

Afternoon she said.

I am looking for that. Yes, that. Try all pockets. Handker. Freeman. Where did I? Ah, yes. Trousers. Potato. Purse. Where?

Hurry. Walk quietly. Moment more. My heart.

His hand looking for the where did I put found in his hip pocket soap lotion have to call tepid paper stuck. Ah soap there I yes. Gate.

Safe!

### [ 9 ]
Urbane, to comfort them, the quaker librarian purred:

—And we have, have we not, those priceless pages of Wilhelm Meister. A great poet on a great brother poet. A hesitating soul taking arms against a sea of troubles, torn by conflicting doubts, as one sees in real life.

He came a step a sinkapace forward on neatsleather creaking and a step backward a sinkapace on the solemn floor.

A noiseless attendant setting open the door but slightly made him a noiseless beck.

—Directly, said he, creaking to go, albeit lingering. The beautiful ineffectual dreamer who comes to grief against hard facts. One always feels that Goethe’s judgments are so true. True in the larger analysis.

Twicreakingly analysis he corantoed off. Bald, most zealous by the door he gave his large ear all to the attendant’s words: heard them: and was gone.

Two left.

—Monsieur de la Palice, Stephen sneered, was alive fifteen minutes before his death.

—Have you found those six brave medicals, John Eglinton asked with elder’s gall, to write Paradise Lost at your dictation? The Sorrows of Satan he calls it.

Smile. Smile Cranly’s smile.

First he tickled her
Then he patted her
Then he passed the female catheter
For he was a medical
Jolly old medi...

—I feel you would need one more for Hamlet. Seven is dear to the mystic mind. The shining seven W.B. calls them.

Glittereyed his rufous skull close to his greencapped desklamp sought the face bearded amid darkgreener shadow, an ollav, holyeyed. He laughed low: a sizar’s laugh of Trinity: unanswered.

Orchestral Satan, weeping many a rood
Tears such as angels weep.
Ed egli avea del cul fatto trombetta.

He holds my follies hostage.

Cranly’s eleven true Wicklowmen to free their sireland. Gaptoothed Kathleen, her four beautiful green fields, the stranger in her house. And one more to hail him: ave, rabbi: the Tinahely twelve. In the shadow of the glen he cooees for them. My soul’s youth I gave him, night by night. God speed. Good hunting.

Mulligan has my telegram.

Folly. Persist.

—Our young Irish bards, John Eglinton censured, have yet to create a figure which the world will set beside Saxon Shakespeare’s Hamlet though I admire him, as old Ben did, on this side idolatry.

—All these questions are purely academic, Russell oracled out of his shadow. I mean, whether Hamlet is Shakespeare or James I or Essex. Clergymen’s discussions of the historicity of Jesus. Art has to reveal to us ideas, formless spiritual essences. The supreme question about a work of art is out of how deep a life does it spring. The painting of Gustave Moreau is the painting of ideas. The deepest poetry of Shelley, the words of Hamlet bring our minds into contact with the eternal wisdom, Plato’s world of ideas. All the rest is the speculation of schoolboys for schoolboys.

A. E. has been telling some yankee interviewer. Wall, tarnation strike me!

—The schoolmen were schoolboys first, Stephen said superpolitely. Aristotle was once Plato’s schoolboy.

—And has remained so, one should hope, John Eglinton sedately said. One can see him, a model schoolboy with his diploma under his arm.

He laughed again at the now smiling bearded face.

Formless spiritual. Father, Word and Holy Breath. Allfather, the heavenly man. Hiesos Kristos, magician of the beautiful, the Logos who suffers in us at every moment. This verily is that. I am the fire upon the altar. I am the sacrificial butter.

Dunlop, Judge, the noblest Roman of them all, A.E., Arval, the Name Ineffable, in heaven hight: K.H., their master, whose identity is no secret to adepts. Brothers of the great white lodge always watching to see if they can help. The Christ with the bridesister, moisture of light, born of an ensouled virgin, repentant sophia, departed to the plane of buddhi. The life esoteric is not for ordinary person. O.P. must work off bad karma first. Mrs Cooper Oakley once glimpsed our very illustrious sister H.P.B.’s elemental.

O, fie! Out on’t! Pfuiteufel! You naughtn’t to look, missus, so you naughtn’t when a lady’s ashowing of her elemental.

Mr Best entered, tall, young, mild, light. He bore in his hand with grace a notebook, new, large, clean, bright.

—That model schoolboy, Stephen said, would find Hamlet’s musings about the afterlife of his princely soul, the improbable, insignificant and undramatic monologue, as shallow as Plato’s.

John Eglinton, frowning, said, waxing wroth:

—Upon my word it makes my blood boil to hear anyone compare Aristotle with Plato.

—Which of the two, Stephen asked, would have banished me from his commonwealth?

Unsheathe your dagger definitions. Horseness is the whatness of allhorse. Streams of tendency and eons they worship. God: noise in the street: very peripatetic. Space: what you damn well have to see. Through spaces smaller than red globules of man’s blood they creepycrawl after Blake’s buttocks into eternity of which this vegetable world is but a shadow. Hold to the now, the here, through which all future plunges to the past.

Mr Best came forward, amiable, towards his colleague.

—Haines is gone, he said.

—Is he?

—I was showing him Jubainville’s book. He’s quite enthusiastic, don’t you know, about Hyde’s Lovesongs of Connacht. I couldn’t bring him in to hear the discussion. He’s gone to Gill’s to buy it.

Bound thee forth, my booklet, quick
To greet the callous public.
Writ, I ween, ’twas not my wish
In lean unlovely English.

—The peatsmoke is going to his head, John Eglinton opined.

We feel in England. Penitent thief. Gone. I smoked his baccy. Green twinkling stone. An emerald set in the ring of the sea.

—People do not know how dangerous lovesongs can be, the auric egg of Russell warned occultly. The movements which work revolutions in the world are born out of the dreams and visions in a peasant’s heart on the hillside. For them the earth is not an exploitable ground but the living mother. The rarefied air of the academy and the arena produce the sixshilling novel, the musichall song. France produces the finest flower of corruption in Mallarmé but the desirable life is revealed only to the poor of heart, the life of Homer’s Phæacians.

From these words Mr Best turned an unoffending face to Stephen.

—Mallarmé, don’t you know, he said, has written those wonderful prose poems Stephen MacKenna used to read to me in Paris. The one about Hamlet. He says: il se promène, lisant au livre de lui-même, don’t you know, reading the book of himself. He describes Hamlet given in a French town, don’t you know, a provincial town. They advertised it.

His free hand graciously wrote tiny signs in air.

Hamlet
ou
Le Distrait
Pièce de Shakespeare

He repeated to John Eglinton’s newgathered frown:

—Pièce de Shakespeare, don’t you know. It’s so French. The French point of view. Hamlet ou...

—The absentminded beggar, Stephen ended.

John Eglinton laughed.

—Yes, I suppose it would be, he said. Excellent people, no doubt, but distressingly shortsighted in some matters.

Sumptuous and stagnant exaggeration of murder.

—A deathsman of the soul Robert Greene called him, Stephen said. Not for nothing was he a butcher’s son, wielding the sledded poleaxe and spitting in his palms. Nine lives are taken off for his father’s one. Our Father who art in purgatory. Khaki Hamlets don’t hesitate to shoot. The bloodboltered shambles in act five is a forecast of the concentration camp sung by Mr Swinburne.

Cranly, I his mute orderly, following battles from afar.

Whelps and dams of murderous foes whom none
But we had spared...

Between the Saxon smile and yankee yawp. The devil and the deep sea.

—He will have it that Hamlet is a ghoststory, John Eglinton said for Mr Best’s behoof. Like the fat boy in Pickwick he wants to make our flesh creep.

List! List! O List!

My flesh hears him: creeping, hears.

If thou didst ever...

—What is a ghost? Stephen said with tingling energy. One who has faded into impalpability through death, through absence, through change of manners. Elizabethan London lay as far from Stratford as corrupt Paris lies from virgin Dublin. Who is the ghost from limbo patrum, returning to the world that has forgotten him? Who is King Hamlet?

John Eglinton shifted his spare body, leaning back to judge.

Lifted.

—It is this hour of a day in mid June, Stephen said, begging with a swift glance their hearing. The flag is up on the playhouse by the bankside. The bear Sackerson growls in the pit near it, Paris garden. Canvasclimbers who sailed with Drake chew their sausages among the groundlings.

Local colour. Work in all you know. Make them accomplices.

—Shakespeare has left the huguenot’s house in Silver street and walks by the swanmews along the riverbank. But he does not stay to feed the pen chivying her game of cygnets towards the rushes. The swan of Avon has other thoughts.

Composition of place. Ignatius Loyola, make haste to help me!

—The play begins. A player comes on under the shadow, made up in the castoff mail of a court buck, a wellset man with a bass voice. It is the ghost, the king, a king and no king, and the player is Shakespeare who has studied Hamlet all the years of his life which were not vanity in order to play the part of the spectre. He speaks the words to Burbage, the young player who stands before him beyond the rack of cerecloth, calling him by a name:

Hamlet, I am thy father’s spirit,

bidding him list. To a son he speaks, the son of his soul, the prince, young Hamlet and to the son of his body, Hamnet Shakespeare, who has died in Stratford that his namesake may live for ever.

Is it possible that that player Shakespeare, a ghost by absence, and in the vesture of buried Denmark, a ghost by death, speaking his own words to his own son’s name (had Hamnet Shakespeare lived he would have been prince Hamlet’s twin), is it possible, I want to know, or probable that he did not draw or foresee the logical conclusion of those premises: you are the dispossessed son: I am the murdered father: your mother is the guilty queen, Ann Shakespeare, born Hathaway?

—But this prying into the family life of a great man, Russell began impatiently.

Art thou there, truepenny?

—Interesting only to the parish clerk. I mean, we have the plays. I mean when we read the poetry of King Lear what is it to us how the poet lived? As for living our servants can do that for us, Villiers de l’Isle has said. Peeping and prying into greenroom gossip of the day, the poet’s drinking, the poet’s debts. We have King Lear: and it is immortal.

Mr Best’s face, appealed to, agreed.

Flow over them with your waves and with your waters,
Mananaan, Mananaan MacLir...

How now, sirrah, that pound he lent you when you were hungry?

Marry, I wanted it.

Take thou this noble.

Go to! You spent most of it in Georgina Johnson’s bed, clergyman’s daughter. Agenbite of inwit.

Do you intend to pay it back?

O, yes.

When? Now?

Well... No.

When, then?

I paid my way. I paid my way.

Steady on. He’s from beyant Boyne water. The northeast corner. You owe it.

Wait. Five months. Molecules all change. I am other I now. Other I got pound.

Buzz. Buzz.

But I, entelechy, form of forms, am I by memory because under everchanging forms.

I that sinned and prayed and fasted.

A child Conmee saved from pandies.

I, I and I. I.

A.E.I.O.U.

—Do you mean to fly in the face of the tradition of three centuries? John Eglinton’s carping voice asked. Her ghost at least has been laid for ever. She died, for literature at least, before she was born.

—She died, Stephen retorted, sixtyseven years after she was born. She saw him into and out of the world. She took his first embraces. She bore his children and she laid pennies on his eyes to keep his eyelids closed when he lay on his deathbed.

Mother’s deathbed. Candle. The sheeted mirror. Who brought me into this world lies there, bronzelidded, under few cheap flowers. Liliata rutilantium.

I wept alone.

John Eglinton looked in the tangled glowworm of his lamp.

—The world believes that Shakespeare made a mistake, he said, and got out of it as quickly and as best he could.

—Bosh! Stephen said rudely. A man of genius makes no mistakes. His errors are volitional and are the portals of discovery.

Portals of discovery opened to let in the quaker librarian, softcreakfooted, bald, eared and assiduous.

—A shrew, John Eglinton said shrewdly, is not a useful portal of discovery, one should imagine. What useful discovery did Socrates learn from Xanthippe?

—Dialectic, Stephen answered: and from his mother how to bring thoughts into the world. What he learnt from his other wife Myrto (absit nomen!), Socratididion’s Epipsychidion, no man, not a woman, will ever know. But neither the midwife’s lore nor the caudlelectures saved him from the archons of Sinn Fein and their naggin of hemlock.

—But Ann Hathaway? Mr Best’s quiet voice said forgetfully. Yes, we seem to be forgetting her as Shakespeare himself forgot her.

His look went from brooder’s beard to carper’s skull, to remind, to chide them not unkindly, then to the baldpink lollard costard, guiltless though maligned.

—He had a good groatsworth of wit, Stephen said, and no truant memory. He carried a memory in his wallet as he trudged to Romeville whistling The girl I left behind me. If the earthquake did not time it we should know where to place poor Wat, sitting in his form, the cry of hounds, the studded bridle and her blue windows. That memory, Venus and Adonis, lay in the bedchamber of every light-of-love in London. Is Katharine the shrew illfavoured? Hortensio calls her young and beautiful. Do you think the writer of Antony and Cleopatra, a passionate pilgrim, had his eyes in the back of his head that he chose the ugliest doxy in all Warwickshire to lie withal? Good: he left her and gained the world of men. But his boywomen are the women of a boy. Their life, thought, speech are lent them by males. He chose badly? He was chosen, it seems to me. If others have their will Ann hath a way. By cock, she was to blame. She put the comether on him, sweet and twentysix. The greyeyed goddess who bends over the boy Adonis, stooping to conquer, as prologue to the swelling act, is a boldfaced Stratford wench who tumbles in a cornfield a lover younger than herself.

And my turn? When?

Come!

—Ryefield, Mr Best said brightly, gladly, raising his new book, gladly, brightly.

He murmured then with blond delight for all:

Between the acres of the rye
These pretty countryfolk would lie.

Paris: the wellpleased pleaser.

A tall figure in bearded homespun rose from shadow and unveiled its cooperative watch.

—I am afraid I am due at the Homestead.

Whither away? Exploitable ground.

—Are you going? John Eglinton’s active eyebrows asked. Shall we see you at Moore’s tonight? Piper is coming.

—Piper! Mr Best piped. Is Piper back?

Peter Piper pecked a peck of pick of peck of pickled pepper.

—I don’t know if I can. Thursday. We have our meeting. If I can get away in time.

Yogibogeybox in Dawson chambers. Isis Unveiled. Their Pali book we tried to pawn. Crosslegged under an umbrel umbershoot he thrones an Aztec logos, functioning on astral levels, their oversoul, mahamahatma. The faithful hermetists await the light, ripe for chelaship, ringroundabout him. Louis H. Victory. T. Caulfield Irwin. Lotus ladies tend them i’the eyes, their pineal glands aglow. Filled with his god, he thrones, Buddh under plantain. Gulfer of souls, engulfer. Hesouls, shesouls, shoals of souls. Engulfed with wailing creecries, whirled, whirling, they bewail.

In quintessential triviality
For years in this fleshcase a shesoul dwelt.

—They say we are to have a literary surprise, the quaker librarian said, friendly and earnest. Mr Russell, rumour has it, is gathering together a sheaf of our younger poets’ verses. We are all looking forward anxiously.

Anxiously he glanced in the cone of lamplight where three faces, lighted, shone.

See this. Remember.

Stephen looked down on a wide headless caubeen, hung on his ashplanthandle over his knee. My casque and sword. Touch lightly with two index fingers. Aristotle’s experiment. One or two? Necessity is that in virtue of which it is impossible that one can be otherwise. Argal, one hat is one hat.

Listen.

Young Colum and Starkey. George Roberts is doing the commercial part. Longworth will give it a good puff in the Express. O, will he? I liked Colum’s Drover. Yes, I think he has that queer thing genius. Do you think he has genius really? Yeats admired his line: As in wild earth a Grecian vase. Did he? I hope you’ll be able to come tonight. Malachi Mulligan is coming too. Moore asked him to bring Haines. Did you hear Miss Mitchell’s joke about Moore and Martyn? That Moore is Martyn’s wild oats? Awfully clever, isn’t it? They remind one of Don Quixote and Sancho Panza. Our national epic has yet to be written, Dr Sigerson says. Moore is the man for it. A knight of the rueful countenance here in Dublin. With a saffron kilt? O’Neill Russell? O, yes, he must speak the grand old tongue. And his Dulcinea? James Stephens is doing some clever sketches. We are becoming important, it seems.

Cordelia. Cordoglio. Lir’s loneliest daughter.

Nookshotten. Now your best French polish.

—Thank you very much, Mr Russell, Stephen said, rising. If you will be so kind as to give the letter to Mr Norman...

—O, yes. If he considers it important it will go in. We have so much correspondence.

—I understand, Stephen said. Thanks.

God ild you. The pigs’ paper. Bullockbefriending.

Synge has promised me an article for Dana too. Are we going to be read? I feel we are. The Gaelic league wants something in Irish. I hope you will come round tonight. Bring Starkey.

Stephen sat down.

The quaker librarian came from the leavetakers. Blushing, his mask said:

—Mr Dedalus, your views are most illuminating.

He creaked to and fro, tiptoing up nearer heaven by the altitude of a chopine, and, covered by the noise of outgoing, said low:

—Is it your view, then, that she was not faithful to the poet?

Alarmed face asks me. Why did he come? Courtesy or an inward light?

—Where there is a reconciliation, Stephen said, there must have been first a sundering.

—Yes.

Christfox in leather trews, hiding, a runaway in blighted treeforks, from hue and cry. Knowing no vixen, walking lonely in the chase. Women he won to him, tender people, a whore of Babylon, ladies of justices, bully tapsters’ wives. Fox and geese. And in New Place a slack dishonoured body that once was comely, once as sweet, as fresh as cinnamon, now her leaves falling, all, bare, frighted of the narrow grave and unforgiven.

—Yes. So you think...

The door closed behind the outgoer.

Rest suddenly possessed the discreet vaulted cell, rest of warm and brooding air.

A vestal’s lamp.

Here he ponders things that were not: what Cæsar would have lived to do had he believed the soothsayer: what might have been: possibilities of the possible as possible: things not known: what name Achilles bore when he lived among women.

Coffined thoughts around me, in mummycases, embalmed in spice of words. Thoth, god of libraries, a birdgod, moonycrowned. And I heard the voice of that Egyptian highpriest. In painted chambers loaded with tilebooks.

They are still. Once quick in the brains of men. Still: but an itch of death is in them, to tell me in my ear a maudlin tale, urge me to wreak their will.

—Certainly, John Eglinton mused, of all great men he is the most enigmatic. We know nothing but that he lived and suffered. Not even so much. Others abide our question. A shadow hangs over all the rest.

—But Hamlet is so personal, isn’t it? Mr Best pleaded. I mean, a kind of private paper, don’t you know, of his private life. I mean, I don’t care a button, don’t you know, who is killed or who is guilty...

He rested an innocent book on the edge of the desk, smiling his defiance. His private papers in the original. Ta an bad ar an tir. Taim in mo shagart. Put beurla on it, littlejohn.

Quoth littlejohn Eglinton:

—I was prepared for paradoxes from what Malachi Mulligan told us but I may as well warn you that if you want to shake my belief that Shakespeare is Hamlet you have a stern task before you.

Bear with me.

Stephen withstood the bane of miscreant eyes glinting stern under wrinkled brows. A basilisk. E quando vede l’uomo l’attosca. Messer Brunetto, I thank thee for the word.

—As we, or mother Dana, weave and unweave our bodies, Stephen said, from day to day, their molecules shuttled to and fro, so does the artist weave and unweave his image. And as the mole on my right breast is where it was when I was born, though all my body has been woven of new stuff time after time, so through the ghost of the unquiet father the image of the unliving son looks forth. In the intense instant of imagination, when the mind, Shelley says, is a fading coal, that which I was is that which I am and that which in possibility I may come to be. So in the future, the sister of the past, I may see myself as I sit here now but by reflection from that which then I shall be.

Drummond of Hawthornden helped you at that stile.

—Yes, Mr Best said youngly. I feel Hamlet quite young. The bitterness might be from the father but the passages with Ophelia are surely from the son.

Has the wrong sow by the lug. He is in my father. I am in his son.

—That mole is the last to go, Stephen said, laughing.

John Eglinton made a nothing pleasing mow.

—If that were the birthmark of genius, he said, genius would be a drug in the market. The plays of Shakespeare’s later years which Renan admired so much breathe another spirit.

—The spirit of reconciliation, the quaker librarian breathed.

—There can be no reconciliation, Stephen said, if there has not been a sundering.

Said that.

—If you want to know what are the events which cast their shadow over the hell of time of King Lear, Othello, Hamlet, Troilus and Cressida, look to see when and how the shadow lifts. What softens the heart of a man, shipwrecked in storms dire, Tried, like another Ulysses, Pericles, prince of Tyre?

Head, redconecapped, buffeted, brineblinded.

—A child, a girl, placed in his arms, Marina.

—The leaning of sophists towards the bypaths of apocrypha is a constant quantity, John Eglinton detected. The highroads are dreary but they lead to the town.

Good Bacon: gone musty. Shakespeare Bacon’s wild oats. Cypherjugglers going the highroads. Seekers on the great quest. What town, good masters? Mummed in names: A. E., eon: Magee, John Eglinton. East of the sun, west of the moon: Tir na n-og. Booted the twain and staved.

How many miles to Dublin?
Three score and ten, sir.
Will we be there by candlelight?

—Mr Brandes accepts it, Stephen said, as the first play of the closing period.

—Does he? What does Mr Sidney Lee, or Mr Simon Lazarus as some aver his name is, say of it?

—Marina, Stephen said, a child of storm, Miranda, a wonder, Perdita, that which was lost. What was lost is given back to him: his daughter’s child. My dearest wife, Pericles says, was like this maid. Will any man love the daughter if he has not loved the mother?

—The art of being a grandfather, Mr Best gan murmur. L’art d’être grand...

—Will he not see reborn in her, with the memory of his own youth added, another image?

Do you know what you are talking about? Love, yes. Word known to all men. Amor vero aliquid alicui bonum vult unde et ea quae concupiscimus ...

—His own image to a man with that queer thing genius is the standard of all experience, material and moral. Such an appeal will touch him. The images of other males of his blood will repel him. He will see in them grotesque attempts of nature to foretell or to repeat himself.

The benign forehead of the quaker librarian enkindled rosily with hope.

—I hope Mr Dedalus will work out his theory for the enlightenment of the public. And we ought to mention another Irish commentator, Mr George Bernard Shaw. Nor should we forget Mr Frank Harris. His articles on Shakespeare in the Saturday Review were surely brilliant. Oddly enough he too draws for us an unhappy relation with the dark lady of the sonnets. The favoured rival is William Herbert, earl of Pembroke. I own that if the poet must be rejected such a rejection would seem more in harmony with—what shall I say?—our notions of what ought not to have been.

Felicitously he ceased and held a meek head among them, auk’s egg, prize of their fray.

He thous and thees her with grave husbandwords. Dost love, Miriam? Dost love thy man?

—That may be too, Stephen said. There’s a saying of Goethe’s which Mr Magee likes to quote. Beware of what you wish for in youth because you will get it in middle life. Why does he send to one who is a buonaroba, a bay where all men ride, a maid of honour with a scandalous girlhood, a lordling to woo for him? He was himself a lord of language and had made himself a coistrel gentleman and he had written Romeo and Juliet. Why? Belief in himself has been untimely killed. He was overborne in a cornfield first (ryefield, I should say) and he will never be a victor in his own eyes after nor play victoriously the game of laugh and lie down. Assumed dongiovannism will not save him. No later undoing will undo the first undoing. The tusk of the boar has wounded him there where love lies ableeding. If the shrew is worsted yet there remains to her woman’s invisible weapon. There is, I feel in the words, some goad of the flesh driving him into a new passion, a darker shadow of the first, darkening even his own understanding of himself. A like fate awaits him and the two rages commingle in a whirlpool.

They list. And in the porches of their ears I pour.

—The soul has been before stricken mortally, a poison poured in the porch of a sleeping ear. But those who are done to death in sleep cannot know the manner of their quell unless their Creator endow their souls with that knowledge in the life to come. The poisoning and the beast with two backs that urged it King Hamlet’s ghost could not know of were he not endowed with knowledge by his creator. That is why the speech (his lean unlovely English) is always turned elsewhere, backward. Ravisher and ravished, what he would but would not, go with him from Lucrece’s bluecircled ivory globes to Imogen’s breast, bare, with its mole cinquespotted. He goes back, weary of the creation he has piled up to hide him from himself, an old dog licking an old sore. But, because loss is his gain, he passes on towards eternity in undiminished personality, untaught by the wisdom he has written or by the laws he has revealed. His beaver is up. He is a ghost, a shadow now, the wind by Elsinore’s rocks or what you will, the sea’s voice, a voice heard only in the heart of him who is the substance of his shadow, the son consubstantial with the father.

—Amen! was responded from the doorway.

Hast thou found me, O mine enemy?

Entr’acte.

A ribald face, sullen as a dean’s, Buck Mulligan came forward, then blithe in motley, towards the greeting of their smiles. My telegram.

—You were speaking of the gaseous vertebrate, if I mistake not? he asked of Stephen.

Primrosevested he greeted gaily with his doffed Panama as with a bauble.

They make him welcome. Was Du verlachst wirst Du noch dienen.

Brood of mockers: Photius, pseudomalachi, Johann Most.

He Who Himself begot middler the Holy Ghost and Himself sent Himself, Agenbuyer, between Himself and others, Who, put upon by His fiends, stripped and whipped, was nailed like bat to barndoor, starved on crosstree, Who let Him bury, stood up, harrowed hell, fared into heaven and there these nineteen hundred years sitteth on the right hand of His Own Self but yet shall come in the latter day to doom the quick and dead when all the quick shall be dead already.

gloriainexelcisdeo

He lifts his hands. Veils fall. O, flowers! Bells with bells with bells aquiring.

—Yes, indeed, the quaker librarian said. A most instructive discussion. Mr Mulligan, I’ll be bound, has his theory too of the play and of Shakespeare. All sides of life should be represented.

He smiled on all sides equally.

Buck Mulligan thought, puzzled:

—Shakespeare? he said. I seem to know the name.

A flying sunny smile rayed in his loose features.

—To be sure, he said, remembering brightly. The chap that writes like Synge.

Mr Best turned to him.

—Haines missed you, he said. Did you meet him? He’ll see you after at the D. B. C. He’s gone to Gill’s to buy Hyde’s Lovesongs of Connacht.

—I came through the museum, Buck Mulligan said. Was he here?

—The bard’s fellowcountrymen, John Eglinton answered, are rather tired perhaps of our brilliancies of theorising. I hear that an actress played Hamlet for the fourhundredandeighth time last night in Dublin. Vining held that the prince was a woman. Has no-one made him out to be an Irishman? Judge Barton, I believe, is searching for some clues. He swears (His Highness not His Lordship) by saint Patrick.

—The most brilliant of all is that story of Wilde’s, Mr Best said, lifting his brilliant notebook. That Portrait of Mr W. H. where he proves that the sonnets were written by a Willie Hughes, a man all hues.

—For Willie Hughes, is it not? the quaker librarian asked.

Or Hughie Wills? Mr William Himself. W. H.: who am I?

—I mean, for Willie Hughes, Mr Best said, amending his gloss easily. Of course it’s all paradox, don’t you know, Hughes and hews and hues, the colour, but it’s so typical the way he works it out. It’s the very essence of Wilde, don’t you know. The light touch.

His glance touched their faces lightly as he smiled, a blond ephebe. Tame essence of Wilde.

You’re darned witty. Three drams of usquebaugh you drank with Dan Deasy’s ducats.

How much did I spend? O, a few shillings.

For a plump of pressmen. Humour wet and dry.

Wit. You would give your five wits for youth’s proud livery he pranks in. Lineaments of gratified desire.

There be many mo. Take her for me. In pairing time. Jove, a cool ruttime send them. Yea, turtledove her.

Eve. Naked wheatbellied sin. A snake coils her, fang in’s kiss.

—Do you think it is only a paradox? the quaker librarian was asking. The mocker is never taken seriously when he is most serious.

They talked seriously of mocker’s seriousness.

Buck Mulligan’s again heavy face eyed Stephen awhile. Then, his head wagging, he came near, drew a folded telegram from his pocket. His mobile lips read, smiling with new delight.

—Telegram! he said. Wonderful inspiration! Telegram! A papal bull!

He sat on a corner of the unlit desk, reading aloud joyfully:

—The sentimentalist is he who would enjoy without incurring the immense debtorship for a thing done. Signed: Dedalus. Where did you launch it from? The kips? No. College Green. Have you drunk the four quid? The aunt is going to call on your unsubstantial father. Telegram! Malachi Mulligan, The Ship, lower Abbey street. O, you peerless mummer! O, you priestified Kinchite!

Joyfully he thrust message and envelope into a pocket but keened in a querulous brogue:

—It’s what I’m telling you, mister honey, it’s queer and sick we were, Haines and myself, the time himself brought it in. ’Twas murmur we did for a gallus potion would rouse a friar, I’m thinking, and he limp with leching. And we one hour and two hours and three hours in Connery’s sitting civil waiting for pints apiece.

He wailed:

—And we to be there, mavrone, and you to be unbeknownst sending us your conglomerations the way we to have our tongues out a yard long like the drouthy clerics do be fainting for a pussful.

Stephen laughed.

Quickly, warningfully Buck Mulligan bent down.

—The tramper Synge is looking for you, he said, to murder you. He heard you pissed on his halldoor in Glasthule. He’s out in pampooties to murder you.

—Me! Stephen exclaimed. That was your contribution to literature.

Buck Mulligan gleefully bent back, laughing to the dark eavesdropping ceiling.

—Murder you! he laughed.

Harsh gargoyle face that warred against me over our mess of hash of lights in rue Saint-André-des-Arts. In words of words for words, palabras. Oisin with Patrick. Faunman he met in Clamart woods, brandishing a winebottle. C’est vendredi saint! Murthering Irish. His image, wandering, he met. I mine. I met a fool i’the forest.

—Mr Lyster, an attendant said from the door ajar.

—... in which everyone can find his own. So Mr Justice Madden in his Diary of Master William Silence has found the hunting terms... Yes? What is it?

—There’s a gentleman here, sir, the attendant said, coming forward and offering a card. From the Freeman. He wants to see the files of the Kilkenny People for last year.

—Certainly, certainly, certainly. Is the gentleman?...

He took the eager card, glanced, not saw, laid down unglanced, looked, asked, creaked, asked:

—Is he?... O, there!

Brisk in a galliard he was off, out. In the daylit corridor he talked with voluble pains of zeal, in duty bound, most fair, most kind, most honest broadbrim.

—This gentleman? Freeman’s Journal? Kilkenny People? To be sure. Good day, sir. Kilkenny... We have certainly...

A patient silhouette waited, listening.

—All the leading provincial... Northern Whig, Cork Examiner, Enniscorthy Guardian, 1903... Will you please?... Evans, conduct this gentleman... If you just follow the atten... Or, please allow me... This way... Please, sir...

Voluble, dutiful, he led the way to all the provincial papers, a bowing dark figure following his hasty heels.

The door closed.

—The sheeny! Buck Mulligan cried.

He jumped up and snatched the card.

—What’s his name? Ikey Moses? Bloom.

He rattled on:

—Jehovah, collector of prepuces, is no more. I found him over in the museum where I went to hail the foamborn Aphrodite. The Greek mouth that has never been twisted in prayer. Every day we must do homage to her. Life of life, thy lips enkindle.

Suddenly he turned to Stephen:

—He knows you. He knows your old fellow. O, I fear me, he is Greeker than the Greeks. His pale Galilean eyes were upon her mesial groove. Venus Kallipyge. O, the thunder of those loins! The god pursuing the maiden hid.

—We want to hear more, John Eglinton decided with Mr Best’s approval. We begin to be interested in Mrs S. Till now we had thought of her, if at all, as a patient Griselda, a Penelope stayathome.

—Antisthenes, pupil of Gorgias, Stephen said, took the palm of beauty from Kyrios Menelaus’ brooddam, Argive Helen, the wooden mare of Troy in whom a score of heroes slept, and handed it to poor Penelope. Twenty years he lived in London and, during part of that time, he drew a salary equal to that of the lord chancellor of Ireland. His life was rich. His art, more than the art of feudalism as Walt Whitman called it, is the art of surfeit. Hot herringpies, green mugs of sack, honeysauces, sugar of roses, marchpane, gooseberried pigeons, ringocandies. Sir Walter Raleigh, when they arrested him, had half a million francs on his back including a pair of fancy stays. The gombeenwoman Eliza Tudor had underlinen enough to vie with her of Sheba. Twenty years he dallied there between conjugial love and its chaste delights and scortatory love and its foul pleasures. You know Manningham’s story of the burgher’s wife who bade Dick Burbage to her bed after she had seen him in Richard III and how Shakespeare, overhearing, without more ado about nothing, took the cow by the horns and, when Burbage came knocking at the gate, answered from the capon’s blankets: William the conqueror came before Richard III. And the gay lakin, mistress Fitton, mount and cry O, and his dainty birdsnies, lady Penelope Rich, a clean quality woman is suited for a player, and the punks of the bankside, a penny a time.

Cours la Reine. Encore vingt sous. Nous ferons de petites cochonneries. Minette? Tu veux?

—The height of fine society. And sir William Davenant of Oxford’s mother with her cup of canary for any cockcanary.

Buck Mulligan, his pious eyes upturned, prayed:

—Blessed Margaret Mary Anycock!

—And Harry of six wives’ daughter. And other lady friends from neighbour seats as Lawn Tennyson, gentleman poet, sings. But all those twenty years what do you suppose poor Penelope in Stratford was doing behind the diamond panes?

Do and do. Thing done. In a rosery of Fetter lane of Gerard, herbalist, he walks, greyedauburn. An azured harebell like her veins. Lids of Juno’s eyes, violets. He walks. One life is all. One body. Do. But do. Afar, in a reek of lust and squalor, hands are laid on whiteness.

Buck Mulligan rapped John Eglinton’s desk sharply.

—Whom do you suspect? he challenged.

—Say that he is the spurned lover in the sonnets. Once spurned twice spurned. But the court wanton spurned him for a lord, his dearmylove.

Love that dare not speak its name.

—As an Englishman, you mean, John sturdy Eglinton put in, he loved a lord.

Old wall where sudden lizards flash. At Charenton I watched them.

—It seems so, Stephen said, when he wants to do for him, and for all other and singular uneared wombs, the holy office an ostler does for the stallion. Maybe, like Socrates, he had a midwife to mother as he had a shrew to wife. But she, the giglot wanton, did not break a bedvow. Two deeds are rank in that ghost’s mind: a broken vow and the dullbrained yokel on whom her favour has declined, deceased husband’s brother. Sweet Ann, I take it, was hot in the blood. Once a wooer, twice a wooer.

Stephen turned boldly in his chair.

—The burden of proof is with you not with me, he said frowning. If you deny that in the fifth scene of Hamlet he has branded her with infamy tell me why there is no mention of her during the thirtyfour years between the day she married him and the day she buried him. All those women saw their men down and under: Mary, her goodman John, Ann, her poor dear Willun, when he went and died on her, raging that he was the first to go, Joan, her four brothers, Judith, her husband and all her sons, Susan, her husband too, while Susan’s daughter, Elizabeth, to use granddaddy’s words, wed her second, having killed her first.

O, yes, mention there is. In the years when he was living richly in royal London to pay a debt she had to borrow forty shillings from her father’s shepherd. Explain you then. Explain the swansong too wherein he has commended her to posterity.

He faced their silence.

To whom thus Eglinton: You mean the will.
But that has been explained, I believe, by jurists.
She was entitled to her widow’s dower
At common law. His legal knowledge was great
Our judges tell us.
            Him Satan fleers,
Mocker:
            And therefore he left out her name
From the first draft but he did not leave out
The presents for his granddaughter, for his daughters,
For his sister, for his old cronies in Stratford
And in London. And therefore when he was urged,
As I believe, to name her
He left her his
Secondbest
Bed.

            Punkt.

Leftherhis
Secondbest
Leftherhis
Bestabed
Secabest
Leftabed.

Woa!

—Pretty countryfolk had few chattels then, John Eglinton observed, as they have still if our peasant plays are true to type.

—He was a rich country gentleman, Stephen said, with a coat of arms and landed estate at Stratford and a house in Ireland yard, a capitalist shareholder, a bill promoter, a tithefarmer. Why did he not leave her his best bed if he wished her to snore away the rest of her nights in peace?

—It is clear that there were two beds, a best and a secondbest, Mr Secondbest Best said finely.

—Separatio a mensa et a thalamo, bettered Buck Mulligan and was smiled on.

—Antiquity mentions famous beds, Second Eglinton puckered, bedsmiling. Let me think.

—Antiquity mentions that Stagyrite schoolurchin and bald heathen sage, Stephen said, who when dying in exile frees and endows his slaves, pays tribute to his elders, wills to be laid in earth near the bones of his dead wife and bids his friends be kind to an old mistress (don’t forget Nell Gwynn Herpyllis) and let her live in his villa.

—Do you mean he died so? Mr Best asked with slight concern. I mean...

—He died dead drunk, Buck Mulligan capped. A quart of ale is a dish for a king. O, I must tell you what Dowden said!

—What? asked Besteglinton.

William Shakespeare and company, limited. The people’s William. For terms apply: E. Dowden, Highfield house...

—Lovely! Buck Mulligan suspired amorously. I asked him what he thought of the charge of pederasty brought against the bard. He lifted his hands and said: All we can say is that life ran very high in those days. Lovely!

Catamite.

—The sense of beauty leads us astray, said beautifulinsadness Best to ugling Eglinton.

Steadfast John replied severe:

—The doctor can tell us what those words mean. You cannot eat your cake and have it.

Sayest thou so? Will they wrest from us, from me, the palm of beauty?

—And the sense of property, Stephen said. He drew Shylock out of his own long pocket. The son of a maltjobber and moneylender he was himself a cornjobber and moneylender, with ten tods of corn hoarded in the famine riots. His borrowers are no doubt those divers of worship mentioned by Chettle Falstaff who reported his uprightness of dealing. He sued a fellowplayer for the price of a few bags of malt and exacted his pound of flesh in interest for every money lent. How else could Aubrey’s ostler and callboy get rich quick? All events brought grist to his mill. Shylock chimes with the jewbaiting that followed the hanging and quartering of the queen’s leech Lopez, his jew’s heart being plucked forth while the sheeny was yet alive: Hamlet and Macbeth with the coming to the throne of a Scotch philosophaster with a turn for witchroasting. The lost armada is his jeer in Love’s Labour Lost. His pageants, the histories, sail fullbellied on a tide of Mafeking enthusiasm. Warwickshire jesuits are tried and we have a porter’s theory of equivocation. The Sea Venture comes home from Bermudas and the play Renan admired is written with Patsy Caliban, our American cousin. The sugared sonnets follow Sidney’s. As for fay Elizabeth, otherwise carrotty Bess, the gross virgin who inspired The Merry Wives of Windsor, let some meinherr from Almany grope his life long for deephid meanings in the depths of the buckbasket.

I think you’re getting on very nicely. Just mix up a mixture of theolologicophilolological. Mingo, minxi, mictum, mingere.

—Prove that he was a jew, John Eglinton dared, expectantly. Your dean of studies holds he was a holy Roman.

Sufflaminandus sum.

—He was made in Germany, Stephen replied, as the champion French polisher of Italian scandals.

—A myriadminded man, Mr Best reminded. Coleridge called him myriadminded.

Amplius. In societate humana hoc est maxime necessarium ut sit amicitia inter multos.

—Saint Thomas, Stephen began...

—Ora pro nobis, Monk Mulligan groaned, sinking to a chair.

There he keened a wailing rune.

—Pogue mahone! Acushla machree! It’s destroyed we are from this day! It’s destroyed we are surely!

All smiled their smiles.

—Saint Thomas, Stephen smiling said, whose gorbellied works I enjoy reading in the original, writing of incest from a standpoint different from that of the new Viennese school Mr Magee spoke of, likens it in his wise and curious way to an avarice of the emotions. He means that the love so given to one near in blood is covetously withheld from some stranger who, it may be, hungers for it. Jews, whom christians tax with avarice, are of all races the most given to intermarriage. Accusations are made in anger. The christian laws which built up the hoards of the jews (for whom, as for the lollards, storm was shelter) bound their affections too with hoops of steel. Whether these be sins or virtues old Nobodaddy will tell us at doomsday leet. But a man who holds so tightly to what he calls his rights over what he calls his debts will hold tightly also to what he calls his rights over her whom he calls his wife. No sir smile neighbour shall covet his ox or his wife or his manservant or his maidservant or his jackass.

—Or his jennyass, Buck Mulligan antiphoned.

—Gentle Will is being roughly handled, gentle Mr Best said gently.

—Which will? gagged sweetly Buck Mulligan. We are getting mixed.

—The will to live, John Eglinton philosophised, for poor Ann, Will’s widow, is the will to die.

—Requiescat! Stephen prayed.

What of all the will to do?
It has vanished long ago...

—She lies laid out in stark stiffness in that secondbest bed, the mobled queen, even though you prove that a bed in those days was as rare as a motorcar is now and that its carvings were the wonder of seven parishes. In old age she takes up with gospellers (one stayed with her at New Place and drank a quart of sack the town council paid for but in which bed he slept it skills not to ask) and heard she had a soul. She read or had read to her his chapbooks preferring them to the Merry Wives and, loosing her nightly waters on the jordan, she thought over Hooks and Eyes for Believers’ Breeches and The most Spiritual Snuffbox to Make the Most Devout Souls Sneeze. Venus has twisted her lips in prayer. Agenbite of inwit: remorse of conscience. It is an age of exhausted whoredom groping for its god.

—History shows that to be true, inquit Eglintonus Chronolologos. The ages succeed one another. But we have it on high authority that a man’s worst enemies shall be those of his own house and family. I feel that Russell is right. What do we care for his wife or father? I should say that only family poets have family lives. Falstaff was not a family man. I feel that the fat knight is his supreme creation.

Lean, he lay back. Shy, deny thy kindred, the unco guid. Shy, supping with the godless, he sneaks the cup. A sire in Ultonian Antrim bade it him. Visits him here on quarter days. Mr Magee, sir, there’s a gentleman to see you. Me? Says he’s your father, sir. Give me my Wordsworth. Enter Magee Mor Matthew, a rugged rough rugheaded kern, in strossers with a buttoned codpiece, his nether stocks bemired with clauber of ten forests, a wand of wilding in his hand.

Your own? He knows your old fellow. The widower.

Hurrying to her squalid deathlair from gay Paris on the quayside I touched his hand. The voice, new warmth, speaking. Dr Bob Kenny is attending her. The eyes that wish me well. But do not know me.

—A father, Stephen said, battling against hopelessness, is a necessary evil. He wrote the play in the months that followed his father’s death. If you hold that he, a greying man with two marriageable daughters, with thirtyfive years of life, nel mezzo del cammin di nostra vita, with fifty of experience, is the beardless undergraduate from Wittenberg then you must hold that his seventyyear old mother is the lustful queen. No. The corpse of John Shakespeare does not walk the night. From hour to hour it rots and rots. He rests, disarmed of fatherhood, having devised that mystical estate upon his son. Boccaccio’s Calandrino was the first and last man who felt himself with child. Fatherhood, in the sense of conscious begetting, is unknown to man. It is a mystical estate, an apostolic succession, from only begetter to only begotten. On that mystery and not on the madonna which the cunning Italian intellect flung to the mob of Europe the church is founded and founded irremovably because founded, like the world, macro and microcosm, upon the void. Upon incertitude, upon unlikelihood. Amor matris, subjective and objective genitive, may be the only true thing in life. Paternity may be a legal fiction. Who is the father of any son that any son should love him or he any son?

What the hell are you driving at?

I know. Shut up. Blast you. I have reasons.

Amplius. Adhuc. Iterum. Postea.

Are you condemned to do this?

—They are sundered by a bodily shame so steadfast that the criminal annals of the world, stained with all other incests and bestialities, hardly record its breach. Sons with mothers, sires with daughters, lesbic sisters, loves that dare not speak their name, nephews with grandmothers, jailbirds with keyholes, queens with prize bulls. The son unborn mars beauty: born, he brings pain, divides affection, increases care. He is a new male: his growth is his father’s decline, his youth his father’s envy, his friend his father’s enemy.

In rue Monsieur-le-Prince I thought it.

—What links them in nature? An instant of blind rut.

Am I a father? If I were?

Shrunken uncertain hand.

—Sabellius, the African, subtlest heresiarch of all the beasts of the field, held that the Father was Himself His Own Son. The bulldog of Aquin, with whom no word shall be impossible, refutes him. Well: if the father who has not a son be not a father can the son who has not a father be a son? When Rutlandbaconsouthamptonshakespeare or another poet of the same name in the comedy of errors wrote Hamlet he was not the father of his own son merely but, being no more a son, he was and felt himself the father of all his race, the father of his own grandfather, the father of his unborn grandson who, by the same token, never was born, for nature, as Mr Magee understands her, abhors perfection.

Eglintoneyes, quick with pleasure, looked up shybrightly. Gladly glancing, a merry puritan, through the twisted eglantine.

Flatter. Rarely. But flatter.

—Himself his own father, Sonmulligan told himself. Wait. I am big with child. I have an unborn child in my brain. Pallas Athena! A play! The play’s the thing! Let me parturiate!

He clasped his paunchbrow with both birthaiding hands.

—As for his family, Stephen said, his mother’s name lives in the forest of Arden. Her death brought from him the scene with Volumnia in Coriolanus. His boyson’s death is the deathscene of young Arthur in King John. Hamlet, the black prince, is Hamnet Shakespeare. Who the girls in The Tempest, in Pericles, in Winter’s Tale are we know. Who Cleopatra, fleshpot of Egypt, and Cressid and Venus are we may guess. But there is another member of his family who is recorded.

—The plot thickens, John Eglinton said.

The quaker librarian, quaking, tiptoed in, quake, his mask, quake, with haste, quake, quack.

Door closed. Cell. Day.

They list. Three. They.

I you he they.

Come, mess.

STEPHEN: He had three brothers, Gilbert, Edmund, Richard. Gilbert in his old age told some cavaliers he got a pass for nowt from Maister Gatherer one time mass he did and he seen his brud Maister Wull the playwriter up in Lunnon in a wrastling play wud a man on’s back. The playhouse sausage filled Gilbert’s soul. He is nowhere: but an Edmund and a Richard are recorded in the works of sweet William.

MAGEEGLINJOHN: Names! What’s in a name?

BEST: That is my name, Richard, don’t you know. I hope you are going to say a good word for Richard, don’t you know, for my sake. (Laughter)

BUCKMULLIGAN: (Piano, diminuendo)

Then outspoke medical Dick
To his comrade medical Davy...

STEPHEN: In his trinity of black Wills, the villain shakebags, Iago, Richard Crookback, Edmund in King Lear, two bear the wicked uncles’ names. Nay, that last play was written or being written while his brother Edmund lay dying in Southwark.

BEST: I hope Edmund is going to catch it. I don’t want Richard, my name ...

(Laughter)

QUAKERLYSTER: (A tempo) But he that filches from me my good name...

STEPHEN: (Stringendo) He has hidden his own name, a fair name, William, in the plays, a super here, a clown there, as a painter of old Italy set his face in a dark corner of his canvas. He has revealed it in the sonnets where there is Will in overplus. Like John o’Gaunt his name is dear to him, as dear as the coat and crest he toadied for, on a bend sable a spear or steeled argent, honorificabilitudinitatibus, dearer than his glory of greatest shakescene in the country. What’s in a name? That is what we ask ourselves in childhood when we write the name that we are told is ours. A star, a daystar, a firedrake, rose at his birth. It shone by day in the heavens alone, brighter than Venus in the night, and by night it shone over delta in Cassiopeia, the recumbent constellation which is the signature of his initial among the stars. His eyes watched it, lowlying on the horizon, eastward of the bear, as he walked by the slumberous summer fields at midnight returning from Shottery and from her arms.

Both satisfied. I too.

Don’t tell them he was nine years old when it was quenched.

And from her arms.

Wait to be wooed and won. Ay, meacock. Who will woo you?

Read the skies. Autontimorumenos. Bous Stephanoumenos. Where’s your configuration? Stephen, Stephen, cut the bread even. S. D: sua donna. Già: di lui. Gelindo risolve di non amare S. D.

—What is that, Mr Dedalus? the quaker librarian asked. Was it a celestial phenomenon?

—A star by night, Stephen said. A pillar of the cloud by day.

What more’s to speak?

Stephen looked on his hat, his stick, his boots.

Stephanos, my crown. My sword. His boots are spoiling the shape of my feet. Buy a pair. Holes in my socks. Handkerchief too.

—You make good use of the name, John Eglinton allowed. Your own name is strange enough. I suppose it explains your fantastical humour.

Me, Magee and Mulligan.

Fabulous artificer. The hawklike man. You flew. Whereto? Newhaven-Dieppe, steerage passenger. Paris and back. Lapwing. Icarus. Pater, ait. Seabedabbled, fallen, weltering. Lapwing you are. Lapwing be.

Mr Best eagerquietly lifted his book to say:

—That’s very interesting because that brother motive, don’t you know, we find also in the old Irish myths. Just what you say. The three brothers Shakespeare. In Grimm too, don’t you know, the fairytales. The third brother that always marries the sleeping beauty and wins the best prize.

Best of Best brothers. Good, better, best.

The quaker librarian springhalted near.

—I should like to know, he said, which brother you... I understand you to suggest there was misconduct with one of the brothers... But perhaps I am anticipating?

He caught himself in the act: looked at all: refrained.

An attendant from the doorway called:

—Mr Lyster! Father Dineen wants...

—O, Father Dineen! Directly.

Swiftly rectly creaking rectly rectly he was rectly gone.

John Eglinton touched the foil.

—Come, he said. Let us hear what you have to say of Richard and Edmund. You kept them for the last, didn’t you?

—In asking you to remember those two noble kinsmen nuncle Richie and nuncle Edmund, Stephen answered, I feel I am asking too much perhaps. A brother is as easily forgotten as an umbrella.

Lapwing.

Where is your brother? Apothecaries’ hall. My whetstone. Him, then Cranly, Mulligan: now these. Speech, speech. But act. Act speech. They mock to try you. Act. Be acted on.

Lapwing.

I am tired of my voice, the voice of Esau. My kingdom for a drink.

On.

—You will say those names were already in the chronicles from which he took the stuff of his plays. Why did he take them rather than others? Richard, a whoreson crookback, misbegotten, makes love to a widowed Ann (what’s in a name?), woos and wins her, a whoreson merry widow. Richard the conqueror, third brother, came after William the conquered. The other four acts of that play hang limply from that first. Of all his kings Richard is the only king unshielded by Shakespeare’s reverence, the angel of the world. Why is the underplot of King Lear in which Edmund figures lifted out of Sidney’s Arcadia and spatchcocked on to a Celtic legend older than history?

—That was Will’s way, John Eglinton defended. We should not now combine a Norse saga with an excerpt from a novel by George Meredith. Que voulez-vous? Moore would say. He puts Bohemia on the seacoast and makes Ulysses quote Aristotle.

—Why? Stephen answered himself. Because the theme of the false or the usurping or the adulterous brother or all three in one is to Shakespeare, what the poor are not, always with him. The note of banishment, banishment from the heart, banishment from home, sounds uninterruptedly from The Two Gentlemen of Verona onward till Prospero breaks his staff, buries it certain fathoms in the earth and drowns his book. It doubles itself in the middle of his life, reflects itself in another, repeats itself, protasis, epitasis, catastasis, catastrophe. It repeats itself again when he is near the grave, when his married daughter Susan, chip of the old block, is accused of adultery. But it was the original sin that darkened his understanding, weakened his will and left in him a strong inclination to evil. The words are those of my lords bishops of Maynooth. An original sin and, like original sin, committed by another in whose sin he too has sinned. It is between the lines of his last written words, it is petrified on his tombstone under which her four bones are not to be laid. Age has not withered it. Beauty and peace have not done it away. It is in infinite variety everywhere in the world he has created, in Much Ado about Nothing, twice in As you like It, in The Tempest, in Hamlet, in Measure for Measure—and in all the other plays which I have not read.

He laughed to free his mind from his mind’s bondage.

Judge Eglinton summed up.

—The truth is midway, he affirmed. He is the ghost and the prince. He is all in all.

—He is, Stephen said. The boy of act one is the mature man of act five. All in all. In Cymbeline, in Othello he is bawd and cuckold. He acts and is acted on. Lover of an ideal or a perversion, like José he kills the real Carmen. His unremitting intellect is the hornmad Iago ceaselessly willing that the moor in him shall suffer.

—Cuckoo! Cuckoo! Cuck Mulligan clucked lewdly. O word of fear!

Dark dome received, reverbed.

—And what a character is Iago! undaunted John Eglinton exclaimed. When all is said Dumas fils (or is it Dumas père?) is right. After God Shakespeare has created most.

—Man delights him not nor woman neither, Stephen said. He returns after a life of absence to that spot of earth where he was born, where he has always been, man and boy, a silent witness and there, his journey of life ended, he plants his mulberrytree in the earth. Then dies. The motion is ended. Gravediggers bury Hamlet père and Hamlet fils. A king and a prince at last in death, with incidental music. And, what though murdered and betrayed, bewept by all frail tender hearts for, Dane or Dubliner, sorrow for the dead is the only husband from whom they refuse to be divorced. If you like the epilogue look long on it: prosperous Prospero, the good man rewarded, Lizzie, grandpa’s lump of love, and nuncle Richie, the bad man taken off by poetic justice to the place where the bad niggers go. Strong curtain. He found in the world without as actual what was in his world within as possible. Maeterlinck says: If Socrates leave his house today he will find the sage seated on his doorstep. If Judas go forth tonight it is to Judas his steps will tend. Every life is many days, day after day. We walk through ourselves, meeting robbers, ghosts, giants, old men, young men, wives, widows, brothers-in-love, but always meeting ourselves. The playwright who wrote the folio of this world and wrote it badly (He gave us light first and the sun two days later), the lord of things as they are whom the most Roman of catholics call dio boia, hangman god, is doubtless all in all in all of us, ostler and butcher, and would be bawd and cuckold too but that in the economy of heaven, foretold by Hamlet, there are no more marriages, glorified man, an androgynous angel, being a wife unto himself.

—Eureka! Buck Mulligan cried. Eureka!

Suddenly happied he jumped up and reached in a stride John Eglinton’s desk.

—May I? he said. The Lord has spoken to Malachi.

He began to scribble on a slip of paper.

Take some slips from the counter going out.

—Those who are married, Mr Best, douce herald, said, all save one, shall live. The rest shall keep as they are.

He laughed, unmarried, at Eglinton Johannes, of arts a bachelor.

Unwed, unfancied, ware of wiles, they fingerponder nightly each his variorum edition of The Taming of the Shrew.

—You are a delusion, said roundly John Eglinton to Stephen. You have brought us all this way to show us a French triangle. Do you believe your own theory?

—No, Stephen said promptly.

—Are you going to write it? Mr Best asked. You ought to make it a dialogue, don’t you know, like the Platonic dialogues Wilde wrote.

John Eclecticon doubly smiled.

—Well, in that case, he said, I don’t see why you should expect payment for it since you don’t believe it yourself. Dowden believes there is some mystery in Hamlet but will say no more. Herr Bleibtreu, the man Piper met in Berlin, who is working up that Rutland theory, believes that the secret is hidden in the Stratford monument. He is going to visit the present duke, Piper says, and prove to him that his ancestor wrote the plays. It will come as a surprise to his grace. But he believes his theory.

I believe, O Lord, help my unbelief. That is, help me to believe or help me to unbelieve? Who helps to believe? Egomen. Who to unbelieve? Other chap.

—You are the only contributor to Dana who asks for pieces of silver. Then I don’t know about the next number. Fred Ryan wants space for an article on economics.

Fraidrine. Two pieces of silver he lent me. Tide you over. Economics.

—For a guinea, Stephen said, you can publish this interview.

Buck Mulligan stood up from his laughing scribbling, laughing: and then gravely said, honeying malice:

—I called upon the bard Kinch at his summer residence in upper Mecklenburgh street and found him deep in the study of the Summa contra Gentiles in the company of two gonorrheal ladies, Fresh Nelly and Rosalie, the coalquay whore.

He broke away.

—Come, Kinch. Come, wandering Ængus of the birds.

Come, Kinch. You have eaten all we left. Ay. I will serve you your orts and offals.

Stephen rose.

Life is many days. This will end.

—We shall see you tonight, John Eglinton said. Notre ami Moore says Malachi Mulligan must be there.

Buck Mulligan flaunted his slip and panama.

—Monsieur Moore, he said, lecturer on French letters to the youth of Ireland. I’ll be there. Come, Kinch, the bards must drink. Can you walk straight?

Laughing, he...

Swill till eleven. Irish nights entertainment.

Lubber...

Stephen followed a lubber...

One day in the national library we had a discussion. Shakes. After. His lub back: I followed. I gall his kibe.

Stephen, greeting, then all amort, followed a lubber jester, a wellkempt head, newbarbered, out of the vaulted cell into a shattering daylight of no thought.

What have I learned? Of them? Of me?

Walk like Haines now.

The constant readers’ room. In the readers’ book Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell parafes his polysyllables. Item: was Hamlet mad? The quaker’s pate godlily with a priesteen in booktalk.

—O please do, sir... I shall be most pleased...

Amused Buck Mulligan mused in pleasant murmur with himself, selfnodding:

—A pleased bottom.

The turnstile.

Is that?... Blueribboned hat... Idly writing... What? Looked?...

The curving balustrade: smoothsliding Mincius.

Puck Mulligan, panamahelmeted, went step by step, iambing, trolling:

John Eglinton, my jo, John,
Why won’t you wed a wife?

He spluttered to the air:

—O, the chinless Chinaman! Chin Chon Eg Lin Ton. We went over to their playbox, Haines and I, the plumbers’ hall. Our players are creating a new art for Europe like the Greeks or M. Maeterlinck. Abbey Theatre! I smell the pubic sweat of monks.

He spat blank.

Forgot: any more than he forgot the whipping lousy Lucy gave him. And left the femme de trente ans. And why no other children born? And his first child a girl?

Afterwit. Go back.

The dour recluse still there (he has his cake) and the douce youngling, minion of pleasure, Phedo’s toyable fair hair.

Eh... I just eh... wanted... I forgot... he...

—Longworth and M’Curdy Atkinson were there...

Puck Mulligan footed featly, trilling:

I hardly hear the purlieu cry
Or a Tommy talk as I pass one by
Before my thoughts begin to run
On F. M’Curdy Atkinson,
The same that had the wooden leg
And that filibustering filibeg
That never dared to slake his drouth,
Magee that had the chinless mouth.
Being afraid to marry on earth
They masturbated for all they were worth.

Jest on. Know thyself.

Halted, below me, a quizzer looks at me. I halt.

—Mournful mummer, Buck Mulligan moaned. Synge has left off wearing black to be like nature. Only crows, priests and English coal are black.

A laugh tripped over his lips.

—Longworth is awfully sick, he said, after what you wrote about that old hake Gregory. O you inquisitional drunken jewjesuit! She gets you a job on the paper and then you go and slate her drivel to Jaysus. Couldn’t you do the Yeats touch?

He went on and down, mopping, chanting with waving graceful arms:

—The most beautiful book that has come out of our country in my time. One thinks of Homer.

He stopped at the stairfoot.

—I have conceived a play for the mummers, he said solemnly.

The pillared Moorish hall, shadows entwined. Gone the nine men’s morrice with caps of indices.

In sweetly varying voices Buck Mulligan read his tablet:

Everyman His Own Wife
or
A Honeymoon in the Hand
(a national immorality in three orgasms)
by
Ballocky Mulligan.

He turned a happy patch’s smirk to Stephen, saying:

—The disguise, I fear, is thin. But listen.

He read, marcato:

—Characters:

     TOBY TOSTOFF (a ruined Pole)
     CRAB (a bushranger)
     MEDICAL DICK )
         and      ) (two birds with one stone)
     MEDICAL DAVY )
     MOTHER GROGAN (a watercarrier)
     FRESH NELLY
         and
     ROSALIE (the coalquay whore).
He laughed, lolling a to and fro head, walking on, followed by Stephen: and mirthfully he told the shadows, souls of men:

—O, the night in the Camden hall when the daughters of Erin had to lift their skirts to step over you as you lay in your mulberrycoloured, multicoloured, multitudinous vomit!

—The most innocent son of Erin, Stephen said, for whom they ever lifted them.

About to pass through the doorway, feeling one behind, he stood aside.

Part. The moment is now. Where then? If Socrates leave his house today, if Judas go forth tonight. Why? That lies in space which I in time must come to, ineluctably.

My will: his will that fronts me. Seas between.

A man passed out between them, bowing, greeting.

—Good day again, Buck Mulligan said.

The portico.

Here I watched the birds for augury. Ængus of the birds. They go, they come. Last night I flew. Easily flew. Men wondered. Street of harlots after. A creamfruit melon he held to me. In. You will see.

—The wandering jew, Buck Mulligan whispered with clown’s awe. Did you see his eye? He looked upon you to lust after you. I fear thee, ancient mariner. O, Kinch, thou art in peril. Get thee a breechpad.

Manner of Oxenford.

Day. Wheelbarrow sun over arch of bridge.

A dark back went before them, step of a pard, down, out by the gateway, under portcullis barbs.

They followed.

Offend me still. Speak on.

Kind air defined the coigns of houses in Kildare street. No birds. Frail from the housetops two plumes of smoke ascended, pluming, and in a flaw of softness softly were blown.

Cease to strive. Peace of the druid priests of Cymbeline: hierophantic: from wide earth an altar.

            Laud we the gods
And let our crooked smokes climb to their nostrils
From our bless’d altars.

### [ 10 ]
The superior, the very reverend John Conmee S. J. reset his smooth watch in his interior pocket as he came down the presbytery steps. Five to three. Just nice time to walk to Artane. What was that boy’s name again? Dignam. Yes. Vere dignum et iustum est. Brother Swan was the person to see. Mr Cunningham’s letter. Yes. Oblige him, if possible. Good practical catholic: useful at mission time.

A onelegged sailor, swinging himself onward by lazy jerks of his crutches, growled some notes. He jerked short before the convent of the sisters of charity and held out a peaked cap for alms towards the very reverend John Conmee S. J. Father Conmee blessed him in the sun for his purse held, he knew, one silver crown.

Father Conmee crossed to Mountjoy square. He thought, but not for long, of soldiers and sailors, whose legs had been shot off by cannonballs, ending their days in some pauper ward, and of cardinal Wolsey’s words: If I had served my God as I have served my king He would not have abandoned me in my old days. He walked by the treeshade of sunnywinking leaves: and towards him came the wife of Mr David Sheehy M.P.

—Very well, indeed, father. And you, father?

Father Conmee was wonderfully well indeed. He would go to Buxton probably for the waters. And her boys, were they getting on well at Belvedere? Was that so? Father Conmee was very glad indeed to hear that. And Mr Sheehy himself? Still in London. The house was still sitting, to be sure it was. Beautiful weather it was, delightful indeed. Yes, it was very probable that Father Bernard Vaughan would come again to preach. O, yes: a very great success. A wonderful man really.

Father Conmee was very glad to see the wife of Mr David Sheehy M.P. Iooking so well and he begged to be remembered to Mr David Sheehy M.P. Yes, he would certainly call.

—Good afternoon, Mrs Sheehy.

Father Conmee doffed his silk hat and smiled, as he took leave, at the jet beads of her mantilla inkshining in the sun. And smiled yet again, in going. He had cleaned his teeth, he knew, with arecanut paste.

Father Conmee walked and, walking, smiled for he thought on Father Bernard Vaughan’s droll eyes and cockney voice.

—Pilate! Wy don’t you old back that owlin mob?

A zealous man, however. Really he was. And really did great good in his way. Beyond a doubt. He loved Ireland, he said, and he loved the Irish. Of good family too would one think it? Welsh, were they not?

O, lest he forget. That letter to father provincial.

Father Conmee stopped three little schoolboys at the corner of Mountjoy square. Yes: they were from Belvedere. The little house. Aha. And were they good boys at school? O. That was very good now. And what was his name? Jack Sohan. And his name? Ger. Gallaher. And the other little man? His name was Brunny Lynam. O, that was a very nice name to have.

Father Conmee gave a letter from his breast to Master Brunny Lynam and pointed to the red pillarbox at the corner of Fitzgibbon street.

—But mind you don’t post yourself into the box, little man, he said.

The boys sixeyed Father Conmee and laughed:

—O, sir.

—Well, let me see if you can post a letter, Father Conmee said.

Master Brunny Lynam ran across the road and put Father Conmee’s letter to father provincial into the mouth of the bright red letterbox. Father Conmee smiled and nodded and smiled and walked along Mountjoy square east.

Mr Denis J Maginni, professor of dancing &c, in silk hat, slate frockcoat with silk facings, white kerchief tie, tight lavender trousers, canary gloves and pointed patent boots, walking with grave deportment most respectfully took the curbstone as he passed lady Maxwell at the corner of Dignam’s court.

Was that not Mrs M’Guinness?

Mrs M’Guinness, stately, silverhaired, bowed to Father Conmee from the farther footpath along which she sailed. And Father Conmee smiled and saluted. How did she do?

A fine carriage she had. Like Mary, queen of Scots, something. And to think that she was a pawnbroker! Well, now! Such a... what should he say?... such a queenly mien.

Father Conmee walked down Great Charles street and glanced at the shutup free church on his left. The reverend T. R. Greene B.A. will (D.V.) speak. The incumbent they called him. He felt it incumbent on him to say a few words. But one should be charitable. Invincible ignorance. They acted according to their lights.

Father Conmee turned the corner and walked along the North Circular road. It was a wonder that there was not a tramline in such an important thoroughfare. Surely, there ought to be.

A band of satchelled schoolboys crossed from Richmond street. All raised untidy caps. Father Conmee greeted them more than once benignly. Christian brother boys.

Father Conmee smelt incense on his right hand as he walked. Saint Joseph’s church, Portland row. For aged and virtuous females. Father Conmee raised his hat to the Blessed Sacrament. Virtuous: but occasionally they were also badtempered.

Near Aldborough house Father Conmee thought of that spendthrift nobleman. And now it was an office or something.

Father Conmee began to walk along the North Strand road and was saluted by Mr William Gallagher who stood in the doorway of his shop. Father Conmee saluted Mr William Gallagher and perceived the odours that came from baconflitches and ample cools of butter. He passed Grogan’s the Tobacconist against which newsboards leaned and told of a dreadful catastrophe in New York. In America those things were continually happening. Unfortunate people to die like that, unprepared. Still, an act of perfect contrition.

Father Conmee went by Daniel Bergin’s publichouse against the window of which two unlabouring men lounged. They saluted him and were saluted.

Father Conmee passed H. J. O’Neill’s funeral establishment where Corny Kelleher totted figures in the daybook while he chewed a blade of hay. A constable on his beat saluted Father Conmee and Father Conmee saluted the constable. In Youkstetter’s, the porkbutcher’s, Father Conmee observed pig’s puddings, white and black and red, lie neatly curled in tubes.

Moored under the trees of Charleville Mall Father Conmee saw a turfbarge, a towhorse with pendent head, a bargeman with a hat of dirty straw seated amidships, smoking and staring at a branch of poplar above him. It was idyllic: and Father Conmee reflected on the providence of the Creator who had made turf to be in bogs whence men might dig it out and bring it to town and hamlet to make fires in the houses of poor people.

On Newcomen bridge the very reverend John Conmee S. J. of saint Francis Xavier’s church, upper Gardiner street, stepped on to an outward bound tram.

Off an inward bound tram stepped the reverend Nicholas Dudley C. C. of saint Agatha’s church, north William street, on to Newcomen bridge.

At Newcomen bridge Father Conmee stepped into an outward bound tram for he disliked to traverse on foot the dingy way past Mud Island.

Father Conmee sat in a corner of the tramcar, a blue ticket tucked with care in the eye of one plump kid glove, while four shillings, a sixpence and five pennies chuted from his other plump glovepalm into his purse. Passing the ivy church he reflected that the ticket inspector usually made his visit when one had carelessly thrown away the ticket. The solemnity of the occupants of the car seemed to Father Conmee excessive for a journey so short and cheap. Father Conmee liked cheerful decorum.

It was a peaceful day. The gentleman with the glasses opposite Father Conmee had finished explaining and looked down. His wife, Father Conmee supposed. A tiny yawn opened the mouth of the wife of the gentleman with the glasses. She raised her small gloved fist, yawned ever so gently, tiptapping her small gloved fist on her opening mouth and smiled tinily, sweetly.

Father Conmee perceived her perfume in the car. He perceived also that the awkward man at the other side of her was sitting on the edge of the seat.

Father Conmee at the altarrails placed the host with difficulty in the mouth of the awkward old man who had the shaky head.

At Annesley bridge the tram halted and, when it was about to go, an old woman rose suddenly from her place to alight. The conductor pulled the bellstrap to stay the car for her. She passed out with her basket and a marketnet: and Father Conmee saw the conductor help her and net and basket down: and Father Conmee thought that, as she had nearly passed the end of the penny fare, she was one of those good souls who had always to be told twice bless you, my child, that they have been absolved, pray for me. But they had so many worries in life, so many cares, poor creatures.

From the hoardings Mr Eugene Stratton grimaced with thick niggerlips at Father Conmee.

Father Conmee thought of the souls of black and brown and yellow men and of his sermon on saint Peter Claver S. J. and the African mission and of the propagation of the faith and of the millions of black and brown and yellow souls that had not received the baptism of water when their last hour came like a thief in the night. That book by the Belgian jesuit, Le Nombre des Élus, seemed to Father Conmee a reasonable plea. Those were millions of human souls created by God in His Own likeness to whom the faith had not (D.V.) been brought. But they were God’s souls, created by God. It seemed to Father Conmee a pity that they should all be lost, a waste, if one might say.

At the Howth road stop Father Conmee alighted, was saluted by the conductor and saluted in his turn.

The Malahide road was quiet. It pleased Father Conmee, road and name. The joybells were ringing in gay Malahide. Lord Talbot de Malahide, immediate hereditary lord admiral of Malahide and the seas adjoining. Then came the call to arms and she was maid, wife and widow in one day. Those were old worldish days, loyal times in joyous townlands, old times in the barony.

Father Conmee, walking, thought of his little book Old Times in the Barony and of the book that might be written about jesuit houses and of Mary Rochfort, daughter of lord Molesworth, first countess of Belvedere.

A listless lady, no more young, walked alone the shore of lough Ennel, Mary, first countess of Belvedere, listlessly walking in the evening, not startled when an otter plunged. Who could know the truth? Not the jealous lord Belvedere and not her confessor if she had not committed adultery fully, eiaculatio seminis inter vas naturale mulieris, with her husband’s brother? She would half confess if she had not all sinned as women did. Only God knew and she and he, her husband’s brother.

Father Conmee thought of that tyrannous incontinence, needed however for man’s race on earth, and of the ways of God which were not our ways.

Don John Conmee walked and moved in times of yore. He was humane and honoured there. He bore in mind secrets confessed and he smiled at smiling noble faces in a beeswaxed drawingroom, ceiled with full fruit clusters. And the hands of a bride and of a bridegroom, noble to noble, were impalmed by Don John Conmee.

It was a charming day.

The lychgate of a field showed Father Conmee breadths of cabbages, curtseying to him with ample underleaves. The sky showed him a flock of small white clouds going slowly down the wind. Moutonner, the French said. A just and homely word.

Father Conmee, reading his office, watched a flock of muttoning clouds over Rathcoffey. His thinsocked ankles were tickled by the stubble of Clongowes field. He walked there, reading in the evening, and heard the cries of the boys’ lines at their play, young cries in the quiet evening. He was their rector: his reign was mild.

Father Conmee drew off his gloves and took his rededged breviary out. An ivory bookmark told him the page.

Nones. He should have read that before lunch. But lady Maxwell had come.

Father Conmee read in secret Pater and Ave and crossed his breast. Deus in adiutorium.

He walked calmly and read mutely the nones, walking and reading till he came to Res in Beati immaculati: Principium verborum tuorum veritas: in eternum omnia iudicia iustitiæ tuæ.

A flushed young man came from a gap of a hedge and after him came a young woman with wild nodding daisies in her hand. The young man raised his cap abruptly: the young woman abruptly bent and with slow care detached from her light skirt a clinging twig.

Father Conmee blessed both gravely and turned a thin page of his breviary. Sin: Principes persecuti sunt me gratis: et a verbis tuis formidavit cor meum.

*    *    *

Corny Kelleher closed his long daybook and glanced with his drooping eye at a pine coffinlid sentried in a corner. He pulled himself erect, went to it and, spinning it on its axle, viewed its shape and brass furnishings. Chewing his blade of hay he laid the coffinlid by and came to the doorway. There he tilted his hatbrim to give shade to his eyes and leaned against the doorcase, looking idly out.

Father John Conmee stepped into the Dollymount tram on Newcomen bridge.

Corny Kelleher locked his largefooted boots and gazed, his hat downtilted, chewing his blade of hay.

Constable 57C, on his beat, stood to pass the time of day.

—That’s a fine day, Mr Kelleher.

—Ay, Corny Kelleher said.

—It’s very close, the constable said.

Corny Kelleher sped a silent jet of hayjuice arching from his mouth while a generous white arm from a window in Eccles street flung forth a coin.

—What’s the best news? he asked.

—I seen that particular party last evening, the constable said with bated breath.

*    *    *

A onelegged sailor crutched himself round MacConnell’s corner, skirting Rabaiotti’s icecream car, and jerked himself up Eccles street. Towards Larry O’Rourke, in shirtsleeves in his doorway, he growled unamiably:

—For England...

He swung himself violently forward past Katey and Boody Dedalus, halted and growled:

—home and beauty.

J. J. O’Molloy’s white careworn face was told that Mr Lambert was in the warehouse with a visitor.

A stout lady stopped, took a copper coin from her purse and dropped it into the cap held out to her. The sailor grumbled thanks, glanced sourly at the unheeding windows, sank his head and swung himself forward four strides.

He halted and growled angrily:

—For England...

Two barefoot urchins, sucking long liquorice laces, halted near him, gaping at his stump with their yellowslobbered mouths.

He swung himself forward in vigorous jerks, halted, lifted his head towards a window and bayed deeply:

—home and beauty.

The gay sweet chirping whistling within went on a bar or two, ceased. The blind of the window was drawn aside. A card Unfurnished Apartments slipped from the sash and fell. A plump bare generous arm shone, was seen, held forth from a white petticoatbodice and taut shiftstraps. A woman’s hand flung forth a coin over the area railings. It fell on the path.

One of the urchins ran to it, picked it up and dropped it into the minstrel’s cap, saying:

—There, sir.

*    *    *

Katey and Boody Dedalus shoved in the door of the closesteaming kitchen.

—Did you put in the books? Boody asked.

Maggy at the range rammed down a greyish mass beneath bubbling suds twice with her potstick and wiped her brow.

—They wouldn’t give anything on them, she said.

Father Conmee walked through Clongowes fields, his thinsocked ankles tickled by stubble.

—Where did you try? Boody asked.

—M’Guinness’s.

Boody stamped her foot and threw her satchel on the table.

—Bad cess to her big face! she cried.

Katey went to the range and peered with squinting eyes.

—What’s in the pot? she asked.

—Shirts, Maggy said.

Boody cried angrily:

—Crickey, is there nothing for us to eat?

Katey, lifting the kettlelid in a pad of her stained skirt, asked:

—And what’s in this?

A heavy fume gushed in answer.

—Peasoup, Maggy said.

—Where did you get it? Katey asked.

—Sister Mary Patrick, Maggy said.

The lacquey rang his bell.

—Barang!

Boody sat down at the table and said hungrily:

—Give us it here.

Maggy poured yellow thick soup from the kettle into a bowl. Katey, sitting opposite Boody, said quietly, as her fingertip lifted to her mouth random crumbs:

—A good job we have that much. Where’s Dilly?

—Gone to meet father, Maggy said.

Boody, breaking big chunks of bread into the yellow soup, added:

—Our father who art not in heaven.

Maggy, pouring yellow soup in Katey’s bowl, exclaimed:

—Boody! For shame!

A skiff, a crumpled throwaway, Elijah is coming, rode lightly down the Liffey, under Loopline bridge, shooting the rapids where water chafed around the bridgepiers, sailing eastward past hulls and anchorchains, between the Customhouse old dock and George’s quay.

*    *    *

The blond girl in Thornton’s bedded the wicker basket with rustling fibre. Blazes Boylan handed her the bottle swathed in pink tissue paper and a small jar.

—Put these in first, will you? he said.

—Yes, sir, the blond girl said. And the fruit on top.

—That’ll do, game ball, Blazes Boylan said.

She bestowed fat pears neatly, head by tail, and among them ripe shamefaced peaches.

Blazes Boylan walked here and there in new tan shoes about the fruitsmelling shop, lifting fruits, young juicy crinkled and plump red tomatoes, sniffing smells.

H. E. L. Y.’S filed before him, tallwhitehatted, past Tangier lane, plodding towards their goal.

He turned suddenly from a chip of strawberries, drew a gold watch from his fob and held it at its chain’s length.

—Can you send them by tram? Now?

A darkbacked figure under Merchants’ arch scanned books on the hawker’s cart.

—Certainly, sir. Is it in the city?

—O, yes, Blazes Boylan said. Ten minutes.

The blond girl handed him a docket and pencil.

—Will you write the address, sir?

Blazes Boylan at the counter wrote and pushed the docket to her.

—Send it at once, will you? he said. It’s for an invalid.

—Yes, sir. I will, sir.

Blazes Boylan rattled merry money in his trousers’ pocket.

—What’s the damage? he asked.

The blond girl’s slim fingers reckoned the fruits.

Blazes Boylan looked into the cut of her blouse. A young pullet. He took a red carnation from the tall stemglass.

—This for me? he asked gallantly.

The blond girl glanced sideways at him, got up regardless, with his tie a bit crooked, blushing.

—Yes, sir, she said.

Bending archly she reckoned again fat pears and blushing peaches.

Blazes Boylan looked in her blouse with more favour, the stalk of the red flower between his smiling teeth.

—May I say a word to your telephone, missy? he asked roguishly.

*    *    *

—Ma! Almidano Artifoni said.

He gazed over Stephen’s shoulder at Goldsmith’s knobby poll.

Two carfuls of tourists passed slowly, their women sitting fore, gripping the handrests. Palefaces. Men’s arms frankly round their stunted forms. They looked from Trinity to the blind columned porch of the bank of Ireland where pigeons roocoocooed.

—Anch’io ho avuto di queste idee, Almidano Artifoni said, quand’ ero giovine come Lei. Eppoi mi sono convinto che il mondo è una bestia. È peccato. Perchè la sua voce... sarebbe un cespite di rendita, via. Invece, Lei si sacrifica.

—Sacrifizio incruento, Stephen said smiling, swaying his ashplant in slow swingswong from its midpoint, lightly.

—Speriamo, the round mustachioed face said pleasantly. Ma, dia retta a me. Ci rifletta.

By the stern stone hand of Grattan, bidding halt, an Inchicore tram unloaded straggling Highland soldiers of a band.

—Ci rifletterò, Stephen said, glancing down the solid trouserleg.

—Ma, sul serio, eh? Almidano Artifoni said.

His heavy hand took Stephen’s firmly. Human eyes. They gazed curiously an instant and turned quickly towards a Dalkey tram.

—Eccolo, Almidano Artifoni said in friendly haste. Venga a trovarmi e ci pensi. Addio, caro.

—Arrivederla, maestro, Stephen said, raising his hat when his hand was freed. E grazie.

—Di che? Almidano Artifoni said. Scusi, eh? Tante belle cose!

Almidano Artifoni, holding up a baton of rolled music as a signal, trotted on stout trousers after the Dalkey tram. In vain he trotted, signalling in vain among the rout of barekneed gillies smuggling implements of music through Trinity gates.

*    *    *

Miss Dunne hid the Capel street library copy of The Woman in White far back in her drawer and rolled a sheet of gaudy notepaper into her typewriter.

Too much mystery business in it. Is he in love with that one, Marion? Change it and get another by Mary Cecil Haye.

The disk shot down the groove, wobbled a while, ceased and ogled them: six.

Miss Dunne clicked on the keyboard:

—16 June 1904.

Five tallwhitehatted sandwichmen between Monypeny’s corner and the slab where Wolfe Tone’s statue was not, eeled themselves turning H. E. L. Y.’S and plodded back as they had come.

Then she stared at the large poster of Marie Kendall, charming soubrette, and, listlessly lolling, scribbled on the jotter sixteens and capital esses. Mustard hair and dauby cheeks. She’s not nicelooking, is she? The way she’s holding up her bit of a skirt. Wonder will that fellow be at the band tonight. If I could get that dressmaker to make a concertina skirt like Susy Nagle’s. They kick out grand. Shannon and all the boatclub swells never took his eyes off her. Hope to goodness he won’t keep me here till seven.

The telephone rang rudely by her ear.

—Hello. Yes, sir. No, sir. Yes, sir. I’ll ring them up after five. Only those two, sir, for Belfast and Liverpool. All right, sir. Then I can go after six if you’re not back. A quarter after. Yes, sir. Twentyseven and six. I’ll tell him. Yes: one, seven, six.

She scribbled three figures on an envelope.

—Mr Boylan! Hello! That gentleman from Sport was in looking for you. Mr Lenehan, yes. He said he’ll be in the Ormond at four. No, sir. Yes, sir. I’ll ring them up after five.

*    *    *

Two pink faces turned in the flare of the tiny torch.

—Who’s that? Ned Lambert asked. Is that Crotty?

—Ringabella and Crosshaven, a voice replied groping for foothold.

—Hello, Jack, is that yourself? Ned Lambert said, raising in salute his pliant lath among the flickering arches. Come on. Mind your steps there.

The vesta in the clergyman’s uplifted hand consumed itself in a long soft flame and was let fall. At their feet its red speck died: and mouldy air closed round them.

—How interesting! a refined accent said in the gloom.

—Yes, sir, Ned Lambert said heartily. We are standing in the historic council chamber of saint Mary’s abbey where silken Thomas proclaimed himself a rebel in 1534. This is the most historic spot in all Dublin. O’Madden Burke is going to write something about it one of these days. The old bank of Ireland was over the way till the time of the union and the original jews’ temple was here too before they built their synagogue over in Adelaide road. You were never here before, Jack, were you?

—No, Ned.

—He rode down through Dame walk, the refined accent said, if my memory serves me. The mansion of the Kildares was in Thomas court.

—That’s right, Ned Lambert said. That’s quite right, sir.

—If you will be so kind then, the clergyman said, the next time to allow me perhaps...

—Certainly, Ned Lambert said. Bring the camera whenever you like. I’ll get those bags cleared away from the windows. You can take it from here or from here.

In the still faint light he moved about, tapping with his lath the piled seedbags and points of vantage on the floor.

From a long face a beard and gaze hung on a chessboard.

—I’m deeply obliged, Mr Lambert, the clergyman said. I won’t trespass on your valuable time...

—You’re welcome, sir, Ned Lambert said. Drop in whenever you like. Next week, say. Can you see?

—Yes, yes. Good afternoon, Mr Lambert. Very pleased to have met you.

—Pleasure is mine, sir, Ned Lambert answered.

He followed his guest to the outlet and then whirled his lath away among the pillars. With J. J. O’Molloy he came forth slowly into Mary’s abbey where draymen were loading floats with sacks of carob and palmnut meal, O’Connor, Wexford.

He stood to read the card in his hand.

—The reverend Hugh C. Love, Rathcoffey. Present address: Saint Michael’s, Sallins. Nice young chap he is. He’s writing a book about the Fitzgeralds he told me. He’s well up in history, faith.

The young woman with slow care detached from her light skirt a clinging twig.

—I thought you were at a new gunpowder plot, J. J. O’Molloy said.

Ned Lambert cracked his fingers in the air.

—God! he cried. I forgot to tell him that one about the earl of Kildare after he set fire to Cashel cathedral. You know that one? I’m bloody sorry I did it, says he, but I declare to God I thought the archbishop was inside. He mightn’t like it, though. What? God, I’ll tell him anyhow. That was the great earl, the Fitzgerald Mor. Hot members they were all of them, the Geraldines.

The horses he passed started nervously under their slack harness. He slapped a piebald haunch quivering near him and cried:

—Woa, sonny!

He turned to J. J. O’Molloy and asked:

—Well, Jack. What is it? What’s the trouble? Wait awhile. Hold hard.

With gaping mouth and head far back he stood still and, after an instant, sneezed loudly.

—Chow! he said. Blast you!

—The dust from those sacks, J. J. O’Molloy said politely.

—No, Ned Lambert gasped, I caught a... cold night before... blast your soul... night before last... and there was a hell of a lot of draught...

He held his handkerchief ready for the coming...

—I was... Glasnevin this morning... poor little... what do you call him... Chow!... Mother of Moses!

*    *    *

Tom Rochford took the top disk from the pile he clasped against his claret waistcoat.

—See? he said. Say it’s turn six. In here, see. Turn Now On.

He slid it into the left slot for them. It shot down the groove, wobbled a while, ceased, ogling them: six.

Lawyers of the past, haughty, pleading, beheld pass from the consolidated taxing office to Nisi Prius court Richie Goulding carrying the costbag of Goulding, Collis and Ward and heard rustling from the admiralty division of king’s bench to the court of appeal an elderly female with false teeth smiling incredulously and a black silk skirt of great amplitude.

—See? he said. See now the last one I put in is over here: Turns Over. The impact. Leverage, see?

He showed them the rising column of disks on the right.

—Smart idea, Nosey Flynn said, snuffling. So a fellow coming in late can see what turn is on and what turns are over.

—See? Tom Rochford said.

He slid in a disk for himself: and watched it shoot, wobble, ogle, stop: four. Turn Now On.

—I’ll see him now in the Ormond, Lenehan said, and sound him. One good turn deserves another.

—Do, Tom Rochford said. Tell him I’m Boylan with impatience.

—Goodnight, M’Coy said abruptly. When you two begin...

Nosey Flynn stooped towards the lever, snuffling at it.

—But how does it work here, Tommy? he asked.

—Tooraloo, Lenehan said. See you later.

He followed M’Coy out across the tiny square of Crampton court.

—He’s a hero, he said simply.

—I know, M’Coy said. The drain, you mean.

—Drain? Lenehan said. It was down a manhole.

They passed Dan Lowry’s musichall where Marie Kendall, charming soubrette, smiled on them from a poster a dauby smile.

Going down the path of Sycamore street beside the Empire musichall Lenehan showed M’Coy how the whole thing was. One of those manholes like a bloody gaspipe and there was the poor devil stuck down in it, half choked with sewer gas. Down went Tom Rochford anyhow, booky’s vest and all, with the rope round him. And be damned but he got the rope round the poor devil and the two were hauled up.

—The act of a hero, he said.

At the Dolphin they halted to allow the ambulance car to gallop past them for Jervis street.

—This way, he said, walking to the right. I want to pop into Lynam’s to see Sceptre’s starting price. What’s the time by your gold watch and chain?

M’Coy peered into Marcus Tertius Moses’ sombre office, then at O’Neill’s clock.

—After three, he said. Who’s riding her?

—O. Madden, Lenehan said. And a game filly she is.

While he waited in Temple bar M’Coy dodged a banana peel with gentle pushes of his toe from the path to the gutter. Fellow might damn easy get a nasty fall there coming along tight in the dark.

The gates of the drive opened wide to give egress to the viceregal cavalcade.

—Even money, Lenehan said returning. I knocked against Bantam Lyons in there going to back a bloody horse someone gave him that hasn’t an earthly. Through here.

They went up the steps and under Merchants’ arch. A darkbacked figure scanned books on the hawker’s cart.

—There he is, Lenehan said.

—Wonder what he’s buying, M’Coy said, glancing behind.

—Leopoldo or the Bloom is on the Rye, Lenehan said.

—He’s dead nuts on sales, M’Coy said. I was with him one day and he bought a book from an old one in Liffey street for two bob. There were fine plates in it worth double the money, the stars and the moon and comets with long tails. Astronomy it was about.

Lenehan laughed.

—I’ll tell you a damn good one about comets’ tails, he said. Come over in the sun.

They crossed to the metal bridge and went along Wellington quay by the riverwall.

Master Patrick Aloysius Dignam came out of Mangan’s, late Fehrenbach’s, carrying a pound and a half of porksteaks.

—There was a long spread out at Glencree reformatory, Lenehan said eagerly. The annual dinner, you know. Boiled shirt affair. The lord mayor was there, Val Dillon it was, and sir Charles Cameron and Dan Dawson spoke and there was music. Bartell d’Arcy sang and Benjamin Dollard...

—I know, M’Coy broke in. My missus sang there once.

—Did she? Lenehan said.

A card Unfurnished Apartments reappeared on the windowsash of number 7 Eccles street.

He checked his tale a moment but broke out in a wheezy laugh.

—But wait till I tell you, he said. Delahunt of Camden street had the catering and yours truly was chief bottlewasher. Bloom and the wife were there. Lashings of stuff we put up: port wine and sherry and curacoa to which we did ample justice. Fast and furious it was. After liquids came solids. Cold joints galore and mince pies...

—I know, M’Coy said. The year the missus was there...

Lenehan linked his arm warmly.

—But wait till I tell you, he said. We had a midnight lunch too after all the jollification and when we sallied forth it was blue o’clock the morning after the night before. Coming home it was a gorgeous winter’s night on the Featherbed Mountain. Bloom and Chris Callinan were on one side of the car and I was with the wife on the other. We started singing glees and duets: Lo, the early beam of morning. She was well primed with a good load of Delahunt’s port under her bellyband. Every jolt the bloody car gave I had her bumping up against me. Hell’s delights! She has a fine pair, God bless her. Like that.

He held his caved hands a cubit from him, frowning:

—I was tucking the rug under her and settling her boa all the time. Know what I mean?

His hands moulded ample curves of air. He shut his eyes tight in delight, his body shrinking, and blew a sweet chirp from his lips.

—The lad stood to attention anyhow, he said with a sigh. She’s a gamey mare and no mistake. Bloom was pointing out all the stars and the comets in the heavens to Chris Callinan and the jarvey: the great bear and Hercules and the dragon, and the whole jingbang lot. But, by God, I was lost, so to speak, in the milky way. He knows them all, faith. At last she spotted a weeny weeshy one miles away. And what star is that, Poldy? says she. By God, she had Bloom cornered. That one, is it? says Chris Callinan, sure that’s only what you might call a pinprick. By God, he wasn’t far wide of the mark.

Lenehan stopped and leaned on the riverwall, panting with soft laughter.

—I’m weak, he gasped.

M’Coy’s white face smiled about it at instants and grew grave. Lenehan walked on again. He lifted his yachtingcap and scratched his hindhead rapidly. He glanced sideways in the sunlight at M’Coy.

—He’s a cultured allroundman, Bloom is, he said seriously. He’s not one of your common or garden... you know... There’s a touch of the artist about old Bloom.

*    *    *

Mr Bloom turned over idly pages of The Awful Disclosures of Maria Monk, then of Aristotle’s Masterpiece. Crooked botched print. Plates: infants cuddled in a ball in bloodred wombs like livers of slaughtered cows. Lots of them like that at this moment all over the world. All butting with their skulls to get out of it. Child born every minute somewhere. Mrs Purefoy.

He laid both books aside and glanced at the third: Tales of the Ghetto by Leopold von Sacher Masoch.

—That I had, he said, pushing it by.

The shopman let two volumes fall on the counter.

—Them are two good ones, he said.

Onions of his breath came across the counter out of his ruined mouth. He bent to make a bundle of the other books, hugged them against his unbuttoned waistcoat and bore them off behind the dingy curtain.

On O’Connell bridge many persons observed the grave deportment and gay apparel of Mr Denis J Maginni, professor of dancing &c.

Mr Bloom, alone, looked at the titles. Fair Tyrants by James Lovebirch. Know the kind that is. Had it? Yes.

He opened it. Thought so.

A woman’s voice behind the dingy curtain. Listen: the man.

No: she wouldn’t like that much. Got her it once.

He read the other title: Sweets of Sin. More in her line. Let us see.

He read where his finger opened.

—All the dollarbills her husband gave her were spent in the stores on wondrous gowns and costliest frillies. For him! For Raoul!

Yes. This. Here. Try.

—Her mouth glued on his in a luscious voluptuous kiss while his hands felt for the opulent curves inside her déshabillé.

Yes. Take this. The end.

—You are late, he spoke hoarsely, eying her with a suspicious glare.

The beautiful woman threw off her sabletrimmed wrap, displaying her queenly shoulders and heaving embonpoint. An imperceptible smile played round her perfect lips as she turned to him calmly.

Mr Bloom read again: The beautiful woman.

Warmth showered gently over him, cowing his flesh. Flesh yielded amply amid rumpled clothes: whites of eyes swooning up. His nostrils arched themselves for prey. Melting breast ointments (for him! For Raoul!). Armpits’ oniony sweat. Fishgluey slime (her heaving embonpoint!). Feel! Press! Crished! Sulphur dung of lions!

Young! Young!

An elderly female, no more young, left the building of the courts of chancery, king’s bench, exchequer and common pleas, having heard in the lord chancellor’s court the case in lunacy of Potterton, in the admiralty division the summons, exparte motion, of the owners of the Lady Cairns versus the owners of the barque Mona, in the court of appeal reservation of judgment in the case of Harvey versus the Ocean Accident and Guarantee Corporation.

Phlegmy coughs shook the air of the bookshop, bulging out the dingy curtains. The shopman’s uncombed grey head came out and his unshaven reddened face, coughing. He raked his throat rudely, puked phlegm on the floor. He put his boot on what he had spat, wiping his sole along it, and bent, showing a rawskinned crown, scantily haired.

Mr Bloom beheld it.

Mastering his troubled breath, he said:

—I’ll take this one.

The shopman lifted eyes bleared with old rheum.

—Sweets of Sin, he said, tapping on it. That’s a good one.

*    *    *

The lacquey by the door of Dillon’s auctionrooms shook his handbell twice again and viewed himself in the chalked mirror of the cabinet.

Dilly Dedalus, loitering by the curbstone, heard the beats of the bell, the cries of the auctioneer within. Four and nine. Those lovely curtains. Five shillings. Cosy curtains. Selling new at two guineas. Any advance on five shillings? Going for five shillings.

The lacquey lifted his handbell and shook it:

—Barang!

Bang of the lastlap bell spurred the halfmile wheelmen to their sprint. J. A. Jackson, W. E. Wylie, A. Munro and H. T. Gahan, their stretched necks wagging, negotiated the curve by the College library.

Mr Dedalus, tugging a long moustache, came round from Williams’s row. He halted near his daughter.

—It’s time for you, she said.

—Stand up straight for the love of the lord Jesus, Mr Dedalus said. Are you trying to imitate your uncle John, the cornetplayer, head upon shoulder? Melancholy God!

Dilly shrugged her shoulders. Mr Dedalus placed his hands on them and held them back.

—Stand up straight, girl, he said. You’ll get curvature of the spine. Do you know what you look like?

He let his head sink suddenly down and forward, hunching his shoulders and dropping his underjaw.

—Give it up, father, Dilly said. All the people are looking at you.

Mr Dedalus drew himself upright and tugged again at his moustache.

—Did you get any money? Dilly asked.

—Where would I get money? Mr Dedalus said. There is no-one in Dublin would lend me fourpence.

—You got some, Dilly said, looking in his eyes.

—How do you know that? Mr Dedalus asked, his tongue in his cheek.

Mr Kernan, pleased with the order he had booked, walked boldly along James’s street.

—I know you did, Dilly answered. Were you in the Scotch house now?

—I was not, then, Mr Dedalus said, smiling. Was it the little nuns taught you to be so saucy? Here.

He handed her a shilling.

—See if you can do anything with that, he said.

—I suppose you got five, Dilly said. Give me more than that.

—Wait awhile, Mr Dedalus said threateningly. You’re like the rest of them, are you? An insolent pack of little bitches since your poor mother died. But wait awhile. You’ll all get a short shrift and a long day from me. Low blackguardism! I’m going to get rid of you. Wouldn’t care if I was stretched out stiff. He’s dead. The man upstairs is dead.

He left her and walked on. Dilly followed quickly and pulled his coat.

—Well, what is it? he said, stopping.

The lacquey rang his bell behind their backs.

—Barang!

—Curse your bloody blatant soul, Mr Dedalus cried, turning on him.

The lacquey, aware of comment, shook the lolling clapper of his bell but feebly:

—Bang!

Mr Dedalus stared at him.

—Watch him, he said. It’s instructive. I wonder will he allow us to talk.

—You got more than that, father, Dilly said.

—I’m going to show you a little trick, Mr Dedalus said. I’ll leave you all where Jesus left the jews. Look, there’s all I have. I got two shillings from Jack Power and I spent twopence for a shave for the funeral.

He drew forth a handful of copper coins, nervously.

—Can’t you look for some money somewhere? Dilly said.

Mr Dedalus thought and nodded.

—I will, he said gravely. I looked all along the gutter in O’Connell street. I’ll try this one now.

—You’re very funny, Dilly said, grinning.

—Here, Mr Dedalus said, handing her two pennies. Get a glass of milk for yourself and a bun or a something. I’ll be home shortly.

He put the other coins in his pocket and started to walk on.

The viceregal cavalcade passed, greeted by obsequious policemen, out of Parkgate.

—I’m sure you have another shilling, Dilly said.

The lacquey banged loudly.

Mr Dedalus amid the din walked off, murmuring to himself with a pursing mincing mouth gently:

—The little nuns! Nice little things! O, sure they wouldn’t do anything! O, sure they wouldn’t really! Is it little sister Monica!

*    *    *

From the sundial towards James’s gate walked Mr Kernan, pleased with the order he had booked for Pulbrook Robertson, boldly along James’s street, past Shackleton’s offices. Got round him all right. How do you do, Mr Crimmins? First rate, sir. I was afraid you might be up in your other establishment in Pimlico. How are things going? Just keeping alive. Lovely weather we’re having. Yes, indeed. Good for the country. Those farmers are always grumbling. I’ll just take a thimbleful of your best gin, Mr Crimmins. A small gin, sir. Yes, sir. Terrible affair that General Slocum explosion. Terrible, terrible! A thousand casualties. And heartrending scenes. Men trampling down women and children. Most brutal thing. What do they say was the cause? Spontaneous combustion. Most scandalous revelation. Not a single lifeboat would float and the firehose all burst. What I can’t understand is how the inspectors ever allowed a boat like that... Now, you’re talking straight, Mr Crimmins. You know why? Palm oil. Is that a fact? Without a doubt. Well now, look at that. And America they say is the land of the free. I thought we were bad here.

I smiled at him. America, I said quietly, just like that. What is it? The sweepings of every country including our own. Isn’t that true? That’s a fact.

Graft, my dear sir. Well, of course, where there’s money going there’s always someone to pick it up.

Saw him looking at my frockcoat. Dress does it. Nothing like a dressy appearance. Bowls them over.

—Hello, Simon, Father Cowley said. How are things?

—Hello, Bob, old man, Mr Dedalus answered, stopping.

Mr Kernan halted and preened himself before the sloping mirror of Peter Kennedy, hairdresser. Stylish coat, beyond a doubt. Scott of Dawson street. Well worth the half sovereign I gave Neary for it. Never built under three guineas. Fits me down to the ground. Some Kildare street club toff had it probably. John Mulligan, the manager of the Hibernian bank, gave me a very sharp eye yesterday on Carlisle bridge as if he remembered me.

Aham! Must dress the character for those fellows. Knight of the road. Gentleman. And now, Mr Crimmins, may we have the honour of your custom again, sir. The cup that cheers but not inebriates, as the old saying has it.

North wall and sir John Rogerson’s quay, with hulls and anchorchains, sailing westward, sailed by a skiff, a crumpled throwaway, rocked on the ferrywash, Elijah is coming.

Mr Kernan glanced in farewell at his image. High colour, of course. Grizzled moustache. Returned Indian officer. Bravely he bore his stumpy body forward on spatted feet, squaring his shoulders. Is that Ned Lambert’s brother over the way, Sam? What? Yes. He’s as like it as damn it. No. The windscreen of that motorcar in the sun there. Just a flash like that. Damn like him.

Aham! Hot spirit of juniper juice warmed his vitals and his breath. Good drop of gin, that was. His frocktails winked in bright sunshine to his fat strut.

Down there Emmet was hanged, drawn and quartered. Greasy black rope. Dogs licking the blood off the street when the lord lieutenant’s wife drove by in her noddy.

Bad times those were. Well, well. Over and done with. Great topers too. Fourbottle men.

Let me see. Is he buried in saint Michan’s? Or no, there was a midnight burial in Glasnevin. Corpse brought in through a secret door in the wall. Dignam is there now. Went out in a puff. Well, well. Better turn down here. Make a detour.

Mr Kernan turned and walked down the slope of Watling street by the corner of Guinness’s visitors’ waitingroom. Outside the Dublin Distillers Company’s stores an outside car without fare or jarvey stood, the reins knotted to the wheel. Damn dangerous thing. Some Tipperary bosthoon endangering the lives of the citizens. Runaway horse.

Denis Breen with his tomes, weary of having waited an hour in John Henry Menton’s office, led his wife over O’Connell bridge, bound for the office of Messrs Collis and Ward.

Mr Kernan approached Island street.

Times of the troubles. Must ask Ned Lambert to lend me those reminiscences of sir Jonah Barrington. When you look back on it all now in a kind of retrospective arrangement. Gaming at Daly’s. No cardsharping then. One of those fellows got his hand nailed to the table by a dagger. Somewhere here lord Edward Fitzgerald escaped from major Sirr. Stables behind Moira house.

Damn good gin that was.

Fine dashing young nobleman. Good stock, of course. That ruffian, that sham squire, with his violet gloves gave him away. Course they were on the wrong side. They rose in dark and evil days. Fine poem that is: Ingram. They were gentlemen. Ben Dollard does sing that ballad touchingly. Masterly rendition.

At the siege of Ross did my father fall.

A cavalcade in easy trot along Pembroke quay passed, outriders leaping, leaping in their, in their saddles. Frockcoats. Cream sunshades.

Mr Kernan hurried forward, blowing pursily.

His Excellency! Too bad! Just missed that by a hair. Damn it! What a pity!

*    *    *

Stephen Dedalus watched through the webbed window the lapidary’s fingers prove a timedulled chain. Dust webbed the window and the showtrays. Dust darkened the toiling fingers with their vulture nails. Dust slept on dull coils of bronze and silver, lozenges of cinnabar, on rubies, leprous and winedark stones.

Born all in the dark wormy earth, cold specks of fire, evil, lights shining in the darkness. Where fallen archangels flung the stars of their brows. Muddy swinesnouts, hands, root and root, gripe and wrest them.

She dances in a foul gloom where gum bums with garlic. A sailorman, rustbearded, sips from a beaker rum and eyes her. A long and seafed silent rut. She dances, capers, wagging her sowish haunches and her hips, on her gross belly flapping a ruby egg.

Old Russell with a smeared shammy rag burnished again his gem, turned it and held it at the point of his Moses’ beard. Grandfather ape gloating on a stolen hoard.

And you who wrest old images from the burial earth? The brainsick words of sophists: Antisthenes. A lore of drugs. Orient and immortal wheat standing from everlasting to everlasting.

Two old women fresh from their whiff of the briny trudged through Irishtown along London bridge road, one with a sanded tired umbrella, one with a midwife’s bag in which eleven cockles rolled.

The whirr of flapping leathern bands and hum of dynamos from the powerhouse urged Stephen to be on. Beingless beings. Stop! Throb always without you and the throb always within. Your heart you sing of. I between them. Where? Between two roaring worlds where they swirl, I. Shatter them, one and both. But stun myself too in the blow. Shatter me you who can. Bawd and butcher were the words. I say! Not yet awhile. A look around.

Yes, quite true. Very large and wonderful and keeps famous time. You say right, sir. A Monday morning, ’twas so, indeed.

Stephen went down Bedford row, the handle of the ash clacking against his shoulderblade. In Clohissey’s window a faded 1860 print of Heenan boxing Sayers held his eye. Staring backers with square hats stood round the roped prizering. The heavyweights in tight loincloths proposed gently each to other his bulbous fists. And they are throbbing: heroes’ hearts.

He turned and halted by the slanted bookcart.

—Twopence each, the huckster said. Four for sixpence.

Tattered pages. The Irish Beekeeper. Life and Miracles of the Curé of Ars. Pocket Guide to Killarney.

I might find here one of my pawned schoolprizes. Stephano Dedalo, alumno optimo, palmam ferenti.

Father Conmee, having read his little hours, walked through the hamlet of Donnycarney, murmuring vespers.

Binding too good probably. What is this? Eighth and ninth book of Moses. Secret of all secrets. Seal of King David. Thumbed pages: read and read. Who has passed here before me? How to soften chapped hands. Recipe for white wine vinegar. How to win a woman’s love. For me this. Say the following talisman three times with hands folded:

—Se el yilo nebrakada femininum! Amor me solo! Sanktus! Amen.

Who wrote this? Charms and invocations of the most blessed abbot Peter Salanka to all true believers divulged. As good as any other abbot’s charms, as mumbling Joachim’s. Down, baldynoddle, or we’ll wool your wool.

—What are you doing here, Stephen?

Dilly’s high shoulders and shabby dress.

Shut the book quick. Don’t let see.

—What are you doing? Stephen said.

A Stuart face of nonesuch Charles, lank locks falling at its sides. It glowed as she crouched feeding the fire with broken boots. I told her of Paris. Late lieabed under a quilt of old overcoats, fingering a pinchbeck bracelet, Dan Kelly’s token. Nebrakada femininum.

—What have you there? Stephen asked.

—I bought it from the other cart for a penny, Dilly said, laughing nervously. Is it any good?

My eyes they say she has. Do others see me so? Quick, far and daring. Shadow of my mind.

He took the coverless book from her hand. Chardenal’s French primer.

—What did you buy that for? he asked. To learn French?

She nodded, reddening and closing tight her lips.

Show no surprise. Quite natural.

—Here, Stephen said. It’s all right. Mind Maggy doesn’t pawn it on you. I suppose all my books are gone.

—Some, Dilly said. We had to.

She is drowning. Agenbite. Save her. Agenbite. All against us. She will drown me with her, eyes and hair. Lank coils of seaweed hair around me, my heart, my soul. Salt green death.

We.

Agenbite of inwit. Inwit’s agenbite.

Misery! Misery!

*    *    *

—Hello, Simon, Father Cowley said. How are things?

—Hello, Bob, old man, Mr Dedalus answered, stopping.

They clasped hands loudly outside Reddy and Daughter’s. Father Cowley brushed his moustache often downward with a scooping hand.

—What’s the best news? Mr Dedalus said.

—Why then not much, Father Cowley said. I’m barricaded up, Simon, with two men prowling around the house trying to effect an entrance.

—Jolly, Mr Dedalus said. Who is it?

—O, Father Cowley said. A certain gombeen man of our acquaintance.

—With a broken back, is it? Mr Dedalus asked.

—The same, Simon, Father Cowley answered. Reuben of that ilk. I’m just waiting for Ben Dollard. He’s going to say a word to long John to get him to take those two men off. All I want is a little time.

He looked with vague hope up and down the quay, a big apple bulging in his neck.

—I know, Mr Dedalus said, nodding. Poor old bockedy Ben! He’s always doing a good turn for someone. Hold hard!

He put on his glasses and gazed towards the metal bridge an instant.

—There he is, by God, he said, arse and pockets.

Ben Dollard’s loose blue cutaway and square hat above large slops crossed the quay in full gait from the metal bridge. He came towards them at an amble, scratching actively behind his coattails.

As he came near Mr Dedalus greeted:

—Hold that fellow with the bad trousers.

—Hold him now, Ben Dollard said.

Mr Dedalus eyed with cold wandering scorn various points of Ben Dollard’s figure. Then, turning to Father Cowley with a nod, he muttered sneeringly:

—That’s a pretty garment, isn’t it, for a summer’s day?

—Why, God eternally curse your soul, Ben Dollard growled furiously, I threw out more clothes in my time than you ever saw.

He stood beside them beaming, on them first and on his roomy clothes from points of which Mr Dedalus flicked fluff, saying:

—They were made for a man in his health, Ben, anyhow.

—Bad luck to the jewman that made them, Ben Dollard said. Thanks be to God he’s not paid yet.

—And how is that basso profondo, Benjamin? Father Cowley asked.

Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell, murmuring, glassyeyed, strode past the Kildare street club.

Ben Dollard frowned and, making suddenly a chanter’s mouth, gave forth a deep note.

—Aw! he said.

—That’s the style, Mr Dedalus said, nodding to its drone.

—What about that? Ben Dollard said. Not too dusty? What?

He turned to both.

—That’ll do, Father Cowley said, nodding also.

The reverend Hugh C. Love walked from the old chapterhouse of saint Mary’s abbey past James and Charles Kennedy’s, rectifiers, attended by Geraldines tall and personable, towards the Tholsel beyond the ford of hurdles.

Ben Dollard with a heavy list towards the shopfronts led them forward, his joyful fingers in the air.

—Come along with me to the subsheriff’s office, he said. I want to show you the new beauty Rock has for a bailiff. He’s a cross between Lobengula and Lynchehaun. He’s well worth seeing, mind you. Come along. I saw John Henry Menton casually in the Bodega just now and it will cost me a fall if I don’t... Wait awhile... We’re on the right lay, Bob, believe you me.

—For a few days tell him, Father Cowley said anxiously.

Ben Dollard halted and stared, his loud orifice open, a dangling button of his coat wagging brightbacked from its thread as he wiped away the heavy shraums that clogged his eyes to hear aright.

—What few days? he boomed. Hasn’t your landlord distrained for rent?

—He has, Father Cowley said.

—Then our friend’s writ is not worth the paper it’s printed on, Ben Dollard said. The landlord has the prior claim. I gave him all the particulars. 29 Windsor avenue. Love is the name?

—That’s right, Father Cowley said. The reverend Mr Love. He’s a minister in the country somewhere. But are you sure of that?

—You can tell Barabbas from me, Ben Dollard said, that he can put that writ where Jacko put the nuts.

He led Father Cowley boldly forward, linked to his bulk.

—Filberts I believe they were, Mr Dedalus said, as he dropped his glasses on his coatfront, following them.

*    *    *

—The youngster will be all right, Martin Cunningham said, as they passed out of the Castleyard gate.

The policeman touched his forehead.

—God bless you, Martin Cunningham said, cheerily.

He signed to the waiting jarvey who chucked at the reins and set on towards Lord Edward street.

Bronze by gold, Miss Kennedy’s head by Miss Douce’s head, appeared above the crossblind of the Ormond hotel.

—Yes, Martin Cunningham said, fingering his beard. I wrote to Father Conmee and laid the whole case before him.

—You could try our friend, Mr Power suggested backward.

—Boyd? Martin Cunningham said shortly. Touch me not.

John Wyse Nolan, lagging behind, reading the list, came after them quickly down Cork hill.

On the steps of the City hall Councillor Nannetti, descending, hailed Alderman Cowley and Councillor Abraham Lyon ascending.

The castle car wheeled empty into upper Exchange street.

—Look here, Martin, John Wyse Nolan said, overtaking them at the Mail office. I see Bloom put his name down for five shillings.

—Quite right, Martin Cunningham said, taking the list. And put down the five shillings too.

—Without a second word either, Mr Power said.

—Strange but true, Martin Cunningham added.

John Wyse Nolan opened wide eyes.

—I’ll say there is much kindness in the jew, he quoted, elegantly.

They went down Parliament street.

—There’s Jimmy Henry, Mr Power said, just heading for Kavanagh’s.

—Righto, Martin Cunningham said. Here goes.

Outside la Maison Claire Blazes Boylan waylaid Jack Mooney’s brother-in-law, humpy, tight, making for the liberties.

John Wyse Nolan fell back with Mr Power, while Martin Cunningham took the elbow of a dapper little man in a shower of hail suit, who walked uncertainly, with hasty steps past Micky Anderson’s watches.

—The assistant town clerk’s corns are giving him some trouble, John Wyse Nolan told Mr Power.

They followed round the corner towards James Kavanagh’s winerooms. The empty castle car fronted them at rest in Essex gate. Martin Cunningham, speaking always, showed often the list at which Jimmy Henry did not glance.

—And long John Fanning is here too, John Wyse Nolan said, as large as life.

The tall form of long John Fanning filled the doorway where he stood.

—Good day, Mr Subsheriff, Martin Cunningham said, as all halted and greeted.

Long John Fanning made no way for them. He removed his large Henry Clay decisively and his large fierce eyes scowled intelligently over all their faces.

—Are the conscript fathers pursuing their peaceful deliberations? he said with rich acrid utterance to the assistant town clerk.

Hell open to christians they were having, Jimmy Henry said pettishly, about their damned Irish language. Where was the marshal, he wanted to know, to keep order in the council chamber. And old Barlow the macebearer laid up with asthma, no mace on the table, nothing in order, no quorum even, and Hutchinson, the lord mayor, in Llandudno and little Lorcan Sherlock doing locum tenens for him. Damned Irish language, language of our forefathers.

Long John Fanning blew a plume of smoke from his lips.

Martin Cunningham spoke by turns, twirling the peak of his beard, to the assistant town clerk and the subsheriff, while John Wyse Nolan held his peace.

—What Dignam was that? long John Fanning asked.

Jimmy Henry made a grimace and lifted his left foot.

—O, my corns! he said plaintively. Come upstairs for goodness’ sake till I sit down somewhere. Uff! Ooo! Mind!

Testily he made room for himself beside long John Fanning’s flank and passed in and up the stairs.

—Come on up, Martin Cunningham said to the subsheriff. I don’t think you knew him or perhaps you did, though.

With John Wyse Nolan Mr Power followed them in.

—Decent little soul he was, Mr Power said to the stalwart back of long John Fanning ascending towards long John Fanning in the mirror.

—Rather lowsized. Dignam of Menton’s office that was, Martin Cunningham said.

Long John Fanning could not remember him.

Clatter of horsehoofs sounded from the air.

—What’s that? Martin Cunningham said.

All turned where they stood. John Wyse Nolan came down again. From the cool shadow of the doorway he saw the horses pass Parliament street, harness and glossy pasterns in sunlight shimmering. Gaily they went past before his cool unfriendly eyes, not quickly. In saddles of the leaders, leaping leaders, rode outriders.

—What was it? Martin Cunningham asked, as they went on up the staircase.

—The lord lieutenantgeneral and general governor of Ireland, John Wyse Nolan answered from the stairfoot.

*    *    *

As they trod across the thick carpet Buck Mulligan whispered behind his Panama to Haines:

—Parnell’s brother. There in the corner.

They chose a small table near the window, opposite a longfaced man whose beard and gaze hung intently down on a chessboard.

—Is that he? Haines asked, twisting round in his seat.

—Yes, Mulligan said. That’s John Howard, his brother, our city marshal.

John Howard Parnell translated a white bishop quietly and his grey claw went up again to his forehead whereat it rested. An instant after, under its screen, his eyes looked quickly, ghostbright, at his foe and fell once more upon a working corner.

—I’ll take a mélange, Haines said to the waitress.

—Two mélanges, Buck Mulligan said. And bring us some scones and butter and some cakes as well.

When she had gone he said, laughing:

—We call it D.B.C. because they have damn bad cakes. O, but you missed Dedalus on Hamlet.

Haines opened his newbought book.

—I’m sorry, he said. Shakespeare is the happy huntingground of all minds that have lost their balance.

The onelegged sailor growled at the area of 14 Nelson street:

—England expects...

Buck Mulligan’s primrose waistcoat shook gaily to his laughter.

—You should see him, he said, when his body loses its balance. Wandering Ængus I call him.

—I am sure he has an idée fixe, Haines said, pinching his chin thoughtfully with thumb and forefinger. Now I am speculating what it would be likely to be. Such persons always have.

Buck Mulligan bent across the table gravely.

—They drove his wits astray, he said, by visions of hell. He will never capture the Attic note. The note of Swinburne, of all poets, the white death and the ruddy birth. That is his tragedy. He can never be a poet. The joy of creation...

—Eternal punishment, Haines said, nodding curtly. I see. I tackled him this morning on belief. There was something on his mind, I saw. It’s rather interesting because professor Pokorny of Vienna makes an interesting point out of that.

Buck Mulligan’s watchful eyes saw the waitress come. He helped her to unload her tray.

—He can find no trace of hell in ancient Irish myth, Haines said, amid the cheerful cups. The moral idea seems lacking, the sense of destiny, of retribution. Rather strange he should have just that fixed idea. Does he write anything for your movement?

He sank two lumps of sugar deftly longwise through the whipped cream. Buck Mulligan slit a steaming scone in two and plastered butter over its smoking pith. He bit off a soft piece hungrily.

—Ten years, he said, chewing and laughing. He is going to write something in ten years.

—Seems a long way off, Haines said, thoughtfully lifting his spoon. Still, I shouldn’t wonder if he did after all.

He tasted a spoonful from the creamy cone of his cup.

—This is real Irish cream I take it, he said with forbearance. I don’t want to be imposed on.

Elijah, skiff, light crumpled throwaway, sailed eastward by flanks of ships and trawlers, amid an archipelago of corks, beyond new Wapping street past Benson’s ferry, and by the threemasted schooner Rosevean from Bridgwater with bricks.

*    *    *

Almidano Artifoni walked past Holles street, past Sewell’s yard. Behind him Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell, with stickumbrelladustcoat dangling, shunned the lamp before Mr Law Smith’s house and, crossing, walked along Merrion square. Distantly behind him a blind stripling tapped his way by the wall of College park.

Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell walked as far as Mr Lewis Werner’s cheerful windows, then turned and strode back along Merrion square, his stickumbrelladustcoat dangling.

At the corner of Wilde’s house he halted, frowned at Elijah’s name announced on the Metropolitan hall, frowned at the distant pleasance of duke’s lawn. His eyeglass flashed frowning in the sun. With ratsteeth bared he muttered:

—Coactus volui.

He strode on for Clare street, grinding his fierce word.

As he strode past Mr Bloom’s dental windows the sway of his dustcoat brushed rudely from its angle a slender tapping cane and swept onwards, having buffeted a thewless body. The blind stripling turned his sickly face after the striding form.

—God’s curse on you, he said sourly, whoever you are! You’re blinder nor I am, you bitch’s bastard!

*    *    *

Opposite Ruggy O’Donohoe’s Master Patrick Aloysius Dignam, pawing the pound and a half of Mangan’s, late Fehrenbach’s, porksteaks he had been sent for, went along warm Wicklow street dawdling. It was too blooming dull sitting in the parlour with Mrs Stoer and Mrs Quigley and Mrs MacDowell and the blind down and they all at their sniffles and sipping sups of the superior tawny sherry uncle Barney brought from Tunney’s. And they eating crumbs of the cottage fruitcake, jawing the whole blooming time and sighing.

After Wicklow lane the window of Madame Doyle, courtdress milliner, stopped him. He stood looking in at the two puckers stripped to their pelts and putting up their props. From the sidemirrors two mourning Masters Dignam gaped silently. Myler Keogh, Dublin’s pet lamb, will meet sergeantmajor Bennett, the Portobello bruiser, for a purse of fifty sovereigns. Gob, that’d be a good pucking match to see. Myler Keogh, that’s the chap sparring out to him with the green sash. Two bar entrance, soldiers half price. I could easy do a bunk on ma. Master Dignam on his left turned as he turned. That’s me in mourning. When is it? May the twentysecond. Sure, the blooming thing is all over. He turned to the right and on his right Master Dignam turned, his cap awry, his collar sticking up. Buttoning it down, his chin lifted, he saw the image of Marie Kendall, charming soubrette, beside the two puckers. One of them mots that do be in the packets of fags Stoer smokes that his old fellow welted hell out of him for one time he found out.

Master Dignam got his collar down and dawdled on. The best pucker going for strength was Fitzsimons. One puck in the wind from that fellow would knock you into the middle of next week, man. But the best pucker for science was Jem Corbet before Fitzsimons knocked the stuffings out of him, dodging and all.

In Grafton street Master Dignam saw a red flower in a toff’s mouth and a swell pair of kicks on him and he listening to what the drunk was telling him and grinning all the time.

No Sandymount tram.

Master Dignam walked along Nassau street, shifted the porksteaks to his other hand. His collar sprang up again and he tugged it down. The blooming stud was too small for the buttonhole of the shirt, blooming end to it. He met schoolboys with satchels. I’m not going tomorrow either, stay away till Monday. He met other schoolboys. Do they notice I’m in mourning? Uncle Barney said he’d get it into the paper tonight. Then they’ll all see it in the paper and read my name printed and pa’s name.

His face got all grey instead of being red like it was and there was a fly walking over it up to his eye. The scrunch that was when they were screwing the screws into the coffin: and the bumps when they were bringing it downstairs.

Pa was inside it and ma crying in the parlour and uncle Barney telling the men how to get it round the bend. A big coffin it was, and high and heavylooking. How was that? The last night pa was boosed he was standing on the landing there bawling out for his boots to go out to Tunney’s for to boose more and he looked butty and short in his shirt. Never see him again. Death, that is. Pa is dead. My father is dead. He told me to be a good son to ma. I couldn’t hear the other things he said but I saw his tongue and his teeth trying to say it better. Poor pa. That was Mr Dignam, my father. I hope he’s in purgatory now because he went to confession to Father Conroy on Saturday night.

*    *    *

William Humble, earl of Dudley, and lady Dudley, accompanied by lieutenantcolonel Heseltine, drove out after luncheon from the viceregal lodge. In the following carriage were the honourable Mrs Paget, Miss de Courcy and the honourable Gerald Ward A. D. C. in attendance.

The cavalcade passed out by the lower gate of Phoenix park saluted by obsequious policemen and proceeded past Kingsbridge along the northern quays. The viceroy was most cordially greeted on his way through the metropolis. At Bloody bridge Mr Thomas Kernan beyond the river greeted him vainly from afar. Between Queen’s and Whitworth bridges lord Dudley’s viceregal carriages passed and were unsaluted by Mr Dudley White, B. L., M. A., who stood on Arran quay outside Mrs M. E. White’s, the pawnbroker’s, at the corner of Arran street west stroking his nose with his forefinger, undecided whether he should arrive at Phibsborough more quickly by a triple change of tram or by hailing a car or on foot through Smithfield, Constitution hill and Broadstone terminus. In the porch of Four Courts Richie Goulding with the costbag of Goulding, Collis and Ward saw him with surprise. Past Richmond bridge at the doorstep of the office of Reuben J Dodd, solicitor, agent for the Patriotic Insurance Company, an elderly female about to enter changed her plan and retracing her steps by King’s windows smiled credulously on the representative of His Majesty. From its sluice in Wood quay wall under Tom Devan’s office Poddle river hung out in fealty a tongue of liquid sewage. Above the crossblind of the Ormond hotel, gold by bronze, Miss Kennedy’s head by Miss Douce’s head watched and admired. On Ormond quay Mr Simon Dedalus, steering his way from the greenhouse for the subsheriff’s office, stood still in midstreet and brought his hat low. His Excellency graciously returned Mr Dedalus’ greeting. From Cahill’s corner the reverend Hugh C. Love, M. A., made obeisance unperceived, mindful of lords deputies whose hands benignant had held of yore rich advowsons. On Grattan bridge Lenehan and M’Coy, taking leave of each other, watched the carriages go by. Passing by Roger Greene’s office and Dollard’s big red printinghouse Gerty MacDowell, carrying the Catesby’s cork lino letters for her father who was laid up, knew by the style it was the lord and lady lieutenant but she couldn’t see what Her Excellency had on because the tram and Spring’s big yellow furniture van had to stop in front of her on account of its being the lord lieutenant. Beyond Lundy Foot’s from the shaded door of Kavanagh’s winerooms John Wyse Nolan smiled with unseen coldness towards the lord lieutenantgeneral and general governor of Ireland. The Right Honourable William Humble, earl of Dudley, G. C. V. O., passed Micky Anderson’s all times ticking watches and Henry and James’s wax smartsuited freshcheeked models, the gentleman Henry, dernier cri James. Over against Dame gate Tom Rochford and Nosey Flynn watched the approach of the cavalcade. Tom Rochford, seeing the eyes of lady Dudley fixed on him, took his thumbs quickly out of the pockets of his claret waistcoat and doffed his cap to her. A charming soubrette, great Marie Kendall, with dauby cheeks and lifted skirt smiled daubily from her poster upon William Humble, earl of Dudley, and upon lieutenantcolonel H. G. Heseltine, and also upon the honourable Gerald Ward A. D. C. From the window of the D. B. C. Buck Mulligan gaily, and Haines gravely, gazed down on the viceregal equipage over the shoulders of eager guests, whose mass of forms darkened the chessboard whereon John Howard Parnell looked intently. In Fownes’s street Dilly Dedalus, straining her sight upward from Chardenal’s first French primer, saw sunshades spanned and wheelspokes spinning in the glare. John Henry Menton, filling the doorway of Commercial Buildings, stared from winebig oyster eyes, holding a fat gold hunter watch not looked at in his fat left hand not feeling it. Where the foreleg of King Billy’s horse pawed the air Mrs Breen plucked her hastening husband back from under the hoofs of the outriders. She shouted in his ear the tidings. Understanding, he shifted his tomes to his left breast and saluted the second carriage. The honourable Gerald Ward A. D. C., agreeably surprised, made haste to reply. At Ponsonby’s corner a jaded white flagon H. halted and four tallhatted white flagons halted behind him, E.L.Y.’S, while outriders pranced past and carriages. Opposite Pigott’s music warerooms Mr Denis J Maginni, professor of dancing &c, gaily apparelled, gravely walked, outpassed by a viceroy and unobserved. By the provost’s wall came jauntily Blazes Boylan, stepping in tan shoes and socks with skyblue clocks to the refrain of My girl’s a Yorkshire girl.

Blazes Boylan presented to the leaders’ skyblue frontlets and high action a skyblue tie, a widebrimmed straw hat at a rakish angle and a suit of indigo serge. His hands in his jacket pockets forgot to salute but he offered to the three ladies the bold admiration of his eyes and the red flower between his lips. As they drove along Nassau street His Excellency drew the attention of his bowing consort to the programme of music which was being discoursed in College park. Unseen brazen highland laddies blared and drumthumped after the cortège:

But though she’s a factory lass
And wears no fancy clothes.
Baraabum.
Yet I’ve a sort of a
Yorkshire relish for
My little Yorkshire rose.
Baraabum.

Thither of the wall the quartermile flat handicappers, M. C. Green, H. Shrift, T. M. Patey, C. Scaife, J. B. Jeffs, G. N. Morphy, F. Stevenson, C. Adderly and W. C. Huggard, started in pursuit. Striding past Finn’s hotel Cashel Boyle O’Connor Fitzmaurice Tisdall Farrell stared through a fierce eyeglass across the carriages at the head of Mr M. E. Solomons in the window of the Austro-Hungarian viceconsulate. Deep in Leinster street by Trinity’s postern a loyal king’s man, Hornblower, touched his tallyho cap. As the glossy horses pranced by Merrion square Master Patrick Aloysius Dignam, waiting, saw salutes being given to the gent with the topper and raised also his new black cap with fingers greased by porksteak paper. His collar too sprang up. The viceroy, on his way to inaugurate the Mirus bazaar in aid of funds for Mercer’s hospital, drove with his following towards Lower Mount street. He passed a blind stripling opposite Broadbent’s. In Lower Mount street a pedestrian in a brown macintosh, eating dry bread, passed swiftly and unscathed across the viceroy’s path. At the Royal Canal bridge, from his hoarding, Mr Eugene Stratton, his blub lips agrin, bade all comers welcome to Pembroke township. At Haddington road corner two sanded women halted themselves, an umbrella and a bag in which eleven cockles rolled to view with wonder the lord mayor and lady mayoress without his golden chain. On Northumberland and Lansdowne roads His Excellency acknowledged punctually salutes from rare male walkers, the salute of two small schoolboys at the garden gate of the house said to have been admired by the late queen when visiting the Irish capital with her husband, the prince consort, in 1849 and the salute of Almidano Artifoni’s sturdy trousers swallowed by a closing door.

### [ 11 ]
Bronze by gold heard the hoofirons, steelyringing.

Imperthnthn thnthnthn.

Chips, picking chips off rocky thumbnail, chips.

Horrid! And gold flushed more.

A husky fifenote blew.

Blew. Blue bloom is on the.

Goldpinnacled hair.

A jumping rose on satiny breast of satin, rose of Castile.

Trilling, trilling: Idolores.

Peep! Who’s in the... peepofgold?

Tink cried to bronze in pity.

And a call, pure, long and throbbing. Longindying call.

Decoy. Soft word. But look: the bright stars fade. Notes chirruping answer.

O rose! Castile. The morn is breaking.

Jingle jingle jaunted jingling.

Coin rang. Clock clacked.

Avowal. Sonnez. I could. Rebound of garter. Not leave thee. Smack. La cloche! Thigh smack. Avowal. Warm. Sweetheart, goodbye!

Jingle. Bloo.

Boomed crashing chords. When love absorbs. War! War! The tympanum.

A sail! A veil awave upon the waves.

Lost. Throstle fluted. All is lost now.

Horn. Hawhorn.

When first he saw. Alas!

Full tup. Full throb.

Warbling. Ah, lure! Alluring.

Martha! Come!

Clapclap. Clipclap. Clappyclap.

Goodgod henev erheard inall.

Deaf bald Pat brought pad knife took up.

A moonlit nightcall: far, far.

I feel so sad. P. S. So lonely blooming.

Listen!

The spiked and winding cold seahorn. Have you the? Each, and for other, plash and silent roar.

Pearls: when she. Liszt’s rhapsodies. Hissss.

You don’t?

Did not: no, no: believe: Lidlyd. With a cock with a carra.

Black. Deepsounding. Do, Ben, do.

Wait while you wait. Hee hee. Wait while you hee.

But wait!

Low in dark middle earth. Embedded ore.

Naminedamine. Preacher is he:

All gone. All fallen.

Tiny, her tremulous fernfoils of maidenhair.

Amen! He gnashed in fury.

Fro. To, fro. A baton cool protruding.

Bronzelydia by Minagold.

By bronze, by gold, in oceangreen of shadow. Bloom. Old Bloom.

One rapped, one tapped, with a carra, with a cock.

Pray for him! Pray, good people!

His gouty fingers nakkering.

Big Benaben. Big Benben.

Last rose Castile of summer left bloom I feel so sad alone.

Pwee! Little wind piped wee.

True men. Lid Ker Cow De and Doll. Ay, ay. Like you men. Will lift your tschink with tschunk.

Fff! Oo!

Where bronze from anear? Where gold from afar? Where hoofs?

Rrrpr. Kraa. Kraandl.

Then not till then. My eppripfftaph. Be pfrwritt.

Done.

Begin!

Bronze by gold, miss Douce’s head by miss Kennedy’s head, over the crossblind of the Ormond bar heard the viceregal hoofs go by, ringing steel.

—Is that her? asked miss Kennedy.

Miss Douce said yes, sitting with his ex, pearl grey and eau de Nil.

—Exquisite contrast, miss Kennedy said.

When all agog miss Douce said eagerly:

—Look at the fellow in the tall silk.

—Who? Where? gold asked more eagerly.

—In the second carriage, miss Douce’s wet lips said, laughing in the sun.

He’s looking. Mind till I see.

She darted, bronze, to the backmost corner, flattening her face against the pane in a halo of hurried breath.

Her wet lips tittered:

—He’s killed looking back.

She laughed:

—O wept! Aren’t men frightful idiots?

With sadness.

Miss Kennedy sauntered sadly from bright light, twining a loose hair behind an ear. Sauntering sadly, gold no more, she twisted twined a hair. Sadly she twined in sauntering gold hair behind a curving ear.

—It’s them has the fine times, sadly then she said.

A man.

Bloowho went by by Moulang’s pipes bearing in his breast the sweets of sin, by Wine’s antiques, in memory bearing sweet sinful words, by Carroll’s dusky battered plate, for Raoul.

The boots to them, them in the bar, them barmaids came. For them unheeding him he banged on the counter his tray of chattering china. And

—There’s your teas, he said.

Miss Kennedy with manners transposed the teatray down to an upturned lithia crate, safe from eyes, low.

—What is it? loud boots unmannerly asked.

—Find out, miss Douce retorted, leaving her spyingpoint.

—Your beau, is it?

A haughty bronze replied:

—I’ll complain to Mrs de Massey on you if I hear any more of your impertinent insolence.

—Imperthnthn thnthnthn, bootssnout sniffed rudely, as he retreated as she threatened as he had come.

Bloom.

On her flower frowning miss Douce said:

—Most aggravating that young brat is. If he doesn’t conduct himself I’ll wring his ear for him a yard long.

Ladylike in exquisite contrast.

—Take no notice, miss Kennedy rejoined.

She poured in a teacup tea, then back in the teapot tea. They cowered under their reef of counter, waiting on footstools, crates upturned, waiting for their teas to draw. They pawed their blouses, both of black satin, two and nine a yard, waiting for their teas to draw, and two and seven.

Yes, bronze from anear, by gold from afar, heard steel from anear, hoofs ring from afar, and heard steelhoofs ringhoof ringsteel.

—Am I awfully sunburnt?

Miss bronze unbloused her neck.

—No, said miss Kennedy. It gets brown after. Did you try the borax with the cherry laurel water?

Miss Douce halfstood to see her skin askance in the barmirror gildedlettered where hock and claret glasses shimmered and in their midst a shell.

—And leave it to my hands, she said.

—Try it with the glycerine, miss Kennedy advised.

Bidding her neck and hands adieu miss Douce

—Those things only bring out a rash, replied, reseated. I asked that old fogey in Boyd’s for something for my skin.

Miss Kennedy, pouring now a fulldrawn tea, grimaced and prayed:

—O, don’t remind me of him for mercy’ sake!

—But wait till I tell you, miss Douce entreated.

Sweet tea miss Kennedy having poured with milk plugged both two ears with little fingers.

—No, don’t, she cried.

—I won’t listen, she cried.

But Bloom?

Miss Douce grunted in snuffy fogey’s tone:

—For your what? says he.

Miss Kennedy unplugged her ears to hear, to speak: but said, but prayed again:

—Don’t let me think of him or I’ll expire. The hideous old wretch! That night in the Antient Concert Rooms.

She sipped distastefully her brew, hot tea, a sip, sipped, sweet tea.

—Here he was, miss Douce said, cocking her bronze head three quarters, ruffling her nosewings. Hufa! Hufa!

Shrill shriek of laughter sprang from miss Kennedy’s throat. Miss Douce huffed and snorted down her nostrils that quivered imperthnthn like a snout in quest.

—O! shrieking, miss Kennedy cried. Will you ever forget his goggle eye?

Miss Douce chimed in in deep bronze laughter, shouting:

—And your other eye!

Bloowhose dark eye read Aaron Figatner’s name. Why do I always think Figather? Gathering figs, I think. And Prosper Loré’s huguenot name. By Bassi’s blessed virgins Bloom’s dark eyes went by. Bluerobed, white under, come to me. God they believe she is: or goddess. Those today. I could not see. That fellow spoke. A student. After with Dedalus’ son. He might be Mulligan. All comely virgins. That brings those rakes of fellows in: her white.

By went his eyes. The sweets of sin. Sweet are the sweets.

Of sin.

In a giggling peal young goldbronze voices blended, Douce with Kennedy your other eye. They threw young heads back, bronze gigglegold, to let freefly their laughter, screaming, your other, signals to each other, high piercing notes.

Ah, panting, sighing, sighing, ah, fordone, their mirth died down.

Miss Kennedy lipped her cup again, raised, drank a sip and gigglegiggled. Miss Douce, bending over the teatray, ruffled again her nose and rolled droll fattened eyes. Again Kennygiggles, stooping, her fair pinnacles of hair, stooping, her tortoise napecomb showed, spluttered out of her mouth her tea, choking in tea and laughter, coughing with choking, crying:

—O greasy eyes! Imagine being married to a man like that! she cried. With his bit of beard!

Douce gave full vent to a splendid yell, a full yell of full woman, delight, joy, indignation.

—Married to the greasy nose! she yelled.

Shrill, with deep laughter, after, gold after bronze, they urged each each to peal after peal, ringing in changes, bronzegold, goldbronze, shrilldeep, to laughter after laughter. And then laughed more. Greasy I knows. Exhausted, breathless, their shaken heads they laid, braided and pinnacled by glossycombed, against the counterledge. All flushed (O!), panting, sweating (O!), all breathless.

Married to Bloom, to greaseabloom.

—O saints above! miss Douce said, sighed above her jumping rose. I wished I hadn’t laughed so much. I feel all wet.

—O, miss Douce! miss Kennedy protested. You horrid thing!

And flushed yet more (you horrid!), more goldenly.

By Cantwell’s offices roved Greaseabloom, by Ceppi’s virgins, bright of their oils. Nannetti’s father hawked those things about, wheedling at doors as I. Religion pays. Must see him for that par. Eat first. I want. Not yet. At four, she said. Time ever passing. Clockhands turning. On. Where eat? The Clarence, Dolphin. On. For Raoul. Eat. If I net five guineas with those ads. The violet silk petticoats. Not yet. The sweets of sin.

Flushed less, still less, goldenly paled.

Into their bar strolled Mr Dedalus. Chips, picking chips off one of his rocky thumbnails. Chips. He strolled.

—O, welcome back, miss Douce.

He held her hand. Enjoyed her holidays?

—Tiptop.

He hoped she had nice weather in Rostrevor.

—Gorgeous, she said. Look at the holy show I am. Lying out on the strand all day.

Bronze whiteness.

—That was exceedingly naughty of you, Mr Dedalus told her and pressed her hand indulgently. Tempting poor simple males.

Miss Douce of satin douced her arm away.

—O go away! she said. You’re very simple, I don’t think.

He was.

—Well now I am, he mused. I looked so simple in the cradle they christened me simple Simon.

—You must have been a doaty, miss Douce made answer. And what did the doctor order today?

—Well now, he mused, whatever you say yourself. I think I’ll trouble you for some fresh water and a half glass of whisky.

Jingle.

—With the greatest alacrity, miss Douce agreed.

With grace of alacrity towards the mirror gilt Cantrell and Cochrane’s she turned herself. With grace she tapped a measure of gold whisky from her crystal keg. Forth from the skirt of his coat Mr Dedalus brought pouch and pipe. Alacrity she served. He blew through the flue two husky fifenotes.

—By Jove, he mused, I often wanted to see the Mourne mountains. Must be a great tonic in the air down there. But a long threatening comes at last, they say. Yes. Yes.

Yes. He fingered shreds of hair, her maidenhair, her mermaid’s, into the bowl. Chips. Shreds. Musing. Mute.

None nought said nothing. Yes.

Gaily miss Douce polished a tumbler, trilling:

—O, Idolores, queen of the eastern seas!

—Was Mr Lidwell in today?

In came Lenehan. Round him peered Lenehan. Mr Bloom reached Essex bridge. Yes, Mr Bloom crossed bridge of Yessex. To Martha I must write. Buy paper. Daly’s. Girl there civil. Bloom. Old Bloom. Blue bloom is on the rye.

—He was in at lunchtime, miss Douce said.

Lenehan came forward.

—Was Mr Boylan looking for me?

He asked. She answered:

—Miss Kennedy, was Mr Boylan in while I was upstairs?

She asked. Miss voice of Kennedy answered, a second teacup poised, her gaze upon a page:

—No. He was not.

Miss gaze of Kennedy, heard, not seen, read on. Lenehan round the sandwichbell wound his round body round.

—Peep! Who’s in the corner?

No glance of Kennedy rewarding him he yet made overtures. To mind her stops. To read only the black ones: round o and crooked ess.

Jingle jaunty jingle.

Girlgold she read and did not glance. Take no notice. She took no notice while he read by rote a solfa fable for her, plappering flatly:

—Ah fox met ah stork. Said thee fox too thee stork: Will you put your bill down inn my troath and pull upp ah bone?

He droned in vain. Miss Douce turned to her tea aside.

He sighed aside:

—Ah me! O my!

He greeted Mr Dedalus and got a nod.

—Greetings from the famous son of a famous father.

—Who may he be? Mr Dedalus asked.

Lenehan opened most genial arms. Who?

—Who may he be? he asked. Can you ask? Stephen, the youthful bard.

Dry.

Mr Dedalus, famous father, laid by his dry filled pipe.

—I see, he said. I didn’t recognise him for the moment. I hear he is keeping very select company. Have you seen him lately?

He had.

—I quaffed the nectarbowl with him this very day, said Lenehan. In Mooney’s en ville and in Mooney’s sur mer. He had received the rhino for the labour of his muse.

He smiled at bronze’s teabathed lips, at listening lips and eyes:

—The élite of Erin hung upon his lips. The ponderous pundit, Hugh MacHugh, Dublin’s most brilliant scribe and editor and that minstrel boy of the wild wet west who is known by the euphonious appellation of the O’Madden Burke.

After an interval Mr Dedalus raised his grog and

—That must have been highly diverting, said he. I see.

He see. He drank. With faraway mourning mountain eye. Set down his glass.

He looked towards the saloon door.

—I see you have moved the piano.

—The tuner was in today, miss Douce replied, tuning it for the smoking concert and I never heard such an exquisite player.

—Is that a fact?

—Didn’t he, miss Kennedy? The real classical, you know. And blind too, poor fellow. Not twenty I’m sure he was.

—Is that a fact? Mr Dedalus said.

He drank and strayed away.

—So sad to look at his face, miss Douce condoled.

God’s curse on bitch’s bastard.

Tink to her pity cried a diner’s bell. To the door of the bar and diningroom came bald Pat, came bothered Pat, came Pat, waiter of Ormond. Lager for diner. Lager without alacrity she served.

With patience Lenehan waited for Boylan with impatience, for jinglejaunty blazes boy.

Upholding the lid he (who?) gazed in the coffin (coffin?) at the oblique triple (piano!) wires. He pressed (the same who pressed indulgently her hand), soft pedalling, a triple of keys to see the thicknesses of felt advancing, to hear the muffled hammerfall in action.

Two sheets cream vellum paper one reserve two envelopes when I was in Wisdom Hely’s wise Bloom in Daly’s Henry Flower bought. Are you not happy in your home? Flower to console me and a pin cuts lo. Means something, language of flow. Was it a daisy? Innocence that is. Respectable girl meet after mass. Thanks awfully muchly. Wise Bloom eyed on the door a poster, a swaying mermaid smoking mid nice waves. Smoke mermaids, coolest whiff of all. Hair streaming: lovelorn. For some man. For Raoul. He eyed and saw afar on Essex bridge a gay hat riding on a jaunting car. It is. Again. Third time. Coincidence.

Jingling on supple rubbers it jaunted from the bridge to Ormond quay. Follow. Risk it. Go quick. At four. Near now. Out.

—Twopence, sir, the shopgirl dared to say.

—Aha... I was forgetting... Excuse...

—And four.

At four she. Winsomely she on Bloohimwhom smiled. Bloo smi qui go. Ternoon. Think you’re the only pebble on the beach? Does that to all.

For men.

In drowsy silence gold bent on her page.

From the saloon a call came, long in dying. That was a tuningfork the tuner had that he forgot that he now struck. A call again. That he now poised that it now throbbed. You hear? It throbbed, pure, purer, softly and softlier, its buzzing prongs. Longer in dying call.

Pat paid for diner’s popcorked bottle: and over tumbler, tray and popcorked bottle ere he went he whispered, bald and bothered, with miss Douce.

—The bright stars fade...

A voiceless song sang from within, singing:

—... the morn is breaking.

A duodene of birdnotes chirruped bright treble answer under sensitive hands. Brightly the keys, all twinkling, linked, all harpsichording, called to a voice to sing the strain of dewy morn, of youth, of love’s leavetaking, life’s, love’s morn.

—The dewdrops pearl...

Lenehan’s lips over the counter lisped a low whistle of decoy.

—But look this way, he said, rose of Castile.

Jingle jaunted by the curb and stopped.

She rose and closed her reading, rose of Castile: fretted, forlorn, dreamily rose.

—Did she fall or was she pushed? he asked her.

She answered, slighting:

—Ask no questions and you’ll hear no lies.

Like lady, ladylike.

Blazes Boylan’s smart tan shoes creaked on the barfloor where he strode. Yes, gold from anear by bronze from afar. Lenehan heard and knew and hailed him:

—See the conquering hero comes.

Between the car and window, warily walking, went Bloom, unconquered hero. See me he might. The seat he sat on: warm. Black wary hecat walked towards Richie Goulding’s legal bag, lifted aloft, saluting.

—And I from thee...

—I heard you were round, said Blazes Boylan.

He touched to fair miss Kennedy a rim of his slanted straw. She smiled on him. But sister bronze outsmiled her, preening for him her richer hair, a bosom and a rose.

Smart Boylan bespoke potions.

—What’s your cry? Glass of bitter? Glass of bitter, please, and a sloegin for me. Wire in yet?

Not yet. At four she. Who said four?

Cowley’s red lugs and bulging apple in the door of the sheriff’s office.

Avoid. Goulding a chance. What is he doing in the Ormond? Car waiting. Wait.

Hello. Where off to? Something to eat? I too was just. In here. What, Ormond? Best value in Dublin. Is that so? Diningroom. Sit tight there. See, not be seen. I think I’ll join you. Come on. Richie led on. Bloom followed bag. Dinner fit for a prince.

Miss Douce reached high to take a flagon, stretching her satin arm, her bust, that all but burst, so high.

—O! O! jerked Lenehan, gasping at each stretch. O!

But easily she seized her prey and led it low in triumph.

—Why don’t you grow? asked Blazes Boylan.

Shebronze, dealing from her oblique jar thick syrupy liquor for his lips, looked as it flowed (flower in his coat: who gave him?), and syrupped with her voice:

—Fine goods in small parcels.

That is to say she. Neatly she poured slowsyrupy sloe.

—Here’s fortune, Blazes said.

He pitched a broad coin down. Coin rang.

—Hold on, said Lenehan, till I...

—Fortune, he wished, lifting his bubbled ale.

—Sceptre will win in a canter, he said.

—I plunged a bit, said Boylan winking and drinking. Not on my own, you know. Fancy of a friend of mine.

Lenehan still drank and grinned at his tilted ale and at miss Douce’s lips that all but hummed, not shut, the oceansong her lips had trilled. Idolores. The eastern seas.

Clock whirred. Miss Kennedy passed their way (flower, wonder who gave), bearing away teatray. Clock clacked.

Miss Douce took Boylan’s coin, struck boldly the cashregister. It clanged. Clock clacked. Fair one of Egypt teased and sorted in the till and hummed and handed coins in change. Look to the west. A clack. For me.

—What time is that? asked Blazes Boylan. Four?

O’clock.

Lenehan, small eyes ahunger on her humming, bust ahumming, tugged Blazes Boylan’s elbowsleeve.

—Let’s hear the time, he said.

The bag of Goulding, Collis, Ward led Bloom by ryebloom flowered tables. Aimless he chose with agitated aim, bald Pat attending, a table near the door. Be near. At four. Has he forgotten? Perhaps a trick. Not come: whet appetite. I couldn’t do. Wait, wait. Pat, waiter, waited.

Sparkling bronze azure eyed Blazure’s skyblue bow and eyes.

—Go on, pressed Lenehan. There’s no-one. He never heard.

—... to Flora’s lips did hie.

High, a high note pealed in the treble clear.

Bronzedouce communing with her rose that sank and rose sought Blazes Boylan’s flower and eyes.

—Please, please.

He pleaded over returning phrases of avowal.

—I could not leave thee...

—Afterwits, miss Douce promised coyly.

—No, now, urged Lenehan. Sonnez la cloche! O do! There’s no-one.

She looked. Quick. Miss Kenn out of earshot. Sudden bent. Two kindling faces watched her bend.

Quavering the chords strayed from the air, found it again, lost chord, and lost and found it, faltering.

—Go on! Do! Sonnez!

Bending, she nipped a peak of skirt above her knee. Delayed. Taunted them still, bending, suspending, with wilful eyes.

—Sonnez!

Smack. She set free sudden in rebound her nipped elastic garter smackwarm against her smackable a woman’s warmhosed thigh.

—La cloche! cried gleeful Lenehan. Trained by owner. No sawdust there.

She smilesmirked supercilious (wept! aren’t men?), but, lightward gliding, mild she smiled on Boylan.

—You’re the essence of vulgarity, she in gliding said.

Boylan, eyed, eyed. Tossed to fat lips his chalice, drank off his chalice tiny, sucking the last fat violet syrupy drops. His spellbound eyes went after, after her gliding head as it went down the bar by mirrors, gilded arch for ginger ale, hock and claret glasses shimmering, a spiky shell, where it concerted, mirrored, bronze with sunnier bronze.

Yes, bronze from anearby.

—... Sweetheart, goodbye!

—I’m off, said Boylan with impatience.

He slid his chalice brisk away, grasped his change.

—Wait a shake, begged Lenehan, drinking quickly. I wanted to tell you. Tom Rochford...

—Come on to blazes, said Blazes Boylan, going.

Lenehan gulped to go.

—Got the horn or what? he said. Wait. I’m coming.

He followed the hasty creaking shoes but stood by nimbly by the threshold, saluting forms, a bulky with a slender.

—How do you do, Mr Dollard?

—Eh? How do? How do? Ben Dollard’s vague bass answered, turning an instant from Father Cowley’s woe. He won’t give you any trouble, Bob. Alf Bergan will speak to the long fellow. We’ll put a barleystraw in that Judas Iscariot’s ear this time.

Sighing Mr Dedalus came through the saloon, a finger soothing an eyelid.

—Hoho, we will, Ben Dollard yodled jollily. Come on, Simon. Give us a ditty. We heard the piano.

Bald Pat, bothered waiter, waited for drink orders. Power for Richie. And Bloom? Let me see. Not make him walk twice. His corns. Four now. How warm this black is. Course nerves a bit. Refracts (is it?) heat. Let me see. Cider. Yes, bottle of cider.

—What’s that? Mr Dedalus said. I was only vamping, man.

—Come on, come on, Ben Dollard called. Begone dull care. Come, Bob.

He ambled Dollard, bulky slops, before them (hold that fellow with the: hold him now) into the saloon. He plumped him Dollard on the stool. His gouty paws plumped chords. Plumped, stopped abrupt.

Bald Pat in the doorway met tealess gold returning. Bothered, he wanted Power and cider. Bronze by the window, watched, bronze from afar.

Jingle a tinkle jaunted.

Bloom heard a jing, a little sound. He’s off. Light sob of breath Bloom sighed on the silent bluehued flowers. Jingling. He’s gone. Jingle. Hear.

—Love and War, Ben, Mr Dedalus said. God be with old times.

Miss Douce’s brave eyes, unregarded, turned from the crossblind, smitten by sunlight. Gone. Pensive (who knows?), smitten (the smiting light), she lowered the dropblind with a sliding cord. She drew down pensive (why did he go so quick when I?) about her bronze, over the bar where bald stood by sister gold, inexquisite contrast, contrast inexquisite nonexquisite, slow cool dim seagreen sliding depth of shadow, eau de Nil.

—Poor old Goodwin was the pianist that night, Father Cowley reminded them. There was a slight difference of opinion between himself and the Collard grand.

There was.

—A symposium all his own, Mr Dedalus said. The devil wouldn’t stop him. He was a crotchety old fellow in the primary stage of drink.

—God, do you remember? Ben bulky Dollard said, turning from the punished keyboard. And by Japers I had no wedding garment.

They laughed all three. He had no wed. All trio laughed. No wedding garment.

—Our friend Bloom turned in handy that night, Mr Dedalus said. Where’s my pipe, by the way?

He wandered back to the bar to the lost chord pipe. Bald Pat carried two diners’ drinks, Richie and Poldy. And Father Cowley laughed again.

—I saved the situation, Ben, I think.

—You did, averred Ben Dollard. I remember those tight trousers too. That was a brilliant idea, Bob.

Father Cowley blushed to his brilliant purply lobes. He saved the situa. Tight trou. Brilliant ide.

—I knew he was on the rocks, he said. The wife was playing the piano in the coffee palace on Saturdays for a very trifling consideration and who was it gave me the wheeze she was doing the other business? Do you remember? We had to search all Holles street to find them till the chap in Keogh’s gave us the number. Remember?

Ben remembered, his broad visage wondering.

—By God, she had some luxurious operacloaks and things there.

Mr Dedalus wandered back, pipe in hand.

—Merrion square style. Balldresses, by God, and court dresses. He wouldn’t take any money either. What? Any God’s quantity of cocked hats and boleros and trunkhose. What?

—Ay, ay, Mr Dedalus nodded. Mrs Marion Bloom has left off clothes of all descriptions.

Jingle jaunted down the quays. Blazes sprawled on bounding tyres.

Liver and bacon. Steak and kidney pie. Right, sir. Right, Pat.

Mrs Marion. Met him pike hoses. Smell of burn. Of Paul de Kock. Nice name he.

—What’s this her name was? A buxom lassy. Marion...

—Tweedy.

—Yes. Is she alive?

—And kicking.

—She was a daughter of...

—Daughter of the regiment.

—Yes, begad. I remember the old drummajor.

Mr Dedalus struck, whizzed, lit, puffed savoury puff after

—Irish? I don’t know, faith. Is she, Simon?

Puff after stiff, a puff, strong, savoury, crackling.

—Buccinator muscle is... What?... Bit rusty... O, she is... My Irish Molly, O.

He puffed a pungent plumy blast.

—From the rock of Gibraltar... all the way.

They pined in depth of ocean shadow, gold by the beerpull, bronze by maraschino, thoughtful all two. Mina Kennedy, 4 Lismore terrace, Drumcondra with Idolores, a queen, Dolores, silent.

Pat served, uncovered dishes. Leopold cut liverslices. As said before he ate with relish the inner organs, nutty gizzards, fried cods’ roes while Richie Goulding, Collis, Ward ate steak and kidney, steak then kidney, bite by bite of pie he ate Bloom ate they ate.

Bloom with Goulding, married in silence, ate. Dinners fit for princes.

By Bachelor’s walk jogjaunty jingled Blazes Boylan, bachelor, in sun in heat, mare’s glossy rump atrot, with flick of whip, on bounding tyres: sprawled, warmseated, Boylan impatience, ardentbold. Horn. Have you the? Horn. Have you the? Haw haw horn.

Over their voices Dollard bassooned attack, booming over bombarding chords:

—When love absorbs my ardent soul...

Roll of Bensoulbenjamin rolled to the quivery loveshivery roofpanes.

—War! War! cried Father Cowley. You’re the warrior.

—So I am, Ben Warrior laughed. I was thinking of your landlord. Love or money.

He stopped. He wagged huge beard, huge face over his blunder huge.

—Sure, you’d burst the tympanum of her ear, man, Mr Dedalus said through smoke aroma, with an organ like yours.

In bearded abundant laughter Dollard shook upon the keyboard. He would.

—Not to mention another membrane, Father Cowley added. Half time, Ben. Amoroso ma non troppo. Let me there.

Miss Kennedy served two gentlemen with tankards of cool stout. She passed a remark. It was indeed, first gentleman said, beautiful weather. They drank cool stout. Did she know where the lord lieutenant was going? And heard steelhoofs ringhoof ring. No, she couldn’t say. But it would be in the paper. O, she need not trouble. No trouble. She waved about her outspread Independent, searching, the lord lieutenant, her pinnacles of hair slowmoving, lord lieuten. Too much trouble, first gentleman said. O, not in the least. Way he looked that. Lord lieutenant. Gold by bronze heard iron steel.

—............ my ardent soul
I care not foror the morrow.

In liver gravy Bloom mashed mashed potatoes. Love and War someone is. Ben Dollard’s famous. Night he ran round to us to borrow a dress suit for that concert. Trousers tight as a drum on him. Musical porkers. Molly did laugh when he went out. Threw herself back across the bed, screaming, kicking. With all his belongings on show. O saints above, I’m drenched! O, the women in the front row! O, I never laughed so many! Well, of course that’s what gives him the base barreltone. For instance eunuchs. Wonder who’s playing. Nice touch. Must be Cowley. Musical. Knows whatever note you play. Bad breath he has, poor chap. Stopped.

Miss Douce, engaging, Lydia Douce, bowed to suave solicitor, George Lidwell, gentleman, entering. Good afternoon. She gave her moist (a lady’s) hand to his firm clasp. Afternoon. Yes, she was back. To the old dingdong again.

—Your friends are inside, Mr Lidwell.

George Lidwell, suave, solicited, held a lydiahand.

Bloom ate liv as said before. Clean here at least. That chap in the Burton, gummy with gristle. No-one here: Goulding and I. Clean tables, flowers, mitres of napkins. Pat to and fro. Bald Pat. Nothing to do. Best value in Dub.

Piano again. Cowley it is. Way he sits in to it, like one together, mutual understanding. Tiresome shapers scraping fiddles, eye on the bowend, sawing the cello, remind you of toothache. Her high long snore. Night we were in the box. Trombone under blowing like a grampus, between the acts, other brass chap unscrewing, emptying spittle. Conductor’s legs too, bagstrousers, jiggedy jiggedy. Do right to hide them.

Jiggedy jingle jaunty jaunty.

Only the harp. Lovely. Gold glowering light. Girl touched it. Poop of a lovely. Gravy’s rather good fit for a. Golden ship. Erin. The harp that once or twice. Cool hands. Ben Howth, the rhododendrons. We are their harps. I. He. Old. Young.

—Ah, I couldn’t, man, Mr Dedalus said, shy, listless.

Strongly.

—Go on, blast you! Ben Dollard growled. Get it out in bits.

—M’appari, Simon, Father Cowley said.

Down stage he strode some paces, grave, tall in affliction, his long arms outheld. Hoarsely the apple of his throat hoarsed softly. Softly he sang to a dusty seascape there: A Last Farewell. A headland, a ship, a sail upon the billows. Farewell. A lovely girl, her veil awave upon the wind upon the headland, wind around her.

Cowley sang:

—M’appari tutt’amor:
Il mio sguardo l’incontr...

She waved, unhearing Cowley, her veil, to one departing, dear one, to wind, love, speeding sail, return.

—Go on, Simon.

—Ah, sure, my dancing days are done, Ben... Well...

Mr Dedalus laid his pipe to rest beside the tuningfork and, sitting, touched the obedient keys.

—No, Simon, Father Cowley turned. Play it in the original. One flat.

The keys, obedient, rose higher, told, faltered, confessed, confused.

Up stage strode Father Cowley.

—Here, Simon, I’ll accompany you, he said. Get up.

By Graham Lemon’s pineapple rock, by Elvery’s elephant jingly jogged.

Steak, kidney, liver, mashed, at meat fit for princes sat princes Bloom and Goulding. Princes at meat they raised and drank, Power and cider.

Most beautiful tenor air ever written, Richie said: Sonnambula. He heard Joe Maas sing that one night. Ah, what M’Guckin! Yes. In his way. Choirboy style. Maas was the boy. Massboy. A lyrical tenor if you like. Never forget it. Never.

Tenderly Bloom over liverless bacon saw the tightened features strain. Backache he. Bright’s bright eye. Next item on the programme. Paying the piper. Pills, pounded bread, worth a guinea a box. Stave it off awhile. Sings too: Down among the dead men. Appropriate. Kidney pie. Sweets to the. Not making much hand of it. Best value in. Characteristic of him. Power. Particular about his drink. Flaw in the glass, fresh Vartry water. Fecking matches from counters to save. Then squander a sovereign in dribs and drabs. And when he’s wanted not a farthing. Screwed refusing to pay his fare. Curious types.

Never would Richie forget that night. As long as he lived: never. In the gods of the old Royal with little Peake. And when the first note.

Speech paused on Richie’s lips.

Coming out with a whopper now. Rhapsodies about damn all. Believes his own lies. Does really. Wonderful liar. But want a good memory.

—Which air is that? asked Leopold Bloom.

—All is lost now.

Richie cocked his lips apout. A low incipient note sweet banshee murmured: all. A thrush. A throstle. His breath, birdsweet, good teeth he’s proud of, fluted with plaintive woe. Is lost. Rich sound. Two notes in one there. Blackbird I heard in the hawthorn valley. Taking my motives he twined and turned them. All most too new call is lost in all. Echo. How sweet the answer. How is that done? All lost now. Mournful he whistled. Fall, surrender, lost.

Bloom bent leopold ear, turning a fringe of doyley down under the vase. Order. Yes, I remember. Lovely air. In sleep she went to him. Innocence in the moon. Brave. Don’t know their danger. Still hold her back. Call name. Touch water. Jingle jaunty. Too late. She longed to go. That’s why. Woman. As easy stop the sea. Yes: all is lost.

—A beautiful air, said Bloom lost Leopold. I know it well.

Never in all his life had Richie Goulding.

He knows it well too. Or he feels. Still harping on his daughter. Wise child that knows her father, Dedalus said. Me?

Bloom askance over liverless saw. Face of the all is lost. Rollicking Richie once. Jokes old stale now. Wagging his ear. Napkinring in his eye. Now begging letters he sends his son with. Crosseyed Walter sir I did sir. Wouldn’t trouble only I was expecting some money. Apologise.

Piano again. Sounds better than last time I heard. Tuned probably. Stopped again.

Dollard and Cowley still urged the lingering singer out with it.

—With it, Simon.

—It, Simon.

—Ladies and gentlemen, I am most deeply obliged by your kind solicitations.

—It, Simon.

—I have no money but if you will lend me your attention I shall endeavour to sing to you of a heart bowed down.

By the sandwichbell in screening shadow Lydia, her bronze and rose, a lady’s grace, gave and withheld: as in cool glaucous eau de Nil Mina to tankards two her pinnacles of gold.

The harping chords of prelude closed. A chord, longdrawn, expectant, drew a voice away.

—When first I saw that form endearing...

Richie turned.

—Si Dedalus’ voice, he said.

Braintipped, cheek touched with flame, they listened feeling that flow endearing flow over skin limbs human heart soul spine. Bloom signed to Pat, bald Pat is a waiter hard of hearing, to set ajar the door of the bar. The door of the bar. So. That will do. Pat, waiter, waited, waiting to hear, for he was hard of hear by the door.

—Sorrow from me seemed to depart.

Through the hush of air a voice sang to them, low, not rain, not leaves in murmur, like no voice of strings or reeds or whatdoyoucallthem dulcimers touching their still ears with words, still hearts of their each his remembered lives. Good, good to hear: sorrow from them each seemed to from both depart when first they heard. When first they saw, lost Richie Poldy, mercy of beauty, heard from a person wouldn’t expect it in the least, her first merciful lovesoft oftloved word.

Love that is singing: love’s old sweet song. Bloom unwound slowly the elastic band of his packet. Love’s old sweet sonnez la gold. Bloom wound a skein round four forkfingers, stretched it, relaxed, and wound it round his troubled double, fourfold, in octave, gyved them fast.

—Full of hope and all delighted...

Tenors get women by the score. Increase their flow. Throw flower at his feet. When will we meet? My head it simply. Jingle all delighted. He can’t sing for tall hats. Your head it simply swurls. Perfumed for him. What perfume does your wife? I want to know. Jing. Stop. Knock. Last look at mirror always before she answers the door. The hall. There? How do you? I do well. There? What? Or? Phial of cachous, kissing comfits, in her satchel. Yes? Hands felt for the opulent.

Alas the voice rose, sighing, changed: loud, full, shining, proud.

—But alas, ’twas idle dreaming...

Glorious tone he has still. Cork air softer also their brogue. Silly man! Could have made oceans of money. Singing wrong words. Wore out his wife: now sings. But hard to tell. Only the two themselves. If he doesn’t break down. Keep a trot for the avenue. His hands and feet sing too. Drink. Nerves overstrung. Must be abstemious to sing. Jenny Lind soup: stock, sage, raw eggs, half pint of cream. For creamy dreamy.

Tenderness it welled: slow, swelling, full it throbbed. That’s the chat. Ha, give! Take! Throb, a throb, a pulsing proud erect.

Words? Music? No: it’s what’s behind.

Bloom looped, unlooped, noded, disnoded.

Bloom. Flood of warm jamjam lickitup secretness flowed to flow in music out, in desire, dark to lick flow invading. Tipping her tepping her tapping her topping her. Tup. Pores to dilate dilating. Tup. The joy the feel the warm the. Tup. To pour o’er sluices pouring gushes. Flood, gush, flow, joygush, tupthrob. Now! Language of love.

—... ray of hope is...

Beaming. Lydia for Lidwell squeak scarcely hear so ladylike the muse unsqueaked a ray of hopk.

Martha it is. Coincidence. Just going to write. Lionel’s song. Lovely name you have. Can’t write. Accept my little pres. Play on her heartstrings pursestrings too. She’s a. I called you naughty boy. Still the name: Martha. How strange! Today.

The voice of Lionel returned, weaker but unwearied. It sang again to Richie Poldy Lydia Lidwell also sang to Pat open mouth ear waiting to wait. How first he saw that form endearing, how sorrow seemed to part, how look, form, word charmed him Gould Lidwell, won Pat Bloom’s heart.

Wish I could see his face, though. Explain better. Why the barber in Drago’s always looked my face when I spoke his face in the glass. Still hear it better here than in the bar though farther.

—Each graceful look...

First night when first I saw her at Mat Dillon’s in Terenure. Yellow, black lace she wore. Musical chairs. We two the last. Fate. After her. Fate. Round and round slow. Quick round. We two. All looked. Halt. Down she sat. All ousted looked. Lips laughing. Yellow knees.

—Charmed my eye...

Singing. Waiting she sang. I turned her music. Full voice of perfume of what perfume does your lilactrees. Bosom I saw, both full, throat warbling. First I saw. She thanked me. Why did she me? Fate. Spanishy eyes. Under a peartree alone patio this hour in old Madrid one side in shadow Dolores shedolores. At me. Luring. Ah, alluring.

—Martha! Ah, Martha!

Quitting all languor Lionel cried in grief, in cry of passion dominant to love to return with deepening yet with rising chords of harmony. In cry of lionel loneliness that she should know, must martha feel. For only her he waited. Where? Here there try there here all try where. Somewhere.

—Co-ome, thou lost one!
Co-ome, thou dear one!

Alone. One love. One hope. One comfort me. Martha, chestnote, return!

—Come!

It soared, a bird, it held its flight, a swift pure cry, soar silver orb it leaped serene, speeding, sustained, to come, don’t spin it out too long long breath he breath long life, soaring high, high resplendent, aflame, crowned, high in the effulgence symbolistic, high, of the etherial bosom, high, of the high vast irradiation everywhere all soaring all around about the all, the endlessnessnessness...

—To me!

Siopold!

Consumed.

Come. Well sung. All clapped. She ought to. Come. To me, to him, to her, you too, me, us.

—Bravo! Clapclap. Good man, Simon. Clappyclapclap. Encore! Clapclipclap clap. Sound as a bell. Bravo, Simon! Clapclopclap. Encore, enclap, said, cried, clapped all, Ben Dollard, Lydia Douce, George Lidwell, Pat, Mina Kennedy, two gentlemen with two tankards, Cowley, first gent with tank and bronze Miss Douce and gold Miss Mina.

Blazes Boylan’s smart tan shoes creaked on the barfloor, said before. Jingle by monuments of sir John Gray, Horatio onehandled Nelson, reverend father Theobald Mathew, jaunted, as said before just now. Atrot, in heat, heatseated. Cloche. Sonnez la. Cloche. Sonnez la. Slower the mare went up the hill by the Rotunda, Rutland square. Too slow for Boylan, blazes Boylan, impatience Boylan, joggled the mare.

An afterclang of Cowley’s chords closed, died on the air made richer.

And Richie Goulding drank his Power and Leopold Bloom his cider drank, Lidwell his Guinness, second gentleman said they would partake of two more tankards if she did not mind. Miss Kennedy smirked, disserving, coral lips, at first, at second. She did not mind.

—Seven days in jail, Ben Dollard said, on bread and water. Then you’d sing, Simon, like a garden thrush.

Lionel Simon, singer, laughed. Father Bob Cowley played. Mina Kennedy served. Second gentleman paid. Tom Kernan strutted in. Lydia, admired, admired. But Bloom sang dumb.

Admiring.

Richie, admiring, descanted on that man’s glorious voice. He remembered one night long ago. Never forget that night. Si sang ’Twas rank and fame: in Ned Lambert’s ’twas. Good God he never heard in all his life a note like that he never did then false one we had better part so clear so God he never heard since love lives not a clinking voice lives not ask Lambert he can tell you too.

Goulding, a flush struggling in his pale, told Mr Bloom, face of the night, Si in Ned Lambert’s, Dedalus house, sang ’Twas rank and fame.

He, Mr Bloom, listened while he, Richie Goulding, told him, Mr Bloom, of the night he, Richie, heard him, Si Dedalus, sing ’Twas rank and fame in his, Ned Lambert’s, house.

Brothers-in-law: relations. We never speak as we pass by. Rift in the lute I think. Treats him with scorn. See. He admires him all the more. The night Si sang. The human voice, two tiny silky chords, wonderful, more than all others.

That voice was a lamentation. Calmer now. It’s in the silence after you feel you hear. Vibrations. Now silent air.

Bloom ungyved his crisscrossed hands and with slack fingers plucked the slender catgut thong. He drew and plucked. It buzz, it twanged. While Goulding talked of Barraclough’s voice production, while Tom Kernan, harking back in a retrospective sort of arrangement talked to listening Father Cowley, who played a voluntary, who nodded as he played. While big Ben Dollard talked with Simon Dedalus, lighting, who nodded as he smoked, who smoked.

Thou lost one. All songs on that theme. Yet more Bloom stretched his string. Cruel it seems. Let people get fond of each other: lure them on. Then tear asunder. Death. Explos. Knock on the head. Outtohelloutofthat. Human life. Dignam. Ugh, that rat’s tail wriggling! Five bob I gave. Corpus paradisum. Corncrake croaker: belly like a poisoned pup. Gone. They sing. Forgotten. I too. And one day she with. Leave her: get tired. Suffer then. Snivel. Big spanishy eyes goggling at nothing. Her wavyavyeavyheavyeavyevyevyhair un comb:’d.

Yet too much happy bores. He stretched more, more. Are you not happy in your? Twang. It snapped.

Jingle into Dorset street.

Miss Douce withdrew her satiny arm, reproachful, pleased.

—Don’t make half so free, said she, till we are better acquainted.

George Lidwell told her really and truly: but she did not believe.

First gentleman told Mina that was so. She asked him was that so. And second tankard told her so. That that was so.

Miss Douce, miss Lydia, did not believe: miss Kennedy, Mina, did not believe: George Lidwell, no: miss Dou did not: the first, the first: gent with the tank: believe, no, no: did not, miss Kenn: Lidlydiawell: the tank.

Better write it here. Quills in the postoffice chewed and twisted.

Bald Pat at a sign drew nigh. A pen and ink. He went. A pad. He went. A pad to blot. He heard, deaf Pat.

—Yes, Mr Bloom said, teasing the curling catgut line. It certainly is. Few lines will do. My present. All that Italian florid music is. Who is this wrote? Know the name you know better. Take out sheet notepaper, envelope: unconcerned. It’s so characteristic.

—Grandest number in the whole opera, Goulding said.

—It is, Bloom said.

Numbers it is. All music when you come to think. Two multiplied by two divided by half is twice one. Vibrations: chords those are. One plus two plus six is seven. Do anything you like with figures juggling. Always find out this equal to that. Symmetry under a cemetery wall. He doesn’t see my mourning. Callous: all for his own gut. Musemathematics. And you think you’re listening to the etherial. But suppose you said it like: Martha, seven times nine minus x is thirtyfive thousand. Fall quite flat. It’s on account of the sounds it is.

Instance he’s playing now. Improvising. Might be what you like, till you hear the words. Want to listen sharp. Hard. Begin all right: then hear chords a bit off: feel lost a bit. In and out of sacks, over barrels, through wirefences, obstacle race. Time makes the tune. Question of mood you’re in. Still always nice to hear. Except scales up and down, girls learning. Two together nextdoor neighbours. Ought to invent dummy pianos for that. Blumenlied I bought for her. The name. Playing it slow, a girl, night I came home, the girl. Door of the stables near Cecilia street. Milly no taste. Queer because we both, I mean.

Bald deaf Pat brought quite flat pad ink. Pat set with ink pen quite flat pad. Pat took plate dish knife fork. Pat went.

It was the only language Mr Dedalus said to Ben. He heard them as a boy in Ringabella, Crosshaven, Ringabella, singing their barcaroles. Queenstown harbour full of Italian ships. Walking, you know, Ben, in the moonlight with those earthquake hats. Blending their voices. God, such music, Ben. Heard as a boy. Cross Ringabella haven mooncarole.

Sour pipe removed he held a shield of hand beside his lips that cooed a moonlight nightcall, clear from anear, a call from afar, replying.

Down the edge of his Freeman baton ranged Bloom’s, your other eye, scanning for where did I see that. Callan, Coleman, Dignam Patrick. Heigho! Heigho! Fawcett. Aha! Just I was looking...

Hope he’s not looking, cute as a rat. He held unfurled his Freeman. Can’t see now. Remember write Greek ees. Bloom dipped, Bloo mur: dear sir. Dear Henry wrote: dear Mady. Got your lett and flow. Hell did I put? Some pock or oth. It is utterl imposs. Underline imposs. To write today.

Bore this. Bored Bloom tambourined gently with I am just reflecting fingers on flat pad Pat brought.

On. Know what I mean. No, change that ee. Accep my poor litt pres enclos. Ask her no answ. Hold on. Five Dig. Two about here. Penny the gulls. Elijah is com. Seven Davy Byrne’s. Is eight about. Say half a crown. My poor little pres: p. o. two and six. Write me a long. Do you despise? Jingle, have you the? So excited. Why do you call me naught? You naughty too? O, Mairy lost the string of her. Bye for today. Yes, yes, will tell you. Want to. To keep it up. Call me that other. Other world she wrote. My patience are exhaust. To keep it up. You must believe. Believe. The tank. It. Is. True.

Folly am I writing? Husbands don’t. That’s marriage does, their wives. Because I’m away from. Suppose. But how? She must. Keep young. If she found out. Card in my high grade ha. No, not tell all. Useless pain. If they don’t see. Woman. Sauce for the gander.

A hackney car, number three hundred and twentyfour, driver Barton James of number one Harmony avenue, Donnybrook, on which sat a fare, a young gentleman, stylishly dressed in an indigoblue serge suit made by George Robert Mesias, tailor and cutter, of number five Eden quay, and wearing a straw hat very dressy, bought of John Plasto of number one Great Brunswick street, hatter. Eh? This is the jingle that joggled and jingled. By Dlugacz’ porkshop bright tubes of Agendath trotted a gallantbuttocked mare.

—Answering an ad? keen Richie’s eyes asked Bloom.

—Yes, Mr Bloom said. Town traveller. Nothing doing, I expect.

Bloom mur: best references. But Henry wrote: it will excite me. You know how. In haste. Henry. Greek ee. Better add postscript. What is he playing now? Improvising. Intermezzo. P. S. The rum tum tum. How will you pun? You punish me? Crooked skirt swinging, whack by. Tell me I want to. Know. O. Course if I didn’t I wouldn’t ask. La la la ree. Trails off there sad in minor. Why minor sad? Sign H. They like sad tail at end. P. P. S. La la la ree. I feel so sad today. La ree. So lonely. Dee.

He blotted quick on pad of Pat. Envel. Address. Just copy out of paper. Murmured: Messrs Callan, Coleman and Co, limited. Henry wrote:

Miss Martha Clifford
    c/o P. O.
        Dolphin’s Barn Lane
            Dublin.

Blot over the other so he can’t read. There. Right. Idea prize titbit. Something detective read off blottingpad. Payment at the rate of guinea per col. Matcham often thinks the laughing witch. Poor Mrs Purefoy. U. P: up.

Too poetical that about the sad. Music did that. Music hath charms. Shakespeare said. Quotations every day in the year. To be or not to be. Wisdom while you wait.

In Gerard’s rosery of Fetter lane he walks, greyedauburn. One life is all. One body. Do. But do.

Done anyhow. Postal order, stamp. Postoffice lower down. Walk now. Enough. Barney Kiernan’s I promised to meet them. Dislike that job. House of mourning. Walk. Pat! Doesn’t hear. Deaf beetle he is.

Car near there now. Talk. Talk. Pat! Doesn’t. Settling those napkins. Lot of ground he must cover in the day. Paint face behind on him then he’d be two. Wish they’d sing more. Keep my mind off.

Bald Pat who is bothered mitred the napkins. Pat is a waiter hard of his hearing. Pat is a waiter who waits while you wait. Hee hee hee hee. He waits while you wait. Hee hee. A waiter is he. Hee hee hee hee. He waits while you wait. While you wait if you wait he will wait while you wait. Hee hee hee hee. Hoh. Wait while you wait.

Douce now. Douce Lydia. Bronze and rose.

She had a gorgeous, simply gorgeous, time. And look at the lovely shell she brought.

To the end of the bar to him she bore lightly the spiked and winding seahorn that he, George Lidwell, solicitor, might hear.

—Listen! she bade him.

Under Tom Kernan’s ginhot words the accompanist wove music slow. Authentic fact. How Walter Bapty lost his voice. Well, sir, the husband took him by the throat. Scoundrel, said he, You’ll sing no more lovesongs. He did, faith, sir Tom. Bob Cowley wove. Tenors get wom. Cowley lay back.

Ah, now he heard, she holding it to his ear. Hear! He heard. Wonderful. She held it to her own. And through the sifted light pale gold in contrast glided. To hear.

Tap.

Bloom through the bardoor saw a shell held at their ears. He heard more faintly that that they heard, each for herself alone, then each for other, hearing the plash of waves, loudly, a silent roar.

Bronze by a weary gold, anear, afar, they listened.

Her ear too is a shell, the peeping lobe there. Been to the seaside. Lovely seaside girls. Skin tanned raw. Should have put on coldcream first make it brown. Buttered toast. O and that lotion mustn’t forget. Fever near her mouth. Your head it simply. Hair braided over: shell with seaweed. Why do they hide their ears with seaweed hair? And Turks the mouth, why? Her eyes over the sheet. Yashmak. Find the way in. A cave. No admittance except on business.

The sea they think they hear. Singing. A roar. The blood it is. Souse in the ear sometimes. Well, it’s a sea. Corpuscle islands.

Wonderful really. So distinct. Again. George Lidwell held its murmur, hearing: then laid it by, gently.

—What are the wild waves saying? he asked her, smiled.

Charming, seasmiling and unanswering Lydia on Lidwell smiled.

Tap.

By Larry O’Rourke’s, by Larry, bold Larry O’, Boylan swayed and Boylan turned.

From the forsaken shell miss Mina glided to her tankards waiting. No, she was not so lonely archly miss Douce’s head let Mr Lidwell know. Walks in the moonlight by the sea. No, not alone. With whom? She nobly answered: with a gentleman friend.

Bob Cowley’s twinkling fingers in the treble played again. The landlord has the prior. A little time. Long John. Big Ben. Lightly he played a light bright tinkling measure for tripping ladies, arch and smiling, and for their gallants, gentlemen friends. One: one, one, one, one, one: two, one, three, four.

Sea, wind, leaves, thunder, waters, cows lowing, the cattlemarket, cocks, hens don’t crow, snakes hissss. There’s music everywhere. Ruttledge’s door: ee creaking. No, that’s noise. Minuet of Don Giovanni he’s playing now. Court dresses of all descriptions in castle chambers dancing. Misery. Peasants outside. Green starving faces eating dockleaves. Nice that is. Look: look, look, look, look, look: you look at us.

That’s joyful I can feel. Never have written it. Why? My joy is other joy. But both are joys. Yes, joy it must be. Mere fact of music shows you are. Often thought she was in the dumps till she began to lilt. Then know.

M’Coy valise. My wife and your wife. Squealing cat. Like tearing silk. Tongue when she talks like the clapper of a bellows. They can’t manage men’s intervals. Gap in their voices too. Fill me. I’m warm, dark, open. Molly in quis est homo: Mercadante. My ear against the wall to hear. Want a woman who can deliver the goods.

Jog jig jogged stopped. Dandy tan shoe of dandy Boylan socks skyblue clocks came light to earth.

O, look we are so! Chamber music. Could make a kind of pun on that. It is a kind of music I often thought when she. Acoustics that is. Tinkling. Empty vessels make most noise. Because the acoustics, the resonance changes according as the weight of the water is equal to the law of falling water. Like those rhapsodies of Liszt’s, Hungarian, gipsyeyed. Pearls. Drops. Rain. Diddleiddle addleaddle ooddleooddle. Hissss. Now. Maybe now. Before.

One rapped on a door, one tapped with a knock, did he knock Paul de Kock with a loud proud knocker with a cock carracarracarra cock. Cockcock.

Tap.

—Qui sdegno, Ben, said Father Cowley.

—No, Ben, Tom Kernan interfered. The Croppy Boy. Our native Doric.

—Ay do, Ben, Mr Dedalus said. Good men and true.

—Do, do, they begged in one.

I’ll go. Here, Pat, return. Come. He came, he came, he did not stay. To me. How much?

—What key? Six sharps?

—F sharp major, Ben Dollard said.

Bob Cowley’s outstretched talons griped the black deepsounding chords.

Must go prince Bloom told Richie prince. No, Richie said. Yes, must. Got money somewhere. He’s on for a razzle backache spree. Much? He seehears lipspeech. One and nine. Penny for yourself. Here. Give him twopence tip. Deaf, bothered. But perhaps he has wife and family waiting, waiting Patty come home. Hee hee hee hee. Deaf wait while they wait.

But wait. But hear. Chords dark. Lugugugubrious. Low. In a cave of the dark middle earth. Embedded ore. Lumpmusic.

The voice of dark age, of unlove, earth’s fatigue made grave approach and painful, come from afar, from hoary mountains, called on good men and true. The priest he sought. With him would he speak a word.

Tap.

Ben Dollard’s voice. Base barreltone. Doing his level best to say it. Croak of vast manless moonless womoonless marsh. Other comedown. Big ships’ chandler’s business he did once. Remember: rosiny ropes, ships’ lanterns. Failed to the tune of ten thousand pounds. Now in the Iveagh home. Cubicle number so and so. Number one Bass did that for him.

The priest’s at home. A false priest’s servant bade him welcome. Step in. The holy father. With bows a traitor servant. Curlycues of chords.

Ruin them. Wreck their lives. Then build them cubicles to end their days in. Hushaby. Lullaby. Die, dog. Little dog, die.

The voice of warning, solemn warning, told them the youth had entered a lonely hall, told them how solemn fell his footsteps there, told them the gloomy chamber, the vested priest sitting to shrive.

Decent soul. Bit addled now. Thinks he’ll win in Answers, poets’ picture puzzle. We hand you crisp five pound note. Bird sitting hatching in a nest. Lay of the last minstrel he thought it was. See blank tee what domestic animal? Tee dash ar most courageous mariner. Good voice he has still. No eunuch yet with all his belongings.

Listen. Bloom listened. Richie Goulding listened. And by the door deaf Pat, bald Pat, tipped Pat, listened.

The chords harped slower.

The voice of penance and of grief came slow, embellished, tremulous. Ben’s contrite beard confessed. in nomine Domini, in God’s name he knelt. He beat his hand upon his breast, confessing: mea culpa.

Latin again. That holds them like birdlime. Priest with the communion corpus for those women. Chap in the mortuary, coffin or coffey, corpusnomine. Wonder where that rat is by now. Scrape.

Tap.

They listened. Tankards and miss Kennedy. George Lidwell, eyelid well expressive, fullbusted satin. Kernan. Si.

The sighing voice of sorrow sang. His sins. Since Easter he had cursed three times. You bitch’s bast. And once at masstime he had gone to play. Once by the churchyard he had passed and for his mother’s rest he had not prayed. A boy. A croppy boy.

Bronze, listening, by the beerpull gazed far away. Soulfully. Doesn’t half know I’m. Molly great dab at seeing anyone looking.

Bronze gazed far sideways. Mirror there. Is that best side of her face? They always know. Knock at the door. Last tip to titivate.

Cockcarracarra.

What do they think when they hear music? Way to catch rattlesnakes. Night Michael Gunn gave us the box. Tuning up. Shah of Persia liked that best. Remind him of home sweet home. Wiped his nose in curtain too. Custom his country perhaps. That’s music too. Not as bad as it sounds. Tootling. Brasses braying asses through uptrunks. Doublebasses helpless, gashes in their sides. Woodwinds mooing cows. Semigrand open crocodile music hath jaws. Woodwind like Goodwin’s name.

She looked fine. Her crocus dress she wore lowcut, belongings on show. Clove her breath was always in theatre when she bent to ask a question. Told her what Spinoza says in that book of poor papa’s. Hypnotised, listening. Eyes like that. She bent. Chap in dresscircle staring down into her with his operaglass for all he was worth. Beauty of music you must hear twice. Nature woman half a look. God made the country man the tune. Met him pike hoses. Philosophy. O rocks!

All gone. All fallen. At the siege of Ross his father, at Gorey all his brothers fell. To Wexford, we are the boys of Wexford, he would. Last of his name and race.

I too. Last of my race. Milly young student. Well, my fault perhaps. No son. Rudy. Too late now. Or if not? If not? If still?

He bore no hate.

Hate. Love. Those are names. Rudy. Soon I am old.

Big Ben his voice unfolded. Great voice Richie Goulding said, a flush struggling in his pale, to Bloom soon old. But when was young?

Ireland comes now. My country above the king. She listens. Who fears to speak of nineteen four? Time to be shoving. Looked enough.

—Bless me, father, Dollard the croppy cried. Bless me and let me go.

Tap.

Bloom looked, unblessed to go. Got up to kill: on eighteen bob a week. Fellows shell out the dibs. Want to keep your weathereye open. Those girls, those lovely. By the sad sea waves. Chorusgirl’s romance. Letters read out for breach of promise. From Chickabiddy’s owny Mumpsypum. Laughter in court. Henry. I never signed it. The lovely name you.

Low sank the music, air and words. Then hastened. The false priest rustling soldier from his cassock. A yeoman captain. They know it all by heart. The thrill they itch for. Yeoman cap.

Tap. Tap.

Thrilled she listened, bending in sympathy to hear.

Blank face. Virgin should say: or fingered only. Write something on it: page. If not what becomes of them? Decline, despair. Keeps them young. Even admire themselves. See. Play on her. Lip blow. Body of white woman, a flute alive. Blow gentle. Loud. Three holes, all women. Goddess I didn’t see. They want it. Not too much polite. That’s why he gets them. Gold in your pocket, brass in your face. Say something. Make her hear. With look to look. Songs without words. Molly, that hurdygurdy boy. She knew he meant the monkey was sick. Or because so like the Spanish. Understand animals too that way. Solomon did. Gift of nature.

Ventriloquise. My lips closed. Think in my stom. What?

Will? You? I. Want. You. To.

With hoarse rude fury the yeoman cursed, swelling in apoplectic bitch’s bastard. A good thought, boy, to come. One hour’s your time to live, your last.

Tap. Tap.

Thrill now. Pity they feel. To wipe away a tear for martyrs that want to, dying to, die. For all things dying, for all things born. Poor Mrs Purefoy. Hope she’s over. Because their wombs.

A liquid of womb of woman eyeball gazed under a fence of lashes, calmly, hearing. See real beauty of the eye when she not speaks. On yonder river. At each slow satiny heaving bosom’s wave (her heaving embon) red rose rose slowly sank red rose. Heartbeats: her breath: breath that is life. And all the tiny tiny fernfoils trembled of maidenhair.

But look. The bright stars fade. O rose! Castile. The morn. Ha. Lidwell. For him then not for. Infatuated. I like that? See her from here though. Popped corks, splashes of beerfroth, stacks of empties.

On the smooth jutting beerpull laid Lydia hand, lightly, plumply, leave it to my hands. All lost in pity for croppy. Fro, to: to, fro: over the polished knob (she knows his eyes, my eyes, her eyes) her thumb and finger passed in pity: passed, reposed and, gently touching, then slid so smoothly, slowly down, a cool firm white enamel baton protruding through their sliding ring.

With a cock with a carra.

Tap. Tap. Tap.

I hold this house. Amen. He gnashed in fury. Traitors swing.

The chords consented. Very sad thing. But had to be.

Get out before the end. Thanks, that was heavenly. Where’s my hat. Pass by her. Can leave that Freeman. Letter I have. Suppose she were the? No. Walk, walk, walk. Like Cashel Boylo Connoro Coylo Tisdall Maurice Tisntdall Farrell. Waaaaaaalk.

Well, I must be. Are you off? Yrfmstbyes. Blmstup. O’er ryehigh blue. Ow. Bloom stood up. Soap feeling rather sticky behind. Must have sweated: music. That lotion, remember. Well, so long. High grade. Card inside. Yes.

By deaf Pat in the doorway straining ear Bloom passed.

At Geneva barrack that young man died. At Passage was his body laid. Dolor! O, he dolores! The voice of the mournful chanter called to dolorous prayer.

By rose, by satiny bosom, by the fondling hand, by slops, by empties, by popped corks, greeting in going, past eyes and maidenhair, bronze and faint gold in deepseashadow, went Bloom, soft Bloom, I feel so lonely Bloom.

Tap. Tap. Tap.

Pray for him, prayed the bass of Dollard. You who hear in peace. Breathe a prayer, drop a tear, good men, good people. He was the croppy boy.

Scaring eavesdropping boots croppy bootsboy Bloom in the Ormond hallway heard the growls and roars of bravo, fat backslapping, their boots all treading, boots not the boots the boy. General chorus off for a swill to wash it down. Glad I avoided.

—Come on, Ben, Simon Dedalus cried. By God, you’re as good as ever you were.

—Better, said Tomgin Kernan. Most trenchant rendition of that ballad, upon my soul and honour it is.

—Lablache, said Father Cowley.

Ben Dollard bulkily cachuchad towards the bar, mightily praisefed and all big roseate, on heavyfooted feet, his gouty fingers nakkering castagnettes in the air.

Big Benaben Dollard. Big Benben. Big Benben.

Rrr.

And deepmoved all, Simon trumping compassion from foghorn nose, all laughing they brought him forth, Ben Dollard, in right good cheer.

—You’re looking rubicund, George Lidwell said.

Miss Douce composed her rose to wait.

—Ben machree, said Mr Dedalus, clapping Ben’s fat back shoulderblade. Fit as a fiddle only he has a lot of adipose tissue concealed about his person.

Rrrrrrrsss.

—Fat of death, Simon, Ben Dollard growled.

Richie rift in the lute alone sat: Goulding, Collis, Ward. Uncertainly he waited. Unpaid Pat too.

Tap. Tap. Tap. Tap.

Miss Mina Kennedy brought near her lips to ear of tankard one.

—Mr Dollard, they murmured low.

—Dollard, murmured tankard.

Tank one believed: miss Kenn when she: that doll he was: she doll: the tank.

He murmured that he knew the name. The name was familiar to him, that is to say. That was to say he had heard the name of. Dollard, was it? Dollard, yes.

Yes, her lips said more loudly, Mr Dollard. He sang that song lovely, murmured Mina. Mr Dollard. And The last rose of summer was a lovely song. Mina loved that song. Tankard loved the song that Mina.

’Tis the last rose of summer dollard left bloom felt wind wound round inside.

Gassy thing that cider: binding too. Wait. Postoffice near Reuben J’s one and eightpence too. Get shut of it. Dodge round by Greek street. Wish I hadn’t promised to meet. Freer in air. Music. Gets on your nerves. Beerpull. Her hand that rocks the cradle rules the. Ben Howth. That rules the world.

Far. Far. Far. Far.

Tap. Tap. Tap. Tap.

Up the quay went Lionelleopold, naughty Henry with letter for Mady, with sweets of sin with frillies for Raoul with met him pike hoses went Poldy on.

Tap blind walked tapping by the tap the curbstone tapping, tap by tap.

Cowley, he stuns himself with it: kind of drunkenness. Better give way only half way the way of a man with a maid. Instance enthusiasts. All ears. Not lose a demisemiquaver. Eyes shut. Head nodding in time. Dotty. You daren’t budge. Thinking strictly prohibited. Always talking shop. Fiddlefaddle about notes.

All a kind of attempt to talk. Unpleasant when it stops because you never know exac. Organ in Gardiner street. Old Glynn fifty quid a year. Queer up there in the cockloft, alone, with stops and locks and keys. Seated all day at the organ. Maunder on for hours, talking to himself or the other fellow blowing the bellows. Growl angry, then shriek cursing (want to have wadding or something in his no don’t she cried), then all of a soft sudden wee little wee little pipy wind.

Pwee! A wee little wind piped eeee. In Bloom’s little wee.

—Was he? Mr Dedalus said, returning with fetched pipe. I was with him this morning at poor little Paddy Dignam’s...

—Ay, the Lord have mercy on him.

—By the bye there’s a tuningfork in there on the...

Tap. Tap. Tap. Tap.

—The wife has a fine voice. Or had. What? Lidwell asked.

—O, that must be the tuner, Lydia said to Simonlionel first I saw, forgot it when he was here.

Blind he was she told George Lidwell second I saw. And played so exquisitely, treat to hear. Exquisite contrast: bronzelid, minagold.

—Shout! Ben Dollard shouted, pouring. Sing out!

—’lldo! cried Father Cowley.

Rrrrrr.

I feel I want...

Tap. Tap. Tap. Tap. Tap

—Very, Mr Dedalus said, staring hard at a headless sardine.

Under the sandwichbell lay on a bier of bread one last, one lonely, last sardine of summer. Bloom alone.

—Very, he stared. The lower register, for choice.

Tap. Tap. Tap. Tap. Tap. Tap. Tap. Tap.

Bloom went by Barry’s. Wish I could. Wait. That wonderworker if I had. Twentyfour solicitors in that one house. Counted them. Litigation. Love one another. Piles of parchment. Messrs Pick and Pocket have power of attorney. Goulding, Collis, Ward.

But for example the chap that wallops the big drum. His vocation: Mickey Rooney’s band. Wonder how it first struck him. Sitting at home after pig’s cheek and cabbage nursing it in the armchair. Rehearsing his band part. Pom. Pompedy. Jolly for the wife. Asses’ skins. Welt them through life, then wallop after death. Pom. Wallop. Seems to be what you call yashmak or I mean kismet. Fate.

Tap. Tap. A stripling, blind, with a tapping cane came taptaptapping by Daly’s window where a mermaid hair all streaming (but he couldn’t see) blew whiffs of a mermaid (blind couldn’t), mermaid, coolest whiff of all.

Instruments. A blade of grass, shell of her hands, then blow. Even comb and tissuepaper you can knock a tune out of. Molly in her shift in Lombard street west, hair down. I suppose each kind of trade made its own, don’t you see? Hunter with a horn. Haw. Have you the? Cloche. Sonnez la. Shepherd his pipe. Pwee little wee. Policeman a whistle. Locks and keys! Sweep! Four o’clock’s all’s well! Sleep! All is lost now. Drum? Pompedy. Wait. I know. Towncrier, bumbailiff. Long John. Waken the dead. Pom. Dignam. Poor little nominedomine. Pom. It is music. I mean of course it’s all pom pom pom very much what they call da capo. Still you can hear. As we march, we march along, march along. Pom.

I must really. Fff. Now if I did that at a banquet. Just a question of custom shah of Persia. Breathe a prayer, drop a tear. All the same he must have been a bit of a natural not to see it was a yeoman cap. Muffled up. Wonder who was that chap at the grave in the brown macin. O, the whore of the lane!

A frowsy whore with black straw sailor hat askew came glazily in the day along the quay towards Mr Bloom. When first he saw that form endearing? Yes, it is. I feel so lonely. Wet night in the lane. Horn. Who had the? Heehaw shesaw. Off her beat here. What is she? Hope she. Psst! Any chance of your wash. Knew Molly. Had me decked. Stout lady does be with you in the brown costume. Put you off your stroke, that. Appointment we made knowing we’d never, well hardly ever. Too dear too near to home sweet home. Sees me, does she? Looks a fright in the day. Face like dip. Damn her. O, well, she has to live like the rest. Look in here.

In Lionel Marks’s antique saleshop window haughty Henry Lionel Leopold dear Henry Flower earnestly Mr Leopold Bloom envisaged battered candlesticks melodeon oozing maggoty blowbags. Bargain: six bob. Might learn to play. Cheap. Let her pass. Course everything is dear if you don’t want it. That’s what good salesman is. Make you buy what he wants to sell. Chap sold me the Swedish razor he shaved me with. Wanted to charge me for the edge he gave it. She’s passing now. Six bob.

Must be the cider or perhaps the burgund.

Near bronze from anear near gold from afar they chinked their clinking glasses all, brighteyed and gallant, before bronze Lydia’s tempting last rose of summer, rose of Castile. First Lid, De, Cow, Ker, Doll, a fifth: Lidwell, Si Dedalus, Bob Cowley, Kernan and big Ben Dollard.

Tap. A youth entered a lonely Ormond hall.

Bloom viewed a gallant pictured hero in Lionel Marks’s window. Robert Emmet’s last words. Seven last words. Of Meyerbeer that is.

—True men like you men.

—Ay, ay, Ben.

—Will lift your glass with us.

They lifted.

Tschink. Tschunk.

Tip. An unseeing stripling stood in the door. He saw not bronze. He saw not gold. Nor Ben nor Bob nor Tom nor Si nor George nor tanks nor Richie nor Pat. Hee hee hee hee. He did not see.

Seabloom, greaseabloom viewed last words. Softly. When my country takes her place among.

Prrprr.

Must be the bur.

Fff! Oo. Rrpr.

Nations of the earth. No-one behind. She’s passed. Then and not till then. Tram kran kran kran. Good oppor. Coming. Krandlkrankran. I’m sure it’s the burgund. Yes. One, two. Let my epitaph be. Kraaaaaa. Written. I have.

Pprrpffrrppffff.

Done.

### [ 12 ]
I was just passing the time of day with old Troy of the D. M. P. at the corner of Arbour hill there and be damned but a bloody sweep came along and he near drove his gear into my eye. I turned around to let him have the weight of my tongue when who should I see dodging along Stony Batter only Joe Hynes.

—Lo, Joe, says I. How are you blowing? Did you see that bloody chimneysweep near shove my eye out with his brush?

—Soot’s luck, says Joe. Who’s the old ballocks you were talking to?

—Old Troy, says I, was in the force. I’m on two minds not to give that fellow in charge for obstructing the thoroughfare with his brooms and ladders.

—What are you doing round those parts? says Joe.

—Devil a much, says I. There’s a bloody big foxy thief beyond by the garrison church at the corner of Chicken lane—old Troy was just giving me a wrinkle about him—lifted any God’s quantity of tea and sugar to pay three bob a week said he had a farm in the county Down off a hop-of-my-thumb by the name of Moses Herzog over there near Heytesbury street.

—Circumcised? says Joe.

—Ay, says I. A bit off the top. An old plumber named Geraghty. I’m hanging on to his taw now for the past fortnight and I can’t get a penny out of him.

—That the lay you’re on now? says Joe.

—Ay, says I. How are the mighty fallen! Collector of bad and doubtful debts. But that’s the most notorious bloody robber you’d meet in a day’s walk and the face on him all pockmarks would hold a shower of rain. Tell him, says he, I dare him, says he, and I doubledare him to send you round here again or if he does, says he, I’ll have him summonsed up before the court, so I will, for trading without a licence. And he after stuffing himself till he’s fit to burst. Jesus, I had to laugh at the little jewy getting his shirt out. He drink me my teas. He eat me my sugars. Because he no pay me my moneys?

For nonperishable goods bought of Moses Herzog, of 13 Saint Kevin’s parade in the city of Dublin, Wood quay ward, merchant, hereinafter called the vendor, and sold and delivered to Michael E. Geraghty, esquire, of 29 Arbour hill in the city of Dublin, Arran quay ward, gentleman, hereinafter called the purchaser, videlicet, five pounds avoirdupois of first choice tea at three shillings and no pence per pound avoirdupois and three stone avoirdupois of sugar, crushed crystal, at threepence per pound avoirdupois, the said purchaser debtor to the said vendor of one pound five shillings and sixpence sterling for value received which amount shall be paid by said purchaser to said vendor in weekly instalments every seven calendar days of three shillings and no pence sterling: and the said nonperishable goods shall not be pawned or pledged or sold or otherwise alienated by the said purchaser but shall be and remain and be held to be the sole and exclusive property of the said vendor to be disposed of at his good will and pleasure until the said amount shall have been duly paid by the said purchaser to the said vendor in the manner herein set forth as this day hereby agreed between the said vendor, his heirs, successors, trustees and assigns of the one part and the said purchaser, his heirs, successors, trustees and assigns of the other part.

—Are you a strict t.t.? says Joe.

—Not taking anything between drinks, says I.

—What about paying our respects to our friend? says Joe.

—Who? says I. Sure, he’s out in John of God’s off his head, poor man.

—Drinking his own stuff? says Joe.

—Ay, says I. Whisky and water on the brain.

—Come around to Barney Kiernan’s, says Joe. I want to see the citizen.

—Barney mavourneen’s be it, says I. Anything strange or wonderful, Joe?

—Not a word, says Joe. I was up at that meeting in the City Arms.

—What was that, Joe? says I.

—Cattle traders, says Joe, about the foot and mouth disease. I want to give the citizen the hard word about it.

So we went around by the Linenhall barracks and the back of the courthouse talking of one thing or another. Decent fellow Joe when he has it but sure like that he never has it. Jesus, I couldn’t get over that bloody foxy Geraghty, the daylight robber. For trading without a licence, says he.

In Inisfail the fair there lies a land, the land of holy Michan. There rises a watchtower beheld of men afar. There sleep the mighty dead as in life they slept, warriors and princes of high renown. A pleasant land it is in sooth of murmuring waters, fishful streams where sport the gurnard, the plaice, the roach, the halibut, the gibbed haddock, the grilse, the dab, the brill, the flounder, the pollock, the mixed coarse fish generally and other denizens of the aqueous kingdom too numerous to be enumerated. In the mild breezes of the west and of the east the lofty trees wave in different directions their firstclass foliage, the wafty sycamore, the Lebanonian cedar, the exalted planetree, the eugenic eucalyptus and other ornaments of the arboreal world with which that region is thoroughly well supplied. Lovely maidens sit in close proximity to the roots of the lovely trees singing the most lovely songs while they play with all kinds of lovely objects as for example golden ingots, silvery fishes, crans of herrings, drafts of eels, codlings, creels of fingerlings, purple seagems and playful insects. And heroes voyage from afar to woo them, from Eblana to Slievemargy, the peerless princes of unfettered Munster and of Connacht the just and of smooth sleek Leinster and of Cruachan’s land and of Armagh the splendid and of the noble district of Boyle, princes, the sons of kings.

And there rises a shining palace whose crystal glittering roof is seen by mariners who traverse the extensive sea in barks built expressly for that purpose, and thither come all herds and fatlings and firstfruits of that land for O’Connell Fitzsimon takes toll of them, a chieftain descended from chieftains. Thither the extremely large wains bring foison of the fields, flaskets of cauliflowers, floats of spinach, pineapple chunks, Rangoon beans, strikes of tomatoes, drums of figs, drills of Swedes, spherical potatoes and tallies of iridescent kale, York and Savoy, and trays of onions, pearls of the earth, and punnets of mushrooms and custard marrows and fat vetches and bere and rape and red green yellow brown russet sweet big bitter ripe pomellated apples and chips of strawberries and sieves of gooseberries, pulpy and pelurious, and strawberries fit for princes and raspberries from their canes.

I dare him, says he, and I doubledare him. Come out here, Geraghty, you notorious bloody hill and dale robber!

And by that way wend the herds innumerable of bellwethers and flushed ewes and shearling rams and lambs and stubble geese and medium steers and roaring mares and polled calves and longwools and storesheep and Cuffe’s prime springers and culls and sowpigs and baconhogs and the various different varieties of highly distinguished swine and Angus heifers and polly bulllocks of immaculate pedigree together with prime premiated milchcows and beeves: and there is ever heard a trampling, cackling, roaring, lowing, bleating, bellowing, rumbling, grunting, champing, chewing, of sheep and pigs and heavyhooved kine from pasturelands of Lusk and Rush and Carrickmines and from the streamy vales of Thomond, from the M’Gillicuddy’s reeks the inaccessible and lordly Shannon the unfathomable, and from the gentle declivities of the place of the race of Kiar, their udders distended with superabundance of milk and butts of butter and rennets of cheese and farmer’s firkins and targets of lamb and crannocks of corn and oblong eggs in great hundreds, various in size, the agate with this dun.

So we turned into Barney Kiernan’s and there, sure enough, was the citizen up in the corner having a great confab with himself and that bloody mangy mongrel, Garryowen, and he waiting for what the sky would drop in the way of drink.

—There he is, says I, in his gloryhole, with his cruiskeen lawn and his load of papers, working for the cause.

The bloody mongrel let a grouse out of him would give you the creeps. Be a corporal work of mercy if someone would take the life of that bloody dog. I’m told for a fact he ate a good part of the breeches off a constabulary man in Santry that came round one time with a blue paper about a licence.

—Stand and deliver, says he.

—That’s all right, citizen, says Joe. Friends here.

—Pass, friends, says he.

Then he rubs his hand in his eye and says he:

—What’s your opinion of the times?

Doing the rapparee and Rory of the hill. But, begob, Joe was equal to the occasion.

—I think the markets are on a rise, says he, sliding his hand down his fork.

So begob the citizen claps his paw on his knee and he says:

—Foreign wars is the cause of it.

And says Joe, sticking his thumb in his pocket:

—It’s the Russians wish to tyrannise.

—Arrah, give over your bloody codding, Joe, says I. I’ve a thirst on me I wouldn’t sell for half a crown.

—Give it a name, citizen, says Joe.

—Wine of the country, says he.

—What’s yours? says Joe.

—Ditto MacAnaspey, says I.

—Three pints, Terry, says Joe. And how’s the old heart, citizen? says he.

—Never better, a chara, says he. What Garry? Are we going to win? Eh?

And with that he took the bloody old towser by the scruff of the neck and, by Jesus, he near throttled him.

The figure seated on a large boulder at the foot of a round tower was that of a broadshouldered deepchested stronglimbed frankeyed redhaired freelyfreckled shaggybearded widemouthed largenosed longheaded deepvoiced barekneed brawnyhanded hairylegged ruddyfaced sinewyarmed hero. From shoulder to shoulder he measured several ells and his rocklike mountainous knees were covered, as was likewise the rest of his body wherever visible, with a strong growth of tawny prickly hair in hue and toughness similar to the mountain gorse (Ulex Europeus). The widewinged nostrils, from which bristles of the same tawny hue projected, were of such capaciousness that within their cavernous obscurity the fieldlark might easily have lodged her nest. The eyes in which a tear and a smile strove ever for the mastery were of the dimensions of a goodsized cauliflower. A powerful current of warm breath issued at regular intervals from the profound cavity of his mouth while in rhythmic resonance the loud strong hale reverberations of his formidable heart thundered rumblingly causing the ground, the summit of the lofty tower and the still loftier walls of the cave to vibrate and tremble.

He wore a long unsleeved garment of recently flayed oxhide reaching to the knees in a loose kilt and this was bound about his middle by a girdle of plaited straw and rushes. Beneath this he wore trews of deerskin, roughly stitched with gut. His nether extremities were encased in high Balbriggan buskins dyed in lichen purple, the feet being shod with brogues of salted cowhide laced with the windpipe of the same beast. From his girdle hung a row of seastones which jangled at every movement of his portentous frame and on these were graven with rude yet striking art the tribal images of many Irish heroes and heroines of antiquity, Cuchulin, Conn of hundred battles, Niall of nine hostages, Brian of Kincora, the ardri Malachi, Art MacMurragh, Shane O’Neill, Father John Murphy, Owen Roe, Patrick Sarsfield, Red Hugh O’Donnell, Red Jim MacDermott, Soggarth Eoghan O’Growney, Michael Dwyer, Francy Higgins, Henry Joy M’Cracken, Goliath, Horace Wheatley, Thomas Conneff, Peg Woffington, the Village Blacksmith, Captain Moonlight, Captain Boycott, Dante Alighieri, Christopher Columbus, S. Fursa, S. Brendan, Marshal MacMahon, Charlemagne, Theobald Wolfe Tone, the Mother of the Maccabees, the Last of the Mohicans, the Rose of Castile, the Man for Galway, The Man that Broke the Bank at Monte Carlo, The Man in the Gap, The Woman Who Didn’t, Benjamin Franklin, Napoleon Bonaparte, John L. Sullivan, Cleopatra, Savourneen Deelish, Julius Caesar, Paracelsus, sir Thomas Lipton, William Tell, Michelangelo Hayes, Muhammad, the Bride of Lammermoor, Peter the Hermit, Peter the Packer, Dark Rosaleen, Patrick W. Shakespeare, Brian Confucius, Murtagh Gutenberg, Patricio Velasquez, Captain Nemo, Tristan and Isolde, the first Prince of Wales, Thomas Cook and Son, the Bold Soldier Boy, Arrah na Pogue, Dick Turpin, Ludwig Beethoven, the Colleen Bawn, Waddler Healy, Angus the Culdee, Dolly Mount, Sidney Parade, Ben Howth, Valentine Greatrakes, Adam and Eve, Arthur Wellesley, Boss Croker, Herodotus, Jack the Giantkiller, Gautama Buddha, Lady Godiva, The Lily of Killarney, Balor of the Evil Eye, the Queen of Sheba, Acky Nagle, Joe Nagle, Alessandro Volta, Jeremiah O’Donovan Rossa, Don Philip O’Sullivan Beare. A couched spear of acuminated granite rested by him while at his feet reposed a savage animal of the canine tribe whose stertorous gasps announced that he was sunk in uneasy slumber, a supposition confirmed by hoarse growls and spasmodic movements which his master repressed from time to time by tranquilising blows of a mighty cudgel rudely fashioned out of paleolithic stone.

So anyhow Terry brought the three pints Joe was standing and begob the sight nearly left my eyes when I saw him land out a quid. O, as true as I’m telling you. A goodlooking sovereign.

—And there’s more where that came from, says he.

—Were you robbing the poorbox, Joe? says I.

—Sweat of my brow, says Joe. ’Twas the prudent member gave me the wheeze.

—I saw him before I met you, says I, sloping around by Pill lane and Greek street with his cod’s eye counting up all the guts of the fish.

Who comes through Michan’s land, bedight in sable armour? O’Bloom, the son of Rory: it is he. Impervious to fear is Rory’s son: he of the prudent soul.

—For the old woman of Prince’s street, says the citizen, the subsidised organ. The pledgebound party on the floor of the house. And look at this blasted rag, says he. Look at this, says he. The Irish Independent, if you please, founded by Parnell to be the workingman’s friend. Listen to the births and deaths in the Irish all for Ireland Independent, and I’ll thank you and the marriages.

And he starts reading them out:

—Gordon, Barnfield crescent, Exeter; Redmayne of Iffley, Saint Anne’s on Sea: the wife of William T Redmayne of a son. How’s that, eh? Wright and Flint, Vincent and Gillett to Rotha Marion daughter of Rosa and the late George Alfred Gillett, 179 Clapham road, Stockwell, Playwood and Ridsdale at Saint Jude’s, Kensington by the very reverend Dr Forrest, dean of Worcester. Eh? Deaths. Bristow, at Whitehall lane, London: Carr, Stoke Newington, of gastritis and heart disease: Cockburn, at the Moat house, Chepstow...

—I know that fellow, says Joe, from bitter experience.

—Cockburn. Dimsey, wife of David Dimsey, late of the admiralty: Miller, Tottenham, aged eightyfive: Welsh, June 12, at 35 Canning street, Liverpool, Isabella Helen. How’s that for a national press, eh, my brown son! How’s that for Martin Murphy, the Bantry jobber?

—Ah, well, says Joe, handing round the boose. Thanks be to God they had the start of us. Drink that, citizen.

—I will, says he, honourable person.

—Health, Joe, says I. And all down the form.

Ah! Ow! Don’t be talking! I was blue mouldy for the want of that pint. Declare to God I could hear it hit the pit of my stomach with a click.

And lo, as they quaffed their cup of joy, a godlike messenger came swiftly in, radiant as the eye of heaven, a comely youth and behind him there passed an elder of noble gait and countenance, bearing the sacred scrolls of law and with him his lady wife a dame of peerless lineage, fairest of her race.

Little Alf Bergan popped in round the door and hid behind Barney’s snug, squeezed up with the laughing. And who was sitting up there in the corner that I hadn’t seen snoring drunk blind to the world only Bob Doran. I didn’t know what was up and Alf kept making signs out of the door. And begob what was it only that bloody old pantaloon Denis Breen in his bathslippers with two bloody big books tucked under his oxter and the wife hotfoot after him, unfortunate wretched woman, trotting like a poodle. I thought Alf would split.

—Look at him, says he. Breen. He’s traipsing all round Dublin with a postcard someone sent him with U. p: up on it to take a li...

And he doubled up.

—Take a what? says I.

—Libel action, says he, for ten thousand pounds.

—O hell! says I.

The bloody mongrel began to growl that’d put the fear of God in you seeing something was up but the citizen gave him a kick in the ribs.

—Bi i dho husht, says he.

—Who? says Joe.

—Breen, says Alf. He was in John Henry Menton’s and then he went round to Collis and Ward’s and then Tom Rochford met him and sent him round to the subsheriff’s for a lark. O God, I’ve a pain laughing. U. p: up. The long fellow gave him an eye as good as a process and now the bloody old lunatic is gone round to Green street to look for a G man.

—When is long John going to hang that fellow in Mountjoy? says Joe.

—Bergan, says Bob Doran, waking up. Is that Alf Bergan?

—Yes, says Alf. Hanging? Wait till I show you. Here, Terry, give us a pony. That bloody old fool! Ten thousand pounds. You should have seen long John’s eye. U. p ....

And he started laughing.

—Who are you laughing at? says Bob Doran. Is that Bergan?

—Hurry up, Terry boy, says Alf.

Terence O’Ryan heard him and straightway brought him a crystal cup full of the foamy ebon ale which the noble twin brothers Bungiveagh and Bungardilaun brew ever in their divine alevats, cunning as the sons of deathless Leda. For they garner the succulent berries of the hop and mass and sift and bruise and brew them and they mix therewith sour juices and bring the must to the sacred fire and cease not night or day from their toil, those cunning brothers, lords of the vat.

Then did you, chivalrous Terence, hand forth, as to the manner born, that nectarous beverage and you offered the crystal cup to him that thirsted, the soul of chivalry, in beauty akin to the immortals.

But he, the young chief of the O’Bergan’s, could ill brook to be outdone in generous deeds but gave therefor with gracious gesture a testoon of costliest bronze. Thereon embossed in excellent smithwork was seen the image of a queen of regal port, scion of the house of Brunswick, Victoria her name, Her Most Excellent Majesty, by grace of God of the United Kingdom of Great Britain and Ireland and of the British dominions beyond the sea, queen, defender of the faith, Empress of India, even she, who bore rule, a victress over many peoples, the wellbeloved, for they knew and loved her from the rising of the sun to the going down thereof, the pale, the dark, the ruddy and the ethiop.

—What’s that bloody freemason doing, says the citizen, prowling up and down outside?

—What’s that? says Joe.

—Here you are, says Alf, chucking out the rhino. Talking about hanging, I’ll show you something you never saw. Hangmen’s letters. Look at here.

So he took a bundle of wisps of letters and envelopes out of his pocket.

—Are you codding? says I.

—Honest injun, says Alf. Read them.

So Joe took up the letters.

—Who are you laughing at? says Bob Doran.

So I saw there was going to be a bit of a dust. Bob’s a queer chap when the porter’s up in him so says I just to make talk:

—How’s Willy Murray those times, Alf?

—I don’t know, says Alf. I saw him just now in Capel street with Paddy Dignam. Only I was running after that...

—You what? says Joe, throwing down the letters. With who?

—With Dignam, says Alf.

—Is it Paddy? says Joe.

—Yes, says Alf. Why?

—Don’t you know he’s dead? says Joe.

—Paddy Dignam dead! says Alf.

—Ay, says Joe.

—Sure I’m after seeing him not five minutes ago, says Alf, as plain as a pikestaff.

—Who’s dead? says Bob Doran.

—You saw his ghost then, says Joe, God between us and harm.

—What? says Alf. Good Christ, only five... What?... And Willy Murray with him, the two of them there near whatdoyoucallhim’s... What? Dignam dead?

—What about Dignam? says Bob Doran. Who’s talking about...?

—Dead! says Alf. He’s no more dead than you are.

—Maybe so, says Joe. They took the liberty of burying him this morning anyhow.

—Paddy? says Alf.

—Ay, says Joe. He paid the debt of nature, God be merciful to him.

—Good Christ! says Alf.

Begob he was what you might call flabbergasted.

In the darkness spirit hands were felt to flutter and when prayer by tantras had been directed to the proper quarter a faint but increasing luminosity of ruby light became gradually visible, the apparition of the etheric double being particularly lifelike owing to the discharge of jivic rays from the crown of the head and face. Communication was effected through the pituitary body and also by means of the orangefiery and scarlet rays emanating from the sacral region and solar plexus. Questioned by his earthname as to his whereabouts in the heavenworld he stated that he was now on the path of prālāyā or return but was still submitted to trial at the hands of certain bloodthirsty entities on the lower astral levels. In reply to a question as to his first sensations in the great divide beyond he stated that previously he had seen as in a glass darkly but that those who had passed over had summit possibilities of atmic development opened up to them. Interrogated as to whether life there resembled our experience in the flesh he stated that he had heard from more favoured beings now in the spirit that their abodes were equipped with every modern home comfort such as tālāfānā, ālāvātār, hātākāldā, wātāklāsāt and that the highest adepts were steeped in waves of volupcy of the very purest nature. Having requested a quart of buttermilk this was brought and evidently afforded relief. Asked if he had any message for the living he exhorted all who were still at the wrong side of Māyā to acknowledge the true path for it was reported in devanic circles that Mars and Jupiter were out for mischief on the eastern angle where the ram has power. It was then queried whether there were any special desires on the part of the defunct and the reply was: We greet you, friends of earth, who are still in the body. Mind C. K. doesn’t pile it on. It was ascertained that the reference was to Mr Cornelius Kelleher, manager of Messrs H. J. O’Neill’s popular funeral establishment, a personal friend of the defunct, who had been responsible for the carrying out of the interment arrangements. Before departing he requested that it should be told to his dear son Patsy that the other boot which he had been looking for was at present under the commode in the return room and that the pair should be sent to Cullen’s to be soled only as the heels were still good. He stated that this had greatly perturbed his peace of mind in the other region and earnestly requested that his desire should be made known.

Assurances were given that the matter would be attended to and it was intimated that this had given satisfaction.

He is gone from mortal haunts: O’Dignam, sun of our morning. Fleet was his foot on the bracken: Patrick of the beamy brow. Wail, Banba, with your wind: and wail, O ocean, with your whirlwind.

—There he is again, says the citizen, staring out.

—Who? says I.

—Bloom, says he. He’s on point duty up and down there for the last ten minutes.

And, begob, I saw his physog do a peep in and then slidder off again.

Little Alf was knocked bawways. Faith, he was.

—Good Christ! says he. I could have sworn it was him.

And says Bob Doran, with the hat on the back of his poll, lowest blackguard in Dublin when he’s under the influence:

—Who said Christ is good?

—I beg your parsnips, says Alf.

—Is that a good Christ, says Bob Doran, to take away poor little Willy Dignam?

—Ah, well, says Alf, trying to pass it off. He’s over all his troubles.

But Bob Doran shouts out of him.

—He’s a bloody ruffian, I say, to take away poor little Willy Dignam.

Terry came down and tipped him the wink to keep quiet, that they didn’t want that kind of talk in a respectable licensed premises. And Bob Doran starts doing the weeps about Paddy Dignam, true as you’re there.

—The finest man, says he, snivelling, the finest purest character.

The tear is bloody near your eye. Talking through his bloody hat. Fitter for him go home to the little sleepwalking bitch he married, Mooney, the bumbailiff’s daughter, mother kept a kip in Hardwicke street, that used to be stravaging about the landings Bantam Lyons told me that was stopping there at two in the morning without a stitch on her, exposing her person, open to all comers, fair field and no favour.

—The noblest, the truest, says he. And he’s gone, poor little Willy, poor little Paddy Dignam.

And mournful and with a heavy heart he bewept the extinction of that beam of heaven.

Old Garryowen started growling again at Bloom that was skeezing round the door.

—Come in, come on, he won’t eat you, says the citizen.

So Bloom slopes in with his cod’s eye on the dog and he asks Terry was Martin Cunningham there.

—O, Christ M’Keown, says Joe, reading one of the letters. Listen to this, will you?

And he starts reading out one.

7 Hunter Street,
Liverpool.

To the High Sheriff of Dublin,
            Dublin.

Honoured sir i beg to offer my services in the abovementioned painful case i hanged Joe Gann in Bootle jail on the 12 of Febuary 1900 and i hanged...

—Show us, Joe, says I.

—... private Arthur Chace for fowl murder of Jessie Tilsit in Pentonville prison and i was assistant when...

—Jesus, says I.

—... Billington executed the awful murderer Toad Smith...

The citizen made a grab at the letter.

—Hold hard, says Joe, i have a special nack of putting the noose once in he can’t get out hoping to be favoured i remain, honoured sir, my terms is five ginnees.

H. Rumbold,
            Master Barber.

—And a barbarous bloody barbarian he is too, says the citizen.

—And the dirty scrawl of the wretch, says Joe. Here, says he, take them to hell out of my sight, Alf. Hello, Bloom, says he, what will you have?

So they started arguing about the point, Bloom saying he wouldn’t and he couldn’t and excuse him no offence and all to that and then he said well he’d just take a cigar. Gob, he’s a prudent member and no mistake.

—Give us one of your prime stinkers, Terry, says Joe.

And Alf was telling us there was one chap sent in a mourning card with a black border round it.

—They’re all barbers, says he, from the black country that would hang their own fathers for five quid down and travelling expenses.

And he was telling us there’s two fellows waiting below to pull his heels down when he gets the drop and choke him properly and then they chop up the rope after and sell the bits for a few bob a skull.

In the dark land they bide, the vengeful knights of the razor. Their deadly coil they grasp: yea, and therein they lead to Erebus whatsoever wight hath done a deed of blood for I will on nowise suffer it even so saith the Lord.

So they started talking about capital punishment and of course Bloom comes out with the why and the wherefore and all the codology of the business and the old dog smelling him all the time I’m told those jewies does have a sort of a queer odour coming off them for dogs about I don’t know what all deterrent effect and so forth and so on.

—There’s one thing it hasn’t a deterrent effect on, says Alf.

—What’s that? says Joe.

—The poor bugger’s tool that’s being hanged, says Alf.

—That so? says Joe.

—God’s truth, says Alf. I heard that from the head warder that was in Kilmainham when they hanged Joe Brady, the invincible. He told me when they cut him down after the drop it was standing up in their faces like a poker.

—Ruling passion strong in death, says Joe, as someone said.

—That can be explained by science, says Bloom. It’s only a natural phenomenon, don’t you see, because on account of the...

And then he starts with his jawbreakers about phenomenon and science and this phenomenon and the other phenomenon.

The distinguished scientist Herr Professor Luitpold Blumenduft tendered medical evidence to the effect that the instantaneous fracture of the cervical vertebrae and consequent scission of the spinal cord would, according to the best approved tradition of medical science, be calculated to inevitably produce in the human subject a violent ganglionic stimulus of the nerve centres of the genital apparatus, thereby causing the elastic pores of the corpora cavernosa to rapidly dilate in such a way as to instantaneously facilitate the flow of blood to that part of the human anatomy known as the penis or male organ resulting in the phenomenon which has been denominated by the faculty a morbid upwards and outwards philoprogenitive erection in articulo mortis per diminutionem capitis.

So of course the citizen was only waiting for the wink of the word and he starts gassing out of him about the invincibles and the old guard and the men of sixtyseven and who fears to speak of ninetyeight and Joe with him about all the fellows that were hanged, drawn and transported for the cause by drumhead courtmartial and a new Ireland and new this, that and the other. Talking about new Ireland he ought to go and get a new dog so he ought. Mangy ravenous brute sniffing and sneezing all round the place and scratching his scabs. And round he goes to Bob Doran that was standing Alf a half one sucking up for what he could get. So of course Bob Doran starts doing the bloody fool with him:

—Give us the paw! Give the paw, doggy! Good old doggy! Give the paw here! Give us the paw!

Arrah, bloody end to the paw he’d paw and Alf trying to keep him from tumbling off the bloody stool atop of the bloody old dog and he talking all kinds of drivel about training by kindness and thoroughbred dog and intelligent dog: give you the bloody pip. Then he starts scraping a few bits of old biscuit out of the bottom of a Jacobs’ tin he told Terry to bring. Gob, he golloped it down like old boots and his tongue hanging out of him a yard long for more. Near ate the tin and all, hungry bloody mongrel.

And the citizen and Bloom having an argument about the point, the brothers Sheares and Wolfe Tone beyond on Arbour Hill and Robert Emmet and die for your country, the Tommy Moore touch about Sara Curran and she’s far from the land. And Bloom, of course, with his knockmedown cigar putting on swank with his lardy face. Phenomenon! The fat heap he married is a nice old phenomenon with a back on her like a ballalley. Time they were stopping up in the City Arms pisser Burke told me there was an old one there with a cracked loodheramaun of a nephew and Bloom trying to get the soft side of her doing the mollycoddle playing bézique to come in for a bit of the wampum in her will and not eating meat of a Friday because the old one was always thumping her craw and taking the lout out for a walk. And one time he led him the rounds of Dublin and, by the holy farmer, he never cried crack till he brought him home as drunk as a boiled owl and he said he did it to teach him the evils of alcohol and by herrings, if the three women didn’t near roast him, it’s a queer story, the old one, Bloom’s wife and Mrs O’Dowd that kept the hotel. Jesus, I had to laugh at pisser Burke taking them off chewing the fat. And Bloom with his but don’t you see? and but on the other hand. And sure, more be token, the lout I’m told was in Power’s after, the blender’s, round in Cope street going home footless in a cab five times in the week after drinking his way through all the samples in the bloody establishment. Phenomenon!

—The memory of the dead, says the citizen taking up his pintglass and glaring at Bloom.

—Ay, ay, says Joe.

—You don’t grasp my point, says Bloom. What I mean is...

—Sinn Fein! says the citizen. Sinn Fein amhain! The friends we love are by our side and the foes we hate before us.

The last farewell was affecting in the extreme. From the belfries far and near the funereal deathbell tolled unceasingly while all around the gloomy precincts rolled the ominous warning of a hundred muffled drums punctuated by the hollow booming of pieces of ordnance. The deafening claps of thunder and the dazzling flashes of lightning which lit up the ghastly scene testified that the artillery of heaven had lent its supernatural pomp to the already gruesome spectacle. A torrential rain poured down from the floodgates of the angry heavens upon the bared heads of the assembled multitude which numbered at the lowest computation five hundred thousand persons. A posse of Dublin Metropolitan police superintended by the Chief Commissioner in person maintained order in the vast throng for whom the York street brass and reed band whiled away the intervening time by admirably rendering on their blackdraped instruments the matchless melody endeared to us from the cradle by Speranza’s plaintive muse. Special quick excursion trains and upholstered charabancs had been provided for the comfort of our country cousins of whom there were large contingents. Considerable amusement was caused by the favourite Dublin streetsingers L-n-h-n and M-ll-g-n who sang The Night before Larry was stretched in their usual mirth-provoking fashion. Our two inimitable drolls did a roaring trade with their broadsheets among lovers of the comedy element and nobody who has a corner in his heart for real Irish fun without vulgarity will grudge them their hardearned pennies. The children of the Male and Female Foundling Hospital who thronged the windows overlooking the scene were delighted with this unexpected addition to the day’s entertainment and a word of praise is due to the Little Sisters of the Poor for their excellent idea of affording the poor fatherless and motherless children a genuinely instructive treat. The viceregal houseparty which included many wellknown ladies was chaperoned by Their Excellencies to the most favourable positions on the grandstand while the picturesque foreign delegation known as the Friends of the Emerald Isle was accommodated on a tribune directly opposite. The delegation, present in full force, consisted of Commendatore Bacibaci Beninobenone (the semiparalysed doyen of the party who had to be assisted to his seat by the aid of a powerful steam crane), Monsieur Pierrepaul Petitépatant, the Grandjoker Vladinmire Pokethankertscheff, the Archjoker Leopold Rudolph von Schwanzenbad-Hodenthaler, Countess Marha Virága Kisászony Putrápesthi, Hiram Y. Bomboost, Count Athanatos Karamelopulos, Ali Baba Backsheesh Rahat Lokum Effendi, Señor Hidalgo Caballero Don Pecadillo y Palabras y Paternoster de la Malora de la Malaria, Hokopoko Harakiri, Hi Hung Chang, Olaf Kobberkeddelsen, Mynheer Trik van Trumps, Pan Poleaxe Paddyrisky, Goosepond Prhklstr Kratchinabritchisitch, Borus Hupinkoff, Herr Hurhausdirektorpresident Hans Chuechli-Steuerli, Nationalgymnasiummuseumsanatoriumandsuspensoriumsordinaryprivatdocentgeneralhistoryspecialprofessordoctor Kriegfried Ueberallgemein. All the delegates without exception expressed themselves in the strongest possible heterogeneous terms concerning the nameless barbarity which they had been called upon to witness. An animated altercation (in which all took part) ensued among the F. O. T. E. I. as to whether the eighth or the ninth of March was the correct date of the birth of Ireland’s patron saint. In the course of the argument cannonballs, scimitars, boomerangs, blunderbusses, stinkpots, meatchoppers, umbrellas, catapults, knuckledusters, sandbags, lumps of pig iron were resorted to and blows were freely exchanged. The baby policeman, Constable MacFadden, summoned by special courier from Booterstown, quickly restored order and with lightning promptitude proposed the seventeenth of the month as a solution equally honourable for both contending parties. The readywitted ninefooter’s suggestion at once appealed to all and was unanimously accepted. Constable MacFadden was heartily congratulated by all the F. O. T. E. I., several of whom were bleeding profusely. Commendatore Beninobenone having been extricated from underneath the presidential armchair, it was explained by his legal adviser Avvocato Pagamimi that the various articles secreted in his thirtytwo pockets had been abstracted by him during the affray from the pockets of his junior colleagues in the hope of bringing them to their senses. The objects (which included several hundred ladies’ and gentlemen’s gold and silver watches) were promptly restored to their rightful owners and general harmony reigned supreme.

Quietly, unassumingly Rumbold stepped on to the scaffold in faultless morning dress and wearing his favourite flower, the Gladiolus Cruentus. He announced his presence by that gentle Rumboldian cough which so many have tried (unsuccessfully) to imitate—short, painstaking yet withal so characteristic of the man. The arrival of the worldrenowned headsman was greeted by a roar of acclamation from the huge concourse, the viceregal ladies waving their handkerchiefs in their excitement while the even more excitable foreign delegates cheered vociferously in a medley of cries, hoch, banzai, eljen, zivio, chinchin, polla kronia, hiphip, vive, Allah, amid which the ringing evviva of the delegate of the land of song (a high double F recalling those piercingly lovely notes with which the eunuch Catalani beglamoured our greatgreatgrandmothers) was easily distinguishable. It was exactly seventeen o’clock. The signal for prayer was then promptly given by megaphone and in an instant all heads were bared, the commendatore’s patriarchal sombrero, which has been in the possession of his family since the revolution of Rienzi, being removed by his medical adviser in attendance, Dr Pippi. The learned prelate who administered the last comforts of holy religion to the hero martyr when about to pay the death penalty knelt in a most christian spirit in a pool of rainwater, his cassock above his hoary head, and offered up to the throne of grace fervent prayers of supplication. Hard by the block stood the grim figure of the executioner, his visage being concealed in a tengallon pot with two circular perforated apertures through which his eyes glowered furiously. As he awaited the fatal signal he tested the edge of his horrible weapon by honing it upon his brawny forearm or decapitated in rapid succession a flock of sheep which had been provided by the admirers of his fell but necessary office. On a handsome mahogany table near him were neatly arranged the quartering knife, the various finely tempered disembowelling appliances (specially supplied by the worldfamous firm of cutlers, Messrs John Round and Sons, Sheffield), a terra cotta saucepan for the reception of the duodenum, colon, blind intestine and appendix etc when successfully extracted and two commodious milkjugs destined to receive the most precious blood of the most precious victim. The housesteward of the amalgamated cats’ and dogs’ home was in attendance to convey these vessels when replenished to that beneficent institution. Quite an excellent repast consisting of rashers and eggs, fried steak and onions, done to a nicety, delicious hot breakfast rolls and invigorating tea had been considerately provided by the authorities for the consumption of the central figure of the tragedy who was in capital spirits when prepared for death and evinced the keenest interest in the proceedings from beginning to end but he, with an abnegation rare in these our times, rose nobly to the occasion and expressed the dying wish (immediately acceded to) that the meal should be divided in aliquot parts among the members of the sick and indigent roomkeepers’ association as a token of his regard and esteem. The nec and non plus ultra of emotion were reached when the blushing bride elect burst her way through the serried ranks of the bystanders and flung herself upon the muscular bosom of him who was about to be launched into eternity for her sake. The hero folded her willowy form in a loving embrace murmuring fondly Sheila, my own. Encouraged by this use of her christian name she kissed passionately all the various suitable areas of his person which the decencies of prison garb permitted her ardour to reach. She swore to him as they mingled the salt streams of their tears that she would ever cherish his memory, that she would never forget her hero boy who went to his death with a song on his lips as if he were but going to a hurling match in Clonturk park. She brought back to his recollection the happy days of blissful childhood together on the banks of Anna Liffey when they had indulged in the innocent pastimes of the young and, oblivious of the dreadful present, they both laughed heartily, all the spectators, including the venerable pastor, joining in the general merriment. That monster audience simply rocked with delight. But anon they were overcome with grief and clasped their hands for the last time. A fresh torrent of tears burst from their lachrymal ducts and the vast concourse of people, touched to the inmost core, broke into heartrending sobs, not the least affected being the aged prebendary himself. Big strong men, officers of the peace and genial giants of the royal Irish constabulary, were making frank use of their handkerchiefs and it is safe to say that there was not a dry eye in that record assemblage. A most romantic incident occurred when a handsome young Oxford graduate, noted for his chivalry towards the fair sex, stepped forward and, presenting his visiting card, bankbook and genealogical tree, solicited the hand of the hapless young lady, requesting her to name the day, and was accepted on the spot. Every lady in the audience was presented with a tasteful souvenir of the occasion in the shape of a skull and crossbones brooch, a timely and generous act which evoked a fresh outburst of emotion: and when the gallant young Oxonian (the bearer, by the way, of one of the most timehonoured names in Albion’s history) placed on the finger of his blushing fiancée an expensive engagement ring with emeralds set in the form of a fourleaved shamrock the excitement knew no bounds. Nay, even the stern provostmarshal, lieutenantcolonel Tomkin-Maxwell ffrenchmullan Tomlinson, who presided on the sad occasion, he who had blown a considerable number of sepoys from the cannonmouth without flinching, could not now restrain his natural emotion. With his mailed gauntlet he brushed away a furtive tear and was overheard, by those privileged burghers who happened to be in his immediate entourage, to murmur to himself in a faltering undertone:

—God blimey if she aint a clinker, that there bleeding tart. Blimey it makes me kind of bleeding cry, straight, it does, when I sees her cause I thinks of my old mashtub what’s waiting for me down Limehouse way.

So then the citizen begins talking about the Irish language and the corporation meeting and all to that and the shoneens that can’t speak their own language and Joe chipping in because he stuck someone for a quid and Bloom putting in his old goo with his twopenny stump that he cadged off of Joe and talking about the Gaelic league and the antitreating league and drink, the curse of Ireland. Antitreating is about the size of it. Gob, he’d let you pour all manner of drink down his throat till the Lord would call him before you’d ever see the froth of his pint. And one night I went in with a fellow into one of their musical evenings, song and dance about she could get up on a truss of hay she could my Maureen Lay and there was a fellow with a Ballyhooly blue ribbon badge spiffing out of him in Irish and a lot of colleen bawns going about with temperance beverages and selling medals and oranges and lemonade and a few old dry buns, gob, flahoolagh entertainment, don’t be talking. Ireland sober is Ireland free. And then an old fellow starts blowing into his bagpipes and all the gougers shuffling their feet to the tune the old cow died of. And one or two sky pilots having an eye around that there was no goings on with the females, hitting below the belt.

So howandever, as I was saying, the old dog seeing the tin was empty starts mousing around by Joe and me. I’d train him by kindness, so I would, if he was my dog. Give him a rousing fine kick now and again where it wouldn’t blind him.

—Afraid he’ll bite you? says the citizen, jeering.

—No, says I. But he might take my leg for a lamppost.

So he calls the old dog over.

—What’s on you, Garry? says he.

Then he starts hauling and mauling and talking to him in Irish and the old towser growling, letting on to answer, like a duet in the opera. Such growling you never heard as they let off between them. Someone that has nothing better to do ought to write a letter pro bono publico to the papers about the muzzling order for a dog the like of that. Growling and grousing and his eye all bloodshot from the drouth is in it and the hydrophobia dropping out of his jaws.

All those who are interested in the spread of human culture among the lower animals (and their name is legion) should make a point of not missing the really marvellous exhibition of cynanthropy given by the famous old Irish red setter wolfdog formerly known by the sobriquet of Garryowen and recently rechristened by his large circle of friends and acquaintances Owen Garry. The exhibition, which is the result of years of training by kindness and a carefully thoughtout dietary system, comprises, among other achievements, the recitation of verse. Our greatest living phonetic expert (wild horses shall not drag it from us!) has left no stone unturned in his efforts to delucidate and compare the verse recited and has found it bears a striking resemblance (the italics are ours) to the ranns of ancient Celtic bards. We are not speaking so much of those delightful lovesongs with which the writer who conceals his identity under the graceful pseudonym of the Little Sweet Branch has familiarised the bookloving world but rather (as a contributor D. O. C. points out in an interesting communication published by an evening contemporary) of the harsher and more personal note which is found in the satirical effusions of the famous Raftery and of Donal MacConsidine to say nothing of a more modern lyrist at present very much in the public eye. We subjoin a specimen which has been rendered into English by an eminent scholar whose name for the moment we are not at liberty to disclose though we believe that our readers will find the topical allusion rather more than an indication. The metrical system of the canine original, which recalls the intricate alliterative and isosyllabic rules of the Welsh englyn, is infinitely more complicated but we believe our readers will agree that the spirit has been well caught. Perhaps it should be added that the effect is greatly increased if Owen’s verse be spoken somewhat slowly and indistinctly in a tone suggestive of suppressed rancour.

The curse of my curses
Seven days every day
And seven dry Thursdays
On you, Barney Kiernan,
Has no sup of water
To cool my courage,
And my guts red roaring
After Lowry’s lights.

So he told Terry to bring some water for the dog and, gob, you could hear him lapping it up a mile off. And Joe asked him would he have another.

—I will, says he, a chara, to show there’s no ill feeling.

Gob, he’s not as green as he’s cabbagelooking. Arsing around from one pub to another, leaving it to your own honour, with old Giltrap’s dog and getting fed up by the ratepayers and corporators. Entertainment for man and beast. And says Joe:

—Could you make a hole in another pint?

—Could a swim duck? says I.

—Same again, Terry, says Joe. Are you sure you won’t have anything in the way of liquid refreshment? says he.

—Thank you, no, says Bloom. As a matter of fact I just wanted to meet Martin Cunningham, don’t you see, about this insurance of poor Dignam’s. Martin asked me to go to the house. You see, he, Dignam, I mean, didn’t serve any notice of the assignment on the company at the time and nominally under the act the mortgagee can’t recover on the policy.

—Holy Wars, says Joe, laughing, that’s a good one if old Shylock is landed. So the wife comes out top dog, what?

—Well, that’s a point, says Bloom, for the wife’s admirers.

—Whose admirers? says Joe.

—The wife’s advisers, I mean, says Bloom.

Then he starts all confused mucking it up about mortgagor under the act like the lord chancellor giving it out on the bench and for the benefit of the wife and that a trust is created but on the other hand that Dignam owed Bridgeman the money and if now the wife or the widow contested the mortgagee’s right till he near had the head of me addled with his mortgagor under the act. He was bloody safe he wasn’t run in himself under the act that time as a rogue and vagabond only he had a friend in court. Selling bazaar tickets or what do you call it royal Hungarian privileged lottery. True as you’re there. O, commend me to an israelite! Royal and privileged Hungarian robbery.

So Bob Doran comes lurching around asking Bloom to tell Mrs Dignam he was sorry for her trouble and he was very sorry about the funeral and to tell her that he said and everyone who knew him said that there was never a truer, a finer than poor little Willy that’s dead to tell her. Choking with bloody foolery. And shaking Bloom’s hand doing the tragic to tell her that. Shake hands, brother. You’re a rogue and I’m another.

—Let me, said he, so far presume upon our acquaintance which, however slight it may appear if judged by the standard of mere time, is founded, as I hope and believe, on a sentiment of mutual esteem as to request of you this favour. But, should I have overstepped the limits of reserve let the sincerity of my feelings be the excuse for my boldness.

—No, rejoined the other, I appreciate to the full the motives which actuate your conduct and I shall discharge the office you entrust to me consoled by the reflection that, though the errand be one of sorrow, this proof of your confidence sweetens in some measure the bitterness of the cup.

—Then suffer me to take your hand, said he. The goodness of your heart, I feel sure, will dictate to you better than my inadequate words the expressions which are most suitable to convey an emotion whose poignancy, were I to give vent to my feelings, would deprive me even of speech.

And off with him and out trying to walk straight. Boosed at five o’clock. Night he was near being lagged only Paddy Leonard knew the bobby, 14A. Blind to the world up in a shebeen in Bride street after closing time, fornicating with two shawls and a bully on guard, drinking porter out of teacups. And calling himself a Frenchy for the shawls, Joseph Manuo, and talking against the Catholic religion, and he serving mass in Adam and Eve’s when he was young with his eyes shut, who wrote the new testament, and the old testament, and hugging and smugging. And the two shawls killed with the laughing, picking his pockets, the bloody fool and he spilling the porter all over the bed and the two shawls screeching laughing at one another. How is your testament? Have you got an old testament? Only Paddy was passing there, I tell you what. Then see him of a Sunday with his little concubine of a wife, and she wagging her tail up the aisle of the chapel with her patent boots on her, no less, and her violets, nice as pie, doing the little lady. Jack Mooney’s sister. And the old prostitute of a mother procuring rooms to street couples. Gob, Jack made him toe the line. Told him if he didn’t patch up the pot, Jesus, he’d kick the shite out of him.

So Terry brought the three pints.

—Here, says Joe, doing the honours. Here, citizen.

—Slan leat, says he.

—Fortune, Joe, says I. Good health, citizen.

Gob, he had his mouth half way down the tumbler already. Want a small fortune to keep him in drinks.

—Who is the long fellow running for the mayoralty, Alf? says Joe.

—Friend of yours, says Alf.

—Nannan? says Joe. The mimber?

—I won’t mention any names, says Alf.

—I thought so, says Joe. I saw him up at that meeting now with William Field, M. P., the cattle traders.

—Hairy Iopas, says the citizen, that exploded volcano, the darling of all countries and the idol of his own.

So Joe starts telling the citizen about the foot and mouth disease and the cattle traders and taking action in the matter and the citizen sending them all to the rightabout and Bloom coming out with his sheepdip for the scab and a hoose drench for coughing calves and the guaranteed remedy for timber tongue. Because he was up one time in a knacker’s yard. Walking about with his book and pencil here’s my head and my heels are coming till Joe Cuffe gave him the order of the boot for giving lip to a grazier. Mister Knowall. Teach your grandmother how to milk ducks. Pisser Burke was telling me in the hotel the wife used to be in rivers of tears some times with Mrs O’Dowd crying her eyes out with her eight inches of fat all over her. Couldn’t loosen her farting strings but old cod’s eye was waltzing around her showing her how to do it. What’s your programme today? Ay. Humane methods. Because the poor animals suffer and experts say and the best known remedy that doesn’t cause pain to the animal and on the sore spot administer gently. Gob, he’d have a soft hand under a hen.

Ga Ga Gara. Klook Klook Klook. Black Liz is our hen. She lays eggs for us. When she lays her egg she is so glad. Gara. Klook Klook Klook. Then comes good uncle Leo. He puts his hand under black Liz and takes her fresh egg. Ga ga ga ga Gara. Klook Klook Klook.

—Anyhow, says Joe, Field and Nannetti are going over tonight to London to ask about it on the floor of the house of commons.

—Are you sure, says Bloom, the councillor is going? I wanted to see him, as it happens.

—Well, he’s going off by the mailboat, says Joe, tonight.

—That’s too bad, says Bloom. I wanted particularly. Perhaps only Mr Field is going. I couldn’t phone. No. You’re sure?

—Nannan’s going too, says Joe. The league told him to ask a question tomorrow about the commissioner of police forbidding Irish games in the park. What do you think of that, citizen? The Sluagh na h-Eireann.

Mr Cowe Conacre (Multifarnham. Nat.): Arising out of the question of my honourable friend, the member for Shillelagh, may I ask the right honourable gentleman whether the government has issued orders that these animals shall be slaughtered though no medical evidence is forthcoming as to their pathological condition?

Mr Allfours (Tamoshant. Con.): Honourable members are already in possession of the evidence produced before a committee of the whole house. I feel I cannot usefully add anything to that. The answer to the honourable member’s question is in the affirmative.

Mr Orelli O’Reilly (Montenotte. Nat.): Have similar orders been issued for the slaughter of human animals who dare to play Irish games in the Phoenix park?

Mr Allfours: The answer is in the negative.

Mr Cowe Conacre: Has the right honourable gentleman’s famous Mitchelstown telegram inspired the policy of gentlemen on the Treasury bench? (O! O!)

Mr Allfours: I must have notice of that question.

Mr Staylewit (Buncombe. Ind.): Don’t hesitate to shoot.

(Ironical opposition cheers.)

The speaker: Order! Order!

(The house rises. Cheers.)

—There’s the man, says Joe, that made the Gaelic sports revival. There he is sitting there. The man that got away James Stephens. The champion of all Ireland at putting the sixteen pound shot. What was your best throw, citizen?

—Na bacleis, says the citizen, letting on to be modest. There was a time I was as good as the next fellow anyhow.

—Put it there, citizen, says Joe. You were and a bloody sight better.

—Is that really a fact? says Alf.

—Yes, says Bloom. That’s well known. Did you not know that?

So off they started about Irish sports and shoneen games the like of lawn tennis and about hurley and putting the stone and racy of the soil and building up a nation once again and all to that. And of course Bloom had to have his say too about if a fellow had a rower’s heart violent exercise was bad. I declare to my antimacassar if you took up a straw from the bloody floor and if you said to Bloom: Look at, Bloom. Do you see that straw? That’s a straw. Declare to my aunt he’d talk about it for an hour so he would and talk steady.

A most interesting discussion took place in the ancient hall of Brian O’Ciarnain’s in Sraid na Bretaine Bheag, under the auspices of Sluagh na h-Eireann, on the revival of ancient Gaelic sports and the importance of physical culture, as understood in ancient Greece and ancient Rome and ancient Ireland, for the development of the race. The venerable president of the noble order was in the chair and the attendance was of large dimensions. After an instructive discourse by the chairman, a magnificent oration eloquently and forcibly expressed, a most interesting and instructive discussion of the usual high standard of excellence ensued as to the desirability of the revivability of the ancient games and sports of our ancient Panceltic forefathers. The wellknown and highly respected worker in the cause of our old tongue, Mr Joseph M’Carthy Hynes, made an eloquent appeal for the resuscitation of the ancient Gaelic sports and pastimes, practised morning and evening by Finn MacCool, as calculated to revive the best traditions of manly strength and prowess handed down to us from ancient ages. L. Bloom, who met with a mixed reception of applause and hisses, having espoused the negative the vocalist chairman brought the discussion to a close, in response to repeated requests and hearty plaudits from all parts of a bumper house, by a remarkably noteworthy rendering of the immortal Thomas Osborne Davis’ evergreen verses (happily too familiar to need recalling here) A nation once again in the execution of which the veteran patriot champion may be said without fear of contradiction to have fairly excelled himself. The Irish Caruso-Garibaldi was in superlative form and his stentorian notes were heard to the greatest advantage in the timehonoured anthem sung as only our citizen can sing it. His superb highclass vocalism, which by its superquality greatly enhanced his already international reputation, was vociferously applauded by the large audience among which were to be noticed many prominent members of the clergy as well as representatives of the press and the bar and the other learned professions. The proceedings then terminated.

Amongst the clergy present were the very rev. William Delany, S. J., L. L. D.; the rt rev. Gerald Molloy, D. D.; the rev. P. J. Kavanagh, C. S. Sp.; the rev. T. Waters, C. C.; the rev. John M. Ivers, P. P.; the rev. P. J. Cleary, O. S. F.; the rev. L. J. Hickey, O. P.; the very rev. Fr. Nicholas, O. S. F. C.; the very rev. B. Gorman, O. D. C.; the rev. T. Maher, S. J.; the very rev. James Murphy, S. J.; the rev. John Lavery, V. F.; the very rev. William Doherty, D. D.; the rev. Peter Fagan, O. M.; the rev. T. Brangan, O. S. A.; the rev. J. Flavin, C. C.; the rev. M. A. Hackett, C. C.; the rev. W. Hurley, C. C.; the rt rev. Mgr M’Manus, V. G.; the rev. B. R. Slattery, O. M. I.; the very rev. M. D. Scally, P. P.; the rev. F. T. Purcell, O. P.; the very rev. Timothy canon Gorman, P. P.; the rev. J. Flanagan, C. C. The laity included P. Fay, T. Quirke, etc., etc.

—Talking about violent exercise, says Alf, were you at that Keogh-Bennett match?

—No, says Joe.

—I heard So and So made a cool hundred quid over it, says Alf.

—Who? Blazes? says Joe.

And says Bloom:

—What I meant about tennis, for example, is the agility and training the eye.

—Ay, Blazes, says Alf. He let out that Myler was on the beer to run up the odds and he swatting all the time.

—We know him, says the citizen. The traitor’s son. We know what put English gold in his pocket.

—True for you, says Joe.

And Bloom cuts in again about lawn tennis and the circulation of the blood, asking Alf:

—Now, don’t you think, Bergan?

—Myler dusted the floor with him, says Alf. Heenan and Sayers was only a bloody fool to it. Handed him the father and mother of a beating. See the little kipper not up to his navel and the big fellow swiping. God, he gave him one last puck in the wind, Queensberry rules and all, made him puke what he never ate.

It was a historic and a hefty battle when Myler and Percy were scheduled to don the gloves for the purse of fifty sovereigns. Handicapped as he was by lack of poundage, Dublin’s pet lamb made up for it by superlative skill in ringcraft. The final bout of fireworks was a gruelling for both champions. The welterweight sergeantmajor had tapped some lively claret in the previous mixup during which Keogh had been receivergeneral of rights and lefts, the artilleryman putting in some neat work on the pet’s nose, and Myler came on looking groggy. The soldier got to business, leading off with a powerful left jab to which the Irish gladiator retaliated by shooting out a stiff one flush to the point of Bennett’s jaw. The redcoat ducked but the Dubliner lifted him with a left hook, the body punch being a fine one. The men came to handigrips. Myler quickly became busy and got his man under, the bout ending with the bulkier man on the ropes, Myler punishing him. The Englishman, whose right eye was nearly closed, took his corner where he was liberally drenched with water and when the bell went came on gamey and brimful of pluck, confident of knocking out the fistic Eblanite in jigtime. It was a fight to a finish and the best man for it. The two fought like tigers and excitement ran fever high. The referee twice cautioned Pucking Percy for holding but the pet was tricky and his footwork a treat to watch. After a brisk exchange of courtesies during which a smart upper cut of the military man brought blood freely from his opponent’s mouth the lamb suddenly waded in all over his man and landed a terrific left to Battling Bennett’s stomach, flooring him flat. It was a knockout clean and clever. Amid tense expectation the Portobello bruiser was being counted out when Bennett’s second Ole Pfotts Wettstein threw in the towel and the Santry boy was declared victor to the frenzied cheers of the public who broke through the ringropes and fairly mobbed him with delight.

—He knows which side his bread is buttered, says Alf. I hear he’s running a concert tour now up in the north.

—He is, says Joe. Isn’t he?

—Who? says Bloom. Ah, yes. That’s quite true. Yes, a kind of summer tour, you see. Just a holiday.

—Mrs B. is the bright particular star, isn’t she? says Joe.

—My wife? says Bloom. She’s singing, yes. I think it will be a success too. He’s an excellent man to organise. Excellent.

Hoho begob says I to myself says I. That explains the milk in the cocoanut and absence of hair on the animal’s chest. Blazes doing the tootle on the flute. Concert tour. Dirty Dan the dodger’s son off Island bridge that sold the same horses twice over to the government to fight the Boers. Old Whatwhat. I called about the poor and water rate, Mr Boylan. You what? The water rate, Mr Boylan. You whatwhat? That’s the bucko that’ll organise her, take my tip. ’Twixt me and you Caddareesh.

Pride of Calpe’s rocky mount, the ravenhaired daughter of Tweedy. There grew she to peerless beauty where loquat and almond scent the air. The gardens of Alameda knew her step: the garths of olives knew and bowed. The chaste spouse of Leopold is she: Marion of the bountiful bosoms.

And lo, there entered one of the clan of the O’Molloy’s, a comely hero of white face yet withal somewhat ruddy, his majesty’s counsel learned in the law, and with him the prince and heir of the noble line of Lambert.

—Hello, Ned.

—Hello, Alf.

—Hello, Jack.

—Hello, Joe.

—God save you, says the citizen.

—Save you kindly, says J. J. What’ll it be, Ned?

—Half one, says Ned.

So J. J. ordered the drinks.

—Were you round at the court? says Joe.

—Yes, says J. J. He’ll square that, Ned, says he.

—Hope so, says Ned.

Now what were those two at? J. J. getting him off the grand jury list and the other give him a leg over the stile. With his name in Stubbs’s. Playing cards, hobnobbing with flash toffs with a swank glass in their eye, adrinking fizz and he half smothered in writs and garnishee orders. Pawning his gold watch in Cummins of Francis street where no-one would know him in the private office when I was there with Pisser releasing his boots out of the pop. What’s your name, sir? Dunne, says he. Ay, and done says I. Gob, he’ll come home by weeping cross one of those days, I’m thinking.

—Did you see that bloody lunatic Breen round there? says Alf. U. p: up.

—Yes, says J. J. Looking for a private detective.

—Ay, says Ned. And he wanted right go wrong to address the court only Corny Kelleher got round him telling him to get the handwriting examined first.

—Ten thousand pounds, says Alf, laughing. God, I’d give anything to hear him before a judge and jury.

—Was it you did it, Alf? says Joe. The truth, the whole truth and nothing but the truth, so help you Jimmy Johnson.

—Me? says Alf. Don’t cast your nasturtiums on my character.

—Whatever statement you make, says Joe, will be taken down in evidence against you.

—Of course an action would lie, says J. J. It implies that he is not compos mentis. U. p: up.

—Compos your eye! says Alf, laughing. Do you know that he’s balmy? Look at his head. Do you know that some mornings he has to get his hat on with a shoehorn.

—Yes, says J. J., but the truth of a libel is no defence to an indictment for publishing it in the eyes of the law.

—Ha ha, Alf, says Joe.

—Still, says Bloom, on account of the poor woman, I mean his wife.

—Pity about her, says the citizen. Or any other woman marries a half and half.

—How half and half? says Bloom. Do you mean he...

—Half and half I mean, says the citizen. A fellow that’s neither fish nor flesh.

—Nor good red herring, says Joe.

—That what’s I mean, says the citizen. A pishogue, if you know what that is.

Begob I saw there was trouble coming. And Bloom explaining he meant on account of it being cruel for the wife having to go round after the old stuttering fool. Cruelty to animals so it is to let that bloody povertystricken Breen out on grass with his beard out tripping him, bringing down the rain. And she with her nose cockahoop after she married him because a cousin of his old fellow’s was pewopener to the pope. Picture of him on the wall with his Smashall Sweeney’s moustaches, the signior Brini from Summerhill, the eyetallyano, papal Zouave to the Holy Father, has left the quay and gone to Moss street. And who was he, tell us? A nobody, two pair back and passages, at seven shillings a week, and he covered with all kinds of breastplates bidding defiance to the world.

—And moreover, says J. J., a postcard is publication. It was held to be sufficient evidence of malice in the testcase Sadgrove v. Hole. In my opinion an action might lie.

Six and eightpence, please. Who wants your opinion? Let us drink our pints in peace. Gob, we won’t be let even do that much itself.

—Well, good health, Jack, says Ned.

—Good health, Ned, says J. J.

—-There he is again, says Joe.

—Where? says Alf.

And begob there he was passing the door with his books under his oxter and the wife beside him and Corny Kelleher with his wall eye looking in as they went past, talking to him like a father, trying to sell him a secondhand coffin.

—How did that Canada swindle case go off? says Joe.

—Remanded, says J. J.

One of the bottlenosed fraternity it was went by the name of James Wought alias Saphiro alias Spark and Spiro, put an ad in the papers saying he’d give a passage to Canada for twenty bob. What? Do you see any green in the white of my eye? Course it was a bloody barney. What? Swindled them all, skivvies and badhachs from the county Meath, ay, and his own kidney too. J. J. was telling us there was an ancient Hebrew Zaretsky or something weeping in the witnessbox with his hat on him, swearing by the holy Moses he was stuck for two quid.

—Who tried the case? says Joe.

—Recorder, says Ned.

—Poor old sir Frederick, says Alf, you can cod him up to the two eyes.

—Heart as big as a lion, says Ned. Tell him a tale of woe about arrears of rent and a sick wife and a squad of kids and, faith, he’ll dissolve in tears on the bench.

—Ay, says Alf. Reuben J was bloody lucky he didn’t clap him in the dock the other day for suing poor little Gumley that’s minding stones, for the corporation there near Butt bridge.

And he starts taking off the old recorder letting on to cry:

—A most scandalous thing! This poor hardworking man! How many children? Ten, did you say?

—Yes, your worship. And my wife has the typhoid.

—And the wife with typhoid fever! Scandalous! Leave the court immediately, sir. No, sir, I’ll make no order for payment. How dare you, sir, come up before me and ask me to make an order! A poor hardworking industrious man! I dismiss the case.

And whereas on the sixteenth day of the month of the oxeyed goddess and in the third week after the feastday of the Holy and Undivided Trinity, the daughter of the skies, the virgin moon being then in her first quarter, it came to pass that those learned judges repaired them to the halls of law. There master Courtenay, sitting in his own chamber, gave his rede and master Justice Andrews, sitting without a jury in the probate court, weighed well and pondered the claim of the first chargeant upon the property in the matter of the will propounded and final testamentary disposition in re the real and personal estate of the late lamented Jacob Halliday, vintner, deceased, versus Livingstone, an infant, of unsound mind, and another. And to the solemn court of Green street there came sir Frederick the Falconer. And he sat him there about the hour of five o’clock to administer the law of the brehons at the commission for all that and those parts to be holden in and for the county of the city of Dublin. And there sat with him the high sinhedrim of the twelve tribes of Iar, for every tribe one man, of the tribe of Patrick and of the tribe of Hugh and of the tribe of Owen and of the tribe of Conn and of the tribe of Oscar and of the tribe of Fergus and of the tribe of Finn and of the tribe of Dermot and of the tribe of Cormac and of the tribe of Kevin and of the tribe of Caolte and of the tribe of Ossian, there being in all twelve good men and true. And he conjured them by Him who died on rood that they should well and truly try and true deliverance make in the issue joined between their sovereign lord the king and the prisoner at the bar and true verdict give according to the evidence so help them God and kiss the book. And they rose in their seats, those twelve of Iar, and they swore by the name of Him Who is from everlasting that they would do His rightwiseness. And straightway the minions of the law led forth from their donjon keep one whom the sleuthhounds of justice had apprehended in consequence of information received. And they shackled him hand and foot and would take of him ne bail ne mainprise but preferred a charge against him for he was a malefactor.

—Those are nice things, says the citizen, coming over here to Ireland filling the country with bugs.

So Bloom lets on he heard nothing and he starts talking with Joe, telling him he needn’t trouble about that little matter till the first but if he would just say a word to Mr Crawford. And so Joe swore high and holy by this and by that he’d do the devil and all.

—Because, you see, says Bloom, for an advertisement you must have repetition. That’s the whole secret.

—Rely on me, says Joe.

—Swindling the peasants, says the citizen, and the poor of Ireland. We want no more strangers in our house.

—O, I’m sure that will be all right, Hynes, says Bloom. It’s just that Keyes, you see.

—Consider that done, says Joe.

—Very kind of you, says Bloom.

—The strangers, says the citizen. Our own fault. We let them come in. We brought them in. The adulteress and her paramour brought the Saxon robbers here.

—Decree nisi, says J. J.

And Bloom letting on to be awfully deeply interested in nothing, a spider’s web in the corner behind the barrel, and the citizen scowling after him and the old dog at his feet looking up to know who to bite and when.

—A dishonoured wife, says the citizen, that’s what’s the cause of all our misfortunes.

—And here she is, says Alf, that was giggling over the Police Gazette with Terry on the counter, in all her warpaint.

—Give us a squint at her, says I.

And what was it only one of the smutty yankee pictures Terry borrows off of Corny Kelleher. Secrets for enlarging your private parts. Misconduct of society belle. Norman W. Tupper, wealthy Chicago contractor, finds pretty but faithless wife in lap of officer Taylor. Belle in her bloomers misconducting herself, and her fancyman feeling for her tickles and Norman W. Tupper bouncing in with his peashooter just in time to be late after she doing the trick of the loop with officer Taylor.

—O jakers, Jenny, says Joe, how short your shirt is!

—There’s hair, Joe, says I. Get a queer old tailend of corned beef off of that one, what?

So anyhow in came John Wyse Nolan and Lenehan with him with a face on him as long as a late breakfast.

—Well, says the citizen, what’s the latest from the scene of action? What did those tinkers in the city hall at their caucus meeting decide about the Irish language?

O’Nolan, clad in shining armour, low bending made obeisance to the puissant and high and mighty chief of all Erin and did him to wit of that which had befallen, how that the grave elders of the most obedient city, second of the realm, had met them in the tholsel, and there, after due prayers to the gods who dwell in ether supernal, had taken solemn counsel whereby they might, if so be it might be, bring once more into honour among mortal men the winged speech of the seadivided Gael.

—It’s on the march, says the citizen. To hell with the bloody brutal Sassenachs and their patois.

So J. J. puts in a word, doing the toff about one story was good till you heard another and blinking facts and the Nelson policy, putting your blind eye to the telescope and drawing up a bill of attainder to impeach a nation, and Bloom trying to back him up moderation and botheration and their colonies and their civilisation.

—Their syphilisation, you mean, says the citizen. To hell with them! The curse of a goodfornothing God light sideways on the bloody thicklugged sons of whores’ gets! No music and no art and no literature worthy of the name. Any civilisation they have they stole from us. Tonguetied sons of bastards’ ghosts.

—The European family, says J. J....

—They’re not European, says the citizen. I was in Europe with Kevin Egan of Paris. You wouldn’t see a trace of them or their language anywhere in Europe except in a cabinet d’aisance.

And says John Wyse:

—Full many a flower is born to blush unseen.

And says Lenehan that knows a bit of the lingo:

—Conspuez les Anglais! Perfide Albion!

He said and then lifted he in his rude great brawny strengthy hands the medher of dark strong foamy ale and, uttering his tribal slogan Lamh Dearg Abu, he drank to the undoing of his foes, a race of mighty valorous heroes, rulers of the waves, who sit on thrones of alabaster silent as the deathless gods.

—What’s up with you, says I to Lenehan. You look like a fellow that had lost a bob and found a tanner.

—Gold cup, says he.

—Who won, Mr Lenehan? says Terry.

—Throwaway, says he, at twenty to one. A rank outsider. And the rest nowhere.

—And Bass’s mare? says Terry.

—Still running, says he. We’re all in a cart. Boylan plunged two quid on my tip Sceptre for himself and a lady friend.

—I had half a crown myself, says Terry, on Zinfandel that Mr Flynn gave me. Lord Howard de Walden’s.

—Twenty to one, says Lenehan. Such is life in an outhouse. Throwaway, says he. Takes the biscuit, and talking about bunions. Frailty, thy name is Sceptre.

So he went over to the biscuit tin Bob Doran left to see if there was anything he could lift on the nod, the old cur after him backing his luck with his mangy snout up. Old Mother Hubbard went to the cupboard.

—Not there, my child, says he.

—Keep your pecker up, says Joe. She’d have won the money only for the other dog.

And J. J. and the citizen arguing about law and history with Bloom sticking in an odd word.

—Some people, says Bloom, can see the mote in others’ eyes but they can’t see the beam in their own.

—Raimeis, says the citizen. There’s no-one as blind as the fellow that won’t see, if you know what that means. Where are our missing twenty millions of Irish should be here today instead of four, our lost tribes? And our potteries and textiles, the finest in the whole world! And our wool that was sold in Rome in the time of Juvenal and our flax and our damask from the looms of Antrim and our Limerick lace, our tanneries and our white flint glass down there by Ballybough and our Huguenot poplin that we have since Jacquard de Lyon and our woven silk and our Foxford tweeds and ivory raised point from the Carmelite convent in New Ross, nothing like it in the whole wide world. Where are the Greek merchants that came through the pillars of Hercules, the Gibraltar now grabbed by the foe of mankind, with gold and Tyrian purple to sell in Wexford at the fair of Carmen? Read Tacitus and Ptolemy, even Giraldus Cambrensis. Wine, peltries, Connemara marble, silver from Tipperary, second to none, our farfamed horses even today, the Irish hobbies, with king Philip of Spain offering to pay customs duties for the right to fish in our waters. What do the yellowjohns of Anglia owe us for our ruined trade and our ruined hearths? And the beds of the Barrow and Shannon they won’t deepen with millions of acres of marsh and bog to make us all die of consumption?

—As treeless as Portugal we’ll be soon, says John Wyse, or Heligoland with its one tree if something is not done to reafforest the land. Larches, firs, all the trees of the conifer family are going fast. I was reading a report of lord Castletown’s...

—Save them, says the citizen, the giant ash of Galway and the chieftain elm of Kildare with a fortyfoot bole and an acre of foliage. Save the trees of Ireland for the future men of Ireland on the fair hills of Eire, O.

—Europe has its eyes on you, says Lenehan.

The fashionable international world attended en masse this afternoon at the wedding of the chevalier Jean Wyse de Neaulan, grand high chief ranger of the Irish National Foresters, with Miss Fir Conifer of Pine Valley. Lady Sylvester Elmshade, Mrs Barbara Lovebirch, Mrs Poll Ash, Mrs Holly Hazeleyes, Miss Daphne Bays, Miss Dorothy Canebrake, Mrs Clyde Twelvetrees, Mrs Rowan Greene, Mrs Helen Vinegadding, Miss Virginia Creeper, Miss Gladys Beech, Miss Olive Garth, Miss Blanche Maple, Mrs Maud Mahogany, Miss Myra Myrtle, Miss Priscilla Elderflower, Miss Bee Honeysuckle, Miss Grace Poplar, Miss O Mimosa San, Miss Rachel Cedarfrond, the Misses Lilian and Viola Lilac, Miss Timidity Aspenall, Mrs Kitty Dewey-Mosse, Miss May Hawthorne, Mrs Gloriana Palme, Mrs Liana Forrest, Mrs Arabella Blackwood and Mrs Norma Holyoake of Oakholme Regis graced the ceremony by their presence. The bride who was given away by her father, the M’Conifer of the Glands, looked exquisitely charming in a creation carried out in green mercerised silk, moulded on an underslip of gloaming grey, sashed with a yoke of broad emerald and finished with a triple flounce of darkerhued fringe, the scheme being relieved by bretelles and hip insertions of acorn bronze. The maids of honour, Miss Larch Conifer and Miss Spruce Conifer, sisters of the bride, wore very becoming costumes in the same tone, a dainty motif of plume rose being worked into the pleats in a pinstripe and repeated capriciously in the jadegreen toques in the form of heron feathers of paletinted coral. Senhor Enrique Flor presided at the organ with his wellknown ability and, in addition to the prescribed numbers of the nuptial mass, played a new and striking arrangement of Woodman, spare that tree at the conclusion of the service. On leaving the church of Saint Fiacre in Horto after the papal blessing the happy pair were subjected to a playful crossfire of hazelnuts, beechmast, bayleaves, catkins of willow, ivytod, hollyberries, mistletoe sprigs and quicken shoots. Mr and Mrs Wyse Conifer Neaulan will spend a quiet honeymoon in the Black Forest.

—And our eyes are on Europe, says the citizen. We had our trade with Spain and the French and with the Flemings before those mongrels were pupped, Spanish ale in Galway, the winebark on the winedark waterway.

—And will again, says Joe.

—And with the help of the holy mother of God we will again, says the citizen, clapping his thigh. Our harbours that are empty will be full again, Queenstown, Kinsale, Galway, Blacksod Bay, Ventry in the kingdom of Kerry, Killybegs, the third largest harbour in the wide world with a fleet of masts of the Galway Lynches and the Cavan O’Reillys and the O’Kennedys of Dublin when the earl of Desmond could make a treaty with the emperor Charles the Fifth himself. And will again, says he, when the first Irish battleship is seen breasting the waves with our own flag to the fore, none of your Henry Tudor’s harps, no, the oldest flag afloat, the flag of the province of Desmond and Thomond, three crowns on a blue field, the three sons of Milesius.

And he took the last swig out of the pint. Moya. All wind and piss like a tanyard cat. Cows in Connacht have long horns. As much as his bloody life is worth to go down and address his tall talk to the assembled multitude in Shanagolden where he daren’t show his nose with the Molly Maguires looking for him to let daylight through him for grabbing the holding of an evicted tenant.

—Hear, hear to that, says John Wyse. What will you have?

—An imperial yeomanry, says Lenehan, to celebrate the occasion.

—Half one, Terry, says John Wyse, and a hands up. Terry! Are you asleep?

—Yes, sir, says Terry. Small whisky and bottle of Allsop. Right, sir.

Hanging over the bloody paper with Alf looking for spicy bits instead of attending to the general public. Picture of a butting match, trying to crack their bloody skulls, one chap going for the other with his head down like a bull at a gate. And another one: Black Beast Burned in Omaha, Ga. A lot of Deadwood Dicks in slouch hats and they firing at a Sambo strung up in a tree with his tongue out and a bonfire under him. Gob, they ought to drown him in the sea after and electrocute and crucify him to make sure of their job.

—But what about the fighting navy, says Ned, that keeps our foes at bay?

—I’ll tell you what about it, says the citizen. Hell upon earth it is. Read the revelations that’s going on in the papers about flogging on the training ships at Portsmouth. A fellow writes that calls himself Disgusted One.

So he starts telling us about corporal punishment and about the crew of tars and officers and rearadmirals drawn up in cocked hats and the parson with his protestant bible to witness punishment and a young lad brought out, howling for his ma, and they tie him down on the buttend of a gun.

—A rump and dozen, says the citizen, was what that old ruffian sir John Beresford called it but the modern God’s Englishman calls it caning on the breech.

And says John Wyse:

—’Tis a custom more honoured in the breach than in the observance.

Then he was telling us the master at arms comes along with a long cane and he draws out and he flogs the bloody backside off of the poor lad till he yells meila murder.

—That’s your glorious British navy, says the citizen, that bosses the earth. The fellows that never will be slaves, with the only hereditary chamber on the face of God’s earth and their land in the hands of a dozen gamehogs and cottonball barons. That’s the great empire they boast about of drudges and whipped serfs.

—On which the sun never rises, says Joe.

—And the tragedy of it is, says the citizen, they believe it. The unfortunate yahoos believe it.

They believe in rod, the scourger almighty, creator of hell upon earth, and in Jacky Tar, the son of a gun, who was conceived of unholy boast, born of the fighting navy, suffered under rump and dozen, was scarified, flayed and curried, yelled like bloody hell, the third day he arose again from the bed, steered into haven, sitteth on his beamend till further orders whence he shall come to drudge for a living and be paid.

—But, says Bloom, isn’t discipline the same everywhere. I mean wouldn’t it be the same here if you put force against force?

Didn’t I tell you? As true as I’m drinking this porter if he was at his last gasp he’d try to downface you that dying was living.

—We’ll put force against force, says the citizen. We have our greater Ireland beyond the sea. They were driven out of house and home in the black 47. Their mudcabins and their shielings by the roadside were laid low by the batteringram and the Times rubbed its hands and told the whitelivered Saxons there would soon be as few Irish in Ireland as redskins in America. Even the Grand Turk sent us his piastres. But the Sassenach tried to starve the nation at home while the land was full of crops that the British hyenas bought and sold in Rio de Janeiro. Ay, they drove out the peasants in hordes. Twenty thousand of them died in the coffinships. But those that came to the land of the free remember the land of bondage. And they will come again and with a vengeance, no cravens, the sons of Granuaile, the champions of Kathleen ni Houlihan.

—Perfectly true, says Bloom. But my point was...

—We are a long time waiting for that day, citizen, says Ned. Since the poor old woman told us that the French were on the sea and landed at Killala.

—Ay, says John Wyse. We fought for the royal Stuarts that reneged us against the Williamites and they betrayed us. Remember Limerick and the broken treatystone. We gave our best blood to France and Spain, the wild geese. Fontenoy, eh? And Sarsfield and O’Donnell, duke of Tetuan in Spain, and Ulysses Browne of Camus that was fieldmarshal to Maria Teresa. But what did we ever get for it?

—The French! says the citizen. Set of dancing masters! Do you know what it is? They were never worth a roasted fart to Ireland. Aren’t they trying to make an Entente cordiale now at Tay Pay’s dinnerparty with perfidious Albion? Firebrands of Europe and they always were.

—Conspuez les Français, says Lenehan, nobbling his beer.

—And as for the Prooshians and the Hanoverians, says Joe, haven’t we had enough of those sausageeating bastards on the throne from George the elector down to the German lad and the flatulent old bitch that’s dead?

Jesus, I had to laugh at the way he came out with that about the old one with the winkers on her, blind drunk in her royal palace every night of God, old Vic, with her jorum of mountain dew and her coachman carting her up body and bones to roll into bed and she pulling him by the whiskers and singing him old bits of songs about Ehren on the Rhine and come where the boose is cheaper.

—Well, says J. J. We have Edward the peacemaker now.

—Tell that to a fool, says the citizen. There’s a bloody sight more pox than pax about that boyo. Edward Guelph-Wettin!

—And what do you think, says Joe, of the holy boys, the priests and bishops of Ireland doing up his room in Maynooth in His Satanic Majesty’s racing colours and sticking up pictures of all the horses his jockeys rode. The earl of Dublin, no less.

—They ought to have stuck up all the women he rode himself, says little Alf.

And says J. J.:

—Considerations of space influenced their lordships’ decision.

—Will you try another, citizen? says Joe.

—Yes, sir, says he. I will.

—You? says Joe.

—Beholden to you, Joe, says I. May your shadow never grow less.

—Repeat that dose, says Joe.

Bloom was talking and talking with John Wyse and he quite excited with his dunducketymudcoloured mug on him and his old plumeyes rolling about.

—Persecution, says he, all the history of the world is full of it. Perpetuating national hatred among nations.

—But do you know what a nation means? says John Wyse.

—Yes, says Bloom.

—What is it? says John Wyse.

—A nation? says Bloom. A nation is the same people living in the same place.

—By God, then, says Ned, laughing, if that’s so I’m a nation for I’m living in the same place for the past five years.

So of course everyone had the laugh at Bloom and says he, trying to muck out of it:

—Or also living in different places.

—That covers my case, says Joe.

—What is your nation if I may ask? says the citizen.

—Ireland, says Bloom. I was born here. Ireland.

The citizen said nothing only cleared the spit out of his gullet and, gob, he spat a Red bank oyster out of him right in the corner.

—After you with the push, Joe, says he, taking out his handkerchief to swab himself dry.

—Here you are, citizen, says Joe. Take that in your right hand and repeat after me the following words.

The muchtreasured and intricately embroidered ancient Irish facecloth attributed to Solomon of Droma and Manus Tomaltach og MacDonogh, authors of the Book of Ballymote, was then carefully produced and called forth prolonged admiration. No need to dwell on the legendary beauty of the cornerpieces, the acme of art, wherein one can distinctly discern each of the four evangelists in turn presenting to each of the four masters his evangelical symbol, a bogoak sceptre, a North American puma (a far nobler king of beasts than the British article, be it said in passing), a Kerry calf and a golden eagle from Carrantuohill. The scenes depicted on the emunctory field, showing our ancient duns and raths and cromlechs and grianauns and seats of learning and maledictive stones, are as wonderfully beautiful and the pigments as delicate as when the Sligo illuminators gave free rein to their artistic fantasy long long ago in the time of the Barmecides. Glendalough, the lovely lakes of Killarney, the ruins of Clonmacnois, Cong Abbey, Glen Inagh and the Twelve Pins, Ireland’s Eye, the Green Hills of Tallaght, Croagh Patrick, the brewery of Messrs Arthur Guinness, Son and Company (Limited), Lough Neagh’s banks, the vale of Ovoca, Isolde’s tower, the Mapas obelisk, Sir Patrick Dun’s hospital, Cape Clear, the glen of Aherlow, Lynch’s castle, the Scotch house, Rathdown Union Workhouse at Loughlinstown, Tullamore jail, Castleconnel rapids, Kilballymacshonakill, the cross at Monasterboice, Jury’s Hotel, S. Patrick’s Purgatory, the Salmon Leap, Maynooth college refectory, Curley’s hole, the three birthplaces of the first duke of Wellington, the rock of Cashel, the bog of Allen, the Henry Street Warehouse, Fingal’s Cave—all these moving scenes are still there for us today rendered more beautiful still by the waters of sorrow which have passed over them and by the rich incrustations of time.

—Show us over the drink, says I. Which is which?

—That’s mine, says Joe, as the devil said to the dead policeman.

—And I belong to a race too, says Bloom, that is hated and persecuted. Also now. This very moment. This very instant.

Gob, he near burnt his fingers with the butt of his old cigar.

—Robbed, says he. Plundered. Insulted. Persecuted. Taking what belongs to us by right. At this very moment, says he, putting up his fist, sold by auction in Morocco like slaves or cattle.

—Are you talking about the new Jerusalem? says the citizen.

—I’m talking about injustice, says Bloom.

—Right, says John Wyse. Stand up to it then with force like men.

That’s an almanac picture for you. Mark for a softnosed bullet. Old lardyface standing up to the business end of a gun. Gob, he’d adorn a sweepingbrush, so he would, if he only had a nurse’s apron on him. And then he collapses all of a sudden, twisting around all the opposite, as limp as a wet rag.

—But it’s no use, says he. Force, hatred, history, all that. That’s not life for men and women, insult and hatred. And everybody knows that it’s the very opposite of that that is really life.

—What? says Alf.

—Love, says Bloom. I mean the opposite of hatred. I must go now, says he to John Wyse. Just round to the court a moment to see if Martin is there. If he comes just say I’ll be back in a second. Just a moment.

Who’s hindering you? And off he pops like greased lightning.

—A new apostle to the gentiles, says the citizen. Universal love.

—Well, says John Wyse. Isn’t that what we’re told. Love your neighbour.

—That chap? says the citizen. Beggar my neighbour is his motto. Love, moya! He’s a nice pattern of a Romeo and Juliet.

Love loves to love love. Nurse loves the new chemist. Constable 14A loves Mary Kelly. Gerty MacDowell loves the boy that has the bicycle. M. B. loves a fair gentleman. Li Chi Han lovey up kissy Cha Pu Chow. Jumbo, the elephant, loves Alice, the elephant. Old Mr Verschoyle with the ear trumpet loves old Mrs Verschoyle with the turnedin eye. The man in the brown macintosh loves a lady who is dead. His Majesty the King loves Her Majesty the Queen. Mrs Norman W. Tupper loves officer Taylor. You love a certain person. And this person loves that other person because everybody loves somebody but God loves everybody.

—Well, Joe, says I, your very good health and song. More power, citizen.

—Hurrah, there, says Joe.

—The blessing of God and Mary and Patrick on you, says the citizen.

And he ups with his pint to wet his whistle.

—We know those canters, says he, preaching and picking your pocket. What about sanctimonious Cromwell and his ironsides that put the women and children of Drogheda to the sword with the bible text God is love pasted round the mouth of his cannon? The bible! Did you read that skit in the United Irishman today about that Zulu chief that’s visiting England?

—What’s that? says Joe.

So the citizen takes up one of his paraphernalia papers and he starts reading out:

—A delegation of the chief cotton magnates of Manchester was presented yesterday to His Majesty the Alaki of Abeakuta by Gold Stick in Waiting, Lord Walkup of Walkup on Eggs, to tender to His Majesty the heartfelt thanks of British traders for the facilities afforded them in his dominions. The delegation partook of luncheon at the conclusion of which the dusky potentate, in the course of a happy speech, freely translated by the British chaplain, the reverend Ananias Praisegod Barebones, tendered his best thanks to Massa Walkup and emphasised the cordial relations existing between Abeakuta and the British empire, stating that he treasured as one of his dearest possessions an illuminated bible, the volume of the word of God and the secret of England’s greatness, graciously presented to him by the white chief woman, the great squaw Victoria, with a personal dedication from the august hand of the Royal Donor. The Alaki then drank a lovingcup of firstshot usquebaugh to the toast Black and White from the skull of his immediate predecessor in the dynasty Kakachakachak, surnamed Forty Warts, after which he visited the chief factory of Cottonopolis and signed his mark in the visitors’ book, subsequently executing a charming old Abeakutic wardance, in the course of which he swallowed several knives and forks, amid hilarious applause from the girl hands.

—Widow woman, says Ned. I wouldn’t doubt her. Wonder did he put that bible to the same use as I would.

—Same only more so, says Lenehan. And thereafter in that fruitful land the broadleaved mango flourished exceedingly.

—Is that by Griffith? says John Wyse.

—No, says the citizen. It’s not signed Shanganagh. It’s only initialled: P.

—And a very good initial too, says Joe.

—That’s how it’s worked, says the citizen. Trade follows the flag.

—Well, says J. J., if they’re any worse than those Belgians in the Congo Free State they must be bad. Did you read that report by a man what’s this his name is?

—Casement, says the citizen. He’s an Irishman.

—Yes, that’s the man, says J. J. Raping the women and girls and flogging the natives on the belly to squeeze all the red rubber they can out of them.

—I know where he’s gone, says Lenehan, cracking his fingers.

—Who? says I.

—Bloom, says he. The courthouse is a blind. He had a few bob on Throwaway and he’s gone to gather in the shekels.

—Is it that whiteeyed kaffir? says the citizen, that never backed a horse in anger in his life?

—That’s where he’s gone, says Lenehan. I met Bantam Lyons going to back that horse only I put him off it and he told me Bloom gave him the tip. Bet you what you like he has a hundred shillings to five on. He’s the only man in Dublin has it. A dark horse.

—He’s a bloody dark horse himself, says Joe.

—Mind, Joe, says I. Show us the entrance out.

—There you are, says Terry.

Goodbye Ireland I’m going to Gort. So I just went round the back of the yard to pumpship and begob (hundred shillings to five) while I was letting off my (Throwaway twenty to) letting off my load gob says I to myself I knew he was uneasy in his (two pints off of Joe and one in Slattery’s off) in his mind to get off the mark to (hundred shillings is five quid) and when they were in the (dark horse) pisser Burke was telling me card party and letting on the child was sick (gob, must have done about a gallon) flabbyarse of a wife speaking down the tube she’s better or she’s (ow!) all a plan so he could vamoose with the pool if he won or (Jesus, full up I was) trading without a licence (ow!) Ireland my nation says he (hoik! phthook!) never be up to those bloody (there’s the last of it) Jerusalem (ah!) cuckoos.

So anyhow when I got back they were at it dingdong, John Wyse saying it was Bloom gave the ideas for Sinn Fein to Griffith to put in his paper all kinds of jerrymandering, packed juries and swindling the taxes off of the government and appointing consuls all over the world to walk about selling Irish industries. Robbing Peter to pay Paul. Gob, that puts the bloody kybosh on it if old sloppy eyes is mucking up the show. Give us a bloody chance. God save Ireland from the likes of that bloody mouseabout. Mr Bloom with his argol bargol. And his old fellow before him perpetrating frauds, old Methusalem Bloom, the robbing bagman, that poisoned himself with the prussic acid after he swamping the country with his baubles and his penny diamonds. Loans by post on easy terms. Any amount of money advanced on note of hand. Distance no object. No security. Gob, he’s like Lanty MacHale’s goat that’d go a piece of the road with every one.

—Well, it’s a fact, says John Wyse. And there’s the man now that’ll tell you all about it, Martin Cunningham.

Sure enough the castle car drove up with Martin on it and Jack Power with him and a fellow named Crofter or Crofton, pensioner out of the collector general’s, an orangeman Blackburn does have on the registration and he drawing his pay or Crawford gallivanting around the country at the king’s expense.

Our travellers reached the rustic hostelry and alighted from their palfreys.

—Ho, varlet! cried he, who by his mien seemed the leader of the party. Saucy knave! To us!

So saying he knocked loudly with his swordhilt upon the open lattice.

Mine host came forth at the summons, girding him with his tabard.

—Give you good den, my masters, said he with an obsequious bow.

—Bestir thyself, sirrah! cried he who had knocked. Look to our steeds. And for ourselves give us of your best for ifaith we need it.

—Lackaday, good masters, said the host, my poor house has but a bare larder. I know not what to offer your lordships.

—How now, fellow? cried the second of the party, a man of pleasant countenance, So servest thou the king’s messengers, master Taptun?

An instantaneous change overspread the landlord’s visage.

—Cry you mercy, gentlemen, he said humbly. An you be the king’s messengers (God shield His Majesty!) you shall not want for aught. The king’s friends (God bless His Majesty!) shall not go afasting in my house I warrant me.

—Then about! cried the traveller who had not spoken, a lusty trencherman by his aspect. Hast aught to give us?

Mine host bowed again as he made answer:

—What say you, good masters, to a squab pigeon pasty, some collops of venison, a saddle of veal, widgeon with crisp hog’s bacon, a boar’s head with pistachios, a bason of jolly custard, a medlar tansy and a flagon of old Rhenish?

—Gadzooks! cried the last speaker. That likes me well. Pistachios!

—Aha! cried he of the pleasant countenance. A poor house and a bare larder, quotha! ’Tis a merry rogue.

So in comes Martin asking where was Bloom.

—Where is he? says Lenehan. Defrauding widows and orphans.

—Isn’t that a fact, says John Wyse, what I was telling the citizen about Bloom and the Sinn Fein?

—That’s so, says Martin. Or so they allege.

—Who made those allegations? says Alf.

—I, says Joe. I’m the alligator.

—And after all, says John Wyse, why can’t a jew love his country like the next fellow?

—Why not? says J. J., when he’s quite sure which country it is.

—Is he a jew or a gentile or a holy Roman or a swaddler or what the hell is he? says Ned. Or who is he? No offence, Crofton.

—Who is Junius? says J. J.

—We don’t want him, says Crofter the Orangeman or presbyterian.

—He’s a perverted jew, says Martin, from a place in Hungary and it was he drew up all the plans according to the Hungarian system. We know that in the castle.

—Isn’t he a cousin of Bloom the dentist? says Jack Power.

—Not at all, says Martin. Only namesakes. His name was Virag, the father’s name that poisoned himself. He changed it by deedpoll, the father did.

—That’s the new Messiah for Ireland! says the citizen. Island of saints and sages!

—Well, they’re still waiting for their redeemer, says Martin. For that matter so are we.

—Yes, says J. J., and every male that’s born they think it may be their Messiah. And every jew is in a tall state of excitement, I believe, till he knows if he’s a father or a mother.

—Expecting every moment will be his next, says Lenehan.

—O, by God, says Ned, you should have seen Bloom before that son of his that died was born. I met him one day in the south city markets buying a tin of Neave’s food six weeks before the wife was delivered.

—En ventre sa mère, says J. J.

—Do you call that a man? says the citizen.

—I wonder did he ever put it out of sight, says Joe.

—Well, there were two children born anyhow, says Jack Power.

—And who does he suspect? says the citizen.

Gob, there’s many a true word spoken in jest. One of those mixed middlings he is. Lying up in the hotel Pisser was telling me once a month with headache like a totty with her courses. Do you know what I’m telling you? It’d be an act of God to take a hold of a fellow the like of that and throw him in the bloody sea. Justifiable homicide, so it would. Then sloping off with his five quid without putting up a pint of stuff like a man. Give us your blessing. Not as much as would blind your eye.

—Charity to the neighbour, says Martin. But where is he? We can’t wait.

—A wolf in sheep’s clothing, says the citizen. That’s what he is. Virag from Hungary! Ahasuerus I call him. Cursed by God.

—Have you time for a brief libation, Martin? says Ned.

—Only one, says Martin. We must be quick. J. J. and S.

—You, Jack? Crofton? Three half ones, Terry.

—Saint Patrick would want to land again at Ballykinlar and convert us, says the citizen, after allowing things like that to contaminate our shores.

—Well, says Martin, rapping for his glass. God bless all here is my prayer.

—Amen, says the citizen.

—And I’m sure He will, says Joe.

And at the sound of the sacring bell, headed by a crucifer with acolytes, thurifers, boatbearers, readers, ostiarii, deacons and subdeacons, the blessed company drew nigh of mitred abbots and priors and guardians and monks and friars: the monks of Benedict of Spoleto, Carthusians and Camaldolesi, Cistercians and Olivetans, Oratorians and Vallombrosans, and the friars of Augustine, Brigittines, Premonstratensians, Servi, Trinitarians, and the children of Peter Nolasco: and therewith from Carmel mount the children of Elijah prophet led by Albert bishop and by Teresa of Avila, calced and other: and friars, brown and grey, sons of poor Francis, capuchins, cordeliers, minimes and observants and the daughters of Clara: and the sons of Dominic, the friars preachers, and the sons of Vincent: and the monks of S. Wolstan: and Ignatius his children: and the confraternity of the christian brothers led by the reverend brother Edmund Ignatius Rice. And after came all saints and martyrs, virgins and confessors: S. Cyr and S. Isidore Arator and S. James the Less and S. Phocas of Sinope and S. Julian Hospitator and S. Felix de Cantalice and S. Simon Stylites and S. Stephen Protomartyr and S. John of God and S. Ferreol and S. Leugarde and S. Theodotus and S. Vulmar and S. Richard and S. Vincent de Paul and S. Martin of Todi and S. Martin of Tours and S. Alfred and S. Joseph and S. Denis and S. Cornelius and S. Leopold and S. Bernard and S. Terence and S. Edward and S. Owen Caniculus and S. Anonymous and S. Eponymous and S. Pseudonymous and S. Homonymous and S. Paronymous and S. Synonymous and S. Laurence O’Toole and S. James of Dingle and Compostella and S. Columcille and S. Columba and S. Celestine and S. Colman and S. Kevin and S. Brendan and S. Frigidian and S. Senan and S. Fachtna and S. Columbanus and S. Gall and S. Fursey and S. Fintan and S. Fiacre and S. John Nepomuc and S. Thomas Aquinas and S. Ives of Brittany and S. Michan and S. Herman-Joseph and the three patrons of holy youth S. Aloysius Gonzaga and S. Stanislaus Kostka and S. John Berchmans and the saints Gervasius, Servasius and Bonifacius and S. Bride and S. Kieran and S. Canice of Kilkenny and S. Jarlath of Tuam and S. Finbarr and S. Pappin of Ballymun and Brother Aloysius Pacificus and Brother Louis Bellicosus and the saints Rose of Lima and of Viterbo and S. Martha of Bethany and S. Mary of Egypt and S. Lucy and S. Brigid and S. Attracta and S. Dympna and S. Ita and S. Marion Calpensis and the Blessed Sister Teresa of the Child Jesus and S. Barbara and S. Scholastica and S. Ursula with eleven thousand virgins. And all came with nimbi and aureoles and gloriae, bearing palms and harps and swords and olive crowns, in robes whereon were woven the blessed symbols of their efficacies, inkhorns, arrows, loaves, cruses, fetters, axes, trees, bridges, babes in a bathtub, shells, wallets, shears, keys, dragons, lilies, buckshot, beards, hogs, lamps, bellows, beehives, soupladles, stars, snakes, anvils, boxes of vaseline, bells, crutches, forceps, stags’ horns, watertight boots, hawks, millstones, eyes on a dish, wax candles, aspergills, unicorns. And as they wended their way by Nelson’s Pillar, Henry street, Mary street, Capel street, Little Britain street chanting the introit in Epiphania Domini which beginneth Surge, illuminare and thereafter most sweetly the gradual Omnes which saith de Saba venient they did divers wonders such as casting out devils, raising the dead to life, multiplying fishes, healing the halt and the blind, discovering various articles which had been mislaid, interpreting and fulfilling the scriptures, blessing and prophesying. And last, beneath a canopy of cloth of gold came the reverend Father O’Flynn attended by Malachi and Patrick. And when the good fathers had reached the appointed place, the house of Bernard Kiernan and Co, limited, 8, 9 and 10 little Britain street, wholesale grocers, wine and brandy shippers, licensed for the sale of beer, wine and spirits for consumption on the premises, the celebrant blessed the house and censed the mullioned windows and the groynes and the vaults and the arrises and the capitals and the pediments and the cornices and the engrailed arches and the spires and the cupolas and sprinkled the lintels thereof with blessed water and prayed that God might bless that house as he had blessed the house of Abraham and Isaac and Jacob and make the angels of His light to inhabit therein. And entering he blessed the viands and the beverages and the company of all the blessed answered his prayers.

—Adiutorium nostrum in nomine Domini.

—Qui fecit cœlum et terram.

—Dominus vobiscum.

—Et cum spiritu tuo.

And he laid his hands upon that he blessed and gave thanks and he prayed and they all with him prayed:

—Deus, cuius verbo sanctificantur omnia, benedictionem tuam effunde super creaturas istas: et praesta ut quisquis eis secundum legem et voluntatem Tuam cum gratiarum actione usus fuerit per invocationem sanctissimi nominis Tui corporis sanitatem et animæ tutelam Te auctore percipiat per Christum Dominum nostrum.

—And so say all of us, says Jack.

—Thousand a year, Lambert, says Crofton or Crawford.

—Right, says Ned, taking up his John Jameson. And butter for fish.

I was just looking around to see who the happy thought would strike when be damned but in he comes again letting on to be in a hell of a hurry.

—I was just round at the courthouse, says he, looking for you. I hope I’m not...

—No, says Martin, we’re ready.

Courthouse my eye and your pockets hanging down with gold and silver. Mean bloody scut. Stand us a drink itself. Devil a sweet fear! There’s a jew for you! All for number one. Cute as a shithouse rat. Hundred to five.

—Don’t tell anyone, says the citizen.

—Beg your pardon, says he.

—Come on boys, says Martin, seeing it was looking blue. Come along now.

—Don’t tell anyone, says the citizen, letting a bawl out of him. It’s a secret.

And the bloody dog woke up and let a growl.

—Bye bye all, says Martin.

And he got them out as quick as he could, Jack Power and Crofton or whatever you call him and him in the middle of them letting on to be all at sea and up with them on the bloody jaunting car.

—Off with you, says Martin to the jarvey.

The milkwhite dolphin tossed his mane and, rising in the golden poop the helmsman spread the bellying sail upon the wind and stood off forward with all sail set, the spinnaker to larboard. A many comely nymphs drew nigh to starboard and to larboard and, clinging to the sides of the noble bark, they linked their shining forms as doth the cunning wheelwright when he fashions about the heart of his wheel the equidistant rays whereof each one is sister to another and he binds them all with an outer ring and giveth speed to the feet of men whenas they ride to a hosting or contend for the smile of ladies fair. Even so did they come and set them, those willing nymphs, the undying sisters. And they laughed, sporting in a circle of their foam: and the bark clave the waves.

But begob I was just lowering the heel of the pint when I saw the citizen getting up to waddle to the door, puffing and blowing with the dropsy, and he cursing the curse of Cromwell on him, bell, book and candle in Irish, spitting and spatting out of him and Joe and little Alf round him like a leprechaun trying to peacify him.

—Let me alone, says he.

And begob he got as far as the door and they holding him and he bawls out of him:

—Three cheers for Israel!

Arrah, sit down on the parliamentary side of your arse for Christ’ sake and don’t be making a public exhibition of yourself. Jesus, there’s always some bloody clown or other kicking up a bloody murder about bloody nothing. Gob, it’d turn the porter sour in your guts, so it would.

And all the ragamuffins and sluts of the nation round the door and Martin telling the jarvey to drive ahead and the citizen bawling and Alf and Joe at him to whisht and he on his high horse about the jews and the loafers calling for a speech and Jack Power trying to get him to sit down on the car and hold his bloody jaw and a loafer with a patch over his eye starts singing If the man in the moon was a jew, jew, jew and a slut shouts out of her:

—Eh, mister! Your fly is open, mister!

And says he:

—Mendelssohn was a jew and Karl Marx and Mercadante and Spinoza. And the Saviour was a jew and his father was a jew. Your God.

—He had no father, says Martin. That’ll do now. Drive ahead.

—Whose God? says the citizen.

—Well, his uncle was a jew, says he. Your God was a jew. Christ was a jew like me.

Gob, the citizen made a plunge back into the shop.

—By Jesus, says he, I’ll brain that bloody jewman for using the holy name. By Jesus, I’ll crucify him so I will. Give us that biscuitbox here.

—Stop! Stop! says Joe.

A large and appreciative gathering of friends and acquaintances from the metropolis and greater Dublin assembled in their thousands to bid farewell to Nagyaságos uram Lipóti Virag, late of Messrs Alexander Thom’s, printers to His Majesty, on the occasion of his departure for the distant clime of Százharminczbrojúgulyás-Dugulás (Meadow of Murmuring Waters). The ceremony which went off with great éclat was characterised by the most affecting cordiality. An illuminated scroll of ancient Irish vellum, the work of Irish artists, was presented to the distinguished phenomenologist on behalf of a large section of the community and was accompanied by the gift of a silver casket, tastefully executed in the style of ancient Celtic ornament, a work which reflects every credit on the makers, Messrs Jacob agus Jacob. The departing guest was the recipient of a hearty ovation, many of those who were present being visibly moved when the select orchestra of Irish pipes struck up the wellknown strains of Come Back to Erin, followed immediately by Rakóczsy’s March. Tarbarrels and bonfires were lighted along the coastline of the four seas on the summits of the Hill of Howth, Three Rock Mountain, Sugarloaf, Bray Head, the mountains of Mourne, the Galtees, the Ox and Donegal and Sperrin peaks, the Nagles and the Bograghs, the Connemara hills, the reeks of M’Gillicuddy, Slieve Aughty, Slieve Bernagh and Slieve Bloom. Amid cheers that rent the welkin, responded to by answering cheers from a big muster of henchmen on the distant Cambrian and Caledonian hills, the mastodontic pleasureship slowly moved away saluted by a final floral tribute from the representatives of the fair sex who were present in large numbers while, as it proceeded down the river, escorted by a flotilla of barges, the flags of the Ballast office and Custom House were dipped in salute as were also those of the electrical power station at the Pigeonhouse and the Poolbeg Light. Visszontlátásra, kedvés barátom! Visszontlátásra! Gone but not forgotten.

Gob, the devil wouldn’t stop him till he got hold of the bloody tin anyhow and out with him and little Alf hanging on to his elbow and he shouting like a stuck pig, as good as any bloody play in the Queen’s royal theatre:

—Where is he till I murder him?

And Ned and J. J. paralysed with the laughing.

—Bloody wars, says I, I’ll be in for the last gospel.

But as luck would have it the jarvey got the nag’s head round the other way and off with him.

—Hold on, citizen, says Joe. Stop!

Begob he drew his hand and made a swipe and let fly. Mercy of God the sun was in his eyes or he’d have left him for dead. Gob, he near sent it into the county Longford. The bloody nag took fright and the old mongrel after the car like bloody hell and all the populace shouting and laughing and the old tinbox clattering along the street.

The catastrophe was terrific and instantaneous in its effect. The observatory of Dunsink registered in all eleven shocks, all of the fifth grade of Mercalli’s scale, and there is no record extant of a similar seismic disturbance in our island since the earthquake of 1534, the year of the rebellion of Silken Thomas. The epicentre appears to have been that part of the metropolis which constitutes the Inn’s Quay ward and parish of Saint Michan covering a surface of fortyone acres, two roods and one square pole or perch. All the lordly residences in the vicinity of the palace of justice were demolished and that noble edifice itself, in which at the time of the catastrophe important legal debates were in progress, is literally a mass of ruins beneath which it is to be feared all the occupants have been buried alive. From the reports of eyewitnesses it transpires that the seismic waves were accompanied by a violent atmospheric perturbation of cyclonic character. An article of headgear since ascertained to belong to the much respected clerk of the crown and peace Mr George Fottrell and a silk umbrella with gold handle with the engraved initials, crest, coat of arms and house number of the erudite and worshipful chairman of quarter sessions sir Frederick Falkiner, recorder of Dublin, have been discovered by search parties in remote parts of the island respectively, the former on the third basaltic ridge of the giant’s causeway, the latter embedded to the extent of one foot three inches in the sandy beach of Holeopen bay near the old head of Kinsale. Other eyewitnesses depose that they observed an incandescent object of enormous proportions hurtling through the atmosphere at a terrifying velocity in a trajectory directed southwest by west. Messages of condolence and sympathy are being hourly received from all parts of the different continents and the sovereign pontiff has been graciously pleased to decree that a special missa pro defunctis shall be celebrated simultaneously by the ordinaries of each and every cathedral church of all the episcopal dioceses subject to the spiritual authority of the Holy See in suffrage of the souls of those faithful departed who have been so unexpectedly called away from our midst. The work of salvage, removal of débris, human remains etc has been entrusted to Messrs Michael Meade and Son, 159 Great Brunswick street, and Messrs T. and C. Martin, 77, 78, 79 and 80 North Wall, assisted by the men and officers of the Duke of Cornwall’s light infantry under the general supervision of H. R. H., rear admiral, the right honourable sir Hercules Hannibal Habeas Corpus Anderson, K. G., K. P., K. T., P. C., K. C. B., M. P., J. P., M. B., D. S. O., S. O. D., M. F. H., M. R. I. A., B. L., Mus. Doc., P. L. G., F. T. C. D., F. R. U. I., F. R. C. P. I. and F. R. C. S. I.

You never saw the like of it in all your born puff. Gob, if he got that lottery ticket on the side of his poll he’d remember the gold cup, he would so, but begob the citizen would have been lagged for assault and battery and Joe for aiding and abetting. The jarvey saved his life by furious driving as sure as God made Moses. What? O, Jesus, he did. And he let a volley of oaths after him.

—Did I kill him, says he, or what?

And he shouting to the bloody dog:

—After him, Garry! After him, boy!

And the last we saw was the bloody car rounding the corner and old sheepsface on it gesticulating and the bloody mongrel after it with his lugs back for all he was bloody well worth to tear him limb from limb. Hundred to five! Jesus, he took the value of it out of him, I promise you.

When, lo, there came about them all a great brightness and they beheld the chariot wherein He stood ascend to heaven. And they beheld Him in the chariot, clothed upon in the glory of the brightness, having raiment as of the sun, fair as the moon and terrible that for awe they durst not look upon Him. And there came a voice out of heaven, calling: Elijah! Elijah! And He answered with a main cry: Abba! Adonai! And they beheld Him even Him, ben Bloom Elijah, amid clouds of angels ascend to the glory of the brightness at an angle of fortyfive degrees over Donohoe’s in Little Green street like a shot off a shovel.

### [ 13 ]
The summer evening had begun to fold the world in its mysterious embrace. Far away in the west the sun was setting and the last glow of all too fleeting day lingered lovingly on sea and strand, on the proud promontory of dear old Howth guarding as ever the waters of the bay, on the weedgrown rocks along Sandymount shore and, last but not least, on the quiet church whence there streamed forth at times upon the stillness the voice of prayer to her who is in her pure radiance a beacon ever to the stormtossed heart of man, Mary, star of the sea.

The three girl friends were seated on the rocks, enjoying the evening scene and the air which was fresh but not too chilly. Many a time and oft were they wont to come there to that favourite nook to have a cosy chat beside the sparkling waves and discuss matters feminine, Cissy Caffrey and Edy Boardman with the baby in the pushcar and Tommy and Jacky Caffrey, two little curlyheaded boys, dressed in sailor suits with caps to match and the name H. M. S. Belleisle printed on both. For Tommy and Jacky Caffrey were twins, scarce four years old and very noisy and spoiled twins sometimes but for all that darling little fellows with bright merry faces and endearing ways about them. They were dabbling in the sand with their spades and buckets, building castles as children do, or playing with their big coloured ball, happy as the day was long. And Edy Boardman was rocking the chubby baby to and fro in the pushcar while that young gentleman fairly chuckled with delight. He was but eleven months and nine days old and, though still a tiny toddler, was just beginning to lisp his first babyish words. Cissy Caffrey bent over to him to tease his fat little plucks and the dainty dimple in his chin.

—Now, baby, Cissy Caffrey said. Say out big, big. I want a drink of water.

And baby prattled after her:

—A jink a jink a jawbo.

Cissy Caffrey cuddled the wee chap for she was awfully fond of children, so patient with little sufferers and Tommy Caffrey could never be got to take his castor oil unless it was Cissy Caffrey that held his nose and promised him the scatty heel of the loaf or brown bread with golden syrup on. What a persuasive power that girl had! But to be sure baby Boardman was as good as gold, a perfect little dote in his new fancy bib. None of your spoilt beauties, Flora MacFlimsy sort, was Cissy Caffrey. A truerhearted lass never drew the breath of life, always with a laugh in her gipsylike eyes and a frolicsome word on her cherryripe red lips, a girl lovable in the extreme. And Edy Boardman laughed too at the quaint language of little brother.

But just then there was a slight altercation between Master Tommy and Master Jacky. Boys will be boys and our two twins were no exception to this golden rule. The apple of discord was a certain castle of sand which Master Jacky had built and Master Tommy would have it right go wrong that it was to be architecturally improved by a frontdoor like the Martello tower had. But if Master Tommy was headstrong Master Jacky was selfwilled too and, true to the maxim that every little Irishman’s house is his castle, he fell upon his hated rival and to such purpose that the wouldbe assailant came to grief and (alas to relate!) the coveted castle too. Needless to say the cries of discomfited Master Tommy drew the attention of the girl friends.

—Come here, Tommy, his sister called imperatively. At once! And you, Jacky, for shame to throw poor Tommy in the dirty sand. Wait till I catch you for that.

His eyes misty with unshed tears Master Tommy came at her call for their big sister’s word was law with the twins. And in a sad plight he was too after his misadventure. His little man-o’-war top and unmentionables were full of sand but Cissy was a past mistress in the art of smoothing over life’s tiny troubles and very quickly not one speck of sand was to be seen on his smart little suit. Still the blue eyes were glistening with hot tears that would well up so she kissed away the hurtness and shook her hand at Master Jacky the culprit and said if she was near him she wouldn’t be far from him, her eyes dancing in admonition.

—Nasty bold Jacky! she cried.

She put an arm round the little mariner and coaxed winningly:

—What’s your name? Butter and cream?

—Tell us who is your sweetheart, spoke Edy Boardman. Is Cissy your sweetheart?

—Nao, tearful Tommy said.

—Is Edy Boardman your sweetheart? Cissy queried.

—Nao, Tommy said.

—I know, Edy Boardman said none too amiably with an arch glance from her shortsighted eyes. I know who is Tommy’s sweetheart. Gerty is Tommy’s sweetheart.

—Nao, Tommy said on the verge of tears.

Cissy’s quick motherwit guessed what was amiss and she whispered to Edy Boardman to take him there behind the pushcar where the gentleman couldn’t see and to mind he didn’t wet his new tan shoes.

But who was Gerty?

Gerty MacDowell who was seated near her companions, lost in thought, gazing far away into the distance was, in very truth, as fair a specimen of winsome Irish girlhood as one could wish to see. She was pronounced beautiful by all who knew her though, as folks often said, she was more a Giltrap than a MacDowell. Her figure was slight and graceful, inclining even to fragility but those iron jelloids she had been taking of late had done her a world of good much better than the Widow Welch’s female pills and she was much better of those discharges she used to get and that tired feeling. The waxen pallor of her face was almost spiritual in its ivorylike purity though her rosebud mouth was a genuine Cupid’s bow, Greekly perfect. Her hands were of finely veined alabaster with tapering fingers and as white as lemonjuice and queen of ointments could make them though it was not true that she used to wear kid gloves in bed or take a milk footbath either. Bertha Supple told that once to Edy Boardman, a deliberate lie, when she was black out at daggers drawn with Gerty (the girl chums had of course their little tiffs from time to time like the rest of mortals) and she told her not to let on whatever she did that it was her that told her or she’d never speak to her again. No. Honour where honour is due. There was an innate refinement, a languid queenly hauteur about Gerty which was unmistakably evidenced in her delicate hands and higharched instep. Had kind fate but willed her to be born a gentlewoman of high degree in her own right and had she only received the benefit of a good education Gerty MacDowell might easily have held her own beside any lady in the land and have seen herself exquisitely gowned with jewels on her brow and patrician suitors at her feet vying with one another to pay their devoirs to her. Mayhap it was this, the love that might have been, that lent to her softlyfeatured face at whiles a look, tense with suppressed meaning, that imparted a strange yearning tendency to the beautiful eyes, a charm few could resist. Why have women such eyes of witchery? Gerty’s were of the bluest Irish blue, set off by lustrous lashes and dark expressive brows. Time was when those brows were not so silkily seductive. It was Madame Vera Verity, directress of the Woman Beautiful page of the Princess Novelette, who had first advised her to try eyebrowleine which gave that haunting expression to the eyes, so becoming in leaders of fashion, and she had never regretted it. Then there was blushing scientifically cured and how to be tall increase your height and you have a beautiful face but your nose? That would suit Mrs Dignam because she had a button one. But Gerty’s crowning glory was her wealth of wonderful hair. It was dark brown with a natural wave in it. She had cut it that very morning on account of the new moon and it nestled about her pretty head in a profusion of luxuriant clusters and pared her nails too, Thursday for wealth. And just now at Edy’s words as a telltale flush, delicate as the faintest rosebloom, crept into her cheeks she looked so lovely in her sweet girlish shyness that of a surety God’s fair land of Ireland did not hold her equal.

For an instant she was silent with rather sad downcast eyes. She was about to retort but something checked the words on her tongue. Inclination prompted her to speak out: dignity told her to be silent. The pretty lips pouted awhile but then she glanced up and broke out into a joyous little laugh which had in it all the freshness of a young May morning. She knew right well, no-one better, what made squinty Edy say that because of him cooling in his attentions when it was simply a lovers’ quarrel. As per usual somebody’s nose was out of joint about the boy that had the bicycle off the London bridge road always riding up and down in front of her window. Only now his father kept him in in the evenings studying hard to get an exhibition in the intermediate that was on and he was going to go to Trinity college to study for a doctor when he left the high school like his brother W. E. Wylie who was racing in the bicycle races in Trinity college university. Little recked he perhaps for what she felt, that dull aching void in her heart sometimes, piercing to the core. Yet he was young and perchance he might learn to love her in time. They were protestants in his family and of course Gerty knew Who came first and after Him the Blessed Virgin and then Saint Joseph. But he was undeniably handsome with an exquisite nose and he was what he looked, every inch a gentleman, the shape of his head too at the back without his cap on that she would know anywhere something off the common and the way he turned the bicycle at the lamp with his hands off the bars and also the nice perfume of those good cigarettes and besides they were both of a size too he and she and that was why Edy Boardman thought she was so frightfully clever because he didn’t go and ride up and down in front of her bit of a garden.

Gerty was dressed simply but with the instinctive taste of a votary of Dame Fashion for she felt that there was just a might that he might be out. A neat blouse of electric blue selftinted by dolly dyes (because it was expected in the Lady’s Pictorial that electric blue would be worn) with a smart vee opening down to the division and kerchief pocket (in which she always kept a piece of cottonwool scented with her favourite perfume because the handkerchief spoiled the sit) and a navy threequarter skirt cut to the stride showed off her slim graceful figure to perfection. She wore a coquettish little love of a hat of wideleaved nigger straw contrast trimmed with an underbrim of eggblue chenille and at the side a butterfly bow of silk to tone. All Tuesday week afternoon she was hunting to match that chenille but at last she found what she wanted at Clery’s summer sales, the very it, slightly shopsoiled but you would never notice, seven fingers two and a penny. She did it up all by herself and what joy was hers when she tried it on then, smiling at the lovely reflection which the mirror gave back to her! And when she put it on the waterjug to keep the shape she knew that that would take the shine out of some people she knew. Her shoes were the newest thing in footwear (Edy Boardman prided herself that she was very petite but she never had a foot like Gerty MacDowell, a five, and never would ash, oak or elm) with patent toecaps and just one smart buckle over her higharched instep. Her wellturned ankle displayed its perfect proportions beneath her skirt and just the proper amount and no more of her shapely limbs encased in finespun hose with highspliced heels and wide garter tops. As for undies they were Gerty’s chief care and who that knows the fluttering hopes and fears of sweet seventeen (though Gerty would never see seventeen again) can find it in his heart to blame her? She had four dinky sets with awfully pretty stitchery, three garments and nighties extra, and each set slotted with different coloured ribbons, rosepink, pale blue, mauve and peagreen, and she aired them herself and blued them when they came home from the wash and ironed them and she had a brickbat to keep the iron on because she wouldn’t trust those washerwomen as far as she’d see them scorching the things. She was wearing the blue for luck, hoping against hope, her own colour and lucky too for a bride to have a bit of blue somewhere on her because the green she wore that day week brought grief because his father brought him in to study for the intermediate exhibition and because she thought perhaps he might be out because when she was dressing that morning she nearly slipped up the old pair on her inside out and that was for luck and lovers’ meeting if you put those things on inside out or if they got untied that he was thinking about you so long as it wasn’t of a Friday.

And yet and yet! That strained look on her face! A gnawing sorrow is there all the time. Her very soul is in her eyes and she would give worlds to be in the privacy of her own familiar chamber where, giving way to tears, she could have a good cry and relieve her pentup feelings though not too much because she knew how to cry nicely before the mirror. You are lovely, Gerty, it said. The paly light of evening falls upon a face infinitely sad and wistful. Gerty MacDowell yearns in vain. Yes, she had known from the very first that her daydream of a marriage has been arranged and the weddingbells ringing for Mrs Reggy Wylie T. C. D. (because the one who married the elder brother would be Mrs Wylie) and in the fashionable intelligence Mrs Gertrude Wylie was wearing a sumptuous confection of grey trimmed with expensive blue fox was not to be. He was too young to understand. He would not believe in love, a woman’s birthright. The night of the party long ago in Stoer’s (he was still in short trousers) when they were alone and he stole an arm round her waist she went white to the very lips. He called her little one in a strangely husky voice and snatched a half kiss (the first!) but it was only the end of her nose and then he hastened from the room with a remark about refreshments. Impetuous fellow! Strength of character had never been Reggy Wylie’s strong point and he who would woo and win Gerty MacDowell must be a man among men. But waiting, always waiting to be asked and it was leap year too and would soon be over. No prince charming is her beau ideal to lay a rare and wondrous love at her feet but rather a manly man with a strong quiet face who had not found his ideal, perhaps his hair slightly flecked with grey, and who would understand, take her in his sheltering arms, strain her to him in all the strength of his deep passionate nature and comfort her with a long long kiss. It would be like heaven. For such a one she yearns this balmy summer eve. With all the heart of her she longs to be his only, his affianced bride for riches for poor, in sickness in health, till death us two part, from this to this day forward.

And while Edy Boardman was with little Tommy behind the pushcar she was just thinking would the day ever come when she could call herself his little wife to be. Then they could talk about her till they went blue in the face, Bertha Supple too, and Edy, little spitfire, because she would be twentytwo in November. She would care for him with creature comforts too for Gerty was womanly wise and knew that a mere man liked that feeling of hominess. Her griddlecakes done to a goldenbrown hue and queen Ann’s pudding of delightful creaminess had won golden opinions from all because she had a lucky hand also for lighting a fire, dredge in the fine selfraising flour and always stir in the same direction, then cream the milk and sugar and whisk well the white of eggs though she didn’t like the eating part when there were any people that made her shy and often she wondered why you couldn’t eat something poetical like violets or roses and they would have a beautifully appointed drawingroom with pictures and engravings and the photograph of grandpapa Giltrap’s lovely dog Garryowen that almost talked it was so human and chintz covers for the chairs and that silver toastrack in Clery’s summer jumble sales like they have in rich houses. He would be tall with broad shoulders (she had always admired tall men for a husband) with glistening white teeth under his carefully trimmed sweeping moustache and they would go on the continent for their honeymoon (three wonderful weeks!) and then, when they settled down in a nice snug and cosy little homely house, every morning they would both have brekky, simple but perfectly served, for their own two selves and before he went out to business he would give his dear little wifey a good hearty hug and gaze for a moment deep down into her eyes.

Edy Boardman asked Tommy Caffrey was he done and he said yes so then she buttoned up his little knickerbockers for him and told him to run off and play with Jacky and to be good now and not to fight. But Tommy said he wanted the ball and Edy told him no that baby was playing with the ball and if he took it there’d be wigs on the green but Tommy said it was his ball and he wanted his ball and he pranced on the ground, if you please. The temper of him! O, he was a man already was little Tommy Caffrey since he was out of pinnies. Edy told him no, no and to be off now with him and she told Cissy Caffrey not to give in to him.

—You’re not my sister, naughty Tommy said. It’s my ball.

But Cissy Caffrey told baby Boardman to look up, look up high at her finger and she snatched the ball quickly and threw it along the sand and Tommy after it in full career, having won the day.

—Anything for a quiet life, laughed Ciss.

And she tickled tiny tot’s two cheeks to make him forget and played here’s the lord mayor, here’s his two horses, here’s his gingerbread carriage and here he walks in, chinchopper, chinchopper, chinchopper chin. But Edy got as cross as two sticks about him getting his own way like that from everyone always petting him.

—I’d like to give him something, she said, so I would, where I won’t say.

—On the beeoteetom, laughed Cissy merrily.

Gerty MacDowell bent down her head and crimsoned at the idea of Cissy saying an unladylike thing like that out loud she’d be ashamed of her life to say, flushing a deep rosy red, and Edy Boardman said she was sure the gentleman opposite heard what she said. But not a pin cared Ciss.

—Let him! she said with a pert toss of her head and a piquant tilt of her nose. Give it to him too on the same place as quick as I’d look at him.

Madcap Ciss with her golliwog curls. You had to laugh at her sometimes. For instance when she asked you would you have some more Chinese tea and jaspberry ram and when she drew the jugs too and the men’s faces on her nails with red ink make you split your sides or when she wanted to go where you know she said she wanted to run and pay a visit to the Miss White. That was just like Cissycums. O, and will you ever forget her the evening she dressed up in her father’s suit and hat and the burned cork moustache and walked down Tritonville road, smoking a cigarette. There was none to come up to her for fun. But she was sincerity itself, one of the bravest and truest hearts heaven ever made, not one of your twofaced things, too sweet to be wholesome.

And then there came out upon the air the sound of voices and the pealing anthem of the organ. It was the men’s temperance retreat conducted by the missioner, the reverend John Hughes S. J., rosary, sermon and benediction of the Most Blessed Sacrament. They were there gathered together without distinction of social class (and a most edifying spectacle it was to see) in that simple fane beside the waves, after the storms of this weary world, kneeling before the feet of the immaculate, reciting the litany of Our Lady of Loreto, beseeching her to intercede for them, the old familiar words, holy Mary, holy virgin of virgins. How sad to poor Gerty’s ears! Had her father only avoided the clutches of the demon drink, by taking the pledge or those powders the drink habit cured in Pearson’s Weekly, she might now be rolling in her carriage, second to none. Over and over had she told herself that as she mused by the dying embers in a brown study without the lamp because she hated two lights or oftentimes gazing out of the window dreamily by the hour at the rain falling on the rusty bucket, thinking. But that vile decoction which has ruined so many hearths and homes had cast its shadow over her childhood days. Nay, she had even witnessed in the home circle deeds of violence caused by intemperance and had seen her own father, a prey to the fumes of intoxication, forget himself completely for if there was one thing of all things that Gerty knew it was that the man who lifts his hand to a woman save in the way of kindness, deserves to be branded as the lowest of the low.

And still the voices sang in supplication to the Virgin most powerful, Virgin most merciful. And Gerty, rapt in thought, scarce saw or heard her companions or the twins at their boyish gambols or the gentleman off Sandymount green that Cissy Caffrey called the man that was so like himself passing along the strand taking a short walk. You never saw him any way screwed but still and for all that she would not like him for a father because he was too old or something or on account of his face (it was a palpable case of Doctor Fell) or his carbuncly nose with the pimples on it and his sandy moustache a bit white under his nose. Poor father! With all his faults she loved him still when he sang Tell me, Mary, how to woo thee or My love and cottage near Rochelle and they had stewed cockles and lettuce with Lazenby’s salad dressing for supper and when he sang The moon hath raised with Mr Dignam that died suddenly and was buried, God have mercy on him, from a stroke. Her mother’s birthday that was and Charley was home on his holidays and Tom and Mr Dignam and Mrs and Patsy and Freddy Dignam and they were to have had a group taken. No-one would have thought the end was so near. Now he was laid to rest. And her mother said to him to let that be a warning to him for the rest of his days and he couldn’t even go to the funeral on account of the gout and she had to go into town to bring him the letters and samples from his office about Catesby’s cork lino, artistic, standard designs, fit for a palace, gives tiptop wear and always bright and cheery in the home.

A sterling good daughter was Gerty just like a second mother in the house, a ministering angel too with a little heart worth its weight in gold. And when her mother had those raging splitting headaches who was it rubbed the menthol cone on her forehead but Gerty though she didn’t like her mother’s taking pinches of snuff and that was the only single thing they ever had words about, taking snuff. Everyone thought the world of her for her gentle ways. It was Gerty who turned off the gas at the main every night and it was Gerty who tacked up on the wall of that place where she never forgot every fortnight the chlorate of lime Mr Tunney the grocer’s christmas almanac, the picture of halcyon days where a young gentleman in the costume they used to wear then with a threecornered hat was offering a bunch of flowers to his ladylove with oldtime chivalry through her lattice window. You could see there was a story behind it. The colours were done something lovely. She was in a soft clinging white in a studied attitude and the gentleman was in chocolate and he looked a thorough aristocrat. She often looked at them dreamily when she went there for a certain purpose and felt her own arms that were white and soft just like hers with the sleeves back and thought about those times because she had found out in Walker’s pronouncing dictionary that belonged to grandpapa Giltrap about the halcyon days what they meant.

The twins were now playing in the most approved brotherly fashion till at last Master Jacky who was really as bold as brass there was no getting behind that deliberately kicked the ball as hard as ever he could down towards the seaweedy rocks. Needless to say poor Tommy was not slow to voice his dismay but luckily the gentleman in black who was sitting there by himself came gallantly to the rescue and intercepted the ball. Our two champions claimed their plaything with lusty cries and to avoid trouble Cissy Caffrey called to the gentleman to throw it to her please. The gentleman aimed the ball once or twice and then threw it up the strand towards Cissy Caffrey but it rolled down the slope and stopped right under Gerty’s skirt near the little pool by the rock. The twins clamoured again for it and Cissy told her to kick it away and let them fight for it so Gerty drew back her foot but she wished their stupid ball hadn’t come rolling down to her and she gave a kick but she missed and Edy and Cissy laughed.

—If you fail try again, Edy Boardman said.

Gerty smiled assent and bit her lip. A delicate pink crept into her pretty cheek but she was determined to let them see so she just lifted her skirt a little but just enough and took good aim and gave the ball a jolly good kick and it went ever so far and the two twins after it down towards the shingle. Pure jealousy of course it was nothing else to draw attention on account of the gentleman opposite looking. She felt the warm flush, a danger signal always with Gerty MacDowell, surging and flaming into her cheeks. Till then they had only exchanged glances of the most casual but now under the brim of her new hat she ventured a look at him and the face that met her gaze there in the twilight, wan and strangely drawn, seemed to her the saddest she had ever seen.

Through the open window of the church the fragrant incense was wafted and with it the fragrant names of her who was conceived without stain of original sin, spiritual vessel, pray for us, honourable vessel, pray for us, vessel of singular devotion, pray for us, mystical rose. And careworn hearts were there and toilers for their daily bread and many who had erred and wandered, their eyes wet with contrition but for all that bright with hope for the reverend father Father Hughes had told them what the great saint Bernard said in his famous prayer of Mary, the most pious Virgin’s intercessory power that it was not recorded in any age that those who implored her powerful protection were ever abandoned by her.

The twins were now playing again right merrily for the troubles of childhood are but as fleeting summer showers. Cissy Caffrey played with baby Boardman till he crowed with glee, clapping baby hands in air. Peep she cried behind the hood of the pushcar and Edy asked where was Cissy gone and then Cissy popped up her head and cried ah! and, my word, didn’t the little chap enjoy that! And then she told him to say papa.

—Say papa, baby. Say pa pa pa pa pa pa pa.

And baby did his level best to say it for he was very intelligent for eleven months everyone said and big for his age and the picture of health, a perfect little bunch of love, and he would certainly turn out to be something great, they said.

—Haja ja ja haja.

Cissy wiped his little mouth with the dribbling bib and wanted him to sit up properly and say pa pa pa but when she undid the strap she cried out, holy saint Denis, that he was possing wet and to double the half blanket the other way under him. Of course his infant majesty was most obstreperous at such toilet formalities and he let everyone know it:

—Habaa baaaahabaaa baaaa.

And two great big lovely big tears coursing down his cheeks. It was all no use soothering him with no, nono, baby, no and telling him about the geegee and where was the puffpuff but Ciss, always readywitted, gave him in his mouth the teat of the suckingbottle and the young heathen was quickly appeased.

Gerty wished to goodness they would take their squalling baby home out of that and not get on her nerves, no hour to be out, and the little brats of twins. She gazed out towards the distant sea. It was like the paintings that man used to do on the pavement with all the coloured chalks and such a pity too leaving them there to be all blotted out, the evening and the clouds coming out and the Bailey light on Howth and to hear the music like that and the perfume of those incense they burned in the church like a kind of waft. And while she gazed her heart went pitapat. Yes, it was her he was looking at, and there was meaning in his look. His eyes burned into her as though they would search her through and through, read her very soul. Wonderful eyes they were, superbly expressive, but could you trust them? People were so queer. She could see at once by his dark eyes and his pale intellectual face that he was a foreigner, the image of the photo she had of Martin Harvey, the matinee idol, only for the moustache which she preferred because she wasn’t stagestruck like Winny Rippingham that wanted they two to always dress the same on account of a play but she could not see whether he had an aquiline nose or a slightly retroussé from where he was sitting. He was in deep mourning, she could see that, and the story of a haunting sorrow was written on his face. She would have given worlds to know what it was. He was looking up so intently, so still, and he saw her kick the ball and perhaps he could see the bright steel buckles of her shoes if she swung them like that thoughtfully with the toes down. She was glad that something told her to put on the transparent stockings thinking Reggy Wylie might be out but that was far away. Here was that of which she had so often dreamed. It was he who mattered and there was joy on her face because she wanted him because she felt instinctively that he was like no-one else. The very heart of the girlwoman went out to him, her dreamhusband, because she knew on the instant it was him. If he had suffered, more sinned against than sinning, or even, even, if he had been himself a sinner, a wicked man, she cared not. Even if he was a protestant or methodist she could convert him easily if he truly loved her. There were wounds that wanted healing with heartbalm. She was a womanly woman not like other flighty girls unfeminine he had known, those cyclists showing off what they hadn’t got and she just yearned to know all, to forgive all if she could make him fall in love with her, make him forget the memory of the past. Then mayhap he would embrace her gently, like a real man, crushing her soft body to him, and love her, his ownest girlie, for herself alone.

Refuge of sinners. Comfortress of the afflicted. Ora pro nobis. Well has it been said that whosoever prays to her with faith and constancy can never be lost or cast away: and fitly is she too a haven of refuge for the afflicted because of the seven dolours which transpierced her own heart. Gerty could picture the whole scene in the church, the stained glass windows lighted up, the candles, the flowers and the blue banners of the blessed Virgin’s sodality and Father Conroy was helping Canon O’Hanlon at the altar, carrying things in and out with his eyes cast down. He looked almost a saint and his confessionbox was so quiet and clean and dark and his hands were just like white wax and if ever she became a Dominican nun in their white habit perhaps he might come to the convent for the novena of Saint Dominic. He told her that time when she told him about that in confession, crimsoning up to the roots of her hair for fear he could see, not to be troubled because that was only the voice of nature and we were all subject to nature’s laws, he said, in this life and that that was no sin because that came from the nature of woman instituted by God, he said, and that Our Blessed Lady herself said to the archangel Gabriel be it done unto me according to Thy Word. He was so kind and holy and often and often she thought and thought could she work a ruched teacosy with embroidered floral design for him as a present or a clock but they had a clock she noticed on the mantelpiece white and gold with a canarybird that came out of a little house to tell the time the day she went there about the flowers for the forty hours’ adoration because it was hard to know what sort of a present to give or perhaps an album of illuminated views of Dublin or some place.

The exasperating little brats of twins began to quarrel again and Jacky threw the ball out towards the sea and they both ran after it. Little monkeys common as ditchwater. Someone ought to take them and give them a good hiding for themselves to keep them in their places, the both of them. And Cissy and Edy shouted after them to come back because they were afraid the tide might come in on them and be drowned.

—Jacky! Tommy!

Not they! What a great notion they had! So Cissy said it was the very last time she’d ever bring them out. She jumped up and called them and she ran down the slope past him, tossing her hair behind her which had a good enough colour if there had been more of it but with all the thingamerry she was always rubbing into it she couldn’t get it to grow long because it wasn’t natural so she could just go and throw her hat at it. She ran with long gandery strides it was a wonder she didn’t rip up her skirt at the side that was too tight on her because there was a lot of the tomboy about Cissy Caffrey and she was a forward piece whenever she thought she had a good opportunity to show off and just because she was a good runner she ran like that so that he could see all the end of her petticoat running and her skinny shanks up as far as possible. It would have served her just right if she had tripped up over something accidentally on purpose with her high crooked French heels on her to make her look tall and got a fine tumble. Tableau! That would have been a very charming exposé for a gentleman like that to witness.

Queen of angels, queen of patriarchs, queen of prophets, of all saints, they prayed, queen of the most holy rosary and then Father Conroy handed the thurible to Canon O’Hanlon and he put in the incense and censed the Blessed Sacrament and Cissy Caffrey caught the two twins and she was itching to give them a ringing good clip on the ear but she didn’t because she thought he might be watching but she never made a bigger mistake in all her life because Gerty could see without looking that he never took his eyes off of her and then Canon O’Hanlon handed the thurible back to Father Conroy and knelt down looking up at the Blessed Sacrament and the choir began to sing the Tantum ergo and she just swung her foot in and out in time as the music rose and fell to the Tantumer gosa cramen tum. Three and eleven she paid for those stockings in Sparrow’s of George’s street on the Tuesday, no the Monday before Easter and there wasn’t a brack on them and that was what he was looking at, transparent, and not at her insignificant ones that had neither shape nor form (the cheek of her!) because he had eyes in his head to see the difference for himself.

Cissy came up along the strand with the two twins and their ball with her hat anyhow on her to one side after her run and she did look a streel tugging the two kids along with the flimsy blouse she bought only a fortnight before like a rag on her back and a bit of her petticoat hanging like a caricature. Gerty just took off her hat for a moment to settle her hair and a prettier, a daintier head of nutbrown tresses was never seen on a girl’s shoulders—a radiant little vision, in sooth, almost maddening in its sweetness. You would have to travel many a long mile before you found a head of hair the like of that. She could almost see the swift answering flash of admiration in his eyes that set her tingling in every nerve. She put on her hat so that she could see from underneath the brim and swung her buckled shoe faster for her breath caught as she caught the expression in his eyes. He was eying her as a snake eyes its prey. Her woman’s instinct told her that she had raised the devil in him and at the thought a burning scarlet swept from throat to brow till the lovely colour of her face became a glorious rose.

Edy Boardman was noticing it too because she was squinting at Gerty, half smiling, with her specs like an old maid, pretending to nurse the baby. Irritable little gnat she was and always would be and that was why no-one could get on with her poking her nose into what was no concern of hers. And she said to Gerty:

—A penny for your thoughts.

—What? replied Gerty with a smile reinforced by the whitest of teeth. I was only wondering was it late.

Because she wished to goodness they’d take the snottynosed twins and their babby home to the mischief out of that so that was why she just gave a gentle hint about its being late. And when Cissy came up Edy asked her the time and Miss Cissy, as glib as you like, said it was half past kissing time, time to kiss again. But Edy wanted to know because they were told to be in early.

—Wait, said Cissy, I’ll run ask my uncle Peter over there what’s the time by his conundrum.

So over she went and when he saw her coming she could see him take his hand out of his pocket, getting nervous, and beginning to play with his watchchain, looking up at the church. Passionate nature though he was Gerty could see that he had enormous control over himself. One moment he had been there, fascinated by a loveliness that made him gaze, and the next moment it was the quiet gravefaced gentleman, selfcontrol expressed in every line of his distinguishedlooking figure.

Cissy said to excuse her would he mind please telling her what was the right time and Gerty could see him taking out his watch, listening to it and looking up and clearing his throat and he said he was very sorry his watch was stopped but he thought it must be after eight because the sun was set. His voice had a cultured ring in it and though he spoke in measured accents there was a suspicion of a quiver in the mellow tones. Cissy said thanks and came back with her tongue out and said uncle said his waterworks were out of order.

Then they sang the second verse of the Tantum ergo and Canon O’Hanlon got up again and censed the Blessed Sacrament and knelt down and he told Father Conroy that one of the candles was just going to set fire to the flowers and Father Conroy got up and settled it all right and she could see the gentleman winding his watch and listening to the works and she swung her leg more in and out in time. It was getting darker but he could see and he was looking all the time that he was winding the watch or whatever he was doing to it and then he put it back and put his hands back into his pockets. She felt a kind of a sensation rushing all over her and she knew by the feel of her scalp and that irritation against her stays that that thing must be coming on because the last time too was when she clipped her hair on account of the moon. His dark eyes fixed themselves on her again drinking in her every contour, literally worshipping at her shrine. If ever there was undisguised admiration in a man’s passionate gaze it was there plain to be seen on that man’s face. It is for you, Gertrude MacDowell, and you know it.

Edy began to get ready to go and it was high time for her and Gerty noticed that that little hint she gave had had the desired effect because it was a long way along the strand to where there was the place to push up the pushcar and Cissy took off the twins’ caps and tidied their hair to make herself attractive of course and Canon O’Hanlon stood up with his cope poking up at his neck and Father Conroy handed him the card to read off and he read out Panem de coelo praestitisti eis and Edy and Cissy were talking about the time all the time and asking her but Gerty could pay them back in their own coin and she just answered with scathing politeness when Edy asked her was she heartbroken about her best boy throwing her over. Gerty winced sharply. A brief cold blaze shone from her eyes that spoke volumes of scorn immeasurable. It hurt—O yes, it cut deep because Edy had her own quiet way of saying things like that she knew would wound like the confounded little cat she was. Gerty’s lips parted swiftly to frame the word but she fought back the sob that rose to her throat, so slim, so flawless, so beautifully moulded it seemed one an artist might have dreamed of. She had loved him better than he knew. Lighthearted deceiver and fickle like all his sex he would never understand what he had meant to her and for an instant there was in the blue eyes a quick stinging of tears. Their eyes were probing her mercilessly but with a brave effort she sparkled back in sympathy as she glanced at her new conquest for them to see.

—O, responded Gerty, quick as lightning, laughing, and the proud head flashed up. I can throw my cap at who I like because it’s leap year.

Her words rang out crystalclear, more musical than the cooing of the ringdove, but they cut the silence icily. There was that in her young voice that told that she was not a one to be lightly trifled with. As for Mr Reggy with his swank and his bit of money she could just chuck him aside as if he was so much filth and never again would she cast as much as a second thought on him and tear his silly postcard into a dozen pieces. And if ever after he dared to presume she could give him one look of measured scorn that would make him shrivel up on the spot. Miss puny little Edy’s countenance fell to no slight extent and Gerty could see by her looking as black as thunder that she was simply in a towering rage though she hid it, the little kinnatt, because that shaft had struck home for her petty jealousy and they both knew that she was something aloof, apart, in another sphere, that she was not of them and never would be and there was somebody else too that knew it and saw it so they could put that in their pipe and smoke it.

Edy straightened up baby Boardman to get ready to go and Cissy tucked in the ball and the spades and buckets and it was high time too because the sandman was on his way for Master Boardman junior. And Cissy told him too that billy winks was coming and that baby was to go deedaw and baby looked just too ducky, laughing up out of his gleeful eyes, and Cissy poked him like that out of fun in his wee fat tummy and baby, without as much as by your leave, sent up his compliments to all and sundry on to his brandnew dribbling bib.

—O my! Puddeny pie! protested Ciss. He has his bib destroyed.

The slight contretemps claimed her attention but in two twos she set that little matter to rights.

Gerty stifled a smothered exclamation and gave a nervous cough and Edy asked what and she was just going to tell her to catch it while it was flying but she was ever ladylike in her deportment so she simply passed it off with consummate tact by saying that that was the benediction because just then the bell rang out from the steeple over the quiet seashore because Canon O’Hanlon was up on the altar with the veil that Father Conroy put round his shoulders giving the benediction with the Blessed Sacrament in his hands.

How moving the scene there in the gathering twilight, the last glimpse of Erin, the touching chime of those evening bells and at the same time a bat flew forth from the ivied belfry through the dusk, hither, thither, with a tiny lost cry. And she could see far away the lights of the lighthouses so picturesque she would have loved to do with a box of paints because it was easier than to make a man and soon the lamplighter would be going his rounds past the presbyterian church grounds and along by shady Tritonville avenue where the couples walked and lighting the lamp near her window where Reggy Wylie used to turn his freewheel like she read in that book The Lamplighter by Miss Cummins, author of Mabel Vaughan and other tales. For Gerty had her dreams that no-one knew of. She loved to read poetry and when she got a keepsake from Bertha Supple of that lovely confession album with the coralpink cover to write her thoughts in she laid it in the drawer of her toilettable which, though it did not err on the side of luxury, was scrupulously neat and clean. It was there she kept her girlish treasure trove, the tortoiseshell combs, her child of Mary badge, the whiterose scent, the eyebrowleine, her alabaster pouncetbox and the ribbons to change when her things came home from the wash and there were some beautiful thoughts written in it in violet ink that she bought in Hely’s of Dame Street for she felt that she too could write poetry if she could only express herself like that poem that appealed to her so deeply that she had copied out of the newspaper she found one evening round the potherbs. Art thou real, my ideal? it was called by Louis J Walsh, Magherafelt, and after there was something about twilight, wilt thou ever? and ofttimes the beauty of poetry, so sad in its transient loveliness, had misted her eyes with silent tears for she felt that the years were slipping by for her, one by one, and but for that one shortcoming she knew she need fear no competition and that was an accident coming down Dalkey hill and she always tried to conceal it. But it must end, she felt. If she saw that magic lure in his eyes there would be no holding back for her. Love laughs at locksmiths. She would make the great sacrifice. Her every effort would be to share his thoughts. Dearer than the whole world would she be to him and gild his days with happiness. There was the allimportant question and she was dying to know was he a married man or a widower who had lost his wife or some tragedy like the nobleman with the foreign name from the land of song had to have her put into a madhouse, cruel only to be kind. But even if—what then? Would it make a very great difference? From everything in the least indelicate her finebred nature instinctively recoiled. She loathed that sort of person, the fallen women off the accommodation walk beside the Dodder that went with the soldiers and coarse men with no respect for a girl’s honour, degrading the sex and being taken up to the police station. No, no: not that. They would be just good friends like a big brother and sister without all that other in spite of the conventions of Society with a big ess. Perhaps it was an old flame he was in mourning for from the days beyond recall. She thought she understood. She would try to understand him because men were so different. The old love was waiting, waiting with little white hands stretched out, with blue appealing eyes. Heart of mine! She would follow, her dream of love, the dictates of her heart that told her he was her all in all, the only man in all the world for her for love was the master guide. Nothing else mattered. Come what might she would be wild, untrammelled, free.

Canon O’Hanlon put the Blessed Sacrament back into the tabernacle and genuflected and the choir sang Laudate Dominum omnes gentes and then he locked the tabernacle door because the benediction was over and Father Conroy handed him his hat to put on and crosscat Edy asked wasn’t she coming but Jacky Caffrey called out:

—O, look, Cissy!

And they all looked was it sheet lightning but Tommy saw it too over the trees beside the church, blue and then green and purple.

—It’s fireworks, Cissy Caffrey said.

And they all ran down the strand to see over the houses and the church, helterskelter, Edy with the pushcar with baby Boardman in it and Cissy holding Tommy and Jacky by the hand so they wouldn’t fall running.

—Come on, Gerty, Cissy called. It’s the bazaar fireworks.

But Gerty was adamant. She had no intention of being at their beck and call. If they could run like rossies she could sit so she said she could see from where she was. The eyes that were fastened upon her set her pulses tingling. She looked at him a moment, meeting his glance, and a light broke in upon her. Whitehot passion was in that face, passion silent as the grave, and it had made her his. At last they were left alone without the others to pry and pass remarks and she knew he could be trusted to the death, steadfast, a sterling man, a man of inflexible honour to his fingertips. His hands and face were working and a tremour went over her. She leaned back far to look up where the fireworks were and she caught her knee in her hands so as not to fall back looking up and there was no-one to see only him and her when she revealed all her graceful beautifully shaped legs like that, supply soft and delicately rounded, and she seemed to hear the panting of his heart, his hoarse breathing, because she knew too about the passion of men like that, hotblooded, because Bertha Supple told her once in dead secret and made her swear she’d never about the gentleman lodger that was staying with them out of the Congested Districts Board that had pictures cut out of papers of those skirtdancers and highkickers and she said he used to do something not very nice that you could imagine sometimes in the bed. But this was altogether different from a thing like that because there was all the difference because she could almost feel him draw her face to his and the first quick hot touch of his handsome lips. Besides there was absolution so long as you didn’t do the other thing before being married and there ought to be women priests that would understand without your telling out and Cissy Caffrey too sometimes had that dreamy kind of dreamy look in her eyes so that she too, my dear, and Winny Rippingham so mad about actors’ photographs and besides it was on account of that other thing coming on the way it did.

And Jacky Caffrey shouted to look, there was another and she leaned back and the garters were blue to match on account of the transparent and they all saw it and they all shouted to look, look, there it was and she leaned back ever so far to see the fireworks and something queer was flying through the air, a soft thing, to and fro, dark. And she saw a long Roman candle going up over the trees, up, up, and, in the tense hush, they were all breathless with excitement as it went higher and higher and she had to lean back more and more to look up after it, high, high, almost out of sight, and her face was suffused with a divine, an entrancing blush from straining back and he could see her other things too, nainsook knickers, the fabric that caresses the skin, better than those other pettiwidth, the green, four and eleven, on account of being white and she let him and she saw that he saw and then it went so high it went out of sight a moment and she was trembling in every limb from being bent so far back that he had a full view high up above her knee where no-one ever not even on the swing or wading and she wasn’t ashamed and he wasn’t either to look in that immodest way like that because he couldn’t resist the sight of the wondrous revealment half offered like those skirtdancers behaving so immodest before gentlemen looking and he kept on looking, looking. She would fain have cried to him chokingly, held out her snowy slender arms to him to come, to feel his lips laid on her white brow, the cry of a young girl’s love, a little strangled cry, wrung from her, that cry that has rung through the ages. And then a rocket sprang and bang shot blind blank and O! then the Roman candle burst and it was like a sigh of O! and everyone cried O! O! in raptures and it gushed out of it a stream of rain gold hair threads and they shed and ah! they were all greeny dewy stars falling with golden, O so lovely, O, soft, sweet, soft!

Then all melted away dewily in the grey air: all was silent. Ah! She glanced at him as she bent forward quickly, a pathetic little glance of piteous protest, of shy reproach under which he coloured like a girl. He was leaning back against the rock behind. Leopold Bloom (for it is he) stands silent, with bowed head before those young guileless eyes. What a brute he had been! At it again? A fair unsullied soul had called to him and, wretch that he was, how had he answered? An utter cad he had been! He of all men! But there was an infinite store of mercy in those eyes, for him too a word of pardon even though he had erred and sinned and wandered. Should a girl tell? No, a thousand times no. That was their secret, only theirs, alone in the hiding twilight and there was none to know or tell save the little bat that flew so softly through the evening to and fro and little bats don’t tell.

Cissy Caffrey whistled, imitating the boys in the football field to show what a great person she was: and then she cried:

—Gerty! Gerty! We’re going. Come on. We can see from farther up.

Gerty had an idea, one of love’s little ruses. She slipped a hand into her kerchief pocket and took out the wadding and waved in reply of course without letting him and then slipped it back. Wonder if he’s too far to. She rose. Was it goodbye? No. She had to go but they would meet again, there, and she would dream of that till then, tomorrow, of her dream of yester eve. She drew herself up to her full height. Their souls met in a last lingering glance and the eyes that reached her heart, full of a strange shining, hung enraptured on her sweet flowerlike face. She half smiled at him wanly, a sweet forgiving smile, a smile that verged on tears, and then they parted.

Slowly, without looking back she went down the uneven strand to Cissy, to Edy to Jacky and Tommy Caffrey, to little baby Boardman. It was darker now and there were stones and bits of wood on the strand and slippy seaweed. She walked with a certain quiet dignity characteristic of her but with care and very slowly because—because Gerty MacDowell was...

Tight boots? No. She’s lame! O!

Mr Bloom watched her as she limped away. Poor girl! That’s why she’s left on the shelf and the others did a sprint. Thought something was wrong by the cut of her jib. Jilted beauty. A defect is ten times worse in a woman. But makes them polite. Glad I didn’t know it when she was on show. Hot little devil all the same. I wouldn’t mind. Curiosity like a nun or a negress or a girl with glasses. That squinty one is delicate. Near her monthlies, I expect, makes them feel ticklish. I have such a bad headache today. Where did I put the letter? Yes, all right. All kinds of crazy longings. Licking pennies. Girl in Tranquilla convent that nun told me liked to smell rock oil. Virgins go mad in the end I suppose. Sister? How many women in Dublin have it today? Martha, she. Something in the air. That’s the moon. But then why don’t all women menstruate at the same time with the same moon, I mean? Depends on the time they were born I suppose. Or all start scratch then get out of step. Sometimes Molly and Milly together. Anyhow I got the best of that. Damned glad I didn’t do it in the bath this morning over her silly I will punish you letter. Made up for that tramdriver this morning. That gouger M’Coy stopping me to say nothing. And his wife engagement in the country valise, voice like a pickaxe. Thankful for small mercies. Cheap too. Yours for the asking. Because they want it themselves. Their natural craving. Shoals of them every evening poured out of offices. Reserve better. Don’t want it they throw it at you. Catch em alive, O. Pity they can’t see themselves. A dream of wellfilled hose. Where was that? Ah, yes. Mutoscope pictures in Capel street: for men only. Peeping Tom. Willy’s hat and what the girls did with it. Do they snapshot those girls or is it all a fake? Lingerie does it. Felt for the curves inside her déshabillé. Excites them also when they’re. I’m all clean come and dirty me. And they like dressing one another for the sacrifice. Milly delighted with Molly’s new blouse. At first. Put them all on to take them all off. Molly. Why I bought her the violet garters. Us too: the tie he wore, his lovely socks and turnedup trousers. He wore a pair of gaiters the night that first we met. His lovely shirt was shining beneath his what? of jet. Say a woman loses a charm with every pin she takes out. Pinned together. O, Mairy lost the pin of her. Dressed up to the nines for somebody. Fashion part of their charm. Just changes when you’re on the track of the secret. Except the east: Mary, Martha: now as then. No reasonable offer refused. She wasn’t in a hurry either. Always off to a fellow when they are. They never forget an appointment. Out on spec probably. They believe in chance because like themselves. And the others inclined to give her an odd dig. Girl friends at school, arms round each other’s necks or with ten fingers locked, kissing and whispering secrets about nothing in the convent garden. Nuns with whitewashed faces, cool coifs and their rosaries going up and down, vindictive too for what they can’t get. Barbed wire. Be sure now and write to me. And I’ll write to you. Now won’t you? Molly and Josie Powell. Till Mr Right comes along, then meet once in a blue moon. Tableau! O, look who it is for the love of God! How are you at all? What have you been doing with yourself? Kiss and delighted to, kiss, to see you. Picking holes in each other’s appearance. You’re looking splendid. Sister souls. Showing their teeth at one another. How many have you left? Wouldn’t lend each other a pinch of salt.

Ah!

Devils they are when that’s coming on them. Dark devilish appearance. Molly often told me feel things a ton weight. Scratch the sole of my foot. O that way! O, that’s exquisite! Feel it myself too. Good to rest once in a way. Wonder if it’s bad to go with them then. Safe in one way. Turns milk, makes fiddlestrings snap. Something about withering plants I read in a garden. Besides they say if the flower withers she wears she’s a flirt. All are. Daresay she felt I. When you feel like that you often meet what you feel. Liked me or what? Dress they look at. Always know a fellow courting: collars and cuffs. Well cocks and lions do the same and stags. Same time might prefer a tie undone or something. Trousers? Suppose I when I was? No. Gently does it. Dislike rough and tumble. Kiss in the dark and never tell. Saw something in me. Wonder what. Sooner have me as I am than some poet chap with bearsgrease plastery hair, lovelock over his dexter optic. To aid gentleman in literary. Ought to attend to my appearance my age. Didn’t let her see me in profile. Still, you never know. Pretty girls and ugly men marrying. Beauty and the beast. Besides I can’t be so if Molly. Took off her hat to show her hair. Wide brim. Bought to hide her face, meeting someone might know her, bend down or carry a bunch of flowers to smell. Hair strong in rut. Ten bob I got for Molly’s combings when we were on the rocks in Holles street. Why not? Suppose he gave her money. Why not? All a prejudice. She’s worth ten, fifteen, more, a pound. What? I think so. All that for nothing. Bold hand: Mrs Marion. Did I forget to write address on that letter like the postcard I sent to Flynn? And the day I went to Drimmie’s without a necktie. Wrangle with Molly it was put me off. No, I remember. Richie Goulding: he’s another. Weighs on his mind. Funny my watch stopped at half past four. Dust. Shark liver oil they use to clean. Could do it myself. Save. Was that just when he, she?

O, he did. Into her. She did. Done.

Ah!

Mr Bloom with careful hand recomposed his wet shirt. O Lord, that little limping devil. Begins to feel cold and clammy. Aftereffect not pleasant. Still you have to get rid of it someway. They don’t care. Complimented perhaps. Go home to nicey bread and milky and say night prayers with the kiddies. Well, aren’t they? See her as she is spoil all. Must have the stage setting, the rouge, costume, position, music. The name too. Amours of actresses. Nell Gwynn, Mrs Bracegirdle, Maud Branscombe. Curtain up. Moonlight silver effulgence. Maiden discovered with pensive bosom. Little sweetheart come and kiss me. Still, I feel. The strength it gives a man. That’s the secret of it. Good job I let off there behind the wall coming out of Dignam’s. Cider that was. Otherwise I couldn’t have. Makes you want to sing after. Lacaus esant taratara. Suppose I spoke to her. What about? Bad plan however if you don’t know how to end the conversation. Ask them a question they ask you another. Good idea if you’re stuck. Gain time. But then you’re in a cart. Wonderful of course if you say: good evening, and you see she’s on for it: good evening. O but the dark evening in the Appian way I nearly spoke to Mrs Clinch O thinking she was. Whew! Girl in Meath street that night. All the dirty things I made her say. All wrong of course. My arks she called it. It’s so hard to find one who. Aho! If you don’t answer when they solicit must be horrible for them till they harden. And kissed my hand when I gave her the extra two shillings. Parrots. Press the button and the bird will squeak. Wish she hadn’t called me sir. O, her mouth in the dark! And you a married man with a single girl! That’s what they enjoy. Taking a man from another woman. Or even hear of it. Different with me. Glad to get away from other chap’s wife. Eating off his cold plate. Chap in the Burton today spitting back gumchewed gristle. French letter still in my pocketbook. Cause of half the trouble. But might happen sometime, I don’t think. Come in, all is prepared. I dreamt. What? Worst is beginning. How they change the venue when it’s not what they like. Ask you do you like mushrooms because she once knew a gentleman who. Or ask you what someone was going to say when he changed his mind and stopped. Yet if I went the whole hog, say: I want to, something like that. Because I did. She too. Offend her. Then make it up. Pretend to want something awfully, then cry off for her sake. Flatters them. She must have been thinking of someone else all the time. What harm? Must since she came to the use of reason, he, he and he. First kiss does the trick. The propitious moment. Something inside them goes pop. Mushy like, tell by their eye, on the sly. First thoughts are best. Remember that till their dying day. Molly, lieutenant Mulvey that kissed her under the Moorish wall beside the gardens. Fifteen she told me. But her breasts were developed. Fell asleep then. After Glencree dinner that was when we drove home. Featherbed mountain. Gnashing her teeth in sleep. Lord mayor had his eye on her too. Val Dillon. Apoplectic.

There she is with them down there for the fireworks. My fireworks. Up like a rocket, down like a stick. And the children, twins they must be, waiting for something to happen. Want to be grownups. Dressing in mother’s clothes. Time enough, understand all the ways of the world. And the dark one with the mop head and the nigger mouth. I knew she could whistle. Mouth made for that. Like Molly. Why that highclass whore in Jammet’s wore her veil only to her nose. Would you mind, please, telling me the right time? I’ll tell you the right time up a dark lane. Say prunes and prisms forty times every morning, cure for fat lips. Caressing the little boy too. Onlookers see most of the game. Of course they understand birds, animals, babies. In their line.

Didn’t look back when she was going down the strand. Wouldn’t give that satisfaction. Those girls, those girls, those lovely seaside girls. Fine eyes she had, clear. It’s the white of the eye brings that out not so much the pupil. Did she know what I? Course. Like a cat sitting beyond a dog’s jump. Women never meet one like that Wilkins in the high school drawing a picture of Venus with all his belongings on show. Call that innocence? Poor idiot! His wife has her work cut out for her. Never see them sit on a bench marked Wet Paint. Eyes all over them. Look under the bed for what’s not there. Longing to get the fright of their lives. Sharp as needles they are. When I said to Molly the man at the corner of Cuffe street was goodlooking, thought she might like, twigged at once he had a false arm. Had, too. Where do they get that? Typist going up Roger Greene’s stairs two at a time to show her understandings. Handed down from father to, mother to daughter, I mean. Bred in the bone. Milly for example drying her handkerchief on the mirror to save the ironing. Best place for an ad to catch a woman’s eye on a mirror. And when I sent her for Molly’s Paisley shawl to Prescott’s by the way that ad I must, carrying home the change in her stocking! Clever little minx. I never told her. Neat way she carries parcels too. Attract men, small thing like that. Holding up her hand, shaking it, to let the blood flow back when it was red. Who did you learn that from? Nobody. Something the nurse taught me. O, don’t they know! Three years old she was in front of Molly’s dressingtable, just before we left Lombard street west. Me have a nice pace. Mullingar. Who knows? Ways of the world. Young student. Straight on her pins anyway not like the other. Still she was game. Lord, I am wet. Devil you are. Swell of her calf. Transparent stockings, stretched to breaking point. Not like that frump today. A. E. Rumpled stockings. Or the one in Grafton street. White. Wow! Beef to the heel.

A monkey puzzle rocket burst, spluttering in darting crackles. Zrads and zrads, zrads, zrads. And Cissy and Tommy and Jacky ran out to see and Edy after with the pushcar and then Gerty beyond the curve of the rocks. Will she? Watch! Watch! See! Looked round. She smelt an onion. Darling, I saw, your. I saw all.

Lord!

Did me good all the same. Off colour after Kiernan’s, Dignam’s. For this relief much thanks. In Hamlet, that is. Lord! It was all things combined. Excitement. When she leaned back, felt an ache at the butt of my tongue. Your head it simply swirls. He’s right. Might have made a worse fool of myself however. Instead of talking about nothing. Then I will tell you all. Still it was a kind of language between us. It couldn’t be? No, Gerty they called her. Might be false name however like my name and the address Dolphin’s barn a blind.

Her maiden name was Jemina Brown
And she lived with her mother in Irishtown.

Place made me think of that I suppose. All tarred with the same brush. Wiping pens in their stockings. But the ball rolled down to her as if it understood. Every bullet has its billet. Course I never could throw anything straight at school. Crooked as a ram’s horn. Sad however because it lasts only a few years till they settle down to potwalloping and papa’s pants will soon fit Willy and fuller’s earth for the baby when they hold him out to do ah ah. No soft job. Saves them. Keeps them out of harm’s way. Nature. Washing child, washing corpse. Dignam. Children’s hands always round them. Cocoanut skulls, monkeys, not even closed at first, sour milk in their swaddles and tainted curds. Oughtn’t to have given that child an empty teat to suck. Fill it up with wind. Mrs Beaufoy, Purefoy. Must call to the hospital. Wonder is nurse Callan there still. She used to look over some nights when Molly was in the Coffee Palace. That young doctor O’Hare I noticed her brushing his coat. And Mrs Breen and Mrs Dignam once like that too, marriageable. Worst of all at night Mrs Duggan told me in the City Arms. Husband rolling in drunk, stink of pub off him like a polecat. Have that in your nose in the dark, whiff of stale boose. Then ask in the morning: was I drunk last night? Bad policy however to fault the husband. Chickens come home to roost. They stick by one another like glue. Maybe the women’s fault also. That’s where Molly can knock spots off them. It’s the blood of the south. Moorish. Also the form, the figure. Hands felt for the opulent. Just compare for instance those others. Wife locked up at home, skeleton in the cupboard. Allow me to introduce my. Then they trot you out some kind of a nondescript, wouldn’t know what to call her. Always see a fellow’s weak point in his wife. Still there’s destiny in it, falling in love. Have their own secrets between them. Chaps that would go to the dogs if some woman didn’t take them in hand. Then little chits of girls, height of a shilling in coppers, with little hubbies. As God made them he matched them. Sometimes children turn out well enough. Twice nought makes one. Or old rich chap of seventy and blushing bride. Marry in May and repent in December. This wet is very unpleasant. Stuck. Well the foreskin is not back. Better detach.

Ow!

Other hand a sixfooter with a wifey up to his watchpocket. Long and the short of it. Big he and little she. Very strange about my watch. Wristwatches are always going wrong. Wonder is there any magnetic influence between the person because that was about the time he. Yes, I suppose, at once. Cat’s away, the mice will play. I remember looking in Pill lane. Also that now is magnetism. Back of everything magnetism. Earth for instance pulling this and being pulled. That causes movement. And time, well that’s the time the movement takes. Then if one thing stopped the whole ghesabo would stop bit by bit. Because it’s all arranged. Magnetic needle tells you what’s going on in the sun, the stars. Little piece of steel iron. When you hold out the fork. Come. Come. Tip. Woman and man that is. Fork and steel. Molly, he. Dress up and look and suggest and let you see and see more and defy you if you’re a man to see that and, like a sneeze coming, legs, look, look and if you have any guts in you. Tip. Have to let fly.

Wonder how is she feeling in that region. Shame all put on before third person. More put out about a hole in her stocking. Molly, her underjaw stuck out, head back, about the farmer in the ridingboots and spurs at the horse show. And when the painters were in Lombard street west. Fine voice that fellow had. How Giuglini began. Smell that I did. Like flowers. It was too. Violets. Came from the turpentine probably in the paint. Make their own use of everything. Same time doing it scraped her slipper on the floor so they wouldn’t hear. But lots of them can’t kick the beam, I think. Keep that thing up for hours. Kind of a general all round over me and half down my back.

Wait. Hm. Hm. Yes. That’s her perfume. Why she waved her hand. I leave you this to think of me when I’m far away on the pillow. What is it? Heliotrope? No. Hyacinth? Hm. Roses, I think. She’d like scent of that kind. Sweet and cheap: soon sour. Why Molly likes opoponax. Suits her, with a little jessamine mixed. Her high notes and her low notes. At the dance night she met him, dance of the hours. Heat brought it out. She was wearing her black and it had the perfume of the time before. Good conductor, is it? Or bad? Light too. Suppose there’s some connection. For instance if you go into a cellar where it’s dark. Mysterious thing too. Why did I smell it only now? Took its time in coming like herself, slow but sure. Suppose it’s ever so many millions of tiny grains blown across. Yes, it is. Because those spice islands, Cinghalese this morning, smell them leagues off. Tell you what it is. It’s like a fine fine veil or web they have all over the skin, fine like what do you call it gossamer, and they’re always spinning it out of them, fine as anything, like rainbow colours without knowing it. Clings to everything she takes off. Vamp of her stockings. Warm shoe. Stays. Drawers: little kick, taking them off. Byby till next time. Also the cat likes to sniff in her shift on the bed. Know her smell in a thousand. Bathwater too. Reminds me of strawberries and cream. Wonder where it is really. There or the armpits or under the neck. Because you get it out of all holes and corners. Hyacinth perfume made of oil of ether or something. Muskrat. Bag under their tails. One grain pour off odour for years. Dogs at each other behind. Good evening. Evening. How do you sniff? Hm. Hm. Very well, thank you. Animals go by that. Yes now, look at it that way. We’re the same. Some women, instance, warn you off when they have their period. Come near. Then get a hogo you could hang your hat on. Like what? Potted herrings gone stale or. Boof! Please keep off the grass.

Perhaps they get a man smell off us. What though? Cigary gloves long John had on his desk the other day. Breath? What you eat and drink gives that. No. Mansmell, I mean. Must be connected with that because priests that are supposed to be are different. Women buzz round it like flies round treacle. Railed off the altar get on to it at any cost. The tree of forbidden priest. O, father, will you? Let me be the first to. That diffuses itself all through the body, permeates. Source of life. And it’s extremely curious the smell. Celery sauce. Let me.

Mr Bloom inserted his nose. Hm. Into the. Hm. Opening of his waistcoat. Almonds or. No. Lemons it is. Ah no, that’s the soap.

O by the by that lotion. I knew there was something on my mind. Never went back and the soap not paid. Dislike carrying bottles like that hag this morning. Hynes might have paid me that three shillings. I could mention Meagher’s just to remind him. Still if he works that paragraph. Two and nine. Bad opinion of me he’ll have. Call tomorrow. How much do I owe you? Three and nine? Two and nine, sir. Ah. Might stop him giving credit another time. Lose your customers that way. Pubs do. Fellows run up a bill on the slate and then slinking around the back streets into somewhere else.

Here’s this nobleman passed before. Blown in from the bay. Just went as far as turn back. Always at home at dinnertime. Looks mangled out: had a good tuck in. Enjoying nature now. Grace after meals. After supper walk a mile. Sure he has a small bank balance somewhere, government sit. Walk after him now make him awkward like those newsboys me today. Still you learn something. See ourselves as others see us. So long as women don’t mock what matter? That’s the way to find out. Ask yourself who is he now. The Mystery Man on the Beach, prize titbit story by Mr Leopold Bloom. Payment at the rate of one guinea per column. And that fellow today at the graveside in the brown macintosh. Corns on his kismet however. Healthy perhaps absorb all the. Whistle brings rain they say. Must be some somewhere. Salt in the Ormond damp. The body feels the atmosphere. Old Betty’s joints are on the rack. Mother Shipton’s prophecy that is about ships around they fly in the twinkling. No. Signs of rain it is. The royal reader. And distant hills seem coming nigh.

Howth. Bailey light. Two, four, six, eight, nine. See. Has to change or they might think it a house. Wreckers. Grace Darling. People afraid of the dark. Also glowworms, cyclists: lightingup time. Jewels diamonds flash better. Women. Light is a kind of reassuring. Not going to hurt you. Better now of course than long ago. Country roads. Run you through the small guts for nothing. Still two types there are you bob against. Scowl or smile. Pardon! Not at all. Best time to spray plants too in the shade after the sun. Some light still. Red rays are longest. Roygbiv Vance taught us: red, orange, yellow, green, blue, indigo, violet. A star I see. Venus? Can’t tell yet. Two. When three it’s night. Were those nightclouds there all the time? Looks like a phantom ship. No. Wait. Trees are they? An optical illusion. Mirage. Land of the setting sun this. Homerule sun setting in the southeast. My native land, goodnight.

Dew falling. Bad for you, dear, to sit on that stone. Brings on white fluxions. Never have little baby then less he was big strong fight his way up through. Might get piles myself. Sticks too like a summer cold, sore on the mouth. Cut with grass or paper worst. Friction of the position. Like to be that rock she sat on. O sweet little, you don’t know how nice you looked. I begin to like them at that age. Green apples. Grab at all that offer. Suppose it’s the only time we cross legs, seated. Also the library today: those girl graduates. Happy chairs under them. But it’s the evening influence. They feel all that. Open like flowers, know their hours, sunflowers, Jerusalem artichokes, in ballrooms, chandeliers, avenues under the lamps. Nightstock in Mat Dillon’s garden where I kissed her shoulder. Wish I had a full length oilpainting of her then. June that was too I wooed. The year returns. History repeats itself. Ye crags and peaks I’m with you once again. Life, love, voyage round your own little world. And now? Sad about her lame of course but must be on your guard not to feel too much pity. They take advantage.

All quiet on Howth now. The distant hills seem. Where we. The rhododendrons. I am a fool perhaps. He gets the plums, and I the plumstones. Where I come in. All that old hill has seen. Names change: that’s all. Lovers: yum yum.

Tired I feel now. Will I get up? O wait. Drained all the manhood out of me, little wretch. She kissed me. Never again. My youth. Only once it comes. Or hers. Take the train there tomorrow. No. Returning not the same. Like kids your second visit to a house. The new I want. Nothing new under the sun. Care of P. O. Dolphin’s Barn. Are you not happy in your? Naughty darling. At Dolphin’s barn charades in Luke Doyle’s house. Mat Dillon and his bevy of daughters: Tiny, Atty, Floey, Maimy, Louy, Hetty. Molly too. Eightyseven that was. Year before we. And the old major, partial to his drop of spirits. Curious she an only child, I an only child. So it returns. Think you’re escaping and run into yourself. Longest way round is the shortest way home. And just when he and she. Circus horse walking in a ring. Rip van Winkle we played. Rip: tear in Henny Doyle’s overcoat. Van: breadvan delivering. Winkle: cockles and periwinkles. Then I did Rip van Winkle coming back. She leaned on the sideboard watching. Moorish eyes. Twenty years asleep in Sleepy Hollow. All changed. Forgotten. The young are old. His gun rusty from the dew.

Ba. What is that flying about? Swallow? Bat probably. Thinks I’m a tree, so blind. Have birds no smell? Metempsychosis. They believed you could be changed into a tree from grief. Weeping willow. Ba. There he goes. Funny little beggar. Wonder where he lives. Belfry up there. Very likely. Hanging by his heels in the odour of sanctity. Bell scared him out, I suppose. Mass seems to be over. Could hear them all at it. Pray for us. And pray for us. And pray for us. Good idea the repetition. Same thing with ads. Buy from us. And buy from us. Yes, there’s the light in the priest’s house. Their frugal meal. Remember about the mistake in the valuation when I was in Thom’s. Twentyeight it is. Two houses they have. Gabriel Conroy’s brother is curate. Ba. Again. Wonder why they come out at night like mice. They’re a mixed breed. Birds are like hopping mice. What frightens them, light or noise? Better sit still. All instinct like the bird in drouth got water out of the end of a jar by throwing in pebbles. Like a little man in a cloak he is with tiny hands. Weeny bones. Almost see them shimmering, kind of a bluey white. Colours depend on the light you see. Stare the sun for example like the eagle then look at a shoe see a blotch blob yellowish. Wants to stamp his trademark on everything. Instance, that cat this morning on the staircase. Colour of brown turf. Say you never see them with three colours. Not true. That half tabbywhite tortoiseshell in the City Arms with the letter em on her forehead. Body fifty different colours. Howth a while ago amethyst. Glass flashing. That’s how that wise man what’s his name with the burning glass. Then the heather goes on fire. It can’t be tourists’ matches. What? Perhaps the sticks dry rub together in the wind and light. Or broken bottles in the furze act as a burning glass in the sun. Archimedes. I have it! My memory’s not so bad.

Ba. Who knows what they’re always flying for. Insects? That bee last week got into the room playing with his shadow on the ceiling. Might be the one bit me, come back to see. Birds too. Never find out. Or what they say. Like our small talk. And says she and says he. Nerve they have to fly over the ocean and back. Lots must be killed in storms, telegraph wires. Dreadful life sailors have too. Big brutes of oceangoing steamers floundering along in the dark, lowing out like seacows. Faugh a ballagh! Out of that, bloody curse to you! Others in vessels, bit of a handkerchief sail, pitched about like snuff at a wake when the stormy winds do blow. Married too. Sometimes away for years at the ends of the earth somewhere. No ends really because it’s round. Wife in every port they say. She has a good job if she minds it till Johnny comes marching home again. If ever he does. Smelling the tail end of ports. How can they like the sea? Yet they do. The anchor’s weighed. Off he sails with a scapular or a medal on him for luck. Well. And the tephilim no what’s this they call it poor papa’s father had on his door to touch. That brought us out of the land of Egypt and into the house of bondage. Something in all those superstitions because when you go out never know what dangers. Hanging on to a plank or astride of a beam for grim life, lifebelt round him, gulping salt water, and that’s the last of his nibs till the sharks catch hold of him. Do fish ever get seasick?

Then you have a beautiful calm without a cloud, smooth sea, placid, crew and cargo in smithereens, Davy Jones’ locker, moon looking down so peaceful. Not my fault, old cockalorum.

A last lonely candle wandered up the sky from Mirus bazaar in search of funds for Mercer’s hospital and broke, drooping, and shed a cluster of violet but one white stars. They floated, fell: they faded. The shepherd’s hour: the hour of folding: hour of tryst. From house to house, giving his everwelcome double knock, went the nine o’clock postman, the glowworm’s lamp at his belt gleaming here and there through the laurel hedges. And among the five young trees a hoisted lintstock lit the lamp at Leahy’s terrace. By screens of lighted windows, by equal gardens a shrill voice went crying, wailing: Evening Telegraph, stop press edition! Result of the Gold Cup races! and from the door of Dignam’s house a boy ran out and called. Twittering the bat flew here, flew there. Far out over the sands the coming surf crept, grey. Howth settled for slumber, tired of long days, of yumyum rhododendrons (he was old) and felt gladly the night breeze lift, ruffle his fell of ferns. He lay but opened a red eye unsleeping, deep and slowly breathing, slumberous but awake. And far on Kish bank the anchored lightship twinkled, winked at Mr Bloom.

Life those chaps out there must have, stuck in the same spot. Irish Lights board. Penance for their sins. Coastguards too. Rocket and breeches buoy and lifeboat. Day we went out for the pleasure cruise in the Erin’s King, throwing them the sack of old papers. Bears in the zoo. Filthy trip. Drunkards out to shake up their livers. Puking overboard to feed the herrings. Nausea. And the women, fear of God in their faces. Milly, no sign of funk. Her blue scarf loose, laughing. Don’t know what death is at that age. And then their stomachs clean. But being lost they fear. When we hid behind the tree at Crumlin. I didn’t want to. Mamma! Mamma! Babes in the wood. Frightening them with masks too. Throwing them up in the air to catch them. I’ll murder you. Is it only half fun? Or children playing battle. Whole earnest. How can people aim guns at each other. Sometimes they go off. Poor kids! Only troubles wildfire and nettlerash. Calomel purge I got her for that. After getting better asleep with Molly. Very same teeth she has. What do they love? Another themselves? But the morning she chased her with the umbrella. Perhaps so as not to hurt. I felt her pulse. Ticking. Little hand it was: now big. Dearest Papli. All that the hand says when you touch. Loved to count my waistcoat buttons. Her first stays I remember. Made me laugh to see. Little paps to begin with. Left one is more sensitive, I think. Mine too. Nearer the heart? Padding themselves out if fat is in fashion. Her growing pains at night, calling, wakening me. Frightened she was when her nature came on her first. Poor child! Strange moment for the mother too. Brings back her girlhood. Gibraltar. Looking from Buena Vista. O’Hara’s tower. The seabirds screaming. Old Barbary ape that gobbled all his family. Sundown, gunfire for the men to cross the lines. Looking out over the sea she told me. Evening like this, but clear, no clouds. I always thought I’d marry a lord or a rich gentleman coming with a private yacht. Buenas noches, señorita. El hombre ama la muchacha hermosa. Why me? Because you were so foreign from the others.

Better not stick here all night like a limpet. This weather makes you dull. Must be getting on for nine by the light. Go home. Too late for Leah, Lily of Killarney. No. Might be still up. Call to the hospital to see. Hope she’s over. Long day I’ve had. Martha, the bath, funeral, house of Keyes, museum with those goddesses, Dedalus’ song. Then that bawler in Barney Kiernan’s. Got my own back there. Drunken ranters what I said about his God made him wince. Mistake to hit back. Or? No. Ought to go home and laugh at themselves. Always want to be swilling in company. Afraid to be alone like a child of two. Suppose he hit me. Look at it other way round. Not so bad then. Perhaps not to hurt he meant. Three cheers for Israel. Three cheers for the sister-in-law he hawked about, three fangs in her mouth. Same style of beauty. Particularly nice old party for a cup of tea. The sister of the wife of the wild man of Borneo has just come to town. Imagine that in the early morning at close range. Everyone to his taste as Morris said when he kissed the cow. But Dignam’s put the boots on it. Houses of mourning so depressing because you never know. Anyhow she wants the money. Must call to those Scottish Widows as I promised. Strange name. Takes it for granted we’re going to pop off first. That widow on Monday was it outside Cramer’s that looked at me. Buried the poor husband but progressing favourably on the premium. Her widow’s mite. Well? What do you expect her to do? Must wheedle her way along. Widower I hate to see. Looks so forlorn. Poor man O’Connor wife and five children poisoned by mussels here. The sewage. Hopeless. Some good matronly woman in a porkpie hat to mother him. Take him in tow, platter face and a large apron. Ladies’ grey flannelette bloomers, three shillings a pair, astonishing bargain. Plain and loved, loved for ever, they say. Ugly: no woman thinks she is. Love, lie and be handsome for tomorrow we die. See him sometimes walking about trying to find out who played the trick. U. p: up. Fate that is. He, not me. Also a shop often noticed. Curse seems to dog it. Dreamt last night? Wait. Something confused. She had red slippers on. Turkish. Wore the breeches. Suppose she does? Would I like her in pyjamas? Damned hard to answer. Nannetti’s gone. Mailboat. Near Holyhead by now. Must nail that ad of Keyes’s. Work Hynes and Crawford. Petticoats for Molly. She has something to put in them. What’s that? Might be money.

Mr Bloom stooped and turned over a piece of paper on the strand. He brought it near his eyes and peered. Letter? No. Can’t read. Better go. Better. I’m tired to move. Page of an old copybook. All those holes and pebbles. Who could count them? Never know what you find. Bottle with story of a treasure in it, thrown from a wreck. Parcels post. Children always want to throw things in the sea. Trust? Bread cast on the waters. What’s this? Bit of stick.

O! Exhausted that female has me. Not so young now. Will she come here tomorrow? Wait for her somewhere for ever. Must come back. Murderers do. Will I?

Mr Bloom with his stick gently vexed the thick sand at his foot. Write a message for her. Might remain. What?

I.

Some flatfoot tramp on it in the morning. Useless. Washed away. Tide comes here. Saw a pool near her foot. Bend, see my face there, dark mirror, breathe on it, stirs. All these rocks with lines and scars and letters. O, those transparent! Besides they don’t know. What is the meaning of that other world. I called you naughty boy because I do not like.

AM. A.

No room. Let it go.

Mr Bloom effaced the letters with his slow boot. Hopeless thing sand. Nothing grows in it. All fades. No fear of big vessels coming up here. Except Guinness’s barges. Round the Kish in eighty days. Done half by design.

He flung his wooden pen away. The stick fell in silted sand, stuck. Now if you were trying to do that for a week on end you couldn’t. Chance. We’ll never meet again. But it was lovely. Goodbye, dear. Thanks. Made me feel so young.

Short snooze now if I had. Must be near nine. Liverpool boat long gone. Not even the smoke. And she can do the other. Did too. And Belfast. I won’t go. Race there, race back to Ennis. Let him. Just close my eyes a moment. Won’t sleep, though. Half dream. It never comes the same. Bat again. No harm in him. Just a few.

O sweety all your little girlwhite up I saw dirty bracegirdle made me do love sticky we two naughty Grace darling she him half past the bed met him pike hoses frillies for Raoul de perfume your wife black hair heave under embon señorita young eyes Mulvey plump bubs me breadvan Winkle red slippers she rusty sleep wander years of dreams return tail end Agendath swoony lovey showed me her next year in drawers return next in her next her next.

A bat flew. Here. There. Here. Far in the grey a bell chimed. Mr Bloom with open mouth, his left boot sanded sideways, leaned, breathed. Just for a few

Cuckoo
Cuckoo
Cuckoo.

The clock on the mantelpiece in the priest’s house cooed where Canon O’Hanlon and Father Conroy and the reverend John Hughes S. J. were taking tea and sodabread and butter and fried mutton chops with catsup and talking about

Cuckoo
Cuckoo
Cuckoo.

Because it was a little canarybird that came out of its little house to tell the time that Gerty MacDowell noticed the time she was there because she was as quick as anything about a thing like that, was Gerty MacDowell, and she noticed at once that that foreign gentleman that was sitting on the rocks looking was

Cuckoo
Cuckoo
Cuckoo.

### [ 14 ]
Deshil Holles Eamus. Deshil Holles Eamus. Deshil Holles Eamus.

Send us bright one, light one, Horhorn, quickening and wombfruit. Send us bright one, light one, Horhorn, quickening and wombfruit. Send us bright one, light one, Horhorn, quickening and wombfruit.

Hoopsa boyaboy hoopsa! Hoopsa boyaboy hoopsa! Hoopsa boyaboy hoopsa!

Universally that person’s acumen is esteemed very little perceptive concerning whatsoever matters are being held as most profitably by mortals with sapience endowed to be studied who is ignorant of that which the most in doctrine erudite and certainly by reason of that in them high mind’s ornament deserving of veneration constantly maintain when by general consent they affirm that other circumstances being equal by no exterior splendour is the prosperity of a nation more efficaciously asserted than by the measure of how far forward may have progressed the tribute of its solicitude for that proliferent continuance which of evils the original if it be absent when fortunately present constitutes the certain sign of omnipollent nature’s incorrupted benefaction. For who is there who anything of some significance has apprehended but is conscious that that exterior splendour may be the surface of a downwardtending lutulent reality or on the contrary anyone so is there unilluminated as not to perceive that as no nature’s boon can contend against the bounty of increase so it behoves every most just citizen to become the exhortator and admonisher of his semblables and to tremble lest what had in the past been by the nation excellently commenced might be in the future not with similar excellence accomplished if an inverecund habit shall have gradually traduced the honourable by ancestors transmitted customs to that thither of profundity that that one was audacious excessively who would have the hardihood to rise affirming that no more odious offence can for anyone be than to oblivious neglect to consign that evangel simultaneously command and promise which on all mortals with prophecy of abundance or with diminution’s menace that exalted of reiteratedly procreating function ever irrevocably enjoined?

It is not why therefore we shall wonder if, as the best historians relate, among the Celts, who nothing that was not in its nature admirable admired, the art of medicine shall have been highly honoured. Not to speak of hostels, leperyards, sweating chambers, plaguegraves, their greatest doctors, the O’Shiels, the O’Hickeys, the O’Lees, have sedulously set down the divers methods by which the sick and the relapsed found again health whether the malady had been the trembling withering or loose boyconnell flux. Certainly in every public work which in it anything of gravity contains preparation should be with importance commensurate and therefore a plan was by them adopted (whether by having preconsidered or as the maturation of experience it is difficult in being said which the discrepant opinions of subsequent inquirers are not up to the present congrued to render manifest) whereby maternity was so far from all accident possibility removed that whatever care the patient in that allhardest of woman hour chiefly required and not solely for the copiously opulent but also for her who not being sufficiently moneyed scarcely and often not even scarcely could subsist valiantly and for an inconsiderable emolument was provided.

To her nothing already then and thenceforward was anyway able to be molestful for this chiefly felt all citizens except with proliferent mothers prosperity at all not to can be and as they had received eternity gods mortals generation to befit them her beholding, when the case was so hoving itself, parturient in vehicle thereward carrying desire immense among all one another was impelling on of her to be received into that domicile. O thing of prudent nation not merely in being seen but also even in being related worthy of being praised that they her by anticipation went seeing mother, that she by them suddenly to be about to be cherished had been begun she felt!

Before born bliss babe had. Within womb won he worship. Whatever in that one case done commodiously done was. A couch by midwives attended with wholesome food reposeful, cleanest swaddles as though forthbringing were now done and by wise foresight set: but to this no less of what drugs there is need and surgical implements which are pertaining to her case not omitting aspect of all very distracting spectacles in various latitudes by our terrestrial orb offered together with images, divine and human, the cogitation of which by sejunct females is to tumescence conducive or eases issue in the high sunbright wellbuilt fair home of mothers when, ostensibly far gone and reproductitive, it is come by her thereto to lie in, her term up.

Some man that wayfaring was stood by housedoor at night’s oncoming. Of Israel’s folk was that man that on earth wandering far had fared. Stark ruth of man his errand that him lone led till that house.

Of that house A. Horne is lord. Seventy beds keeps he there teeming mothers are wont that they lie for to thole and bring forth bairns hale so God’s angel to Mary quoth. Watchers tway there walk, white sisters in ward sleepless. Smarts they still, sickness soothing: in twelve moons thrice an hundred. Truest bedthanes they twain are, for Horne holding wariest ward.

In ward wary the watcher hearing come that man mildhearted eft rising with swire ywimpled to him her gate wide undid. Lo, levin leaping lightens in eyeblink Ireland’s westward welkin. Full she drad that God the Wreaker all mankind would fordo with water for his evil sins. Christ’s rood made she on breastbone and him drew that he would rathe infare under her thatch. That man her will wotting worthful went in Horne’s house.

Loth to irk in Horne’s hall hat holding the seeker stood. On her stow he ere was living with dear wife and lovesome daughter that then over land and seafloor nine years had long outwandered. Once her in townhithe meeting he to her bow had not doffed. Her to forgive now he craved with good ground of her allowed that that of him swiftseen face, hers, so young then had looked. Light swift her eyes kindled, bloom of blushes his word winning.

As her eyes then ongot his weeds swart therefor sorrow she feared. Glad after she was that ere adread was. Her he asked if O’Hare Doctor tidings sent from far coast and she with grameful sigh him answered that O’Hare Doctor in heaven was. Sad was the man that word to hear that him so heavied in bowels ruthful. All she there told him, ruing death for friend so young, algate sore unwilling God’s rightwiseness to withsay. She said that he had a fair sweet death through God His goodness with masspriest to be shriven, holy housel and sick men’s oil to his limbs. The man then right earnest asked the nun of which death the dead man was died and the nun answered him and said that he was died in Mona Island through bellycrab three year agone come Childermas and she prayed to God the Allruthful to have his dear soul in his undeathliness. He heard her sad words, in held hat sad staring. So stood they there both awhile in wanhope sorrowing one with other.

Therefore, everyman, look to that last end that is thy death and the dust that gripeth on every man that is born of woman for as he came naked forth from his mother’s womb so naked shall he wend him at the last for to go as he came.

The man that was come in to the house then spoke to the nursingwoman and he asked her how it fared with the woman that lay there in childbed. The nursingwoman answered him and said that that woman was in throes now full three days and that it would be a hard birth unneth to bear but that now in a little it would be. She said thereto that she had seen many births of women but never was none so hard as was that woman’s birth. Then she set it all forth to him for because she knew the man that time was had lived nigh that house. The man hearkened to her words for he felt with wonder women’s woe in the travail that they have of motherhood and he wondered to look on her face that was a fair face for any man to see but yet was she left after long years a handmaid. Nine twelve bloodflows chiding her childless.

And whiles they spake the door of the castle was opened and there nighed them a mickle noise as of many that sat there at meat. And there came against the place as they stood a young learningknight yclept Dixon. And the traveller Leopold was couth to him sithen it had happed that they had had ado each with other in the house of misericord where this learningknight lay by cause the traveller Leopold came there to be healed for he was sore wounded in his breast by a spear wherewith a horrible and dreadful dragon was smitten him for which he did do make a salve of volatile salt and chrism as much as he might suffice. And he said now that he should go in to that castle for to make merry with them that were there. And the traveller Leopold said that he should go otherwhither for he was a man of cautels and a subtile. Also the lady was of his avis and repreved the learningknight though she trowed well that the traveller had said thing that was false for his subtility. But the learningknight would not hear say nay nor do her mandement ne have him in aught contrarious to his list and he said how it was a marvellous castle. And the traveller Leopold went into the castle for to rest him for a space being sore of limb after many marches environing in divers lands and sometime venery.

And in the castle was set a board that was of the birchwood of Finlandy and it was upheld by four dwarfmen of that country but they durst not move more for enchantment. And on this board were frightful swords and knives that are made in a great cavern by swinking demons out of white flames that they fix then in the horns of buffalos and stags that there abound marvellously. And there were vessels that are wrought by magic of Mahound out of seasand and the air by a warlock with his breath that he blases in to them like to bubbles. And full fair cheer and rich was on the board that no wight could devise a fuller ne richer. And there was a vat of silver that was moved by craft to open in the which lay strange fishes withouten heads though misbelieving men nie that this be possible thing without they see it natheless they are so. And these fishes lie in an oily water brought there from Portugal land because of the fatness that therein is like to the juices of the olivepress. And also it was a marvel to see in that castle how by magic they make a compost out of fecund wheatkidneys out of Chaldee that by aid of certain angry spirits that they do in to it swells up wondrously like to a vast mountain. And they teach the serpents there to entwine themselves up on long sticks out of the ground and of the scales of these serpents they brew out a brewage like to mead.

And the learning knight let pour for childe Leopold a draught and halp thereto the while all they that were there drank every each. And childe Leopold did up his beaver for to pleasure him and took apertly somewhat in amity for he never drank no manner of mead which he then put by and anon full privily he voided the more part in his neighbour glass and his neighbour nist not of this wile. And he sat down in that castle with them for to rest him there awhile. Thanked be Almighty God.

This meanwhile this good sister stood by the door and begged them at the reverence of Jesu our alther liege Lord to leave their wassailing for there was above one quick with child, a gentle dame, whose time hied fast. Sir Leopold heard on the upfloor cry on high and he wondered what cry that it was whether of child or woman and I marvel, said he, that it be not come or now. Meseems it dureth overlong. And he was ware and saw a franklin that hight Lenehan on that side the table that was older than any of the tother and for that they both were knights virtuous in the one emprise and eke by cause that he was elder he spoke to him full gently. But, said he, or it be long too she will bring forth by God His bounty and have joy of her childing for she hath waited marvellous long. And the franklin that had drunken said, Expecting each moment to be her next. Also he took the cup that stood tofore him for him needed never none asking nor desiring of him to drink and, Now drink, said he, fully delectably, and he quaffed as far as he might to their both’s health for he was a passing good man of his lustiness. And sir Leopold that was the goodliest guest that ever sat in scholars’ hall and that was the meekest man and the kindest that ever laid husbandly hand under hen and that was the very truest knight of the world one that ever did minion service to lady gentle pledged him courtly in the cup. Woman’s woe with wonder pondering.

Now let us speak of that fellowship that was there to the intent to be drunken an they might. There was a sort of scholars along either side the board, that is to wit, Dixon yclept junior of saint Mary Merciable’s with other his fellows Lynch and Madden, scholars of medicine, and the franklin that hight Lenehan and one from Alba Longa, one Crotthers, and young Stephen that had mien of a frere that was at head of the board and Costello that men clepen Punch Costello all long of a mastery of him erewhile gested (and of all them, reserved young Stephen, he was the most drunken that demanded still of more mead) and beside the meek sir Leopold. But on young Malachi they waited for that he promised to have come and such as intended to no goodness said how he had broke his avow. And sir Leopold sat with them for he bore fast friendship to sir Simon and to this his son young Stephen and for that his languor becalmed him there after longest wanderings insomuch as they feasted him for that time in the honourablest manner. Ruth red him, love led on with will to wander, loth to leave.

For they were right witty scholars. And he heard their aresouns each gen other as touching birth and righteousness, young Madden maintaining that put such case it were hard the wife to die (for so it had fallen out a matter of some year agone with a woman of Eblana in Horne’s house that now was trespassed out of this world and the self night next before her death all leeches and pothecaries had taken counsel of her case). And they said farther she should live because in the beginning, they said, the woman should bring forth in pain and wherefore they that were of this imagination affirmed how young Madden had said truth for he had conscience to let her die. And not few and of these was young Lynch were in doubt that the world was now right evil governed as it was never other howbeit the mean people believed it otherwise but the law nor his judges did provide no remedy. A redress God grant. This was scant said but all cried with one acclaim nay, by our Virgin Mother, the wife should live and the babe to die. In colour whereof they waxed hot upon that head what with argument and what for their drinking but the franklin Lenehan was prompt each when to pour them ale so that at the least way mirth might not lack. Then young Madden showed all the whole affair and said how that she was dead and how for holy religion sake by rede of palmer and bedesman and for a vow he had made to Saint Ultan of Arbraccan her goodman husband would not let her death whereby they were all wondrous grieved. To whom young Stephen had these words following: Murmur, sirs, is eke oft among lay folk. Both babe and parent now glorify their Maker, the one in limbo gloom, the other in purgefire. But, gramercy, what of those Godpossibled souls that we nightly impossibilise, which is the sin against the Holy Ghost, Very God, Lord and Giver of Life? For, sirs, he said, our lust is brief. We are means to those small creatures within us and nature has other ends than we. Then said Dixon junior to Punch Costello wist he what ends. But he had overmuch drunken and the best word he could have of him was that he would ever dishonest a woman whoso she were or wife or maid or leman if it so fortuned him to be delivered of his spleen of lustihead. Whereat Crotthers of Alba Longa sang young Malachi’s praise of that beast the unicorn how once in the millennium he cometh by his horn, the other all this while, pricked forward with their jibes wherewith they did malice him, witnessing all and several by saint Foutinus his engines that he was able to do any manner of thing that lay in man to do. Thereat laughed they all right jocundly only young Stephen and sir Leopold which never durst laugh too open by reason of a strange humour which he would not bewray and also for that he rued for her that bare whoso she might be or wheresoever. Then spake young Stephen orgulous of mother Church that would cast him out of her bosom, of law of canons, of Lilith, patron of abortions, of bigness wrought by wind of seeds of brightness or by potency of vampires mouth to mouth or, as Virgilius saith, by the influence of the occident or by the reek of moonflower or an she lie with a woman which her man has but lain with, effectu secuto, or peradventure in her bath according to the opinions of Averroes and Moses Maimonides. He said also how at the end of the second month a human soul was infused and how in all our holy mother foldeth ever souls for God’s greater glory whereas that earthly mother which was but a dam to bear beastly should die by canon for so saith he that holdeth the fisherman’s seal, even that blessed Peter on which rock was holy church for all ages founded. All they bachelors then asked of sir Leopold would he in like case so jeopard her person as risk life to save life. A wariness of mind he would answer as fitted all and, laying hand to jaw, he said dissembling, as his wont was, that as it was informed him, who had ever loved the art of physic as might a layman, and agreeing also with his experience of so seldomseen an accident it was good for that mother Church belike at one blow had birth and death pence and in such sort deliverly he scaped their questions. That is truth, pardy, said Dixon, and, or I err, a pregnant word. Which hearing young Stephen was a marvellous glad man and he averred that he who stealeth from the poor lendeth to the Lord for he was of a wild manner when he was drunken and that he was now in that taking it appeared eftsoons.

But sir Leopold was passing grave maugre his word by cause he still had pity of the terrorcausing shrieking of shrill women in their labour and as he was minded of his good lady Marion that had borne him an only manchild which on his eleventh day on live had died and no man of art could save so dark is destiny. And she was wondrous stricken of heart for that evil hap and for his burial did him on a fair corselet of lamb’s wool, the flower of the flock, lest he might perish utterly and lie akeled (for it was then about the midst of the winter) and now sir Leopold that had of his body no manchild for an heir looked upon him his friend’s son and was shut up in sorrow for his forepassed happiness and as sad as he was that him failed a son of such gentle courage (for all accounted him of real parts) so grieved he also in no less measure for young Stephen for that he lived riotously with those wastrels and murdered his goods with whores.

About that present time young Stephen filled all cups that stood empty so as there remained but little mo if the prudenter had not shadowed their approach from him that still plied it very busily who, praying for the intentions of the sovereign pontiff, he gave them for a pledge the vicar of Christ which also as he said is vicar of Bray. Now drink we, quod he, of this mazer and quaff ye this mead which is not indeed parcel of my body but my soul’s bodiment. Leave ye fraction of bread to them that live by bread alone. Be not afeard neither for any want for this will comfort more than the other will dismay. See ye here. And he showed them glistering coins of the tribute and goldsmith notes the worth of two pound nineteen shilling that he had, he said, for a song which he writ. They all admired to see the foresaid riches in such dearth of money as was herebefore. His words were then these as followeth: Know all men, he said, time’s ruins build eternity’s mansions. What means this? Desire’s wind blasts the thorntree but after it becomes from a bramblebush to be a rose upon the rood of time. Mark me now. In woman’s womb word is made flesh but in the spirit of the maker all flesh that passes becomes the word that shall not pass away. This is the postcreation. Omnis caro ad te veniet. No question but her name is puissant who aventried the dear corse of our Agenbuyer, Healer and Herd, our mighty mother and mother most venerable and Bernardus saith aptly that She hath an omnipotentiam deiparae supplicem, that is to wit, an almightiness of petition because she is the second Eve and she won us, saith Augustine too, whereas that other, our grandam, which we are linked up with by successive anastomosis of navelcords sold us all, seed, breed and generation, for a penny pippin. But here is the matter now. Or she knew him, that second I say, and was but creature of her creature, vergine madre, figlia di tuo figlio, or she knew him not and then stands she in the one denial or ignorancy with Peter Piscator who lives in the house that Jack built and with Joseph the joiner patron of the happy demise of all unhappy marriages, parceque M. Léo Taxil nous a dit que qui l’avait mise dans cette fichue position c’était le sacré pigeon, ventre de Dieu! Entweder transubstantiality oder consubstantiality but in no case subsubstantiality. And all cried out upon it for a very scurvy word. A pregnancy without joy, he said, a birth without pangs, a body without blemish, a belly without bigness. Let the lewd with faith and fervour worship. With will will we withstand, withsay.

Hereupon Punch Costello dinged with his fist upon the board and would sing a bawdy catch Staboo Stabella about a wench that was put in pod of a jolly swashbuckler in Almany which he did straightways now attack: The first three months she was not well, Staboo, when here nurse Quigley from the door angerly bid them hist ye should shame you nor was it not meet as she remembered them being her mind was to have all orderly against lord Andrew came for because she was jealous that no gasteful turmoil might shorten the honour of her guard. It was an ancient and a sad matron of a sedate look and christian walking, in habit dun beseeming her megrims and wrinkled visage, nor did her hortative want of it effect for incontinently Punch Costello was of them all embraided and they reclaimed the churl with civil rudeness some and shaked him with menace of blandishments others whiles they all chode with him, a murrain seize the dolt, what a devil he would be at, thou chuff, thou puny, thou got in peasestraw, thou losel, thou chitterling, thou spawn of a rebel, thou dykedropt, thou abortion thou, to shut up his drunken drool out of that like a curse of God ape, the good sir Leopold that had for his cognisance the flower of quiet, margerain gentle, advising also the time’s occasion as most sacred and most worthy to be most sacred. In Horne’s house rest should reign.

To be short this passage was scarce by when Master Dixon of Mary in Eccles, goodly grinning, asked young Stephen what was the reason why he had not cided to take friar’s vows and he answered him obedience in the womb, chastity in the tomb but involuntary poverty all his days. Master Lenehan at this made return that he had heard of those nefarious deeds and how, as he heard hereof counted, he had besmirched the lily virtue of a confiding female which was corruption of minors and they all intershowed it too, waxing merry and toasting to his fathership. But he said very entirely it was clean contrary to their suppose for he was the eternal son and ever virgin. Thereat mirth grew in them the more and they rehearsed to him his curious rite of wedlock for the disrobing and deflowering of spouses, as the priests use in Madagascar island, she to be in guise of white and saffron, her groom in white and grain, with burning of nard and tapers, on a bridebed while clerks sung kyries and the anthem Ut novetur sexus omnis corporis mysterium till she was there unmaided. He gave them then a much admirable hymen minim by those delicate poets Master John Fletcher and Master Francis Beaumont that is in their Maid’s Tragedy that was writ for a like twining of lovers: To bed, to bed was the burden of it to be played with accompanable concent upon the virginals. An exquisite dulcet epithalame of most mollificative suadency for juveniles amatory whom the odoriferous flambeaus of the paranymphs have escorted to the quadrupedal proscenium of connubial communion. Well met they were, said Master Dixon, joyed, but, harkee, young sir, better were they named Beau Mount and Lecher for, by my troth, of such a mingling much might come. Young Stephen said indeed to his best remembrance they had but the one doxy between them and she of the stews to make shift with in delights amorous for life ran very high in those days and the custom of the country approved with it. Greater love than this, he said, no man hath that a man lay down his wife for his friend. Go thou and do likewise. Thus, or words to that effect, saith Zarathustra, sometime regius professor of French letters to the university of Oxtail nor breathed there ever that man to whom mankind was more beholden. Bring a stranger within thy tower it will go hard but thou wilt have the secondbest bed. Orate, fratres, pro memetipso. And all the people shall say, Amen. Remember, Erin, thy generations and thy days of old, how thou settedst little by me and by my word and broughtedst in a stranger to my gates to commit fornication in my sight and to wax fat and kick like Jeshurum. Therefore hast thou sinned against my light and hast made me, thy lord, to be the slave of servants. Return, return, Clan Milly: forget me not, O Milesian. Why hast thou done this abomination before me that thou didst spurn me for a merchant of jalaps and didst deny me to the Roman and to the Indian of dark speech with whom thy daughters did lie luxuriously? Look forth now, my people, upon the land of behest, even from Horeb and from Nebo and from Pisgah and from the Horns of Hatten unto a land flowing with milk and money. But thou hast suckled me with a bitter milk: my moon and my sun thou hast quenched for ever. And thou hast left me alone for ever in the dark ways of my bitterness: and with a kiss of ashes hast thou kissed my mouth. This tenebrosity of the interior, he proceeded to say, hath not been illumined by the wit of the septuagint nor so much as mentioned for the Orient from on high which brake hell’s gates visited a darkness that was foraneous. Assuefaction minorates atrocities (as Tully saith of his darling Stoics) and Hamlet his father showeth the prince no blister of combustion. The adiaphane in the noon of life is an Egypt’s plague which in the nights of prenativity and postmortemity is their most proper ubi and quomodo. And as the ends and ultimates of all things accord in some mean and measure with their inceptions and originals, that same multiplicit concordance which leads forth growth from birth accomplishing by a retrogressive metamorphosis that minishing and ablation towards the final which is agreeable unto nature so is it with our subsolar being. The aged sisters draw us into life: we wail, batten, sport, clip, clasp, sunder, dwindle, die: over us dead they bend. First, saved from waters of old Nile, among bulrushes, a bed of fasciated wattles: at last the cavity of a mountain, an occulted sepulchre amid the conclamation of the hillcat and the ossifrage. And as no man knows the ubicity of his tumulus nor to what processes we shall thereby be ushered nor whether to Tophet or to Edenville in the like way is all hidden when we would backward see from what region of remoteness the whatness of our whoness hath fetched his whenceness.

Thereto Punch Costello roared out mainly Etienne chanson but he loudly bid them, lo, wisdom hath built herself a house, this vast majestic longstablished vault, the crystal palace of the Creator, all in applepie order, a penny for him who finds the pea.

Behold the mansion reared by dedal Jack
See the malt stored in many a refluent sack,
In the proud cirque of Jackjohn’s bivouac.

A black crack of noise in the street here, alack, bawled back. Loud on left Thor thundered: in anger awful the hammerhurler. Came now the storm that hist his heart. And Master Lynch bade him have a care to flout and witwanton as the god self was angered for his hellprate and paganry. And he that had erst challenged to be so doughty waxed wan as they might all mark and shrank together and his pitch that was before so haught uplift was now of a sudden quite plucked down and his heart shook within the cage of his breast as he tasted the rumour of that storm. Then did some mock and some jeer and Punch Costello fell hard again to his yale which Master Lenehan vowed he would do after and he was indeed but a word and a blow on any the least colour. But the braggart boaster cried that an old Nobodaddy was in his cups it was muchwhat indifferent and he would not lag behind his lead. But this was only to dye his desperation as cowed he crouched in Horne’s hall. He drank indeed at one draught to pluck up a heart of any grace for it thundered long rumblingly over all the heavens so that Master Madden, being godly certain whiles, knocked him on his ribs upon that crack of doom and Master Bloom, at the braggart’s side, spoke to him calming words to slumber his great fear, advertising how it was no other thing but a hubbub noise that he heard, the discharge of fluid from the thunderhead, look you, having taken place, and all of the order of a natural phenomenon.

But was young Boasthard’s fear vanquished by Calmer’s words? No, for he had in his bosom a spike named Bitterness which could not by words be done away. And was he then neither calm like the one nor godly like the other? He was neither as much as he would have liked to be either. But could he not have endeavoured to have found again as in his youth the bottle Holiness that then he lived withal? Indeed no for Grace was not there to find that bottle. Heard he then in that clap the voice of the god Bringforth or, what Calmer said, a hubbub of Phenomenon? Heard? Why, he could not but hear unless he had plugged him up the tube Understanding (which he had not done). For through that tube he saw that he was in the land of Phenomenon where he must for a certain one day die as he was like the rest too a passing show. And would he not accept to die like the rest and pass away? By no means would he though he must nor would he make more shows according as men do with wives which Phenomenon has commanded them to do by the book Law. Then wotted he nought of that other land which is called Believe-on-Me, that is the land of promise which behoves to the king Delightful and shall be for ever where there is no death and no birth neither wiving nor mothering at which all shall come as many as believe on it? Yes, Pious had told him of that land and Chaste had pointed him to the way but the reason was that in the way he fell in with a certain whore of an eyepleasing exterior whose name, she said, is Bird-in-the-Hand and she beguiled him wrongways from the true path by her flatteries that she said to him as, Ho, you pretty man, turn aside hither and I will show you a brave place, and she lay at him so flatteringly that she had him in her grot which is named Two-in-the-Bush or, by some learned, Carnal Concupiscence.

This was it what all that company that sat there at commons in Manse of Mothers the most lusted after and if they met with this whore Bird-in-the-Hand (which was within all foul plagues, monsters and a wicked devil) they would strain the last but they would make at her and know her. For regarding Believe-on-Me they said it was nought else but notion and they could conceive no thought of it for, first, Two-in-the-Bush whither she ticed them was the very goodliest grot and in it were four pillows on which were four tickets with these words printed on them, Pickaback and Topsyturvy and Shameface and Cheek by Jowl and, second, for that foul plague Allpox and the monsters they cared not for them for Preservative had given them a stout shield of oxengut and, third, that they might take no hurt neither from Offspring that was that wicked devil by virtue of this same shield which was named Killchild. So were they all in their blind fancy, Mr Cavil and Mr Sometimes Godly, Mr Ape Swillale, Mr False Franklin, Mr Dainty Dixon, Young Boasthard and Mr Cautious Calmer. Wherein, O wretched company, were ye all deceived for that was the voice of the god that was in a very grievous rage that he would presently lift his arm up and spill their souls for their abuses and their spillings done by them contrariwise to his word which forth to bring brenningly biddeth.

So Thursday sixteenth June Patk. Dignam laid in clay of an apoplexy and after hard drought, please God, rained, a bargeman coming in by water a fifty mile or thereabout with turf saying the seed won’t sprout, fields athirst, very sadcoloured and stunk mightily, the quags and tofts too. Hard to breathe and all the young quicks clean consumed without sprinkle this long while back as no man remembered to be without. The rosy buds all gone brown and spread out blobs and on the hills nought but dry flag and faggots that would catch at first fire. All the world saying, for aught they knew, the big wind of last February a year that did havoc the land so pitifully a small thing beside this barrenness. But by and by, as said, this evening after sundown, the wind sitting in the west, biggish swollen clouds to be seen as the night increased and the weatherwise poring up at them and some sheet lightnings at first and after, past ten of the clock, one great stroke with a long thunder and in a brace of shakes all scamper pellmell within door for the smoking shower, the men making shelter for their straws with a clout or kerchief, womenfolk skipping off with kirtles catched up soon as the pour came. In Ely place, Baggot street, Duke’s lawn, thence through Merrion green up to Holles street a swash of water flowing that was before bonedry and not one chair or coach or fiacre seen about but no more crack after that first. Over against the Rt. Hon. Mr Justice Fitzgibbon’s door (that is to sit with Mr Healy the lawyer upon the college lands) Mal. Mulligan a gentleman’s gentleman that had but come from Mr Moore’s the writer’s (that was a papish but is now, folk say, a good Williamite) chanced against Alec. Bannon in a cut bob (which are now in with dance cloaks of Kendal green) that was new got to town from Mullingar with the stage where his coz and Mal M’s brother will stay a month yet till Saint Swithin and asks what in the earth he does there, he bound home and he to Andrew Horne’s being stayed for to crush a cup of wine, so he said, but would tell him of a skittish heifer, big of her age and beef to the heel, and all this while poured with rain and so both together on to Horne’s. There Leop. Bloom of Crawford’s journal sitting snug with a covey of wags, likely brangling fellows, Dixon jun., scholar of my lady of Mercy’s, Vin. Lynch, a Scots fellow, Will. Madden, T. Lenehan, very sad about a racer he fancied and Stephen D. Leop. Bloom there for a languor he had but was now better, he having dreamed tonight a strange fancy of his dame Mrs Moll with red slippers on in a pair of Turkey trunks which is thought by those in ken to be for a change and Mistress Purefoy there, that got in through pleading her belly, and now on the stools, poor body, two days past her term, the midwives sore put to it and can’t deliver, she queasy for a bowl of riceslop that is a shrewd drier up of the insides and her breath very heavy more than good and should be a bullyboy from the knocks, they say, but God give her soon issue. ’Tis her ninth chick to live, I hear, and Lady day bit off her last chick’s nails that was then a twelvemonth and with other three all breastfed that died written out in a fair hand in the king’s bible. Her hub fifty odd and a methodist but takes the sacrament and is to be seen any fair sabbath with a pair of his boys off Bullock harbour dapping on the sound with a heavybraked reel or in a punt he has trailing for flounder and pollock and catches a fine bag, I hear. In sum an infinite great fall of rain and all refreshed and will much increase the harvest yet those in ken say after wind and water fire shall come for a prognostication of Malachi’s almanac (and I hear that Mr Russell has done a prophetical charm of the same gist out of the Hindustanish for his farmer’s gazette) to have three things in all but this a mere fetch without bottom of reason for old crones and bairns yet sometimes they are found in the right guess with their queerities no telling how.

With this came up Lenehan to the feet of the table to say how the letter was in that night’s gazette and he made a show to find it about him (for he swore with an oath that he had been at pains about it) but on Stephen’s persuasion he gave over the search and was bidden to sit near by which he did mighty brisk. He was a kind of sport gentleman that went for a merryandrew or honest pickle and what belonged of women, horseflesh or hot scandal he had it pat. To tell the truth he was mean in fortunes and for the most part hankered about the coffeehouses and low taverns with crimps, ostlers, bookies, Paul’s men, runners, flatcaps, waistcoateers, ladies of the bagnio and other rogues of the game or with a chanceable catchpole or a tipstaff often at nights till broad day of whom he picked up between his sackpossets much loose gossip. He took his ordinary at a boilingcook’s and if he had but gotten into him a mess of broken victuals or a platter of tripes with a bare tester in his purse he could always bring himself off with his tongue, some randy quip he had from a punk or whatnot that every mother’s son of them would burst their sides. The other, Costello that is, hearing this talk asked was it poetry or a tale. Faith, no, he says, Frank (that was his name), ’tis all about Kerry cows that are to be butchered along of the plague. But they can go hang, says he with a wink, for me with their bully beef, a pox on it. There’s as good fish in this tin as ever came out of it and very friendly he offered to take of some salty sprats that stood by which he had eyed wishly in the meantime and found the place which was indeed the chief design of his embassy as he was sharpset. Mort aux vaches, says Frank then in the French language that had been indentured to a brandyshipper that has a winelodge in Bordeaux and he spoke French like a gentleman too. From a child this Frank had been a donought that his father, a headborough, who could ill keep him to school to learn his letters and the use of the globes, matriculated at the university to study the mechanics but he took the bit between his teeth like a raw colt and was more familiar with the justiciary and the parish beadle than with his volumes. One time he would be a playactor, then a sutler or a welsher, then nought would keep him from the bearpit and the cocking main, then he was for the ocean sea or to hoof it on the roads with the romany folk, kidnapping a squire’s heir by favour of moonlight or fecking maids’ linen or choking chicken behind a hedge. He had been off as many times as a cat has lives and back again with naked pockets as many more to his father the headborough who shed a pint of tears as often as he saw him. What, says Mr Leopold with his hands across, that was earnest to know the drift of it, will they slaughter all? I protest I saw them but this day morning going to the Liverpool boats, says he. I can scarce believe ’tis so bad, says he. And he had experience of the like brood beasts and of springers, greasy hoggets and wether wool, having been some years before actuary for Mr Joseph Cuffe, a worthy salesmaster that drove his trade for live stock and meadow auctions hard by Mr Gavin Low’s yard in Prussia street. I question with you there, says he. More like ’tis the hoose or the timber tongue. Mr Stephen, a little moved but very handsomely told him no such matter and that he had dispatches from the emperor’s chief tailtickler thanking him for the hospitality, that was sending over Doctor Rinderpest, the bestquoted cowcatcher in all Muscovy, with a bolus or two of physic to take the bull by the horns. Come, come, says Mr Vincent, plain dealing. He’ll find himself on the horns of a dilemma if he meddles with a bull that’s Irish, says he. Irish by name and irish by nature, says Mr Stephen, and he sent the ale purling about, an Irish bull in an English chinashop. I conceive you, says Mr Dixon. It is that same bull that was sent to our island by farmer Nicholas, the bravest cattlebreeder of them all, with an emerald ring in his nose. True for you, says Mr Vincent cross the table, and a bullseye into the bargain, says he, and a plumper and a portlier bull, says he, never shit on shamrock. He had horns galore, a coat of cloth of gold and a sweet smoky breath coming out of his nostrils so that the women of our island, leaving doughballs and rollingpins, followed after him hanging his bulliness in daisychains. What for that, says Mr Dixon, but before he came over farmer Nicholas that was a eunuch had him properly gelded by a college of doctors who were no better off than himself. So be off now, says he, and do all my cousin german the lord Harry tells you and take a farmer’s blessing, and with that he slapped his posteriors very soundly. But the slap and the blessing stood him friend, says Mr Vincent, for to make up he taught him a trick worth two of the other so that maid, wife, abbess and widow to this day affirm that they would rather any time of the month whisper in his ear in the dark of a cowhouse or get a lick on the nape from his long holy tongue than lie with the finest strapping young ravisher in the four fields of all Ireland. Another then put in his word: And they dressed him, says he, in a point shift and petticoat with a tippet and girdle and ruffles on his wrists and clipped his forelock and rubbed him all over with spermacetic oil and built stables for him at every turn of the road with a gold manger in each full of the best hay in the market so that he could doss and dung to his heart’s content. By this time the father of the faithful (for so they called him) was grown so heavy that he could scarce walk to pasture. To remedy which our cozening dames and damsels brought him his fodder in their apronlaps and as soon as his belly was full he would rear up on his hind quarters to show their ladyships a mystery and roar and bellow out of him in bulls’ language and they all after him. Ay, says another, and so pampered was he that he would suffer nought to grow in all the land but green grass for himself (for that was the only colour to his mind) and there was a board put up on a hillock in the middle of the island with a printed notice, saying: By the Lord Harry, Green is the grass that grows on the ground. And, says Mr Dixon, if ever he got scent of a cattleraider in Roscommon or the wilds of Connemara or a husbandman in Sligo that was sowing as much as a handful of mustard or a bag of rapeseed out he’d run amok over half the countryside rooting up with his horns whatever was planted and all by lord Harry’s orders. There was bad blood between them at first, says Mr Vincent, and the lord Harry called farmer Nicholas all the old Nicks in the world and an old whoremaster that kept seven trulls in his house and I’ll meddle in his matters, says he. I’ll make that animal smell hell, says he, with the help of that good pizzle my father left me. But one evening, says Mr Dixon, when the lord Harry was cleaning his royal pelt to go to dinner after winning a boatrace (he had spade oars for himself but the first rule of the course was that the others were to row with pitchforks) he discovered in himself a wonderful likeness to a bull and on picking up a blackthumbed chapbook that he kept in the pantry he found sure enough that he was a lefthanded descendant of the famous champion bull of the Romans, Bos Bovum, which is good bog Latin for boss of the show. After that, says Mr Vincent, the lord Harry put his head into a cow’s drinkingtrough in the presence of all his courtiers and pulling it out again told them all his new name. Then, with the water running off him, he got into an old smock and skirt that had belonged to his grandmother and bought a grammar of the bulls’ language to study but he could never learn a word of it except the first personal pronoun which he copied out big and got off by heart and if ever he went out for a walk he filled his pockets with chalk to write it upon what took his fancy, the side of a rock or a teahouse table or a bale of cotton or a corkfloat. In short, he and the bull of Ireland were soon as fast friends as an arse and a shirt. They were, says Mr Stephen, and the end was that the men of the island seeing no help was toward, as the ungrate women were all of one mind, made a wherry raft, loaded themselves and their bundles of chattels on shipboard, set all masts erect, manned the yards, sprang their luff, heaved to, spread three sheets in the wind, put her head between wind and water, weighed anchor, ported her helm, ran up the jolly Roger, gave three times three, let the bullgine run, pushed off in their bumboat and put to sea to recover the main of America. Which was the occasion, says Mr Vincent, of the composing by a boatswain of that rollicking chanty:

—Pope Peter’s but a pissabed.
A man’s a man for a’ that.

Our worthy acquaintance Mr Malachi Mulligan now appeared in the doorway as the students were finishing their apologue accompanied with a friend whom he had just rencountered, a young gentleman, his name Alec Bannon, who had late come to town, it being his intention to buy a colour or a cornetcy in the fencibles and list for the wars. Mr Mulligan was civil enough to express some relish of it all the more as it jumped with a project of his own for the cure of the very evil that had been touched on. Whereat he handed round to the company a set of pasteboard cards which he had had printed that day at Mr Quinnell’s bearing a legend printed in fair italics: Mr Malachi Mulligan. Fertiliser and Incubator. Lambay Island. His project, as he went on to expound, was to withdraw from the round of idle pleasures such as form the chief business of sir Fopling Popinjay and sir Milksop Quidnunc in town and to devote himself to the noblest task for which our bodily organism has been framed. Well, let us hear of it, good my friend, said Mr Dixon. I make no doubt it smacks of wenching. Come, be seated, both. ’Tis as cheap sitting as standing. Mr Mulligan accepted of the invitation and, expatiating upon his design, told his hearers that he had been led into this thought by a consideration of the causes of sterility, both the inhibitory and the prohibitory, whether the inhibition in its turn were due to conjugal vexations or to a parsimony of the balance as well as whether the prohibition proceeded from defects congenital or from proclivities acquired. It grieved him plaguily, he said, to see the nuptial couch defrauded of its dearest pledges: and to reflect upon so many agreeable females with rich jointures, a prey to the vilest bonzes, who hide their flambeau under a bushel in an uncongenial cloister or lose their womanly bloom in the embraces of some unaccountable muskin when they might multiply the inlets of happiness, sacrificing the inestimable jewel of their sex when a hundred pretty fellows were at hand to caress, this, he assured them, made his heart weep. To curb this inconvenient (which he concluded due to a suppression of latent heat), having advised with certain counsellors of worth and inspected into this matter, he had resolved to purchase in fee simple for ever the freehold of Lambay island from its holder, lord Talbot de Malahide, a Tory gentleman of note much in favour with our ascendancy party. He proposed to set up there a national fertilising farm to be named Omphalos with an obelisk hewn and erected after the fashion of Egypt and to offer his dutiful yeoman services for the fecundation of any female of what grade of life soever who should there direct to him with the desire of fulfilling the functions of her natural. Money was no object, he said, nor would he take a penny for his pains. The poorest kitchenwench no less than the opulent lady of fashion, if so be their constructions and their tempers were warm persuaders for their petitions, would find in him their man. For his nutriment he shewed how he would feed himself exclusively upon a diet of savoury tubercles and fish and coneys there, the flesh of these latter prolific rodents being highly recommended for his purpose, both broiled and stewed with a blade of mace and a pod or two of capsicum chillies. After this homily which he delivered with much warmth of asseveration Mr Mulligan in a trice put off from his hat a kerchief with which he had shielded it. They both, it seems, had been overtaken by the rain and for all their mending their pace had taken water, as might be observed by Mr Mulligan’s smallclothes of a hodden grey which was now somewhat piebald. His project meanwhile was very favourably entertained by his auditors and won hearty eulogies from all though Mr Dixon of Mary’s excepted to it, asking with a finicking air did he purpose also to carry coals to Newcastle. Mr Mulligan however made court to the scholarly by an apt quotation from the classics which, as it dwelt upon his memory, seemed to him a sound and tasteful support of his contention: Talis ac tanta depravatio hujus seculi, O quirites, ut matresfamiliarum nostrae lascivas cujuslibet semiviri libici titillationes testibus ponderosis atque excelsis erectionibus centurionum Romanorum magnopere anteponunt, while for those of ruder wit he drove home his point by analogies of the animal kingdom more suitable to their stomach, the buck and doe of the forest glade, the farmyard drake and duck.

Valuing himself not a little upon his elegance, being indeed a proper man of person, this talkative now applied himself to his dress with animadversions of some heat upon the sudden whimsy of the atmospherics while the company lavished their encomiums upon the project he had advanced. The young gentleman, his friend, overjoyed as he was at a passage that had late befallen him, could not forbear to tell it his nearest neighbour. Mr Mulligan, now perceiving the table, asked for whom were those loaves and fishes and, seeing the stranger, he made him a civil bow and said, Pray, sir, was you in need of any professional assistance we could give? Who, upon his offer, thanked him very heartily, though preserving his proper distance, and replied that he was come there about a lady, now an inmate of Horne’s house, that was in an interesting condition, poor body, from woman’s woe (and here he fetched a deep sigh) to know if her happiness had yet taken place. Mr Dixon, to turn the table, took on to ask of Mr Mulligan himself whether his incipient ventripotence, upon which he rallied him, betokened an ovoblastic gestation in the prostatic utricle or male womb or was due, as with the noted physician, Mr Austin Meldon, to a wolf in the stomach. For answer Mr Mulligan, in a gale of laughter at his smalls, smote himself bravely below the diaphragm, exclaiming with an admirable droll mimic of Mother Grogan (the most excellent creature of her sex though ’tis pity she’s a trollop): There’s a belly that never bore a bastard. This was so happy a conceit that it renewed the storm of mirth and threw the whole room into the most violent agitations of delight. The spry rattle had run on in the same vein of mimicry but for some larum in the antechamber.

Here the listener who was none other than the Scotch student, a little fume of a fellow, blond as tow, congratulated in the liveliest fashion with the young gentleman and, interrupting the narrative at a salient point, having desired his visavis with a polite beck to have the obligingness to pass him a flagon of cordial waters at the same time by a questioning poise of the head (a whole century of polite breeding had not achieved so nice a gesture) to which was united an equivalent but contrary balance of the bottle asked the narrator as plainly as was ever done in words if he might treat him with a cup of it. Mais bien sûr, noble stranger, said he cheerily, et mille compliments. That you may and very opportunely. There wanted nothing but this cup to crown my felicity. But, gracious heaven, was I left with but a crust in my wallet and a cupful of water from the well, my God, I would accept of them and find it in my heart to kneel down upon the ground and give thanks to the powers above for the happiness vouchsafed me by the Giver of good things. With these words he approached the goblet to his lips, took a complacent draught of the cordial, slicked his hair and, opening his bosom, out popped a locket that hung from a silk riband, that very picture which he had cherished ever since her hand had wrote therein. Gazing upon those features with a world of tenderness, Ah, Monsieur, he said, had you but beheld her as I did with these eyes at that affecting instant with her dainty tucker and her new coquette cap (a gift for her feastday as she told me prettily) in such an artless disorder, of so melting a tenderness, ’pon my conscience, even you, Monsieur, had been impelled by generous nature to deliver yourself wholly into the hands of such an enemy or to quit the field for ever. I declare, I was never so touched in all my life. God, I thank thee, as the Author of my days! Thrice happy will he be whom so amiable a creature will bless with her favours. A sigh of affection gave eloquence to these words and, having replaced the locket in his bosom, he wiped his eye and sighed again. Beneficent Disseminator of blessings to all Thy creatures, how great and universal must be that sweetest of Thy tyrannies which can hold in thrall the free and the bond, the simple swain and the polished coxcomb, the lover in the heyday of reckless passion and the husband of maturer years. But indeed, sir, I wander from the point. How mingled and imperfect are all our sublunary joys. Maledicity! he exclaimed in anguish. Would to God that foresight had but remembered me to take my cloak along! I could weep to think of it. Then, though it had poured seven showers, we were neither of us a penny the worse. But beshrew me, he cried, clapping hand to his forehead, tomorrow will be a new day and, thousand thunders, I know of a marchand de capotes, Monsieur Poyntz, from whom I can have for a livre as snug a cloak of the French fashion as ever kept a lady from wetting. Tut, tut! cries Le Fécondateur, tripping in, my friend Monsieur Moore, that most accomplished traveller (I have just cracked a half bottle avec lui in a circle of the best wits of the town), is my authority that in Cape Horn, ventre biche, they have a rain that will wet through any, even the stoutest cloak. A drenching of that violence, he tells me, sans blague, has sent more than one luckless fellow in good earnest posthaste to another world. Pooh! A livre! cries Monsieur Lynch. The clumsy things are dear at a sou. One umbrella, were it no bigger than a fairy mushroom, is worth ten such stopgaps. No woman of any wit would wear one. My dear Kitty told me today that she would dance in a deluge before ever she would starve in such an ark of salvation for, as she reminded me (blushing piquantly and whispering in my ear though there was none to snap her words but giddy butterflies), dame Nature, by the divine blessing, has implanted it in our hearts and it has become a household word that il y a deux choses for which the innocence of our original garb, in other circumstances a breach of the proprieties, is the fittest, nay, the only garment. The first, said she (and here my pretty philosopher, as I handed her to her tilbury, to fix my attention, gently tipped with her tongue the outer chamber of my ear), the first is a bath... But at this point a bell tinkling in the hall cut short a discourse which promised so bravely for the enrichment of our store of knowledge.

Amid the general vacant hilarity of the assembly a bell rang and, while all were conjecturing what might be the cause, Miss Callan entered and, having spoken a few words in a low tone to young Mr Dixon, retired with a profound bow to the company. The presence even for a moment among a party of debauchees of a woman endued with every quality of modesty and not less severe than beautiful refrained the humourous sallies even of the most licentious but her departure was the signal for an outbreak of ribaldry. Strike me silly, said Costello, a low fellow who was fuddled. A monstrous fine bit of cowflesh! I’ll be sworn she has rendezvoused you. What, you dog? Have you a way with them? Gad’s bud, immensely so, said Mr Lynch. The bedside manner it is that they use in the Mater hospice. Demme, does not Doctor O’Gargle chuck the nuns there under the chin. As I look to be saved I had it from my Kitty who has been wardmaid there any time these seven months. Lawksamercy, doctor, cried the young blood in the primrose vest, feigning a womanish simper and with immodest squirmings of his body, how you do tease a body! Drat the man! Bless me, I’m all of a wibbly wobbly. Why, you’re as bad as dear little Father Cantekissem, that you are! May this pot of four half choke me, cried Costello, if she aint in the family way. I knows a lady what’s got a white swelling quick as I claps eyes on her. The young surgeon, however, rose and begged the company to excuse his retreat as the nurse had just then informed him that he was needed in the ward. Merciful providence had been pleased to put a period to the sufferings of the lady who was enceinte which she had borne with a laudable fortitude and she had given birth to a bouncing boy. I want patience, said he, with those who, without wit to enliven or learning to instruct, revile an ennobling profession which, saving the reverence due to the Deity, is the greatest power for happiness upon the earth. I am positive when I say that if need were I could produce a cloud of witnesses to the excellence of her noble exercitations which, so far from being a byword, should be a glorious incentive in the human breast. I cannot away with them. What? Malign such an one, the amiable Miss Callan, who is the lustre of her own sex and the astonishment of ours? And at an instant the most momentous that can befall a puny child of clay? Perish the thought! I shudder to think of the future of a race where the seeds of such malice have been sown and where no right reverence is rendered to mother and maid in house of Horne. Having delivered himself of this rebuke he saluted those present on the by and repaired to the door. A murmur of approval arose from all and some were for ejecting the low soaker without more ado, a design which would have been effected nor would he have received more than his bare deserts had he not abridged his transgression by affirming with a horrid imprecation (for he swore a round hand) that he was as good a son of the true fold as ever drew breath. Stap my vitals, said he, them was always the sentiments of honest Frank Costello which I was bred up most particular to honour thy father and thy mother that had the best hand to a rolypoly or a hasty pudding as you ever see what I always looks back on with a loving heart.

To revert to Mr Bloom who, after his first entry, had been conscious of some impudent mocks which he however had borne with as being the fruits of that age upon which it is commonly charged that it knows not pity. The young sparks, it is true, were as full of extravagancies as overgrown children: the words of their tumultuary discussions were difficultly understood and not often nice: their testiness and outrageous mots were such that his intellects resiled from: nor were they scrupulously sensible of the proprieties though their fund of strong animal spirits spoke in their behalf. But the word of Mr Costello was an unwelcome language for him for he nauseated the wretch that seemed to him a cropeared creature of a misshapen gibbosity, born out of wedlock and thrust like a crookback toothed and feet first into the world, which the dint of the surgeon’s pliers in his skull lent indeed a colour to, so as to put him in thought of that missing link of creation’s chain desiderated by the late ingenious Mr Darwin. It was now for more than the middle span of our allotted years that he had passed through the thousand vicissitudes of existence and, being of a wary ascendancy and self a man of rare forecast, he had enjoined his heart to repress all motions of a rising choler and, by intercepting them with the readiest precaution, foster within his breast that plenitude of sufferance which base minds jeer at, rash judgers scorn and all find tolerable and but tolerable. To those who create themselves wits at the cost of feminine delicacy (a habit of mind which he never did hold with) to them he would concede neither to bear the name nor to herit the tradition of a proper breeding: while for such that, having lost all forbearance, can lose no more, there remained the sharp antidote of experience to cause their insolency to beat a precipitate and inglorious retreat. Not but what he could feel with mettlesome youth which, caring nought for the mows of dotards or the gruntlings of the severe, is ever (as the chaste fancy of the Holy Writer expresses it) for eating of the tree forbid it yet not so far forth as to pretermit humanity upon any condition soever towards a gentlewoman when she was about her lawful occasions. To conclude, while from the sister’s words he had reckoned upon a speedy delivery he was, however, it must be owned, not a little alleviated by the intelligence that the issue so auspicated after an ordeal of such duress now testified once more to the mercy as well as to the bounty of the Supreme Being.

Accordingly he broke his mind to his neighbour, saying that, to express his notion of the thing, his opinion (who ought not perchance to express one) was that one must have a cold constitution and a frigid genius not to be rejoiced by this freshest news of the fruition of her confinement since she had been in such pain through no fault of hers. The dressy young blade said it was her husband’s that put her in that expectation or at least it ought to be unless she were another Ephesian matron. I must acquaint you, said Mr Crotthers, clapping on the table so as to evoke a resonant comment of emphasis, old Glory Allelujurum was round again today, an elderly man with dundrearies, preferring through his nose a request to have word of Wilhelmina, my life, as he calls her. I bade him hold himself in readiness for that the event would burst anon. ’Slife, I’ll be round with you. I cannot but extol the virile potency of the old bucko that could still knock another child out of her. All fell to praising of it, each after his own fashion, though the same young blade held with his former view that another than her conjugial had been the man in the gap, a clerk in orders, a linkboy (virtuous) or an itinerant vendor of articles needed in every household. Singular, communed the guest with himself, the wonderfully unequal faculty of metempsychosis possessed by them, that the puerperal dormitory and the dissecting theatre should be the seminaries of such frivolity, that the mere acquisition of academic titles should suffice to transform in a pinch of time these votaries of levity into exemplary practitioners of an art which most men anywise eminent have esteemed the noblest. But, he further added, it is mayhap to relieve the pentup feelings that in common oppress them for I have more than once observed that birds of a feather laugh together.

But with what fitness, let it be asked of the noble lord, his patron, has this alien, whom the concession of a gracious prince has admitted to civic rights, constituted himself the lord paramount of our internal polity? Where is now that gratitude which loyalty should have counselled? During the recent war whenever the enemy had a temporary advantage with his granados did this traitor to his kind not seize that moment to discharge his piece against the empire of which he is a tenant at will while he trembled for the security of his four per cents? Has he forgotten this as he forgets all benefits received? Or is it that from being a deluder of others he has become at last his own dupe as he is, if report belie him not, his own and his only enjoyer? Far be it from candour to violate the bedchamber of a respectable lady, the daughter of a gallant major, or to cast the most distant reflections upon her virtue but if he challenges attention there (as it was indeed highly his interest not to have done) then be it so. Unhappy woman, she has been too long and too persistently denied her legitimate prerogative to listen to his objurgations with any other feeling than the derision of the desperate. He says this, a censor of morals, a very pelican in his piety, who did not scruple, oblivious of the ties of nature, to attempt illicit intercourse with a female domestic drawn from the lowest strata of society! Nay, had the hussy’s scouringbrush not been her tutelary angel, it had gone with her as hard as with Hagar, the Egyptian! In the question of the grazing lands his peevish asperity is notorious and in Mr Cuffe’s hearing brought upon him from an indignant rancher a scathing retort couched in terms as straightforward as they were bucolic. It ill becomes him to preach that gospel. Has he not nearer home a seedfield that lies fallow for the want of the ploughshare? A habit reprehensible at puberty is second nature and an opprobrium in middle life. If he must dispense his balm of Gilead in nostrums and apothegms of dubious taste to restore to health a generation of unfledged profligates let his practice consist better with the doctrines that now engross him. His marital breast is the repository of secrets which decorum is reluctant to adduce. The lewd suggestions of some faded beauty may console him for a consort neglected and debauched but this new exponent of morals and healer of ills is at his best an exotic tree which, when rooted in its native orient, throve and flourished and was abundant in balm but, transplanted to a clime more temperate, its roots have lost their quondam vigour while the stuff that comes away from it is stagnant, acid and inoperative.

The news was imparted with a circumspection recalling the ceremonial usage of the Sublime Porte by the second female infirmarian to the junior medical officer in residence, who in his turn announced to the delegation that an heir had been born. When he had betaken himself to the women’s apartment to assist at the prescribed ceremony of the afterbirth in the presence of the secretary of state for domestic affairs and the members of the privy council, silent in unanimous exhaustion and approbation the delegates, chafing under the length and solemnity of their vigil and hoping that the joyful occurrence would palliate a licence which the simultaneous absence of abigail and obstetrician rendered the easier, broke out at once into a strife of tongues. In vain the voice of Mr Canvasser Bloom was heard endeavouring to urge, to mollify, to refrain. The moment was too propitious for the display of that discursiveness which seemed the only bond of union among tempers so divergent. Every phase of the situation was successively eviscerated: the prenatal repugnance of uterine brothers, the Caesarean section, posthumity with respect to the father and, that rarer form, with respect to the mother, the fratricidal case known as the Childs Murder and rendered memorable by the impassioned plea of Mr Advocate Bushe which secured the acquittal of the wrongfully accused, the rights of primogeniture and king’s bounty touching twins and triplets, miscarriages and infanticides, simulated or dissimulated, the acardiac foetus in foetu and aprosopia due to a congestion, the agnathia of certain chinless Chinamen (cited by Mr Candidate Mulligan) in consequence of defective reunion of the maxillary knobs along the medial line so that (as he said) one ear could hear what the other spoke, the benefits of anesthesia or twilight sleep, the prolongation of labour pains in advanced gravidancy by reason of pressure on the vein, the premature relentment of the amniotic fluid (as exemplified in the actual case) with consequent peril of sepsis to the matrix, artificial insemination by means of syringes, involution of the womb consequent upon the menopause, the problem of the perpetration of the species in the case of females impregnated by delinquent rape, that distressing manner of delivery called by the Brandenburghers Sturzgeburt, the recorded instances of multiseminal, twikindled and monstrous births conceived during the catamenic period or of consanguineous parents—in a word all the cases of human nativity which Aristotle has classified in his masterpiece with chromolithographic illustrations. The gravest problems of obstetrics and forensic medicine were examined with as much animation as the most popular beliefs on the state of pregnancy such as the forbidding to a gravid woman to step over a countrystile lest, by her movement, the navelcord should strangle her creature and the injunction upon her in the event of a yearning, ardently and ineffectually entertained, to place her hand against that part of her person which long usage has consecrated as the seat of castigation. The abnormalities of harelip, breastmole, supernumerary digits, negro’s inkle, strawberry mark and portwine stain were alleged by one as a prima facie and natural hypothetical explanation of those swineheaded (the case of Madame Grissel Steevens was not forgotten) or doghaired infants occasionally born. The hypothesis of a plasmic memory, advanced by the Caledonian envoy and worthy of the metaphysical traditions of the land he stood for, envisaged in such cases an arrest of embryonic development at some stage antecedent to the human. An outlandish delegate sustained against both these views, with such heat as almost carried conviction, the theory of copulation between women and the males of brutes, his authority being his own avouchment in support of fables such as that of the Minotaur which the genius of the elegant Latin poet has handed down to us in the pages of his Metamorphoses. The impression made by his words was immediate but shortlived. It was effaced as easily as it had been evoked by an allocution from Mr Candidate Mulligan in that vein of pleasantry which none better than he knew how to affect, postulating as the supremest object of desire a nice clean old man. Contemporaneously, a heated argument having arisen between Mr Delegate Madden and Mr Candidate Lynch regarding the juridical and theological dilemma created in the event of one Siamese twin predeceasing the other, the difficulty by mutual consent was referred to Mr Canvasser Bloom for instant submittal to Mr Coadjutor Deacon Dedalus. Hitherto silent, whether the better to show by preternatural gravity that curious dignity of the garb with which he was invested or in obedience to an inward voice, he delivered briefly and, as some thought, perfunctorily the ecclesiastical ordinance forbidding man to put asunder what God has joined.

But Malachias’ tale began to freeze them with horror. He conjured up the scene before them. The secret panel beside the chimney slid back and in the recess appeared... Haines! Which of us did not feel his flesh creep! He had a portfolio full of Celtic literature in one hand, in the other a phial marked Poison. Surprise, horror, loathing were depicted on all faces while he eyed them with a ghostly grin. I anticipated some such reception, he began with an eldritch laugh, for which, it seems, history is to blame. Yes, it is true. I am the murderer of Samuel Childs. And how I am punished! The inferno has no terrors for me. This is the appearance is on me. Tare and ages, what way would I be resting at all, he muttered thickly, and I tramping Dublin this while back with my share of songs and himself after me the like of a soulth or a bullawurrus? My hell, and Ireland’s, is in this life. It is what I tried to obliterate my crime. Distractions, rookshooting, the Erse language (he recited some), laudanum (he raised the phial to his lips), camping out. In vain! His spectre stalks me. Dope is my only hope... Ah! Destruction! The black panther! With a cry he suddenly vanished and the panel slid back. An instant later his head appeared in the door opposite and said: Meet me at Westland Row station at ten past eleven. He was gone. Tears gushed from the eyes of the dissipated host. The seer raised his hand to heaven, murmuring: The vendetta of Mananaun! The sage repeated: Lex talionis. The sentimentalist is he who would enjoy without incurring the immense debtorship for a thing done. Malachias, overcome by emotion, ceased. The mystery was unveiled. Haines was the third brother. His real name was Childs. The black panther was himself the ghost of his own father. He drank drugs to obliterate. For this relief much thanks. The lonely house by the graveyard is uninhabited. No soul will live there. The spider pitches her web in the solitude. The nocturnal rat peers from his hole. A curse is on it. It is haunted. Murderer’s ground.

What is the age of the soul of man? As she hath the virtue of the chameleon to change her hue at every new approach, to be gay with the merry and mournful with the downcast, so too is her age changeable as her mood. No longer is Leopold, as he sits there, ruminating, chewing the cud of reminiscence, that staid agent of publicity and holder of a modest substance in the funds. A score of years are blown away. He is young Leopold. There, as in a retrospective arrangement, a mirror within a mirror (hey, presto!), he beholdeth himself. That young figure of then is seen, precociously manly, walking on a nipping morning from the old house in Clanbrassil street to the high school, his booksatchel on him bandolierwise, and in it a goodly hunk of wheaten loaf, a mother’s thought. Or it is the same figure, a year or so gone over, in his first hard hat (ah, that was a day!), already on the road, a fullfledged traveller for the family firm, equipped with an orderbook, a scented handkerchief (not for show only), his case of bright trinketware (alas! a thing now of the past!) and a quiverful of compliant smiles for this or that halfwon housewife reckoning it out upon her fingertips or for a budding virgin, shyly acknowledging (but the heart? tell me!) his studied baisemoins. The scent, the smile, but, more than these, the dark eyes and oleaginous address, brought home at duskfall many a commission to the head of the firm, seated with Jacob’s pipe after like labours in the paternal ingle (a meal of noodles, you may be sure, is aheating), reading through round horned spectacles some paper from the Europe of a month before. But hey, presto, the mirror is breathed on and the young knighterrant recedes, shrivels, dwindles to a tiny speck within the mist. Now he is himself paternal and these about him might be his sons. Who can say? The wise father knows his own child. He thinks of a drizzling night in Hatch street, hard by the bonded stores there, the first. Together (she is a poor waif, a child of shame, yours and mine and of all for a bare shilling and her luckpenny), together they hear the heavy tread of the watch as two raincaped shadows pass the new royal university. Bridie! Bridie Kelly! He will never forget the name, ever remember the night: first night, the bridenight. They are entwined in nethermost darkness, the willer with the willed, and in an instant (fiat!) light shall flood the world. Did heart leap to heart? Nay, fair reader. In a breath ’twas done but—hold! Back! It must not be! In terror the poor girl flees away through the murk. She is the bride of darkness, a daughter of night. She dare not bear the sunnygolden babe of day. No, Leopold. Name and memory solace thee not. That youthful illusion of thy strength was taken from thee—and in vain. No son of thy loins is by thee. There is none now to be for Leopold, what Leopold was for Rudolph.

The voices blend and fuse in clouded silence: silence that is the infinite of space: and swiftly, silently the soul is wafted over regions of cycles of generations that have lived. A region where grey twilight ever descends, never falls on wide sagegreen pasturefields, shedding her dusk, scattering a perennial dew of stars. She follows her mother with ungainly steps, a mare leading her fillyfoal. Twilight phantoms are they, yet moulded in prophetic grace of structure, slim shapely haunches, a supple tendonous neck, the meek apprehensive skull. They fade, sad phantoms: all is gone. Agendath is a waste land, a home of screechowls and the sandblind upupa. Netaim, the golden, is no more. And on the highway of the clouds they come, muttering thunder of rebellion, the ghosts of beasts. Huuh! Hark! Huuh! Parallax stalks behind and goads them, the lancinating lightnings of whose brow are scorpions. Elk and yak, the bulls of Bashan and of Babylon, mammoth and mastodon, they come trooping to the sunken sea, Lacus Mortis. Ominous revengeful zodiacal host! They moan, passing upon the clouds, horned and capricorned, the trumpeted with the tusked, the lionmaned, the giantantlered, snouter and crawler, rodent, ruminant and pachyderm, all their moving moaning multitude, murderers of the sun.

Onward to the dead sea they tramp to drink, unslaked and with horrible gulpings, the salt somnolent inexhaustible flood. And the equine portent grows again, magnified in the deserted heavens, nay to heaven’s own magnitude, till it looms, vast, over the house of Virgo. And lo, wonder of metempsychosis, it is she, the everlasting bride, harbinger of the daystar, the bride, ever virgin. It is she, Martha, thou lost one, Millicent, the young, the dear, the radiant. How serene does she now arise, a queen among the Pleiades, in the penultimate antelucan hour, shod in sandals of bright gold, coifed with a veil of what do you call it gossamer. It floats, it flows about her starborn flesh and loose it streams, emerald, sapphire, mauve and heliotrope, sustained on currents of the cold interstellar wind, winding, coiling, simply swirling, writhing in the skies a mysterious writing till, after a myriad metamorphoses of symbol, it blazes, Alpha, a ruby and triangled sign upon the forehead of Taurus.

Francis was reminding Stephen of years before when they had been at school together in Conmee’s time. He asked about Glaucon, Alcibiades, Pisistratus. Where were they now? Neither knew. You have spoken of the past and its phantoms, Stephen said. Why think of them? If I call them into life across the waters of Lethe will not the poor ghosts troop to my call? Who supposes it? I, Bous Stephanoumenos, bullockbefriending bard, am lord and giver of their life. He encircled his gadding hair with a coronal of vineleaves, smiling at Vincent. That answer and those leaves, Vincent said to him, will adorn you more fitly when something more, and greatly more, than a capful of light odes can call your genius father. All who wish you well hope this for you. All desire to see you bring forth the work you meditate, to acclaim you Stephaneforos. I heartily wish you may not fail them. O no, Vincent Lenehan said, laying a hand on the shoulder near him. Have no fear. He could not leave his mother an orphan. The young man’s face grew dark. All could see how hard it was for him to be reminded of his promise and of his recent loss. He would have withdrawn from the feast had not the noise of voices allayed the smart. Madden had lost five drachmas on Sceptre for a whim of the rider’s name: Lenehan as much more. He told them of the race. The flag fell and, huuh! off, scamper, the mare ran out freshly with O. Madden up. She was leading the field. All hearts were beating. Even Phyllis could not contain herself. She waved her scarf and cried: Huzzah! Sceptre wins! But in the straight on the run home when all were in close order the dark horse Throwaway drew level, reached, outstripped her. All was lost now. Phyllis was silent: her eyes were sad anemones. Juno, she cried, I am undone. But her lover consoled her and brought her a bright casket of gold in which lay some oval sugarplums which she partook. A tear fell: one only. A whacking fine whip, said Lenehan, is W. Lane. Four winners yesterday and three today. What rider is like him? Mount him on the camel or the boisterous buffalo the victory in a hack canter is still his. But let us bear it as was the ancient wont. Mercy on the luckless! Poor Sceptre! he said with a light sigh. She is not the filly that she was. Never, by this hand, shall we behold such another. By gad, sir, a queen of them. Do you remember her, Vincent? I wish you could have seen my queen today, Vincent said. How young she was and radiant (Lalage were scarce fair beside her) in her yellow shoes and frock of muslin, I do not know the right name of it. The chestnuts that shaded us were in bloom: the air drooped with their persuasive odour and with pollen floating by us. In the sunny patches one might easily have cooked on a stone a batch of those buns with Corinth fruit in them that Periplipomenes sells in his booth near the bridge. But she had nought for her teeth but the arm with which I held her and in that she nibbled mischievously when I pressed too close. A week ago she lay ill, four days on the couch, but today she was free, blithe, mocked at peril. She is more taking then. Her posies too! Mad romp that she is, she had pulled her fill as we reclined together. And in your ear, my friend, you will not think who met us as we left the field. Conmee himself! He was walking by the hedge, reading, I think a brevier book with, I doubt not, a witty letter in it from Glycera or Chloe to keep the page. The sweet creature turned all colours in her confusion, feigning to reprove a slight disorder in her dress: a slip of underwood clung there for the very trees adore her. When Conmee had passed she glanced at her lovely echo in that little mirror she carries. But he had been kind. In going by he had blessed us. The gods too are ever kind, Lenehan said. If I had poor luck with Bass’s mare perhaps this draught of his may serve me more propensely. He was laying his hand upon a winejar: Malachi saw it and withheld his act, pointing to the stranger and to the scarlet label. Warily, Malachi whispered, preserve a druid silence. His soul is far away. It is as painful perhaps to be awakened from a vision as to be born. Any object, intensely regarded, may be a gate of access to the incorruptible eon of the gods. Do you not think it, Stephen? Theosophos told me so, Stephen answered, whom in a previous existence Egyptian priests initiated into the mysteries of karmic law. The lords of the moon, Theosophos told me, an orangefiery shipload from planet Alpha of the lunar chain would not assume the etheric doubles and these were therefore incarnated by the rubycoloured egos from the second constellation.

However, as a matter of fact though, the preposterous surmise about him being in some description of a doldrums or other or mesmerised which was entirely due to a misconception of the shallowest character, was not the case at all. The individual whose visual organs while the above was going on were at this juncture commencing to exhibit symptoms of animation was as astute if not astuter than any man living and anybody that conjectured the contrary would have found themselves pretty speedily in the wrong shop. During the past four minutes or thereabouts he had been staring hard at a certain amount of number one Bass bottled by Messrs Bass and Co at Burton-on-Trent which happened to be situated amongst a lot of others right opposite to where he was and which was certainly calculated to attract anyone’s remark on account of its scarlet appearance. He was simply and solely, as it subsequently transpired for reasons best known to himself, which put quite an altogether different complexion on the proceedings, after the moment before’s observations about boyhood days and the turf, recollecting two or three private transactions of his own which the other two were as mutually innocent of as the babe unborn. Eventually, however, both their eyes met and as soon as it began to dawn on him that the other was endeavouring to help himself to the thing he involuntarily determined to help him himself and so he accordingly took hold of the neck of the mediumsized glass recipient which contained the fluid sought after and made a capacious hole in it by pouring a lot of it out with, also at the same time, however, a considerable degree of attentiveness in order not to upset any of the beer that was in it about the place.

The debate which ensued was in its scope and progress an epitome of the course of life. Neither place nor council was lacking in dignity. The debaters were the keenest in the land, the theme they were engaged on the loftiest and most vital. The high hall of Horne’s house had never beheld an assembly so representative and so varied nor had the old rafters of that establishment ever listened to a language so encyclopaedic. A gallant scene in truth it made. Crotthers was there at the foot of the table in his striking Highland garb, his face glowing from the briny airs of the Mull of Galloway. There too, opposite to him, was Lynch whose countenance bore already the stigmata of early depravity and premature wisdom. Next the Scotchman was the place assigned to Costello, the eccentric, while at his side was seated in stolid repose the squat form of Madden. The chair of the resident indeed stood vacant before the hearth but on either flank of it the figure of Bannon in explorer’s kit of tweed shorts and salted cowhide brogues contrasted sharply with the primrose elegance and townbred manners of Malachi Roland St John Mulligan. Lastly at the head of the board was the young poet who found a refuge from his labours of pedagogy and metaphysical inquisition in the convivial atmosphere of Socratic discussion, while to right and left of him were accommodated the flippant prognosticator, fresh from the hippodrome, and that vigilant wanderer, soiled by the dust of travel and combat and stained by the mire of an indelible dishonour, but from whose steadfast and constant heart no lure or peril or threat or degradation could ever efface the image of that voluptuous loveliness which the inspired pencil of Lafayette has limned for ages yet to come.

It had better be stated here and now at the outset that the perverted transcendentalism to which Mr S. Dedalus’ (Div. Scep.) contentions would appear to prove him pretty badly addicted runs directly counter to accepted scientific methods. Science, it cannot be too often repeated, deals with tangible phenomena. The man of science like the man in the street has to face hardheaded facts that cannot be blinked and explain them as best he can. There may be, it is true, some questions which science cannot answer—at present—such as the first problem submitted by Mr L. Bloom (Pubb. Canv.) regarding the future determination of sex. Must we accept the view of Empedocles of Trinacria that the right ovary (the postmenstrual period, assert others) is responsible for the birth of males or are the too long neglected spermatozoa or nemasperms the differentiating factors or is it, as most embryologists incline to opine, such as Culpepper, Spallanzani, Blumenbach, Lusk, Hertwig, Leopold and Valenti, a mixture of both? This would be tantamount to a cooperation (one of nature’s favourite devices) between the nisus formativus of the nemasperm on the one hand and on the other a happily chosen position, succubitus felix, of the passive element. The other problem raised by the same inquirer is scarcely less vital: infant mortality. It is interesting because, as he pertinently remarks, we are all born in the same way but we all die in different ways. Mr M. Mulligan (Hyg. et Eug. Doc.) blames the sanitary conditions in which our greylunged citizens contract adenoids, pulmonary complaints etc. by inhaling the bacteria which lurk in dust. These factors, he alleged, and the revolting spectacles offered by our streets, hideous publicity posters, religious ministers of all denominations, mutilated soldiers and sailors, exposed scorbutic cardrivers, the suspended carcases of dead animals, paranoic bachelors and unfructified duennas—these, he said, were accountable for any and every fallingoff in the calibre of the race. Kalipedia, he prophesied, would soon be generally adopted and all the graces of life, genuinely good music, agreeable literature, light philosophy, instructive pictures, plastercast reproductions of the classical statues such as Venus and Apollo, artistic coloured photographs of prize babies, all these little attentions would enable ladies who were in a particular condition to pass the intervening months in a most enjoyable manner. Mr J. Crotthers (Disc. Bacc.) attributes some of these demises to abdominal trauma in the case of women workers subjected to heavy labours in the workshop and to marital discipline in the home but by far the vast majority to neglect, private or official, culminating in the exposure of newborn infants, the practice of criminal abortion or in the atrocious crime of infanticide. Although the former (we are thinking of neglect) is undoubtedly only too true the case he cites of nurses forgetting to count the sponges in the peritoneal cavity is too rare to be normative. In fact when one comes to look into it the wonder is that so many pregnancies and deliveries go off so well as they do, all things considered and in spite of our human shortcomings which often baulk nature in her intentions. An ingenious suggestion is that thrown out by Mr V. Lynch (Bacc. Arith.) that both natality and mortality, as well as all other phenomena of evolution, tidal movements, lunar phases, blood temperatures, diseases in general, everything, in fine, in nature’s vast workshop from the extinction of some remote sun to the blossoming of one of the countless flowers which beautify our public parks is subject to a law of numeration as yet unascertained. Still the plain straightforward question why a child of normally healthy parents and seemingly a healthy child and properly looked after succumbs unaccountably in early childhood (though other children of the same marriage do not) must certainly, in the poet’s words, give us pause. Nature, we may rest assured, has her own good and cogent reasons for whatever she does and in all probability such deaths are due to some law of anticipation by which organisms in which morbous germs have taken up their residence (modern science has conclusively shown that only the plasmic substance can be said to be immortal) tend to disappear at an increasingly earlier stage of development, an arrangement which, though productive of pain to some of our feelings (notably the maternal), is nevertheless, some of us think, in the long run beneficial to the race in general in securing thereby the survival of the fittest. Mr S. Dedalus’ (Div. Scep.) remark (or should it be called an interruption?) that an omnivorous being which can masticate, deglute, digest and apparently pass through the ordinary channel with pluterperfect imperturbability such multifarious aliments as cancrenous females emaciated by parturition, corpulent professional gentlemen, not to speak of jaundiced politicians and chlorotic nuns, might possibly find gastric relief in an innocent collation of staggering bob, reveals as nought else could and in a very unsavoury light the tendency above alluded to. For the enlightenment of those who are not so intimately acquainted with the minutiae of the municipal abattoir as this morbidminded esthete and embryo philosopher who for all his overweening bumptiousness in things scientific can scarcely distinguish an acid from an alkali prides himself on being, it should perhaps be stated that staggering bob in the vile parlance of our lowerclass licensed victuallers signifies the cookable and eatable flesh of a calf newly dropped from its mother. In a recent public controversy with Mr L. Bloom (Pubb. Canv.) which took place in the commons’ hall of the National Maternity Hospital, 29, 30 and 31 Holles street, of which, as is well known, Dr A. Horne (Lic. in Midw., F. K. Q. C. P. I.) is the able and popular master, he is reported by eyewitnesses as having stated that once a woman has let the cat into the bag (an esthete’s allusion, presumably, to one of the most complicated and marvellous of all nature’s processes—the act of sexual congress) she must let it out again or give it life, as he phrased it, to save her own. At the risk of her own, was the telling rejoinder of his interlocutor, none the less effective for the moderate and measured tone in which it was delivered.

Meanwhile the skill and patience of the physician had brought about a happy accouchement. It had been a weary weary while both for patient and doctor. All that surgical skill could do was done and the brave woman had manfully helped. She had. She had fought the good fight and now she was very very happy. Those who have passed on, who have gone before, are happy too as they gaze down and smile upon the touching scene. Reverently look at her as she reclines there with the motherlight in her eyes, that longing hunger for baby fingers (a pretty sight it is to see), in the first bloom of her new motherhood, breathing a silent prayer of thanksgiving to One above, the Universal Husband. And as her loving eyes behold her babe she wishes only one blessing more, to have her dear Doady there with her to share her joy, to lay in his arms that mite of God’s clay, the fruit of their lawful embraces. He is older now (you and I may whisper it) and a trifle stooped in the shoulders yet in the whirligig of years a grave dignity has come to the conscientious second accountant of the Ulster bank, College Green branch. O Doady, loved one of old, faithful lifemate now, it may never be again, that faroff time of the roses! With the old shake of her pretty head she recalls those days. God! How beautiful now across the mist of years! But their children are grouped in her imagination about the bedside, hers and his, Charley, Mary Alice, Frederick Albert (if he had lived), Mamy, Budgy (Victoria Frances), Tom, Violet Constance Louisa, darling little Bobsy (called after our famous hero of the South African war, lord Bobs of Waterford and Candahar) and now this last pledge of their union, a Purefoy if ever there was one, with the true Purefoy nose. Young hopeful will be christened Mortimer Edward after the influential third cousin of Mr Purefoy in the Treasury Remembrancer’s office, Dublin Castle. And so time wags on: but father Cronion has dealt lightly here. No, let no sigh break from that bosom, dear gentle Mina. And Doady, knock the ashes from your pipe, the seasoned briar you still fancy when the curfew rings for you (may it be the distant day!) and dout the light whereby you read in the Sacred Book for the oil too has run low, and so with a tranquil heart to bed, to rest. He knows and will call in His own good time. You too have fought the good fight and played loyally your man’s part. Sir, to you my hand. Well done, thou good and faithful servant!

There are sins or (let us call them as the world calls them) evil memories which are hidden away by man in the darkest places of the heart but they abide there and wait. He may suffer their memory to grow dim, let them be as though they had not been and all but persuade himself that they were not or at least were otherwise. Yet a chance word will call them forth suddenly and they will rise up to confront him in the most various circumstances, a vision or a dream, or while timbrel and harp soothe his senses or amid the cool silver tranquility of the evening or at the feast, at midnight, when he is now filled with wine. Not to insult over him will the vision come as over one that lies under her wrath, not for vengeance to cut him off from the living but shrouded in the piteous vesture of the past, silent, remote, reproachful.

The stranger still regarded on the face before him a slow recession of that false calm there, imposed, as it seemed, by habit or some studied trick, upon words so embittered as to accuse in their speaker an unhealthiness, a flair, for the cruder things of life. A scene disengages itself in the observer’s memory, evoked, it would seem, by a word of so natural a homeliness as if those days were really present there (as some thought) with their immediate pleasures. A shaven space of lawn one soft May evening, the wellremembered grove of lilacs at Roundtown, purple and white, fragrant slender spectators of the game but with much real interest in the pellets as they run slowly forward over the sward or collide and stop, one by its fellow, with a brief alert shock. And yonder about that grey urn where the water moves at times in thoughtful irrigation you saw another as fragrant sisterhood, Floey, Atty, Tiny and their darker friend with I know not what of arresting in her pose then, Our Lady of the Cherries, a comely brace of them pendent from an ear, bringing out the foreign warmth of the skin so daintily against the cool ardent fruit. A lad of four or five in linseywoolsey (blossomtime but there will be cheer in the kindly hearth when ere long the bowls are gathered and hutched) is standing on the urn secured by that circle of girlish fond hands. He frowns a little just as this young man does now with a perhaps too conscious enjoyment of the danger but must needs glance at whiles towards where his mother watches from the piazzetta giving upon the flowerclose with a faint shadow of remoteness or of reproach (alles Vergängliche) in her glad look.

Mark this farther and remember. The end comes suddenly. Enter that antechamber of birth where the studious are assembled and note their faces. Nothing, as it seems, there of rash or violent. Quietude of custody, rather, befitting their station in that house, the vigilant watch of shepherds and of angels about a crib in Bethlehem of Juda long ago. But as before the lightning the serried stormclouds, heavy with preponderant excess of moisture, in swollen masses turgidly distended, compass earth and sky in one vast slumber, impending above parched field and drowsy oxen and blighted growth of shrub and verdure till in an instant a flash rives their centres and with the reverberation of the thunder the cloudburst pours its torrent, so and not otherwise was the transformation, violent and instantaneous, upon the utterance of the word.

Burke’s! outflings my lord Stephen, giving the cry, and a tag and bobtail of all them after, cockerel, jackanapes, welsher, pilldoctor, punctual Bloom at heels with a universal grabbing at headgear, ashplants, bilbos, Panama hats and scabbards, Zermatt alpenstocks and what not. A dedale of lusty youth, noble every student there. Nurse Callan taken aback in the hallway cannot stay them nor smiling surgeon coming downstairs with news of placentation ended, a full pound if a milligramme. They hark him on. The door! It is open? Ha! They are out, tumultuously, off for a minute’s race, all bravely legging it, Burke’s of Denzille and Holles their ulterior goal. Dixon follows giving them sharp language but raps out an oath, he too, and on. Bloom stays with nurse a thought to send a kind word to happy mother and nurseling up there. Doctor Diet and Doctor Quiet. Looks she too not other now? Ward of watching in Horne’s house has told its tale in that washedout pallor. Then all being gone, a glance of motherwit helping, he whispers close in going: Madam, when comes the storkbird for thee?

The air without is impregnated with raindew moisture, life essence celestial, glistening on Dublin stone there under starshiny coelum. God’s air, the Allfather’s air, scintillant circumambient cessile air. Breathe it deep into thee. By heaven, Theodore Purefoy, thou hast done a doughty deed and no botch! Thou art, I vow, the remarkablest progenitor barring none in this chaffering allincluding most farraginous chronicle. Astounding! In her lay a Godframed Godgiven preformed possibility which thou hast fructified with thy modicum of man’s work. Cleave to her! Serve! Toil on, labour like a very bandog and let scholarment and all Malthusiasts go hang. Thou art all their daddies, Theodore. Art drooping under thy load, bemoiled with butcher’s bills at home and ingots (not thine!) in the countinghouse? Head up! For every newbegotten thou shalt gather thy homer of ripe wheat. See, thy fleece is drenched. Dost envy Darby Dullman there with his Joan? A canting jay and a rheumeyed curdog is all their progeny. Pshaw, I tell thee! He is a mule, a dead gasteropod, without vim or stamina, not worth a cracked kreutzer. Copulation without population! No, say I! Herod’s slaughter of the innocents were the truer name. Vegetables, forsooth, and sterile cohabitation! Give her beefsteaks, red, raw, bleeding! She is a hoary pandemonium of ills, enlarged glands, mumps, quinsy, bunions, hayfever, bedsores, ringworm, floating kidney, Derbyshire neck, warts, bilious attacks, gallstones, cold feet, varicose veins. A truce to threnes and trentals and jeremies and all such congenital defunctive music! Twenty years of it, regret them not. With thee it was not as with many that will and would and wait and never—do. Thou sawest thy America, thy lifetask, and didst charge to cover like the transpontine bison. How saith Zarathustra? Deine Kuh Trübsal melkest Du. Nun Trinkst Du die süsse Milch des Euters. See! it displodes for thee in abundance. Drink, man, an udderful! Mother’s milk, Purefoy, the milk of human kin, milk too of those burgeoning stars overhead rutilant in thin rainvapour, punch milk, such as those rioters will quaff in their guzzling den, milk of madness, the honeymilk of Canaan’s land. Thy cow’s dug was tough, what? Ay, but her milk is hot and sweet and fattening. No dollop this but thick rich bonnyclaber. To her, old patriarch! Pap! Per deam Partulam et Pertundam nunc est bibendum!

All off for a buster, armstrong, hollering down the street. Bonafides. Where you slep las nigh? Timothy of the battered naggin. Like ole Billyo. Any brollies or gumboots in the fambly? Where the Henry Nevil’s sawbones and ole clo? Sorra one o’ me knows. Hurrah there, Dix! Forward to the ribbon counter. Where’s Punch? All serene. Jay, look at the drunken minister coming out of the maternity hospal! Benedicat vos omnipotens Deus, Pater et Filius. A make, mister. The Denzille lane boys. Hell, blast ye! Scoot. Righto, Isaacs, shove em out of the bleeding limelight. Yous join uz, dear sir? No hentrusion in life. Lou heap good man. Allee samee dis bunch. En avant, mes enfants! Fire away number one on the gun. Burke’s! Burke’s! Thence they advanced five parasangs. Slattery’s mounted foot. Where’s that bleeding awfur? Parson Steve, apostates’ creed! No, no, Mulligan! Abaft there! Shove ahead. Keep a watch on the clock. Chuckingout time. Mullee! What’s on you? Ma mère m’a mariée. British Beatitudes! Retamplatan digidi boumboum. Ayes have it. To be printed and bound at the Druiddrum press by two designing females. Calf covers of pissedon green. Last word in art shades. Most beautiful book come out of Ireland my time. Silentium! Get a spurt on. Tention. Proceed to nearest canteen and there annex liquor stores. March! Tramp, tramp, tramp, the boys are (attitudes!) parching. Beer, beef, business, bibles, bulldogs battleships, buggery and bishops. Whether on the scaffold high. Beer, beef, trample the bibles. When for Irelandear. Trample the trampellers. Thunderation! Keep the durned millingtary step. We fall. Bishops boosebox. Halt! Heave to. Rugger. Scrum in. No touch kicking. Wow, my tootsies! You hurt? Most amazingly sorry!

Query. Who’s astanding this here do? Proud possessor of damnall. Declare misery. Bet to the ropes. Me nantee saltee. Not a red at me this week gone. Yours? Mead of our fathers for the Übermensch. Dittoh. Five number ones. You, sir? Ginger cordial. Chase me, the cabby’s caudle. Stimulate the caloric. Winding of his ticker. Stopped short never to go again when the old. Absinthe for me, savvy? Caramba! Have an eggnog or a prairie oyster. Enemy? Avuncular’s got my timepiece. Ten to. Obligated awful. Don’t mention it. Got a pectoral trauma, eh, Dix? Pos fact. Got bet be a boomblebee whenever he wus settin sleepin in hes bit garten. Digs up near the Mater. Buckled he is. Know his dona? Yup, sartin I do. Full of a dure. See her in her dishybilly. Peels off a credit. Lovey lovekin. None of your lean kine, not much. Pull down the blind, love. Two Ardilauns. Same here. Look slippery. If you fall don’t wait to get up. Five, seven, nine. Fine! Got a prime pair of mincepies, no kid. And her take me to rests and her anker of rum. Must be seen to be believed. Your starving eyes and allbeplastered neck you stole my heart, O gluepot. Sir? Spud again the rheumatiz? All poppycock, you’ll scuse me saying. For the hoi polloi. I vear thee beest a gert vool. Well, doc? Back fro Lapland? Your corporosity sagaciating O K? How’s the squaws and papooses? Womanbody after going on the straw? Stand and deliver. Password. There’s hair. Ours the white death and the ruddy birth. Hi! Spit in your own eye, boss! Mummer’s wire. Cribbed out of Meredith. Jesified, orchidised, polycimical jesuit! Aunty mine’s writing Pa Kinch. Baddybad Stephen lead astray goodygood Malachi.

Hurroo! Collar the leather, youngun. Roun wi the nappy. Here, Jock braw Hielentman’s your barleybree. Lang may your lum reek and your kailpot boil! My tipple. Merci. Here’s to us. How’s that? Leg before wicket. Don’t stain my brandnew sitinems. Give’s a shake of peppe, you there. Catch aholt. Caraway seed to carry away. Twig? Shrieks of silence. Every cove to his gentry mort. Venus Pandemos. Les petites femmes. Bold bad girl from the town of Mullingar. Tell her I was axing at her. Hauding Sara by the wame. On the road to Malahide. Me? If she who seduced me had left but the name. What do you want for ninepence? Machree, macruiskeen. Smutty Moll for a mattress jig. And a pull all together. Ex!

Waiting, guvnor? Most deciduously. Bet your boots on. Stunned like, seeing as how no shiners is acoming. Underconstumble? He’ve got the chink ad lib. Seed near free poun on un a spell ago a said war hisn. Us come right in on your invite, see? Up to you, matey. Out with the oof. Two bar and a wing. You larn that go off of they there Frenchy bilks? Won’t wash here for nuts nohow. Lil chile velly solly. Ise de cutest colour coon down our side. Gawds teruth, Chawley. We are nae fou. We’re nae tha fou. Au reservoir, mossoo. Tanks you.

’Tis, sure. What say? In the speakeasy. Tight. I shee you, shir. Bantam, two days teetee. Bowsing nowt but claretwine. Garn! Have a glint, do. Gum, I’m jiggered. And been to barber he have. Too full for words. With a railway bloke. How come you so? Opera he’d like? Rose of Castile. Rows of cast. Police! Some H2O for a gent fainted. Look at Bantam’s flowers. Gemini. He’s going to holler. The colleen bawn. My colleen bawn. O, cheese it! Shut his blurry Dutch oven with a firm hand. Had the winner today till I tipped him a dead cert. The ruffin cly the nab of Stephen Hand as give me the jady coppaleen. He strike a telegramboy paddock wire big bug Bass to the depot. Shove him a joey and grahamise. Mare on form hot order. Guinea to a goosegog. Tell a cram, that. Gospeltrue. Criminal diversion? I think that yes. Sure thing. Land him in chokeechokee if the harman beck copped the game. Madden back Madden’s a maddening back. O lust our refuge and our strength. Decamping. Must you go? Off to mammy. Stand by. Hide my blushes someone. All in if he spots me. Come ahome, our Bantam. Horryvar, mong vioo. Dinna forget the cowslips for hersel. Cornfide. Wha gev ye thon colt? Pal to pal. Jannock. Of John Thomas, her spouse. No fake, old man Leo. S’elp me, honest injun. Shiver my timbers if I had. There’s a great big holy friar. Vyfor you no me tell? Vel, I ses, if that aint a sheeny nachez, vel, I vil get misha mishinnah. Through yerd our lord, Amen.

You move a motion? Steve boy, you’re going it some. More bluggy drunkables? Will immensely splendiferous stander permit one stooder of most extreme poverty and one largesize grandacious thirst to terminate one expensive inaugurated libation? Give’s a breather. Landlord, landlord, have you good wine, staboo? Hoots, mon, a wee drap to pree. Cut and come again. Right. Boniface! Absinthe the lot. Nos omnes biberimus viridum toxicum diabolus capiat posterioria nostria. Closingtime, gents. Eh? Rome boose for the Bloom toff. I hear you say onions? Bloo? Cadges ads. Photo’s papli, by all that’s gorgeous. Play low, pardner. Slide. Bonsoir la compagnie. And snares of the poxfiend. Where’s the buck and Namby Amby? Skunked? Leg bail. Aweel, ye maun e’en gang yer gates. Checkmate. King to tower. Kind Kristyann wil yu help yung man hoose frend tuk bungellow kee tu find plais whear tu lay crown of his hed 2 night. Crickey, I’m about sprung. Tarnally dog gone my shins if this beent the bestest puttiest longbreak yet. Item, curate, couple of cookies for this child. Cot’s plood and prandypalls, none! Not a pite of sheeses? Thrust syphilis down to hell and with him those other licensed spirits. Time, gents! Who wander through the world. Health all! À la vôtre!

Golly, whatten tunket’s yon guy in the mackintosh? Dusty Rhodes. Peep at his wearables. By mighty! What’s he got? Jubilee mutton. Bovril, by James. Wants it real bad. D’ye ken bare socks? Seedy cuss in the Richmond? Rawthere! Thought he had a deposit of lead in his penis. Trumpery insanity. Bartle the Bread we calls him. That, sir, was once a prosperous cit. Man all tattered and torn that married a maiden all forlorn. Slung her hook, she did. Here see lost love. Walking Mackintosh of lonely canyon. Tuck and turn in. Schedule time. Nix for the hornies. Pardon? Seen him today at a runefal? Chum o’ yourn passed in his checks? Ludamassy! Pore piccaninnies! Thou’ll no be telling me thot, Pold veg! Did ums blubble bigsplash crytears cos fren Padney was took off in black bag? Of all de darkies Massa Pat was verra best. I never see the like since I was born. Tiens, tiens, but it is well sad, that, my faith, yes. O, get, rev on a gradient one in nine. Live axle drives are souped. Lay you two to one Jenatzy licks him ruddy well hollow. Jappies? High angle fire, inyah! Sunk by war specials. Be worse for him, says he, nor any Rooshian. Time all. There’s eleven of them. Get ye gone. Forward, woozy wobblers! Night. Night. May Allah the Excellent One your soul this night ever tremendously conserve.

Your attention! We’re nae tha fou. The Leith police dismisseth us. The least tholice. Ware hawks for the chap puking. Unwell in his abominable regions. Yooka. Night. Mona, my true love. Yook. Mona, my own love. Ook.

Hark! Shut your obstropolos. Pflaap! Pflaap! Blaze on. There she goes. Brigade! Bout ship. Mount street way. Cut up! Pflaap! Tally ho. You not come? Run, skelter, race. Pflaaaap!

Lynch! Hey? Sign on long o’ me. Denzille lane this way. Change here for Bawdyhouse. We two, she said, will seek the kips where shady Mary is. Righto, any old time. Laetabuntur in cubilibus suis. You coming long? Whisper, who the sooty hell’s the johnny in the black duds? Hush! Sinned against the light and even now that day is at hand when he shall come to judge the world by fire. Pflaap! Ut implerentur scripturae. Strike up a ballad. Then outspake medical Dick to his comrade medical Davy. Christicle, who’s this excrement yellow gospeller on the Merrion hall? Elijah is coming! Washed in the blood of the Lamb. Come on you winefizzling, ginsizzling, booseguzzling existences! Come on, you dog-gone, bullnecked, beetlebrowed, hogjowled, peanutbrained, weaseleyed fourflushers, false alarms and excess baggage! Come on, you triple extract of infamy! Alexander J Christ Dowie, that’s my name, that’s yanked to glory most half this planet from Frisco beach to Vladivostok. The Deity aint no nickel dime bumshow. I put it to you that He’s on the square and a corking fine business proposition. He’s the grandest thing yet and don’t you forget it. Shout salvation in King Jesus. You’ll need to rise precious early, you sinner there, if you want to diddle the Almighty God. Pflaaaap! Not half. He’s got a coughmixture with a punch in it for you, my friend, in his back pocket. Just you try it on.

### [ 15 ]
(The Mabbot street entrance of nighttown, before which stretches an uncobbled tramsiding set with skeleton tracks, red and green will-o’-the-wisps and danger signals. Rows of grimy houses with gaping doors. Rare lamps with faint rainbow fans. Round Rabaiotti’s halted ice gondola stunted men and women squabble. They grab wafers between which are wedged lumps of coral and copper snow. Sucking, they scatter slowly. Children. The swancomb of the gondola, highreared, forges on through the murk, white and blue under a lighthouse. Whistles call and answer.)

THE CALLS: Wait, my love, and I’ll be with you.

THE ANSWERS: Round behind the stable.

(A deafmute idiot with goggle eyes, his shapeless mouth dribbling, jerks past, shaken in Saint Vitus’ dance. A chain of children ’s hands imprisons him.)

THE CHILDREN: Kithogue! Salute!

THE IDIOT: (Lifts a palsied left arm and gurgles.) Grhahute!

THE CHILDREN: Where’s the great light?

THE IDIOT: (Gobbling.) Ghaghahest.

(They release him. He jerks on. A pigmy woman swings on a rope slung between two railings, counting. A form sprawled against a dustbin and muffled by its arm and hat snores, groans, grinding growling teeth, and snores again. On a step a gnome totting among a rubbishtip crouches to shoulder a sack of rags and bones. A crone standing by with a smoky oillamp rams her last bottle in the maw of his sack. He heaves his booty, tugs askew his peaked cap and hobbles off mutely. The crone makes back for her lair, swaying her lamp. A bandy child, asquat on the doorstep with a paper shuttlecock, crawls sidling after her in spurts, clutches her skirt, scrambles up. A drunken navvy grips with both hands the railings of an area, lurching heavily. At a corner two night watch in shouldercapes, their hands upon their staffholsters, loom tall. A plate crashes: a woman screams: a child wails. Oaths of a man roar, mutter, cease. Figures wander, lurk, peer from warrens. In a room lit by a candle stuck in a bottleneck a slut combs out the tatts from the hair of a scrofulous child. Cissy Caffrey’s voice, still young, sings shrill from a lane.)

CISSY CAFFREY:

I gave it to Molly
Because she was jolly,
The leg of the duck,
The leg of the duck.

(Private Carr and Private Compton, swaggersticks tight in their oxters, as they march unsteadily rightaboutface and burst together from their mouths a volleyed fart. Laughter of men from the lane. A hoarse virago retorts.)

THE VIRAGO: Signs on you, hairy arse. More power the Cavan girl.

CISSY CAFFREY: More luck to me. Cavan, Cootehill and Belturbet. (She sings.)

I gave it to Nelly
To stick in her belly,
The leg of the duck,
The leg of the duck.

(Private Carr and Private Compton turn and counterretort, their tunics bloodbright in a lampglow, black sockets of caps on their blond cropped polls. Stephen Dedalus and Lynch pass through the crowd close to the redcoats.)

PRIVATE COMPTON: (Jerks his finger.) Way for the parson.

PRIVATE CARR: (Turns and calls.) What ho, parson!

CISSY CAFFREY: (Her voice soaring higher.)

She has it, she got it,
Wherever she put it,
The leg of the duck.

(Stephen, flourishing the ashplant in his left hand, chants with joy the introit for paschal time. Lynch, his jockeycap low on his brow, attends him, a sneer of discontent wrinkling his face.)

STEPHEN: Vidi aquam egredientem de templo a latere dextro. Alleluia.

(The famished snaggletusks of an elderly bawd protrude from a doorway.)

THE BAWD: (Her voice whispering huskily.) Sst! Come here till I tell you. Maidenhead inside. Sst!

STEPHEN: (Altius aliquantulum.) Et omnes ad quos pervenit aqua ista.

THE BAWD: (Spits in their trail her jet of venom.) Trinity medicals. Fallopian tube. All prick and no pence.

(Edy Boardman, sniffling, crouched with Bertha Supple, draws her shawl across her nostrils.)

EDY BOARDMAN: (Bickering.) And says the one: I seen you up Faithful place with your squarepusher, the greaser off the railway, in his cometobed hat. Did you, says I. That’s not for you to say, says I. You never seen me in the mantrap with a married highlander, says I. The likes of her! Stag that one is! Stubborn as a mule! And her walking with two fellows the one time, Kilbride, the enginedriver, and lancecorporal Oliphant.

STEPHEN: (Triumphaliter.) Salvi facti sunt.

(He flourishes his ashplant, shivering the lamp image, shattering light over the world. A liver and white spaniel on the prowl slinks after him, growling. Lynch scares it with a kick.)

LYNCH: So that?

STEPHEN: (Looks behind.) So that gesture, not music not odour, would be a universal language, the gift of tongues rendering visible not the lay sense but the first entelechy, the structural rhythm.

LYNCH: Pornosophical philotheology. Metaphysics in Mecklenburgh street!

STEPHEN: We have shrewridden Shakespeare and henpecked Socrates. Even the allwisest Stagyrite was bitted, bridled and mounted by a light of love.

LYNCH: Ba!

STEPHEN: Anyway, who wants two gestures to illustrate a loaf and a jug? This movement illustrates the loaf and jug of bread or wine in Omar. Hold my stick.

LYNCH: Damn your yellow stick. Where are we going?

STEPHEN: Lecherous lynx, to la belle dame sans merci, Georgina Johnson, ad deam qui laetificat iuventutem meam.

(Stephen thrusts the ashplant on him and slowly holds out his hands, his head going back till both hands are a span from his breast, down turned, in planes intersecting, the fingers about to part, the left being higher.)

LYNCH: Which is the jug of bread? It skills not. That or the customhouse. Illustrate thou. Here take your crutch and walk.

(They pass. Tommy Caffrey scrambles to a gaslamp and, clasping, climbs in spasms. From the top spur he slides down. Jacky Caffrey clasps to climb. The navvy lurches against the lamp. The twins scuttle off in the dark. The navvy, swaying, presses a forefinger against a wing of his nose and ejects from the farther nostril a long liquid jet of snot. Shouldering the lamp he staggers away through the crowd with his flaring cresset.

Snakes of river fog creep slowly. From drains, clefts, cesspools, middens arise on all sides stagnant fumes. A glow leaps in the south beyond the seaward reaches of the river. The navvy, staggering forward, cleaves the crowd and lurches towards the tramsiding. On the farther side under the railway bridge Bloom appears, flushed, panting, cramming bread and chocolate into a sidepocket. From Gillen’s hairdresser’s window a composite portrait shows him gallant Nelson’s image. A concave mirror at the side presents to him lovelorn longlost lugubru Booloohoom. Grave Gladstone sees him level, Bloom for Bloom. He passes, struck by the stare of truculent Wellington, but in the convex mirror grin unstruck the bonham eyes and fatchuck cheekchops of Jollypoldy the rixdix doldy.

At Antonio Rabaiotti’s door Bloom halts, sweated under the bright arclamp. He disappears. In a moment he reappears and hurries on.)

BLOOM: Fish and taters. N. g. Ah!

(He disappears into Olhausen’s, the porkbutcher’s, under the downcoming rollshutter. A few moments later he emerges from under the shutter, puffing Poldy, blowing Bloohoom. In each hand he holds a parcel, one containing a lukewarm pig’s crubeen, the other a cold sheep’s trotter, sprinkled with wholepepper. He gasps, standing upright. Then bending to one side he presses a parcel against his ribs and groans.)

BLOOM: Stitch in my side. Why did I run?

(He takes breath with care and goes forward slowly towards the lampset siding. The glow leaps again.)

BLOOM: What is that? A flasher? Searchlight.

(He stands at Cormack’s corner, watching.)

BLOOM: Aurora borealis or a steel foundry? Ah, the brigade, of course. South side anyhow. Big blaze. Might be his house. Beggar’s bush. We’re safe. (He hums cheerfully.) London’s burning, London’s burning! On fire, on fire! (He catches sight of the navvy lurching through the crowd at the farther side of Talbot street.) I’ll miss him. Run. Quick. Better cross here.

(He darts to cross the road. Urchins shout.)

THE URCHINS: Mind out, mister!

(Two cyclists, with lighted paper lanterns aswing, swim by him, grazing him, their bells rattling.)

THE BELLS: Haltyaltyaltyall.

BLOOM: (Halts erect, stung by a spasm.) Ow!

(He looks round, darts forward suddenly. Through rising fog a dragon sandstrewer, travelling at caution, slews heavily down upon him, its huge red headlight winking, its trolley hissing on the wire. The motorman bangs his footgong.)

THE GONG: Bang Bang Bla Bak Blud Bugg Bloo.

(The brake cracks violently. Bloom, raising a policeman’s whitegloved hand, blunders stifflegged out of the track. The motorman, thrown forward, pugnosed, on the guidewheel, yells as he slides past over chains and keys.)

THE MOTORMAN: Hey, shitbreeches, are you doing the hat trick?

(Bloom trickleaps to the curbstone and halts again. He brushes a mudflake from his cheek with a parcelled hand.)

BLOOM: No thoroughfare. Close shave that but cured the stitch. Must take up Sandow’s exercises again. On the hands down. Insure against street accident too. The Providential. (He feels his trouser pocket.) Poor mamma’s panacea. Heel easily catch in track or bootlace in a cog. Day the wheel of the black Maria peeled off my shoe at Leonard’s corner. Third time is the charm. Shoe trick. Insolent driver. I ought to report him. Tension makes them nervous. Might be the fellow balked me this morning with that horsey woman. Same style of beauty. Quick of him all the same. The stiff walk. True word spoken in jest. That awful cramp in Lad lane. Something poisonous I ate. Emblem of luck. Why? Probably lost cattle. Mark of the beast. (He closes his eyes an instant.) Bit light in the head. Monthly or effect of the other. Brainfogfag. That tired feeling. Too much for me now. Ow!

(A sinister figure leans on plaited legs against O’Beirne’s wall, a visage unknown, injected with dark mercury. From under a wideleaved sombrero the figure regards him with evil eye.)

BLOOM: Buenas noches, señorita Blanca, que calle es esta?

THE FIGURE: (Impassive, raises a signal arm.) Password. Sraid Mabbot.

BLOOM: Haha. Merci. Esperanto. Slan leath. (He mutters.) Gaelic league spy, sent by that fireeater.

(He steps forward. A sackshouldered ragman bars his path. He steps left, ragsackman left.)

BLOOM: I beg.

(He leaps right, sackragman right.)

BLOOM: I beg.

(He swerves, sidles, stepaside, slips past and on.)

BLOOM: Keep to the right, right, right. If there is a signpost planted by the Touring Club at Stepaside who procured that public boon? I who lost my way and contributed to the columns of the Irish Cyclist the letter headed In darkest Stepaside. Keep, keep, keep to the right. Rags and bones at midnight. A fence more likely. First place murderer makes for. Wash off his sins of the world.

(Jacky Caffrey, hunted by Tommy Caffrey, runs full tilt against Bloom.)

BLOOM: O.

(Shocked, on weak hams, he halts. Tommy and Jacky vanish there, there. Bloom pats with parcelled hands watch, fobpocket, bookpocket, pursepoke, sweets of sin, potato soap.)

BLOOM: Beware of pickpockets. Old thieves’ dodge. Collide. Then snatch your purse.

(The retriever approaches sniffing, nose to the ground. A sprawled form sneezes. A stooped bearded figure appears garbed in the long caftan of an elder in Zion and a smokingcap with magenta tassels. Horned spectacles hang down at the wings of the nose. Yellow poison streaks are on the drawn face.)

RUDOLPH: Second halfcrown waste money today. I told you not go with drunken goy ever. So you catch no money.

BLOOM: (Hides the crubeen and trotter behind his back and, crestfallen, feels warm and cold feetmeat.) Ja, ich weiss, papachi.

RUDOLPH: What you making down this place? Have you no soul? (With feeble vulture talons he feels the silent face of Bloom.) Are you not my son Leopold, the grandson of Leopold? Are you not my dear son Leopold who left the house of his father and left the god of his fathers Abraham and Jacob?

BLOOM: (With precaution.) I suppose so, father. Mosenthal. All that’s left of him.

RUDOLPH: (Severely.) One night they bring you home drunk as dog after spend your good money. What you call them running chaps?

BLOOM: (In youth’s smart blue Oxford suit with white vestslips, narrowshouldered, in brown Alpine hat, wearing gent’s sterling silver waterbury keyless watch and double curb Albert with seal attached, one side of him coated with stiffening mud.) Harriers, father. Only that once.

RUDOLPH: Once! Mud head to foot. Cut your hand open. Lockjaw. They make you kaputt, Leopoldleben. You watch them chaps.

BLOOM: (Weakly.) They challenged me to a sprint. It was muddy. I slipped.

RUDOLPH: (With contempt.) Goim nachez! Nice spectacles for your poor mother!

BLOOM: Mamma!

ELLEN BLOOM: (In pantomime dame’s stringed mobcap, widow Twankey’s crinoline and bustle, blouse with muttonleg sleeves buttoned behind, grey mittens and cameo brooch, her plaited hair in a crispine net, appears over the staircase banisters, a slanted candlestick in her hand, and cries out in shrill alarm.) O blessed Redeemer, what have they done to him! My smelling salts! (She hauls up a reef of skirt and ransacks the pouch of her striped blay petticoat. A phial, an Agnus Dei, a shrivelled potato and a celluloid doll fall out.) Sacred Heart of Mary, where were you at all at all?

(Bloom, mumbling, his eyes downcast, begins to bestow his parcels in his filled pockets but desists, muttering.)

A VOICE: (Sharply.) Poldy!

BLOOM: Who? (He ducks and wards off a blow clumsily.) At your service.

(He looks up. Beside her mirage of datepalms a handsome woman in Turkish costume stands before him. Opulent curves fill out her scarlet trousers and jacket, slashed with gold. A wide yellow cummerbund girdles her. A white yashmak, violet in the night, covers her face, leaving free only her large dark eyes and raven hair.)

BLOOM: Molly!

MARION: Welly? Mrs Marion from this out, my dear man, when you speak to me. (Satirically.) Has poor little hubby cold feet waiting so long?

BLOOM: (Shifts from foot to foot.) No, no. Not the least little bit.

(He breathes in deep agitation, swallowing gulps of air, questions, hopes, crubeens for her supper, things to tell her, excuse, desire, spellbound. A coin gleams on her forehead. On her feet are jewelled toerings. Her ankles are linked by a slender fetterchain. Beside her a camel, hooded with a turreting turban, waits. A silk ladder of innumerable rungs climbs to his bobbing howdah. He ambles near with disgruntled hindquarters. Fiercely she slaps his haunch, her goldcurb wristbangles angriling, scolding him in Moorish.)

MARION: Nebrakada! Femininum!

(The camel, lifting a foreleg, plucks from a tree a large mango fruit, offers it to his mistress, blinking, in his cloven hoof, then droops his head and, grunting, with uplifted neck, fumbles to kneel. Bloom stoops his back for leapfrog.)

BLOOM: I can give you... I mean as your business menagerer... Mrs Marion... if you...

MARION: So you notice some change? (Her hands passing slowly over her trinketed stomacher, a slow friendly mockery in her eyes.) O Poldy, Poldy, you are a poor old stick in the mud! Go and see life. See the wide world.

BLOOM: I was just going back for that lotion whitewax, orangeflower water. Shop closes early on Thursday. But the first thing in the morning. (He pats divers pockets.) This moving kidney. Ah!

(He points to the south, then to the east. A cake of new clean lemon soap arises, diffusing light and perfume.)

THE SOAP:

We’re a capital couple are Bloom and I.
He brightens the earth. I polish the sky.

(The freckled face of Sweny, the druggist, appears in the disc of the soapsun.)

SWENY: Three and a penny, please.

BLOOM: Yes. For my wife. Mrs Marion. Special recipe.

MARION: (Softly.) Poldy!

BLOOM: Yes, ma’am?

MARION: Ti trema un poco il cuore?

(In disdain she saunters away, plump as a pampered pouter pigeon, humming the duet from Don Giovanni.)

BLOOM: Are you sure about that Voglio? I mean the pronunciati...

(He follows, followed by the sniffing terrier. The elderly bawd seizes his sleeve, the bristles of her chinmole glittering.)

THE BAWD: Ten shillings a maidenhead. Fresh thing was never touched. Fifteen. There’s no-one in it only her old father that’s dead drunk.

(She points. In the gap of her dark den furtive, rainbedraggled, Bridie Kelly stands.)

BRIDIE: Hatch street. Any good in your mind?

(With a squeak she flaps her bat shawl and runs. A burly rough pursues with booted strides. He stumbles on the steps, recovers, plunges into gloom. Weak squeaks of laughter are heard, weaker.)

THE BAWD: (Her wolfeyes shining.) He’s getting his pleasure. You won’t get a virgin in the flash houses. Ten shillings. Don’t be all night before the polis in plain clothes sees us. Sixtyseven is a bitch.

(Leering, Gerty Macdowell limps forward. She draws from behind, ogling, and shows coyly her bloodied clout.)

GERTY: With all my worldly goods I thee and thou. (She murmurs.) You did that. I hate you.

BLOOM: I? When? You’re dreaming. I never saw you.

THE BAWD: Leave the gentleman alone, you cheat. Writing the gentleman false letters. Streetwalking and soliciting. Better for your mother take the strap to you at the bedpost, hussy like you.

GERTY: (To Bloom.) When you saw all the secrets of my bottom drawer. (She paws his sleeve, slobbering.) Dirty married man! I love you for doing that to me.

(She glides away crookedly. Mrs Breen in man’s frieze overcoat with loose bellows pockets, stands in the causeway, her roguish eyes wideopen, smiling in all her herbivorous buckteeth.)

MRS BREEN: Mr...

BLOOM: (Coughs gravely.) Madam, when we last had this pleasure by letter dated the sixteenth instant...

MRS BREEN: Mr Bloom! You down here in the haunts of sin! I caught you nicely! Scamp!

BLOOM: (Hurriedly.) Not so loud my name. Whatever do you think of me? Don’t give me away. Walls have ears. How do you do? It’s ages since I. You’re looking splendid. Absolutely it. Seasonable weather we are having this time of year. Black refracts heat. Short cut home here. Interesting quarter. Rescue of fallen women. Magdalen asylum. I am the secretary...

MRS BREEN: (Holds up a finger.) Now, don’t tell a big fib! I know somebody won’t like that. O just wait till I see Molly! (Slily.) Account for yourself this very sminute or woe betide you!

BLOOM: (Looks behind.) She often said she’d like to visit. Slumming. The exotic, you see. Negro servants in livery too if she had money. Othello black brute. Eugene Stratton. Even the bones and cornerman at the Livermore christies. Bohee brothers. Sweep for that matter.

(Tom and Sam Bohee, coloured coons in white duck suits, scarlet socks, upstarched Sambo chokers and large scarlet asters in their buttonholes, leap out. Each has his banjo slung. Their paler smaller negroid hands jingle the twingtwang wires. Flashing white Kaffir eyes and tusks they rattle through a breakdown in clumsy clogs, twinging, singing, back to back, toe heel, heel toe, with smackfatclacking nigger lips.)

TOM AND SAM:

There’s someone in the house with Dina
There’s someone in the house, I know,
There’s someone in the house with Dina
Playing on the old banjo.

(They whisk black masks from raw babby faces: then, chuckling, chortling, trumming, twanging, they diddle diddle cakewalk dance away.)

BLOOM: (With a sour tenderish smile.) A little frivol, shall we, if you are so inclined? Would you like me perhaps to embrace you just for a fraction of a second?

MRS BREEN: (Screams gaily.) O, you ruck! You ought to see yourself!

BLOOM: For old sake’ sake. I only meant a square party, a mixed marriage mingling of our different little conjugials. You know I had a soft corner for you. (Gloomily.) ’Twas I sent you that valentine of the dear gazelle.

MRS BREEN: Glory Alice, you do look a holy show! Killing simply. (She puts out her hand inquisitively.) What are you hiding behind your back? Tell us, there’s a dear.

BLOOM: (Seizes her wrist with his free hand.) Josie Powell that was, prettiest deb in Dublin. How time flies by! Do you remember, harking back in a retrospective arrangement, Old Christmas night, Georgina Simpson’s housewarming while they were playing the Irving Bishop game, finding the pin blindfold and thoughtreading? Subject, what is in this snuffbox?

MRS BREEN: You were the lion of the night with your seriocomic recitation and you looked the part. You were always a favourite with the ladies.

BLOOM: (Squire of dames, in dinner jacket with wateredsilk facings, blue masonic badge in his buttonhole, black bow and mother-of-pearl studs, a prismatic champagne glass tilted in his hand.) Ladies and gentlemen, I give you Ireland, home and beauty.

MRS BREEN: The dear dead days beyond recall. Love’s old sweet song.

BLOOM: (Meaningfully dropping his voice.) I confess I’m teapot with curiosity to find out whether some person’s something is a little teapot at present.

MRS BREEN: (Gushingly.) Tremendously teapot! London’s teapot and I’m simply teapot all over me! (She rubs sides with him.) After the parlour mystery games and the crackers from the tree we sat on the staircase ottoman. Under the mistletoe. Two is company.

BLOOM: (Wearing a purple Napoleon hat with an amber halfmoon, his fingers and thumb passing slowly down to her soft moist meaty palm which she surrenders gently.) The witching hour of night. I took the splinter out of this hand, carefully, slowly. (Tenderly, as he slips on her finger a ruby ring.) Là ci darem la mano.

MRS BREEN: (In a onepiece evening frock executed in moonlight blue, a tinsel sylph’s diadem on her brow with her dancecard fallen beside her moonblue satin slipper, curves her palm softly, breathing quickly.) Voglio e non. You’re hot! You’re scalding! The left hand nearest the heart.

BLOOM: When you made your present choice they said it was beauty and the beast. I can never forgive you for that. (His clenched fist at his brow.) Think what it means. All you meant to me then. (Hoarsely.) Woman, it’s breaking me!

(Denis Breen, whitetallhatted, with Wisdom Hely’s sandwichboards, shuffles past them in carpet slippers, his dull beard thrust out, muttering to right and left. Little Alf Bergan, cloaked in the pall of the ace of spades, dogs him to left and right, doubled in laughter.)

ALF BERGAN: (Points jeering at the sandwichboards.) U. p: up.

MRS BREEN: (To Bloom.) High jinks below stairs. (She gives him the glad eye.) Why didn’t you kiss the spot to make it well? You wanted to.

BLOOM: (Shocked.) Molly’s best friend! Could you?

MRS BREEN: (Her pulpy tongue between her lips, offers a pigeon kiss.) Hnhn. The answer is a lemon. Have you a little present for me there?

BLOOM: (Offhandedly.) Kosher. A snack for supper. The home without potted meat is incomplete. I was at Leah, Mrs Bandmann Palmer. Trenchant exponent of Shakespeare. Unfortunately threw away the programme. Rattling good place round there for pigs’ feet. Feel.

(Richie Goulding, three ladies’ hats pinned on his head, appears weighted to one side by the black legal bag of Collis and Ward on which a skull and crossbones are painted in white limewash. He opens it and shows it full of polonies, kippered herrings, Findon haddies and tightpacked pills.)

RICHIE: Best value in Dub.

(Bald Pat, bothered beetle, stands on the curbstone, folding his napkin, waiting to wait.)

PAT: (Advances with a tilted dish of spillspilling gravy.) Steak and kidney. Bottle of lager. Hee hee hee. Wait till I wait.

RICHIE: Goodgod. Inev erate inall...

(With hanging head he marches doggedly forward. The navvy, lurching by, gores him with his flaming pronghorn.)

RICHIE: (With a cry of pain, his hand to his back.) Ah! Bright’s! Lights!

BLOOM: (Points to the navvy.) A spy. Don’t attract attention. I hate stupid crowds. I am not on pleasure bent. I am in a grave predicament.

MRS BREEN: Humbugging and deluthering as per usual with your cock and bull story.

BLOOM: I want to tell you a little secret about how I came to be here. But you must never tell. Not even Molly. I have a most particular reason.

MRS BREEN: (All agog.) O, not for worlds.

BLOOM: Let’s walk on. Shall us?

MRS BREEN: Let’s.

(The bawd makes an unheeded sign. Bloom walks on with Mrs Breen. The terrier follows, whining piteously, wagging his tail.)

THE BAWD: Jewman’s melt!

BLOOM: (In an oatmeal sporting suit, a sprig of woodbine in the lapel, tony buff shirt, shepherd’s plaid Saint Andrew’s cross scarftie, white spats, fawn dustcoat on his arm, tawny red brogues, fieldglasses in bandolier and a grey billycock hat.) Do you remember a long long time, years and years ago, just after Milly, Marionette we called her, was weaned when we all went together to Fairyhouse races, was it?

MRS BREEN: (In smart Saxe tailormade, white velours hat and spider veil.) Leopardstown.

BLOOM: I mean, Leopardstown. And Molly won seven shillings on a three year old named Nevertell and coming home along by Foxrock in that old fiveseater shanderadan of a waggonette you were in your heyday then and you had on that new hat of white velours with a surround of molefur that Mrs Hayes advised you to buy because it was marked down to nineteen and eleven, a bit of wire and an old rag of velveteen, and I’ll lay you what you like she did it on purpose...

MRS BREEN: She did, of course, the cat! Don’t tell me! Nice adviser!

BLOOM: Because it didn’t suit you one quarter as well as the other ducky little tammy toque with the bird of paradise wing in it that I admired on you and you honestly looked just too fetching in it though it was a pity to kill it, you cruel naughty creature, little mite of a thing with a heart the size of a fullstop.

MRS BREEN: (Squeezes his arm, simpers.) Naughty cruel I was!

BLOOM: (Low, secretly, ever more rapidly.) And Molly was eating a sandwich of spiced beef out of Mrs Joe Gallaher’s lunch basket. Frankly, though she had her advisers or admirers, I never cared much for her style. She was...

MRS BREEN: Too...

BLOOM: Yes. And Molly was laughing because Rogers and Maggot O’Reilly were mimicking a cock as we passed a farmhouse and Marcus Tertius Moses, the tea merchant, drove past us in a gig with his daughter, Dancer Moses was her name, and the poodle in her lap bridled up and you asked me if I ever heard or read or knew or came across...

MRS BREEN: (Eagerly.) Yes, yes, yes, yes, yes, yes, yes.

(She fades from his side. Followed by the whining dog he walks on towards hellsgates. In an archway a standing woman, bent forward, her feet apart, pisses cowily. Outside a shuttered pub a bunch of loiterers listen to a tale which their brokensnouted gaffer rasps out with raucous humour. An armless pair of them flop wrestling, growling, in maimed sodden playfight.)

THE GAFFER: (Crouches, his voice twisted in his snout.) And when Cairns came down from the scaffolding in Beaver street what was he after doing it into only into the bucket of porter that was there waiting on the shavings for Derwan’s plasterers.

THE LOITERERS: (Guffaw with cleft palates.) O jays!

(Their paintspeckled hats wag. Spattered with size and lime of their lodges they frisk limblessly about him.)

BLOOM: Coincidence too. They think it funny. Anything but that. Broad daylight. Trying to walk. Lucky no woman.

THE LOITERERS: Jays, that’s a good one. Glauber salts. O jays, into the men’s porter.

(Bloom passes. Cheap whores, singly, coupled, shawled, dishevelled, call from lanes, doors, corners.)

THE WHORES:

Are you going far, queer fellow?
How’s your middle leg?
Got a match on you?
Eh, come here till I stiffen it for you.

(He plodges through their sump towards the lighted street beyond. From a bulge of window curtains a gramophone rears a battered brazen trunk. In the shadow a shebeenkeeper haggles with the navvy and the two redcoats.)

THE NAVVY: (Belching.) Where’s the bloody house?

THE SHEBEENKEEPER: Purdon street. Shilling a bottle of stout. Respectable woman.

THE NAVVY: (Gripping the two redcoats, staggers forward with them.) Come on, you British army!

PRIVATE CARR: (Behind his back.) He aint half balmy.

PRIVATE COMPTON: (Laughs.) What ho!

PRIVATE CARR: (To the navvy.) Portobello barracks canteen. You ask for Carr. Just Carr.

THE NAVVY: (Shouts.)

We are the boys. Of Wexford.

PRIVATE COMPTON: Say! What price the sergeantmajor?

PRIVATE CARR: Bennett? He’s my pal. I love old Bennett.

THE NAVVY: (Shouts.)

The galling chain.
And free our native land.

(He staggers forward, dragging them with him. Bloom stops, at fault. The dog approaches, his tongue outlolling, panting.)

BLOOM: Wildgoose chase this. Disorderly houses. Lord knows where they are gone. Drunks cover distance double quick. Nice mixup. Scene at Westland row. Then jump in first class with third ticket. Then too far. Train with engine behind. Might have taken me to Malahide or a siding for the night or collision. Second drink does it. Once is a dose. What am I following him for? Still, he’s the best of that lot. If I hadn’t heard about Mrs Beaufoy Purefoy I wouldn’t have gone and wouldn’t have met. Kismet. He’ll lose that cash. Relieving office here. Good biz for cheapjacks, organs. What do ye lack? Soon got, soon gone. Might have lost my life too with that mangongwheeltracktrolleyglarejuggernaut only for presence of mind. Can’t always save you, though. If I had passed Truelock’s window that day two minutes later would have been shot. Absence of body. Still if bullet only went through my coat get damages for shock, five hundred pounds. What was he? Kildare street club toff. God help his gamekeeper.

(He gazes ahead, reading on the wall a scrawled chalk legend Wet Dream and a phallic design.) Odd! Molly drawing on the frosted carriagepane at Kingstown. What’s that like? (Gaudy dollwomen loll in the lighted doorways, in window embrasures, smoking birdseye cigarettes. The odour of the sicksweet weed floats towards him in slow round ovalling wreaths.)

THE WREATHS: Sweet are the sweets. Sweets of sin.

BLOOM: My spine’s a bit limp. Go or turn? And this food? Eat it and get all pigsticky. Absurd I am. Waste of money. One and eightpence too much. (The retriever drives a cold snivelling muzzle against his hand, wagging his tail.) Strange how they take to me. Even that brute today. Better speak to him first. Like women they like rencontres. Stinks like a polecat. Chacun son goût. He might be mad. Dogdays. Uncertain in his movements. Good fellow! Fido! Good fellow! Garryowen! (The wolfdog sprawls on his back, wriggling obscenely with begging paws, his long black tongue lolling out.) Influence of his surroundings. Give and have done with it. Provided nobody. (Calling encouraging words he shambles back with a furtive poacher’s tread, dogged by the setter into a dark stalestunk corner. He unrolls one parcel and goes to dump the crubeen softly but holds back and feels the trotter.) Sizeable for threepence. But then I have it in my left hand. Calls for more effort. Why? Smaller from want of use. O, let it slide. Two and six.

(With regret he lets the unrolled crubeen and trotter slide. The mastiff mauls the bundle clumsily and gluts himself with growling greed, crunching the bones. Two raincaped watch approach, silent, vigilant. They murmur together.)

THE WATCH: Bloom. Of Bloom. For Bloom. Bloom.

(Each lays hand on Bloom’s shoulder.)

FIRST WATCH: Caught in the act. Commit no nuisance.

BLOOM: (Stammers.) I am doing good to others.

(A covey of gulls, storm petrels, rises hungrily from Liffey slime with Banbury cakes in their beaks.)

THE GULLS: Kaw kave kankury kake.

BLOOM: The friend of man. Trained by kindness.

(He points. Bob Doran, toppling from a high barstool, sways over the munching spaniel.)

BOB DORAN: Towser. Give us the paw. Give the paw.

(The bulldog growls, his scruff standing, a gobbet of pig’s knuckle between his molars through which rabid scumspittle dribbles. Bob Doran falls silently into an area.)

SECOND WATCH: Prevention of cruelty to animals.

BLOOM: (Enthusiastically.) A noble work! I scolded that tramdriver on Harold’s cross bridge for illusing the poor horse with his harness scab. Bad French I got for my pains. Of course it was frosty and the last tram. All tales of circus life are highly demoralising.

(Signor Maffei, passionpale, in liontamer’s costume with diamond studs in his shirtfront, steps forward, holding a circus paperhoop, a curling carriagewhip and a revolver with which he covers the gorging boarhound.)

SIGNOR MAFFEI: (With a sinister smile.) Ladies and gentlemen, my educated greyhound. It was I broke in the bucking broncho Ajax with my patent spiked saddle for carnivores. Lash under the belly with a knotted thong. Block tackle and a strangling pulley will bring your lion to heel, no matter how fractious, even Leo ferox there, the Libyan maneater. A redhot crowbar and some liniment rubbing on the burning part produced Fritz of Amsterdam, the thinking hyena. (He glares.) I possess the Indian sign. The glint of my eye does it with these breastsparklers. (With a bewitching smile.) I now introduce Mademoiselle Ruby, the pride of the ring.

FIRST WATCH: Come. Name and address.

BLOOM: I have forgotten for the moment. Ah, yes! (He takes off his high grade hat, saluting.) Dr Bloom, Leopold, dental surgeon. You have heard of von Blum Pasha. Umpteen millions. Donnerwetter! Owns half Austria. Egypt. Cousin.

FIRST WATCH: Proof.

(A card falls from inside the leather headband of Bloom’s hat.)

BLOOM: (In red fez, cadi’s dress coat with broad green sash, wearing a false badge of the Legion of Honour, picks up the card hastily and offers it.) Allow me. My club is the Junior Army and Navy. Solicitors: Messrs John Henry Menton, 27 Bachelor’s Walk.

FIRST WATCH: (Reads.) Henry Flower. No fixed abode. Unlawfully watching and besetting.

SECOND WATCH: An alibi. You are cautioned.

BLOOM: (Produces from his heartpocket a crumpled yellow flower.) This is the flower in question. It was given me by a man I don’t know his name. (Plausibly.) You know that old joke, rose of Castile. Bloom. The change of name. Virag. (He murmurs privately and confidentially.) We are engaged you see, sergeant. Lady in the case. Love entanglement. (He shoulders the second watch gently.) Dash it all. It’s a way we gallants have in the navy. Uniform that does it. (He turns gravely to the first watch.) Still, of course, you do get your Waterloo sometimes. Drop in some evening and have a glass of old Burgundy. (To the second watch gaily.) I’ll introduce you, inspector. She’s game. Do it in the shake of a lamb’s tail.

(A dark mercurialised face appears, leading a veiled figure.)

THE DARK MERCURY: The Castle is looking for him. He was drummed out of the army.

MARTHA: (Thickveiled, a crimson halter round her neck, a copy of the Irish Times in her hand, in tone of reproach, pointing.) Henry! Leopold! Lionel, thou lost one! Clear my name.

FIRST WATCH: (Sternly.) Come to the station.

BLOOM: (Scared, hats himself, steps back, then, plucking at his heart and lifting his right forearm on the square, he gives the sign and dueguard of fellowcraft.) No, no, worshipful master, light of love. Mistaken identity. The Lyons mail. Lesurques and Dubosc. You remember the Childs fratricide case. We medical men. By striking him dead with a hatchet. I am wrongfully accused. Better one guilty escape than ninetynine wrongfully condemned.

MARTHA: (Sobbing behind her veil.) Breach of promise. My real name is Peggy Griffin. He wrote to me that he was miserable. I’ll tell my brother, the Bective rugger fullback, on you, heartless flirt.

BLOOM: (Behind his hand.) She’s drunk. The woman is inebriated. (He murmurs vaguely the pass of Ephraim.) Shitbroleeth.

SECOND WATCH: (Tears in his eyes, to Bloom.) You ought to be thoroughly well ashamed of yourself.

BLOOM: Gentlemen of the jury, let me explain. A pure mare’s nest. I am a man misunderstood. I am being made a scapegoat of. I am a respectable married man, without a stain on my character. I live in Eccles street. My wife, I am the daughter of a most distinguished commander, a gallant upstanding gentleman, what do you call him, Majorgeneral Brian Tweedy, one of Britain’s fighting men who helped to win our battles. Got his majority for the heroic defence of Rorke’s Drift.

FIRST WATCH: Regiment.

BLOOM: (Turns to the gallery.) The royal Dublins, boys, the salt of the earth, known the world over. I think I see some old comrades in arms up there among you. The R. D. F., with our own Metropolitan police, guardians of our homes, the pluckiest lads and the finest body of men, as physique, in the service of our sovereign.

A VOICE: Turncoat! Up the Boers! Who booed Joe Chamberlain?

BLOOM: (His hand on the shoulder of the first watch.) My old dad too was a J. P. I’m as staunch a Britisher as you are, sir. I fought with the colours for king and country in the absentminded war under general Gough in the park and was disabled at Spion Kop and Bloemfontein, was mentioned in dispatches. I did all a white man could. (With quiet feeling.) Jim Bludso. Hold her nozzle again the bank.

FIRST WATCH: Profession or trade.

BLOOM: Well, I follow a literary occupation, author-journalist. In fact we are just bringing out a collection of prize stories of which I am the inventor, something that is an entirely new departure. I am connected with the British and Irish press. If you ring up...

(Myles Crawford strides out jerkily, a quill between his teeth. His scarlet beak blazes within the aureole of his straw hat. He dangles a hank of Spanish onions in one hand and holds with the other hand a telephone receiver nozzle to his ear.)

MYLES CRAWFORD: (His cock’s wattles wagging.) Hello, seventyseven eightfour. Hello. Freeman’s Urinal and Weekly Arsewipe here. Paralyse Europe. You which? Bluebags? Who writes? Is it Bloom?

(Mr Philip Beaufoy, palefaced, stands in the witnessbox, in accurate morning dress, outbreast pocket with peak of handkerchief showing, creased lavender trousers and patent boots. He carries a large portfolio labelled Matcham’s Masterstrokes.)

BEAUFOY: (Drawls.) No, you aren’t. Not by a long shot if I know it. I don’t see it, that’s all. No born gentleman, no-one with the most rudimentary promptings of a gentleman would stoop to such particularly loathsome conduct. One of those, my lord. A plagiarist. A soapy sneak masquerading as a literateur. It’s perfectly obvious that with the most inherent baseness he has cribbed some of my bestselling copy, really gorgeous stuff, a perfect gem, the love passages in which are beneath suspicion. The Beaufoy books of love and great possessions, with which your lordship is doubtless familiar, are a household word throughout the kingdom.

BLOOM: (Murmurs with hangdog meekness glum.) That bit about the laughing witch hand in hand I take exception to, if I may...

BEAUFOY: (His lip upcurled, smiles superciliously on the court.) You funny ass, you! You’re too beastly awfully weird for words! I don’t think you need over excessively disincommodate yourself in that regard. My literary agent Mr J. B. Pinker is in attendance. I presume, my lord, we shall receive the usual witnesses’ fees, shan’t we? We are considerably out of pocket over this bally pressman johnny, this jackdaw of Rheims, who has not even been to a university.

BLOOM: (Indistinctly.) University of life. Bad art.

BEAUFOY: (Shouts.) It’s a damnably foul lie, showing the moral rottenness of the man! (He extends his portfolio.) We have here damning evidence, the corpus delicti, my lord, a specimen of my maturer work disfigured by the hallmark of the beast.

A VOICE FROM THE GALLERY:

Moses, Moses, king of the jews,
Wiped his arse in the Daily News.

BLOOM: (Bravely.) Overdrawn.

BEAUFOY: You low cad! You ought to be ducked in the horsepond, you rotter! (To the court.) Why, look at the man’s private life! Leading a quadruple existence! Street angel and house devil. Not fit to be mentioned in mixed society! The archconspirator of the age!

BLOOM: (To the court.) And he, a bachelor, how...

FIRST WATCH: The King versus Bloom. Call the woman Driscoll.

THE CRIER: Mary Driscoll, scullerymaid!

(Mary Driscoll, a slipshod servant girl, approaches. She has a bucket on the crook of her arm and a scouringbrush in her hand.)

SECOND WATCH: Another! Are you of the unfortunate class?

MARY DRISCOLL: (Indignantly.) I’m not a bad one. I bear a respectable character and was four months in my last place. I was in a situation, six pounds a year and my chances with Fridays out and I had to leave owing to his carryings on.

FIRST WATCH: What do you tax him with?

MARY DRISCOLL: He made a certain suggestion but I thought more of myself as poor as I am.

BLOOM: (In housejacket of ripplecloth, flannel trousers, heelless slippers, unshaven, his hair rumpled: softly.) I treated you white. I gave you mementos, smart emerald garters far above your station. Incautiously I took your part when you were accused of pilfering. There’s a medium in all things. Play cricket.

MARY DRISCOLL: (Excitedly.) As God is looking down on me this night if ever I laid a hand to them oylsters!

FIRST WATCH: The offence complained of? Did something happen?

MARY DRISCOLL: He surprised me in the rere of the premises, Your honour, when the missus was out shopping one morning with a request for a safety pin. He held me and I was discoloured in four places as a result. And he interfered twict with my clothing.

BLOOM: She counterassaulted.

MARY DRISCOLL: (Scornfully.) I had more respect for the scouringbrush, so I had. I remonstrated with him, Your lord, and he remarked: keep it quiet.

(General laughter.)

GEORGE FOTTRELL: (Clerk of the crown and peace, resonantly.) Order in court! The accused will now make a bogus statement.

(Bloom, pleading not guilty and holding a fullblown waterlily, begins a long unintelligible speech. They would hear what counsel had to say in his stirring address to the grand jury. He was down and out but, though branded as a black sheep, if he might say so, he meant to reform, to retrieve the memory of the past in a purely sisterly way and return to nature as a purely domestic animal. A sevenmonths’ child, he had been carefully brought up and nurtured by an aged bedridden parent. There might have been lapses of an erring father but he wanted to turn over a new leaf and now, when at long last in sight of the whipping post, to lead a homely life in the evening of his days, permeated by the affectionate surroundings of the heaving bosom of the family. An acclimatised Britisher, he had seen that summer eve from the footplate of an engine cab of the Loop line railway company while the rain refrained from falling glimpses, as it were, through the windows of loveful households in Dublin city and urban district of scenes truly rural of happiness of the better land with Dockrell’s wallpaper at one and ninepence a dozen, innocent Britishborn bairns lisping prayers to the Sacred Infant, youthful scholars grappling with their pensums or model young ladies playing on the pianoforte or anon all with fervour reciting the family rosary round the crackling Yulelog while in the boreens and green lanes the colleens with their swains strolled what times the strains of the organtoned melodeon Britannia metalbound with four acting stops and twelvefold bellows, a sacrifice, greatest bargain ever....

(Renewed laughter. He mumbles incoherently. Reporters complain that they cannot hear.)

LONGHAND AND SHORTHAND: (Without looking up from their notebooks.) Loosen his boots.

PROFESSOR MACHUGH: (From the presstable, coughs and calls.) Cough it up, man. Get it out in bits.

(The crossexamination proceeds re Bloom and the bucket. A large bucket. Bloom himself. Bowel trouble. In Beaver street. Gripe, yes. Quite bad. A plasterer’s bucket. By walking stifflegged. Suffered untold misery. Deadly agony. About noon. Love or burgundy. Yes, some spinach. Crucial moment. He did not look in the bucket. Nobody. Rather a mess. Not completely. A Titbits back number.)

(Uproar and catcalls. Bloom in a torn frockcoat stained with whitewash, dinged silk hat sideways on his head, a strip of stickingplaster across his nose, talks inaudibly.)

J. J. O’MOLLOY: (In barrister’s grey wig and stuffgown, speaking with a voice of pained protest.) This is no place for indecent levity at the expense of an erring mortal disguised in liquor. We are not in a beargarden nor at an Oxford rag nor is this a travesty of justice. My client is an infant, a poor foreign immigrant who started scratch as a stowaway and is now trying to turn an honest penny. The trumped up misdemeanour was due to a momentary aberration of heredity, brought on by hallucination, such familiarities as the alleged guilty occurrence being quite permitted in my client’s native place, the land of the Pharaoh. Prima facie, I put it to you that there was no attempt at carnally knowing. Intimacy did not occur and the offence complained of by Driscoll, that her virtue was solicited, was not repeated. I would deal in especial with atavism. There have been cases of shipwreck and somnambulism in my client’s family. If the accused could speak he could a tale unfold—one of the strangest that have ever been narrated between the covers of a book. He himself, my lord, is a physical wreck from cobbler’s weak chest. His submission is that he is of Mongolian extraction and irresponsible for his actions. Not all there, in fact.

BLOOM: (Barefoot, pigeonbreasted, in lascar’s vest and trousers, apologetic toes turned in, opens his tiny mole’s eyes and looks about him dazedly, passing a slow hand across his forehead. Then he hitches his belt sailor fashion and with a shrug of oriental obeisance salutes the court, pointing one thumb heavenward.) Him makee velly muchee fine night. (He begins to lilt simply.)

Li li poo lil chile
Blingee pigfoot evly night
Payee two shilly...

(He is howled down.)

J. J. O’MOLLOY: (Hotly to the populace.) This is a lonehand fight. By Hades, I will not have any client of mine gagged and badgered in this fashion by a pack of curs and laughing hyenas. The Mosaic code has superseded the law of the jungle. I say it and I say it emphatically, without wishing for one moment to defeat the ends of justice, accused was not accessory before the act and prosecutrix has not been tampered with. The young person was treated by defendant as if she were his very own daughter. (Bloom takes J. J. O’Molloy’s hand and raises it to his lips.) I shall call rebutting evidence to prove up to the hilt that the hidden hand is again at its old game. When in doubt persecute Bloom. My client, an innately bashful man, would be the last man in the world to do anything ungentlemanly which injured modesty could object to or cast a stone at a girl who took the wrong turning when some dastard, responsible for her condition, had worked his own sweet will on her. He wants to go straight. I regard him as the whitest man I know. He is down on his luck at present owing to the mortgaging of his extensive property at Agendath Netaim in faraway Asia Minor, slides of which will now be shown. (To Bloom.) I suggest that you will do the handsome thing.

BLOOM: A penny in the pound.

(The image of the lake of Kinnereth with blurred cattle cropping in silver haze is projected on the wall. Moses Dlugacz, ferreteyed albino, in blue dungarees, stands up in the gallery, holding in each hand an orange citron and a pork kidney.)

DLUGACZ: (Hoarsely.) Bleibtreustrasse, Berlin, W. 13.

(J. J. O’Molloy steps on to a low plinth and holds the lapel of his coat with solemnity. His face lengthens, grows pale and bearded, with sunken eyes, the blotches of phthisis and hectic cheekbones of John F. Taylor. He applies his handkerchief to his mouth and scrutinises the galloping tide of rosepink blood.)

J. J. O’MOLLOY: (Almost voicelessly.) Excuse me. I am suffering from a severe chill, have recently come from a sickbed. A few wellchosen words. (He assumes the avine head, foxy moustache and proboscidal eloquence of Seymour Bushe.) When the angel’s book comes to be opened if aught that the pensive bosom has inaugurated of soultransfigured and of soultransfiguring deserves to live I say accord the prisoner at the bar the sacred benefit of the doubt.

(A paper with something written on it is handed into court.)

BLOOM: (In court dress.) Can give best references. Messrs Callan, Coleman. Mr Wisdom Hely J. P. My old chief Joe Cuffe. Mr V. B. Dillon, ex lord mayor of Dublin. I have moved in the charmed circle of the highest... Queens of Dublin society. (Carelessly.) I was just chatting this afternoon at the viceregal lodge to my old pals, sir Robert and lady Ball, astronomer royal, at the levee. Sir Bob, I said...

MRS YELVERTON BARRY: (In lowcorsaged opal balldress and elbowlength ivory gloves, wearing a sabletrimmed brickquilted dolman, a comb of brilliants and panache of osprey in her hair.) Arrest him, constable. He wrote me an anonymous letter in prentice backhand when my husband was in the North Riding of Tipperary on the Munster circuit, signed James Lovebirch. He said that he had seen from the gods my peerless globes as I sat in a box of the Theatre Royal at a command performance of La Cigale. I deeply inflamed him, he said. He made improper overtures to me to misconduct myself at half past four p.m. on the following Thursday, Dunsink time. He offered to send me through the post a work of fiction by Monsieur Paul de Kock, entitled The Girl with the Three Pairs of Stays.

MRS BELLINGHAM: (In cap and seal coney mantle, wrapped up to the nose, steps out of her brougham and scans through tortoiseshell quizzing-glasses which she takes from inside her huge opossum muff.) Also to me. Yes, I believe it is the same objectionable person. Because he closed my carriage door outside sir Thornley Stoker’s one sleety day during the cold snap of February ninetythree when even the grid of the wastepipe and the ballstop in my bath cistern were frozen. Subsequently he enclosed a bloom of edelweiss culled on the heights, as he said, in my honour. I had it examined by a botanical expert and elicited the information that it was a blossom of the homegrown potato plant purloined from a forcingcase of the model farm.

MRS YELVERTON BARRY: Shame on him!

(A crowd of sluts and ragamuffins surges forward.)

THE SLUTS AND RAGAMUFFINS: (Screaming.) Stop thief! Hurrah there, Bluebeard! Three cheers for Ikey Mo!

SECOND WATCH: (Produces handcuffs.) Here are the darbies.

MRS BELLINGHAM: He addressed me in several handwritings with fulsome compliments as a Venus in furs and alleged profound pity for my frostbound coachman Palmer while in the same breath he expressed himself as envious of his earflaps and fleecy sheepskins and of his fortunate proximity to my person, when standing behind my chair wearing my livery and the armorial bearings of the Bellingham escutcheon garnished sable, a buck’s head couped or. He lauded almost extravagantly my nether extremities, my swelling calves in silk hose drawn up to the limit, and eulogised glowingly my other hidden treasures in priceless lace which, he said, he could conjure up. He urged me (Stating that he felt it his mission in life to urge me.) to defile the marriage bed, to commit adultery at the earliest possible opportunity.

THE HONOURABLE MRS MERVYN TALBOYS: (In amazon costume, hard hat, jackboots cockspurred, vermilion waistcoat, fawn musketeer gauntlets with braided drums, long train held up and hunting crop with which she strikes her welt constantly.) Also me. Because he saw me on the polo ground of the Phoenix park at the match All Ireland versus the Rest of Ireland. My eyes, I know, shone divinely as I watched Captain Slogger Dennehy of the Inniskillings win the final chukkar on his darling cob Centaur. This plebeian Don Juan observed me from behind a hackney car and sent me in double envelopes an obscene photograph, such as are sold after dark on Paris boulevards, insulting to any lady. I have it still. It represents a partially nude señorita, frail and lovely (his wife, as he solemnly assured me, taken by him from nature), practising illicit intercourse with a muscular torero, evidently a blackguard. He urged me to do likewise, to misbehave, to sin with officers of the garrison. He implored me to soil his letter in an unspeakable manner, to chastise him as he richly deserves, to bestride and ride him, to give him a most vicious horsewhipping.

MRS BELLINGHAM: Me too.

MRS YELVERTON BARRY: Me too.

(Several highly respectable Dublin ladies hold up improper letters received from Bloom.)

THE HONOURABLE MRS MERVYN TALBOYS: (Stamps her jingling spurs in a sudden paroxysm of fury.) I will, by the God above me. I’ll scourge the pigeonlivered cur as long as I can stand over him. I’ll flay him alive.

BLOOM: (His eyes closing, quails expectantly.) Here? (He squirms.) Again! (He pants cringing.) I love the danger.

THE HONOURABLE MRS MERVYN TALBOYS: Very much so! I’ll make it hot for you. I’ll make you dance Jack Latten for that.

MRS BELLINGHAM: Tan his breech well, the upstart! Write the stars and stripes on it!

MRS YELVERTON BARRY: Disgraceful! There’s no excuse for him! A married man!

BLOOM: All these people. I meant only the spanking idea. A warm tingling glow without effusion. Refined birching to stimulate the circulation.

THE HONOURABLE MRS MERVYN TALBOYS: (Laughs derisively.) O, did you, my fine fellow? Well, by the living God, you’ll get the surprise of your life now, believe me, the most unmerciful hiding a man ever bargained for. You have lashed the dormant tigress in my nature into fury.

MRS BELLINGHAM: (Shakes her muff and quizzing-glasses vindictively.) Make him smart, Hanna dear. Give him ginger. Thrash the mongrel within an inch of his life. The cat-o’-nine-tails. Geld him. Vivisect him.

BLOOM: (Shuddering, shrinking, joins his hands: with hangdog mien.) O cold! O shivery! It was your ambrosial beauty. Forget, forgive. Kismet. Let me off this once. (He offers the other cheek.)

MRS YELVERTON BARRY: (Severely.) Don’t do so on any account, Mrs Talboys! He should be soundly trounced!

THE HONOURABLE MRS MERVYN TALBOYS: (Unbuttoning her gauntlet violently.) I’ll do no such thing. Pigdog and always was ever since he was pupped! To dare address me! I’ll flog him black and blue in the public streets. I’ll dig my spurs in him up to the rowel. He is a wellknown cuckold. (She swishes her huntingcrop savagely in the air.) Take down his trousers without loss of time. Come here, sir! Quick! Ready?

BLOOM: (Trembling, beginning to obey.) The weather has been so warm.

(Davy Stephens, ringletted, passes with a bevy of barefoot newsboys.)

DAVY STEPHENS: Messenger of the Sacred Heart and Evening Telegraph with Saint Patrick’s Day supplement. Containing the new addresses of all the cuckolds in Dublin.

(The very reverend Canon O’Hanlon in cloth of gold cope elevates and exposes a marble timepiece. Before him Father Conroy and the reverend John Hughes S. J. bend low.)

THE TIMEPIECE: (Unportalling.)

Cuckoo.
Cuckoo.
Cuckoo.

(The brass quoits of a bed are heard to jingle.)

THE QUOITS: Jigjag. Jigajiga. Jigjag.

(A panel of fog rolls back rapidly, revealing rapidly in the jurybox the faces of Martin Cunningham, foreman, silkhatted, Jack Power, Simon Dedalus, Tom Kernan, Ned Lambert, John Henry Menton, Myles Crawford, Lenehan, Paddy Leonard, Nosey Flynn, M’Coy and the featureless face of a Nameless One.)

THE NAMELESS ONE: Bareback riding. Weight for age. Gob, he organised her.

THE JURORS: (All their heads turned to his voice.) Really?

THE NAMELESS ONE: (Snarls.) Arse over tip. Hundred shillings to five.

THE JURORS: (All their heads lowered in assent.) Most of us thought as much.

FIRST WATCH: He is a marked man. Another girl’s plait cut. Wanted: Jack the Ripper. A thousand pounds reward.

SECOND WATCH: (Awed, whispers.) And in black. A mormon. Anarchist.

THE CRIER: (Loudly.) Whereas Leopold Bloom of no fixed abode is a wellknown dynamitard, forger, bigamist, bawd and cuckold and a public nuisance to the citizens of Dublin and whereas at this commission of assizes the most honourable...

(His Honour, sir Frederick Falkiner, recorder of Dublin, in judicial garb of grey stone rises from the bench, stonebearded. He bears in his arms an umbrella sceptre. From his forehead arise starkly the Mosaic ramshorns.)

THE RECORDER: I will put an end to this white slave traffic and rid Dublin of this odious pest. Scandalous! (He dons the black cap.) Let him be taken, Mr Subsheriff, from the dock where he now stands and detained in custody in Mountjoy prison during His Majesty’s pleasure and there be hanged by the neck until he is dead and therein fail not at your peril or may the Lord have mercy on your soul. Remove him. (A black skullcap descends upon his head.)

(The subsheriff Long John Fanning appears, smoking a pungent Henry Clay.)

LONG JOHN FANNING: (Scowls and calls with rich rolling utterance.) Who’ll hang Judas Iscariot?

(H. Rumbold, master barber, in a bloodcoloured jerkin and tanner’s apron, a rope coiled over his shoulder, mounts the block. A life preserver and a nailstudded bludgeon are stuck in his belt. He rubs grimly his grappling hands, knobbed with knuckledusters.)

RUMBOLD: (To the recorder with sinister familiarity.) Hanging Harry, your Majesty, the Mersey terror. Five guineas a jugular. Neck or nothing.

(The bells of George’s church toll slowly, loud dark iron.)

THE BELLS: Heigho! Heigho!

BLOOM: (Desperately.) Wait. Stop. Gulls. Good heart. I saw. Innocence. Girl in the monkeyhouse. Zoo. Lewd chimpanzee. (Breathlessly.) Pelvic basin. Her artless blush unmanned me. (Overcome with emotion.) I left the precincts. (He turns to a figure in the crowd, appealing.) Hynes, may I speak to you? You know me. That three shillings you can keep. If you want a little more...

HYNES: (Coldly.) You are a perfect stranger.

SECOND WATCH: (Points to the corner.) The bomb is here.

FIRST WATCH: Infernal machine with a time fuse.

BLOOM: No, no. Pig’s feet. I was at a funeral.

FIRST WATCH: (Draws his truncheon.) Liar!

(The beagle lifts his snout, showing the grey scorbutic face of Paddy Dignam. He has gnawed all. He exhales a putrid carcasefed breath. He grows to human size and shape. His dachshund coat becomes a brown mortuary habit. His green eye flashes bloodshot. Half of one ear, all the nose and both thumbs are ghouleaten.)

PADDY DIGNAM: (In a hollow voice.) It is true. It was my funeral. Doctor Finucane pronounced life extinct when I succumbed to the disease from natural causes.

(He lifts his mutilated ashen face moonwards and bays lugubriously.)

BLOOM: (In triumph.) You hear?

PADDY DIGNAM: Bloom, I am Paddy Dignam’s spirit. List, list, O list!

BLOOM: The voice is the voice of Esau.

SECOND WATCH: (Blesses himself.) How is that possible?

FIRST WATCH: It is not in the penny catechism.

PADDY DIGNAM: By metempsychosis. Spooks.

A VOICE: O rocks.

PADDY DIGNAM: (Earnestly.) Once I was in the employ of Mr J. H. Menton, solicitor, commissioner for oaths and affidavits, of 27 Bachelor’s Walk. Now I am defunct, the wall of the heart hypertrophied. Hard lines. The poor wife was awfully cut up. How is she bearing it? Keep her off that bottle of sherry. (He looks round him.) A lamp. I must satisfy an animal need. That buttermilk didn’t agree with me.

(The portly figure of John O’Connell, caretaker, stands forth, holding a bunch of keys tied with crape. Beside him stands Father Coffey, chaplain, toadbellied, wrynecked, in a surplice and bandanna nightcap, holding sleepily a staff of twisted poppies.)

FATHER COFFEY: (Yawns, then chants with a hoarse croak.) Namine. Jacobs. Vobiscuits. Amen.

JOHN O’CONNELL: (Foghorns stormily through his megaphone.) Dignam, Patrick T, deceased.

PADDY DIGNAM: (With pricked up ears, winces.) Overtones. (He wriggles forward and places an ear to the ground.) My master’s voice!

JOHN O’CONNELL: Burial docket letter number U. P. eightyfive thousand. Field seventeen. House of Keys. Plot, one hundred and one.

(Paddy Dignam listens with visible effort, thinking, his tail stiffpointed, his ears cocked.)

PADDY DIGNAM: Pray for the repose of his soul.

(He worms down through a coalhole, his brown habit trailing its tether over rattling pebbles. After him toddles an obese grandfather rat on fungus turtle paws under a grey carapace. Dignam’s voice, muffled, is heard baying under ground: Dignam’s dead and gone below. Tom Rochford, robinredbreasted, in cap and breeches, jumps from his twocolumned machine.)

TOM ROCHFORD: (A hand to his breastbone, bows.) Reuben J. A florin I find him. (He fixes the manhole with a resolute stare.) My turn now on. Follow me up to Carlow.

(He executes a daredevil salmon leap in the air and is engulfed in the coalhole. Two discs on the columns wobble, eyes of nought. All recedes. Bloom plodges forward again through the sump. Kisses chirp amid the rifts of fog. A piano sounds. He stands before a lighted house, listening. The kisses, winging from their bowers, fly about him, twittering, warbling, cooing.)

THE KISSES: (Warbling.) Leo! (Twittering.) Icky licky micky sticky for Leo! (Cooing.) Coo coocoo! Yummyyum, Womwom! (Warbling.) Big comebig! Pirouette! Leopopold! (Twittering.) Leeolee! (Warbling.) O Leo!

(They rustle, flutter upon his garments, alight, bright giddy flecks, silvery sequins.)

BLOOM: A man’s touch. Sad music. Church music. Perhaps here.

(Zoe Higgins, a young whore in a sapphire slip, closed with three bronze buckles, a slim black velvet fillet round her throat, nods, trips down the steps and accosts him.)

ZOE: Are you looking for someone? He’s inside with his friend.

BLOOM: Is this Mrs Mack’s?

ZOE: No, eightyone. Mrs Cohen’s. You might go farther and fare worse. Mother Slipperslapper. (Familiarly.) She’s on the job herself tonight with the vet her tipster that gives her all the winners and pays for her son in Oxford. Working overtime but her luck’s turned today. (Suspiciously.) You’re not his father, are you?

BLOOM: Not I!

ZOE: You both in black. Has little mousey any tickles tonight?

(His skin, alert, feels her fingertips approach. A hand glides over his left thigh.)

ZOE: How’s the nuts?

BLOOM: Off side. Curiously they are on the right. Heavier, I suppose. One in a million my tailor, Mesias, says.

ZOE: (In sudden alarm.) You’ve a hard chancre.

BLOOM: Not likely.

ZOE: I feel it.

(Her hand slides into his left trouser pocket and brings out a hard black shrivelled potato. She regards it and Bloom with dumb moist lips.)

BLOOM: A talisman. Heirloom.

ZOE: For Zoe? For keeps? For being so nice, eh?

(She puts the potato greedily into a pocket then links his arm, cuddling him with supple warmth. He smiles uneasily. Slowly, note by note, oriental music is played. He gazes in the tawny crystal of her eyes, ringed with kohol. His smile softens.)

ZOE: You’ll know me the next time.

BLOOM: (Forlornly.) I never loved a dear gazelle but it was sure to...

(Gazelles are leaping, feeding on the mountains. Near are lakes. Round their shores file shadows black of cedargroves. Aroma rises, a strong hairgrowth of resin. It burns, the orient, a sky of sapphire, cleft by the bronze flight of eagles. Under it lies the womancity, nude, white, still, cool, in luxury. A fountain murmurs among damask roses. Mammoth roses murmur of scarlet winegrapes. A wine of shame, lust, blood exudes, strangely murmuring.)

ZOE: (Murmuring singsong with the music, her odalisk lips lusciously smeared with salve of swinefat and rosewater.) Schorach ani wenowach, benoith Hierushaloim.

BLOOM: (Fascinated.) I thought you were of good stock by your accent.

ZOE: And you know what thought did?

(She bites his ear gently with little goldstopped teeth, sending on him a cloying breath of stale garlic. The roses draw apart, disclose a sepulchre of the gold of kings and their mouldering bones.)

BLOOM: (Draws back, mechanically caressing her right bub with a flat awkward hand.) Are you a Dublin girl?

ZOE: (Catches a stray hair deftly and twists it to her coil.) No bloody fear. I’m English. Have you a swaggerroot?

BLOOM: (As before.) Rarely smoke, dear. Cigar now and then. Childish device. (Lewdly.) The mouth can be better engaged than with a cylinder of rank weed.

ZOE: Go on. Make a stump speech out of it.

BLOOM: (In workman’s corduroy overalls, black gansy with red floating tie and apache cap.) Mankind is incorrigible. Sir Walter Ralegh brought from the new world that potato and that weed, the one a killer of pestilence by absorption, the other a poisoner of the ear, eye, heart, memory, will, understanding, all. That is to say he brought the poison a hundred years before another person whose name I forget brought the food. Suicide. Lies. All our habits. Why, look at our public life!

(Midnight chimes from distant steeples.)

THE CHIMES: Turn again, Leopold! Lord mayor of Dublin!

BLOOM: (In alderman’s gown and chain.) Electors of Arran Quay, Inns Quay, Rotunda, Mountjoy and North Dock, better run a tramline, I say, from the cattlemarket to the river. That’s the music of the future. That’s my programme. Cui bono? But our bucaneering Vanderdeckens in their phantom ship of finance...

AN ELECTOR: Three times three for our future chief magistrate!

(The aurora borealis of the torchlight procession leaps.)

THE TORCHBEARERS: Hooray!

(Several wellknown burgesses, city magnates and freemen of the city shake hands with Bloom and congratulate him. Timothy Harrington, late thrice Lord Mayor of Dublin, imposing in mayoral scarlet, gold chain and white silk tie, confers with councillor Lorcan Sherlock, locum tenens. They nod vigorously in agreement.)

LATE LORD MAYOR HARRINGTON: (In scarlet robe with mace, gold mayoral chain and large white silk scarf.) That alderman sir Leo Bloom’s speech be printed at the expense of the ratepayers. That the house in which he was born be ornamented with a commemorative tablet and that the thoroughfare hitherto known as Cow Parlour off Cork street be henceforth designated Boulevard Bloom.

COUNCILLOR LORCAN SHERLOCK: Carried unanimously.

BLOOM: (Impassionedly.) These flying Dutchmen or lying Dutchmen as they recline in their upholstered poop, casting dice, what reck they? Machines is their cry, their chimera, their panacea. Laboursaving apparatuses, supplanters, bugbears, manufactured monsters for mutual murder, hideous hobgoblins produced by a horde of capitalistic lusts upon our prostituted labour. The poor man starves while they are grassing their royal mountain stags or shooting peasants and phartridges in their purblind pomp of pelf and power. But their reign is rover for rever and ever and ev...

(Prolonged applause. Venetian masts, maypoles and festal arches spring up. A streamer bearing the legends Cead Mile Failte and Mah Ttob Melek Israel spans the street. All the windows are thronged with sightseers, chiefly ladies. Along the route the regiments of the Royal Dublin Fusiliers, the King’s own Scottish Borderers, the Cameron Highlanders and the Welsh Fusiliers, standing to attention, keep back the crowd. Boys from High school are perched on the lampposts, telegraph poles, windowsills, cornices, gutters, chimneypots, railings, rainspouts, whistling and cheering. The pillar of the cloud appears. A fife and drum band is heard in the distance playing the Kol Nidre. The beaters approach with imperial eagles hoisted, trailing banners and waving oriental palms. The chryselephantine papal standard rises high, surrounded by pennons of the civic flag. The van of the procession appears headed by John Howard Parnell, city marshal, in a chessboard tabard, the Athlone Poursuivant and Ulster King of Arms. They are followed by the Right Honourable Joseph Hutchinson, lord mayor of Dublin, his lordship the lord mayor of Cork, their worships the mayors of Limerick, Galway, Sligo and Waterford, twentyeight Irish representative peers, sirdars, grandees and maharajahs bearing the cloth of estate, the Dublin Metropolitan Fire Brigade, the chapter of the saints of finance in their plutocratic order of precedence, the bishop of Down and Connor, His Eminence Michael cardinal Logue, archbishop of Armagh, primate of all Ireland, His Grace, the most reverend Dr William Alexander, archbishop of Armagh, primate of all Ireland, the chief rabbi, the presbyterian moderator, the heads of the baptist, anabaptist, methodist and Moravian chapels and the honorary secretary of the society of friends. After them march the guilds and trades and trainbands with flying colours: coopers, bird fanciers, millwrights, newspaper canvassers, law scriveners, masseurs, vintners, trussmakers, chimneysweeps, lard refiners, tabinet and poplin weavers, farriers, Italian warehousemen, church decorators, bootjack manufacturers, undertakers, silk mercers, lapidaries, salesmasters, corkcutters, assessors of fire losses, dyers and cleaners, export bottlers, fellmongers, ticketwriters, heraldic seal engravers, horse repository hands, bullion brokers, cricket and archery outfitters, riddlemakers, egg and potato factors, hosiers and glovers, plumbing contractors. After them march gentlemen of the bedchamber, Black Rod, Deputy Garter, Gold Stick, the master of horse, the lord great chamberlain, the earl marshal, the high constable carrying the sword of state, saint Stephen’s iron crown, the chalice and bible. Four buglers on foot blow a sennet. Beefeaters reply, winding clarions of welcome. Under an arch of triumph Bloom appears, bareheaded, in a crimson velvet mantle trimmed with ermine, bearing Saint Edward’s staff, the orb and sceptre with the dove, the curtana. He is seated on a milkwhite horse with long flowing crimson tail, richly caparisoned, with golden headstall. Wild excitement. The ladies from their balconies throw down rosepetals. The air is perfumed with essences. The men cheer. Bloom’s boys run amid the bystanders with branches of hawthorn and wrenbushes.)

BLOOM’S BOYS:

The wren, the wren,
The king of all birds,
Saint Stephen’s his day
Was caught in the furze.

A BLACKSMITH: (Murmurs.) For the honour of God! And is that Bloom? He scarcely looks thirtyone.

A PAVIOR AND FLAGGER: That’s the famous Bloom now, the world’s greatest reformer. Hats off!

(All uncover their heads. Women whisper eagerly.)

A MILLIONAIRESS: (Richly.) Isn’t he simply wonderful?

A NOBLEWOMAN: (Nobly.) All that man has seen!

A FEMINIST: (Masculinely.) And done!

A BELLHANGER: A classic face! He has the forehead of a thinker.

(Bloom’s weather. A sunburst appears in the northwest.)

THE BISHOP OF DOWN AND CONNOR: I here present your undoubted emperor-president and king-chairman, the most serene and potent and very puissant ruler of this realm. God save Leopold the First!

ALL: God save Leopold the First!

BLOOM: (In dalmatic and purple mantle, to the bishop of Down and Connor, with dignity.) Thanks, somewhat eminent sir.

WILLIAM, ARCHBISHOP OF ARMAGH: (In purple stock and shovel hat.) Will you to your power cause law and mercy to be executed in all your judgments in Ireland and territories thereunto belonging?

BLOOM: (Placing his right hand on his testicles, swears.) So may the Creator deal with me. All this I promise to do.

MICHAEL, ARCHBISHOP OF ARMAGH: (Pours a cruse of hairoil over Bloom’s head.) Gaudium magnum annuntio vobis. Habemus carneficem. Leopold, Patrick, Andrew, David, George, be thou anointed!

(Bloom assumes a mantle of cloth of gold and puts on a ruby ring. He ascends and stands on the stone of destiny. The representative peers put on at the same time their twentyeight crowns. Joybells ring in Christ church, Saint Patrick’s, George’s and gay Malahide. Mirus bazaar fireworks go up from all sides with symbolical phallopyrotechnic designs. The peers do homage, one by one, approaching and genuflecting.)

THE PEERS: I do become your liege man of life and limb to earthly worship.

(Bloom holds up his right hand on which sparkles the Koh-i-Noor diamond. His palfrey neighs. Immediate silence. Wireless intercontinental and interplanetary transmitters are set for reception of message.)

BLOOM: My subjects! We hereby nominate our faithful charger Copula Felix hereditary Grand Vizier and announce that we have this day repudiated our former spouse and have bestowed our royal hand upon the princess Selene, the splendour of night.

(The former morganatic spouse of Bloom is hastily removed in the Black Maria. The princess Selene, in moonblue robes, a silver crescent on her head, descends from a Sedan chair, borne by two giants. An outburst of cheering.)

JOHN HOWARD PARNELL: (Raises the royal standard.) Illustrious Bloom! Successor to my famous brother!

BLOOM: (Embraces John Howard Parnell.) We thank you from our heart, John, for this right royal welcome to green Erin, the promised land of our common ancestors.

(The freedom of the city is presented to him embodied in a charter. The keys of Dublin, crossed on a crimson cushion, are given to him. He shows all that he is wearing green socks.)

TOM KERNAN: You deserve it, your honour.

BLOOM: On this day twenty years ago we overcame the hereditary enemy at Ladysmith. Our howitzers and camel swivel guns played on his lines with telling effect. Half a league onward! They charge! All is lost now! Do we yield? No! We drive them headlong! Lo! We charge! Deploying to the left our light horse swept across the heights of Plevna and, uttering their warcry Bonafide Sabaoth, sabred the Saracen gunners to a man.

THE CHAPEL OF FREEMAN TYPESETTERS: Hear! Hear!

JOHN WYSE NOLAN: There’s the man that got away James Stephens.

A BLUECOAT SCHOOLBOY: Bravo!

AN OLD RESIDENT: You’re a credit to your country, sir, that’s what you are.

AN APPLEWOMAN: He’s a man like Ireland wants.

BLOOM: My beloved subjects, a new era is about to dawn. I, Bloom, tell you verily it is even now at hand. Yea, on the word of a Bloom, ye shall ere long enter into the golden city which is to be, the new Bloomusalem in the Nova Hibernia of the future.

(Thirtytwo workmen, wearing rosettes, from all the counties of Ireland, under the guidance of Derwan the builder, construct the new Bloomusalem. It is a colossal edifice with crystal roof, built in the shape of a huge pork kidney, containing forty thousand rooms. In the course of its extension several buildings and monuments are demolished. Government offices are temporarily transferred to railway sheds. Numerous houses are razed to the ground. The inhabitants are lodged in barrels and boxes, all marked in red with the letters: L. B. Several paupers fall from a ladder. A part of the walls of Dublin, crowded with loyal sightseers, collapses.)

THE SIGHTSEERS: (Dying.) Morituri te salutant. (They die.)

(A man in a brown macintosh springs up through a trapdoor. He points an elongated finger at Bloom.)

THE MAN IN THE MACINTOSH: Don’t you believe a word he says. That man is Leopold M’Intosh, the notorious fireraiser. His real name is Higgins.

BLOOM: Shoot him! Dog of a christian! So much for M’Intosh!

(A cannonshot. The man in the macintosh disappears. Bloom with his sceptre strikes down poppies. The instantaneous deaths of many powerful enemies, graziers, members of parliament, members of standing committees, are reported. Bloom’s bodyguard distribute Maundy money, commemoration medals, loaves and fishes, temperance badges, expensive Henry Clay cigars, free cowbones for soup, rubber preservatives in sealed envelopes tied with gold thread, butter scotch, pineapple rock, billets doux in the form of cocked hats, readymade suits, porringers of toad in the hole, bottles of Jeyes’ Fluid, purchase stamps, 40 days’ indulgences, spurious coins, dairyfed pork sausages, theatre passes, season tickets available for all tramlines, coupons of the royal and privileged Hungarian lottery, penny dinner counters, cheap reprints of the World’s Twelve Worst Books: Froggy And Fritz (politic), Care of the Baby (infantilic), 50 Meals for 7/6 (culinic), Was Jesus a Sun Myth? (historic), Expel that Pain (medic), Infant’s Compendium of the Universe (cosmic), Let’s All Chortle (hilaric), Canvasser’s Vade Mecum (journalic), Loveletters of Mother Assistant (erotic), Who’s Who in Space (astric), Songs that Reached Our Heart (melodic), Pennywise’s Way to Wealth (parsimonic). A general rush and scramble. Women press forward to touch the hem of Bloom’s robe. The lady Gwendolen Dubedat bursts through the throng, leaps on his horse and kisses him on both cheeks amid great acclamation. A magnesium flashlight photograph is taken. Babes and sucklings are held up.)

THE WOMEN: Little father! Little father!

THE BABES AND SUCKLINGS:

Clap clap hands till Poldy comes home,
Cakes in his pocket for Leo alone.

(Bloom, bending down, pokes Baby Boardman gently in the stomach.)

BABY BOARDMAN: (Hiccups, curdled milk flowing from his mouth.) Hajajaja.

BLOOM: (Shaking hands with a blind stripling.) My more than Brother! (Placing his arms round the shoulders of an old couple.) Dear old friends! (He plays pussy fourcorners with ragged boys and girls.) Peep! Bopeep! (He wheels twins in a perambulator.) Ticktacktwo wouldyousetashoe? (He performs juggler’s tricks, draws red, orange, yellow, green, blue, indigo and violet silk handkerchiefs from his mouth.) Roygbiv. 32 feet per second. (He consoles a widow.) Absence makes the heart grow younger. (He dances the Highland fling with grotesque antics.) Leg it, ye devils! (He kisses the bedsores of a palsied veteran.) Honourable wounds! (He trips up a fat policeman.) U. p: up. U. p: up. (He whispers in the ear of a blushing waitress and laughs kindly.) Ah, naughty, naughty! (He eats a raw turnip offered him by Maurice Butterly, farmer.) Fine! Splendid! (He refuses to accept three shillings offered him by Joseph Hynes, journalist.) My dear fellow, not at all! (He gives his coat to a beggar.) Please accept. (He takes part in a stomach race with elderly male and female cripples.) Come on, boys! Wriggle it, girls!

THE CITIZEN: (Choked with emotion, brushes aside a tear in his emerald muffler.) May the good God bless him!

(The rams’ horns sound for silence. The standard of Zion is hoisted.)

BLOOM: (Uncloaks impressively, revealing obesity, unrolls a paper and reads solemnly.) Aleph Beth Ghimel Daleth Hagadah Tephilim Kosher Yom Kippur Hanukah Roschaschana Beni Brith Bar Mitzvah Mazzoth Askenazim Meshuggah Talith.

(An official translation is read by Jimmy Henry, assistant town clerk.)

JIMMY HENRY: The Court of Conscience is now open. His Most Catholic Majesty will now administer open air justice. Free medical and legal advice, solution of doubles and other problems. All cordially invited. Given at this our loyal city of Dublin in the year 1 of the Paradisiacal Era.

PADDY LEONARD: What am I to do about my rates and taxes?

BLOOM: Pay them, my friend.

PADDY LEONARD: Thank you.

NOSEY FLYNN: Can I raise a mortgage on my fire insurance?

BLOOM: (Obdurately.) Sirs, take notice that by the law of torts you are bound over in your own recognisances for six months in the sum of five pounds.

J. J. O’MOLLOY: A Daniel did I say? Nay! A Peter O’Brien!

NOSEY FLYNN: Where do I draw the five pounds?

PISSER BURKE: For bladder trouble?

BLOOM:

Acid. nit. hydrochlor. dil., 20 minims
Tinct. nux vom., 5 minims
Extr. taraxel. lig., 30 minims.
Aq. dis. ter in die.

CHRIS CALLINAN: What is the parallax of the subsolar ecliptic of Aldebaran?

BLOOM: Pleased to hear from you, Chris. K. 11.

JOE HYNES: Why aren’t you in uniform?

BLOOM: When my progenitor of sainted memory wore the uniform of the Austrian despot in a dank prison where was yours?

BEN DOLLARD: Pansies?

BLOOM: Embellish (beautify) suburban gardens.

BEN DOLLARD: When twins arrive?

BLOOM: Father (pater, dad) starts thinking.

LARRY O’ROURKE: An eightday licence for my new premises. You remember me, sir Leo, when you were in number seven. I’m sending around a dozen of stout for the missus.

BLOOM: (Coldly.) You have the advantage of me. Lady Bloom accepts no presents.

CROFTON: This is indeed a festivity.

BLOOM: (Solemnly.) You call it a festivity. I call it a sacrament.

ALEXANDER KEYES: When will we have our own house of keys?

BLOOM: I stand for the reform of municipal morals and the plain ten commandments. New worlds for old. Union of all, jew, moslem and gentile. Three acres and a cow for all children of nature. Saloon motor hearses. Compulsory manual labour for all. All parks open to the public day and night. Electric dishscrubbers. Tuberculosis, lunacy, war and mendicancy must now cease. General amnesty, weekly carnival with masked licence, bonuses for all, esperanto the universal language with universal brotherhood. No more patriotism of barspongers and dropsical impostors. Free money, free rent, free love and a free lay church in a free lay state.

O’MADDEN BURKE: Free fox in a free henroost.

DAVY BYRNE: (Yawning.) Iiiiiiiiiaaaaaaach!

BLOOM: Mixed races and mixed marriage.

LENEHAN: What about mixed bathing?

(Bloom explains to those near him his schemes for social regeneration. All agree with him. The keeper of the Kildare street museum appears, dragging a lorry on which are the shaking statues of several naked goddesses, Venus Callipyge, Venus Pandemos, Venus Metempsychosis, and plaster figures, also naked, representing the new nine muses, Commerce, Operatic Music, Amor, Publicity, Manufacture, Liberty of Speech, Plural Voting, Gastronomy, Private Hygiene, Seaside Concert Entertainments, Painless Obstetrics and Astronomy for the People.)

FATHER FARLEY: He is an episcopalian, an agnostic, an anythingarian seeking to overthrow our holy faith.

MRS RIORDAN: (Tears up her will.) I’m disappointed in you! You bad man!

MOTHER GROGAN: (Removes her boot to throw it at Bloom.) You beast! You abominable person!

NOSEY FLYNN: Give us a tune, Bloom. One of the old sweet songs.

BLOOM: (With rollicking humour.)

I vowed that I never would leave her,
She turned out a cruel deceiver.
With my tooraloom tooraloom tooraloom tooraloom.

HOPPY HOLOHAN: Good old Bloom! There’s nobody like him after all.

PADDY LEONARD: Stage Irishman!

BLOOM: What railway opera is like a tramline in Gibraltar? The Rows of Casteele.

(Laughter.)

LENEHAN: Plagiarist! Down with Bloom!

THE VEILED SIBYL: (Enthusiastically.) I’m a Bloomite and I glory in it. I believe in him in spite of all. I’d give my life for him, the funniest man on earth.

BLOOM: (Winks at the bystanders.) I bet she’s a bonny lassie.

THEODORE PUREFOY: (In fishingcap and oilskin jacket.) He employs a mechanical device to frustrate the sacred ends of nature.

THE VEILED SIBYL: (Stabs herself.) My hero god! (She dies.)

(Many most attractive and enthusiastic women also commit suicide by stabbing, drowning, drinking prussic acid, aconite, arsenic, opening their veins, refusing food, casting themselves under steamrollers, from the top of Nelson’s Pillar, into the great vat of Guinness’s brewery, asphyxiating themselves by placing their heads in gasovens, hanging themselves in stylish garters, leaping from windows of different storeys.)

ALEXANDER J DOWIE: (Violently.) Fellowchristians and antiBloomites, the man called Bloom is from the roots of hell, a disgrace to christian men. A fiendish libertine from his earliest years this stinking goat of Mendes gave precocious signs of infantile debauchery, recalling the cities of the plain, with a dissolute granddam. This vile hypocrite, bronzed with infamy, is the white bull mentioned in the Apocalypse. A worshipper of the Scarlet Woman, intrigue is the very breath of his nostrils. The stake faggots and the caldron of boiling oil are for him. Caliban!

THE MOB: Lynch him! Roast him! He’s as bad as Parnell was. Mr Fox!

(Mother Grogan throws her boot at Bloom. Several shopkeepers from upper and lower Dorset street throw objects of little or no commercial value, hambones, condensed milk tins, unsaleable cabbage, stale bread, sheep’s tails, odd pieces of fat.)

BLOOM: (Excitedly.) This is midsummer madness, some ghastly joke again. By heaven, I am guiltless as the unsunned snow! It was my brother Henry. He is my double. He lives in number 2 Dolphin’s Barn. Slander, the viper, has wrongfully accused me. Fellowcountrymen, sgenl inn ban bata coisde gan capall. I call on my old friend, Dr Malachi Mulligan, sex specialist, to give medical testimony on my behalf.

DR MULLIGAN: (In motor jerkin, green motorgoggles on his brow.) Dr Bloom is bisexually abnormal. He has recently escaped from Dr Eustace’s private asylum for demented gentlemen. Born out of bedlock hereditary epilepsy is present, the consequence of unbridled lust. Traces of elephantiasis have been discovered among his ascendants. There are marked symptoms of chronic exhibitionism. Ambidexterity is also latent. He is prematurely bald from selfabuse, perversely idealistic in consequence, a reformed rake, and has metal teeth. In consequence of a family complex he has temporarily lost his memory and I believe him to be more sinned against than sinning. I have made a pervaginal examination and, after application of the acid test to 5427 anal, axillary, pectoral and pubic hairs, I declare him to be virgo intacta.

(Bloom holds his high grade hat over his genital organs.)

DR MADDEN: Hypsospadia is also marked. In the interest of coming generations I suggest that the parts affected should be preserved in spirits of wine in the national teratological museum.

DR CROTTHERS: I have examined the patient’s urine. It is albuminoid. Salivation is insufficient, the patellar reflex intermittent.

DR PUNCH COSTELLO: The fetor judaicus is most perceptible.

DR DIXON: (Reads a bill of health.) Professor Bloom is a finished example of the new womanly man. His moral nature is simple and lovable. Many have found him a dear man, a dear person. He is a rather quaint fellow on the whole, coy though not feebleminded in the medical sense. He has written a really beautiful letter, a poem in itself, to the court missionary of the Reformed Priests’ Protection Society which clears up everything. He is practically a total abstainer and I can affirm that he sleeps on a straw litter and eats the most Spartan food, cold dried grocer’s peas. He wears a hairshirt of pure Irish manufacture winter and summer and scourges himself every Saturday. He was, I understand, at one time a firstclass misdemeanant in Glencree reformatory. Another report states that he was a very posthumous child. I appeal for clemency in the name of the most sacred word our vocal organs have ever been called upon to speak. He is about to have a baby.

(General commotion and compassion. Women faint. A wealthy American makes a street collection for Bloom. Gold and silver coins, blank cheques, banknotes, jewels, treasury bonds, maturing bills of exchange, I. O. U’s, wedding rings, watchchains, lockets, necklaces and bracelets are rapidly collected.)

BLOOM: O, I so want to be a mother.

MRS THORNTON: (In nursetender’s gown.) Embrace me tight, dear. You’ll be soon over it. Tight, dear.

(Bloom embraces her tightly and bears eight male yellow and white children. They appear on a redcarpeted staircase adorned with expensive plants. All the octuplets are handsome, with valuable metallic faces, wellmade, respectably dressed and wellconducted, speaking five modern languages fluently and interested in various arts and sciences. Each has his name printed in legible letters on his shirtfront: Nasodoro, Goldfinger, Chrysostomos, Maindorée, Silversmile, Silberselber, Vifargent, Panargyros. They are immediately appointed to positions of high public trust in several different countries as managing directors of banks, traffic managers of railways, chairmen of limited liability companies, vicechairmen of hotel syndicates.)

A VOICE: Bloom, are you the Messiah ben Joseph or ben David?

BLOOM: (Darkly.) You have said it.

BROTHER BUZZ: Then perform a miracle like Father Charles.

BANTAM LYONS: Prophesy who will win the Saint Leger.

(Bloom walks on a net, covers his left eye with his left ear, passes through several walls, climbs Nelson’s Pillar, hangs from the top ledge by his eyelids, eats twelve dozen oysters (shells included), heals several sufferers from king’s evil, contracts his face so as to resemble many historical personages, Lord Beaconsfield, Lord Byron, Wat Tyler, Moses of Egypt, Moses Maimonides, Moses Mendelssohn, Henry Irving, Rip van Winkle, Kossuth, Jean Jacques Rousseau, Baron Leopold Rothschild, Robinson Crusoe, Sherlock Holmes, Pasteur, turns each foot simultaneously in different directions, bids the tide turn back, eclipses the sun by extending his little finger.)

BRINI, PAPAL NUNCIO: (In papal zouave’s uniform, steel cuirasses as breastplate, armplates, thighplates, legplates, large profane moustaches and brown paper mitre.) Leopoldi autem generatio. Moses begat Noah and Noah begat Eunuch and Eunuch begat O’Halloran and O’Halloran begat Guggenheim and Guggenheim begat Agendath and Agendath begat Netaim and Netaim begat Le Hirsch and Le Hirsch begat Jesurum and Jesurum begat MacKay and MacKay begat Ostrolopsky and Ostrolopsky begat Smerdoz and Smerdoz begat Weiss and Weiss begat Schwarz and Schwarz begat Adrianopoli and Adrianopoli begat Aranjuez and Aranjuez begat Lewy Lawson and Lewy Lawson begat Ichabudonosor and Ichabudonosor begat O’Donnell Magnus and O’Donnell Magnus begat Christbaum and Christbaum begat ben Maimun and ben Maimun begat Dusty Rhodes and Dusty Rhodes begat Benamor and Benamor begat Jones-Smith and Jones-Smith begat Savorgnanovich and Savorgnanovich begat Jasperstone and Jasperstone begat Vingtetunieme and Vingtetunieme begat Szombathely and Szombathely begat Virag and Virag begat Bloom et vocabitur nomen eius Emmanuel.

A DEADHAND: (Writes on the wall.) Bloom is a cod.

CRAB: (In bushranger’s kit.) What did you do in the cattlecreep behind Kilbarrack?

A FEMALE INFANT: (Shakes a rattle.) And under Ballybough bridge?

A HOLLYBUSH: And in the devil’s glen?

BLOOM: (Blushes furiously all over from frons to nates, three tears falling from his left eye.) Spare my past.

THE IRISH EVICTED TENANTS: (In bodycoats, kneebreeches, with Donnybrook fair shillelaghs.) Sjambok him!

(Bloom with asses’ ears seats himself in the pillory with crossed arms, his feet protruding. He whistles Don Giovanni, a cenar teco. Artane orphans, joining hands, caper round him. Girls of the Prison Gate Mission, joining hands, caper round in the opposite direction.)

THE ARTANE ORPHANS:

You hig, you hog, you dirty dog!
You think the ladies love you!

THE PRISON GATE GIRLS:

If you see Kay
Tell him he may
See you in tea
Tell him from me.

HORNBLOWER: (In ephod and huntingcap, announces.) And he shall carry the sins of the people to Azazel, the spirit which is in the wilderness, and to Lilith, the nighthag. And they shall stone him and defile him, yea, all from Agendath Netaim and from Mizraim, the land of Ham.

(All the people cast soft pantomime stones at Bloom. Many bonafide travellers and ownerless dogs come near him and defile him. Mastiansky and Citron approach in gaberdines, wearing long earlocks. They wag their beards at Bloom.)

MASTIANSKY AND CITRON: Belial! Laemlein of Istria, the false Messiah! Abulafia! Recant!

(George R Mesias, Bloom’s tailor, appears, a tailor’s goose under his arm, presenting a bill.)

MESIAS: To alteration one pair trousers eleven shillings.

BLOOM: (Rubs his hands cheerfully.) Just like old times. Poor Bloom!

(Reuben J Dodd, blackbearded Iscariot, bad shepherd, bearing on his shoulders the drowned corpse of his son, approaches the pillory.)

REUBEN J: (Whispers hoarsely.) The squeak is out. A split is gone for the flatties. Nip the first rattler.

THE FIRE BRIGADE: Pflaap!

BROTHER BUZZ: (Invests Bloom in a yellow habit with embroidery of painted flames and high pointed hat. He places a bag of gunpowder round his neck and hands him over to the civil power, saying.) Forgive him his trespasses.

(Lieutenant Myers of the Dublin Fire Brigade by general request sets fire to Bloom. Lamentations.)

THE CITIZEN: Thank heaven!

BLOOM: (In a seamless garment marked I. H. S. stands upright amid phoenix flames.) Weep not for me, O daughters of Erin.

(He exhibits to Dublin reporters traces of burning. The daughters of Erin, in black garments, with large prayerbooks and long lighted candles in their hands, kneel down and pray.)

THE DAUGHTERS OF ERIN:

Kidney of Bloom, pray for us
Flower of the Bath, pray for us
Mentor of Menton, pray for us
Canvasser for the Freeman, pray for us
Charitable Mason, pray for us
Wandering Soap, pray for us
Sweets of Sin, pray for us
Music without Words, pray for us
Reprover of the Citizen, pray for us
Friend of all Frillies, pray for us
Midwife Most Merciful, pray for us
Potato Preservative against Plague and Pestilence, pray for us.

(A choir of six hundred voices, conducted by Vincent O’Brien, sings the chorus from Handel’s Messiah Alleluia for the Lord God Omnipotent reigneth, accompanied on the organ by Joseph Glynn. Bloom becomes mute, shrunken, carbonised.)

ZOE: Talk away till you’re black in the face.

BLOOM: (In caubeen with clay pipe stuck in the band, dusty brogues, an emigrant’s red handkerchief bundle in his hand, leading a black bogoak pig by a sugaun, with a smile in his eye.) Let me be going now, woman of the house, for by all the goats in Connemara I’m after having the father and mother of a bating. (With a tear in his eye.) All insanity. Patriotism, sorrow for the dead, music, future of the race. To be or not to be. Life’s dream is o’er. End it peacefully. They can live on. (He gazes far away mournfully.) I am ruined. A few pastilles of aconite. The blinds drawn. A letter. Then lie back to rest. (He breathes softly.) No more. I have lived. Fare. Farewell.

ZOE: (Stiffly, her finger in her neckfillet.) Honest? Till the next time. (She sneers.) Suppose you got up the wrong side of the bed or came too quick with your best girl. O, I can read your thoughts!

BLOOM: (Bitterly.) Man and woman, love, what is it? A cork and bottle. I’m sick of it. Let everything rip.

ZOE: (In sudden sulks.) I hate a rotter that’s insincere. Give a bleeding whore a chance.

BLOOM: (Repentantly.) I am very disagreeable. You are a necessary evil. Where are you from? London?

ZOE: (Glibly.) Hog’s Norton where the pigs plays the organs. I’m Yorkshire born. (She holds his hand which is feeling for her nipple.) I say, Tommy Tittlemouse. Stop that and begin worse. Have you cash for a short time? Ten shillings?

BLOOM: (Smiles, nods slowly.) More, houri, more.

ZOE: And more’s mother? (She pats him offhandedly with velvet paws.) Are you coming into the musicroom to see our new pianola? Come and I’ll peel off.

BLOOM: (Feeling his occiput dubiously with the unparalleled embarrassment of a harassed pedlar gauging the symmetry of her peeled pears.) Somebody would be dreadfully jealous if she knew. The greeneyed monster. (Earnestly.) You know how difficult it is. I needn’t tell you.

ZOE: (Flattered.) What the eye can’t see the heart can’t grieve for. (She pats him.) Come.

BLOOM: Laughing witch! The hand that rocks the cradle.

ZOE: Babby!

BLOOM: (In babylinen and pelisse, bigheaded, with a caul of dark hair, fixes big eyes on her fluid slip and counts its bronze buckles with a chubby finger, his moist tongue lolling and lisping.) One two tlee: tlee tlwo tlone.

THE BUCKLES: Love me. Love me not. Love me.

ZOE: Silent means consent. (With little parted talons she captures his hand, her forefinger giving to his palm the passtouch of secret monitor, luring him to doom.) Hot hands cold gizzard.

(He hesitates amid scents, music, temptations. She leads him towards the steps, drawing him by the odour of her armpits, the vice of her painted eyes, the rustle of her slip in whose sinuous folds lurks the lion reek of all the male brutes that have possessed her.)

THE MALE BRUTES: (Exhaling sulphur of rut and dung and ramping in their loosebox, faintly roaring, their drugged heads swaying to and fro.) Good!

(Zoe and Bloom reach the doorway where two sister whores are seated. They examine him curiously from under their pencilled brows and smile to his hasty bow. He trips awkwardly.)

ZOE: (Her lucky hand instantly saving him.) Hoopsa! Don’t fall upstairs.

BLOOM: The just man falls seven times. (He stands aside at the threshold.) After you is good manners.

ZOE: Ladies first, gentlemen after.

(She crosses the threshold. He hesitates. She turns and, holding out her hands, draws him over. He hops. On the antlered rack of the hall hang a man’s hat and waterproof. Bloom uncovers himself but, seeing them, frowns, then smiles, preoccupied. A door on the return landing is flung open. A man in purple shirt and grey trousers, brownsocked, passes with an ape’s gait, his bald head and goatee beard upheld, hugging a full waterjugjar, his twotailed black braces dangling at heels. Averting his face quickly Bloom bends to examine on the halltable the spaniel eyes of a running fox: then, his lifted head sniffing, follows Zoe into the musicroom. A shade of mauve tissuepaper dims the light of the chandelier. Round and round a moth flies, colliding, escaping. The floor is covered with an oilcloth mosaic of jade and azure and cinnabar rhomboids. Footmarks are stamped over it in all senses, heel to heel, heel to hollow, toe to toe, feet locked, a morris of shuffling feet without body phantoms, all in a scrimmage higgledypiggledy. The walls are tapestried with a paper of yewfronds and clear glades. In the grate is spread a screen of peacock feathers. Lynch squats crosslegged on the hearthrug of matted hair, his cap back to the front. With a wand he beats time slowly. Kitty Ricketts, a bony pallid whore in navy costume, doeskin gloves rolled back from a coral wristlet, a chain purse in her hand, sits perched on the edge of the table swinging her leg and glancing at herself in the gilt mirror over the mantelpiece. A tag of her corsetlace hangs slightly below her jacket. Lynch indicates mockingly the couple at the piano.)

KITTY: (Coughs behind her hand.) She’s a bit imbecillic. (She signs with a waggling forefinger.) Blemblem. (Lynch lifts up her skirt and white petticoat with the wand. She settles them down quickly.) Respect yourself. (She hiccups, then bends quickly her sailor hat under which her hair glows, red with henna.) O, excuse!

ZOE: More limelight, Charley. (She goes to the chandelier and turns the gas full cock.)

KITTY: (Peers at the gasjet.) What ails it tonight?

LYNCH: (Deeply.) Enter a ghost and hobgoblins.

ZOE: Clap on the back for Zoe.

(The wand in Lynch’s hand flashes: a brass poker. Stephen stands at the pianola on which sprawl his hat and ashplant. With two fingers he repeats once more the series of empty fifths. Florry Talbot, a blond feeble goosefat whore in a tatterdemalion gown of mildewed strawberry, lolls spreadeagle in the sofacorner, her limp forearm pendent over the bolster, listening. A heavy stye droops over her sleepy eyelid.)

KITTY: (Hiccups again with a kick of her horsed foot.) O, excuse!

ZOE: (Promptly.) Your boy’s thinking of you. Tie a knot on your shift.

(Kitty Ricketts bends her head. Her boa uncoils, slides, glides over her shoulder, back, arm, chair to the ground. Lynch lifts the curled catterpillar on his wand. She snakes her neck, nestling. Stephen glances behind at the squatted figure with its cap back to the front.)

STEPHEN: As a matter of fact it is of no importance whether Benedetto Marcello found it or made it. The rite is the poet’s rest. It may be an old hymn to Demeter or also illustrate Cœla enarrant gloriam Domini. It is susceptible of nodes or modes as far apart as hyperphrygian and mixolydian and of texts so divergent as priests haihooping round David’s that is Circe’s or what am I saying Ceres’ altar and David’s tip from the stable to his chief bassoonist about the alrightness of his almightiness. Mais nom de nom, that is another pair of trousers. Jetez la gourme. Faut que jeunesse se passe. (He stops, points at Lynch’s cap, smiles, laughs.) Which side is your knowledge bump?

THE CAP: (With saturnine spleen.) Bah! It is because it is. Woman’s reason. Jewgreek is greekjew. Extremes meet. Death is the highest form of life. Bah!

STEPHEN: You remember fairly accurately all my errors, boasts, mistakes. How long shall I continue to close my eyes to disloyalty? Whetstone!

THE CAP: Bah!

STEPHEN: Here’s another for you. (He frowns.) The reason is because the fundamental and the dominant are separated by the greatest possible interval which...

THE CAP: Which? Finish. You can’t.

STEPHEN: (With an effort.) Interval which. Is the greatest possible ellipse. Consistent with. The ultimate return. The octave. Which.

THE CAP: Which?

(Outside the gramophone begins to blare The Holy City.)

STEPHEN: (Abruptly.) What went forth to the ends of the world to traverse not itself, God, the sun, Shakespeare, a commercial traveller, having itself traversed in reality itself becomes that self. Wait a moment. Wait a second. Damn that fellow’s noise in the street. Self which it itself was ineluctably preconditioned to become. Ecco!

LYNCH: (With a mocking whinny of laughter grins at Bloom and Zoe Higgins.) What a learned speech, eh?

ZOE: (Briskly.) God help your head, he knows more than you have forgotten.

(With obese stupidity Florry Talbot regards Stephen.)

FLORRY: They say the last day is coming this summer.

KITTY: No!

ZOE: (Explodes in laughter.) Great unjust God!

FLORRY: (Offended.) Well, it was in the papers about Antichrist. O, my foot’s tickling.

(Ragged barefoot newsboys, jogging a wagtail kite, patter past, yelling.)

THE NEWSBOYS: Stop press edition. Result of the rockinghorse races. Sea serpent in the royal canal. Safe arrival of Antichrist.

(Stephen turns and sees Bloom.)

STEPHEN: A time, times and half a time.

(Reuben J Antichrist, wandering jew, a clutching hand open on his spine, stumps forward. Across his loins is slung a pilgrim’s wallet from which protrude promissory notes and dishonoured bills. Aloft over his shoulder he bears a long boatpole from the hook of which the sodden huddled mass of his only son, saved from Liffey waters, hangs from the slack of its breeches. A hobgoblin in the image of Punch Costello, hipshot, crookbacked, hydrocephalic, prognathic with receding forehead and Ally Sloper nose, tumbles in somersaults through the gathering darkness.)

ALL: What?

THE HOBGOBLIN: (His jaws chattering, capers to and fro, goggling his eyes, squeaking, kangaroohopping with outstretched clutching arms, then all at once thrusts his lipless face through the fork of his thighs.) Il vient! C’est moi! L’homme qui rit! L’homme primigène! (He whirls round and round with dervish howls.) Sieurs et dames, faites vos jeux! (He crouches juggling. Tiny roulette planets fly from his hands.) Les jeux sont faits! (The planets rush together, uttering crepitant cracks.) Rien va plus! (The planets, buoyant balloons, sail swollen up and away. He springs off into vacuum.)

FLORRY: (Sinking into torpor, crossing herself secretly.) The end of the world!

(A female tepid effluvium leaks out from her. Nebulous obscurity occupies space. Through the drifting fog without the gramophone blares over coughs and feetshuffling.)

THE GRAMOPHONE:

Jerusalem!
Open your gates and sing
Hosanna...

(A rocket rushes up the sky and bursts. A white star falls from it, proclaiming the consummation of all things and second coming of Elijah. Along an infinite invisible tightrope taut from zenith to nadir the End of the World, a twoheaded octopus in gillie’s kilts, busby and tartan filibegs, whirls through the murk, head over heels, in the form of the Three Legs of Man.)

THE END OF THE WORLD: (With a Scotch accent.) Wha’ll dance the keel row, the keel row, the keel row?

(Over the possing drift and choking breathcoughs, Elijah’s voice, harsh as a corncrake’s, jars on high. Perspiring in a loose lawn surplice with funnel sleeves he is seen, vergerfaced, above a rostrum about which the banner of old glory is draped. He thumps the parapet.)

ELIJAH: No yapping, if you please, in this booth. Jake Crane, Creole Sue, Dove Campbell, Abe Kirschner, do your coughing with your mouths shut. Say, I am operating all this trunk line. Boys, do it now. God’s time is 12.25. Tell mother you’ll be there. Rush your order and you play a slick ace. Join on right here. Book through to eternity junction, the nonstop run. Just one word more. Are you a god or a doggone clod? If the second advent came to Coney Island are we ready? Florry Christ, Stephen Christ, Zoe Christ, Bloom Christ, Kitty Christ, Lynch Christ, it’s up to you to sense that cosmic force. Have we cold feet about the cosmos? No. Be on the side of the angels. Be a prism. You have that something within, the higher self. You can rub shoulders with a Jesus, a Gautama, an Ingersoll. Are you all in this vibration? I say you are. You once nobble that, congregation, and a buck joyride to heaven becomes a back number. You got me? It’s a lifebrightener, sure. The hottest stuff ever was. It’s the whole pie with jam in. It’s just the cutest snappiest line out. It is immense, supersumptuous. It restores. It vibrates. I know and I am some vibrator. Joking apart and, getting down to bedrock, A. J. Christ Dowie and the harmonial philosophy, have you got that? O. K. Seventyseven west sixtyninth street. Got me? That’s it. You call me up by sunphone any old time. Bumboosers, save your stamps. (He shouts.) Now then our glory song. All join heartily in the singing. Encore! (He sings.) Jeru...

THE GRAMOPHONE: (Drowning his voice.) Whorusalaminyourhighhohhhh... (The disc rasps gratingly against the needle.)

THE THREE WHORES: (Covering their ears, squawk.) Ahhkkk!

ELIJAH: (In rolledup shirtsleeves, black in the face, shouts at the top of his voice, his arms uplifted.) Big Brother up there, Mr President, you hear what I done just been saying to you. Certainly, I sort of believe strong in you, Mr President. I certainly am thinking now Miss Higgins and Miss Ricketts got religion way inside them. Certainly seems to me I don’t never see no wusser scared female than the way you been, Miss Florry, just now as I done seed you. Mr President, you come long and help me save our sisters dear. (He winks at his audience.) Our Mr President, he twig the whole lot and he aint saying nothing.

KITTY-KATE: I forgot myself. In a weak moment I erred and did what I did on Constitution hill. I was confirmed by the bishop and enrolled in the brown scapular. My mother’s sister married a Montmorency. It was a working plumber was my ruination when I was pure.

ZOE-FANNY: I let him larrup it into me for the fun of it.

FLORRY-TERESA: It was in consequence of a portwine beverage on top of Hennessy’s three star. I was guilty with Whelan when he slipped into the bed.

STEPHEN: In the beginning was the word, in the end the world without end. Blessed be the eight beatitudes.

(The beatitudes, Dixon, Madden, Crotthers, Costello, Lenehan, Bannon, Mulligan and Lynch in white surgical students’ gowns, four abreast, goosestepping, tramp fast past in noisy marching.)

THE BEATITUDES: (Incoherently.) Beer beef battledog buybull businum barnum buggerum bishop.

LYSTER: (In quakergrey kneebreeches and broadbrimmed hat, says discreetly.) He is our friend. I need not mention names. Seek thou the light.

(He corantos by. Best enters in hairdresser’s attire, shinily laundered, his locks in curlpapers. He leads John Eglinton who wears a mandarin’s kimono of Nankeen yellow, lizardlettered, and a high pagoda hat.)

BEST: (Smiling, lifts the hat and displays a shaven poll from the crown of which bristles a pigtail toupee tied with an orange topknot.) I was just beautifying him, don’t you know. A thing of beauty, don’t you know, Yeats says, or I mean, Keats says.

JOHN EGLINTON: (Produces a greencapped dark lantern and flashes it towards a corner: with carping accent.) Esthetics and cosmetics are for the boudoir. I am out for truth. Plain truth for a plain man. Tanderagee wants the facts and means to get them.

(In the cone of the searchlight behind the coalscuttle, ollave, holyeyed, the bearded figure of Mananaun MacLir broods, chin on knees. He rises slowly. A cold seawind blows from his druid mouth. About his head writhe eels and elvers. He is encrusted with weeds and shells. His right hand holds a bicycle pump. His left hand grasps a huge crayfish by its two talons.)

MANANAUN MACLIR: (With a voice of waves.) Aum! Hek! Wal! Ak! Lub! Mor! Ma! White yoghin of the gods. Occult pimander of Hermes Trismegistos. (With a voice of whistling seawind.) Punarjanam patsypunjaub! I won’t have my leg pulled. It has been said by one: beware the left, the cult of Shakti. (With a cry of stormbirds.) Shakti Shiva, darkhidden Father! (He smites with his bicycle pump the crayfish in his left hand. On its cooperative dial glow the twelve signs of the zodiac. He wails with the vehemence of the ocean.) Aum! Baum! Pyjaum! I am the light of the homestead! I am the dreamery creamery butter.

(A skeleton judashand strangles the light. The green light wanes to mauve. The gasjet wails whistling.)

THE GASJET: Pooah! Pfuiiiiiii!

(Zoe runs to the chandelier and, crooking her leg, adjusts the mantle.)

ZOE: Who has a fag as I’m here?

LYNCH: (Tossing a cigarette on to the table.) Here.

ZOE: (Her head perched aside in mock pride.) Is that the way to hand the pot to a lady? (She stretches up to light the cigarette over the flame, twirling it slowly, showing the brown tufts of her armpits. Lynch with his poker lifts boldly a side of her slip. Bare from her garters up her flesh appears under the sapphire a nixie’s green. She puffs calmly at her cigarette.) Can you see the beautyspo