"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

import re


def sort_query_parameters(url):
    parts = url.split("?")

    if len(parts) == 1:
        return url

    query = parts[1]
    params = query.split("&")

    params.sort(key=lambda x: x.split('=')[0])

    return parts[0] + "?" + "&".join(params)


def sort_serialized_maps(inp: any, regex: str, delim: str):

    def sort_map(m):
        entire_match = m.group(0)

        groups = m.groups()

        for group in groups:
            pairs = []
            if '=' in group:
                pairs = group.split(delim)

                pairs.sort(key=lambda x: x.split('=')[0])
            else:
                values = group.split(delim)

                if len(values) == 1:
                    pairs = values
                else:
                    pairs = [''] * int(len(values)/2)
                    # loop though every 2nd item
                    for i in range(0, len(values), 2):
                        pairs[int(i/2)] = values[i] + delim + values[i+1]

                pairs.sort(key=lambda x: x.split(delim)[0])

            entire_match = entire_match.replace(group, delim.join(pairs))

        return entire_match

    if isinstance(inp, str):
        return re.sub(regex, sort_map, inp)
    elif isinstance(inp, list):
        for i, v in enumerate(inp):
            inp[i] = sort_serialized_maps(v, regex, delim)
        return inp
    elif isinstance(inp, dict):
        for k, v in inp.items():
            inp[k] = sort_serialized_maps(v, regex, delim)
        return inp
    else:
        raise Exception("Unsupported type")
