/*---------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------------------------------------------*/

/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * Pytorch profile API
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0.0
 *
 *
 * NOTE: This file is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the file manually.
 */

import * as url from 'url'
import * as portableFetch from 'portable-fetch'
import { Configuration } from './configuration'

const BASE_PATH = '.'.replace(/\/+$/, '')

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
  csv: ',',
  ssv: ' ',
  tsv: '\t',
  pipes: '|'
}

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
  (url: string, init?: any): Promise<Response>
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
  url: string
  options: any
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
  protected configuration: Configuration

  constructor(
    configuration?: Configuration,
    protected basePath: string = BASE_PATH,
    protected fetch: FetchAPI = portableFetch
  ) {
    if (configuration) {
      this.configuration = configuration
      this.basePath = configuration.basePath || this.basePath
    }
  }
}

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
  name: 'RequiredError'
  constructor(public field: string, msg?: string) {
    super(msg)
  }
}

/**
 *
 * @export
 * @interface CallStackTableData
 */
export interface CallStackTableData extends Array<CallStackTableDataInner> {}
/**
 *
 * @export
 * @interface CallStackTableDataInner
 */
export interface CallStackTableDataInner {
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  input_shape?: string
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  calls: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  device_self_duration?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  device_total_duration?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  host_self_duration: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  host_total_duration: number
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  call_stack?: string
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  tc_eligible?: string
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  tc_self_ratio?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  tc_total_ratio?: number
}
/**
 *
 * @export
 * @interface DiffNode
 */
export interface DiffNode {
  /**
   *
   * @type {OpStats}
   * @memberof DiffNode
   */
  left: OpStats
  /**
   *
   * @type {OpStats}
   * @memberof DiffNode
   */
  right: OpStats
  /**
   *
   * @type {string}
   * @memberof DiffNode
   */
  path: string
  /**
   *
   * @type {Array<DiffNode>}
   * @memberof DiffNode
   */
  children: Array<DiffNode>
}
/**
 *
 * @export
 * @interface DistributedGraph
 */
export interface DistributedGraph {
  /**
   *
   * @type {DistributedGraphMetadata}
   * @memberof DistributedGraph
   */
  metadata: DistributedGraphMetadata
  /**
   *
   * @type {any}
   * @memberof DistributedGraph
   */
  data: any
}
/**
 *
 * @export
 * @interface DistributedGraphMetadata
 */
export interface DistributedGraphMetadata {
  /**
   *
   * @type {string}
   * @memberof DistributedGraphMetadata
   */
  title: string
  /**
   *
   * @type {Array<string>}
   * @memberof DistributedGraphMetadata
   */
  legends: Array<string>
  /**
   *
   * @type {string}
   * @memberof DistributedGraphMetadata
   */
  units: string
}
/**
 *
 * @export
 * @interface Environment
 */
export interface Environment {
  /**
   *
   * @type {string}
   * @memberof Environment
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof Environment
   */
  value: string
}
/**
 *
 * @export
 * @interface GpuInfo
 */
export interface GpuInfo {
  /**
   *
   * @type {GpuInfoMetadata}
   * @memberof GpuInfo
   */
  metadata: GpuInfoMetadata
  /**
   *
   * @type {any}
   * @memberof GpuInfo
   */
  data: any
}
/**
 *
 * @export
 * @interface GpuInfoMetadata
 */
export interface GpuInfoMetadata {
  /**
   *
   * @type {string}
   * @memberof GpuInfoMetadata
   */
  title: string
}
/**
 *
 * @export
 * @interface GpuMetric
 */
export interface GpuMetric {
  /**
   *
   * @type {string}
   * @memberof GpuMetric
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof GpuMetric
   */
  value: string
}
/**
 *
 * @export
 * @interface GpuMetrics
 */
export interface GpuMetrics {
  /**
   *
   * @type {Array<GpuMetric>}
   * @memberof GpuMetrics
   */
  data: Array<GpuMetric>
  /**
   *
   * @type {string}
   * @memberof GpuMetrics
   */
  tooltip: string
}
/**
 *
 * @export
 * @interface Graph
 */
export interface Graph {
  /**
   *
   * @type {string}
   * @memberof Graph
   */
  title?: string
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof Graph
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {Array<Array<string | number | boolean | ValueAndFormat>>}
   * @memberof Graph
   */
  rows: Array<Array<string | number | boolean | ValueAndFormat>>
}
/**
 *
 * @export
 * @interface GraphColumn
 */
export interface GraphColumn {
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  type: string
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  role?: string
  /**
   *
   * @type {GraphColumnP}
   * @memberof GraphColumn
   */
  p?: GraphColumnP
}
/**
 *
 * @export
 * @interface GraphColumnP
 */
export interface GraphColumnP {
  /**
   *
   * @type {boolean}
   * @memberof GraphColumnP
   */
  html?: boolean
}
/**
 *
 * @export
 * @interface InlineResponse200
 */
export interface InlineResponse200 {
  /**
   *
   * @type {TableMetadata}
   * @memberof InlineResponse200
   */
  metadata: TableMetadata
  /**
   *
   * @type {OperationTableData}
   * @memberof InlineResponse200
   */
  data: OperationTableData
}
/**
 *
 * @export
 * @interface InlineResponse2001
 */
export interface InlineResponse2001 {
  /**
   *
   * @type {TableMetadata}
   * @memberof InlineResponse2001
   */
  metadata: TableMetadata
  /**
   *
   * @type {CallStackTableData}
   * @memberof InlineResponse2001
   */
  data: CallStackTableData
}
/**
 *
 * @export
 * @interface InlineResponse2002
 */
export interface InlineResponse2002 {
  /**
   *
   * @type {GpuInfoMetadata}
   * @memberof InlineResponse2002
   */
  metadata: GpuInfoMetadata
  /**
   *
   * @type {any}
   * @memberof InlineResponse2002
   */
  data: any
}
/**
 *
 * @export
 * @interface KernelGraph
 */
export interface KernelGraph {
  /**
   *
   * @type {Graph}
   * @memberof KernelGraph
   */
  total: Graph
}
/**
 *
 * @export
 * @interface KeyedColumn
 */
export interface KeyedColumn {
  /**
   *
   * @type {string}
   * @memberof KeyedColumn
   */
  type: string
  /**
   *
   * @type {string}
   * @memberof KeyedColumn
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof KeyedColumn
   */
  key: string
}
/**
 *
 * @export
 * @interface MemoryCurveData
 */
export interface MemoryCurveData {
  /**
   *
   * @type {MemoryCurveDataMetadata}
   * @memberof MemoryCurveData
   */
  metadata: MemoryCurveDataMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryCurveData
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryCurveData
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryCurveDataMetadata
 */
export interface MemoryCurveDataMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryCurveDataMetadata
   */
  default_device: string
  /**
   *
   * @type {Array<string>}
   * @memberof MemoryCurveDataMetadata
   */
  devices: Array<string>
  /**
   *
   * @type {any}
   * @memberof MemoryCurveDataMetadata
   */
  peaks: any
  /**
   *
   * @type {any}
   * @memberof MemoryCurveDataMetadata
   */
  totals: any
  /**
   *
   * @type {number}
   * @memberof MemoryCurveDataMetadata
   */
  first_ts: number
  /**
   *
   * @type {string}
   * @memberof MemoryCurveDataMetadata
   */
  time_metric: string
  /**
   *
   * @type {string}
   * @memberof MemoryCurveDataMetadata
   */
  memory_metric: string
  /**
   *
   * @type {number}
   * @memberof MemoryCurveDataMetadata
   */
  time_factor: number
  /**
   *
   * @type {number}
   * @memberof MemoryCurveDataMetadata
   */
  memory_factor: number
}
/**
 *
 * @export
 * @interface MemoryEventsData
 */
export interface MemoryEventsData {
  /**
   *
   * @type {MemoryEventsTableMetadata}
   * @memberof MemoryEventsData
   */
  metadata: MemoryEventsTableMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryEventsData
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryEventsData
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryEventsTableMetadata
 */
export interface MemoryEventsTableMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  default_device: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  search?: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  sort?: string
}
/**
 *
 * @export
 * @interface MemoryStatsData
 */
export interface MemoryStatsData {
  /**
   *
   * @type {MemoryStatsTableMetadata}
   * @memberof MemoryStatsData
   */
  metadata: MemoryStatsTableMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryStatsData
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryStatsData
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryStatsTableMetadata
 */
export interface MemoryStatsTableMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryStatsTableMetadata
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof MemoryStatsTableMetadata
   */
  default_device: string
  /**
   *
   * @type {string}
   * @memberof MemoryStatsTableMetadata
   */
  search: string
  /**
   *
   * @type {string}
   * @memberof MemoryStatsTableMetadata
   */
  sort: string
}
/**
 *
 * @export
 * @interface ModuleStats
 */
export interface ModuleStats {
  /**
   *
   * @type {string}
   * @memberof ModuleStats
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof ModuleStats
   */
  id: string
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  occurences: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  operators: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  host_duration: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  self_host_duration: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  device_duration: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  self_device_duration: number
  /**
   *
   * @type {number}
   * @memberof ModuleStats
   */
  avg_duration: number
  /**
   *
   * @type {Array<ModuleStats>}
   * @memberof ModuleStats
   */
  children: Array<ModuleStats>
}
/**
 *
 * @export
 * @interface ModuleViewData
 */
export interface ModuleViewData {
  /**
   *
   * @type {Array<KeyedColumn>}
   * @memberof ModuleViewData
   */
  columns: Array<KeyedColumn>
  /**
   *
   * @type {Array<ModuleStats>}
   * @memberof ModuleViewData
   */
  data: Array<ModuleStats>
}
/**
 *
 * @export
 * @interface OpAgg
 */
export interface OpAgg {
  /**
   *
   * @type {string}
   * @memberof OpAgg
   */
  name: string
  /**
   *
   * @type {number}
   * @memberof OpAgg
   */
  calls: number
  /**
   *
   * @type {number}
   * @memberof OpAgg
   */
  host_duration: number
  /**
   *
   * @type {number}
   * @memberof OpAgg
   */
  device_duration: number
  /**
   *
   * @type {number}
   * @memberof OpAgg
   */
  self_host_duration: number
  /**
   *
   * @type {number}
   * @memberof OpAgg
   */
  self_device_duration: number
}
/**
 *
 * @export
 * @interface OpStats
 */
export interface OpStats {
  /**
   *
   * @type {string}
   * @memberof OpStats
   */
  name: string
  /**
   *
   * @type {number}
   * @memberof OpStats
   */
  duration: number
  /**
   *
   * @type {number}
   * @memberof OpStats
   */
  device_duration: number
  /**
   *
   * @type {number}
   * @memberof OpStats
   */
  total_duration: number
  /**
   *
   * @type {Array<OpAgg>}
   * @memberof OpStats
   */
  aggs: Array<OpAgg>
}
/**
 *
 * @export
 * @interface OperationTableData
 */
export interface OperationTableData extends Array<OperationTableDataInner> {}
/**
 *
 * @export
 * @interface OperationTableDataInner
 */
export interface OperationTableDataInner {
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  input_shape?: string
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  calls: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  device_self_duration?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  device_total_duration?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  host_self_duration: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  host_total_duration: number
  /**
   *
   * @type {boolean}
   * @memberof OperationTableDataInner
   */
  has_call_stack: boolean
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  tc_eligible?: string
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  tc_self_ratio?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  tc_total_ratio?: number
}
/**
 *
 * @export
 * @interface OperatorGraph
 */
export interface OperatorGraph {
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  device_total_time: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  device_self_time: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  host_total_time: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  host_self_time: Graph
}
/**
 *
 * @export
 * @interface OperatorNode
 */
export interface OperatorNode {
  /**
   *
   * @type {string}
   * @memberof OperatorNode
   */
  name: string
  /**
   *
   * @type {number}
   * @memberof OperatorNode
   */
  start_time: number
  /**
   *
   * @type {number}
   * @memberof OperatorNode
   */
  end_time: number
  /**
   *
   * @type {string}
   * @memberof OperatorNode
   */
  type: string
  /**
   *
   * @type {number}
   * @memberof OperatorNode
   */
  tid: number
  /**
   *
   * @type {Array<OperatorNode>}
   * @memberof OperatorNode
   */
  children: Array<OperatorNode>
}
/**
 *
 * @export
 * @interface Overview
 */
export interface Overview {
  /**
   *
   * @type {Array<Performance>}
   * @memberof Overview
   */
  performance: Array<Performance>
  /**
   *
   * @type {Array<Environment>}
   * @memberof Overview
   */
  environments: Array<Environment>
  /**
   *
   * @type {Graph}
   * @memberof Overview
   */
  steps: Graph
  /**
   *
   * @type {string}
   * @memberof Overview
   */
  recommendations: string
  /**
   *
   * @type {GpuMetrics}
   * @memberof Overview
   */
  gpu_metrics?: GpuMetrics
}
/**
 *
 * @export
 * @interface Performance
 */
export interface Performance {
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  description?: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  value?: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  extra?: string
  /**
   *
   * @type {Array<Performance>}
   * @memberof Performance
   */
  children?: Array<Performance>
}
/**
 *
 * @export
 * @interface Runs
 */
export interface Runs {
  /**
   *
   * @type {Array<string>}
   * @memberof Runs
   */
  runs: Array<string>
  /**
   *
   * @type {boolean}
   * @memberof Runs
   */
  loading: boolean
}
/**
 *
 * @export
 * @interface TableData
 */
export interface TableData {
  /**
   *
   * @type {Graph}
   * @memberof TableData
   */
  data: Graph
  /**
   *
   * @type {TableMetadata}
   * @memberof TableData
   */
  metadata: TableMetadata
}
/**
 *
 * @export
 * @interface TableMetadata
 */
export interface TableMetadata {
  /**
   *
   * @type {string}
   * @memberof TableMetadata
   */
  sort: string
  /**
   *
   * @type {any}
   * @memberof TableMetadata
   */
  tooltips?: any
}
/**
 *
 * @export
 * @interface TensorCoresGraph
 */
export interface TensorCoresGraph {
  /**
   *
   * @type {Graph}
   * @memberof TensorCoresGraph
   */
  total: Graph
}
/**
 *
 * @export
 * @interface ValueAndFormat
 */
export interface ValueAndFormat {
  /**
   *
   * @type {string | number | boolean}
   * @memberof ValueAndFormat
   */
  v: string | number | boolean
  /**
   *
   * @type {string}
   * @memberof ValueAndFormat
   */
  f: string
}
/**
 * DefaultApi - fetch parameter creator
 * @export
 */
export const DefaultApiFetchParamCreator = function (
  configuration?: Configuration
) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} exp_run
     * @param {string} exp_worker
     * @param {string} exp_span
     * @param {string} [path]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    diffnodeGet(
      run: string,
      worker: string,
      span: string,
      exp_run: string,
      exp_worker: string,
      exp_span: string,
      path?: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling diffnodeGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling diffnodeGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling diffnodeGet.'
        )
      }
      // verify required parameter 'exp_run' is not null or undefined
      if (exp_run === null || exp_run === undefined) {
        throw new RequiredError(
          'exp_run',
          'Required parameter exp_run was null or undefined when calling diffnodeGet.'
        )
      }
      // verify required parameter 'exp_worker' is not null or undefined
      if (exp_worker === null || exp_worker === undefined) {
        throw new RequiredError(
          'exp_worker',
          'Required parameter exp_worker was null or undefined when calling diffnodeGet.'
        )
      }
      // verify required parameter 'exp_span' is not null or undefined
      if (exp_span === null || exp_span === undefined) {
        throw new RequiredError(
          'exp_span',
          'Required parameter exp_span was null or undefined when calling diffnodeGet.'
        )
      }
      const localVarPath = `/diffnode`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (exp_run !== undefined) {
        localVarQueryParameter['exp_run'] = exp_run
      }

      if (exp_worker !== undefined) {
        localVarQueryParameter['exp_worker'] = exp_worker
      }

      if (exp_span !== undefined) {
        localVarQueryParameter['exp_span'] = exp_span
      }

      if (path !== undefined) {
        localVarQueryParameter['path'] = path
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedCommopsGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedCommopsGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedCommopsGet.'
        )
      }
      const localVarPath = `/distributed/commops`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      const localVarPath = `/distributed/gpuinfo`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedOverlapGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedOverlapGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedOverlapGet.'
        )
      }
      const localVarPath = `/distributed/overlap`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedWaittimeGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedWaittimeGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedWaittimeGet.'
        )
      }
      const localVarPath = `/distributed/waittime`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'group_by' is not null or undefined
      if (group_by === null || group_by === undefined) {
        throw new RequiredError(
          'group_by',
          'Required parameter group_by was null or undefined when calling kernelGet.'
        )
      }
      const localVarPath = `/kernel`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (group_by !== undefined) {
        localVarQueryParameter['group_by'] = group_by
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [group_by] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      group_by?: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelTableGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelTableGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelTableGet.'
        )
      }
      const localVarPath = `/kernel/table`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (group_by !== undefined) {
        localVarQueryParameter['group_by'] = group_by
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelTcPieGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelTcPieGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelTcPieGet.'
        )
      }
      const localVarPath = `/kernel/tc_pie`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryCurveGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryCurveGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryCurveGet.'
        )
      }
      const localVarPath = `/memory_curve`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryEventsGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryEventsGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryEventsGet.'
        )
      }
      const localVarPath = `/memory_events`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (start_ts !== undefined) {
        localVarQueryParameter['start_ts'] = start_ts
      }

      if (end_ts !== undefined) {
        localVarQueryParameter['end_ts'] = end_ts
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryGet.'
        )
      }
      const localVarPath = `/memory`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (start_ts !== undefined) {
        localVarQueryParameter['start_ts'] = start_ts
      }

      if (end_ts !== undefined) {
        localVarQueryParameter['end_ts'] = end_ts
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    moduleGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling moduleGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling moduleGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling moduleGet.'
        )
      }
      const localVarPath = `/module`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'group_by' is not null or undefined
      if (group_by === null || group_by === undefined) {
        throw new RequiredError(
          'group_by',
          'Required parameter group_by was null or undefined when calling operationGet.'
        )
      }
      const localVarPath = `/operation`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (group_by !== undefined) {
        localVarQueryParameter['group_by'] = group_by
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {string} op_name
     * @param {string} [input_shape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      op_name: string,
      input_shape?: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'group_by' is not null or undefined
      if (group_by === null || group_by === undefined) {
        throw new RequiredError(
          'group_by',
          'Required parameter group_by was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'op_name' is not null or undefined
      if (op_name === null || op_name === undefined) {
        throw new RequiredError(
          'op_name',
          'Required parameter op_name was null or undefined when calling operationStackGet.'
        )
      }
      const localVarPath = `/operation/stack`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (group_by !== undefined) {
        localVarQueryParameter['group_by'] = group_by
      }

      if (op_name !== undefined) {
        localVarQueryParameter['op_name'] = op_name
      }

      if (input_shape !== undefined) {
        localVarQueryParameter['input_shape'] = input_shape
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'group_by' is not null or undefined
      if (group_by === null || group_by === undefined) {
        throw new RequiredError(
          'group_by',
          'Required parameter group_by was null or undefined when calling operationTableGet.'
        )
      }
      const localVarPath = `/operation/table`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (group_by !== undefined) {
        localVarQueryParameter['group_by'] = group_by
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling overviewGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling overviewGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling overviewGet.'
        )
      }
      const localVarPath = `/overview`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(options: any = {}): FetchArgs {
      const localVarPath = `/runs`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(run: string, worker: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling spansGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling spansGet.'
        )
      }
      const localVarPath = `/spans`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling traceGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling traceGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling traceGet.'
        )
      }
      const localVarPath = `/trace`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    treeGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling treeGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling treeGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling treeGet.'
        )
      }
      const localVarPath = `/tree`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(run: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling viewsGet.'
        )
      }
      const localVarPath = `/views`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(run: string, view: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling workersGet.'
        )
      }
      // verify required parameter 'view' is not null or undefined
      if (view === null || view === undefined) {
        throw new RequiredError(
          'view',
          'Required parameter view was null or undefined when calling workersGet.'
        )
      }
      const localVarPath = `/workers`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (view !== undefined) {
        localVarQueryParameter['view'] = view
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    }
  }
}

/**
 * DefaultApi - functional programming interface
 * @export
 */
export const DefaultApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} exp_run
     * @param {string} exp_worker
     * @param {string} exp_span
     * @param {string} [path]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    diffnodeGet(
      run: string,
      worker: string,
      span: string,
      exp_run: string,
      exp_worker: string,
      exp_span: string,
      path?: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<DiffNode> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).diffnodeGet(
        run,
        worker,
        span,
        exp_run,
        exp_worker,
        exp_span,
        path,
        options
      )
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse2002> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedCommopsGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<GpuInfo> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedGpuinfoGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<DistributedGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedOverlapGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<DistributedGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedWaittimeGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<KernelGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelGet(run, worker, span, group_by, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [group_by] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      group_by?: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<TableData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelTableGet(run, worker, span, group_by, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<TensorCoresGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelTcPieGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryCurveData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryCurveGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryEventsData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryEventsGet(run, worker, span, start_ts, end_ts, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryStatsData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryGet(run, worker, span, start_ts, end_ts, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    moduleGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ModuleViewData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).moduleGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<OperatorGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationGet(run, worker, span, group_by, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {string} op_name
     * @param {string} [input_shape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      op_name: string,
      input_shape?: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse2001> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationStackGet(
        run,
        worker,
        span,
        group_by,
        op_name,
        input_shape,
        options
      )
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse200> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationTableGet(run, worker, span, group_by, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Overview> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).overviewGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Runs> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).runsGet(options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(
      run: string,
      worker: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).spansGet(run, worker, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).traceGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    treeGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<OperatorNode> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).treeGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(
      run: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).viewsGet(run, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(
      run: string,
      view: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).workersGet(run, view, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    }
  }
}

/**
 * DefaultApi - factory interface
 * @export
 */
export const DefaultApiFactory = function (
  configuration?: Configuration,
  fetch?: FetchAPI,
  basePath?: string
) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} exp_run
     * @param {string} exp_worker
     * @param {string} exp_span
     * @param {string} [path]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    diffnodeGet(
      run: string,
      worker: string,
      span: string,
      exp_run: string,
      exp_worker: string,
      exp_span: string,
      path?: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).diffnodeGet(
        run,
        worker,
        span,
        exp_run,
        exp_worker,
        exp_span,
        path,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedCommopsGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedGpuinfoGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedOverlapGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedWaittimeGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).kernelGet(
        run,
        worker,
        span,
        group_by,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [group_by] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      group_by?: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).kernelTableGet(
        run,
        worker,
        span,
        group_by,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).kernelTcPieGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).memoryCurveGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options?: any
    ) {
      return DefaultApiFp(configuration).memoryEventsGet(
        run,
        worker,
        span,
        start_ts,
        end_ts,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [start_ts]
     * @param {number} [end_ts]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      start_ts?: number,
      end_ts?: number,
      options?: any
    ) {
      return DefaultApiFp(configuration).memoryGet(
        run,
        worker,
        span,
        start_ts,
        end_ts,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    moduleGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).moduleGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationGet(
        run,
        worker,
        span,
        group_by,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {string} op_name
     * @param {string} [input_shape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      op_name: string,
      input_shape?: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationStackGet(
        run,
        worker,
        span,
        group_by,
        op_name,
        input_shape,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} group_by Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      group_by: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationTableGet(
        run,
        worker,
        span,
        group_by,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).overviewGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(options?: any) {
      return DefaultApiFp(configuration).runsGet(options)(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(run: string, worker: string, options?: any) {
      return DefaultApiFp(configuration).spansGet(
        run,
        worker,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).traceGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    treeGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).treeGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(run: string, options?: any) {
      return DefaultApiFp(configuration).viewsGet(run, options)(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(run: string, view: string, options?: any) {
      return DefaultApiFp(configuration).workersGet(
        run,
        view,
        options
      )(fetch, basePath)
    }
  }
}

/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export class DefaultApi extends BaseAPI {
  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} exp_run
   * @param {string} exp_worker
   * @param {string} exp_span
   * @param {string} [path]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public diffnodeGet(
    run: string,
    worker: string,
    span: string,
    exp_run: string,
    exp_worker: string,
    exp_span: string,
    path?: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).diffnodeGet(
      run,
      worker,
      span,
      exp_run,
      exp_worker,
      exp_span,
      path,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedCommopsGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedCommopsGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedGpuinfoGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedGpuinfoGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedOverlapGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedOverlapGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedWaittimeGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedWaittimeGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} group_by Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelGet(
    run: string,
    worker: string,
    span: string,
    group_by: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelGet(
      run,
      worker,
      span,
      group_by,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} [group_by] Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelTableGet(
    run: string,
    worker: string,
    span: string,
    group_by?: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelTableGet(
      run,
      worker,
      span,
      group_by,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelTcPieGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelTcPieGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryCurveGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryCurveGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {number} [start_ts]
   * @param {number} [end_ts]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryEventsGet(
    run: string,
    worker: string,
    span: string,
    start_ts?: number,
    end_ts?: number,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryEventsGet(
      run,
      worker,
      span,
      start_ts,
      end_ts,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {number} [start_ts]
   * @param {number} [end_ts]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryGet(
    run: string,
    worker: string,
    span: string,
    start_ts?: number,
    end_ts?: number,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryGet(
      run,
      worker,
      span,
      start_ts,
      end_ts,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public moduleGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).moduleGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} group_by Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationGet(
    run: string,
    worker: string,
    span: string,
    group_by: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationGet(
      run,
      worker,
      span,
      group_by,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} group_by Group By
   * @param {string} op_name
   * @param {string} [input_shape]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationStackGet(
    run: string,
    worker: string,
    span: string,
    group_by: string,
    op_name: string,
    input_shape?: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationStackGet(
      run,
      worker,
      span,
      group_by,
      op_name,
      input_shape,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} group_by Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationTableGet(
    run: string,
    worker: string,
    span: string,
    group_by: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationTableGet(
      run,
      worker,
      span,
      group_by,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public overviewGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).overviewGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public runsGet(options?: any) {
    return DefaultApiFp(this.configuration).runsGet(options)(
      this.fetch,
      this.basePath
    )
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public spansGet(run: string, worker: string, options?: any) {
    return DefaultApiFp(this.configuration).spansGet(
      run,
      worker,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public traceGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).traceGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public treeGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).treeGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public viewsGet(run: string, options?: any) {
    return DefaultApiFp(this.configuration).viewsGet(run, options)(
      this.fetch,
      this.basePath
    )
  }

  /**
   *
   * @param {string} run
   * @param {string} view
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public workersGet(run: string, view: string, options?: any) {
    return DefaultApiFp(this.configuration).workersGet(
      run,
      view,
      options
    )(this.fetch, this.basePath)
  }
}
