## How to contribute to Pytube

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/pytube/pytube/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/pytube/pytube/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **[MRE code sample](https://stackoverflow.com/help/minimal-reproducible-example)** or an **executable test case** demonstrating the expected behavior that is not occurring.

* For more detailed information on submitting a bug report and creating an issue, visit `TODO`

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Before submitting, please read the [Numpy Contribution Guidelines](https://numpy.org/devdocs/dev/index.html) guide to know more about coding conventions and benchmarks.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Pytube will generally not be accepted as we abide by pep8 formatting.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change as an issue in the with the label #enhancement

* Though perhaps not common as GitHub issues are primarily intended for bug reports and fixes, PyTube is currently using issues for open design proposals.

#### **Do you have questions about the source code?**

* Ask any question about how to use PyTube [in StackOverflow](https://stackoverflow.com/questions/tagged/pytube)

#### **Do you want to contribute to the PyTube documentation?**

* Consider submitting a patch to the [docs](https://github.com/pytube/pytube/tree/master/docs)

PyTube is a volunteer effort. We encourage you to pitch in and [join the team](https://contributors.rubyonrails.org)!

Thanks! :smile: :heart:

PyTube Team
