# Milvus Python SDK

[![version](https://img.shields.io/pypi/v/pymilvus.svg?color=blue)](https://pypi.org/project/pymilvus/)
[![Supported Python Versions](https://img.shields.io/pypi/pyversions/pymilvus?logo=python&logoColor=blue)](https://pypi.org/project/pymilvus/)
[![Downloads](https://static.pepy.tech/badge/pymilvus)](https://pepy.tech/project/pymilvus)
[![Downloads](https://static.pepy.tech/badge/pymilvus/month)](https://pepy.tech/project/pymilvus)
[![Downloads](https://static.pepy.tech/badge/pymilvus/week)](https://pepy.tech/project/pymilvus)

[![license](https://img.shields.io/hexpm/l/plug.svg?color=green)](https://github.com/milvus-io/pymilvus/blob/master/LICENSE)
![Static Badge](https://img.shields.io/badge/slack-%23py--milvus-blue?style=social&logo=slack&link=https%3A%2F%2Fmilvusio.slack.com%2Farchives%2FC024XTWMT4L)

Python SDK for [Milvus](https://github.com/milvus-io/milvus). To contribute code to this project, please read our [contribution guidelines](https://github.com/milvus-io/milvus/blob/master/CONTRIBUTING.md) first. If you have some ideas or encounter a problem, you can find us in the Slack channel [#py-milvus](https://milvusio.slack.com/archives/C024XTWMT4L).


## Compatibility
The following collection shows Milvus versions and recommended PyMilvus versions:

|Milvus version| Recommended PyMilvus version |
|:-----:|:-----:|
| 1.0.\* | 1.0.1 |
| 1.1.\* | 1.1.2 |
| 2.0.\* | 2.0.2 |
| 2.1.\* | 2.1.3 |
| 2.2.\* | 2.2.15 |
| 2.3.\* | 2.3.7 |
| 2.4.\* | 2.4.X |
| 2.5.\* | 2.5.X |
| 2.6.\* | 2.6.X |


## Installation

You can install PyMilvus via `pip` or `pip3` for Python 3.8+:

```shell
$ pip3 install pymilvus
$ pip3 install pymilvus[model] # for milvus-model
$ pip3 install pymilvus[bulk_writer] # for bulk_writer
```

You can install a specific version of PyMilvus by:

```shell
$ pip3 install pymilvus==2.4.10
```

You can upgrade PyMilvus to the latest version by:

```shell
$ pip3 install --upgrade pymilvus
```

## FAQ
Q1. How to get submodules?

A1. The following command will get the protos matching to the generated files, for protos of certain version, see
[milvus-proto](https://github.com/milvus-io/milvus-proto#usage) for details.
```shell
$ git submodule update --init
```

Q2. How to generate python files from milvus-proto?

A2.
```shell
$ make gen_proto
```

Q3. How to use the local PyMilvus repository for Milvus server?

A3.
```shell
$ make install
```

Q4. How to check and auto-fix the coding styles?

A4.
```shell
make lint
make format
```

Q5. How to set up pre-commit hooks to automatically check and fix the coding styles?

Once installed, the hooks will automatically run `make format` and `make lint` before each commit. If the checks fail, the commit will be aborted, and you'll need to fix the issues before committing again.

A5. Pre-commit hooks help ensure code quality by automatically running linting and formatting checks before each commit.
```shell
# Install pre-commit (if not already installed)
$ pip install pre-commit

# Install the git hook scripts
$ pre-commit install
```

Q7. How to run unittests?

A7
```shell
$ pip install ".[dev]"
$ make unittest
```

Q8. `zsh: no matches found: pymilvus[model]`, how do I solve this?

A8
```shell
$ pip install "pymilvus[model]"
```

## Documentation

Documentation is available online: https://milvus.io/api-reference/pymilvus/v2.4.x/About.md

## Developing package releases

The commits on the development branch of each version will be packaged and uploaded to [Test PyPI](https://test.pypi.org/).

The package name generated by the development branch is x.y.z.rc<dist>, where <dist> is the number of commits that differ from the most recent release.

- For example, after the release of **2.3.4**, two commits were submitted on the 2.3 branch.
The version number of the latest commit of 2.3 branch is **2.3.5.rc2**.

- For example, after the release of **2.3.4**, 10 commits were submitted on the master branch.
The version number of the latest commit of master branch is **2.4.0.rc10**.


To install the package on Test PyPi, you need to append `--extra-index-url` after pip, for example:
```shell
$ python3 -m pip install --extra-index-url https://test.pypi.org/simple/ pymilvus==2.1.0.dev66
```


## License
[Apache License 2.0](LICENSE)
