#------------------------------------------------------------------------------
# Copyright (c) 2021, 2025, Oracle and/or its affiliates.
#
# This software is dual-licensed to you under the Universal Permissive License
# (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl and Apache License
# 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose
# either license.
#
# If you elect to accept the software under the Apache License, Version 2.0,
# the following applies:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# data_types.pyx
#
# Cython file defining the messages sent to the database and the responses that
# are received by the client for establishing data type formats (embedded in
# thin_impl.pyx).
#------------------------------------------------------------------------------

ctypedef struct DataType:
    uint16_t data_type
    uint16_t conv_data_type
    uint16_t representation


# data types not associated with actual data in the database
cdef enum:
    TNS_DATA_TYPE_FLOAT = 4
    TNS_DATA_TYPE_STR = 5
    TNS_DATA_TYPE_VNU = 6
    TNS_DATA_TYPE_PDN = 7
    TNS_DATA_TYPE_VCS = 9
    TNS_DATA_TYPE_TIDDEF = 10
    TNS_DATA_TYPE_VBI = 15
    TNS_DATA_TYPE_UB2 = 25
    TNS_DATA_TYPE_UB4 = 26
    TNS_DATA_TYPE_SB1 = 27
    TNS_DATA_TYPE_SB2 = 28
    TNS_DATA_TYPE_SB4 = 29
    TNS_DATA_TYPE_SWORD = 30
    TNS_DATA_TYPE_UWORD = 31
    TNS_DATA_TYPE_PTRB = 32
    TNS_DATA_TYPE_PTRW = 33
    TNS_DATA_TYPE_OER8 = 34 + 256
    TNS_DATA_TYPE_FUN = 35 + 256
    TNS_DATA_TYPE_AUA = 36 + 256
    TNS_DATA_TYPE_RXH7 = 37 + 256
    TNS_DATA_TYPE_NA6 = 38 + 256
    TNS_DATA_TYPE_OAC9 = 39
    TNS_DATA_TYPE_AMS = 40
    TNS_DATA_TYPE_BRN = 41
    TNS_DATA_TYPE_BRP = 42 + 256
    TNS_DATA_TYPE_BRV = 43 + 256
    TNS_DATA_TYPE_KVA = 44 + 256
    TNS_DATA_TYPE_CLS = 45 + 256
    TNS_DATA_TYPE_CUI = 46 + 256
    TNS_DATA_TYPE_DFN = 47 + 256
    TNS_DATA_TYPE_DQR = 48 + 256
    TNS_DATA_TYPE_DSC = 49 + 256
    TNS_DATA_TYPE_EXE = 50 + 256
    TNS_DATA_TYPE_FCH = 51 + 256
    TNS_DATA_TYPE_GBV = 52 + 256
    TNS_DATA_TYPE_GEM = 53 + 256
    TNS_DATA_TYPE_GIV = 54 + 256
    TNS_DATA_TYPE_OKG = 55 + 256
    TNS_DATA_TYPE_HMI = 56 + 256
    TNS_DATA_TYPE_INO = 57 + 256
    TNS_DATA_TYPE_LNF = 59 + 256
    TNS_DATA_TYPE_ONT = 60 + 256
    TNS_DATA_TYPE_OPE = 61 + 256
    TNS_DATA_TYPE_OSQ = 62 + 256
    TNS_DATA_TYPE_SFE = 63 + 256
    TNS_DATA_TYPE_SPF = 64 + 256
    TNS_DATA_TYPE_VSN = 65 + 256
    TNS_DATA_TYPE_UD7 = 66 + 256
    TNS_DATA_TYPE_DSA = 67 + 256
    TNS_DATA_TYPE_UIN = 68
    TNS_DATA_TYPE_PIN = 71 + 256
    TNS_DATA_TYPE_PFN = 72 + 256
    TNS_DATA_TYPE_PPT = 73 + 256
    TNS_DATA_TYPE_STO = 75 + 256
    TNS_DATA_TYPE_ARC = 77 + 256
    TNS_DATA_TYPE_MRS = 78 + 256
    TNS_DATA_TYPE_MRT = 79 + 256
    TNS_DATA_TYPE_MRG = 80 + 256
    TNS_DATA_TYPE_MRR = 81 + 256
    TNS_DATA_TYPE_MRC = 82 + 256
    TNS_DATA_TYPE_VER = 83 + 256
    TNS_DATA_TYPE_LON2 = 84 + 256
    TNS_DATA_TYPE_INO2 = 85 + 256
    TNS_DATA_TYPE_ALL = 86 + 256
    TNS_DATA_TYPE_UDB = 87 + 256
    TNS_DATA_TYPE_AQI = 88 + 256
    TNS_DATA_TYPE_ULB = 89 + 256
    TNS_DATA_TYPE_ULD = 90 + 256
    TNS_DATA_TYPE_SLS = 91
    TNS_DATA_TYPE_SID = 92 + 256
    TNS_DATA_TYPE_NA7 = 93 + 256
    TNS_DATA_TYPE_LVC = 94
    TNS_DATA_TYPE_LVB = 95
    TNS_DATA_TYPE_AVC = 97
    TNS_DATA_TYPE_AL7 = 98 + 256
    TNS_DATA_TYPE_K2RPC = 99 + 256
    TNS_DATA_TYPE_RDD = 104
    TNS_DATA_TYPE_XDP = 103 + 256
    TNS_DATA_TYPE_OSL = 106
    TNS_DATA_TYPE_OKO8 = 107 + 256
    TNS_DATA_TYPE_EXT_NAMED = 108
    TNS_DATA_TYPE_EXT_REF = 110
    TNS_DATA_TYPE_INT_REF = 111
    TNS_DATA_TYPE_CFILE = 115
    TNS_DATA_TYPE_RSET = 116
    TNS_DATA_TYPE_CWD = 117
    TNS_DATA_TYPE_OAC122 = 120
    TNS_DATA_TYPE_UD12 = 124 + 256
    TNS_DATA_TYPE_AL8 = 125 + 256
    TNS_DATA_TYPE_LFOP = 126 + 256
    TNS_DATA_TYPE_FCRT = 127 + 256
    TNS_DATA_TYPE_DNY = 128 + 256
    TNS_DATA_TYPE_OPR = 129 + 256
    TNS_DATA_TYPE_PLS = 130 + 256
    TNS_DATA_TYPE_XID = 131 + 256
    TNS_DATA_TYPE_TXN = 132 + 256
    TNS_DATA_TYPE_DCB = 133 + 256
    TNS_DATA_TYPE_CCA = 134 + 256
    TNS_DATA_TYPE_WRN = 135 + 256
    TNS_DATA_TYPE_TLH = 137 + 256
    TNS_DATA_TYPE_TOH = 138 + 256
    TNS_DATA_TYPE_FOI = 139 + 256
    TNS_DATA_TYPE_SID2 = 140 + 256
    TNS_DATA_TYPE_TCH = 141 + 256
    TNS_DATA_TYPE_PII = 142 + 256
    TNS_DATA_TYPE_PFI = 143 + 256
    TNS_DATA_TYPE_PPU = 144 + 256
    TNS_DATA_TYPE_PTE = 145 + 256
    TNS_DATA_TYPE_CLV = 146
    TNS_DATA_TYPE_RXH8 = 148 + 256
    TNS_DATA_TYPE_N12 = 149 + 256
    TNS_DATA_TYPE_AUTH = 150 + 256
    TNS_DATA_TYPE_KVAL = 151 + 256
    TNS_DATA_TYPE_DTR = 152
    TNS_DATA_TYPE_DUN = 153
    TNS_DATA_TYPE_DOP = 154
    TNS_DATA_TYPE_VST = 155
    TNS_DATA_TYPE_ODT = 156
    TNS_DATA_TYPE_FGI = 157 + 256
    TNS_DATA_TYPE_DSY = 158 + 256
    TNS_DATA_TYPE_DSYR8 = 159 + 256
    TNS_DATA_TYPE_DSYH8 = 160 + 256
    TNS_DATA_TYPE_DSYL = 161 + 256
    TNS_DATA_TYPE_DSYT8 = 162 + 256
    TNS_DATA_TYPE_DSYV8 = 163 + 256
    TNS_DATA_TYPE_DSYP = 164 + 256
    TNS_DATA_TYPE_DSYF = 165 + 256
    TNS_DATA_TYPE_DSYK = 166 + 256
    TNS_DATA_TYPE_DSYY = 167 + 256
    TNS_DATA_TYPE_DSYQ = 168 + 256
    TNS_DATA_TYPE_DSYC = 169 + 256
    TNS_DATA_TYPE_DSYA = 170 + 256
    TNS_DATA_TYPE_OT8 = 171 + 256
    TNS_DATA_TYPE_DOL = 172
    TNS_DATA_TYPE_DSYTY = 173 + 256
    TNS_DATA_TYPE_AQE = 174 + 256
    TNS_DATA_TYPE_KV = 175 + 256
    TNS_DATA_TYPE_AQD = 176 + 256
    TNS_DATA_TYPE_AQ8 = 177 + 256
    TNS_DATA_TYPE_TIME = 178
    TNS_DATA_TYPE_TIME_TZ = 179
    TNS_DATA_TYPE_EDATE = 184
    TNS_DATA_TYPE_ETIME = 185
    TNS_DATA_TYPE_ETTZ = 186
    TNS_DATA_TYPE_ESTAMP = 187
    TNS_DATA_TYPE_ESTZ = 188
    TNS_DATA_TYPE_EIYM = 189
    TNS_DATA_TYPE_EIDS = 190
    TNS_DATA_TYPE_RFS = 193 + 256
    TNS_DATA_TYPE_RXH10 = 194 + 256
    TNS_DATA_TYPE_DCLOB = 195
    TNS_DATA_TYPE_DBLOB = 196
    TNS_DATA_TYPE_DBFILE = 197
    TNS_DATA_TYPE_DJSON = 198
    TNS_DATA_TYPE_KPN = 198 + 256
    TNS_DATA_TYPE_KPDNR = 199 + 256
    TNS_DATA_TYPE_DSYD = 200 + 256
    TNS_DATA_TYPE_DSYS = 201 + 256
    TNS_DATA_TYPE_DSYR = 202 + 256
    TNS_DATA_TYPE_DSYH = 203 + 256
    TNS_DATA_TYPE_DSYT = 204 + 256
    TNS_DATA_TYPE_DSYV = 205 + 256
    TNS_DATA_TYPE_AQM = 206 + 256
    TNS_DATA_TYPE_OER11 = 207 + 256
    TNS_DATA_TYPE_AQL = 210 + 256
    TNS_DATA_TYPE_OTC = 211 + 256
    TNS_DATA_TYPE_KFNO = 212 + 256
    TNS_DATA_TYPE_KFNP = 213 + 256
    TNS_DATA_TYPE_KGT8 = 214 + 256
    TNS_DATA_TYPE_RASB4 = 215 + 256
    TNS_DATA_TYPE_RAUB2 = 216 + 256
    TNS_DATA_TYPE_RAUB1 = 217 + 256
    TNS_DATA_TYPE_RATXT = 218 + 256
    TNS_DATA_TYPE_RSSB4 = 219 + 256
    TNS_DATA_TYPE_RSUB2 = 220 + 256
    TNS_DATA_TYPE_RSUB1 = 221 + 256
    TNS_DATA_TYPE_RSTXT = 222 + 256
    TNS_DATA_TYPE_RIDL = 223 + 256
    TNS_DATA_TYPE_GLRDD = 224 + 256
    TNS_DATA_TYPE_GLRDG = 225 + 256
    TNS_DATA_TYPE_GLRDC = 226 + 256
    TNS_DATA_TYPE_OKO = 227 + 256
    TNS_DATA_TYPE_DPP = 228 + 256
    TNS_DATA_TYPE_DPLS = 229 + 256
    TNS_DATA_TYPE_DPMOP = 230 + 256
    TNS_DATA_TYPE_ESITZ = 232
    TNS_DATA_TYPE_UB8 = 233
    TNS_DATA_TYPE_STAT = 234 + 256
    TNS_DATA_TYPE_RFX = 235 + 256
    TNS_DATA_TYPE_FAL = 236 + 256
    TNS_DATA_TYPE_CKV = 237 + 256
    TNS_DATA_TYPE_DRCX = 238 + 256
    TNS_DATA_TYPE_KGH = 239 + 256
    TNS_DATA_TYPE_AQO = 240 + 256
    TNS_DATA_TYPE_PNTY = 241
    TNS_DATA_TYPE_OKGT = 242 + 256
    TNS_DATA_TYPE_KPFC = 243 + 256
    TNS_DATA_TYPE_FE2 = 244 + 256
    TNS_DATA_TYPE_SPFP = 245 + 256
    TNS_DATA_TYPE_DPULS = 246 + 256
    TNS_DATA_TYPE_AQA = 253 + 256
    TNS_DATA_TYPE_KPBF = 254 + 256
    TNS_DATA_TYPE_TSM = 513
    TNS_DATA_TYPE_MSS = 514
    TNS_DATA_TYPE_KPC = 516
    TNS_DATA_TYPE_CRS = 517
    TNS_DATA_TYPE_KKS = 518
    TNS_DATA_TYPE_KSP = 519
    TNS_DATA_TYPE_KSPTOP = 520
    TNS_DATA_TYPE_KSPVAL = 521
    TNS_DATA_TYPE_PSS = 522
    TNS_DATA_TYPE_NLS = 523
    TNS_DATA_TYPE_ALS = 524
    TNS_DATA_TYPE_KSDEVTVAL = 525
    TNS_DATA_TYPE_KSDEVTTOP = 526
    TNS_DATA_TYPE_KPSPP = 527
    TNS_DATA_TYPE_KOL = 528
    TNS_DATA_TYPE_LST = 529
    TNS_DATA_TYPE_ACX = 530
    TNS_DATA_TYPE_SCS = 531
    TNS_DATA_TYPE_RXH = 532
    TNS_DATA_TYPE_KPDNS = 533
    TNS_DATA_TYPE_KPDCN = 534
    TNS_DATA_TYPE_KPNNS = 535
    TNS_DATA_TYPE_KPNCN = 536
    TNS_DATA_TYPE_KPS = 537
    TNS_DATA_TYPE_APINF = 538
    TNS_DATA_TYPE_TEN = 539
    TNS_DATA_TYPE_XSSCS = 540
    TNS_DATA_TYPE_XSSSO = 541
    TNS_DATA_TYPE_XSSAO = 542
    TNS_DATA_TYPE_KSRPC = 543
    TNS_DATA_TYPE_KVL = 560
    TNS_DATA_TYPE_SESSGET = 563
    TNS_DATA_TYPE_SESSREL = 564
    TNS_DATA_TYPE_XSSDEF = 565
    TNS_DATA_TYPE_PDQCINV = 572
    TNS_DATA_TYPE_PDQIDC = 573
    TNS_DATA_TYPE_KPDQCSTA = 574
    TNS_DATA_TYPE_KPRS = 575
    TNS_DATA_TYPE_KPDQIDC = 576
    TNS_DATA_TYPE_RTSTRM = 578
    TNS_DATA_TYPE_SESSRET = 579
    TNS_DATA_TYPE_SCN6 = 580
    TNS_DATA_TYPE_KECPA = 581
    TNS_DATA_TYPE_KECPP = 582
    TNS_DATA_TYPE_SXA = 583
    TNS_DATA_TYPE_KVARR = 584
    TNS_DATA_TYPE_KPNGN = 585
    TNS_DATA_TYPE_XSNSOP = 590
    TNS_DATA_TYPE_XSATTR = 591
    TNS_DATA_TYPE_XSNS = 592
    TNS_DATA_TYPE_TXT = 593
    TNS_DATA_TYPE_XSSESSNS = 594
    TNS_DATA_TYPE_XSATTOP = 595
    TNS_DATA_TYPE_XSCREOP = 596
    TNS_DATA_TYPE_XSDETOP = 597
    TNS_DATA_TYPE_XSDESOP = 598
    TNS_DATA_TYPE_XSSETSP = 599
    TNS_DATA_TYPE_XSSIDP = 600
    TNS_DATA_TYPE_XSPRIN = 601
    TNS_DATA_TYPE_XSKVL = 602
    TNS_DATA_TYPE_XSSSDEF2 = 603
    TNS_DATA_TYPE_XSNSOP2 = 604
    TNS_DATA_TYPE_XSNS2 = 605
    TNS_DATA_TYPE_IMPLRES = 611
    TNS_DATA_TYPE_OER19 = 612
    TNS_DATA_TYPE_UB1ARRAY = 613
    TNS_DATA_TYPE_SESSSTATE = 614
    TNS_DATA_TYPE_AC_REPLAY = 615
    TNS_DATA_TYPE_AC_CONT = 616
    TNS_DATA_TYPE_KPDNREQ = 622
    TNS_DATA_TYPE_KPDNRNF = 623
    TNS_DATA_TYPE_KPNGNC = 624
    TNS_DATA_TYPE_KPNRI = 625
    TNS_DATA_TYPE_AQENQ = 626
    TNS_DATA_TYPE_AQDEQ = 627
    TNS_DATA_TYPE_AQJMS = 628
    TNS_DATA_TYPE_KPDNRPAY = 629
    TNS_DATA_TYPE_KPDNRACK = 630
    TNS_DATA_TYPE_KPDNRMP = 631
    TNS_DATA_TYPE_KPDNRDQ = 632
    TNS_DATA_TYPE_CHUNKINFO = 636
    TNS_DATA_TYPE_SCN = 637
    TNS_DATA_TYPE_SCN8 = 638
    TNS_DATA_TYPE_UD21 = 639
    TNS_DATA_TYPE_TNP = 640
    TNS_DATA_TYPE_OAC = 646
    TNS_DATA_TYPE_SESSSIGN = 647
    TNS_DATA_TYPE_OER = 652
    TNS_DATA_TYPE_PLEND = 660
    TNS_DATA_TYPE_PLBGN = 661
    TNS_DATA_TYPE_UDS = 663
    TNS_DATA_TYPE_PLOP = 665


# data type representations
cdef enum:
    TNS_TYPE_REP_NATIVE = 0
    TNS_TYPE_REP_UNIVERSAL = 1
    TNS_TYPE_REP_ORACLE = 10


cdef DataType[320] DATA_TYPES = [
    [ORA_TYPE_NUM_VARCHAR, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_NUMBER, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [ORA_TYPE_NUM_LONG, ORA_TYPE_NUM_LONG, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_DATE, ORA_TYPE_NUM_DATE, TNS_TYPE_REP_ORACLE],
    [ORA_TYPE_NUM_RAW, ORA_TYPE_NUM_RAW, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_LONG_RAW, ORA_TYPE_NUM_LONG_RAW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB2, TNS_DATA_TYPE_UB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB4, TNS_DATA_TYPE_UB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SB1, TNS_DATA_TYPE_SB1, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_SB2, TNS_DATA_TYPE_SB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SB4, TNS_DATA_TYPE_SB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SWORD, TNS_DATA_TYPE_SWORD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UWORD, TNS_DATA_TYPE_UWORD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTRB, TNS_DATA_TYPE_PTRB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTRW, TNS_DATA_TYPE_PTRW, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIDDEF, TNS_DATA_TYPE_TIDDEF, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_ROWID, ORA_TYPE_NUM_ROWID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AMS, TNS_DATA_TYPE_AMS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRN, TNS_DATA_TYPE_BRN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CWD, TNS_DATA_TYPE_CWD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OAC122, TNS_DATA_TYPE_OAC122, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER8, TNS_DATA_TYPE_OER8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FUN, TNS_DATA_TYPE_FUN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AUA, TNS_DATA_TYPE_AUA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH7, TNS_DATA_TYPE_RXH7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NA6, TNS_DATA_TYPE_NA6, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRP, TNS_DATA_TYPE_BRP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_BRV, TNS_DATA_TYPE_BRV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVA, TNS_DATA_TYPE_KVA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CLS, TNS_DATA_TYPE_CLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CUI, TNS_DATA_TYPE_CUI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DFN, TNS_DATA_TYPE_DFN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DQR, TNS_DATA_TYPE_DQR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSC, TNS_DATA_TYPE_DSC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXE, TNS_DATA_TYPE_EXE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FCH, TNS_DATA_TYPE_FCH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GBV, TNS_DATA_TYPE_GBV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GEM, TNS_DATA_TYPE_GEM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GIV, TNS_DATA_TYPE_GIV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKG, TNS_DATA_TYPE_OKG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_HMI, TNS_DATA_TYPE_HMI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INO, TNS_DATA_TYPE_INO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LNF, TNS_DATA_TYPE_LNF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ONT, TNS_DATA_TYPE_ONT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OPE, TNS_DATA_TYPE_OPE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OSQ, TNS_DATA_TYPE_OSQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SFE, TNS_DATA_TYPE_SFE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SPF, TNS_DATA_TYPE_SPF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VSN, TNS_DATA_TYPE_VSN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UD7, TNS_DATA_TYPE_UD7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSA, TNS_DATA_TYPE_DSA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PIN, TNS_DATA_TYPE_PIN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PFN, TNS_DATA_TYPE_PFN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PPT, TNS_DATA_TYPE_PPT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_STO, TNS_DATA_TYPE_STO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ARC, TNS_DATA_TYPE_ARC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRS, TNS_DATA_TYPE_MRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRT, TNS_DATA_TYPE_MRT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRG, TNS_DATA_TYPE_MRG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRR, TNS_DATA_TYPE_MRR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MRC, TNS_DATA_TYPE_MRC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VER, TNS_DATA_TYPE_VER, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LON2, TNS_DATA_TYPE_LON2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INO2, TNS_DATA_TYPE_INO2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ALL, TNS_DATA_TYPE_ALL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UDB, TNS_DATA_TYPE_UDB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQI, TNS_DATA_TYPE_AQI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ULB, TNS_DATA_TYPE_ULB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ULD, TNS_DATA_TYPE_ULD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SID, TNS_DATA_TYPE_SID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NA7, TNS_DATA_TYPE_NA7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AL7, TNS_DATA_TYPE_AL7, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_K2RPC, TNS_DATA_TYPE_K2RPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XDP, TNS_DATA_TYPE_XDP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKO8, TNS_DATA_TYPE_OKO8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UD12, TNS_DATA_TYPE_UD12, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AL8, TNS_DATA_TYPE_AL8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LFOP, TNS_DATA_TYPE_LFOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FCRT, TNS_DATA_TYPE_FCRT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DNY, TNS_DATA_TYPE_DNY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OPR, TNS_DATA_TYPE_OPR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PLS, TNS_DATA_TYPE_PLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XID, TNS_DATA_TYPE_XID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TXN, TNS_DATA_TYPE_TXN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DCB, TNS_DATA_TYPE_DCB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CCA, TNS_DATA_TYPE_CCA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_WRN, TNS_DATA_TYPE_WRN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TLH, TNS_DATA_TYPE_TLH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TOH, TNS_DATA_TYPE_TOH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FOI, TNS_DATA_TYPE_FOI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SID2, TNS_DATA_TYPE_SID2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TCH, TNS_DATA_TYPE_TCH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PII, TNS_DATA_TYPE_PII, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PFI, TNS_DATA_TYPE_PFI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PPU, TNS_DATA_TYPE_PPU, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PTE, TNS_DATA_TYPE_PTE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH8, TNS_DATA_TYPE_RXH8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_N12, TNS_DATA_TYPE_N12, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AUTH, TNS_DATA_TYPE_AUTH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVAL, TNS_DATA_TYPE_KVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FGI, TNS_DATA_TYPE_FGI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSY, TNS_DATA_TYPE_DSY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYR8, TNS_DATA_TYPE_DSYR8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYH8, TNS_DATA_TYPE_DSYH8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYL, TNS_DATA_TYPE_DSYL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYT8, TNS_DATA_TYPE_DSYT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYV8, TNS_DATA_TYPE_DSYV8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYP, TNS_DATA_TYPE_DSYP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYF, TNS_DATA_TYPE_DSYF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYK, TNS_DATA_TYPE_DSYK, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYY, TNS_DATA_TYPE_DSYY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYQ, TNS_DATA_TYPE_DSYQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYC, TNS_DATA_TYPE_DSYC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYA, TNS_DATA_TYPE_DSYA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OT8, TNS_DATA_TYPE_OT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYTY, TNS_DATA_TYPE_DSYTY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQE, TNS_DATA_TYPE_AQE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KV, TNS_DATA_TYPE_KV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQD, TNS_DATA_TYPE_AQD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQ8, TNS_DATA_TYPE_AQ8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RFS, TNS_DATA_TYPE_RFS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH10, TNS_DATA_TYPE_RXH10, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPN, TNS_DATA_TYPE_KPN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNR, TNS_DATA_TYPE_KPDNR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYD, TNS_DATA_TYPE_DSYD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYS, TNS_DATA_TYPE_DSYS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYR, TNS_DATA_TYPE_DSYR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYH, TNS_DATA_TYPE_DSYH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYT, TNS_DATA_TYPE_DSYT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DSYV, TNS_DATA_TYPE_DSYV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQM, TNS_DATA_TYPE_AQM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER11, TNS_DATA_TYPE_OER11, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQL, TNS_DATA_TYPE_AQL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OTC, TNS_DATA_TYPE_OTC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KFNO, TNS_DATA_TYPE_KFNO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KFNP, TNS_DATA_TYPE_KFNP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KGT8, TNS_DATA_TYPE_KGT8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RASB4, TNS_DATA_TYPE_RASB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RAUB2, TNS_DATA_TYPE_RAUB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RAUB1, TNS_DATA_TYPE_RAUB1, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RATXT, TNS_DATA_TYPE_RATXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSSB4, TNS_DATA_TYPE_RSSB4, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSUB2, TNS_DATA_TYPE_RSUB2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSUB1, TNS_DATA_TYPE_RSUB1, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSTXT, TNS_DATA_TYPE_RSTXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RIDL, TNS_DATA_TYPE_RIDL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDD, TNS_DATA_TYPE_GLRDD, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDG, TNS_DATA_TYPE_GLRDG, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_GLRDC, TNS_DATA_TYPE_GLRDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKO, TNS_DATA_TYPE_OKO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPP, TNS_DATA_TYPE_DPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPLS, TNS_DATA_TYPE_DPLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPMOP, TNS_DATA_TYPE_DPMOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_STAT, TNS_DATA_TYPE_STAT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RFX, TNS_DATA_TYPE_RFX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FAL, TNS_DATA_TYPE_FAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CKV, TNS_DATA_TYPE_CKV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DRCX, TNS_DATA_TYPE_DRCX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KGH, TNS_DATA_TYPE_KGH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQO, TNS_DATA_TYPE_AQO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OKGT, TNS_DATA_TYPE_OKGT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPFC, TNS_DATA_TYPE_KPFC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_FE2, TNS_DATA_TYPE_FE2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SPFP, TNS_DATA_TYPE_SPFP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DPULS, TNS_DATA_TYPE_DPULS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQA, TNS_DATA_TYPE_AQA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPBF, TNS_DATA_TYPE_KPBF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TSM, TNS_DATA_TYPE_TSM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_MSS, TNS_DATA_TYPE_MSS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPC, TNS_DATA_TYPE_KPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CRS, TNS_DATA_TYPE_CRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KKS, TNS_DATA_TYPE_KKS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSP, TNS_DATA_TYPE_KSP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSPTOP, TNS_DATA_TYPE_KSPTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSPVAL, TNS_DATA_TYPE_KSPVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PSS, TNS_DATA_TYPE_PSS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_NLS, TNS_DATA_TYPE_NLS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ALS, TNS_DATA_TYPE_ALS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSDEVTVAL, TNS_DATA_TYPE_KSDEVTVAL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSDEVTTOP, TNS_DATA_TYPE_KSDEVTTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPSPP, TNS_DATA_TYPE_KPSPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KOL, TNS_DATA_TYPE_KOL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LST, TNS_DATA_TYPE_LST, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ACX, TNS_DATA_TYPE_ACX, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCS, TNS_DATA_TYPE_SCS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RXH, TNS_DATA_TYPE_RXH, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNS, TNS_DATA_TYPE_KPDNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDCN, TNS_DATA_TYPE_KPDCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNNS, TNS_DATA_TYPE_KPNNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNCN, TNS_DATA_TYPE_KPNCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPS, TNS_DATA_TYPE_KPS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_APINF, TNS_DATA_TYPE_APINF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TEN, TNS_DATA_TYPE_TEN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSCS, TNS_DATA_TYPE_XSSCS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSSO, TNS_DATA_TYPE_XSSSO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSAO, TNS_DATA_TYPE_XSSAO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KSRPC, TNS_DATA_TYPE_KSRPC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVL, TNS_DATA_TYPE_KVL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSDEF, TNS_DATA_TYPE_XSSDEF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PDQCINV, TNS_DATA_TYPE_PDQCINV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PDQIDC, TNS_DATA_TYPE_PDQIDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDQCSTA, TNS_DATA_TYPE_KPDQCSTA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPRS, TNS_DATA_TYPE_KPRS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDQIDC, TNS_DATA_TYPE_KPDQIDC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RTSTRM, TNS_DATA_TYPE_RTSTRM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSGET, TNS_DATA_TYPE_SESSGET, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSREL, TNS_DATA_TYPE_SESSREL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSRET, TNS_DATA_TYPE_SESSRET, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN6, TNS_DATA_TYPE_SCN6, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KECPA, TNS_DATA_TYPE_KECPA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KECPP, TNS_DATA_TYPE_KECPP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SXA, TNS_DATA_TYPE_SXA, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KVARR, TNS_DATA_TYPE_KVARR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNGN, TNS_DATA_TYPE_KPNGN, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BINARY_INTEGER, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_FLOAT, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_STR, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VNU, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_PDN, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_VCS, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_VBI, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OAC9, TNS_DATA_TYPE_OAC9, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UIN, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_SLS, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_LVC, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_LVB, ORA_TYPE_NUM_RAW, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_CHAR, ORA_TYPE_NUM_CHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AVC, ORA_TYPE_NUM_CHAR, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BINARY_FLOAT, ORA_TYPE_NUM_BINARY_FLOAT,
            TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BINARY_DOUBLE, ORA_TYPE_NUM_BINARY_DOUBLE,
            TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_CURSOR, ORA_TYPE_NUM_CURSOR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RDD, ORA_TYPE_NUM_ROWID, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OSL, TNS_DATA_TYPE_OSL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXT_NAMED, ORA_TYPE_NUM_OBJECT, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_OBJECT, ORA_TYPE_NUM_OBJECT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EXT_REF, TNS_DATA_TYPE_INT_REF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_INT_REF, TNS_DATA_TYPE_INT_REF, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_CLOB, ORA_TYPE_NUM_CLOB, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BLOB, ORA_TYPE_NUM_BLOB, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BFILE, ORA_TYPE_NUM_BFILE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CFILE, TNS_DATA_TYPE_CFILE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_RSET, ORA_TYPE_NUM_CURSOR, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_JSON, ORA_TYPE_NUM_JSON, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DJSON, TNS_DATA_TYPE_DJSON, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CLV, TNS_DATA_TYPE_CLV, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DTR, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DUN, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DOP, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_VST, ORA_TYPE_NUM_VARCHAR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ODT, ORA_TYPE_NUM_DATE, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_DOL, ORA_TYPE_NUM_NUMBER, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_TIME, TNS_DATA_TYPE_TIME, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TIME_TZ, TNS_DATA_TYPE_TIME_TZ, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_TIMESTAMP, ORA_TYPE_NUM_TIMESTAMP, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_TIMESTAMP_TZ, ORA_TYPE_NUM_TIMESTAMP_TZ,
            TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_INTERVAL_YM, ORA_TYPE_NUM_INTERVAL_YM,
            TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_INTERVAL_DS, ORA_TYPE_NUM_INTERVAL_DS,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EDATE, ORA_TYPE_NUM_DATE, TNS_TYPE_REP_ORACLE],
    [TNS_DATA_TYPE_ETIME, TNS_DATA_TYPE_ETIME, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ETTZ, TNS_DATA_TYPE_ETTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESTAMP, TNS_DATA_TYPE_ESTAMP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESTZ, TNS_DATA_TYPE_ESTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EIYM, TNS_DATA_TYPE_EIYM, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_EIDS, TNS_DATA_TYPE_EIDS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DCLOB, ORA_TYPE_NUM_CLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DBLOB, ORA_TYPE_NUM_BLOB, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_DBFILE, ORA_TYPE_NUM_BFILE, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_UROWID, ORA_TYPE_NUM_UROWID, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_TIMESTAMP_LTZ, ORA_TYPE_NUM_TIMESTAMP_LTZ,
            TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_ESITZ, ORA_TYPE_NUM_TIMESTAMP_LTZ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB8, TNS_DATA_TYPE_UB8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PNTY, ORA_TYPE_NUM_OBJECT, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_BOOLEAN, ORA_TYPE_NUM_BOOLEAN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNSOP, TNS_DATA_TYPE_XSNSOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSATTR, TNS_DATA_TYPE_XSATTR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNS, TNS_DATA_TYPE_XSNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UB1ARRAY, TNS_DATA_TYPE_UB1ARRAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSSTATE, TNS_DATA_TYPE_SESSSTATE, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AC_REPLAY, TNS_DATA_TYPE_AC_REPLAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AC_CONT, TNS_DATA_TYPE_AC_CONT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_IMPLRES, TNS_DATA_TYPE_IMPLRES, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER19, TNS_DATA_TYPE_OER19, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TXT, TNS_DATA_TYPE_TXT, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSESSNS, TNS_DATA_TYPE_XSSESSNS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSATTOP, TNS_DATA_TYPE_XSATTOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSCREOP, TNS_DATA_TYPE_XSCREOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSDETOP, TNS_DATA_TYPE_XSDETOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSDESOP, TNS_DATA_TYPE_XSDESOP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSETSP, TNS_DATA_TYPE_XSSETSP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSIDP, TNS_DATA_TYPE_XSSIDP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSPRIN, TNS_DATA_TYPE_XSPRIN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSKVL, TNS_DATA_TYPE_XSKVL, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSSSDEF2, TNS_DATA_TYPE_XSSSDEF2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNSOP2, TNS_DATA_TYPE_XSNSOP2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_XSNS2, TNS_DATA_TYPE_XSNS2, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNREQ, TNS_DATA_TYPE_KPDNREQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRNF, TNS_DATA_TYPE_KPDNRNF, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNGNC, TNS_DATA_TYPE_KPNGNC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPNRI, TNS_DATA_TYPE_KPNRI, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQENQ, TNS_DATA_TYPE_AQENQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQDEQ, TNS_DATA_TYPE_AQDEQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_AQJMS, TNS_DATA_TYPE_AQJMS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRPAY, TNS_DATA_TYPE_KPDNRPAY, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRACK, TNS_DATA_TYPE_KPDNRACK, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRMP, TNS_DATA_TYPE_KPDNRMP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_KPDNRDQ, TNS_DATA_TYPE_KPDNRDQ, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN, TNS_DATA_TYPE_SCN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SCN8, TNS_DATA_TYPE_SCN8, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_CHUNKINFO, TNS_DATA_TYPE_CHUNKINFO, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UD21, TNS_DATA_TYPE_UD21, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_UDS, TNS_DATA_TYPE_UDS, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_TNP, TNS_DATA_TYPE_TNP, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OER, TNS_DATA_TYPE_OER, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_OAC, TNS_DATA_TYPE_OAC, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_SESSSIGN, TNS_DATA_TYPE_SESSSIGN, TNS_TYPE_REP_UNIVERSAL],
    [ORA_TYPE_NUM_VECTOR, ORA_TYPE_NUM_VECTOR, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PLEND, TNS_DATA_TYPE_PLEND, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PLBGN, TNS_DATA_TYPE_PLBGN, TNS_TYPE_REP_UNIVERSAL],
    [TNS_DATA_TYPE_PLOP, TNS_DATA_TYPE_PLOP, TNS_TYPE_REP_UNIVERSAL],
    [0, 0, 0]
]


@cython.final
cdef class DataTypesMessage(Message):

    cdef int _process_message(self, ReadBuffer buf,
                              uint8_t message_type) except -1:
        cdef uint16_t data_type, conv_data_type
        while True:
            buf.read_uint16be(&data_type)
            if data_type == 0:
                break
            buf.read_uint16be(&conv_data_type)
            if conv_data_type != 0:
                buf.skip_raw_bytes(4)
        if not buf._caps.supports_end_of_response:
            self.end_of_response = True

    cdef int _write_message(self, WriteBuffer buf) except -1:
        cdef:
            DataType* data_type
            int i

        # write character set and capabilities
        buf.write_uint8(TNS_MSG_TYPE_DATA_TYPES)
        buf.write_uint16le(TNS_CHARSET_UTF8)
        buf.write_uint16le(TNS_CHARSET_UTF8)
        buf.write_uint8(TNS_ENCODING_MULTI_BYTE | TNS_ENCODING_CONV_LENGTH)
        buf.write_bytes_with_length(bytes(buf._caps.compile_caps))
        buf.write_bytes_with_length(bytes(buf._caps.runtime_caps))

        # write data types
        i = 0
        while True:
            data_type = &DATA_TYPES[i]
            if data_type.data_type == 0:
                break
            i += 1
            buf.write_uint16be(data_type.data_type)
            buf.write_uint16be(data_type.conv_data_type)
            buf.write_uint16be(data_type.representation)
            buf.write_uint16be(0)
        buf.write_uint16be(0)
