#------------------------------------------------------------------------------
# Copyright (c) 2024, 2025, Oracle and/or its affiliates.
#
# This software is dual-licensed to you under the Universal Permissive License
# (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl and Apache License
# 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose
# either license.
#
# If you elect to accept the software under the Apache License, Version 2.0,
# the following applies:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# pipeline.pyx
#
# Cython file defining the PipelineImpl, PipelineOpImpl and
# PipelineOpResultImpl classes (embedded in base_impl.pyx).
#------------------------------------------------------------------------------

cdef class PipelineImpl:

    def __init__(self):
        self.operations = []


cdef class PipelineOpImpl:

    def __init__(
        self,
        uint8_t op_type,
        str statement = None,
        str name = None,
        object parameters = None,
        object keyword_parameters = None,
        object return_type = None,
        object rowfactory = None,
        uint32_t arraysize = 0,
        uint32_t num_rows = 0,
        object fetch_lobs = None,
        object fetch_decimals = None,
    ):
        self.op_type = op_type
        self.statement = statement
        self.name = name
        self.parameters = parameters
        self.keyword_parameters = keyword_parameters
        self.return_type = return_type
        self.rowfactory = rowfactory
        self.arraysize = arraysize
        self.num_rows = num_rows
        if fetch_lobs is None:
            self.fetch_lobs = C_DEFAULTS.fetch_lobs
        else:
            self.fetch_lobs = fetch_lobs
        if fetch_decimals is None:
            self.fetch_decimals = C_DEFAULTS.fetch_decimals
        else:
            self.fetch_decimals = fetch_decimals


cdef class PipelineOpResultImpl:

    def __init__(self, PipelineOpImpl op):
        self.operation = op

    cdef int _capture_err(self, Exception exc) except -1:
        """
        Captures the error in the result. If the error is not an error
        generated by the driver itself, wrap it so that the value in the error
        attribute is always an instance of the _Error class.
        """
        if isinstance(exc, exceptions.Error):
            self.error = exc.args[0]
        else:
            self.error = errors._create_err(
                errors.ERR_UNEXPECTED_PIPELINE_FAILURE, cause=exc
            )
