This crate is a Rust Kubernetes API client. It contains bindings for the resources in the Kubernetes client API, auto-generated from the OpenAPI spec.

[crates.io](https://crates.io/crates/k8s-openapi)

[Documentation](https://arnavion.github.io/k8s-openapi/)

[Changelog](https://github.com/Arnavion/k8s-openapi/blob/master/CHANGELOG.md)


This crate is *not* generated using Swagger or the OpenAPI Generator directly, as clients generated by [the common client generator](https://github.com/kubernetes-client/gen) are. This gives this crate a few important advantages.


### Works around bugs in the upstream OpenAPI spec

The upstream OpenAPI spec is not written by hand; it's itself generated from the API server's Go code. As such, the spec makes mistakes when trying to convert the representations of Go types to OpenAPI, such as incorrectly representing the `JSON` type used in CRD validation, and incorrectly representing the type of objects inside a `WatchEvent`. A client generated naively from the spec inherits all these mistakes, and it is hard for such a client to fix them in "post".

Since this crate uses a custom code generator, it is able to work around these mistakes and emit correct bindings. See the list of fixes [here](https://github.com/Arnavion/k8s-openapi/blob/master/k8s-openapi-codegen/src/fixups/upstream_bugs.rs) and the breakdown of fixes applied to each Kubernetes version [here.](https://github.com/Arnavion/k8s-openapi/blob/master/k8s-openapi-codegen/src/supported_version.rs)


### Supports more versions of Kubernetes

Official clients tend to support only the three latest versions of Kubernetes. This crate supports a few more.

As mentioned above, the upstream OpenAPI spec contains mistakes. When upstream fixes these mistakes, it usually does not backport them to older versions (not even to *supported* older versions). This crate does backport those fixes if they're applicable.


# License

```
k8s-openapi

https://github.com/Arnavion/k8s-openapi

Copyright 2018 Arnav Singh

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

The OpenAPI spec that these bindings are generated from is sourced from the
Kubernetes repository https://github.com/kubernetes/kubernetes which also uses
the Apache-2.0 license.
