// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Container for Payer.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct RequestPaymentConfiguration {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub payer: crate::types::Payer,
}
impl RequestPaymentConfiguration {
    /// <p>Specifies who pays for the download and request fees.</p>
    pub fn payer(&self) -> &crate::types::Payer {
        &self.payer
    }
}
impl RequestPaymentConfiguration {
    /// Creates a new builder-style object to manufacture [`RequestPaymentConfiguration`](crate::types::RequestPaymentConfiguration).
    pub fn builder() -> crate::types::builders::RequestPaymentConfigurationBuilder {
        crate::types::builders::RequestPaymentConfigurationBuilder::default()
    }
}

/// A builder for [`RequestPaymentConfiguration`](crate::types::RequestPaymentConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct RequestPaymentConfigurationBuilder {
    pub(crate) payer: ::std::option::Option<crate::types::Payer>,
}
impl RequestPaymentConfigurationBuilder {
    /// <p>Specifies who pays for the download and request fees.</p>
    /// This field is required.
    pub fn payer(mut self, input: crate::types::Payer) -> Self {
        self.payer = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies who pays for the download and request fees.</p>
    pub fn set_payer(mut self, input: ::std::option::Option<crate::types::Payer>) -> Self {
        self.payer = input;
        self
    }
    /// <p>Specifies who pays for the download and request fees.</p>
    pub fn get_payer(&self) -> &::std::option::Option<crate::types::Payer> {
        &self.payer
    }
    /// Consumes the builder and constructs a [`RequestPaymentConfiguration`](crate::types::RequestPaymentConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`payer`](crate::types::builders::RequestPaymentConfigurationBuilder::payer)
    pub fn build(self) -> ::std::result::Result<crate::types::RequestPaymentConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::RequestPaymentConfiguration {
            payer: self.payer.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "payer",
                    "payer was not specified but it is required when building RequestPaymentConfiguration",
                )
            })?,
        })
    }
}
