// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>If an S3 Metadata V1 <code>CreateBucketMetadataTableConfiguration</code> or V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code and error message.</p><note>
/// <p>If you created your S3 Metadata configuration before July 15, 2025, we recommend that you delete and re-create your configuration by using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataConfiguration.html">CreateBucketMetadataConfiguration</a> so that you can expire journal table records and create a live inventory table.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ErrorDetails {
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub error_code: ::std::option::Option<::std::string::String>,
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error message. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub error_message: ::std::option::Option<::std::string::String>,
}
impl ErrorDetails {
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn error_code(&self) -> ::std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error message. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn error_message(&self) -> ::std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl ErrorDetails {
    /// Creates a new builder-style object to manufacture [`ErrorDetails`](crate::types::ErrorDetails).
    pub fn builder() -> crate::types::builders::ErrorDetailsBuilder {
        crate::types::builders::ErrorDetailsBuilder::default()
    }
}

/// A builder for [`ErrorDetails`](crate::types::ErrorDetails).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ErrorDetailsBuilder {
    pub(crate) error_code: ::std::option::Option<::std::string::String>,
    pub(crate) error_message: ::std::option::Option<::std::string::String>,
}
impl ErrorDetailsBuilder {
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn set_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_code = input;
        self
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn get_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_code
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error message. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error message. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn set_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_message = input;
        self
    }
    /// <p>If the V1 <code>CreateBucketMetadataTableConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error message. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code> and <code>s3tables:PutTablePolicy</code> permissions, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableAlreadyExists</code> - The table that you specified already exists in the table bucket's namespace. Specify a different table name. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>TableBucketNotFound</code> - The table bucket that you specified doesn't exist in this Amazon Web Services Region and account. Create or choose a different table bucket. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// </ul>
    /// <p>If the V2 <code>CreateBucketMetadataConfiguration</code> request succeeds, but S3 Metadata was unable to create the table, this structure contains the error code. The possible error codes and error messages are as follows:</p>
    /// <ul>
    /// <li>
    /// <p><code>AccessDeniedCreatingResources</code> - You don't have sufficient permissions to create the required resources. Make sure that you have <code>s3tables:CreateTableBucket</code>, <code>s3tables:CreateNamespace</code>, <code>s3tables:CreateTable</code>, <code>s3tables:GetTable</code>, <code>s3tables:PutTablePolicy</code>, <code>kms:DescribeKey</code>, and <code>s3tables:PutTableEncryption</code> permissions. Additionally, ensure that the KMS key used to encrypt the table still exists, is active and has a resource policy granting access to the S3 service principals '<code>maintenance.s3tables.amazonaws.com</code>' and '<code>metadata.s3.amazonaws.com</code>'. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>AccessDeniedWritingToTable</code> - Unable to write to the metadata table because of missing resource permissions. To fix the resource policy, Amazon S3 needs to create a new metadata table. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>DestinationTableNotFound</code> - The destination table doesn't exist. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>ServerInternalError</code> - An internal error has occurred. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableAlreadyExists</code> - A journal table already exists in the Amazon Web Services managed table bucket's namespace. Delete the journal table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>InventoryTableAlreadyExists</code> - An inventory table already exists in the Amazon Web Services managed table bucket's namespace. Delete the inventory table, and then try again. To create a new metadata table, you must delete the metadata configuration for this bucket, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>JournalTableNotAvailable</code> - The journal table that the inventory table relies on has a <code>FAILED</code> status. An inventory table requires a journal table with an <code>ACTIVE</code> status. To create a new journal or inventory table, you must delete the metadata configuration for this bucket, along with any journal or inventory tables, and then create a new metadata configuration.</p></li>
    /// <li>
    /// <p><code>NoSuchBucket</code> - The specified general purpose bucket does not exist.</p></li>
    /// </ul>
    pub fn get_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_message
    }
    /// Consumes the builder and constructs a [`ErrorDetails`](crate::types::ErrorDetails).
    pub fn build(self) -> crate::types::ErrorDetails {
        crate::types::ErrorDetails {
            error_code: self.error_code,
            error_message: self.error_message,
        }
    }
}
