// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.27.0
// source: queries.sql

package log

import (
	"context"
)

const deleteCollection = `-- name: DeleteCollection :exec
DELETE FROM collection c where c.id = ANY($1::text[])
`

func (q *Queries) DeleteCollection(ctx context.Context, collectionIds []string) error {
	_, err := q.db.Exec(ctx, deleteCollection, collectionIds)
	return err
}

const deleteRecords = `-- name: DeleteRecords :exec
DELETE FROM record_log r where r.collection_id = ANY($1::text[])
`

func (q *Queries) DeleteRecords(ctx context.Context, collectionIds []string) error {
	_, err := q.db.Exec(ctx, deleteRecords, collectionIds)
	return err
}

const getAllCollections = `-- name: GetAllCollections :many
SELECT id FROM collection
`

func (q *Queries) GetAllCollections(ctx context.Context) ([]string, error) {
	rows, err := q.db.Query(ctx, getAllCollections)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []string
	for rows.Next() {
		var id string
		if err := rows.Scan(&id); err != nil {
			return nil, err
		}
		items = append(items, id)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getAllCollectionsToCompact = `-- name: GetAllCollectionsToCompact :many
with summary as (
    select r.collection_id, r.offset, r.timestamp, row_number() over(partition by r.collection_id order by r.offset) as rank
    from record_log r, collection c
    where r.collection_id = c.id
    and (c.record_enumeration_offset_position - c.record_compaction_offset_position) >= $1
    and r.offset > c.record_compaction_offset_position
)
select collection_id, "offset", timestamp, rank from summary
where rank=1
order by timestamp
`

type GetAllCollectionsToCompactRow struct {
	CollectionID string
	Offset       int64
	Timestamp    int64
	Rank         int64
}

func (q *Queries) GetAllCollectionsToCompact(ctx context.Context, minCompactionSize int64) ([]GetAllCollectionsToCompactRow, error) {
	rows, err := q.db.Query(ctx, getAllCollectionsToCompact, minCompactionSize)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []GetAllCollectionsToCompactRow
	for rows.Next() {
		var i GetAllCollectionsToCompactRow
		if err := rows.Scan(
			&i.CollectionID,
			&i.Offset,
			&i.Timestamp,
			&i.Rank,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getCollectionForUpdate = `-- name: GetCollectionForUpdate :one
SELECT id, record_compaction_offset_position, record_enumeration_offset_position
FROM collection
WHERE id = $1
FOR UPDATE
`

func (q *Queries) GetCollectionForUpdate(ctx context.Context, id string) (Collection, error) {
	row := q.db.QueryRow(ctx, getCollectionForUpdate, id)
	var i Collection
	err := row.Scan(&i.ID, &i.RecordCompactionOffsetPosition, &i.RecordEnumerationOffsetPosition)
	return i, err
}

const getLastCompactedOffset = `-- name: GetLastCompactedOffset :one
SELECT record_compaction_offset_position FROM collection c WHERE c.id = $1
`

func (q *Queries) GetLastCompactedOffset(ctx context.Context, id string) (int64, error) {
	row := q.db.QueryRow(ctx, getLastCompactedOffset, id)
	var record_compaction_offset_position int64
	err := row.Scan(&record_compaction_offset_position)
	return record_compaction_offset_position, err
}

const getRecordsForCollection = `-- name: GetRecordsForCollection :many
SELECT "offset", collection_id, timestamp, record FROM record_log r WHERE r.collection_id = $1 AND r.offset >= $2 and r.timestamp <= $4  ORDER BY r.offset ASC limit $3
`

type GetRecordsForCollectionParams struct {
	CollectionID string
	Offset       int64
	Limit        int32
	Timestamp    int64
}

func (q *Queries) GetRecordsForCollection(ctx context.Context, arg GetRecordsForCollectionParams) ([]RecordLog, error) {
	rows, err := q.db.Query(ctx, getRecordsForCollection,
		arg.CollectionID,
		arg.Offset,
		arg.Limit,
		arg.Timestamp,
	)
	if err != nil {
		return nil, err
	}
	defer rows.Close()
	var items []RecordLog
	for rows.Next() {
		var i RecordLog
		if err := rows.Scan(
			&i.Offset,
			&i.CollectionID,
			&i.Timestamp,
			&i.Record,
		); err != nil {
			return nil, err
		}
		items = append(items, i)
	}
	if err := rows.Err(); err != nil {
		return nil, err
	}
	return items, nil
}

const getTotalUncompactedRecordsCount = `-- name: GetTotalUncompactedRecordsCount :one
SELECT CAST(COALESCE(SUM(record_enumeration_offset_position - record_compaction_offset_position), 0) AS bigint) AS total_uncompacted_depth FROM collection
`

func (q *Queries) GetTotalUncompactedRecordsCount(ctx context.Context) (int64, error) {
	row := q.db.QueryRow(ctx, getTotalUncompactedRecordsCount)
	var total_uncompacted_depth int64
	err := row.Scan(&total_uncompacted_depth)
	return total_uncompacted_depth, err
}

const insertCollection = `-- name: InsertCollection :one
INSERT INTO collection (id, record_enumeration_offset_position, record_compaction_offset_position) values($1, $2, $3) returning id, record_compaction_offset_position, record_enumeration_offset_position
`

type InsertCollectionParams struct {
	ID                              string
	RecordEnumerationOffsetPosition int64
	RecordCompactionOffsetPosition  int64
}

func (q *Queries) InsertCollection(ctx context.Context, arg InsertCollectionParams) (Collection, error) {
	row := q.db.QueryRow(ctx, insertCollection, arg.ID, arg.RecordEnumerationOffsetPosition, arg.RecordCompactionOffsetPosition)
	var i Collection
	err := row.Scan(&i.ID, &i.RecordCompactionOffsetPosition, &i.RecordEnumerationOffsetPosition)
	return i, err
}

type InsertRecordParams struct {
	CollectionID string
	Offset       int64
	Record       []byte
	Timestamp    int64
}

const purgeRecords = `-- name: PurgeRecords :exec
DELETE FROM record_log r using collection c where r.collection_id = c.id and r.offset <= c.record_compaction_offset_position
`

func (q *Queries) PurgeRecords(ctx context.Context) error {
	_, err := q.db.Exec(ctx, purgeRecords)
	return err
}

const updateCollectionCompactionOffsetPosition = `-- name: UpdateCollectionCompactionOffsetPosition :exec
UPDATE collection set record_compaction_offset_position = $2 where id = $1
`

type UpdateCollectionCompactionOffsetPositionParams struct {
	ID                             string
	RecordCompactionOffsetPosition int64
}

func (q *Queries) UpdateCollectionCompactionOffsetPosition(ctx context.Context, arg UpdateCollectionCompactionOffsetPositionParams) error {
	_, err := q.db.Exec(ctx, updateCollectionCompactionOffsetPosition, arg.ID, arg.RecordCompactionOffsetPosition)
	return err
}

const updateCollectionEnumerationOffsetPosition = `-- name: UpdateCollectionEnumerationOffsetPosition :exec
UPDATE collection set record_enumeration_offset_position = $2 where id = $1
`

type UpdateCollectionEnumerationOffsetPositionParams struct {
	ID                              string
	RecordEnumerationOffsetPosition int64
}

func (q *Queries) UpdateCollectionEnumerationOffsetPosition(ctx context.Context, arg UpdateCollectionEnumerationOffsetPositionParams) error {
	_, err := q.db.Exec(ctx, updateCollectionEnumerationOffsetPosition, arg.ID, arg.RecordEnumerationOffsetPosition)
	return err
}
