; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt -passes=inline -preserve-alignment-assumptions-during-inlining -S < %s | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

; Test behavior of inserted alignment assumptions with byval. No
; assume should be inserted.
define void @byval_callee(ptr byval(float) align 128 nocapture %a, ptr %b) #0 {
; CHECK-LABEL: define {{[^@]+}}@byval_callee
; CHECK-SAME: (ptr nocapture byval(float) align 128 [[A:%.*]], ptr [[B:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD:%.*]] = load float, ptr [[A]], align 4
; CHECK-NEXT:    [[B_IDX:%.*]] = getelementptr inbounds float, ptr [[B]], i64 8
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[LOAD]], 2.000000e+00
; CHECK-NEXT:    store float [[ADD]], ptr [[B_IDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %load = load float, ptr %a, align 4
  %b.idx = getelementptr inbounds float, ptr %b, i64 8
  %add = fadd float %load, 2.0
  store float %add, ptr %b.idx, align 4
  ret void
}

define void @byval_caller(ptr nocapture align 64 %a, ptr %b) #0 {
; CHECK-LABEL: define {{[^@]+}}@byval_caller
; CHECK-SAME: (ptr nocapture align 64 [[A:%.*]], ptr [[B:%.*]]) #0
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A1:%.*]] = alloca float, align 128
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr [[A1]])
; CHECK-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[A1]], ptr align 1 [[A]], i64 4, i1 false)
; CHECK-NEXT:    [[LOAD_I:%.*]] = load float, ptr [[A1]], align 4
; CHECK-NEXT:    [[B_IDX_I:%.*]] = getelementptr inbounds float, ptr [[B]], i64 8
; CHECK-NEXT:    [[ADD_I:%.*]] = fadd float [[LOAD_I]], 2.000000e+00
; CHECK-NEXT:    store float [[ADD_I]], ptr [[B_IDX_I]], align 4
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 4, ptr [[A1]])
; CHECK-NEXT:    [[CALLER_LOAD:%.*]] = load float, ptr [[B]], align 4
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[A]], i64 7
; CHECK-NEXT:    store float [[CALLER_LOAD]], ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    ret void
;
entry:
  call void @byval_callee(ptr byval(float) align 128 %a, ptr %b)
  %caller.load = load float, ptr %b, align 4
  %arrayidx = getelementptr inbounds float, ptr %a, i64 7
  store float %caller.load, ptr %arrayidx, align 4
  ret void
}

attributes #0 = { nounwind uwtable }
