// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: raft_serverpb.proto

package raft_serverpb

import (
	"fmt"
	"io"
	"math"
	math_bits "math/bits"

	proto "github.com/golang/protobuf/proto"
	disk_usage "github.com/pingcap/kvproto/pkg/disk_usage"
	eraftpb "github.com/pingcap/kvproto/pkg/eraftpb"
	kvrpcpb "github.com/pingcap/kvproto/pkg/kvrpcpb"
	metapb "github.com/pingcap/kvproto/pkg/metapb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PeerState int32

const (
	PeerState_Normal    PeerState = 0
	PeerState_Applying  PeerState = 1
	PeerState_Tombstone PeerState = 2
	PeerState_Merging   PeerState = 3
	// Currently used for witness to non-witness conversion: When a witness
	// has just become a non-witness, we need to set and persist this state,
	// so that when the service restarts before applying snapshot, we can
	// actively request snapshot when initializing this peer.
	PeerState_Unavailable PeerState = 4
)

var PeerState_name = map[int32]string{
	0: "Normal",
	1: "Applying",
	2: "Tombstone",
	3: "Merging",
	4: "Unavailable",
}

var PeerState_value = map[string]int32{
	"Normal":      0,
	"Applying":    1,
	"Tombstone":   2,
	"Merging":     3,
	"Unavailable": 4,
}

func (x PeerState) String() string {
	return proto.EnumName(PeerState_name, int32(x))
}

func (PeerState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{0}
}

type ExtraMessageType int32

const (
	ExtraMessageType_MsgRegionWakeUp           ExtraMessageType = 0
	ExtraMessageType_MsgWantRollbackMerge      ExtraMessageType = 1
	ExtraMessageType_MsgCheckStalePeer         ExtraMessageType = 2
	ExtraMessageType_MsgCheckStalePeerResponse ExtraMessageType = 3
	// If leader is going to sleep, it will send requests to all its followers
	// to make sure they all agree to sleep.
	ExtraMessageType_MsgHibernateRequest                 ExtraMessageType = 4
	ExtraMessageType_MsgHibernateResponse                ExtraMessageType = 5
	ExtraMessageType_MsgRejectRaftLogCausedByMemoryUsage ExtraMessageType = 6
	ExtraMessageType_MsgAvailabilityRequest              ExtraMessageType = 7
	ExtraMessageType_MsgAvailabilityResponse             ExtraMessageType = 8
)

var ExtraMessageType_name = map[int32]string{
	0: "MsgRegionWakeUp",
	1: "MsgWantRollbackMerge",
	2: "MsgCheckStalePeer",
	3: "MsgCheckStalePeerResponse",
	4: "MsgHibernateRequest",
	5: "MsgHibernateResponse",
	6: "MsgRejectRaftLogCausedByMemoryUsage",
	7: "MsgAvailabilityRequest",
	8: "MsgAvailabilityResponse",
}

var ExtraMessageType_value = map[string]int32{
	"MsgRegionWakeUp":                     0,
	"MsgWantRollbackMerge":                1,
	"MsgCheckStalePeer":                   2,
	"MsgCheckStalePeerResponse":           3,
	"MsgHibernateRequest":                 4,
	"MsgHibernateResponse":                5,
	"MsgRejectRaftLogCausedByMemoryUsage": 6,
	"MsgAvailabilityRequest":              7,
	"MsgAvailabilityResponse":             8,
}

func (x ExtraMessageType) String() string {
	return proto.EnumName(ExtraMessageType_name, int32(x))
}

func (ExtraMessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{1}
}

type RaftMessage struct {
	RegionId    uint64              `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	FromPeer    *metapb.Peer        `protobuf:"bytes,2,opt,name=from_peer,json=fromPeer,proto3" json:"from_peer,omitempty"`
	ToPeer      *metapb.Peer        `protobuf:"bytes,3,opt,name=to_peer,json=toPeer,proto3" json:"to_peer,omitempty"`
	Message     *eraftpb.Message    `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	RegionEpoch *metapb.RegionEpoch `protobuf:"bytes,5,opt,name=region_epoch,json=regionEpoch,proto3" json:"region_epoch,omitempty"`
	// true means to_peer is a tombstone peer and it should remove itself.
	IsTombstone bool `protobuf:"varint,6,opt,name=is_tombstone,json=isTombstone,proto3" json:"is_tombstone,omitempty"`
	// Region key range [start_key, end_key).
	StartKey []byte `protobuf:"bytes,7,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte `protobuf:"bytes,8,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// If it has value, to_peer should be removed if merge is never going to complete.
	MergeTarget          *metapb.Region       `protobuf:"bytes,9,opt,name=merge_target,json=mergeTarget,proto3" json:"merge_target,omitempty"`
	ExtraMsg             *ExtraMessage        `protobuf:"bytes,10,opt,name=extra_msg,json=extraMsg,proto3" json:"extra_msg,omitempty"`
	ExtraCtx             []byte               `protobuf:"bytes,11,opt,name=extra_ctx,json=extraCtx,proto3" json:"extra_ctx,omitempty"`
	DiskUsage            disk_usage.DiskUsage `protobuf:"varint,12,opt,name=disk_usage,json=diskUsage,proto3,enum=disk_usage.DiskUsage" json:"disk_usage,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *RaftMessage) Reset()         { *m = RaftMessage{} }
func (m *RaftMessage) String() string { return proto.CompactTextString(m) }
func (*RaftMessage) ProtoMessage()    {}
func (*RaftMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{0}
}
func (m *RaftMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftMessage.Merge(m, src)
}
func (m *RaftMessage) XXX_Size() int {
	return m.Size()
}
func (m *RaftMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftMessage.DiscardUnknown(m)
}

var xxx_messageInfo_RaftMessage proto.InternalMessageInfo

func (m *RaftMessage) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *RaftMessage) GetFromPeer() *metapb.Peer {
	if m != nil {
		return m.FromPeer
	}
	return nil
}

func (m *RaftMessage) GetToPeer() *metapb.Peer {
	if m != nil {
		return m.ToPeer
	}
	return nil
}

func (m *RaftMessage) GetMessage() *eraftpb.Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *RaftMessage) GetRegionEpoch() *metapb.RegionEpoch {
	if m != nil {
		return m.RegionEpoch
	}
	return nil
}

func (m *RaftMessage) GetIsTombstone() bool {
	if m != nil {
		return m.IsTombstone
	}
	return false
}

func (m *RaftMessage) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RaftMessage) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RaftMessage) GetMergeTarget() *metapb.Region {
	if m != nil {
		return m.MergeTarget
	}
	return nil
}

func (m *RaftMessage) GetExtraMsg() *ExtraMessage {
	if m != nil {
		return m.ExtraMsg
	}
	return nil
}

func (m *RaftMessage) GetExtraCtx() []byte {
	if m != nil {
		return m.ExtraCtx
	}
	return nil
}

func (m *RaftMessage) GetDiskUsage() disk_usage.DiskUsage {
	if m != nil {
		return m.DiskUsage
	}
	return disk_usage.DiskUsage_Normal
}

type RaftTruncatedState struct {
	Index                uint64   `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Term                 uint64   `protobuf:"varint,2,opt,name=term,proto3" json:"term,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RaftTruncatedState) Reset()         { *m = RaftTruncatedState{} }
func (m *RaftTruncatedState) String() string { return proto.CompactTextString(m) }
func (*RaftTruncatedState) ProtoMessage()    {}
func (*RaftTruncatedState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{1}
}
func (m *RaftTruncatedState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftTruncatedState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftTruncatedState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftTruncatedState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftTruncatedState.Merge(m, src)
}
func (m *RaftTruncatedState) XXX_Size() int {
	return m.Size()
}
func (m *RaftTruncatedState) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftTruncatedState.DiscardUnknown(m)
}

var xxx_messageInfo_RaftTruncatedState proto.InternalMessageInfo

func (m *RaftTruncatedState) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *RaftTruncatedState) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

type SnapshotCFFile struct {
	Cf                   string   `protobuf:"bytes,1,opt,name=cf,proto3" json:"cf,omitempty"`
	Size_                uint64   `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	Checksum             uint32   `protobuf:"varint,3,opt,name=checksum,proto3" json:"checksum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotCFFile) Reset()         { *m = SnapshotCFFile{} }
func (m *SnapshotCFFile) String() string { return proto.CompactTextString(m) }
func (*SnapshotCFFile) ProtoMessage()    {}
func (*SnapshotCFFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{2}
}
func (m *SnapshotCFFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SnapshotCFFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SnapshotCFFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SnapshotCFFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotCFFile.Merge(m, src)
}
func (m *SnapshotCFFile) XXX_Size() int {
	return m.Size()
}
func (m *SnapshotCFFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotCFFile.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotCFFile proto.InternalMessageInfo

func (m *SnapshotCFFile) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *SnapshotCFFile) GetSize_() uint64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

func (m *SnapshotCFFile) GetChecksum() uint32 {
	if m != nil {
		return m.Checksum
	}
	return 0
}

type SnapshotMeta struct {
	CfFiles []*SnapshotCFFile `protobuf:"bytes,1,rep,name=cf_files,json=cfFiles,proto3" json:"cf_files,omitempty"`
	// true means this snapshot is triggered for load balance
	ForBalance bool `protobuf:"varint,2,opt,name=for_balance,json=forBalance,proto3" json:"for_balance,omitempty"`
	// true means this is an empty snapshot for witness
	ForWitness bool `protobuf:"varint,3,opt,name=for_witness,json=forWitness,proto3" json:"for_witness,omitempty"`
	// the timestamp second to generate snapshot
	Start uint64 `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	// the duration of generating snapshot
	GenerateDurationSec  uint64   `protobuf:"varint,5,opt,name=generate_duration_sec,json=generateDurationSec,proto3" json:"generate_duration_sec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotMeta) Reset()         { *m = SnapshotMeta{} }
func (m *SnapshotMeta) String() string { return proto.CompactTextString(m) }
func (*SnapshotMeta) ProtoMessage()    {}
func (*SnapshotMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{3}
}
func (m *SnapshotMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SnapshotMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SnapshotMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SnapshotMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotMeta.Merge(m, src)
}
func (m *SnapshotMeta) XXX_Size() int {
	return m.Size()
}
func (m *SnapshotMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotMeta.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotMeta proto.InternalMessageInfo

func (m *SnapshotMeta) GetCfFiles() []*SnapshotCFFile {
	if m != nil {
		return m.CfFiles
	}
	return nil
}

func (m *SnapshotMeta) GetForBalance() bool {
	if m != nil {
		return m.ForBalance
	}
	return false
}

func (m *SnapshotMeta) GetForWitness() bool {
	if m != nil {
		return m.ForWitness
	}
	return false
}

func (m *SnapshotMeta) GetStart() uint64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SnapshotMeta) GetGenerateDurationSec() uint64 {
	if m != nil {
		return m.GenerateDurationSec
	}
	return 0
}

type SnapshotChunk struct {
	Message              *RaftMessage `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	Data                 []byte       `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SnapshotChunk) Reset()         { *m = SnapshotChunk{} }
func (m *SnapshotChunk) String() string { return proto.CompactTextString(m) }
func (*SnapshotChunk) ProtoMessage()    {}
func (*SnapshotChunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{4}
}
func (m *SnapshotChunk) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SnapshotChunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SnapshotChunk.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SnapshotChunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotChunk.Merge(m, src)
}
func (m *SnapshotChunk) XXX_Size() int {
	return m.Size()
}
func (m *SnapshotChunk) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotChunk.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotChunk proto.InternalMessageInfo

func (m *SnapshotChunk) GetMessage() *RaftMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *SnapshotChunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type Done struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Done) Reset()         { *m = Done{} }
func (m *Done) String() string { return proto.CompactTextString(m) }
func (*Done) ProtoMessage()    {}
func (*Done) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{5}
}
func (m *Done) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Done) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Done.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Done) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Done.Merge(m, src)
}
func (m *Done) XXX_Size() int {
	return m.Size()
}
func (m *Done) XXX_DiscardUnknown() {
	xxx_messageInfo_Done.DiscardUnknown(m)
}

var xxx_messageInfo_Done proto.InternalMessageInfo

type KeyValue struct {
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyValue) Reset()         { *m = KeyValue{} }
func (m *KeyValue) String() string { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()    {}
func (*KeyValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{6}
}
func (m *KeyValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyValue.Merge(m, src)
}
func (m *KeyValue) XXX_Size() int {
	return m.Size()
}
func (m *KeyValue) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyValue.DiscardUnknown(m)
}

var xxx_messageInfo_KeyValue proto.InternalMessageInfo

func (m *KeyValue) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KeyValue) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type RaftSnapshotData struct {
	Region               *metapb.Region `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	FileSize             uint64         `protobuf:"varint,2,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	Data                 []*KeyValue    `protobuf:"bytes,3,rep,name=data,proto3" json:"data,omitempty"`
	Version              uint64         `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	Meta                 *SnapshotMeta  `protobuf:"bytes,5,opt,name=meta,proto3" json:"meta,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RaftSnapshotData) Reset()         { *m = RaftSnapshotData{} }
func (m *RaftSnapshotData) String() string { return proto.CompactTextString(m) }
func (*RaftSnapshotData) ProtoMessage()    {}
func (*RaftSnapshotData) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{7}
}
func (m *RaftSnapshotData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftSnapshotData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftSnapshotData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftSnapshotData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftSnapshotData.Merge(m, src)
}
func (m *RaftSnapshotData) XXX_Size() int {
	return m.Size()
}
func (m *RaftSnapshotData) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftSnapshotData.DiscardUnknown(m)
}

var xxx_messageInfo_RaftSnapshotData proto.InternalMessageInfo

func (m *RaftSnapshotData) GetRegion() *metapb.Region {
	if m != nil {
		return m.Region
	}
	return nil
}

func (m *RaftSnapshotData) GetFileSize() uint64 {
	if m != nil {
		return m.FileSize
	}
	return 0
}

func (m *RaftSnapshotData) GetData() []*KeyValue {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *RaftSnapshotData) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RaftSnapshotData) GetMeta() *SnapshotMeta {
	if m != nil {
		return m.Meta
	}
	return nil
}

type StoreIdent struct {
	ClusterId            uint64             `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StoreId              uint64             `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3" json:"store_id,omitempty"`
	ApiVersion           kvrpcpb.APIVersion `protobuf:"varint,3,opt,name=api_version,json=apiVersion,proto3,enum=kvrpcpb.APIVersion" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StoreIdent) Reset()         { *m = StoreIdent{} }
func (m *StoreIdent) String() string { return proto.CompactTextString(m) }
func (*StoreIdent) ProtoMessage()    {}
func (*StoreIdent) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{8}
}
func (m *StoreIdent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreIdent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreIdent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StoreIdent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreIdent.Merge(m, src)
}
func (m *StoreIdent) XXX_Size() int {
	return m.Size()
}
func (m *StoreIdent) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreIdent.DiscardUnknown(m)
}

var xxx_messageInfo_StoreIdent proto.InternalMessageInfo

func (m *StoreIdent) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *StoreIdent) GetStoreId() uint64 {
	if m != nil {
		return m.StoreId
	}
	return 0
}

func (m *StoreIdent) GetApiVersion() kvrpcpb.APIVersion {
	if m != nil {
		return m.ApiVersion
	}
	return kvrpcpb.APIVersion_V1
}

type StoreRecoverState struct {
	// Used for TiKV start recovery when WAL of KVDB was disabled.
	// TiKV may read all relations between seqno and raft log index, and replay
	// all raft logs which corresponding seqno smaller than the seqno here.
	// After TiKV replays all raft logs and flushed KV data, the seqno here must
	// be updated.
	Seqno                uint64   `protobuf:"varint,1,opt,name=seqno,proto3" json:"seqno,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StoreRecoverState) Reset()         { *m = StoreRecoverState{} }
func (m *StoreRecoverState) String() string { return proto.CompactTextString(m) }
func (*StoreRecoverState) ProtoMessage()    {}
func (*StoreRecoverState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{9}
}
func (m *StoreRecoverState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreRecoverState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreRecoverState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StoreRecoverState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreRecoverState.Merge(m, src)
}
func (m *StoreRecoverState) XXX_Size() int {
	return m.Size()
}
func (m *StoreRecoverState) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreRecoverState.DiscardUnknown(m)
}

var xxx_messageInfo_StoreRecoverState proto.InternalMessageInfo

func (m *StoreRecoverState) GetSeqno() uint64 {
	if m != nil {
		return m.Seqno
	}
	return 0
}

type RaftLocalState struct {
	HardState            *eraftpb.HardState `protobuf:"bytes,1,opt,name=hard_state,json=hardState,proto3" json:"hard_state,omitempty"`
	LastIndex            uint64             `protobuf:"varint,2,opt,name=last_index,json=lastIndex,proto3" json:"last_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *RaftLocalState) Reset()         { *m = RaftLocalState{} }
func (m *RaftLocalState) String() string { return proto.CompactTextString(m) }
func (*RaftLocalState) ProtoMessage()    {}
func (*RaftLocalState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{10}
}
func (m *RaftLocalState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftLocalState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftLocalState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftLocalState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftLocalState.Merge(m, src)
}
func (m *RaftLocalState) XXX_Size() int {
	return m.Size()
}
func (m *RaftLocalState) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftLocalState.DiscardUnknown(m)
}

var xxx_messageInfo_RaftLocalState proto.InternalMessageInfo

func (m *RaftLocalState) GetHardState() *eraftpb.HardState {
	if m != nil {
		return m.HardState
	}
	return nil
}

func (m *RaftLocalState) GetLastIndex() uint64 {
	if m != nil {
		return m.LastIndex
	}
	return 0
}

type RaftApplyState struct {
	AppliedIndex         uint64              `protobuf:"varint,1,opt,name=applied_index,json=appliedIndex,proto3" json:"applied_index,omitempty"`
	LastCommitIndex      uint64              `protobuf:"varint,3,opt,name=last_commit_index,json=lastCommitIndex,proto3" json:"last_commit_index,omitempty"`
	CommitIndex          uint64              `protobuf:"varint,4,opt,name=commit_index,json=commitIndex,proto3" json:"commit_index,omitempty"`
	CommitTerm           uint64              `protobuf:"varint,5,opt,name=commit_term,json=commitTerm,proto3" json:"commit_term,omitempty"`
	TruncatedState       *RaftTruncatedState `protobuf:"bytes,2,opt,name=truncated_state,json=truncatedState,proto3" json:"truncated_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *RaftApplyState) Reset()         { *m = RaftApplyState{} }
func (m *RaftApplyState) String() string { return proto.CompactTextString(m) }
func (*RaftApplyState) ProtoMessage()    {}
func (*RaftApplyState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{11}
}
func (m *RaftApplyState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RaftApplyState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RaftApplyState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RaftApplyState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaftApplyState.Merge(m, src)
}
func (m *RaftApplyState) XXX_Size() int {
	return m.Size()
}
func (m *RaftApplyState) XXX_DiscardUnknown() {
	xxx_messageInfo_RaftApplyState.DiscardUnknown(m)
}

var xxx_messageInfo_RaftApplyState proto.InternalMessageInfo

func (m *RaftApplyState) GetAppliedIndex() uint64 {
	if m != nil {
		return m.AppliedIndex
	}
	return 0
}

func (m *RaftApplyState) GetLastCommitIndex() uint64 {
	if m != nil {
		return m.LastCommitIndex
	}
	return 0
}

func (m *RaftApplyState) GetCommitIndex() uint64 {
	if m != nil {
		return m.CommitIndex
	}
	return 0
}

func (m *RaftApplyState) GetCommitTerm() uint64 {
	if m != nil {
		return m.CommitTerm
	}
	return 0
}

func (m *RaftApplyState) GetTruncatedState() *RaftTruncatedState {
	if m != nil {
		return m.TruncatedState
	}
	return nil
}

type MergeState struct {
	MinIndex             uint64         `protobuf:"varint,1,opt,name=min_index,json=minIndex,proto3" json:"min_index,omitempty"`
	Target               *metapb.Region `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	Commit               uint64         `protobuf:"varint,3,opt,name=commit,proto3" json:"commit,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MergeState) Reset()         { *m = MergeState{} }
func (m *MergeState) String() string { return proto.CompactTextString(m) }
func (*MergeState) ProtoMessage()    {}
func (*MergeState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{12}
}
func (m *MergeState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MergeState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MergeState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MergeState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeState.Merge(m, src)
}
func (m *MergeState) XXX_Size() int {
	return m.Size()
}
func (m *MergeState) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeState.DiscardUnknown(m)
}

var xxx_messageInfo_MergeState proto.InternalMessageInfo

func (m *MergeState) GetMinIndex() uint64 {
	if m != nil {
		return m.MinIndex
	}
	return 0
}

func (m *MergeState) GetTarget() *metapb.Region {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MergeState) GetCommit() uint64 {
	if m != nil {
		return m.Commit
	}
	return 0
}

type RegionLocalState struct {
	State      PeerState      `protobuf:"varint,1,opt,name=state,proto3,enum=raft_serverpb.PeerState" json:"state,omitempty"`
	Region     *metapb.Region `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	MergeState *MergeState    `protobuf:"bytes,3,opt,name=merge_state,json=mergeState,proto3" json:"merge_state,omitempty"`
	// The apply index corresponding to the storage when it's initialized.
	TabletIndex          uint64   `protobuf:"varint,4,opt,name=tablet_index,json=tabletIndex,proto3" json:"tablet_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegionLocalState) Reset()         { *m = RegionLocalState{} }
func (m *RegionLocalState) String() string { return proto.CompactTextString(m) }
func (*RegionLocalState) ProtoMessage()    {}
func (*RegionLocalState) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{13}
}
func (m *RegionLocalState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionLocalState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionLocalState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegionLocalState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionLocalState.Merge(m, src)
}
func (m *RegionLocalState) XXX_Size() int {
	return m.Size()
}
func (m *RegionLocalState) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionLocalState.DiscardUnknown(m)
}

var xxx_messageInfo_RegionLocalState proto.InternalMessageInfo

func (m *RegionLocalState) GetState() PeerState {
	if m != nil {
		return m.State
	}
	return PeerState_Normal
}

func (m *RegionLocalState) GetRegion() *metapb.Region {
	if m != nil {
		return m.Region
	}
	return nil
}

func (m *RegionLocalState) GetMergeState() *MergeState {
	if m != nil {
		return m.MergeState
	}
	return nil
}

func (m *RegionLocalState) GetTabletIndex() uint64 {
	if m != nil {
		return m.TabletIndex
	}
	return 0
}

type RegionSequenceNumberRelation struct {
	RegionId             uint64            `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	SequenceNumber       uint64            `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	ApplyState           *RaftApplyState   `protobuf:"bytes,3,opt,name=apply_state,json=applyState,proto3" json:"apply_state,omitempty"`
	RegionState          *RegionLocalState `protobuf:"bytes,4,opt,name=region_state,json=regionState,proto3" json:"region_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RegionSequenceNumberRelation) Reset()         { *m = RegionSequenceNumberRelation{} }
func (m *RegionSequenceNumberRelation) String() string { return proto.CompactTextString(m) }
func (*RegionSequenceNumberRelation) ProtoMessage()    {}
func (*RegionSequenceNumberRelation) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{14}
}
func (m *RegionSequenceNumberRelation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionSequenceNumberRelation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionSequenceNumberRelation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegionSequenceNumberRelation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionSequenceNumberRelation.Merge(m, src)
}
func (m *RegionSequenceNumberRelation) XXX_Size() int {
	return m.Size()
}
func (m *RegionSequenceNumberRelation) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionSequenceNumberRelation.DiscardUnknown(m)
}

var xxx_messageInfo_RegionSequenceNumberRelation proto.InternalMessageInfo

func (m *RegionSequenceNumberRelation) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *RegionSequenceNumberRelation) GetSequenceNumber() uint64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

func (m *RegionSequenceNumberRelation) GetApplyState() *RaftApplyState {
	if m != nil {
		return m.ApplyState
	}
	return nil
}

func (m *RegionSequenceNumberRelation) GetRegionState() *RegionLocalState {
	if m != nil {
		return m.RegionState
	}
	return nil
}

type ExtraMessage struct {
	Type           ExtraMessageType `protobuf:"varint,1,opt,name=type,proto3,enum=raft_serverpb.ExtraMessageType" json:"type,omitempty"`
	PremergeCommit uint64           `protobuf:"varint,2,opt,name=premerge_commit,json=premergeCommit,proto3" json:"premerge_commit,omitempty"`
	CheckPeers     []*metapb.Peer   `protobuf:"bytes,3,rep,name=check_peers,json=checkPeers,proto3" json:"check_peers,omitempty"`
	WaitData       bool             `protobuf:"varint,4,opt,name=wait_data,json=waitData,proto3" json:"wait_data,omitempty"`
	// Flag for forcely wake up hibernate regions if true.
	ForcelyAwaken        bool     `protobuf:"varint,5,opt,name=forcely_awaken,json=forcelyAwaken,proto3" json:"forcely_awaken,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExtraMessage) Reset()         { *m = ExtraMessage{} }
func (m *ExtraMessage) String() string { return proto.CompactTextString(m) }
func (*ExtraMessage) ProtoMessage()    {}
func (*ExtraMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_130ebc2f2c37a342, []int{15}
}
func (m *ExtraMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExtraMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExtraMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExtraMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtraMessage.Merge(m, src)
}
func (m *ExtraMessage) XXX_Size() int {
	return m.Size()
}
func (m *ExtraMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtraMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ExtraMessage proto.InternalMessageInfo

func (m *ExtraMessage) GetType() ExtraMessageType {
	if m != nil {
		return m.Type
	}
	return ExtraMessageType_MsgRegionWakeUp
}

func (m *ExtraMessage) GetPremergeCommit() uint64 {
	if m != nil {
		return m.PremergeCommit
	}
	return 0
}

func (m *ExtraMessage) GetCheckPeers() []*metapb.Peer {
	if m != nil {
		return m.CheckPeers
	}
	return nil
}

func (m *ExtraMessage) GetWaitData() bool {
	if m != nil {
		return m.WaitData
	}
	return false
}

func (m *ExtraMessage) GetForcelyAwaken() bool {
	if m != nil {
		return m.ForcelyAwaken
	}
	return false
}

func init() {
	proto.RegisterEnum("raft_serverpb.PeerState", PeerState_name, PeerState_value)
	proto.RegisterEnum("raft_serverpb.ExtraMessageType", ExtraMessageType_name, ExtraMessageType_value)
	proto.RegisterType((*RaftMessage)(nil), "raft_serverpb.RaftMessage")
	proto.RegisterType((*RaftTruncatedState)(nil), "raft_serverpb.RaftTruncatedState")
	proto.RegisterType((*SnapshotCFFile)(nil), "raft_serverpb.SnapshotCFFile")
	proto.RegisterType((*SnapshotMeta)(nil), "raft_serverpb.SnapshotMeta")
	proto.RegisterType((*SnapshotChunk)(nil), "raft_serverpb.SnapshotChunk")
	proto.RegisterType((*Done)(nil), "raft_serverpb.Done")
	proto.RegisterType((*KeyValue)(nil), "raft_serverpb.KeyValue")
	proto.RegisterType((*RaftSnapshotData)(nil), "raft_serverpb.RaftSnapshotData")
	proto.RegisterType((*StoreIdent)(nil), "raft_serverpb.StoreIdent")
	proto.RegisterType((*StoreRecoverState)(nil), "raft_serverpb.StoreRecoverState")
	proto.RegisterType((*RaftLocalState)(nil), "raft_serverpb.RaftLocalState")
	proto.RegisterType((*RaftApplyState)(nil), "raft_serverpb.RaftApplyState")
	proto.RegisterType((*MergeState)(nil), "raft_serverpb.MergeState")
	proto.RegisterType((*RegionLocalState)(nil), "raft_serverpb.RegionLocalState")
	proto.RegisterType((*RegionSequenceNumberRelation)(nil), "raft_serverpb.RegionSequenceNumberRelation")
	proto.RegisterType((*ExtraMessage)(nil), "raft_serverpb.ExtraMessage")
}

func init() { proto.RegisterFile("raft_serverpb.proto", fileDescriptor_130ebc2f2c37a342) }

var fileDescriptor_130ebc2f2c37a342 = []byte{
	// 1458 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x56, 0x4b, 0x73, 0x13, 0x49,
	0x12, 0xa6, 0x25, 0x21, 0xb5, 0x52, 0x0f, 0x37, 0x65, 0xc0, 0xc2, 0x5e, 0xbf, 0x44, 0x00, 0xc6,
	0x1b, 0xab, 0x0d, 0x0c, 0xb1, 0x41, 0xec, 0x81, 0x08, 0x3f, 0x20, 0xf0, 0xb2, 0x22, 0x88, 0xb6,
	0x81, 0xd8, 0x53, 0x47, 0xa9, 0x95, 0x6a, 0xf7, 0xaa, 0x5f, 0x54, 0x95, 0x84, 0xb5, 0xb1, 0x3f,
	0x61, 0x7f, 0xc0, 0xfe, 0x84, 0xf9, 0x29, 0x33, 0xa7, 0x99, 0xc3, 0x1c, 0xe6, 0x36, 0x13, 0xcc,
	0x65, 0xae, 0x73, 0x9c, 0xdb, 0x44, 0x3d, 0x5a, 0x2f, 0x3c, 0x9c, 0xba, 0x32, 0xf3, 0xab, 0xaa,
	0x7c, 0x7c, 0x99, 0x5d, 0xb0, 0xca, 0xe8, 0x40, 0x78, 0x1c, 0xd9, 0x18, 0x59, 0xd6, 0xeb, 0x64,
	0x2c, 0x15, 0x29, 0x69, 0x2c, 0x28, 0xd7, 0x1b, 0x28, 0xe5, 0xdc, 0xba, 0x5e, 0x8f, 0x51, 0xd0,
	0xa9, 0xd4, 0x18, 0x8e, 0x59, 0xe6, 0x4f, 0x45, 0xa7, 0x1f, 0xf2, 0xa1, 0x37, 0xe2, 0x34, 0x40,
	0xa3, 0x59, 0x61, 0x23, 0x2e, 0xd4, 0x52, 0x2b, 0xda, 0xbf, 0x15, 0xa1, 0xe6, 0xd2, 0x81, 0xe8,
	0x22, 0x97, 0x30, 0xb2, 0x01, 0x55, 0x86, 0x41, 0x98, 0x26, 0x5e, 0xd8, 0x6f, 0x59, 0x3b, 0xd6,
	0x5e, 0xc9, 0xb5, 0xb5, 0xe2, 0xb4, 0x4f, 0x1e, 0x42, 0x75, 0xc0, 0xd2, 0xd8, 0xcb, 0x10, 0x59,
	0xab, 0xb0, 0x63, 0xed, 0xd5, 0x0e, 0xea, 0x1d, 0xe3, 0xc0, 0x1b, 0x44, 0xe6, 0xda, 0xd2, 0x2c,
	0x57, 0xe4, 0x1e, 0x54, 0x44, 0xaa, 0x81, 0xc5, 0x2b, 0x80, 0x65, 0x91, 0x2a, 0xd8, 0x3e, 0x54,
	0x62, 0x7d, 0x73, 0xab, 0xa4, 0x60, 0x4e, 0x27, 0x8f, 0xcf, 0x78, 0xe4, 0xe6, 0x00, 0xf2, 0x37,
	0xa8, 0x1b, 0xd7, 0x30, 0x4b, 0xfd, 0x8b, 0xd6, 0x75, 0xb5, 0x61, 0x35, 0x3f, 0xd7, 0x55, 0xb6,
	0xe7, 0xd2, 0xe4, 0xd6, 0xd8, 0x4c, 0x20, 0xbb, 0x50, 0x0f, 0xb9, 0x27, 0xd2, 0xb8, 0xc7, 0x45,
	0x9a, 0x60, 0xab, 0xbc, 0x63, 0xed, 0xd9, 0x6e, 0x2d, 0xe4, 0xe7, 0xb9, 0x4a, 0x46, 0xcd, 0x05,
	0x65, 0xc2, 0x1b, 0xe2, 0xa4, 0x55, 0xd9, 0xb1, 0xf6, 0xea, 0xae, 0xad, 0x14, 0xaf, 0x70, 0x42,
	0xd6, 0xa0, 0x82, 0x49, 0x5f, 0x99, 0x6c, 0x65, 0x2a, 0x63, 0xd2, 0x97, 0x86, 0x47, 0x50, 0x8f,
	0x91, 0x05, 0xe8, 0x09, 0xca, 0x02, 0x14, 0xad, 0xaa, 0x72, 0xa8, 0xb9, 0xe8, 0x90, 0x5b, 0x53,
	0x98, 0x73, 0x05, 0x21, 0x4f, 0xa1, 0x8a, 0x97, 0x82, 0x51, 0x2f, 0xe6, 0x41, 0x0b, 0x14, 0x7e,
	0xa3, 0xb3, 0x58, 0xf5, 0xe7, 0xd2, 0x9e, 0x07, 0x6f, 0x2b, 0x74, 0x97, 0x07, 0xd2, 0x45, 0xbd,
	0xd3, 0x17, 0x97, 0xad, 0x9a, 0x76, 0x51, 0x29, 0x8e, 0xc5, 0x25, 0x79, 0x02, 0x30, 0x2b, 0x75,
	0xab, 0xbe, 0x63, 0xed, 0x35, 0x0f, 0x6e, 0x75, 0xe6, 0xaa, 0x7f, 0x12, 0xf2, 0xe1, 0x5b, 0x75,
	0x62, 0xb5, 0x9f, 0x2f, 0xdb, 0xcf, 0x80, 0xc8, 0xd2, 0x9f, 0xb3, 0x51, 0xe2, 0x53, 0x81, 0xfd,
	0x33, 0x41, 0x05, 0x92, 0x9b, 0x70, 0x3d, 0x4c, 0xfa, 0x78, 0x69, 0xaa, 0xaf, 0x05, 0x42, 0xa0,
	0x24, 0x90, 0xc5, 0xaa, 0xea, 0x25, 0x57, 0xad, 0xdb, 0x6f, 0xa0, 0x79, 0x96, 0xd0, 0x8c, 0x5f,
	0xa4, 0xe2, 0xf8, 0xc5, 0x8b, 0x30, 0x42, 0xd2, 0x84, 0x82, 0x3f, 0x50, 0x1b, 0xab, 0x6e, 0xc1,
	0x1f, 0xc8, 0x5d, 0x3c, 0xfc, 0x0f, 0xe6, 0xbb, 0xe4, 0x9a, 0xac, 0x83, 0xed, 0x5f, 0xa0, 0x3f,
	0xe4, 0xa3, 0x58, 0x51, 0xa3, 0xe1, 0x4e, 0xe5, 0xf6, 0xf7, 0x16, 0xd4, 0xf3, 0x23, 0xbb, 0x28,
	0x28, 0x79, 0x0a, 0xb6, 0x3f, 0xf0, 0x06, 0x61, 0x84, 0xbc, 0x65, 0xed, 0x14, 0xf7, 0x6a, 0x07,
	0x9b, 0x4b, 0xe9, 0x5a, 0xf4, 0xc0, 0xad, 0xf8, 0x03, 0xf9, 0xe5, 0x64, 0x1b, 0x6a, 0x83, 0x94,
	0x79, 0x3d, 0x1a, 0xd1, 0xc4, 0xd7, 0x1e, 0xd8, 0x2e, 0x0c, 0x52, 0x76, 0xa4, 0x35, 0x39, 0xe0,
	0x63, 0x28, 0x12, 0xe4, 0x5c, 0xb9, 0xa2, 0x01, 0xef, 0xb5, 0x46, 0x26, 0x42, 0x71, 0x40, 0x31,
	0xb3, 0xe4, 0x6a, 0x81, 0x1c, 0xc0, 0xad, 0x00, 0x13, 0x64, 0x54, 0xa0, 0xd7, 0x1f, 0x31, 0x2a,
	0x24, 0x21, 0x39, 0xfa, 0x8a, 0x8e, 0x25, 0x77, 0x35, 0x37, 0x9e, 0x18, 0xdb, 0x19, 0xfa, 0xed,
	0x7f, 0x41, 0x63, 0xea, 0xe6, 0xc5, 0x28, 0x19, 0x92, 0x27, 0x33, 0xda, 0x5b, 0x8a, 0x04, 0xeb,
	0x4b, 0x51, 0xcd, 0xb5, 0xe4, 0xac, 0x01, 0x08, 0x94, 0xfa, 0x54, 0x50, 0x15, 0x4b, 0xdd, 0x55,
	0xeb, 0x76, 0x19, 0x4a, 0x27, 0x69, 0x82, 0xed, 0x03, 0xb0, 0x5f, 0xe1, 0xe4, 0x1d, 0x8d, 0x46,
	0x48, 0x1c, 0x28, 0x4a, 0xb2, 0x5a, 0x0a, 0x26, 0x97, 0x32, 0x94, 0xb1, 0x34, 0x99, 0xad, 0x5a,
	0x68, 0x7f, 0x6b, 0x81, 0x23, 0x2f, 0xca, 0x7d, 0x3b, 0xa1, 0x82, 0x92, 0xfb, 0x50, 0xd6, 0xcd,
	0x63, 0x3c, 0x5b, 0xa6, 0xb3, 0xb1, 0x4a, 0x3e, 0xca, 0xb2, 0x78, 0x73, 0xf5, 0xb5, 0xa5, 0xe2,
	0x4c, 0xd6, 0xf8, 0xcf, 0xc6, 0xd3, 0xa2, 0x2a, 0xd9, 0xda, 0x52, 0x70, 0xb9, 0xa3, 0x3a, 0x04,
	0xd2, 0x82, 0xca, 0x18, 0x19, 0x97, 0x57, 0xea, 0x4c, 0xe7, 0x22, 0xf9, 0x2b, 0x94, 0xe4, 0xe5,
	0xa6, 0xd3, 0x37, 0xfe, 0xa0, 0xf2, 0x92, 0x28, 0xae, 0x02, 0xb6, 0xff, 0x0b, 0x70, 0x26, 0x52,
	0x86, 0xa7, 0x7d, 0x4c, 0x04, 0xd9, 0x04, 0xf0, 0xa3, 0x11, 0x17, 0xc8, 0x66, 0xc3, 0xac, 0x6a,
	0x34, 0xa7, 0x7d, 0x72, 0x07, 0x6c, 0x2e, 0xc1, 0xd2, 0xa8, 0x03, 0xa8, 0x70, 0xbd, 0x99, 0x3c,
	0x81, 0x1a, 0xcd, 0x42, 0x2f, 0x77, 0xab, 0xa8, 0x1a, 0x6a, 0xb5, 0x93, 0x4f, 0xd7, 0xc3, 0x37,
	0xa7, 0xef, 0xb4, 0xc9, 0x05, 0x9a, 0x85, 0x66, 0xdd, 0x7e, 0x08, 0x37, 0xd4, 0xed, 0x2e, 0xfa,
	0xe9, 0x18, 0xd9, 0xb4, 0x9d, 0x38, 0x7e, 0x48, 0xd2, 0xbc, 0x9d, 0x94, 0xd0, 0xee, 0x41, 0x53,
	0x66, 0xfe, 0x9f, 0xa9, 0x4f, 0x23, 0x8d, 0x7b, 0x04, 0x70, 0x41, 0x59, 0xdf, 0xe3, 0x52, 0x32,
	0xb9, 0x27, 0xd3, 0x61, 0xf8, 0x92, 0x32, 0xdd, 0x9e, 0x6e, 0xf5, 0x22, 0x5f, 0xca, 0xf8, 0x22,
	0xca, 0x85, 0xa7, 0xdb, 0x55, 0x87, 0x50, 0x95, 0x9a, 0x53, 0xa9, 0x68, 0xff, 0x6a, 0xe9, 0x4b,
	0x0e, 0xb3, 0x2c, 0x9a, 0xe8, 0x1d, 0x77, 0xa1, 0x41, 0xb3, 0x2c, 0x0a, 0xb1, 0xef, 0xcd, 0xf7,
	0x78, 0xdd, 0x28, 0xd5, 0x3e, 0xb2, 0x0f, 0x37, 0xd4, 0xb1, 0x7e, 0x1a, 0xc7, 0x61, 0x7e, 0x7a,
	0x51, 0x01, 0x57, 0xa4, 0xe1, 0x58, 0xe9, 0x35, 0x76, 0x17, 0xea, 0x0b, 0x30, 0x5d, 0xc0, 0x9a,
	0x3f, 0x07, 0xd9, 0x06, 0x23, 0x7a, 0x6a, 0x80, 0xe8, 0x36, 0x01, 0xad, 0x3a, 0x47, 0x16, 0x93,
	0x7f, 0xc0, 0x8a, 0xc8, 0x47, 0x90, 0x09, 0x5f, 0xff, 0x5b, 0x76, 0xaf, 0x68, 0x8a, 0xc5, 0x61,
	0xe5, 0x36, 0xc5, 0x82, 0xdc, 0x0e, 0x01, 0xba, 0x72, 0xdc, 0xea, 0x70, 0x37, 0xa0, 0x1a, 0x87,
	0xc9, 0x42, 0xa8, 0x76, 0x1c, 0x26, 0xda, 0xaf, 0xfb, 0x50, 0x36, 0x73, 0xbb, 0x70, 0x35, 0xd1,
	0xb5, 0x95, 0xdc, 0x86, 0xb2, 0x76, 0xd6, 0xe4, 0xc0, 0x48, 0xed, 0x6f, 0x64, 0xf7, 0x28, 0xe8,
	0x5c, 0x15, 0x3b, 0x6a, 0x66, 0x98, 0x02, 0x36, 0x0f, 0x5a, 0x4b, 0x11, 0xc8, 0x7f, 0x9e, 0x76,
	0x5c, 0xc3, 0xe6, 0xba, 0xad, 0xf0, 0xc5, 0x6e, 0xfb, 0x3b, 0xe8, 0xdf, 0x88, 0xc9, 0x8f, 0xfe,
	0xa5, 0xde, 0x59, 0x3a, 0x7d, 0x16, 0xb9, 0x0b, 0xf1, 0x2c, 0x0b, 0xbb, 0x50, 0x17, 0xb4, 0x17,
	0xe1, 0x52, 0x8d, 0xb4, 0x4e, 0x53, 0xe5, 0x17, 0x0b, 0xfe, 0xa4, 0x6f, 0x3c, 0xc3, 0x0f, 0x23,
	0x4c, 0x7c, 0x7c, 0x3d, 0x8a, 0x7b, 0xc8, 0x5c, 0x8c, 0xd4, 0x10, 0xfb, 0xf2, 0xb3, 0xe0, 0x01,
	0xac, 0x70, 0xb3, 0xcd, 0x4b, 0xd4, 0x3e, 0x43, 0xc6, 0x26, 0x5f, 0x38, 0x8d, 0x3c, 0x93, 0x6d,
	0x95, 0x45, 0x93, 0x85, 0x28, 0x36, 0xaf, 0xa8, 0xf2, 0x8c, 0xb2, 0xb2, 0xc1, 0xa6, 0xf4, 0x3d,
	0x9a, 0xbe, 0x00, 0xf4, 0x01, 0xfa, 0xc9, 0xb0, 0xbd, 0x7c, 0xc0, 0x52, 0x51, 0xf2, 0xd7, 0x80,
	0x66, 0xc8, 0x8f, 0x16, 0xd4, 0xe7, 0x7f, 0xb1, 0xe4, 0x31, 0x94, 0xc4, 0x24, 0xcb, 0x2b, 0xb6,
	0xfd, 0x85, 0xbf, 0xf1, 0xf9, 0x24, 0x43, 0x57, 0x81, 0x65, 0xc8, 0x19, 0x43, 0x5d, 0x12, 0xc3,
	0x0e, 0x13, 0x72, 0xae, 0xd6, 0x5d, 0x42, 0xfe, 0x02, 0x35, 0xf5, 0x77, 0x53, 0x4f, 0x21, 0x6e,
	0x06, 0xe2, 0xe2, 0x5b, 0x08, 0x14, 0x40, 0x2e, 0xb9, 0xcc, 0xf3, 0x47, 0x1a, 0x0a, 0x4f, 0x4d,
	0xcf, 0x92, 0xfa, 0x25, 0xd9, 0x52, 0xa1, 0x46, 0xf3, 0x3d, 0x68, 0x0e, 0x52, 0xe6, 0x63, 0x34,
	0xf1, 0xe8, 0x47, 0x3a, 0xc4, 0x44, 0x35, 0x93, 0xed, 0x36, 0x8c, 0xf6, 0x50, 0x29, 0xf7, 0x5d,
	0xa8, 0x4e, 0x79, 0x46, 0x00, 0xca, 0xaf, 0x53, 0x16, 0xd3, 0xc8, 0xb9, 0x46, 0xea, 0x60, 0xab,
	0xc4, 0x86, 0x49, 0xe0, 0x58, 0xa4, 0x01, 0xd5, 0xe9, 0x03, 0xc8, 0x29, 0x90, 0x1a, 0x54, 0x24,
	0x7f, 0xa4, 0xad, 0x48, 0x56, 0xa0, 0xf6, 0x36, 0xa1, 0x63, 0x1a, 0x46, 0x92, 0x24, 0x4e, 0x69,
	0xff, 0x7f, 0x05, 0x70, 0x96, 0x53, 0x41, 0x56, 0x61, 0xa5, 0xcb, 0x03, 0x9d, 0xee, 0xf7, 0x74,
	0x88, 0x6f, 0x33, 0xe7, 0x1a, 0x69, 0xc1, 0xcd, 0x2e, 0x0f, 0xde, 0xd3, 0x44, 0xb8, 0x69, 0x14,
	0xf5, 0xa8, 0x3f, 0x54, 0xb4, 0x74, 0x2c, 0x72, 0x0b, 0x6e, 0x74, 0x79, 0x70, 0x2c, 0x83, 0x3d,
	0x13, 0x34, 0x42, 0xe9, 0xa4, 0x53, 0x20, 0x9b, 0x70, 0xe7, 0x33, 0xb5, 0x8b, 0x3c, 0x4b, 0x13,
	0x8e, 0x4e, 0x91, 0xac, 0xc1, 0x6a, 0x97, 0x07, 0x2f, 0xc3, 0x1e, 0xb2, 0x44, 0x16, 0x53, 0x32,
	0x8a, 0x0b, 0xa7, 0x64, 0x2e, 0x9a, 0x33, 0x98, 0x2d, 0xd7, 0xc9, 0x03, 0xb8, 0xab, 0xfc, 0xfa,
	0x37, 0xfa, 0x42, 0x4f, 0xd9, 0xe0, 0x98, 0x8e, 0x38, 0xf6, 0x8f, 0x26, 0x5d, 0x8c, 0x53, 0x36,
	0x51, 0xcf, 0x1f, 0xa7, 0x4c, 0xd6, 0xe1, 0x76, 0x97, 0x07, 0x87, 0x3a, 0xce, 0x30, 0x0a, 0xc5,
	0x24, 0x3f, 0xbe, 0x42, 0x36, 0x60, 0xed, 0x33, 0x9b, 0xb9, 0xc1, 0x3e, 0xba, 0xff, 0xc3, 0x57,
	0xb6, 0xf5, 0xf5, 0xa7, 0x2d, 0xeb, 0xbb, 0x4f, 0x5b, 0xd6, 0x4f, 0x9f, 0xb6, 0xac, 0xff, 0xff,
	0xbc, 0x75, 0x0d, 0x9c, 0x94, 0x05, 0x1d, 0x11, 0x0e, 0xc7, 0x9d, 0xe1, 0x58, 0xbd, 0xae, 0x7b,
	0x65, 0xf5, 0x79, 0xfc, 0x7b, 0x00, 0x00, 0x00, 0xff, 0xff, 0x1a, 0x5e, 0xce, 0x8b, 0xd9, 0x0b,
	0x00, 0x00,
}

func (m *RaftMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.DiskUsage != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.DiskUsage))
		i--
		dAtA[i] = 0x60
	}
	if len(m.ExtraCtx) > 0 {
		i -= len(m.ExtraCtx)
		copy(dAtA[i:], m.ExtraCtx)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.ExtraCtx)))
		i--
		dAtA[i] = 0x5a
	}
	if m.ExtraMsg != nil {
		{
			size, err := m.ExtraMsg.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.MergeTarget != nil {
		{
			size, err := m.MergeTarget.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x3a
	}
	if m.IsTombstone {
		i--
		if m.IsTombstone {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.RegionEpoch != nil {
		{
			size, err := m.RegionEpoch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Message != nil {
		{
			size, err := m.Message.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ToPeer != nil {
		{
			size, err := m.ToPeer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.FromPeer != nil {
		{
			size, err := m.FromPeer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionId != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.RegionId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RaftTruncatedState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftTruncatedState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftTruncatedState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Term != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x10
	}
	if m.Index != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SnapshotCFFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotCFFile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SnapshotCFFile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Checksum != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Checksum))
		i--
		dAtA[i] = 0x18
	}
	if m.Size_ != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Size_))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SnapshotMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SnapshotMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.GenerateDurationSec != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.GenerateDurationSec))
		i--
		dAtA[i] = 0x28
	}
	if m.Start != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x20
	}
	if m.ForWitness {
		i--
		if m.ForWitness {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.ForBalance {
		i--
		if m.ForBalance {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.CfFiles) > 0 {
		for iNdEx := len(m.CfFiles) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CfFiles[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SnapshotChunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotChunk) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SnapshotChunk) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	if m.Message != nil {
		{
			size, err := m.Message.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Done) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Done) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Done) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintRaftServerpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RaftSnapshotData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftSnapshotData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftSnapshotData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Meta != nil {
		{
			size, err := m.Meta.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Version != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Data) > 0 {
		for iNdEx := len(m.Data) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Data[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.FileSize != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.FileSize))
		i--
		dAtA[i] = 0x10
	}
	if m.Region != nil {
		{
			size, err := m.Region.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StoreIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreIdent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StoreIdent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ApiVersion != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.ApiVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.StoreId != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.StoreId))
		i--
		dAtA[i] = 0x10
	}
	if m.ClusterId != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.ClusterId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *StoreRecoverState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreRecoverState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StoreRecoverState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Seqno != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Seqno))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RaftLocalState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftLocalState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftLocalState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.LastIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.HardState != nil {
		{
			size, err := m.HardState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RaftApplyState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftApplyState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RaftApplyState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitTerm != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.CommitTerm))
		i--
		dAtA[i] = 0x28
	}
	if m.CommitIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.CommitIndex))
		i--
		dAtA[i] = 0x20
	}
	if m.LastCommitIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.LastCommitIndex))
		i--
		dAtA[i] = 0x18
	}
	if m.TruncatedState != nil {
		{
			size, err := m.TruncatedState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.AppliedIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.AppliedIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MergeState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MergeState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Commit != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Commit))
		i--
		dAtA[i] = 0x18
	}
	if m.Target != nil {
		{
			size, err := m.Target.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.MinIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.MinIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RegionLocalState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionLocalState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegionLocalState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TabletIndex != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.TabletIndex))
		i--
		dAtA[i] = 0x20
	}
	if m.MergeState != nil {
		{
			size, err := m.MergeState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Region != nil {
		{
			size, err := m.Region.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.State != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RegionSequenceNumberRelation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionSequenceNumberRelation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegionSequenceNumberRelation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RegionState != nil {
		{
			size, err := m.RegionState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.ApplyState != nil {
		{
			size, err := m.ApplyState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.SequenceNumber != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.SequenceNumber))
		i--
		dAtA[i] = 0x10
	}
	if m.RegionId != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.RegionId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExtraMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExtraMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExtraMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForcelyAwaken {
		i--
		if m.ForcelyAwaken {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.WaitData {
		i--
		if m.WaitData {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.CheckPeers) > 0 {
		for iNdEx := len(m.CheckPeers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CheckPeers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRaftServerpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.PremergeCommit != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.PremergeCommit))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintRaftServerpb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintRaftServerpb(dAtA []byte, offset int, v uint64) int {
	offset -= sovRaftServerpb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *RaftMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.RegionId))
	}
	if m.FromPeer != nil {
		l = m.FromPeer.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.ToPeer != nil {
		l = m.ToPeer.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.RegionEpoch != nil {
		l = m.RegionEpoch.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.IsTombstone {
		n += 2
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.MergeTarget != nil {
		l = m.MergeTarget.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.ExtraMsg != nil {
		l = m.ExtraMsg.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.ExtraCtx)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.DiskUsage != 0 {
		n += 1 + sovRaftServerpb(uint64(m.DiskUsage))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RaftTruncatedState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Index != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Index))
	}
	if m.Term != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Term))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SnapshotCFFile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Size_))
	}
	if m.Checksum != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Checksum))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SnapshotMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.CfFiles) > 0 {
		for _, e := range m.CfFiles {
			l = e.Size()
			n += 1 + l + sovRaftServerpb(uint64(l))
		}
	}
	if m.ForBalance {
		n += 2
	}
	if m.ForWitness {
		n += 2
	}
	if m.Start != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Start))
	}
	if m.GenerateDurationSec != 0 {
		n += 1 + sovRaftServerpb(uint64(m.GenerateDurationSec))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SnapshotChunk) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Done) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RaftSnapshotData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Region != nil {
		l = m.Region.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.FileSize != 0 {
		n += 1 + sovRaftServerpb(uint64(m.FileSize))
	}
	if len(m.Data) > 0 {
		for _, e := range m.Data {
			l = e.Size()
			n += 1 + l + sovRaftServerpb(uint64(l))
		}
	}
	if m.Version != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Version))
	}
	if m.Meta != nil {
		l = m.Meta.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreIdent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.ClusterId))
	}
	if m.StoreId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.StoreId))
	}
	if m.ApiVersion != 0 {
		n += 1 + sovRaftServerpb(uint64(m.ApiVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreRecoverState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Seqno != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Seqno))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RaftLocalState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HardState != nil {
		l = m.HardState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.LastIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.LastIndex))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RaftApplyState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AppliedIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.AppliedIndex))
	}
	if m.TruncatedState != nil {
		l = m.TruncatedState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.LastCommitIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.LastCommitIndex))
	}
	if m.CommitIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.CommitIndex))
	}
	if m.CommitTerm != 0 {
		n += 1 + sovRaftServerpb(uint64(m.CommitTerm))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MergeState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MinIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.MinIndex))
	}
	if m.Target != nil {
		l = m.Target.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.Commit != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Commit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionLocalState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != 0 {
		n += 1 + sovRaftServerpb(uint64(m.State))
	}
	if m.Region != nil {
		l = m.Region.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.MergeState != nil {
		l = m.MergeState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.TabletIndex != 0 {
		n += 1 + sovRaftServerpb(uint64(m.TabletIndex))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionSequenceNumberRelation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovRaftServerpb(uint64(m.RegionId))
	}
	if m.SequenceNumber != 0 {
		n += 1 + sovRaftServerpb(uint64(m.SequenceNumber))
	}
	if m.ApplyState != nil {
		l = m.ApplyState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.RegionState != nil {
		l = m.RegionState.Size()
		n += 1 + l + sovRaftServerpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExtraMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovRaftServerpb(uint64(m.Type))
	}
	if m.PremergeCommit != 0 {
		n += 1 + sovRaftServerpb(uint64(m.PremergeCommit))
	}
	if len(m.CheckPeers) > 0 {
		for _, e := range m.CheckPeers {
			l = e.Size()
			n += 1 + l + sovRaftServerpb(uint64(l))
		}
	}
	if m.WaitData {
		n += 2
	}
	if m.ForcelyAwaken {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovRaftServerpb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRaftServerpb(x uint64) (n int) {
	return sovRaftServerpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RaftMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromPeer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FromPeer == nil {
				m.FromPeer = &metapb.Peer{}
			}
			if err := m.FromPeer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToPeer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ToPeer == nil {
				m.ToPeer = &metapb.Peer{}
			}
			if err := m.ToPeer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &eraftpb.Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionEpoch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionEpoch == nil {
				m.RegionEpoch = &metapb.RegionEpoch{}
			}
			if err := m.RegionEpoch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsTombstone", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsTombstone = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTarget", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTarget == nil {
				m.MergeTarget = &metapb.Region{}
			}
			if err := m.MergeTarget.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraMsg", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExtraMsg == nil {
				m.ExtraMsg = &ExtraMessage{}
			}
			if err := m.ExtraMsg.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraCtx", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtraCtx = append(m.ExtraCtx[:0], dAtA[iNdEx:postIndex]...)
			if m.ExtraCtx == nil {
				m.ExtraCtx = []byte{}
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskUsage", wireType)
			}
			m.DiskUsage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DiskUsage |= disk_usage.DiskUsage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftTruncatedState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftTruncatedState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftTruncatedState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotCFFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotCFFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotCFFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			m.Checksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Checksum |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CfFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CfFiles = append(m.CfFiles, &SnapshotCFFile{})
			if err := m.CfFiles[len(m.CfFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForBalance", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForBalance = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForWitness", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForWitness = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenerateDurationSec", wireType)
			}
			m.GenerateDurationSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GenerateDurationSec |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotChunk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotChunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotChunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &RaftMessage{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Done) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Done: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Done: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftSnapshotData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftSnapshotData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftSnapshotData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Region == nil {
				m.Region = &metapb.Region{}
			}
			if err := m.Region.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileSize", wireType)
			}
			m.FileSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FileSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data, &KeyValue{})
			if err := m.Data[len(m.Data)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = &SnapshotMeta{}
			}
			if err := m.Meta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreId", wireType)
			}
			m.StoreId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			m.ApiVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApiVersion |= kvrpcpb.APIVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreRecoverState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreRecoverState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreRecoverState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seqno", wireType)
			}
			m.Seqno = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seqno |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftLocalState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftLocalState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftLocalState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HardState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HardState == nil {
				m.HardState = &eraftpb.HardState{}
			}
			if err := m.HardState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastIndex", wireType)
			}
			m.LastIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftApplyState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftApplyState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftApplyState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedIndex", wireType)
			}
			m.AppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AppliedIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncatedState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncatedState == nil {
				m.TruncatedState = &RaftTruncatedState{}
			}
			if err := m.TruncatedState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastCommitIndex", wireType)
			}
			m.LastCommitIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastCommitIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitIndex", wireType)
			}
			m.CommitIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTerm", wireType)
			}
			m.CommitTerm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTerm |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinIndex", wireType)
			}
			m.MinIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Target == nil {
				m.Target = &metapb.Region{}
			}
			if err := m.Target.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			m.Commit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Commit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionLocalState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionLocalState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionLocalState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= PeerState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Region == nil {
				m.Region = &metapb.Region{}
			}
			if err := m.Region.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeState == nil {
				m.MergeState = &MergeState{}
			}
			if err := m.MergeState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TabletIndex", wireType)
			}
			m.TabletIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TabletIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionSequenceNumberRelation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionSequenceNumberRelation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionSequenceNumberRelation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SequenceNumber", wireType)
			}
			m.SequenceNumber = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SequenceNumber |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ApplyState == nil {
				m.ApplyState = &RaftApplyState{}
			}
			if err := m.ApplyState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionState == nil {
				m.RegionState = &RegionLocalState{}
			}
			if err := m.RegionState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExtraMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExtraMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExtraMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ExtraMessageType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PremergeCommit", wireType)
			}
			m.PremergeCommit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PremergeCommit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckPeers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckPeers = append(m.CheckPeers, &metapb.Peer{})
			if err := m.CheckPeers[len(m.CheckPeers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitData", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WaitData = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForcelyAwaken", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForcelyAwaken = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRaftServerpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRaftServerpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRaftServerpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRaftServerpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaftServerpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRaftServerpb
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRaftServerpb
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRaftServerpb
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRaftServerpb        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRaftServerpb          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRaftServerpb = fmt.Errorf("proto: unexpected end of group")
)
