// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: kvrpcpb.proto

package kvrpcpb

import (
	"fmt"
	"io"
	"math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	deadlock "github.com/pingcap/kvproto/pkg/deadlock"
	errorpb "github.com/pingcap/kvproto/pkg/errorpb"
	metapb "github.com/pingcap/kvproto/pkg/metapb"
	tracepb "github.com/pingcap/kvproto/pkg/tracepb"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Used to specify the behavior when a pessimistic lock request is woken up after waiting for another
// lock.
type PessimisticLockWakeUpMode int32

const (
	// When woken up, returns WriteConflict error to the client and the client should retry if necessary.
	// In this mode, results of `return_values` or `check_existence` will be set to `values` and `not_founds`
	// fields of the PessimisticLockResponse, which is compatible with old versions.
	PessimisticLockWakeUpMode_WakeUpModeNormal PessimisticLockWakeUpMode = 0
	// When woken up, continue trying to lock the key. This implicitly enables the `allow_lock_with_conflict`
	// behavior, which means, allow acquiring the lock even if there is WriteConflict on the key.
	// In this mode, `return_values` or `check_existence` fields of PessimisticLockResponse won't be used, and
	// all results are carried in the `results` field.
	PessimisticLockWakeUpMode_WakeUpModeForceLock PessimisticLockWakeUpMode = 1
)

var PessimisticLockWakeUpMode_name = map[int32]string{
	0: "WakeUpModeNormal",
	1: "WakeUpModeForceLock",
}

var PessimisticLockWakeUpMode_value = map[string]int32{
	"WakeUpModeNormal":    0,
	"WakeUpModeForceLock": 1,
}

func (x PessimisticLockWakeUpMode) String() string {
	return proto.EnumName(PessimisticLockWakeUpMode_name, int32(x))
}

func (PessimisticLockWakeUpMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{0}
}

type PessimisticLockKeyResultType int32

const (
	PessimisticLockKeyResultType_LockResultNormal             PessimisticLockKeyResultType = 0
	PessimisticLockKeyResultType_LockResultLockedWithConflict PessimisticLockKeyResultType = 1
	PessimisticLockKeyResultType_LockResultFailed             PessimisticLockKeyResultType = 2
)

var PessimisticLockKeyResultType_name = map[int32]string{
	0: "LockResultNormal",
	1: "LockResultLockedWithConflict",
	2: "LockResultFailed",
}

var PessimisticLockKeyResultType_value = map[string]int32{
	"LockResultNormal":             0,
	"LockResultLockedWithConflict": 1,
	"LockResultFailed":             2,
}

func (x PessimisticLockKeyResultType) String() string {
	return proto.EnumName(PessimisticLockKeyResultType_name, int32(x))
}

func (PessimisticLockKeyResultType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{1}
}

// The API version the server and the client is using.
// See more details in https://github.com/tikv/rfcs/blob/master/text/0069-api-v2.md.
type APIVersion int32

const (
	// `V1` is mainly for TiDB & TxnKV, and is not safe to use RawKV along with the others.
	// V1 server only accepts V1 requests. V1 raw requests with TTL will be rejected.
	APIVersion_V1 APIVersion = 0
	//
	// `V1TTL` is only available to RawKV, and 8 bytes representing the unix timestamp in
	// seconds for expiring time will be append to the value of all RawKV entries. For example:
	// ------------------------------------------------------------
	// | User value     | Expire Ts                               |
	// ------------------------------------------------------------
	// | 0x12 0x34 0x56 | 0x00 0x00 0x00 0x00 0x00 0x00 0xff 0xff |
	// ------------------------------------------------------------
	// V1TTL server only accepts V1 raw requests.
	// V1 client should not use `V1TTL` in request. V1 client should always send `V1`.
	APIVersion_V1TTL APIVersion = 1
	//
	// `V2` use new encoding for RawKV & TxnKV to support more features.
	//
	// Key Encoding:
	//  TiDB: start with `m` or `t`, the same as `V1`.
	//  TxnKV: prefix with `x`, encoded as `MCE( x{keyspace id} + {user key} ) + timestamp`.
	//  RawKV: prefix with `r`, encoded as `MCE( r{keyspace id} + {user key} ) + timestamp`.
	//  Where the `{keyspace id}` is fixed-length of 3 bytes in network byte order.
	//  Besides, RawKV entires must be in `default` CF.
	//
	// Value Encoding:
	//  TiDB & TxnKV: the same as `V1`.
	//  RawKV: `{user value} + {optional fields} + {meta flag}`. The last byte in the
	//  raw value must be meta flags. For example:
	//  --------------------------------------
	//  | User value     | Meta flags        |
	//  --------------------------------------
	//  | 0x12 0x34 0x56 | 0x00 (0b00000000) |
	//  --------------------------------------
	//  Bit 0 of meta flags is for TTL. If set, the value contains 8 bytes expiring time as
	//  unix timestamp in seconds at the very left to the meta flags.
	//  --------------------------------------------------------------------------------
	//  | User value     | Expiring time                           | Meta flags        |
	//  --------------------------------------------------------------------------------
	//  | 0x12 0x34 0x56 | 0x00 0x00 0x00 0x00 0x00 0x00 0xff 0xff | 0x01 (0b00000001) |
	//  --------------------------------------------------------------------------------
	//  Bit 1 is for deletion. If set, the entry is logical deleted.
	//  ---------------------
	//  | Meta flags        |
	//  ---------------------
	//  | 0x02 (0b00000010) |
	//  ---------------------
	//
	// V2 server accpets V2 requests and V1 transactional requests that statrts with TiDB key
	// prefix (`m` and `t`).
	APIVersion_V2 APIVersion = 2
)

var APIVersion_name = map[int32]string{
	0: "V1",
	1: "V1TTL",
	2: "V2",
}

var APIVersion_value = map[string]int32{
	"V1":    0,
	"V1TTL": 1,
	"V2":    2,
}

func (x APIVersion) String() string {
	return proto.EnumName(APIVersion_name, int32(x))
}

func (APIVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{2}
}

type CommandPri int32

const (
	CommandPri_Normal CommandPri = 0
	CommandPri_Low    CommandPri = 1
	CommandPri_High   CommandPri = 2
)

var CommandPri_name = map[int32]string{
	0: "Normal",
	1: "Low",
	2: "High",
}

var CommandPri_value = map[string]int32{
	"Normal": 0,
	"Low":    1,
	"High":   2,
}

func (x CommandPri) String() string {
	return proto.EnumName(CommandPri_name, int32(x))
}

func (CommandPri) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{3}
}

type IsolationLevel int32

const (
	IsolationLevel_SI        IsolationLevel = 0
	IsolationLevel_RC        IsolationLevel = 1
	IsolationLevel_RCCheckTS IsolationLevel = 2
)

var IsolationLevel_name = map[int32]string{
	0: "SI",
	1: "RC",
	2: "RCCheckTS",
}

var IsolationLevel_value = map[string]int32{
	"SI":        0,
	"RC":        1,
	"RCCheckTS": 2,
}

func (x IsolationLevel) String() string {
	return proto.EnumName(IsolationLevel_name, int32(x))
}

func (IsolationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{4}
}

// Operation allowed info during each TiKV storage threshold.
type DiskFullOpt int32

const (
	DiskFullOpt_NotAllowedOnFull     DiskFullOpt = 0
	DiskFullOpt_AllowedOnAlmostFull  DiskFullOpt = 1
	DiskFullOpt_AllowedOnAlreadyFull DiskFullOpt = 2
)

var DiskFullOpt_name = map[int32]string{
	0: "NotAllowedOnFull",
	1: "AllowedOnAlmostFull",
	2: "AllowedOnAlreadyFull",
}

var DiskFullOpt_value = map[string]int32{
	"NotAllowedOnFull":     0,
	"AllowedOnAlmostFull":  1,
	"AllowedOnAlreadyFull": 2,
}

func (x DiskFullOpt) String() string {
	return proto.EnumName(DiskFullOpt_name, int32(x))
}

func (DiskFullOpt) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{5}
}

type Op int32

const (
	Op_Put      Op = 0
	Op_Del      Op = 1
	Op_Lock     Op = 2
	Op_Rollback Op = 3
	// insert operation has a constraint that key should not exist before.
	Op_Insert          Op = 4
	Op_PessimisticLock Op = 5
	Op_CheckNotExists  Op = 6
)

var Op_name = map[int32]string{
	0: "Put",
	1: "Del",
	2: "Lock",
	3: "Rollback",
	4: "Insert",
	5: "PessimisticLock",
	6: "CheckNotExists",
}

var Op_value = map[string]int32{
	"Put":             0,
	"Del":             1,
	"Lock":            2,
	"Rollback":        3,
	"Insert":          4,
	"PessimisticLock": 5,
	"CheckNotExists":  6,
}

func (x Op) String() string {
	return proto.EnumName(Op_name, int32(x))
}

func (Op) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{6}
}

type Assertion int32

const (
	Assertion_None     Assertion = 0
	Assertion_Exist    Assertion = 1
	Assertion_NotExist Assertion = 2
)

var Assertion_name = map[int32]string{
	0: "None",
	1: "Exist",
	2: "NotExist",
}

var Assertion_value = map[string]int32{
	"None":     0,
	"Exist":    1,
	"NotExist": 2,
}

func (x Assertion) String() string {
	return proto.EnumName(Assertion_name, int32(x))
}

func (Assertion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{7}
}

type AssertionLevel int32

const (
	// No assertion.
	AssertionLevel_Off AssertionLevel = 0
	// Assertion is enabled, but not enforced when it might affect performance.
	AssertionLevel_Fast AssertionLevel = 1
	// Assertion is enabled and enforced.
	AssertionLevel_Strict AssertionLevel = 2
)

var AssertionLevel_name = map[int32]string{
	0: "Off",
	1: "Fast",
	2: "Strict",
}

var AssertionLevel_value = map[string]int32{
	"Off":    0,
	"Fast":   1,
	"Strict": 2,
}

func (x AssertionLevel) String() string {
	return proto.EnumName(AssertionLevel_name, int32(x))
}

func (AssertionLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{8}
}

type Action int32

const (
	Action_NoAction                     Action = 0
	Action_TTLExpireRollback            Action = 1
	Action_LockNotExistRollback         Action = 2
	Action_MinCommitTSPushed            Action = 3
	Action_TTLExpirePessimisticRollback Action = 4
	Action_LockNotExistDoNothing        Action = 5
)

var Action_name = map[int32]string{
	0: "NoAction",
	1: "TTLExpireRollback",
	2: "LockNotExistRollback",
	3: "MinCommitTSPushed",
	4: "TTLExpirePessimisticRollback",
	5: "LockNotExistDoNothing",
}

var Action_value = map[string]int32{
	"NoAction":                     0,
	"TTLExpireRollback":            1,
	"LockNotExistRollback":         2,
	"MinCommitTSPushed":            3,
	"TTLExpirePessimisticRollback": 4,
	"LockNotExistDoNothing":        5,
}

func (x Action) String() string {
	return proto.EnumName(Action_name, int32(x))
}

func (Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{9}
}

type ExtraOp int32

const (
	ExtraOp_Noop ExtraOp = 0
	// ReadOldValue represents to output the previous value for delete/update operations.
	ExtraOp_ReadOldValue ExtraOp = 1
)

var ExtraOp_name = map[int32]string{
	0: "Noop",
	1: "ReadOldValue",
}

var ExtraOp_value = map[string]int32{
	"Noop":         0,
	"ReadOldValue": 1,
}

func (x ExtraOp) String() string {
	return proto.EnumName(ExtraOp_name, int32(x))
}

func (ExtraOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{10}
}

type ChecksumAlgorithm int32

const (
	ChecksumAlgorithm_Crc64_Xor ChecksumAlgorithm = 0
)

var ChecksumAlgorithm_name = map[int32]string{
	0: "Crc64_Xor",
}

var ChecksumAlgorithm_value = map[string]int32{
	"Crc64_Xor": 0,
}

func (x ChecksumAlgorithm) String() string {
	return proto.EnumName(ChecksumAlgorithm_name, int32(x))
}

func (ChecksumAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{11}
}

// What kind of checks need to be performed for keys in a pessimistic transaction.
type PrewriteRequest_PessimisticAction int32

const (
	// The key needn't be locked and no extra write conflict checks are needed.
	PrewriteRequest_SKIP_PESSIMISTIC_CHECK PrewriteRequest_PessimisticAction = 0
	// The key should have been locked at the time of prewrite.
	PrewriteRequest_DO_PESSIMISTIC_CHECK PrewriteRequest_PessimisticAction = 1
	// The key doesn't need a pessimistic lock. But we need to do data constraint checks.
	PrewriteRequest_DO_CONSTRAINT_CHECK PrewriteRequest_PessimisticAction = 2
)

var PrewriteRequest_PessimisticAction_name = map[int32]string{
	0: "SKIP_PESSIMISTIC_CHECK",
	1: "DO_PESSIMISTIC_CHECK",
	2: "DO_CONSTRAINT_CHECK",
}

var PrewriteRequest_PessimisticAction_value = map[string]int32{
	"SKIP_PESSIMISTIC_CHECK": 0,
	"DO_PESSIMISTIC_CHECK":   1,
	"DO_CONSTRAINT_CHECK":    2,
}

func (x PrewriteRequest_PessimisticAction) String() string {
	return proto.EnumName(PrewriteRequest_PessimisticAction_name, int32(x))
}

func (PrewriteRequest_PessimisticAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{4, 0}
}

type WriteConflict_Reason int32

const (
	WriteConflict_Unknown             WriteConflict_Reason = 0
	WriteConflict_Optimistic          WriteConflict_Reason = 1
	WriteConflict_PessimisticRetry    WriteConflict_Reason = 2
	WriteConflict_SelfRolledBack      WriteConflict_Reason = 3
	WriteConflict_RcCheckTs           WriteConflict_Reason = 4
	WriteConflict_LazyUniquenessCheck WriteConflict_Reason = 5
)

var WriteConflict_Reason_name = map[int32]string{
	0: "Unknown",
	1: "Optimistic",
	2: "PessimisticRetry",
	3: "SelfRolledBack",
	4: "RcCheckTs",
	5: "LazyUniquenessCheck",
}

var WriteConflict_Reason_value = map[string]int32{
	"Unknown":             0,
	"Optimistic":          1,
	"PessimisticRetry":    2,
	"SelfRolledBack":      3,
	"RcCheckTs":           4,
	"LazyUniquenessCheck": 5,
}

func (x WriteConflict_Reason) String() string {
	return proto.EnumName(WriteConflict_Reason_name, int32(x))
}

func (WriteConflict_Reason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{78, 0}
}

// A transactional get command. Lookup a value for `key` in the transaction with
// starting timestamp = `version`.
type GetRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Version              uint64   `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRequest) Reset()         { *m = GetRequest{} }
func (m *GetRequest) String() string { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()    {}
func (*GetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{0}
}
func (m *GetRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRequest.Merge(m, src)
}
func (m *GetRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRequest proto.InternalMessageInfo

func (m *GetRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *GetRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *GetRequest) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type GetResponse struct {
	// A region error indicates that the request was sent to the wrong TiKV node
	// (or other, similar errors).
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	// A value could not be retrieved due to the state of the database for the requested key.
	Error *KeyError `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// A successful result.
	Value []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// True if the key does not exist in the database.
	NotFound bool `protobuf:"varint,4,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	// Time and scan details when processing the request.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,6,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GetResponse) Reset()         { *m = GetResponse{} }
func (m *GetResponse) String() string { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()    {}
func (*GetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{1}
}
func (m *GetResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetResponse.Merge(m, src)
}
func (m *GetResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetResponse proto.InternalMessageInfo

func (m *GetResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *GetResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *GetResponse) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *GetResponse) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

func (m *GetResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Scan fetches values for a range of keys; it is part of the transaction with
// starting timestamp = `version`.
type ScanRequest struct {
	Context  *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// The maximum number of results to return.
	Limit   uint32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	Version uint64 `protobuf:"varint,4,opt,name=version,proto3" json:"version,omitempty"`
	// Return only the keys found by scanning, not their values.
	KeyOnly bool `protobuf:"varint,5,opt,name=key_only,json=keyOnly,proto3" json:"key_only,omitempty"`
	Reverse bool `protobuf:"varint,6,opt,name=reverse,proto3" json:"reverse,omitempty"`
	// For compatibility, when scanning forward, the range to scan is [start_key, end_key), where start_key < end_key;
	// and when scanning backward, it scans [end_key, start_key) in descending order, where end_key < start_key.
	EndKey []byte `protobuf:"bytes,7,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// If sample_step > 0, skips 'sample_step - 1' number of keys after each returned key.
	// locks are not checked.
	SampleStep           uint32   `protobuf:"varint,8,opt,name=sample_step,json=sampleStep,proto3" json:"sample_step,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanRequest) Reset()         { *m = ScanRequest{} }
func (m *ScanRequest) String() string { return proto.CompactTextString(m) }
func (*ScanRequest) ProtoMessage()    {}
func (*ScanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{2}
}
func (m *ScanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanRequest.Merge(m, src)
}
func (m *ScanRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScanRequest proto.InternalMessageInfo

func (m *ScanRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ScanRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *ScanRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ScanRequest) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *ScanRequest) GetKeyOnly() bool {
	if m != nil {
		return m.KeyOnly
	}
	return false
}

func (m *ScanRequest) GetReverse() bool {
	if m != nil {
		return m.Reverse
	}
	return false
}

func (m *ScanRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *ScanRequest) GetSampleStep() uint32 {
	if m != nil {
		return m.SampleStep
	}
	return 0
}

type ScanResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	// Each KvPair may contain a key error.
	Pairs []*KvPair `protobuf:"bytes,2,rep,name=pairs,proto3" json:"pairs,omitempty"`
	// This KeyError exists when some key is locked but we cannot check locks of all keys.
	// In this case, `pairs` should be empty and the client should redo scanning all the keys
	// after resolving the lock.
	Error                *KeyError `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ScanResponse) Reset()         { *m = ScanResponse{} }
func (m *ScanResponse) String() string { return proto.CompactTextString(m) }
func (*ScanResponse) ProtoMessage()    {}
func (*ScanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{3}
}
func (m *ScanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanResponse.Merge(m, src)
}
func (m *ScanResponse) XXX_Size() int {
	return m.Size()
}
func (m *ScanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScanResponse proto.InternalMessageInfo

func (m *ScanResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *ScanResponse) GetPairs() []*KvPair {
	if m != nil {
		return m.Pairs
	}
	return nil
}

func (m *ScanResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

// A prewrite is the first phase of writing to TiKV. It contains all data to be written in a transaction.
// TiKV will write the data in a preliminary state. Data cannot be read until it has been committed.
// The client should only commit a transaction once all prewrites succeed.
type PrewriteRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The data to be written to the database.
	Mutations []*Mutation `protobuf:"bytes,2,rep,name=mutations,proto3" json:"mutations,omitempty"`
	// The client picks one key to be primary (unrelated to the primary key concept in SQL). This
	// key's lock is the source of truth for the state of a transaction. All other locks due to a
	// transaction will point to the primary lock.
	PrimaryLock []byte `protobuf:"bytes,3,opt,name=primary_lock,json=primaryLock,proto3" json:"primary_lock,omitempty"`
	// Identifies the transaction being written.
	StartVersion uint64 `protobuf:"varint,4,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	LockTtl      uint64 `protobuf:"varint,5,opt,name=lock_ttl,json=lockTtl,proto3" json:"lock_ttl,omitempty"`
	// TiKV can skip some checks, used for speeding up data migration.
	SkipConstraintCheck bool `protobuf:"varint,6,opt,name=skip_constraint_check,json=skipConstraintCheck,proto3" json:"skip_constraint_check,omitempty"`
	// For pessimistic transaction, some mutations don't need to be locked, for example, non-unique index key.
	// Keys with deferred constraint checks are not locked.
	PessimisticActions []PrewriteRequest_PessimisticAction `protobuf:"varint,7,rep,packed,name=pessimistic_actions,json=pessimisticActions,proto3,enum=kvrpcpb.PrewriteRequest_PessimisticAction" json:"pessimistic_actions,omitempty"`
	// How many keys this transaction involves in this region.
	TxnSize uint64 `protobuf:"varint,8,opt,name=txn_size,json=txnSize,proto3" json:"txn_size,omitempty"`
	// For pessimistic transactions only; used to check if a conflict lock is already committed.
	ForUpdateTs uint64 `protobuf:"varint,9,opt,name=for_update_ts,json=forUpdateTs,proto3" json:"for_update_ts,omitempty"`
	// If min_commit_ts > 0, this is a large transaction request, the final commit_ts
	// will be inferred from `min_commit_ts`.
	MinCommitTs uint64 `protobuf:"varint,10,opt,name=min_commit_ts,json=minCommitTs,proto3" json:"min_commit_ts,omitempty"`
	// When async commit is enabled, `secondaries` should be set as the key list of all secondary
	// locks if the request prewrites the primary lock.
	UseAsyncCommit bool     `protobuf:"varint,11,opt,name=use_async_commit,json=useAsyncCommit,proto3" json:"use_async_commit,omitempty"`
	Secondaries    [][]byte `protobuf:"bytes,12,rep,name=secondaries,proto3" json:"secondaries,omitempty"`
	// When the transaction involves only one region, it's possible to commit the transaction
	// directly with 1PC protocol.
	TryOnePc bool `protobuf:"varint,13,opt,name=try_one_pc,json=tryOnePc,proto3" json:"try_one_pc,omitempty"`
	// The max commit ts is reserved for limiting the commit ts of 1PC or async commit, which can be used to avoid
	// inconsistency with schema change.
	MaxCommitTs uint64 `protobuf:"varint,14,opt,name=max_commit_ts,json=maxCommitTs,proto3" json:"max_commit_ts,omitempty"`
	// The level of assertion to use on this prewrte request.
	AssertionLevel       AssertionLevel `protobuf:"varint,15,opt,name=assertion_level,json=assertionLevel,proto3,enum=kvrpcpb.AssertionLevel" json:"assertion_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PrewriteRequest) Reset()         { *m = PrewriteRequest{} }
func (m *PrewriteRequest) String() string { return proto.CompactTextString(m) }
func (*PrewriteRequest) ProtoMessage()    {}
func (*PrewriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{4}
}
func (m *PrewriteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrewriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrewriteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrewriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrewriteRequest.Merge(m, src)
}
func (m *PrewriteRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrewriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrewriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrewriteRequest proto.InternalMessageInfo

func (m *PrewriteRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *PrewriteRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

func (m *PrewriteRequest) GetPrimaryLock() []byte {
	if m != nil {
		return m.PrimaryLock
	}
	return nil
}

func (m *PrewriteRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *PrewriteRequest) GetLockTtl() uint64 {
	if m != nil {
		return m.LockTtl
	}
	return 0
}

func (m *PrewriteRequest) GetSkipConstraintCheck() bool {
	if m != nil {
		return m.SkipConstraintCheck
	}
	return false
}

func (m *PrewriteRequest) GetPessimisticActions() []PrewriteRequest_PessimisticAction {
	if m != nil {
		return m.PessimisticActions
	}
	return nil
}

func (m *PrewriteRequest) GetTxnSize() uint64 {
	if m != nil {
		return m.TxnSize
	}
	return 0
}

func (m *PrewriteRequest) GetForUpdateTs() uint64 {
	if m != nil {
		return m.ForUpdateTs
	}
	return 0
}

func (m *PrewriteRequest) GetMinCommitTs() uint64 {
	if m != nil {
		return m.MinCommitTs
	}
	return 0
}

func (m *PrewriteRequest) GetUseAsyncCommit() bool {
	if m != nil {
		return m.UseAsyncCommit
	}
	return false
}

func (m *PrewriteRequest) GetSecondaries() [][]byte {
	if m != nil {
		return m.Secondaries
	}
	return nil
}

func (m *PrewriteRequest) GetTryOnePc() bool {
	if m != nil {
		return m.TryOnePc
	}
	return false
}

func (m *PrewriteRequest) GetMaxCommitTs() uint64 {
	if m != nil {
		return m.MaxCommitTs
	}
	return 0
}

func (m *PrewriteRequest) GetAssertionLevel() AssertionLevel {
	if m != nil {
		return m.AssertionLevel
	}
	return AssertionLevel_Off
}

type PrewriteResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Errors      []*KeyError    `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	// 0 if the min_commit_ts is not ready or any other reason that async
	// commit cannot proceed. The client can then fallback to normal way to
	// continue committing the transaction if prewrite are all finished.
	MinCommitTs uint64 `protobuf:"varint,3,opt,name=min_commit_ts,json=minCommitTs,proto3" json:"min_commit_ts,omitempty"`
	// When the transaction is successfully committed with 1PC protocol, this field will be set to
	// the commit ts of the transaction. Otherwise, if TiKV failed to commit it with 1PC or the
	// transaction is not 1PC, the value will be 0.
	OnePcCommitTs uint64 `protobuf:"varint,4,opt,name=one_pc_commit_ts,json=onePcCommitTs,proto3" json:"one_pc_commit_ts,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,5,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PrewriteResponse) Reset()         { *m = PrewriteResponse{} }
func (m *PrewriteResponse) String() string { return proto.CompactTextString(m) }
func (*PrewriteResponse) ProtoMessage()    {}
func (*PrewriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{5}
}
func (m *PrewriteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrewriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrewriteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrewriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrewriteResponse.Merge(m, src)
}
func (m *PrewriteResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrewriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrewriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrewriteResponse proto.InternalMessageInfo

func (m *PrewriteResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *PrewriteResponse) GetErrors() []*KeyError {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *PrewriteResponse) GetMinCommitTs() uint64 {
	if m != nil {
		return m.MinCommitTs
	}
	return 0
}

func (m *PrewriteResponse) GetOnePcCommitTs() uint64 {
	if m != nil {
		return m.OnePcCommitTs
	}
	return 0
}

func (m *PrewriteResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Lock a set of keys to prepare to write to them.
type PessimisticLockRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// In this case every `Op` of the mutations must be `PessimisticLock`.
	Mutations    []*Mutation `protobuf:"bytes,2,rep,name=mutations,proto3" json:"mutations,omitempty"`
	PrimaryLock  []byte      `protobuf:"bytes,3,opt,name=primary_lock,json=primaryLock,proto3" json:"primary_lock,omitempty"`
	StartVersion uint64      `protobuf:"varint,4,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	LockTtl      uint64      `protobuf:"varint,5,opt,name=lock_ttl,json=lockTtl,proto3" json:"lock_ttl,omitempty"`
	// Each locking command in a pessimistic transaction has its own timestamp. If locking fails, then
	// the corresponding SQL statement can be retried with a later timestamp, TiDB does not need to
	// retry the whole transaction. The name comes from the `SELECT ... FOR UPDATE` SQL statement which
	// is a locking read. Each `SELECT ... FOR UPDATE` in a transaction will be assigned its own
	// timestamp.
	ForUpdateTs uint64 `protobuf:"varint,6,opt,name=for_update_ts,json=forUpdateTs,proto3" json:"for_update_ts,omitempty"`
	// If the request is the first lock request, we don't need to detect deadlock.
	IsFirstLock bool `protobuf:"varint,7,opt,name=is_first_lock,json=isFirstLock,proto3" json:"is_first_lock,omitempty"`
	// Time to wait for lock released in milliseconds when encountering locks.
	// 0 means using default timeout in TiKV. Negative means no wait.
	WaitTimeout int64 `protobuf:"varint,8,opt,name=wait_timeout,json=waitTimeout,proto3" json:"wait_timeout,omitempty"`
	// If it is true, TiKV will acquire the pessimistic lock regardless of write conflict
	// and return the latest value. It's only supported for single mutation.
	Force bool `protobuf:"varint,9,opt,name=force,proto3" json:"force,omitempty"` // Deprecated: Do not use.
	// If it is true, TiKV will return values of the keys if no error, so TiDB can cache the values for
	// later read in the same transaction.
	// When 'force' is set to true, this field is ignored.
	ReturnValues bool `protobuf:"varint,10,opt,name=return_values,json=returnValues,proto3" json:"return_values,omitempty"`
	// If min_commit_ts > 0, this is large transaction proto, the final commit_ts
	// would be infered from min_commit_ts.
	MinCommitTs uint64 `protobuf:"varint,11,opt,name=min_commit_ts,json=minCommitTs,proto3" json:"min_commit_ts,omitempty"`
	// If set to true, it means TiKV need to check if the key exists, and return the result in
	// the `not_founds` feild in the response. This works no matter if `return_values` is set. If
	// `return_values` is set, it simply makes no difference; otherwise, the `value` field of the
	// repsonse will be empty while the `not_founds` field still indicates the keys' existence.
	CheckExistence bool `protobuf:"varint,12,opt,name=check_existence,json=checkExistence,proto3" json:"check_existence,omitempty"`
	// TiKV lock the record only when it exists
	LockOnlyIfExists bool `protobuf:"varint,13,opt,name=lock_only_if_exists,json=lockOnlyIfExists,proto3" json:"lock_only_if_exists,omitempty"`
	// Specifies the behavior when the request is woken up after wating for lock of another transaction.
	WakeUpMode           PessimisticLockWakeUpMode `protobuf:"varint,14,opt,name=wake_up_mode,json=wakeUpMode,proto3,enum=kvrpcpb.PessimisticLockWakeUpMode" json:"wake_up_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *PessimisticLockRequest) Reset()         { *m = PessimisticLockRequest{} }
func (m *PessimisticLockRequest) String() string { return proto.CompactTextString(m) }
func (*PessimisticLockRequest) ProtoMessage()    {}
func (*PessimisticLockRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{6}
}
func (m *PessimisticLockRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PessimisticLockRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PessimisticLockRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PessimisticLockRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PessimisticLockRequest.Merge(m, src)
}
func (m *PessimisticLockRequest) XXX_Size() int {
	return m.Size()
}
func (m *PessimisticLockRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PessimisticLockRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PessimisticLockRequest proto.InternalMessageInfo

func (m *PessimisticLockRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *PessimisticLockRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

func (m *PessimisticLockRequest) GetPrimaryLock() []byte {
	if m != nil {
		return m.PrimaryLock
	}
	return nil
}

func (m *PessimisticLockRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *PessimisticLockRequest) GetLockTtl() uint64 {
	if m != nil {
		return m.LockTtl
	}
	return 0
}

func (m *PessimisticLockRequest) GetForUpdateTs() uint64 {
	if m != nil {
		return m.ForUpdateTs
	}
	return 0
}

func (m *PessimisticLockRequest) GetIsFirstLock() bool {
	if m != nil {
		return m.IsFirstLock
	}
	return false
}

func (m *PessimisticLockRequest) GetWaitTimeout() int64 {
	if m != nil {
		return m.WaitTimeout
	}
	return 0
}

// Deprecated: Do not use.
func (m *PessimisticLockRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *PessimisticLockRequest) GetReturnValues() bool {
	if m != nil {
		return m.ReturnValues
	}
	return false
}

func (m *PessimisticLockRequest) GetMinCommitTs() uint64 {
	if m != nil {
		return m.MinCommitTs
	}
	return 0
}

func (m *PessimisticLockRequest) GetCheckExistence() bool {
	if m != nil {
		return m.CheckExistence
	}
	return false
}

func (m *PessimisticLockRequest) GetLockOnlyIfExists() bool {
	if m != nil {
		return m.LockOnlyIfExists
	}
	return false
}

func (m *PessimisticLockRequest) GetWakeUpMode() PessimisticLockWakeUpMode {
	if m != nil {
		return m.WakeUpMode
	}
	return PessimisticLockWakeUpMode_WakeUpModeNormal
}

type PessimisticLockKeyResult struct {
	Type      PessimisticLockKeyResultType `protobuf:"varint,1,opt,name=type,proto3,enum=kvrpcpb.PessimisticLockKeyResultType" json:"type,omitempty"`
	Value     []byte                       `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Existence bool                         `protobuf:"varint,3,opt,name=existence,proto3" json:"existence,omitempty"`
	// We allow a key be locked when there is write conflict (latest commit_ts > for_update_ts).
	// In this case, the key is semantically locked by a newer for_update_ts.
	// For each requested key, the field is non-zero if the key is locked with write conflict, and it
	// equals to the commit_ts of the latest version of the specified key. The for_update_ts field
	// of the lock that's actually written to TiKV will also be this value. At the same time,
	// `value` and `existence` will be returned regardless to how `return_values` and
	// `check_existence` are set.
	LockedWithConflictTs uint64 `protobuf:"varint,4,opt,name=locked_with_conflict_ts,json=lockedWithConflictTs,proto3" json:"locked_with_conflict_ts,omitempty"`
	// Hint the client that resolving lock is not needed for this lock. For `PessimisticLock`
	// requests only.
	SkipResolvingLock    bool     `protobuf:"varint,11,opt,name=skip_resolving_lock,json=skipResolvingLock,proto3" json:"skip_resolving_lock,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PessimisticLockKeyResult) Reset()         { *m = PessimisticLockKeyResult{} }
func (m *PessimisticLockKeyResult) String() string { return proto.CompactTextString(m) }
func (*PessimisticLockKeyResult) ProtoMessage()    {}
func (*PessimisticLockKeyResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{7}
}
func (m *PessimisticLockKeyResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PessimisticLockKeyResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PessimisticLockKeyResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PessimisticLockKeyResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PessimisticLockKeyResult.Merge(m, src)
}
func (m *PessimisticLockKeyResult) XXX_Size() int {
	return m.Size()
}
func (m *PessimisticLockKeyResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PessimisticLockKeyResult.DiscardUnknown(m)
}

var xxx_messageInfo_PessimisticLockKeyResult proto.InternalMessageInfo

func (m *PessimisticLockKeyResult) GetType() PessimisticLockKeyResultType {
	if m != nil {
		return m.Type
	}
	return PessimisticLockKeyResultType_LockResultNormal
}

func (m *PessimisticLockKeyResult) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PessimisticLockKeyResult) GetExistence() bool {
	if m != nil {
		return m.Existence
	}
	return false
}

func (m *PessimisticLockKeyResult) GetLockedWithConflictTs() uint64 {
	if m != nil {
		return m.LockedWithConflictTs
	}
	return 0
}

func (m *PessimisticLockKeyResult) GetSkipResolvingLock() bool {
	if m != nil {
		return m.SkipResolvingLock
	}
	return false
}

type PessimisticLockResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Errors      []*KeyError    `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	// It carries the latest value and its commit ts if force in PessimisticLockRequest is true.
	CommitTs uint64 `protobuf:"varint,3,opt,name=commit_ts,json=commitTs,proto3" json:"commit_ts,omitempty"` // Deprecated: Do not use.
	Value    []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`                        // Deprecated: Do not use.
	// The values is set if 'return_values' is true in the request and no error.
	// If 'force' is true, this field is not used.
	// Only used when `wake_up_mode` is `WakeUpModeNormal`.
	Values [][]byte `protobuf:"bytes,5,rep,name=values,proto3" json:"values,omitempty"`
	// Indicates whether the values at the same index is correspond to an existing key.
	// In legacy TiKV, this field is not used even 'force' is false. In that case, an empty value indicates
	// two possible situations: (1) the key does not exist. (2) the key exists but the value is empty.
	// Only used when `wake_up_mode` is `WakeUpModeNormal`.
	NotFounds []bool `protobuf:"varint,6,rep,packed,name=not_founds,json=notFounds,proto3" json:"not_founds,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2 *ExecDetailsV2 `protobuf:"bytes,7,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	// Results of the request. Only used when `wake_up_mode` is `WakeUpModeForceLock`.
	Results              []*PessimisticLockKeyResult `protobuf:"bytes,8,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PessimisticLockResponse) Reset()         { *m = PessimisticLockResponse{} }
func (m *PessimisticLockResponse) String() string { return proto.CompactTextString(m) }
func (*PessimisticLockResponse) ProtoMessage()    {}
func (*PessimisticLockResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{8}
}
func (m *PessimisticLockResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PessimisticLockResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PessimisticLockResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PessimisticLockResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PessimisticLockResponse.Merge(m, src)
}
func (m *PessimisticLockResponse) XXX_Size() int {
	return m.Size()
}
func (m *PessimisticLockResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PessimisticLockResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PessimisticLockResponse proto.InternalMessageInfo

func (m *PessimisticLockResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *PessimisticLockResponse) GetErrors() []*KeyError {
	if m != nil {
		return m.Errors
	}
	return nil
}

// Deprecated: Do not use.
func (m *PessimisticLockResponse) GetCommitTs() uint64 {
	if m != nil {
		return m.CommitTs
	}
	return 0
}

// Deprecated: Do not use.
func (m *PessimisticLockResponse) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PessimisticLockResponse) GetValues() [][]byte {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *PessimisticLockResponse) GetNotFounds() []bool {
	if m != nil {
		return m.NotFounds
	}
	return nil
}

func (m *PessimisticLockResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

func (m *PessimisticLockResponse) GetResults() []*PessimisticLockKeyResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// Unlock keys locked using `PessimisticLockRequest`.
type PessimisticRollbackRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartVersion         uint64   `protobuf:"varint,2,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	ForUpdateTs          uint64   `protobuf:"varint,3,opt,name=for_update_ts,json=forUpdateTs,proto3" json:"for_update_ts,omitempty"`
	Keys                 [][]byte `protobuf:"bytes,4,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PessimisticRollbackRequest) Reset()         { *m = PessimisticRollbackRequest{} }
func (m *PessimisticRollbackRequest) String() string { return proto.CompactTextString(m) }
func (*PessimisticRollbackRequest) ProtoMessage()    {}
func (*PessimisticRollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{9}
}
func (m *PessimisticRollbackRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PessimisticRollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PessimisticRollbackRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PessimisticRollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PessimisticRollbackRequest.Merge(m, src)
}
func (m *PessimisticRollbackRequest) XXX_Size() int {
	return m.Size()
}
func (m *PessimisticRollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PessimisticRollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PessimisticRollbackRequest proto.InternalMessageInfo

func (m *PessimisticRollbackRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *PessimisticRollbackRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *PessimisticRollbackRequest) GetForUpdateTs() uint64 {
	if m != nil {
		return m.ForUpdateTs
	}
	return 0
}

func (m *PessimisticRollbackRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

type PessimisticRollbackResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Errors      []*KeyError    `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,3,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PessimisticRollbackResponse) Reset()         { *m = PessimisticRollbackResponse{} }
func (m *PessimisticRollbackResponse) String() string { return proto.CompactTextString(m) }
func (*PessimisticRollbackResponse) ProtoMessage()    {}
func (*PessimisticRollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{10}
}
func (m *PessimisticRollbackResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PessimisticRollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PessimisticRollbackResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PessimisticRollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PessimisticRollbackResponse.Merge(m, src)
}
func (m *PessimisticRollbackResponse) XXX_Size() int {
	return m.Size()
}
func (m *PessimisticRollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PessimisticRollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PessimisticRollbackResponse proto.InternalMessageInfo

func (m *PessimisticRollbackResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *PessimisticRollbackResponse) GetErrors() []*KeyError {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *PessimisticRollbackResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Used to update the lock_ttl of a psessimistic and/or large transaction to prevent it from been killed.
type TxnHeartBeatRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The key of the lock to update.
	PrimaryLock []byte `protobuf:"bytes,2,opt,name=primary_lock,json=primaryLock,proto3" json:"primary_lock,omitempty"`
	// Start timestamp of the large transaction.
	StartVersion uint64 `protobuf:"varint,3,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	// The new TTL the sender would like.
	AdviseLockTtl        uint64   `protobuf:"varint,4,opt,name=advise_lock_ttl,json=adviseLockTtl,proto3" json:"advise_lock_ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TxnHeartBeatRequest) Reset()         { *m = TxnHeartBeatRequest{} }
func (m *TxnHeartBeatRequest) String() string { return proto.CompactTextString(m) }
func (*TxnHeartBeatRequest) ProtoMessage()    {}
func (*TxnHeartBeatRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{11}
}
func (m *TxnHeartBeatRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnHeartBeatRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxnHeartBeatRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxnHeartBeatRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnHeartBeatRequest.Merge(m, src)
}
func (m *TxnHeartBeatRequest) XXX_Size() int {
	return m.Size()
}
func (m *TxnHeartBeatRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnHeartBeatRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TxnHeartBeatRequest proto.InternalMessageInfo

func (m *TxnHeartBeatRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *TxnHeartBeatRequest) GetPrimaryLock() []byte {
	if m != nil {
		return m.PrimaryLock
	}
	return nil
}

func (m *TxnHeartBeatRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *TxnHeartBeatRequest) GetAdviseLockTtl() uint64 {
	if m != nil {
		return m.AdviseLockTtl
	}
	return 0
}

type TxnHeartBeatResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// The TTL actually set on the requested lock.
	LockTtl uint64 `protobuf:"varint,3,opt,name=lock_ttl,json=lockTtl,proto3" json:"lock_ttl,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,4,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TxnHeartBeatResponse) Reset()         { *m = TxnHeartBeatResponse{} }
func (m *TxnHeartBeatResponse) String() string { return proto.CompactTextString(m) }
func (*TxnHeartBeatResponse) ProtoMessage()    {}
func (*TxnHeartBeatResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{12}
}
func (m *TxnHeartBeatResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnHeartBeatResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxnHeartBeatResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxnHeartBeatResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnHeartBeatResponse.Merge(m, src)
}
func (m *TxnHeartBeatResponse) XXX_Size() int {
	return m.Size()
}
func (m *TxnHeartBeatResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnHeartBeatResponse.DiscardUnknown(m)
}

var xxx_messageInfo_TxnHeartBeatResponse proto.InternalMessageInfo

func (m *TxnHeartBeatResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *TxnHeartBeatResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *TxnHeartBeatResponse) GetLockTtl() uint64 {
	if m != nil {
		return m.LockTtl
	}
	return 0
}

func (m *TxnHeartBeatResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// CheckTxnStatusRequest checks the status of a transaction.
// If the transaction is rollbacked/committed, return that result.
// If the TTL of the transaction is exhausted, abort that transaction and inform the caller.
// Otherwise, returns the TTL information for the transaction.
// CheckTxnStatusRequest may also push forward the minCommitTS of a large transaction.
type CheckTxnStatusRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Primary key and lock ts together to locate the primary lock of a transaction.
	PrimaryKey []byte `protobuf:"bytes,2,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	// Starting timestamp of the transaction being checked.
	LockTs uint64 `protobuf:"varint,3,opt,name=lock_ts,json=lockTs,proto3" json:"lock_ts,omitempty"`
	// The start timestamp of the transaction which this request is part of.
	CallerStartTs uint64 `protobuf:"varint,4,opt,name=caller_start_ts,json=callerStartTs,proto3" json:"caller_start_ts,omitempty"`
	// The client must specify the current time to TiKV using this timestamp. It is used to check TTL
	// timeouts. It may be inaccurate.
	CurrentTs uint64 `protobuf:"varint,5,opt,name=current_ts,json=currentTs,proto3" json:"current_ts,omitempty"`
	// If true, then TiKV will leave a rollback tombstone in the write CF for `primary_key`, even if
	// that key is not locked.
	RollbackIfNotExist bool `protobuf:"varint,6,opt,name=rollback_if_not_exist,json=rollbackIfNotExist,proto3" json:"rollback_if_not_exist,omitempty"`
	// This field is set to true only if the transaction is known to fall back from async commit.
	// Then, CheckTxnStatus treats the transaction as non-async-commit even if the use_async_commit
	// field in the primary lock is true.
	ForceSyncCommit bool `protobuf:"varint,7,opt,name=force_sync_commit,json=forceSyncCommit,proto3" json:"force_sync_commit,omitempty"`
	// If the check request is used to resolve or decide the transaction status for a input pessimistic
	// lock, the transaction status could not be decided if the primary lock is pessimistic too and
	// it's still uncertain.
	ResolvingPessimisticLock bool     `protobuf:"varint,8,opt,name=resolving_pessimistic_lock,json=resolvingPessimisticLock,proto3" json:"resolving_pessimistic_lock,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *CheckTxnStatusRequest) Reset()         { *m = CheckTxnStatusRequest{} }
func (m *CheckTxnStatusRequest) String() string { return proto.CompactTextString(m) }
func (*CheckTxnStatusRequest) ProtoMessage()    {}
func (*CheckTxnStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{13}
}
func (m *CheckTxnStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckTxnStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckTxnStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckTxnStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckTxnStatusRequest.Merge(m, src)
}
func (m *CheckTxnStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckTxnStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckTxnStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckTxnStatusRequest proto.InternalMessageInfo

func (m *CheckTxnStatusRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CheckTxnStatusRequest) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *CheckTxnStatusRequest) GetLockTs() uint64 {
	if m != nil {
		return m.LockTs
	}
	return 0
}

func (m *CheckTxnStatusRequest) GetCallerStartTs() uint64 {
	if m != nil {
		return m.CallerStartTs
	}
	return 0
}

func (m *CheckTxnStatusRequest) GetCurrentTs() uint64 {
	if m != nil {
		return m.CurrentTs
	}
	return 0
}

func (m *CheckTxnStatusRequest) GetRollbackIfNotExist() bool {
	if m != nil {
		return m.RollbackIfNotExist
	}
	return false
}

func (m *CheckTxnStatusRequest) GetForceSyncCommit() bool {
	if m != nil {
		return m.ForceSyncCommit
	}
	return false
}

func (m *CheckTxnStatusRequest) GetResolvingPessimisticLock() bool {
	if m != nil {
		return m.ResolvingPessimisticLock
	}
	return false
}

type CheckTxnStatusResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Three kinds of transaction status:
	//
	//	locked: lock_ttl > 0
	//	committed: commit_version > 0
	//	rollbacked: lock_ttl = 0 && commit_version = 0
	LockTtl       uint64 `protobuf:"varint,3,opt,name=lock_ttl,json=lockTtl,proto3" json:"lock_ttl,omitempty"`
	CommitVersion uint64 `protobuf:"varint,4,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	// The action performed by TiKV (and why if the action is to rollback).
	Action   Action    `protobuf:"varint,5,opt,name=action,proto3,enum=kvrpcpb.Action" json:"action,omitempty"`
	LockInfo *LockInfo `protobuf:"bytes,6,opt,name=lock_info,json=lockInfo,proto3" json:"lock_info,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,7,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CheckTxnStatusResponse) Reset()         { *m = CheckTxnStatusResponse{} }
func (m *CheckTxnStatusResponse) String() string { return proto.CompactTextString(m) }
func (*CheckTxnStatusResponse) ProtoMessage()    {}
func (*CheckTxnStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{14}
}
func (m *CheckTxnStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckTxnStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckTxnStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckTxnStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckTxnStatusResponse.Merge(m, src)
}
func (m *CheckTxnStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckTxnStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckTxnStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckTxnStatusResponse proto.InternalMessageInfo

func (m *CheckTxnStatusResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *CheckTxnStatusResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CheckTxnStatusResponse) GetLockTtl() uint64 {
	if m != nil {
		return m.LockTtl
	}
	return 0
}

func (m *CheckTxnStatusResponse) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

func (m *CheckTxnStatusResponse) GetAction() Action {
	if m != nil {
		return m.Action
	}
	return Action_NoAction
}

func (m *CheckTxnStatusResponse) GetLockInfo() *LockInfo {
	if m != nil {
		return m.LockInfo
	}
	return nil
}

func (m *CheckTxnStatusResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Part of the async commit protocol, checks for locks on all supplied keys. If a lock is missing,
// does not have a successful status, or belongs to another transaction, TiKV will leave a rollback
// tombstone for that key.
type CheckSecondaryLocksRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Keys    [][]byte `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	// Identifies the transaction we are investigating.
	StartVersion         uint64   `protobuf:"varint,3,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckSecondaryLocksRequest) Reset()         { *m = CheckSecondaryLocksRequest{} }
func (m *CheckSecondaryLocksRequest) String() string { return proto.CompactTextString(m) }
func (*CheckSecondaryLocksRequest) ProtoMessage()    {}
func (*CheckSecondaryLocksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{15}
}
func (m *CheckSecondaryLocksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckSecondaryLocksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckSecondaryLocksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckSecondaryLocksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckSecondaryLocksRequest.Merge(m, src)
}
func (m *CheckSecondaryLocksRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckSecondaryLocksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckSecondaryLocksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckSecondaryLocksRequest proto.InternalMessageInfo

func (m *CheckSecondaryLocksRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CheckSecondaryLocksRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *CheckSecondaryLocksRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

type CheckSecondaryLocksResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// For each key in `keys` in `CheckSecondaryLocks`, there will be a lock in
	// this list if there is a lock present and belonging to the correct transaction,
	// nil otherwise.
	Locks []*LockInfo `protobuf:"bytes,3,rep,name=locks,proto3" json:"locks,omitempty"`
	// If any of the locks have been committed, this is the commit ts used. If no
	// locks have been committed, it will be zero.
	CommitTs uint64 `protobuf:"varint,4,opt,name=commit_ts,json=commitTs,proto3" json:"commit_ts,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,5,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CheckSecondaryLocksResponse) Reset()         { *m = CheckSecondaryLocksResponse{} }
func (m *CheckSecondaryLocksResponse) String() string { return proto.CompactTextString(m) }
func (*CheckSecondaryLocksResponse) ProtoMessage()    {}
func (*CheckSecondaryLocksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{16}
}
func (m *CheckSecondaryLocksResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckSecondaryLocksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckSecondaryLocksResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckSecondaryLocksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckSecondaryLocksResponse.Merge(m, src)
}
func (m *CheckSecondaryLocksResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckSecondaryLocksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckSecondaryLocksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckSecondaryLocksResponse proto.InternalMessageInfo

func (m *CheckSecondaryLocksResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *CheckSecondaryLocksResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CheckSecondaryLocksResponse) GetLocks() []*LockInfo {
	if m != nil {
		return m.Locks
	}
	return nil
}

func (m *CheckSecondaryLocksResponse) GetCommitTs() uint64 {
	if m != nil {
		return m.CommitTs
	}
	return 0
}

func (m *CheckSecondaryLocksResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// The second phase of writing to TiKV. If there are no errors or conflicts, then this request
// commits a transaction so that its data can be read by other transactions.
type CommitRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Identifies the transaction.
	StartVersion uint64 `protobuf:"varint,2,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	// All keys in the transaction (to be committed).
	Keys [][]byte `protobuf:"bytes,3,rep,name=keys,proto3" json:"keys,omitempty"`
	// Timestamp for the end of the transaction. Must be greater than `start_version`.
	CommitVersion        uint64   `protobuf:"varint,4,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{17}
}
func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(m, src)
}
func (m *CommitRequest) XXX_Size() int {
	return m.Size()
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CommitRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *CommitRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *CommitRequest) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

type CommitResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the commit ts is derived from min_commit_ts, this field should be set.
	CommitVersion uint64 `protobuf:"varint,3,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,4,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{18}
}
func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(m, src)
}
func (m *CommitResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

func (m *CommitResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *CommitResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CommitResponse) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

func (m *CommitResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Not yet implemented.
type ImportRequest struct {
	Mutations            []*Mutation `protobuf:"bytes,1,rep,name=mutations,proto3" json:"mutations,omitempty"`
	CommitVersion        uint64      `protobuf:"varint,2,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ImportRequest) Reset()         { *m = ImportRequest{} }
func (m *ImportRequest) String() string { return proto.CompactTextString(m) }
func (*ImportRequest) ProtoMessage()    {}
func (*ImportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{19}
}
func (m *ImportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImportRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportRequest.Merge(m, src)
}
func (m *ImportRequest) XXX_Size() int {
	return m.Size()
}
func (m *ImportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportRequest proto.InternalMessageInfo

func (m *ImportRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

func (m *ImportRequest) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

type ImportResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ImportResponse) Reset()         { *m = ImportResponse{} }
func (m *ImportResponse) String() string { return proto.CompactTextString(m) }
func (*ImportResponse) ProtoMessage()    {}
func (*ImportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{20}
}
func (m *ImportResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ImportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ImportResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ImportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportResponse.Merge(m, src)
}
func (m *ImportResponse) XXX_Size() int {
	return m.Size()
}
func (m *ImportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ImportResponse proto.InternalMessageInfo

func (m *ImportResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *ImportResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Cleanup a key by possibly unlocking it.
// From 4.0 onwards, this message is no longer used.
type CleanupRequest struct {
	Context      *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key          []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	StartVersion uint64   `protobuf:"varint,3,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	// The current timestamp, used in combination with a lock's TTL to determine
	// if the lock has expired. If `current_ts == 0`, then the key will be unlocked
	// irrespective of its TTL.
	CurrentTs            uint64   `protobuf:"varint,4,opt,name=current_ts,json=currentTs,proto3" json:"current_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CleanupRequest) Reset()         { *m = CleanupRequest{} }
func (m *CleanupRequest) String() string { return proto.CompactTextString(m) }
func (*CleanupRequest) ProtoMessage()    {}
func (*CleanupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{21}
}
func (m *CleanupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CleanupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CleanupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CleanupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CleanupRequest.Merge(m, src)
}
func (m *CleanupRequest) XXX_Size() int {
	return m.Size()
}
func (m *CleanupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CleanupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CleanupRequest proto.InternalMessageInfo

func (m *CleanupRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CleanupRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CleanupRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *CleanupRequest) GetCurrentTs() uint64 {
	if m != nil {
		return m.CurrentTs
	}
	return 0
}

type CleanupResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Set if the key is already committed.
	CommitVersion        uint64   `protobuf:"varint,3,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CleanupResponse) Reset()         { *m = CleanupResponse{} }
func (m *CleanupResponse) String() string { return proto.CompactTextString(m) }
func (*CleanupResponse) ProtoMessage()    {}
func (*CleanupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{22}
}
func (m *CleanupResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CleanupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CleanupResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CleanupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CleanupResponse.Merge(m, src)
}
func (m *CleanupResponse) XXX_Size() int {
	return m.Size()
}
func (m *CleanupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CleanupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CleanupResponse proto.InternalMessageInfo

func (m *CleanupResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *CleanupResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CleanupResponse) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

// Similar to a `Get` request.
type BatchGetRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Keys                 [][]byte `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	Version              uint64   `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchGetRequest) Reset()         { *m = BatchGetRequest{} }
func (m *BatchGetRequest) String() string { return proto.CompactTextString(m) }
func (*BatchGetRequest) ProtoMessage()    {}
func (*BatchGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{23}
}
func (m *BatchGetRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BatchGetRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BatchGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetRequest.Merge(m, src)
}
func (m *BatchGetRequest) XXX_Size() int {
	return m.Size()
}
func (m *BatchGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetRequest proto.InternalMessageInfo

func (m *BatchGetRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *BatchGetRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *BatchGetRequest) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type BatchGetResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Pairs       []*KvPair      `protobuf:"bytes,2,rep,name=pairs,proto3" json:"pairs,omitempty"`
	// Time and scan details when processing the request.
	ExecDetailsV2 *ExecDetailsV2 `protobuf:"bytes,4,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	// This KeyError exists when some key is locked but we cannot check locks of all keys.
	// In this case, `pairs` should be empty and the client should redo batch get all the keys
	// after resolving the lock.
	Error                *KeyError `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BatchGetResponse) Reset()         { *m = BatchGetResponse{} }
func (m *BatchGetResponse) String() string { return proto.CompactTextString(m) }
func (*BatchGetResponse) ProtoMessage()    {}
func (*BatchGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{24}
}
func (m *BatchGetResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BatchGetResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BatchGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetResponse.Merge(m, src)
}
func (m *BatchGetResponse) XXX_Size() int {
	return m.Size()
}
func (m *BatchGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetResponse proto.InternalMessageInfo

func (m *BatchGetResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *BatchGetResponse) GetPairs() []*KvPair {
	if m != nil {
		return m.Pairs
	}
	return nil
}

func (m *BatchGetResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

func (m *BatchGetResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

// Rollback a prewritten transaction. This will remove the preliminary data from the database,
// unlock locks, and leave a rollback tombstone.
type BatchRollbackRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Identify the transaction to be rolled back.
	StartVersion uint64 `protobuf:"varint,2,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	// The keys to rollback.
	Keys                 [][]byte `protobuf:"bytes,3,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchRollbackRequest) Reset()         { *m = BatchRollbackRequest{} }
func (m *BatchRollbackRequest) String() string { return proto.CompactTextString(m) }
func (*BatchRollbackRequest) ProtoMessage()    {}
func (*BatchRollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{25}
}
func (m *BatchRollbackRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchRollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BatchRollbackRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BatchRollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchRollbackRequest.Merge(m, src)
}
func (m *BatchRollbackRequest) XXX_Size() int {
	return m.Size()
}
func (m *BatchRollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchRollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchRollbackRequest proto.InternalMessageInfo

func (m *BatchRollbackRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *BatchRollbackRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *BatchRollbackRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

type BatchRollbackResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,3,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *BatchRollbackResponse) Reset()         { *m = BatchRollbackResponse{} }
func (m *BatchRollbackResponse) String() string { return proto.CompactTextString(m) }
func (*BatchRollbackResponse) ProtoMessage()    {}
func (*BatchRollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{26}
}
func (m *BatchRollbackResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BatchRollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BatchRollbackResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BatchRollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchRollbackResponse.Merge(m, src)
}
func (m *BatchRollbackResponse) XXX_Size() int {
	return m.Size()
}
func (m *BatchRollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchRollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchRollbackResponse proto.InternalMessageInfo

func (m *BatchRollbackResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *BatchRollbackResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BatchRollbackResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Scan the database for locks. Used at the start of the GC process to find all
// old locks.
type ScanLockRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Returns all locks with a start timestamp before `max_version`.
	MaxVersion uint64 `protobuf:"varint,2,opt,name=max_version,json=maxVersion,proto3" json:"max_version,omitempty"`
	// Start scanning from this key.
	StartKey []byte `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// The maximum number of locks to return.
	Limit uint32 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	// The exclusive upperbound for scanning.
	EndKey               []byte   `protobuf:"bytes,5,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanLockRequest) Reset()         { *m = ScanLockRequest{} }
func (m *ScanLockRequest) String() string { return proto.CompactTextString(m) }
func (*ScanLockRequest) ProtoMessage()    {}
func (*ScanLockRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{27}
}
func (m *ScanLockRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanLockRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanLockRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanLockRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanLockRequest.Merge(m, src)
}
func (m *ScanLockRequest) XXX_Size() int {
	return m.Size()
}
func (m *ScanLockRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanLockRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScanLockRequest proto.InternalMessageInfo

func (m *ScanLockRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ScanLockRequest) GetMaxVersion() uint64 {
	if m != nil {
		return m.MaxVersion
	}
	return 0
}

func (m *ScanLockRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *ScanLockRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ScanLockRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

type ScanLockResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Info on all locks found by the scan.
	Locks []*LockInfo `protobuf:"bytes,3,rep,name=locks,proto3" json:"locks,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,4,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ScanLockResponse) Reset()         { *m = ScanLockResponse{} }
func (m *ScanLockResponse) String() string { return proto.CompactTextString(m) }
func (*ScanLockResponse) ProtoMessage()    {}
func (*ScanLockResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{28}
}
func (m *ScanLockResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanLockResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanLockResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanLockResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanLockResponse.Merge(m, src)
}
func (m *ScanLockResponse) XXX_Size() int {
	return m.Size()
}
func (m *ScanLockResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanLockResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScanLockResponse proto.InternalMessageInfo

func (m *ScanLockResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *ScanLockResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ScanLockResponse) GetLocks() []*LockInfo {
	if m != nil {
		return m.Locks
	}
	return nil
}

func (m *ScanLockResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// For all keys locked by the transaction identified by `start_version`, either
// commit or rollback the transaction and unlock the key.
type ResolveLockRequest struct {
	Context      *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartVersion uint64   `protobuf:"varint,2,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	// `commit_version == 0` means the transaction was rolled back.
	// `commit_version > 0` means the transaction was committed at the given timestamp.
	CommitVersion uint64     `protobuf:"varint,3,opt,name=commit_version,json=commitVersion,proto3" json:"commit_version,omitempty"`
	TxnInfos      []*TxnInfo `protobuf:"bytes,4,rep,name=txn_infos,json=txnInfos,proto3" json:"txn_infos,omitempty"`
	// Only resolve specified keys.
	Keys                 [][]byte `protobuf:"bytes,5,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResolveLockRequest) Reset()         { *m = ResolveLockRequest{} }
func (m *ResolveLockRequest) String() string { return proto.CompactTextString(m) }
func (*ResolveLockRequest) ProtoMessage()    {}
func (*ResolveLockRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{29}
}
func (m *ResolveLockRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveLockRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResolveLockRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResolveLockRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveLockRequest.Merge(m, src)
}
func (m *ResolveLockRequest) XXX_Size() int {
	return m.Size()
}
func (m *ResolveLockRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveLockRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveLockRequest proto.InternalMessageInfo

func (m *ResolveLockRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ResolveLockRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *ResolveLockRequest) GetCommitVersion() uint64 {
	if m != nil {
		return m.CommitVersion
	}
	return 0
}

func (m *ResolveLockRequest) GetTxnInfos() []*TxnInfo {
	if m != nil {
		return m.TxnInfos
	}
	return nil
}

func (m *ResolveLockRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

type ResolveLockResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Execution details about the request processing.
	ExecDetailsV2        *ExecDetailsV2 `protobuf:"bytes,3,opt,name=exec_details_v2,json=execDetailsV2,proto3" json:"exec_details_v2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ResolveLockResponse) Reset()         { *m = ResolveLockResponse{} }
func (m *ResolveLockResponse) String() string { return proto.CompactTextString(m) }
func (*ResolveLockResponse) ProtoMessage()    {}
func (*ResolveLockResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{30}
}
func (m *ResolveLockResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResolveLockResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResolveLockResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResolveLockResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResolveLockResponse.Merge(m, src)
}
func (m *ResolveLockResponse) XXX_Size() int {
	return m.Size()
}
func (m *ResolveLockResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResolveLockResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResolveLockResponse proto.InternalMessageInfo

func (m *ResolveLockResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *ResolveLockResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ResolveLockResponse) GetExecDetailsV2() *ExecDetailsV2 {
	if m != nil {
		return m.ExecDetailsV2
	}
	return nil
}

// Request TiKV to garbage collect all non-current data older than `safe_point`.
type GCRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	SafePoint            uint64   `protobuf:"varint,2,opt,name=safe_point,json=safePoint,proto3" json:"safe_point,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCRequest) Reset()         { *m = GCRequest{} }
func (m *GCRequest) String() string { return proto.CompactTextString(m) }
func (*GCRequest) ProtoMessage()    {}
func (*GCRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{31}
}
func (m *GCRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCRequest.Merge(m, src)
}
func (m *GCRequest) XXX_Size() int {
	return m.Size()
}
func (m *GCRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GCRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GCRequest proto.InternalMessageInfo

func (m *GCRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *GCRequest) GetSafePoint() uint64 {
	if m != nil {
		return m.SafePoint
	}
	return 0
}

type GCResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                *KeyError      `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GCResponse) Reset()         { *m = GCResponse{} }
func (m *GCResponse) String() string { return proto.CompactTextString(m) }
func (*GCResponse) ProtoMessage()    {}
func (*GCResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{32}
}
func (m *GCResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCResponse.Merge(m, src)
}
func (m *GCResponse) XXX_Size() int {
	return m.Size()
}
func (m *GCResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GCResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GCResponse proto.InternalMessageInfo

func (m *GCResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *GCResponse) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

// Delete a range of data from TiKV.
// This message should not be used.
type DeleteRangeRequest struct {
	Context  *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte   `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// If true, the data will not be immediately deleted, but the operation will
	// still be replicated via Raft. This is used to notify TiKV that the data
	// will be deleted using `unsafe_destroy_range` soon.
	NotifyOnly           bool     `protobuf:"varint,4,opt,name=notify_only,json=notifyOnly,proto3" json:"notify_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRangeRequest) Reset()         { *m = DeleteRangeRequest{} }
func (m *DeleteRangeRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRangeRequest) ProtoMessage()    {}
func (*DeleteRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{33}
}
func (m *DeleteRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteRangeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRangeRequest.Merge(m, src)
}
func (m *DeleteRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRangeRequest proto.InternalMessageInfo

func (m *DeleteRangeRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *DeleteRangeRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *DeleteRangeRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *DeleteRangeRequest) GetNotifyOnly() bool {
	if m != nil {
		return m.NotifyOnly
	}
	return false
}

type DeleteRangeResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *DeleteRangeResponse) Reset()         { *m = DeleteRangeResponse{} }
func (m *DeleteRangeResponse) String() string { return proto.CompactTextString(m) }
func (*DeleteRangeResponse) ProtoMessage()    {}
func (*DeleteRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{34}
}
func (m *DeleteRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteRangeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRangeResponse.Merge(m, src)
}
func (m *DeleteRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeleteRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRangeResponse proto.InternalMessageInfo

func (m *DeleteRangeResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *DeleteRangeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Preparing the flashback for a region/key range will "lock" the region
// so that there is no any read, write or schedule operation could be proposed before
// the actual flashback operation.
type PrepareFlashbackToVersionRequest struct {
	Context  *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte   `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// The `start_ts` which we will use to write a lock to prevent
	// the `resolved_ts` from advancing during the whole process.
	StartTs uint64 `protobuf:"varint,4,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	// The TS version which the data will flashback to later.
	Version              uint64   `protobuf:"varint,5,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrepareFlashbackToVersionRequest) Reset()         { *m = PrepareFlashbackToVersionRequest{} }
func (m *PrepareFlashbackToVersionRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareFlashbackToVersionRequest) ProtoMessage()    {}
func (*PrepareFlashbackToVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{35}
}
func (m *PrepareFlashbackToVersionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrepareFlashbackToVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrepareFlashbackToVersionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrepareFlashbackToVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareFlashbackToVersionRequest.Merge(m, src)
}
func (m *PrepareFlashbackToVersionRequest) XXX_Size() int {
	return m.Size()
}
func (m *PrepareFlashbackToVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareFlashbackToVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareFlashbackToVersionRequest proto.InternalMessageInfo

func (m *PrepareFlashbackToVersionRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *PrepareFlashbackToVersionRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *PrepareFlashbackToVersionRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *PrepareFlashbackToVersionRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *PrepareFlashbackToVersionRequest) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

type PrepareFlashbackToVersionResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PrepareFlashbackToVersionResponse) Reset()         { *m = PrepareFlashbackToVersionResponse{} }
func (m *PrepareFlashbackToVersionResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareFlashbackToVersionResponse) ProtoMessage()    {}
func (*PrepareFlashbackToVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{36}
}
func (m *PrepareFlashbackToVersionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrepareFlashbackToVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrepareFlashbackToVersionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrepareFlashbackToVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareFlashbackToVersionResponse.Merge(m, src)
}
func (m *PrepareFlashbackToVersionResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrepareFlashbackToVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareFlashbackToVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareFlashbackToVersionResponse proto.InternalMessageInfo

func (m *PrepareFlashbackToVersionResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *PrepareFlashbackToVersionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Flashback the region to a specific point with the given `version`, please
// make sure the region is "locked" by `PrepareFlashbackToVersionRequest` first,
// otherwise this request will fail.
type FlashbackToVersionRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The TS version which the data should flashback to.
	Version  uint64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	StartKey []byte `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey   []byte `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	// The `start_ts“ and `commit_ts` which the newly written MVCC version will use.
	// Please make sure the `start_ts` is the same one in `PrepareFlashbackToVersionRequest`.
	StartTs              uint64   `protobuf:"varint,5,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	CommitTs             uint64   `protobuf:"varint,6,opt,name=commit_ts,json=commitTs,proto3" json:"commit_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FlashbackToVersionRequest) Reset()         { *m = FlashbackToVersionRequest{} }
func (m *FlashbackToVersionRequest) String() string { return proto.CompactTextString(m) }
func (*FlashbackToVersionRequest) ProtoMessage()    {}
func (*FlashbackToVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{37}
}
func (m *FlashbackToVersionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlashbackToVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlashbackToVersionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlashbackToVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlashbackToVersionRequest.Merge(m, src)
}
func (m *FlashbackToVersionRequest) XXX_Size() int {
	return m.Size()
}
func (m *FlashbackToVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FlashbackToVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FlashbackToVersionRequest proto.InternalMessageInfo

func (m *FlashbackToVersionRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *FlashbackToVersionRequest) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *FlashbackToVersionRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *FlashbackToVersionRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *FlashbackToVersionRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *FlashbackToVersionRequest) GetCommitTs() uint64 {
	if m != nil {
		return m.CommitTs
	}
	return 0
}

type FlashbackToVersionResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FlashbackToVersionResponse) Reset()         { *m = FlashbackToVersionResponse{} }
func (m *FlashbackToVersionResponse) String() string { return proto.CompactTextString(m) }
func (*FlashbackToVersionResponse) ProtoMessage()    {}
func (*FlashbackToVersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{38}
}
func (m *FlashbackToVersionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FlashbackToVersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FlashbackToVersionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FlashbackToVersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlashbackToVersionResponse.Merge(m, src)
}
func (m *FlashbackToVersionResponse) XXX_Size() int {
	return m.Size()
}
func (m *FlashbackToVersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FlashbackToVersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FlashbackToVersionResponse proto.InternalMessageInfo

func (m *FlashbackToVersionResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *FlashbackToVersionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawGetRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawGetRequest) Reset()         { *m = RawGetRequest{} }
func (m *RawGetRequest) String() string { return proto.CompactTextString(m) }
func (*RawGetRequest) ProtoMessage()    {}
func (*RawGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{39}
}
func (m *RawGetRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawGetRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawGetRequest.Merge(m, src)
}
func (m *RawGetRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawGetRequest proto.InternalMessageInfo

func (m *RawGetRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawGetRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RawGetRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type RawGetResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Value                []byte         `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	NotFound             bool           `protobuf:"varint,4,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawGetResponse) Reset()         { *m = RawGetResponse{} }
func (m *RawGetResponse) String() string { return proto.CompactTextString(m) }
func (*RawGetResponse) ProtoMessage()    {}
func (*RawGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{40}
}
func (m *RawGetResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawGetResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawGetResponse.Merge(m, src)
}
func (m *RawGetResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawGetResponse proto.InternalMessageInfo

func (m *RawGetResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawGetResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *RawGetResponse) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RawGetResponse) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

type RawBatchGetRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Keys                 [][]byte `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawBatchGetRequest) Reset()         { *m = RawBatchGetRequest{} }
func (m *RawBatchGetRequest) String() string { return proto.CompactTextString(m) }
func (*RawBatchGetRequest) ProtoMessage()    {}
func (*RawBatchGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{41}
}
func (m *RawBatchGetRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchGetRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchGetRequest.Merge(m, src)
}
func (m *RawBatchGetRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchGetRequest proto.InternalMessageInfo

func (m *RawBatchGetRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawBatchGetRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *RawBatchGetRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type RawBatchGetResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Pairs                []*KvPair      `protobuf:"bytes,2,rep,name=pairs,proto3" json:"pairs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawBatchGetResponse) Reset()         { *m = RawBatchGetResponse{} }
func (m *RawBatchGetResponse) String() string { return proto.CompactTextString(m) }
func (*RawBatchGetResponse) ProtoMessage()    {}
func (*RawBatchGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{42}
}
func (m *RawBatchGetResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchGetResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchGetResponse.Merge(m, src)
}
func (m *RawBatchGetResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchGetResponse proto.InternalMessageInfo

func (m *RawBatchGetResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawBatchGetResponse) GetPairs() []*KvPair {
	if m != nil {
		return m.Pairs
	}
	return nil
}

type RawPutRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Cf                   string   `protobuf:"bytes,4,opt,name=cf,proto3" json:"cf,omitempty"`
	Ttl                  uint64   `protobuf:"varint,5,opt,name=ttl,proto3" json:"ttl,omitempty"`
	ForCas               bool     `protobuf:"varint,6,opt,name=for_cas,json=forCas,proto3" json:"for_cas,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawPutRequest) Reset()         { *m = RawPutRequest{} }
func (m *RawPutRequest) String() string { return proto.CompactTextString(m) }
func (*RawPutRequest) ProtoMessage()    {}
func (*RawPutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{43}
}
func (m *RawPutRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawPutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawPutRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawPutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPutRequest.Merge(m, src)
}
func (m *RawPutRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawPutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawPutRequest proto.InternalMessageInfo

func (m *RawPutRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawPutRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RawPutRequest) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RawPutRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawPutRequest) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *RawPutRequest) GetForCas() bool {
	if m != nil {
		return m.ForCas
	}
	return false
}

type RawPutResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawPutResponse) Reset()         { *m = RawPutResponse{} }
func (m *RawPutResponse) String() string { return proto.CompactTextString(m) }
func (*RawPutResponse) ProtoMessage()    {}
func (*RawPutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{44}
}
func (m *RawPutResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawPutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawPutResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawPutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawPutResponse.Merge(m, src)
}
func (m *RawPutResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawPutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawPutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawPutResponse proto.InternalMessageInfo

func (m *RawPutResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawPutResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawBatchPutRequest struct {
	Context *Context  `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Pairs   []*KvPair `protobuf:"bytes,2,rep,name=pairs,proto3" json:"pairs,omitempty"`
	Cf      string    `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	Ttl     uint64    `protobuf:"varint,4,opt,name=ttl,proto3" json:"ttl,omitempty"` // Deprecated: Do not use.
	ForCas  bool      `protobuf:"varint,5,opt,name=for_cas,json=forCas,proto3" json:"for_cas,omitempty"`
	// The time-to-live for each keys in seconds, and if the length of `ttls`
	// is exactly one, the ttl will be applied to all keys. Otherwise, the length
	// mismatch between `ttls` and `pairs` will return an error.
	Ttls                 []uint64 `protobuf:"varint,6,rep,packed,name=ttls,proto3" json:"ttls,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawBatchPutRequest) Reset()         { *m = RawBatchPutRequest{} }
func (m *RawBatchPutRequest) String() string { return proto.CompactTextString(m) }
func (*RawBatchPutRequest) ProtoMessage()    {}
func (*RawBatchPutRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{45}
}
func (m *RawBatchPutRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchPutRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchPutRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchPutRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchPutRequest.Merge(m, src)
}
func (m *RawBatchPutRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchPutRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchPutRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchPutRequest proto.InternalMessageInfo

func (m *RawBatchPutRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawBatchPutRequest) GetPairs() []*KvPair {
	if m != nil {
		return m.Pairs
	}
	return nil
}

func (m *RawBatchPutRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

// Deprecated: Do not use.
func (m *RawBatchPutRequest) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *RawBatchPutRequest) GetForCas() bool {
	if m != nil {
		return m.ForCas
	}
	return false
}

func (m *RawBatchPutRequest) GetTtls() []uint64 {
	if m != nil {
		return m.Ttls
	}
	return nil
}

type RawBatchPutResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawBatchPutResponse) Reset()         { *m = RawBatchPutResponse{} }
func (m *RawBatchPutResponse) String() string { return proto.CompactTextString(m) }
func (*RawBatchPutResponse) ProtoMessage()    {}
func (*RawBatchPutResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{46}
}
func (m *RawBatchPutResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchPutResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchPutResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchPutResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchPutResponse.Merge(m, src)
}
func (m *RawBatchPutResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchPutResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchPutResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchPutResponse proto.InternalMessageInfo

func (m *RawBatchPutResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawBatchPutResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawDeleteRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	ForCas               bool     `protobuf:"varint,4,opt,name=for_cas,json=forCas,proto3" json:"for_cas,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawDeleteRequest) Reset()         { *m = RawDeleteRequest{} }
func (m *RawDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*RawDeleteRequest) ProtoMessage()    {}
func (*RawDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{47}
}
func (m *RawDeleteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawDeleteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDeleteRequest.Merge(m, src)
}
func (m *RawDeleteRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawDeleteRequest proto.InternalMessageInfo

func (m *RawDeleteRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawDeleteRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RawDeleteRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawDeleteRequest) GetForCas() bool {
	if m != nil {
		return m.ForCas
	}
	return false
}

type RawDeleteResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawDeleteResponse) Reset()         { *m = RawDeleteResponse{} }
func (m *RawDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*RawDeleteResponse) ProtoMessage()    {}
func (*RawDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{48}
}
func (m *RawDeleteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawDeleteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDeleteResponse.Merge(m, src)
}
func (m *RawDeleteResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawDeleteResponse proto.InternalMessageInfo

func (m *RawDeleteResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawDeleteResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawBatchDeleteRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Keys                 [][]byte `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	ForCas               bool     `protobuf:"varint,4,opt,name=for_cas,json=forCas,proto3" json:"for_cas,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawBatchDeleteRequest) Reset()         { *m = RawBatchDeleteRequest{} }
func (m *RawBatchDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*RawBatchDeleteRequest) ProtoMessage()    {}
func (*RawBatchDeleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{49}
}
func (m *RawBatchDeleteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchDeleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchDeleteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchDeleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchDeleteRequest.Merge(m, src)
}
func (m *RawBatchDeleteRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchDeleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchDeleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchDeleteRequest proto.InternalMessageInfo

func (m *RawBatchDeleteRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawBatchDeleteRequest) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *RawBatchDeleteRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawBatchDeleteRequest) GetForCas() bool {
	if m != nil {
		return m.ForCas
	}
	return false
}

type RawBatchDeleteResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawBatchDeleteResponse) Reset()         { *m = RawBatchDeleteResponse{} }
func (m *RawBatchDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*RawBatchDeleteResponse) ProtoMessage()    {}
func (*RawBatchDeleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{50}
}
func (m *RawBatchDeleteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchDeleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchDeleteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchDeleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchDeleteResponse.Merge(m, src)
}
func (m *RawBatchDeleteResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchDeleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchDeleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchDeleteResponse proto.InternalMessageInfo

func (m *RawBatchDeleteResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawBatchDeleteResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawScanRequest struct {
	Context  *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	Limit    uint32   `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	KeyOnly  bool     `protobuf:"varint,4,opt,name=key_only,json=keyOnly,proto3" json:"key_only,omitempty"`
	Cf       string   `protobuf:"bytes,5,opt,name=cf,proto3" json:"cf,omitempty"`
	Reverse  bool     `protobuf:"varint,6,opt,name=reverse,proto3" json:"reverse,omitempty"`
	// For compatibility, when scanning forward, the range to scan is [start_key, end_key), where start_key < end_key;
	// and when scanning backward, it scans [end_key, start_key) in descending order, where end_key < start_key.
	EndKey               []byte   `protobuf:"bytes,7,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawScanRequest) Reset()         { *m = RawScanRequest{} }
func (m *RawScanRequest) String() string { return proto.CompactTextString(m) }
func (*RawScanRequest) ProtoMessage()    {}
func (*RawScanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{51}
}
func (m *RawScanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawScanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawScanRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawScanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawScanRequest.Merge(m, src)
}
func (m *RawScanRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawScanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawScanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawScanRequest proto.InternalMessageInfo

func (m *RawScanRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawScanRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RawScanRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *RawScanRequest) GetKeyOnly() bool {
	if m != nil {
		return m.KeyOnly
	}
	return false
}

func (m *RawScanRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawScanRequest) GetReverse() bool {
	if m != nil {
		return m.Reverse
	}
	return false
}

func (m *RawScanRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

type RawScanResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Kvs                  []*KvPair      `protobuf:"bytes,2,rep,name=kvs,proto3" json:"kvs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawScanResponse) Reset()         { *m = RawScanResponse{} }
func (m *RawScanResponse) String() string { return proto.CompactTextString(m) }
func (*RawScanResponse) ProtoMessage()    {}
func (*RawScanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{52}
}
func (m *RawScanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawScanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawScanResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawScanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawScanResponse.Merge(m, src)
}
func (m *RawScanResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawScanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawScanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawScanResponse proto.InternalMessageInfo

func (m *RawScanResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawScanResponse) GetKvs() []*KvPair {
	if m != nil {
		return m.Kvs
	}
	return nil
}

type RawDeleteRangeRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey             []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Cf                   string   `protobuf:"bytes,4,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawDeleteRangeRequest) Reset()         { *m = RawDeleteRangeRequest{} }
func (m *RawDeleteRangeRequest) String() string { return proto.CompactTextString(m) }
func (*RawDeleteRangeRequest) ProtoMessage()    {}
func (*RawDeleteRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{53}
}
func (m *RawDeleteRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawDeleteRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawDeleteRangeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawDeleteRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDeleteRangeRequest.Merge(m, src)
}
func (m *RawDeleteRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawDeleteRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDeleteRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawDeleteRangeRequest proto.InternalMessageInfo

func (m *RawDeleteRangeRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawDeleteRangeRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RawDeleteRangeRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RawDeleteRangeRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type RawDeleteRangeResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawDeleteRangeResponse) Reset()         { *m = RawDeleteRangeResponse{} }
func (m *RawDeleteRangeResponse) String() string { return proto.CompactTextString(m) }
func (*RawDeleteRangeResponse) ProtoMessage()    {}
func (*RawDeleteRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{54}
}
func (m *RawDeleteRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawDeleteRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawDeleteRangeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawDeleteRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawDeleteRangeResponse.Merge(m, src)
}
func (m *RawDeleteRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawDeleteRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawDeleteRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawDeleteRangeResponse proto.InternalMessageInfo

func (m *RawDeleteRangeResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawDeleteRangeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RawBatchScanRequest struct {
	Context              *Context    `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Ranges               []*KeyRange `protobuf:"bytes,2,rep,name=ranges,proto3" json:"ranges,omitempty"`
	EachLimit            uint32      `protobuf:"varint,3,opt,name=each_limit,json=eachLimit,proto3" json:"each_limit,omitempty"`
	KeyOnly              bool        `protobuf:"varint,4,opt,name=key_only,json=keyOnly,proto3" json:"key_only,omitempty"`
	Cf                   string      `protobuf:"bytes,5,opt,name=cf,proto3" json:"cf,omitempty"`
	Reverse              bool        `protobuf:"varint,6,opt,name=reverse,proto3" json:"reverse,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawBatchScanRequest) Reset()         { *m = RawBatchScanRequest{} }
func (m *RawBatchScanRequest) String() string { return proto.CompactTextString(m) }
func (*RawBatchScanRequest) ProtoMessage()    {}
func (*RawBatchScanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{55}
}
func (m *RawBatchScanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchScanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchScanRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchScanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchScanRequest.Merge(m, src)
}
func (m *RawBatchScanRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchScanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchScanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchScanRequest proto.InternalMessageInfo

func (m *RawBatchScanRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawBatchScanRequest) GetRanges() []*KeyRange {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *RawBatchScanRequest) GetEachLimit() uint32 {
	if m != nil {
		return m.EachLimit
	}
	return 0
}

func (m *RawBatchScanRequest) GetKeyOnly() bool {
	if m != nil {
		return m.KeyOnly
	}
	return false
}

func (m *RawBatchScanRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawBatchScanRequest) GetReverse() bool {
	if m != nil {
		return m.Reverse
	}
	return false
}

type RawBatchScanResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Kvs                  []*KvPair      `protobuf:"bytes,2,rep,name=kvs,proto3" json:"kvs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawBatchScanResponse) Reset()         { *m = RawBatchScanResponse{} }
func (m *RawBatchScanResponse) String() string { return proto.CompactTextString(m) }
func (*RawBatchScanResponse) ProtoMessage()    {}
func (*RawBatchScanResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{56}
}
func (m *RawBatchScanResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawBatchScanResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawBatchScanResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawBatchScanResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawBatchScanResponse.Merge(m, src)
}
func (m *RawBatchScanResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawBatchScanResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawBatchScanResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawBatchScanResponse proto.InternalMessageInfo

func (m *RawBatchScanResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawBatchScanResponse) GetKvs() []*KvPair {
	if m != nil {
		return m.Kvs
	}
	return nil
}

type UnsafeDestroyRangeRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartKey             []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UnsafeDestroyRangeRequest) Reset()         { *m = UnsafeDestroyRangeRequest{} }
func (m *UnsafeDestroyRangeRequest) String() string { return proto.CompactTextString(m) }
func (*UnsafeDestroyRangeRequest) ProtoMessage()    {}
func (*UnsafeDestroyRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{57}
}
func (m *UnsafeDestroyRangeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnsafeDestroyRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnsafeDestroyRangeRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnsafeDestroyRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnsafeDestroyRangeRequest.Merge(m, src)
}
func (m *UnsafeDestroyRangeRequest) XXX_Size() int {
	return m.Size()
}
func (m *UnsafeDestroyRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UnsafeDestroyRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UnsafeDestroyRangeRequest proto.InternalMessageInfo

func (m *UnsafeDestroyRangeRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *UnsafeDestroyRangeRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *UnsafeDestroyRangeRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

type UnsafeDestroyRangeResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UnsafeDestroyRangeResponse) Reset()         { *m = UnsafeDestroyRangeResponse{} }
func (m *UnsafeDestroyRangeResponse) String() string { return proto.CompactTextString(m) }
func (*UnsafeDestroyRangeResponse) ProtoMessage()    {}
func (*UnsafeDestroyRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{58}
}
func (m *UnsafeDestroyRangeResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UnsafeDestroyRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UnsafeDestroyRangeResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UnsafeDestroyRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UnsafeDestroyRangeResponse.Merge(m, src)
}
func (m *UnsafeDestroyRangeResponse) XXX_Size() int {
	return m.Size()
}
func (m *UnsafeDestroyRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UnsafeDestroyRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UnsafeDestroyRangeResponse proto.InternalMessageInfo

func (m *UnsafeDestroyRangeResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *UnsafeDestroyRangeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RegisterLockObserverRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	MaxTs                uint64   `protobuf:"varint,2,opt,name=max_ts,json=maxTs,proto3" json:"max_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterLockObserverRequest) Reset()         { *m = RegisterLockObserverRequest{} }
func (m *RegisterLockObserverRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterLockObserverRequest) ProtoMessage()    {}
func (*RegisterLockObserverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{59}
}
func (m *RegisterLockObserverRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegisterLockObserverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegisterLockObserverRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegisterLockObserverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterLockObserverRequest.Merge(m, src)
}
func (m *RegisterLockObserverRequest) XXX_Size() int {
	return m.Size()
}
func (m *RegisterLockObserverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterLockObserverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterLockObserverRequest proto.InternalMessageInfo

func (m *RegisterLockObserverRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RegisterLockObserverRequest) GetMaxTs() uint64 {
	if m != nil {
		return m.MaxTs
	}
	return 0
}

type RegisterLockObserverResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterLockObserverResponse) Reset()         { *m = RegisterLockObserverResponse{} }
func (m *RegisterLockObserverResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterLockObserverResponse) ProtoMessage()    {}
func (*RegisterLockObserverResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{60}
}
func (m *RegisterLockObserverResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegisterLockObserverResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegisterLockObserverResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegisterLockObserverResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterLockObserverResponse.Merge(m, src)
}
func (m *RegisterLockObserverResponse) XXX_Size() int {
	return m.Size()
}
func (m *RegisterLockObserverResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterLockObserverResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterLockObserverResponse proto.InternalMessageInfo

func (m *RegisterLockObserverResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type CheckLockObserverRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	MaxTs                uint64   `protobuf:"varint,2,opt,name=max_ts,json=maxTs,proto3" json:"max_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckLockObserverRequest) Reset()         { *m = CheckLockObserverRequest{} }
func (m *CheckLockObserverRequest) String() string { return proto.CompactTextString(m) }
func (*CheckLockObserverRequest) ProtoMessage()    {}
func (*CheckLockObserverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{61}
}
func (m *CheckLockObserverRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckLockObserverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckLockObserverRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckLockObserverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckLockObserverRequest.Merge(m, src)
}
func (m *CheckLockObserverRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckLockObserverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckLockObserverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckLockObserverRequest proto.InternalMessageInfo

func (m *CheckLockObserverRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *CheckLockObserverRequest) GetMaxTs() uint64 {
	if m != nil {
		return m.MaxTs
	}
	return 0
}

type CheckLockObserverResponse struct {
	Error                string      `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	IsClean              bool        `protobuf:"varint,2,opt,name=is_clean,json=isClean,proto3" json:"is_clean,omitempty"`
	Locks                []*LockInfo `protobuf:"bytes,3,rep,name=locks,proto3" json:"locks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CheckLockObserverResponse) Reset()         { *m = CheckLockObserverResponse{} }
func (m *CheckLockObserverResponse) String() string { return proto.CompactTextString(m) }
func (*CheckLockObserverResponse) ProtoMessage()    {}
func (*CheckLockObserverResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{62}
}
func (m *CheckLockObserverResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckLockObserverResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckLockObserverResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckLockObserverResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckLockObserverResponse.Merge(m, src)
}
func (m *CheckLockObserverResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckLockObserverResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckLockObserverResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckLockObserverResponse proto.InternalMessageInfo

func (m *CheckLockObserverResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *CheckLockObserverResponse) GetIsClean() bool {
	if m != nil {
		return m.IsClean
	}
	return false
}

func (m *CheckLockObserverResponse) GetLocks() []*LockInfo {
	if m != nil {
		return m.Locks
	}
	return nil
}

type RemoveLockObserverRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	MaxTs                uint64   `protobuf:"varint,2,opt,name=max_ts,json=maxTs,proto3" json:"max_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveLockObserverRequest) Reset()         { *m = RemoveLockObserverRequest{} }
func (m *RemoveLockObserverRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveLockObserverRequest) ProtoMessage()    {}
func (*RemoveLockObserverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{63}
}
func (m *RemoveLockObserverRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveLockObserverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveLockObserverRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveLockObserverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveLockObserverRequest.Merge(m, src)
}
func (m *RemoveLockObserverRequest) XXX_Size() int {
	return m.Size()
}
func (m *RemoveLockObserverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveLockObserverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveLockObserverRequest proto.InternalMessageInfo

func (m *RemoveLockObserverRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RemoveLockObserverRequest) GetMaxTs() uint64 {
	if m != nil {
		return m.MaxTs
	}
	return 0
}

type RemoveLockObserverResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveLockObserverResponse) Reset()         { *m = RemoveLockObserverResponse{} }
func (m *RemoveLockObserverResponse) String() string { return proto.CompactTextString(m) }
func (*RemoveLockObserverResponse) ProtoMessage()    {}
func (*RemoveLockObserverResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{64}
}
func (m *RemoveLockObserverResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RemoveLockObserverResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RemoveLockObserverResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RemoveLockObserverResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveLockObserverResponse.Merge(m, src)
}
func (m *RemoveLockObserverResponse) XXX_Size() int {
	return m.Size()
}
func (m *RemoveLockObserverResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveLockObserverResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveLockObserverResponse proto.InternalMessageInfo

func (m *RemoveLockObserverResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type PhysicalScanLockRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	MaxTs                uint64   `protobuf:"varint,2,opt,name=max_ts,json=maxTs,proto3" json:"max_ts,omitempty"`
	StartKey             []byte   `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	Limit                uint32   `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PhysicalScanLockRequest) Reset()         { *m = PhysicalScanLockRequest{} }
func (m *PhysicalScanLockRequest) String() string { return proto.CompactTextString(m) }
func (*PhysicalScanLockRequest) ProtoMessage()    {}
func (*PhysicalScanLockRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{65}
}
func (m *PhysicalScanLockRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PhysicalScanLockRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PhysicalScanLockRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PhysicalScanLockRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PhysicalScanLockRequest.Merge(m, src)
}
func (m *PhysicalScanLockRequest) XXX_Size() int {
	return m.Size()
}
func (m *PhysicalScanLockRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PhysicalScanLockRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PhysicalScanLockRequest proto.InternalMessageInfo

func (m *PhysicalScanLockRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *PhysicalScanLockRequest) GetMaxTs() uint64 {
	if m != nil {
		return m.MaxTs
	}
	return 0
}

func (m *PhysicalScanLockRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *PhysicalScanLockRequest) GetLimit() uint32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type PhysicalScanLockResponse struct {
	Error                string      `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Locks                []*LockInfo `protobuf:"bytes,2,rep,name=locks,proto3" json:"locks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *PhysicalScanLockResponse) Reset()         { *m = PhysicalScanLockResponse{} }
func (m *PhysicalScanLockResponse) String() string { return proto.CompactTextString(m) }
func (*PhysicalScanLockResponse) ProtoMessage()    {}
func (*PhysicalScanLockResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{66}
}
func (m *PhysicalScanLockResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PhysicalScanLockResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PhysicalScanLockResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PhysicalScanLockResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PhysicalScanLockResponse.Merge(m, src)
}
func (m *PhysicalScanLockResponse) XXX_Size() int {
	return m.Size()
}
func (m *PhysicalScanLockResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PhysicalScanLockResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PhysicalScanLockResponse proto.InternalMessageInfo

func (m *PhysicalScanLockResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *PhysicalScanLockResponse) GetLocks() []*LockInfo {
	if m != nil {
		return m.Locks
	}
	return nil
}

// Sent from PD to a TiKV node.
type SplitRegionRequest struct {
	Context   *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	SplitKey  []byte   `protobuf:"bytes,2,opt,name=split_key,json=splitKey,proto3" json:"split_key,omitempty"` // Deprecated: Do not use.
	SplitKeys [][]byte `protobuf:"bytes,3,rep,name=split_keys,json=splitKeys,proto3" json:"split_keys,omitempty"`
	// Once enabled, the split_key will not be encoded.
	IsRawKv              bool     `protobuf:"varint,4,opt,name=is_raw_kv,json=isRawKv,proto3" json:"is_raw_kv,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SplitRegionRequest) Reset()         { *m = SplitRegionRequest{} }
func (m *SplitRegionRequest) String() string { return proto.CompactTextString(m) }
func (*SplitRegionRequest) ProtoMessage()    {}
func (*SplitRegionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{67}
}
func (m *SplitRegionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplitRegionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplitRegionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplitRegionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitRegionRequest.Merge(m, src)
}
func (m *SplitRegionRequest) XXX_Size() int {
	return m.Size()
}
func (m *SplitRegionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitRegionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitRegionRequest proto.InternalMessageInfo

func (m *SplitRegionRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

// Deprecated: Do not use.
func (m *SplitRegionRequest) GetSplitKey() []byte {
	if m != nil {
		return m.SplitKey
	}
	return nil
}

func (m *SplitRegionRequest) GetSplitKeys() [][]byte {
	if m != nil {
		return m.SplitKeys
	}
	return nil
}

func (m *SplitRegionRequest) GetIsRawKv() bool {
	if m != nil {
		return m.IsRawKv
	}
	return false
}

type SplitRegionResponse struct {
	RegionError          *errorpb.Error   `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Left                 *metapb.Region   `protobuf:"bytes,2,opt,name=left,proto3" json:"left,omitempty"`   // Deprecated: Do not use.
	Right                *metapb.Region   `protobuf:"bytes,3,opt,name=right,proto3" json:"right,omitempty"` // Deprecated: Do not use.
	Regions              []*metapb.Region `protobuf:"bytes,4,rep,name=regions,proto3" json:"regions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *SplitRegionResponse) Reset()         { *m = SplitRegionResponse{} }
func (m *SplitRegionResponse) String() string { return proto.CompactTextString(m) }
func (*SplitRegionResponse) ProtoMessage()    {}
func (*SplitRegionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{68}
}
func (m *SplitRegionResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SplitRegionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SplitRegionResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SplitRegionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitRegionResponse.Merge(m, src)
}
func (m *SplitRegionResponse) XXX_Size() int {
	return m.Size()
}
func (m *SplitRegionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitRegionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitRegionResponse proto.InternalMessageInfo

func (m *SplitRegionResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

// Deprecated: Do not use.
func (m *SplitRegionResponse) GetLeft() *metapb.Region {
	if m != nil {
		return m.Left
	}
	return nil
}

// Deprecated: Do not use.
func (m *SplitRegionResponse) GetRight() *metapb.Region {
	if m != nil {
		return m.Right
	}
	return nil
}

func (m *SplitRegionResponse) GetRegions() []*metapb.Region {
	if m != nil {
		return m.Regions
	}
	return nil
}

// Sent from TiFlash to a TiKV node.
type ReadIndexRequest struct {
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// TiKV checks the given range if there is any unapplied lock
	// blocking the read request.
	StartTs              uint64      `protobuf:"varint,2,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	Ranges               []*KeyRange `protobuf:"bytes,3,rep,name=ranges,proto3" json:"ranges,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ReadIndexRequest) Reset()         { *m = ReadIndexRequest{} }
func (m *ReadIndexRequest) String() string { return proto.CompactTextString(m) }
func (*ReadIndexRequest) ProtoMessage()    {}
func (*ReadIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{69}
}
func (m *ReadIndexRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadIndexRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadIndexRequest.Merge(m, src)
}
func (m *ReadIndexRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReadIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadIndexRequest proto.InternalMessageInfo

func (m *ReadIndexRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ReadIndexRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *ReadIndexRequest) GetRanges() []*KeyRange {
	if m != nil {
		return m.Ranges
	}
	return nil
}

type ReadIndexResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	ReadIndex   uint64         `protobuf:"varint,2,opt,name=read_index,json=readIndex,proto3" json:"read_index,omitempty"`
	// If `locked` is set, this read request is blocked by a lock.
	// The lock should be returned to the client.
	Locked               *LockInfo `protobuf:"bytes,3,opt,name=locked,proto3" json:"locked,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ReadIndexResponse) Reset()         { *m = ReadIndexResponse{} }
func (m *ReadIndexResponse) String() string { return proto.CompactTextString(m) }
func (*ReadIndexResponse) ProtoMessage()    {}
func (*ReadIndexResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{70}
}
func (m *ReadIndexResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadIndexResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadIndexResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadIndexResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadIndexResponse.Merge(m, src)
}
func (m *ReadIndexResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReadIndexResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadIndexResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadIndexResponse proto.InternalMessageInfo

func (m *ReadIndexResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *ReadIndexResponse) GetReadIndex() uint64 {
	if m != nil {
		return m.ReadIndex
	}
	return 0
}

func (m *ReadIndexResponse) GetLocked() *LockInfo {
	if m != nil {
		return m.Locked
	}
	return nil
}

type MvccGetByKeyRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MvccGetByKeyRequest) Reset()         { *m = MvccGetByKeyRequest{} }
func (m *MvccGetByKeyRequest) String() string { return proto.CompactTextString(m) }
func (*MvccGetByKeyRequest) ProtoMessage()    {}
func (*MvccGetByKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{71}
}
func (m *MvccGetByKeyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccGetByKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccGetByKeyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccGetByKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccGetByKeyRequest.Merge(m, src)
}
func (m *MvccGetByKeyRequest) XXX_Size() int {
	return m.Size()
}
func (m *MvccGetByKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccGetByKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MvccGetByKeyRequest proto.InternalMessageInfo

func (m *MvccGetByKeyRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *MvccGetByKeyRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type MvccGetByKeyResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Info                 *MvccInfo      `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MvccGetByKeyResponse) Reset()         { *m = MvccGetByKeyResponse{} }
func (m *MvccGetByKeyResponse) String() string { return proto.CompactTextString(m) }
func (*MvccGetByKeyResponse) ProtoMessage()    {}
func (*MvccGetByKeyResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{72}
}
func (m *MvccGetByKeyResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccGetByKeyResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccGetByKeyResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccGetByKeyResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccGetByKeyResponse.Merge(m, src)
}
func (m *MvccGetByKeyResponse) XXX_Size() int {
	return m.Size()
}
func (m *MvccGetByKeyResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccGetByKeyResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MvccGetByKeyResponse proto.InternalMessageInfo

func (m *MvccGetByKeyResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *MvccGetByKeyResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *MvccGetByKeyResponse) GetInfo() *MvccInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

type MvccGetByStartTsRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	StartTs              uint64   `protobuf:"varint,2,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MvccGetByStartTsRequest) Reset()         { *m = MvccGetByStartTsRequest{} }
func (m *MvccGetByStartTsRequest) String() string { return proto.CompactTextString(m) }
func (*MvccGetByStartTsRequest) ProtoMessage()    {}
func (*MvccGetByStartTsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{73}
}
func (m *MvccGetByStartTsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccGetByStartTsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccGetByStartTsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccGetByStartTsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccGetByStartTsRequest.Merge(m, src)
}
func (m *MvccGetByStartTsRequest) XXX_Size() int {
	return m.Size()
}
func (m *MvccGetByStartTsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccGetByStartTsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MvccGetByStartTsRequest proto.InternalMessageInfo

func (m *MvccGetByStartTsRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *MvccGetByStartTsRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

type MvccGetByStartTsResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Key                  []byte         `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	Info                 *MvccInfo      `protobuf:"bytes,4,opt,name=info,proto3" json:"info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MvccGetByStartTsResponse) Reset()         { *m = MvccGetByStartTsResponse{} }
func (m *MvccGetByStartTsResponse) String() string { return proto.CompactTextString(m) }
func (*MvccGetByStartTsResponse) ProtoMessage()    {}
func (*MvccGetByStartTsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{74}
}
func (m *MvccGetByStartTsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccGetByStartTsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccGetByStartTsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccGetByStartTsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccGetByStartTsResponse.Merge(m, src)
}
func (m *MvccGetByStartTsResponse) XXX_Size() int {
	return m.Size()
}
func (m *MvccGetByStartTsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccGetByStartTsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MvccGetByStartTsResponse proto.InternalMessageInfo

func (m *MvccGetByStartTsResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *MvccGetByStartTsResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *MvccGetByStartTsResponse) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *MvccGetByStartTsResponse) GetInfo() *MvccInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

// Miscellaneous metadata attached to most requests.
type Context struct {
	RegionId       uint64              `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	RegionEpoch    *metapb.RegionEpoch `protobuf:"bytes,2,opt,name=region_epoch,json=regionEpoch,proto3" json:"region_epoch,omitempty"`
	Peer           *metapb.Peer        `protobuf:"bytes,3,opt,name=peer,proto3" json:"peer,omitempty"`
	Term           uint64              `protobuf:"varint,5,opt,name=term,proto3" json:"term,omitempty"`
	Priority       CommandPri          `protobuf:"varint,6,opt,name=priority,proto3,enum=kvrpcpb.CommandPri" json:"priority,omitempty"`
	IsolationLevel IsolationLevel      `protobuf:"varint,7,opt,name=isolation_level,json=isolationLevel,proto3,enum=kvrpcpb.IsolationLevel" json:"isolation_level,omitempty"`
	NotFillCache   bool                `protobuf:"varint,8,opt,name=not_fill_cache,json=notFillCache,proto3" json:"not_fill_cache,omitempty"`
	SyncLog        bool                `protobuf:"varint,9,opt,name=sync_log,json=syncLog,proto3" json:"sync_log,omitempty"`
	// True means execution time statistics should be recorded and returned.
	RecordTimeStat bool `protobuf:"varint,10,opt,name=record_time_stat,json=recordTimeStat,proto3" json:"record_time_stat,omitempty"`
	// True means RocksDB scan statistics should be recorded and returned.
	RecordScanStat bool `protobuf:"varint,11,opt,name=record_scan_stat,json=recordScanStat,proto3" json:"record_scan_stat,omitempty"`
	ReplicaRead    bool `protobuf:"varint,12,opt,name=replica_read,json=replicaRead,proto3" json:"replica_read,omitempty"`
	// Read requests can ignore locks belonging to these transactions because either
	// these transactions are rolled back or theirs commit_ts > read request's start_ts.
	ResolvedLocks          []uint64 `protobuf:"varint,13,rep,packed,name=resolved_locks,json=resolvedLocks,proto3" json:"resolved_locks,omitempty"`
	MaxExecutionDurationMs uint64   `protobuf:"varint,14,opt,name=max_execution_duration_ms,json=maxExecutionDurationMs,proto3" json:"max_execution_duration_ms,omitempty"`
	// After a region applies to `applied_index`, we can get a
	// snapshot for the region even if the peer is a follower.
	AppliedIndex uint64 `protobuf:"varint,15,opt,name=applied_index,json=appliedIndex,proto3" json:"applied_index,omitempty"`
	// A hint for TiKV to schedule tasks more fairly. Query with same task ID
	// may share same priority and resource quota.
	TaskId uint64 `protobuf:"varint,16,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Not required to read the most up-to-date data, replicas with `safe_ts` >= `start_ts`
	// can handle read request directly
	StaleRead bool `protobuf:"varint,17,opt,name=stale_read,json=staleRead,proto3" json:"stale_read,omitempty"`
	// Any additional serialized information about the request.
	ResourceGroupTag []byte `protobuf:"bytes,18,opt,name=resource_group_tag,json=resourceGroupTag,proto3" json:"resource_group_tag,omitempty"`
	// Used to tell TiKV whether operations are allowed or not on different disk usages.
	DiskFullOpt DiskFullOpt `protobuf:"varint,19,opt,name=disk_full_opt,json=diskFullOpt,proto3,enum=kvrpcpb.DiskFullOpt" json:"disk_full_opt,omitempty"`
	// Indicates the request is a retry request and the same request may have been sent before.
	IsRetryRequest bool `protobuf:"varint,20,opt,name=is_retry_request,json=isRetryRequest,proto3" json:"is_retry_request,omitempty"`
	// API version implies the encode of the key and value.
	ApiVersion APIVersion `protobuf:"varint,21,opt,name=api_version,json=apiVersion,proto3,enum=kvrpcpb.APIVersion" json:"api_version,omitempty"`
	// Read request should read through locks belonging to these transactions because these
	// transactions are committed and theirs commit_ts <= read request's start_ts.
	CommittedLocks []uint64 `protobuf:"varint,22,rep,packed,name=committed_locks,json=committedLocks,proto3" json:"committed_locks,omitempty"`
	// The informantion to trace a request sent to TiKV.
	TraceContext *tracepb.TraceContext `protobuf:"bytes,23,opt,name=trace_context,json=traceContext,proto3" json:"trace_context,omitempty"`
	// The source of the request, will be used as the tag of the metrics reporting.
	// This field can be set for any requests that require to report metrics with any extra labels.
	RequestSource string `protobuf:"bytes,24,opt,name=request_source,json=requestSource,proto3" json:"request_source,omitempty"`
	// The source of the current transaction.
	TxnSource            uint64   `protobuf:"varint,25,opt,name=txn_source,json=txnSource,proto3" json:"txn_source,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Context) Reset()         { *m = Context{} }
func (m *Context) String() string { return proto.CompactTextString(m) }
func (*Context) ProtoMessage()    {}
func (*Context) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{75}
}
func (m *Context) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Context) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Context.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Context) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Context.Merge(m, src)
}
func (m *Context) XXX_Size() int {
	return m.Size()
}
func (m *Context) XXX_DiscardUnknown() {
	xxx_messageInfo_Context.DiscardUnknown(m)
}

var xxx_messageInfo_Context proto.InternalMessageInfo

func (m *Context) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *Context) GetRegionEpoch() *metapb.RegionEpoch {
	if m != nil {
		return m.RegionEpoch
	}
	return nil
}

func (m *Context) GetPeer() *metapb.Peer {
	if m != nil {
		return m.Peer
	}
	return nil
}

func (m *Context) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

func (m *Context) GetPriority() CommandPri {
	if m != nil {
		return m.Priority
	}
	return CommandPri_Normal
}

func (m *Context) GetIsolationLevel() IsolationLevel {
	if m != nil {
		return m.IsolationLevel
	}
	return IsolationLevel_SI
}

func (m *Context) GetNotFillCache() bool {
	if m != nil {
		return m.NotFillCache
	}
	return false
}

func (m *Context) GetSyncLog() bool {
	if m != nil {
		return m.SyncLog
	}
	return false
}

func (m *Context) GetRecordTimeStat() bool {
	if m != nil {
		return m.RecordTimeStat
	}
	return false
}

func (m *Context) GetRecordScanStat() bool {
	if m != nil {
		return m.RecordScanStat
	}
	return false
}

func (m *Context) GetReplicaRead() bool {
	if m != nil {
		return m.ReplicaRead
	}
	return false
}

func (m *Context) GetResolvedLocks() []uint64 {
	if m != nil {
		return m.ResolvedLocks
	}
	return nil
}

func (m *Context) GetMaxExecutionDurationMs() uint64 {
	if m != nil {
		return m.MaxExecutionDurationMs
	}
	return 0
}

func (m *Context) GetAppliedIndex() uint64 {
	if m != nil {
		return m.AppliedIndex
	}
	return 0
}

func (m *Context) GetTaskId() uint64 {
	if m != nil {
		return m.TaskId
	}
	return 0
}

func (m *Context) GetStaleRead() bool {
	if m != nil {
		return m.StaleRead
	}
	return false
}

func (m *Context) GetResourceGroupTag() []byte {
	if m != nil {
		return m.ResourceGroupTag
	}
	return nil
}

func (m *Context) GetDiskFullOpt() DiskFullOpt {
	if m != nil {
		return m.DiskFullOpt
	}
	return DiskFullOpt_NotAllowedOnFull
}

func (m *Context) GetIsRetryRequest() bool {
	if m != nil {
		return m.IsRetryRequest
	}
	return false
}

func (m *Context) GetApiVersion() APIVersion {
	if m != nil {
		return m.ApiVersion
	}
	return APIVersion_V1
}

func (m *Context) GetCommittedLocks() []uint64 {
	if m != nil {
		return m.CommittedLocks
	}
	return nil
}

func (m *Context) GetTraceContext() *tracepb.TraceContext {
	if m != nil {
		return m.TraceContext
	}
	return nil
}

func (m *Context) GetRequestSource() string {
	if m != nil {
		return m.RequestSource
	}
	return ""
}

func (m *Context) GetTxnSource() uint64 {
	if m != nil {
		return m.TxnSource
	}
	return 0
}

type LockInfo struct {
	PrimaryLock []byte `protobuf:"bytes,1,opt,name=primary_lock,json=primaryLock,proto3" json:"primary_lock,omitempty"`
	LockVersion uint64 `protobuf:"varint,2,opt,name=lock_version,json=lockVersion,proto3" json:"lock_version,omitempty"`
	Key         []byte `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	LockTtl     uint64 `protobuf:"varint,4,opt,name=lock_ttl,json=lockTtl,proto3" json:"lock_ttl,omitempty"`
	// How many keys this transaction involves in this region.
	TxnSize         uint64 `protobuf:"varint,5,opt,name=txn_size,json=txnSize,proto3" json:"txn_size,omitempty"`
	LockType        Op     `protobuf:"varint,6,opt,name=lock_type,json=lockType,proto3,enum=kvrpcpb.Op" json:"lock_type,omitempty"`
	LockForUpdateTs uint64 `protobuf:"varint,7,opt,name=lock_for_update_ts,json=lockForUpdateTs,proto3" json:"lock_for_update_ts,omitempty"`
	// Fields for transactions that are using Async Commit.
	UseAsyncCommit       bool     `protobuf:"varint,8,opt,name=use_async_commit,json=useAsyncCommit,proto3" json:"use_async_commit,omitempty"`
	MinCommitTs          uint64   `protobuf:"varint,9,opt,name=min_commit_ts,json=minCommitTs,proto3" json:"min_commit_ts,omitempty"`
	Secondaries          [][]byte `protobuf:"bytes,10,rep,name=secondaries,proto3" json:"secondaries,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LockInfo) Reset()         { *m = LockInfo{} }
func (m *LockInfo) String() string { return proto.CompactTextString(m) }
func (*LockInfo) ProtoMessage()    {}
func (*LockInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{76}
}
func (m *LockInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LockInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LockInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LockInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LockInfo.Merge(m, src)
}
func (m *LockInfo) XXX_Size() int {
	return m.Size()
}
func (m *LockInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LockInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LockInfo proto.InternalMessageInfo

func (m *LockInfo) GetPrimaryLock() []byte {
	if m != nil {
		return m.PrimaryLock
	}
	return nil
}

func (m *LockInfo) GetLockVersion() uint64 {
	if m != nil {
		return m.LockVersion
	}
	return 0
}

func (m *LockInfo) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *LockInfo) GetLockTtl() uint64 {
	if m != nil {
		return m.LockTtl
	}
	return 0
}

func (m *LockInfo) GetTxnSize() uint64 {
	if m != nil {
		return m.TxnSize
	}
	return 0
}

func (m *LockInfo) GetLockType() Op {
	if m != nil {
		return m.LockType
	}
	return Op_Put
}

func (m *LockInfo) GetLockForUpdateTs() uint64 {
	if m != nil {
		return m.LockForUpdateTs
	}
	return 0
}

func (m *LockInfo) GetUseAsyncCommit() bool {
	if m != nil {
		return m.UseAsyncCommit
	}
	return false
}

func (m *LockInfo) GetMinCommitTs() uint64 {
	if m != nil {
		return m.MinCommitTs
	}
	return 0
}

func (m *LockInfo) GetSecondaries() [][]byte {
	if m != nil {
		return m.Secondaries
	}
	return nil
}

type KeyError struct {
	Locked               *LockInfo         `protobuf:"bytes,1,opt,name=locked,proto3" json:"locked,omitempty"`
	Retryable            string            `protobuf:"bytes,2,opt,name=retryable,proto3" json:"retryable,omitempty"`
	Abort                string            `protobuf:"bytes,3,opt,name=abort,proto3" json:"abort,omitempty"`
	Conflict             *WriteConflict    `protobuf:"bytes,4,opt,name=conflict,proto3" json:"conflict,omitempty"`
	AlreadyExist         *AlreadyExist     `protobuf:"bytes,5,opt,name=already_exist,json=alreadyExist,proto3" json:"already_exist,omitempty"`
	Deadlock             *Deadlock         `protobuf:"bytes,6,opt,name=deadlock,proto3" json:"deadlock,omitempty"`
	CommitTsExpired      *CommitTsExpired  `protobuf:"bytes,7,opt,name=commit_ts_expired,json=commitTsExpired,proto3" json:"commit_ts_expired,omitempty"`
	TxnNotFound          *TxnNotFound      `protobuf:"bytes,8,opt,name=txn_not_found,json=txnNotFound,proto3" json:"txn_not_found,omitempty"`
	CommitTsTooLarge     *CommitTsTooLarge `protobuf:"bytes,9,opt,name=commit_ts_too_large,json=commitTsTooLarge,proto3" json:"commit_ts_too_large,omitempty"`
	AssertionFailed      *AssertionFailed  `protobuf:"bytes,10,opt,name=assertion_failed,json=assertionFailed,proto3" json:"assertion_failed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *KeyError) Reset()         { *m = KeyError{} }
func (m *KeyError) String() string { return proto.CompactTextString(m) }
func (*KeyError) ProtoMessage()    {}
func (*KeyError) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{77}
}
func (m *KeyError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyError.Merge(m, src)
}
func (m *KeyError) XXX_Size() int {
	return m.Size()
}
func (m *KeyError) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyError.DiscardUnknown(m)
}

var xxx_messageInfo_KeyError proto.InternalMessageInfo

func (m *KeyError) GetLocked() *LockInfo {
	if m != nil {
		return m.Locked
	}
	return nil
}

func (m *KeyError) GetRetryable() string {
	if m != nil {
		return m.Retryable
	}
	return ""
}

func (m *KeyError) GetAbort() string {
	if m != nil {
		return m.Abort
	}
	return ""
}

func (m *KeyError) GetConflict() *WriteConflict {
	if m != nil {
		return m.Conflict
	}
	return nil
}

func (m *KeyError) GetAlreadyExist() *AlreadyExist {
	if m != nil {
		return m.AlreadyExist
	}
	return nil
}

func (m *KeyError) GetDeadlock() *Deadlock {
	if m != nil {
		return m.Deadlock
	}
	return nil
}

func (m *KeyError) GetCommitTsExpired() *CommitTsExpired {
	if m != nil {
		return m.CommitTsExpired
	}
	return nil
}

func (m *KeyError) GetTxnNotFound() *TxnNotFound {
	if m != nil {
		return m.TxnNotFound
	}
	return nil
}

func (m *KeyError) GetCommitTsTooLarge() *CommitTsTooLarge {
	if m != nil {
		return m.CommitTsTooLarge
	}
	return nil
}

func (m *KeyError) GetAssertionFailed() *AssertionFailed {
	if m != nil {
		return m.AssertionFailed
	}
	return nil
}

type WriteConflict struct {
	StartTs              uint64               `protobuf:"varint,1,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	ConflictTs           uint64               `protobuf:"varint,2,opt,name=conflict_ts,json=conflictTs,proto3" json:"conflict_ts,omitempty"`
	Key                  []byte               `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	Primary              []byte               `protobuf:"bytes,4,opt,name=primary,proto3" json:"primary,omitempty"`
	ConflictCommitTs     uint64               `protobuf:"varint,5,opt,name=conflict_commit_ts,json=conflictCommitTs,proto3" json:"conflict_commit_ts,omitempty"`
	Reason               WriteConflict_Reason `protobuf:"varint,6,opt,name=reason,proto3,enum=kvrpcpb.WriteConflict_Reason" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WriteConflict) Reset()         { *m = WriteConflict{} }
func (m *WriteConflict) String() string { return proto.CompactTextString(m) }
func (*WriteConflict) ProtoMessage()    {}
func (*WriteConflict) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{78}
}
func (m *WriteConflict) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteConflict) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteConflict.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteConflict) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteConflict.Merge(m, src)
}
func (m *WriteConflict) XXX_Size() int {
	return m.Size()
}
func (m *WriteConflict) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteConflict.DiscardUnknown(m)
}

var xxx_messageInfo_WriteConflict proto.InternalMessageInfo

func (m *WriteConflict) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *WriteConflict) GetConflictTs() uint64 {
	if m != nil {
		return m.ConflictTs
	}
	return 0
}

func (m *WriteConflict) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *WriteConflict) GetPrimary() []byte {
	if m != nil {
		return m.Primary
	}
	return nil
}

func (m *WriteConflict) GetConflictCommitTs() uint64 {
	if m != nil {
		return m.ConflictCommitTs
	}
	return 0
}

func (m *WriteConflict) GetReason() WriteConflict_Reason {
	if m != nil {
		return m.Reason
	}
	return WriteConflict_Unknown
}

type AlreadyExist struct {
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AlreadyExist) Reset()         { *m = AlreadyExist{} }
func (m *AlreadyExist) String() string { return proto.CompactTextString(m) }
func (*AlreadyExist) ProtoMessage()    {}
func (*AlreadyExist) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{79}
}
func (m *AlreadyExist) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AlreadyExist) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AlreadyExist.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AlreadyExist) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlreadyExist.Merge(m, src)
}
func (m *AlreadyExist) XXX_Size() int {
	return m.Size()
}
func (m *AlreadyExist) XXX_DiscardUnknown() {
	xxx_messageInfo_AlreadyExist.DiscardUnknown(m)
}

var xxx_messageInfo_AlreadyExist proto.InternalMessageInfo

func (m *AlreadyExist) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type Deadlock struct {
	LockTs               uint64                   `protobuf:"varint,1,opt,name=lock_ts,json=lockTs,proto3" json:"lock_ts,omitempty"`
	LockKey              []byte                   `protobuf:"bytes,2,opt,name=lock_key,json=lockKey,proto3" json:"lock_key,omitempty"`
	DeadlockKeyHash      uint64                   `protobuf:"varint,3,opt,name=deadlock_key_hash,json=deadlockKeyHash,proto3" json:"deadlock_key_hash,omitempty"`
	WaitChain            []*deadlock.WaitForEntry `protobuf:"bytes,4,rep,name=wait_chain,json=waitChain,proto3" json:"wait_chain,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Deadlock) Reset()         { *m = Deadlock{} }
func (m *Deadlock) String() string { return proto.CompactTextString(m) }
func (*Deadlock) ProtoMessage()    {}
func (*Deadlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{80}
}
func (m *Deadlock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deadlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deadlock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deadlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deadlock.Merge(m, src)
}
func (m *Deadlock) XXX_Size() int {
	return m.Size()
}
func (m *Deadlock) XXX_DiscardUnknown() {
	xxx_messageInfo_Deadlock.DiscardUnknown(m)
}

var xxx_messageInfo_Deadlock proto.InternalMessageInfo

func (m *Deadlock) GetLockTs() uint64 {
	if m != nil {
		return m.LockTs
	}
	return 0
}

func (m *Deadlock) GetLockKey() []byte {
	if m != nil {
		return m.LockKey
	}
	return nil
}

func (m *Deadlock) GetDeadlockKeyHash() uint64 {
	if m != nil {
		return m.DeadlockKeyHash
	}
	return 0
}

func (m *Deadlock) GetWaitChain() []*deadlock.WaitForEntry {
	if m != nil {
		return m.WaitChain
	}
	return nil
}

type CommitTsExpired struct {
	StartTs              uint64   `protobuf:"varint,1,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	AttemptedCommitTs    uint64   `protobuf:"varint,2,opt,name=attempted_commit_ts,json=attemptedCommitTs,proto3" json:"attempted_commit_ts,omitempty"`
	Key                  []byte   `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	MinCommitTs          uint64   `protobuf:"varint,4,opt,name=min_commit_ts,json=minCommitTs,proto3" json:"min_commit_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitTsExpired) Reset()         { *m = CommitTsExpired{} }
func (m *CommitTsExpired) String() string { return proto.CompactTextString(m) }
func (*CommitTsExpired) ProtoMessage()    {}
func (*CommitTsExpired) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{81}
}
func (m *CommitTsExpired) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitTsExpired) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitTsExpired.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitTsExpired) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitTsExpired.Merge(m, src)
}
func (m *CommitTsExpired) XXX_Size() int {
	return m.Size()
}
func (m *CommitTsExpired) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitTsExpired.DiscardUnknown(m)
}

var xxx_messageInfo_CommitTsExpired proto.InternalMessageInfo

func (m *CommitTsExpired) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *CommitTsExpired) GetAttemptedCommitTs() uint64 {
	if m != nil {
		return m.AttemptedCommitTs
	}
	return 0
}

func (m *CommitTsExpired) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *CommitTsExpired) GetMinCommitTs() uint64 {
	if m != nil {
		return m.MinCommitTs
	}
	return 0
}

type TxnNotFound struct {
	StartTs              uint64   `protobuf:"varint,1,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	PrimaryKey           []byte   `protobuf:"bytes,2,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TxnNotFound) Reset()         { *m = TxnNotFound{} }
func (m *TxnNotFound) String() string { return proto.CompactTextString(m) }
func (*TxnNotFound) ProtoMessage()    {}
func (*TxnNotFound) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{82}
}
func (m *TxnNotFound) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnNotFound) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxnNotFound.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxnNotFound) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnNotFound.Merge(m, src)
}
func (m *TxnNotFound) XXX_Size() int {
	return m.Size()
}
func (m *TxnNotFound) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnNotFound.DiscardUnknown(m)
}

var xxx_messageInfo_TxnNotFound proto.InternalMessageInfo

func (m *TxnNotFound) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *TxnNotFound) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

type CommitTsTooLarge struct {
	CommitTs             uint64   `protobuf:"varint,1,opt,name=commit_ts,json=commitTs,proto3" json:"commit_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitTsTooLarge) Reset()         { *m = CommitTsTooLarge{} }
func (m *CommitTsTooLarge) String() string { return proto.CompactTextString(m) }
func (*CommitTsTooLarge) ProtoMessage()    {}
func (*CommitTsTooLarge) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{83}
}
func (m *CommitTsTooLarge) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommitTsTooLarge) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommitTsTooLarge.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommitTsTooLarge) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitTsTooLarge.Merge(m, src)
}
func (m *CommitTsTooLarge) XXX_Size() int {
	return m.Size()
}
func (m *CommitTsTooLarge) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitTsTooLarge.DiscardUnknown(m)
}

var xxx_messageInfo_CommitTsTooLarge proto.InternalMessageInfo

func (m *CommitTsTooLarge) GetCommitTs() uint64 {
	if m != nil {
		return m.CommitTs
	}
	return 0
}

type AssertionFailed struct {
	StartTs              uint64    `protobuf:"varint,1,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	Key                  []byte    `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Assertion            Assertion `protobuf:"varint,3,opt,name=assertion,proto3,enum=kvrpcpb.Assertion" json:"assertion,omitempty"`
	ExistingStartTs      uint64    `protobuf:"varint,4,opt,name=existing_start_ts,json=existingStartTs,proto3" json:"existing_start_ts,omitempty"`
	ExistingCommitTs     uint64    `protobuf:"varint,5,opt,name=existing_commit_ts,json=existingCommitTs,proto3" json:"existing_commit_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *AssertionFailed) Reset()         { *m = AssertionFailed{} }
func (m *AssertionFailed) String() string { return proto.CompactTextString(m) }
func (*AssertionFailed) ProtoMessage()    {}
func (*AssertionFailed) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{84}
}
func (m *AssertionFailed) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssertionFailed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssertionFailed.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssertionFailed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssertionFailed.Merge(m, src)
}
func (m *AssertionFailed) XXX_Size() int {
	return m.Size()
}
func (m *AssertionFailed) XXX_DiscardUnknown() {
	xxx_messageInfo_AssertionFailed.DiscardUnknown(m)
}

var xxx_messageInfo_AssertionFailed proto.InternalMessageInfo

func (m *AssertionFailed) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *AssertionFailed) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *AssertionFailed) GetAssertion() Assertion {
	if m != nil {
		return m.Assertion
	}
	return Assertion_None
}

func (m *AssertionFailed) GetExistingStartTs() uint64 {
	if m != nil {
		return m.ExistingStartTs
	}
	return 0
}

func (m *AssertionFailed) GetExistingCommitTs() uint64 {
	if m != nil {
		return m.ExistingCommitTs
	}
	return 0
}

type TimeDetail struct {
	// Off-cpu wall time elapsed in TiKV side. Usually this includes queue waiting time and
	// other kind of waitings in series. (Wait time in the raftstore is not included.)
	WaitWallTimeMs uint64 `protobuf:"varint,1,opt,name=wait_wall_time_ms,json=waitWallTimeMs,proto3" json:"wait_wall_time_ms,omitempty"`
	// Off-cpu and on-cpu wall time elapsed to actually process the request payload. It does not
	// include `wait_wall_time`.
	// This field is very close to the CPU time in most cases. Some wait time spend in RocksDB
	// cannot be excluded for now, like Mutex wait time, which is included in this field, so that
	// this field is called wall time instead of CPU time.
	ProcessWallTimeMs uint64 `protobuf:"varint,2,opt,name=process_wall_time_ms,json=processWallTimeMs,proto3" json:"process_wall_time_ms,omitempty"`
	// KV read wall Time means the time used in key/value scan and get.
	KvReadWallTimeMs uint64 `protobuf:"varint,3,opt,name=kv_read_wall_time_ms,json=kvReadWallTimeMs,proto3" json:"kv_read_wall_time_ms,omitempty"`
	// Total wall clock time spent on this RPC in TiKV .
	TotalRpcWallTimeNs   uint64   `protobuf:"varint,4,opt,name=total_rpc_wall_time_ns,json=totalRpcWallTimeNs,proto3" json:"total_rpc_wall_time_ns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeDetail) Reset()         { *m = TimeDetail{} }
func (m *TimeDetail) String() string { return proto.CompactTextString(m) }
func (*TimeDetail) ProtoMessage()    {}
func (*TimeDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{85}
}
func (m *TimeDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeDetail.Merge(m, src)
}
func (m *TimeDetail) XXX_Size() int {
	return m.Size()
}
func (m *TimeDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeDetail.DiscardUnknown(m)
}

var xxx_messageInfo_TimeDetail proto.InternalMessageInfo

func (m *TimeDetail) GetWaitWallTimeMs() uint64 {
	if m != nil {
		return m.WaitWallTimeMs
	}
	return 0
}

func (m *TimeDetail) GetProcessWallTimeMs() uint64 {
	if m != nil {
		return m.ProcessWallTimeMs
	}
	return 0
}

func (m *TimeDetail) GetKvReadWallTimeMs() uint64 {
	if m != nil {
		return m.KvReadWallTimeMs
	}
	return 0
}

func (m *TimeDetail) GetTotalRpcWallTimeNs() uint64 {
	if m != nil {
		return m.TotalRpcWallTimeNs
	}
	return 0
}

type ScanInfo struct {
	Total                int64    `protobuf:"varint,1,opt,name=total,proto3" json:"total,omitempty"`
	Processed            int64    `protobuf:"varint,2,opt,name=processed,proto3" json:"processed,omitempty"`
	ReadBytes            int64    `protobuf:"varint,3,opt,name=read_bytes,json=readBytes,proto3" json:"read_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScanInfo) Reset()         { *m = ScanInfo{} }
func (m *ScanInfo) String() string { return proto.CompactTextString(m) }
func (*ScanInfo) ProtoMessage()    {}
func (*ScanInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{86}
}
func (m *ScanInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanInfo.Merge(m, src)
}
func (m *ScanInfo) XXX_Size() int {
	return m.Size()
}
func (m *ScanInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ScanInfo proto.InternalMessageInfo

func (m *ScanInfo) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *ScanInfo) GetProcessed() int64 {
	if m != nil {
		return m.Processed
	}
	return 0
}

func (m *ScanInfo) GetReadBytes() int64 {
	if m != nil {
		return m.ReadBytes
	}
	return 0
}

// Only reserved for compatibility.
type ScanDetail struct {
	Write                *ScanInfo `protobuf:"bytes,1,opt,name=write,proto3" json:"write,omitempty"`
	Lock                 *ScanInfo `protobuf:"bytes,2,opt,name=lock,proto3" json:"lock,omitempty"`
	Data                 *ScanInfo `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ScanDetail) Reset()         { *m = ScanDetail{} }
func (m *ScanDetail) String() string { return proto.CompactTextString(m) }
func (*ScanDetail) ProtoMessage()    {}
func (*ScanDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{87}
}
func (m *ScanDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanDetail.Merge(m, src)
}
func (m *ScanDetail) XXX_Size() int {
	return m.Size()
}
func (m *ScanDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanDetail.DiscardUnknown(m)
}

var xxx_messageInfo_ScanDetail proto.InternalMessageInfo

func (m *ScanDetail) GetWrite() *ScanInfo {
	if m != nil {
		return m.Write
	}
	return nil
}

func (m *ScanDetail) GetLock() *ScanInfo {
	if m != nil {
		return m.Lock
	}
	return nil
}

func (m *ScanDetail) GetData() *ScanInfo {
	if m != nil {
		return m.Data
	}
	return nil
}

type ScanDetailV2 struct {
	// Number of user keys scanned from the storage.
	// It does not include deleted version or RocksDB tombstone keys.
	// For Coprocessor requests, it includes keys that has been filtered out by
	// Selection.
	ProcessedVersions uint64 `protobuf:"varint,1,opt,name=processed_versions,json=processedVersions,proto3" json:"processed_versions,omitempty"`
	// Number of bytes of user key-value pairs scanned from the storage, i.e.
	// total size of data returned from MVCC layer.
	ProcessedVersionsSize uint64 `protobuf:"varint,8,opt,name=processed_versions_size,json=processedVersionsSize,proto3" json:"processed_versions_size,omitempty"`
	// Approximate number of MVCC keys meet during scanning. It includes
	// deleted versions, but does not include RocksDB tombstone keys.
	//
	// When this field is notably larger than `processed_versions`, it means
	// there are a lot of deleted MVCC keys.
	TotalVersions uint64 `protobuf:"varint,2,opt,name=total_versions,json=totalVersions,proto3" json:"total_versions,omitempty"`
	// Total number of deletes and single deletes skipped over during
	// iteration, i.e. how many RocksDB tombstones are skipped.
	RocksdbDeleteSkippedCount uint64 `protobuf:"varint,3,opt,name=rocksdb_delete_skipped_count,json=rocksdbDeleteSkippedCount,proto3" json:"rocksdb_delete_skipped_count,omitempty"`
	// Total number of internal keys skipped over during iteration.
	// See https://github.com/facebook/rocksdb/blob/9f1c84ca471d8b1ad7be9f3eebfc2c7e07dfd7a7/include/rocksdb/perf_context.h#L84 for details.
	RocksdbKeySkippedCount uint64 `protobuf:"varint,4,opt,name=rocksdb_key_skipped_count,json=rocksdbKeySkippedCount,proto3" json:"rocksdb_key_skipped_count,omitempty"`
	// Total number of RocksDB block cache hits.
	RocksdbBlockCacheHitCount uint64 `protobuf:"varint,5,opt,name=rocksdb_block_cache_hit_count,json=rocksdbBlockCacheHitCount,proto3" json:"rocksdb_block_cache_hit_count,omitempty"`
	// Total number of block reads (with IO).
	RocksdbBlockReadCount uint64 `protobuf:"varint,6,opt,name=rocksdb_block_read_count,json=rocksdbBlockReadCount,proto3" json:"rocksdb_block_read_count,omitempty"`
	// Total number of bytes from block reads.
	RocksdbBlockReadByte uint64 `protobuf:"varint,7,opt,name=rocksdb_block_read_byte,json=rocksdbBlockReadByte,proto3" json:"rocksdb_block_read_byte,omitempty"`
	// Total time used for block reads.
	RocksdbBlockReadNanos uint64 `protobuf:"varint,9,opt,name=rocksdb_block_read_nanos,json=rocksdbBlockReadNanos,proto3" json:"rocksdb_block_read_nanos,omitempty"`
	// Time used for getting a raftstore snapshot (including proposing read index, leader confirmation and getting the RocksDB snapshot).
	GetSnapshotNanos uint64 `protobuf:"varint,10,opt,name=get_snapshot_nanos,json=getSnapshotNanos,proto3" json:"get_snapshot_nanos,omitempty"`
	// Time used for proposing read index from read pool to store pool, equals 0 when performing lease read.
	ReadIndexProposeWaitNanos uint64 `protobuf:"varint,11,opt,name=read_index_propose_wait_nanos,json=readIndexProposeWaitNanos,proto3" json:"read_index_propose_wait_nanos,omitempty"`
	// Time used for leader confirmation, equals 0 when performing lease read.
	ReadIndexConfirmWaitNanos uint64 `protobuf:"varint,12,opt,name=read_index_confirm_wait_nanos,json=readIndexConfirmWaitNanos,proto3" json:"read_index_confirm_wait_nanos,omitempty"`
	// Time used for read pool scheduling.
	ReadPoolScheduleWaitNanos uint64   `protobuf:"varint,13,opt,name=read_pool_schedule_wait_nanos,json=readPoolScheduleWaitNanos,proto3" json:"read_pool_schedule_wait_nanos,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *ScanDetailV2) Reset()         { *m = ScanDetailV2{} }
func (m *ScanDetailV2) String() string { return proto.CompactTextString(m) }
func (*ScanDetailV2) ProtoMessage()    {}
func (*ScanDetailV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{88}
}
func (m *ScanDetailV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ScanDetailV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ScanDetailV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ScanDetailV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanDetailV2.Merge(m, src)
}
func (m *ScanDetailV2) XXX_Size() int {
	return m.Size()
}
func (m *ScanDetailV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanDetailV2.DiscardUnknown(m)
}

var xxx_messageInfo_ScanDetailV2 proto.InternalMessageInfo

func (m *ScanDetailV2) GetProcessedVersions() uint64 {
	if m != nil {
		return m.ProcessedVersions
	}
	return 0
}

func (m *ScanDetailV2) GetProcessedVersionsSize() uint64 {
	if m != nil {
		return m.ProcessedVersionsSize
	}
	return 0
}

func (m *ScanDetailV2) GetTotalVersions() uint64 {
	if m != nil {
		return m.TotalVersions
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbDeleteSkippedCount() uint64 {
	if m != nil {
		return m.RocksdbDeleteSkippedCount
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbKeySkippedCount() uint64 {
	if m != nil {
		return m.RocksdbKeySkippedCount
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbBlockCacheHitCount() uint64 {
	if m != nil {
		return m.RocksdbBlockCacheHitCount
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbBlockReadCount() uint64 {
	if m != nil {
		return m.RocksdbBlockReadCount
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbBlockReadByte() uint64 {
	if m != nil {
		return m.RocksdbBlockReadByte
	}
	return 0
}

func (m *ScanDetailV2) GetRocksdbBlockReadNanos() uint64 {
	if m != nil {
		return m.RocksdbBlockReadNanos
	}
	return 0
}

func (m *ScanDetailV2) GetGetSnapshotNanos() uint64 {
	if m != nil {
		return m.GetSnapshotNanos
	}
	return 0
}

func (m *ScanDetailV2) GetReadIndexProposeWaitNanos() uint64 {
	if m != nil {
		return m.ReadIndexProposeWaitNanos
	}
	return 0
}

func (m *ScanDetailV2) GetReadIndexConfirmWaitNanos() uint64 {
	if m != nil {
		return m.ReadIndexConfirmWaitNanos
	}
	return 0
}

func (m *ScanDetailV2) GetReadPoolScheduleWaitNanos() uint64 {
	if m != nil {
		return m.ReadPoolScheduleWaitNanos
	}
	return 0
}

type ExecDetails struct {
	// Available when ctx.record_time_stat = true or meet slow query.
	TimeDetail *TimeDetail `protobuf:"bytes,1,opt,name=time_detail,json=timeDetail,proto3" json:"time_detail,omitempty"`
	// Available when ctx.record_scan_stat = true or meet slow query.
	ScanDetail           *ScanDetail `protobuf:"bytes,2,opt,name=scan_detail,json=scanDetail,proto3" json:"scan_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ExecDetails) Reset()         { *m = ExecDetails{} }
func (m *ExecDetails) String() string { return proto.CompactTextString(m) }
func (*ExecDetails) ProtoMessage()    {}
func (*ExecDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{89}
}
func (m *ExecDetails) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecDetails.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecDetails.Merge(m, src)
}
func (m *ExecDetails) XXX_Size() int {
	return m.Size()
}
func (m *ExecDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecDetails.DiscardUnknown(m)
}

var xxx_messageInfo_ExecDetails proto.InternalMessageInfo

func (m *ExecDetails) GetTimeDetail() *TimeDetail {
	if m != nil {
		return m.TimeDetail
	}
	return nil
}

func (m *ExecDetails) GetScanDetail() *ScanDetail {
	if m != nil {
		return m.ScanDetail
	}
	return nil
}

type ExecDetailsV2 struct {
	// Available when ctx.record_time_stat = true or meet slow query.
	TimeDetail *TimeDetail `protobuf:"bytes,1,opt,name=time_detail,json=timeDetail,proto3" json:"time_detail,omitempty"`
	// Available when ctx.record_scan_stat = true or meet slow query.
	ScanDetailV2 *ScanDetailV2 `protobuf:"bytes,2,opt,name=scan_detail_v2,json=scanDetailV2,proto3" json:"scan_detail_v2,omitempty"`
	// Raftstore writing durations of the request. Only available for some write requests.
	WriteDetail          *WriteDetail `protobuf:"bytes,3,opt,name=write_detail,json=writeDetail,proto3" json:"write_detail,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ExecDetailsV2) Reset()         { *m = ExecDetailsV2{} }
func (m *ExecDetailsV2) String() string { return proto.CompactTextString(m) }
func (*ExecDetailsV2) ProtoMessage()    {}
func (*ExecDetailsV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{90}
}
func (m *ExecDetailsV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExecDetailsV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExecDetailsV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExecDetailsV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecDetailsV2.Merge(m, src)
}
func (m *ExecDetailsV2) XXX_Size() int {
	return m.Size()
}
func (m *ExecDetailsV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecDetailsV2.DiscardUnknown(m)
}

var xxx_messageInfo_ExecDetailsV2 proto.InternalMessageInfo

func (m *ExecDetailsV2) GetTimeDetail() *TimeDetail {
	if m != nil {
		return m.TimeDetail
	}
	return nil
}

func (m *ExecDetailsV2) GetScanDetailV2() *ScanDetailV2 {
	if m != nil {
		return m.ScanDetailV2
	}
	return nil
}

func (m *ExecDetailsV2) GetWriteDetail() *WriteDetail {
	if m != nil {
		return m.WriteDetail
	}
	return nil
}

type WriteDetail struct {
	// Wait duration in the store loop.
	StoreBatchWaitNanos uint64 `protobuf:"varint,1,opt,name=store_batch_wait_nanos,json=storeBatchWaitNanos,proto3" json:"store_batch_wait_nanos,omitempty"`
	// Wait duration before sending proposal to peers.
	ProposeSendWaitNanos uint64 `protobuf:"varint,2,opt,name=propose_send_wait_nanos,json=proposeSendWaitNanos,proto3" json:"propose_send_wait_nanos,omitempty"`
	// Total time spent on persisting the log.
	PersistLogNanos uint64 `protobuf:"varint,3,opt,name=persist_log_nanos,json=persistLogNanos,proto3" json:"persist_log_nanos,omitempty"`
	// Wait time until the Raft log write leader begins to write.
	RaftDbWriteLeaderWaitNanos uint64 `protobuf:"varint,4,opt,name=raft_db_write_leader_wait_nanos,json=raftDbWriteLeaderWaitNanos,proto3" json:"raft_db_write_leader_wait_nanos,omitempty"`
	// Time spent on synchronizing the Raft log to the disk.
	RaftDbSyncLogNanos uint64 `protobuf:"varint,5,opt,name=raft_db_sync_log_nanos,json=raftDbSyncLogNanos,proto3" json:"raft_db_sync_log_nanos,omitempty"`
	// Time spent on writing the Raft log to the Raft memtable.
	RaftDbWriteMemtableNanos uint64 `protobuf:"varint,6,opt,name=raft_db_write_memtable_nanos,json=raftDbWriteMemtableNanos,proto3" json:"raft_db_write_memtable_nanos,omitempty"`
	// Time waiting for peers to confirm the proposal (counting from the instant when the leader sends the proposal message).
	CommitLogNanos uint64 `protobuf:"varint,7,opt,name=commit_log_nanos,json=commitLogNanos,proto3" json:"commit_log_nanos,omitempty"`
	// Wait duration in the apply loop.
	ApplyBatchWaitNanos uint64 `protobuf:"varint,8,opt,name=apply_batch_wait_nanos,json=applyBatchWaitNanos,proto3" json:"apply_batch_wait_nanos,omitempty"`
	// Total time spend to applying the log.
	ApplyLogNanos uint64 `protobuf:"varint,9,opt,name=apply_log_nanos,json=applyLogNanos,proto3" json:"apply_log_nanos,omitempty"`
	// Wait time until the KV RocksDB lock is acquired.
	ApplyMutexLockNanos uint64 `protobuf:"varint,10,opt,name=apply_mutex_lock_nanos,json=applyMutexLockNanos,proto3" json:"apply_mutex_lock_nanos,omitempty"`
	// Wait time until becoming the KV RocksDB write leader.
	ApplyWriteLeaderWaitNanos uint64 `protobuf:"varint,11,opt,name=apply_write_leader_wait_nanos,json=applyWriteLeaderWaitNanos,proto3" json:"apply_write_leader_wait_nanos,omitempty"`
	// Time spent on writing the KV DB WAL to the disk.
	ApplyWriteWalNanos uint64 `protobuf:"varint,12,opt,name=apply_write_wal_nanos,json=applyWriteWalNanos,proto3" json:"apply_write_wal_nanos,omitempty"`
	// Time spent on writing to the memtable of the KV RocksDB.
	ApplyWriteMemtableNanos uint64 `protobuf:"varint,13,opt,name=apply_write_memtable_nanos,json=applyWriteMemtableNanos,proto3" json:"apply_write_memtable_nanos,omitempty"`
	// Time spent on waiting in the latch.
	LatchWaitNanos uint64 `protobuf:"varint,14,opt,name=latch_wait_nanos,json=latchWaitNanos,proto3" json:"latch_wait_nanos,omitempty"`
	// Processing time in the transaction layer.
	ProcessNanos uint64 `protobuf:"varint,15,opt,name=process_nanos,json=processNanos,proto3" json:"process_nanos,omitempty"`
	// Wait time because of the scheduler flow control or quota limiter throttling.
	ThrottleNanos uint64 `protobuf:"varint,16,opt,name=throttle_nanos,json=throttleNanos,proto3" json:"throttle_nanos,omitempty"`
	// Wait time in the waiter manager for pessimistic locking.
	PessimisticLockWaitNanos uint64   `protobuf:"varint,17,opt,name=pessimistic_lock_wait_nanos,json=pessimisticLockWaitNanos,proto3" json:"pessimistic_lock_wait_nanos,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *WriteDetail) Reset()         { *m = WriteDetail{} }
func (m *WriteDetail) String() string { return proto.CompactTextString(m) }
func (*WriteDetail) ProtoMessage()    {}
func (*WriteDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{91}
}
func (m *WriteDetail) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteDetail.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteDetail.Merge(m, src)
}
func (m *WriteDetail) XXX_Size() int {
	return m.Size()
}
func (m *WriteDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteDetail.DiscardUnknown(m)
}

var xxx_messageInfo_WriteDetail proto.InternalMessageInfo

func (m *WriteDetail) GetStoreBatchWaitNanos() uint64 {
	if m != nil {
		return m.StoreBatchWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetProposeSendWaitNanos() uint64 {
	if m != nil {
		return m.ProposeSendWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetPersistLogNanos() uint64 {
	if m != nil {
		return m.PersistLogNanos
	}
	return 0
}

func (m *WriteDetail) GetRaftDbWriteLeaderWaitNanos() uint64 {
	if m != nil {
		return m.RaftDbWriteLeaderWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetRaftDbSyncLogNanos() uint64 {
	if m != nil {
		return m.RaftDbSyncLogNanos
	}
	return 0
}

func (m *WriteDetail) GetRaftDbWriteMemtableNanos() uint64 {
	if m != nil {
		return m.RaftDbWriteMemtableNanos
	}
	return 0
}

func (m *WriteDetail) GetCommitLogNanos() uint64 {
	if m != nil {
		return m.CommitLogNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyBatchWaitNanos() uint64 {
	if m != nil {
		return m.ApplyBatchWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyLogNanos() uint64 {
	if m != nil {
		return m.ApplyLogNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyMutexLockNanos() uint64 {
	if m != nil {
		return m.ApplyMutexLockNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyWriteLeaderWaitNanos() uint64 {
	if m != nil {
		return m.ApplyWriteLeaderWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyWriteWalNanos() uint64 {
	if m != nil {
		return m.ApplyWriteWalNanos
	}
	return 0
}

func (m *WriteDetail) GetApplyWriteMemtableNanos() uint64 {
	if m != nil {
		return m.ApplyWriteMemtableNanos
	}
	return 0
}

func (m *WriteDetail) GetLatchWaitNanos() uint64 {
	if m != nil {
		return m.LatchWaitNanos
	}
	return 0
}

func (m *WriteDetail) GetProcessNanos() uint64 {
	if m != nil {
		return m.ProcessNanos
	}
	return 0
}

func (m *WriteDetail) GetThrottleNanos() uint64 {
	if m != nil {
		return m.ThrottleNanos
	}
	return 0
}

func (m *WriteDetail) GetPessimisticLockWaitNanos() uint64 {
	if m != nil {
		return m.PessimisticLockWaitNanos
	}
	return 0
}

type KvPair struct {
	Error                *KeyError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Key                  []byte    `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte    `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *KvPair) Reset()         { *m = KvPair{} }
func (m *KvPair) String() string { return proto.CompactTextString(m) }
func (*KvPair) ProtoMessage()    {}
func (*KvPair) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{92}
}
func (m *KvPair) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KvPair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KvPair.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KvPair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KvPair.Merge(m, src)
}
func (m *KvPair) XXX_Size() int {
	return m.Size()
}
func (m *KvPair) XXX_DiscardUnknown() {
	xxx_messageInfo_KvPair.DiscardUnknown(m)
}

var xxx_messageInfo_KvPair proto.InternalMessageInfo

func (m *KvPair) GetError() *KeyError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *KvPair) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *KvPair) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type Mutation struct {
	Op                   Op        `protobuf:"varint,1,opt,name=op,proto3,enum=kvrpcpb.Op" json:"op,omitempty"`
	Key                  []byte    `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte    `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	Assertion            Assertion `protobuf:"varint,4,opt,name=assertion,proto3,enum=kvrpcpb.Assertion" json:"assertion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Mutation) Reset()         { *m = Mutation{} }
func (m *Mutation) String() string { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()    {}
func (*Mutation) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{93}
}
func (m *Mutation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Mutation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Mutation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Mutation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Mutation.Merge(m, src)
}
func (m *Mutation) XXX_Size() int {
	return m.Size()
}
func (m *Mutation) XXX_DiscardUnknown() {
	xxx_messageInfo_Mutation.DiscardUnknown(m)
}

var xxx_messageInfo_Mutation proto.InternalMessageInfo

func (m *Mutation) GetOp() Op {
	if m != nil {
		return m.Op
	}
	return Op_Put
}

func (m *Mutation) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Mutation) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Mutation) GetAssertion() Assertion {
	if m != nil {
		return m.Assertion
	}
	return Assertion_None
}

type MvccWrite struct {
	Type                  Op       `protobuf:"varint,1,opt,name=type,proto3,enum=kvrpcpb.Op" json:"type,omitempty"`
	StartTs               uint64   `protobuf:"varint,2,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	CommitTs              uint64   `protobuf:"varint,3,opt,name=commit_ts,json=commitTs,proto3" json:"commit_ts,omitempty"`
	ShortValue            []byte   `protobuf:"bytes,4,opt,name=short_value,json=shortValue,proto3" json:"short_value,omitempty"`
	HasOverlappedRollback bool     `protobuf:"varint,5,opt,name=has_overlapped_rollback,json=hasOverlappedRollback,proto3" json:"has_overlapped_rollback,omitempty"`
	HasGcFence            bool     `protobuf:"varint,6,opt,name=has_gc_fence,json=hasGcFence,proto3" json:"has_gc_fence,omitempty"`
	GcFence               uint64   `protobuf:"varint,7,opt,name=gc_fence,json=gcFence,proto3" json:"gc_fence,omitempty"`
	LastChangeTs          uint64   `protobuf:"varint,8,opt,name=last_change_ts,json=lastChangeTs,proto3" json:"last_change_ts,omitempty"`
	VersionsToLastChange  uint64   `protobuf:"varint,9,opt,name=versions_to_last_change,json=versionsToLastChange,proto3" json:"versions_to_last_change,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *MvccWrite) Reset()         { *m = MvccWrite{} }
func (m *MvccWrite) String() string { return proto.CompactTextString(m) }
func (*MvccWrite) ProtoMessage()    {}
func (*MvccWrite) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{94}
}
func (m *MvccWrite) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccWrite) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccWrite.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccWrite) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccWrite.Merge(m, src)
}
func (m *MvccWrite) XXX_Size() int {
	return m.Size()
}
func (m *MvccWrite) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccWrite.DiscardUnknown(m)
}

var xxx_messageInfo_MvccWrite proto.InternalMessageInfo

func (m *MvccWrite) GetType() Op {
	if m != nil {
		return m.Type
	}
	return Op_Put
}

func (m *MvccWrite) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *MvccWrite) GetCommitTs() uint64 {
	if m != nil {
		return m.CommitTs
	}
	return 0
}

func (m *MvccWrite) GetShortValue() []byte {
	if m != nil {
		return m.ShortValue
	}
	return nil
}

func (m *MvccWrite) GetHasOverlappedRollback() bool {
	if m != nil {
		return m.HasOverlappedRollback
	}
	return false
}

func (m *MvccWrite) GetHasGcFence() bool {
	if m != nil {
		return m.HasGcFence
	}
	return false
}

func (m *MvccWrite) GetGcFence() uint64 {
	if m != nil {
		return m.GcFence
	}
	return 0
}

func (m *MvccWrite) GetLastChangeTs() uint64 {
	if m != nil {
		return m.LastChangeTs
	}
	return 0
}

func (m *MvccWrite) GetVersionsToLastChange() uint64 {
	if m != nil {
		return m.VersionsToLastChange
	}
	return 0
}

type MvccValue struct {
	StartTs              uint64   `protobuf:"varint,1,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MvccValue) Reset()         { *m = MvccValue{} }
func (m *MvccValue) String() string { return proto.CompactTextString(m) }
func (*MvccValue) ProtoMessage()    {}
func (*MvccValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{95}
}
func (m *MvccValue) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccValue.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccValue.Merge(m, src)
}
func (m *MvccValue) XXX_Size() int {
	return m.Size()
}
func (m *MvccValue) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccValue.DiscardUnknown(m)
}

var xxx_messageInfo_MvccValue proto.InternalMessageInfo

func (m *MvccValue) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *MvccValue) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type MvccLock struct {
	Type                 Op       `protobuf:"varint,1,opt,name=type,proto3,enum=kvrpcpb.Op" json:"type,omitempty"`
	StartTs              uint64   `protobuf:"varint,2,opt,name=start_ts,json=startTs,proto3" json:"start_ts,omitempty"`
	Primary              []byte   `protobuf:"bytes,3,opt,name=primary,proto3" json:"primary,omitempty"`
	ShortValue           []byte   `protobuf:"bytes,4,opt,name=short_value,json=shortValue,proto3" json:"short_value,omitempty"`
	Ttl                  uint64   `protobuf:"varint,5,opt,name=ttl,proto3" json:"ttl,omitempty"`
	ForUpdateTs          uint64   `protobuf:"varint,6,opt,name=for_update_ts,json=forUpdateTs,proto3" json:"for_update_ts,omitempty"`
	TxnSize              uint64   `protobuf:"varint,7,opt,name=txn_size,json=txnSize,proto3" json:"txn_size,omitempty"`
	UseAsyncCommit       bool     `protobuf:"varint,8,opt,name=use_async_commit,json=useAsyncCommit,proto3" json:"use_async_commit,omitempty"`
	Secondaries          [][]byte `protobuf:"bytes,9,rep,name=secondaries,proto3" json:"secondaries,omitempty"`
	RollbackTs           []uint64 `protobuf:"varint,10,rep,packed,name=rollback_ts,json=rollbackTs,proto3" json:"rollback_ts,omitempty"`
	LastChangeTs         uint64   `protobuf:"varint,11,opt,name=last_change_ts,json=lastChangeTs,proto3" json:"last_change_ts,omitempty"`
	VersionsToLastChange uint64   `protobuf:"varint,12,opt,name=versions_to_last_change,json=versionsToLastChange,proto3" json:"versions_to_last_change,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MvccLock) Reset()         { *m = MvccLock{} }
func (m *MvccLock) String() string { return proto.CompactTextString(m) }
func (*MvccLock) ProtoMessage()    {}
func (*MvccLock) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{96}
}
func (m *MvccLock) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccLock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccLock.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccLock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccLock.Merge(m, src)
}
func (m *MvccLock) XXX_Size() int {
	return m.Size()
}
func (m *MvccLock) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccLock.DiscardUnknown(m)
}

var xxx_messageInfo_MvccLock proto.InternalMessageInfo

func (m *MvccLock) GetType() Op {
	if m != nil {
		return m.Type
	}
	return Op_Put
}

func (m *MvccLock) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *MvccLock) GetPrimary() []byte {
	if m != nil {
		return m.Primary
	}
	return nil
}

func (m *MvccLock) GetShortValue() []byte {
	if m != nil {
		return m.ShortValue
	}
	return nil
}

func (m *MvccLock) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *MvccLock) GetForUpdateTs() uint64 {
	if m != nil {
		return m.ForUpdateTs
	}
	return 0
}

func (m *MvccLock) GetTxnSize() uint64 {
	if m != nil {
		return m.TxnSize
	}
	return 0
}

func (m *MvccLock) GetUseAsyncCommit() bool {
	if m != nil {
		return m.UseAsyncCommit
	}
	return false
}

func (m *MvccLock) GetSecondaries() [][]byte {
	if m != nil {
		return m.Secondaries
	}
	return nil
}

func (m *MvccLock) GetRollbackTs() []uint64 {
	if m != nil {
		return m.RollbackTs
	}
	return nil
}

func (m *MvccLock) GetLastChangeTs() uint64 {
	if m != nil {
		return m.LastChangeTs
	}
	return 0
}

func (m *MvccLock) GetVersionsToLastChange() uint64 {
	if m != nil {
		return m.VersionsToLastChange
	}
	return 0
}

type MvccInfo struct {
	Lock                 *MvccLock    `protobuf:"bytes,1,opt,name=lock,proto3" json:"lock,omitempty"`
	Writes               []*MvccWrite `protobuf:"bytes,2,rep,name=writes,proto3" json:"writes,omitempty"`
	Values               []*MvccValue `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MvccInfo) Reset()         { *m = MvccInfo{} }
func (m *MvccInfo) String() string { return proto.CompactTextString(m) }
func (*MvccInfo) ProtoMessage()    {}
func (*MvccInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{97}
}
func (m *MvccInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MvccInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MvccInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MvccInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MvccInfo.Merge(m, src)
}
func (m *MvccInfo) XXX_Size() int {
	return m.Size()
}
func (m *MvccInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MvccInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MvccInfo proto.InternalMessageInfo

func (m *MvccInfo) GetLock() *MvccLock {
	if m != nil {
		return m.Lock
	}
	return nil
}

func (m *MvccInfo) GetWrites() []*MvccWrite {
	if m != nil {
		return m.Writes
	}
	return nil
}

func (m *MvccInfo) GetValues() []*MvccValue {
	if m != nil {
		return m.Values
	}
	return nil
}

type TxnInfo struct {
	Txn                  uint64   `protobuf:"varint,1,opt,name=txn,proto3" json:"txn,omitempty"`
	Status               uint64   `protobuf:"varint,2,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TxnInfo) Reset()         { *m = TxnInfo{} }
func (m *TxnInfo) String() string { return proto.CompactTextString(m) }
func (*TxnInfo) ProtoMessage()    {}
func (*TxnInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{98}
}
func (m *TxnInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TxnInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TxnInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnInfo.Merge(m, src)
}
func (m *TxnInfo) XXX_Size() int {
	return m.Size()
}
func (m *TxnInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TxnInfo proto.InternalMessageInfo

func (m *TxnInfo) GetTxn() uint64 {
	if m != nil {
		return m.Txn
	}
	return 0
}

func (m *TxnInfo) GetStatus() uint64 {
	if m != nil {
		return m.Status
	}
	return 0
}

type KeyRange struct {
	StartKey             []byte   `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyRange) Reset()         { *m = KeyRange{} }
func (m *KeyRange) String() string { return proto.CompactTextString(m) }
func (*KeyRange) ProtoMessage()    {}
func (*KeyRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{99}
}
func (m *KeyRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyRange.Merge(m, src)
}
func (m *KeyRange) XXX_Size() int {
	return m.Size()
}
func (m *KeyRange) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyRange.DiscardUnknown(m)
}

var xxx_messageInfo_KeyRange proto.InternalMessageInfo

func (m *KeyRange) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *KeyRange) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

type LeaderInfo struct {
	RegionId             uint64              `protobuf:"varint,1,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	PeerId               uint64              `protobuf:"varint,2,opt,name=peer_id,json=peerId,proto3" json:"peer_id,omitempty"`
	Term                 uint64              `protobuf:"varint,3,opt,name=term,proto3" json:"term,omitempty"`
	RegionEpoch          *metapb.RegionEpoch `protobuf:"bytes,4,opt,name=region_epoch,json=regionEpoch,proto3" json:"region_epoch,omitempty"`
	ReadState            *ReadState          `protobuf:"bytes,5,opt,name=read_state,json=readState,proto3" json:"read_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *LeaderInfo) Reset()         { *m = LeaderInfo{} }
func (m *LeaderInfo) String() string { return proto.CompactTextString(m) }
func (*LeaderInfo) ProtoMessage()    {}
func (*LeaderInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{100}
}
func (m *LeaderInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LeaderInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LeaderInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LeaderInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeaderInfo.Merge(m, src)
}
func (m *LeaderInfo) XXX_Size() int {
	return m.Size()
}
func (m *LeaderInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_LeaderInfo.DiscardUnknown(m)
}

var xxx_messageInfo_LeaderInfo proto.InternalMessageInfo

func (m *LeaderInfo) GetRegionId() uint64 {
	if m != nil {
		return m.RegionId
	}
	return 0
}

func (m *LeaderInfo) GetPeerId() uint64 {
	if m != nil {
		return m.PeerId
	}
	return 0
}

func (m *LeaderInfo) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

func (m *LeaderInfo) GetRegionEpoch() *metapb.RegionEpoch {
	if m != nil {
		return m.RegionEpoch
	}
	return nil
}

func (m *LeaderInfo) GetReadState() *ReadState {
	if m != nil {
		return m.ReadState
	}
	return nil
}

type ReadState struct {
	AppliedIndex         uint64   `protobuf:"varint,1,opt,name=applied_index,json=appliedIndex,proto3" json:"applied_index,omitempty"`
	SafeTs               uint64   `protobuf:"varint,2,opt,name=safe_ts,json=safeTs,proto3" json:"safe_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadState) Reset()         { *m = ReadState{} }
func (m *ReadState) String() string { return proto.CompactTextString(m) }
func (*ReadState) ProtoMessage()    {}
func (*ReadState) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{101}
}
func (m *ReadState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReadState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReadState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReadState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadState.Merge(m, src)
}
func (m *ReadState) XXX_Size() int {
	return m.Size()
}
func (m *ReadState) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadState.DiscardUnknown(m)
}

var xxx_messageInfo_ReadState proto.InternalMessageInfo

func (m *ReadState) GetAppliedIndex() uint64 {
	if m != nil {
		return m.AppliedIndex
	}
	return 0
}

func (m *ReadState) GetSafeTs() uint64 {
	if m != nil {
		return m.SafeTs
	}
	return 0
}

type CheckLeaderRequest struct {
	Regions              []*LeaderInfo `protobuf:"bytes,1,rep,name=regions,proto3" json:"regions,omitempty"`
	Ts                   uint64        `protobuf:"varint,2,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CheckLeaderRequest) Reset()         { *m = CheckLeaderRequest{} }
func (m *CheckLeaderRequest) String() string { return proto.CompactTextString(m) }
func (*CheckLeaderRequest) ProtoMessage()    {}
func (*CheckLeaderRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{102}
}
func (m *CheckLeaderRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckLeaderRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckLeaderRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckLeaderRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckLeaderRequest.Merge(m, src)
}
func (m *CheckLeaderRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckLeaderRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckLeaderRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckLeaderRequest proto.InternalMessageInfo

func (m *CheckLeaderRequest) GetRegions() []*LeaderInfo {
	if m != nil {
		return m.Regions
	}
	return nil
}

func (m *CheckLeaderRequest) GetTs() uint64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

type CheckLeaderResponse struct {
	Regions              []uint64 `protobuf:"varint,1,rep,packed,name=regions,proto3" json:"regions,omitempty"`
	Ts                   uint64   `protobuf:"varint,2,opt,name=ts,proto3" json:"ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckLeaderResponse) Reset()         { *m = CheckLeaderResponse{} }
func (m *CheckLeaderResponse) String() string { return proto.CompactTextString(m) }
func (*CheckLeaderResponse) ProtoMessage()    {}
func (*CheckLeaderResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{103}
}
func (m *CheckLeaderResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckLeaderResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckLeaderResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckLeaderResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckLeaderResponse.Merge(m, src)
}
func (m *CheckLeaderResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckLeaderResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckLeaderResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckLeaderResponse proto.InternalMessageInfo

func (m *CheckLeaderResponse) GetRegions() []uint64 {
	if m != nil {
		return m.Regions
	}
	return nil
}

func (m *CheckLeaderResponse) GetTs() uint64 {
	if m != nil {
		return m.Ts
	}
	return 0
}

type StoreSafeTSRequest struct {
	// Get the minimal `safe_ts` from regions that overlap with the key range [`start_key`, `end_key`)
	// An empty key range means all regions in the store
	KeyRange             *KeyRange `protobuf:"bytes,1,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *StoreSafeTSRequest) Reset()         { *m = StoreSafeTSRequest{} }
func (m *StoreSafeTSRequest) String() string { return proto.CompactTextString(m) }
func (*StoreSafeTSRequest) ProtoMessage()    {}
func (*StoreSafeTSRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{104}
}
func (m *StoreSafeTSRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreSafeTSRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreSafeTSRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StoreSafeTSRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreSafeTSRequest.Merge(m, src)
}
func (m *StoreSafeTSRequest) XXX_Size() int {
	return m.Size()
}
func (m *StoreSafeTSRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreSafeTSRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StoreSafeTSRequest proto.InternalMessageInfo

func (m *StoreSafeTSRequest) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

type StoreSafeTSResponse struct {
	SafeTs               uint64   `protobuf:"varint,1,opt,name=safe_ts,json=safeTs,proto3" json:"safe_ts,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StoreSafeTSResponse) Reset()         { *m = StoreSafeTSResponse{} }
func (m *StoreSafeTSResponse) String() string { return proto.CompactTextString(m) }
func (*StoreSafeTSResponse) ProtoMessage()    {}
func (*StoreSafeTSResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{105}
}
func (m *StoreSafeTSResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreSafeTSResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StoreSafeTSResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StoreSafeTSResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreSafeTSResponse.Merge(m, src)
}
func (m *StoreSafeTSResponse) XXX_Size() int {
	return m.Size()
}
func (m *StoreSafeTSResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreSafeTSResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StoreSafeTSResponse proto.InternalMessageInfo

func (m *StoreSafeTSResponse) GetSafeTs() uint64 {
	if m != nil {
		return m.SafeTs
	}
	return 0
}

type RawGetKeyTTLRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawGetKeyTTLRequest) Reset()         { *m = RawGetKeyTTLRequest{} }
func (m *RawGetKeyTTLRequest) String() string { return proto.CompactTextString(m) }
func (*RawGetKeyTTLRequest) ProtoMessage()    {}
func (*RawGetKeyTTLRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{106}
}
func (m *RawGetKeyTTLRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawGetKeyTTLRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawGetKeyTTLRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawGetKeyTTLRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawGetKeyTTLRequest.Merge(m, src)
}
func (m *RawGetKeyTTLRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawGetKeyTTLRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawGetKeyTTLRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawGetKeyTTLRequest proto.InternalMessageInfo

func (m *RawGetKeyTTLRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawGetKeyTTLRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RawGetKeyTTLRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type RawGetKeyTTLResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Ttl                  uint64         `protobuf:"varint,3,opt,name=ttl,proto3" json:"ttl,omitempty"`
	NotFound             bool           `protobuf:"varint,4,opt,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawGetKeyTTLResponse) Reset()         { *m = RawGetKeyTTLResponse{} }
func (m *RawGetKeyTTLResponse) String() string { return proto.CompactTextString(m) }
func (*RawGetKeyTTLResponse) ProtoMessage()    {}
func (*RawGetKeyTTLResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{107}
}
func (m *RawGetKeyTTLResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawGetKeyTTLResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawGetKeyTTLResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawGetKeyTTLResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawGetKeyTTLResponse.Merge(m, src)
}
func (m *RawGetKeyTTLResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawGetKeyTTLResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawGetKeyTTLResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawGetKeyTTLResponse proto.InternalMessageInfo

func (m *RawGetKeyTTLResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawGetKeyTTLResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *RawGetKeyTTLResponse) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

func (m *RawGetKeyTTLResponse) GetNotFound() bool {
	if m != nil {
		return m.NotFound
	}
	return false
}

type RawCASRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Key                  []byte   `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	PreviousNotExist     bool     `protobuf:"varint,4,opt,name=previous_not_exist,json=previousNotExist,proto3" json:"previous_not_exist,omitempty"`
	PreviousValue        []byte   `protobuf:"bytes,5,opt,name=previous_value,json=previousValue,proto3" json:"previous_value,omitempty"`
	Cf                   string   `protobuf:"bytes,6,opt,name=cf,proto3" json:"cf,omitempty"`
	Ttl                  uint64   `protobuf:"varint,7,opt,name=ttl,proto3" json:"ttl,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawCASRequest) Reset()         { *m = RawCASRequest{} }
func (m *RawCASRequest) String() string { return proto.CompactTextString(m) }
func (*RawCASRequest) ProtoMessage()    {}
func (*RawCASRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{108}
}
func (m *RawCASRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawCASRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawCASRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawCASRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawCASRequest.Merge(m, src)
}
func (m *RawCASRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawCASRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawCASRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawCASRequest proto.InternalMessageInfo

func (m *RawCASRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawCASRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RawCASRequest) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RawCASRequest) GetPreviousNotExist() bool {
	if m != nil {
		return m.PreviousNotExist
	}
	return false
}

func (m *RawCASRequest) GetPreviousValue() []byte {
	if m != nil {
		return m.PreviousValue
	}
	return nil
}

func (m *RawCASRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *RawCASRequest) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

type RawCASResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error       string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Succeed     bool           `protobuf:"varint,3,opt,name=succeed,proto3" json:"succeed,omitempty"`
	// The previous value regardless of whether the comparison is succeed.
	PreviousNotExist     bool     `protobuf:"varint,4,opt,name=previous_not_exist,json=previousNotExist,proto3" json:"previous_not_exist,omitempty"`
	PreviousValue        []byte   `protobuf:"bytes,5,opt,name=previous_value,json=previousValue,proto3" json:"previous_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawCASResponse) Reset()         { *m = RawCASResponse{} }
func (m *RawCASResponse) String() string { return proto.CompactTextString(m) }
func (*RawCASResponse) ProtoMessage()    {}
func (*RawCASResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{109}
}
func (m *RawCASResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawCASResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawCASResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawCASResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawCASResponse.Merge(m, src)
}
func (m *RawCASResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawCASResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawCASResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawCASResponse proto.InternalMessageInfo

func (m *RawCASResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawCASResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *RawCASResponse) GetSucceed() bool {
	if m != nil {
		return m.Succeed
	}
	return false
}

func (m *RawCASResponse) GetPreviousNotExist() bool {
	if m != nil {
		return m.PreviousNotExist
	}
	return false
}

func (m *RawCASResponse) GetPreviousValue() []byte {
	if m != nil {
		return m.PreviousValue
	}
	return nil
}

type GetLockWaitInfoRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLockWaitInfoRequest) Reset()         { *m = GetLockWaitInfoRequest{} }
func (m *GetLockWaitInfoRequest) String() string { return proto.CompactTextString(m) }
func (*GetLockWaitInfoRequest) ProtoMessage()    {}
func (*GetLockWaitInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{110}
}
func (m *GetLockWaitInfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLockWaitInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLockWaitInfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLockWaitInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLockWaitInfoRequest.Merge(m, src)
}
func (m *GetLockWaitInfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetLockWaitInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLockWaitInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLockWaitInfoRequest proto.InternalMessageInfo

func (m *GetLockWaitInfoRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

type GetLockWaitInfoResponse struct {
	RegionError          *errorpb.Error           `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string                   `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Entries              []*deadlock.WaitForEntry `protobuf:"bytes,3,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetLockWaitInfoResponse) Reset()         { *m = GetLockWaitInfoResponse{} }
func (m *GetLockWaitInfoResponse) String() string { return proto.CompactTextString(m) }
func (*GetLockWaitInfoResponse) ProtoMessage()    {}
func (*GetLockWaitInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{111}
}
func (m *GetLockWaitInfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLockWaitInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLockWaitInfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLockWaitInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLockWaitInfoResponse.Merge(m, src)
}
func (m *GetLockWaitInfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetLockWaitInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLockWaitInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetLockWaitInfoResponse proto.InternalMessageInfo

func (m *GetLockWaitInfoResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *GetLockWaitInfoResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *GetLockWaitInfoResponse) GetEntries() []*deadlock.WaitForEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type GetLockWaitHistoryRequest struct {
	Context              *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLockWaitHistoryRequest) Reset()         { *m = GetLockWaitHistoryRequest{} }
func (m *GetLockWaitHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*GetLockWaitHistoryRequest) ProtoMessage()    {}
func (*GetLockWaitHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{112}
}
func (m *GetLockWaitHistoryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLockWaitHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLockWaitHistoryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLockWaitHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLockWaitHistoryRequest.Merge(m, src)
}
func (m *GetLockWaitHistoryRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetLockWaitHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLockWaitHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLockWaitHistoryRequest proto.InternalMessageInfo

func (m *GetLockWaitHistoryRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

type GetLockWaitHistoryResponse struct {
	RegionError          *errorpb.Error           `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string                   `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Entries              []*deadlock.WaitForEntry `protobuf:"bytes,3,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GetLockWaitHistoryResponse) Reset()         { *m = GetLockWaitHistoryResponse{} }
func (m *GetLockWaitHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*GetLockWaitHistoryResponse) ProtoMessage()    {}
func (*GetLockWaitHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{113}
}
func (m *GetLockWaitHistoryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetLockWaitHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetLockWaitHistoryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetLockWaitHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLockWaitHistoryResponse.Merge(m, src)
}
func (m *GetLockWaitHistoryResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetLockWaitHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLockWaitHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetLockWaitHistoryResponse proto.InternalMessageInfo

func (m *GetLockWaitHistoryResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *GetLockWaitHistoryResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *GetLockWaitHistoryResponse) GetEntries() []*deadlock.WaitForEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type RawCoprocessorRequest struct {
	Context  *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	CoprName string   `protobuf:"bytes,2,opt,name=copr_name,json=coprName,proto3" json:"copr_name,omitempty"`
	// Coprorcessor version constraint following SEMVER definition.
	CoprVersionReq       string      `protobuf:"bytes,3,opt,name=copr_version_req,json=coprVersionReq,proto3" json:"copr_version_req,omitempty"`
	Ranges               []*KeyRange `protobuf:"bytes,4,rep,name=ranges,proto3" json:"ranges,omitempty"`
	Data                 []byte      `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RawCoprocessorRequest) Reset()         { *m = RawCoprocessorRequest{} }
func (m *RawCoprocessorRequest) String() string { return proto.CompactTextString(m) }
func (*RawCoprocessorRequest) ProtoMessage()    {}
func (*RawCoprocessorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{114}
}
func (m *RawCoprocessorRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawCoprocessorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawCoprocessorRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawCoprocessorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawCoprocessorRequest.Merge(m, src)
}
func (m *RawCoprocessorRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawCoprocessorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawCoprocessorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawCoprocessorRequest proto.InternalMessageInfo

func (m *RawCoprocessorRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawCoprocessorRequest) GetCoprName() string {
	if m != nil {
		return m.CoprName
	}
	return ""
}

func (m *RawCoprocessorRequest) GetCoprVersionReq() string {
	if m != nil {
		return m.CoprVersionReq
	}
	return ""
}

func (m *RawCoprocessorRequest) GetRanges() []*KeyRange {
	if m != nil {
		return m.Ranges
	}
	return nil
}

func (m *RawCoprocessorRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawCoprocessorResponse struct {
	RegionError *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	// Error message for cases like if no coprocessor with a matching name is found
	// or on a version mismatch between plugin_api and the coprocessor.
	Error                string   `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawCoprocessorResponse) Reset()         { *m = RawCoprocessorResponse{} }
func (m *RawCoprocessorResponse) String() string { return proto.CompactTextString(m) }
func (*RawCoprocessorResponse) ProtoMessage()    {}
func (*RawCoprocessorResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{115}
}
func (m *RawCoprocessorResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawCoprocessorResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawCoprocessorResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawCoprocessorResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawCoprocessorResponse.Merge(m, src)
}
func (m *RawCoprocessorResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawCoprocessorResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawCoprocessorResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawCoprocessorResponse proto.InternalMessageInfo

func (m *RawCoprocessorResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawCoprocessorResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *RawCoprocessorResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type RawChecksumRequest struct {
	Context              *Context          `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	Algorithm            ChecksumAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=kvrpcpb.ChecksumAlgorithm" json:"algorithm,omitempty"`
	Ranges               []*KeyRange       `protobuf:"bytes,3,rep,name=ranges,proto3" json:"ranges,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RawChecksumRequest) Reset()         { *m = RawChecksumRequest{} }
func (m *RawChecksumRequest) String() string { return proto.CompactTextString(m) }
func (*RawChecksumRequest) ProtoMessage()    {}
func (*RawChecksumRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{116}
}
func (m *RawChecksumRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawChecksumRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawChecksumRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawChecksumRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawChecksumRequest.Merge(m, src)
}
func (m *RawChecksumRequest) XXX_Size() int {
	return m.Size()
}
func (m *RawChecksumRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RawChecksumRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RawChecksumRequest proto.InternalMessageInfo

func (m *RawChecksumRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *RawChecksumRequest) GetAlgorithm() ChecksumAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return ChecksumAlgorithm_Crc64_Xor
}

func (m *RawChecksumRequest) GetRanges() []*KeyRange {
	if m != nil {
		return m.Ranges
	}
	return nil
}

type RawChecksumResponse struct {
	RegionError          *errorpb.Error `protobuf:"bytes,1,opt,name=region_error,json=regionError,proto3" json:"region_error,omitempty"`
	Error                string         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	Checksum             uint64         `protobuf:"varint,3,opt,name=checksum,proto3" json:"checksum,omitempty"`
	TotalKvs             uint64         `protobuf:"varint,4,opt,name=total_kvs,json=totalKvs,proto3" json:"total_kvs,omitempty"`
	TotalBytes           uint64         `protobuf:"varint,5,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RawChecksumResponse) Reset()         { *m = RawChecksumResponse{} }
func (m *RawChecksumResponse) String() string { return proto.CompactTextString(m) }
func (*RawChecksumResponse) ProtoMessage()    {}
func (*RawChecksumResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{117}
}
func (m *RawChecksumResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawChecksumResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawChecksumResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RawChecksumResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawChecksumResponse.Merge(m, src)
}
func (m *RawChecksumResponse) XXX_Size() int {
	return m.Size()
}
func (m *RawChecksumResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RawChecksumResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RawChecksumResponse proto.InternalMessageInfo

func (m *RawChecksumResponse) GetRegionError() *errorpb.Error {
	if m != nil {
		return m.RegionError
	}
	return nil
}

func (m *RawChecksumResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *RawChecksumResponse) GetChecksum() uint64 {
	if m != nil {
		return m.Checksum
	}
	return 0
}

func (m *RawChecksumResponse) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *RawChecksumResponse) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

type CompactError struct {
	// Types that are valid to be assigned to Error:
	//
	//	*CompactError_ErrInvalidStartKey
	//	*CompactError_ErrPhysicalTableNotExist
	//	*CompactError_ErrCompactInProgress
	//	*CompactError_ErrTooManyPendingTasks
	Error                isCompactError_Error `protobuf_oneof:"error"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CompactError) Reset()         { *m = CompactError{} }
func (m *CompactError) String() string { return proto.CompactTextString(m) }
func (*CompactError) ProtoMessage()    {}
func (*CompactError) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{118}
}
func (m *CompactError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactError.Merge(m, src)
}
func (m *CompactError) XXX_Size() int {
	return m.Size()
}
func (m *CompactError) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactError.DiscardUnknown(m)
}

var xxx_messageInfo_CompactError proto.InternalMessageInfo

type isCompactError_Error interface {
	isCompactError_Error()
	MarshalTo([]byte) (int, error)
	Size() int
}

type CompactError_ErrInvalidStartKey struct {
	ErrInvalidStartKey *CompactErrorInvalidStartKey `protobuf:"bytes,1,opt,name=err_invalid_start_key,json=errInvalidStartKey,proto3,oneof" json:"err_invalid_start_key,omitempty"`
}
type CompactError_ErrPhysicalTableNotExist struct {
	ErrPhysicalTableNotExist *CompactErrorPhysicalTableNotExist `protobuf:"bytes,2,opt,name=err_physical_table_not_exist,json=errPhysicalTableNotExist,proto3,oneof" json:"err_physical_table_not_exist,omitempty"`
}
type CompactError_ErrCompactInProgress struct {
	ErrCompactInProgress *CompactErrorCompactInProgress `protobuf:"bytes,3,opt,name=err_compact_in_progress,json=errCompactInProgress,proto3,oneof" json:"err_compact_in_progress,omitempty"`
}
type CompactError_ErrTooManyPendingTasks struct {
	ErrTooManyPendingTasks *CompactErrorTooManyPendingTasks `protobuf:"bytes,4,opt,name=err_too_many_pending_tasks,json=errTooManyPendingTasks,proto3,oneof" json:"err_too_many_pending_tasks,omitempty"`
}

func (*CompactError_ErrInvalidStartKey) isCompactError_Error()       {}
func (*CompactError_ErrPhysicalTableNotExist) isCompactError_Error() {}
func (*CompactError_ErrCompactInProgress) isCompactError_Error()     {}
func (*CompactError_ErrTooManyPendingTasks) isCompactError_Error()   {}

func (m *CompactError) GetError() isCompactError_Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CompactError) GetErrInvalidStartKey() *CompactErrorInvalidStartKey {
	if x, ok := m.GetError().(*CompactError_ErrInvalidStartKey); ok {
		return x.ErrInvalidStartKey
	}
	return nil
}

func (m *CompactError) GetErrPhysicalTableNotExist() *CompactErrorPhysicalTableNotExist {
	if x, ok := m.GetError().(*CompactError_ErrPhysicalTableNotExist); ok {
		return x.ErrPhysicalTableNotExist
	}
	return nil
}

func (m *CompactError) GetErrCompactInProgress() *CompactErrorCompactInProgress {
	if x, ok := m.GetError().(*CompactError_ErrCompactInProgress); ok {
		return x.ErrCompactInProgress
	}
	return nil
}

func (m *CompactError) GetErrTooManyPendingTasks() *CompactErrorTooManyPendingTasks {
	if x, ok := m.GetError().(*CompactError_ErrTooManyPendingTasks); ok {
		return x.ErrTooManyPendingTasks
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CompactError) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CompactError_ErrInvalidStartKey)(nil),
		(*CompactError_ErrPhysicalTableNotExist)(nil),
		(*CompactError_ErrCompactInProgress)(nil),
		(*CompactError_ErrTooManyPendingTasks)(nil),
	}
}

type CompactErrorInvalidStartKey struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactErrorInvalidStartKey) Reset()         { *m = CompactErrorInvalidStartKey{} }
func (m *CompactErrorInvalidStartKey) String() string { return proto.CompactTextString(m) }
func (*CompactErrorInvalidStartKey) ProtoMessage()    {}
func (*CompactErrorInvalidStartKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{119}
}
func (m *CompactErrorInvalidStartKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactErrorInvalidStartKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactErrorInvalidStartKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactErrorInvalidStartKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactErrorInvalidStartKey.Merge(m, src)
}
func (m *CompactErrorInvalidStartKey) XXX_Size() int {
	return m.Size()
}
func (m *CompactErrorInvalidStartKey) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactErrorInvalidStartKey.DiscardUnknown(m)
}

var xxx_messageInfo_CompactErrorInvalidStartKey proto.InternalMessageInfo

type CompactErrorPhysicalTableNotExist struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactErrorPhysicalTableNotExist) Reset()         { *m = CompactErrorPhysicalTableNotExist{} }
func (m *CompactErrorPhysicalTableNotExist) String() string { return proto.CompactTextString(m) }
func (*CompactErrorPhysicalTableNotExist) ProtoMessage()    {}
func (*CompactErrorPhysicalTableNotExist) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{120}
}
func (m *CompactErrorPhysicalTableNotExist) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactErrorPhysicalTableNotExist) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactErrorPhysicalTableNotExist.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactErrorPhysicalTableNotExist) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactErrorPhysicalTableNotExist.Merge(m, src)
}
func (m *CompactErrorPhysicalTableNotExist) XXX_Size() int {
	return m.Size()
}
func (m *CompactErrorPhysicalTableNotExist) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactErrorPhysicalTableNotExist.DiscardUnknown(m)
}

var xxx_messageInfo_CompactErrorPhysicalTableNotExist proto.InternalMessageInfo

type CompactErrorCompactInProgress struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactErrorCompactInProgress) Reset()         { *m = CompactErrorCompactInProgress{} }
func (m *CompactErrorCompactInProgress) String() string { return proto.CompactTextString(m) }
func (*CompactErrorCompactInProgress) ProtoMessage()    {}
func (*CompactErrorCompactInProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{121}
}
func (m *CompactErrorCompactInProgress) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactErrorCompactInProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactErrorCompactInProgress.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactErrorCompactInProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactErrorCompactInProgress.Merge(m, src)
}
func (m *CompactErrorCompactInProgress) XXX_Size() int {
	return m.Size()
}
func (m *CompactErrorCompactInProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactErrorCompactInProgress.DiscardUnknown(m)
}

var xxx_messageInfo_CompactErrorCompactInProgress proto.InternalMessageInfo

type CompactErrorTooManyPendingTasks struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactErrorTooManyPendingTasks) Reset()         { *m = CompactErrorTooManyPendingTasks{} }
func (m *CompactErrorTooManyPendingTasks) String() string { return proto.CompactTextString(m) }
func (*CompactErrorTooManyPendingTasks) ProtoMessage()    {}
func (*CompactErrorTooManyPendingTasks) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{122}
}
func (m *CompactErrorTooManyPendingTasks) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactErrorTooManyPendingTasks) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactErrorTooManyPendingTasks.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactErrorTooManyPendingTasks) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactErrorTooManyPendingTasks.Merge(m, src)
}
func (m *CompactErrorTooManyPendingTasks) XXX_Size() int {
	return m.Size()
}
func (m *CompactErrorTooManyPendingTasks) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactErrorTooManyPendingTasks.DiscardUnknown(m)
}

var xxx_messageInfo_CompactErrorTooManyPendingTasks proto.InternalMessageInfo

type CompactRequest struct {
	// If specified, the compaction will start from this start key.
	// If unspecified, the compaction will start from beginning.
	// NOTE 1: The start key should be never manually constructed. You should always use a key
	// returned in CompactResponse.
	// NOTE 2: the compaction range will be always restricted by physical_table_id.
	StartKey []byte `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// The physical table that will be compacted.
	//
	// TODO: this is information that TiKV doesn't need to know.
	// See https://github.com/pingcap/kvproto/issues/912
	PhysicalTableId int64 `protobuf:"varint,2,opt,name=physical_table_id,json=physicalTableId,proto3" json:"physical_table_id,omitempty"`
	// The logical table id of the compaction. When receiving parallel requests with the same
	// logical table id, err_compact_in_progress will be returned.
	//
	// TODO: this is information that TiKV doesn't need to know.
	// See https://github.com/pingcap/kvproto/issues/912
	LogicalTableId       int64    `protobuf:"varint,3,opt,name=logical_table_id,json=logicalTableId,proto3" json:"logical_table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactRequest) Reset()         { *m = CompactRequest{} }
func (m *CompactRequest) String() string { return proto.CompactTextString(m) }
func (*CompactRequest) ProtoMessage()    {}
func (*CompactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{123}
}
func (m *CompactRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactRequest.Merge(m, src)
}
func (m *CompactRequest) XXX_Size() int {
	return m.Size()
}
func (m *CompactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CompactRequest proto.InternalMessageInfo

func (m *CompactRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *CompactRequest) GetPhysicalTableId() int64 {
	if m != nil {
		return m.PhysicalTableId
	}
	return 0
}

func (m *CompactRequest) GetLogicalTableId() int64 {
	if m != nil {
		return m.LogicalTableId
	}
	return 0
}

type CompactResponse struct {
	Error *CompactError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// The compaction is done incrementally. If there are more data to compact, this field
	// will be set. The client can request to compact more data according to the `compacted_end_key`.
	HasRemaining         bool     `protobuf:"varint,2,opt,name=has_remaining,json=hasRemaining,proto3" json:"has_remaining,omitempty"`
	CompactedStartKey    []byte   `protobuf:"bytes,3,opt,name=compacted_start_key,json=compactedStartKey,proto3" json:"compacted_start_key,omitempty"`
	CompactedEndKey      []byte   `protobuf:"bytes,4,opt,name=compacted_end_key,json=compactedEndKey,proto3" json:"compacted_end_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CompactResponse) Reset()         { *m = CompactResponse{} }
func (m *CompactResponse) String() string { return proto.CompactTextString(m) }
func (*CompactResponse) ProtoMessage()    {}
func (*CompactResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1afe832be69693c7, []int{124}
}
func (m *CompactResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompactResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompactResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompactResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompactResponse.Merge(m, src)
}
func (m *CompactResponse) XXX_Size() int {
	return m.Size()
}
func (m *CompactResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CompactResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CompactResponse proto.InternalMessageInfo

func (m *CompactResponse) GetError() *CompactError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CompactResponse) GetHasRemaining() bool {
	if m != nil {
		return m.HasRemaining
	}
	return false
}

func (m *CompactResponse) GetCompactedStartKey() []byte {
	if m != nil {
		return m.CompactedStartKey
	}
	return nil
}

func (m *CompactResponse) GetCompactedEndKey() []byte {
	if m != nil {
		return m.CompactedEndKey
	}
	return nil
}

func init() {
	proto.RegisterEnum("kvrpcpb.PessimisticLockWakeUpMode", PessimisticLockWakeUpMode_name, PessimisticLockWakeUpMode_value)
	proto.RegisterEnum("kvrpcpb.PessimisticLockKeyResultType", PessimisticLockKeyResultType_name, PessimisticLockKeyResultType_value)
	proto.RegisterEnum("kvrpcpb.APIVersion", APIVersion_name, APIVersion_value)
	proto.RegisterEnum("kvrpcpb.CommandPri", CommandPri_name, CommandPri_value)
	proto.RegisterEnum("kvrpcpb.IsolationLevel", IsolationLevel_name, IsolationLevel_value)
	proto.RegisterEnum("kvrpcpb.DiskFullOpt", DiskFullOpt_name, DiskFullOpt_value)
	proto.RegisterEnum("kvrpcpb.Op", Op_name, Op_value)
	proto.RegisterEnum("kvrpcpb.Assertion", Assertion_name, Assertion_value)
	proto.RegisterEnum("kvrpcpb.AssertionLevel", AssertionLevel_name, AssertionLevel_value)
	proto.RegisterEnum("kvrpcpb.Action", Action_name, Action_value)
	proto.RegisterEnum("kvrpcpb.ExtraOp", ExtraOp_name, ExtraOp_value)
	proto.RegisterEnum("kvrpcpb.ChecksumAlgorithm", ChecksumAlgorithm_name, ChecksumAlgorithm_value)
	proto.RegisterEnum("kvrpcpb.PrewriteRequest_PessimisticAction", PrewriteRequest_PessimisticAction_name, PrewriteRequest_PessimisticAction_value)
	proto.RegisterEnum("kvrpcpb.WriteConflict_Reason", WriteConflict_Reason_name, WriteConflict_Reason_value)
	proto.RegisterType((*GetRequest)(nil), "kvrpcpb.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "kvrpcpb.GetResponse")
	proto.RegisterType((*ScanRequest)(nil), "kvrpcpb.ScanRequest")
	proto.RegisterType((*ScanResponse)(nil), "kvrpcpb.ScanResponse")
	proto.RegisterType((*PrewriteRequest)(nil), "kvrpcpb.PrewriteRequest")
	proto.RegisterType((*PrewriteResponse)(nil), "kvrpcpb.PrewriteResponse")
	proto.RegisterType((*PessimisticLockRequest)(nil), "kvrpcpb.PessimisticLockRequest")
	proto.RegisterType((*PessimisticLockKeyResult)(nil), "kvrpcpb.PessimisticLockKeyResult")
	proto.RegisterType((*PessimisticLockResponse)(nil), "kvrpcpb.PessimisticLockResponse")
	proto.RegisterType((*PessimisticRollbackRequest)(nil), "kvrpcpb.PessimisticRollbackRequest")
	proto.RegisterType((*PessimisticRollbackResponse)(nil), "kvrpcpb.PessimisticRollbackResponse")
	proto.RegisterType((*TxnHeartBeatRequest)(nil), "kvrpcpb.TxnHeartBeatRequest")
	proto.RegisterType((*TxnHeartBeatResponse)(nil), "kvrpcpb.TxnHeartBeatResponse")
	proto.RegisterType((*CheckTxnStatusRequest)(nil), "kvrpcpb.CheckTxnStatusRequest")
	proto.RegisterType((*CheckTxnStatusResponse)(nil), "kvrpcpb.CheckTxnStatusResponse")
	proto.RegisterType((*CheckSecondaryLocksRequest)(nil), "kvrpcpb.CheckSecondaryLocksRequest")
	proto.RegisterType((*CheckSecondaryLocksResponse)(nil), "kvrpcpb.CheckSecondaryLocksResponse")
	proto.RegisterType((*CommitRequest)(nil), "kvrpcpb.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "kvrpcpb.CommitResponse")
	proto.RegisterType((*ImportRequest)(nil), "kvrpcpb.ImportRequest")
	proto.RegisterType((*ImportResponse)(nil), "kvrpcpb.ImportResponse")
	proto.RegisterType((*CleanupRequest)(nil), "kvrpcpb.CleanupRequest")
	proto.RegisterType((*CleanupResponse)(nil), "kvrpcpb.CleanupResponse")
	proto.RegisterType((*BatchGetRequest)(nil), "kvrpcpb.BatchGetRequest")
	proto.RegisterType((*BatchGetResponse)(nil), "kvrpcpb.BatchGetResponse")
	proto.RegisterType((*BatchRollbackRequest)(nil), "kvrpcpb.BatchRollbackRequest")
	proto.RegisterType((*BatchRollbackResponse)(nil), "kvrpcpb.BatchRollbackResponse")
	proto.RegisterType((*ScanLockRequest)(nil), "kvrpcpb.ScanLockRequest")
	proto.RegisterType((*ScanLockResponse)(nil), "kvrpcpb.ScanLockResponse")
	proto.RegisterType((*ResolveLockRequest)(nil), "kvrpcpb.ResolveLockRequest")
	proto.RegisterType((*ResolveLockResponse)(nil), "kvrpcpb.ResolveLockResponse")
	proto.RegisterType((*GCRequest)(nil), "kvrpcpb.GCRequest")
	proto.RegisterType((*GCResponse)(nil), "kvrpcpb.GCResponse")
	proto.RegisterType((*DeleteRangeRequest)(nil), "kvrpcpb.DeleteRangeRequest")
	proto.RegisterType((*DeleteRangeResponse)(nil), "kvrpcpb.DeleteRangeResponse")
	proto.RegisterType((*PrepareFlashbackToVersionRequest)(nil), "kvrpcpb.PrepareFlashbackToVersionRequest")
	proto.RegisterType((*PrepareFlashbackToVersionResponse)(nil), "kvrpcpb.PrepareFlashbackToVersionResponse")
	proto.RegisterType((*FlashbackToVersionRequest)(nil), "kvrpcpb.FlashbackToVersionRequest")
	proto.RegisterType((*FlashbackToVersionResponse)(nil), "kvrpcpb.FlashbackToVersionResponse")
	proto.RegisterType((*RawGetRequest)(nil), "kvrpcpb.RawGetRequest")
	proto.RegisterType((*RawGetResponse)(nil), "kvrpcpb.RawGetResponse")
	proto.RegisterType((*RawBatchGetRequest)(nil), "kvrpcpb.RawBatchGetRequest")
	proto.RegisterType((*RawBatchGetResponse)(nil), "kvrpcpb.RawBatchGetResponse")
	proto.RegisterType((*RawPutRequest)(nil), "kvrpcpb.RawPutRequest")
	proto.RegisterType((*RawPutResponse)(nil), "kvrpcpb.RawPutResponse")
	proto.RegisterType((*RawBatchPutRequest)(nil), "kvrpcpb.RawBatchPutRequest")
	proto.RegisterType((*RawBatchPutResponse)(nil), "kvrpcpb.RawBatchPutResponse")
	proto.RegisterType((*RawDeleteRequest)(nil), "kvrpcpb.RawDeleteRequest")
	proto.RegisterType((*RawDeleteResponse)(nil), "kvrpcpb.RawDeleteResponse")
	proto.RegisterType((*RawBatchDeleteRequest)(nil), "kvrpcpb.RawBatchDeleteRequest")
	proto.RegisterType((*RawBatchDeleteResponse)(nil), "kvrpcpb.RawBatchDeleteResponse")
	proto.RegisterType((*RawScanRequest)(nil), "kvrpcpb.RawScanRequest")
	proto.RegisterType((*RawScanResponse)(nil), "kvrpcpb.RawScanResponse")
	proto.RegisterType((*RawDeleteRangeRequest)(nil), "kvrpcpb.RawDeleteRangeRequest")
	proto.RegisterType((*RawDeleteRangeResponse)(nil), "kvrpcpb.RawDeleteRangeResponse")
	proto.RegisterType((*RawBatchScanRequest)(nil), "kvrpcpb.RawBatchScanRequest")
	proto.RegisterType((*RawBatchScanResponse)(nil), "kvrpcpb.RawBatchScanResponse")
	proto.RegisterType((*UnsafeDestroyRangeRequest)(nil), "kvrpcpb.UnsafeDestroyRangeRequest")
	proto.RegisterType((*UnsafeDestroyRangeResponse)(nil), "kvrpcpb.UnsafeDestroyRangeResponse")
	proto.RegisterType((*RegisterLockObserverRequest)(nil), "kvrpcpb.RegisterLockObserverRequest")
	proto.RegisterType((*RegisterLockObserverResponse)(nil), "kvrpcpb.RegisterLockObserverResponse")
	proto.RegisterType((*CheckLockObserverRequest)(nil), "kvrpcpb.CheckLockObserverRequest")
	proto.RegisterType((*CheckLockObserverResponse)(nil), "kvrpcpb.CheckLockObserverResponse")
	proto.RegisterType((*RemoveLockObserverRequest)(nil), "kvrpcpb.RemoveLockObserverRequest")
	proto.RegisterType((*RemoveLockObserverResponse)(nil), "kvrpcpb.RemoveLockObserverResponse")
	proto.RegisterType((*PhysicalScanLockRequest)(nil), "kvrpcpb.PhysicalScanLockRequest")
	proto.RegisterType((*PhysicalScanLockResponse)(nil), "kvrpcpb.PhysicalScanLockResponse")
	proto.RegisterType((*SplitRegionRequest)(nil), "kvrpcpb.SplitRegionRequest")
	proto.RegisterType((*SplitRegionResponse)(nil), "kvrpcpb.SplitRegionResponse")
	proto.RegisterType((*ReadIndexRequest)(nil), "kvrpcpb.ReadIndexRequest")
	proto.RegisterType((*ReadIndexResponse)(nil), "kvrpcpb.ReadIndexResponse")
	proto.RegisterType((*MvccGetByKeyRequest)(nil), "kvrpcpb.MvccGetByKeyRequest")
	proto.RegisterType((*MvccGetByKeyResponse)(nil), "kvrpcpb.MvccGetByKeyResponse")
	proto.RegisterType((*MvccGetByStartTsRequest)(nil), "kvrpcpb.MvccGetByStartTsRequest")
	proto.RegisterType((*MvccGetByStartTsResponse)(nil), "kvrpcpb.MvccGetByStartTsResponse")
	proto.RegisterType((*Context)(nil), "kvrpcpb.Context")
	proto.RegisterType((*LockInfo)(nil), "kvrpcpb.LockInfo")
	proto.RegisterType((*KeyError)(nil), "kvrpcpb.KeyError")
	proto.RegisterType((*WriteConflict)(nil), "kvrpcpb.WriteConflict")
	proto.RegisterType((*AlreadyExist)(nil), "kvrpcpb.AlreadyExist")
	proto.RegisterType((*Deadlock)(nil), "kvrpcpb.Deadlock")
	proto.RegisterType((*CommitTsExpired)(nil), "kvrpcpb.CommitTsExpired")
	proto.RegisterType((*TxnNotFound)(nil), "kvrpcpb.TxnNotFound")
	proto.RegisterType((*CommitTsTooLarge)(nil), "kvrpcpb.CommitTsTooLarge")
	proto.RegisterType((*AssertionFailed)(nil), "kvrpcpb.AssertionFailed")
	proto.RegisterType((*TimeDetail)(nil), "kvrpcpb.TimeDetail")
	proto.RegisterType((*ScanInfo)(nil), "kvrpcpb.ScanInfo")
	proto.RegisterType((*ScanDetail)(nil), "kvrpcpb.ScanDetail")
	proto.RegisterType((*ScanDetailV2)(nil), "kvrpcpb.ScanDetailV2")
	proto.RegisterType((*ExecDetails)(nil), "kvrpcpb.ExecDetails")
	proto.RegisterType((*ExecDetailsV2)(nil), "kvrpcpb.ExecDetailsV2")
	proto.RegisterType((*WriteDetail)(nil), "kvrpcpb.WriteDetail")
	proto.RegisterType((*KvPair)(nil), "kvrpcpb.KvPair")
	proto.RegisterType((*Mutation)(nil), "kvrpcpb.Mutation")
	proto.RegisterType((*MvccWrite)(nil), "kvrpcpb.MvccWrite")
	proto.RegisterType((*MvccValue)(nil), "kvrpcpb.MvccValue")
	proto.RegisterType((*MvccLock)(nil), "kvrpcpb.MvccLock")
	proto.RegisterType((*MvccInfo)(nil), "kvrpcpb.MvccInfo")
	proto.RegisterType((*TxnInfo)(nil), "kvrpcpb.TxnInfo")
	proto.RegisterType((*KeyRange)(nil), "kvrpcpb.KeyRange")
	proto.RegisterType((*LeaderInfo)(nil), "kvrpcpb.LeaderInfo")
	proto.RegisterType((*ReadState)(nil), "kvrpcpb.ReadState")
	proto.RegisterType((*CheckLeaderRequest)(nil), "kvrpcpb.CheckLeaderRequest")
	proto.RegisterType((*CheckLeaderResponse)(nil), "kvrpcpb.CheckLeaderResponse")
	proto.RegisterType((*StoreSafeTSRequest)(nil), "kvrpcpb.StoreSafeTSRequest")
	proto.RegisterType((*StoreSafeTSResponse)(nil), "kvrpcpb.StoreSafeTSResponse")
	proto.RegisterType((*RawGetKeyTTLRequest)(nil), "kvrpcpb.RawGetKeyTTLRequest")
	proto.RegisterType((*RawGetKeyTTLResponse)(nil), "kvrpcpb.RawGetKeyTTLResponse")
	proto.RegisterType((*RawCASRequest)(nil), "kvrpcpb.RawCASRequest")
	proto.RegisterType((*RawCASResponse)(nil), "kvrpcpb.RawCASResponse")
	proto.RegisterType((*GetLockWaitInfoRequest)(nil), "kvrpcpb.GetLockWaitInfoRequest")
	proto.RegisterType((*GetLockWaitInfoResponse)(nil), "kvrpcpb.GetLockWaitInfoResponse")
	proto.RegisterType((*GetLockWaitHistoryRequest)(nil), "kvrpcpb.GetLockWaitHistoryRequest")
	proto.RegisterType((*GetLockWaitHistoryResponse)(nil), "kvrpcpb.GetLockWaitHistoryResponse")
	proto.RegisterType((*RawCoprocessorRequest)(nil), "kvrpcpb.RawCoprocessorRequest")
	proto.RegisterType((*RawCoprocessorResponse)(nil), "kvrpcpb.RawCoprocessorResponse")
	proto.RegisterType((*RawChecksumRequest)(nil), "kvrpcpb.RawChecksumRequest")
	proto.RegisterType((*RawChecksumResponse)(nil), "kvrpcpb.RawChecksumResponse")
	proto.RegisterType((*CompactError)(nil), "kvrpcpb.CompactError")
	proto.RegisterType((*CompactErrorInvalidStartKey)(nil), "kvrpcpb.CompactErrorInvalidStartKey")
	proto.RegisterType((*CompactErrorPhysicalTableNotExist)(nil), "kvrpcpb.CompactErrorPhysicalTableNotExist")
	proto.RegisterType((*CompactErrorCompactInProgress)(nil), "kvrpcpb.CompactErrorCompactInProgress")
	proto.RegisterType((*CompactErrorTooManyPendingTasks)(nil), "kvrpcpb.CompactErrorTooManyPendingTasks")
	proto.RegisterType((*CompactRequest)(nil), "kvrpcpb.CompactRequest")
	proto.RegisterType((*CompactResponse)(nil), "kvrpcpb.CompactResponse")
}

func init() { proto.RegisterFile("kvrpcpb.proto", fileDescriptor_1afe832be69693c7) }

var fileDescriptor_1afe832be69693c7 = []byte{
	// 6304 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x3c, 0x5b, 0x6c, 0x24, 0xd9,
	0x55, 0x53, 0xfd, 0x70, 0x77, 0x9f, 0xb6, 0xdb, 0xe5, 0xeb, 0x57, 0xdb, 0x33, 0xb3, 0xe3, 0xa9,
	0xcd, 0xec, 0x3a, 0x4e, 0xd6, 0x9b, 0xf5, 0xee, 0xe6, 0x41, 0x42, 0xb2, 0x33, 0xf6, 0x3c, 0xbc,
	0xe3, 0x19, 0x5b, 0xd5, 0xbd, 0xb3, 0xac, 0x20, 0xa9, 0x5c, 0x57, 0x5f, 0x77, 0x97, 0x5c, 0x5d,
	0x55, 0x5b, 0x75, 0xdb, 0x76, 0x07, 0x21, 0x11, 0x25, 0x20, 0x45, 0x42, 0x3c, 0xa2, 0x48, 0x41,
	0x22, 0x42, 0xe2, 0x23, 0x12, 0xe1, 0x0f, 0xf1, 0x03, 0xe4, 0x03, 0x21, 0xe5, 0x23, 0x20, 0xa2,
	0x44, 0x42, 0x28, 0x08, 0x3e, 0x80, 0x45, 0xe2, 0x9b, 0x1f, 0x84, 0xf8, 0x40, 0xa0, 0xfb, 0xaa,
	0x47, 0x77, 0x8f, 0xc7, 0xd3, 0x63, 0xcf, 0x06, 0xbe, 0xdc, 0x75, 0xce, 0xb9, 0xf7, 0x9e, 0x7b,
	0x5e, 0xf7, 0x9e, 0x7b, 0xcf, 0x35, 0x4c, 0x1d, 0x1e, 0x85, 0x81, 0x1d, 0xec, 0xaf, 0x07, 0xa1,
	0x4f, 0x7d, 0x54, 0x92, 0x9f, 0xcb, 0x93, 0x5d, 0x42, 0xb1, 0x02, 0x2f, 0x4f, 0x91, 0x30, 0xf4,
	0xc3, 0xf8, 0x73, 0xae, 0xed, 0xb7, 0x7d, 0xfe, 0xf3, 0x55, 0xf6, 0x4b, 0x42, 0xa7, 0xc3, 0x5e,
	0x44, 0xf9, 0x4f, 0x09, 0xa8, 0xb5, 0x08, 0x6e, 0xb9, 0xbe, 0x7d, 0xa8, 0x7a, 0xa1, 0x21, 0xb6,
	0x89, 0xea, 0xc5, 0x68, 0x01, 0xdc, 0x25, 0xd4, 0x24, 0xef, 0xf7, 0x48, 0x44, 0xd1, 0x1a, 0x94,
	0x6c, 0xdf, 0xa3, 0xe4, 0x84, 0xd6, 0xb5, 0x15, 0x6d, 0xb5, 0xba, 0xa1, 0xaf, 0x2b, 0xd6, 0x36,
	0x05, 0xdc, 0x54, 0x04, 0x48, 0x87, 0xfc, 0x21, 0xe9, 0xd7, 0x73, 0x2b, 0xda, 0xea, 0xa4, 0xc9,
	0x7e, 0xa2, 0x3a, 0x94, 0x8e, 0x48, 0x18, 0x39, 0xbe, 0x57, 0xcf, 0xaf, 0x68, 0xab, 0x05, 0x53,
	0x7d, 0x1a, 0x1f, 0x68, 0x50, 0xe5, 0xc3, 0x44, 0x81, 0xef, 0x45, 0x04, 0xbd, 0x06, 0x93, 0x21,
	0x69, 0x3b, 0xbe, 0x67, 0xf1, 0x39, 0xc9, 0xc1, 0x6a, 0xeb, 0x6a, 0x86, 0xb7, 0xd9, 0x5f, 0xb3,
	0x2a, 0x68, 0xf8, 0x07, 0x7a, 0x19, 0x8a, 0x82, 0x36, 0xc7, 0x69, 0x67, 0x62, 0xc6, 0xee, 0x93,
	0xbe, 0x20, 0x17, 0x78, 0x34, 0x07, 0xc5, 0x23, 0xec, 0xf6, 0x08, 0xe7, 0x61, 0xd2, 0x14, 0x1f,
	0xe8, 0x32, 0x54, 0x3c, 0x9f, 0x5a, 0x07, 0x7e, 0xcf, 0x6b, 0xd5, 0x0b, 0x2b, 0xda, 0x6a, 0xd9,
	0x2c, 0x7b, 0x3e, 0xbd, 0xc3, 0xbe, 0xd1, 0xe7, 0x61, 0x9a, 0x9c, 0x10, 0xdb, 0x6a, 0x11, 0x8a,
	0x1d, 0x37, 0xb2, 0x8e, 0x36, 0xea, 0x13, 0x7c, 0x94, 0x85, 0x78, 0x94, 0xdb, 0x27, 0xc4, 0xde,
	0x12, 0xe8, 0x47, 0x1b, 0xe6, 0x14, 0x49, 0x7f, 0xbe, 0x5d, 0x28, 0x17, 0xf5, 0x09, 0xe3, 0x3f,
	0x34, 0xa8, 0x36, 0x6c, 0xec, 0x8d, 0x23, 0xcc, 0xcb, 0x50, 0x89, 0x28, 0x0e, 0xa9, 0x95, 0x88,
	0xb4, 0xcc, 0x01, 0xf7, 0x49, 0x9f, 0xcd, 0xc8, 0x75, 0xba, 0x0e, 0xe5, 0x33, 0x9a, 0x32, 0xc5,
	0x47, 0x5a, 0xda, 0x85, 0x8c, 0xb4, 0xd1, 0x12, 0x94, 0x0f, 0x49, 0xdf, 0xf2, 0x3d, 0xb7, 0x5f,
	0x2f, 0xf2, 0xa9, 0x96, 0x0e, 0x49, 0x7f, 0xd7, 0x73, 0xb9, 0x8a, 0x42, 0xc2, 0xe8, 0x08, 0x9f,
	0x61, 0xd9, 0x54, 0x9f, 0x68, 0x11, 0x4a, 0xc4, 0x6b, 0xf1, 0xf1, 0x4b, 0x7c, 0xfc, 0x09, 0xe2,
	0xb5, 0xd8, 0xe8, 0xd7, 0xa0, 0x1a, 0xe1, 0x6e, 0xe0, 0x12, 0x2b, 0xa2, 0x24, 0xa8, 0x97, 0x39,
	0x0f, 0x20, 0x40, 0x0d, 0x4a, 0x02, 0xe3, 0x77, 0x34, 0x98, 0x14, 0xf3, 0x1e, 0x5f, 0xbb, 0x37,
	0xa0, 0x18, 0x60, 0x27, 0x8c, 0xea, 0xb9, 0x95, 0xfc, 0x6a, 0x75, 0x63, 0x3a, 0xd1, 0xee, 0xd1,
	0x1e, 0x76, 0x42, 0x53, 0x60, 0x13, 0x23, 0xc8, 0x9f, 0x6e, 0x04, 0xc6, 0x7f, 0x15, 0x61, 0x7a,
	0x2f, 0x24, 0xc7, 0xa1, 0x43, 0xc9, 0x38, 0xfa, 0x78, 0x15, 0x2a, 0xdd, 0x1e, 0xc5, 0xd4, 0xf1,
	0x3d, 0xc5, 0x53, 0x32, 0xd8, 0x03, 0x89, 0x31, 0x13, 0x1a, 0x74, 0x1d, 0x26, 0x83, 0xd0, 0xe9,
	0xe2, 0xb0, 0x6f, 0x31, 0x67, 0x93, 0xc6, 0x57, 0x95, 0xb0, 0x1d, 0xdf, 0x3e, 0x44, 0x2f, 0xc2,
	0x94, 0xd0, 0x71, 0x56, 0x6d, 0x93, 0x1c, 0xf8, 0x28, 0xd1, 0x1d, 0x6b, 0x6f, 0x51, 0xea, 0x72,
	0xdd, 0x15, 0xcc, 0x12, 0xfb, 0x6e, 0x52, 0x17, 0x6d, 0xc0, 0x7c, 0x74, 0xe8, 0x04, 0x96, 0xed,
	0x7b, 0x11, 0x0d, 0xb1, 0xe3, 0x51, 0xcb, 0xee, 0x10, 0xfb, 0x50, 0x6a, 0x72, 0x96, 0x21, 0x37,
	0x63, 0xdc, 0x26, 0x43, 0xa1, 0x5f, 0x84, 0xd9, 0x80, 0x44, 0x91, 0xd3, 0x75, 0x22, 0xea, 0xd8,
	0x16, 0xb6, 0xc5, 0x8c, 0x4a, 0x2b, 0xf9, 0xd5, 0xda, 0xc6, 0x5a, 0x3c, 0xa3, 0x01, 0x51, 0xad,
	0xef, 0x25, 0x6d, 0x6e, 0xf2, 0x26, 0x26, 0x0a, 0x06, 0x41, 0x11, 0xe3, 0x95, 0x9e, 0x78, 0x56,
	0xe4, 0x7c, 0x85, 0x70, 0xb3, 0x28, 0x98, 0x25, 0x7a, 0xe2, 0x35, 0x9c, 0xaf, 0x10, 0x64, 0xc0,
	0xd4, 0x81, 0x1f, 0x5a, 0xbd, 0xa0, 0x85, 0x29, 0xb1, 0x68, 0x54, 0xaf, 0x70, 0x7c, 0xf5, 0xc0,
	0x0f, 0xdf, 0xe1, 0xb0, 0x66, 0xc4, 0x68, 0xba, 0x8e, 0x67, 0xd9, 0x7e, 0xb7, 0xeb, 0x50, 0x46,
	0x03, 0x82, 0xa6, 0xeb, 0x78, 0x9b, 0x1c, 0xd6, 0x8c, 0xd0, 0x2a, 0xe8, 0xbd, 0x88, 0x58, 0x38,
	0xea, 0x7b, 0xb6, 0xa4, 0xac, 0x57, 0xf9, 0x74, 0x6b, 0xbd, 0x88, 0xdc, 0x64, 0x60, 0x41, 0x8b,
	0x56, 0xa0, 0x1a, 0x11, 0xdb, 0xf7, 0x5a, 0x38, 0x74, 0x48, 0x54, 0x9f, 0x5c, 0xc9, 0x33, 0xf9,
	0xa7, 0x40, 0xe8, 0x0a, 0x00, 0x0d, 0x99, 0x5b, 0x10, 0x2b, 0xb0, 0xeb, 0x53, 0x22, 0x06, 0xd0,
	0xb0, 0xbf, 0xeb, 0x91, 0x3d, 0x9b, 0x73, 0x83, 0x4f, 0x52, 0xdc, 0xd4, 0x24, 0x37, 0xf8, 0x24,
	0xe6, 0xe6, 0x2d, 0x98, 0xc6, 0x51, 0x44, 0x42, 0x36, 0x7d, 0xcb, 0x25, 0x47, 0xc4, 0xad, 0x4f,
	0xaf, 0x68, 0xab, 0xb5, 0x8d, 0xc5, 0x58, 0x92, 0x37, 0x15, 0x7e, 0x87, 0xa1, 0xcd, 0x1a, 0xce,
	0x7c, 0x1b, 0xfb, 0x30, 0x33, 0x24, 0x5b, 0xb4, 0x0c, 0x0b, 0x8d, 0xfb, 0xdb, 0x7b, 0xd6, 0xde,
	0xed, 0x46, 0x63, 0xfb, 0xc1, 0x76, 0xa3, 0xb9, 0xbd, 0x69, 0x6d, 0xde, 0xbb, 0xbd, 0x79, 0x5f,
	0xbf, 0x84, 0xea, 0x30, 0xb7, 0xb5, 0x3b, 0x02, 0xa3, 0xa1, 0x45, 0x98, 0xdd, 0xda, 0xb5, 0x36,
	0x77, 0x1f, 0x36, 0x9a, 0xe6, 0xcd, 0xed, 0x87, 0x4d, 0x89, 0xc8, 0x19, 0xff, 0xad, 0x81, 0x9e,
	0x28, 0x74, 0x7c, 0x9f, 0xfc, 0x28, 0x4c, 0x70, 0xec, 0xb0, 0x03, 0xc4, 0xde, 0x26, 0x09, 0x86,
	0x55, 0x99, 0x1f, 0x56, 0xe5, 0xcb, 0xa0, 0x0b, 0xd1, 0xa7, 0xc8, 0x84, 0x07, 0x4c, 0xf9, 0x4c,
	0x03, 0x31, 0xe1, 0x88, 0x68, 0x5c, 0x7c, 0x8a, 0x68, 0x6c, 0xfc, 0xa0, 0x00, 0x0b, 0x29, 0x21,
	0x33, 0xdf, 0xfb, 0xff, 0x12, 0x02, 0x86, 0xdc, 0x6a, 0x62, 0xa4, 0x5b, 0x39, 0x91, 0x75, 0xe0,
	0x84, 0x11, 0x15, 0x7c, 0x94, 0xb8, 0xa5, 0x57, 0x9d, 0xe8, 0x0e, 0x83, 0x71, 0x3e, 0xae, 0xc3,
	0xe4, 0x31, 0x66, 0x2a, 0x70, 0xba, 0xc4, 0xef, 0x51, 0xee, 0xbd, 0x79, 0xb3, 0xca, 0x60, 0x4d,
	0x01, 0x42, 0x75, 0x28, 0x1e, 0xf8, 0xa1, 0x4d, 0xb8, 0xe7, 0x96, 0x6f, 0xe5, 0xea, 0x9a, 0x29,
	0x00, 0x6c, 0x12, 0x21, 0xa1, 0xbd, 0xd0, 0xb3, 0xf8, 0xd2, 0x2a, 0xfc, 0xb6, 0x6c, 0x4e, 0x0a,
	0xe0, 0x23, 0x0e, 0x1b, 0xb6, 0x88, 0xea, 0x28, 0x8b, 0x98, 0xe6, 0x01, 0xcc, 0x22, 0x27, 0x4e,
	0x44, 0x89, 0x67, 0x93, 0xfa, 0xa4, 0xf0, 0x6d, 0x0e, 0xbe, 0xad, 0xa0, 0xe8, 0x15, 0x98, 0xe5,
	0x12, 0x61, 0x2b, 0x9a, 0xe5, 0x1c, 0x08, 0xfa, 0x48, 0xba, 0xb0, 0xce, 0x50, 0x6c, 0x71, 0xdb,
	0x3e, 0xe0, 0x2d, 0x22, 0xb4, 0xc5, 0x66, 0x77, 0x48, 0xac, 0x5e, 0x60, 0x75, 0xfd, 0x16, 0xe1,
	0x9e, 0x5c, 0xdb, 0x30, 0x92, 0x68, 0x97, 0x35, 0x8e, 0x77, 0xf1, 0x21, 0x79, 0x27, 0x78, 0xe0,
	0xb7, 0x88, 0x09, 0xc7, 0xf1, 0x6f, 0xe3, 0xdf, 0x35, 0xa8, 0x0f, 0x50, 0xde, 0x27, 0x7d, 0x93,
	0x44, 0x3d, 0x97, 0xa2, 0xcf, 0x40, 0x81, 0xf6, 0x03, 0xc2, 0xad, 0xa8, 0xb6, 0x71, 0xe3, 0x71,
	0x5d, 0xc7, 0x0d, 0x9a, 0xfd, 0x80, 0x98, 0xbc, 0x49, 0xb2, 0x3f, 0xc9, 0xa5, 0xf7, 0x27, 0x57,
	0xa0, 0x92, 0x48, 0x21, 0xcf, 0x27, 0x96, 0x00, 0xd0, 0x9b, 0xb0, 0xc8, 0x66, 0x49, 0x5a, 0xd6,
	0xb1, 0x43, 0x3b, 0x6c, 0x05, 0x38, 0x70, 0x1d, 0x3b, 0xe5, 0x42, 0x73, 0x02, 0xfd, 0xae, 0x43,
	0x3b, 0x9b, 0x12, 0xd9, 0x8c, 0xd0, 0x3a, 0xf0, 0x45, 0xc1, 0x0a, 0x49, 0xe4, 0xbb, 0x47, 0x8e,
	0xd7, 0x16, 0x06, 0x21, 0x02, 0xe8, 0x0c, 0x43, 0x99, 0x0a, 0xc3, 0xb8, 0x35, 0xfe, 0x2d, 0x07,
	0x8b, 0x43, 0x9e, 0xf3, 0x5c, 0x02, 0xc8, 0x35, 0xa8, 0x0c, 0x04, 0x0f, 0x6e, 0x71, 0x65, 0x5b,
	0xd9, 0x4a, 0x5d, 0x49, 0x8d, 0xcd, 0x77, 0x52, 0x98, 0xa3, 0x90, 0xdc, 0x02, 0x4c, 0x48, 0x3b,
	0x2c, 0xf2, 0x98, 0x2f, 0xbf, 0xd0, 0x55, 0x80, 0x78, 0xc7, 0xc7, 0x1c, 0x25, 0xcf, 0x44, 0xaa,
	0xb6, 0x7c, 0x23, 0xa3, 0x4c, 0xe9, 0x29, 0xa2, 0x0c, 0xfa, 0x2c, 0xdb, 0x49, 0x31, 0xd5, 0x46,
	0xf5, 0x32, 0x9f, 0xdd, 0xf5, 0x27, 0x1a, 0x81, 0xa9, 0x5a, 0x18, 0xdf, 0xd5, 0x60, 0x39, 0x45,
	0x65, 0xfa, 0xae, 0xbb, 0x8f, 0xc7, 0x0b, 0x53, 0x43, 0x21, 0x25, 0x37, 0x22, 0xa4, 0x0c, 0xc5,
	0x8d, 0xfc, 0x70, 0xdc, 0x40, 0x50, 0x38, 0x24, 0x7d, 0x66, 0x50, 0x4c, 0x8a, 0xfc, 0xb7, 0xf1,
	0x7d, 0x0d, 0x2e, 0x8f, 0xe4, 0xf3, 0xb9, 0x18, 0xc5, 0x08, 0x15, 0xe5, 0x9f, 0x66, 0x21, 0xf8,
	0x63, 0x0d, 0x66, 0x9b, 0x27, 0xde, 0x3d, 0x82, 0x43, 0x7a, 0x8b, 0xe0, 0xb1, 0xb2, 0x9c, 0xc1,
	0xa0, 0x9e, 0x3b, 0x43, 0x50, 0xcf, 0x8f, 0xd0, 0xc0, 0x4b, 0x30, 0x8d, 0x5b, 0x47, 0x4e, 0x44,
	0xac, 0x38, 0xb6, 0xcb, 0xc5, 0x4f, 0x80, 0x77, 0x44, 0x84, 0x37, 0x7e, 0xa4, 0xc1, 0x5c, 0x96,
	0xe7, 0xe7, 0x90, 0x32, 0xa5, 0x57, 0x9c, 0x7c, 0x76, 0xc5, 0x19, 0xa1, 0x83, 0xc2, 0xd3, 0xe8,
	0xe0, 0x5f, 0x72, 0x30, 0xcf, 0xb7, 0xa2, 0xcd, 0x13, 0xaf, 0x41, 0x31, 0xed, 0x45, 0xe3, 0x68,
	0xe1, 0x1a, 0x28, 0x89, 0xa7, 0x12, 0x24, 0x90, 0x20, 0x96, 0xa4, 0x2c, 0x42, 0x49, 0xcc, 0x40,
	0x99, 0xf6, 0x04, 0x9f, 0x40, 0xc4, 0xe4, 0x6e, 0x63, 0xd7, 0x25, 0xa1, 0x25, 0x74, 0x94, 0x6c,
	0x3a, 0x04, 0xb8, 0xc1, 0xa0, 0x4d, 0x1e, 0x2d, 0xec, 0x5e, 0x18, 0x12, 0x8f, 0x93, 0x88, 0x65,
	0xb7, 0x22, 0x21, 0xcd, 0x08, 0xbd, 0x06, 0xf3, 0xa1, 0x34, 0x7e, 0xb6, 0x00, 0xb1, 0xc0, 0xc2,
	0xa3, 0xb3, 0xdc, 0x7b, 0x23, 0x85, 0xdc, 0x3e, 0x78, 0xe8, 0x53, 0xbe, 0x0c, 0xa1, 0x35, 0x98,
	0xe1, 0xeb, 0xa5, 0x95, 0xde, 0xbb, 0x8a, 0xb5, 0x78, 0x9a, 0x23, 0x1a, 0xc9, 0xe6, 0xf5, 0x73,
	0xb0, 0x9c, 0xc4, 0xe8, 0xf4, 0x86, 0x9d, 0xdb, 0x5c, 0x99, 0x37, 0xaa, 0xc7, 0x14, 0x03, 0xf1,
	0xc5, 0xf8, 0x71, 0x0e, 0x16, 0x06, 0x65, 0xfc, 0xe1, 0x5a, 0xcd, 0x0d, 0xa8, 0xc9, 0x70, 0x9e,
	0xdd, 0xe8, 0x4c, 0x09, 0xa8, 0x72, 0x8a, 0x97, 0x61, 0x42, 0x64, 0x24, 0x5c, 0xe0, 0xb5, 0x54,
	0xda, 0x27, 0xb3, 0x0e, 0x89, 0x46, 0xeb, 0x50, 0xe1, 0x43, 0x39, 0xde, 0x81, 0x2f, 0x53, 0xf3,
	0x84, 0x2f, 0x26, 0x83, 0x6d, 0xef, 0xc0, 0x37, 0x39, 0x3b, 0xec, 0xd7, 0xb3, 0x06, 0x77, 0xe3,
	0xab, 0x1a, 0x2c, 0x73, 0x89, 0x36, 0x64, 0xfe, 0xc0, 0x3d, 0x7d, 0x2c, 0xd3, 0x55, 0x61, 0x35,
	0x97, 0x84, 0xd5, 0x33, 0x45, 0x0c, 0xe3, 0x7f, 0x34, 0xb8, 0x3c, 0x92, 0x87, 0xe7, 0xa0, 0xda,
	0x97, 0xa1, 0xc8, 0x64, 0xc9, 0x9c, 0x29, 0x3f, 0x5a, 0xd6, 0x02, 0x8f, 0x2e, 0xa7, 0xd7, 0x6d,
	0xa1, 0xe3, 0x64, 0xcd, 0x7e, 0xd6, 0x8d, 0xfc, 0xf7, 0x34, 0x98, 0x12, 0x0e, 0x72, 0x61, 0x0b,
	0xa3, 0xd2, 0x4e, 0x3e, 0xa5, 0x9d, 0xb3, 0x19, 0xaf, 0x38, 0xf4, 0x31, 0x27, 0xf6, 0x1d, 0xcf,
	0xf5, 0xdb, 0xc6, 0xdf, 0x6a, 0x50, 0x53, 0xbc, 0x3e, 0x07, 0x05, 0x0d, 0xf3, 0x98, 0x1f, 0xe5,
	0x60, 0xcf, 0x1a, 0xbd, 0xdb, 0x30, 0xb5, 0xdd, 0x0d, 0xfc, 0x30, 0x56, 0x40, 0x26, 0x29, 0xd2,
	0xce, 0x90, 0x14, 0x0d, 0x33, 0x9a, 0x1b, 0xc1, 0xa8, 0xf1, 0x1e, 0xd4, 0xd4, 0x40, 0xe3, 0x4b,
	0x6f, 0x2e, 0x2d, 0xbd, 0x8a, 0x3a, 0x0a, 0xfa, 0x26, 0xd3, 0x8c, 0x4b, 0xb0, 0xd7, 0x0b, 0xce,
	0xe7, 0x98, 0xf3, 0x4c, 0xeb, 0x7d, 0x76, 0x3d, 0x29, 0x0c, 0xac, 0x27, 0xc6, 0xb7, 0x34, 0x98,
	0x8e, 0x99, 0xfa, 0x99, 0xb1, 0x17, 0xe3, 0x10, 0xa6, 0x6f, 0x61, 0x6a, 0x77, 0xc6, 0x3c, 0x12,
	0x1e, 0x15, 0xeb, 0x1e, 0x7f, 0x28, 0xfc, 0x8f, 0x1a, 0xe8, 0xc9, 0x68, 0x17, 0x7e, 0x76, 0xf8,
	0x8c, 0xbe, 0x90, 0xc8, 0xba, 0x78, 0xba, 0xac, 0xdf, 0x2e, 0x94, 0xf3, 0x7a, 0xc1, 0xf8, 0x65,
	0x98, 0xe3, 0x93, 0xbb, 0xf0, 0xbd, 0xfd, 0x88, 0x10, 0x66, 0xfc, 0x89, 0x06, 0xf3, 0x03, 0xa3,
	0x3f, 0x07, 0x23, 0x7b, 0xd6, 0xfd, 0xfa, 0x1f, 0x69, 0x30, 0xdd, 0xb0, 0xb1, 0x37, 0xee, 0x89,
	0xcd, 0x35, 0xa8, 0x76, 0xf1, 0xc9, 0x80, 0xb0, 0xa0, 0x8b, 0x4f, 0x94, 0xa8, 0x32, 0xa7, 0xec,
	0xf9, 0xc7, 0x9d, 0xb2, 0x17, 0xd2, 0xa7, 0xec, 0xa9, 0x63, 0xf1, 0x62, 0xfa, 0x58, 0xdc, 0xf8,
	0xa9, 0x06, 0x7a, 0xc2, 0xec, 0xcf, 0xd2, 0x9a, 0xfc, 0xac, 0x41, 0xff, 0xc7, 0x1a, 0x20, 0x71,
	0x2e, 0x40, 0xc6, 0xd5, 0xc4, 0x99, 0x0c, 0xf7, 0x8c, 0x6b, 0xd8, 0x2b, 0x50, 0xa1, 0x27, 0x1e,
	0xdf, 0xfa, 0x89, 0xe4, 0x34, 0x3d, 0x72, 0xf3, 0xc4, 0x13, 0x5b, 0x3f, 0x2a, 0x7e, 0x24, 0x69,
	0x6c, 0x31, 0xe5, 0x0e, 0x2c, 0x11, 0xcc, 0xcc, 0xe8, 0xff, 0x80, 0x33, 0x3c, 0x82, 0xca, 0xdd,
	0xcd, 0x71, 0x64, 0x7f, 0x15, 0x20, 0xc2, 0x07, 0xc4, 0x0a, 0x7c, 0xc7, 0xa3, 0x52, 0xf0, 0x15,
	0x06, 0xd9, 0x63, 0x00, 0xa3, 0x03, 0xc0, 0xfa, 0xbd, 0x78, 0x09, 0x18, 0xdf, 0xd6, 0x00, 0x6d,
	0x11, 0x97, 0x50, 0x62, 0x62, 0xaf, 0x4d, 0xce, 0xfd, 0x5a, 0x2c, 0xe5, 0x9a, 0xf9, 0xc1, 0x1b,
	0x2b, 0xcf, 0xa7, 0xce, 0x81, 0xbc, 0x02, 0x13, 0xb7, 0x7d, 0x20, 0x40, 0xbb, 0x9e, 0xdb, 0x37,
	0xbe, 0x04, 0xb3, 0x19, 0xc6, 0xce, 0x7b, 0xcb, 0xf1, 0x67, 0x1a, 0xac, 0xec, 0x85, 0x24, 0xc0,
	0x21, 0xb9, 0xe3, 0xe2, 0xa8, 0xc3, 0x22, 0x70, 0xd3, 0x97, 0x06, 0xfd, 0xfc, 0xe4, 0xb0, 0x04,
	0xe5, 0x81, 0xa4, 0xb7, 0x14, 0xc9, 0x74, 0x37, 0xb5, 0x2a, 0x17, 0xb3, 0xab, 0xb2, 0x0b, 0xd7,
	0x4f, 0x61, 0xfd, 0xbc, 0x25, 0xf5, 0x63, 0x0d, 0x96, 0xce, 0x47, 0x44, 0xa9, 0x19, 0xe5, 0xb2,
	0xd7, 0xa1, 0xa7, 0x46, 0xfd, 0x94, 0xf0, 0x0a, 0x8f, 0x15, 0x5e, 0x31, 0x2b, 0xbc, 0x4c, 0xd2,
	0x33, 0x91, 0x4d, 0x7a, 0x0c, 0x02, 0xcb, 0xcf, 0x43, 0x70, 0x5f, 0x84, 0x29, 0x13, 0x1f, 0x9f,
	0xdb, 0xd5, 0x7d, 0x0d, 0x72, 0xf6, 0x01, 0x17, 0x4e, 0xc5, 0xcc, 0xd9, 0x07, 0xc6, 0x6f, 0x68,
	0x50, 0x53, 0xfd, 0x9f, 0x33, 0xeb, 0x63, 0x5c, 0xd0, 0x1b, 0x2d, 0x40, 0x26, 0x3e, 0x3e, 0xef,
	0xad, 0xe9, 0xe0, 0xa4, 0x7d, 0x98, 0xcd, 0x8c, 0x72, 0xd1, 0x5b, 0x52, 0xe3, 0xf7, 0x35, 0xae,
	0xc5, 0xbd, 0xde, 0x39, 0x69, 0x71, 0xb4, 0x64, 0xc5, 0x34, 0x0b, 0x6a, 0x9a, 0xac, 0x5d, 0x72,
	0xb5, 0xc4, 0x7e, 0x32, 0x27, 0x38, 0xf0, 0x43, 0xcb, 0xc6, 0x91, 0x3c, 0xcf, 0x9a, 0x38, 0xf0,
	0xc3, 0x4d, 0x1c, 0xb1, 0xb4, 0x4c, 0xf1, 0x77, 0xde, 0x06, 0xfc, 0xe7, 0x5a, 0xa2, 0xd3, 0x31,
	0x05, 0x70, 0xc6, 0x8d, 0xff, 0x80, 0x9a, 0xd1, 0x9c, 0x98, 0x7f, 0x21, 0xbe, 0x65, 0x18, 0x94,
	0x41, 0x31, 0x2d, 0x03, 0x66, 0x39, 0x94, 0xba, 0xe2, 0x06, 0xa1, 0x60, 0xf2, 0xdf, 0x6c, 0x01,
	0xc9, 0xf0, 0x7e, 0xde, 0xc2, 0xe9, 0x83, 0x6e, 0xe2, 0x63, 0xb9, 0x46, 0x5d, 0x84, 0x83, 0xa7,
	0xa7, 0x5b, 0xc8, 0xa8, 0xfc, 0x97, 0x60, 0x26, 0x35, 0xf4, 0x79, 0x4f, 0xec, 0x57, 0x35, 0x98,
	0x57, 0x92, 0x1b, 0x7f, 0x7a, 0x67, 0x70, 0xe6, 0xc7, 0x4f, 0x10, 0xc3, 0xc2, 0x20, 0x07, 0xe7,
	0x3d, 0xcb, 0x1f, 0x89, 0xe8, 0xf9, 0x1c, 0x8b, 0x81, 0xd2, 0x25, 0x3f, 0x85, 0x6c, 0xc9, 0x8f,
	0x10, 0x4c, 0x31, 0x16, 0xcc, 0xd3, 0x97, 0x00, 0x19, 0x6d, 0x98, 0x8e, 0xa7, 0x33, 0xbe, 0xac,
	0xae, 0x43, 0xfe, 0xf0, 0xe8, 0xb1, 0xce, 0xca, 0x70, 0xc6, 0x37, 0x84, 0x79, 0x7c, 0x28, 0xbb,
	0xc6, 0x81, 0x30, 0x29, 0xed, 0xe4, 0x42, 0xf7, 0x89, 0x3f, 0xd1, 0x92, 0x38, 0x32, 0xae, 0xb1,
	0x7c, 0x14, 0x26, 0x42, 0xc6, 0xdd, 0xc8, 0xfb, 0x34, 0xc1, 0xb7, 0x24, 0x60, 0x99, 0x01, 0xc1,
	0x76, 0xc7, 0x4a, 0xdb, 0x4f, 0x85, 0x41, 0x76, 0xce, 0xcd, 0x86, 0x0c, 0x17, 0xe6, 0xb2, 0x33,
	0xba, 0x50, 0x7b, 0xf9, 0x15, 0x58, 0x7a, 0xc7, 0x63, 0xb9, 0xcd, 0x16, 0x89, 0x68, 0xe8, 0xf7,
	0x9f, 0xaf, 0xc9, 0xb0, 0xbd, 0xde, 0xa8, 0xe1, 0xcf, 0xdb, 0x4c, 0xbe, 0x0c, 0x97, 0x4d, 0xd2,
	0x76, 0x22, 0x4a, 0x42, 0x96, 0xbe, 0xee, 0xee, 0x47, 0x24, 0x3c, 0x22, 0xe1, 0x38, 0xf3, 0x9c,
	0x87, 0x89, 0x2e, 0x3e, 0x61, 0xfb, 0x56, 0xb1, 0x49, 0x2e, 0x76, 0xf1, 0x49, 0x33, 0x32, 0xde,
	0x80, 0x2b, 0xa3, 0x47, 0x90, 0x53, 0x89, 0xf9, 0xd2, 0xb2, 0x7b, 0xd0, 0x3a, 0xbf, 0xa0, 0xb8,
	0x20, 0xa6, 0x7a, 0xb0, 0x34, 0xa2, 0xfb, 0xd3, 0x38, 0x62, 0x26, 0xec, 0x44, 0x96, 0xed, 0x12,
	0x2c, 0xb2, 0x80, 0xb2, 0x59, 0x72, 0x22, 0x7e, 0xce, 0x7a, 0xe6, 0xe3, 0x13, 0xe3, 0x4b, 0xb0,
	0x64, 0x92, 0xae, 0x2f, 0x8e, 0x0a, 0x2e, 0x60, 0x5a, 0x1b, 0xb0, 0x3c, 0xaa, 0xff, 0x53, 0x25,
	0xfd, 0x5b, 0x1a, 0x2c, 0xee, 0x75, 0xfa, 0x91, 0x63, 0x63, 0xf7, 0x59, 0x4e, 0xc8, 0x46, 0xb3,
	0x34, 0xc6, 0xb9, 0x98, 0xf1, 0x1e, 0xd4, 0x87, 0x19, 0x3a, 0x55, 0x37, 0xb1, 0x02, 0x72, 0x4f,
	0x50, 0xc0, 0x77, 0x34, 0x40, 0x8d, 0xc0, 0x75, 0xa8, 0xc9, 0x3d, 0x63, 0xbc, 0x93, 0xc0, 0x4a,
	0xc4, 0x7a, 0x48, 0xdc, 0x59, 0x94, 0x93, 0x70, 0x20, 0x9b, 0xd4, 0x55, 0x80, 0x98, 0x40, 0x1d,
	0x9d, 0x56, 0x14, 0x36, 0x42, 0xcb, 0x50, 0x71, 0x22, 0x2b, 0xc4, 0xc7, 0xd6, 0xe1, 0x91, 0x8a,
	0x85, 0x4e, 0x64, 0xe2, 0xe3, 0xfb, 0x47, 0xc6, 0x0f, 0x34, 0x98, 0xcd, 0xb0, 0x37, 0xbe, 0xbb,
	0xbf, 0x04, 0x05, 0x97, 0x1c, 0x50, 0x79, 0x92, 0x52, 0x5b, 0x97, 0xe5, 0xde, 0xa2, 0x63, 0xce,
	0x31, 0xc7, 0xa3, 0x55, 0x28, 0x86, 0x4e, 0xbb, 0x43, 0xe5, 0x09, 0xd2, 0x28, 0x42, 0x41, 0x80,
	0x56, 0x59, 0x60, 0x6e, 0xf3, 0xdb, 0x19, 0x71, 0x54, 0x36, 0x40, 0x6b, 0x2a, 0xb4, 0xf1, 0x75,
	0x0d, 0x74, 0x93, 0xe0, 0xd6, 0xb6, 0xd7, 0x22, 0x27, 0xe3, 0xc8, 0x38, 0x9d, 0x20, 0xe7, 0xb2,
	0x09, 0x72, 0xb2, 0x26, 0xe5, 0x9f, 0xb0, 0x26, 0x19, 0xbf, 0xad, 0xc1, 0x4c, 0x8a, 0x8d, 0xf1,
	0x65, 0x79, 0x15, 0x20, 0x24, 0xb8, 0x65, 0x39, 0xac, 0x23, 0x75, 0xec, 0x15, 0xaa, 0x9e, 0x19,
	0x4b, 0xa2, 0x44, 0x6a, 0xa8, 0x74, 0x38, 0x36, 0x3f, 0x49, 0x60, 0x34, 0x60, 0xf6, 0xc1, 0x91,
	0x6d, 0xdf, 0x25, 0xf4, 0x56, 0x9f, 0xd7, 0xee, 0x9c, 0xc3, 0xfe, 0xdb, 0xf8, 0x75, 0x0d, 0xe6,
	0xb2, 0xbd, 0x9e, 0x77, 0x5a, 0x7d, 0x03, 0x0a, 0xfc, 0x7a, 0x7c, 0x70, 0x7e, 0x6c, 0x54, 0x3e,
	0x3f, 0x8e, 0x36, 0xbe, 0x0c, 0x8b, 0x31, 0x1f, 0xb2, 0xf8, 0xe1, 0x7c, 0xb5, 0xcf, 0xfc, 0xb7,
	0x3e, 0x3c, 0xc4, 0x79, 0x4f, 0x57, 0x8a, 0x38, 0x9f, 0xa4, 0x38, 0x4a, 0x00, 0x85, 0xd3, 0x05,
	0xf0, 0xf5, 0x32, 0x94, 0x36, 0x93, 0x65, 0x5f, 0x72, 0xe3, 0xb4, 0x38, 0x2b, 0x05, 0xb3, 0x2c,
	0x00, 0xdb, 0x2d, 0xf4, 0xc9, 0x84, 0xd5, 0xc0, 0xb7, 0x3b, 0xd2, 0x4b, 0x67, 0xb3, 0x0e, 0x75,
	0x9b, 0xa1, 0x62, 0x7e, 0xd9, 0x07, 0x5a, 0x81, 0x42, 0x40, 0x88, 0xaa, 0x51, 0x9f, 0x54, 0xf4,
	0x7b, 0x84, 0x84, 0x26, 0xc7, 0xf0, 0x94, 0x92, 0x84, 0x5d, 0x99, 0x82, 0xf3, 0xdf, 0xe8, 0x55,
	0x28, 0x07, 0xa1, 0xe3, 0x87, 0x0e, 0xed, 0xf3, 0x3d, 0x55, 0x6d, 0x63, 0x36, 0x25, 0xfd, 0x6e,
	0x17, 0x7b, 0xad, 0xbd, 0xd0, 0x31, 0x63, 0x22, 0xf4, 0x16, 0x4c, 0x3b, 0x91, 0xef, 0xe2, 0x54,
	0x31, 0x72, 0x69, 0xa0, 0x18, 0x79, 0x5b, 0xe1, 0x65, 0x31, 0xb2, 0x93, 0xf9, 0x46, 0x1f, 0x81,
	0x1a, 0x3f, 0x72, 0x71, 0x5c, 0xd7, 0xb2, 0xb1, 0xdd, 0x21, 0xb2, 0xd2, 0x64, 0xd2, 0xf3, 0xe9,
	0x1d, 0xc7, 0x75, 0x37, 0x19, 0x8c, 0x6b, 0xba, 0xef, 0xd9, 0x96, 0xeb, 0xb7, 0x45, 0x2d, 0xa8,
	0x59, 0x62, 0xdf, 0x3b, 0x7e, 0x1b, 0xad, 0x82, 0x1e, 0x12, 0xdb, 0x0f, 0x5b, 0xbc, 0x90, 0xd4,
	0x8a, 0x28, 0xa6, 0xb2, 0x18, 0xb4, 0x26, 0xe0, 0x4d, 0xa7, 0x4b, 0x1a, 0x14, 0xd3, 0x14, 0x65,
	0x64, 0x63, 0x4f, 0x50, 0x56, 0xd3, 0x94, 0x6c, 0x11, 0xe1, 0x94, 0xd7, 0x99, 0xd4, 0x03, 0xd7,
	0xb1, 0xb1, 0xc5, 0xbc, 0x57, 0x56, 0x84, 0x56, 0x25, 0x8c, 0x85, 0x0a, 0x74, 0x03, 0x6a, 0xa2,
	0x16, 0x86, 0xb4, 0x2c, 0xb1, 0xa4, 0x4c, 0xf1, 0xdc, 0x7c, 0x4a, 0x41, 0x79, 0xa1, 0x04, 0xfa,
	0x0c, 0x2c, 0xb1, 0xc5, 0x8e, 0x9c, 0x10, 0xbb, 0xc7, 0x85, 0xd4, 0xea, 0x85, 0x42, 0x5a, 0x5d,
	0x55, 0xdd, 0xbd, 0xd0, 0xc5, 0x27, 0xb7, 0x15, 0x7e, 0x4b, 0xa2, 0x1f, 0xf0, 0x02, 0x0d, 0x1c,
	0x04, 0xae, 0x43, 0x54, 0x3c, 0x99, 0x16, 0xf7, 0x17, 0x12, 0x28, 0x42, 0xca, 0x22, 0x94, 0x28,
	0x8e, 0x0e, 0x99, 0xe9, 0xe8, 0xa2, 0xe6, 0x88, 0x7d, 0x6e, 0xb7, 0xf8, 0xe2, 0x42, 0xb1, 0x4b,
	0xc4, 0x04, 0x66, 0x44, 0x31, 0x27, 0x87, 0x70, 0xf6, 0x3f, 0x0e, 0x88, 0x31, 0xda, 0x0b, 0x6d,
	0x62, 0xb5, 0x43, 0xbf, 0x17, 0x58, 0x14, 0xb7, 0xeb, 0x88, 0x1b, 0xb2, 0xae, 0x30, 0x77, 0x19,
	0xa2, 0x89, 0xdb, 0xe8, 0xd3, 0x30, 0xd5, 0x72, 0xa2, 0x43, 0xeb, 0xa0, 0xe7, 0xba, 0x96, 0x1f,
	0xd0, 0xfa, 0x2c, 0x57, 0xf2, 0x5c, 0xac, 0xe4, 0x2d, 0x27, 0x3a, 0xbc, 0xd3, 0x73, 0xdd, 0xdd,
	0x80, 0x9a, 0xd5, 0x56, 0xf2, 0xc1, 0x64, 0xce, 0x16, 0x31, 0x42, 0xc3, 0xbe, 0x15, 0x0a, 0x17,
	0xaf, 0xcf, 0x09, 0x99, 0x3b, 0x91, 0xc9, 0xc0, 0xca, 0xf1, 0xdf, 0x80, 0x2a, 0x0e, 0x9c, 0xf8,
	0x1a, 0x66, 0x7e, 0xc0, 0xfc, 0x6e, 0xee, 0x6d, 0xab, 0x73, 0x4c, 0xc0, 0x81, 0x93, 0x54, 0xef,
	0x4c, 0x8b, 0x53, 0x4f, 0x1a, 0xeb, 0x61, 0x81, 0xeb, 0xa1, 0x16, 0x83, 0x85, 0x22, 0x7e, 0x0e,
	0xc4, 0xa3, 0x23, 0x4b, 0x45, 0x97, 0x45, 0xee, 0x19, 0xf3, 0xeb, 0xea, 0x29, 0x52, 0x93, 0xfd,
	0x55, 0x21, 0x66, 0x92, 0xa6, 0xbe, 0x84, 0xae, 0x39, 0x97, 0x96, 0x10, 0x4c, 0xbd, 0xce, 0xa3,
	0xc0, 0x94, 0x84, 0x36, 0x38, 0x90, 0x89, 0x9c, 0x3f, 0x45, 0x10, 0x24, 0x4b, 0x22, 0xfa, 0xd3,
	0x13, 0x4f, 0xa0, 0xdf, 0x2e, 0x94, 0x0b, 0x7a, 0x91, 0x19, 0x11, 0x6e, 0x59, 0xef, 0xf7, 0xfc,
	0xb0, 0xd7, 0x35, 0xfe, 0x29, 0x07, 0x65, 0x15, 0xfa, 0x87, 0xaa, 0xfc, 0xb4, 0xe1, 0x2a, 0xbf,
	0xeb, 0x30, 0xc9, 0x4b, 0x90, 0xb2, 0x87, 0xcc, 0x55, 0x06, 0x53, 0x02, 0x19, 0x0e, 0x49, 0xe9,
	0x12, 0xa9, 0x42, 0xb6, 0x44, 0x2a, 0xfd, 0x78, 0xa2, 0x98, 0x7d, 0x3c, 0xb1, 0x2a, 0xab, 0x9d,
	0x78, 0x85, 0xb1, 0x88, 0x05, 0xd5, 0x58, 0x19, 0xbb, 0x81, 0xa8, 0x73, 0x6a, 0xf6, 0x03, 0x82,
	0x3e, 0x06, 0x88, 0x53, 0x66, 0x8b, 0x3b, 0x4b, 0xbc, 0xbb, 0x69, 0x86, 0xb9, 0x93, 0x2a, 0xf0,
	0x1c, 0xf5, 0x96, 0xa2, 0x3c, 0xf2, 0x2d, 0xc5, 0x50, 0xf1, 0x76, 0x65, 0xb8, 0x78, 0x7b, 0xe0,
	0xbd, 0x05, 0x0c, 0xbd, 0xb7, 0x30, 0xbe, 0x5d, 0x80, 0xb2, 0xba, 0x13, 0x4a, 0xad, 0xbf, 0xda,
	0x13, 0xd6, 0x5f, 0x74, 0x85, 0x05, 0x65, 0x1a, 0xf6, 0xf1, 0xbe, 0x4b, 0x64, 0xcc, 0x4f, 0x00,
	0x6c, 0x35, 0xc0, 0xfb, 0x7e, 0x48, 0xe5, 0x51, 0x8f, 0xf8, 0x40, 0x1b, 0x50, 0x56, 0x45, 0xd1,
	0x43, 0x97, 0x9d, 0xef, 0x86, 0x0e, 0x25, 0xaa, 0x2a, 0xda, 0x8c, 0xe9, 0x98, 0x59, 0x62, 0x97,
	0x99, 0x44, 0x5f, 0xd6, 0xf2, 0x15, 0xa5, 0x59, 0xc6, 0x76, 0x2f, 0xb0, 0xbc, 0x9c, 0xcf, 0x9c,
	0xc4, 0xa9, 0x2f, 0xf4, 0x0a, 0x94, 0xd5, 0xbb, 0xba, 0xa1, 0x7a, 0xb4, 0x2d, 0x89, 0x30, 0x63,
	0x12, 0xb4, 0x05, 0x33, 0xb1, 0x30, 0x2d, 0x72, 0x12, 0x38, 0x21, 0x69, 0xc9, 0x8a, 0xb4, 0x7a,
	0x26, 0xca, 0x33, 0xd1, 0xde, 0x16, 0x78, 0x73, 0xda, 0xce, 0x02, 0x58, 0x28, 0x60, 0x26, 0x93,
	0x1c, 0x93, 0x97, 0x79, 0x0f, 0x73, 0xe9, 0xdb, 0xd0, 0x87, 0xf2, 0xc8, 0xdc, 0xac, 0xd2, 0xe4,
	0x03, 0xdd, 0x83, 0xd9, 0x64, 0x7c, 0xea, 0xfb, 0x96, 0x8b, 0xc3, 0xb6, 0x28, 0xed, 0xaf, 0x6e,
	0x2c, 0x0d, 0x71, 0xd0, 0xf4, 0xfd, 0x1d, 0x46, 0x60, 0xea, 0xf6, 0x00, 0x04, 0x6d, 0x82, 0x9e,
	0x3c, 0x81, 0x39, 0xc0, 0x8e, 0x4b, 0x5a, 0x3c, 0xe4, 0xa7, 0x27, 0x12, 0xbf, 0x81, 0xb9, 0xc3,
	0xf1, 0x66, 0xf2, 0x68, 0x46, 0x00, 0x8c, 0xbf, 0xcb, 0xc1, 0x54, 0x46, 0x2b, 0x99, 0xed, 0x84,
	0x96, 0xdd, 0x4c, 0x5e, 0x83, 0x6a, 0xba, 0xde, 0x5d, 0xde, 0xea, 0xdb, 0x49, 0x95, 0xfb, 0xb0,
	0xdb, 0xd5, 0xa1, 0x24, 0x5d, 0x57, 0x5e, 0xea, 0xa8, 0x4f, 0x16, 0x7b, 0xe3, 0xce, 0x12, 0xf3,
	0x16, 0xfe, 0xa7, 0x2b, 0x4c, 0x6c, 0xe3, 0x6f, 0xc2, 0x44, 0x48, 0x70, 0xe4, 0x7b, 0xd2, 0x0b,
	0xaf, 0x8e, 0xb6, 0xa9, 0x75, 0x93, 0x13, 0x99, 0x92, 0xd8, 0x38, 0x86, 0x09, 0x01, 0x41, 0x55,
	0x28, 0xbd, 0xe3, 0x1d, 0x7a, 0xfe, 0xb1, 0xa7, 0x5f, 0x42, 0x35, 0x80, 0xdd, 0x80, 0xca, 0xc2,
	0x4d, 0x5d, 0x43, 0x73, 0xa0, 0xa7, 0x6b, 0xab, 0x99, 0x85, 0xeb, 0x39, 0x84, 0xa0, 0xd6, 0x20,
	0xee, 0x81, 0xe9, 0xbb, 0x2e, 0x69, 0xdd, 0xc2, 0xf6, 0xa1, 0x9e, 0x47, 0x53, 0x50, 0x31, 0x6d,
	0x51, 0xe1, 0x19, 0xe9, 0x05, 0xb4, 0x08, 0xb3, 0x3b, 0xf8, 0x2b, 0xfd, 0x77, 0x3c, 0xe7, 0xfd,
	0x1e, 0xf1, 0x48, 0x14, 0x71, 0x94, 0x5e, 0x34, 0x56, 0x60, 0x32, 0x6d, 0xb3, 0x4a, 0x32, 0x5a,
	0xb2, 0x0d, 0xfd, 0x03, 0x0d, 0xca, 0xca, 0x3e, 0xd3, 0x45, 0xb3, 0x5a, 0xa6, 0x68, 0x56, 0x85,
	0xad, 0x64, 0x0f, 0xcb, 0x09, 0x59, 0xe2, 0xb4, 0x06, 0x33, 0xca, 0xaa, 0x19, 0xda, 0xea, 0xe0,
	0xa8, 0x23, 0xef, 0xed, 0xa7, 0x15, 0xe2, 0x3e, 0xe9, 0xdf, 0xc3, 0x51, 0x07, 0xbd, 0x09, 0xc0,
	0x5f, 0x99, 0xd8, 0x1d, 0xec, 0x78, 0x32, 0x1f, 0x59, 0x58, 0x8f, 0xdf, 0xa3, 0xbe, 0x8b, 0x1d,
	0x7a, 0xc7, 0x0f, 0x6f, 0x7b, 0x6c, 0x25, 0xaa, 0x30, 0xca, 0x4d, 0x46, 0x68, 0x7c, 0x53, 0x83,
	0xe9, 0x01, 0x5f, 0x38, 0xcd, 0x3e, 0xd6, 0x61, 0x16, 0x53, 0x4a, 0xba, 0x01, 0x5b, 0x86, 0x12,
	0x9d, 0x0a, 0x3b, 0x99, 0x89, 0x51, 0xb1, 0x52, 0x87, 0xcd, 0x65, 0x28, 0xdc, 0x15, 0x86, 0xc2,
	0x9d, 0xb1, 0x0d, 0xd5, 0x94, 0x77, 0x3d, 0xc1, 0x5e, 0x4f, 0xad, 0x55, 0x36, 0x5e, 0x05, 0x7d,
	0xd0, 0xd1, 0xb2, 0x57, 0x8a, 0xda, 0xc0, 0x95, 0xe2, 0x5f, 0x6b, 0x30, 0x3d, 0xe0, 0x53, 0xa7,
	0x31, 0x30, 0x7c, 0xf8, 0xff, 0x09, 0xa8, 0xc4, 0x2e, 0xc8, 0x27, 0x5e, 0xdb, 0x40, 0xc3, 0xde,
	0x6a, 0x26, 0x44, 0x4c, 0xcd, 0x3c, 0x26, 0x3a, 0x5e, 0x7b, 0xb0, 0x70, 0x7a, 0x5a, 0x21, 0x54,
	0xe9, 0xf4, 0xc7, 0x01, 0xc5, 0xb4, 0x43, 0x3e, 0xa5, 0x30, 0xb1, 0x20, 0xff, 0x46, 0x03, 0x60,
	0xdb, 0x42, 0x51, 0xe9, 0x80, 0x3e, 0x0a, 0x33, 0xdc, 0x46, 0x8e, 0xb1, 0xeb, 0x8a, 0x5d, 0x64,
	0x57, 0x4d, 0xa8, 0xc6, 0x10, 0xef, 0x62, 0xd7, 0x65, 0xe4, 0x0f, 0x22, 0xf4, 0x2a, 0xcc, 0x05,
	0xa1, 0x6f, 0x93, 0x28, 0xca, 0x52, 0x4b, 0x4d, 0x4b, 0x5c, 0xaa, 0xc1, 0x3a, 0xcc, 0x1d, 0x1e,
	0xf1, 0x4d, 0x58, 0xb6, 0x81, 0x30, 0x57, 0xfd, 0xf0, 0x88, 0x6d, 0xc7, 0x52, 0xf4, 0x1b, 0xb0,
	0x40, 0x7d, 0x8a, 0x5d, 0x2b, 0x0c, 0xec, 0x54, 0x0b, 0x4f, 0xcd, 0x1c, 0x71, 0xac, 0x19, 0xd8,
	0xaa, 0xcd, 0xc3, 0xc8, 0xf8, 0x22, 0x94, 0xd9, 0xd6, 0x95, 0xef, 0x22, 0xe6, 0xa0, 0xc8, 0x29,
	0x38, 0xff, 0x79, 0x53, 0x7c, 0xb0, 0xe5, 0x4c, 0xb2, 0x46, 0x5a, 0x9c, 0xd7, 0xbc, 0x99, 0x00,
	0xe2, 0xb4, 0x75, 0xbf, 0x4f, 0x89, 0xe0, 0x2c, 0x2f, 0xd2, 0xd6, 0x5b, 0x0c, 0x60, 0x7c, 0x4d,
	0x03, 0x60, 0xfd, 0x4b, 0x69, 0xbd, 0x0c, 0x45, 0xfe, 0xac, 0x6f, 0x68, 0x11, 0x55, 0x3c, 0x98,
	0x02, 0xcf, 0x72, 0xa1, 0xf8, 0xb9, 0xc2, 0x48, 0x3a, 0x8e, 0x66, 0x64, 0x2d, 0x4c, 0xf1, 0x50,
	0xce, 0x98, 0x90, 0x31, 0xb4, 0xf1, 0x9f, 0x45, 0xf1, 0xc2, 0x57, 0x70, 0xf1, 0x68, 0x03, 0xbd,
	0x02, 0x28, 0x9e, 0x82, 0xda, 0x11, 0x29, 0xb5, 0xcd, 0xc4, 0x18, 0xb9, 0x2f, 0x8a, 0xd0, 0x27,
	0x61, 0x71, 0x98, 0x3c, 0xfd, 0x6e, 0x74, 0x7e, 0xa8, 0x0d, 0xdf, 0x08, 0xdd, 0x80, 0x9a, 0x50,
	0x48, 0x3c, 0x84, 0x2c, 0x1e, 0xe5, 0xd0, 0xb8, 0xfb, 0x2f, 0xc0, 0x95, 0x90, 0x6d, 0x34, 0x5b,
	0xfb, 0x56, 0x8b, 0x1f, 0xd7, 0x5b, 0xd1, 0xa1, 0x13, 0x04, 0x3c, 0x1c, 0xf4, 0x3c, 0x2a, 0xf5,
	0xbd, 0x24, 0x69, 0xc4, 0x89, 0x7e, 0x43, 0x50, 0x6c, 0x32, 0x02, 0x96, 0x29, 0xa8, 0x0e, 0x58,
	0x4c, 0xcb, 0xb6, 0x16, 0xba, 0x5f, 0x90, 0x04, 0xf7, 0x49, 0x3f, 0xd3, 0xf4, 0x2d, 0xb8, 0xaa,
	0x9a, 0xee, 0xf3, 0xa0, 0xc8, 0x13, 0x29, 0xab, 0xc3, 0xc2, 0x1e, 0x6f, 0x5e, 0xcc, 0x0c, 0x7e,
	0x8b, 0xd1, 0xf0, 0xbc, 0xea, 0x9e, 0x43, 0x45, 0x0f, 0x9f, 0x82, 0x7a, 0xb6, 0x07, 0x6e, 0x0f,
	0xa2, 0xb1, 0x28, 0x2e, 0x98, 0x4f, 0x37, 0x66, 0x36, 0x2b, 0x1a, 0xbe, 0x09, 0x8b, 0x23, 0x1a,
	0x32, 0x43, 0x92, 0x3b, 0xc0, 0xb9, 0xc1, 0x76, 0xcc, 0xa6, 0x1e, 0x33, 0x9e, 0x87, 0x3d, 0x5f,
	0xed, 0xf3, 0x86, 0xc6, 0x7b, 0xc8, 0x90, 0xcc, 0xcf, 0xdb, 0x84, 0x5a, 0x91, 0x87, 0x83, 0xa8,
	0xe3, 0x53, 0xd9, 0x44, 0x3c, 0xda, 0xd5, 0xdb, 0x84, 0x36, 0x24, 0x42, 0x50, 0x33, 0xc1, 0xc4,
	0xe7, 0x31, 0x56, 0x10, 0xfa, 0x81, 0x1f, 0x11, 0x8b, 0xfb, 0xba, 0x68, 0x58, 0x95, 0x82, 0x51,
	0x47, 0x34, 0x7b, 0x82, 0x84, 0xad, 0x0a, 0xa3, 0x7a, 0x60, 0x8b, 0xb3, 0x13, 0x76, 0xd3, 0x3d,
	0x4c, 0x0e, 0xf4, 0xb0, 0x29, 0x48, 0x86, 0x7b, 0x08, 0x7c, 0xdf, 0xb5, 0x22, 0xbb, 0x43, 0x5a,
	0x3d, 0x37, 0xc3, 0xc3, 0x54, 0xd2, 0xc3, 0x9e, 0xef, 0xbb, 0x0d, 0x49, 0x12, 0xf7, 0x60, 0xfc,
	0x9a, 0x06, 0xd5, 0x54, 0x99, 0x16, 0xcb, 0x94, 0x78, 0x4c, 0x10, 0x55, 0x5d, 0xd2, 0x0d, 0x93,
	0x4c, 0x29, 0x09, 0x6c, 0x26, 0xd0, 0x24, 0xc8, 0xbd, 0x01, 0x55, 0x9e, 0xf6, 0xca, 0x56, 0xb9,
	0x81, 0x56, 0x89, 0x6b, 0x99, 0x10, 0xc5, 0xbf, 0x45, 0x1d, 0xa9, 0x48, 0x5d, 0x8c, 0xef, 0x6b,
	0x30, 0x95, 0x29, 0x17, 0x1b, 0x93, 0x93, 0xcf, 0x42, 0x2d, 0xc5, 0x89, 0x75, 0xb4, 0x21, 0x99,
	0x99, 0x1f, 0xc1, 0xcc, 0xa3, 0x0d, 0x73, 0x32, 0x4a, 0x7b, 0xfd, 0xa7, 0x60, 0x92, 0x47, 0x17,
	0x35, 0x66, 0x7e, 0x60, 0xfb, 0xc9, 0x37, 0x45, 0x72, 0xd0, 0xea, 0x71, 0xf2, 0x61, 0x7c, 0xb5,
	0x04, 0xd5, 0x14, 0x12, 0xbd, 0x0e, 0x0b, 0x11, 0xf5, 0x43, 0x62, 0xed, 0x63, 0x6a, 0x77, 0xd2,
	0x0a, 0x11, 0x21, 0x64, 0x96, 0x63, 0xf9, 0x25, 0x52, 0xa2, 0xcc, 0x37, 0x79, 0x10, 0xe1, 0x56,
	0x14, 0x11, 0xaf, 0x95, 0x6e, 0x25, 0xa2, 0xc2, 0x9c, 0x44, 0x37, 0x88, 0xd7, 0x4a, 0x9a, 0xad,
	0xc1, 0x4c, 0xc0, 0x02, 0x05, 0x7f, 0x0d, 0xdb, 0x96, 0x0d, 0xe4, 0x86, 0x45, 0x22, 0x76, 0xfc,
	0xb6, 0xa0, 0xdd, 0x84, 0x6b, 0x21, 0x3e, 0xa0, 0x56, 0x6b, 0xdf, 0x12, 0x13, 0x75, 0x09, 0x6e,
	0x91, 0x30, 0x3d, 0x94, 0x88, 0x06, 0xcb, 0x8c, 0x6c, 0x6b, 0x9f, 0xcf, 0x69, 0x87, 0xd3, 0x24,
	0x03, 0x6e, 0xc0, 0x82, 0xea, 0x44, 0x9d, 0x9b, 0xc8, 0xb6, 0x22, 0x14, 0x20, 0xd1, 0xb6, 0x21,
	0xce, 0x50, 0x44, 0x9b, 0xcf, 0xc3, 0x95, 0xec, 0xc0, 0x5d, 0xd2, 0xa5, 0x2c, 0xdd, 0x91, 0x2d,
	0x45, 0x1c, 0xa8, 0xa7, 0x46, 0x7d, 0x20, 0x09, 0x44, 0xfb, 0x55, 0x90, 0x3b, 0xf5, 0xd4, 0x68,
	0x22, 0x06, 0xc8, 0x5c, 0x3c, 0x1e, 0xe9, 0x75, 0x58, 0xc0, 0x41, 0xe0, 0xf6, 0x87, 0x45, 0x2f,
	0x22, 0xf1, 0x2c, 0xc7, 0x0e, 0x88, 0xfe, 0x25, 0x98, 0x16, 0x8d, 0x92, 0xde, 0x2b, 0xf2, 0xf1,
	0x1a, 0x03, 0x0f, 0x77, 0xde, 0xed, 0x51, 0x72, 0x22, 0x5e, 0xba, 0xa5, 0xa3, 0x84, 0xe8, 0xfc,
	0x01, 0x43, 0xb2, 0xac, 0x2f, 0x76, 0x52, 0xd1, 0xe8, 0x71, 0x22, 0x97, 0x81, 0x82, 0x13, 0x8d,
	0x94, 0xf8, 0x6b, 0x30, 0x9f, 0xee, 0xe1, 0x18, 0xbb, 0x99, 0x00, 0x81, 0x92, 0x96, 0xef, 0x62,
	0x57, 0x34, 0xf9, 0x2c, 0x2c, 0xa7, 0x9b, 0x0c, 0x88, 0x5b, 0x84, 0x85, 0xc5, 0xa4, 0xdd, 0x90,
	0xb4, 0xdd, 0x41, 0xe9, 0x89, 0xf3, 0xa4, 0x9a, 0x9b, 0x15, 0xdc, 0x8b, 0x30, 0xa5, 0xb6, 0x2c,
	0x82, 0x4c, 0x9e, 0x23, 0x49, 0xa0, 0x20, 0x62, 0xab, 0x5c, 0x27, 0xf4, 0x29, 0x8d, 0xc7, 0xd7,
	0xe5, 0x2a, 0x27, 0xa1, 0x82, 0xec, 0xe7, 0xe1, 0xf2, 0xe0, 0xcb, 0xb0, 0x34, 0x03, 0x33, 0xc2,
	0x44, 0x82, 0xc1, 0xb7, 0xcd, 0x2a, 0x92, 0xbd, 0x07, 0x13, 0xe2, 0xe6, 0x34, 0x29, 0xe0, 0xd4,
	0x9e, 0x50, 0xc2, 0x7a, 0xc6, 0x02, 0x23, 0xe3, 0xab, 0x1a, 0x94, 0xd5, 0xdb, 0x0f, 0x74, 0x19,
	0x72, 0x7e, 0x20, 0xdf, 0x45, 0x67, 0x4e, 0x2d, 0x72, 0x7e, 0x70, 0xe6, 0x92, 0xa5, 0xcc, 0x86,
	0xb5, 0x70, 0x86, 0x0d, 0xab, 0xf1, 0xd3, 0x1c, 0x54, 0x1e, 0x1c, 0xd9, 0x36, 0x57, 0x17, 0xba,
	0x96, 0x79, 0x9e, 0x9d, 0x61, 0x43, 0x3c, 0xc2, 0x3e, 0xe5, 0xf2, 0xe2, 0xf2, 0xd0, 0x53, 0xe4,
	0xd4, 0x93, 0xa6, 0x6b, 0x50, 0x8d, 0x3a, 0x7e, 0x48, 0xad, 0xd4, 0x63, 0x64, 0x13, 0x38, 0x88,
	0x3f, 0x7c, 0x67, 0x5b, 0x9d, 0x0e, 0x8e, 0x2c, 0xff, 0x88, 0x84, 0x2e, 0xe6, 0xbb, 0x08, 0xf5,
	0x34, 0x50, 0x96, 0x15, 0xcd, 0x77, 0x70, 0xb4, 0x1b, 0x63, 0x55, 0x7d, 0x3e, 0x5a, 0x81, 0x49,
	0xd6, 0xae, 0x6d, 0x5b, 0x07, 0xfc, 0x09, 0xb8, 0xb8, 0x56, 0x87, 0x0e, 0x8e, 0xee, 0xda, 0x77,
	0xf8, 0x1b, 0xf0, 0x25, 0x28, 0xc7, 0x58, 0xe1, 0xdb, 0xa5, 0xb6, 0x44, 0x7d, 0x04, 0x6a, 0x2e,
	0x8e, 0x78, 0xa2, 0xe5, 0xb5, 0xf9, 0x11, 0x90, 0x70, 0xe6, 0x49, 0x06, 0xdd, 0xe4, 0x40, 0x9e,
	0xcd, 0x2e, 0xc6, 0x7b, 0x2f, 0xea, 0x5b, 0xa9, 0x16, 0xd2, 0x9b, 0xe7, 0x14, 0xba, 0xe9, 0xef,
	0xc4, 0x0d, 0x8d, 0xcf, 0x09, 0xc1, 0x8a, 0xe9, 0x9d, 0x92, 0x76, 0x8c, 0x7c, 0xd7, 0x6e, 0x7c,
	0x27, 0x0f, 0x65, 0xd6, 0x9c, 0x9f, 0xa1, 0x3d, 0x8b, 0x5a, 0x52, 0x39, 0x7d, 0x3e, 0x9b, 0xd3,
	0x3f, 0x51, 0x27, 0xc3, 0x05, 0x6f, 0x67, 0xf9, 0x3f, 0x0a, 0xe9, 0x03, 0xba, 0xd2, 0xe0, 0x01,
	0xdd, 0x59, 0x4f, 0xd2, 0x06, 0x4e, 0xc9, 0x2a, 0xc3, 0xff, 0x95, 0xe4, 0x1a, 0x54, 0xe3, 0x97,
	0xa5, 0x54, 0x9c, 0xa3, 0x15, 0x4c, 0x50, 0xa0, 0x66, 0x34, 0x42, 0xb9, 0xd5, 0xa7, 0x53, 0xee,
	0xe4, 0x29, 0xca, 0xfd, 0x86, 0x26, 0xd4, 0xc3, 0xf3, 0x17, 0x95, 0x34, 0x68, 0x23, 0x2e, 0x50,
	0xf8, 0x05, 0xaf, 0x48, 0x1a, 0xd6, 0x60, 0x82, 0x47, 0x4d, 0x75, 0x93, 0x8b, 0x32, 0x84, 0xdc,
	0x01, 0x4d, 0x49, 0xc1, 0x68, 0xe5, 0xe3, 0xfc, 0xfc, 0x08, 0x5a, 0xae, 0x1e, 0xf5, 0x60, 0xdf,
	0x78, 0x1d, 0x4a, 0xb2, 0x9c, 0x9f, 0x6b, 0xec, 0xc4, 0x93, 0x16, 0xc6, 0x7e, 0xa2, 0x05, 0x98,
	0x88, 0xf8, 0xd3, 0x56, 0x69, 0x17, 0xf2, 0xcb, 0x78, 0x8b, 0x9f, 0x31, 0xf2, 0x3b, 0xc5, 0xec,
	0x35, 0xb6, 0xf6, 0xf8, 0x22, 0x8e, 0x5c, 0xa6, 0x88, 0xe3, 0x2f, 0x35, 0x00, 0xb1, 0xa2, 0xf0,
	0xa1, 0x4f, 0xbd, 0x12, 0x5a, 0x84, 0x52, 0x40, 0x48, 0xc8, 0x50, 0x92, 0x0d, 0xf6, 0xb9, 0xdd,
	0x8a, 0x6f, 0x74, 0xf2, 0xa9, 0x1b, 0x9d, 0xc1, 0xfb, 0xa3, 0xc2, 0x19, 0xef, 0x8f, 0x5e, 0x93,
	0x29, 0x21, 0x9b, 0x21, 0x91, 0x87, 0x92, 0x89, 0xdc, 0xd8, 0x7e, 0xbc, 0xc1, 0x30, 0x22, 0x4d,
	0xe4, 0x3f, 0x8d, 0x6d, 0xa8, 0xc4, 0xf0, 0xe1, 0xcb, 0x0b, 0x6d, 0xf4, 0xe5, 0x05, 0x7f, 0x25,
	0x40, 0x13, 0x81, 0xe2, 0x03, 0xd2, 0x8c, 0x8c, 0x06, 0x20, 0x51, 0x75, 0xc1, 0x45, 0xa2, 0x6e,
	0x08, 0x5e, 0x49, 0xee, 0x95, 0xc5, 0xab, 0xbf, 0x64, 0xa7, 0x99, 0xc8, 0x2e, 0xbe, 0x5c, 0x46,
	0x35, 0xc8, 0xc5, 0x1d, 0xe7, 0x68, 0x64, 0x7c, 0x01, 0x66, 0x33, 0x9d, 0xca, 0xcb, 0xc0, 0x7a,
	0xb6, 0xd7, 0xc2, 0xe3, 0x3b, 0xd8, 0x02, 0xd4, 0x60, 0x7b, 0xc2, 0x06, 0x63, 0xb2, 0xa1, 0xb8,
	0x5a, 0x87, 0x0a, 0xcb, 0xd7, 0xf8, 0x55, 0xf2, 0xa8, 0xd5, 0x4c, 0x5c, 0x35, 0x97, 0x0f, 0xe5,
	0x2f, 0x63, 0x1d, 0x66, 0x33, 0xbd, 0x48, 0x36, 0x52, 0xb2, 0xd0, 0x32, 0xb2, 0xb0, 0x79, 0x79,
	0xd6, 0x5d, 0xc2, 0x0c, 0xa8, 0xd9, 0xdc, 0xb9, 0x98, 0x52, 0xeb, 0xdf, 0xd4, 0x78, 0xc9, 0x54,
	0x6a, 0x94, 0x0b, 0xb8, 0x2a, 0x4d, 0xde, 0x68, 0xf3, 0xf8, 0x77, 0x6a, 0xb1, 0xf5, 0x3f, 0x88,
	0xaa, 0xe4, 0xcd, 0x9b, 0x8d, 0x8b, 0xac, 0x4a, 0xfe, 0x38, 0xa0, 0x20, 0x24, 0x47, 0x8e, 0xdf,
	0x8b, 0x52, 0xcf, 0xe9, 0x05, 0x2f, 0xba, 0xc2, 0xc4, 0x8f, 0xe9, 0x6f, 0x40, 0x2d, 0xa6, 0x16,
	0x9d, 0x89, 0xd7, 0x58, 0x53, 0x0a, 0xfa, 0x28, 0x55, 0xea, 0x3c, 0x31, 0x58, 0xea, 0x5c, 0x8a,
	0x67, 0x6e, 0xfc, 0x50, 0x94, 0x66, 0xf2, 0xc9, 0x9d, 0xb7, 0x9c, 0xeb, 0x50, 0x8a, 0x7a, 0xb6,
	0x4d, 0x64, 0x91, 0x41, 0xd9, 0x54, 0x9f, 0x17, 0x32, 0x59, 0x63, 0x0b, 0x16, 0xee, 0x12, 0xaa,
	0x76, 0x79, 0xdc, 0x01, 0x9f, 0x5e, 0x5f, 0xc6, 0xb7, 0x34, 0x58, 0x1c, 0xea, 0xe6, 0xbc, 0x25,
	0xf3, 0x09, 0x16, 0x7c, 0x29, 0x5f, 0x02, 0xf3, 0xa7, 0x1e, 0x03, 0x2b, 0x32, 0xe3, 0x2e, 0x2c,
	0xa5, 0xb8, 0xba, 0xe7, 0xb0, 0x8c, 0x70, 0x9c, 0x52, 0x0c, 0xe3, 0xdb, 0x1a, 0x2c, 0x8f, 0xea,
	0xe9, 0xc3, 0x9f, 0xe2, 0x5f, 0x89, 0x62, 0xd7, 0x4d, 0x5f, 0x66, 0x03, 0x7e, 0x38, 0x66, 0xe5,
	0xa2, 0xed, 0x07, 0xa1, 0xe5, 0xe1, 0xae, 0xba, 0x2d, 0x2b, 0x33, 0xc0, 0x43, 0xdc, 0x25, 0x22,
	0x2f, 0x0c, 0x42, 0x75, 0x7e, 0x66, 0x85, 0xe4, 0x7d, 0x19, 0x79, 0x6a, 0x0c, 0x9e, 0x3c, 0xb7,
	0x49, 0x95, 0xec, 0x14, 0x9e, 0x54, 0x46, 0x8a, 0xe4, 0xa1, 0xa1, 0x30, 0x4a, 0x71, 0x42, 0xd8,
	0xe3, 0xc5, 0xb2, 0x99, 0xa9, 0x9c, 0xb7, 0x80, 0x51, 0xea, 0xac, 0x52, 0x0d, 0xfb, 0x5d, 0xf1,
	0x88, 0x80, 0xaf, 0x2d, 0x51, 0xaf, 0x3b, 0x8e, 0xfc, 0x3e, 0x0d, 0x15, 0xec, 0xb6, 0xfd, 0xd0,
	0xa1, 0x9d, 0x2e, 0x1f, 0xb0, 0xb6, 0xb1, 0x9c, 0x50, 0xcb, 0x8e, 0x6f, 0x2a, 0x0a, 0x33, 0x21,
	0x7e, 0x9a, 0x2a, 0xa7, 0x3f, 0x15, 0x85, 0xbe, 0x09, 0x9f, 0xe7, 0x2d, 0x9c, 0x65, 0x28, 0xdb,
	0xb2, 0xf3, 0x38, 0x67, 0x91, 0xdf, 0xcc, 0x42, 0xc4, 0x29, 0xea, 0xe1, 0x51, 0xfc, 0x3f, 0x1a,
	0x38, 0xe0, 0xfe, 0x11, 0xdf, 0x7e, 0x0a, 0xa4, 0x38, 0x80, 0x16, 0x7b, 0x64, 0xe0, 0x20, 0x71,
	0x02, 0xfd, 0xbd, 0x3c, 0x4c, 0x6e, 0xfa, 0xdd, 0x00, 0xdb, 0x54, 0x30, 0xf0, 0x1e, 0xcc, 0x93,
	0x30, 0xb4, 0x1c, 0xef, 0x08, 0xbb, 0x4e, 0xcb, 0xca, 0xee, 0xb8, 0xaa, 0x1b, 0x1f, 0x49, 0xdf,
	0x26, 0xc6, 0xad, 0xb6, 0x05, 0x75, 0x43, 0xee, 0xc6, 0xee, 0x5d, 0x32, 0x11, 0x09, 0x07, 0xa1,
	0xc8, 0x85, 0x2b, 0xac, 0xeb, 0x40, 0x16, 0x16, 0x5a, 0x32, 0x27, 0x8f, 0x03, 0xa6, 0x38, 0xab,
	0x5a, 0x1b, 0x39, 0x82, 0xaa, 0x46, 0x6c, 0xf2, 0x3c, 0x5d, 0x86, 0xd2, 0x7b, 0x97, 0xcc, 0x3a,
	0x09, 0x47, 0xe3, 0x90, 0x05, 0x8b, 0x6c, 0x34, 0x5b, 0x74, 0x62, 0x39, 0x9e, 0x15, 0x84, 0x7e,
	0x3b, 0x24, 0x51, 0x24, 0x4f, 0xb6, 0x5e, 0x1a, 0x39, 0x90, 0xfc, 0xbd, 0xed, 0xed, 0x49, 0xea,
	0x7b, 0x97, 0xcc, 0x39, 0x12, 0x0e, 0xc3, 0xd1, 0x01, 0x2c, 0xb3, 0x01, 0xa8, 0xef, 0x5b, 0x5d,
	0xec, 0xf5, 0xad, 0x80, 0x78, 0x2d, 0xc7, 0x6b, 0x5b, 0x14, 0x47, 0x87, 0x91, 0xdc, 0x0e, 0xae,
	0x8e, 0x1c, 0xa3, 0xe9, 0xfb, 0x0f, 0xb0, 0xd7, 0xdf, 0x13, 0x0d, 0x9a, 0x8c, 0xfe, 0xde, 0x25,
	0x73, 0x81, 0x84, 0xa3, 0x30, 0xb7, 0x4a, 0xd2, 0x24, 0x8c, 0xab, 0x70, 0xf9, 0x14, 0xa1, 0x1b,
	0x2f, 0xc2, 0xf5, 0x27, 0x4a, 0xcc, 0xb8, 0x06, 0x57, 0x4f, 0x9d, 0xad, 0x71, 0x1d, 0xae, 0x3d,
	0x81, 0x55, 0xe3, 0x6b, 0xe2, 0x9f, 0x61, 0x30, 0x1a, 0xe5, 0x92, 0xa7, 0xee, 0xcd, 0xd7, 0x60,
	0x66, 0x40, 0xe7, 0x8e, 0xba, 0x2a, 0x99, 0x0e, 0xd2, 0x5c, 0x6e, 0xb7, 0xf8, 0xe1, 0x8b, 0xdf,
	0xce, 0x92, 0x8a, 0x6b, 0x93, 0x9a, 0x84, 0x4b, 0x4a, 0xe3, 0x2f, 0xc4, 0x3d, 0xa2, 0xe0, 0x42,
	0x3a, 0xdc, 0xc7, 0xb2, 0x67, 0x1f, 0xf3, 0x23, 0xa5, 0xaf, 0x9c, 0xea, 0x45, 0x98, 0x62, 0x39,
	0x79, 0x48, 0xba, 0xd8, 0xf1, 0x1c, 0xaf, 0x2d, 0x4b, 0x8a, 0x59, 0xa2, 0x6e, 0x2a, 0x18, 0x5a,
	0xe7, 0x57, 0xeb, 0xac, 0x2d, 0x49, 0x3b, 0x83, 0x88, 0x52, 0x33, 0x31, 0xaa, 0x91, 0x9a, 0x6b,
	0x42, 0x9f, 0x7d, 0x7a, 0x38, 0x1d, 0x23, 0x6e, 0xf3, 0xd4, 0x64, 0xed, 0x6d, 0x58, 0x7a, 0xec,
	0xff, 0xaa, 0x43, 0x73, 0xa0, 0x27, 0x5f, 0x0f, 0xfd, 0xb0, 0x8b, 0x5d, 0xfd, 0x12, 0x5a, 0x84,
	0xd9, 0x04, 0x7a, 0xc7, 0x0f, 0x6d, 0x5e, 0x66, 0xac, 0x6b, 0x6b, 0x2e, 0x5c, 0x39, 0xed, 0x9f,
	0xd3, 0xb1, 0xee, 0x64, 0x11, 0x6f, 0xcf, 0xa5, 0x71, 0x77, 0x2b, 0x70, 0x25, 0x81, 0xee, 0x0c,
	0xfd, 0x8f, 0x39, 0x71, 0x8b, 0x9d, 0x50, 0x88, 0xcb, 0x49, 0x3d, 0xb7, 0xf6, 0x32, 0x40, 0x52,
	0x35, 0x84, 0x26, 0x20, 0xf7, 0xe8, 0x35, 0xfd, 0x12, 0xaa, 0x40, 0xf1, 0xd1, 0x6b, 0xcd, 0xe6,
	0x8e, 0xae, 0x71, 0xd0, 0x86, 0x9e, 0x5b, 0xfb, 0x18, 0x40, 0x52, 0xdd, 0x86, 0x00, 0x26, 0xe2,
	0xa1, 0x4b, 0x90, 0xdf, 0xf1, 0x8f, 0x75, 0x0d, 0x95, 0xa1, 0x70, 0xcf, 0x69, 0x77, 0xf4, 0xdc,
	0xda, 0xab, 0x50, 0xcb, 0x96, 0xb4, 0xb1, 0x6e, 0x1a, 0xdb, 0xfa, 0x25, 0xf6, 0xd7, 0xdc, 0xd4,
	0x35, 0x7e, 0x53, 0xbe, 0x29, 0x6e, 0xca, 0x1b, 0x7a, 0x6e, 0xed, 0x11, 0x54, 0x53, 0xe5, 0x51,
	0x8c, 0xd7, 0x87, 0x3e, 0xbd, 0xe9, 0xba, 0xfe, 0x31, 0x69, 0xed, 0x7a, 0x0c, 0x2c, 0x44, 0x16,
	0x83, 0x6e, 0xba, 0x5d, 0x3f, 0xa2, 0x1c, 0xa1, 0xa1, 0x3a, 0xcc, 0xa5, 0x10, 0xfc, 0x5e, 0x9d,
	0x63, 0x72, 0x6b, 0x36, 0xe4, 0x76, 0x03, 0xc6, 0xe1, 0x5e, 0x8f, 0x0a, 0x56, 0xb7, 0x88, 0x2b,
	0x58, 0xe5, 0xe2, 0xce, 0xa1, 0x49, 0x28, 0xab, 0xb3, 0x1d, 0x3d, 0xcf, 0xe6, 0xb5, 0xed, 0x45,
	0x24, 0xa4, 0x7a, 0x01, 0xcd, 0xc2, 0xf4, 0x80, 0x22, 0xf4, 0x22, 0x42, 0x50, 0xe3, 0x5c, 0x2b,
	0x37, 0x8c, 0xf4, 0x89, 0xb5, 0x75, 0xa8, 0xc4, 0x47, 0x5d, 0xac, 0xe7, 0x87, 0xbe, 0x47, 0x84,
	0x10, 0x39, 0x89, 0xae, 0xb1, 0x41, 0x54, 0x03, 0x21, 0x9d, 0xec, 0x7f, 0x1f, 0x65, 0x7c, 0xed,
	0x1e, 0x1c, 0xe8, 0x97, 0x58, 0xeb, 0x3b, 0x98, 0x37, 0x01, 0x98, 0x68, 0xd0, 0x90, 0xa9, 0x2e,
	0xb7, 0xf6, 0x7b, 0x1a, 0x4c, 0xc8, 0x7f, 0x41, 0xca, 0x7b, 0x12, 0xbf, 0xf5, 0x4b, 0x68, 0x1e,
	0x66, 0x9a, 0xcd, 0x1d, 0x71, 0xf7, 0x1e, 0xcf, 0x82, 0xcb, 0x83, 0x1f, 0xdb, 0xca, 0x21, 0x63,
	0x4c, 0x8e, 0x35, 0x78, 0x10, 0x5f, 0x96, 0x37, 0xf6, 0x7a, 0x51, 0x87, 0xb4, 0xf4, 0x3c, 0xb3,
	0x9e, 0xb8, 0x9f, 0x11, 0xff, 0x46, 0x4e, 0x2f, 0xa0, 0x25, 0x98, 0x4f, 0x77, 0xb9, 0xe5, 0x3f,
	0xf4, 0x69, 0xc7, 0xf1, 0xda, 0x7a, 0x71, 0xed, 0x06, 0x94, 0x6e, 0x9f, 0xd0, 0x10, 0xef, 0x06,
	0x62, 0xf2, 0x7e, 0xa0, 0x5f, 0x42, 0x3a, 0x4c, 0xb2, 0x44, 0x77, 0xd7, 0x6d, 0xf1, 0x3d, 0xb0,
	0xae, 0xad, 0x19, 0x30, 0x33, 0xb4, 0x4a, 0x33, 0x33, 0xd8, 0x0c, 0xed, 0x4f, 0xbe, 0x61, 0xfd,
	0x82, 0x1f, 0xea, 0x97, 0x6e, 0xbd, 0xf4, 0xf7, 0x7f, 0x58, 0xd6, 0x7e, 0xf8, 0xc1, 0x0b, 0xda,
	0x4f, 0x3e, 0x78, 0x41, 0xfb, 0xe7, 0x0f, 0x5e, 0xd0, 0x7e, 0xf7, 0x5f, 0x5f, 0xb8, 0x04, 0xba,
	0x1f, 0xb6, 0xd7, 0xa9, 0x73, 0x78, 0xb4, 0x7e, 0x78, 0xc4, 0xff, 0x19, 0xf6, 0xfe, 0x04, 0xff,
	0xf3, 0xfa, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x74, 0x4b, 0x6d, 0x7b, 0x90, 0x5b, 0x00, 0x00,
}

func (m *GetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Version != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.NotFound {
		i--
		if m.NotFound {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SampleStep != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.SampleStep))
		i--
		dAtA[i] = 0x40
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Reverse {
		i--
		if m.Reverse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.KeyOnly {
		i--
		if m.KeyOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Version != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x20
	}
	if m.Limit != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x18
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Pairs) > 0 {
		for iNdEx := len(m.Pairs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pairs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrewriteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrewriteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrewriteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AssertionLevel != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.AssertionLevel))
		i--
		dAtA[i] = 0x78
	}
	if m.MaxCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxCommitTs))
		i--
		dAtA[i] = 0x70
	}
	if m.TryOnePc {
		i--
		if m.TryOnePc {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if len(m.Secondaries) > 0 {
		for iNdEx := len(m.Secondaries) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Secondaries[iNdEx])
			copy(dAtA[i:], m.Secondaries[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Secondaries[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.UseAsyncCommit {
		i--
		if m.UseAsyncCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.MinCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MinCommitTs))
		i--
		dAtA[i] = 0x50
	}
	if m.ForUpdateTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ForUpdateTs))
		i--
		dAtA[i] = 0x48
	}
	if m.TxnSize != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TxnSize))
		i--
		dAtA[i] = 0x40
	}
	if len(m.PessimisticActions) > 0 {
		dAtA9 := make([]byte, len(m.PessimisticActions)*10)
		var j8 int
		for _, num := range m.PessimisticActions {
			for num >= 1<<7 {
				dAtA9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			dAtA9[j8] = uint8(num)
			j8++
		}
		i -= j8
		copy(dAtA[i:], dAtA9[:j8])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j8))
		i--
		dAtA[i] = 0x3a
	}
	if m.SkipConstraintCheck {
		i--
		if m.SkipConstraintCheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.LockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTtl))
		i--
		dAtA[i] = 0x28
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x20
	}
	if len(m.PrimaryLock) > 0 {
		i -= len(m.PrimaryLock)
		copy(dAtA[i:], m.PrimaryLock)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryLock)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Mutations) > 0 {
		for iNdEx := len(m.Mutations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mutations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrewriteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrewriteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrewriteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.OnePcCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.OnePcCommitTs))
		i--
		dAtA[i] = 0x20
	}
	if m.MinCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MinCommitTs))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PessimisticLockRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PessimisticLockRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PessimisticLockRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.WakeUpMode != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.WakeUpMode))
		i--
		dAtA[i] = 0x70
	}
	if m.LockOnlyIfExists {
		i--
		if m.LockOnlyIfExists {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if m.CheckExistence {
		i--
		if m.CheckExistence {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.MinCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MinCommitTs))
		i--
		dAtA[i] = 0x58
	}
	if m.ReturnValues {
		i--
		if m.ReturnValues {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Force {
		i--
		if m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.WaitTimeout != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.WaitTimeout))
		i--
		dAtA[i] = 0x40
	}
	if m.IsFirstLock {
		i--
		if m.IsFirstLock {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.ForUpdateTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ForUpdateTs))
		i--
		dAtA[i] = 0x30
	}
	if m.LockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTtl))
		i--
		dAtA[i] = 0x28
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x20
	}
	if len(m.PrimaryLock) > 0 {
		i -= len(m.PrimaryLock)
		copy(dAtA[i:], m.PrimaryLock)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryLock)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Mutations) > 0 {
		for iNdEx := len(m.Mutations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mutations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PessimisticLockKeyResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PessimisticLockKeyResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PessimisticLockKeyResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SkipResolvingLock {
		i--
		if m.SkipResolvingLock {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.LockedWithConflictTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockedWithConflictTs))
		i--
		dAtA[i] = 0x20
	}
	if m.Existence {
		i--
		if m.Existence {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PessimisticLockResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PessimisticLockResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PessimisticLockResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Results) > 0 {
		for iNdEx := len(m.Results) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Results[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.NotFounds) > 0 {
		for iNdEx := len(m.NotFounds) - 1; iNdEx >= 0; iNdEx-- {
			i--
			if m.NotFounds[iNdEx] {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
		}
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.NotFounds)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x22
	}
	if m.CommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitTs))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PessimisticRollbackRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PessimisticRollbackRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PessimisticRollbackRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.ForUpdateTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ForUpdateTs))
		i--
		dAtA[i] = 0x18
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PessimisticRollbackResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PessimisticRollbackResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PessimisticRollbackResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TxnHeartBeatRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnHeartBeatRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxnHeartBeatRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AdviseLockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.AdviseLockTtl))
		i--
		dAtA[i] = 0x20
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PrimaryLock) > 0 {
		i -= len(m.PrimaryLock)
		copy(dAtA[i:], m.PrimaryLock)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryLock)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TxnHeartBeatResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnHeartBeatResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxnHeartBeatResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.LockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTtl))
		i--
		dAtA[i] = 0x18
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckTxnStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckTxnStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckTxnStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ResolvingPessimisticLock {
		i--
		if m.ResolvingPessimisticLock {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.ForceSyncCommit {
		i--
		if m.ForceSyncCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.RollbackIfNotExist {
		i--
		if m.RollbackIfNotExist {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.CurrentTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CurrentTs))
		i--
		dAtA[i] = 0x28
	}
	if m.CallerStartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CallerStartTs))
		i--
		dAtA[i] = 0x20
	}
	if m.LockTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTs))
		i--
		dAtA[i] = 0x18
	}
	if len(m.PrimaryKey) > 0 {
		i -= len(m.PrimaryKey)
		copy(dAtA[i:], m.PrimaryKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckTxnStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckTxnStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckTxnStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.LockInfo != nil {
		{
			size, err := m.LockInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.Action != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x28
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x20
	}
	if m.LockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTtl))
		i--
		dAtA[i] = 0x18
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckSecondaryLocksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckSecondaryLocksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckSecondaryLocksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckSecondaryLocksResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckSecondaryLocksResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckSecondaryLocksResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.CommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitTs))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Locks) > 0 {
		for iNdEx := len(m.Locks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Locks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ImportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImportRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Mutations) > 0 {
		for iNdEx := len(m.Mutations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Mutations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ImportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ImportResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CleanupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CleanupRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CleanupRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CurrentTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CurrentTs))
		i--
		dAtA[i] = 0x20
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CleanupResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CleanupResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CleanupResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BatchGetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchGetRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BatchGetRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Version != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BatchGetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchGetResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BatchGetResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Pairs) > 0 {
		for iNdEx := len(m.Pairs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pairs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BatchRollbackRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchRollbackRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BatchRollbackRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *BatchRollbackResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchRollbackResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BatchRollbackResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanLockRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanLockRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanLockRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Limit != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x20
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanLockResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanLockResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanLockResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Locks) > 0 {
		for iNdEx := len(m.Locks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Locks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResolveLockRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveLockRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResolveLockRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.TxnInfos) > 0 {
		for iNdEx := len(m.TxnInfos) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TxnInfos[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.CommitVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitVersion))
		i--
		dAtA[i] = 0x18
	}
	if m.StartVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartVersion))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResolveLockResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveLockResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResolveLockResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExecDetailsV2 != nil {
		{
			size, err := m.ExecDetailsV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GCRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SafePoint != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.SafePoint))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GCResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteRangeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NotifyOnly {
		i--
		if m.NotifyOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteRangeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrepareFlashbackToVersionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrepareFlashbackToVersionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrepareFlashbackToVersionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Version != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x28
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x20
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrepareFlashbackToVersionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrepareFlashbackToVersionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrepareFlashbackToVersionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FlashbackToVersionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlashbackToVersionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlashbackToVersionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitTs))
		i--
		dAtA[i] = 0x30
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x28
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Version != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FlashbackToVersionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlashbackToVersionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FlashbackToVersionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawGetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawGetRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawGetRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawGetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawGetResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawGetResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NotFound {
		i--
		if m.NotFound {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchGetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchGetRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchGetRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchGetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchGetResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchGetResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Pairs) > 0 {
		for iNdEx := len(m.Pairs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pairs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawPutRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawPutRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForCas {
		i--
		if m.ForCas {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.Ttl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawPutResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawPutResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchPutRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchPutRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ttls) > 0 {
		dAtA72 := make([]byte, len(m.Ttls)*10)
		var j71 int
		for _, num := range m.Ttls {
			for num >= 1<<7 {
				dAtA72[j71] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j71++
			}
			dAtA72[j71] = uint8(num)
			j71++
		}
		i -= j71
		copy(dAtA[i:], dAtA72[:j71])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j71))
		i--
		dAtA[i] = 0x32
	}
	if m.ForCas {
		i--
		if m.ForCas {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Ttl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Pairs) > 0 {
		for iNdEx := len(m.Pairs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Pairs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchPutResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchPutResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawDeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawDeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawDeleteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForCas {
		i--
		if m.ForCas {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawDeleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawDeleteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawDeleteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchDeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchDeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchDeleteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForCas {
		i--
		if m.ForCas {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Keys) > 0 {
		for iNdEx := len(m.Keys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Keys[iNdEx])
			copy(dAtA[i:], m.Keys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Keys[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchDeleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchDeleteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchDeleteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawScanRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawScanRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Reverse {
		i--
		if m.Reverse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x2a
	}
	if m.KeyOnly {
		i--
		if m.KeyOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Limit != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x18
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawScanResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawScanResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Kvs) > 0 {
		for iNdEx := len(m.Kvs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Kvs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawDeleteRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawDeleteRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawDeleteRangeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawDeleteRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawDeleteRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawDeleteRangeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchScanRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchScanRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Reverse {
		i--
		if m.Reverse {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x2a
	}
	if m.KeyOnly {
		i--
		if m.KeyOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.EachLimit != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.EachLimit))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Ranges) > 0 {
		for iNdEx := len(m.Ranges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ranges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawBatchScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawBatchScanResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawBatchScanResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Kvs) > 0 {
		for iNdEx := len(m.Kvs) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Kvs[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UnsafeDestroyRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsafeDestroyRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnsafeDestroyRangeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UnsafeDestroyRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsafeDestroyRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UnsafeDestroyRangeResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RegisterLockObserverRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegisterLockObserverRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegisterLockObserverRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RegisterLockObserverResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegisterLockObserverResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegisterLockObserverResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckLockObserverRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckLockObserverRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckLockObserverRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckLockObserverResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckLockObserverResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckLockObserverResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Locks) > 0 {
		for iNdEx := len(m.Locks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Locks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.IsClean {
		i--
		if m.IsClean {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveLockObserverRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveLockObserverRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveLockObserverRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MaxTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RemoveLockObserverResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoveLockObserverResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RemoveLockObserverResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PhysicalScanLockRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PhysicalScanLockRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PhysicalScanLockRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x20
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0x1a
	}
	if m.MaxTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PhysicalScanLockResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PhysicalScanLockResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PhysicalScanLockResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Locks) > 0 {
		for iNdEx := len(m.Locks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Locks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplitRegionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplitRegionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplitRegionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsRawKv {
		i--
		if m.IsRawKv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.SplitKeys) > 0 {
		for iNdEx := len(m.SplitKeys) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.SplitKeys[iNdEx])
			copy(dAtA[i:], m.SplitKeys[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.SplitKeys[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SplitKey) > 0 {
		i -= len(m.SplitKey)
		copy(dAtA[i:], m.SplitKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.SplitKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SplitRegionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplitRegionResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SplitRegionResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Regions) > 0 {
		for iNdEx := len(m.Regions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Regions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.Right != nil {
		{
			size, err := m.Right.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Left != nil {
		{
			size, err := m.Left.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReadIndexRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadIndexRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadIndexRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ranges) > 0 {
		for iNdEx := len(m.Ranges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ranges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ReadIndexResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadIndexResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadIndexResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Locked != nil {
		{
			size, err := m.Locked.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ReadIndex != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ReadIndex))
		i--
		dAtA[i] = 0x10
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MvccGetByKeyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccGetByKeyRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccGetByKeyRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MvccGetByKeyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccGetByKeyResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccGetByKeyResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MvccGetByStartTsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccGetByStartTsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccGetByStartTsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MvccGetByStartTsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccGetByStartTsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccGetByStartTsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Info != nil {
		{
			size, err := m.Info.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Context) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Context) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Context) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TxnSource != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TxnSource))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if len(m.RequestSource) > 0 {
		i -= len(m.RequestSource)
		copy(dAtA[i:], m.RequestSource)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.RequestSource)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if m.TraceContext != nil {
		{
			size, err := m.TraceContext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if len(m.CommittedLocks) > 0 {
		dAtA106 := make([]byte, len(m.CommittedLocks)*10)
		var j105 int
		for _, num := range m.CommittedLocks {
			for num >= 1<<7 {
				dAtA106[j105] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j105++
			}
			dAtA106[j105] = uint8(num)
			j105++
		}
		i -= j105
		copy(dAtA[i:], dAtA106[:j105])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j105))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.ApiVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApiVersion))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.IsRetryRequest {
		i--
		if m.IsRetryRequest {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.DiskFullOpt != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.DiskFullOpt))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if len(m.ResourceGroupTag) > 0 {
		i -= len(m.ResourceGroupTag)
		copy(dAtA[i:], m.ResourceGroupTag)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.ResourceGroupTag)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.StaleRead {
		i--
		if m.StaleRead {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.TaskId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TaskId))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.AppliedIndex != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.AppliedIndex))
		i--
		dAtA[i] = 0x78
	}
	if m.MaxExecutionDurationMs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MaxExecutionDurationMs))
		i--
		dAtA[i] = 0x70
	}
	if len(m.ResolvedLocks) > 0 {
		dAtA108 := make([]byte, len(m.ResolvedLocks)*10)
		var j107 int
		for _, num := range m.ResolvedLocks {
			for num >= 1<<7 {
				dAtA108[j107] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j107++
			}
			dAtA108[j107] = uint8(num)
			j107++
		}
		i -= j107
		copy(dAtA[i:], dAtA108[:j107])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j107))
		i--
		dAtA[i] = 0x6a
	}
	if m.ReplicaRead {
		i--
		if m.ReplicaRead {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.RecordScanStat {
		i--
		if m.RecordScanStat {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if m.RecordTimeStat {
		i--
		if m.RecordTimeStat {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.SyncLog {
		i--
		if m.SyncLog {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.NotFillCache {
		i--
		if m.NotFillCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.IsolationLevel != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.IsolationLevel))
		i--
		dAtA[i] = 0x38
	}
	if m.Priority != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x30
	}
	if m.Term != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x28
	}
	if m.Peer != nil {
		{
			size, err := m.Peer.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.RegionEpoch != nil {
		{
			size, err := m.RegionEpoch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.RegionId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RegionId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LockInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LockInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LockInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Secondaries) > 0 {
		for iNdEx := len(m.Secondaries) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Secondaries[iNdEx])
			copy(dAtA[i:], m.Secondaries[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Secondaries[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.MinCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MinCommitTs))
		i--
		dAtA[i] = 0x48
	}
	if m.UseAsyncCommit {
		i--
		if m.UseAsyncCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.LockForUpdateTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockForUpdateTs))
		i--
		dAtA[i] = 0x38
	}
	if m.LockType != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockType))
		i--
		dAtA[i] = 0x30
	}
	if m.TxnSize != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TxnSize))
		i--
		dAtA[i] = 0x28
	}
	if m.LockTtl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTtl))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LockVersion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockVersion))
		i--
		dAtA[i] = 0x10
	}
	if len(m.PrimaryLock) > 0 {
		i -= len(m.PrimaryLock)
		copy(dAtA[i:], m.PrimaryLock)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryLock)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KeyError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AssertionFailed != nil {
		{
			size, err := m.AssertionFailed.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.CommitTsTooLarge != nil {
		{
			size, err := m.CommitTsTooLarge.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.TxnNotFound != nil {
		{
			size, err := m.TxnNotFound.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CommitTsExpired != nil {
		{
			size, err := m.CommitTsExpired.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Deadlock != nil {
		{
			size, err := m.Deadlock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.AlreadyExist != nil {
		{
			size, err := m.AlreadyExist.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.Conflict != nil {
		{
			size, err := m.Conflict.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Abort) > 0 {
		i -= len(m.Abort)
		copy(dAtA[i:], m.Abort)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Abort)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Retryable) > 0 {
		i -= len(m.Retryable)
		copy(dAtA[i:], m.Retryable)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Retryable)))
		i--
		dAtA[i] = 0x12
	}
	if m.Locked != nil {
		{
			size, err := m.Locked.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WriteConflict) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteConflict) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteConflict) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Reason != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Reason))
		i--
		dAtA[i] = 0x30
	}
	if m.ConflictCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ConflictCommitTs))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Primary) > 0 {
		i -= len(m.Primary)
		copy(dAtA[i:], m.Primary)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Primary)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x1a
	}
	if m.ConflictTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ConflictTs))
		i--
		dAtA[i] = 0x10
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AlreadyExist) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlreadyExist) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AlreadyExist) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deadlock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deadlock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deadlock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.WaitChain) > 0 {
		for iNdEx := len(m.WaitChain) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.WaitChain[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.DeadlockKeyHash != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.DeadlockKeyHash))
		i--
		dAtA[i] = 0x18
	}
	if len(m.LockKey) > 0 {
		i -= len(m.LockKey)
		copy(dAtA[i:], m.LockKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.LockKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.LockTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LockTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommitTsExpired) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitTsExpired) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitTsExpired) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.MinCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.MinCommitTs))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AttemptedCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.AttemptedCommitTs))
		i--
		dAtA[i] = 0x10
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TxnNotFound) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnNotFound) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxnNotFound) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PrimaryKey) > 0 {
		i -= len(m.PrimaryKey)
		copy(dAtA[i:], m.PrimaryKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PrimaryKey)))
		i--
		dAtA[i] = 0x12
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CommitTsTooLarge) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommitTsTooLarge) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommitTsTooLarge) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AssertionFailed) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssertionFailed) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssertionFailed) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExistingCommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ExistingCommitTs))
		i--
		dAtA[i] = 0x28
	}
	if m.ExistingStartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ExistingStartTs))
		i--
		dAtA[i] = 0x20
	}
	if m.Assertion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Assertion))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TimeDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimeDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TotalRpcWallTimeNs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TotalRpcWallTimeNs))
		i--
		dAtA[i] = 0x20
	}
	if m.KvReadWallTimeMs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.KvReadWallTimeMs))
		i--
		dAtA[i] = 0x18
	}
	if m.ProcessWallTimeMs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ProcessWallTimeMs))
		i--
		dAtA[i] = 0x10
	}
	if m.WaitWallTimeMs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.WaitWallTimeMs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ScanInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReadBytes != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ReadBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.Processed != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Processed))
		i--
		dAtA[i] = 0x10
	}
	if m.Total != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Total))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ScanDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Data != nil {
		{
			size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.Lock != nil {
		{
			size, err := m.Lock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Write != nil {
		{
			size, err := m.Write.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ScanDetailV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanDetailV2) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ScanDetailV2) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReadPoolScheduleWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ReadPoolScheduleWaitNanos))
		i--
		dAtA[i] = 0x68
	}
	if m.ReadIndexConfirmWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ReadIndexConfirmWaitNanos))
		i--
		dAtA[i] = 0x60
	}
	if m.ReadIndexProposeWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ReadIndexProposeWaitNanos))
		i--
		dAtA[i] = 0x58
	}
	if m.GetSnapshotNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.GetSnapshotNanos))
		i--
		dAtA[i] = 0x50
	}
	if m.RocksdbBlockReadNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbBlockReadNanos))
		i--
		dAtA[i] = 0x48
	}
	if m.ProcessedVersionsSize != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ProcessedVersionsSize))
		i--
		dAtA[i] = 0x40
	}
	if m.RocksdbBlockReadByte != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbBlockReadByte))
		i--
		dAtA[i] = 0x38
	}
	if m.RocksdbBlockReadCount != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbBlockReadCount))
		i--
		dAtA[i] = 0x30
	}
	if m.RocksdbBlockCacheHitCount != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbBlockCacheHitCount))
		i--
		dAtA[i] = 0x28
	}
	if m.RocksdbKeySkippedCount != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbKeySkippedCount))
		i--
		dAtA[i] = 0x20
	}
	if m.RocksdbDeleteSkippedCount != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RocksdbDeleteSkippedCount))
		i--
		dAtA[i] = 0x18
	}
	if m.TotalVersions != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TotalVersions))
		i--
		dAtA[i] = 0x10
	}
	if m.ProcessedVersions != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ProcessedVersions))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ExecDetails) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecDetails) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecDetails) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ScanDetail != nil {
		{
			size, err := m.ScanDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.TimeDetail != nil {
		{
			size, err := m.TimeDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExecDetailsV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExecDetailsV2) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExecDetailsV2) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.WriteDetail != nil {
		{
			size, err := m.WriteDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.ScanDetailV2 != nil {
		{
			size, err := m.ScanDetailV2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.TimeDetail != nil {
		{
			size, err := m.TimeDetail.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WriteDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteDetail) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteDetail) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.PessimisticLockWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.PessimisticLockWaitNanos))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.ThrottleNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ThrottleNanos))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.ProcessNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ProcessNanos))
		i--
		dAtA[i] = 0x78
	}
	if m.LatchWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LatchWaitNanos))
		i--
		dAtA[i] = 0x70
	}
	if m.ApplyWriteMemtableNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyWriteMemtableNanos))
		i--
		dAtA[i] = 0x68
	}
	if m.ApplyWriteWalNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyWriteWalNanos))
		i--
		dAtA[i] = 0x60
	}
	if m.ApplyWriteLeaderWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyWriteLeaderWaitNanos))
		i--
		dAtA[i] = 0x58
	}
	if m.ApplyMutexLockNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyMutexLockNanos))
		i--
		dAtA[i] = 0x50
	}
	if m.ApplyLogNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyLogNanos))
		i--
		dAtA[i] = 0x48
	}
	if m.ApplyBatchWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ApplyBatchWaitNanos))
		i--
		dAtA[i] = 0x40
	}
	if m.CommitLogNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitLogNanos))
		i--
		dAtA[i] = 0x38
	}
	if m.RaftDbWriteMemtableNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RaftDbWriteMemtableNanos))
		i--
		dAtA[i] = 0x30
	}
	if m.RaftDbSyncLogNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RaftDbSyncLogNanos))
		i--
		dAtA[i] = 0x28
	}
	if m.RaftDbWriteLeaderWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RaftDbWriteLeaderWaitNanos))
		i--
		dAtA[i] = 0x20
	}
	if m.PersistLogNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.PersistLogNanos))
		i--
		dAtA[i] = 0x18
	}
	if m.ProposeSendWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ProposeSendWaitNanos))
		i--
		dAtA[i] = 0x10
	}
	if m.StoreBatchWaitNanos != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StoreBatchWaitNanos))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KvPair) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KvPair) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KvPair) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Mutation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Mutation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Mutation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Assertion != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Assertion))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Op != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MvccWrite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccWrite) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccWrite) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.VersionsToLastChange != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.VersionsToLastChange))
		i--
		dAtA[i] = 0x48
	}
	if m.LastChangeTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LastChangeTs))
		i--
		dAtA[i] = 0x40
	}
	if m.GcFence != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.GcFence))
		i--
		dAtA[i] = 0x38
	}
	if m.HasGcFence {
		i--
		if m.HasGcFence {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.HasOverlappedRollback {
		i--
		if m.HasOverlappedRollback {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.ShortValue) > 0 {
		i -= len(m.ShortValue)
		copy(dAtA[i:], m.ShortValue)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.ShortValue)))
		i--
		dAtA[i] = 0x22
	}
	if m.CommitTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.CommitTs))
		i--
		dAtA[i] = 0x18
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MvccValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccValue) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccValue) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MvccLock) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccLock) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccLock) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.VersionsToLastChange != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.VersionsToLastChange))
		i--
		dAtA[i] = 0x60
	}
	if m.LastChangeTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LastChangeTs))
		i--
		dAtA[i] = 0x58
	}
	if len(m.RollbackTs) > 0 {
		dAtA129 := make([]byte, len(m.RollbackTs)*10)
		var j128 int
		for _, num := range m.RollbackTs {
			for num >= 1<<7 {
				dAtA129[j128] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j128++
			}
			dAtA129[j128] = uint8(num)
			j128++
		}
		i -= j128
		copy(dAtA[i:], dAtA129[:j128])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j128))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Secondaries) > 0 {
		for iNdEx := len(m.Secondaries) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Secondaries[iNdEx])
			copy(dAtA[i:], m.Secondaries[iNdEx])
			i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Secondaries[iNdEx])))
			i--
			dAtA[i] = 0x4a
		}
	}
	if m.UseAsyncCommit {
		i--
		if m.UseAsyncCommit {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.TxnSize != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TxnSize))
		i--
		dAtA[i] = 0x38
	}
	if m.ForUpdateTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.ForUpdateTs))
		i--
		dAtA[i] = 0x30
	}
	if m.Ttl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x28
	}
	if len(m.ShortValue) > 0 {
		i -= len(m.ShortValue)
		copy(dAtA[i:], m.ShortValue)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.ShortValue)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Primary) > 0 {
		i -= len(m.Primary)
		copy(dAtA[i:], m.Primary)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Primary)))
		i--
		dAtA[i] = 0x1a
	}
	if m.StartTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.StartTs))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *MvccInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MvccInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MvccInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Values[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Writes) > 0 {
		for iNdEx := len(m.Writes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Writes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Lock != nil {
		{
			size, err := m.Lock.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TxnInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TxnInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x10
	}
	if m.Txn != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Txn))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *KeyRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.EndKey) > 0 {
		i -= len(m.EndKey)
		copy(dAtA[i:], m.EndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.EndKey)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LeaderInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaderInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LeaderInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ReadState != nil {
		{
			size, err := m.ReadState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.RegionEpoch != nil {
		{
			size, err := m.RegionEpoch.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Term != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x18
	}
	if m.PeerId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.PeerId))
		i--
		dAtA[i] = 0x10
	}
	if m.RegionId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.RegionId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ReadState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReadState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SafeTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.SafeTs))
		i--
		dAtA[i] = 0x10
	}
	if m.AppliedIndex != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.AppliedIndex))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CheckLeaderRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckLeaderRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckLeaderRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Ts != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ts))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Regions) > 0 {
		for iNdEx := len(m.Regions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Regions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CheckLeaderResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckLeaderResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckLeaderResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Ts != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ts))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Regions) > 0 {
		dAtA134 := make([]byte, len(m.Regions)*10)
		var j133 int
		for _, num := range m.Regions {
			for num >= 1<<7 {
				dAtA134[j133] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j133++
			}
			dAtA134[j133] = uint8(num)
			j133++
		}
		i -= j133
		copy(dAtA[i:], dAtA134[:j133])
		i = encodeVarintKvrpcpb(dAtA, i, uint64(j133))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StoreSafeTSRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreSafeTSRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StoreSafeTSRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.KeyRange != nil {
		{
			size, err := m.KeyRange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *StoreSafeTSResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreSafeTSResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *StoreSafeTSResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SafeTs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.SafeTs))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *RawGetKeyTTLRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawGetKeyTTLRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawGetKeyTTLRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawGetKeyTTLResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawGetKeyTTLResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawGetKeyTTLResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NotFound {
		i--
		if m.NotFound {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Ttl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawCASRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawCASRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawCASRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Ttl != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Cf) > 0 {
		i -= len(m.Cf)
		copy(dAtA[i:], m.Cf)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Cf)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.PreviousValue) > 0 {
		i -= len(m.PreviousValue)
		copy(dAtA[i:], m.PreviousValue)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PreviousValue)))
		i--
		dAtA[i] = 0x2a
	}
	if m.PreviousNotExist {
		i--
		if m.PreviousNotExist {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawCASResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawCASResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawCASResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PreviousValue) > 0 {
		i -= len(m.PreviousValue)
		copy(dAtA[i:], m.PreviousValue)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.PreviousValue)))
		i--
		dAtA[i] = 0x2a
	}
	if m.PreviousNotExist {
		i--
		if m.PreviousNotExist {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Succeed {
		i--
		if m.Succeed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetLockWaitInfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLockWaitInfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLockWaitInfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetLockWaitInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLockWaitInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLockWaitInfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetLockWaitHistoryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLockWaitHistoryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLockWaitHistoryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetLockWaitHistoryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetLockWaitHistoryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetLockWaitHistoryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawCoprocessorRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawCoprocessorRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawCoprocessorRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Ranges) > 0 {
		for iNdEx := len(m.Ranges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ranges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.CoprVersionReq) > 0 {
		i -= len(m.CoprVersionReq)
		copy(dAtA[i:], m.CoprVersionReq)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.CoprVersionReq)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CoprName) > 0 {
		i -= len(m.CoprName)
		copy(dAtA[i:], m.CoprName)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.CoprName)))
		i--
		dAtA[i] = 0x12
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawCoprocessorResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawCoprocessorResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawCoprocessorResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawChecksumRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Ranges) > 0 {
		for iNdEx := len(m.Ranges) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Ranges[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Algorithm != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Algorithm))
		i--
		dAtA[i] = 0x10
	}
	if m.Context != nil {
		{
			size, err := m.Context.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RawChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RawChecksumResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.TotalBytes != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TotalBytes))
		i--
		dAtA[i] = 0x28
	}
	if m.TotalKvs != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.TotalKvs))
		i--
		dAtA[i] = 0x20
	}
	if m.Checksum != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.Checksum))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x12
	}
	if m.RegionError != nil {
		{
			size, err := m.RegionError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CompactError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Error != nil {
		{
			size := m.Error.Size()
			i -= size
			if _, err := m.Error.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *CompactError_ErrInvalidStartKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactError_ErrInvalidStartKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ErrInvalidStartKey != nil {
		{
			size, err := m.ErrInvalidStartKey.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *CompactError_ErrPhysicalTableNotExist) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactError_ErrPhysicalTableNotExist) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ErrPhysicalTableNotExist != nil {
		{
			size, err := m.ErrPhysicalTableNotExist.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *CompactError_ErrCompactInProgress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactError_ErrCompactInProgress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ErrCompactInProgress != nil {
		{
			size, err := m.ErrCompactInProgress.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *CompactError_ErrTooManyPendingTasks) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactError_ErrTooManyPendingTasks) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.ErrTooManyPendingTasks != nil {
		{
			size, err := m.ErrTooManyPendingTasks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *CompactErrorInvalidStartKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactErrorInvalidStartKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactErrorInvalidStartKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CompactErrorPhysicalTableNotExist) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactErrorPhysicalTableNotExist) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactErrorPhysicalTableNotExist) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CompactErrorCompactInProgress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactErrorCompactInProgress) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactErrorCompactInProgress) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CompactErrorTooManyPendingTasks) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactErrorTooManyPendingTasks) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactErrorTooManyPendingTasks) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *CompactRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LogicalTableId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.LogicalTableId))
		i--
		dAtA[i] = 0x18
	}
	if m.PhysicalTableId != 0 {
		i = encodeVarintKvrpcpb(dAtA, i, uint64(m.PhysicalTableId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.StartKey) > 0 {
		i -= len(m.StartKey)
		copy(dAtA[i:], m.StartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.StartKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CompactResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompactResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompactResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CompactedEndKey) > 0 {
		i -= len(m.CompactedEndKey)
		copy(dAtA[i:], m.CompactedEndKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.CompactedEndKey)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.CompactedStartKey) > 0 {
		i -= len(m.CompactedStartKey)
		copy(dAtA[i:], m.CompactedStartKey)
		i = encodeVarintKvrpcpb(dAtA, i, uint64(len(m.CompactedStartKey)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HasRemaining {
		i--
		if m.HasRemaining {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKvrpcpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintKvrpcpb(dAtA []byte, offset int, v uint64) int {
	offset -= sovKvrpcpb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GetRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.NotFound {
		n += 2
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Limit))
	}
	if m.Version != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Version))
	}
	if m.KeyOnly {
		n += 2
	}
	if m.Reverse {
		n += 2
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.SampleStep != 0 {
		n += 1 + sovKvrpcpb(uint64(m.SampleStep))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Pairs) > 0 {
		for _, e := range m.Pairs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrewriteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Mutations) > 0 {
		for _, e := range m.Mutations {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.PrimaryLock)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.LockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTtl))
	}
	if m.SkipConstraintCheck {
		n += 2
	}
	if len(m.PessimisticActions) > 0 {
		l = 0
		for _, e := range m.PessimisticActions {
			l += sovKvrpcpb(uint64(e))
		}
		n += 1 + sovKvrpcpb(uint64(l)) + l
	}
	if m.TxnSize != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TxnSize))
	}
	if m.ForUpdateTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ForUpdateTs))
	}
	if m.MinCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MinCommitTs))
	}
	if m.UseAsyncCommit {
		n += 2
	}
	if len(m.Secondaries) > 0 {
		for _, b := range m.Secondaries {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.TryOnePc {
		n += 2
	}
	if m.MaxCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxCommitTs))
	}
	if m.AssertionLevel != 0 {
		n += 1 + sovKvrpcpb(uint64(m.AssertionLevel))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrewriteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.MinCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MinCommitTs))
	}
	if m.OnePcCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.OnePcCommitTs))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PessimisticLockRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Mutations) > 0 {
		for _, e := range m.Mutations {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.PrimaryLock)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.LockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTtl))
	}
	if m.ForUpdateTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ForUpdateTs))
	}
	if m.IsFirstLock {
		n += 2
	}
	if m.WaitTimeout != 0 {
		n += 1 + sovKvrpcpb(uint64(m.WaitTimeout))
	}
	if m.Force {
		n += 2
	}
	if m.ReturnValues {
		n += 2
	}
	if m.MinCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MinCommitTs))
	}
	if m.CheckExistence {
		n += 2
	}
	if m.LockOnlyIfExists {
		n += 2
	}
	if m.WakeUpMode != 0 {
		n += 1 + sovKvrpcpb(uint64(m.WakeUpMode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PessimisticLockKeyResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Type))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Existence {
		n += 2
	}
	if m.LockedWithConflictTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockedWithConflictTs))
	}
	if m.SkipResolvingLock {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PessimisticLockResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.CommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitTs))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, b := range m.Values {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if len(m.NotFounds) > 0 {
		n += 1 + sovKvrpcpb(uint64(len(m.NotFounds))) + len(m.NotFounds)*1
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Results) > 0 {
		for _, e := range m.Results {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PessimisticRollbackRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.ForUpdateTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ForUpdateTs))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PessimisticRollbackResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TxnHeartBeatRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.PrimaryLock)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.AdviseLockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.AdviseLockTtl))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TxnHeartBeatResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.LockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTtl))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckTxnStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.PrimaryKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.LockTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTs))
	}
	if m.CallerStartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CallerStartTs))
	}
	if m.CurrentTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CurrentTs))
	}
	if m.RollbackIfNotExist {
		n += 2
	}
	if m.ForceSyncCommit {
		n += 2
	}
	if m.ResolvingPessimisticLock {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckTxnStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.LockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTtl))
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if m.Action != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Action))
	}
	if m.LockInfo != nil {
		l = m.LockInfo.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckSecondaryLocksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckSecondaryLocksResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Locks) > 0 {
		for _, e := range m.Locks {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.CommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitTs))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommitRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommitResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Mutations) > 0 {
		for _, e := range m.Mutations {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ImportResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CleanupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.CurrentTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CurrentTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CleanupResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BatchGetRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.Version != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BatchGetResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Pairs) > 0 {
		for _, e := range m.Pairs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BatchRollbackRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BatchRollbackResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanLockRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MaxVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxVersion))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Limit))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanLockResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Locks) > 0 {
		for _, e := range m.Locks {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResolveLockRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartVersion))
	}
	if m.CommitVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitVersion))
	}
	if len(m.TxnInfos) > 0 {
		for _, e := range m.TxnInfos {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResolveLockResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ExecDetailsV2 != nil {
		l = m.ExecDetailsV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.SafePoint != 0 {
		n += 1 + sovKvrpcpb(uint64(m.SafePoint))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.NotifyOnly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrepareFlashbackToVersionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.Version != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Version))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PrepareFlashbackToVersionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FlashbackToVersionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Version))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.CommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FlashbackToVersionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawGetRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawGetResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.NotFound {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchGetRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchGetResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Pairs) > 0 {
		for _, e := range m.Pairs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawPutRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Ttl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ttl))
	}
	if m.ForCas {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawPutResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchPutRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Pairs) > 0 {
		for _, e := range m.Pairs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Ttl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ttl))
	}
	if m.ForCas {
		n += 2
	}
	if len(m.Ttls) > 0 {
		l = 0
		for _, e := range m.Ttls {
			l += sovKvrpcpb(uint64(e))
		}
		n += 1 + sovKvrpcpb(uint64(l)) + l
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchPutResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawDeleteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ForCas {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawDeleteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchDeleteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ForCas {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchDeleteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawScanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Limit))
	}
	if m.KeyOnly {
		n += 2
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Reverse {
		n += 2
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawScanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Kvs) > 0 {
		for _, e := range m.Kvs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawDeleteRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawDeleteRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchScanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.EachLimit != 0 {
		n += 1 + sovKvrpcpb(uint64(m.EachLimit))
	}
	if m.KeyOnly {
		n += 2
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Reverse {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawBatchScanResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Kvs) > 0 {
		for _, e := range m.Kvs {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UnsafeDestroyRangeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UnsafeDestroyRangeResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegisterLockObserverRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MaxTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegisterLockObserverResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckLockObserverRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MaxTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckLockObserverResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.IsClean {
		n += 2
	}
	if len(m.Locks) > 0 {
		for _, e := range m.Locks {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RemoveLockObserverRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MaxTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RemoveLockObserverResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PhysicalScanLockRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MaxTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxTs))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Limit != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PhysicalScanLockResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Locks) > 0 {
		for _, e := range m.Locks {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplitRegionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.SplitKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.SplitKeys) > 0 {
		for _, b := range m.SplitKeys {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.IsRawKv {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SplitRegionResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Left != nil {
		l = m.Left.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Right != nil {
		l = m.Right.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Regions) > 0 {
		for _, e := range m.Regions {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadIndexRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadIndexResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ReadIndex != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ReadIndex))
	}
	if m.Locked != nil {
		l = m.Locked.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccGetByKeyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccGetByKeyResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccGetByStartTsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccGetByStartTsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Context) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RegionId))
	}
	if m.RegionEpoch != nil {
		l = m.RegionEpoch.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Peer != nil {
		l = m.Peer.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Term != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Term))
	}
	if m.Priority != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Priority))
	}
	if m.IsolationLevel != 0 {
		n += 1 + sovKvrpcpb(uint64(m.IsolationLevel))
	}
	if m.NotFillCache {
		n += 2
	}
	if m.SyncLog {
		n += 2
	}
	if m.RecordTimeStat {
		n += 2
	}
	if m.RecordScanStat {
		n += 2
	}
	if m.ReplicaRead {
		n += 2
	}
	if len(m.ResolvedLocks) > 0 {
		l = 0
		for _, e := range m.ResolvedLocks {
			l += sovKvrpcpb(uint64(e))
		}
		n += 1 + sovKvrpcpb(uint64(l)) + l
	}
	if m.MaxExecutionDurationMs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MaxExecutionDurationMs))
	}
	if m.AppliedIndex != 0 {
		n += 1 + sovKvrpcpb(uint64(m.AppliedIndex))
	}
	if m.TaskId != 0 {
		n += 2 + sovKvrpcpb(uint64(m.TaskId))
	}
	if m.StaleRead {
		n += 3
	}
	l = len(m.ResourceGroupTag)
	if l > 0 {
		n += 2 + l + sovKvrpcpb(uint64(l))
	}
	if m.DiskFullOpt != 0 {
		n += 2 + sovKvrpcpb(uint64(m.DiskFullOpt))
	}
	if m.IsRetryRequest {
		n += 3
	}
	if m.ApiVersion != 0 {
		n += 2 + sovKvrpcpb(uint64(m.ApiVersion))
	}
	if len(m.CommittedLocks) > 0 {
		l = 0
		for _, e := range m.CommittedLocks {
			l += sovKvrpcpb(uint64(e))
		}
		n += 2 + sovKvrpcpb(uint64(l)) + l
	}
	if m.TraceContext != nil {
		l = m.TraceContext.Size()
		n += 2 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.RequestSource)
	if l > 0 {
		n += 2 + l + sovKvrpcpb(uint64(l))
	}
	if m.TxnSource != 0 {
		n += 2 + sovKvrpcpb(uint64(m.TxnSource))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LockInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.PrimaryLock)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.LockVersion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockVersion))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.LockTtl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTtl))
	}
	if m.TxnSize != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TxnSize))
	}
	if m.LockType != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockType))
	}
	if m.LockForUpdateTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockForUpdateTs))
	}
	if m.UseAsyncCommit {
		n += 2
	}
	if m.MinCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MinCommitTs))
	}
	if len(m.Secondaries) > 0 {
		for _, b := range m.Secondaries {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Locked != nil {
		l = m.Locked.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Retryable)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Abort)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Conflict != nil {
		l = m.Conflict.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.AlreadyExist != nil {
		l = m.AlreadyExist.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Deadlock != nil {
		l = m.Deadlock.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.CommitTsExpired != nil {
		l = m.CommitTsExpired.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.TxnNotFound != nil {
		l = m.TxnNotFound.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.CommitTsTooLarge != nil {
		l = m.CommitTsTooLarge.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.AssertionFailed != nil {
		l = m.AssertionFailed.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteConflict) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.ConflictTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ConflictTs))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Primary)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ConflictCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ConflictCommitTs))
	}
	if m.Reason != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Reason))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AlreadyExist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deadlock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LockTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LockTs))
	}
	l = len(m.LockKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.DeadlockKeyHash != 0 {
		n += 1 + sovKvrpcpb(uint64(m.DeadlockKeyHash))
	}
	if len(m.WaitChain) > 0 {
		for _, e := range m.WaitChain {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommitTsExpired) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.AttemptedCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.AttemptedCommitTs))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.MinCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.MinCommitTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TxnNotFound) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	l = len(m.PrimaryKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommitTsTooLarge) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AssertionFailed) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Assertion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Assertion))
	}
	if m.ExistingStartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ExistingStartTs))
	}
	if m.ExistingCommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ExistingCommitTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WaitWallTimeMs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.WaitWallTimeMs))
	}
	if m.ProcessWallTimeMs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ProcessWallTimeMs))
	}
	if m.KvReadWallTimeMs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.KvReadWallTimeMs))
	}
	if m.TotalRpcWallTimeNs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TotalRpcWallTimeNs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Total != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Total))
	}
	if m.Processed != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Processed))
	}
	if m.ReadBytes != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ReadBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Write != nil {
		l = m.Write.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Lock != nil {
		l = m.Lock.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ScanDetailV2) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ProcessedVersions != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ProcessedVersions))
	}
	if m.TotalVersions != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TotalVersions))
	}
	if m.RocksdbDeleteSkippedCount != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbDeleteSkippedCount))
	}
	if m.RocksdbKeySkippedCount != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbKeySkippedCount))
	}
	if m.RocksdbBlockCacheHitCount != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbBlockCacheHitCount))
	}
	if m.RocksdbBlockReadCount != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbBlockReadCount))
	}
	if m.RocksdbBlockReadByte != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbBlockReadByte))
	}
	if m.ProcessedVersionsSize != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ProcessedVersionsSize))
	}
	if m.RocksdbBlockReadNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RocksdbBlockReadNanos))
	}
	if m.GetSnapshotNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.GetSnapshotNanos))
	}
	if m.ReadIndexProposeWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ReadIndexProposeWaitNanos))
	}
	if m.ReadIndexConfirmWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ReadIndexConfirmWaitNanos))
	}
	if m.ReadPoolScheduleWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ReadPoolScheduleWaitNanos))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecDetails) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeDetail != nil {
		l = m.TimeDetail.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ScanDetail != nil {
		l = m.ScanDetail.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExecDetailsV2) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TimeDetail != nil {
		l = m.TimeDetail.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ScanDetailV2 != nil {
		l = m.ScanDetailV2.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.WriteDetail != nil {
		l = m.WriteDetail.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteDetail) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StoreBatchWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StoreBatchWaitNanos))
	}
	if m.ProposeSendWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ProposeSendWaitNanos))
	}
	if m.PersistLogNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.PersistLogNanos))
	}
	if m.RaftDbWriteLeaderWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RaftDbWriteLeaderWaitNanos))
	}
	if m.RaftDbSyncLogNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RaftDbSyncLogNanos))
	}
	if m.RaftDbWriteMemtableNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RaftDbWriteMemtableNanos))
	}
	if m.CommitLogNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitLogNanos))
	}
	if m.ApplyBatchWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyBatchWaitNanos))
	}
	if m.ApplyLogNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyLogNanos))
	}
	if m.ApplyMutexLockNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyMutexLockNanos))
	}
	if m.ApplyWriteLeaderWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyWriteLeaderWaitNanos))
	}
	if m.ApplyWriteWalNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyWriteWalNanos))
	}
	if m.ApplyWriteMemtableNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ApplyWriteMemtableNanos))
	}
	if m.LatchWaitNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LatchWaitNanos))
	}
	if m.ProcessNanos != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ProcessNanos))
	}
	if m.ThrottleNanos != 0 {
		n += 2 + sovKvrpcpb(uint64(m.ThrottleNanos))
	}
	if m.PessimisticLockWaitNanos != 0 {
		n += 2 + sovKvrpcpb(uint64(m.PessimisticLockWaitNanos))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KvPair) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Mutation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Op))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Assertion != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Assertion))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccWrite) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Type))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	if m.CommitTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.CommitTs))
	}
	l = len(m.ShortValue)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.HasOverlappedRollback {
		n += 2
	}
	if m.HasGcFence {
		n += 2
	}
	if m.GcFence != 0 {
		n += 1 + sovKvrpcpb(uint64(m.GcFence))
	}
	if m.LastChangeTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LastChangeTs))
	}
	if m.VersionsToLastChange != 0 {
		n += 1 + sovKvrpcpb(uint64(m.VersionsToLastChange))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccValue) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccLock) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Type))
	}
	if m.StartTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.StartTs))
	}
	l = len(m.Primary)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.ShortValue)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Ttl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ttl))
	}
	if m.ForUpdateTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.ForUpdateTs))
	}
	if m.TxnSize != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TxnSize))
	}
	if m.UseAsyncCommit {
		n += 2
	}
	if len(m.Secondaries) > 0 {
		for _, b := range m.Secondaries {
			l = len(b)
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if len(m.RollbackTs) > 0 {
		l = 0
		for _, e := range m.RollbackTs {
			l += sovKvrpcpb(uint64(e))
		}
		n += 1 + sovKvrpcpb(uint64(l)) + l
	}
	if m.LastChangeTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LastChangeTs))
	}
	if m.VersionsToLastChange != 0 {
		n += 1 + sovKvrpcpb(uint64(m.VersionsToLastChange))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MvccInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Lock != nil {
		l = m.Lock.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Writes) > 0 {
		for _, e := range m.Writes {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if len(m.Values) > 0 {
		for _, e := range m.Values {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TxnInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Txn != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Txn))
	}
	if m.Status != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LeaderInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionId != 0 {
		n += 1 + sovKvrpcpb(uint64(m.RegionId))
	}
	if m.PeerId != 0 {
		n += 1 + sovKvrpcpb(uint64(m.PeerId))
	}
	if m.Term != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Term))
	}
	if m.RegionEpoch != nil {
		l = m.RegionEpoch.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.ReadState != nil {
		l = m.ReadState.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ReadState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AppliedIndex != 0 {
		n += 1 + sovKvrpcpb(uint64(m.AppliedIndex))
	}
	if m.SafeTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.SafeTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckLeaderRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Regions) > 0 {
		for _, e := range m.Regions {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.Ts != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ts))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckLeaderResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Regions) > 0 {
		l = 0
		for _, e := range m.Regions {
			l += sovKvrpcpb(uint64(e))
		}
		n += 1 + sovKvrpcpb(uint64(l)) + l
	}
	if m.Ts != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ts))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreSafeTSRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyRange != nil {
		l = m.KeyRange.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StoreSafeTSResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.SafeTs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.SafeTs))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawGetKeyTTLRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawGetKeyTTLResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Ttl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ttl))
	}
	if m.NotFound {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawCASRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.PreviousNotExist {
		n += 2
	}
	l = len(m.PreviousValue)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Ttl != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Ttl))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawCASResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Succeed {
		n += 2
	}
	if m.PreviousNotExist {
		n += 2
	}
	l = len(m.PreviousValue)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLockWaitInfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLockWaitInfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLockWaitHistoryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetLockWaitHistoryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawCoprocessorRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.CoprName)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.CoprVersionReq)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawCoprocessorResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawChecksumRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Context != nil {
		l = m.Context.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Algorithm != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Algorithm))
	}
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovKvrpcpb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawChecksumResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.Checksum != 0 {
		n += 1 + sovKvrpcpb(uint64(m.Checksum))
	}
	if m.TotalKvs != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovKvrpcpb(uint64(m.TotalBytes))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		n += m.Error.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactError_ErrInvalidStartKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrInvalidStartKey != nil {
		l = m.ErrInvalidStartKey.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	return n
}
func (m *CompactError_ErrPhysicalTableNotExist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrPhysicalTableNotExist != nil {
		l = m.ErrPhysicalTableNotExist.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	return n
}
func (m *CompactError_ErrCompactInProgress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrCompactInProgress != nil {
		l = m.ErrCompactInProgress.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	return n
}
func (m *CompactError_ErrTooManyPendingTasks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrTooManyPendingTasks != nil {
		l = m.ErrTooManyPendingTasks.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	return n
}
func (m *CompactErrorInvalidStartKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactErrorPhysicalTableNotExist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactErrorCompactInProgress) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactErrorTooManyPendingTasks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.PhysicalTableId != 0 {
		n += 1 + sovKvrpcpb(uint64(m.PhysicalTableId))
	}
	if m.LogicalTableId != 0 {
		n += 1 + sovKvrpcpb(uint64(m.LogicalTableId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CompactResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.HasRemaining {
		n += 2
	}
	l = len(m.CompactedStartKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	l = len(m.CompactedEndKey)
	if l > 0 {
		n += 1 + l + sovKvrpcpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovKvrpcpb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozKvrpcpb(x uint64) (n int) {
	return sovKvrpcpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotFound", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotFound = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KeyOnly = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleStep", wireType)
			}
			m.SampleStep = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleStep |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pairs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pairs = append(m.Pairs, &KvPair{})
			if err := m.Pairs[len(m.Pairs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrewriteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrewriteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrewriteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mutations = append(m.Mutations, &Mutation{})
			if err := m.Mutations[len(m.Mutations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryLock", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryLock = append(m.PrimaryLock[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryLock == nil {
				m.PrimaryLock = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTtl", wireType)
			}
			m.LockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipConstraintCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipConstraintCheck = bool(v != 0)
		case 7:
			if wireType == 0 {
				var v PrewriteRequest_PessimisticAction
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= PrewriteRequest_PessimisticAction(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.PessimisticActions = append(m.PessimisticActions, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.PessimisticActions) == 0 {
					m.PessimisticActions = make([]PrewriteRequest_PessimisticAction, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v PrewriteRequest_PessimisticAction
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= PrewriteRequest_PessimisticAction(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.PessimisticActions = append(m.PessimisticActions, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field PessimisticActions", wireType)
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSize", wireType)
			}
			m.TxnSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxnSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForUpdateTs", wireType)
			}
			m.ForUpdateTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForUpdateTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinCommitTs", wireType)
			}
			m.MinCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseAsyncCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseAsyncCommit = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secondaries", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secondaries = append(m.Secondaries, make([]byte, postIndex-iNdEx))
			copy(m.Secondaries[len(m.Secondaries)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TryOnePc", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TryOnePc = bool(v != 0)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxCommitTs", wireType)
			}
			m.MaxCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssertionLevel", wireType)
			}
			m.AssertionLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AssertionLevel |= AssertionLevel(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrewriteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrewriteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrewriteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &KeyError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinCommitTs", wireType)
			}
			m.MinCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnePcCommitTs", wireType)
			}
			m.OnePcCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OnePcCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PessimisticLockRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PessimisticLockRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PessimisticLockRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mutations = append(m.Mutations, &Mutation{})
			if err := m.Mutations[len(m.Mutations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryLock", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryLock = append(m.PrimaryLock[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryLock == nil {
				m.PrimaryLock = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTtl", wireType)
			}
			m.LockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForUpdateTs", wireType)
			}
			m.ForUpdateTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForUpdateTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFirstLock", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFirstLock = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitTimeout", wireType)
			}
			m.WaitTimeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WaitTimeout |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnValues", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnValues = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinCommitTs", wireType)
			}
			m.MinCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckExistence", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CheckExistence = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockOnlyIfExists", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LockOnlyIfExists = bool(v != 0)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WakeUpMode", wireType)
			}
			m.WakeUpMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WakeUpMode |= PessimisticLockWakeUpMode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PessimisticLockKeyResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PessimisticLockKeyResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PessimisticLockKeyResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= PessimisticLockKeyResultType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Existence", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Existence = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockedWithConflictTs", wireType)
			}
			m.LockedWithConflictTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockedWithConflictTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipResolvingLock", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipResolvingLock = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PessimisticLockResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PessimisticLockResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PessimisticLockResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &KeyError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTs", wireType)
			}
			m.CommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, make([]byte, postIndex-iNdEx))
			copy(m.Values[len(m.Values)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType == 0 {
				var v int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.NotFounds = append(m.NotFounds, bool(v != 0))
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen
				if elementCount != 0 && len(m.NotFounds) == 0 {
					m.NotFounds = make([]bool, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.NotFounds = append(m.NotFounds, bool(v != 0))
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field NotFounds", wireType)
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Results", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Results = append(m.Results, &PessimisticLockKeyResult{})
			if err := m.Results[len(m.Results)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PessimisticRollbackRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PessimisticRollbackRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PessimisticRollbackRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForUpdateTs", wireType)
			}
			m.ForUpdateTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForUpdateTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PessimisticRollbackResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PessimisticRollbackResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PessimisticRollbackResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &KeyError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnHeartBeatRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnHeartBeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnHeartBeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryLock", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryLock = append(m.PrimaryLock[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryLock == nil {
				m.PrimaryLock = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdviseLockTtl", wireType)
			}
			m.AdviseLockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AdviseLockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnHeartBeatResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnHeartBeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnHeartBeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTtl", wireType)
			}
			m.LockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckTxnStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckTxnStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckTxnStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryKey = append(m.PrimaryKey[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryKey == nil {
				m.PrimaryKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTs", wireType)
			}
			m.LockTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CallerStartTs", wireType)
			}
			m.CallerStartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CallerStartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentTs", wireType)
			}
			m.CurrentTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RollbackIfNotExist", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RollbackIfNotExist = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForceSyncCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForceSyncCommit = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvingPessimisticLock", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ResolvingPessimisticLock = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckTxnStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckTxnStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckTxnStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTtl", wireType)
			}
			m.LockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= Action(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LockInfo == nil {
				m.LockInfo = &LockInfo{}
			}
			if err := m.LockInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckSecondaryLocksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckSecondaryLocksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckSecondaryLocksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckSecondaryLocksResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckSecondaryLocksResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckSecondaryLocksResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locks = append(m.Locks, &LockInfo{})
			if err := m.Locks[len(m.Locks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTs", wireType)
			}
			m.CommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mutations = append(m.Mutations, &Mutation{})
			if err := m.Mutations[len(m.Mutations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CleanupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CleanupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CleanupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentTs", wireType)
			}
			m.CurrentTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CleanupResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CleanupResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CleanupResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchGetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchGetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchGetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchGetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchGetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchGetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pairs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pairs = append(m.Pairs, &KvPair{})
			if err := m.Pairs[len(m.Pairs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchRollbackRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchRollbackRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchRollbackRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchRollbackResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchRollbackResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchRollbackResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanLockRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanLockRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanLockRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxVersion", wireType)
			}
			m.MaxVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanLockResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanLockResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanLockResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locks = append(m.Locks, &LockInfo{})
			if err := m.Locks[len(m.Locks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveLockRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveLockRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveLockRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitVersion", wireType)
			}
			m.CommitVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxnInfos = append(m.TxnInfos, &TxnInfo{})
			if err := m.TxnInfos[len(m.TxnInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveLockResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveLockResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveLockResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecDetailsV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecDetailsV2 == nil {
				m.ExecDetailsV2 = &ExecDetailsV2{}
			}
			if err := m.ExecDetailsV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SafePoint", wireType)
			}
			m.SafePoint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SafePoint |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotifyOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotifyOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrepareFlashbackToVersionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrepareFlashbackToVersionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrepareFlashbackToVersionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrepareFlashbackToVersionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrepareFlashbackToVersionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrepareFlashbackToVersionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlashbackToVersionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlashbackToVersionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlashbackToVersionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTs", wireType)
			}
			m.CommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlashbackToVersionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlashbackToVersionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlashbackToVersionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawGetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawGetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawGetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawGetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawGetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawGetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotFound", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotFound = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchGetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchGetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchGetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchGetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchGetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchGetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pairs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pairs = append(m.Pairs, &KvPair{})
			if err := m.Pairs[len(m.Pairs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForCas", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForCas = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pairs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pairs = append(m.Pairs, &KvPair{})
			if err := m.Pairs[len(m.Pairs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForCas", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForCas = bool(v != 0)
		case 6:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Ttls = append(m.Ttls, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Ttls) == 0 {
					m.Ttls = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Ttls = append(m.Ttls, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttls", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawDeleteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawDeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawDeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForCas", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForCas = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawDeleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawDeleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawDeleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchDeleteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchDeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchDeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForCas", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForCas = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchDeleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchDeleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchDeleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KeyOnly = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kvs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kvs = append(m.Kvs, &KvPair{})
			if err := m.Kvs[len(m.Kvs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawDeleteRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawDeleteRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawDeleteRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawDeleteRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawDeleteRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawDeleteRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, &KeyRange{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EachLimit", wireType)
			}
			m.EachLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EachLimit |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.KeyOnly = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawBatchScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawBatchScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawBatchScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kvs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kvs = append(m.Kvs, &KvPair{})
			if err := m.Kvs[len(m.Kvs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsafeDestroyRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsafeDestroyRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsafeDestroyRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsafeDestroyRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsafeDestroyRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsafeDestroyRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterLockObserverRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterLockObserverRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterLockObserverRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTs", wireType)
			}
			m.MaxTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegisterLockObserverResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegisterLockObserverResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegisterLockObserverResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckLockObserverRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckLockObserverRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckLockObserverRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTs", wireType)
			}
			m.MaxTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckLockObserverResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckLockObserverResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckLockObserverResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsClean", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsClean = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locks = append(m.Locks, &LockInfo{})
			if err := m.Locks[len(m.Locks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveLockObserverRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveLockObserverRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveLockObserverRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTs", wireType)
			}
			m.MaxTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoveLockObserverResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoveLockObserverResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoveLockObserverResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PhysicalScanLockRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PhysicalScanLockRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PhysicalScanLockRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTs", wireType)
			}
			m.MaxTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PhysicalScanLockResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PhysicalScanLockResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PhysicalScanLockResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Locks = append(m.Locks, &LockInfo{})
			if err := m.Locks[len(m.Locks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplitRegionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplitRegionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplitRegionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SplitKey = append(m.SplitKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SplitKey == nil {
				m.SplitKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitKeys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SplitKeys = append(m.SplitKeys, make([]byte, postIndex-iNdEx))
			copy(m.SplitKeys[len(m.SplitKeys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRawKv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRawKv = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplitRegionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplitRegionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplitRegionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Left", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Left == nil {
				m.Left = &metapb.Region{}
			}
			if err := m.Left.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Right", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Right == nil {
				m.Right = &metapb.Region{}
			}
			if err := m.Right.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Regions = append(m.Regions, &metapb.Region{})
			if err := m.Regions[len(m.Regions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadIndexRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadIndexRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadIndexRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, &KeyRange{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadIndexResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadIndexResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadIndexResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadIndex", wireType)
			}
			m.ReadIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locked == nil {
				m.Locked = &LockInfo{}
			}
			if err := m.Locked.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccGetByKeyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccGetByKeyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccGetByKeyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccGetByKeyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccGetByKeyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccGetByKeyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &MvccInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccGetByStartTsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccGetByStartTsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccGetByStartTsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccGetByStartTsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccGetByStartTsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccGetByStartTsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &MvccInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Context) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Context: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Context: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionEpoch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionEpoch == nil {
				m.RegionEpoch = &metapb.RegionEpoch{}
			}
			if err := m.RegionEpoch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Peer == nil {
				m.Peer = &metapb.Peer{}
			}
			if err := m.Peer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= CommandPri(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsolationLevel", wireType)
			}
			m.IsolationLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IsolationLevel |= IsolationLevel(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotFillCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotFillCache = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncLog", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SyncLog = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordTimeStat", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RecordTimeStat = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecordScanStat", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RecordScanStat = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaRead", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReplicaRead = bool(v != 0)
		case 13:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ResolvedLocks = append(m.ResolvedLocks, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.ResolvedLocks) == 0 {
					m.ResolvedLocks = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ResolvedLocks = append(m.ResolvedLocks, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolvedLocks", wireType)
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxExecutionDurationMs", wireType)
			}
			m.MaxExecutionDurationMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxExecutionDurationMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedIndex", wireType)
			}
			m.AppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AppliedIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskId", wireType)
			}
			m.TaskId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TaskId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaleRead", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StaleRead = bool(v != 0)
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceGroupTag", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceGroupTag = append(m.ResourceGroupTag[:0], dAtA[iNdEx:postIndex]...)
			if m.ResourceGroupTag == nil {
				m.ResourceGroupTag = []byte{}
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskFullOpt", wireType)
			}
			m.DiskFullOpt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DiskFullOpt |= DiskFullOpt(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRetryRequest", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRetryRequest = bool(v != 0)
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiVersion", wireType)
			}
			m.ApiVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApiVersion |= APIVersion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 22:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.CommittedLocks = append(m.CommittedLocks, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.CommittedLocks) == 0 {
					m.CommittedLocks = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.CommittedLocks = append(m.CommittedLocks, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field CommittedLocks", wireType)
			}
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TraceContext == nil {
				m.TraceContext = &tracepb.TraceContext{}
			}
			if err := m.TraceContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSource", wireType)
			}
			m.TxnSource = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxnSource |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LockInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LockInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LockInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryLock", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryLock = append(m.PrimaryLock[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryLock == nil {
				m.PrimaryLock = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockVersion", wireType)
			}
			m.LockVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockVersion |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTtl", wireType)
			}
			m.LockTtl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTtl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSize", wireType)
			}
			m.TxnSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxnSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockType", wireType)
			}
			m.LockType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockType |= Op(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockForUpdateTs", wireType)
			}
			m.LockForUpdateTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockForUpdateTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseAsyncCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseAsyncCommit = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinCommitTs", wireType)
			}
			m.MinCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secondaries", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secondaries = append(m.Secondaries, make([]byte, postIndex-iNdEx))
			copy(m.Secondaries[len(m.Secondaries)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locked == nil {
				m.Locked = &LockInfo{}
			}
			if err := m.Locked.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retryable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Retryable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Abort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Abort = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Conflict", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Conflict == nil {
				m.Conflict = &WriteConflict{}
			}
			if err := m.Conflict.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlreadyExist", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlreadyExist == nil {
				m.AlreadyExist = &AlreadyExist{}
			}
			if err := m.AlreadyExist.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deadlock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deadlock == nil {
				m.Deadlock = &Deadlock{}
			}
			if err := m.Deadlock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTsExpired", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommitTsExpired == nil {
				m.CommitTsExpired = &CommitTsExpired{}
			}
			if err := m.CommitTsExpired.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxnNotFound == nil {
				m.TxnNotFound = &TxnNotFound{}
			}
			if err := m.TxnNotFound.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTsTooLarge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommitTsTooLarge == nil {
				m.CommitTsTooLarge = &CommitTsTooLarge{}
			}
			if err := m.CommitTsTooLarge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AssertionFailed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AssertionFailed == nil {
				m.AssertionFailed = &AssertionFailed{}
			}
			if err := m.AssertionFailed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteConflict) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteConflict: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteConflict: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConflictTs", wireType)
			}
			m.ConflictTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConflictTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primary", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Primary = append(m.Primary[:0], dAtA[iNdEx:postIndex]...)
			if m.Primary == nil {
				m.Primary = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConflictCommitTs", wireType)
			}
			m.ConflictCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConflictCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= WriteConflict_Reason(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AlreadyExist) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlreadyExist: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlreadyExist: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deadlock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deadlock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deadlock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockTs", wireType)
			}
			m.LockTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LockTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LockKey = append(m.LockKey[:0], dAtA[iNdEx:postIndex]...)
			if m.LockKey == nil {
				m.LockKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeadlockKeyHash", wireType)
			}
			m.DeadlockKeyHash = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DeadlockKeyHash |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.WaitChain = append(m.WaitChain, &deadlock.WaitForEntry{})
			if err := m.WaitChain[len(m.WaitChain)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitTsExpired) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitTsExpired: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitTsExpired: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttemptedCommitTs", wireType)
			}
			m.AttemptedCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AttemptedCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinCommitTs", wireType)
			}
			m.MinCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnNotFound) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnNotFound: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnNotFound: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrimaryKey = append(m.PrimaryKey[:0], dAtA[iNdEx:postIndex]...)
			if m.PrimaryKey == nil {
				m.PrimaryKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommitTsTooLarge) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommitTsTooLarge: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommitTsTooLarge: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTs", wireType)
			}
			m.CommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssertionFailed) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssertionFailed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssertionFailed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assertion", wireType)
			}
			m.Assertion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Assertion |= Assertion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExistingStartTs", wireType)
			}
			m.ExistingStartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExistingStartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExistingCommitTs", wireType)
			}
			m.ExistingCommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExistingCommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitWallTimeMs", wireType)
			}
			m.WaitWallTimeMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.WaitWallTimeMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessWallTimeMs", wireType)
			}
			m.ProcessWallTimeMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessWallTimeMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KvReadWallTimeMs", wireType)
			}
			m.KvReadWallTimeMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KvReadWallTimeMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRpcWallTimeNs", wireType)
			}
			m.TotalRpcWallTimeNs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRpcWallTimeNs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processed", wireType)
			}
			m.Processed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Processed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadBytes", wireType)
			}
			m.ReadBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Write", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Write == nil {
				m.Write = &ScanInfo{}
			}
			if err := m.Write.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lock == nil {
				m.Lock = &ScanInfo{}
			}
			if err := m.Lock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &ScanInfo{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanDetailV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanDetailV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanDetailV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessedVersions", wireType)
			}
			m.ProcessedVersions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessedVersions |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalVersions", wireType)
			}
			m.TotalVersions = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalVersions |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbDeleteSkippedCount", wireType)
			}
			m.RocksdbDeleteSkippedCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbDeleteSkippedCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbKeySkippedCount", wireType)
			}
			m.RocksdbKeySkippedCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbKeySkippedCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbBlockCacheHitCount", wireType)
			}
			m.RocksdbBlockCacheHitCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbBlockCacheHitCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbBlockReadCount", wireType)
			}
			m.RocksdbBlockReadCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbBlockReadCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbBlockReadByte", wireType)
			}
			m.RocksdbBlockReadByte = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbBlockReadByte |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessedVersionsSize", wireType)
			}
			m.ProcessedVersionsSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessedVersionsSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RocksdbBlockReadNanos", wireType)
			}
			m.RocksdbBlockReadNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RocksdbBlockReadNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GetSnapshotNanos", wireType)
			}
			m.GetSnapshotNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GetSnapshotNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadIndexProposeWaitNanos", wireType)
			}
			m.ReadIndexProposeWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadIndexProposeWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadIndexConfirmWaitNanos", wireType)
			}
			m.ReadIndexConfirmWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadIndexConfirmWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadPoolScheduleWaitNanos", wireType)
			}
			m.ReadPoolScheduleWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadPoolScheduleWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecDetails) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecDetails: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecDetails: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeDetail == nil {
				m.TimeDetail = &TimeDetail{}
			}
			if err := m.TimeDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanDetail == nil {
				m.ScanDetail = &ScanDetail{}
			}
			if err := m.ScanDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExecDetailsV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExecDetailsV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExecDetailsV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeDetail == nil {
				m.TimeDetail = &TimeDetail{}
			}
			if err := m.TimeDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanDetailV2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ScanDetailV2 == nil {
				m.ScanDetailV2 = &ScanDetailV2{}
			}
			if err := m.ScanDetailV2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteDetail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteDetail == nil {
				m.WriteDetail = &WriteDetail{}
			}
			if err := m.WriteDetail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreBatchWaitNanos", wireType)
			}
			m.StoreBatchWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreBatchWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposeSendWaitNanos", wireType)
			}
			m.ProposeSendWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProposeSendWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PersistLogNanos", wireType)
			}
			m.PersistLogNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PersistLogNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftDbWriteLeaderWaitNanos", wireType)
			}
			m.RaftDbWriteLeaderWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftDbWriteLeaderWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftDbSyncLogNanos", wireType)
			}
			m.RaftDbSyncLogNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftDbSyncLogNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftDbWriteMemtableNanos", wireType)
			}
			m.RaftDbWriteMemtableNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftDbWriteMemtableNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitLogNanos", wireType)
			}
			m.CommitLogNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitLogNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyBatchWaitNanos", wireType)
			}
			m.ApplyBatchWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyBatchWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyLogNanos", wireType)
			}
			m.ApplyLogNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyLogNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyMutexLockNanos", wireType)
			}
			m.ApplyMutexLockNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyMutexLockNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyWriteLeaderWaitNanos", wireType)
			}
			m.ApplyWriteLeaderWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyWriteLeaderWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyWriteWalNanos", wireType)
			}
			m.ApplyWriteWalNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyWriteWalNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplyWriteMemtableNanos", wireType)
			}
			m.ApplyWriteMemtableNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApplyWriteMemtableNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatchWaitNanos", wireType)
			}
			m.LatchWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LatchWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessNanos", wireType)
			}
			m.ProcessNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProcessNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ThrottleNanos", wireType)
			}
			m.ThrottleNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ThrottleNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PessimisticLockWaitNanos", wireType)
			}
			m.PessimisticLockWaitNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PessimisticLockWaitNanos |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KvPair) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KvPair: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KvPair: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &KeyError{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Mutation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Mutation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Mutation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= Op(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assertion", wireType)
			}
			m.Assertion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Assertion |= Assertion(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccWrite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccWrite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccWrite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= Op(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitTs", wireType)
			}
			m.CommitTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommitTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortValue = append(m.ShortValue[:0], dAtA[iNdEx:postIndex]...)
			if m.ShortValue == nil {
				m.ShortValue = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasOverlappedRollback", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasOverlappedRollback = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasGcFence", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasGcFence = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GcFence", wireType)
			}
			m.GcFence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GcFence |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastChangeTs", wireType)
			}
			m.LastChangeTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastChangeTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionsToLastChange", wireType)
			}
			m.VersionsToLastChange = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VersionsToLastChange |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccLock) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccLock: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccLock: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= Op(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primary", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Primary = append(m.Primary[:0], dAtA[iNdEx:postIndex]...)
			if m.Primary == nil {
				m.Primary = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortValue = append(m.ShortValue[:0], dAtA[iNdEx:postIndex]...)
			if m.ShortValue == nil {
				m.ShortValue = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForUpdateTs", wireType)
			}
			m.ForUpdateTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ForUpdateTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSize", wireType)
			}
			m.TxnSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxnSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseAsyncCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseAsyncCommit = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secondaries", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secondaries = append(m.Secondaries, make([]byte, postIndex-iNdEx))
			copy(m.Secondaries[len(m.Secondaries)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RollbackTs = append(m.RollbackTs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.RollbackTs) == 0 {
					m.RollbackTs = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RollbackTs = append(m.RollbackTs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RollbackTs", wireType)
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastChangeTs", wireType)
			}
			m.LastChangeTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastChangeTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionsToLastChange", wireType)
			}
			m.VersionsToLastChange = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.VersionsToLastChange |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MvccInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MvccInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MvccInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lock", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lock == nil {
				m.Lock = &MvccLock{}
			}
			if err := m.Lock.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Writes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Writes = append(m.Writes, &MvccWrite{})
			if err := m.Writes[len(m.Writes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, &MvccValue{})
			if err := m.Values[len(m.Values)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			m.Txn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Txn |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaderInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaderInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaderInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			m.RegionId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RegionId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerId", wireType)
			}
			m.PeerId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeerId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionEpoch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionEpoch == nil {
				m.RegionEpoch = &metapb.RegionEpoch{}
			}
			if err := m.RegionEpoch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadState == nil {
				m.ReadState = &ReadState{}
			}
			if err := m.ReadState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliedIndex", wireType)
			}
			m.AppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AppliedIndex |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SafeTs", wireType)
			}
			m.SafeTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SafeTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckLeaderRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckLeaderRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckLeaderRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Regions = append(m.Regions, &LeaderInfo{})
			if err := m.Regions[len(m.Regions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ts", wireType)
			}
			m.Ts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ts |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckLeaderResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckLeaderResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckLeaderResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Regions = append(m.Regions, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKvrpcpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthKvrpcpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Regions) == 0 {
					m.Regions = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKvrpcpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Regions = append(m.Regions, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Regions", wireType)
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ts", wireType)
			}
			m.Ts = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ts |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreSafeTSRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreSafeTSRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreSafeTSRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KeyRange == nil {
				m.KeyRange = &KeyRange{}
			}
			if err := m.KeyRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreSafeTSResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreSafeTSResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreSafeTSResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SafeTs", wireType)
			}
			m.SafeTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SafeTs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawGetKeyTTLRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawGetKeyTTLRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawGetKeyTTLRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawGetKeyTTLResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawGetKeyTTLResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawGetKeyTTLResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotFound", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NotFound = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawCASRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawCASRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawCASRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousNotExist", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PreviousNotExist = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PreviousValue = append(m.PreviousValue[:0], dAtA[iNdEx:postIndex]...)
			if m.PreviousValue == nil {
				m.PreviousValue = []byte{}
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawCASResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawCASResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawCASResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RegionError == nil {
				m.RegionError = &errorpb.Error{}
			}
			if err := m.RegionError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Succeed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Succeed = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousNotExist", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PreviousNotExist = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PreviousValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PreviousValue = append(m.PreviousValue[:0], dAtA[iNdEx:postIndex]...)
			if m.PreviousValue == nil {
				m.PreviousValue = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKvrpcpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetLockWaitInfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKvrpcpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetLockWaitInfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetLockWaitInfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKvrpcpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKvrpcpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Context == nil {
				m.Context = &Context{}
			}
			if err := m.Context.Unmarshal(dAtA[iNdEx:postIndex]); err !=