// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: keyspacepb.proto

package keyspacepb

import (
	"context"
	"fmt"
	"io"
	"math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	pdpb "github.com/pingcap/kvproto/pkg/pdpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type KeyspaceState int32

const (
	KeyspaceState_ENABLED  KeyspaceState = 0
	KeyspaceState_DISABLED KeyspaceState = 1
	KeyspaceState_ARCHIVED KeyspaceState = 2
)

var KeyspaceState_name = map[int32]string{
	0: "ENABLED",
	1: "DISABLED",
	2: "ARCHIVED",
}

var KeyspaceState_value = map[string]int32{
	"ENABLED":  0,
	"DISABLED": 1,
	"ARCHIVED": 2,
}

func (x KeyspaceState) String() string {
	return proto.EnumName(KeyspaceState_name, int32(x))
}

func (KeyspaceState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{0}
}

type KeyspaceMeta struct {
	Id                   uint32            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Name                 string            `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	State                KeyspaceState     `protobuf:"varint,3,opt,name=state,proto3,enum=keyspacepb.KeyspaceState" json:"state,omitempty"`
	CreatedAt            int64             `protobuf:"varint,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	StateChangedAt       int64             `protobuf:"varint,5,opt,name=state_changed_at,json=stateChangedAt,proto3" json:"state_changed_at,omitempty"`
	Config               map[string]string `protobuf:"bytes,7,rep,name=config,proto3" json:"config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *KeyspaceMeta) Reset()         { *m = KeyspaceMeta{} }
func (m *KeyspaceMeta) String() string { return proto.CompactTextString(m) }
func (*KeyspaceMeta) ProtoMessage()    {}
func (*KeyspaceMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{0}
}
func (m *KeyspaceMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyspaceMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyspaceMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyspaceMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyspaceMeta.Merge(m, src)
}
func (m *KeyspaceMeta) XXX_Size() int {
	return m.Size()
}
func (m *KeyspaceMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyspaceMeta.DiscardUnknown(m)
}

var xxx_messageInfo_KeyspaceMeta proto.InternalMessageInfo

func (m *KeyspaceMeta) GetId() uint32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *KeyspaceMeta) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *KeyspaceMeta) GetState() KeyspaceState {
	if m != nil {
		return m.State
	}
	return KeyspaceState_ENABLED
}

func (m *KeyspaceMeta) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *KeyspaceMeta) GetStateChangedAt() int64 {
	if m != nil {
		return m.StateChangedAt
	}
	return 0
}

func (m *KeyspaceMeta) GetConfig() map[string]string {
	if m != nil {
		return m.Config
	}
	return nil
}

type LoadKeyspaceRequest struct {
	Header               *pdpb.RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Name                 string              `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *LoadKeyspaceRequest) Reset()         { *m = LoadKeyspaceRequest{} }
func (m *LoadKeyspaceRequest) String() string { return proto.CompactTextString(m) }
func (*LoadKeyspaceRequest) ProtoMessage()    {}
func (*LoadKeyspaceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{1}
}
func (m *LoadKeyspaceRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadKeyspaceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadKeyspaceRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadKeyspaceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadKeyspaceRequest.Merge(m, src)
}
func (m *LoadKeyspaceRequest) XXX_Size() int {
	return m.Size()
}
func (m *LoadKeyspaceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadKeyspaceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LoadKeyspaceRequest proto.InternalMessageInfo

func (m *LoadKeyspaceRequest) GetHeader() *pdpb.RequestHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *LoadKeyspaceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type LoadKeyspaceResponse struct {
	Header               *pdpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Keyspace             *KeyspaceMeta        `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LoadKeyspaceResponse) Reset()         { *m = LoadKeyspaceResponse{} }
func (m *LoadKeyspaceResponse) String() string { return proto.CompactTextString(m) }
func (*LoadKeyspaceResponse) ProtoMessage()    {}
func (*LoadKeyspaceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{2}
}
func (m *LoadKeyspaceResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadKeyspaceResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadKeyspaceResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadKeyspaceResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadKeyspaceResponse.Merge(m, src)
}
func (m *LoadKeyspaceResponse) XXX_Size() int {
	return m.Size()
}
func (m *LoadKeyspaceResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadKeyspaceResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LoadKeyspaceResponse proto.InternalMessageInfo

func (m *LoadKeyspaceResponse) GetHeader() *pdpb.ResponseHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *LoadKeyspaceResponse) GetKeyspace() *KeyspaceMeta {
	if m != nil {
		return m.Keyspace
	}
	return nil
}

type WatchKeyspacesRequest struct {
	Header               *pdpb.RequestHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *WatchKeyspacesRequest) Reset()         { *m = WatchKeyspacesRequest{} }
func (m *WatchKeyspacesRequest) String() string { return proto.CompactTextString(m) }
func (*WatchKeyspacesRequest) ProtoMessage()    {}
func (*WatchKeyspacesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{3}
}
func (m *WatchKeyspacesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchKeyspacesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchKeyspacesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchKeyspacesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchKeyspacesRequest.Merge(m, src)
}
func (m *WatchKeyspacesRequest) XXX_Size() int {
	return m.Size()
}
func (m *WatchKeyspacesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchKeyspacesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WatchKeyspacesRequest proto.InternalMessageInfo

func (m *WatchKeyspacesRequest) GetHeader() *pdpb.RequestHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

type WatchKeyspacesResponse struct {
	Header               *pdpb.ResponseHeader `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	Keyspaces            []*KeyspaceMeta      `protobuf:"bytes,2,rep,name=keyspaces,proto3" json:"keyspaces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WatchKeyspacesResponse) Reset()         { *m = WatchKeyspacesResponse{} }
func (m *WatchKeyspacesResponse) String() string { return proto.CompactTextString(m) }
func (*WatchKeyspacesResponse) ProtoMessage()    {}
func (*WatchKeyspacesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c5d91f3e5071166, []int{4}
}
func (m *WatchKeyspacesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchKeyspacesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchKeyspacesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchKeyspacesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchKeyspacesResponse.Merge(m, src)
}
func (m *WatchKeyspacesResponse) XXX_Size() int {
	return m.Size()
}
func (m *WatchKeyspacesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchKeyspacesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WatchKeyspacesResponse proto.InternalMessageInfo

func (m *WatchKeyspacesResponse) GetHeader() *pdpb.ResponseHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *WatchKeyspacesResponse) GetKeyspaces() []*KeyspaceMeta {
	if m != nil {
		return m.Keyspaces
	}
	return nil
}

func init() {
	proto.RegisterEnum("keyspacepb.KeyspaceState", KeyspaceState_name, KeyspaceState_value)
	proto.RegisterType((*KeyspaceMeta)(nil), "keyspacepb.KeyspaceMeta")
	proto.RegisterMapType((map[string]string)(nil), "keyspacepb.KeyspaceMeta.ConfigEntry")
	proto.RegisterType((*LoadKeyspaceRequest)(nil), "keyspacepb.LoadKeyspaceRequest")
	proto.RegisterType((*LoadKeyspaceResponse)(nil), "keyspacepb.LoadKeyspaceResponse")
	proto.RegisterType((*WatchKeyspacesRequest)(nil), "keyspacepb.WatchKeyspacesRequest")
	proto.RegisterType((*WatchKeyspacesResponse)(nil), "keyspacepb.WatchKeyspacesResponse")
}

func init() { proto.RegisterFile("keyspacepb.proto", fileDescriptor_5c5d91f3e5071166) }

var fileDescriptor_5c5d91f3e5071166 = []byte{
	// 509 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xcd, 0x3a, 0x4d, 0x9a, 0x8c, 0xd3, 0x60, 0x6d, 0x03, 0x32, 0x96, 0x08, 0xc6, 0x42, 0xc8,
	0x02, 0xe4, 0x22, 0x83, 0x50, 0x41, 0x5c, 0xd2, 0x24, 0x52, 0x2b, 0x0a, 0x87, 0x8d, 0x54, 0x0e,
	0x1c, 0xaa, 0xad, 0xbd, 0x38, 0x51, 0xc0, 0x36, 0xf6, 0x26, 0x52, 0x38, 0xf0, 0x1d, 0xfc, 0x00,
	0x12, 0x1f, 0xc1, 0x07, 0x70, 0xe4, 0xc8, 0x11, 0x85, 0x1f, 0x41, 0x5e, 0x7b, 0xa9, 0x13, 0x25,
	0x1c, 0x7a, 0xca, 0xcc, 0x9b, 0x37, 0x6f, 0xf6, 0xcd, 0xc4, 0xa0, 0x4d, 0xd9, 0x22, 0x8d, 0xa9,
	0xc7, 0xe2, 0x0b, 0x27, 0x4e, 0x22, 0x1e, 0x61, 0xb8, 0x44, 0x0c, 0x88, 0x7d, 0x89, 0x1b, 0x9d,
	0x20, 0x0a, 0x22, 0x11, 0x1e, 0x64, 0x51, 0x81, 0x5e, 0x4b, 0x66, 0x29, 0x17, 0x61, 0x0e, 0x58,
	0x5f, 0x15, 0x68, 0xbd, 0x2c, 0x14, 0x5e, 0x31, 0x4e, 0x71, 0x1b, 0x94, 0x89, 0xaf, 0x23, 0x13,
	0xd9, 0x7b, 0x44, 0x99, 0xf8, 0x18, 0xc3, 0x4e, 0x48, 0x3f, 0x30, 0x5d, 0x31, 0x91, 0xdd, 0x24,
	0x22, 0xc6, 0x07, 0x50, 0x4b, 0x39, 0xe5, 0x4c, 0xaf, 0x9a, 0xc8, 0x6e, 0xbb, 0x37, 0x9d, 0xd2,
	0xab, 0xa4, 0xd8, 0x28, 0x23, 0x90, 0x9c, 0x87, 0x6f, 0x01, 0x78, 0x09, 0xa3, 0x9c, 0xf9, 0xe7,
	0x94, 0xeb, 0x3b, 0x26, 0xb2, 0xab, 0xa4, 0x59, 0x20, 0x3d, 0x8e, 0x6d, 0xd0, 0x04, 0xef, 0xdc,
	0x1b, 0xd3, 0x30, 0xc8, 0x49, 0x35, 0x41, 0x6a, 0x0b, 0xbc, 0x9f, 0xc3, 0x3d, 0x8e, 0x5f, 0x40,
	0xdd, 0x8b, 0xc2, 0x77, 0x93, 0x40, 0xdf, 0x35, 0xab, 0xb6, 0xea, 0xde, 0xdd, 0x34, 0x3a, 0xf3,
	0xe1, 0xf4, 0x05, 0x6d, 0x18, 0xf2, 0x64, 0x41, 0x8a, 0x1e, 0xe3, 0x19, 0xa8, 0x25, 0x18, 0x6b,
	0x50, 0x9d, 0xb2, 0x85, 0xf0, 0xda, 0x24, 0x59, 0x88, 0x3b, 0x50, 0x9b, 0xd3, 0xf7, 0x33, 0xe9,
	0x36, 0x4f, 0x9e, 0x2b, 0x87, 0xc8, 0x3a, 0x83, 0xfd, 0xd3, 0x88, 0xfa, 0x72, 0x04, 0x61, 0x1f,
	0x67, 0x2c, 0xe5, 0xf8, 0x01, 0xd4, 0xc7, 0x8c, 0xfa, 0x2c, 0x11, 0x2a, 0xaa, 0xbb, 0xef, 0x88,
	0x13, 0x14, 0xe5, 0x63, 0x51, 0x22, 0x05, 0x65, 0xd3, 0x2a, 0xad, 0x4f, 0xd0, 0x59, 0xd5, 0x4d,
	0xe3, 0x28, 0x4c, 0x19, 0x7e, 0xb8, 0x26, 0xdc, 0x91, 0xc2, 0x79, 0x7d, 0x4d, 0xf9, 0x09, 0x34,
	0xe4, 0x1e, 0x84, 0xba, 0xea, 0xea, 0xdb, 0x16, 0x43, 0xfe, 0x31, 0xad, 0x01, 0x5c, 0x7f, 0x43,
	0xb9, 0x37, 0x96, 0xe5, 0xf4, 0x2a, 0xae, 0xac, 0xcf, 0x70, 0x63, 0x5d, 0xe5, 0x4a, 0x1e, 0x9e,
	0x42, 0x53, 0xbe, 0x2c, 0xd5, 0x15, 0x71, 0xdd, 0xed, 0x26, 0x2e, 0xa9, 0xf7, 0x0f, 0x61, 0x6f,
	0xe5, 0x3f, 0x87, 0x55, 0xd8, 0x1d, 0xbe, 0xee, 0x1d, 0x9d, 0x0e, 0x07, 0x5a, 0x05, 0xb7, 0xa0,
	0x31, 0x38, 0x19, 0xe5, 0x19, 0xca, 0xb2, 0x1e, 0xe9, 0x1f, 0x9f, 0x9c, 0x0d, 0x07, 0x9a, 0xe2,
	0x7e, 0x47, 0xd0, 0x90, 0xad, 0x78, 0x04, 0xad, 0xf2, 0x21, 0xf0, 0xed, 0xf2, 0xec, 0x0d, 0xa7,
	0x37, 0xcc, 0xed, 0x84, 0xdc, 0x9f, 0x55, 0xc1, 0x6f, 0xa1, 0xbd, 0xba, 0x1b, 0x7c, 0xa7, 0xdc,
	0xb5, 0x71, 0xfb, 0x86, 0xf5, 0x3f, 0x8a, 0x94, 0x7e, 0x84, 0x8e, 0xee, 0xfd, 0xfa, 0xd6, 0x40,
	0x3f, 0x96, 0x5d, 0xf4, 0x73, 0xd9, 0x45, 0xbf, 0x97, 0x5d, 0xf4, 0xe5, 0x4f, 0xb7, 0x02, 0x5a,
	0x94, 0x04, 0x0e, 0x9f, 0x4c, 0xe7, 0xce, 0x74, 0x2e, 0x3e, 0xf1, 0x8b, 0xba, 0xf8, 0x79, 0xfc,
	0x37, 0x00, 0x00, 0xff, 0xff, 0x4e, 0xd8, 0x06, 0xef, 0x3c, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// KeyspaceClient is the client API for Keyspace service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type KeyspaceClient interface {
	LoadKeyspace(ctx context.Context, in *LoadKeyspaceRequest, opts ...grpc.CallOption) (*LoadKeyspaceResponse, error)
	// WatchKeyspaces first return all current keyspaces' metadata as its first response.
	// Then, it returns responses containing keyspaces that had their metadata changed.
	WatchKeyspaces(ctx context.Context, in *WatchKeyspacesRequest, opts ...grpc.CallOption) (Keyspace_WatchKeyspacesClient, error)
}

type keyspaceClient struct {
	cc *grpc.ClientConn
}

func NewKeyspaceClient(cc *grpc.ClientConn) KeyspaceClient {
	return &keyspaceClient{cc}
}

func (c *keyspaceClient) LoadKeyspace(ctx context.Context, in *LoadKeyspaceRequest, opts ...grpc.CallOption) (*LoadKeyspaceResponse, error) {
	out := new(LoadKeyspaceResponse)
	err := c.cc.Invoke(ctx, "/keyspacepb.Keyspace/LoadKeyspace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyspaceClient) WatchKeyspaces(ctx context.Context, in *WatchKeyspacesRequest, opts ...grpc.CallOption) (Keyspace_WatchKeyspacesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Keyspace_serviceDesc.Streams[0], "/keyspacepb.Keyspace/WatchKeyspaces", opts...)
	if err != nil {
		return nil, err
	}
	x := &keyspaceWatchKeyspacesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Keyspace_WatchKeyspacesClient interface {
	Recv() (*WatchKeyspacesResponse, error)
	grpc.ClientStream
}

type keyspaceWatchKeyspacesClient struct {
	grpc.ClientStream
}

func (x *keyspaceWatchKeyspacesClient) Recv() (*WatchKeyspacesResponse, error) {
	m := new(WatchKeyspacesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// KeyspaceServer is the server API for Keyspace service.
type KeyspaceServer interface {
	LoadKeyspace(context.Context, *LoadKeyspaceRequest) (*LoadKeyspaceResponse, error)
	// WatchKeyspaces first return all current keyspaces' metadata as its first response.
	// Then, it returns responses containing keyspaces that had their metadata changed.
	WatchKeyspaces(*WatchKeyspacesRequest, Keyspace_WatchKeyspacesServer) error
}

// UnimplementedKeyspaceServer can be embedded to have forward compatible implementations.
type UnimplementedKeyspaceServer struct {
}

func (*UnimplementedKeyspaceServer) LoadKeyspace(ctx context.Context, req *LoadKeyspaceRequest) (*LoadKeyspaceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadKeyspace not implemented")
}
func (*UnimplementedKeyspaceServer) WatchKeyspaces(req *WatchKeyspacesRequest, srv Keyspace_WatchKeyspacesServer) error {
	return status.Errorf(codes.Unimplemented, "method WatchKeyspaces not implemented")
}

func RegisterKeyspaceServer(s *grpc.Server, srv KeyspaceServer) {
	s.RegisterService(&_Keyspace_serviceDesc, srv)
}

func _Keyspace_LoadKeyspace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadKeyspaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyspaceServer).LoadKeyspace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/keyspacepb.Keyspace/LoadKeyspace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyspaceServer).LoadKeyspace(ctx, req.(*LoadKeyspaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Keyspace_WatchKeyspaces_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchKeyspacesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(KeyspaceServer).WatchKeyspaces(m, &keyspaceWatchKeyspacesServer{stream})
}

type Keyspace_WatchKeyspacesServer interface {
	Send(*WatchKeyspacesResponse) error
	grpc.ServerStream
}

type keyspaceWatchKeyspacesServer struct {
	grpc.ServerStream
}

func (x *keyspaceWatchKeyspacesServer) Send(m *WatchKeyspacesResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Keyspace_serviceDesc = grpc.ServiceDesc{
	ServiceName: "keyspacepb.Keyspace",
	HandlerType: (*KeyspaceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LoadKeyspace",
			Handler:    _Keyspace_LoadKeyspace_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WatchKeyspaces",
			Handler:       _Keyspace_WatchKeyspaces_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "keyspacepb.proto",
}

func (m *KeyspaceMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyspaceMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyspaceMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Config) > 0 {
		for k := range m.Config {
			v := m.Config[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintKeyspacepb(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintKeyspacepb(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintKeyspacepb(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.StateChangedAt != 0 {
		i = encodeVarintKeyspacepb(dAtA, i, uint64(m.StateChangedAt))
		i--
		dAtA[i] = 0x28
	}
	if m.CreatedAt != 0 {
		i = encodeVarintKeyspacepb(dAtA, i, uint64(m.CreatedAt))
		i--
		dAtA[i] = 0x20
	}
	if m.State != 0 {
		i = encodeVarintKeyspacepb(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintKeyspacepb(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.Id != 0 {
		i = encodeVarintKeyspacepb(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LoadKeyspaceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadKeyspaceRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadKeyspaceRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintKeyspacepb(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LoadKeyspaceResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadKeyspaceResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadKeyspaceResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Keyspace != nil {
		{
			size, err := m.Keyspace.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WatchKeyspacesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchKeyspacesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WatchKeyspacesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *WatchKeyspacesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchKeyspacesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WatchKeyspacesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Keyspaces) > 0 {
		for iNdEx := len(m.Keyspaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Keyspaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Header != nil {
		{
			size, err := m.Header.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintKeyspacepb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintKeyspacepb(dAtA []byte, offset int, v uint64) int {
	offset -= sovKeyspacepb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *KeyspaceMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovKeyspacepb(uint64(m.Id))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if m.State != 0 {
		n += 1 + sovKeyspacepb(uint64(m.State))
	}
	if m.CreatedAt != 0 {
		n += 1 + sovKeyspacepb(uint64(m.CreatedAt))
	}
	if m.StateChangedAt != 0 {
		n += 1 + sovKeyspacepb(uint64(m.StateChangedAt))
	}
	if len(m.Config) > 0 {
		for k, v := range m.Config {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovKeyspacepb(uint64(len(k))) + 1 + len(v) + sovKeyspacepb(uint64(len(v)))
			n += mapEntrySize + 1 + sovKeyspacepb(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadKeyspaceRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LoadKeyspaceResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if m.Keyspace != nil {
		l = m.Keyspace.Size()
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchKeyspacesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WatchKeyspacesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovKeyspacepb(uint64(l))
	}
	if len(m.Keyspaces) > 0 {
		for _, e := range m.Keyspaces {
			l = e.Size()
			n += 1 + l + sovKeyspacepb(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovKeyspacepb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozKeyspacepb(x uint64) (n int) {
	return sovKeyspacepb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *KeyspaceMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyspaceMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyspaceMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= KeyspaceState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			m.CreatedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreatedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateChangedAt", wireType)
			}
			m.StateChangedAt = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateChangedAt |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKeyspacepb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyspacepb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthKeyspacepb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthKeyspacepb
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyspacepb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthKeyspacepb
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthKeyspacepb
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipKeyspacepb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthKeyspacepb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Config[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyspacepb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadKeyspaceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadKeyspaceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadKeyspaceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &pdpb.RequestHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyspacepb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadKeyspaceResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadKeyspaceResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadKeyspaceResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &pdpb.ResponseHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keyspace", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Keyspace == nil {
				m.Keyspace = &KeyspaceMeta{}
			}
			if err := m.Keyspace.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyspacepb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchKeyspacesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchKeyspacesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchKeyspacesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &pdpb.RequestHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyspacepb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchKeyspacesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchKeyspacesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchKeyspacesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &pdpb.ResponseHeader{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keyspaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keyspaces = append(m.Keyspaces, &KeyspaceMeta{})
			if err := m.Keyspaces[len(m.Keyspaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyspacepb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthKeyspacepb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipKeyspacepb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowKeyspacepb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowKeyspacepb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthKeyspacepb
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupKeyspacepb
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthKeyspacepb
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthKeyspacepb        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowKeyspacepb          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupKeyspacepb = fmt.Errorf("proto: unexpected end of group")
)
