// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: eraftpb.proto

package eraftpb

import (
	"fmt"
	"io"
	"math"
	math_bits "math/bits"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EntryType int32

const (
	EntryType_EntryNormal       EntryType = 0
	EntryType_EntryConfChange   EntryType = 1
	EntryType_EntryConfChangeV2 EntryType = 2
)

var EntryType_name = map[int32]string{
	0: "EntryNormal",
	1: "EntryConfChange",
	2: "EntryConfChangeV2",
}

var EntryType_value = map[string]int32{
	"EntryNormal":       0,
	"EntryConfChange":   1,
	"EntryConfChangeV2": 2,
}

func (x EntryType) String() string {
	return proto.EnumName(EntryType_name, int32(x))
}

func (EntryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{0}
}

type MessageType int32

const (
	MessageType_MsgHup                    MessageType = 0
	MessageType_MsgBeat                   MessageType = 1
	MessageType_MsgPropose                MessageType = 2
	MessageType_MsgAppend                 MessageType = 3
	MessageType_MsgAppendResponse         MessageType = 4
	MessageType_MsgRequestVote            MessageType = 5
	MessageType_MsgRequestVoteResponse    MessageType = 6
	MessageType_MsgSnapshot               MessageType = 7
	MessageType_MsgHeartbeat              MessageType = 8
	MessageType_MsgHeartbeatResponse      MessageType = 9
	MessageType_MsgUnreachable            MessageType = 10
	MessageType_MsgSnapStatus             MessageType = 11
	MessageType_MsgCheckQuorum            MessageType = 12
	MessageType_MsgTransferLeader         MessageType = 13
	MessageType_MsgTimeoutNow             MessageType = 14
	MessageType_MsgReadIndex              MessageType = 15
	MessageType_MsgReadIndexResp          MessageType = 16
	MessageType_MsgRequestPreVote         MessageType = 17
	MessageType_MsgRequestPreVoteResponse MessageType = 18
)

var MessageType_name = map[int32]string{
	0:  "MsgHup",
	1:  "MsgBeat",
	2:  "MsgPropose",
	3:  "MsgAppend",
	4:  "MsgAppendResponse",
	5:  "MsgRequestVote",
	6:  "MsgRequestVoteResponse",
	7:  "MsgSnapshot",
	8:  "MsgHeartbeat",
	9:  "MsgHeartbeatResponse",
	10: "MsgUnreachable",
	11: "MsgSnapStatus",
	12: "MsgCheckQuorum",
	13: "MsgTransferLeader",
	14: "MsgTimeoutNow",
	15: "MsgReadIndex",
	16: "MsgReadIndexResp",
	17: "MsgRequestPreVote",
	18: "MsgRequestPreVoteResponse",
}

var MessageType_value = map[string]int32{
	"MsgHup":                    0,
	"MsgBeat":                   1,
	"MsgPropose":                2,
	"MsgAppend":                 3,
	"MsgAppendResponse":         4,
	"MsgRequestVote":            5,
	"MsgRequestVoteResponse":    6,
	"MsgSnapshot":               7,
	"MsgHeartbeat":              8,
	"MsgHeartbeatResponse":      9,
	"MsgUnreachable":            10,
	"MsgSnapStatus":             11,
	"MsgCheckQuorum":            12,
	"MsgTransferLeader":         13,
	"MsgTimeoutNow":             14,
	"MsgReadIndex":              15,
	"MsgReadIndexResp":          16,
	"MsgRequestPreVote":         17,
	"MsgRequestPreVoteResponse": 18,
}

func (x MessageType) String() string {
	return proto.EnumName(MessageType_name, int32(x))
}

func (MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{1}
}

type ConfChangeTransition int32

const (
	// Automatically use the simple protocol if possible, otherwise fall back
	// to ConfChangeType::Implicit. Most applications will want to use this.
	ConfChangeTransition_Auto ConfChangeTransition = 0
	// Use joint consensus unconditionally, and transition out of them
	// automatically (by proposing a zero configuration change).
	//
	// This option is suitable for applications that want to minimize the time
	// spent in the joint configuration and do not store the joint configuration
	// in the state machine (outside of InitialState).
	ConfChangeTransition_Implicit ConfChangeTransition = 1
	// Use joint consensus and remain in the joint configuration until the
	// application proposes a no-op configuration change. This is suitable for
	// applications that want to explicitly control the transitions, for example
	// to use a custom payload (via the Context field).
	ConfChangeTransition_Explicit ConfChangeTransition = 2
)

var ConfChangeTransition_name = map[int32]string{
	0: "Auto",
	1: "Implicit",
	2: "Explicit",
}

var ConfChangeTransition_value = map[string]int32{
	"Auto":     0,
	"Implicit": 1,
	"Explicit": 2,
}

func (x ConfChangeTransition) String() string {
	return proto.EnumName(ConfChangeTransition_name, int32(x))
}

func (ConfChangeTransition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{2}
}

type ConfChangeType int32

const (
	ConfChangeType_AddNode        ConfChangeType = 0
	ConfChangeType_RemoveNode     ConfChangeType = 1
	ConfChangeType_AddLearnerNode ConfChangeType = 2
)

var ConfChangeType_name = map[int32]string{
	0: "AddNode",
	1: "RemoveNode",
	2: "AddLearnerNode",
}

var ConfChangeType_value = map[string]int32{
	"AddNode":        0,
	"RemoveNode":     1,
	"AddLearnerNode": 2,
}

func (x ConfChangeType) String() string {
	return proto.EnumName(ConfChangeType_name, int32(x))
}

func (ConfChangeType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{3}
}

// The entry is a type of change that needs to be applied. It contains two data fields.
// While the fields are built into the model; their usage is determined by the entry_type.
//
// For normal entries, the data field should contain the data change that should be applied.
// The context field can be used for any contextual data that might be relevant to the
// application of the data.
//
// For configuration changes, the data will contain the ConfChange message and the
// context will provide anything needed to assist the configuration change. The context
// if for the user to set and use in this case.
type Entry struct {
	EntryType EntryType `protobuf:"varint,1,opt,name=entry_type,json=entryType,proto3,enum=eraftpb.EntryType" json:"entry_type,omitempty"`
	Term      uint64    `protobuf:"varint,2,opt,name=term,proto3" json:"term,omitempty"`
	Index     uint64    `protobuf:"varint,3,opt,name=index,proto3" json:"index,omitempty"`
	Data      []byte    `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
	Context   []byte    `protobuf:"bytes,6,opt,name=context,proto3" json:"context,omitempty"`
	// Deprecated! It is kept for backward compatibility.
	// TODO: remove it in the next major release.
	SyncLog              bool     `protobuf:"varint,5,opt,name=sync_log,json=syncLog,proto3" json:"sync_log,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}
func (*Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{0}
}
func (m *Entry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Entry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entry.Merge(m, src)
}
func (m *Entry) XXX_Size() int {
	return m.Size()
}
func (m *Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Entry proto.InternalMessageInfo

func (m *Entry) GetEntryType() EntryType {
	if m != nil {
		return m.EntryType
	}
	return EntryType_EntryNormal
}

func (m *Entry) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

func (m *Entry) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *Entry) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Entry) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Entry) GetSyncLog() bool {
	if m != nil {
		return m.SyncLog
	}
	return false
}

type SnapshotMetadata struct {
	// The current `ConfState`.
	ConfState *ConfState `protobuf:"bytes,1,opt,name=conf_state,json=confState,proto3" json:"conf_state,omitempty"`
	// The applied index.
	Index uint64 `protobuf:"varint,2,opt,name=index,proto3" json:"index,omitempty"`
	// The term of the applied index.
	Term                 uint64   `protobuf:"varint,3,opt,name=term,proto3" json:"term,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SnapshotMetadata) Reset()         { *m = SnapshotMetadata{} }
func (m *SnapshotMetadata) String() string { return proto.CompactTextString(m) }
func (*SnapshotMetadata) ProtoMessage()    {}
func (*SnapshotMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{1}
}
func (m *SnapshotMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SnapshotMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SnapshotMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SnapshotMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotMetadata.Merge(m, src)
}
func (m *SnapshotMetadata) XXX_Size() int {
	return m.Size()
}
func (m *SnapshotMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotMetadata proto.InternalMessageInfo

func (m *SnapshotMetadata) GetConfState() *ConfState {
	if m != nil {
		return m.ConfState
	}
	return nil
}

func (m *SnapshotMetadata) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *SnapshotMetadata) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

type Snapshot struct {
	Data                 []byte            `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Metadata             *SnapshotMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Snapshot) Reset()         { *m = Snapshot{} }
func (m *Snapshot) String() string { return proto.CompactTextString(m) }
func (*Snapshot) ProtoMessage()    {}
func (*Snapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{2}
}
func (m *Snapshot) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Snapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Snapshot.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Snapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Snapshot.Merge(m, src)
}
func (m *Snapshot) XXX_Size() int {
	return m.Size()
}
func (m *Snapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_Snapshot.DiscardUnknown(m)
}

var xxx_messageInfo_Snapshot proto.InternalMessageInfo

func (m *Snapshot) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Snapshot) GetMetadata() *SnapshotMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

type Message struct {
	MsgType              MessageType `protobuf:"varint,1,opt,name=msg_type,json=msgType,proto3,enum=eraftpb.MessageType" json:"msg_type,omitempty"`
	To                   uint64      `protobuf:"varint,2,opt,name=to,proto3" json:"to,omitempty"`
	From                 uint64      `protobuf:"varint,3,opt,name=from,proto3" json:"from,omitempty"`
	Term                 uint64      `protobuf:"varint,4,opt,name=term,proto3" json:"term,omitempty"`
	LogTerm              uint64      `protobuf:"varint,5,opt,name=log_term,json=logTerm,proto3" json:"log_term,omitempty"`
	Index                uint64      `protobuf:"varint,6,opt,name=index,proto3" json:"index,omitempty"`
	Entries              []*Entry    `protobuf:"bytes,7,rep,name=entries,proto3" json:"entries,omitempty"`
	Commit               uint64      `protobuf:"varint,8,opt,name=commit,proto3" json:"commit,omitempty"`
	Snapshot             *Snapshot   `protobuf:"bytes,9,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	RequestSnapshot      uint64      `protobuf:"varint,13,opt,name=request_snapshot,json=requestSnapshot,proto3" json:"request_snapshot,omitempty"`
	Reject               bool        `protobuf:"varint,10,opt,name=reject,proto3" json:"reject,omitempty"`
	RejectHint           uint64      `protobuf:"varint,11,opt,name=reject_hint,json=rejectHint,proto3" json:"reject_hint,omitempty"`
	Context              []byte      `protobuf:"bytes,12,opt,name=context,proto3" json:"context,omitempty"`
	Priority             uint64      `protobuf:"varint,14,opt,name=priority,proto3" json:"priority,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Message) Reset()         { *m = Message{} }
func (m *Message) String() string { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()    {}
func (*Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{3}
}
func (m *Message) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Message.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Message.Merge(m, src)
}
func (m *Message) XXX_Size() int {
	return m.Size()
}
func (m *Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Message proto.InternalMessageInfo

func (m *Message) GetMsgType() MessageType {
	if m != nil {
		return m.MsgType
	}
	return MessageType_MsgHup
}

func (m *Message) GetTo() uint64 {
	if m != nil {
		return m.To
	}
	return 0
}

func (m *Message) GetFrom() uint64 {
	if m != nil {
		return m.From
	}
	return 0
}

func (m *Message) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

func (m *Message) GetLogTerm() uint64 {
	if m != nil {
		return m.LogTerm
	}
	return 0
}

func (m *Message) GetIndex() uint64 {
	if m != nil {
		return m.Index
	}
	return 0
}

func (m *Message) GetEntries() []*Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *Message) GetCommit() uint64 {
	if m != nil {
		return m.Commit
	}
	return 0
}

func (m *Message) GetSnapshot() *Snapshot {
	if m != nil {
		return m.Snapshot
	}
	return nil
}

func (m *Message) GetRequestSnapshot() uint64 {
	if m != nil {
		return m.RequestSnapshot
	}
	return 0
}

func (m *Message) GetReject() bool {
	if m != nil {
		return m.Reject
	}
	return false
}

func (m *Message) GetRejectHint() uint64 {
	if m != nil {
		return m.RejectHint
	}
	return 0
}

func (m *Message) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Message) GetPriority() uint64 {
	if m != nil {
		return m.Priority
	}
	return 0
}

type HardState struct {
	Term                 uint64   `protobuf:"varint,1,opt,name=term,proto3" json:"term,omitempty"`
	Vote                 uint64   `protobuf:"varint,2,opt,name=vote,proto3" json:"vote,omitempty"`
	Commit               uint64   `protobuf:"varint,3,opt,name=commit,proto3" json:"commit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HardState) Reset()         { *m = HardState{} }
func (m *HardState) String() string { return proto.CompactTextString(m) }
func (*HardState) ProtoMessage()    {}
func (*HardState) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{4}
}
func (m *HardState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HardState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HardState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HardState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HardState.Merge(m, src)
}
func (m *HardState) XXX_Size() int {
	return m.Size()
}
func (m *HardState) XXX_DiscardUnknown() {
	xxx_messageInfo_HardState.DiscardUnknown(m)
}

var xxx_messageInfo_HardState proto.InternalMessageInfo

func (m *HardState) GetTerm() uint64 {
	if m != nil {
		return m.Term
	}
	return 0
}

func (m *HardState) GetVote() uint64 {
	if m != nil {
		return m.Vote
	}
	return 0
}

func (m *HardState) GetCommit() uint64 {
	if m != nil {
		return m.Commit
	}
	return 0
}

type ConfState struct {
	Voters   []uint64 `protobuf:"varint,1,rep,packed,name=voters,proto3" json:"voters,omitempty"`
	Learners []uint64 `protobuf:"varint,2,rep,packed,name=learners,proto3" json:"learners,omitempty"`
	// The voters in the outgoing config. If not empty the node is in joint consensus.
	VotersOutgoing []uint64 `protobuf:"varint,3,rep,packed,name=voters_outgoing,json=votersOutgoing,proto3" json:"voters_outgoing,omitempty"`
	// The nodes that will become learners when the outgoing config is removed.
	// These nodes are necessarily currently in nodes_joint (or they would have
	// been added to the incoming config right away).
	LearnersNext []uint64 `protobuf:"varint,4,rep,packed,name=learners_next,json=learnersNext,proto3" json:"learners_next,omitempty"`
	// If set, the config is joint and Raft will automatically transition into
	// the final config (i.e. remove the outgoing config) when this is safe.
	AutoLeave            bool     `protobuf:"varint,5,opt,name=auto_leave,json=autoLeave,proto3" json:"auto_leave,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfState) Reset()         { *m = ConfState{} }
func (m *ConfState) String() string { return proto.CompactTextString(m) }
func (*ConfState) ProtoMessage()    {}
func (*ConfState) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{5}
}
func (m *ConfState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfState.Merge(m, src)
}
func (m *ConfState) XXX_Size() int {
	return m.Size()
}
func (m *ConfState) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfState.DiscardUnknown(m)
}

var xxx_messageInfo_ConfState proto.InternalMessageInfo

func (m *ConfState) GetVoters() []uint64 {
	if m != nil {
		return m.Voters
	}
	return nil
}

func (m *ConfState) GetLearners() []uint64 {
	if m != nil {
		return m.Learners
	}
	return nil
}

func (m *ConfState) GetVotersOutgoing() []uint64 {
	if m != nil {
		return m.VotersOutgoing
	}
	return nil
}

func (m *ConfState) GetLearnersNext() []uint64 {
	if m != nil {
		return m.LearnersNext
	}
	return nil
}

func (m *ConfState) GetAutoLeave() bool {
	if m != nil {
		return m.AutoLeave
	}
	return false
}

type ConfChange struct {
	ChangeType           ConfChangeType `protobuf:"varint,2,opt,name=change_type,json=changeType,proto3,enum=eraftpb.ConfChangeType" json:"change_type,omitempty"`
	NodeId               uint64         `protobuf:"varint,3,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	Context              []byte         `protobuf:"bytes,4,opt,name=context,proto3" json:"context,omitempty"`
	Id                   uint64         `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ConfChange) Reset()         { *m = ConfChange{} }
func (m *ConfChange) String() string { return proto.CompactTextString(m) }
func (*ConfChange) ProtoMessage()    {}
func (*ConfChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{6}
}
func (m *ConfChange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfChange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfChange.Merge(m, src)
}
func (m *ConfChange) XXX_Size() int {
	return m.Size()
}
func (m *ConfChange) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfChange.DiscardUnknown(m)
}

var xxx_messageInfo_ConfChange proto.InternalMessageInfo

func (m *ConfChange) GetChangeType() ConfChangeType {
	if m != nil {
		return m.ChangeType
	}
	return ConfChangeType_AddNode
}

func (m *ConfChange) GetNodeId() uint64 {
	if m != nil {
		return m.NodeId
	}
	return 0
}

func (m *ConfChange) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *ConfChange) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

// ConfChangeSingle is an individual configuration change operation. Multiple
// such operations can be carried out atomically via a ConfChangeV2.
type ConfChangeSingle struct {
	ChangeType           ConfChangeType `protobuf:"varint,1,opt,name=change_type,json=changeType,proto3,enum=eraftpb.ConfChangeType" json:"change_type,omitempty"`
	NodeId               uint64         `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ConfChangeSingle) Reset()         { *m = ConfChangeSingle{} }
func (m *ConfChangeSingle) String() string { return proto.CompactTextString(m) }
func (*ConfChangeSingle) ProtoMessage()    {}
func (*ConfChangeSingle) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{7}
}
func (m *ConfChangeSingle) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfChangeSingle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfChangeSingle.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfChangeSingle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfChangeSingle.Merge(m, src)
}
func (m *ConfChangeSingle) XXX_Size() int {
	return m.Size()
}
func (m *ConfChangeSingle) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfChangeSingle.DiscardUnknown(m)
}

var xxx_messageInfo_ConfChangeSingle proto.InternalMessageInfo

func (m *ConfChangeSingle) GetChangeType() ConfChangeType {
	if m != nil {
		return m.ChangeType
	}
	return ConfChangeType_AddNode
}

func (m *ConfChangeSingle) GetNodeId() uint64 {
	if m != nil {
		return m.NodeId
	}
	return 0
}

// ConfChangeV2 messages initiate configuration changes. They support both the
// simple "one at a time" membership change protocol and full Joint Consensus
// allowing for arbitrary changes in membership.
//
// The supplied context is treated as an opaque payload and can be used to
// attach an action on the state machine to the application of the config change
// proposal. Note that contrary to Joint Consensus as outlined in the Raft
// paper[1], configuration changes become active when they are *applied* to the
// state machine (not when they are appended to the log).
//
// The simple protocol can be used whenever only a single change is made.
//
// Non-simple changes require the use of Joint Consensus, for which two
// configuration changes are run. The first configuration change specifies the
// desired changes and transitions the Raft group into the joint configuration,
// in which quorum requires a majority of both the pre-changes and post-changes
// configuration. Joint Consensus avoids entering fragile intermediate
// configurations that could compromise survivability. For example, without the
// use of Joint Consensus and running across three availability zones with a
// replication factor of three, it is not possible to replace a voter without
// entering an intermediate configuration that does not survive the outage of
// one availability zone.
//
// The provided ConfChangeTransition specifies how (and whether) Joint Consensus
// is used, and assigns the task of leaving the joint configuration either to
// Raft or the application. Leaving the joint configuration is accomplished by
// proposing a ConfChangeV2 with only and optionally the Context field
// populated.
//
// For details on Raft membership changes, see:
//
// [1]: https://github.com/ongardie/dissertation/blob/master/online-trim.pdf
type ConfChangeV2 struct {
	Transition           ConfChangeTransition `protobuf:"varint,1,opt,name=transition,proto3,enum=eraftpb.ConfChangeTransition" json:"transition,omitempty"`
	Changes              []*ConfChangeSingle  `protobuf:"bytes,2,rep,name=changes,proto3" json:"changes,omitempty"`
	Context              []byte               `protobuf:"bytes,3,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ConfChangeV2) Reset()         { *m = ConfChangeV2{} }
func (m *ConfChangeV2) String() string { return proto.CompactTextString(m) }
func (*ConfChangeV2) ProtoMessage()    {}
func (*ConfChangeV2) Descriptor() ([]byte, []int) {
	return fileDescriptor_acd9f78e51523dd8, []int{8}
}
func (m *ConfChangeV2) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfChangeV2) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfChangeV2.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfChangeV2) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfChangeV2.Merge(m, src)
}
func (m *ConfChangeV2) XXX_Size() int {
	return m.Size()
}
func (m *ConfChangeV2) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfChangeV2.DiscardUnknown(m)
}

var xxx_messageInfo_ConfChangeV2 proto.InternalMessageInfo

func (m *ConfChangeV2) GetTransition() ConfChangeTransition {
	if m != nil {
		return m.Transition
	}
	return ConfChangeTransition_Auto
}

func (m *ConfChangeV2) GetChanges() []*ConfChangeSingle {
	if m != nil {
		return m.Changes
	}
	return nil
}

func (m *ConfChangeV2) GetContext() []byte {
	if m != nil {
		return m.Context
	}
	return nil
}

func init() {
	proto.RegisterEnum("eraftpb.EntryType", EntryType_name, EntryType_value)
	proto.RegisterEnum("eraftpb.MessageType", MessageType_name, MessageType_value)
	proto.RegisterEnum("eraftpb.ConfChangeTransition", ConfChangeTransition_name, ConfChangeTransition_value)
	proto.RegisterEnum("eraftpb.ConfChangeType", ConfChangeType_name, ConfChangeType_value)
	proto.RegisterType((*Entry)(nil), "eraftpb.Entry")
	proto.RegisterType((*SnapshotMetadata)(nil), "eraftpb.SnapshotMetadata")
	proto.RegisterType((*Snapshot)(nil), "eraftpb.Snapshot")
	proto.RegisterType((*Message)(nil), "eraftpb.Message")
	proto.RegisterType((*HardState)(nil), "eraftpb.HardState")
	proto.RegisterType((*ConfState)(nil), "eraftpb.ConfState")
	proto.RegisterType((*ConfChange)(nil), "eraftpb.ConfChange")
	proto.RegisterType((*ConfChangeSingle)(nil), "eraftpb.ConfChangeSingle")
	proto.RegisterType((*ConfChangeV2)(nil), "eraftpb.ConfChangeV2")
}

func init() { proto.RegisterFile("eraftpb.proto", fileDescriptor_acd9f78e51523dd8) }

var fileDescriptor_acd9f78e51523dd8 = []byte{
	// 1013 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xcd, 0x6e, 0xe4, 0x44,
	0x10, 0x8e, 0x3d, 0x93, 0xb1, 0xa7, 0xe6, 0x27, 0x9d, 0x26, 0x64, 0x9d, 0x95, 0x12, 0x46, 0xc3,
	0x81, 0x21, 0x12, 0x8b, 0x36, 0x2b, 0x24, 0x0e, 0x70, 0xc8, 0x46, 0x2b, 0x25, 0x22, 0x13, 0x16,
	0x27, 0x9b, 0xeb, 0xc8, 0xb1, 0x2b, 0x8e, 0x61, 0xdc, 0x6d, 0xba, 0x7b, 0x42, 0xf2, 0x08, 0x48,
	0x3c, 0x00, 0x07, 0x1e, 0x01, 0x78, 0x0e, 0x8e, 0x3c, 0x02, 0x0a, 0x2f, 0x82, 0xba, 0xdd, 0xf6,
	0x78, 0x92, 0x3d, 0x71, 0xab, 0xfa, 0x5c, 0x55, 0xfd, 0xd5, 0x57, 0xd5, 0x2d, 0xc3, 0x00, 0x45,
	0x74, 0xad, 0x8a, 0xab, 0x17, 0x85, 0xe0, 0x8a, 0x53, 0xcf, 0xba, 0xe3, 0x3f, 0x1c, 0x58, 0x7f,
	0xc3, 0x94, 0xb8, 0xa7, 0x2f, 0x01, 0x50, 0x1b, 0x33, 0x75, 0x5f, 0x60, 0xe0, 0x8c, 0x9c, 0xc9,
	0xf0, 0x80, 0xbe, 0xa8, 0xd2, 0x4c, 0xcc, 0xc5, 0x7d, 0x81, 0x61, 0x17, 0x2b, 0x93, 0x52, 0x68,
	0x2b, 0x14, 0x79, 0xe0, 0x8e, 0x9c, 0x49, 0x3b, 0x34, 0x36, 0xdd, 0x82, 0xf5, 0x8c, 0x25, 0x78,
	0x17, 0xb4, 0x0c, 0x58, 0x3a, 0x3a, 0x32, 0x89, 0x54, 0x14, 0xb4, 0x47, 0xce, 0xa4, 0x1f, 0x1a,
	0x9b, 0x06, 0xe0, 0xc5, 0x9c, 0x29, 0xbc, 0x53, 0x41, 0xc7, 0xc0, 0x95, 0x4b, 0x77, 0xc0, 0x97,
	0xf7, 0x2c, 0x9e, 0xcd, 0x79, 0x1a, 0xac, 0x8f, 0x9c, 0x89, 0x1f, 0x7a, 0xda, 0x3f, 0xe5, 0xe9,
	0x98, 0x03, 0x39, 0x67, 0x51, 0x21, 0x6f, 0xb8, 0x9a, 0xa2, 0x8a, 0x4c, 0xa1, 0x97, 0x00, 0x31,
	0x67, 0xd7, 0x33, 0xa9, 0x22, 0x55, 0x32, 0xef, 0x35, 0x98, 0x1f, 0x71, 0x76, 0x7d, 0xae, 0xbf,
	0x84, 0xdd, 0xb8, 0x32, 0x97, 0x2c, 0xdd, 0x47, 0x2c, 0x4d, 0x3f, 0xad, 0x65, 0x3f, 0xe3, 0x77,
	0xe0, 0x57, 0x07, 0xd6, 0x5d, 0x38, 0x8d, 0x2e, 0xbe, 0x00, 0x3f, 0xb7, 0x44, 0x4c, 0xb1, 0xde,
	0xc1, 0x4e, 0x7d, 0xf4, 0x63, 0xa6, 0x61, 0x1d, 0x3a, 0xfe, 0xb3, 0x05, 0xde, 0x14, 0xa5, 0x8c,
	0x52, 0xa4, 0x9f, 0x83, 0x9f, 0xcb, 0xb4, 0xa9, 0xfb, 0x56, 0x5d, 0xc2, 0xc6, 0x18, 0xe5, 0xbd,
	0x5c, 0xa6, 0x46, 0xf7, 0x21, 0xb8, 0x8a, 0x5b, 0xea, 0xae, 0xe2, 0x9a, 0xd7, 0xb5, 0xe0, 0x35,
	0x6f, 0x6d, 0xd7, 0xbd, 0xb4, 0x1b, 0xb3, 0xd9, 0x01, 0x7f, 0xce, 0xd3, 0x99, 0xc1, 0xd7, 0x0d,
	0xee, 0xcd, 0x79, 0x7a, 0xb1, 0x32, 0xb6, 0x4e, 0x53, 0x90, 0x09, 0x78, 0x7a, 0xda, 0x19, 0xca,
	0xc0, 0x1b, 0xb5, 0x26, 0xbd, 0x83, 0xe1, 0xea, 0x42, 0x84, 0xd5, 0x67, 0xba, 0x0d, 0x9d, 0x98,
	0xe7, 0x79, 0xa6, 0x02, 0xdf, 0x14, 0xb0, 0x1e, 0xfd, 0x0c, 0x7c, 0x69, 0x55, 0x08, 0xba, 0x46,
	0x9e, 0xcd, 0x27, 0xf2, 0x84, 0x75, 0x08, 0xfd, 0x14, 0x88, 0xc0, 0x1f, 0x17, 0x28, 0xd5, 0xac,
	0x4e, 0x1b, 0x98, 0x82, 0x1b, 0x16, 0xaf, 0x87, 0xb1, 0x0d, 0x1d, 0x81, 0xdf, 0x63, 0xac, 0x02,
	0x30, 0x2b, 0x62, 0x3d, 0xfa, 0x11, 0xf4, 0x4a, 0x6b, 0x76, 0x93, 0x31, 0x15, 0xf4, 0x4c, 0x36,
	0x94, 0xd0, 0x71, 0xc6, 0x54, 0x73, 0xef, 0xfa, 0xab, 0x7b, 0xf7, 0x1c, 0xfc, 0x42, 0x64, 0x5c,
	0x64, 0xea, 0x3e, 0x18, 0x9a, 0xbc, 0xda, 0x1f, 0x7f, 0x03, 0xdd, 0xe3, 0x48, 0x24, 0xe5, 0xfa,
	0x54, 0xe2, 0x3a, 0x0d, 0x71, 0x29, 0xb4, 0x6f, 0xb9, 0xc2, 0xea, 0x32, 0x68, 0xbb, 0xa1, 0x4a,
	0xab, 0xa9, 0xca, 0xf8, 0x77, 0x07, 0xba, 0xf5, 0x5e, 0xea, 0x28, 0x1d, 0x2d, 0x64, 0xe0, 0x8c,
	0x5a, 0x3a, 0xaa, 0xf4, 0x34, 0x9d, 0x39, 0x46, 0x82, 0xe9, 0x2f, 0xae, 0xf9, 0x52, 0xfb, 0xf4,
	0x13, 0xd8, 0x28, 0xa3, 0x66, 0x7c, 0xa1, 0x52, 0x9e, 0xb1, 0x34, 0x68, 0x99, 0x90, 0x61, 0x09,
	0x7f, 0x6b, 0x51, 0xfa, 0x31, 0x0c, 0xaa, 0xa4, 0x19, 0xd3, 0x3d, 0xb7, 0x4d, 0x58, 0xbf, 0x02,
	0xcf, 0x74, 0xe3, 0xbb, 0x00, 0xd1, 0x42, 0xf1, 0xd9, 0x1c, 0xa3, 0x5b, 0xb4, 0x57, 0xae, 0xab,
	0x91, 0x53, 0x0d, 0x8c, 0x7f, 0x76, 0x00, 0x34, 0xdd, 0xa3, 0x9b, 0x88, 0xa5, 0x48, 0xbf, 0x84,
	0x5e, 0x6c, 0xac, 0x72, 0x65, 0x5d, 0xb3, 0xb2, 0xcf, 0x56, 0x2e, 0x5c, 0x19, 0x69, 0xb6, 0x16,
	0xe2, 0xda, 0xa6, 0xcf, 0xc0, 0x63, 0x3c, 0xc1, 0x59, 0x96, 0x54, 0x82, 0x68, 0xf7, 0x24, 0x69,
	0xce, 0xa4, 0xbd, 0x3a, 0x93, 0x21, 0xb8, 0x59, 0x62, 0x85, 0x76, 0xb3, 0x64, 0x8c, 0x40, 0x96,
	0x07, 0x9c, 0x67, 0x2c, 0x9d, 0x3f, 0x21, 0xe4, 0xfc, 0x2f, 0x42, 0x6e, 0x93, 0xd0, 0xf8, 0x37,
	0x07, 0xfa, 0xcb, 0xbc, 0xcb, 0x03, 0xfa, 0x35, 0x80, 0x12, 0x11, 0x93, 0x99, 0xca, 0x38, 0xb3,
	0x47, 0xec, 0xbe, 0xef, 0x88, 0x3a, 0x28, 0x6c, 0x24, 0xd0, 0x57, 0xe0, 0x95, 0xc7, 0x96, 0xa3,
	0x6c, 0xbe, 0x12, 0x8f, 0xdb, 0x09, 0xab, 0xc8, 0xa6, 0x2a, 0xad, 0x15, 0x55, 0xf6, 0x8f, 0xa1,
	0x5b, 0xbf, 0xc8, 0x74, 0x03, 0x7a, 0xc6, 0x39, 0xe3, 0x22, 0x8f, 0xe6, 0x64, 0x8d, 0x7e, 0x00,
	0x1b, 0x06, 0x58, 0x56, 0x26, 0x0e, 0xfd, 0x10, 0x36, 0x1f, 0x81, 0x97, 0x07, 0xc4, 0xdd, 0xff,
	0xa5, 0x05, 0xbd, 0xc6, 0x23, 0x43, 0x01, 0x3a, 0x53, 0x99, 0x1e, 0x2f, 0x0a, 0xb2, 0x46, 0x7b,
	0xe0, 0x4d, 0x65, 0xfa, 0x1a, 0x23, 0x45, 0x1c, 0x3a, 0x04, 0x98, 0xca, 0xf4, 0xad, 0xe0, 0x05,
	0x97, 0x48, 0x5c, 0x3a, 0x80, 0xee, 0x54, 0xa6, 0x87, 0x45, 0x81, 0x2c, 0x21, 0x2d, 0x5d, 0xbe,
	0x76, 0x43, 0x94, 0x05, 0x67, 0x12, 0x49, 0x9b, 0x52, 0x18, 0x4e, 0x65, 0x1a, 0x96, 0x77, 0xf7,
	0x92, 0x2b, 0x24, 0xeb, 0xf4, 0x39, 0x6c, 0xaf, 0x62, 0x75, 0x7c, 0x47, 0xf7, 0x32, 0x95, 0x69,
	0x75, 0xc9, 0x89, 0x47, 0x09, 0xf4, 0x35, 0x1f, 0x8c, 0x84, 0xba, 0xd2, 0x44, 0x7c, 0x1a, 0xc0,
	0x56, 0x13, 0xa9, 0x93, 0xbb, 0xf6, 0xb0, 0x77, 0x4c, 0x60, 0x14, 0xdf, 0x44, 0x57, 0x73, 0x24,
	0x40, 0x37, 0x61, 0x60, 0x0b, 0xea, 0xcb, 0xb6, 0x90, 0xa4, 0x67, 0xc3, 0x8e, 0x6e, 0x30, 0xfe,
	0xe1, 0xbb, 0x05, 0x17, 0x8b, 0x9c, 0xf4, 0x2d, 0x7d, 0x33, 0xbc, 0x6b, 0x14, 0xa7, 0x18, 0x25,
	0x28, 0xc8, 0xc0, 0x66, 0x5f, 0x64, 0x39, 0xf2, 0x85, 0x3a, 0xe3, 0x3f, 0x91, 0xa1, 0x25, 0x14,
	0x62, 0x94, 0x9c, 0xe8, 0x37, 0x92, 0x6c, 0xd0, 0x2d, 0x20, 0x4d, 0x44, 0x13, 0x22, 0xc4, 0x56,
	0xb4, 0x5d, 0xbe, 0x15, 0x68, 0x9a, 0xdf, 0xa4, 0xbb, 0xb0, 0xf3, 0x04, 0xae, 0x5b, 0xa0, 0xfb,
	0x5f, 0xc1, 0xd6, 0xfb, 0x76, 0x89, 0xfa, 0xd0, 0x3e, 0x5c, 0x28, 0x4e, 0xd6, 0x68, 0x1f, 0xfc,
	0x93, 0xbc, 0x98, 0x67, 0x71, 0xa6, 0xa7, 0xd2, 0x07, 0xff, 0xcd, 0x9d, 0xf5, 0xdc, 0xfd, 0x43,
	0x18, 0xae, 0x2e, 0xbb, 0x1e, 0xe1, 0x61, 0x92, 0x9c, 0xf1, 0x04, 0xc9, 0x9a, 0x1e, 0x61, 0x88,
	0x39, 0xbf, 0x45, 0xe3, 0x3b, 0x5a, 0x88, 0xc3, 0x24, 0x39, 0x2d, 0x5f, 0x02, 0x83, 0xb9, 0xaf,
	0xc9, 0x5f, 0x0f, 0x7b, 0xce, 0xdf, 0x0f, 0x7b, 0xce, 0x3f, 0x0f, 0x7b, 0xce, 0xaf, 0xff, 0xee,
	0xad, 0x5d, 0x75, 0xcc, 0x2f, 0xc3, 0xab, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xef, 0xba, 0xa7,
	0x87, 0x43, 0x08, 0x00, 0x00,
}

func (m *Entry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Entry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Entry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Context) > 0 {
		i -= len(m.Context)
		copy(dAtA[i:], m.Context)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Context)))
		i--
		dAtA[i] = 0x32
	}
	if m.SyncLog {
		i--
		if m.SyncLog {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x22
	}
	if m.Index != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x18
	}
	if m.Term != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x10
	}
	if m.EntryType != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.EntryType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SnapshotMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SnapshotMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Term != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x18
	}
	if m.Index != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x10
	}
	if m.ConfState != nil {
		{
			size, err := m.ConfState.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEraftpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Snapshot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Snapshot) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Snapshot) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEraftpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Message) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Message) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Priority != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Priority))
		i--
		dAtA[i] = 0x70
	}
	if m.RequestSnapshot != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.RequestSnapshot))
		i--
		dAtA[i] = 0x68
	}
	if len(m.Context) > 0 {
		i -= len(m.Context)
		copy(dAtA[i:], m.Context)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Context)))
		i--
		dAtA[i] = 0x62
	}
	if m.RejectHint != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.RejectHint))
		i--
		dAtA[i] = 0x58
	}
	if m.Reject {
		i--
		if m.Reject {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.Snapshot != nil {
		{
			size, err := m.Snapshot.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEraftpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Commit != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Commit))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEraftpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Index != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Index))
		i--
		dAtA[i] = 0x30
	}
	if m.LogTerm != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.LogTerm))
		i--
		dAtA[i] = 0x28
	}
	if m.Term != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x20
	}
	if m.From != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.From))
		i--
		dAtA[i] = 0x18
	}
	if m.To != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.To))
		i--
		dAtA[i] = 0x10
	}
	if m.MsgType != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.MsgType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HardState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HardState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HardState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Commit != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Commit))
		i--
		dAtA[i] = 0x18
	}
	if m.Vote != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Vote))
		i--
		dAtA[i] = 0x10
	}
	if m.Term != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Term))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.AutoLeave {
		i--
		if m.AutoLeave {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.LearnersNext) > 0 {
		dAtA5 := make([]byte, len(m.LearnersNext)*10)
		var j4 int
		for _, num := range m.LearnersNext {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		i -= j4
		copy(dAtA[i:], dAtA5[:j4])
		i = encodeVarintEraftpb(dAtA, i, uint64(j4))
		i--
		dAtA[i] = 0x22
	}
	if len(m.VotersOutgoing) > 0 {
		dAtA7 := make([]byte, len(m.VotersOutgoing)*10)
		var j6 int
		for _, num := range m.VotersOutgoing {
			for num >= 1<<7 {
				dAtA7[j6] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j6++
			}
			dAtA7[j6] = uint8(num)
			j6++
		}
		i -= j6
		copy(dAtA[i:], dAtA7[:j6])
		i = encodeVarintEraftpb(dAtA, i, uint64(j6))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Learners) > 0 {
		dAtA9 := make([]byte, len(m.Learners)*10)
		var j8 int
		for _, num := range m.Learners {
			for num >= 1<<7 {
				dAtA9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			dAtA9[j8] = uint8(num)
			j8++
		}
		i -= j8
		copy(dAtA[i:], dAtA9[:j8])
		i = encodeVarintEraftpb(dAtA, i, uint64(j8))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Voters) > 0 {
		dAtA11 := make([]byte, len(m.Voters)*10)
		var j10 int
		for _, num := range m.Voters {
			for num >= 1<<7 {
				dAtA11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			dAtA11[j10] = uint8(num)
			j10++
		}
		i -= j10
		copy(dAtA[i:], dAtA11[:j10])
		i = encodeVarintEraftpb(dAtA, i, uint64(j10))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ConfChange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfChange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfChange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Context) > 0 {
		i -= len(m.Context)
		copy(dAtA[i:], m.Context)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Context)))
		i--
		dAtA[i] = 0x22
	}
	if m.NodeId != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.NodeId))
		i--
		dAtA[i] = 0x18
	}
	if m.ChangeType != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.ChangeType))
		i--
		dAtA[i] = 0x10
	}
	if m.Id != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfChangeSingle) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfChangeSingle) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfChangeSingle) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.NodeId != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.NodeId))
		i--
		dAtA[i] = 0x10
	}
	if m.ChangeType != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.ChangeType))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfChangeV2) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfChangeV2) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfChangeV2) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Context) > 0 {
		i -= len(m.Context)
		copy(dAtA[i:], m.Context)
		i = encodeVarintEraftpb(dAtA, i, uint64(len(m.Context)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Changes) > 0 {
		for iNdEx := len(m.Changes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Changes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEraftpb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Transition != 0 {
		i = encodeVarintEraftpb(dAtA, i, uint64(m.Transition))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintEraftpb(dAtA []byte, offset int, v uint64) int {
	offset -= sovEraftpb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Entry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EntryType != 0 {
		n += 1 + sovEraftpb(uint64(m.EntryType))
	}
	if m.Term != 0 {
		n += 1 + sovEraftpb(uint64(m.Term))
	}
	if m.Index != 0 {
		n += 1 + sovEraftpb(uint64(m.Index))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.SyncLog {
		n += 2
	}
	l = len(m.Context)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SnapshotMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ConfState != nil {
		l = m.ConfState.Size()
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.Index != 0 {
		n += 1 + sovEraftpb(uint64(m.Index))
	}
	if m.Term != 0 {
		n += 1 + sovEraftpb(uint64(m.Term))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Snapshot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Message) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MsgType != 0 {
		n += 1 + sovEraftpb(uint64(m.MsgType))
	}
	if m.To != 0 {
		n += 1 + sovEraftpb(uint64(m.To))
	}
	if m.From != 0 {
		n += 1 + sovEraftpb(uint64(m.From))
	}
	if m.Term != 0 {
		n += 1 + sovEraftpb(uint64(m.Term))
	}
	if m.LogTerm != 0 {
		n += 1 + sovEraftpb(uint64(m.LogTerm))
	}
	if m.Index != 0 {
		n += 1 + sovEraftpb(uint64(m.Index))
	}
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovEraftpb(uint64(l))
		}
	}
	if m.Commit != 0 {
		n += 1 + sovEraftpb(uint64(m.Commit))
	}
	if m.Snapshot != nil {
		l = m.Snapshot.Size()
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.Reject {
		n += 2
	}
	if m.RejectHint != 0 {
		n += 1 + sovEraftpb(uint64(m.RejectHint))
	}
	l = len(m.Context)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.RequestSnapshot != 0 {
		n += 1 + sovEraftpb(uint64(m.RequestSnapshot))
	}
	if m.Priority != 0 {
		n += 1 + sovEraftpb(uint64(m.Priority))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HardState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Term != 0 {
		n += 1 + sovEraftpb(uint64(m.Term))
	}
	if m.Vote != 0 {
		n += 1 + sovEraftpb(uint64(m.Vote))
	}
	if m.Commit != 0 {
		n += 1 + sovEraftpb(uint64(m.Commit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Voters) > 0 {
		l = 0
		for _, e := range m.Voters {
			l += sovEraftpb(uint64(e))
		}
		n += 1 + sovEraftpb(uint64(l)) + l
	}
	if len(m.Learners) > 0 {
		l = 0
		for _, e := range m.Learners {
			l += sovEraftpb(uint64(e))
		}
		n += 1 + sovEraftpb(uint64(l)) + l
	}
	if len(m.VotersOutgoing) > 0 {
		l = 0
		for _, e := range m.VotersOutgoing {
			l += sovEraftpb(uint64(e))
		}
		n += 1 + sovEraftpb(uint64(l)) + l
	}
	if len(m.LearnersNext) > 0 {
		l = 0
		for _, e := range m.LearnersNext {
			l += sovEraftpb(uint64(e))
		}
		n += 1 + sovEraftpb(uint64(l)) + l
	}
	if m.AutoLeave {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfChange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Id != 0 {
		n += 1 + sovEraftpb(uint64(m.Id))
	}
	if m.ChangeType != 0 {
		n += 1 + sovEraftpb(uint64(m.ChangeType))
	}
	if m.NodeId != 0 {
		n += 1 + sovEraftpb(uint64(m.NodeId))
	}
	l = len(m.Context)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfChangeSingle) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ChangeType != 0 {
		n += 1 + sovEraftpb(uint64(m.ChangeType))
	}
	if m.NodeId != 0 {
		n += 1 + sovEraftpb(uint64(m.NodeId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfChangeV2) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Transition != 0 {
		n += 1 + sovEraftpb(uint64(m.Transition))
	}
	if len(m.Changes) > 0 {
		for _, e := range m.Changes {
			l = e.Size()
			n += 1 + l + sovEraftpb(uint64(l))
		}
	}
	l = len(m.Context)
	if l > 0 {
		n += 1 + l + sovEraftpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEraftpb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEraftpb(x uint64) (n int) {
	return sovEraftpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Entry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntryType", wireType)
			}
			m.EntryType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EntryType |= EntryType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncLog", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SyncLog = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Context = append(m.Context[:0], dAtA[iNdEx:postIndex]...)
			if m.Context == nil {
				m.Context = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConfState == nil {
				m.ConfState = &ConfState{}
			}
			if err := m.ConfState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Snapshot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Snapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Snapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &SnapshotMetadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Message) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgType", wireType)
			}
			m.MsgType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MsgType |= MessageType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			m.To = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.To |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			m.From = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.From |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogTerm", wireType)
			}
			m.LogTerm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LogTerm |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &Entry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			m.Commit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Commit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Snapshot == nil {
				m.Snapshot = &Snapshot{}
			}
			if err := m.Snapshot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reject", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reject = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectHint", wireType)
			}
			m.RejectHint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RejectHint |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Context = append(m.Context[:0], dAtA[iNdEx:postIndex]...)
			if m.Context == nil {
				m.Context = []byte{}
			}
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSnapshot", wireType)
			}
			m.RequestSnapshot = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestSnapshot |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HardState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HardState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HardState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vote", wireType)
			}
			m.Vote = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Vote |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			m.Commit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Commit |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Voters = append(m.Voters, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthEraftpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthEraftpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Voters) == 0 {
					m.Voters = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEraftpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Voters = append(m.Voters, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Voters", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Learners = append(m.Learners, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthEraftpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthEraftpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Learners) == 0 {
					m.Learners = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEraftpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Learners = append(m.Learners, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Learners", wireType)
			}
		case 3:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.VotersOutgoing = append(m.VotersOutgoing, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthEraftpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthEraftpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.VotersOutgoing) == 0 {
					m.VotersOutgoing = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEraftpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.VotersOutgoing = append(m.VotersOutgoing, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field VotersOutgoing", wireType)
			}
		case 4:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LearnersNext = append(m.LearnersNext, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEraftpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthEraftpb
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthEraftpb
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.LearnersNext) == 0 {
					m.LearnersNext = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEraftpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LearnersNext = append(m.LearnersNext, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LearnersNext", wireType)
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoLeave", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AutoLeave = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfChange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfChange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfChange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= ConfChangeType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			m.NodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Context = append(m.Context[:0], dAtA[iNdEx:postIndex]...)
			if m.Context == nil {
				m.Context = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfChangeSingle) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfChangeSingle: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfChangeSingle: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= ConfChangeType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeId", wireType)
			}
			m.NodeId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfChangeV2) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfChangeV2: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfChangeV2: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transition", wireType)
			}
			m.Transition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Transition |= ConfChangeTransition(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Changes = append(m.Changes, &ConfChangeSingle{})
			if err := m.Changes[len(m.Changes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Context", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEraftpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEraftpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Context = append(m.Context[:0], dAtA[iNdEx:postIndex]...)
			if m.Context == nil {
				m.Context = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEraftpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEraftpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEraftpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEraftpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEraftpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEraftpb
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEraftpb
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEraftpb
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEraftpb        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEraftpb          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEraftpb = fmt.Errorf("proto: unexpected end of group")
)
