// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: encryptionpb.proto

package encryptionpb

import (
	"fmt"
	"io"
	"math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type EncryptionMethod int32

const (
	EncryptionMethod_UNKNOWN    EncryptionMethod = 0
	EncryptionMethod_PLAINTEXT  EncryptionMethod = 1
	EncryptionMethod_AES128_CTR EncryptionMethod = 2
	EncryptionMethod_AES192_CTR EncryptionMethod = 3
	EncryptionMethod_AES256_CTR EncryptionMethod = 4
	EncryptionMethod_SM4_CTR    EncryptionMethod = 5
)

var EncryptionMethod_name = map[int32]string{
	0: "UNKNOWN",
	1: "PLAINTEXT",
	2: "AES128_CTR",
	3: "AES192_CTR",
	4: "AES256_CTR",
	5: "SM4_CTR",
}

var EncryptionMethod_value = map[string]int32{
	"UNKNOWN":    0,
	"PLAINTEXT":  1,
	"AES128_CTR": 2,
	"AES192_CTR": 3,
	"AES256_CTR": 4,
	"SM4_CTR":    5,
}

func (x EncryptionMethod) String() string {
	return proto.EnumName(EncryptionMethod_name, int32(x))
}

func (EncryptionMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{0}
}

// General encryption metadata for any data type.
type EncryptionMeta struct {
	// ID of the key used to encrypt the data.
	KeyId uint64 `protobuf:"varint,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Initialization vector (IV) of the data.
	Iv                   []byte   `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptionMeta) Reset()         { *m = EncryptionMeta{} }
func (m *EncryptionMeta) String() string { return proto.CompactTextString(m) }
func (*EncryptionMeta) ProtoMessage()    {}
func (*EncryptionMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{0}
}
func (m *EncryptionMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncryptionMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptionMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncryptionMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptionMeta.Merge(m, src)
}
func (m *EncryptionMeta) XXX_Size() int {
	return m.Size()
}
func (m *EncryptionMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptionMeta.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptionMeta proto.InternalMessageInfo

func (m *EncryptionMeta) GetKeyId() uint64 {
	if m != nil {
		return m.KeyId
	}
	return 0
}

func (m *EncryptionMeta) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

// Information about an encrypted file.
type FileInfo struct {
	// ID of the key used to encrypt the file.
	KeyId uint64 `protobuf:"varint,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Initialization vector (IV) of the file.
	Iv []byte `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty"`
	// Method of encryption algorithm used to encrypted the file.
	Method               EncryptionMethod `protobuf:"varint,3,opt,name=method,proto3,enum=encryptionpb.EncryptionMethod" json:"method,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *FileInfo) Reset()         { *m = FileInfo{} }
func (m *FileInfo) String() string { return proto.CompactTextString(m) }
func (*FileInfo) ProtoMessage()    {}
func (*FileInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{1}
}
func (m *FileInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FileInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FileInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FileInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileInfo.Merge(m, src)
}
func (m *FileInfo) XXX_Size() int {
	return m.Size()
}
func (m *FileInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_FileInfo.DiscardUnknown(m)
}

var xxx_messageInfo_FileInfo proto.InternalMessageInfo

func (m *FileInfo) GetKeyId() uint64 {
	if m != nil {
		return m.KeyId
	}
	return 0
}

func (m *FileInfo) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

func (m *FileInfo) GetMethod() EncryptionMethod {
	if m != nil {
		return m.Method
	}
	return EncryptionMethod_UNKNOWN
}

type FileDictionary struct {
	// A map of file name to file info.
	Files                map[string]*FileInfo `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FileDictionary) Reset()         { *m = FileDictionary{} }
func (m *FileDictionary) String() string { return proto.CompactTextString(m) }
func (*FileDictionary) ProtoMessage()    {}
func (*FileDictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{2}
}
func (m *FileDictionary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FileDictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FileDictionary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FileDictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileDictionary.Merge(m, src)
}
func (m *FileDictionary) XXX_Size() int {
	return m.Size()
}
func (m *FileDictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_FileDictionary.DiscardUnknown(m)
}

var xxx_messageInfo_FileDictionary proto.InternalMessageInfo

func (m *FileDictionary) GetFiles() map[string]*FileInfo {
	if m != nil {
		return m.Files
	}
	return nil
}

// The key used to encrypt the user data.
type DataKey struct {
	// A sequence of secret bytes used to encrypt data.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Method of encryption algorithm used to encrypted data.
	Method EncryptionMethod `protobuf:"varint,2,opt,name=method,proto3,enum=encryptionpb.EncryptionMethod" json:"method,omitempty"`
	// Creation time of the key.
	CreationTime uint64 `protobuf:"varint,3,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// A flag for the key have ever been exposed.
	WasExposed           bool     `protobuf:"varint,4,opt,name=was_exposed,json=wasExposed,proto3" json:"was_exposed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataKey) Reset()         { *m = DataKey{} }
func (m *DataKey) String() string { return proto.CompactTextString(m) }
func (*DataKey) ProtoMessage()    {}
func (*DataKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{3}
}
func (m *DataKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DataKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataKey.Merge(m, src)
}
func (m *DataKey) XXX_Size() int {
	return m.Size()
}
func (m *DataKey) XXX_DiscardUnknown() {
	xxx_messageInfo_DataKey.DiscardUnknown(m)
}

var xxx_messageInfo_DataKey proto.InternalMessageInfo

func (m *DataKey) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *DataKey) GetMethod() EncryptionMethod {
	if m != nil {
		return m.Method
	}
	return EncryptionMethod_UNKNOWN
}

func (m *DataKey) GetCreationTime() uint64 {
	if m != nil {
		return m.CreationTime
	}
	return 0
}

func (m *DataKey) GetWasExposed() bool {
	if m != nil {
		return m.WasExposed
	}
	return false
}

type KeyDictionary struct {
	// A map of key ID to dat key.
	Keys map[uint64]*DataKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of a key currently in use.
	CurrentKeyId         uint64   `protobuf:"varint,2,opt,name=current_key_id,json=currentKeyId,proto3" json:"current_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyDictionary) Reset()         { *m = KeyDictionary{} }
func (m *KeyDictionary) String() string { return proto.CompactTextString(m) }
func (*KeyDictionary) ProtoMessage()    {}
func (*KeyDictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{4}
}
func (m *KeyDictionary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyDictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyDictionary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KeyDictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyDictionary.Merge(m, src)
}
func (m *KeyDictionary) XXX_Size() int {
	return m.Size()
}
func (m *KeyDictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyDictionary.DiscardUnknown(m)
}

var xxx_messageInfo_KeyDictionary proto.InternalMessageInfo

func (m *KeyDictionary) GetKeys() map[uint64]*DataKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *KeyDictionary) GetCurrentKeyId() uint64 {
	if m != nil {
		return m.CurrentKeyId
	}
	return 0
}

// Master key config.
type MasterKey struct {
	// Types that are valid to be assigned to Backend:
	//	*MasterKey_Plaintext
	//	*MasterKey_File
	//	*MasterKey_Kms
	Backend              isMasterKey_Backend `protobuf_oneof:"backend"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MasterKey) Reset()         { *m = MasterKey{} }
func (m *MasterKey) String() string { return proto.CompactTextString(m) }
func (*MasterKey) ProtoMessage()    {}
func (*MasterKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{5}
}
func (m *MasterKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MasterKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKey.Merge(m, src)
}
func (m *MasterKey) XXX_Size() int {
	return m.Size()
}
func (m *MasterKey) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKey.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKey proto.InternalMessageInfo

type isMasterKey_Backend interface {
	isMasterKey_Backend()
	MarshalTo([]byte) (int, error)
	Size() int
}

type MasterKey_Plaintext struct {
	Plaintext *MasterKeyPlaintext `protobuf:"bytes,1,opt,name=plaintext,proto3,oneof" json:"plaintext,omitempty"`
}
type MasterKey_File struct {
	File *MasterKeyFile `protobuf:"bytes,2,opt,name=file,proto3,oneof" json:"file,omitempty"`
}
type MasterKey_Kms struct {
	Kms *MasterKeyKms `protobuf:"bytes,3,opt,name=kms,proto3,oneof" json:"kms,omitempty"`
}

func (*MasterKey_Plaintext) isMasterKey_Backend() {}
func (*MasterKey_File) isMasterKey_Backend()      {}
func (*MasterKey_Kms) isMasterKey_Backend()       {}

func (m *MasterKey) GetBackend() isMasterKey_Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (m *MasterKey) GetPlaintext() *MasterKeyPlaintext {
	if x, ok := m.GetBackend().(*MasterKey_Plaintext); ok {
		return x.Plaintext
	}
	return nil
}

func (m *MasterKey) GetFile() *MasterKeyFile {
	if x, ok := m.GetBackend().(*MasterKey_File); ok {
		return x.File
	}
	return nil
}

func (m *MasterKey) GetKms() *MasterKeyKms {
	if x, ok := m.GetBackend().(*MasterKey_Kms); ok {
		return x.Kms
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MasterKey) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MasterKey_Plaintext)(nil),
		(*MasterKey_File)(nil),
		(*MasterKey_Kms)(nil),
	}
}

// MasterKeyPlaintext indicates content is stored as plaintext.
type MasterKeyPlaintext struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyPlaintext) Reset()         { *m = MasterKeyPlaintext{} }
func (m *MasterKeyPlaintext) String() string { return proto.CompactTextString(m) }
func (*MasterKeyPlaintext) ProtoMessage()    {}
func (*MasterKeyPlaintext) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{6}
}
func (m *MasterKeyPlaintext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyPlaintext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyPlaintext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MasterKeyPlaintext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyPlaintext.Merge(m, src)
}
func (m *MasterKeyPlaintext) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyPlaintext) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyPlaintext.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyPlaintext proto.InternalMessageInfo

// MasterKeyFile is a master key backed by a file containing encryption key in human-readable
// hex format.
type MasterKeyFile struct {
	// Local file path.
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyFile) Reset()         { *m = MasterKeyFile{} }
func (m *MasterKeyFile) String() string { return proto.CompactTextString(m) }
func (*MasterKeyFile) ProtoMessage()    {}
func (*MasterKeyFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{7}
}
func (m *MasterKeyFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MasterKeyFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyFile.Merge(m, src)
}
func (m *MasterKeyFile) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyFile.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyFile proto.InternalMessageInfo

func (m *MasterKeyFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// MasterKeyKms is a master key backed by KMS service that manages the encryption key,
// and provide API to encrypt and decrypt a data key, which is used to encrypt the content.
type MasterKeyKms struct {
	// KMS vendor.
	Vendor string `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// KMS key id.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// KMS region.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// KMS endpoint. Normally not needed.
	Endpoint             string   `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyKms) Reset()         { *m = MasterKeyKms{} }
func (m *MasterKeyKms) String() string { return proto.CompactTextString(m) }
func (*MasterKeyKms) ProtoMessage()    {}
func (*MasterKeyKms) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{8}
}
func (m *MasterKeyKms) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyKms) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyKms.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MasterKeyKms) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyKms.Merge(m, src)
}
func (m *MasterKeyKms) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyKms) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyKms.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyKms proto.InternalMessageInfo

func (m *MasterKeyKms) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *MasterKeyKms) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *MasterKeyKms) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *MasterKeyKms) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

type EncryptedContent struct {
	// Metadata of the encrypted content.
	// Eg. IV, method and KMS key ID
	// It is preferred to define new fields for extra metadata than using this metadata map.
	Metadata map[string][]byte `protobuf:"bytes,1,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Encrypted content.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Master key used to encrypt the content.
	MasterKey *MasterKey `protobuf:"bytes,3,opt,name=master_key,json=masterKey,proto3" json:"master_key,omitempty"`
	// Initilization vector (IV) used.
	Iv []byte `protobuf:"bytes,4,opt,name=iv,proto3" json:"iv,omitempty"`
	// Encrypted data key generated by KMS and used to actually encrypt data.
	// Valid only when KMS is used.
	CiphertextKey        []byte   `protobuf:"bytes,5,opt,name=ciphertext_key,json=ciphertextKey,proto3" json:"ciphertext_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptedContent) Reset()         { *m = EncryptedContent{} }
func (m *EncryptedContent) String() string { return proto.CompactTextString(m) }
func (*EncryptedContent) ProtoMessage()    {}
func (*EncryptedContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_a483860494a778a2, []int{9}
}
func (m *EncryptedContent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncryptedContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptedContent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EncryptedContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptedContent.Merge(m, src)
}
func (m *EncryptedContent) XXX_Size() int {
	return m.Size()
}
func (m *EncryptedContent) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptedContent.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptedContent proto.InternalMessageInfo

func (m *EncryptedContent) GetMetadata() map[string][]byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EncryptedContent) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *EncryptedContent) GetMasterKey() *MasterKey {
	if m != nil {
		return m.MasterKey
	}
	return nil
}

func (m *EncryptedContent) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

func (m *EncryptedContent) GetCiphertextKey() []byte {
	if m != nil {
		return m.CiphertextKey
	}
	return nil
}

func init() {
	proto.RegisterEnum("encryptionpb.EncryptionMethod", EncryptionMethod_name, EncryptionMethod_value)
	proto.RegisterType((*EncryptionMeta)(nil), "encryptionpb.EncryptionMeta")
	proto.RegisterType((*FileInfo)(nil), "encryptionpb.FileInfo")
	proto.RegisterType((*FileDictionary)(nil), "encryptionpb.FileDictionary")
	proto.RegisterMapType((map[string]*FileInfo)(nil), "encryptionpb.FileDictionary.FilesEntry")
	proto.RegisterType((*DataKey)(nil), "encryptionpb.DataKey")
	proto.RegisterType((*KeyDictionary)(nil), "encryptionpb.KeyDictionary")
	proto.RegisterMapType((map[uint64]*DataKey)(nil), "encryptionpb.KeyDictionary.KeysEntry")
	proto.RegisterType((*MasterKey)(nil), "encryptionpb.MasterKey")
	proto.RegisterType((*MasterKeyPlaintext)(nil), "encryptionpb.MasterKeyPlaintext")
	proto.RegisterType((*MasterKeyFile)(nil), "encryptionpb.MasterKeyFile")
	proto.RegisterType((*MasterKeyKms)(nil), "encryptionpb.MasterKeyKms")
	proto.RegisterType((*EncryptedContent)(nil), "encryptionpb.EncryptedContent")
	proto.RegisterMapType((map[string][]byte)(nil), "encryptionpb.EncryptedContent.MetadataEntry")
}

func init() { proto.RegisterFile("encryptionpb.proto", fileDescriptor_a483860494a778a2) }

var fileDescriptor_a483860494a778a2 = []byte{
	// 768 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xcb, 0x6e, 0xdb, 0x46,
	0x14, 0xd5, 0x50, 0xd4, 0x83, 0x57, 0x8f, 0x0a, 0x03, 0xdb, 0x15, 0x54, 0x40, 0x15, 0xe8, 0xba,
	0x15, 0x5a, 0x43, 0x85, 0xd9, 0xd6, 0xb5, 0x5b, 0x04, 0x88, 0x1f, 0x0a, 0x64, 0x28, 0x52, 0x0c,
	0x5a, 0x41, 0xb2, 0x13, 0x68, 0x71, 0x2c, 0x11, 0x14, 0x1f, 0x21, 0xc7, 0xb2, 0xf9, 0x27, 0xc9,
	0x32, 0x59, 0xe5, 0x1f, 0xb2, 0xc9, 0x32, 0xcb, 0x2c, 0xb3, 0x0c, 0x9c, 0x1f, 0x09, 0x38, 0x1c,
	0x51, 0x24, 0x6c, 0x03, 0xc9, 0x8a, 0x73, 0xee, 0x9c, 0x7b, 0x79, 0xe7, 0xcc, 0x99, 0x0b, 0x98,
	0xd8, 0x13, 0x2f, 0x70, 0xa9, 0xe1, 0xd8, 0xee, 0x79, 0xc7, 0xf5, 0x1c, 0xea, 0xe0, 0x72, 0x32,
	0xd6, 0x58, 0x9b, 0x3a, 0x53, 0x87, 0x6d, 0xfc, 0x19, 0xae, 0x22, 0x4e, 0xe3, 0x07, 0xef, 0xd2,
	0xa7, 0x6c, 0x19, 0x05, 0xe4, 0x7f, 0xa1, 0xda, 0x8d, 0xd3, 0x06, 0x84, 0x6a, 0x78, 0x1d, 0xf2,
	0x26, 0x09, 0xc6, 0x86, 0x5e, 0x47, 0x2d, 0xd4, 0x16, 0xd5, 0x9c, 0x49, 0x82, 0x13, 0x1d, 0x57,
	0x41, 0x30, 0x16, 0x75, 0xa1, 0x85, 0xda, 0x65, 0x55, 0x30, 0x16, 0xb2, 0x01, 0xc5, 0x47, 0xc6,
	0x9c, 0x9c, 0xd8, 0x17, 0xce, 0x37, 0xa6, 0xe0, 0x5d, 0xc8, 0x5b, 0x84, 0xce, 0x1c, 0xbd, 0x9e,
	0x6d, 0xa1, 0x76, 0x55, 0x69, 0x76, 0x52, 0xa7, 0x48, 0xf5, 0x31, 0x73, 0x74, 0x95, 0xb3, 0xe5,
	0xd7, 0x08, 0xaa, 0xe1, 0xbf, 0x8e, 0x8d, 0x49, 0xb8, 0xab, 0x79, 0x01, 0x7e, 0x00, 0xb9, 0x0b,
	0x63, 0x4e, 0xfc, 0x3a, 0x6a, 0x65, 0xdb, 0x25, 0xe5, 0xb7, 0x74, 0xa5, 0x34, 0x99, 0x41, 0xbf,
	0x6b, 0x53, 0x2f, 0x50, 0xa3, 0xac, 0xc6, 0x29, 0xc0, 0x2a, 0x88, 0x6b, 0x90, 0x35, 0x49, 0xc0,
	0x7a, 0x97, 0xd4, 0x70, 0x89, 0xb7, 0x21, 0xb7, 0xd0, 0xe6, 0x97, 0x84, 0x35, 0x5f, 0x52, 0x36,
	0x6e, 0x97, 0x0f, 0xcf, 0xad, 0x46, 0xa4, 0xff, 0x84, 0x3d, 0x24, 0xbf, 0x42, 0x50, 0x38, 0xd6,
	0xa8, 0xd6, 0x27, 0xa9, 0x7a, 0xe5, 0xa8, 0xde, 0xea, 0xe4, 0xc2, 0xf7, 0x9c, 0x1c, 0x6f, 0x42,
	0x65, 0xe2, 0x11, 0x2d, 0xdc, 0x19, 0x53, 0xc3, 0x22, 0x4c, 0x38, 0x51, 0x2d, 0x2f, 0x83, 0x23,
	0xc3, 0x22, 0xf8, 0x67, 0x28, 0x5d, 0x69, 0xfe, 0x98, 0x5c, 0xbb, 0x8e, 0x4f, 0xf4, 0xba, 0xd8,
	0x42, 0xed, 0xa2, 0x0a, 0x57, 0x9a, 0xdf, 0x8d, 0x22, 0xf2, 0x7b, 0x04, 0x95, 0x3e, 0x09, 0x12,
	0xf2, 0xed, 0x83, 0x68, 0x92, 0x60, 0xa9, 0xde, 0x56, 0xba, 0x9b, 0x14, 0x35, 0x44, 0x5c, 0x3b,
	0x96, 0x82, 0x7f, 0x81, 0xea, 0xe4, 0xd2, 0xf3, 0x88, 0x4d, 0xc7, 0xfc, 0xce, 0x05, 0xde, 0x53,
	0x14, 0xed, 0x87, 0x57, 0xdf, 0x18, 0x82, 0x14, 0x27, 0x26, 0xf5, 0x10, 0x23, 0x3d, 0xfe, 0x48,
	0xeb, 0xbb, 0x9e, 0x6e, 0x80, 0xeb, 0x98, 0x94, 0xf7, 0x1d, 0x02, 0x69, 0xa0, 0xf9, 0x94, 0x78,
	0xa1, 0xc0, 0x0f, 0x41, 0x72, 0xe7, 0x9a, 0x61, 0x53, 0x72, 0x4d, 0x59, 0xd9, 0x92, 0xd2, 0x4a,
	0x97, 0x88, 0xb9, 0xa7, 0x4b, 0x5e, 0x2f, 0xa3, 0xae, 0x92, 0xf0, 0x0e, 0x88, 0xa1, 0x13, 0xf8,
	0xff, 0x7f, 0xba, 0x27, 0x39, 0xbc, 0xe8, 0x5e, 0x46, 0x65, 0x54, 0xdc, 0x81, 0xac, 0x69, 0xf9,
	0xec, 0x06, 0x4a, 0x4a, 0xe3, 0x9e, 0x8c, 0xbe, 0xe5, 0xf7, 0x32, 0x6a, 0x48, 0x3c, 0x94, 0xa0,
	0x70, 0xae, 0x4d, 0x4c, 0x62, 0xeb, 0xf2, 0x1a, 0xe0, 0xdb, 0x0d, 0xc9, 0x9b, 0x50, 0x49, 0xfd,
	0x09, 0x63, 0x10, 0x5d, 0x8d, 0xce, 0xb8, 0x11, 0xd9, 0x5a, 0x7e, 0x01, 0xe5, 0x64, 0x71, 0xbc,
	0x01, 0xf9, 0x05, 0xb1, 0x75, 0xc7, 0xe3, 0x2c, 0x8e, 0x12, 0x4f, 0x50, 0x60, 0x71, 0xfe, 0x04,
	0x37, 0x20, 0xef, 0x91, 0xa9, 0xe1, 0xd8, 0xac, 0x6f, 0x49, 0xe5, 0x08, 0x37, 0xa0, 0x48, 0x6c,
	0xdd, 0x75, 0x0c, 0x9b, 0x32, 0xc3, 0x48, 0x6a, 0x8c, 0xe5, 0x37, 0x02, 0xd4, 0xb8, 0x23, 0x89,
	0x7e, 0xe4, 0xd8, 0x94, 0xd8, 0x14, 0xf7, 0xa0, 0x68, 0x11, 0xaa, 0xe9, 0x1a, 0xd5, 0xb8, 0x6b,
	0xb6, 0xef, 0xf4, 0x70, 0x9c, 0xd1, 0x19, 0x70, 0x7a, 0x64, 0x9e, 0x38, 0x1b, 0xd7, 0xa1, 0x30,
	0x89, 0x28, 0x7c, 0x34, 0x2c, 0x21, 0xde, 0x05, 0xb0, 0xd8, 0x59, 0x43, 0x67, 0x71, 0xa1, 0x7f,
	0xbc, 0x47, 0x68, 0x55, 0xb2, 0x62, 0x3b, 0x44, 0x73, 0x46, 0x8c, 0xe7, 0xcc, 0x16, 0x54, 0x27,
	0x86, 0x3b, 0x23, 0x5e, 0x28, 0x33, 0xab, 0x95, 0x63, 0x7b, 0x95, 0x55, 0xb4, 0x4f, 0x82, 0xc6,
	0xff, 0x50, 0x49, 0xf5, 0x78, 0xc7, 0x1c, 0x58, 0x4b, 0xfa, 0xb4, 0x9c, 0x30, 0xe4, 0xef, 0x66,
	0xac, 0x51, 0xfc, 0x6a, 0x71, 0x09, 0x0a, 0x4f, 0x87, 0xfd, 0xe1, 0x93, 0x67, 0xc3, 0x5a, 0x06,
	0x57, 0x40, 0x3a, 0x7d, 0x7c, 0x70, 0x32, 0x1c, 0x75, 0x9f, 0x8f, 0x6a, 0x08, 0x57, 0x01, 0x0e,
	0xba, 0x67, 0x3b, 0xca, 0xde, 0xf8, 0x68, 0xa4, 0xd6, 0x84, 0x25, 0xde, 0x57, 0x18, 0xce, 0x72,
	0xac, 0xfc, 0xb3, 0xcb, 0xb0, 0x18, 0xd6, 0x3a, 0x1b, 0xfc, 0xcd, 0x40, 0xee, 0xf0, 0xd7, 0x4f,
	0x6f, 0x8b, 0xe8, 0xc3, 0x4d, 0x13, 0x7d, 0xbc, 0x69, 0xa2, 0xcf, 0x37, 0x4d, 0xf4, 0xf2, 0x4b,
	0x33, 0x03, 0x35, 0xc7, 0x9b, 0x76, 0xa8, 0x61, 0x2e, 0x3a, 0xe6, 0x82, 0x0d, 0xf3, 0xf3, 0x3c,
	0xfb, 0xfc, 0xf5, 0x35, 0x00, 0x00, 0xff, 0xff, 0xec, 0x2d, 0xb0, 0x8e, 0x1e, 0x06, 0x00, 0x00,
}

func (m *EncryptionMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncryptionMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Iv) > 0 {
		i -= len(m.Iv)
		copy(dAtA[i:], m.Iv)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i--
		dAtA[i] = 0x12
	}
	if m.KeyId != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.KeyId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *FileInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FileInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Method != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Iv) > 0 {
		i -= len(m.Iv)
		copy(dAtA[i:], m.Iv)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i--
		dAtA[i] = 0x12
	}
	if m.KeyId != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.KeyId))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *FileDictionary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileDictionary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FileDictionary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Files) > 0 {
		for k := range m.Files {
			v := m.Files[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintEncryptionpb(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintEncryptionpb(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DataKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DataKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.WasExposed {
		i--
		if m.WasExposed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.CreationTime != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.CreationTime))
		i--
		dAtA[i] = 0x18
	}
	if m.Method != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Method))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *KeyDictionary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyDictionary) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KeyDictionary) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CurrentKeyId != 0 {
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.CurrentKeyId))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Keys) > 0 {
		for k := range m.Keys {
			v := m.Keys[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i = encodeVarintEncryptionpb(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintEncryptionpb(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *MasterKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKey) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKey) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Backend != nil {
		{
			size := m.Backend.Size()
			i -= size
			if _, err := m.Backend.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *MasterKey_Plaintext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKey_Plaintext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Plaintext != nil {
		{
			size, err := m.Plaintext.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *MasterKey_File) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKey_File) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.File != nil {
		{
			size, err := m.File.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *MasterKey_Kms) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKey_Kms) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Kms != nil {
		{
			size, err := m.Kms.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *MasterKeyPlaintext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyPlaintext) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKeyPlaintext) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *MasterKeyFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyFile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKeyFile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MasterKeyKms) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyKms) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MasterKeyKms) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Region) > 0 {
		i -= len(m.Region)
		copy(dAtA[i:], m.Region)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Region)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.KeyId) > 0 {
		i -= len(m.KeyId)
		copy(dAtA[i:], m.KeyId)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.KeyId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Vendor) > 0 {
		i -= len(m.Vendor)
		copy(dAtA[i:], m.Vendor)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Vendor)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EncryptedContent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptedContent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EncryptedContent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.CiphertextKey) > 0 {
		i -= len(m.CiphertextKey)
		copy(dAtA[i:], m.CiphertextKey)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.CiphertextKey)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Iv) > 0 {
		i -= len(m.Iv)
		copy(dAtA[i:], m.Iv)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i--
		dAtA[i] = 0x22
	}
	if m.MasterKey != nil {
		{
			size, err := m.MasterKey.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintEncryptionpb(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Content) > 0 {
		i -= len(m.Content)
		copy(dAtA[i:], m.Content)
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Content)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Metadata) > 0 {
		for k := range m.Metadata {
			v := m.Metadata[k]
			baseI := i
			if len(v) > 0 {
				i -= len(v)
				copy(dAtA[i:], v)
				i = encodeVarintEncryptionpb(dAtA, i, uint64(len(v)))
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintEncryptionpb(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintEncryptionpb(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintEncryptionpb(dAtA []byte, offset int, v uint64) int {
	offset -= sovEncryptionpb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *EncryptionMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.KeyId))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FileInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.KeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.KeyId))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovEncryptionpb(uint64(m.Method))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FileDictionary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Files) > 0 {
		for k, v := range m.Files {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovEncryptionpb(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovEncryptionpb(uint64(m.Method))
	}
	if m.CreationTime != 0 {
		n += 1 + sovEncryptionpb(uint64(m.CreationTime))
	}
	if m.WasExposed {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyDictionary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for k, v := range m.Keys {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovEncryptionpb(uint64(l))
			}
			mapEntrySize := 1 + sovEncryptionpb(uint64(k)) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	if m.CurrentKeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.CurrentKeyId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Backend != nil {
		n += m.Backend.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKey_Plaintext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Plaintext != nil {
		l = m.Plaintext.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKey_File) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.File != nil {
		l = m.File.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKey_Kms) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Kms != nil {
		l = m.Kms.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKeyPlaintext) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKeyFile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKeyKms) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Vendor)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.KeyId)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EncryptedContent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovEncryptionpb(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	l = len(m.Content)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.MasterKey != nil {
		l = m.MasterKey.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.CiphertextKey)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEncryptionpb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEncryptionpb(x uint64) (n int) {
	return sovEncryptionpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EncryptionMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			m.KeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			m.KeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= EncryptionMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileDictionary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileDictionary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileDictionary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Files == nil {
				m.Files = make(map[string]*FileInfo)
			}
			var mapkey string
			var mapvalue *FileInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &FileInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Files[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= EncryptionMethod(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreationTime", wireType)
			}
			m.CreationTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreationTime |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WasExposed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WasExposed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyDictionary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyDictionary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyDictionary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Keys == nil {
				m.Keys = make(map[uint64]*DataKey)
			}
			var mapkey uint64
			var mapvalue *DataKey
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DataKey{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Keys[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentKeyId", wireType)
			}
			m.CurrentKeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentKeyId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plaintext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyPlaintext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_Plaintext{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyFile{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_File{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyKms{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_Kms{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyPlaintext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyPlaintext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyPlaintext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyKms) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyKms: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyKms: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vendor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vendor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptedContent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptedContent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptedContent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string][]byte)
			}
			var mapkey string
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Content = append(m.Content[:0], dAtA[iNdEx:postIndex]...)
			if m.Content == nil {
				m.Content = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MasterKey == nil {
				m.MasterKey = &MasterKey{}
			}
			if err := m.MasterKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CiphertextKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CiphertextKey = append(m.CiphertextKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CiphertextKey == nil {
				m.CiphertextKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEncryptionpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEncryptionpb
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEncryptionpb
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEncryptionpb
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEncryptionpb        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEncryptionpb          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEncryptionpb = fmt.Errorf("proto: unexpected end of group")
)
