/*
 * Copyright (c) 2023-2024, NVIDIA CORPORATION.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @file
 * @brief Doxygen group definitions
 */

// This header is only processed by doxygen and does
// not need to be included in any source file.
// Below are the main groups that doxygen uses to build
// the Modules page in the specified order.
//
// To add a new API to an existing group, just use the
// @ingroup tag to the API's doxygen comment.
// Add a new group by first specifying in the hierarchy below.

/**
 * @defgroup memory_resources Memory Resources
 * @{
 *   @defgroup device_memory_resources Device Memory Resources
 *   @defgroup host_memory_resources Host Memory Resources
 *   @defgroup device_resource_adaptors Device Resource Adaptors
 * @}
 * @defgroup cuda_device_management CUDA Device Management
 * @defgroup cuda_streams CUDA Streams
 * @defgroup data_containers Data Containers
 * @defgroup errors Errors
 * @defgroup logging Logging
 * @defgroup thrust_integrations Thrust Integrations
 * @defgroup utilities Utilities
 */
