// Code generated by protoc-gen-go. DO NOT EDIT.
// source: schema.proto

package schemapb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	commonpb "github.com/milvus-io/milvus-proto/go-api/v2/commonpb"
	_ "google.golang.org/protobuf/types/descriptorpb"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// *
// @brief Field data type
type DataType int32

const (
	DataType_None              DataType = 0
	DataType_Bool              DataType = 1
	DataType_Int8              DataType = 2
	DataType_Int16             DataType = 3
	DataType_Int32             DataType = 4
	DataType_Int64             DataType = 5
	DataType_Float             DataType = 10
	DataType_Double            DataType = 11
	DataType_String            DataType = 20
	DataType_VarChar           DataType = 21
	DataType_Array             DataType = 22
	DataType_JSON              DataType = 23
	DataType_BinaryVector      DataType = 100
	DataType_FloatVector       DataType = 101
	DataType_Float16Vector     DataType = 102
	DataType_BFloat16Vector    DataType = 103
	DataType_SparseFloatVector DataType = 104
)

var DataType_name = map[int32]string{
	0:   "None",
	1:   "Bool",
	2:   "Int8",
	3:   "Int16",
	4:   "Int32",
	5:   "Int64",
	10:  "Float",
	11:  "Double",
	20:  "String",
	21:  "VarChar",
	22:  "Array",
	23:  "JSON",
	100: "BinaryVector",
	101: "FloatVector",
	102: "Float16Vector",
	103: "BFloat16Vector",
	104: "SparseFloatVector",
}

var DataType_value = map[string]int32{
	"None":              0,
	"Bool":              1,
	"Int8":              2,
	"Int16":             3,
	"Int32":             4,
	"Int64":             5,
	"Float":             10,
	"Double":            11,
	"String":            20,
	"VarChar":           21,
	"Array":             22,
	"JSON":              23,
	"BinaryVector":      100,
	"FloatVector":       101,
	"Float16Vector":     102,
	"BFloat16Vector":    103,
	"SparseFloatVector": 104,
}

func (x DataType) String() string {
	return proto.EnumName(DataType_name, int32(x))
}

func (DataType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{0}
}

type FieldState int32

const (
	FieldState_FieldCreated  FieldState = 0
	FieldState_FieldCreating FieldState = 1
	FieldState_FieldDropping FieldState = 2
	FieldState_FieldDropped  FieldState = 3
)

var FieldState_name = map[int32]string{
	0: "FieldCreated",
	1: "FieldCreating",
	2: "FieldDropping",
	3: "FieldDropped",
}

var FieldState_value = map[string]int32{
	"FieldCreated":  0,
	"FieldCreating": 1,
	"FieldDropping": 2,
	"FieldDropped":  3,
}

func (x FieldState) String() string {
	return proto.EnumName(FieldState_name, int32(x))
}

func (FieldState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{1}
}

// *
// @brief Field schema
type FieldSchema struct {
	FieldID      int64                    `protobuf:"varint,1,opt,name=fieldID,proto3" json:"fieldID,omitempty"`
	Name         string                   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	IsPrimaryKey bool                     `protobuf:"varint,3,opt,name=is_primary_key,json=isPrimaryKey,proto3" json:"is_primary_key,omitempty"`
	Description  string                   `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	DataType     DataType                 `protobuf:"varint,5,opt,name=data_type,json=dataType,proto3,enum=milvus.proto.schema.DataType" json:"data_type,omitempty"`
	TypeParams   []*commonpb.KeyValuePair `protobuf:"bytes,6,rep,name=type_params,json=typeParams,proto3" json:"type_params,omitempty"`
	IndexParams  []*commonpb.KeyValuePair `protobuf:"bytes,7,rep,name=index_params,json=indexParams,proto3" json:"index_params,omitempty"`
	AutoID       bool                     `protobuf:"varint,8,opt,name=autoID,proto3" json:"autoID,omitempty"`
	State        FieldState               `protobuf:"varint,9,opt,name=state,proto3,enum=milvus.proto.schema.FieldState" json:"state,omitempty"`
	// state is `Created`.
	ElementType          DataType    `protobuf:"varint,10,opt,name=element_type,json=elementType,proto3,enum=milvus.proto.schema.DataType" json:"element_type,omitempty"`
	DefaultValue         *ValueField `protobuf:"bytes,11,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	IsDynamic            bool        `protobuf:"varint,12,opt,name=is_dynamic,json=isDynamic,proto3" json:"is_dynamic,omitempty"`
	IsPartitionKey       bool        `protobuf:"varint,13,opt,name=is_partition_key,json=isPartitionKey,proto3" json:"is_partition_key,omitempty"`
	IsClusteringKey      bool        `protobuf:"varint,14,opt,name=is_clustering_key,json=isClusteringKey,proto3" json:"is_clustering_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *FieldSchema) Reset()         { *m = FieldSchema{} }
func (m *FieldSchema) String() string { return proto.CompactTextString(m) }
func (*FieldSchema) ProtoMessage()    {}
func (*FieldSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{0}
}

func (m *FieldSchema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldSchema.Unmarshal(m, b)
}
func (m *FieldSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldSchema.Marshal(b, m, deterministic)
}
func (m *FieldSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldSchema.Merge(m, src)
}
func (m *FieldSchema) XXX_Size() int {
	return xxx_messageInfo_FieldSchema.Size(m)
}
func (m *FieldSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldSchema.DiscardUnknown(m)
}

var xxx_messageInfo_FieldSchema proto.InternalMessageInfo

func (m *FieldSchema) GetFieldID() int64 {
	if m != nil {
		return m.FieldID
	}
	return 0
}

func (m *FieldSchema) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FieldSchema) GetIsPrimaryKey() bool {
	if m != nil {
		return m.IsPrimaryKey
	}
	return false
}

func (m *FieldSchema) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *FieldSchema) GetDataType() DataType {
	if m != nil {
		return m.DataType
	}
	return DataType_None
}

func (m *FieldSchema) GetTypeParams() []*commonpb.KeyValuePair {
	if m != nil {
		return m.TypeParams
	}
	return nil
}

func (m *FieldSchema) GetIndexParams() []*commonpb.KeyValuePair {
	if m != nil {
		return m.IndexParams
	}
	return nil
}

func (m *FieldSchema) GetAutoID() bool {
	if m != nil {
		return m.AutoID
	}
	return false
}

func (m *FieldSchema) GetState() FieldState {
	if m != nil {
		return m.State
	}
	return FieldState_FieldCreated
}

func (m *FieldSchema) GetElementType() DataType {
	if m != nil {
		return m.ElementType
	}
	return DataType_None
}

func (m *FieldSchema) GetDefaultValue() *ValueField {
	if m != nil {
		return m.DefaultValue
	}
	return nil
}

func (m *FieldSchema) GetIsDynamic() bool {
	if m != nil {
		return m.IsDynamic
	}
	return false
}

func (m *FieldSchema) GetIsPartitionKey() bool {
	if m != nil {
		return m.IsPartitionKey
	}
	return false
}

func (m *FieldSchema) GetIsClusteringKey() bool {
	if m != nil {
		return m.IsClusteringKey
	}
	return false
}

// *
// @brief Collection schema
type CollectionSchema struct {
	Name                 string                   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Description          string                   `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	AutoID               bool                     `protobuf:"varint,3,opt,name=autoID,proto3" json:"autoID,omitempty"` // Deprecated: Do not use.
	Fields               []*FieldSchema           `protobuf:"bytes,4,rep,name=fields,proto3" json:"fields,omitempty"`
	EnableDynamicField   bool                     `protobuf:"varint,5,opt,name=enable_dynamic_field,json=enableDynamicField,proto3" json:"enable_dynamic_field,omitempty"`
	Properties           []*commonpb.KeyValuePair `protobuf:"bytes,6,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CollectionSchema) Reset()         { *m = CollectionSchema{} }
func (m *CollectionSchema) String() string { return proto.CompactTextString(m) }
func (*CollectionSchema) ProtoMessage()    {}
func (*CollectionSchema) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{1}
}

func (m *CollectionSchema) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CollectionSchema.Unmarshal(m, b)
}
func (m *CollectionSchema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CollectionSchema.Marshal(b, m, deterministic)
}
func (m *CollectionSchema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectionSchema.Merge(m, src)
}
func (m *CollectionSchema) XXX_Size() int {
	return xxx_messageInfo_CollectionSchema.Size(m)
}
func (m *CollectionSchema) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectionSchema.DiscardUnknown(m)
}

var xxx_messageInfo_CollectionSchema proto.InternalMessageInfo

func (m *CollectionSchema) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CollectionSchema) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Deprecated: Do not use.
func (m *CollectionSchema) GetAutoID() bool {
	if m != nil {
		return m.AutoID
	}
	return false
}

func (m *CollectionSchema) GetFields() []*FieldSchema {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *CollectionSchema) GetEnableDynamicField() bool {
	if m != nil {
		return m.EnableDynamicField
	}
	return false
}

func (m *CollectionSchema) GetProperties() []*commonpb.KeyValuePair {
	if m != nil {
		return m.Properties
	}
	return nil
}

type BoolArray struct {
	Data                 []bool   `protobuf:"varint,1,rep,packed,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BoolArray) Reset()         { *m = BoolArray{} }
func (m *BoolArray) String() string { return proto.CompactTextString(m) }
func (*BoolArray) ProtoMessage()    {}
func (*BoolArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{2}
}

func (m *BoolArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoolArray.Unmarshal(m, b)
}
func (m *BoolArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoolArray.Marshal(b, m, deterministic)
}
func (m *BoolArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoolArray.Merge(m, src)
}
func (m *BoolArray) XXX_Size() int {
	return xxx_messageInfo_BoolArray.Size(m)
}
func (m *BoolArray) XXX_DiscardUnknown() {
	xxx_messageInfo_BoolArray.DiscardUnknown(m)
}

var xxx_messageInfo_BoolArray proto.InternalMessageInfo

func (m *BoolArray) GetData() []bool {
	if m != nil {
		return m.Data
	}
	return nil
}

type IntArray struct {
	Data                 []int32  `protobuf:"varint,1,rep,packed,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntArray) Reset()         { *m = IntArray{} }
func (m *IntArray) String() string { return proto.CompactTextString(m) }
func (*IntArray) ProtoMessage()    {}
func (*IntArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{3}
}

func (m *IntArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntArray.Unmarshal(m, b)
}
func (m *IntArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntArray.Marshal(b, m, deterministic)
}
func (m *IntArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntArray.Merge(m, src)
}
func (m *IntArray) XXX_Size() int {
	return xxx_messageInfo_IntArray.Size(m)
}
func (m *IntArray) XXX_DiscardUnknown() {
	xxx_messageInfo_IntArray.DiscardUnknown(m)
}

var xxx_messageInfo_IntArray proto.InternalMessageInfo

func (m *IntArray) GetData() []int32 {
	if m != nil {
		return m.Data
	}
	return nil
}

type LongArray struct {
	Data                 []int64  `protobuf:"varint,1,rep,packed,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LongArray) Reset()         { *m = LongArray{} }
func (m *LongArray) String() string { return proto.CompactTextString(m) }
func (*LongArray) ProtoMessage()    {}
func (*LongArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{4}
}

func (m *LongArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongArray.Unmarshal(m, b)
}
func (m *LongArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongArray.Marshal(b, m, deterministic)
}
func (m *LongArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongArray.Merge(m, src)
}
func (m *LongArray) XXX_Size() int {
	return xxx_messageInfo_LongArray.Size(m)
}
func (m *LongArray) XXX_DiscardUnknown() {
	xxx_messageInfo_LongArray.DiscardUnknown(m)
}

var xxx_messageInfo_LongArray proto.InternalMessageInfo

func (m *LongArray) GetData() []int64 {
	if m != nil {
		return m.Data
	}
	return nil
}

type FloatArray struct {
	Data                 []float32 `protobuf:"fixed32,1,rep,packed,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FloatArray) Reset()         { *m = FloatArray{} }
func (m *FloatArray) String() string { return proto.CompactTextString(m) }
func (*FloatArray) ProtoMessage()    {}
func (*FloatArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{5}
}

func (m *FloatArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FloatArray.Unmarshal(m, b)
}
func (m *FloatArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FloatArray.Marshal(b, m, deterministic)
}
func (m *FloatArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FloatArray.Merge(m, src)
}
func (m *FloatArray) XXX_Size() int {
	return xxx_messageInfo_FloatArray.Size(m)
}
func (m *FloatArray) XXX_DiscardUnknown() {
	xxx_messageInfo_FloatArray.DiscardUnknown(m)
}

var xxx_messageInfo_FloatArray proto.InternalMessageInfo

func (m *FloatArray) GetData() []float32 {
	if m != nil {
		return m.Data
	}
	return nil
}

type DoubleArray struct {
	Data                 []float64 `protobuf:"fixed64,1,rep,packed,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DoubleArray) Reset()         { *m = DoubleArray{} }
func (m *DoubleArray) String() string { return proto.CompactTextString(m) }
func (*DoubleArray) ProtoMessage()    {}
func (*DoubleArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{6}
}

func (m *DoubleArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DoubleArray.Unmarshal(m, b)
}
func (m *DoubleArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DoubleArray.Marshal(b, m, deterministic)
}
func (m *DoubleArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleArray.Merge(m, src)
}
func (m *DoubleArray) XXX_Size() int {
	return xxx_messageInfo_DoubleArray.Size(m)
}
func (m *DoubleArray) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleArray.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleArray proto.InternalMessageInfo

func (m *DoubleArray) GetData() []float64 {
	if m != nil {
		return m.Data
	}
	return nil
}

// For special fields such as bigdecimal, array...
type BytesArray struct {
	Data                 [][]byte `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BytesArray) Reset()         { *m = BytesArray{} }
func (m *BytesArray) String() string { return proto.CompactTextString(m) }
func (*BytesArray) ProtoMessage()    {}
func (*BytesArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{7}
}

func (m *BytesArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BytesArray.Unmarshal(m, b)
}
func (m *BytesArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BytesArray.Marshal(b, m, deterministic)
}
func (m *BytesArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BytesArray.Merge(m, src)
}
func (m *BytesArray) XXX_Size() int {
	return xxx_messageInfo_BytesArray.Size(m)
}
func (m *BytesArray) XXX_DiscardUnknown() {
	xxx_messageInfo_BytesArray.DiscardUnknown(m)
}

var xxx_messageInfo_BytesArray proto.InternalMessageInfo

func (m *BytesArray) GetData() [][]byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type StringArray struct {
	Data                 []string `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringArray) Reset()         { *m = StringArray{} }
func (m *StringArray) String() string { return proto.CompactTextString(m) }
func (*StringArray) ProtoMessage()    {}
func (*StringArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{8}
}

func (m *StringArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringArray.Unmarshal(m, b)
}
func (m *StringArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringArray.Marshal(b, m, deterministic)
}
func (m *StringArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringArray.Merge(m, src)
}
func (m *StringArray) XXX_Size() int {
	return xxx_messageInfo_StringArray.Size(m)
}
func (m *StringArray) XXX_DiscardUnknown() {
	xxx_messageInfo_StringArray.DiscardUnknown(m)
}

var xxx_messageInfo_StringArray proto.InternalMessageInfo

func (m *StringArray) GetData() []string {
	if m != nil {
		return m.Data
	}
	return nil
}

type ArrayArray struct {
	Data                 []*ScalarField `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	ElementType          DataType       `protobuf:"varint,2,opt,name=element_type,json=elementType,proto3,enum=milvus.proto.schema.DataType" json:"element_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ArrayArray) Reset()         { *m = ArrayArray{} }
func (m *ArrayArray) String() string { return proto.CompactTextString(m) }
func (*ArrayArray) ProtoMessage()    {}
func (*ArrayArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{9}
}

func (m *ArrayArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArrayArray.Unmarshal(m, b)
}
func (m *ArrayArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArrayArray.Marshal(b, m, deterministic)
}
func (m *ArrayArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArrayArray.Merge(m, src)
}
func (m *ArrayArray) XXX_Size() int {
	return xxx_messageInfo_ArrayArray.Size(m)
}
func (m *ArrayArray) XXX_DiscardUnknown() {
	xxx_messageInfo_ArrayArray.DiscardUnknown(m)
}

var xxx_messageInfo_ArrayArray proto.InternalMessageInfo

func (m *ArrayArray) GetData() []*ScalarField {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ArrayArray) GetElementType() DataType {
	if m != nil {
		return m.ElementType
	}
	return DataType_None
}

type JSONArray struct {
	Data                 [][]byte `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JSONArray) Reset()         { *m = JSONArray{} }
func (m *JSONArray) String() string { return proto.CompactTextString(m) }
func (*JSONArray) ProtoMessage()    {}
func (*JSONArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{10}
}

func (m *JSONArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JSONArray.Unmarshal(m, b)
}
func (m *JSONArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JSONArray.Marshal(b, m, deterministic)
}
func (m *JSONArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JSONArray.Merge(m, src)
}
func (m *JSONArray) XXX_Size() int {
	return xxx_messageInfo_JSONArray.Size(m)
}
func (m *JSONArray) XXX_DiscardUnknown() {
	xxx_messageInfo_JSONArray.DiscardUnknown(m)
}

var xxx_messageInfo_JSONArray proto.InternalMessageInfo

func (m *JSONArray) GetData() [][]byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ValueField struct {
	// Types that are valid to be assigned to Data:
	//
	//	*ValueField_BoolData
	//	*ValueField_IntData
	//	*ValueField_LongData
	//	*ValueField_FloatData
	//	*ValueField_DoubleData
	//	*ValueField_StringData
	//	*ValueField_BytesData
	Data                 isValueField_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ValueField) Reset()         { *m = ValueField{} }
func (m *ValueField) String() string { return proto.CompactTextString(m) }
func (*ValueField) ProtoMessage()    {}
func (*ValueField) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{11}
}

func (m *ValueField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValueField.Unmarshal(m, b)
}
func (m *ValueField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValueField.Marshal(b, m, deterministic)
}
func (m *ValueField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValueField.Merge(m, src)
}
func (m *ValueField) XXX_Size() int {
	return xxx_messageInfo_ValueField.Size(m)
}
func (m *ValueField) XXX_DiscardUnknown() {
	xxx_messageInfo_ValueField.DiscardUnknown(m)
}

var xxx_messageInfo_ValueField proto.InternalMessageInfo

type isValueField_Data interface {
	isValueField_Data()
}

type ValueField_BoolData struct {
	BoolData bool `protobuf:"varint,1,opt,name=bool_data,json=boolData,proto3,oneof"`
}

type ValueField_IntData struct {
	IntData int32 `protobuf:"varint,2,opt,name=int_data,json=intData,proto3,oneof"`
}

type ValueField_LongData struct {
	LongData int64 `protobuf:"varint,3,opt,name=long_data,json=longData,proto3,oneof"`
}

type ValueField_FloatData struct {
	FloatData float32 `protobuf:"fixed32,4,opt,name=float_data,json=floatData,proto3,oneof"`
}

type ValueField_DoubleData struct {
	DoubleData float64 `protobuf:"fixed64,5,opt,name=double_data,json=doubleData,proto3,oneof"`
}

type ValueField_StringData struct {
	StringData string `protobuf:"bytes,6,opt,name=string_data,json=stringData,proto3,oneof"`
}

type ValueField_BytesData struct {
	BytesData []byte `protobuf:"bytes,7,opt,name=bytes_data,json=bytesData,proto3,oneof"`
}

func (*ValueField_BoolData) isValueField_Data() {}

func (*ValueField_IntData) isValueField_Data() {}

func (*ValueField_LongData) isValueField_Data() {}

func (*ValueField_FloatData) isValueField_Data() {}

func (*ValueField_DoubleData) isValueField_Data() {}

func (*ValueField_StringData) isValueField_Data() {}

func (*ValueField_BytesData) isValueField_Data() {}

func (m *ValueField) GetData() isValueField_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ValueField) GetBoolData() bool {
	if x, ok := m.GetData().(*ValueField_BoolData); ok {
		return x.BoolData
	}
	return false
}

func (m *ValueField) GetIntData() int32 {
	if x, ok := m.GetData().(*ValueField_IntData); ok {
		return x.IntData
	}
	return 0
}

func (m *ValueField) GetLongData() int64 {
	if x, ok := m.GetData().(*ValueField_LongData); ok {
		return x.LongData
	}
	return 0
}

func (m *ValueField) GetFloatData() float32 {
	if x, ok := m.GetData().(*ValueField_FloatData); ok {
		return x.FloatData
	}
	return 0
}

func (m *ValueField) GetDoubleData() float64 {
	if x, ok := m.GetData().(*ValueField_DoubleData); ok {
		return x.DoubleData
	}
	return 0
}

func (m *ValueField) GetStringData() string {
	if x, ok := m.GetData().(*ValueField_StringData); ok {
		return x.StringData
	}
	return ""
}

func (m *ValueField) GetBytesData() []byte {
	if x, ok := m.GetData().(*ValueField_BytesData); ok {
		return x.BytesData
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ValueField) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ValueField_BoolData)(nil),
		(*ValueField_IntData)(nil),
		(*ValueField_LongData)(nil),
		(*ValueField_FloatData)(nil),
		(*ValueField_DoubleData)(nil),
		(*ValueField_StringData)(nil),
		(*ValueField_BytesData)(nil),
	}
}

type ScalarField struct {
	// Types that are valid to be assigned to Data:
	//
	//	*ScalarField_BoolData
	//	*ScalarField_IntData
	//	*ScalarField_LongData
	//	*ScalarField_FloatData
	//	*ScalarField_DoubleData
	//	*ScalarField_StringData
	//	*ScalarField_BytesData
	//	*ScalarField_ArrayData
	//	*ScalarField_JsonData
	Data                 isScalarField_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ScalarField) Reset()         { *m = ScalarField{} }
func (m *ScalarField) String() string { return proto.CompactTextString(m) }
func (*ScalarField) ProtoMessage()    {}
func (*ScalarField) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{12}
}

func (m *ScalarField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalarField.Unmarshal(m, b)
}
func (m *ScalarField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalarField.Marshal(b, m, deterministic)
}
func (m *ScalarField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarField.Merge(m, src)
}
func (m *ScalarField) XXX_Size() int {
	return xxx_messageInfo_ScalarField.Size(m)
}
func (m *ScalarField) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarField.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarField proto.InternalMessageInfo

type isScalarField_Data interface {
	isScalarField_Data()
}

type ScalarField_BoolData struct {
	BoolData *BoolArray `protobuf:"bytes,1,opt,name=bool_data,json=boolData,proto3,oneof"`
}

type ScalarField_IntData struct {
	IntData *IntArray `protobuf:"bytes,2,opt,name=int_data,json=intData,proto3,oneof"`
}

type ScalarField_LongData struct {
	LongData *LongArray `protobuf:"bytes,3,opt,name=long_data,json=longData,proto3,oneof"`
}

type ScalarField_FloatData struct {
	FloatData *FloatArray `protobuf:"bytes,4,opt,name=float_data,json=floatData,proto3,oneof"`
}

type ScalarField_DoubleData struct {
	DoubleData *DoubleArray `protobuf:"bytes,5,opt,name=double_data,json=doubleData,proto3,oneof"`
}

type ScalarField_StringData struct {
	StringData *StringArray `protobuf:"bytes,6,opt,name=string_data,json=stringData,proto3,oneof"`
}

type ScalarField_BytesData struct {
	BytesData *BytesArray `protobuf:"bytes,7,opt,name=bytes_data,json=bytesData,proto3,oneof"`
}

type ScalarField_ArrayData struct {
	ArrayData *ArrayArray `protobuf:"bytes,8,opt,name=array_data,json=arrayData,proto3,oneof"`
}

type ScalarField_JsonData struct {
	JsonData *JSONArray `protobuf:"bytes,9,opt,name=json_data,json=jsonData,proto3,oneof"`
}

func (*ScalarField_BoolData) isScalarField_Data() {}

func (*ScalarField_IntData) isScalarField_Data() {}

func (*ScalarField_LongData) isScalarField_Data() {}

func (*ScalarField_FloatData) isScalarField_Data() {}

func (*ScalarField_DoubleData) isScalarField_Data() {}

func (*ScalarField_StringData) isScalarField_Data() {}

func (*ScalarField_BytesData) isScalarField_Data() {}

func (*ScalarField_ArrayData) isScalarField_Data() {}

func (*ScalarField_JsonData) isScalarField_Data() {}

func (m *ScalarField) GetData() isScalarField_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ScalarField) GetBoolData() *BoolArray {
	if x, ok := m.GetData().(*ScalarField_BoolData); ok {
		return x.BoolData
	}
	return nil
}

func (m *ScalarField) GetIntData() *IntArray {
	if x, ok := m.GetData().(*ScalarField_IntData); ok {
		return x.IntData
	}
	return nil
}

func (m *ScalarField) GetLongData() *LongArray {
	if x, ok := m.GetData().(*ScalarField_LongData); ok {
		return x.LongData
	}
	return nil
}

func (m *ScalarField) GetFloatData() *FloatArray {
	if x, ok := m.GetData().(*ScalarField_FloatData); ok {
		return x.FloatData
	}
	return nil
}

func (m *ScalarField) GetDoubleData() *DoubleArray {
	if x, ok := m.GetData().(*ScalarField_DoubleData); ok {
		return x.DoubleData
	}
	return nil
}

func (m *ScalarField) GetStringData() *StringArray {
	if x, ok := m.GetData().(*ScalarField_StringData); ok {
		return x.StringData
	}
	return nil
}

func (m *ScalarField) GetBytesData() *BytesArray {
	if x, ok := m.GetData().(*ScalarField_BytesData); ok {
		return x.BytesData
	}
	return nil
}

func (m *ScalarField) GetArrayData() *ArrayArray {
	if x, ok := m.GetData().(*ScalarField_ArrayData); ok {
		return x.ArrayData
	}
	return nil
}

func (m *ScalarField) GetJsonData() *JSONArray {
	if x, ok := m.GetData().(*ScalarField_JsonData); ok {
		return x.JsonData
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ScalarField) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ScalarField_BoolData)(nil),
		(*ScalarField_IntData)(nil),
		(*ScalarField_LongData)(nil),
		(*ScalarField_FloatData)(nil),
		(*ScalarField_DoubleData)(nil),
		(*ScalarField_StringData)(nil),
		(*ScalarField_BytesData)(nil),
		(*ScalarField_ArrayData)(nil),
		(*ScalarField_JsonData)(nil),
	}
}

// beta, api may change
type SparseFloatArray struct {
	Contents [][]byte `protobuf:"bytes,1,rep,name=contents,proto3" json:"contents,omitempty"`
	// dim is the max dimension of the current batch of vectors
	Dim                  int64    `protobuf:"varint,2,opt,name=dim,proto3" json:"dim,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SparseFloatArray) Reset()         { *m = SparseFloatArray{} }
func (m *SparseFloatArray) String() string { return proto.CompactTextString(m) }
func (*SparseFloatArray) ProtoMessage()    {}
func (*SparseFloatArray) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{13}
}

func (m *SparseFloatArray) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SparseFloatArray.Unmarshal(m, b)
}
func (m *SparseFloatArray) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SparseFloatArray.Marshal(b, m, deterministic)
}
func (m *SparseFloatArray) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SparseFloatArray.Merge(m, src)
}
func (m *SparseFloatArray) XXX_Size() int {
	return xxx_messageInfo_SparseFloatArray.Size(m)
}
func (m *SparseFloatArray) XXX_DiscardUnknown() {
	xxx_messageInfo_SparseFloatArray.DiscardUnknown(m)
}

var xxx_messageInfo_SparseFloatArray proto.InternalMessageInfo

func (m *SparseFloatArray) GetContents() [][]byte {
	if m != nil {
		return m.Contents
	}
	return nil
}

func (m *SparseFloatArray) GetDim() int64 {
	if m != nil {
		return m.Dim
	}
	return 0
}

type VectorField struct {
	// For sparse vector, dim is the max dimension of the current batch of vectors
	Dim int64 `protobuf:"varint,1,opt,name=dim,proto3" json:"dim,omitempty"`
	// Types that are valid to be assigned to Data:
	//
	//	*VectorField_FloatVector
	//	*VectorField_BinaryVector
	//	*VectorField_Float16Vector
	//	*VectorField_Bfloat16Vector
	//	*VectorField_SparseFloatVector
	Data                 isVectorField_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VectorField) Reset()         { *m = VectorField{} }
func (m *VectorField) String() string { return proto.CompactTextString(m) }
func (*VectorField) ProtoMessage()    {}
func (*VectorField) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{14}
}

func (m *VectorField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VectorField.Unmarshal(m, b)
}
func (m *VectorField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VectorField.Marshal(b, m, deterministic)
}
func (m *VectorField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VectorField.Merge(m, src)
}
func (m *VectorField) XXX_Size() int {
	return xxx_messageInfo_VectorField.Size(m)
}
func (m *VectorField) XXX_DiscardUnknown() {
	xxx_messageInfo_VectorField.DiscardUnknown(m)
}

var xxx_messageInfo_VectorField proto.InternalMessageInfo

func (m *VectorField) GetDim() int64 {
	if m != nil {
		return m.Dim
	}
	return 0
}

type isVectorField_Data interface {
	isVectorField_Data()
}

type VectorField_FloatVector struct {
	FloatVector *FloatArray `protobuf:"bytes,2,opt,name=float_vector,json=floatVector,proto3,oneof"`
}

type VectorField_BinaryVector struct {
	BinaryVector []byte `protobuf:"bytes,3,opt,name=binary_vector,json=binaryVector,proto3,oneof"`
}

type VectorField_Float16Vector struct {
	Float16Vector []byte `protobuf:"bytes,4,opt,name=float16_vector,json=float16Vector,proto3,oneof"`
}

type VectorField_Bfloat16Vector struct {
	Bfloat16Vector []byte `protobuf:"bytes,5,opt,name=bfloat16_vector,json=bfloat16Vector,proto3,oneof"`
}

type VectorField_SparseFloatVector struct {
	SparseFloatVector *SparseFloatArray `protobuf:"bytes,6,opt,name=sparse_float_vector,json=sparseFloatVector,proto3,oneof"`
}

func (*VectorField_FloatVector) isVectorField_Data() {}

func (*VectorField_BinaryVector) isVectorField_Data() {}

func (*VectorField_Float16Vector) isVectorField_Data() {}

func (*VectorField_Bfloat16Vector) isVectorField_Data() {}

func (*VectorField_SparseFloatVector) isVectorField_Data() {}

func (m *VectorField) GetData() isVectorField_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *VectorField) GetFloatVector() *FloatArray {
	if x, ok := m.GetData().(*VectorField_FloatVector); ok {
		return x.FloatVector
	}
	return nil
}

func (m *VectorField) GetBinaryVector() []byte {
	if x, ok := m.GetData().(*VectorField_BinaryVector); ok {
		return x.BinaryVector
	}
	return nil
}

func (m *VectorField) GetFloat16Vector() []byte {
	if x, ok := m.GetData().(*VectorField_Float16Vector); ok {
		return x.Float16Vector
	}
	return nil
}

func (m *VectorField) GetBfloat16Vector() []byte {
	if x, ok := m.GetData().(*VectorField_Bfloat16Vector); ok {
		return x.Bfloat16Vector
	}
	return nil
}

func (m *VectorField) GetSparseFloatVector() *SparseFloatArray {
	if x, ok := m.GetData().(*VectorField_SparseFloatVector); ok {
		return x.SparseFloatVector
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*VectorField) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*VectorField_FloatVector)(nil),
		(*VectorField_BinaryVector)(nil),
		(*VectorField_Float16Vector)(nil),
		(*VectorField_Bfloat16Vector)(nil),
		(*VectorField_SparseFloatVector)(nil),
	}
}

type FieldData struct {
	Type      DataType `protobuf:"varint,1,opt,name=type,proto3,enum=milvus.proto.schema.DataType" json:"type,omitempty"`
	FieldName string   `protobuf:"bytes,2,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// Types that are valid to be assigned to Field:
	//
	//	*FieldData_Scalars
	//	*FieldData_Vectors
	Field                isFieldData_Field `protobuf_oneof:"field"`
	FieldId              int64             `protobuf:"varint,5,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	IsDynamic            bool              `protobuf:"varint,6,opt,name=is_dynamic,json=isDynamic,proto3" json:"is_dynamic,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *FieldData) Reset()         { *m = FieldData{} }
func (m *FieldData) String() string { return proto.CompactTextString(m) }
func (*FieldData) ProtoMessage()    {}
func (*FieldData) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{15}
}

func (m *FieldData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldData.Unmarshal(m, b)
}
func (m *FieldData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldData.Marshal(b, m, deterministic)
}
func (m *FieldData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldData.Merge(m, src)
}
func (m *FieldData) XXX_Size() int {
	return xxx_messageInfo_FieldData.Size(m)
}
func (m *FieldData) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldData.DiscardUnknown(m)
}

var xxx_messageInfo_FieldData proto.InternalMessageInfo

func (m *FieldData) GetType() DataType {
	if m != nil {
		return m.Type
	}
	return DataType_None
}

func (m *FieldData) GetFieldName() string {
	if m != nil {
		return m.FieldName
	}
	return ""
}

type isFieldData_Field interface {
	isFieldData_Field()
}

type FieldData_Scalars struct {
	Scalars *ScalarField `protobuf:"bytes,3,opt,name=scalars,proto3,oneof"`
}

type FieldData_Vectors struct {
	Vectors *VectorField `protobuf:"bytes,4,opt,name=vectors,proto3,oneof"`
}

func (*FieldData_Scalars) isFieldData_Field() {}

func (*FieldData_Vectors) isFieldData_Field() {}

func (m *FieldData) GetField() isFieldData_Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *FieldData) GetScalars() *ScalarField {
	if x, ok := m.GetField().(*FieldData_Scalars); ok {
		return x.Scalars
	}
	return nil
}

func (m *FieldData) GetVectors() *VectorField {
	if x, ok := m.GetField().(*FieldData_Vectors); ok {
		return x.Vectors
	}
	return nil
}

func (m *FieldData) GetFieldId() int64 {
	if m != nil {
		return m.FieldId
	}
	return 0
}

func (m *FieldData) GetIsDynamic() bool {
	if m != nil {
		return m.IsDynamic
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FieldData) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FieldData_Scalars)(nil),
		(*FieldData_Vectors)(nil),
	}
}

type IDs struct {
	// Types that are valid to be assigned to IdField:
	//
	//	*IDs_IntId
	//	*IDs_StrId
	IdField              isIDs_IdField `protobuf_oneof:"id_field"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *IDs) Reset()         { *m = IDs{} }
func (m *IDs) String() string { return proto.CompactTextString(m) }
func (*IDs) ProtoMessage()    {}
func (*IDs) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{16}
}

func (m *IDs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IDs.Unmarshal(m, b)
}
func (m *IDs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IDs.Marshal(b, m, deterministic)
}
func (m *IDs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IDs.Merge(m, src)
}
func (m *IDs) XXX_Size() int {
	return xxx_messageInfo_IDs.Size(m)
}
func (m *IDs) XXX_DiscardUnknown() {
	xxx_messageInfo_IDs.DiscardUnknown(m)
}

var xxx_messageInfo_IDs proto.InternalMessageInfo

type isIDs_IdField interface {
	isIDs_IdField()
}

type IDs_IntId struct {
	IntId *LongArray `protobuf:"bytes,1,opt,name=int_id,json=intId,proto3,oneof"`
}

type IDs_StrId struct {
	StrId *StringArray `protobuf:"bytes,2,opt,name=str_id,json=strId,proto3,oneof"`
}

func (*IDs_IntId) isIDs_IdField() {}

func (*IDs_StrId) isIDs_IdField() {}

func (m *IDs) GetIdField() isIDs_IdField {
	if m != nil {
		return m.IdField
	}
	return nil
}

func (m *IDs) GetIntId() *LongArray {
	if x, ok := m.GetIdField().(*IDs_IntId); ok {
		return x.IntId
	}
	return nil
}

func (m *IDs) GetStrId() *StringArray {
	if x, ok := m.GetIdField().(*IDs_StrId); ok {
		return x.StrId
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*IDs) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*IDs_IntId)(nil),
		(*IDs_StrId)(nil),
	}
}

type SearchResultData struct {
	NumQueries           int64        `protobuf:"varint,1,opt,name=num_queries,json=numQueries,proto3" json:"num_queries,omitempty"`
	TopK                 int64        `protobuf:"varint,2,opt,name=top_k,json=topK,proto3" json:"top_k,omitempty"`
	FieldsData           []*FieldData `protobuf:"bytes,3,rep,name=fields_data,json=fieldsData,proto3" json:"fields_data,omitempty"`
	Scores               []float32    `protobuf:"fixed32,4,rep,packed,name=scores,proto3" json:"scores,omitempty"`
	Ids                  *IDs         `protobuf:"bytes,5,opt,name=ids,proto3" json:"ids,omitempty"`
	Topks                []int64      `protobuf:"varint,6,rep,packed,name=topks,proto3" json:"topks,omitempty"`
	OutputFields         []string     `protobuf:"bytes,7,rep,name=output_fields,json=outputFields,proto3" json:"output_fields,omitempty"`
	GroupByFieldValue    *FieldData   `protobuf:"bytes,8,opt,name=group_by_field_value,json=groupByFieldValue,proto3" json:"group_by_field_value,omitempty"`
	AllSearchCount       int64        `protobuf:"varint,9,opt,name=all_search_count,json=allSearchCount,proto3" json:"all_search_count,omitempty"`
	Distances            []float32    `protobuf:"fixed32,10,rep,packed,name=distances,proto3" json:"distances,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SearchResultData) Reset()         { *m = SearchResultData{} }
func (m *SearchResultData) String() string { return proto.CompactTextString(m) }
func (*SearchResultData) ProtoMessage()    {}
func (*SearchResultData) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{17}
}

func (m *SearchResultData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchResultData.Unmarshal(m, b)
}
func (m *SearchResultData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchResultData.Marshal(b, m, deterministic)
}
func (m *SearchResultData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchResultData.Merge(m, src)
}
func (m *SearchResultData) XXX_Size() int {
	return xxx_messageInfo_SearchResultData.Size(m)
}
func (m *SearchResultData) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchResultData.DiscardUnknown(m)
}

var xxx_messageInfo_SearchResultData proto.InternalMessageInfo

func (m *SearchResultData) GetNumQueries() int64 {
	if m != nil {
		return m.NumQueries
	}
	return 0
}

func (m *SearchResultData) GetTopK() int64 {
	if m != nil {
		return m.TopK
	}
	return 0
}

func (m *SearchResultData) GetFieldsData() []*FieldData {
	if m != nil {
		return m.FieldsData
	}
	return nil
}

func (m *SearchResultData) GetScores() []float32 {
	if m != nil {
		return m.Scores
	}
	return nil
}

func (m *SearchResultData) GetIds() *IDs {
	if m != nil {
		return m.Ids
	}
	return nil
}

func (m *SearchResultData) GetTopks() []int64 {
	if m != nil {
		return m.Topks
	}
	return nil
}

func (m *SearchResultData) GetOutputFields() []string {
	if m != nil {
		return m.OutputFields
	}
	return nil
}

func (m *SearchResultData) GetGroupByFieldValue() *FieldData {
	if m != nil {
		return m.GroupByFieldValue
	}
	return nil
}

func (m *SearchResultData) GetAllSearchCount() int64 {
	if m != nil {
		return m.AllSearchCount
	}
	return 0
}

func (m *SearchResultData) GetDistances() []float32 {
	if m != nil {
		return m.Distances
	}
	return nil
}

// vector field clustering info
type VectorClusteringInfo struct {
	// for multi vectors
	Field                string       `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	Centroid             *VectorField `protobuf:"bytes,2,opt,name=centroid,proto3" json:"centroid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VectorClusteringInfo) Reset()         { *m = VectorClusteringInfo{} }
func (m *VectorClusteringInfo) String() string { return proto.CompactTextString(m) }
func (*VectorClusteringInfo) ProtoMessage()    {}
func (*VectorClusteringInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{18}
}

func (m *VectorClusteringInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VectorClusteringInfo.Unmarshal(m, b)
}
func (m *VectorClusteringInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VectorClusteringInfo.Marshal(b, m, deterministic)
}
func (m *VectorClusteringInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VectorClusteringInfo.Merge(m, src)
}
func (m *VectorClusteringInfo) XXX_Size() int {
	return xxx_messageInfo_VectorClusteringInfo.Size(m)
}
func (m *VectorClusteringInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VectorClusteringInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VectorClusteringInfo proto.InternalMessageInfo

func (m *VectorClusteringInfo) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *VectorClusteringInfo) GetCentroid() *VectorField {
	if m != nil {
		return m.Centroid
	}
	return nil
}

// Scalar field clustering info
// todo more definitions: min/max, etc
type ScalarClusteringInfo struct {
	Field                string   `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScalarClusteringInfo) Reset()         { *m = ScalarClusteringInfo{} }
func (m *ScalarClusteringInfo) String() string { return proto.CompactTextString(m) }
func (*ScalarClusteringInfo) ProtoMessage()    {}
func (*ScalarClusteringInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{19}
}

func (m *ScalarClusteringInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScalarClusteringInfo.Unmarshal(m, b)
}
func (m *ScalarClusteringInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScalarClusteringInfo.Marshal(b, m, deterministic)
}
func (m *ScalarClusteringInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScalarClusteringInfo.Merge(m, src)
}
func (m *ScalarClusteringInfo) XXX_Size() int {
	return xxx_messageInfo_ScalarClusteringInfo.Size(m)
}
func (m *ScalarClusteringInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ScalarClusteringInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ScalarClusteringInfo proto.InternalMessageInfo

func (m *ScalarClusteringInfo) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

// clustering distribution info of a certain data unit, it can be segment, partition, etc.
type ClusteringInfo struct {
	VectorClusteringInfos []*VectorClusteringInfo `protobuf:"bytes,1,rep,name=vector_clustering_infos,json=vectorClusteringInfos,proto3" json:"vector_clustering_infos,omitempty"`
	ScalarClusteringInfos []*ScalarClusteringInfo `protobuf:"bytes,2,rep,name=scalar_clustering_infos,json=scalarClusteringInfos,proto3" json:"scalar_clustering_infos,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                `json:"-"`
	XXX_unrecognized      []byte                  `json:"-"`
	XXX_sizecache         int32                   `json:"-"`
}

func (m *ClusteringInfo) Reset()         { *m = ClusteringInfo{} }
func (m *ClusteringInfo) String() string { return proto.CompactTextString(m) }
func (*ClusteringInfo) ProtoMessage()    {}
func (*ClusteringInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1c5fb4d8cc22d66a, []int{20}
}

func (m *ClusteringInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClusteringInfo.Unmarshal(m, b)
}
func (m *ClusteringInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClusteringInfo.Marshal(b, m, deterministic)
}
func (m *ClusteringInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusteringInfo.Merge(m, src)
}
func (m *ClusteringInfo) XXX_Size() int {
	return xxx_messageInfo_ClusteringInfo.Size(m)
}
func (m *ClusteringInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusteringInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ClusteringInfo proto.InternalMessageInfo

func (m *ClusteringInfo) GetVectorClusteringInfos() []*VectorClusteringInfo {
	if m != nil {
		return m.VectorClusteringInfos
	}
	return nil
}

func (m *ClusteringInfo) GetScalarClusteringInfos() []*ScalarClusteringInfo {
	if m != nil {
		return m.ScalarClusteringInfos
	}
	return nil
}

func init() {
	proto.RegisterEnum("milvus.proto.schema.DataType", DataType_name, DataType_value)
	proto.RegisterEnum("milvus.proto.schema.FieldState", FieldState_name, FieldState_value)
	proto.RegisterType((*FieldSchema)(nil), "milvus.proto.schema.FieldSchema")
	proto.RegisterType((*CollectionSchema)(nil), "milvus.proto.schema.CollectionSchema")
	proto.RegisterType((*BoolArray)(nil), "milvus.proto.schema.BoolArray")
	proto.RegisterType((*IntArray)(nil), "milvus.proto.schema.IntArray")
	proto.RegisterType((*LongArray)(nil), "milvus.proto.schema.LongArray")
	proto.RegisterType((*FloatArray)(nil), "milvus.proto.schema.FloatArray")
	proto.RegisterType((*DoubleArray)(nil), "milvus.proto.schema.DoubleArray")
	proto.RegisterType((*BytesArray)(nil), "milvus.proto.schema.BytesArray")
	proto.RegisterType((*StringArray)(nil), "milvus.proto.schema.StringArray")
	proto.RegisterType((*ArrayArray)(nil), "milvus.proto.schema.ArrayArray")
	proto.RegisterType((*JSONArray)(nil), "milvus.proto.schema.JSONArray")
	proto.RegisterType((*ValueField)(nil), "milvus.proto.schema.ValueField")
	proto.RegisterType((*ScalarField)(nil), "milvus.proto.schema.ScalarField")
	proto.RegisterType((*SparseFloatArray)(nil), "milvus.proto.schema.SparseFloatArray")
	proto.RegisterType((*VectorField)(nil), "milvus.proto.schema.VectorField")
	proto.RegisterType((*FieldData)(nil), "milvus.proto.schema.FieldData")
	proto.RegisterType((*IDs)(nil), "milvus.proto.schema.IDs")
	proto.RegisterType((*SearchResultData)(nil), "milvus.proto.schema.SearchResultData")
	proto.RegisterType((*VectorClusteringInfo)(nil), "milvus.proto.schema.VectorClusteringInfo")
	proto.RegisterType((*ScalarClusteringInfo)(nil), "milvus.proto.schema.ScalarClusteringInfo")
	proto.RegisterType((*ClusteringInfo)(nil), "milvus.proto.schema.ClusteringInfo")
}

func init() { proto.RegisterFile("schema.proto", fileDescriptor_1c5fb4d8cc22d66a) }

var fileDescriptor_1c5fb4d8cc22d66a = []byte{
	// 1662 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x57, 0xcd, 0x72, 0x23, 0x49,
	0x11, 0x76, 0xab, 0xf5, 0xd3, 0xca, 0x96, 0x35, 0xed, 0x1a, 0xcf, 0x6c, 0x33, 0xe0, 0xb5, 0x46,
	0xb0, 0x81, 0xd6, 0xc1, 0xda, 0x8c, 0x77, 0x18, 0x96, 0x8d, 0xdd, 0xc0, 0x2b, 0x29, 0x8c, 0x85,
	0x61, 0xd6, 0xb4, 0x09, 0x13, 0xc1, 0xa5, 0xa3, 0xd4, 0x5d, 0x96, 0x6b, 0xa7, 0xd5, 0xd5, 0x74,
	0x55, 0x3b, 0xd0, 0x1d, 0x9e, 0x80, 0xe0, 0xc6, 0x01, 0xae, 0xbc, 0x05, 0x2f, 0xc1, 0x91, 0x57,
	0xe0, 0xc8, 0x95, 0xa8, 0x1f, 0xfd, 0x4b, 0x5e, 0xcf, 0xad, 0x2a, 0xeb, 0xcb, 0xac, 0xca, 0xcc,
	0x2f, 0xb3, 0xb3, 0xa1, 0xc1, 0xa3, 0x3b, 0x32, 0xc6, 0xc7, 0x59, 0xce, 0x04, 0x43, 0x4f, 0xc7,
	0x34, 0xb9, 0x2f, 0xb8, 0xde, 0x1d, 0xeb, 0xa3, 0x17, 0x8d, 0x88, 0x8d, 0xc7, 0x2c, 0xd5, 0xc2,
	0x17, 0xad, 0x11, 0x63, 0xa3, 0x84, 0x9c, 0xa8, 0xdd, 0xb0, 0xb8, 0x3d, 0x89, 0x09, 0x8f, 0x72,
	0x9a, 0x09, 0x96, 0x6b, 0x44, 0xfb, 0xaf, 0x15, 0x70, 0xcf, 0x29, 0x49, 0xe2, 0x6b, 0xa5, 0x8f,
	0x7c, 0xa8, 0xdd, 0xca, 0xed, 0xa0, 0xef, 0x5b, 0x2d, 0xab, 0x63, 0x07, 0xd3, 0x2d, 0x42, 0x50,
	0x4e, 0xf1, 0x98, 0xf8, 0xa5, 0x96, 0xd5, 0xa9, 0x07, 0x6a, 0x8d, 0x7e, 0x00, 0x4d, 0xca, 0xc3,
	0x2c, 0xa7, 0x63, 0x9c, 0x4f, 0xc2, 0x77, 0x64, 0xe2, 0xdb, 0x2d, 0xab, 0xe3, 0x04, 0x0d, 0xca,
	0xaf, 0xb4, 0xf0, 0x92, 0x4c, 0x50, 0x0b, 0xdc, 0xe9, 0xbd, 0x94, 0xa5, 0x7e, 0x59, 0x19, 0x58,
	0x14, 0xa1, 0xcf, 0xa1, 0x1e, 0x63, 0x81, 0x43, 0x31, 0xc9, 0x88, 0x5f, 0x69, 0x59, 0x9d, 0xe6,
	0xe9, 0xc1, 0xf1, 0x06, 0xf7, 0x8e, 0xfb, 0x58, 0xe0, 0xdf, 0x4e, 0x32, 0x12, 0x38, 0xb1, 0x59,
	0xa1, 0x2e, 0xb8, 0x52, 0x2d, 0xcc, 0x70, 0x8e, 0xc7, 0xdc, 0xaf, 0xb6, 0xec, 0x8e, 0x7b, 0xfa,
	0x72, 0x59, 0xdb, 0x04, 0xe5, 0x92, 0x4c, 0x6e, 0x70, 0x52, 0x90, 0x2b, 0x4c, 0xf3, 0x00, 0xa4,
	0xd6, 0x95, 0x52, 0x42, 0x7d, 0x68, 0xd0, 0x34, 0x26, 0x7f, 0x9c, 0x1a, 0xa9, 0x3d, 0xd6, 0x88,
	0xab, 0xd4, 0x8c, 0x95, 0xe7, 0x50, 0xc5, 0x85, 0x60, 0x83, 0xbe, 0xef, 0xa8, 0x28, 0x98, 0x1d,
	0xfa, 0x09, 0x54, 0xb8, 0xc0, 0x82, 0xf8, 0x75, 0xe5, 0xd9, 0xe1, 0x46, 0xcf, 0x74, 0x12, 0x24,
	0x2c, 0xd0, 0x68, 0x74, 0x06, 0x0d, 0x92, 0x90, 0x31, 0x49, 0x85, 0x8e, 0x0b, 0x3c, 0x26, 0x2e,
	0xae, 0x51, 0x51, 0xa1, 0xe9, 0xc3, 0x6e, 0x4c, 0x6e, 0x71, 0x91, 0x88, 0xf0, 0x5e, 0x3e, 0xd9,
	0x77, 0x5b, 0x56, 0xc7, 0xdd, 0xf2, 0x00, 0xe5, 0x94, 0x7a, 0x45, 0xd0, 0x30, 0x5a, 0x4a, 0x84,
	0x0e, 0x00, 0x28, 0x0f, 0xe3, 0x49, 0x8a, 0xc7, 0x34, 0xf2, 0x1b, 0xca, 0xb5, 0x3a, 0xe5, 0x7d,
	0x2d, 0x40, 0x1d, 0xf0, 0x24, 0x07, 0x70, 0x2e, 0xa8, 0xcc, 0xa5, 0x62, 0xc1, 0xae, 0x02, 0x35,
	0x29, 0xbf, 0x9a, 0x8a, 0x25, 0x0f, 0x8e, 0x60, 0x8f, 0xf2, 0x30, 0x4a, 0x0a, 0x2e, 0x48, 0x4e,
	0xd3, 0x91, 0x82, 0x36, 0x15, 0xf4, 0x09, 0xe5, 0xbd, 0x99, 0xfc, 0x92, 0x4c, 0xda, 0x7f, 0x29,
	0x81, 0xd7, 0x63, 0x49, 0x42, 0x22, 0xa9, 0x6d, 0xc8, 0x39, 0xa5, 0xa0, 0xb5, 0x40, 0xc1, 0x15,
	0x72, 0x95, 0xd6, 0xc9, 0xf5, 0x62, 0x96, 0x16, 0x45, 0xce, 0x6e, 0xc9, 0xb7, 0x66, 0xa9, 0xf9,
	0x0c, 0xaa, 0x8a, 0xdf, 0xdc, 0x2f, 0xab, 0x94, 0xb7, 0x1e, 0xc8, 0x8d, 0x5a, 0x07, 0x06, 0x8f,
	0x7e, 0x0c, 0xfb, 0x24, 0xc5, 0xc3, 0x84, 0x4c, 0x23, 0x13, 0xaa, 0x03, 0xc5, 0x5e, 0x27, 0x40,
	0xfa, 0xcc, 0xc4, 0x48, 0xe9, 0xa3, 0xaf, 0x00, 0xb2, 0x9c, 0x65, 0x24, 0x17, 0x94, 0xbc, 0x0f,
	0x4f, 0xe7, 0x4a, 0xed, 0x43, 0xa8, 0x77, 0x19, 0x4b, 0xbe, 0xca, 0x73, 0x3c, 0x91, 0xd1, 0x90,
	0x45, 0xe0, 0x5b, 0x2d, 0xbb, 0xe3, 0x04, 0x6a, 0xdd, 0xfe, 0x10, 0x9c, 0x41, 0x2a, 0xd6, 0xcf,
	0x2b, 0xe6, 0xfc, 0x10, 0xea, 0xbf, 0x62, 0xe9, 0x68, 0x1d, 0x60, 0x1b, 0x40, 0x0b, 0xe0, 0x3c,
	0x61, 0x78, 0x83, 0x89, 0x92, 0x41, 0xbc, 0x04, 0xb7, 0xcf, 0x8a, 0x61, 0x42, 0xd6, 0x21, 0xd6,
	0xdc, 0x48, 0x77, 0x22, 0x08, 0x5f, 0x47, 0x34, 0xe6, 0x46, 0xae, 0x85, 0xcc, 0xf5, 0x3a, 0xa4,
	0x6e, 0x20, 0x7f, 0xb2, 0x00, 0xd4, 0xa9, 0x86, 0xbc, 0x5e, 0x80, 0x6c, 0xcb, 0xd3, 0x75, 0x84,
	0x13, 0x9c, 0x6b, 0x0e, 0x2b, 0xf4, 0x5a, 0x0d, 0x95, 0xde, 0xb7, 0x86, 0x64, 0xc4, 0x7e, 0x79,
	0xfd, 0xf5, 0xdb, 0xed, 0xae, 0xfc, 0xcf, 0x02, 0x98, 0xd7, 0x0e, 0x3a, 0x80, 0xfa, 0x90, 0xb1,
	0x24, 0x34, 0x38, 0xab, 0xe3, 0x5c, 0xec, 0x04, 0x8e, 0x14, 0x49, 0xfb, 0xe8, 0xbb, 0xe0, 0xd0,
	0x54, 0xe8, 0x53, 0xf9, 0x98, 0xca, 0xc5, 0x4e, 0x50, 0xa3, 0xa9, 0x50, 0x87, 0x07, 0x50, 0x4f,
	0x58, 0x3a, 0xd2, 0xa7, 0x92, 0xac, 0xb6, 0xd4, 0x95, 0x22, 0x75, 0x7c, 0x08, 0x70, 0x2b, 0x73,
	0xa3, 0xcf, 0x65, 0x1b, 0x2d, 0x5d, 0xec, 0x04, 0x75, 0x25, 0x53, 0x80, 0x97, 0xe0, 0xc6, 0x2a,
	0x35, 0x1a, 0x21, 0xa9, 0x68, 0x5d, 0xec, 0x04, 0xa0, 0x85, 0x53, 0x08, 0x57, 0x81, 0xd7, 0x90,
	0xaa, 0x2c, 0x17, 0x09, 0xd1, 0xc2, 0xe9, 0x35, 0x43, 0x99, 0x3d, 0x8d, 0xa8, 0xb5, 0xac, 0x4e,
	0x43, 0x5e, 0xa3, 0x64, 0x12, 0xd0, 0xad, 0xea, 0x28, 0xb4, 0xff, 0x53, 0x06, 0x77, 0x21, 0xe4,
	0xe8, 0xcb, 0x55, 0xd7, 0xdd, 0xd3, 0x0f, 0x37, 0x46, 0x7a, 0xc6, 0xe1, 0xa5, 0xd0, 0x7c, 0xbe,
	0x12, 0x1a, 0x77, 0x4b, 0x9e, 0xa6, 0x04, 0x5f, 0x8c, 0xdc, 0x97, 0xab, 0x91, 0xdb, 0x76, 0xf5,
	0x8c, 0xfd, 0x4b, 0x91, 0x3d, 0x5b, 0x8b, 0xec, 0xb6, 0x2e, 0x39, 0x2f, 0x8e, 0xe5, 0xd0, 0xf7,
	0xd6, 0x43, 0xbf, 0x8d, 0xa5, 0x0b, 0xd5, 0xb3, 0x92, 0x9c, 0xde, 0x7a, 0x72, 0xb6, 0x52, 0x7d,
	0x5e, 0x3d, 0x2b, 0xe9, 0x3b, 0x5b, 0x4b, 0xdf, 0x36, 0x5f, 0xe6, 0x35, 0xba, 0x94, 0x5f, 0x69,
	0x01, 0x4b, 0xa9, 0xb6, 0xe0, 0x3c, 0x60, 0x61, 0x5e, 0x9f, 0xd2, 0x82, 0x52, 0x9a, 0xa6, 0xe3,
	0x1b, 0xce, 0x52, 0x6d, 0xa0, 0xfe, 0x40, 0x3a, 0x66, 0xa5, 0x25, 0xd3, 0x21, 0x55, 0x96, 0x08,
	0x76, 0x06, 0xde, 0x75, 0x86, 0x73, 0x4e, 0x16, 0x5a, 0xd2, 0x0b, 0x70, 0x22, 0x96, 0x0a, 0x92,
	0x0a, 0x6e, 0xca, 0x70, 0xb6, 0x47, 0x1e, 0xd8, 0x31, 0x1d, 0x2b, 0xf2, 0xd8, 0x81, 0x5c, 0xb6,
	0xff, 0x55, 0x02, 0xf7, 0x86, 0x44, 0x82, 0x19, 0x8a, 0x1a, 0x84, 0x35, 0x43, 0xc8, 0x4f, 0xbf,
	0x4e, 0xfd, 0xbd, 0x82, 0x19, 0xe6, 0x3d, 0x22, 0xf9, 0xae, 0x52, 0xd3, 0xc6, 0xd1, 0x47, 0xb0,
	0x3b, 0xa4, 0xa9, 0x1c, 0x82, 0x8c, 0x19, 0xdb, 0x94, 0x4d, 0x43, 0x8b, 0x0d, 0xec, 0x87, 0xd0,
	0x54, 0x5a, 0xaf, 0xde, 0x4c, 0x71, 0x65, 0x83, 0xdb, 0x35, 0x72, 0x03, 0xfc, 0x18, 0x9e, 0x0c,
	0x57, 0x90, 0x15, 0x83, 0x6c, 0x0e, 0x97, 0xa1, 0xbf, 0x83, 0xa7, 0x5c, 0x05, 0x29, 0x5c, 0xf2,
	0x43, 0x93, 0xe7, 0xa3, 0xcd, 0xe4, 0x59, 0x09, 0xea, 0xc5, 0x4e, 0xb0, 0xc7, 0xe7, 0x32, 0x6d,
	0x78, 0x96, 0x85, 0xbf, 0x95, 0xa0, 0xae, 0xa2, 0xa7, 0x52, 0xfb, 0x0a, 0xca, 0xaa, 0x93, 0x5a,
	0x8f, 0xe9, 0xa4, 0x0a, 0x2a, 0x07, 0x08, 0xf5, 0x6d, 0x0c, 0x17, 0xe6, 0xc7, 0xba, 0x92, 0xbc,
	0x95, 0x5f, 0xf0, 0x2f, 0xa0, 0xc6, 0x55, 0x17, 0xe1, 0xa6, 0x72, 0xbf, 0xb5, 0xb9, 0xcb, 0xca,
	0x37, 0x2a, 0x52, 0x5b, 0x7b, 0xcc, 0x4d, 0xdd, 0x6e, 0xd6, 0x5e, 0x20, 0x81, 0xd4, 0x36, 0x2a,
	0xe8, 0x3b, 0xe0, 0xe8, 0xa7, 0x51, 0xfd, 0xe5, 0x9e, 0xcd, 0xbb, 0xf1, 0xca, 0xd8, 0x53, 0x5d,
	0x19, 0x7b, 0xba, 0x35, 0xa8, 0x28, 0x64, 0xfb, 0xcf, 0x16, 0xd8, 0x83, 0x3e, 0x47, 0x3f, 0x85,
	0xaa, 0x6c, 0x5f, 0x34, 0x7e, 0xb0, 0xf5, 0x2d, 0xf6, 0x9f, 0x0a, 0x4d, 0xc5, 0x20, 0x46, 0x3f,
	0x83, 0x2a, 0x17, 0xb9, 0x54, 0x2c, 0x3d, 0xba, 0xe0, 0x2b, 0x5c, 0xe4, 0x83, 0xb8, 0x0b, 0xe0,
	0xd0, 0x58, 0x0f, 0x1e, 0xed, 0x7f, 0xd8, 0xe0, 0x5d, 0x13, 0x9c, 0x47, 0x77, 0x01, 0xe1, 0x45,
	0x22, 0x4c, 0x2f, 0x77, 0xd3, 0x62, 0x1c, 0xfe, 0xa1, 0x20, 0xb9, 0x1c, 0x3a, 0x34, 0xef, 0x21,
	0x2d, 0xc6, 0xbf, 0xd1, 0x12, 0xf4, 0x14, 0x2a, 0x82, 0x65, 0xe1, 0x3b, 0x53, 0x34, 0x65, 0xc1,
	0xb2, 0x4b, 0xf4, 0x73, 0x70, 0xf5, 0x94, 0x33, 0xed, 0xa7, 0xf6, 0x56, 0x7f, 0x66, 0xc4, 0x08,
	0x74, 0x8e, 0x75, 0x07, 0x79, 0x0e, 0x55, 0x1e, 0xb1, 0x9c, 0xe8, 0xb1, 0xaa, 0x14, 0x98, 0x1d,
	0x3a, 0x02, 0x9b, 0xc6, 0xdc, 0x74, 0x47, 0x7f, 0x73, 0x77, 0xef, 0xf3, 0x40, 0x82, 0xd0, 0xbe,
	0x7a, 0xd9, 0x3b, 0x3d, 0x29, 0xd9, 0x81, 0xde, 0xa0, 0xef, 0xc3, 0x2e, 0x2b, 0x44, 0x56, 0x88,
	0xd0, 0xcc, 0x6d, 0x35, 0x35, 0x32, 0x34, 0xb4, 0xf0, 0x5c, 0xcf, 0x66, 0x5f, 0xc3, 0xfe, 0x28,
	0x67, 0x45, 0x16, 0x0e, 0x27, 0x1a, 0x66, 0xc6, 0x5f, 0xe7, 0x81, 0xc4, 0xcc, 0x1d, 0xd9, 0x53,
	0xba, 0xdd, 0x89, 0x92, 0xe8, 0x11, 0xb8, 0x03, 0x1e, 0x4e, 0x92, 0x90, 0xab, 0xf0, 0x86, 0x11,
	0x2b, 0x52, 0xa1, 0xda, 0x9a, 0x1d, 0x34, 0x71, 0x92, 0xe8, 0xa8, 0xf7, 0xa4, 0x14, 0x7d, 0x0f,
	0xea, 0x31, 0xe5, 0x02, 0xa7, 0x11, 0xe1, 0x3e, 0x28, 0xe7, 0xe7, 0x82, 0xf6, 0x37, 0xb0, 0xaf,
	0x89, 0x38, 0x1f, 0x76, 0x07, 0xe9, 0x2d, 0x93, 0xbe, 0xea, 0xe9, 0x51, 0x4f, 0xb6, 0x7a, 0x83,
	0xbe, 0x00, 0x27, 0x22, 0xa9, 0xc8, 0xd9, 0xb7, 0x50, 0x63, 0x81, 0xdb, 0xc1, 0x4c, 0xa3, 0xfd,
	0x23, 0xd8, 0xd7, 0x25, 0xf3, 0x98, 0xbb, 0xda, 0xff, 0xb6, 0xa0, 0xb9, 0x02, 0xc4, 0xf0, 0x81,
	0x2e, 0x93, 0xc5, 0x91, 0x9d, 0xa6, 0xb7, 0x8c, 0x9b, 0x21, 0xec, 0xe3, 0x07, 0x5e, 0xb3, 0x6c,
	0x2b, 0x78, 0x76, 0xbf, 0x41, 0xca, 0xe5, 0x15, 0xba, 0x8e, 0xd7, 0xaf, 0x28, 0x3d, 0x70, 0xc5,
	0x26, 0xbf, 0x82, 0x67, 0x7c, 0x83, 0x94, 0x1f, 0xfd, 0xd7, 0x02, 0x67, 0xda, 0x8f, 0x90, 0x03,
	0xe5, 0xb7, 0x2c, 0x25, 0xde, 0x8e, 0x5c, 0xc9, 0x29, 0xc4, 0xb3, 0xe4, 0x6a, 0x90, 0x8a, 0xcf,
	0xbc, 0x12, 0xaa, 0x43, 0x65, 0x90, 0x8a, 0x57, 0x6f, 0x3c, 0xdb, 0x2c, 0x3f, 0x3d, 0xf5, 0xca,
	0x66, 0xf9, 0xe6, 0xb5, 0x57, 0x91, 0x4b, 0xd5, 0x20, 0x3d, 0x40, 0x00, 0x55, 0xfd, 0x1d, 0xf7,
	0x5c, 0xb9, 0xd6, 0xd5, 0xe9, 0xed, 0x23, 0x17, 0x6a, 0x37, 0x38, 0xef, 0xdd, 0xe1, 0xdc, 0x7b,
	0x26, 0xf1, 0xaa, 0x60, 0xbd, 0xe7, 0xf2, 0x16, 0xf9, 0xad, 0xf3, 0x3e, 0x40, 0x1e, 0x34, 0xba,
	0x0b, 0xdf, 0x04, 0x2f, 0x46, 0x4f, 0xc0, 0x5d, 0xe8, 0xbb, 0x1e, 0x41, 0x7b, 0xb0, 0x7b, 0xbe,
	0xd8, 0xe3, 0xbd, 0x5b, 0x84, 0xa0, 0xd9, 0x5d, 0x96, 0x8d, 0xd0, 0x33, 0xd8, 0xbb, 0x5e, 0xed,
	0xda, 0xde, 0xdd, 0xd1, 0x0d, 0xc0, 0xfc, 0x67, 0x52, 0x5e, 0xa7, 0x76, 0xbd, 0x9c, 0x60, 0x41,
	0x62, 0x6f, 0x47, 0x59, 0x9f, 0x49, 0xe4, 0xab, 0xad, 0x99, 0xa8, 0x9f, 0xb3, 0x2c, 0x93, 0xa2,
	0xd2, 0x4c, 0x4f, 0x89, 0x48, 0xec, 0xd9, 0xdd, 0x31, 0x34, 0x29, 0x9b, 0xe6, 0x63, 0x94, 0x67,
	0x51, 0xd7, 0xd5, 0xff, 0x44, 0x57, 0x32, 0x37, 0x57, 0xd6, 0xef, 0x5f, 0x8f, 0xa8, 0xb8, 0x2b,
	0x86, 0xf2, 0x2f, 0xe6, 0x44, 0xc3, 0x3e, 0xa1, 0x6c, 0xba, 0x52, 0x09, 0x3c, 0x19, 0xb1, 0x4f,
	0x70, 0x46, 0x4f, 0xee, 0x4f, 0x4f, 0x74, 0x2a, 0xb3, 0xe1, 0xdf, 0x2d, 0xeb, 0x9f, 0x25, 0xf4,
	0x6b, 0x6d, 0xb5, 0x97, 0x50, 0x92, 0x8a, 0xe3, 0x5f, 0xe4, 0x59, 0x34, 0xac, 0x2a, 0x8d, 0x4f,
	0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0xd3, 0x9d, 0x40, 0x06, 0xf5, 0x10, 0x00, 0x00,
}
