/*
 * Copyright (c) 2004 The FreeBSD Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#ident "$Id$"

#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <unistd.h>

int main (void)
{
	const char *user, *tty;
	uid_t uid;

	tty = ttyname (0);
	if (NULL == tty) {
		tty = "UNKNOWN";
	}
	user = getlogin ();
	if (NULL == user) {
		user = "UNKNOWN";
	}

	char *ssh_origcmd = getenv("SSH_ORIGINAL_COMMAND");
	uid = getuid (); /* getuid() is always successful */
	openlog ("nologin", LOG_CONS, LOG_AUTH);
	syslog (LOG_CRIT, "Attempted login by %s (UID: %d) on %s%s%s",
	        user, uid, tty,
		(ssh_origcmd ? " SSH_ORIGINAL_COMMAND=" : ""),
		(ssh_origcmd ? ssh_origcmd : ""));
	closelog ();

	printf ("%s", "This account is currently not available.\n");

	return EXIT_FAILURE;
}
