/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.MessageFormatter;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.helpers.ReaderWriterLock;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class Category
implements ULogger,
AppenderAttachable {
    private static final String FQCN = (class$org$apache$log4j$Category == null ? (class$org$apache$log4j$Category = Category.class$("org.apache.log4j.Category")) : class$org$apache$log4j$Category).getName();
    protected String name;
    protected volatile Level level;
    protected volatile Category parent;
    protected ResourceBundle resourceBundle;
    protected ReaderWriterLock lock;
    protected LoggerRepository repository;
    AppenderAttachableImpl aai;
    protected boolean additive = true;
    static /* synthetic */ Class class$org$apache$log4j$Category;

    protected Category(String name) {
        this.name = name;
        this.lock = new ReaderWriterLock();
    }

    public void addAppender(Appender newAppender) {
        this.lock.getWriteLock();
        if (this.aai == null) {
            this.aai = new AppenderAttachableImpl();
        }
        this.aai.addAppender(newAppender);
        this.lock.releaseWriteLock();
        this.repository.fireAddAppenderEvent((Logger)this, newAppender);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        Category c = this;
        while (c != null) {
            Object var5_4;
            try {
                c.lock.getReadLock();
                if (c.aai != null) {
                    writes += c.aai.appendLoopOnAppenders(event);
                }
                var5_4 = null;
                c.lock.releaseReadLock();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                c.lock.releaseReadLock();
                throw throwable;
            }
            if (!c.additive) break;
            c = c.parent;
        }
        if (writes == 0) {
            this.repository.emitNoAppenderWarning((Logger)this);
        }
    }

    void closeNestedAppenders() {
        Enumeration enumeration = this.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Appender a = (Appender)enumeration.nextElement();
                if (!(a instanceof AppenderAttachable)) continue;
                a.close();
            }
        }
    }

    public void debug(Object message) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, message, t);
        }
    }

    public void debug(Object messagePattern, Object arg) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            if (messagePattern instanceof String) {
                String msgStr = (String)messagePattern;
                msgStr = MessageFormatter.format(msgStr, arg);
                this.forcedLog(FQCN, Level.DEBUG, msgStr, null);
            } else {
                this.forcedLog(FQCN, Level.DEBUG, messagePattern, null);
            }
        }
    }

    public void debug(String messagePattern, Object arg1, Object arg2) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel())) {
            messagePattern = MessageFormatter.format(messagePattern, arg1, arg2);
            this.forcedLog(FQCN, Level.DEBUG, messagePattern, null);
        }
    }

    public boolean isErrorEnabled() {
        if (this.repository.isDisabled(40000)) {
            return false;
        }
        return Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public void error(Object message) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, message, null);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, message, t);
        }
    }

    public void error(Object messagePattern, Object arg) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            if (messagePattern instanceof String) {
                String msgStr = (String)messagePattern;
                msgStr = MessageFormatter.format(msgStr, arg);
                this.forcedLog(FQCN, Level.ERROR, msgStr, null);
            } else {
                this.forcedLog(FQCN, Level.ERROR, messagePattern, null);
            }
        }
    }

    public void error(String messagePattern, Object arg1, Object arg2) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (Level.ERROR.isGreaterOrEqual(this.getEffectiveLevel())) {
            messagePattern = MessageFormatter.format(messagePattern, arg1, arg2);
            this.forcedLog(FQCN, Level.ERROR, messagePattern, null);
        }
    }

    public static Logger exists(String name) {
        return LogManager.exists(name);
    }

    public void fatal(Object message) {
        if (this.repository.isDisabled(50000)) {
            return;
        }
        if (Level.FATAL.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.FATAL, message, null);
        }
    }

    public void fatal(Object messagePattern, Object arg) {
        if (this.repository.isDisabled(50000)) {
            return;
        }
        if (Level.FATAL.isGreaterOrEqual(this.getEffectiveLevel())) {
            if (messagePattern instanceof String) {
                String msgStr = (String)messagePattern;
                msgStr = MessageFormatter.format(msgStr, arg);
                this.forcedLog(FQCN, Level.FATAL, msgStr, null);
            } else {
                this.forcedLog(FQCN, Level.FATAL, messagePattern, null);
            }
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.repository.isDisabled(50000)) {
            return;
        }
        if (Level.FATAL.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.FATAL, message, t);
        }
    }

    protected void forcedLog(String fqcn, Priority level, Object message, Throwable t) {
        this.callAppenders(new LoggingEvent(fqcn, (Logger)this, level, message, t));
    }

    public boolean getAdditivity() {
        return this.additive;
    }

    public Enumeration getAllAppenders() {
        this.lock.getReadLock();
        Enumeration result = this.aai == null ? NullEnumeration.getInstance() : this.aai.getAllAppenders();
        this.lock.releaseReadLock();
        return result;
    }

    public Appender getAppender(String name) {
        this.lock.getReadLock();
        Appender result = this.aai == null || name == null ? null : this.aai.getAppender(name);
        this.lock.releaseReadLock();
        return result;
    }

    public Level getEffectiveLevel() {
        Category c = this;
        while (c != null) {
            if (c.level != null) {
                return c.level;
            }
            c = c.parent;
        }
        return null;
    }

    public Priority getChainedPriority() {
        Category c = this;
        while (c != null) {
            if (c.level != null) {
                return c.level;
            }
            c = c.parent;
        }
        return null;
    }

    public static Enumeration getCurrentCategories() {
        return LogManager.getCurrentLoggers();
    }

    public static LoggerRepository getDefaultHierarchy() {
        return LogManager.getLoggerRepository();
    }

    public LoggerRepository getHierarchy() {
        return this.repository;
    }

    public LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    public static Category getInstance(String name) {
        return LogManager.getLogger(name);
    }

    public static Category getInstance(Class clazz) {
        return LogManager.getLogger(clazz);
    }

    public final String getName() {
        return this.name;
    }

    public final Category getParent() {
        return this.parent;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final Level getPriority() {
        return this.level;
    }

    public static final Category getRoot() {
        return LogManager.getRootLogger();
    }

    public ResourceBundle getResourceBundle() {
        Category c = this;
        while (c != null) {
            if (c.resourceBundle != null) {
                return c.resourceBundle;
            }
            c = c.parent;
        }
        return null;
    }

    protected String getResourceBundleString(String key) {
        ResourceBundle rb = this.getResourceBundle();
        if (rb == null) {
            return null;
        }
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException mre) {
            this.error("No resource is associated with key \"" + key + "\".");
            return null;
        }
    }

    public void info(Object message) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, message, null);
        }
    }

    public void info(Object messagePattern, Object arg) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            if (messagePattern instanceof String) {
                String msgStr = (String)messagePattern;
                msgStr = MessageFormatter.format(msgStr, arg);
                this.forcedLog(FQCN, Level.INFO, msgStr, null);
            } else {
                this.forcedLog(FQCN, Level.INFO, messagePattern, null);
            }
        }
    }

    public void info(String messagePattern, Object arg1, Object arg2) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            messagePattern = MessageFormatter.format(messagePattern, arg1, arg2);
            this.forcedLog(FQCN, Level.INFO, messagePattern, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (Level.INFO.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, message, t);
        }
    }

    public boolean isAttached(Appender appender) {
        this.lock.getReadLock();
        boolean result = appender == null || this.aai == null ? false : this.aai.isAttached(appender);
        this.lock.releaseReadLock();
        return result;
    }

    public boolean isDebugEnabled() {
        if (this.repository.isDisabled(10000)) {
            return false;
        }
        return Level.DEBUG.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public boolean isTraceEnabled() {
        if (this.repository.isDisabled(5000)) {
            return false;
        }
        return Level.TRACE.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public boolean isEnabledFor(Level level) {
        if (this.repository.isDisabled(level.level)) {
            return false;
        }
        return level.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public boolean isEnabledFor(Priority level) {
        return this.isEnabledFor((Level)level);
    }

    public boolean isInfoEnabled() {
        if (this.repository.isDisabled(20000)) {
            return false;
        }
        return Level.INFO.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public void l7dlog(Priority level, String key, Throwable t) {
        if (this.repository.isDisabled(level.level)) {
            return;
        }
        if (level.isGreaterOrEqual(this.getEffectiveLevel())) {
            String msg = this.getResourceBundleString(key);
            if (msg == null) {
                msg = key;
            }
            this.forcedLog(FQCN, level, msg, t);
        }
    }

    public void l7dlog(Priority level, String key, Object[] params, Throwable t) {
        if (this.repository.isDisabled(level.level)) {
            return;
        }
        if (level.isGreaterOrEqual(this.getEffectiveLevel())) {
            String pattern = this.getResourceBundleString(key);
            String msg = pattern == null ? key : MessageFormat.format(pattern, params);
            this.forcedLog(FQCN, level, msg, t);
        }
    }

    public void log(Priority level, Object message, Throwable t) {
        this.log((Level)level, message, t);
    }

    public void log(Level level, Object message, Throwable t) {
        if (this.repository.isDisabled(level.level)) {
            return;
        }
        if (level.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, level, message, t);
        }
    }

    public void log(Priority level, Object message) {
        this.log((Level)level, message);
    }

    public void log(Level level, Object message) {
        if (this.repository.isDisabled(level.level)) {
            return;
        }
        if (level.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, level, message, null);
        }
    }

    public void log(String callerFQCN, Level level, Object message, Throwable t) {
        if (this.repository.isDisabled(level.level)) {
            return;
        }
        if (level.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(callerFQCN, level, message, t);
        }
    }

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.log(callerFQCN, (Level)level, message, t);
    }

    public void removeAllAppenders() {
        this.lock.getWriteLock();
        if (this.aai != null) {
            this.aai.removeAllAppenders();
            this.aai = null;
        }
        this.lock.releaseWriteLock();
    }

    public void removeAppender(Appender appender) {
        this.lock.getWriteLock();
        if (appender != null && this.aai != null) {
            this.aai.removeAppender(appender);
        }
        this.lock.releaseWriteLock();
    }

    public void removeAppender(String name) {
        this.lock.getWriteLock();
        if (name != null && this.aai != null) {
            this.aai.removeAppender(name);
        }
        this.lock.releaseWriteLock();
    }

    public void setAdditivity(boolean additive) {
        this.additive = additive;
    }

    final void setHierarchy(LoggerRepository repository) {
        this.repository = repository;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setPriority(Priority priority) {
        this.level = (Level)priority;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundle = bundle;
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public boolean isWarnEnabled() {
        if (this.repository.isDisabled(30000)) {
            return false;
        }
        return Level.WARN.isGreaterOrEqual(this.getEffectiveLevel());
    }

    public void warn(Object message) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, message, null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, message, t);
        }
    }

    public void warn(Object messagePattern, Object arg) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            if (messagePattern instanceof String) {
                String msgStr = (String)messagePattern;
                msgStr = MessageFormatter.format(msgStr, arg);
                this.forcedLog(FQCN, Level.WARN, msgStr, null);
            } else {
                this.forcedLog(FQCN, Level.WARN, messagePattern, null);
            }
        }
    }

    public void warn(String messagePattern, Object arg1, Object arg2) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (Level.WARN.isGreaterOrEqual(this.getEffectiveLevel())) {
            messagePattern = MessageFormatter.format(messagePattern, arg1, arg2);
            this.forcedLog(FQCN, Level.WARN, messagePattern, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

