#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/termios.h>
#include <sys/ioctl.h>
#include <string.h>
#include <errno.h>

#define BAUDRATE B19200         /* But both run at 19k2 */

#define ESC 0x1B
static char BRL_DISPLAY[] = { ESC, 0x01 };

#define LEN 2
static char DEVICE_ID[] = { ESC, 0x84 };

#define MAXREAD 18
static int brl_fd;              /* file descriptor for comm port */

static struct termios oldtio,   /* old terminal settings for com port */
  curtio;                       /* current settings */

static unsigned char *rawdata,  /* translated data to send to display */
 *prevdata,                     /* previous data sent */
 *dispbuf;

main (int argc, char **argv)
{
  unsigned char buf[MAXREAD + 1];

  int i = 0;

  if (argc < 2)
   {
     printf ("usage: %s /dev/ttyS[1..4]", argv[0]);
     return;
   }

  brl_fd = open (argv[1], O_RDWR | O_NOCTTY);

  tcgetattr (brl_fd, &oldtio);  /* save current settings */
  memcpy (&curtio, &oldtio, sizeof (struct termios));
  cfmakeraw (&curtio);

  curtio.c_lflag &= ~TOSTOP;    /* no SIGTTOU to backgrounded processes */
  curtio.c_cflag |= CLOCAL      /* ignore status lines (carrier detect...) */
    | CREAD;                    /* enable reading */
  curtio.c_cflag = BAUDRATE | CS8 | CLOCAL | CREAD;
  curtio.c_iflag &= ~(INPCK     /* no input parity check */
                      | ~IXOFF  /* don't send XON/XOFF */
    );

  curtio.c_cc[VTIME] = 1;       /* 0.1sec timeout between chars on input */
  curtio.c_cc[VMIN] = 0;        /* no minimum input. */

  tcsetattr (brl_fd, TCSAFLUSH, &curtio);
  /* write the ID-request */
  write (brl_fd, DEVICE_ID, LEN);
  usleep (100000);              /* wait for response */
  read (brl_fd, buf, MAXREAD);

  if (!strcmp (buf + 2, "Baum Vario40"))
    printf ("vario40");
  else if (!strcmp (buf + 2, "Baum Vario80"))
    printf ("vario80");
}
