.\" Automatically generated by Pandoc 2.11.4
.\"
.TH "CTWILL" "1" "February 6, 2021" "Web2c @VERSION@" "General Commands Manual"
.hy
.SH NAME
.PP
ctwill, ctwill-refsort, ctwill-twinx - translate CWEB to TeX with mini-indexes
.SH SYNOPSIS
.PP
\f[B]ctwill\f[R] [\f[I]options\f[R]] \f[I]webfile\f[R][.w]
[{\f[I]changefile\f[R][.ch]|-} [\f[I]outfile\f[R][.tex]]]
.PD 0
.P
.PD
\f[B]ctwill-refsort\f[R] < \f[I]indexfile\f[R].ref > \f[I]indexfile\f[R].sref
.PD 0
.P
.PD
\f[B]ctwill-twinx\f[R] \f[I]outfile\f[R].tex [\f[I]outfile\f[R].tex \&...] >
index.tex
.SH DESCRIPTION
.PP
The \f[B]ctwill\f[R] program converts a CWEB source document into a
TeX\ file that may be formatted and printed in the usual way.
It takes appropriate care of typographic details like page layout and
the use of indentation, \f[I]italics\f[R], \f[B]boldface\f[R], etc., and
it supplies extensive cross-index information that it gathers
automatically.
.PP
CWEB allows you to prepare a single document containing all the
information that is needed both to produce a compilable C/C++\ program
and to produce a well-formatted document describing the program in as
much detail as the writer may desire.
The user of CWEB ought to be familiar with TeX as well as C/C++.
.SH USAGE
.PP
The command line should have one, two, or three names on it.
The first is taken as the CWEB input file (and \f[B].w\f[R] is added if
there is no extension).
If there is a second name, it is a change file (and \f[B].ch\f[R] is
added if there is no extension).
The change file overrides parts of the CWEB file, as described in the
documentation.
If there is a third name, it overrides the default name of the output
file, which is ordinarily the same as the name of the input file (but on
the current directory) with the extension \f[B].tex\f[R].
If you just want to change the output file name, but don\[cq]t have a
change file to apply, you can use `\f[B]-\f[R]' as the second argument.
.PP
\f[B]ctwill\f[R] is exactly like \f[B]cweave\f[R] except that it
produces much better documentation, for which you must work harder.
You should run \f[B]ctwill\f[R] twice, once to prime the pump and once
to get decent answers.
Moreover, you must run the output twice through TeX.
.PP
After \f[B]tex foo\f[R] you will have output that looks like final pages
except that the entries of mini-indexes won\[cq]t be alphabetized.
The first run produces a weird file called \f[B]foo.ref\f[R].
Say \f[B]ctwill-refsort < foo.ref > foo.sref\f[R] and then another \f[B]tex
foo\f[R] will produce alphabetized output.
.PP
The \f[B]ctwill-twinx\f[R] program compiles a master index for a set of related
programs that have been processed by \f[B]ctwill\f[R].
The individual programs should define their names with a line of the
form \f[B]\[rs]def\[rs]title{NAME}\f[R].
.PP
The mini-indexes list identifiers that are used but not defined on each
two-page spread.
At the end of each section, \f[B]ctwill\f[R] gives TeX a list of
identifiers used in that section and information about where they are
defined.
.PP
The current meaning of every identifier is initially
\f[B]\[rs]uninitialized\f[R].
Then \f[B]ctwill\f[R] reads the \f[B].aux\f[R] file for your job, if
any.
.PP
Before reading the \f[B].aux\f[R] file, \f[B]ctwill\f[R] actually looks
for a file called \f[B]system.bux\f[R], which will be read if present.
And after \f[B]foo.aux\f[R], a third possibility is \f[B]foo.bux\f[R].
The general convention is to put definitions of system procedures such
as \f[I]printf\f[R] into \f[B]system.bux\f[R], and to put definitions
found in specifically foo-ish header files into \f[B]foo.bux\f[R].
Like the \f[B].aux\f[R] files, \f[B].bux\f[R] files should contain only
\f[B]\[at]$\f[R] specifications.
.PP
The meaning specified by \f[B]\[at]$\&...\[at]>\f[R] generally has four
components: an identifier (followed by space), a program name (enclosed
in braces), a section number (followed by space), and a TeX\ part.
.PP
A special \f[I]proofmode\f[R] is provided so that you can check
\f[B]ctwill\f[R]\[cq]s conclusions about cross-references.
Run \f[B]ctwill\f[R] with the flag \f[B]+P\f[R], and TeX will produce a
specially formatted document (\f[I]without\f[R] mini-indexes) in which
you can check that your specifications are correct.
.PP
More details how to use \f[B]ctwill\f[R] can be found in the first
sections of its source code, respectively the change file
\f[B]cweav-twill.ch\f[R] applicable to the \f[B]cweave.w\f[R] source.
A complete example with all bells and whistles is described in
\f[B]Mini-Indexes for Literate Programs\f[R], pages 225\[en]245 of
Knuth\[cq]s \f[B]Digital Typography\f[R].
.SH DIFFERENCES TO ORIGINAL CTWILL
.PP
The present incarnation of \f[B]ctwill\f[R] and its utilities tries hard
to be a drop-in replacement for the original package.
There are, however, a few differences worth noting:
.IP \[bu] 2
This version is based on the most recent version of CWEB (4.2).
.IP \[bu] 2
In TeX\ Live the utility programs are prefixed with \f[B]ctwill-\f[R]
and the macro files with \f[B]ct\f[R] for technical reasons.
.IP \[bu] 2
Options \f[B]--help\f[R], \f[B]--quiet\f[R], \f[B]--verbose\f[R],
\f[B]--version\f[R], and flags \f[B]-i\f[R], \f[B]-o\f[R], \f[B]-t\f[R],
and \f[B]+lX\f[R] are new in CWEBbin and TeX\ Live.
.IP \[bu] 2
Option \f[B]+lX\f[R] is accompanied by example wrapper files for
\f[B]ctwimac.tex\f[R] and \f[B]ctproofmac.tex\f[R] with translated
captions for German (\f[B]+ld\f[R]).
.IP \[bu] 2
Option \f[B]+lX\f[R] is also accompanied by an extended
\f[B]pdfctwimac.tex\f[R] for production of PDF output with active
hyperlinks (\f[B]+lpdf\f[R]).
.IP \[bu] 2
\f[B]ctwill\f[R] in TeX\ Live operates silently by default; use the
\f[B]--verbose\f[R] option to get the original behavior.
.IP \[bu] 2
File lookup with the environment variable CWEBINPUTS is extended to
permit several, colon-separated, paths; see ENVIRONMENT below.
.IP \[bu] 2
If properly configured, the main program \f[B]ctwill\f[R] is localized
with the \[lq]GNU gettext utilities\[rq].
.SH OPTIONS
.PP
Options on the command line may be either turned off with `\f[B]-\f[R]'
(if they are on by default) or turned on with `\f[B]+\f[R]' (if they are
off by default).
In fact, the options are processed from left to right, so a sequence
like \f[B]--verbose -h\f[R] will only show the \f[B]banner line\f[R]
(\f[B]+b\f[R]) and the \f[B]progress report\f[R] (\f[B]+p\f[R]), but
leave out the \f[B]happy message\f[R] (\f[B]-h\f[R]).
.IP \[bu] 2
\f[B]+b\f[R]: print banner line on terminal
.IP \[bu] 2
\f[B]+h\f[R]: print success message on completion
.IP \[bu] 2
\f[B]+p\f[R]: print progress report messages
.IP \[bu] 2
\f[B]+q\f[R]/\f[B]-q\f[R]: shortcut for \f[B]-bhp\f[R]; also
\f[B]--quiet\f[R] (default)
.IP \[bu] 2
\f[B]+v\f[R]/\f[B]-v\f[R]: shortcut for \f[B]+bhp\f[R]; also
\f[B]--verbose\f[R]
.IP \[bu] 2
\f[B]-e\f[R]: do not enclose C/C++\ material in \f[B]\[rs]PB{\&...}\f[R]
.IP \[bu] 2
\f[B]-f\f[R]: do not force a newline after every C/C++\ statement in
output
.IP \[bu] 2
\f[B]-i\f[R]: suppress indentation of parameter declarations
.IP \[bu] 2
\f[B]-o\f[R]: suppress separation of declarations and statements
.IP \[bu] 2
\f[B]-t\f[R]: ignore temporary output irrespective of changes
.IP \[bu] 2
\f[B]-x\f[R]: omit indices, section names, table of contents
.IP \[bu] 2
\f[B]+P\f[R]: \f[B]\[rs]input ctproofmac.tex\f[R] instead of
\f[B]ctwimac.tex\f[R]
.IP \[bu] 2
\f[B]+lX\f[R]/\f[B]-lX\f[R]: use macros for language \f[I]X\f[R] as of
\f[I]X\f[R]{\f[B]ctwimac\f[R]|\f[B]ctproofmac\f[R]}\f[B].tex\f[R]
.IP \[bu] 2
\f[B]+s\f[R]: print usage statistics
.IP \[bu] 2
\f[B]--help\f[R]: display help message and exit
.IP \[bu] 2
\f[B]--version\f[R]: output version information and exit
.SH ENVIRONMENT
.PP
The environment variable CWEBINPUTS is used to search for the input
files, or the system default if CWEBINPUTS is not set.
See tex(1) for the details of the searching.
To avoid conflicts with other programs that also use the CWEBINPUTS
environment, you can be more specific and use CWEBINPUTS_cweb for
special requirements in CWEB.
.PP
If prepared for NLS support, \f[B]ctwill\f[R] like \f[B]ctangle\f[R] and
\f[B]cweave\f[R] uses the environment variable TEXMFLOCALEDIR to
configure the parent directory where the \[lq]GNU gettext utilities\[rq]
search for translation catalogs.
.PP
These variables are preconfigured in TeX\ Live\[cq]s
\f[B]texmf.cnf\f[R].
.SH FILES
.PP
The location of the files mentioned below varies from system to system.
Use the \f[B]kpsewhich\f[R] utility to find their locations.
.IP \[bu] 2
\f[B]ctwimac.tex\f[R]: The default TeX\ macros \f[B]\[rs]input\f[R] in
the first line of the output file.
.IP \[bu] 2
\f[B]ctproofmac.tex\f[R]: If \f[B]ctwill\f[R] is invoked with the
\f[B]+P\f[R] option, it will change the first line of the output file to
\f[B]\[rs]input ctproofmac.tex\f[R].
.PP
In both cases you can request some prefix \f[I]X\f[R] with the
\f[B]+lX\f[R] option, e.g., \f[B]+ld\f[R] will \f[B]\[rs]input
dctwimac.tex\f[R] and \f[B]+Pld\f[R] will \f[B]\[rs]input
dctproofmac.tex\f[R].
A special application is the use of option \f[B]+lpdf\f[R] that will
\f[B]\[rs]input pdfctwimac.tex\f[R] for production of PDF output with
active hyperlinks.
.IP \[bu] 2
\f[I]webfile\f[R]\f[B].bux\f[R]: Reference definitions to resolve from
other modules.
.IP \[bu] 2
\f[B]system.bux\f[R]: Reference definitions to resolve from
C/C++\ standard library header files like \f[B]<stdio.h>\f[R].
.PP
Other \f[B]aux\f[R]iliary files with references are created
automatically by \f[B]ctwill\f[R] and the actual index files are created
by TeX.
.IP \[bu] 2
\f[B]cwebman.tex\f[R]: The CWEB user manual, available in PDF from
CTAN (https://ctan.org/pkg/cweb).
.SH SEE ALSO
.IP \[bu] 2
The CWEB System of Structured Documentation: by Donald E.\ Knuth and
Silvio Levy (hardcopy version of \f[B]cwebman.tex\f[R] and the source
code listings of \f[B]common.w\f[R], \f[B]ctangle.w\f[R], and
\f[B]cweave.w\f[R]).
.IP \[bu] 2
Digital Typography: by D.\ E.\ Knuth.
.IP \[bu] 2
Literate Programming: by D.\ E.\ Knuth.
.IP \[bu] 2
Weaving a Program: by Wayne Sewell.
.PP
cweb(1), tex(1), cc(1)
.SH AUTHORS
.PP
Don Knuth wrote \f[B]ctwill\f[R] based on \f[B]cweave\f[R] by Silvio
Levy and Knuth.
.PD 0
.P
.PD
\f[B]ctwill\f[R] and its utilities \f[B]ctwill-refsort\f[R] and \f[B]ctwill-twinx\f[R]
have been fully integrated with the CWEBbin extension that serves as the
basis for CWEB in TeX\ Live; see the project
page (https://github.com/ascherer/cwebbin).
