/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// LinuxContainerUserApplyConfiguration represents a declarative configuration of the LinuxContainerUser type for use
// with apply.
type LinuxContainerUserApplyConfiguration struct {
	UID                *int64  `json:"uid,omitempty"`
	GID                *int64  `json:"gid,omitempty"`
	SupplementalGroups []int64 `json:"supplementalGroups,omitempty"`
}

// LinuxContainerUserApplyConfiguration constructs a declarative configuration of the LinuxContainerUser type for use with
// apply.
func LinuxContainerUser() *LinuxContainerUserApplyConfiguration {
	return &LinuxContainerUserApplyConfiguration{}
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *LinuxContainerUserApplyConfiguration) WithUID(value int64) *LinuxContainerUserApplyConfiguration {
	b.UID = &value
	return b
}

// WithGID sets the GID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GID field is set to the value of the last call.
func (b *LinuxContainerUserApplyConfiguration) WithGID(value int64) *LinuxContainerUserApplyConfiguration {
	b.GID = &value
	return b
}

// WithSupplementalGroups adds the given value to the SupplementalGroups field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the SupplementalGroups field.
func (b *LinuxContainerUserApplyConfiguration) WithSupplementalGroups(values ...int64) *LinuxContainerUserApplyConfiguration {
	for i := range values {
		b.SupplementalGroups = append(b.SupplementalGroups, values[i])
	}
	return b
}
