; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc  -O0 -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL64-O0
; RUN: llc  -O0 -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large < %s \
; RUN:      | FileCheck %s --check-prefix=LARGE64-O0
; RUN: llc  -O0 -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc-ibm-aix-xcoff < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL32-O0
; RUN: llc  -O0 -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc-ibm-aix-xcoff --code-model=large < %s \
; RUN:      | FileCheck %s --check-prefix=LARGE32-O0

@TLInt = internal thread_local(localexec) global i32 0, align 4
@TLLongLong = internal thread_local(localexec) global i64 0, align 8
@TLDouble = internal thread_local(localexec) global double 0.000000e+00, align 8
@TLFloat = internal thread_local(localexec) global float 0.000000e+00, align 4
declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1

define void @storeInt(i32 noundef %x) {
; SMALL64-O0-LABEL: storeInt:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; SMALL64-O0-NEXT:    ld r4, L..C0(r2) # target-flags(ppc-tprel) @TLInt
; SMALL64-O0-NEXT:    add r4, r13, r4
; SMALL64-O0-NEXT:    stw r3, 0(r4)
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: storeInt:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; LARGE64-O0-NEXT:    addis r4, L..C0@u(r2)
; LARGE64-O0-NEXT:    ld r4, L..C0@l(r4)
; LARGE64-O0-NEXT:    add r4, r13, r4
; LARGE64-O0-NEXT:    stw r3, 0(r4)
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: storeInt:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    stw r3, 28(r1) # 4-byte Folded Spill
; SMALL32-O0-NEXT:    lwz r5, L..C0(r2) # target-flags(ppc-tprel) @TLInt
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    mr r4, r3
; SMALL32-O0-NEXT:    lwz r3, 28(r1) # 4-byte Folded Reload
; SMALL32-O0-NEXT:    add r4, r4, r5
; SMALL32-O0-NEXT:    stw r3, 0(r4)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: storeInt:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    stw r3, 28(r1) # 4-byte Folded Spill
; LARGE32-O0-NEXT:    addis r3, L..C0@u(r2)
; LARGE32-O0-NEXT:    lwz r5, L..C0@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    mr r4, r3
; LARGE32-O0-NEXT:    lwz r3, 28(r1) # 4-byte Folded Reload
; LARGE32-O0-NEXT:    add r4, r4, r5
; LARGE32-O0-NEXT:    stw r3, 0(r4)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @TLInt)
  store i32 %x, ptr %0, align 4
  ret void
}

define void @storeLongLong(i64 noundef %x) {
; SMALL64-O0-LABEL: storeLongLong:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r4, L..C1(r2) # target-flags(ppc-tprel) @TLLongLong
; SMALL64-O0-NEXT:    add r4, r13, r4
; SMALL64-O0-NEXT:    std r3, 0(r4)
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: storeLongLong:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r4, L..C1@u(r2)
; LARGE64-O0-NEXT:    ld r4, L..C1@l(r4)
; LARGE64-O0-NEXT:    add r4, r13, r4
; LARGE64-O0-NEXT:    std r3, 0(r4)
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: storeLongLong:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    mr r5, r4
; SMALL32-O0-NEXT:    stw r3, 28(r1) # 4-byte Folded Spill
; SMALL32-O0-NEXT:    # kill: def $r4 killed $r5
; SMALL32-O0-NEXT:    lwz r6, L..C1(r2) # target-flags(ppc-tprel) @TLLongLong
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    mr r4, r3
; SMALL32-O0-NEXT:    lwz r3, 28(r1) # 4-byte Folded Reload
; SMALL32-O0-NEXT:    add r4, r4, r6
; SMALL32-O0-NEXT:    stw r5, 4(r4)
; SMALL32-O0-NEXT:    stw r3, 0(r4)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: storeLongLong:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    mr r5, r4
; LARGE32-O0-NEXT:    stw r3, 28(r1) # 4-byte Folded Spill
; LARGE32-O0-NEXT:    # kill: def $r4 killed $r5
; LARGE32-O0-NEXT:    addis r3, L..C1@u(r2)
; LARGE32-O0-NEXT:    lwz r6, L..C1@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    mr r4, r3
; LARGE32-O0-NEXT:    lwz r3, 28(r1) # 4-byte Folded Reload
; LARGE32-O0-NEXT:    add r4, r4, r6
; LARGE32-O0-NEXT:    stw r5, 4(r4)
; LARGE32-O0-NEXT:    stw r3, 0(r4)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @TLLongLong)
  store i64 %x, ptr %0, align 8
  ret void
}

define void @storeDouble(double noundef %x) {
; SMALL64-O0-LABEL: storeDouble:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tprel) @TLDouble
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    stxsdx f1, 0, r3
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: storeDouble:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C2@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C2@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    stxsdx f1, 0, r3
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: storeDouble:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C2(r2) # target-flags(ppc-tprel) @TLDouble
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    stfd f1, 0(r3)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: storeDouble:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C2@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C2@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    stfd f1, 0(r3)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @TLDouble)
  store double %x, ptr %0, align 8
  ret void
}

define void @storeFloat(float noundef %x) {
; SMALL64-O0-LABEL: storeFloat:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C3(r2) # target-flags(ppc-tprel) @TLFloat
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    stfs f1, 0(r3)
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: storeFloat:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C3@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C3@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    stfs f1, 0(r3)
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: storeFloat:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C3(r2) # target-flags(ppc-tprel) @TLFloat
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    stfs f1, 0(r3)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: storeFloat:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C3@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C3@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    stfs f1, 0(r3)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @TLFloat)
  store float %x, ptr %0, align 4
  ret void
}

define i32 @loadInt() {
; SMALL64-O0-LABEL: loadInt:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tprel) @TLInt
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    lwz r3, 0(r3)
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: loadInt:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C0@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C0@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    lwz r3, 0(r3)
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: loadInt:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C0(r2) # target-flags(ppc-tprel) @TLInt
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    lwz r3, 0(r3)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: loadInt:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C0@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C0@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    lwz r3, 0(r3)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @TLInt)
  %1 = load i32, ptr %0, align 4
  ret i32 %1
}

define i32 @loadLongLong() {
; SMALL64-O0-LABEL: loadLongLong:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C1(r2) # target-flags(ppc-tprel) @TLLongLong
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    ld r3, 0(r3)
; SMALL64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; SMALL64-O0-NEXT:    clrldi r3, r3, 32
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: loadLongLong:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C1@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C1@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    ld r3, 0(r3)
; LARGE64-O0-NEXT:    # kill: def $r3 killed $r3 killed $x3
; LARGE64-O0-NEXT:    clrldi r3, r3, 32
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: loadLongLong:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C1(r2) # target-flags(ppc-tprel) @TLLongLong
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    lwz r3, 4(r3)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: loadLongLong:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C1@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C1@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    lwz r3, 4(r3)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @TLLongLong)
  %1 = load i64, ptr %0, align 8
  %conv = trunc i64 %1 to i32
  ret i32 %conv
}

define i32 @loadDouble() {
; SMALL64-O0-LABEL: loadDouble:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tprel) @TLDouble
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    lfd f0, 0(r3)
; SMALL64-O0-NEXT:    # kill: def $f1 killed $f0
; SMALL64-O0-NEXT:    xscvdpsxws f0, f0
; SMALL64-O0-NEXT:    addi r3, r1, -12
; SMALL64-O0-NEXT:    stfiwx f0, 0, r3
; SMALL64-O0-NEXT:    lwz r3, -12(r1)
; SMALL64-O0-NEXT:    clrldi r3, r3, 32
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: loadDouble:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C2@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C2@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    lfd f0, 0(r3)
; LARGE64-O0-NEXT:    # kill: def $f1 killed $f0
; LARGE64-O0-NEXT:    xscvdpsxws f0, f0
; LARGE64-O0-NEXT:    addi r3, r1, -12
; LARGE64-O0-NEXT:    stfiwx f0, 0, r3
; LARGE64-O0-NEXT:    lwz r3, -12(r1)
; LARGE64-O0-NEXT:    clrldi r3, r3, 32
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: loadDouble:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C2(r2) # target-flags(ppc-tprel) @TLDouble
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    lfd f0, 0(r3)
; SMALL32-O0-NEXT:    xscvdpsxws f0, f0
; SMALL32-O0-NEXT:    addi r3, r1, 28
; SMALL32-O0-NEXT:    stfiwx f0, 0, r3
; SMALL32-O0-NEXT:    lwz r3, 28(r1)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: loadDouble:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C2@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C2@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    lfd f0, 0(r3)
; LARGE32-O0-NEXT:    xscvdpsxws f0, f0
; LARGE32-O0-NEXT:    addi r3, r1, 28
; LARGE32-O0-NEXT:    stfiwx f0, 0, r3
; LARGE32-O0-NEXT:    lwz r3, 28(r1)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @TLDouble)
  %1 = load double, ptr %0, align 8
  %conv = fptosi double %1 to i32
  ret i32 %conv
}

define i32 @loadFloat() {
; SMALL64-O0-LABEL: loadFloat:
; SMALL64-O0:       # %bb.0: # %entry
; SMALL64-O0-NEXT:    ld r3, L..C3(r2) # target-flags(ppc-tprel) @TLFloat
; SMALL64-O0-NEXT:    add r3, r13, r3
; SMALL64-O0-NEXT:    lfs f0, 0(r3)
; SMALL64-O0-NEXT:    fctiwz f0, f0
; SMALL64-O0-NEXT:    stfd f0, -8(r1)
; SMALL64-O0-NEXT:    lwa r3, -4(r1)
; SMALL64-O0-NEXT:    clrldi r3, r3, 32
; SMALL64-O0-NEXT:    blr
;
; LARGE64-O0-LABEL: loadFloat:
; LARGE64-O0:       # %bb.0: # %entry
; LARGE64-O0-NEXT:    addis r3, L..C3@u(r2)
; LARGE64-O0-NEXT:    ld r3, L..C3@l(r3)
; LARGE64-O0-NEXT:    add r3, r13, r3
; LARGE64-O0-NEXT:    lfs f0, 0(r3)
; LARGE64-O0-NEXT:    fctiwz f0, f0
; LARGE64-O0-NEXT:    stfd f0, -8(r1)
; LARGE64-O0-NEXT:    lwa r3, -4(r1)
; LARGE64-O0-NEXT:    clrldi r3, r3, 32
; LARGE64-O0-NEXT:    blr
;
; SMALL32-O0-LABEL: loadFloat:
; SMALL32-O0:       # %bb.0: # %entry
; SMALL32-O0-NEXT:    mflr r0
; SMALL32-O0-NEXT:    stwu r1, -32(r1)
; SMALL32-O0-NEXT:    stw r0, 40(r1)
; SMALL32-O0-NEXT:    lwz r4, L..C3(r2) # target-flags(ppc-tprel) @TLFloat
; SMALL32-O0-NEXT:    bla .__get_tpointer[PR]
; SMALL32-O0-NEXT:    add r3, r3, r4
; SMALL32-O0-NEXT:    lfs f0, 0(r3)
; SMALL32-O0-NEXT:    xscvdpsxws f0, f0
; SMALL32-O0-NEXT:    addi r3, r1, 28
; SMALL32-O0-NEXT:    stfiwx f0, 0, r3
; SMALL32-O0-NEXT:    lwz r3, 28(r1)
; SMALL32-O0-NEXT:    addi r1, r1, 32
; SMALL32-O0-NEXT:    lwz r0, 8(r1)
; SMALL32-O0-NEXT:    mtlr r0
; SMALL32-O0-NEXT:    blr
;
; LARGE32-O0-LABEL: loadFloat:
; LARGE32-O0:       # %bb.0: # %entry
; LARGE32-O0-NEXT:    mflr r0
; LARGE32-O0-NEXT:    stwu r1, -32(r1)
; LARGE32-O0-NEXT:    stw r0, 40(r1)
; LARGE32-O0-NEXT:    addis r3, L..C3@u(r2)
; LARGE32-O0-NEXT:    lwz r4, L..C3@l(r3)
; LARGE32-O0-NEXT:    bla .__get_tpointer[PR]
; LARGE32-O0-NEXT:    add r3, r3, r4
; LARGE32-O0-NEXT:    lfs f0, 0(r3)
; LARGE32-O0-NEXT:    xscvdpsxws f0, f0
; LARGE32-O0-NEXT:    addi r3, r1, 28
; LARGE32-O0-NEXT:    stfiwx f0, 0, r3
; LARGE32-O0-NEXT:    lwz r3, 28(r1)
; LARGE32-O0-NEXT:    addi r1, r1, 32
; LARGE32-O0-NEXT:    lwz r0, 8(r1)
; LARGE32-O0-NEXT:    mtlr r0
; LARGE32-O0-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @TLFloat)
  %1 = load float, ptr %0, align 4
  %conv = fptosi float %1 to i32
  ret i32 %conv
}

; TOC Entry Checks.

; SMALL64-O0-LABEL: .toc
; SMALL64-O0-LABEL:L..C0:
; SMALL64-O0-NEXT:	.tc TLInt[TC],TLInt[UL]@le
; SMALL64-O0-LABEL:L..C1:
; SMALL64-O0-NEXT:	.tc TLLongLong[TC],TLLongLong[UL]@le
; SMALL64-O0-LABEL:L..C2:
; SMALL64-O0-NEXT:	.tc TLDouble[TC],TLDouble[UL]@le
; SMALL64-O0-LABEL:L..C3:
; SMALL64-O0-NEXT:	.tc TLFloat[TC],TLFloat[UL]@le

; LARGE64-O0-LABEL: .toc
; LARGE64-O0-LABEL:L..C0:
; LARGE64-O0-NEXT:	.tc TLInt[TE],TLInt[UL]@le
; LARGE64-O0-LABEL:L..C1:
; LARGE64-O0-NEXT:	.tc TLLongLong[TE],TLLongLong[UL]@le
; LARGE64-O0-LABEL:L..C2:
; LARGE64-O0-NEXT:	.tc TLDouble[TE],TLDouble[UL]@le
; LARGE64-O0-LABEL:L..C3:
; LARGE64-O0-NEXT:	.tc TLFloat[TE],TLFloat[UL]@le

; SMALL32-O0-LABEL: .toc
; SMALL32-O0-LABEL:L..C0:
; SMALL32-O0-NEXT:	.tc TLInt[TC],TLInt[UL]@le
; SMALL32-O0-LABEL:L..C1:
; SMALL32-O0-NEXT:	.tc TLLongLong[TC],TLLongLong[UL]@le
; SMALL32-O0-LABEL:L..C2:
; SMALL32-O0-NEXT:	.tc TLDouble[TC],TLDouble[UL]@le
; SMALL32-O0-LABEL:L..C3:
; SMALL32-O0-NEXT:	.tc TLFloat[TC],TLFloat[UL]@le

; LARGE32-O0-LABEL: .toc
; LARGE32-O0-LABEL:L..C0:
; LARGE32-O0-NEXT:	.tc TLInt[TE],TLInt[UL]@le
; LARGE32-O0-LABEL:L..C1:
; LARGE32-O0-NEXT:	.tc TLLongLong[TE],TLLongLong[UL]@le
; LARGE32-O0-LABEL:L..C2:
; LARGE32-O0-NEXT:	.tc TLDouble[TE],TLDouble[UL]@le
; LARGE32-O0-LABEL:L..C3:
; LARGE32-O0-NEXT:	.tc TLFloat[TE],TLFloat[UL]@le

