; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible-sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

;
; ANDV
;

define i8 @andv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: andv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @andv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: andv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @andv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: andv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @andv_v32i8(ptr %a) {
; CHECK-LABEL: andv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.and.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @andv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: andv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @andv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: andv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @andv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: andv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @andv_v16i16(ptr %a) {
; CHECK-LABEL: andv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @andv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: andv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @andv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: andv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @andv_v8i32(ptr %a) {
; CHECK-LABEL: andv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @andv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: andv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    andv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @andv_v4i64(ptr %a) {
; CHECK-LABEL: andv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    and z0.d, z1.d, z0.d
; CHECK-NEXT:    andv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; EORV
;

define i8 @eorv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: eorv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: eorv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: eorv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @eorv_v32i8(ptr %a) {
; CHECK-LABEL: eorv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.xor.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @eorv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: eorv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: eorv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: eorv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @eorv_v16i16(ptr %a) {
; CHECK-LABEL: eorv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @eorv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: eorv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @eorv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: eorv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @eorv_v8i32(ptr %a) {
; CHECK-LABEL: eorv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @eorv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: eorv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    eorv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @eorv_v4i64(ptr %a) {
; CHECK-LABEL: eorv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    eor z0.d, z1.d, z0.d
; CHECK-NEXT:    eorv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %op)
  ret i64 %res
}

;
; ORV
;

define i8 @orv_v4i8(<4 x i8> %a) {
; CHECK-LABEL: orv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v4i8(<4 x i8> %a)
  ret i8 %res
}

define i8 @orv_v8i8(<8 x i8> %a) {
; CHECK-LABEL: orv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v8i8(<8 x i8> %a)
  ret i8 %res
}

define i8 @orv_v16i8(<16 x i8> %a) {
; CHECK-LABEL: orv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %a)
  ret i8 %res
}

define i8 @orv_v32i8(ptr %a) {
; CHECK-LABEL: orv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv b0, p0, z0.b
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <32 x i8>, ptr %a
  %res = call i8 @llvm.vector.reduce.or.v32i8(<32 x i8> %op)
  ret i8 %res
}

define i16 @orv_v2i16(<2 x i16> %a) {
; CHECK-LABEL: orv_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v2i16(<2 x i16> %a)
  ret i16 %res
}

define i16 @orv_v4i16(<4 x i16> %a) {
; CHECK-LABEL: orv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v4i16(<4 x i16> %a)
  ret i16 %res
}

define i16 @orv_v8i16(<8 x i16> %a) {
; CHECK-LABEL: orv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %a)
  ret i16 %res
}

define i16 @orv_v16i16(ptr %a) {
; CHECK-LABEL: orv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv h0, p0, z0.h
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <16 x i16>, ptr %a
  %res = call i16 @llvm.vector.reduce.or.v16i16(<16 x i16> %op)
  ret i16 %res
}

define i32 @orv_v2i32(<2 x i32> %a) {
; CHECK-LABEL: orv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.or.v2i32(<2 x i32> %a)
  ret i32 %res
}

define i32 @orv_v4i32(<4 x i32> %a) {
; CHECK-LABEL: orv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %res = call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %a)
  ret i32 %res
}

define i32 @orv_v8i32(ptr %a) {
; CHECK-LABEL: orv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv s0, p0, z0.s
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %op = load <8 x i32>, ptr %a
  %res = call i32 @llvm.vector.reduce.or.v8i32(<8 x i32> %op)
  ret i32 %res
}

define i64 @orv_v2i64(<2 x i64> %a) {
; CHECK-LABEL: orv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    orv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %res = call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %a)
  ret i64 %res
}

define i64 @orv_v4i64(ptr %a) {
; CHECK-LABEL: orv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    orr z0.d, z1.d, z0.d
; CHECK-NEXT:    orv d0, p0, z0.d
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    ret
  %op = load <4 x i64>, ptr %a
  %res = call i64 @llvm.vector.reduce.or.v4i64(<4 x i64> %op)
  ret i64 %res
}

declare i8 @llvm.vector.reduce.and.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.and.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.and.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.and.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.and.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.and.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.and.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.and.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.and.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.and.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.and.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.or.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.or.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.or.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.or.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.or.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.or.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.or.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.or.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.or.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.or.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.or.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.or.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.or.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.xor.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.xor.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.xor.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.xor.v32i8(<32 x i8>)

declare i16 @llvm.vector.reduce.xor.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.xor.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.xor.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.xor.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.xor.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.xor.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.xor.v8i32(<8 x i32>)

declare i64 @llvm.vector.reduce.xor.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.xor.v4i64(<4 x i64>)
