/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.loader.AbstractEntityLoader;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.sql.ConditionFragment;
import net.sf.hibernate.type.Type;

public class EntityLoader
extends AbstractEntityLoader
implements UniqueEntityLoader {
    private final Type[] idType;

    public EntityLoader(Loadable persister, SessionFactoryImplementor factory) throws MappingException {
        super(persister, factory);
        this.idType = new Type[]{persister.getIdentifierType()};
        String condition = new ConditionFragment().setTableAlias(this.alias).setCondition(persister.getIdentifierColumnNames(), "?").toFragmentString();
        this.renderStatement(condition, factory);
        this.postInstantiate();
    }

    public Object load(SessionImplementor session, Serializable id, Object object) throws HibernateException, SQLException {
        List list = this.loadEntity(session, new Object[]{id}, this.idType, object, id, false);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        throw new HibernateException("More than one row with the given identifier was found: " + id + ", for class: " + this.persister.getClassName());
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row[row.length - 1];
    }
}

