/*
 * Decompiled with CFR 0.152.
 */
package org.fedoraproject.xmvn.tools.subst;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class SubstCliRequest {
    @Parameter
    private List<String> parameters = new LinkedList<String>();
    @Parameter(names={"-h", "--help"}, help=true, description="Display usage information")
    private boolean help;
    @Parameter(names={"-X", "--debug"}, description="Display debugging information")
    private boolean debug = false;
    @Parameter(names={"-s", "--strict"}, description="Fail if any artifact cannot be symlinked")
    private boolean strict = false;
    @Parameter(names={"-d", "--dry-run"}, description="Do not symlink anything but report what would have been symlinked")
    private boolean dryRun = false;
    @Parameter(names={"-L", "--follow-symlinks"}, description="Follow symbolic links when traversing directory structure")
    private boolean followSymlinks = false;
    @Parameter(names={"-t", "--type"}, description="Consider artifacts with given type")
    private List<String> types = new ArrayList<String>(Arrays.asList("jar", "war"));
    @Parameter(names={"-R", "--root"}, description="Consider another root when looking for artifacts")
    private String root;
    @DynamicParameter(names={"-D"}, description="Define system property")
    private Map<String, String> defines = new TreeMap<String, String>();

    public SubstCliRequest(String[] args) {
        try {
            JCommander jcomm = new JCommander((Object)this);
            jcomm.setProgramName("xmvn-subst");
            jcomm.parse(args);
            if (this.help) {
                System.out.println("xmvn-subst: Substitute artifact files with symbolic links");
                System.out.println();
                jcomm.usage();
                System.exit(0);
            }
            for (String param : this.defines.keySet()) {
                System.setProperty(param, this.defines.get(param));
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage() + ". Specify -h for usage.");
            System.exit(1);
        }
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Map<String, String> getDefines() {
        return this.defines;
    }

    public void setDefines(Map<String, String> defines) {
        this.defines = defines;
    }
}

