/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_PRIVATE_DATA_SLOT_H
#define VN_PROTOCOL_DRIVER_PRIVATE_DATA_SLOT_H

#include "vn_instance.h"
#include "vn_protocol_driver_structs.h"

/* struct VkPrivateDataSlotCreateInfo chain */

static inline size_t
vn_sizeof_VkPrivateDataSlotCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPrivateDataSlotCreateInfo_self(const VkPrivateDataSlotCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline size_t
vn_sizeof_VkPrivateDataSlotCreateInfo(const VkPrivateDataSlotCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPrivateDataSlotCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkPrivateDataSlotCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPrivateDataSlotCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPrivateDataSlotCreateInfo_self(struct vn_cs_encoder *enc, const VkPrivateDataSlotCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_encode_VkPrivateDataSlotCreateInfo(struct vn_cs_encoder *enc, const VkPrivateDataSlotCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO });
    vn_encode_VkPrivateDataSlotCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkPrivateDataSlotCreateInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkCreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pCreateInfo);
    if (pCreateInfo)
        cmd_size += vn_sizeof_VkPrivateDataSlotCreateInfo(pCreateInfo);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);
    cmd_size += vn_sizeof_simple_pointer(pPrivateDataSlot);
    if (pPrivateDataSlot)
        cmd_size += vn_sizeof_VkPrivateDataSlot(pPrivateDataSlot);

    return cmd_size;
}

static inline void vn_encode_vkCreatePrivateDataSlot(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pCreateInfo))
        vn_encode_VkPrivateDataSlotCreateInfo(enc, pCreateInfo);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
    if (vn_encode_simple_pointer(enc, pPrivateDataSlot))
        vn_encode_VkPrivateDataSlot(enc, pPrivateDataSlot);
}

static inline size_t vn_sizeof_vkCreatePrivateDataSlot_reply(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    cmd_size += vn_sizeof_simple_pointer(pPrivateDataSlot);
    if (pPrivateDataSlot)
        cmd_size += vn_sizeof_VkPrivateDataSlot(pPrivateDataSlot);

    return cmd_size;
}

static inline VkResult vn_decode_vkCreatePrivateDataSlot_reply(struct vn_cs_decoder *dec, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCreatePrivateDataSlot_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pCreateInfo */
    /* skip pAllocator */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkPrivateDataSlot(dec, pPrivateDataSlot);
    } else {
        pPrivateDataSlot = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkDestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkPrivateDataSlot(&privateDataSlot);
    cmd_size += vn_sizeof_simple_pointer(pAllocator);
    if (pAllocator)
        assert(false);

    return cmd_size;
}

static inline void vn_encode_vkDestroyPrivateDataSlot(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkPrivateDataSlot(enc, &privateDataSlot);
    if (vn_encode_simple_pointer(enc, pAllocator))
        assert(false);
}

static inline size_t vn_sizeof_vkDestroyPrivateDataSlot_reply(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip privateDataSlot */
    /* skip pAllocator */

    return cmd_size;
}

static inline void vn_decode_vkDestroyPrivateDataSlot_reply(struct vn_cs_decoder *dec, VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkDestroyPrivateDataSlot_EXT);

    /* skip device */
    /* skip privateDataSlot */
    /* skip pAllocator */
}

static inline size_t vn_sizeof_vkSetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkSetPrivateData_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkObjectType(&objectType);
    cmd_size += vn_sizeof_uint64_t(&objectHandle);
    cmd_size += vn_sizeof_VkPrivateDataSlot(&privateDataSlot);
    cmd_size += vn_sizeof_uint64_t(&data);

    return cmd_size;
}

static inline void vn_encode_vkSetPrivateData(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkSetPrivateData_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkObjectType(enc, &objectType);
    vn_encode_uint64_t(enc, &objectHandle);
    vn_encode_VkPrivateDataSlot(enc, &privateDataSlot);
    vn_encode_uint64_t(enc, &data);
}

static inline size_t vn_sizeof_vkSetPrivateData_reply(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkSetPrivateData_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip objectType */
    /* skip objectHandle */
    /* skip privateDataSlot */
    /* skip data */

    return cmd_size;
}

static inline VkResult vn_decode_vkSetPrivateData_reply(struct vn_cs_decoder *dec, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkSetPrivateData_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip objectType */
    /* skip objectHandle */
    /* skip privateDataSlot */
    /* skip data */

    return ret;
}

static inline size_t vn_sizeof_vkGetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPrivateData_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkObjectType(&objectType);
    cmd_size += vn_sizeof_uint64_t(&objectHandle);
    cmd_size += vn_sizeof_VkPrivateDataSlot(&privateDataSlot);
    cmd_size += vn_sizeof_simple_pointer(pData); /* out */

    return cmd_size;
}

static inline void vn_encode_vkGetPrivateData(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPrivateData_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkObjectType(enc, &objectType);
    vn_encode_uint64_t(enc, &objectHandle);
    vn_encode_VkPrivateDataSlot(enc, &privateDataSlot);
    vn_encode_simple_pointer(enc, pData); /* out */
}

static inline size_t vn_sizeof_vkGetPrivateData_reply(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkGetPrivateData_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip objectType */
    /* skip objectHandle */
    /* skip privateDataSlot */
    cmd_size += vn_sizeof_simple_pointer(pData);
    if (pData)
        cmd_size += vn_sizeof_uint64_t(pData);

    return cmd_size;
}

static inline void vn_decode_vkGetPrivateData_reply(struct vn_cs_decoder *dec, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkGetPrivateData_EXT);

    /* skip device */
    /* skip objectType */
    /* skip objectHandle */
    /* skip privateDataSlot */
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_uint64_t(dec, pData);
    } else {
        pData = NULL;
    }
}

static inline void vn_submit_vkCreatePrivateDataSlot(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCreatePrivateDataSlot_reply(device, pCreateInfo, pAllocator, pPrivateDataSlot) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkCreatePrivateDataSlot(enc, cmd_flags, device, pCreateInfo, pAllocator, pPrivateDataSlot);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkDestroyPrivateDataSlot(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkDestroyPrivateDataSlot(device, privateDataSlot, pAllocator);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkDestroyPrivateDataSlot_reply(device, privateDataSlot, pAllocator) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkDestroyPrivateDataSlot(enc, cmd_flags, device, privateDataSlot, pAllocator);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkSetPrivateData(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkSetPrivateData(device, objectType, objectHandle, privateDataSlot, data);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkSetPrivateData_reply(device, objectType, objectHandle, privateDataSlot, data) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkSetPrivateData(enc, cmd_flags, device, objectType, objectHandle, privateDataSlot, data);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline void vn_submit_vkGetPrivateData(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }
    const size_t reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkGetPrivateData_reply(device, objectType, objectHandle, privateDataSlot, pData) : 0;

    struct vn_cs_encoder *enc = vn_instance_submit_command_init(vn_instance, submit, cmd_data, cmd_size, reply_size);
    if (cmd_size) {
        vn_encode_vkGetPrivateData(enc, cmd_flags, device, objectType, objectHandle, privateDataSlot, pData);
        vn_instance_submit_command(vn_instance, submit);
        if (cmd_data != local_cmd_data)
            free(cmd_data);
    }
}

static inline VkResult vn_call_vkCreatePrivateDataSlot(struct vn_instance *vn_instance, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkCreatePrivateDataSlot(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pCreateInfo, pAllocator, pPrivateDataSlot, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkCreatePrivateDataSlot_reply(dec, device, pCreateInfo, pAllocator, pPrivateDataSlot);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkCreatePrivateDataSlot(struct vn_instance *vn_instance, VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCreatePrivateDataSlot(vn_instance, 0, device, pCreateInfo, pAllocator, pPrivateDataSlot, &submit);
}

static inline void vn_call_vkDestroyPrivateDataSlot(struct vn_instance *vn_instance, VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPrivateDataSlot(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, privateDataSlot, pAllocator, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkDestroyPrivateDataSlot_reply(dec, device, privateDataSlot, pAllocator);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkDestroyPrivateDataSlot(struct vn_instance *vn_instance, VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkDestroyPrivateDataSlot(vn_instance, 0, device, privateDataSlot, pAllocator, &submit);
}

static inline VkResult vn_call_vkSetPrivateData(struct vn_instance *vn_instance, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkSetPrivateData(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, objectType, objectHandle, privateDataSlot, data, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        const VkResult ret = vn_decode_vkSetPrivateData_reply(dec, device, objectType, objectHandle, privateDataSlot, data);
        vn_instance_free_command_reply(vn_instance, &submit);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkSetPrivateData(struct vn_instance *vn_instance, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkSetPrivateData(vn_instance, 0, device, objectType, objectHandle, privateDataSlot, data, &submit);
}

static inline void vn_call_vkGetPrivateData(struct vn_instance *vn_instance, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    VN_TRACE_FUNC();

    struct vn_instance_submit_command submit;
    vn_submit_vkGetPrivateData(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, objectType, objectHandle, privateDataSlot, pData, &submit);
    struct vn_cs_decoder *dec = vn_instance_get_command_reply(vn_instance, &submit);
    if (dec) {
        vn_decode_vkGetPrivateData_reply(dec, device, objectType, objectHandle, privateDataSlot, pData);
        vn_instance_free_command_reply(vn_instance, &submit);
    }
}

static inline void vn_async_vkGetPrivateData(struct vn_instance *vn_instance, VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkGetPrivateData(vn_instance, 0, device, objectType, objectHandle, privateDataSlot, pData, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_PRIVATE_DATA_SLOT_H */
