/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.url;

import fr.jayasoft.ivy.url.AbstractURLHandler;
import fr.jayasoft.ivy.url.URLHandler;
import fr.jayasoft.ivy.util.CopyProgressListener;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public class BasicURLHandler
extends AbstractURLHandler {
    public URLHandler.URLInfo getURLInfo(URL url) {
        return this.getURLInfo(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLHandler.URLInfo getURLInfo(URL url, int timeout) {
        block18: {
            URLConnection con = null;
            try {
                con = url.openConnection();
                if (con instanceof HttpURLConnection) {
                    int status = ((HttpURLConnection)con).getResponseCode();
                    if (status == 200) {
                        URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, ((HttpURLConnection)con).getContentLength(), con.getLastModified());
                        return uRLInfo;
                    }
                    if (status == 407) {
                        Message.warn("Your proxy requires authentication.");
                    } else if (String.valueOf(status).startsWith("4")) {
                        Message.verbose("CLIENT ERROR: " + ((HttpURLConnection)con).getResponseMessage() + " url=" + url);
                    } else if (String.valueOf(status).startsWith("5")) {
                        Message.error("SERVER ERROR: " + ((HttpURLConnection)con).getResponseMessage() + " url=" + url);
                    }
                    Message.debug("HTTP response status: " + status + " url=" + url);
                    break block18;
                }
                int contentLength = con.getContentLength();
                if (contentLength <= 0) {
                    URLHandler.URLInfo uRLInfo = UNAVAILABLE;
                    return uRLInfo;
                }
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, contentLength, con.getLastModified());
                return uRLInfo;
            }
            catch (UnknownHostException e) {
                Message.warn("Host " + e.getMessage() + " not found. url=" + url);
                Message.info("You probably access the destination server through a proxy server that is not well configured.");
            }
            catch (IOException e) {
                Message.error("Server access Error: " + e.getMessage() + " url=" + url);
            }
            finally {
                if (con instanceof HttpURLConnection) {
                    ((HttpURLConnection)con).disconnect();
                }
            }
        }
        return UNAVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openStream(URL url) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        URLConnection conn;
        block5: {
            conn = null;
            InputStream inStream = null;
            try {
                int len;
                conn = url.openConnection();
                inStream = conn.getInputStream();
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((len = inStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
                byteArrayInputStream = new ByteArrayInputStream(outStream.toByteArray());
                Object var9_8 = null;
                if (inStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var9_9 = null;
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (conn == null || !(conn instanceof HttpURLConnection)) break block6;
                    ((HttpURLConnection)conn).disconnect();
                }
                throw throwable;
            }
            inStream.close();
        }
        if (conn != null && conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        URLConnection srcConn = null;
        try {
            srcConn = src.openConnection();
            FileUtil.copy(srcConn.getInputStream(), dest, l);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (srcConn != null && srcConn instanceof HttpURLConnection) {
                ((HttpURLConnection)srcConn).disconnect();
            }
            throw throwable;
        }
        if (srcConn != null && srcConn instanceof HttpURLConnection) {
            ((HttpURLConnection)srcConn).disconnect();
        }
    }

    private static interface HttpStatus {
        public static final int SC_OK = 200;
        public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    }
}

