#!/usr/bin/env bash
. $builddir/tests/test_common.sh

set -e
set -o pipefail

result=`mktemp`
stderr=`mktemp`

$OSCAP xccdf eval --results $result $srcdir/test_xccdf_check_unsupported_check_system.xml 2> $stderr
echo "Stderr file = $stderr"
grep "Skipping rule that requires an unregistered check system or incorrect content reference to evaluate." $stderr
rm $stderr

$OSCAP xccdf validate --skip-schematron $result

assert_exists 1 '//rule-result[@idref="xccdf_moc.elpmaxe.www_rule_1"]/result[text()="notchecked"]'
rm $result
