// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct VerifyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    pub signature_valid: bool,
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub signing_algorithm: ::std::option::Option<crate::types::SigningAlgorithmSpec>,
    _request_id: Option<String>,
}
impl VerifyOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    pub fn signature_valid(&self) -> bool {
        self.signature_valid
    }
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub fn signing_algorithm(&self) -> ::std::option::Option<&crate::types::SigningAlgorithmSpec> {
        self.signing_algorithm.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for VerifyOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl VerifyOutput {
    /// Creates a new builder-style object to manufacture [`VerifyOutput`](crate::operation::verify::VerifyOutput).
    pub fn builder() -> crate::operation::verify::builders::VerifyOutputBuilder {
        crate::operation::verify::builders::VerifyOutputBuilder::default()
    }
}

/// A builder for [`VerifyOutput`](crate::operation::verify::VerifyOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct VerifyOutputBuilder {
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) signature_valid: ::std::option::Option<bool>,
    pub(crate) signing_algorithm: ::std::option::Option<crate::types::SigningAlgorithmSpec>,
    _request_id: Option<String>,
}
impl VerifyOutputBuilder {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to verify the signature.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    pub fn signature_valid(mut self, input: bool) -> Self {
        self.signature_valid = ::std::option::Option::Some(input);
        self
    }
    /// <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    pub fn set_signature_valid(mut self, input: ::std::option::Option<bool>) -> Self {
        self.signature_valid = input;
        self
    }
    /// <p>A Boolean value that indicates whether the signature was verified. A value of <code>True</code> indicates that the <code>Signature</code> was produced by signing the <code>Message</code> with the specified <code>KeyID</code> and <code>SigningAlgorithm.</code> If the signature is not verified, the <code>Verify</code> operation fails with a <code>KMSInvalidSignatureException</code> exception.</p>
    pub fn get_signature_valid(&self) -> &::std::option::Option<bool> {
        &self.signature_valid
    }
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub fn signing_algorithm(mut self, input: crate::types::SigningAlgorithmSpec) -> Self {
        self.signing_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub fn set_signing_algorithm(mut self, input: ::std::option::Option<crate::types::SigningAlgorithmSpec>) -> Self {
        self.signing_algorithm = input;
        self
    }
    /// <p>The signing algorithm that was used to verify the signature.</p>
    pub fn get_signing_algorithm(&self) -> &::std::option::Option<crate::types::SigningAlgorithmSpec> {
        &self.signing_algorithm
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`VerifyOutput`](crate::operation::verify::VerifyOutput).
    pub fn build(self) -> crate::operation::verify::VerifyOutput {
        crate::operation::verify::VerifyOutput {
            key_id: self.key_id,
            signature_valid: self.signature_valid.unwrap_or_default(),
            signing_algorithm: self.signing_algorithm,
            _request_id: self._request_id,
        }
    }
}
