// RUN: llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s

s_mov_b32 s5, s1
// CHECK: [0x01,0x00,0x85,0xbe]

s_mov_b32 s101, s1
// CHECK: [0x01,0x00,0xe5,0xbe]

s_mov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x00,0xe6,0xbe]

s_mov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x00,0xe7,0xbe]

s_mov_b32 vcc_lo, s1
// CHECK: [0x01,0x00,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// CHECK: [0x01,0x00,0xeb,0xbe]

s_mov_b32 ttmp15, s1
// CHECK: [0x01,0x00,0xfb,0xbe]

s_mov_b32 m0, s1
// CHECK: [0x01,0x00,0xfc,0xbe]

s_mov_b32 exec_lo, s1
// CHECK: [0x01,0x00,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// CHECK: [0x01,0x00,0xff,0xbe]

s_mov_b32 s5, s101
// CHECK: [0x65,0x00,0x85,0xbe]

s_mov_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x00,0x85,0xbe]

s_mov_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x00,0x85,0xbe]

s_mov_b32 s5, vcc_lo
// CHECK: [0x6a,0x00,0x85,0xbe]

s_mov_b32 s5, vcc_hi
// CHECK: [0x6b,0x00,0x85,0xbe]

s_mov_b32 s5, ttmp15
// CHECK: [0x7b,0x00,0x85,0xbe]

s_mov_b32 s5, m0
// CHECK: [0x7c,0x00,0x85,0xbe]

s_mov_b32 s5, exec_lo
// CHECK: [0x7e,0x00,0x85,0xbe]

s_mov_b32 s5, exec_hi
// CHECK: [0x7f,0x00,0x85,0xbe]

s_mov_b32 s5, 0
// CHECK: [0x80,0x00,0x85,0xbe]

s_mov_b32 s5, -1
// CHECK: [0xc1,0x00,0x85,0xbe]

s_mov_b32 s5, 0.5
// CHECK: [0xf0,0x00,0x85,0xbe]

s_mov_b32 s5, -4.0
// CHECK: [0xf7,0x00,0x85,0xbe]

s_mov_b32 s5, src_vccz
// CHECK: [0xfb,0x00,0x85,0xbe]

s_mov_b32 s5, src_execz
// CHECK: [0xfc,0x00,0x85,0xbe]

s_mov_b32 s5, src_scc
// CHECK: [0xfd,0x00,0x85,0xbe]

s_mov_b32 s5, 0xaf123456
// CHECK: [0xff,0x00,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b32 s5, 0x3f717273
// CHECK: [0xff,0x00,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x01,0x8a,0xbe]

s_mov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x01,0x8c,0xbe]

s_mov_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x01,0xe4,0xbe]

s_mov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x01,0xe6,0xbe]

s_mov_b64 vcc, s[2:3]
// CHECK: [0x02,0x01,0xea,0xbe]

s_mov_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x01,0xfa,0xbe]

s_mov_b64 exec, s[2:3]
// CHECK: [0x02,0x01,0xfe,0xbe]

s_mov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], vcc
// CHECK: [0x6a,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], exec
// CHECK: [0x7e,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], 0
// CHECK: [0x80,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], -1
// CHECK: [0xc1,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], src_execz
// CHECK: [0xfc,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], src_scc
// CHECK: [0xfd,0x01,0x8a,0xbe]

s_mov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x01,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x01,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s5, s1
// CHECK: [0x01,0x02,0x85,0xbe]

s_cmov_b32 s101, s1
// CHECK: [0x01,0x02,0xe5,0xbe]

s_cmov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x02,0xe6,0xbe]

s_cmov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x02,0xe7,0xbe]

s_cmov_b32 vcc_lo, s1
// CHECK: [0x01,0x02,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// CHECK: [0x01,0x02,0xeb,0xbe]

s_cmov_b32 ttmp15, s1
// CHECK: [0x01,0x02,0xfb,0xbe]

s_cmov_b32 m0, s1
// CHECK: [0x01,0x02,0xfc,0xbe]

s_cmov_b32 exec_lo, s1
// CHECK: [0x01,0x02,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// CHECK: [0x01,0x02,0xff,0xbe]

s_cmov_b32 s5, s101
// CHECK: [0x65,0x02,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x02,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x02,0x85,0xbe]

s_cmov_b32 s5, vcc_lo
// CHECK: [0x6a,0x02,0x85,0xbe]

s_cmov_b32 s5, vcc_hi
// CHECK: [0x6b,0x02,0x85,0xbe]

s_cmov_b32 s5, ttmp15
// CHECK: [0x7b,0x02,0x85,0xbe]

s_cmov_b32 s5, m0
// CHECK: [0x7c,0x02,0x85,0xbe]

s_cmov_b32 s5, exec_lo
// CHECK: [0x7e,0x02,0x85,0xbe]

s_cmov_b32 s5, exec_hi
// CHECK: [0x7f,0x02,0x85,0xbe]

s_cmov_b32 s5, 0
// CHECK: [0x80,0x02,0x85,0xbe]

s_cmov_b32 s5, -1
// CHECK: [0xc1,0x02,0x85,0xbe]

s_cmov_b32 s5, 0.5
// CHECK: [0xf0,0x02,0x85,0xbe]

s_cmov_b32 s5, -4.0
// CHECK: [0xf7,0x02,0x85,0xbe]

s_cmov_b32 s5, src_vccz
// CHECK: [0xfb,0x02,0x85,0xbe]

s_cmov_b32 s5, src_execz
// CHECK: [0xfc,0x02,0x85,0xbe]

s_cmov_b32 s5, src_scc
// CHECK: [0xfd,0x02,0x85,0xbe]

s_cmov_b32 s5, 0xaf123456
// CHECK: [0xff,0x02,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b32 s5, 0x3f717273
// CHECK: [0xff,0x02,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x03,0x8a,0xbe]

s_cmov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x03,0x8c,0xbe]

s_cmov_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x03,0xe4,0xbe]

s_cmov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x03,0xe6,0xbe]

s_cmov_b64 vcc, s[2:3]
// CHECK: [0x02,0x03,0xea,0xbe]

s_cmov_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x03,0xfa,0xbe]

s_cmov_b64 exec, s[2:3]
// CHECK: [0x02,0x03,0xfe,0xbe]

s_cmov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], vcc
// CHECK: [0x6a,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], exec
// CHECK: [0x7e,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], 0
// CHECK: [0x80,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], -1
// CHECK: [0xc1,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], src_execz
// CHECK: [0xfc,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], src_scc
// CHECK: [0xfd,0x03,0x8a,0xbe]

s_cmov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x03,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x03,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s5, s1
// CHECK: [0x01,0x04,0x85,0xbe]

s_not_b32 s101, s1
// CHECK: [0x01,0x04,0xe5,0xbe]

s_not_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x04,0xe6,0xbe]

s_not_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x04,0xe7,0xbe]

s_not_b32 vcc_lo, s1
// CHECK: [0x01,0x04,0xea,0xbe]

s_not_b32 vcc_hi, s1
// CHECK: [0x01,0x04,0xeb,0xbe]

s_not_b32 ttmp15, s1
// CHECK: [0x01,0x04,0xfb,0xbe]

s_not_b32 m0, s1
// CHECK: [0x01,0x04,0xfc,0xbe]

s_not_b32 exec_lo, s1
// CHECK: [0x01,0x04,0xfe,0xbe]

s_not_b32 exec_hi, s1
// CHECK: [0x01,0x04,0xff,0xbe]

s_not_b32 s5, s101
// CHECK: [0x65,0x04,0x85,0xbe]

s_not_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x04,0x85,0xbe]

s_not_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x04,0x85,0xbe]

s_not_b32 s5, vcc_lo
// CHECK: [0x6a,0x04,0x85,0xbe]

s_not_b32 s5, vcc_hi
// CHECK: [0x6b,0x04,0x85,0xbe]

s_not_b32 s5, ttmp15
// CHECK: [0x7b,0x04,0x85,0xbe]

s_not_b32 s5, m0
// CHECK: [0x7c,0x04,0x85,0xbe]

s_not_b32 s5, exec_lo
// CHECK: [0x7e,0x04,0x85,0xbe]

s_not_b32 s5, exec_hi
// CHECK: [0x7f,0x04,0x85,0xbe]

s_not_b32 s5, 0
// CHECK: [0x80,0x04,0x85,0xbe]

s_not_b32 s5, -1
// CHECK: [0xc1,0x04,0x85,0xbe]

s_not_b32 s5, 0.5
// CHECK: [0xf0,0x04,0x85,0xbe]

s_not_b32 s5, -4.0
// CHECK: [0xf7,0x04,0x85,0xbe]

s_not_b32 s5, src_vccz
// CHECK: [0xfb,0x04,0x85,0xbe]

s_not_b32 s5, src_execz
// CHECK: [0xfc,0x04,0x85,0xbe]

s_not_b32 s5, src_scc
// CHECK: [0xfd,0x04,0x85,0xbe]

s_not_b32 s5, 0xaf123456
// CHECK: [0xff,0x04,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s5, 0x3f717273
// CHECK: [0xff,0x04,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x05,0x8a,0xbe]

s_not_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x05,0x8c,0xbe]

s_not_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x05,0xe4,0xbe]

s_not_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x05,0xe6,0xbe]

s_not_b64 vcc, s[2:3]
// CHECK: [0x02,0x05,0xea,0xbe]

s_not_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x05,0xfa,0xbe]

s_not_b64 exec, s[2:3]
// CHECK: [0x02,0x05,0xfe,0xbe]

s_not_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x05,0x8a,0xbe]

s_not_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x05,0x8a,0xbe]

s_not_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x05,0x8a,0xbe]

s_not_b64 s[10:11], vcc
// CHECK: [0x6a,0x05,0x8a,0xbe]

s_not_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x05,0x8a,0xbe]

s_not_b64 s[10:11], exec
// CHECK: [0x7e,0x05,0x8a,0xbe]

s_not_b64 s[10:11], 0
// CHECK: [0x80,0x05,0x8a,0xbe]

s_not_b64 s[10:11], -1
// CHECK: [0xc1,0x05,0x8a,0xbe]

s_not_b64 s[10:11], 0.5
// CHECK: [0xf0,0x05,0x8a,0xbe]

s_not_b64 s[10:11], -4.0
// CHECK: [0xf7,0x05,0x8a,0xbe]

s_not_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x05,0x8a,0xbe]

s_not_b64 s[10:11], src_execz
// CHECK: [0xfc,0x05,0x8a,0xbe]

s_not_b64 s[10:11], src_scc
// CHECK: [0xfd,0x05,0x8a,0xbe]

s_not_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x05,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x05,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s5, s1
// CHECK: [0x01,0x06,0x85,0xbe]

s_wqm_b32 s101, s1
// CHECK: [0x01,0x06,0xe5,0xbe]

s_wqm_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x06,0xe6,0xbe]

s_wqm_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x06,0xe7,0xbe]

s_wqm_b32 vcc_lo, s1
// CHECK: [0x01,0x06,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// CHECK: [0x01,0x06,0xeb,0xbe]

s_wqm_b32 ttmp15, s1
// CHECK: [0x01,0x06,0xfb,0xbe]

s_wqm_b32 m0, s1
// CHECK: [0x01,0x06,0xfc,0xbe]

s_wqm_b32 exec_lo, s1
// CHECK: [0x01,0x06,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// CHECK: [0x01,0x06,0xff,0xbe]

s_wqm_b32 s5, s101
// CHECK: [0x65,0x06,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x06,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x06,0x85,0xbe]

s_wqm_b32 s5, vcc_lo
// CHECK: [0x6a,0x06,0x85,0xbe]

s_wqm_b32 s5, vcc_hi
// CHECK: [0x6b,0x06,0x85,0xbe]

s_wqm_b32 s5, ttmp15
// CHECK: [0x7b,0x06,0x85,0xbe]

s_wqm_b32 s5, m0
// CHECK: [0x7c,0x06,0x85,0xbe]

s_wqm_b32 s5, exec_lo
// CHECK: [0x7e,0x06,0x85,0xbe]

s_wqm_b32 s5, exec_hi
// CHECK: [0x7f,0x06,0x85,0xbe]

s_wqm_b32 s5, 0
// CHECK: [0x80,0x06,0x85,0xbe]

s_wqm_b32 s5, -1
// CHECK: [0xc1,0x06,0x85,0xbe]

s_wqm_b32 s5, 0.5
// CHECK: [0xf0,0x06,0x85,0xbe]

s_wqm_b32 s5, -4.0
// CHECK: [0xf7,0x06,0x85,0xbe]

s_wqm_b32 s5, src_vccz
// CHECK: [0xfb,0x06,0x85,0xbe]

s_wqm_b32 s5, src_execz
// CHECK: [0xfc,0x06,0x85,0xbe]

s_wqm_b32 s5, src_scc
// CHECK: [0xfd,0x06,0x85,0xbe]

s_wqm_b32 s5, 0xaf123456
// CHECK: [0xff,0x06,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s5, 0x3f717273
// CHECK: [0xff,0x06,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x07,0x8a,0xbe]

s_wqm_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x07,0x8c,0xbe]

s_wqm_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x07,0xe4,0xbe]

s_wqm_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x07,0xe6,0xbe]

s_wqm_b64 vcc, s[2:3]
// CHECK: [0x02,0x07,0xea,0xbe]

s_wqm_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x07,0xfa,0xbe]

s_wqm_b64 exec, s[2:3]
// CHECK: [0x02,0x07,0xfe,0xbe]

s_wqm_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], vcc
// CHECK: [0x6a,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], exec
// CHECK: [0x7e,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], 0
// CHECK: [0x80,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], -1
// CHECK: [0xc1,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], 0.5
// CHECK: [0xf0,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], -4.0
// CHECK: [0xf7,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], src_execz
// CHECK: [0xfc,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], src_scc
// CHECK: [0xfd,0x07,0x8a,0xbe]

s_wqm_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x07,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x07,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s5, s1
// CHECK: [0x01,0x08,0x85,0xbe]

s_brev_b32 s101, s1
// CHECK: [0x01,0x08,0xe5,0xbe]

s_brev_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x08,0xe6,0xbe]

s_brev_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x08,0xe7,0xbe]

s_brev_b32 vcc_lo, s1
// CHECK: [0x01,0x08,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// CHECK: [0x01,0x08,0xeb,0xbe]

s_brev_b32 ttmp15, s1
// CHECK: [0x01,0x08,0xfb,0xbe]

s_brev_b32 m0, s1
// CHECK: [0x01,0x08,0xfc,0xbe]

s_brev_b32 exec_lo, s1
// CHECK: [0x01,0x08,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// CHECK: [0x01,0x08,0xff,0xbe]

s_brev_b32 s5, s101
// CHECK: [0x65,0x08,0x85,0xbe]

s_brev_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x08,0x85,0xbe]

s_brev_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x08,0x85,0xbe]

s_brev_b32 s5, vcc_lo
// CHECK: [0x6a,0x08,0x85,0xbe]

s_brev_b32 s5, vcc_hi
// CHECK: [0x6b,0x08,0x85,0xbe]

s_brev_b32 s5, ttmp15
// CHECK: [0x7b,0x08,0x85,0xbe]

s_brev_b32 s5, m0
// CHECK: [0x7c,0x08,0x85,0xbe]

s_brev_b32 s5, exec_lo
// CHECK: [0x7e,0x08,0x85,0xbe]

s_brev_b32 s5, exec_hi
// CHECK: [0x7f,0x08,0x85,0xbe]

s_brev_b32 s5, 0
// CHECK: [0x80,0x08,0x85,0xbe]

s_brev_b32 s5, -1
// CHECK: [0xc1,0x08,0x85,0xbe]

s_brev_b32 s5, 0.5
// CHECK: [0xf0,0x08,0x85,0xbe]

s_brev_b32 s5, -4.0
// CHECK: [0xf7,0x08,0x85,0xbe]

s_brev_b32 s5, src_vccz
// CHECK: [0xfb,0x08,0x85,0xbe]

s_brev_b32 s5, src_execz
// CHECK: [0xfc,0x08,0x85,0xbe]

s_brev_b32 s5, src_scc
// CHECK: [0xfd,0x08,0x85,0xbe]

s_brev_b32 s5, 0xaf123456
// CHECK: [0xff,0x08,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s5, 0x3f717273
// CHECK: [0xff,0x08,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x09,0x8a,0xbe]

s_brev_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x09,0x8c,0xbe]

s_brev_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x09,0xe4,0xbe]

s_brev_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x09,0xe6,0xbe]

s_brev_b64 vcc, s[2:3]
// CHECK: [0x02,0x09,0xea,0xbe]

s_brev_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x09,0xfa,0xbe]

s_brev_b64 exec, s[2:3]
// CHECK: [0x02,0x09,0xfe,0xbe]

s_brev_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], vcc
// CHECK: [0x6a,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], exec
// CHECK: [0x7e,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], 0
// CHECK: [0x80,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], -1
// CHECK: [0xc1,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], 0.5
// CHECK: [0xf0,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], -4.0
// CHECK: [0xf7,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], src_execz
// CHECK: [0xfc,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], src_scc
// CHECK: [0xfd,0x09,0x8a,0xbe]

s_brev_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x09,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x09,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s5, s1
// CHECK: [0x01,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s101, s1
// CHECK: [0x01,0x0a,0xe5,0xbe]

s_bcnt0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0a,0xe6,0xbe]

s_bcnt0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0a,0xe7,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0a,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0a,0xeb,0xbe]

s_bcnt0_i32_b32 ttmp15, s1
// CHECK: [0x01,0x0a,0xfb,0xbe]

s_bcnt0_i32_b32 m0, s1
// CHECK: [0x01,0x0a,0xfc,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0a,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0a,0xff,0xbe]

s_bcnt0_i32_b32 s5, s101
// CHECK: [0x65,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, ttmp15
// CHECK: [0x7b,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, m0
// CHECK: [0x7c,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0
// CHECK: [0x80,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, -1
// CHECK: [0xc1,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_execz
// CHECK: [0xfc,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, src_scc
// CHECK: [0xfd,0x0a,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0a,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0a,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s101, s[2:3]
// CHECK: [0x02,0x0b,0xe5,0xbe]

s_bcnt0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x0b,0xe6,0xbe]

s_bcnt0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x0b,0xe7,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x0b,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x0b,0xeb,0xbe]

s_bcnt0_i32_b64 ttmp15, s[2:3]
// CHECK: [0x02,0x0b,0xfb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x0b,0xfc,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x0b,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x0b,0xff,0xbe]

s_bcnt0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, s[100:101]
// CHECK: [0x64,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, flat_scratch
// CHECK: [0x66,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, vcc
// CHECK: [0x6a,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, ttmp[14:15]
// CHECK: [0x7a,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, exec
// CHECK: [0x7e,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0
// CHECK: [0x80,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, -1
// CHECK: [0xc1,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_execz
// CHECK: [0xfc,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, src_scc
// CHECK: [0xfd,0x0b,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x0b,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x0b,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s5, s1
// CHECK: [0x01,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s101, s1
// CHECK: [0x01,0x0c,0xe5,0xbe]

s_bcnt1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0c,0xe6,0xbe]

s_bcnt1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0c,0xe7,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0c,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0c,0xeb,0xbe]

s_bcnt1_i32_b32 ttmp15, s1
// CHECK: [0x01,0x0c,0xfb,0xbe]

s_bcnt1_i32_b32 m0, s1
// CHECK: [0x01,0x0c,0xfc,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0c,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0c,0xff,0xbe]

s_bcnt1_i32_b32 s5, s101
// CHECK: [0x65,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, ttmp15
// CHECK: [0x7b,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, m0
// CHECK: [0x7c,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0
// CHECK: [0x80,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, -1
// CHECK: [0xc1,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_execz
// CHECK: [0xfc,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, src_scc
// CHECK: [0xfd,0x0c,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0c,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0c,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s101, s[2:3]
// CHECK: [0x02,0x0d,0xe5,0xbe]

s_bcnt1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x0d,0xe6,0xbe]

s_bcnt1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x0d,0xe7,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x0d,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x0d,0xeb,0xbe]

s_bcnt1_i32_b64 ttmp15, s[2:3]
// CHECK: [0x02,0x0d,0xfb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x0d,0xfc,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x0d,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x0d,0xff,0xbe]

s_bcnt1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, s[100:101]
// CHECK: [0x64,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, flat_scratch
// CHECK: [0x66,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, vcc
// CHECK: [0x6a,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, ttmp[14:15]
// CHECK: [0x7a,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, exec
// CHECK: [0x7e,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0
// CHECK: [0x80,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, -1
// CHECK: [0xc1,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_execz
// CHECK: [0xfc,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, src_scc
// CHECK: [0xfd,0x0d,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x0d,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x0d,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b32 s5, s1
// CHECK: [0x01,0x0e,0x85,0xbe]

s_ff0_i32_b32 s101, s1
// CHECK: [0x01,0x0e,0xe5,0xbe]

s_ff0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0e,0xe6,0xbe]

s_ff0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0e,0xe7,0xbe]

s_ff0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0e,0xea,0xbe]

s_ff0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0e,0xeb,0xbe]

s_ff0_i32_b32 ttmp15, s1
// CHECK: [0x01,0x0e,0xfb,0xbe]

s_ff0_i32_b32 m0, s1
// CHECK: [0x01,0x0e,0xfc,0xbe]

s_ff0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0e,0xfe,0xbe]

s_ff0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0e,0xff,0xbe]

s_ff0_i32_b32 s5, s101
// CHECK: [0x65,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, ttmp15
// CHECK: [0x7b,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, m0
// CHECK: [0x7c,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, 0
// CHECK: [0x80,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, -1
// CHECK: [0xc1,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, src_execz
// CHECK: [0xfc,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, src_scc
// CHECK: [0xfd,0x0e,0x85,0xbe]

s_ff0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0e,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0e,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x0f,0x85,0xbe]

s_ff0_i32_b64 s101, s[2:3]
// CHECK: [0x02,0x0f,0xe5,0xbe]

s_ff0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x0f,0xe6,0xbe]

s_ff0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x0f,0xe7,0xbe]

s_ff0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x0f,0xea,0xbe]

s_ff0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x0f,0xeb,0xbe]

s_ff0_i32_b64 ttmp15, s[2:3]
// CHECK: [0x02,0x0f,0xfb,0xbe]

s_ff0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x0f,0xfc,0xbe]

s_ff0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x0f,0xfe,0xbe]

s_ff0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x0f,0xff,0xbe]

s_ff0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, s[100:101]
// CHECK: [0x64,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, flat_scratch
// CHECK: [0x66,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, vcc
// CHECK: [0x6a,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, ttmp[14:15]
// CHECK: [0x7a,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, exec
// CHECK: [0x7e,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, 0
// CHECK: [0x80,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, -1
// CHECK: [0xc1,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, src_execz
// CHECK: [0xfc,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, src_scc
// CHECK: [0xfd,0x0f,0x85,0xbe]

s_ff0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x0f,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x0f,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s5, s1
// CHECK: [0x01,0x10,0x85,0xbe]

s_ff1_i32_b32 s101, s1
// CHECK: [0x01,0x10,0xe5,0xbe]

s_ff1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x10,0xe6,0xbe]

s_ff1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x10,0xe7,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x10,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x10,0xeb,0xbe]

s_ff1_i32_b32 ttmp15, s1
// CHECK: [0x01,0x10,0xfb,0xbe]

s_ff1_i32_b32 m0, s1
// CHECK: [0x01,0x10,0xfc,0xbe]

s_ff1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x10,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x10,0xff,0xbe]

s_ff1_i32_b32 s5, s101
// CHECK: [0x65,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, ttmp15
// CHECK: [0x7b,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, m0
// CHECK: [0x7c,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, 0
// CHECK: [0x80,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, -1
// CHECK: [0xc1,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, src_execz
// CHECK: [0xfc,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, src_scc
// CHECK: [0xfd,0x10,0x85,0xbe]

s_ff1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x10,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x10,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x11,0x85,0xbe]

s_ff1_i32_b64 s101, s[2:3]
// CHECK: [0x02,0x11,0xe5,0xbe]

s_ff1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x11,0xe6,0xbe]

s_ff1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x11,0xe7,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x11,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x11,0xeb,0xbe]

s_ff1_i32_b64 ttmp15, s[2:3]
// CHECK: [0x02,0x11,0xfb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x11,0xfc,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x11,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x11,0xff,0xbe]

s_ff1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, s[100:101]
// CHECK: [0x64,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, flat_scratch
// CHECK: [0x66,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, vcc
// CHECK: [0x6a,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, ttmp[14:15]
// CHECK: [0x7a,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, exec
// CHECK: [0x7e,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, 0
// CHECK: [0x80,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, -1
// CHECK: [0xc1,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, src_execz
// CHECK: [0xfc,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, src_scc
// CHECK: [0xfd,0x11,0x85,0xbe]

s_ff1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x11,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x11,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s5, s1
// CHECK: [0x01,0x12,0x85,0xbe]

s_flbit_i32_b32 s101, s1
// CHECK: [0x01,0x12,0xe5,0xbe]

s_flbit_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x12,0xe6,0xbe]

s_flbit_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x12,0xe7,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x12,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x12,0xeb,0xbe]

s_flbit_i32_b32 ttmp15, s1
// CHECK: [0x01,0x12,0xfb,0xbe]

s_flbit_i32_b32 m0, s1
// CHECK: [0x01,0x12,0xfc,0xbe]

s_flbit_i32_b32 exec_lo, s1
// CHECK: [0x01,0x12,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// CHECK: [0x01,0x12,0xff,0xbe]

s_flbit_i32_b32 s5, s101
// CHECK: [0x65,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, ttmp15
// CHECK: [0x7b,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, m0
// CHECK: [0x7c,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, 0
// CHECK: [0x80,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, -1
// CHECK: [0xc1,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, 0.5
// CHECK: [0xf0,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, -4.0
// CHECK: [0xf7,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, src_vccz
// CHECK: [0xfb,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, src_execz
// CHECK: [0xfc,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, src_scc
// CHECK: [0xfd,0x12,0x85,0xbe]

s_flbit_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x12,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x12,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x13,0x85,0xbe]

s_flbit_i32_b64 s101, s[2:3]
// CHECK: [0x02,0x13,0xe5,0xbe]

s_flbit_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x13,0xe6,0xbe]

s_flbit_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x13,0xe7,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x13,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x13,0xeb,0xbe]

s_flbit_i32_b64 ttmp15, s[2:3]
// CHECK: [0x02,0x13,0xfb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x13,0xfc,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x13,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x13,0xff,0xbe]

s_flbit_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, s[100:101]
// CHECK: [0x64,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, flat_scratch
// CHECK: [0x66,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, vcc
// CHECK: [0x6a,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, ttmp[14:15]
// CHECK: [0x7a,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, exec
// CHECK: [0x7e,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, 0
// CHECK: [0x80,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, -1
// CHECK: [0xc1,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, 0.5
// CHECK: [0xf0,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, -4.0
// CHECK: [0xf7,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, src_vccz
// CHECK: [0xfb,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, src_execz
// CHECK: [0xfc,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, src_scc
// CHECK: [0xfd,0x13,0x85,0xbe]

s_flbit_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x13,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x13,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s5, s1
// CHECK: [0x01,0x14,0x85,0xbe]

s_flbit_i32 s101, s1
// CHECK: [0x01,0x14,0xe5,0xbe]

s_flbit_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x14,0xe6,0xbe]

s_flbit_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x14,0xe7,0xbe]

s_flbit_i32 vcc_lo, s1
// CHECK: [0x01,0x14,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// CHECK: [0x01,0x14,0xeb,0xbe]

s_flbit_i32 ttmp15, s1
// CHECK: [0x01,0x14,0xfb,0xbe]

s_flbit_i32 m0, s1
// CHECK: [0x01,0x14,0xfc,0xbe]

s_flbit_i32 exec_lo, s1
// CHECK: [0x01,0x14,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// CHECK: [0x01,0x14,0xff,0xbe]

s_flbit_i32 s5, s101
// CHECK: [0x65,0x14,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_lo
// CHECK: [0x66,0x14,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_hi
// CHECK: [0x67,0x14,0x85,0xbe]

s_flbit_i32 s5, vcc_lo
// CHECK: [0x6a,0x14,0x85,0xbe]

s_flbit_i32 s5, vcc_hi
// CHECK: [0x6b,0x14,0x85,0xbe]

s_flbit_i32 s5, ttmp15
// CHECK: [0x7b,0x14,0x85,0xbe]

s_flbit_i32 s5, m0
// CHECK: [0x7c,0x14,0x85,0xbe]

s_flbit_i32 s5, exec_lo
// CHECK: [0x7e,0x14,0x85,0xbe]

s_flbit_i32 s5, exec_hi
// CHECK: [0x7f,0x14,0x85,0xbe]

s_flbit_i32 s5, 0
// CHECK: [0x80,0x14,0x85,0xbe]

s_flbit_i32 s5, -1
// CHECK: [0xc1,0x14,0x85,0xbe]

s_flbit_i32 s5, 0.5
// CHECK: [0xf0,0x14,0x85,0xbe]

s_flbit_i32 s5, -4.0
// CHECK: [0xf7,0x14,0x85,0xbe]

s_flbit_i32 s5, src_vccz
// CHECK: [0xfb,0x14,0x85,0xbe]

s_flbit_i32 s5, src_execz
// CHECK: [0xfc,0x14,0x85,0xbe]

s_flbit_i32 s5, src_scc
// CHECK: [0xfd,0x14,0x85,0xbe]

s_flbit_i32 s5, 0xaf123456
// CHECK: [0xff,0x14,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s5, 0x3f717273
// CHECK: [0xff,0x14,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s5, s[2:3]
// CHECK: [0x02,0x15,0x85,0xbe]

s_flbit_i32_i64 s101, s[2:3]
// CHECK: [0x02,0x15,0xe5,0xbe]

s_flbit_i32_i64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x15,0xe6,0xbe]

s_flbit_i32_i64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x15,0xe7,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// CHECK: [0x02,0x15,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// CHECK: [0x02,0x15,0xeb,0xbe]

s_flbit_i32_i64 ttmp15, s[2:3]
// CHECK: [0x02,0x15,0xfb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// CHECK: [0x02,0x15,0xfc,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// CHECK: [0x02,0x15,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// CHECK: [0x02,0x15,0xff,0xbe]

s_flbit_i32_i64 s5, s[4:5]
// CHECK: [0x04,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, s[100:101]
// CHECK: [0x64,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, flat_scratch
// CHECK: [0x66,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, vcc
// CHECK: [0x6a,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, ttmp[14:15]
// CHECK: [0x7a,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, exec
// CHECK: [0x7e,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, 0
// CHECK: [0x80,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, -1
// CHECK: [0xc1,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, 0.5
// CHECK: [0xf0,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, -4.0
// CHECK: [0xf7,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, src_vccz
// CHECK: [0xfb,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, src_execz
// CHECK: [0xfc,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, src_scc
// CHECK: [0xfd,0x15,0x85,0xbe]

s_flbit_i32_i64 s5, 0xaf123456
// CHECK: [0xff,0x15,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s5, 0x3f717273
// CHECK: [0xff,0x15,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s5, s1
// CHECK: [0x01,0x16,0x85,0xbe]

s_sext_i32_i8 s101, s1
// CHECK: [0x01,0x16,0xe5,0xbe]

s_sext_i32_i8 flat_scratch_lo, s1
// CHECK: [0x01,0x16,0xe6,0xbe]

s_sext_i32_i8 flat_scratch_hi, s1
// CHECK: [0x01,0x16,0xe7,0xbe]

s_sext_i32_i8 vcc_lo, s1
// CHECK: [0x01,0x16,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// CHECK: [0x01,0x16,0xeb,0xbe]

s_sext_i32_i8 ttmp15, s1
// CHECK: [0x01,0x16,0xfb,0xbe]

s_sext_i32_i8 m0, s1
// CHECK: [0x01,0x16,0xfc,0xbe]

s_sext_i32_i8 exec_lo, s1
// CHECK: [0x01,0x16,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// CHECK: [0x01,0x16,0xff,0xbe]

s_sext_i32_i8 s5, s101
// CHECK: [0x65,0x16,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_lo
// CHECK: [0x66,0x16,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_hi
// CHECK: [0x67,0x16,0x85,0xbe]

s_sext_i32_i8 s5, vcc_lo
// CHECK: [0x6a,0x16,0x85,0xbe]

s_sext_i32_i8 s5, vcc_hi
// CHECK: [0x6b,0x16,0x85,0xbe]

s_sext_i32_i8 s5, ttmp15
// CHECK: [0x7b,0x16,0x85,0xbe]

s_sext_i32_i8 s5, m0
// CHECK: [0x7c,0x16,0x85,0xbe]

s_sext_i32_i8 s5, exec_lo
// CHECK: [0x7e,0x16,0x85,0xbe]

s_sext_i32_i8 s5, exec_hi
// CHECK: [0x7f,0x16,0x85,0xbe]

s_sext_i32_i8 s5, 0
// CHECK: [0x80,0x16,0x85,0xbe]

s_sext_i32_i8 s5, -1
// CHECK: [0xc1,0x16,0x85,0xbe]

s_sext_i32_i8 s5, 0.5
// CHECK: [0xf0,0x16,0x85,0xbe]

s_sext_i32_i8 s5, -4.0
// CHECK: [0xf7,0x16,0x85,0xbe]

s_sext_i32_i8 s5, src_vccz
// CHECK: [0xfb,0x16,0x85,0xbe]

s_sext_i32_i8 s5, src_execz
// CHECK: [0xfc,0x16,0x85,0xbe]

s_sext_i32_i8 s5, src_scc
// CHECK: [0xfd,0x16,0x85,0xbe]

s_sext_i32_i8 s5, 0x71
// CHECK: [0xff,0x16,0x85,0xbe,0x71,0x00,0x00,0x00]

s_sext_i32_i8 s5, 0xf0
// CHECK: [0xff,0x16,0x85,0xbe,0xf0,0x00,0x00,0x00]

s_sext_i32_i16 s5, s1
// CHECK: [0x01,0x17,0x85,0xbe]

s_sext_i32_i16 s101, s1
// CHECK: [0x01,0x17,0xe5,0xbe]

s_sext_i32_i16 flat_scratch_lo, s1
// CHECK: [0x01,0x17,0xe6,0xbe]

s_sext_i32_i16 flat_scratch_hi, s1
// CHECK: [0x01,0x17,0xe7,0xbe]

s_sext_i32_i16 vcc_lo, s1
// CHECK: [0x01,0x17,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// CHECK: [0x01,0x17,0xeb,0xbe]

s_sext_i32_i16 ttmp15, s1
// CHECK: [0x01,0x17,0xfb,0xbe]

s_sext_i32_i16 m0, s1
// CHECK: [0x01,0x17,0xfc,0xbe]

s_sext_i32_i16 exec_lo, s1
// CHECK: [0x01,0x17,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// CHECK: [0x01,0x17,0xff,0xbe]

s_sext_i32_i16 s5, s101
// CHECK: [0x65,0x17,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_lo
// CHECK: [0x66,0x17,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_hi
// CHECK: [0x67,0x17,0x85,0xbe]

s_sext_i32_i16 s5, vcc_lo
// CHECK: [0x6a,0x17,0x85,0xbe]

s_sext_i32_i16 s5, vcc_hi
// CHECK: [0x6b,0x17,0x85,0xbe]

s_sext_i32_i16 s5, ttmp15
// CHECK: [0x7b,0x17,0x85,0xbe]

s_sext_i32_i16 s5, m0
// CHECK: [0x7c,0x17,0x85,0xbe]

s_sext_i32_i16 s5, exec_lo
// CHECK: [0x7e,0x17,0x85,0xbe]

s_sext_i32_i16 s5, exec_hi
// CHECK: [0x7f,0x17,0x85,0xbe]

s_sext_i32_i16 s5, 0
// CHECK: [0x80,0x17,0x85,0xbe]

s_sext_i32_i16 s5, -1
// CHECK: [0xc1,0x17,0x85,0xbe]

s_sext_i32_i16 s5, 0.5
// CHECK: [0xf0,0x17,0x85,0xbe]

s_sext_i32_i16 s5, -4.0
// CHECK: [0xf7,0x17,0x85,0xbe]

s_sext_i32_i16 s5, src_vccz
// CHECK: [0xfb,0x17,0x85,0xbe]

s_sext_i32_i16 s5, src_execz
// CHECK: [0xfc,0x17,0x85,0xbe]

s_sext_i32_i16 s5, src_scc
// CHECK: [0xfd,0x17,0x85,0xbe]

s_sext_i32_i16 s5, 0xfe0b
// CHECK: [0xff,0x17,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_sext_i32_i16 s5, 0x3456
// CHECK: [0xff,0x17,0x85,0xbe,0x56,0x34,0x00,0x00]

s_bitset0_b32 s5, s1
// CHECK: [0x01,0x18,0x85,0xbe]

s_bitset0_b32 s101, s1
// CHECK: [0x01,0x18,0xe5,0xbe]

s_bitset0_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x18,0xe6,0xbe]

s_bitset0_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x18,0xe7,0xbe]

s_bitset0_b32 vcc_lo, s1
// CHECK: [0x01,0x18,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// CHECK: [0x01,0x18,0xeb,0xbe]

s_bitset0_b32 ttmp15, s1
// CHECK: [0x01,0x18,0xfb,0xbe]

s_bitset0_b32 m0, s1
// CHECK: [0x01,0x18,0xfc,0xbe]

s_bitset0_b32 exec_lo, s1
// CHECK: [0x01,0x18,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// CHECK: [0x01,0x18,0xff,0xbe]

s_bitset0_b32 s5, s101
// CHECK: [0x65,0x18,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x18,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x18,0x85,0xbe]

s_bitset0_b32 s5, vcc_lo
// CHECK: [0x6a,0x18,0x85,0xbe]

s_bitset0_b32 s5, vcc_hi
// CHECK: [0x6b,0x18,0x85,0xbe]

s_bitset0_b32 s5, ttmp15
// CHECK: [0x7b,0x18,0x85,0xbe]

s_bitset0_b32 s5, m0
// CHECK: [0x7c,0x18,0x85,0xbe]

s_bitset0_b32 s5, exec_lo
// CHECK: [0x7e,0x18,0x85,0xbe]

s_bitset0_b32 s5, exec_hi
// CHECK: [0x7f,0x18,0x85,0xbe]

s_bitset0_b32 s5, 0
// CHECK: [0x80,0x18,0x85,0xbe]

s_bitset0_b32 s5, -1
// CHECK: [0xc1,0x18,0x85,0xbe]

s_bitset0_b32 s5, 0.5
// CHECK: [0xf0,0x18,0x85,0xbe]

s_bitset0_b32 s5, -4.0
// CHECK: [0xf7,0x18,0x85,0xbe]

s_bitset0_b32 s5, src_vccz
// CHECK: [0xfb,0x18,0x85,0xbe]

s_bitset0_b32 s5, src_execz
// CHECK: [0xfc,0x18,0x85,0xbe]

s_bitset0_b32 s5, src_scc
// CHECK: [0xfd,0x18,0x85,0xbe]

s_bitset0_b32 s5, 0xaf123456
// CHECK: [0xff,0x18,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s5, 0x3f717273
// CHECK: [0xff,0x18,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[10:11], s1
// CHECK: [0x01,0x19,0x8a,0xbe]

s_bitset0_b64 s[12:13], s1
// CHECK: [0x01,0x19,0x8c,0xbe]

s_bitset0_b64 s[100:101], s1
// CHECK: [0x01,0x19,0xe4,0xbe]

s_bitset0_b64 flat_scratch, s1
// CHECK: [0x01,0x19,0xe6,0xbe]

s_bitset0_b64 vcc, s1
// CHECK: [0x01,0x19,0xea,0xbe]

s_bitset0_b64 ttmp[14:15], s1
// CHECK: [0x01,0x19,0xfa,0xbe]

s_bitset0_b64 exec, s1
// CHECK: [0x01,0x19,0xfe,0xbe]

s_bitset0_b64 s[10:11], s101
// CHECK: [0x65,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_lo
// CHECK: [0x66,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_hi
// CHECK: [0x67,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], ttmp15
// CHECK: [0x7b,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], m0
// CHECK: [0x7c,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0
// CHECK: [0x80,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], -1
// CHECK: [0xc1,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0.5
// CHECK: [0xf0,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], -4.0
// CHECK: [0xf7,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_execz
// CHECK: [0xfc,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], src_scc
// CHECK: [0xfd,0x19,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x19,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x19,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s5, s1
// CHECK: [0x01,0x1a,0x85,0xbe]

s_bitset1_b32 s101, s1
// CHECK: [0x01,0x1a,0xe5,0xbe]

s_bitset1_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x1a,0xe6,0xbe]

s_bitset1_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x1a,0xe7,0xbe]

s_bitset1_b32 vcc_lo, s1
// CHECK: [0x01,0x1a,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// CHECK: [0x01,0x1a,0xeb,0xbe]

s_bitset1_b32 ttmp15, s1
// CHECK: [0x01,0x1a,0xfb,0xbe]

s_bitset1_b32 m0, s1
// CHECK: [0x01,0x1a,0xfc,0xbe]

s_bitset1_b32 exec_lo, s1
// CHECK: [0x01,0x1a,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// CHECK: [0x01,0x1a,0xff,0xbe]

s_bitset1_b32 s5, s101
// CHECK: [0x65,0x1a,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x1a,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x1a,0x85,0xbe]

s_bitset1_b32 s5, vcc_lo
// CHECK: [0x6a,0x1a,0x85,0xbe]

s_bitset1_b32 s5, vcc_hi
// CHECK: [0x6b,0x1a,0x85,0xbe]

s_bitset1_b32 s5, ttmp15
// CHECK: [0x7b,0x1a,0x85,0xbe]

s_bitset1_b32 s5, m0
// CHECK: [0x7c,0x1a,0x85,0xbe]

s_bitset1_b32 s5, exec_lo
// CHECK: [0x7e,0x1a,0x85,0xbe]

s_bitset1_b32 s5, exec_hi
// CHECK: [0x7f,0x1a,0x85,0xbe]

s_bitset1_b32 s5, 0
// CHECK: [0x80,0x1a,0x85,0xbe]

s_bitset1_b32 s5, -1
// CHECK: [0xc1,0x1a,0x85,0xbe]

s_bitset1_b32 s5, 0.5
// CHECK: [0xf0,0x1a,0x85,0xbe]

s_bitset1_b32 s5, -4.0
// CHECK: [0xf7,0x1a,0x85,0xbe]

s_bitset1_b32 s5, src_vccz
// CHECK: [0xfb,0x1a,0x85,0xbe]

s_bitset1_b32 s5, src_execz
// CHECK: [0xfc,0x1a,0x85,0xbe]

s_bitset1_b32 s5, src_scc
// CHECK: [0xfd,0x1a,0x85,0xbe]

s_bitset1_b32 s5, 0xaf123456
// CHECK: [0xff,0x1a,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s5, 0x3f717273
// CHECK: [0xff,0x1a,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[10:11], s1
// CHECK: [0x01,0x1b,0x8a,0xbe]

s_bitset1_b64 s[12:13], s1
// CHECK: [0x01,0x1b,0x8c,0xbe]

s_bitset1_b64 s[100:101], s1
// CHECK: [0x01,0x1b,0xe4,0xbe]

s_bitset1_b64 flat_scratch, s1
// CHECK: [0x01,0x1b,0xe6,0xbe]

s_bitset1_b64 vcc, s1
// CHECK: [0x01,0x1b,0xea,0xbe]

s_bitset1_b64 ttmp[14:15], s1
// CHECK: [0x01,0x1b,0xfa,0xbe]

s_bitset1_b64 exec, s1
// CHECK: [0x01,0x1b,0xfe,0xbe]

s_bitset1_b64 s[10:11], s101
// CHECK: [0x65,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_lo
// CHECK: [0x66,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_hi
// CHECK: [0x67,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], ttmp15
// CHECK: [0x7b,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], m0
// CHECK: [0x7c,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0
// CHECK: [0x80,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], -1
// CHECK: [0xc1,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0.5
// CHECK: [0xf0,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], -4.0
// CHECK: [0xf7,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_execz
// CHECK: [0xfc,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], src_scc
// CHECK: [0xfd,0x1b,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x1b,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x1b,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_getpc_b64 s[10:11]
// CHECK: [0x00,0x1c,0x8a,0xbe]

s_getpc_b64 s[12:13]
// CHECK: [0x00,0x1c,0x8c,0xbe]

s_getpc_b64 s[100:101]
// CHECK: [0x00,0x1c,0xe4,0xbe]

s_getpc_b64 flat_scratch
// CHECK: [0x00,0x1c,0xe6,0xbe]

s_getpc_b64 vcc
// CHECK: [0x00,0x1c,0xea,0xbe]

s_getpc_b64 ttmp[14:15]
// CHECK: [0x00,0x1c,0xfa,0xbe]

s_getpc_b64 exec
// CHECK: [0x00,0x1c,0xfe,0xbe]

s_setpc_b64 s[2:3]
// CHECK: [0x02,0x1d,0x80,0xbe]

s_setpc_b64 s[4:5]
// CHECK: [0x04,0x1d,0x80,0xbe]

s_setpc_b64 s[100:101]
// CHECK: [0x64,0x1d,0x80,0xbe]

s_setpc_b64 flat_scratch
// CHECK: [0x66,0x1d,0x80,0xbe]

s_setpc_b64 vcc
// CHECK: [0x6a,0x1d,0x80,0xbe]

s_setpc_b64 ttmp[14:15]
// CHECK: [0x7a,0x1d,0x80,0xbe]

s_swappc_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x1e,0x8a,0xbe]

s_swappc_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x1e,0x8c,0xbe]

s_swappc_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x1e,0xe4,0xbe]

s_swappc_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x1e,0xe6,0xbe]

s_swappc_b64 vcc, s[2:3]
// CHECK: [0x02,0x1e,0xea,0xbe]

s_swappc_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x1e,0xfa,0xbe]

s_swappc_b64 exec, s[2:3]
// CHECK: [0x02,0x1e,0xfe,0xbe]

s_swappc_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x1e,0x8a,0xbe]

s_swappc_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x1e,0x8a,0xbe]

s_swappc_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x1e,0x8a,0xbe]

s_swappc_b64 s[10:11], vcc
// CHECK: [0x6a,0x1e,0x8a,0xbe]

s_swappc_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x1e,0x8a,0xbe]

s_rfe_b64 s[2:3]
// CHECK: [0x02,0x1f,0x80,0xbe]

s_rfe_b64 s[4:5]
// CHECK: [0x04,0x1f,0x80,0xbe]

s_rfe_b64 s[100:101]
// CHECK: [0x64,0x1f,0x80,0xbe]

s_rfe_b64 flat_scratch
// CHECK: [0x66,0x1f,0x80,0xbe]

s_rfe_b64 vcc
// CHECK: [0x6a,0x1f,0x80,0xbe]

s_rfe_b64 ttmp[14:15]
// CHECK: [0x7a,0x1f,0x80,0xbe]

s_and_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x20,0x8c,0xbe]

s_and_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x20,0xe4,0xbe]

s_and_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x20,0xe6,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x20,0xea,0xbe]

s_and_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x20,0xfa,0xbe]

s_and_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x20,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x20,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x20,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x21,0x8c,0xbe]

s_or_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x21,0xe4,0xbe]

s_or_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x21,0xe6,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x21,0xea,0xbe]

s_or_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x21,0xfa,0xbe]

s_or_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x21,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x21,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x21,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x22,0x8c,0xbe]

s_xor_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x22,0xe4,0xbe]

s_xor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x22,0xe6,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x22,0xea,0xbe]

s_xor_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x22,0xfa,0xbe]

s_xor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x22,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x22,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x22,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x23,0x8c,0xbe]

s_andn2_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x23,0xe4,0xbe]

s_andn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x23,0xe6,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x23,0xea,0xbe]

s_andn2_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x23,0xfa,0xbe]

s_andn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x23,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x23,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x23,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x24,0x8c,0xbe]

s_orn2_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x24,0xe4,0xbe]

s_orn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x24,0xe6,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x24,0xea,0xbe]

s_orn2_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x24,0xfa,0xbe]

s_orn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x24,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x24,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x24,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x25,0x8c,0xbe]

s_nand_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x25,0xe4,0xbe]

s_nand_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x25,0xe6,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x25,0xea,0xbe]

s_nand_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x25,0xfa,0xbe]

s_nand_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x25,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x25,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x25,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x26,0x8c,0xbe]

s_nor_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x26,0xe4,0xbe]

s_nor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x26,0xe6,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x26,0xea,0xbe]

s_nor_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x26,0xfa,0xbe]

s_nor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x26,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x26,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x26,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x27,0x8c,0xbe]

s_xnor_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x27,0xe4,0xbe]

s_xnor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x27,0xe6,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x27,0xea,0xbe]

s_xnor_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x27,0xfa,0xbe]

s_xnor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x27,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x27,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x27,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s5, s1
// CHECK: [0x01,0x28,0x85,0xbe]

s_quadmask_b32 s101, s1
// CHECK: [0x01,0x28,0xe5,0xbe]

s_quadmask_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x28,0xe6,0xbe]

s_quadmask_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x28,0xe7,0xbe]

s_quadmask_b32 vcc_lo, s1
// CHECK: [0x01,0x28,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// CHECK: [0x01,0x28,0xeb,0xbe]

s_quadmask_b32 ttmp15, s1
// CHECK: [0x01,0x28,0xfb,0xbe]

s_quadmask_b32 m0, s1
// CHECK: [0x01,0x28,0xfc,0xbe]

s_quadmask_b32 exec_lo, s1
// CHECK: [0x01,0x28,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// CHECK: [0x01,0x28,0xff,0xbe]

s_quadmask_b32 s5, s101
// CHECK: [0x65,0x28,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x28,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x28,0x85,0xbe]

s_quadmask_b32 s5, vcc_lo
// CHECK: [0x6a,0x28,0x85,0xbe]

s_quadmask_b32 s5, vcc_hi
// CHECK: [0x6b,0x28,0x85,0xbe]

s_quadmask_b32 s5, ttmp15
// CHECK: [0x7b,0x28,0x85,0xbe]

s_quadmask_b32 s5, m0
// CHECK: [0x7c,0x28,0x85,0xbe]

s_quadmask_b32 s5, exec_lo
// CHECK: [0x7e,0x28,0x85,0xbe]

s_quadmask_b32 s5, exec_hi
// CHECK: [0x7f,0x28,0x85,0xbe]

s_quadmask_b32 s5, 0
// CHECK: [0x80,0x28,0x85,0xbe]

s_quadmask_b32 s5, -1
// CHECK: [0xc1,0x28,0x85,0xbe]

s_quadmask_b32 s5, 0.5
// CHECK: [0xf0,0x28,0x85,0xbe]

s_quadmask_b32 s5, -4.0
// CHECK: [0xf7,0x28,0x85,0xbe]

s_quadmask_b32 s5, src_vccz
// CHECK: [0xfb,0x28,0x85,0xbe]

s_quadmask_b32 s5, src_execz
// CHECK: [0xfc,0x28,0x85,0xbe]

s_quadmask_b32 s5, src_scc
// CHECK: [0xfd,0x28,0x85,0xbe]

s_quadmask_b32 s5, 0xaf123456
// CHECK: [0xff,0x28,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s5, 0x3f717273
// CHECK: [0xff,0x28,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x29,0x8a,0xbe]

s_quadmask_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x29,0x8c,0xbe]

s_quadmask_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x29,0xe4,0xbe]

s_quadmask_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x29,0xe6,0xbe]

s_quadmask_b64 vcc, s[2:3]
// CHECK: [0x02,0x29,0xea,0xbe]

s_quadmask_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x29,0xfa,0xbe]

s_quadmask_b64 exec, s[2:3]
// CHECK: [0x02,0x29,0xfe,0xbe]

s_quadmask_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], vcc
// CHECK: [0x6a,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], exec
// CHECK: [0x7e,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0
// CHECK: [0x80,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], -1
// CHECK: [0xc1,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0.5
// CHECK: [0xf0,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], -4.0
// CHECK: [0xf7,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_execz
// CHECK: [0xfc,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], src_scc
// CHECK: [0xfd,0x29,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x29,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x29,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_movrels_b32 s5, s1
// CHECK: [0x01,0x2a,0x85,0xbe]

s_movrels_b32 s101, s1
// CHECK: [0x01,0x2a,0xe5,0xbe]

s_movrels_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2a,0xe6,0xbe]

s_movrels_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2a,0xe7,0xbe]

s_movrels_b32 vcc_lo, s1
// CHECK: [0x01,0x2a,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// CHECK: [0x01,0x2a,0xeb,0xbe]

s_movrels_b32 ttmp15, s1
// CHECK: [0x01,0x2a,0xfb,0xbe]

s_movrels_b32 m0, s1
// CHECK: [0x01,0x2a,0xfc,0xbe]

s_movrels_b32 exec_lo, s1
// CHECK: [0x01,0x2a,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// CHECK: [0x01,0x2a,0xff,0xbe]

s_movrels_b32 s5, s101
// CHECK: [0x65,0x2a,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x2a,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x2a,0x85,0xbe]

s_movrels_b32 s5, vcc_lo
// CHECK: [0x6a,0x2a,0x85,0xbe]

s_movrels_b32 s5, vcc_hi
// CHECK: [0x6b,0x2a,0x85,0xbe]

s_movrels_b32 s5, ttmp15
// CHECK: [0x7b,0x2a,0x85,0xbe]

s_movrels_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2b,0x8a,0xbe]

s_movrels_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2b,0x8c,0xbe]

s_movrels_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x2b,0xe4,0xbe]

s_movrels_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2b,0xe6,0xbe]

s_movrels_b64 vcc, s[2:3]
// CHECK: [0x02,0x2b,0xea,0xbe]

s_movrels_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x2b,0xfa,0xbe]

s_movrels_b64 exec, s[2:3]
// CHECK: [0x02,0x2b,0xfe,0xbe]

s_movrels_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2b,0x8a,0xbe]

s_movrels_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x2b,0x8a,0xbe]

s_movrels_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x2b,0x8a,0xbe]

s_movrels_b64 s[10:11], vcc
// CHECK: [0x6a,0x2b,0x8a,0xbe]

s_movrels_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x2b,0x8a,0xbe]

s_movreld_b32 s5, s1
// CHECK: [0x01,0x2c,0x85,0xbe]

s_movreld_b32 s101, s1
// CHECK: [0x01,0x2c,0xe5,0xbe]

s_movreld_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2c,0xe6,0xbe]

s_movreld_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2c,0xe7,0xbe]

s_movreld_b32 vcc_lo, s1
// CHECK: [0x01,0x2c,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// CHECK: [0x01,0x2c,0xeb,0xbe]

s_movreld_b32 ttmp15, s1
// CHECK: [0x01,0x2c,0xfb,0xbe]

s_movreld_b32 s5, s101
// CHECK: [0x65,0x2c,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_lo
// CHECK: [0x66,0x2c,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_hi
// CHECK: [0x67,0x2c,0x85,0xbe]

s_movreld_b32 s5, vcc_lo
// CHECK: [0x6a,0x2c,0x85,0xbe]

s_movreld_b32 s5, vcc_hi
// CHECK: [0x6b,0x2c,0x85,0xbe]

s_movreld_b32 s5, ttmp15
// CHECK: [0x7b,0x2c,0x85,0xbe]

s_movreld_b32 s5, m0
// CHECK: [0x7c,0x2c,0x85,0xbe]

s_movreld_b32 s5, 0
// CHECK: [0x80,0x2c,0x85,0xbe]

s_movreld_b32 s5, -1
// CHECK: [0xc1,0x2c,0x85,0xbe]

s_movreld_b32 s5, 0.5
// CHECK: [0xf0,0x2c,0x85,0xbe]

s_movreld_b32 s5, -4.0
// CHECK: [0xf7,0x2c,0x85,0xbe]

s_movreld_b32 s5, src_vccz
// CHECK: [0xfb,0x2c,0x85,0xbe]

s_movreld_b32 s5, src_execz
// CHECK: [0xfc,0x2c,0x85,0xbe]

s_movreld_b32 s5, src_scc
// CHECK: [0xfd,0x2c,0x85,0xbe]

s_movreld_b32 s5, 0xaf123456
// CHECK: [0xff,0x2c,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b32 s5, 0x3f717273
// CHECK: [0xff,0x2c,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2d,0x8a,0xbe]

s_movreld_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2d,0x8c,0xbe]

s_movreld_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x2d,0xe4,0xbe]

s_movreld_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2d,0xe6,0xbe]

s_movreld_b64 vcc, s[2:3]
// CHECK: [0x02,0x2d,0xea,0xbe]

s_movreld_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x2d,0xfa,0xbe]

s_movreld_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], vcc
// CHECK: [0x6a,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], 0
// CHECK: [0x80,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], -1
// CHECK: [0xc1,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], src_execz
// CHECK: [0xfc,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], src_scc
// CHECK: [0xfd,0x2d,0x8a,0xbe]

s_movreld_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2d,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2d,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cbranch_join s1
// CHECK: [0x01,0x2e,0x80,0xbe]

s_cbranch_join s101
// CHECK: [0x65,0x2e,0x80,0xbe]

s_cbranch_join flat_scratch_lo
// CHECK: [0x66,0x2e,0x80,0xbe]

s_cbranch_join flat_scratch_hi
// CHECK: [0x67,0x2e,0x80,0xbe]

s_cbranch_join vcc_lo
// CHECK: [0x6a,0x2e,0x80,0xbe]

s_cbranch_join vcc_hi
// CHECK: [0x6b,0x2e,0x80,0xbe]

s_cbranch_join ttmp15
// CHECK: [0x7b,0x2e,0x80,0xbe]

s_abs_i32 s5, s1
// CHECK: [0x01,0x30,0x85,0xbe]

s_abs_i32 s101, s1
// CHECK: [0x01,0x30,0xe5,0xbe]

s_abs_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x30,0xe6,0xbe]

s_abs_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x30,0xe7,0xbe]

s_abs_i32 vcc_lo, s1
// CHECK: [0x01,0x30,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// CHECK: [0x01,0x30,0xeb,0xbe]

s_abs_i32 ttmp15, s1
// CHECK: [0x01,0x30,0xfb,0xbe]

s_abs_i32 m0, s1
// CHECK: [0x01,0x30,0xfc,0xbe]

s_abs_i32 exec_lo, s1
// CHECK: [0x01,0x30,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// CHECK: [0x01,0x30,0xff,0xbe]

s_abs_i32 s5, s101
// CHECK: [0x65,0x30,0x85,0xbe]

s_abs_i32 s5, flat_scratch_lo
// CHECK: [0x66,0x30,0x85,0xbe]

s_abs_i32 s5, flat_scratch_hi
// CHECK: [0x67,0x30,0x85,0xbe]

s_abs_i32 s5, vcc_lo
// CHECK: [0x6a,0x30,0x85,0xbe]

s_abs_i32 s5, vcc_hi
// CHECK: [0x6b,0x30,0x85,0xbe]

s_abs_i32 s5, ttmp15
// CHECK: [0x7b,0x30,0x85,0xbe]

s_abs_i32 s5, m0
// CHECK: [0x7c,0x30,0x85,0xbe]

s_abs_i32 s5, exec_lo
// CHECK: [0x7e,0x30,0x85,0xbe]

s_abs_i32 s5, exec_hi
// CHECK: [0x7f,0x30,0x85,0xbe]

s_abs_i32 s5, 0
// CHECK: [0x80,0x30,0x85,0xbe]

s_abs_i32 s5, -1
// CHECK: [0xc1,0x30,0x85,0xbe]

s_abs_i32 s5, 0.5
// CHECK: [0xf0,0x30,0x85,0xbe]

s_abs_i32 s5, -4.0
// CHECK: [0xf7,0x30,0x85,0xbe]

s_abs_i32 s5, src_vccz
// CHECK: [0xfb,0x30,0x85,0xbe]

s_abs_i32 s5, src_execz
// CHECK: [0xfc,0x30,0x85,0xbe]

s_abs_i32 s5, src_scc
// CHECK: [0xfd,0x30,0x85,0xbe]

s_abs_i32 s5, 0xaf123456
// CHECK: [0xff,0x30,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s5, 0x3f717273
// CHECK: [0xff,0x30,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_set_gpr_idx_idx s1
// CHECK: [0x01,0x32,0x80,0xbe]

s_set_gpr_idx_idx s101
// CHECK: [0x65,0x32,0x80,0xbe]

s_set_gpr_idx_idx flat_scratch_lo
// CHECK: [0x66,0x32,0x80,0xbe]

s_set_gpr_idx_idx flat_scratch_hi
// CHECK: [0x67,0x32,0x80,0xbe]

s_set_gpr_idx_idx vcc_lo
// CHECK: [0x6a,0x32,0x80,0xbe]

s_set_gpr_idx_idx vcc_hi
// CHECK: [0x6b,0x32,0x80,0xbe]

s_set_gpr_idx_idx ttmp15
// CHECK: [0x7b,0x32,0x80,0xbe]

s_set_gpr_idx_idx m0
// CHECK: [0x7c,0x32,0x80,0xbe]

s_set_gpr_idx_idx 0
// CHECK: [0x80,0x32,0x80,0xbe]

s_set_gpr_idx_idx -1
// CHECK: [0xc1,0x32,0x80,0xbe]

s_set_gpr_idx_idx 0.5
// CHECK: [0xf0,0x32,0x80,0xbe]

s_set_gpr_idx_idx -4.0
// CHECK: [0xf7,0x32,0x80,0xbe]

s_set_gpr_idx_idx src_vccz
// CHECK: [0xfb,0x32,0x80,0xbe]

s_set_gpr_idx_idx src_execz
// CHECK: [0xfc,0x32,0x80,0xbe]

s_set_gpr_idx_idx src_scc
// CHECK: [0xfd,0x32,0x80,0xbe]

s_set_gpr_idx_idx 0xaf123456
// CHECK: [0xff,0x32,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_set_gpr_idx_idx 0x3f717273
// CHECK: [0xff,0x32,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x33,0x8c,0xbe]

s_andn1_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x33,0xe4,0xbe]

s_andn1_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x33,0xe6,0xbe]

s_andn1_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x33,0xea,0xbe]

s_andn1_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x33,0xfa,0xbe]

s_andn1_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x33,0x8a,0xbe]

s_andn1_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x33,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x33,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x34,0x8c,0xbe]

s_orn1_saveexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x34,0xe4,0xbe]

s_orn1_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x34,0xe6,0xbe]

s_orn1_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x34,0xea,0xbe]

s_orn1_saveexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x34,0xfa,0xbe]

s_orn1_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x34,0x8a,0xbe]

s_orn1_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x34,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x34,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x35,0x8c,0xbe]

s_andn1_wrexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x35,0xe4,0xbe]

s_andn1_wrexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x35,0xe6,0xbe]

s_andn1_wrexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x35,0xea,0xbe]

s_andn1_wrexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x35,0xfa,0xbe]

s_andn1_wrexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], exec
// CHECK: [0x7e,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], 0
// CHECK: [0x80,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], -1
// CHECK: [0xc1,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x35,0x8a,0xbe]

s_andn1_wrexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x35,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x35,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x36,0x8c,0xbe]

s_andn2_wrexec_b64 s[100:101], s[2:3]
// CHECK: [0x02,0x36,0xe4,0xbe]

s_andn2_wrexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x36,0xe6,0xbe]

s_andn2_wrexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x36,0xea,0xbe]

s_andn2_wrexec_b64 ttmp[14:15], s[2:3]
// CHECK: [0x02,0x36,0xfa,0xbe]

s_andn2_wrexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], s[100:101]
// CHECK: [0x64,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], flat_scratch
// CHECK: [0x66,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], ttmp[14:15]
// CHECK: [0x7a,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], exec
// CHECK: [0x7e,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], 0
// CHECK: [0x80,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], -1
// CHECK: [0xc1,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], src_vccz
// CHECK: [0xfb,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], src_execz
// CHECK: [0xfc,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], src_scc
// CHECK: [0xfd,0x36,0x8a,0xbe]

s_andn2_wrexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x36,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x36,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bitreplicate_b64_b32 s[10:11], s1
// CHECK: [0x01,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[12:13], s1
// CHECK: [0x01,0x37,0x8c,0xbe]

s_bitreplicate_b64_b32 s[100:101], s1
// CHECK: [0x01,0x37,0xe4,0xbe]

s_bitreplicate_b64_b32 flat_scratch, s1
// CHECK: [0x01,0x37,0xe6,0xbe]

s_bitreplicate_b64_b32 vcc, s1
// CHECK: [0x01,0x37,0xea,0xbe]

s_bitreplicate_b64_b32 ttmp[14:15], s1
// CHECK: [0x01,0x37,0xfa,0xbe]

s_bitreplicate_b64_b32 exec, s1
// CHECK: [0x01,0x37,0xfe,0xbe]

s_bitreplicate_b64_b32 s[10:11], s101
// CHECK: [0x65,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], flat_scratch_lo
// CHECK: [0x66,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], flat_scratch_hi
// CHECK: [0x67,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], vcc_lo
// CHECK: [0x6a,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], vcc_hi
// CHECK: [0x6b,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], ttmp15
// CHECK: [0x7b,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], m0
// CHECK: [0x7c,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], exec_lo
// CHECK: [0x7e,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], exec_hi
// CHECK: [0x7f,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], 0
// CHECK: [0x80,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], -1
// CHECK: [0xc1,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], 0.5
// CHECK: [0xf0,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], -4.0
// CHECK: [0xf7,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], src_vccz
// CHECK: [0xfb,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], src_execz
// CHECK: [0xfc,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], src_scc
// CHECK: [0xfd,0x37,0x8a,0xbe]

s_bitreplicate_b64_b32 s[10:11], 0xaf123456
// CHECK: [0xff,0x37,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitreplicate_b64_b32 s[10:11], 0x3f717273
// CHECK: [0xff,0x37,0x8a,0xbe,0x73,0x72,0x71,0x3f]
