/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// OvirtVolumePopulatorsGetter has a method to return a OvirtVolumePopulatorInterface.
// A group's client should implement this interface.
type OvirtVolumePopulatorsGetter interface {
	OvirtVolumePopulators(namespace string) OvirtVolumePopulatorInterface
}

// OvirtVolumePopulatorInterface has methods to work with OvirtVolumePopulator resources.
type OvirtVolumePopulatorInterface interface {
	Create(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.CreateOptions) (*v1beta1.OvirtVolumePopulator, error)
	Update(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (*v1beta1.OvirtVolumePopulator, error)
	UpdateStatus(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (*v1beta1.OvirtVolumePopulator, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.OvirtVolumePopulator, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.OvirtVolumePopulatorList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OvirtVolumePopulator, err error)
	OvirtVolumePopulatorExpansion
}

// ovirtVolumePopulators implements OvirtVolumePopulatorInterface
type ovirtVolumePopulators struct {
	client rest.Interface
	ns     string
}

// newOvirtVolumePopulators returns a OvirtVolumePopulators
func newOvirtVolumePopulators(c *ForkliftV1beta1Client, namespace string) *ovirtVolumePopulators {
	return &ovirtVolumePopulators{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the ovirtVolumePopulator, and returns the corresponding ovirtVolumePopulator object, and an error if there is any.
func (c *ovirtVolumePopulators) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	result = &v1beta1.OvirtVolumePopulator{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OvirtVolumePopulators that match those selectors.
func (c *ovirtVolumePopulators) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OvirtVolumePopulatorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.OvirtVolumePopulatorList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ovirtVolumePopulators.
func (c *ovirtVolumePopulators) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ovirtVolumePopulator and creates it.  Returns the server's representation of the ovirtVolumePopulator, and an error, if there is any.
func (c *ovirtVolumePopulators) Create(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.CreateOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	result = &v1beta1.OvirtVolumePopulator{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ovirtVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ovirtVolumePopulator and updates it. Returns the server's representation of the ovirtVolumePopulator, and an error, if there is any.
func (c *ovirtVolumePopulators) Update(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	result = &v1beta1.OvirtVolumePopulator{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		Name(ovirtVolumePopulator.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ovirtVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ovirtVolumePopulators) UpdateStatus(ctx context.Context, ovirtVolumePopulator *v1beta1.OvirtVolumePopulator, opts v1.UpdateOptions) (result *v1beta1.OvirtVolumePopulator, err error) {
	result = &v1beta1.OvirtVolumePopulator{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		Name(ovirtVolumePopulator.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ovirtVolumePopulator).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ovirtVolumePopulator and deletes it. Returns an error if one occurs.
func (c *ovirtVolumePopulators) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ovirtVolumePopulators) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ovirtVolumePopulator.
func (c *ovirtVolumePopulators) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OvirtVolumePopulator, err error) {
	result = &v1beta1.OvirtVolumePopulator{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("ovirtvolumepopulators").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
