/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xbd, 0xcc, 0x7f, 0xd9, 0x3c, 0x70, 0x5f, 0x10, 0xe3, 0x4b, 0x15, 0x30,
        0x13, 0x66, 0x3e, 0x1d, 0x64, 0x8d, 0xcd, 0x68, 0x52, 0xe8, 0xfb, 0x8d,
        0x05, 0x5d, 0xd2, 0xe7, 0x37, 0xae, 0xfb, 0x5f, 0x66, 0x11, 0x4a, 0xe4,
        0xe6, 0x98, 0x7f, 0x6f, 0xdc, 0x54, 0xdd, 0xfe, 0x19, 0xc0, 0x4b, 0x75,
        0xbe, 0x69, 0xb2, 0x97, 0xc5, 0x43, 0x1a, 0x5f, 0xd1, 0xd3, 0xfb, 0x28,
        0xb3, 0xba, 0x4b, 0x4c, 0xd5, 0x9f, 0xf4, 0x39, 0x82, 0xd2, 0xa3, 0x02,
        0x95, 0x5d, 0x51, 0x34, 0x27, 0x45, 0xfe, 0x16, 0x55, 0xc9, 0x3b, 0x07,
        0x40, 0xbd, 0x18, 0xe3, 0xab, 0x2e, 0xf0, 0xe3, 0xe9, 0x9e, 0x52, 0x54,
        0x45, 0xb6, 0xd2, 0x1a, 0x70, 0x9d, 0xaa, 0xf9, 0xdb, 0x70, 0x86, 0x0d,
        0x68, 0x00, 0xb3, 0x5a, 0xed, 0xe1, 0x0e, 0x38, 0x52, 0x47, 0xbd, 0xa3,
        0x3f, 0x75, 0xbc, 0x61, 0x09, 0x66, 0x18, 0x42, 0x7c, 0x7d, 0x6d, 0x4b,
        0x6a, 0x39, 0x1b, 0xb5, 0x37, 0x12, 0x31, 0x54, 0x43, 0x70, 0x4b, 0xe6,
        0x83, 0xeb, 0x1b, 0xad, 0xb9, 0x32, 0x06, 0xaf, 0x32, 0x6b, 0xd5, 0x9a,
        0x18, 0xe9, 0x00, 0x04, 0x27, 0x8e, 0x9a, 0x7a, 0xd7, 0xe6, 0x5a, 0xbd,
        0xa4, 0x8c, 0xf5, 0x0d, 0x31, 0xc2, 0x88, 0x4d, 0x9c, 0x02, 0x88, 0xbd,
        0x6f, 0x5a, 0x17, 0x5f, 0x79, 0xbc, 0xd1, 0x93, 0xf4, 0x06, 0xab, 0x14,
        0xa4, 0xc0, 0x9e, 0x68, 0x39, 0x01, 0xcf, 0x21, 0xe2, 0x58, 0x7f, 0x2a,
        0xa5, 0x9e, 0x77, 0x10, 0x12, 0x56, 0x28, 0x9b, 0xa3, 0x53, 0x62, 0xee,
        0xa0, 0x13, 0xed, 0xe8, 0x09, 0xe9, 0xcd, 0x93, 0x0e, 0x36, 0x66, 0x52,
        0x42, 0x26, 0x7c, 0x09, 0x2c, 0x47, 0x33, 0x55, 0x99, 0x62, 0x8f, 0x84,
        0xd4, 0xd9, 0xf7, 0x2c, 0x36, 0x0d, 0x5b, 0x24, 0xe0, 0x9b, 0x05, 0x15,
        0xa2, 0x08, 0x7e, 0xf7
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.70 */
