/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends Layout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    public static final String PATTERN_RULE_REGISTRY = "PATTERN_RULE_REGISTRY";
    private String conversionPattern;
    private LoggingEventPatternConverter[] patternConverters;
    private FormattingInfo[] patternFields;
    private StringBuffer buf = new StringBuffer();
    private boolean handlesExceptions;

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String pattern) {
        this.conversionPattern = pattern;
        this.activateOptions();
    }

    public void setConversionPattern(String conversionPattern) {
        this.conversionPattern = OptionConverter.convertSpecialChars(conversionPattern);
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    public void activateOptions() {
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        Map converterRegistry = null;
        if (this.repository != null && this.repository instanceof LoggerRepositoryEx) {
            converterRegistry = (Map)((LoggerRepositoryEx)this.repository).getObject(PATTERN_RULE_REGISTRY);
        }
        PatternParser.parse(this.conversionPattern, converters, fields, converterRegistry, PatternParser.getPatternLayoutRules(), this.getLogger());
        this.patternConverters = new LoggingEventPatternConverter[converters.size()];
        this.patternFields = new FormattingInfo[converters.size()];
        int i = 0;
        Iterator converterIter = converters.iterator();
        Iterator fieldIter = fields.iterator();
        while (converterIter.hasNext()) {
            Object converter = converterIter.next();
            if (converter instanceof LoggingEventPatternConverter) {
                this.patternConverters[i] = (LoggingEventPatternConverter)converter;
                this.handlesExceptions |= this.patternConverters[i].handlesThrowable();
            } else {
                this.patternConverters[i] = new LiteralPatternConverter("");
            }
            this.patternFields[i] = fieldIter.hasNext() ? (FormattingInfo)fieldIter.next() : FormattingInfo.getDefault();
            ++i;
        }
    }

    public String format(LoggingEvent event) {
        this.buf.setLength(0);
        int i = 0;
        while (i < this.patternConverters.length) {
            int startField = this.buf.length();
            this.patternConverters[i].format(event, this.buf);
            this.patternFields[i].format(startField, this.buf);
            ++i;
        }
        String retval = this.buf.toString();
        this.buf.setLength(0);
        return retval;
    }

    public boolean ignoresThrowable() {
        return !this.handlesExceptions;
    }
}

