/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	gboolean _is_main_block;
	ValaParameter* _this_parameter;
	ValaLocalVariable* _params_array_var;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* async_begin_parameters;
	ValaList* async_end_parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

struct _Block2Data {
	int _ref_count_;
	ValaMethod* self;
	ValaList* referenced_generics;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_set_is_main_block (ValaMethod* self,
                                    gboolean value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar** invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static ValaTraverseStatus ___lambda5_ (ValaMethod* self,
                                ValaCodeNode* node);
static ValaTraverseStatus ____lambda5__vala_traverse_func (ValaCodeNode* node,
                                                    gpointer self);
static ValaTraverseStatus __lambda6_ (Block2Data* _data2_,
                               ValaCodeNode* node);
static ValaTraverseStatus ___lambda6__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_has_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

gboolean
vala_method_get_is_main_block (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_main_block;
	return result;
}

static void
vala_method_set_is_main_block (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_main_block = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_has_attribute ((ValaCodeNode*) self, "PrintfFormat");
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_has_attribute ((ValaCodeNode*) self, "ScanfFormat");
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaLocalVariable*
vala_method_get_params_array_var (ValaMethod* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_params_array_var;
	result = _tmp0_;
	return result;
}

void
vala_method_set_params_array_var (ValaMethod* self,
                                  ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	self->priv->_params_array_var = _tmp0_;
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Creates a new main block method.
 *
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct_main_block (GType object_type,
                                  ValaSourceReference* source_reference)
{
	ValaMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	self = (ValaMethod*) vala_subroutine_construct (object_type, "main", source_reference, NULL);
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	vala_callable_set_return_type ((ValaCallable*) self, (ValaDataType*) _tmp1_);
	_vala_code_node_unref0 (_tmp1_);
	vala_method_set_is_main_block (self, TRUE);
	return self;
}

ValaMethod*
vala_method_new_main_block (ValaSourceReference* source_reference)
{
	return vala_method_construct_main_block (VALA_TYPE_METHOD, source_reference);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp16_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp8_ = param;
			_tmp9_ = vala_parameter_get_ellipsis (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				ValaScope* _tmp11_;
				ValaScope* _tmp12_;
				ValaParameter* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp11_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp12_ = _tmp11_;
				_tmp13_ = param;
				_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
				_tmp15_ = _tmp14_;
				vala_scope_remove (_tmp12_, _tmp15_);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp16_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp16_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaParameter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp9_ = param;
			_tmp10_ = vala_parameter_get_ellipsis (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				_tmp8_ = TRUE;
			} else {
				ValaParameter* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = param;
				_tmp13_ = vala_parameter_get_params_array (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp26_;
	ValaLocalVariable* _tmp36_;
	ValaLocalVariable* _tmp37_;
	ValaList* _tmp40_;
	ValaList* _tmp50_;
	ValaBlock* _tmp60_;
	ValaBlock* _tmp61_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = vala_list_get (_tmp6_, _p_index);
			p = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp9_ = vala_method_get_base_interface_type (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp11_ = vala_method_get_base_interface_type (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp17_ = self->priv->parameters;
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaParameter* param = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaParameter* _tmp25_;
			_param_index = _param_index + 1;
			_tmp21_ = _param_index;
			_tmp22_ = _param_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _param_list;
			_tmp24_ = vala_list_get (_tmp23_, _param_index);
			param = (ValaParameter*) _tmp24_;
			_tmp25_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (param);
		}
	}
	_tmp26_ = self->error_types;
	if (_tmp26_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp27_;
			gint _error_type_size = 0;
			ValaList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _error_type_index = 0;
			_tmp27_ = self->error_types;
			_error_type_list = _tmp27_;
			_tmp28_ = _error_type_list;
			_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_error_type_size = _tmp30_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp33_;
				gpointer _tmp34_;
				ValaDataType* _tmp35_;
				_error_type_index = _error_type_index + 1;
				_tmp31_ = _error_type_index;
				_tmp32_ = _error_type_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _error_type_list;
				_tmp34_ = vala_list_get (_tmp33_, _error_type_index);
				error_type = (ValaDataType*) _tmp34_;
				_tmp35_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	_tmp36_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaLocalVariable* _tmp38_;
		ValaLocalVariable* _tmp39_;
		_tmp38_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp39_ = _tmp38_;
		vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
	}
	_tmp40_ = self->priv->preconditions;
	if (_tmp40_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp41_;
			gint _precondition_size = 0;
			ValaList* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _precondition_index = 0;
			_tmp41_ = self->priv->preconditions;
			_precondition_list = _tmp41_;
			_tmp42_ = _precondition_list;
			_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
			_tmp44_ = _tmp43_;
			_precondition_size = _tmp44_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp45_;
				gint _tmp46_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp47_;
				gpointer _tmp48_;
				ValaExpression* _tmp49_;
				_precondition_index = _precondition_index + 1;
				_tmp45_ = _precondition_index;
				_tmp46_ = _precondition_size;
				if (!(_tmp45_ < _tmp46_)) {
					break;
				}
				_tmp47_ = _precondition_list;
				_tmp48_ = vala_list_get (_tmp47_, _precondition_index);
				precondition = (ValaExpression*) _tmp48_;
				_tmp49_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp49_, visitor);
				_vala_code_node_unref0 (precondition);
			}
		}
	}
	_tmp50_ = self->priv->postconditions;
	if (_tmp50_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp51_;
			gint _postcondition_size = 0;
			ValaList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint _postcondition_index = 0;
			_tmp51_ = self->priv->postconditions;
			_postcondition_list = _tmp51_;
			_tmp52_ = _postcondition_list;
			_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			_postcondition_size = _tmp54_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp55_;
				gint _tmp56_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp57_;
				gpointer _tmp58_;
				ValaExpression* _tmp59_;
				_postcondition_index = _postcondition_index + 1;
				_tmp55_ = _postcondition_index;
				_tmp56_ = _postcondition_size;
				if (!(_tmp55_ < _tmp56_)) {
					break;
				}
				_tmp57_ = _postcondition_list;
				_tmp58_ = vala_list_get (_tmp57_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp58_;
				_tmp59_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp59_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
		}
	}
	_tmp60_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp61_ = _tmp60_;
	if (_tmp61_ != NULL) {
		ValaBlock* _tmp62_;
		ValaBlock* _tmp63_;
		_tmp62_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp63_ = _tmp62_;
		vala_code_node_accept ((ValaCodeNode*) _tmp63_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar** invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar** invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* method_type_args = NULL;
	ValaDataType* return_type = NULL;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	ValaObjectType* _tmp64_;
	ValaList* _tmp65_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp76_;
	ValaIterator* _tmp77_;
	gint param_index = 0;
	ValaIterator* _tmp126_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp128_;
	ValaArrayList* _tmp129_;
	ValaArrayList* _tmp130_;
	ValaList* _tmp131_;
	gboolean _tmp154_;
	gboolean _tmp155_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp19_;
				ValaGenericType* _tmp20_;
				ValaGenericType* _tmp21_;
				ValaObjectType* _tmp22_;
				ValaGenericType* _tmp23_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp15_ = _type_parameter_index;
				_tmp16_ = _type_parameter_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _type_parameter_list;
				_tmp18_ = vala_list_get (_tmp17_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp18_;
				_tmp19_ = type_parameter;
				_tmp20_ = vala_generic_type_new (_tmp19_, NULL);
				type_arg = _tmp20_;
				_tmp21_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp21_, TRUE);
				_tmp22_ = object_type;
				_tmp23_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp22_, (ValaDataType*) _tmp23_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
		}
	}
	_tmp24_ = vala_method_get_type_parameters (self);
	_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_method_get_type_parameters (base_method);
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp26_ < _tmp29_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp30_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		ValaList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp31_ = vala_method_get_type_parameters (self);
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_method_get_type_parameters (base_method);
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp33_ > _tmp36_) {
			gchar* _tmp37_;
			_tmp37_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp37_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp38_;
		ValaArrayList* _tmp39_;
		_tmp38_ = g_direct_equal;
		_tmp39_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp38_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp39_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp40_;
			gint _type_parameter_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _type_parameter_index = 0;
			_tmp40_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp40_;
			_tmp41_ = _type_parameter_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_type_parameter_size = _tmp43_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp44_;
				gint _tmp45_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp46_;
				gpointer _tmp47_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp48_;
				ValaGenericType* _tmp49_;
				ValaGenericType* _tmp50_;
				ValaList* _tmp51_;
				ValaGenericType* _tmp52_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp44_ = _type_parameter_index;
				_tmp45_ = _type_parameter_size;
				if (!(_tmp44_ < _tmp45_)) {
					break;
				}
				_tmp46_ = _type_parameter_list;
				_tmp47_ = vala_list_get (_tmp46_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp47_;
				_tmp48_ = type_parameter;
				_tmp49_ = vala_generic_type_new (_tmp48_, NULL);
				type_arg = _tmp49_;
				_tmp50_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp50_, TRUE);
				_tmp51_ = method_type_args;
				_tmp52_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp51_, (ValaDataType*) _tmp52_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
		}
	}
	_tmp53_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_data_type_copy (_tmp54_);
	return_type = _tmp55_;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "returns_floating_reference")) {
		ValaDataType* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		_tmp56_ = return_type;
		_tmp57_ = vala_method_get_returns_floating_reference (self);
		_tmp58_ = _tmp57_;
		vala_data_type_set_floating_reference (_tmp56_, _tmp58_);
	} else {
		ValaDataType* _tmp59_;
		gboolean _tmp60_;
		gboolean _tmp61_;
		_tmp59_ = return_type;
		_tmp60_ = vala_method_get_returns_floating_reference (base_method);
		_tmp61_ = _tmp60_;
		vala_data_type_set_floating_reference (_tmp59_, _tmp61_);
	}
	_tmp62_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp63_ = _tmp62_;
	_tmp64_ = object_type;
	_tmp65_ = method_type_args;
	_tmp66_ = vala_data_type_get_actual_type (_tmp63_, (ValaDataType*) _tmp64_, _tmp65_, node_reference);
	actual_base_type = _tmp66_;
	_tmp67_ = return_type;
	_tmp68_ = actual_base_type;
	if (!vala_data_type_equals (_tmp67_, _tmp68_)) {
		ValaDataType* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaDataType* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp69_ = actual_base_type;
		_tmp70_ = vala_data_type_to_prototype_string (_tmp69_, NULL);
		_tmp71_ = _tmp70_;
		_tmp72_ = return_type;
		_tmp73_ = vala_data_type_to_prototype_string (_tmp72_, NULL);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp71_, _tmp74_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp75_;
		_g_free0 (_tmp74_);
		_g_free0 (_tmp71_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp76_ = self->priv->parameters;
	_tmp77_ = vala_iterable_iterator ((ValaIterable*) _tmp76_);
	method_params_it = _tmp77_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp78_;
		gint _base_param_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _base_param_index = 0;
		_tmp78_ = base_method->priv->parameters;
		_base_param_list = _tmp78_;
		_tmp79_ = _base_param_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_base_param_size = _tmp81_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp84_;
			gpointer _tmp85_;
			ValaIterator* _tmp86_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp88_;
			gpointer _tmp89_;
			ValaParameter* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			ValaParameter* _tmp93_;
			gboolean _tmp94_;
			gboolean _tmp95_;
			ValaParameter* _tmp97_;
			gboolean _tmp98_;
			gboolean _tmp99_;
			ValaParameter* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			ValaParameter* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			gint _tmp125_;
			_base_param_index = _base_param_index + 1;
			_tmp82_ = _base_param_index;
			_tmp83_ = _base_param_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _base_param_list;
			_tmp85_ = vala_list_get (_tmp84_, _base_param_index);
			base_param = (ValaParameter*) _tmp85_;
			_tmp86_ = method_params_it;
			if (!vala_iterator_next (_tmp86_)) {
				gchar* _tmp87_;
				_tmp87_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp87_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp88_ = method_params_it;
			_tmp89_ = vala_iterator_get (_tmp88_);
			param = (ValaParameter*) _tmp89_;
			_tmp90_ = base_param;
			_tmp91_ = vala_parameter_get_ellipsis (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = param;
			_tmp94_ = vala_parameter_get_ellipsis (_tmp93_);
			_tmp95_ = _tmp94_;
			if (_tmp92_ != _tmp95_) {
				gchar* _tmp96_;
				_tmp96_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp96_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp97_ = base_param;
			_tmp98_ = vala_parameter_get_params_array (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_ = param;
			_tmp101_ = vala_parameter_get_params_array (_tmp100_);
			_tmp102_ = _tmp101_;
			if (_tmp99_ != _tmp102_) {
				gchar* _tmp103_;
				_tmp103_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp103_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_code_node_unref0 (return_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp104_ = base_param;
			_tmp105_ = vala_parameter_get_ellipsis (_tmp104_);
			_tmp106_ = _tmp105_;
			if (!_tmp106_) {
				ValaParameter* _tmp107_;
				ValaParameterDirection _tmp108_;
				ValaParameterDirection _tmp109_;
				ValaParameter* _tmp110_;
				ValaParameterDirection _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameter* _tmp114_;
				ValaDataType* _tmp115_;
				ValaDataType* _tmp116_;
				ValaObjectType* _tmp117_;
				ValaList* _tmp118_;
				ValaDataType* _tmp119_;
				ValaDataType* _tmp120_;
				ValaParameter* _tmp121_;
				ValaDataType* _tmp122_;
				ValaDataType* _tmp123_;
				_tmp107_ = base_param;
				_tmp108_ = vala_parameter_get_direction (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = param;
				_tmp111_ = vala_parameter_get_direction (_tmp110_);
				_tmp112_ = _tmp111_;
				if (_tmp109_ != _tmp112_) {
					gchar* _tmp113_;
					_tmp113_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp113_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp114_ = base_param;
				_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) _tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = object_type;
				_tmp118_ = method_type_args;
				_tmp119_ = vala_data_type_get_actual_type (_tmp116_, (ValaDataType*) _tmp117_, _tmp118_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp119_;
				_tmp120_ = actual_base_type;
				_tmp121_ = param;
				_tmp122_ = vala_variable_get_variable_type ((ValaVariable*) _tmp121_);
				_tmp123_ = _tmp122_;
				if (!vala_data_type_equals (_tmp120_, _tmp123_)) {
					gchar* _tmp124_;
					_tmp124_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp124_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp125_ = param_index;
			param_index = _tmp125_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
	}
	_tmp126_ = method_params_it;
	if (vala_iterator_next (_tmp126_)) {
		gchar* _tmp127_;
		_tmp127_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp127_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp128_ = g_direct_equal;
	_tmp129_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp128_);
	base_method_errors = _tmp129_;
	_tmp130_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp130_, NULL);
	_tmp131_ = self->error_types;
	if (_tmp131_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp132_;
			gint _method_error_type_size = 0;
			ValaList* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gint _method_error_type_index = 0;
			_tmp132_ = self->error_types;
			_method_error_type_list = _tmp132_;
			_tmp133_ = _method_error_type_list;
			_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
			_tmp135_ = _tmp134_;
			_method_error_type_size = _tmp135_;
			_method_error_type_index = -1;
			while (TRUE) {
				gint _tmp136_;
				gint _tmp137_;
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp138_;
				gpointer _tmp139_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				_tmp136_ = _method_error_type_index;
				_tmp137_ = _method_error_type_size;
				if (!(_tmp136_ < _tmp137_)) {
					break;
				}
				_tmp138_ = _method_error_type_list;
				_tmp139_ = vala_list_get (_tmp138_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp139_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp140_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp141_;
					gint _tmp142_;
					gint _tmp143_;
					gint _base_method_error_type_index = 0;
					_tmp140_ = base_method_errors;
					_base_method_error_type_list = _tmp140_;
					_tmp141_ = _base_method_error_type_list;
					_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
					_tmp143_ = _tmp142_;
					_base_method_error_type_size = _tmp143_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp144_;
						gint _tmp145_;
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp146_;
						gpointer _tmp147_;
						ValaDataType* _tmp148_;
						ValaDataType* _tmp149_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						_tmp144_ = _base_method_error_type_index;
						_tmp145_ = _base_method_error_type_size;
						if (!(_tmp144_ < _tmp145_)) {
							break;
						}
						_tmp146_ = _base_method_error_type_list;
						_tmp147_ = vala_list_get ((ValaList*) _tmp146_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp147_;
						_tmp148_ = method_error_type;
						_tmp149_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp148_, _tmp149_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
				}
				if (!match) {
					ValaDataType* _tmp150_;
					gchar* _tmp151_;
					gchar* _tmp152_;
					gchar* _tmp153_;
					_tmp150_ = method_error_type;
					_tmp151_ = vala_code_node_to_string ((ValaCodeNode*) _tmp150_);
					_tmp152_ = _tmp151_;
					_tmp153_ = g_strdup_printf ("incompatible error type `%s'", _tmp152_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp153_;
					_g_free0 (_tmp152_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_code_node_unref0 (return_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
		}
	}
	_tmp154_ = base_method->priv->_coroutine;
	_tmp155_ = self->priv->_coroutine;
	if (_tmp154_ != _tmp155_) {
		gchar* _tmp156_;
		_tmp156_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp156_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_code_node_unref0 (return_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		gint _parameter_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaTypeParameter* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			_parameter_index = _parameter_index + 1;
			_tmp5_ = _parameter_index;
			_tmp6_ = _parameter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _parameter_list;
			_tmp8_ = vala_list_get (_tmp7_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp8_;
			_tmp9_ = parameter;
			_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				return result;
			}
			_tmp12_ = i;
			i = _tmp12_ + 1;
			_vala_code_node_unref0 (parameter);
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			gint _error_type_size = 0;
			ValaList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_error_type_list = _tmp1_;
			_tmp2_ = _error_type_list;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_error_type_size = _tmp4_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				_error_type_index = _error_type_index + 1;
				_tmp5_ = _error_type_index;
				_tmp6_ = _error_type_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _error_type_list;
				_tmp8_ = vala_list_get (_tmp7_, _error_type_index);
				error_type = (ValaDataType*) _tmp8_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					ValaDataType* _tmp12_;
					_tmp9_ = error_type;
					_tmp10_ = vala_data_type_copy (_tmp9_);
					type = _tmp10_;
					_tmp11_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp11_, source_reference);
					_tmp12_ = type;
					vala_collection_add (collection, _tmp12_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp13_;
					_tmp13_ = error_type;
					vala_collection_add (collection, _tmp13_);
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
}

static void
vala_method_real_replace_expression (ValaCodeNode* base,
                                     ValaExpression* old_node,
                                     ValaExpression* new_node)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		gint index = 0;
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		index = vala_list_index_of (_tmp1_, old_node);
		if (index >= 0) {
			ValaList* _tmp2_;
			_tmp2_ = self->priv->preconditions;
			vala_list_set (_tmp2_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
	_tmp3_ = self->priv->postconditions;
	if (_tmp3_ != NULL) {
		gint index = 0;
		ValaList* _tmp4_;
		_tmp4_ = self->priv->postconditions;
		index = vala_list_index_of (_tmp4_, old_node);
		if (index >= 0) {
			ValaList* _tmp5_;
			_tmp5_ = self->priv->postconditions;
			vala_list_set (_tmp5_, index, new_node);
			vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp34_;
	ValaClass* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp31_;
			ValaMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_, NULL);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				vala_report_error (_tmp24_, "overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp31_ = base_method;
			self->priv->_base_method = _tmp31_;
			_tmp32_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp32_, "CCode", "instance_pos");
			_tmp33_ = base_method;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp33_, "CCode", "returns_floating_reference");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp34_ = vala_class_get_base_class (cl);
	_tmp35_ = _tmp34_;
	if (_tmp35_ != NULL) {
		ValaClass* _tmp36_;
		ValaClass* _tmp37_;
		_tmp36_ = vala_class_get_base_class (cl);
		_tmp37_ = _tmp36_;
		vala_method_find_base_class_method (self, _tmp37_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp69_;
	ValaDataType* _tmp87_;
	ValaDataType* _tmp88_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_INTERFACE (_tmp10_)) {
				gboolean _tmp11_ = FALSE;
				ValaDataType* _tmp12_;
				ValaDataType* _tmp13_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaScope* _tmp24_;
				ValaScope* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp35_;
				_tmp12_ = vala_method_get_base_interface_type (self);
				_tmp13_ = _tmp12_;
				if (_tmp13_ != NULL) {
					ValaDataType* _tmp14_;
					ValaDataType* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaDataType* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					_tmp14_ = vala_method_get_base_interface_type (self);
					_tmp15_ = _tmp14_;
					_tmp16_ = vala_data_type_get_type_symbol (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = type;
					_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp11_ = _tmp17_ != _tmp20_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp21_ = type;
				_tmp22_ = vala_data_type_get_type_symbol (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_scope ((ValaSymbol*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_scope_lookup (_tmp25_, _tmp27_);
				sym = _tmp28_;
				_tmp29_ = sym;
				if (VALA_IS_SIGNAL (_tmp29_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp30_;
					ValaSignal* _tmp31_;
					ValaMethod* _tmp32_;
					ValaMethod* _tmp33_;
					ValaSymbol* _tmp34_;
					_tmp30_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp31_ = sig;
					_tmp32_ = vala_signal_get_default_handler (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp33_);
					_vala_code_node_unref0 (sym);
					sym = _tmp34_;
				}
				_tmp35_ = sym;
				if (VALA_IS_METHOD (_tmp35_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp36_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod);
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp60_;
						gchar* _tmp61_ = NULL;
						gboolean _tmp62_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp48_;
									gint _tmp49_;
									ValaMethod* m = NULL;
									ValaList* _tmp50_;
									gpointer _tmp51_;
									gboolean _tmp52_ = FALSE;
									ValaMethod* _tmp53_;
									ValaDataType* _tmp54_;
									ValaDataType* _tmp55_;
									_m_index = _m_index + 1;
									_tmp48_ = _m_index;
									_tmp49_ = _m_size;
									if (!(_tmp48_ < _tmp49_)) {
										break;
									}
									_tmp50_ = _m_list;
									_tmp51_ = vala_list_get (_tmp50_, _m_index);
									m = (ValaMethod*) _tmp51_;
									_tmp53_ = m;
									_tmp54_ = vala_method_get_base_interface_type (_tmp53_);
									_tmp55_ = _tmp54_;
									if (_tmp55_ != NULL) {
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										ValaMethod* _tmp58_;
										ValaMethod* _tmp59_;
										_tmp56_ = base_method;
										_tmp57_ = m;
										_tmp58_ = vala_method_get_base_interface_method (_tmp57_);
										_tmp59_ = _tmp58_;
										_tmp52_ = _tmp56_ == _tmp59_;
									} else {
										_tmp52_ = FALSE;
									}
									if (_tmp52_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp60_ = base_method;
						_tmp62_ = vala_method_compatible (self, _tmp60_, &_tmp61_);
						_g_free0 (invalid_match);
						invalid_match = _tmp61_;
						if (!_tmp62_) {
							const gchar* _tmp63_;
							gchar* _tmp64_;
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp63_ = invalid_match;
							_tmp64_ = g_strdup (_tmp63_);
							_g_free0 (invalid_error);
							invalid_error = _tmp64_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp66_;
						} else {
							ValaMethod* _tmp67_;
							ValaMethod* _tmp68_;
							_tmp67_ = base_method;
							_tmp68_ = _vala_code_node_ref0 (_tmp67_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp68_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
	}
	_tmp69_ = base_match;
	if (_tmp69_ != NULL) {
		ValaMethod* _tmp70_;
		ValaMethod* _tmp71_;
		ValaMethod* _tmp72_;
		_tmp70_ = base_match;
		self->priv->_base_interface_method = _tmp70_;
		_tmp71_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp71_, "CCode", "instance_pos");
		_tmp72_ = base_match;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) self, (ValaCodeNode*) _tmp72_, "CCode", "returns_floating_reference");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp74_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp75_ = _tmp74_;
		if (!_tmp75_) {
			ValaMethod* _tmp76_;
			_tmp76_ = invalid_base_match;
			_tmp73_ = _tmp76_ != NULL;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp77_;
			ValaMethodType* _tmp78_;
			ValaSourceReference* _tmp79_;
			ValaSourceReference* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			ValaMethodType* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			const gchar* _tmp86_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp77_ = invalid_base_match;
			_tmp78_ = vala_method_type_new (_tmp77_, NULL);
			base_method_type = _tmp78_;
			_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp80_ = _tmp79_;
			_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = base_method_type;
			_tmp84_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			_tmp86_ = invalid_error;
			vala_report_error (_tmp80_, "overriding method `%s' is incompatible with base method `%s': %s.", _tmp82_, _tmp85_, _tmp86_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp82_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp87_ = vala_method_get_base_interface_type (self);
	_tmp88_ = _tmp87_;
	if (_tmp88_ != NULL) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "`%s': no suitable interface method found to implement", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ValaMethod* self;
		self = _data2_->self;
		_vala_iterable_unref0 (_data2_->referenced_generics);
		_vala_code_node_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static ValaTraverseStatus
___lambda5_ (ValaMethod* self,
             ValaCodeNode* node)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaTraverseStatus result;
	g_return_val_if_fail (node != NULL, 0);
	if (VALA_IS_STATEMENT (node)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_EXPRESSION (node);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_VARIABLE (node);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CATCH_CLAUSE (node);
	}
	if (!_tmp0_) {
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	if (VALA_IS_YIELD_STATEMENT (node)) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (VALA_IS_METHOD_CALL (node)) {
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp6_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_METHOD_CALL, ValaMethodCall));
			_tmp7_ = _tmp6_;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		if (VALA_IS_OBJECT_CREATION_EXPRESSION (node)) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression));
			_tmp10_ = _tmp9_;
			_tmp8_ = _tmp10_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp3_ = _tmp8_;
	}
	if (_tmp3_) {
		vala_method_set_coroutine (self, TRUE);
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
____lambda5__vala_traverse_func (ValaCodeNode* node,
                                 gpointer self)
{
	ValaTraverseStatus result;
	result = ___lambda5_ ((ValaMethod*) self, node);
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static ValaTraverseStatus
__lambda6_ (Block2Data* _data2_,
            ValaCodeNode* node)
{
	ValaMethod* self;
	ValaTraverseStatus result;
	self = _data2_->self;
	g_return_val_if_fail (node != NULL, 0);
	if (VALA_IS_GENERIC_TYPE (node)) {
		ValaList* _tmp0_;
		_tmp0_ = _data2_->referenced_generics;
		vala_collection_add ((ValaCollection*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda6__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda6_ (self, node);
	return result;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	Block2Data* _data2_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp43_;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	gboolean _tmp122_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp127_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSourceFile* _tmp129_;
	ValaSourceFile* _tmp130_;
	ValaSourceFile* _tmp131_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp132_;
	ValaSemanticAnalyzer* _tmp133_;
	ValaSymbol* _tmp134_;
	ValaSymbol* _tmp135_;
	ValaSymbol* _tmp136_;
	ValaSourceReference* _tmp137_;
	ValaSourceReference* _tmp138_;
	ValaSemanticAnalyzer* _tmp145_;
	ValaSemanticAnalyzer* _tmp146_;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp148_;
	gboolean _tmp149_;
	gboolean _tmp150_;
	ValaDataType* _tmp151_;
	ValaDataType* _tmp152_;
	gboolean _tmp153_;
	gboolean _tmp154_;
	ValaDataType* _tmp159_;
	ValaDataType* _tmp160_;
	ValaTypeSymbol* _tmp161_;
	ValaTypeSymbol* _tmp162_;
	ValaSemanticAnalyzer* _tmp163_;
	ValaSemanticAnalyzer* _tmp164_;
	ValaDataType* _tmp165_;
	ValaTypeSymbol* _tmp166_;
	ValaTypeSymbol* _tmp167_;
	gboolean _tmp182_ = FALSE;
	gboolean _tmp183_ = FALSE;
	gboolean _tmp184_ = FALSE;
	ValaList* _tmp185_;
	gint _tmp186_;
	gint _tmp187_;
	gboolean _tmp201_ = FALSE;
	GEqualFunc _tmp220_;
	ValaArrayList* _tmp221_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp222_;
	ValaDataType* _tmp223_;
	ValaDataType* _tmp224_;
	ValaTraverseVisitor* _tmp225_;
	gboolean optional_param = FALSE;
	gboolean params_array_param = FALSE;
	gboolean ellipsis_param = FALSE;
	gboolean _tmp359_ = FALSE;
	gboolean _tmp360_ = FALSE;
	ValaMemberBinding _tmp361_;
	gboolean _tmp406_;
	ValaList* _tmp420_;
	ValaLocalVariable* _tmp445_;
	ValaLocalVariable* _tmp446_;
	ValaList* _tmp449_;
	ValaList* _tmp459_;
	ValaBlock* _tmp469_;
	ValaBlock* _tmp470_;
	gboolean _tmp473_ = FALSE;
	gboolean _tmp474_ = FALSE;
	gboolean _tmp475_ = FALSE;
	gboolean _tmp476_;
	gboolean _tmp516_ = FALSE;
	gboolean _tmp517_ = FALSE;
	ValaDataType* _tmp518_;
	ValaDataType* _tmp519_;
	ValaSemanticAnalyzer* _tmp560_;
	ValaSemanticAnalyzer* _tmp561_;
	ValaSourceFile* _tmp562_;
	ValaSemanticAnalyzer* _tmp563_;
	ValaSemanticAnalyzer* _tmp564_;
	ValaSymbol* _tmp565_;
	gboolean _tmp566_ = FALSE;
	gboolean _tmp567_ = FALSE;
	gboolean _tmp568_ = FALSE;
	gboolean _tmp569_;
	gboolean _tmp570_;
	ValaDataType* _tmp584_;
	ValaDataType* _tmp585_;
	gboolean _tmp634_ = FALSE;
	ValaBlock* _tmp635_;
	ValaBlock* _tmp636_;
	gboolean _tmp677_ = FALSE;
	gboolean _tmp678_ = FALSE;
	gboolean _tmp679_ = FALSE;
	gboolean _tmp680_ = FALSE;
	gboolean _tmp681_ = FALSE;
	gboolean _tmp734_;
	gboolean _tmp735_;
	gboolean result;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = vala_code_node_ref (self);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "DestroysInstance")) {
		ValaParameter* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp6_ = self->priv->_this_parameter;
		_tmp7_ = vala_variable_get_variable_type ((ValaVariable*) _tmp6_);
		_tmp8_ = _tmp7_;
		vala_data_type_set_value_owned (_tmp8_, TRUE);
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "NoThrow")) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (VALA_IS_CLASS (_tmp11_)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gboolean _tmp17_ = FALSE;
		ValaClass* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		ValaClass* _tmp26_;
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass);
		_tmp18_ = cl;
		_tmp19_ = vala_class_get_is_compact (_tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			ValaClass* _tmp21_;
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			_tmp21_ = cl;
			_tmp22_ = vala_class_get_base_class (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp17_ = _tmp23_ != NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			vala_report_error (_tmp25_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		_tmp26_ = cl;
		_tmp27_ = vala_class_get_is_opaque (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_) {
			ValaSourceReference* _tmp29_;
			ValaSourceReference* _tmp30_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp30_ = _tmp29_;
			vala_report_error (_tmp30_, "Abstract and virtual methods may not be declared in opaque compact cla" \
"sses");
			result = FALSE;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_;
		_tmp33_ = self->priv->_is_abstract;
		if (_tmp33_) {
			_tmp32_ = TRUE;
		} else {
			gboolean _tmp34_;
			_tmp34_ = self->priv->_is_virtual;
			_tmp32_ = _tmp34_;
		}
		_tmp31_ = _tmp32_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ValaSourceReference* _tmp35_;
		ValaSourceReference* _tmp36_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp36_ = _tmp35_;
		vala_report_error (_tmp36_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...' or params-array.");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "NoWrapper")) {
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_;
		_tmp39_ = self->priv->_is_abstract;
		if (_tmp39_) {
			_tmp38_ = TRUE;
		} else {
			gboolean _tmp40_;
			_tmp40_ = self->priv->_is_virtual;
			_tmp38_ = _tmp40_;
		}
		_tmp37_ = !_tmp38_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		vala_report_error (_tmp42_, "[NoWrapper] methods must be declared abstract or virtual");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp43_ = self->priv->_is_abstract;
	if (_tmp43_) {
		ValaSymbol* _tmp44_;
		ValaSymbol* _tmp45_;
		_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp45_ = _tmp44_;
		if (VALA_IS_CLASS (_tmp45_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaClass* _tmp48_;
			gboolean _tmp49_;
			gboolean _tmp50_;
			_tmp46_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp47_ = _tmp46_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CLASS, ValaClass);
			_tmp48_ = cl;
			_tmp49_ = vala_class_get_is_abstract (_tmp48_);
			_tmp50_ = _tmp49_;
			if (!_tmp50_) {
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp52_ = _tmp51_;
				vala_report_error (_tmp52_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		} else {
			ValaSymbol* _tmp53_;
			ValaSymbol* _tmp54_;
			_tmp53_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp54_ = _tmp53_;
			if (!VALA_IS_INTERFACE (_tmp54_)) {
				ValaSourceReference* _tmp55_;
				ValaSourceReference* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp56_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		}
	} else {
		gboolean _tmp57_;
		_tmp57_ = self->priv->_is_virtual;
		if (_tmp57_) {
			gboolean _tmp58_ = FALSE;
			ValaSymbol* _tmp59_;
			ValaSymbol* _tmp60_;
			_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp60_ = _tmp59_;
			if (!VALA_IS_CLASS (_tmp60_)) {
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				_tmp61_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				_tmp58_ = !VALA_IS_INTERFACE (_tmp62_);
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp64_ = _tmp63_;
				vala_report_error (_tmp64_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		} else {
			gboolean _tmp65_;
			_tmp65_ = self->priv->_overrides;
			if (_tmp65_) {
				ValaSymbol* _tmp66_;
				ValaSymbol* _tmp67_;
				_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp67_ = _tmp66_;
				if (!VALA_IS_CLASS (_tmp67_)) {
					ValaSourceReference* _tmp68_;
					ValaSourceReference* _tmp69_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp69_ = _tmp68_;
					vala_report_error (_tmp69_, "Methods may not be overridden outside of classes");
					result = FALSE;
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp70_;
				ValaSymbolAccessibility _tmp71_;
				_tmp70_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp71_ = _tmp70_;
				if (_tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp72_ = FALSE;
					ValaSymbol* _tmp73_;
					ValaSymbol* _tmp74_;
					_tmp73_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp74_ = _tmp73_;
					if (!VALA_IS_CLASS (_tmp74_)) {
						ValaSymbol* _tmp75_;
						ValaSymbol* _tmp76_;
						_tmp75_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp76_ = _tmp75_;
						_tmp72_ = !VALA_IS_INTERFACE (_tmp76_);
					} else {
						_tmp72_ = FALSE;
					}
					if (_tmp72_) {
						ValaSourceReference* _tmp77_;
						ValaSourceReference* _tmp78_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp78_ = _tmp77_;
						vala_report_error (_tmp78_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						return result;
					}
				}
			}
		}
	}
	_tmp80_ = self->priv->_is_abstract;
	if (_tmp80_) {
		ValaBlock* _tmp81_;
		ValaBlock* _tmp82_;
		_tmp81_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp82_ = _tmp81_;
		_tmp79_ = _tmp82_ != NULL;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		ValaSourceReference* _tmp83_;
		ValaSourceReference* _tmp84_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		vala_report_error (_tmp84_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp85_ = FALSE;
		gboolean _tmp86_ = FALSE;
		gboolean _tmp87_;
		_tmp87_ = self->priv->_is_abstract;
		if (_tmp87_) {
			_tmp86_ = TRUE;
		} else {
			gboolean _tmp88_;
			_tmp88_ = self->priv->_is_virtual;
			_tmp86_ = _tmp88_;
		}
		if (_tmp86_) {
			gboolean _tmp89_;
			gboolean _tmp90_;
			_tmp89_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp90_ = _tmp89_;
			_tmp85_ = _tmp90_;
		} else {
			_tmp85_ = FALSE;
		}
		if (_tmp85_) {
			ValaSourceReference* _tmp91_;
			ValaSourceReference* _tmp92_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			vala_report_error (_tmp92_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp93_ = FALSE;
			gboolean _tmp94_;
			gboolean _tmp95_;
			_tmp94_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp95_ = _tmp94_;
			if (_tmp95_) {
				ValaBlock* _tmp96_;
				ValaBlock* _tmp97_;
				_tmp96_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp97_ = _tmp96_;
				_tmp93_ = _tmp97_ != NULL;
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaSourceReference* _tmp98_;
				ValaSourceReference* _tmp99_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp99_ = _tmp98_;
				vala_report_error (_tmp99_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
				gboolean _tmp103_;
				_tmp103_ = self->priv->_is_abstract;
				if (!_tmp103_) {
					gboolean _tmp104_;
					gboolean _tmp105_;
					_tmp104_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp105_ = _tmp104_;
					_tmp102_ = !_tmp105_;
				} else {
					_tmp102_ = FALSE;
				}
				if (_tmp102_) {
					ValaSourceFileType _tmp106_;
					ValaSourceFileType _tmp107_;
					_tmp106_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp107_ = _tmp106_;
					_tmp101_ = _tmp107_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaBlock* _tmp108_;
					ValaBlock* _tmp109_;
					_tmp108_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp109_ = _tmp108_;
					_tmp100_ = _tmp109_ == NULL;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaSourceReference* _tmp110_;
					ValaSourceReference* _tmp111_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp111_ = _tmp110_;
					vala_report_error (_tmp111_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp113_ = self->priv->_is_main_block;
	if (_tmp113_) {
		ValaBlock* _tmp114_;
		ValaBlock* _tmp115_;
		_tmp114_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp115_ = _tmp114_;
		_tmp112_ = _tmp115_ != NULL;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaBlock* _tmp116_;
		ValaBlock* _tmp117_;
		ValaTraverseVisitor* _tmp118_;
		ValaTraverseVisitor* _tmp119_;
		_tmp116_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_traverse_visitor_new (____lambda5__vala_traverse_func, vala_code_node_ref (self), vala_code_node_unref);
		_tmp119_ = _tmp118_;
		vala_code_node_accept ((ValaCodeNode*) _tmp117_, (ValaCodeVisitor*) _tmp119_);
		_vala_code_visitor_unref0 (_tmp119_);
	}
	_tmp122_ = self->priv->_coroutine;
	if (_tmp122_) {
		gboolean _tmp123_;
		gboolean _tmp124_;
		_tmp123_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp124_ = _tmp123_;
		_tmp121_ = !_tmp124_;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		_tmp120_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaSourceReference* _tmp125_;
		ValaSourceReference* _tmp126_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp126_ = _tmp125_;
		vala_report_error (_tmp126_, "gio-2.0 package required for async methods");
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp127_ = vala_code_context_get_analyzer (context);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_semantic_analyzer_get_current_source_file (_tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = _vala_source_file_ref0 (_tmp130_);
	old_source_file = _tmp131_;
	_tmp132_ = vala_code_context_get_analyzer (context);
	_tmp133_ = _tmp132_;
	_tmp134_ = vala_semantic_analyzer_get_current_symbol (_tmp133_);
	_tmp135_ = _tmp134_;
	_tmp136_ = _vala_code_node_ref0 (_tmp135_);
	old_symbol = _tmp136_;
	_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp138_ = _tmp137_;
	if (_tmp138_ != NULL) {
		ValaSemanticAnalyzer* _tmp139_;
		ValaSemanticAnalyzer* _tmp140_;
		ValaSourceReference* _tmp141_;
		ValaSourceReference* _tmp142_;
		ValaSourceFile* _tmp143_;
		ValaSourceFile* _tmp144_;
		_tmp139_ = vala_code_context_get_analyzer (context);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_source_reference_get_file (_tmp142_);
		_tmp144_ = _tmp143_;
		vala_semantic_analyzer_set_current_source_file (_tmp140_, _tmp144_);
	}
	_tmp145_ = vala_code_context_get_analyzer (context);
	_tmp146_ = _tmp145_;
	vala_semantic_analyzer_set_current_symbol (_tmp146_, (ValaSymbol*) self);
	_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp148_ = _tmp147_;
	_tmp149_ = vala_method_get_returns_floating_reference (self);
	_tmp150_ = _tmp149_;
	vala_data_type_set_floating_reference (_tmp148_, _tmp150_);
	_tmp151_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp152_ = _tmp151_;
	vala_code_node_check ((ValaCodeNode*) _tmp152_, context);
	_tmp153_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp154_ = _tmp153_;
	if (!_tmp154_) {
		ValaSemanticAnalyzer* _tmp155_;
		ValaSemanticAnalyzer* _tmp156_;
		ValaDataType* _tmp157_;
		ValaDataType* _tmp158_;
		_tmp155_ = vala_code_context_get_analyzer (context);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp158_ = _tmp157_;
		vala_semantic_analyzer_check_type (_tmp156_, _tmp158_);
	}
	_tmp159_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp160_ = _tmp159_;
	_tmp161_ = vala_data_type_get_type_symbol (_tmp160_);
	_tmp162_ = _tmp161_;
	_tmp163_ = vala_code_context_get_analyzer (context);
	_tmp164_ = _tmp163_;
	_tmp165_ = _tmp164_->va_list_type;
	_tmp166_ = vala_data_type_get_type_symbol (_tmp165_);
	_tmp167_ = _tmp166_;
	if (_tmp162_ == _tmp167_) {
		ValaSourceReference* _tmp168_;
		ValaSourceReference* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		ValaTypeSymbol* _tmp172_;
		ValaTypeSymbol* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_data_type_get_type_symbol (_tmp171_);
		_tmp173_ = _tmp172_;
		_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
		_tmp175_ = _tmp174_;
		vala_report_error (_tmp169_, "`%s' not supported as return type", _tmp175_);
		_g_free0 (_tmp175_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "ModuleInit")) {
		ValaSourceReference* _tmp176_;
		ValaSourceReference* _tmp177_;
		ValaSourceFile* _tmp178_;
		ValaSourceFile* _tmp179_;
		ValaCodeContext* _tmp180_;
		ValaCodeContext* _tmp181_;
		_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_source_reference_get_file (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_source_file_get_context (_tmp179_);
		_tmp181_ = _tmp180_;
		vala_code_context_set_module_init_method (_tmp181_, self);
	}
	_tmp185_ = self->priv->parameters;
	_tmp186_ = vala_collection_get_size ((ValaCollection*) _tmp185_);
	_tmp187_ = _tmp186_;
	if (_tmp187_ == 1) {
		ValaList* _tmp188_;
		gpointer _tmp189_;
		ValaParameter* _tmp190_;
		gboolean _tmp191_;
		gboolean _tmp192_;
		_tmp188_ = self->priv->parameters;
		_tmp189_ = vala_list_get (_tmp188_, 0);
		_tmp190_ = (ValaParameter*) _tmp189_;
		_tmp191_ = vala_parameter_get_ellipsis (_tmp190_);
		_tmp192_ = _tmp191_;
		_tmp184_ = _tmp192_;
		_vala_code_node_unref0 (_tmp190_);
	} else {
		_tmp184_ = FALSE;
	}
	if (_tmp184_) {
		ValaBlock* _tmp193_;
		ValaBlock* _tmp194_;
		_tmp193_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp194_ = _tmp193_;
		_tmp183_ = _tmp194_ != NULL;
	} else {
		_tmp183_ = FALSE;
	}
	if (_tmp183_) {
		ValaMemberBinding _tmp195_;
		_tmp195_ = self->priv->_binding;
		_tmp182_ = _tmp195_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp182_ = FALSE;
	}
	if (_tmp182_) {
		ValaList* _tmp196_;
		gpointer _tmp197_;
		ValaParameter* _tmp198_;
		ValaSourceReference* _tmp199_;
		ValaSourceReference* _tmp200_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp196_ = self->priv->parameters;
		_tmp197_ = vala_list_get (_tmp196_, 0);
		_tmp198_ = (ValaParameter*) _tmp197_;
		_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp198_);
		_tmp200_ = _tmp199_;
		vala_report_error (_tmp200_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp198_);
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "Print")) {
		gboolean _tmp202_ = FALSE;
		ValaList* _tmp203_;
		gint _tmp204_;
		gint _tmp205_;
		_tmp203_ = self->priv->parameters;
		_tmp204_ = vala_collection_get_size ((ValaCollection*) _tmp203_);
		_tmp205_ = _tmp204_;
		if (_tmp205_ != 1) {
			_tmp202_ = TRUE;
		} else {
			ValaList* _tmp206_;
			gpointer _tmp207_;
			ValaParameter* _tmp208_;
			ValaDataType* _tmp209_;
			ValaDataType* _tmp210_;
			ValaTypeSymbol* _tmp211_;
			ValaTypeSymbol* _tmp212_;
			ValaSemanticAnalyzer* _tmp213_;
			ValaSemanticAnalyzer* _tmp214_;
			ValaDataType* _tmp215_;
			ValaTypeSymbol* _tmp216_;
			ValaTypeSymbol* _tmp217_;
			_tmp206_ = self->priv->parameters;
			_tmp207_ = vala_list_get (_tmp206_, 0);
			_tmp208_ = (ValaParameter*) _tmp207_;
			_tmp209_ = vala_variable_get_variable_type ((ValaVariable*) _tmp208_);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_data_type_get_type_symbol (_tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_code_context_get_analyzer (context);
			_tmp214_ = _tmp213_;
			_tmp215_ = _tmp214_->string_type;
			_tmp216_ = vala_data_type_get_type_symbol (_tmp215_);
			_tmp217_ = _tmp216_;
			_tmp202_ = _tmp212_ != _tmp217_;
			_vala_code_node_unref0 (_tmp208_);
		}
		_tmp201_ = _tmp202_;
	} else {
		_tmp201_ = FALSE;
	}
	if (_tmp201_) {
		ValaSourceReference* _tmp218_;
		ValaSourceReference* _tmp219_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp219_ = _tmp218_;
		vala_report_error (_tmp219_, "[Print] methods must have exactly one parameter of type `string'");
	}
	_tmp220_ = g_direct_equal;
	_tmp221_ = vala_array_list_new (VALA_TYPE_GENERIC_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp220_);
	_data2_->referenced_generics = (ValaList*) _tmp221_;
	_tmp222_ = vala_traverse_visitor_new (___lambda6__vala_traverse_func, block2_data_ref (_data2_), block2_data_unref);
	traverse = _tmp222_;
	_tmp223_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp224_ = _tmp223_;
	_tmp225_ = traverse;
	vala_code_node_accept ((ValaCodeNode*) _tmp224_, (ValaCodeVisitor*) _tmp225_);
	optional_param = FALSE;
	params_array_param = FALSE;
	ellipsis_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp226_;
		gint _param_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _param_index = 0;
		_tmp226_ = self->priv->parameters;
		_param_list = _tmp226_;
		_tmp227_ = _param_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_param_size = _tmp229_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			ValaParameter* param = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			ValaParameter* _tmp234_;
			gboolean _tmp235_ = FALSE;
			gboolean _tmp236_;
			gboolean _tmp243_ = FALSE;
			gboolean _tmp244_ = FALSE;
			gboolean _tmp245_;
			gboolean _tmp246_;
			ValaParameter* _tmp269_;
			ValaTraverseVisitor* _tmp270_;
			gboolean _tmp271_;
			gboolean _tmp272_ = FALSE;
			gboolean _tmp273_ = FALSE;
			gboolean _tmp298_ = FALSE;
			ValaParameter* _tmp299_;
			gboolean _tmp300_;
			gboolean _tmp301_;
			_param_index = _param_index + 1;
			_tmp230_ = _param_index;
			_tmp231_ = _param_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _param_list;
			_tmp233_ = vala_list_get (_tmp232_, _param_index);
			param = (ValaParameter*) _tmp233_;
			_tmp234_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp234_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp236_ = self->priv->_coroutine;
			if (_tmp236_) {
				ValaParameter* _tmp237_;
				ValaParameterDirection _tmp238_;
				ValaParameterDirection _tmp239_;
				_tmp237_ = param;
				_tmp238_ = vala_parameter_get_direction (_tmp237_);
				_tmp239_ = _tmp238_;
				_tmp235_ = _tmp239_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp235_ = FALSE;
			}
			if (_tmp235_) {
				ValaParameter* _tmp240_;
				ValaSourceReference* _tmp241_;
				ValaSourceReference* _tmp242_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp240_ = param;
				_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp240_);
				_tmp242_ = _tmp241_;
				vala_report_error (_tmp242_, "Reference parameters are not supported for async methods");
			}
			_tmp245_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp246_ = _tmp245_;
			if (!_tmp246_) {
				gboolean _tmp247_;
				_tmp247_ = self->priv->_coroutine;
				_tmp244_ = _tmp247_;
			} else {
				_tmp244_ = FALSE;
			}
			if (_tmp244_) {
				gboolean _tmp248_ = FALSE;
				gboolean _tmp249_ = FALSE;
				ValaParameter* _tmp250_;
				gboolean _tmp251_;
				gboolean _tmp252_;
				_tmp250_ = param;
				_tmp251_ = vala_parameter_get_ellipsis (_tmp250_);
				_tmp252_ = _tmp251_;
				if (_tmp252_) {
					_tmp249_ = TRUE;
				} else {
					ValaParameter* _tmp253_;
					gboolean _tmp254_;
					gboolean _tmp255_;
					_tmp253_ = param;
					_tmp254_ = vala_parameter_get_params_array (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp249_ = _tmp255_;
				}
				if (_tmp249_) {
					_tmp248_ = TRUE;
				} else {
					ValaParameter* _tmp256_;
					ValaDataType* _tmp257_;
					ValaDataType* _tmp258_;
					ValaTypeSymbol* _tmp259_;
					ValaTypeSymbol* _tmp260_;
					ValaSemanticAnalyzer* _tmp261_;
					ValaSemanticAnalyzer* _tmp262_;
					ValaDataType* _tmp263_;
					ValaTypeSymbol* _tmp264_;
					ValaTypeSymbol* _tmp265_;
					_tmp256_ = param;
					_tmp257_ = vala_variable_get_variable_type ((ValaVariable*) _tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_data_type_get_type_symbol (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_code_context_get_analyzer (context);
					_tmp262_ = _tmp261_;
					_tmp263_ = _tmp262_->va_list_type;
					_tmp264_ = vala_data_type_get_type_symbol (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp248_ = _tmp260_ == _tmp265_;
				}
				_tmp243_ = _tmp248_;
			} else {
				_tmp243_ = FALSE;
			}
			if (_tmp243_) {
				ValaParameter* _tmp266_;
				ValaSourceReference* _tmp267_;
				ValaSourceReference* _tmp268_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp266_ = param;
				_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp266_);
				_tmp268_ = _tmp267_;
				vala_report_error (_tmp268_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp269_ = param;
			_tmp270_ = traverse;
			vala_code_node_accept_children ((ValaCodeNode*) _tmp269_, (ValaCodeVisitor*) _tmp270_);
			_tmp271_ = self->priv->_coroutine;
			if (_tmp271_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp274_;
				ValaExpression* _tmp275_;
				ValaExpression* _tmp276_;
				_tmp274_ = param;
				_tmp275_ = vala_variable_get_initializer ((ValaVariable*) _tmp274_);
				_tmp276_ = _tmp275_;
				_tmp273_ = _tmp276_ == NULL;
			} else {
				_tmp273_ = FALSE;
			}
			if (_tmp273_) {
				ValaParameter* _tmp277_;
				gboolean _tmp278_;
				gboolean _tmp279_;
				_tmp277_ = param;
				_tmp278_ = vala_parameter_get_ellipsis (_tmp277_);
				_tmp279_ = _tmp278_;
				_tmp272_ = !_tmp279_;
			} else {
				_tmp272_ = FALSE;
			}
			if (_tmp272_) {
				ValaParameter* _tmp280_;
				ValaSourceReference* _tmp281_;
				ValaSourceReference* _tmp282_;
				_tmp280_ = param;
				_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp280_);
				_tmp282_ = _tmp281_;
				vala_report_warning (_tmp282_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp283_;
				ValaExpression* _tmp284_;
				ValaExpression* _tmp285_;
				_tmp283_ = param;
				_tmp284_ = vala_variable_get_initializer ((ValaVariable*) _tmp283_);
				_tmp285_ = _tmp284_;
				if (_tmp285_ != NULL) {
					optional_param = TRUE;
				}
			}
			if (params_array_param) {
				ValaParameter* _tmp286_;
				ValaSourceReference* _tmp287_;
				ValaSourceReference* _tmp288_;
				_tmp286_ = param;
				_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp286_);
				_tmp288_ = _tmp287_;
				vala_report_error (_tmp288_, "parameter follows params-array parameter");
			} else {
				ValaParameter* _tmp289_;
				gboolean _tmp290_;
				gboolean _tmp291_;
				_tmp289_ = param;
				_tmp290_ = vala_parameter_get_params_array (_tmp289_);
				_tmp291_ = _tmp290_;
				if (_tmp291_) {
					params_array_param = TRUE;
				}
			}
			if (ellipsis_param) {
				ValaParameter* _tmp292_;
				ValaSourceReference* _tmp293_;
				ValaSourceReference* _tmp294_;
				_tmp292_ = param;
				_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp292_);
				_tmp294_ = _tmp293_;
				vala_report_error (_tmp294_, "parameter follows ellipsis parameter");
			} else {
				ValaParameter* _tmp295_;
				gboolean _tmp296_;
				gboolean _tmp297_;
				_tmp295_ = param;
				_tmp296_ = vala_parameter_get_ellipsis (_tmp295_);
				_tmp297_ = _tmp296_;
				if (_tmp297_) {
					ellipsis_param = TRUE;
				}
			}
			_tmp299_ = param;
			_tmp300_ = vala_parameter_get_params_array (_tmp299_);
			_tmp301_ = _tmp300_;
			if (_tmp301_) {
				ValaBlock* _tmp302_;
				ValaBlock* _tmp303_;
				_tmp302_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp303_ = _tmp302_;
				_tmp298_ = _tmp303_ != NULL;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaLocalVariable* _tmp304_;
				gboolean _tmp308_;
				gboolean _tmp309_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				ValaArrayType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				ValaArrayType* _tmp320_;
				gboolean _tmp321_;
				gboolean _tmp322_;
				ValaArrayType* _tmp323_;
				gboolean _tmp324_ = FALSE;
				ValaArrayType* _tmp325_;
				ValaDataType* _tmp326_;
				ValaDataType* _tmp327_;
				ValaArrayType* _tmp336_;
				ValaExpression* _tmp337_;
				ValaExpression* _tmp338_;
				ValaArrayType* _tmp342_;
				ValaParameter* _tmp343_;
				const gchar* _tmp344_;
				const gchar* _tmp345_;
				ValaParameter* _tmp346_;
				ValaSourceReference* _tmp347_;
				ValaSourceReference* _tmp348_;
				ValaLocalVariable* _tmp349_;
				ValaLocalVariable* _tmp350_;
				ValaBlock* _tmp351_;
				ValaBlock* _tmp352_;
				ValaLocalVariable* _tmp353_;
				ValaParameter* _tmp354_;
				ValaSourceReference* _tmp355_;
				ValaSourceReference* _tmp356_;
				ValaDeclarationStatement* _tmp357_;
				ValaDeclarationStatement* _tmp358_;
				_tmp304_ = self->priv->_params_array_var;
				if (_tmp304_ != NULL) {
					ValaParameter* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaSourceReference* _tmp307_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = param;
					_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp305_);
					_tmp307_ = _tmp306_;
					vala_report_error (_tmp307_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp308_ = vala_code_context_get_experimental (context);
				_tmp309_ = _tmp308_;
				if (!_tmp309_) {
					ValaParameter* _tmp310_;
					ValaSourceReference* _tmp311_;
					ValaSourceReference* _tmp312_;
					_tmp310_ = param;
					_tmp311_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_warning (_tmp312_, "Support of params-arrays is experimental");
				}
				_tmp313_ = param;
				_tmp314_ = vala_variable_get_variable_type ((ValaVariable*) _tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_data_type_copy (_tmp315_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp316_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp317_ = type;
				_tmp318_ = vala_array_type_get_element_type (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = type;
				_tmp321_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp320_);
				_tmp322_ = _tmp321_;
				vala_data_type_set_value_owned (_tmp319_, _tmp322_);
				_tmp323_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp323_, TRUE);
				_tmp325_ = type;
				_tmp326_ = vala_array_type_get_element_type (_tmp325_);
				_tmp327_ = _tmp326_;
				if (vala_data_type_is_real_struct_type (_tmp327_)) {
					ValaArrayType* _tmp328_;
					ValaDataType* _tmp329_;
					ValaDataType* _tmp330_;
					gboolean _tmp331_;
					gboolean _tmp332_;
					_tmp328_ = type;
					_tmp329_ = vala_array_type_get_element_type (_tmp328_);
					_tmp330_ = _tmp329_;
					_tmp331_ = vala_data_type_get_nullable (_tmp330_);
					_tmp332_ = _tmp331_;
					_tmp324_ = !_tmp332_;
				} else {
					_tmp324_ = FALSE;
				}
				if (_tmp324_) {
					ValaParameter* _tmp333_;
					ValaSourceReference* _tmp334_;
					ValaSourceReference* _tmp335_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp333_ = param;
					_tmp334_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp333_);
					_tmp335_ = _tmp334_;
					vala_report_error (_tmp335_, "Only nullable struct elements are supported in params-array");
				}
				_tmp336_ = type;
				_tmp337_ = vala_array_type_get_length (_tmp336_);
				_tmp338_ = _tmp337_;
				if (_tmp338_ != NULL) {
					ValaParameter* _tmp339_;
					ValaSourceReference* _tmp340_;
					ValaSourceReference* _tmp341_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp339_ = param;
					_tmp340_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp339_);
					_tmp341_ = _tmp340_;
					vala_report_error (_tmp341_, "Passing length to params-array is not supported yet");
				}
				_tmp342_ = type;
				_tmp343_ = param;
				_tmp344_ = vala_symbol_get_name ((ValaSymbol*) _tmp343_);
				_tmp345_ = _tmp344_;
				_tmp346_ = param;
				_tmp347_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp346_);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_local_variable_new ((ValaDataType*) _tmp342_, _tmp345_, NULL, _tmp348_);
				_tmp350_ = _tmp349_;
				vala_method_set_params_array_var (self, _tmp350_);
				_vala_code_node_unref0 (_tmp350_);
				_tmp351_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp352_ = _tmp351_;
				_tmp353_ = self->priv->_params_array_var;
				_tmp354_ = param;
				_tmp355_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp354_);
				_tmp356_ = _tmp355_;
				_tmp357_ = vala_declaration_statement_new ((ValaSymbol*) _tmp353_, _tmp356_);
				_tmp358_ = _tmp357_;
				vala_block_insert_statement (_tmp352_, 0, (ValaStatement*) _tmp358_);
				_vala_code_node_unref0 (_tmp358_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp361_ = self->priv->_binding;
	if (_tmp361_ == VALA_MEMBER_BINDING_STATIC) {
		ValaSymbol* _tmp362_;
		ValaSymbol* _tmp363_;
		_tmp362_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp363_ = _tmp362_;
		_tmp360_ = VALA_IS_CLASS (_tmp363_);
	} else {
		_tmp360_ = FALSE;
	}
	if (_tmp360_) {
		ValaSymbol* _tmp364_;
		ValaSymbol* _tmp365_;
		gboolean _tmp366_;
		gboolean _tmp367_;
		_tmp364_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp365_ = _tmp364_;
		_tmp366_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp365_, VALA_TYPE_CLASS, ValaClass));
		_tmp367_ = _tmp366_;
		_tmp359_ = !_tmp367_;
	} else {
		_tmp359_ = FALSE;
	}
	if (_tmp359_) {
		ValaIterator* ref_generics_it = NULL;
		ValaList* _tmp368_;
		ValaIterator* _tmp369_;
		_tmp368_ = _data2_->referenced_generics;
		_tmp369_ = vala_iterable_iterator ((ValaIterable*) _tmp368_);
		ref_generics_it = _tmp369_;
		while (TRUE) {
			ValaIterator* _tmp370_;
			ValaGenericType* ref_generics = NULL;
			ValaIterator* _tmp371_;
			gpointer _tmp372_;
			_tmp370_ = ref_generics_it;
			if (!vala_iterator_next (_tmp370_)) {
				break;
			}
			_tmp371_ = ref_generics_it;
			_tmp372_ = vala_iterator_get (_tmp371_);
			ref_generics = (ValaGenericType*) _tmp372_;
			{
				ValaList* _type_param_list = NULL;
				ValaList* _tmp373_;
				gint _type_param_size = 0;
				ValaList* _tmp374_;
				gint _tmp375_;
				gint _tmp376_;
				gint _type_param_index = 0;
				_tmp373_ = vala_method_get_type_parameters (self);
				_type_param_list = _tmp373_;
				_tmp374_ = _type_param_list;
				_tmp375_ = vala_collection_get_size ((ValaCollection*) _tmp374_);
				_tmp376_ = _tmp375_;
				_type_param_size = _tmp376_;
				_type_param_index = -1;
				while (TRUE) {
					gint _tmp377_;
					gint _tmp378_;
					ValaTypeParameter* type_param = NULL;
					ValaList* _tmp379_;
					gpointer _tmp380_;
					ValaGenericType* _tmp381_;
					ValaTypeParameter* _tmp382_;
					ValaTypeParameter* _tmp383_;
					const gchar* _tmp384_;
					const gchar* _tmp385_;
					ValaTypeParameter* _tmp386_;
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					_type_param_index = _type_param_index + 1;
					_tmp377_ = _type_param_index;
					_tmp378_ = _type_param_size;
					if (!(_tmp377_ < _tmp378_)) {
						break;
					}
					_tmp379_ = _type_param_list;
					_tmp380_ = vala_list_get (_tmp379_, _type_param_index);
					type_param = (ValaTypeParameter*) _tmp380_;
					_tmp381_ = ref_generics;
					_tmp382_ = vala_generic_type_get_type_parameter (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = vala_symbol_get_name ((ValaSymbol*) _tmp383_);
					_tmp385_ = _tmp384_;
					_tmp386_ = type_param;
					_tmp387_ = vala_symbol_get_name ((ValaSymbol*) _tmp386_);
					_tmp388_ = _tmp387_;
					if (g_strcmp0 (_tmp385_, _tmp388_) == 0) {
						ValaIterator* _tmp389_;
						_tmp389_ = ref_generics_it;
						vala_iterator_remove (_tmp389_);
					}
					_vala_code_node_unref0 (type_param);
				}
			}
			_vala_code_node_unref0 (ref_generics);
		}
		{
			ValaList* _type_list = NULL;
			ValaList* _tmp390_;
			gint _type_size = 0;
			ValaList* _tmp391_;
			gint _tmp392_;
			gint _tmp393_;
			gint _type_index = 0;
			_tmp390_ = _data2_->referenced_generics;
			_type_list = _tmp390_;
			_tmp391_ = _type_list;
			_tmp392_ = vala_collection_get_size ((ValaCollection*) _tmp391_);
			_tmp393_ = _tmp392_;
			_type_size = _tmp393_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp394_;
				gint _tmp395_;
				ValaGenericType* type = NULL;
				ValaList* _tmp396_;
				gpointer _tmp397_;
				ValaGenericType* _tmp398_;
				ValaSourceReference* _tmp399_;
				ValaSourceReference* _tmp400_;
				ValaGenericType* _tmp401_;
				ValaTypeParameter* _tmp402_;
				ValaTypeParameter* _tmp403_;
				const gchar* _tmp404_;
				const gchar* _tmp405_;
				_type_index = _type_index + 1;
				_tmp394_ = _type_index;
				_tmp395_ = _type_size;
				if (!(_tmp394_ < _tmp395_)) {
					break;
				}
				_tmp396_ = _type_list;
				_tmp397_ = vala_list_get (_tmp396_, _type_index);
				type = (ValaGenericType*) _tmp397_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp398_ = type;
				_tmp399_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = type;
				_tmp402_ = vala_generic_type_get_type_parameter (_tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_symbol_get_name ((ValaSymbol*) _tmp403_);
				_tmp405_ = _tmp404_;
				vala_report_error (_tmp400_, "The type name `%s' could not be found", _tmp405_);
				_vala_code_node_unref0 (type);
			}
		}
		_vala_iterator_unref0 (ref_generics_it);
	}
	_tmp406_ = self->priv->_coroutine;
	if (_tmp406_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp407_;
			gint _tmp408_;
			gint _tmp409_;
			_tmp407_ = self->priv->parameters;
			_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
			_tmp409_ = _tmp408_;
			i = _tmp409_ - 1;
			{
				gboolean _tmp410_ = FALSE;
				_tmp410_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp412_;
					gpointer _tmp413_;
					ValaParameter* _tmp414_;
					ValaParameterDirection _tmp415_;
					ValaParameterDirection _tmp416_;
					if (!_tmp410_) {
						gint _tmp411_;
						_tmp411_ = i;
						i = _tmp411_ - 1;
					}
					_tmp410_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp412_ = self->priv->parameters;
					_tmp413_ = vala_list_get (_tmp412_, i);
					param = (ValaParameter*) _tmp413_;
					_tmp414_ = param;
					_tmp415_ = vala_parameter_get_direction (_tmp414_);
					_tmp416_ = _tmp415_;
					if (_tmp416_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp417_;
							ValaSourceReference* _tmp418_;
							ValaSourceReference* _tmp419_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp417_ = param;
							_tmp418_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp417_);
							_tmp419_ = _tmp418_;
							vala_report_error (_tmp419_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp420_ = self->error_types;
	if (_tmp420_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp421_;
			gint _error_type_size = 0;
			ValaList* _tmp422_;
			gint _tmp423_;
			gint _tmp424_;
			gint _error_type_index = 0;
			_tmp421_ = self->error_types;
			_error_type_list = _tmp421_;
			_tmp422_ = _error_type_list;
			_tmp423_ = vala_collection_get_size ((ValaCollection*) _tmp422_);
			_tmp424_ = _tmp423_;
			_error_type_size = _tmp424_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp425_;
				gint _tmp426_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp427_;
				gpointer _tmp428_;
				ValaDataType* _tmp429_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp437_;
				_error_type_index = _error_type_index + 1;
				_tmp425_ = _error_type_index;
				_tmp426_ = _error_type_size;
				if (!(_tmp425_ < _tmp426_)) {
					break;
				}
				_tmp427_ = _error_type_list;
				_tmp428_ = vala_list_get (_tmp427_, _error_type_index);
				error_type = (ValaDataType*) _tmp428_;
				_tmp429_ = error_type;
				if (!VALA_IS_ERROR_TYPE (_tmp429_)) {
					ValaDataType* _tmp430_;
					ValaSourceReference* _tmp431_;
					ValaSourceReference* _tmp432_;
					ValaDataType* _tmp433_;
					gchar* _tmp434_;
					gchar* _tmp435_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp430_ = error_type;
					_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp430_);
					_tmp432_ = _tmp431_;
					_tmp433_ = error_type;
					_tmp434_ = vala_code_node_to_string ((ValaCodeNode*) _tmp433_);
					_tmp435_ = _tmp434_;
					vala_report_error (_tmp432_, "`%s' is not an error type", _tmp435_);
					_g_free0 (_tmp435_);
				}
				_tmp436_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp436_, context);
				_tmp437_ = error_type;
				if (!vala_data_type_is_accessible (_tmp437_, (ValaSymbol*) self)) {
					ValaSourceReference* _tmp438_;
					ValaSourceReference* _tmp439_;
					ValaDataType* _tmp440_;
					gchar* _tmp441_;
					gchar* _tmp442_;
					gchar* _tmp443_;
					gchar* _tmp444_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp439_ = _tmp438_;
					_tmp440_ = error_type;
					_tmp441_ = vala_code_node_to_string ((ValaCodeNode*) _tmp440_);
					_tmp442_ = _tmp441_;
					_tmp443_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp444_ = _tmp443_;
					vala_report_error (_tmp439_, "error type `%s' is less accessible than method `%s'", _tmp442_, _tmp444_);
					_g_free0 (_tmp444_);
					_g_free0 (_tmp442_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_code_visitor_unref0 (traverse);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
		}
	}
	_tmp445_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp446_ = _tmp445_;
	if (_tmp446_ != NULL) {
		ValaLocalVariable* _tmp447_;
		ValaLocalVariable* _tmp448_;
		_tmp447_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp448_ = _tmp447_;
		vala_code_node_check ((ValaCodeNode*) _tmp448_, context);
	}
	_tmp449_ = self->priv->preconditions;
	if (_tmp449_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp450_;
			gint _precondition_size = 0;
			ValaList* _tmp451_;
			gint _tmp452_;
			gint _tmp453_;
			gint _precondition_index = 0;
			_tmp450_ = self->priv->preconditions;
			_precondition_list = _tmp450_;
			_tmp451_ = _precondition_list;
			_tmp452_ = vala_collection_get_size ((ValaCollection*) _tmp451_);
			_tmp453_ = _tmp452_;
			_precondition_size = _tmp453_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp454_;
				gint _tmp455_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp456_;
				gpointer _tmp457_;
				ValaExpression* _tmp458_;
				_precondition_index = _precondition_index + 1;
				_tmp454_ = _precondition_index;
				_tmp455_ = _precondition_size;
				if (!(_tmp454_ < _tmp455_)) {
					break;
				}
				_tmp456_ = _precondition_list;
				_tmp457_ = vala_list_get (_tmp456_, _precondition_index);
				precondition = (ValaExpression*) _tmp457_;
				_tmp458_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp458_, context);
				_vala_code_node_unref0 (precondition);
			}
		}
	}
	_tmp459_ = self->priv->postconditions;
	if (_tmp459_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp460_;
			gint _postcondition_size = 0;
			ValaList* _tmp461_;
			gint _tmp462_;
			gint _tmp463_;
			gint _postcondition_index = 0;
			_tmp460_ = self->priv->postconditions;
			_postcondition_list = _tmp460_;
			_tmp461_ = _postcondition_list;
			_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
			_tmp463_ = _tmp462_;
			_postcondition_size = _tmp463_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp464_;
				gint _tmp465_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp466_;
				gpointer _tmp467_;
				ValaExpression* _tmp468_;
				_postcondition_index = _postcondition_index + 1;
				_tmp464_ = _postcondition_index;
				_tmp465_ = _postcondition_size;
				if (!(_tmp464_ < _tmp465_)) {
					break;
				}
				_tmp466_ = _postcondition_list;
				_tmp467_ = vala_list_get (_tmp466_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp467_;
				_tmp468_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp468_, context);
				_vala_code_node_unref0 (postcondition);
			}
		}
	}
	_tmp469_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp470_ = _tmp469_;
	if (_tmp470_ != NULL) {
		ValaBlock* _tmp471_;
		ValaBlock* _tmp472_;
		_tmp471_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp472_ = _tmp471_;
		vala_code_node_check ((ValaCodeNode*) _tmp472_, context);
	}
	_tmp476_ = self->priv->_overrides;
	if (_tmp476_) {
		ValaMethod* _tmp477_;
		ValaMethod* _tmp478_;
		_tmp477_ = vala_method_get_base_method (self);
		_tmp478_ = _tmp477_;
		_tmp475_ = _tmp478_ == NULL;
	} else {
		_tmp475_ = FALSE;
	}
	if (_tmp475_) {
		ValaMethod* _tmp479_;
		ValaMethod* _tmp480_;
		_tmp479_ = vala_method_get_base_interface_method (self);
		_tmp480_ = _tmp479_;
		_tmp474_ = _tmp480_ != NULL;
	} else {
		_tmp474_ = FALSE;
	}
	if (_tmp474_) {
		ValaMethod* _tmp481_;
		ValaMethod* _tmp482_;
		gboolean _tmp483_;
		_tmp481_ = vala_method_get_base_interface_method (self);
		_tmp482_ = _tmp481_;
		_tmp483_ = _tmp482_->priv->_is_abstract;
		_tmp473_ = _tmp483_;
	} else {
		_tmp473_ = FALSE;
	}
	if (_tmp473_) {
		ValaSourceReference* _tmp484_;
		ValaSourceReference* _tmp485_;
		ValaMethod* _tmp486_;
		ValaMethod* _tmp487_;
		gchar* _tmp488_;
		gchar* _tmp489_;
		_tmp484_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp485_ = _tmp484_;
		_tmp486_ = vala_method_get_base_interface_method (self);
		_tmp487_ = _tmp486_;
		_tmp488_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp487_);
		_tmp489_ = _tmp488_;
		vala_report_warning (_tmp485_, "`override' not required to implement `abstract' interface method `%s'", _tmp489_);
		_g_free0 (_tmp489_);
		vala_method_set_overrides (self, FALSE);
	} else {
		gboolean _tmp490_ = FALSE;
		gboolean _tmp491_ = FALSE;
		gboolean _tmp492_ = FALSE;
		gboolean _tmp493_;
		gboolean _tmp494_;
		_tmp493_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp494_ = _tmp493_;
		if (!_tmp494_) {
			gboolean _tmp495_;
			_tmp495_ = self->priv->_overrides;
			_tmp492_ = _tmp495_;
		} else {
			_tmp492_ = FALSE;
		}
		if (_tmp492_) {
			ValaMethod* _tmp496_;
			ValaMethod* _tmp497_;
			_tmp496_ = vala_method_get_base_method (self);
			_tmp497_ = _tmp496_;
			_tmp491_ = _tmp497_ == NULL;
		} else {
			_tmp491_ = FALSE;
		}
		if (_tmp491_) {
			ValaMethod* _tmp498_;
			ValaMethod* _tmp499_;
			_tmp498_ = vala_method_get_base_interface_method (self);
			_tmp499_ = _tmp498_;
			_tmp490_ = _tmp499_ == NULL;
		} else {
			_tmp490_ = FALSE;
		}
		if (_tmp490_) {
			ValaSourceReference* _tmp500_;
			ValaSourceReference* _tmp501_;
			gchar* _tmp502_;
			gchar* _tmp503_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp500_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp501_ = _tmp500_;
			_tmp502_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp503_ = _tmp502_;
			vala_report_error (_tmp501_, "`%s': no suitable method found to override", _tmp503_);
			_g_free0 (_tmp503_);
		} else {
			gboolean _tmp504_ = FALSE;
			gboolean _tmp505_ = FALSE;
			gboolean _tmp506_ = FALSE;
			gboolean _tmp507_;
			_tmp507_ = self->priv->_is_abstract;
			if (_tmp507_) {
				_tmp506_ = TRUE;
			} else {
				gboolean _tmp508_;
				_tmp508_ = self->priv->_is_virtual;
				_tmp506_ = _tmp508_;
			}
			if (_tmp506_) {
				_tmp505_ = TRUE;
			} else {
				gboolean _tmp509_;
				_tmp509_ = self->priv->_overrides;
				_tmp505_ = _tmp509_;
			}
			if (_tmp505_) {
				ValaSymbolAccessibility _tmp510_;
				ValaSymbolAccessibility _tmp511_;
				_tmp510_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp511_ = _tmp510_;
				_tmp504_ = _tmp511_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp504_ = FALSE;
			}
			if (_tmp504_) {
				ValaSourceReference* _tmp512_;
				ValaSourceReference* _tmp513_;
				gchar* _tmp514_;
				gchar* _tmp515_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp513_ = _tmp512_;
				_tmp514_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp515_ = _tmp514_;
				vala_report_error (_tmp513_, "Private member `%s' cannot be marked as override, virtual, or abstract", _tmp515_);
				_g_free0 (_tmp515_);
				result = FALSE;
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
		}
	}
	_tmp518_ = vala_method_get_base_interface_type (self);
	_tmp519_ = _tmp518_;
	if (_tmp519_ != NULL) {
		ValaMethod* _tmp520_;
		ValaMethod* _tmp521_;
		_tmp520_ = vala_method_get_base_interface_method (self);
		_tmp521_ = _tmp520_;
		_tmp517_ = _tmp521_ != NULL;
	} else {
		_tmp517_ = FALSE;
	}
	if (_tmp517_) {
		ValaSymbol* _tmp522_;
		ValaSymbol* _tmp523_;
		_tmp522_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp523_ = _tmp522_;
		_tmp516_ = VALA_IS_CLASS (_tmp523_);
	} else {
		_tmp516_ = FALSE;
	}
	if (_tmp516_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp524_;
		ValaSymbol* _tmp525_;
		_tmp524_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp525_ = _tmp524_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp525_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp526_;
			ValaList* _tmp527_;
			gint _m_size = 0;
			ValaList* _tmp528_;
			gint _tmp529_;
			gint _tmp530_;
			gint _m_index = 0;
			_tmp526_ = cl;
			_tmp527_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp526_);
			_m_list = _tmp527_;
			_tmp528_ = _m_list;
			_tmp529_ = vala_collection_get_size ((ValaCollection*) _tmp528_);
			_tmp530_ = _tmp529_;
			_m_size = _tmp530_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp531_;
				gint _tmp532_;
				ValaMethod* m = NULL;
				ValaList* _tmp533_;
				gpointer _tmp534_;
				gboolean _tmp535_ = FALSE;
				ValaMethod* _tmp536_;
				_m_index = _m_index + 1;
				_tmp531_ = _m_index;
				_tmp532_ = _m_size;
				if (!(_tmp531_ < _tmp532_)) {
					break;
				}
				_tmp533_ = _m_list;
				_tmp534_ = vala_list_get (_tmp533_, _m_index);
				m = (ValaMethod*) _tmp534_;
				_tmp536_ = m;
				if (_tmp536_ != self) {
					ValaMethod* _tmp537_;
					ValaMethod* _tmp538_;
					ValaMethod* _tmp539_;
					ValaMethod* _tmp540_;
					ValaMethod* _tmp541_;
					_tmp537_ = m;
					_tmp538_ = vala_method_get_base_interface_method (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = vala_method_get_base_interface_method (self);
					_tmp541_ = _tmp540_;
					_tmp535_ = _tmp539_ == _tmp541_;
				} else {
					_tmp535_ = FALSE;
				}
				if (_tmp535_) {
					ValaMethod* _tmp542_;
					ValaMethod* _tmp543_;
					ValaSourceReference* _tmp544_;
					ValaSourceReference* _tmp545_;
					ValaClass* _tmp546_;
					gchar* _tmp547_;
					gchar* _tmp548_;
					ValaMethod* _tmp549_;
					ValaMethod* _tmp550_;
					gchar* _tmp551_;
					gchar* _tmp552_;
					ValaMethod* _tmp553_;
					ValaSourceReference* _tmp554_;
					ValaSourceReference* _tmp555_;
					ValaMethod* _tmp556_;
					ValaMethod* _tmp557_;
					gchar* _tmp558_;
					gchar* _tmp559_;
					_tmp542_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp542_, TRUE);
					_tmp543_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp543_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp545_ = _tmp544_;
					_tmp546_ = cl;
					_tmp547_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp546_);
					_tmp548_ = _tmp547_;
					_tmp549_ = vala_method_get_base_interface_method (self);
					_tmp550_ = _tmp549_;
					_tmp551_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp550_);
					_tmp552_ = _tmp551_;
					vala_report_error (_tmp545_, "`%s' already contains an implementation for `%s'", _tmp548_, _tmp552_);
					_g_free0 (_tmp552_);
					_g_free0 (_tmp548_);
					_tmp553_ = m;
					_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = vala_method_get_base_interface_method (self);
					_tmp557_ = _tmp556_;
					_tmp558_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp557_);
					_tmp559_ = _tmp558_;
					vala_report_notice (_tmp555_, "previous implementation of `%s' was here", _tmp559_);
					_g_free0 (_tmp559_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_code_visitor_unref0 (traverse);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				}
				_vala_code_node_unref0 (m);
			}
		}
	}
	_tmp560_ = vala_code_context_get_analyzer (context);
	_tmp561_ = _tmp560_;
	_tmp562_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp561_, _tmp562_);
	_tmp563_ = vala_code_context_get_analyzer (context);
	_tmp564_ = _tmp563_;
	_tmp565_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp564_, _tmp565_);
	_tmp569_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp570_ = _tmp569_;
	if (!_tmp570_) {
		gboolean _tmp571_;
		_tmp571_ = self->priv->_overrides;
		_tmp568_ = !_tmp571_;
	} else {
		_tmp568_ = FALSE;
	}
	if (_tmp568_) {
		gboolean _tmp572_;
		gboolean _tmp573_;
		_tmp572_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp573_ = _tmp572_;
		_tmp567_ = !_tmp573_;
	} else {
		_tmp567_ = FALSE;
	}
	if (_tmp567_) {
		ValaSymbol* _tmp574_;
		ValaSymbol* _tmp575_;
		_tmp574_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp575_ = _tmp574_;
		_tmp566_ = _tmp575_ != NULL;
		_vala_code_node_unref0 (_tmp575_);
	} else {
		_tmp566_ = FALSE;
	}
	if (_tmp566_) {
		ValaSourceReference* _tmp576_;
		ValaSourceReference* _tmp577_;
		gchar* _tmp578_;
		gchar* _tmp579_;
		ValaSymbol* _tmp580_;
		ValaSymbol* _tmp581_;
		gchar* _tmp582_;
		gchar* _tmp583_;
		_tmp576_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp577_ = _tmp576_;
		_tmp578_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp579_ = _tmp578_;
		_tmp580_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp581_ = _tmp580_;
		_tmp582_ = vala_symbol_get_full_name (_tmp581_);
		_tmp583_ = _tmp582_;
		vala_report_warning (_tmp577_, "%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp579_, _tmp583_);
		_g_free0 (_tmp583_);
		_vala_code_node_unref0 (_tmp581_);
		_g_free0 (_tmp579_);
	}
	_tmp584_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp585_ = _tmp584_;
	if (!vala_data_type_is_accessible (_tmp585_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp586_;
		ValaSourceReference* _tmp587_;
		ValaDataType* _tmp588_;
		ValaDataType* _tmp589_;
		gchar* _tmp590_;
		gchar* _tmp591_;
		gchar* _tmp592_;
		gchar* _tmp593_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp586_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp587_ = _tmp586_;
		_tmp588_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp589_ = _tmp588_;
		_tmp590_ = vala_code_node_to_string ((ValaCodeNode*) _tmp589_);
		_tmp591_ = _tmp590_;
		_tmp592_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp593_ = _tmp592_;
		vala_report_error (_tmp587_, "return type `%s' is less accessible than method `%s'", _tmp591_, _tmp593_);
		_g_free0 (_tmp593_);
		_g_free0 (_tmp591_);
		result = FALSE;
		_vala_code_visitor_unref0 (traverse);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp594_;
		gint _precondition_size = 0;
		ValaList* _tmp595_;
		gint _tmp596_;
		gint _tmp597_;
		gint _precondition_index = 0;
		_tmp594_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp594_;
		_tmp595_ = _precondition_list;
		_tmp596_ = vala_collection_get_size ((ValaCollection*) _tmp595_);
		_tmp597_ = _tmp596_;
		_precondition_size = _tmp597_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp598_;
			gint _tmp599_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp600_;
			gpointer _tmp601_;
			ValaExpression* _tmp602_;
			gboolean _tmp603_;
			gboolean _tmp604_;
			ValaExpression* _tmp605_;
			ValaDataType* _tmp606_;
			ValaDataType* _tmp607_;
			ValaSemanticAnalyzer* _tmp608_;
			ValaSemanticAnalyzer* _tmp609_;
			ValaDataType* _tmp610_;
			_precondition_index = _precondition_index + 1;
			_tmp598_ = _precondition_index;
			_tmp599_ = _precondition_size;
			if (!(_tmp598_ < _tmp599_)) {
				break;
			}
			_tmp600_ = _precondition_list;
			_tmp601_ = vala_list_get (_tmp600_, _precondition_index);
			precondition = (ValaExpression*) _tmp601_;
			_tmp602_ = precondition;
			_tmp603_ = vala_code_node_get_error ((ValaCodeNode*) _tmp602_);
			_tmp604_ = _tmp603_;
			if (_tmp604_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp605_ = precondition;
			_tmp606_ = vala_expression_get_value_type (_tmp605_);
			_tmp607_ = _tmp606_;
			_tmp608_ = vala_code_context_get_analyzer (context);
			_tmp609_ = _tmp608_;
			_tmp610_ = _tmp609_->bool_type;
			if (!vala_data_type_compatible (_tmp607_, _tmp610_)) {
				ValaExpression* _tmp611_;
				ValaSourceReference* _tmp612_;
				ValaSourceReference* _tmp613_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp611_ = precondition;
				_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp611_);
				_tmp613_ = _tmp612_;
				vala_report_error (_tmp613_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp614_;
		gint _postcondition_size = 0;
		ValaList* _tmp615_;
		gint _tmp616_;
		gint _tmp617_;
		gint _postcondition_index = 0;
		_tmp614_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp614_;
		_tmp615_ = _postcondition_list;
		_tmp616_ = vala_collection_get_size ((ValaCollection*) _tmp615_);
		_tmp617_ = _tmp616_;
		_postcondition_size = _tmp617_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp618_;
			gint _tmp619_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp620_;
			gpointer _tmp621_;
			ValaExpression* _tmp622_;
			gboolean _tmp623_;
			gboolean _tmp624_;
			ValaExpression* _tmp625_;
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			ValaSemanticAnalyzer* _tmp628_;
			ValaSemanticAnalyzer* _tmp629_;
			ValaDataType* _tmp630_;
			_postcondition_index = _postcondition_index + 1;
			_tmp618_ = _postcondition_index;
			_tmp619_ = _postcondition_size;
			if (!(_tmp618_ < _tmp619_)) {
				break;
			}
			_tmp620_ = _postcondition_list;
			_tmp621_ = vala_list_get (_tmp620_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp621_;
			_tmp622_ = postcondition;
			_tmp623_ = vala_code_node_get_error ((ValaCodeNode*) _tmp622_);
			_tmp624_ = _tmp623_;
			if (_tmp624_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_tmp625_ = postcondition;
			_tmp626_ = vala_expression_get_value_type (_tmp625_);
			_tmp627_ = _tmp626_;
			_tmp628_ = vala_code_context_get_analyzer (context);
			_tmp629_ = _tmp628_;
			_tmp630_ = _tmp629_->bool_type;
			if (!vala_data_type_compatible (_tmp627_, _tmp630_)) {
				ValaExpression* _tmp631_;
				ValaSourceReference* _tmp632_;
				ValaSourceReference* _tmp633_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp631_ = postcondition;
				_tmp632_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp631_);
				_tmp633_ = _tmp632_;
				vala_report_error (_tmp633_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_code_visitor_unref0 (traverse);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
	}
	_tmp635_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp636_ = _tmp635_;
	if (_tmp636_ != NULL) {
		ValaBlock* _tmp637_;
		ValaBlock* _tmp638_;
		gboolean _tmp639_;
		gboolean _tmp640_;
		_tmp637_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp638_ = _tmp637_;
		_tmp639_ = vala_code_node_get_error ((ValaCodeNode*) _tmp638_);
		_tmp640_ = _tmp639_;
		_tmp634_ = !_tmp640_;
	} else {
		_tmp634_ = FALSE;
	}
	if (_tmp634_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp641_;
		ValaArrayList* _tmp642_;
		ValaBlock* _tmp643_;
		ValaBlock* _tmp644_;
		ValaArrayList* _tmp645_;
		_tmp641_ = g_direct_equal;
		_tmp642_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp641_);
		body_errors = _tmp642_;
		_tmp643_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp644_ = _tmp643_;
		_tmp645_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp644_, (ValaCollection*) _tmp645_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp646_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp647_;
			gint _tmp648_;
			gint _tmp649_;
			gint _body_error_type_index = 0;
			_tmp646_ = body_errors;
			_body_error_type_list = _tmp646_;
			_tmp647_ = _body_error_type_list;
			_tmp648_ = vala_collection_get_size ((ValaCollection*) _tmp647_);
			_tmp649_ = _tmp648_;
			_body_error_type_size = _tmp649_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp650_;
				gint _tmp651_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp652_;
				gpointer _tmp653_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp654_;
				gboolean _tmp665_ = FALSE;
				ValaDataType* _tmp666_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp670_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp650_ = _body_error_type_index;
				_tmp651_ = _body_error_type_size;
				if (!(_tmp650_ < _tmp651_)) {
					break;
				}
				_tmp652_ = _body_error_type_list;
				_tmp653_ = vala_list_get ((ValaList*) _tmp652_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp653_;
				can_propagate_error = FALSE;
				_tmp654_ = self->error_types;
				if (_tmp654_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp655_;
						gint _method_error_type_size = 0;
						ValaList* _tmp656_;
						gint _tmp657_;
						gint _tmp658_;
						gint _method_error_type_index = 0;
						_tmp655_ = self->error_types;
						_method_error_type_list = _tmp655_;
						_tmp656_ = _method_error_type_list;
						_tmp657_ = vala_collection_get_size ((ValaCollection*) _tmp656_);
						_tmp658_ = _tmp657_;
						_method_error_type_size = _tmp658_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp659_;
							gint _tmp660_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp661_;
							gpointer _tmp662_;
							ValaDataType* _tmp663_;
							ValaDataType* _tmp664_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp659_ = _method_error_type_index;
							_tmp660_ = _method_error_type_size;
							if (!(_tmp659_ < _tmp660_)) {
								break;
							}
							_tmp661_ = _method_error_type_list;
							_tmp662_ = vala_list_get (_tmp661_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp662_;
							_tmp663_ = body_error_type;
							_tmp664_ = method_error_type;
							if (vala_data_type_compatible (_tmp663_, _tmp664_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
					}
				}
				_tmp666_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp666_)) {
					ValaDataType* _tmp667_;
					gboolean _tmp668_;
					gboolean _tmp669_;
					_tmp667_ = body_error_type;
					_tmp668_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp667_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp669_ = _tmp668_;
					_tmp665_ = _tmp669_;
				} else {
					_tmp665_ = FALSE;
				}
				is_dynamic_error = _tmp665_;
				if (!can_propagate_error) {
					_tmp670_ = !is_dynamic_error;
				} else {
					_tmp670_ = FALSE;
				}
				if (_tmp670_) {
					ValaDataType* _tmp671_;
					ValaSourceReference* _tmp672_;
					ValaSourceReference* _tmp673_;
					ValaDataType* _tmp674_;
					gchar* _tmp675_;
					gchar* _tmp676_;
					_tmp671_ = body_error_type;
					_tmp672_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = body_error_type;
					_tmp675_ = vala_code_node_to_string ((ValaCodeNode*) _tmp674_);
					_tmp676_ = _tmp675_;
					vala_report_warning (_tmp673_, "unhandled error `%s'", _tmp676_);
					_g_free0 (_tmp676_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp682_;
		_tmp682_ = self->priv->_binding;
		_tmp681_ = _tmp682_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp681_ = FALSE;
	}
	if (_tmp681_) {
		gboolean _tmp683_;
		_tmp683_ = self->priv->_overrides;
		_tmp680_ = !_tmp683_;
	} else {
		_tmp680_ = FALSE;
	}
	if (_tmp680_) {
		ValaSymbolAccessibility _tmp684_;
		ValaSymbolAccessibility _tmp685_;
		_tmp684_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp685_ = _tmp684_;
		_tmp679_ = _tmp685_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp679_ = FALSE;
	}
	if (_tmp679_) {
		ValaSymbol* _tmp686_;
		ValaSymbol* _tmp687_;
		_tmp686_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp687_ = _tmp686_;
		_tmp678_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp687_);
	} else {
		_tmp678_ = FALSE;
	}
	if (_tmp678_) {
		ValaSymbol* _tmp688_;
		ValaSymbol* _tmp689_;
		_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp689_ = _tmp688_;
		_tmp677_ = vala_code_node_has_attribute ((ValaCodeNode*) _tmp689_, "DBus");
	} else {
		_tmp677_ = FALSE;
	}
	if (_tmp677_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp690_;
		ValaAttribute* _tmp691_;
		gboolean _tmp692_ = FALSE;
		ValaAttribute* _tmp693_;
		_tmp690_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp691_ = _vala_code_node_ref0 (_tmp690_);
		dbus_attr = _tmp691_;
		_tmp693_ = dbus_attr;
		if (_tmp693_ == NULL) {
			_tmp692_ = TRUE;
		} else {
			ValaAttribute* _tmp694_;
			_tmp694_ = dbus_attr;
			_tmp692_ = vala_attribute_get_bool (_tmp694_, "visible", TRUE);
		}
		if (_tmp692_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp695_;
			ValaArrayList* _tmp696_;
			ValaArrayList* _tmp697_;
			gboolean _tmp715_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp695_ = g_direct_equal;
			_tmp696_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp695_);
			error_types = _tmp696_;
			_tmp697_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp697_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp698_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp699_;
				gint _tmp700_;
				gint _tmp701_;
				gint _error_type_index = 0;
				_tmp698_ = error_types;
				_error_type_list = _tmp698_;
				_tmp699_ = _error_type_list;
				_tmp700_ = vala_collection_get_size ((ValaCollection*) _tmp699_);
				_tmp701_ = _tmp700_;
				_error_type_size = _tmp701_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp702_;
					gint _tmp703_;
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp704_;
					gpointer _tmp705_;
					ValaDataType* _tmp706_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp707_;
					ValaErrorDomain* _tmp708_;
					ValaErrorDomain* _tmp709_;
					ValaErrorDomain* _tmp710_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp711_;
					gchar* _tmp712_;
					const gchar* _tmp713_;
					_error_type_index = _error_type_index + 1;
					_tmp702_ = _error_type_index;
					_tmp703_ = _error_type_size;
					if (!(_tmp702_ < _tmp703_)) {
						break;
					}
					_tmp704_ = _error_type_list;
					_tmp705_ = vala_list_get ((ValaList*) _tmp704_, _error_type_index);
					error_type = (ValaDataType*) _tmp705_;
					_tmp706_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp706_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp707_ = error_type;
					_tmp708_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp707_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp709_ = _tmp708_;
					error_domain = _tmp709_;
					_tmp710_ = error_domain;
					if (_tmp710_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp711_ = error_domain;
					_tmp712_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp711_);
					full_error_domain = _tmp712_;
					_tmp713_ = full_error_domain;
					if (g_strcmp0 (_tmp713_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp714_;
						_tmp714_ = full_error_domain;
						if (g_strcmp0 (_tmp714_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
			}
			if (!throws_gerror) {
				gboolean _tmp716_ = FALSE;
				if (throws_gioerror) {
					_tmp716_ = throws_gdbuserror;
				} else {
					_tmp716_ = FALSE;
				}
				_tmp715_ = !_tmp716_;
			} else {
				_tmp715_ = FALSE;
			}
			if (_tmp715_) {
				ValaSourceReference* _tmp717_;
				ValaSourceReference* _tmp718_;
				_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp718_ = _tmp717_;
				vala_report_warning (_tmp718_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp719_;
		ValaMethod* _tmp720_;
		gboolean _tmp727_;
		gboolean _tmp728_;
		gboolean _tmp731_;
		_tmp719_ = vala_code_context_get_entry_point (context);
		_tmp720_ = _tmp719_;
		if (_tmp720_ != NULL) {
			ValaSourceReference* _tmp721_;
			ValaSourceReference* _tmp722_;
			ValaMethod* _tmp723_;
			ValaMethod* _tmp724_;
			gchar* _tmp725_;
			gchar* _tmp726_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp721_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_code_context_get_entry_point (context);
			_tmp724_ = _tmp723_;
			_tmp725_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp724_);
			_tmp726_ = _tmp725_;
			vala_report_error (_tmp722_, "program already has an entry point `%s'", _tmp726_);
			_g_free0 (_tmp726_);
			result = FALSE;
			_vala_code_visitor_unref0 (traverse);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp727_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp728_ = _tmp727_;
		if (_tmp728_) {
			ValaSourceReference* _tmp729_;
			ValaSourceReference* _tmp730_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp729_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp730_ = _tmp729_;
			vala_report_error (_tmp730_, "\"main\" method cannot throw errors");
		}
		_tmp731_ = self->priv->_is_inline;
		if (_tmp731_) {
			ValaSourceReference* _tmp732_;
			ValaSourceReference* _tmp733_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp733_ = _tmp732_;
			vala_report_error (_tmp733_, "\"main\" method cannot be inline");
		}
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "GtkCallback")) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp734_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp735_ = _tmp734_;
	result = !_tmp735_;
	_vala_code_visitor_unref0 (traverse);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaParameter* _tmp9_;
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			gint _tmp15_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			_tmp9_ = param;
			_tmp10_ = vala_variable_get_initializer ((ValaVariable*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				_tmp8_ = TRUE;
			} else {
				ValaParameter* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = param;
				_tmp13_ = vala_parameter_get_ellipsis (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp15_ = n;
			n = _tmp15_ + 1;
			_vala_code_node_unref0 (param);
		}
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp35_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp34_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaMethod* _tmp20_;
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameter* _tmp23_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = vala_list_get (_tmp18_, _param_index);
				param = (ValaParameter*) _tmp19_;
				_tmp20_ = self->priv->end_method;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_copy (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_callable_add_parameter ((ValaCallable*) _tmp20_, _tmp23_);
				_vala_code_node_unref0 (_tmp23_);
				_vala_code_node_unref0 (param);
			}
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp24_;
			gint _param_size = 0;
			ValaList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _param_index = 0;
			_tmp24_ = vala_method_get_type_parameters (self);
			_param_list = _tmp24_;
			_tmp25_ = _param_list;
			_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_param_size = _tmp27_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValaMethod* _tmp32_;
				ValaTypeParameter* _tmp33_;
				_param_index = _param_index + 1;
				_tmp28_ = _param_index;
				_tmp29_ = _param_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _param_list;
				_tmp31_ = vala_list_get (_tmp30_, _param_index);
				param = (ValaTypeParameter*) _tmp31_;
				_tmp32_ = self->priv->end_method;
				_tmp33_ = param;
				vala_method_add_type_parameter (_tmp32_, _tmp33_);
				_vala_code_node_unref0 (param);
			}
		}
		_tmp34_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp34_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp35_ = self->priv->end_method;
	result = _tmp35_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp21_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaDataType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaSemanticAnalyzer* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaScope* _tmp18_;
		ValaScope* _tmp19_;
		ValaMethod* _tmp20_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_analyzer (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->bool_type;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp8_;
		_tmp9_ = bool_type;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
		_tmp10_ = bool_type;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new ("callback", _tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp13_;
		_tmp14_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp15_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp15_, TRUE);
		_tmp16_ = self->priv->callback_method;
		vala_method_set_binding (_tmp16_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp17_ = self->priv->callback_method;
		_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp19_ = _tmp18_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp17_, _tmp19_);
		_tmp20_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp20_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp21_ = self->priv->callback_method;
	result = _tmp21_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp31_;
	ValaScope* _tmp32_;
	ValaScope* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaDelegate* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaDelegateType* _tmp42_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaParameter* _tmp46_;
	ValaParameter* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaSourceReference* _tmp49_;
	ValaNullLiteral* _tmp50_;
	ValaNullLiteral* _tmp51_;
	ValaParameter* _tmp52_;
	ValaExpression* _tmp53_;
	ValaExpression* _tmp54_;
	ValaDelegateType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	ValaScope* _tmp60_;
	ValaScope* _tmp61_;
	ValaParameter* _tmp62_;
	ValaList* _tmp63_;
	ValaParameter* _tmp64_;
	ValaParameter* _tmp65_;
	ValaList* _tmp68_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->async_begin_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		_tmp2_ = self->priv->async_begin_parameters;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	_vala_iterable_unref0 (self->priv->async_begin_parameters);
	self->priv->async_begin_parameters = (ValaList*) _tmp4_;
	_tmp5_ = vala_code_context_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	_tmp12_ = _tmp11_;
	_vala_code_context_unref0 (_tmp6_);
	glib_ns = _tmp12_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp13_;
		gint _param_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _param_index = 0;
		_tmp13_ = self->priv->parameters;
		_param_list = _tmp13_;
		_tmp14_ = _param_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_param_size = _tmp16_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaParameter* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_param_index = _param_index + 1;
			_tmp17_ = _param_index;
			_tmp18_ = _param_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = vala_list_get (_tmp19_, _param_index);
			param = (ValaParameter*) _tmp20_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_ellipsis (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp24_ = param;
				_tmp25_ = _vala_code_node_ref0 (_tmp24_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp25_;
			} else {
				ValaParameter* _tmp26_;
				ValaParameterDirection _tmp27_;
				ValaParameterDirection _tmp28_;
				_tmp26_ = param;
				_tmp27_ = vala_parameter_get_direction (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaList* _tmp29_;
					ValaParameter* _tmp30_;
					_tmp29_ = self->priv->async_begin_parameters;
					_tmp30_ = param;
					vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
				}
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp31_ = glib_ns;
	_tmp32_ = vala_symbol_get_scope (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_scope_lookup (_tmp33_, "AsyncReadyCallback");
	_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_delegate_type_new (_tmp35_, _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_code_node_unref0 (_tmp35_);
	callback_type = _tmp39_;
	_tmp40_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp41_, TRUE);
	_tmp42_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp42_, TRUE);
	_tmp43_ = callback_type;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp43_, _tmp45_);
	callback_param = _tmp46_;
	_tmp47_ = callback_param;
	_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_null_literal_new (_tmp49_);
	_tmp51_ = _tmp50_;
	vala_variable_set_initializer ((ValaVariable*) _tmp47_, (ValaExpression*) _tmp51_);
	_vala_code_node_unref0 (_tmp51_);
	_tmp52_ = callback_param;
	_tmp53_ = vala_variable_get_initializer ((ValaVariable*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = callback_type;
	_tmp56_ = vala_data_type_copy ((ValaDataType*) _tmp55_);
	_tmp57_ = _tmp56_;
	vala_expression_set_target_type (_tmp54_, _tmp57_);
	_vala_code_node_unref0 (_tmp57_);
	_tmp58_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp58_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp59_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp59_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp60_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = callback_param;
	vala_scope_add (_tmp61_, NULL, (ValaSymbol*) _tmp62_);
	_tmp63_ = self->priv->async_begin_parameters;
	_tmp64_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp63_, _tmp64_);
	_tmp65_ = ellipsis;
	if (_tmp65_ != NULL) {
		ValaList* _tmp66_;
		ValaParameter* _tmp67_;
		_tmp66_ = self->priv->async_begin_parameters;
		_tmp67_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp66_, _tmp67_);
	}
	_tmp68_ = self->priv->async_begin_parameters;
	result = _tmp68_;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaObjectTypeSymbol* _tmp17_;
	ValaObjectType* _tmp18_;
	ValaObjectType* _tmp19_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaParameter* _tmp23_;
	ValaParameter* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	ValaParameter* _tmp27_;
	ValaList* _tmp28_;
	ValaParameter* _tmp29_;
	ValaList* _tmp43_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->async_end_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		_tmp2_ = self->priv->async_end_parameters;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
	_vala_iterable_unref0 (self->priv->async_end_parameters);
	self->priv->async_end_parameters = (ValaList*) _tmp4_;
	_tmp5_ = vala_code_context_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_scope_lookup (_tmp10_, "GLib");
	_tmp12_ = _tmp11_;
	_vala_code_context_unref0 (_tmp6_);
	glib_ns = _tmp12_;
	_tmp13_ = glib_ns;
	_tmp14_ = vala_symbol_get_scope (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_scope_lookup (_tmp15_, "AsyncResult");
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp18_ = vala_object_type_new (_tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_vala_code_node_unref0 (_tmp17_);
	result_type = _tmp19_;
	_tmp20_ = result_type;
	_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp20_, _tmp22_);
	result_param = _tmp23_;
	_tmp24_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp24_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = result_param;
	vala_scope_add (_tmp26_, NULL, (ValaSymbol*) _tmp27_);
	_tmp28_ = self->priv->async_end_parameters;
	_tmp29_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp28_, _tmp29_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp30_;
		gint _param_size = 0;
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _param_index = 0;
		_tmp30_ = self->priv->parameters;
		_param_list = _tmp30_;
		_tmp31_ = _param_list;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_param_size = _tmp33_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			ValaParameter* param = NULL;
			ValaList* _tmp36_;
			gpointer _tmp37_;
			ValaParameter* _tmp38_;
			ValaParameterDirection _tmp39_;
			ValaParameterDirection _tmp40_;
			_param_index = _param_index + 1;
			_tmp34_ = _param_index;
			_tmp35_ = _param_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _param_list;
			_tmp37_ = vala_list_get (_tmp36_, _param_index);
			param = (ValaParameter*) _tmp37_;
			_tmp38_ = param;
			_tmp39_ = vala_parameter_get_direction (_tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaList* _tmp41_;
				ValaParameter* _tmp42_;
				_tmp41_ = self->priv->async_end_parameters;
				_tmp42_ = param;
				vala_collection_add ((ValaCollection*) _tmp41_, _tmp42_);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp43_ = self->priv->async_end_parameters;
	result = _tmp43_;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			gint _local_size = 0;
			ValaList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_local_list = _tmp1_;
			_tmp2_ = _local_list;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_local_size = _tmp4_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				ValaLocalVariable* _tmp9_;
				_local_index = _local_index + 1;
				_tmp5_ = _local_index;
				_tmp6_ = _local_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _local_list;
				_tmp8_ = vala_list_get (_tmp7_, _local_index);
				local = (ValaLocalVariable*) _tmp8_;
				_tmp9_ = local;
				vala_collection_add (variables, _tmp9_);
				_vala_code_node_unref0 (local);
			}
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp4_;
	gboolean _tmp6_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_params_array_var;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		_tmp5_ = self->priv->_params_array_var;
		vala_collection_add (collection, (ValaVariable*) _tmp5_);
	}
	_tmp6_ = self->priv->_closure;
	if (_tmp6_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = (gboolean (*) (ValaSubroutine*)) vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->async_begin_parameters);
	_vala_iterable_unref0 (self->priv->async_end_parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__once = 0;
	if (g_once_init_enter (&vala_method_type_id__once)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__once, vala_method_type_id);
	}
	return vala_method_type_id__once;
}

