biblatex-unified
================

`biblatex-unified` is an opinionated biblatex implementation of the [Unified Stylesheet for Linguistics Journal](https://www.linguisticsociety.org/resource/unified-style-sheet). The stylesheet was developed by [CELxJ, the Committee of Editors of Linguistics Journals](https://www.linguisticsociety.org/about/who-we-are/committees/editors-linguistics-journals-celxj). 

The first implementation of the stylesheet for LaTeX was [`sp.bst`](https://raw.githubusercontent.com/semprag/tex/master/sp.cls), developed for the house-style of the journal [*Semantics and Pragmatics*](http://semprag.org) (*S&P*). Bridget Samuels produced a revised version `unified.bst`, which has largely disappeared from the internet.

The current project is a ground-up re-implementation of the unified stylesheet in modern biblatex. It has been used by *S&P* in production for several years.

Please [file an issue at github](https://github.com/semprag/biblatex-sp-unified/issues/new) to let us know of any problems you encounter and any recommendations for improvement.


## Sources

The `biblatex-unified` style consists of two files:

* [`unified.bbx`](unified.bbx) -- for formatting the bibliography.
* [`unified.cbx`](unified.cbx) -- for formatting in-text citations in the style of *S&P*.
  - Since the Unified Stylesheet does not give any guidelines for in-text citations, this file is optional and users can choose other citation styles, such as the `authoryear-comp` citation style that comes with biblatex.


## Requirements and backward compatibility

Compiling LaTeX documents with this style depends on a fairly recent TeX installation that includes biblatex 2.0+. It is tested only with the `biber` backend. TexLive 2019 or later would be ideal.


## Installation

Manual installation involves putting the two files `unified.bbx` and `unified.cbx` somewhere where your TeX system can find them. This could be local in the same directory as your tex source file, or in your `TEXMF` "home" directory, or in the system `TEXMF` directories. 


## Configuring your `.tex` document to use the style

To use the style in conjunction with *S&P*'s [`sp.cls`](https://raw.githubusercontent.com/semprag/tex/master/sp.cls),
simply add the `biblatex` class option when importing `sp.cls`:

```latex
    \documentclass[biblatex]{sp}
```

If you are not using the *S&P* document class, you can still use this style by adding the following to your preamble (after `\documentclass{...}` but before `\begin{document}`):

```latex
    \usepackage[backend=biber,
                style=unified,
                maxcitenames=3,
                maxbibnames=99]{biblatex}
```

If you were previously using `natbib`, remove `\usepackage{natbib}` and any accompanying `\bibliographystyle{...}` and `\bibpunct{...}` settings.
You might also find it helpful to add `natbib` to the list of options (`\usepackage[..., natbib]{biblatex}`), to load biblatex's `natbib` compatibility module, which implements common `natbib` commands like `\citet`, `\citep`, `\citealt`, `\citealp`, etc.

Whether you're using `sp.cls` or a different document class, you'll need to change the usual BibTeX commands to biblatex, in two places:

1. Replace the `\bibliography{your-bibfile}` line in the backmatter with `\printbibliography`.
2. Add the following command to your preamble:  
   `\addbibresource{your-bibfile.bib}`
   - NB: the `.bib` extension must be included (unlike BibTeX)

## Documentation

The full documentation and implementation notes can be found in [`biblatex-unified.pdf`](biblatex-unified.pdf). The PDF can be regenerated by typesetting the `tex` source file with `xelatex`. The `tex` is actually itself generated from the underlying `md` markdown file via `pandoc` with the following incantation:

```zsh
pandoc -f markdown -t latex biblatex-unified.md -s\ 
-o biblatex-unified.tex --highlight-style=kate
```

## License and copyright

Copyright ©2020 Kai von Fintel. 

This package is author-maintained. Permission is granted to copy, distribute
and/or modify this software under the terms of the LaTeX Project Public License,
version 1.3c. 

This software is provided “as is,” without warranty of any kind, either
expressed or implied, including, but not limited to, the implied warranties of
merchantability and fitness for a particular purpose.
