# (open)SUSE installation images

Scripts and tools to generate the disk images used during installation
(inst-sys) and the rescue disk images for openSUSE and SUSE.

## Generating the images locally

To build a new image, you have to:

* be root
* put the installation-images directory on a *local* file system (ie. not NFS)
* have a valid .oscrc

Then you must run ```make``` once to build all parts.

The images will be stored in the 'image' directory, the contents of the images
will be in the 'tmp' directory.

```make install``` will gather the images and put them into the 'instsys' dir.

For testing purposes there is a make target 'cd1' that builds a complete
tree as it's used on our media.

`make iso` will directly create the .iso file for CD1 (`images/cd1.iso` file)

## Configuring the generation of images

The exact behavior of ```make``` can be influenced by several environment
variables. For a full description of these variables and how they affect each
image, check the [configoptions.md](configoptions.md) file.

## Setting the default network repository

The default network repository location is product dependent and defined in
[obs/installation-images.spec](../obs/installation-images.spec) in the `net_repo`
macro.

## Committing changes to (open)SUSE

Basically every new commit into the master branch of the repository will be auto-submitted
to all current SUSE products. No further action is needed except accepting the pull request.

For details see [here](submitting.md).

## Anatomy of the images

After a successful execution of ```make``` the directory ```images/``` will
contain several subdirectories and files. Follows a short description of the images:

* ```images/base``` is the build environment used for the other images.
* ```images/boot``` is the image that contains the bootloader.
* ```images/cd1.iso``` is a media used for testing purposes only; can be optionally
    generated by the `make iso` command.
* ```images/initrd``` contains all the files used at the initrd stage ([check out our initrd implementation](https://github.com/openSUSE/linuxrc)).
* ```images/rescue``` contains the data for the rescue system.
* ```images/root``` is mounted to provide the necessary files for YaST installation.
* ```images/gdb``` is an extension containing the GNU GDB debugger (use the `extend gdb`
    command to activate it in the inst-sys).
* ```images/libyui-rest-api``` is an extension containing the [LibYUI REST API](
    https://github.com/libyui/libyui-rest-api) packages (use the `extend libyui-rest-api`
    command to activate it in the inst-sys).


## FAQ

* How to make sure a driver is available in the installation/rescue system?
  Check the [modules.md](modules.md) file.

* How to add a package or one of its file to the image?
  Check the [files.md](files.md) file.

* How the branding works?
  Check the [branding.md](branding.md) file

## Troubleshooting and Hacks

* How to remove a specific file from the initrd image?

  If you can rebuild the image, the recommended way is to exclude the file from the package that contains it. To do so, you need to modify the .file_list of the image (see [files.md](files.md) ).

  If you're looking for a quick hack with `mksusecd` please keep in mind that symlinks won't work; instead you'll need to overwrite the files with other, real files (even empty) thanks to the --initrd flag.

* After building an image from the master branch and installing it I get an error regarding "Wrong media".

  This is because for some reason, your images have mismatching build IDs. To check a build id, you want to look at the content of the .config files. ` find . -name "*.config"` will show a few of them, in general you'll be interested in .instsys.config and linuxrc.config.

* What happens if a package is included in two subsequent stages (e.g. initrd, root)?

  Installation-images is smart enough to recognise this duplication and eliminate it. Please do not abuse of this feature because the .file_list files serve as a list of files included in the image (read: documentation) so polluting the files might cause confusion.

* What is the control.xml used for?

  This is a very important file! It gives YaST the instructions on how to (the sequence of steps) used to install a system.

* How do I mount the built images?

  The images are compressed using the squashfs file system, but you can normally
  mount them with the `mount` command.

**TODO FAQ: compression algorithm, linemode, fonts**
