// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ssm"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// GetExecutionPreview
// This example illustrates one usage of GetExecutionPreview
func ExampleSSM_GetExecutionPreview_shared00() {
	svc := ssm.New(session.New())
	input := &ssm.GetExecutionPreviewInput{
		ExecutionPreviewId: aws.String("2f27d6e5-9676-4708-b8bd-aef0ab47bb26"),
	}

	result, err := svc.GetExecutionPreview(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssm.ErrCodeInternalServerError:
				fmt.Println(ssm.ErrCodeInternalServerError, aerr.Error())
			case ssm.ErrCodeResourceNotFoundException:
				fmt.Println(ssm.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListNodes
// This example illustrates one usage of ListNodes
func ExampleSSM_ListNodes_shared00() {
	svc := ssm.New(session.New())
	input := &ssm.ListNodesInput{
		Filters: []*ssm.NodeFilter{
			{
				Key:  aws.String("Region"),
				Type: aws.String("Equal"),
				Values: []*string{
					aws.String("us-east-2"),
				},
			},
		},
		MaxResults: aws.Int64(1),
		SyncName:   aws.String("AWS-QuickSetup-ManagedNode"),
	}

	result, err := svc.ListNodes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssm.ErrCodeInternalServerError:
				fmt.Println(ssm.ErrCodeInternalServerError, aerr.Error())
			case ssm.ErrCodeInvalidFilter:
				fmt.Println(ssm.ErrCodeInvalidFilter, aerr.Error())
			case ssm.ErrCodeInvalidNextToken:
				fmt.Println(ssm.ErrCodeInvalidNextToken, aerr.Error())
			case ssm.ErrCodeResourceDataSyncNotFoundException:
				fmt.Println(ssm.ErrCodeResourceDataSyncNotFoundException, aerr.Error())
			case ssm.ErrCodeUnsupportedOperationException:
				fmt.Println(ssm.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// ListNodesSummary
// This example illustrates one usage of ListNodesSummary
func ExampleSSM_ListNodesSummary_shared00() {
	svc := ssm.New(session.New())
	input := &ssm.ListNodesSummaryInput{
		Aggregators: []*ssm.NodeAggregator{
			{
				AggregatorType: aws.String("Count"),
				AttributeName:  aws.String("Region"),
				TypeName:       aws.String("Instance"),
			},
		},
		Filters: []*ssm.NodeFilter{
			{
				Key:  aws.String("InstanceStatus"),
				Type: aws.String("Equal"),
				Values: []*string{
					aws.String("Active"),
				},
			},
		},
		MaxResults: aws.Int64(2),
		NextToken:  aws.String("A9lT8CAxj9aDFRi+MNAoFq08I---EXAMPLE"),
		SyncName:   aws.String("AWS-QuickSetup-ManagedNode"),
	}

	result, err := svc.ListNodesSummary(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssm.ErrCodeInternalServerError:
				fmt.Println(ssm.ErrCodeInternalServerError, aerr.Error())
			case ssm.ErrCodeInvalidAggregatorException:
				fmt.Println(ssm.ErrCodeInvalidAggregatorException, aerr.Error())
			case ssm.ErrCodeInvalidFilter:
				fmt.Println(ssm.ErrCodeInvalidFilter, aerr.Error())
			case ssm.ErrCodeInvalidNextToken:
				fmt.Println(ssm.ErrCodeInvalidNextToken, aerr.Error())
			case ssm.ErrCodeResourceDataSyncNotFoundException:
				fmt.Println(ssm.ErrCodeResourceDataSyncNotFoundException, aerr.Error())
			case ssm.ErrCodeUnsupportedOperationException:
				fmt.Println(ssm.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// StartExecutionPreview
// This example illustrates one usage of StartExecutionPreview
func ExampleSSM_StartExecutionPreview_shared00() {
	svc := ssm.New(session.New())
	input := &ssm.StartExecutionPreviewInput{
		DocumentName: aws.String("AWS-StartEC2Instance"),
	}

	result, err := svc.StartExecutionPreview(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssm.ErrCodeInternalServerError:
				fmt.Println(ssm.ErrCodeInternalServerError, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
