/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream;

import com.sun.xml.stream.Entity;
import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.StaxErrorReporter;
import com.sun.xml.stream.XMLDTDScannerImpl;
import com.sun.xml.stream.XMLEntityManager;
import com.sun.xml.stream.XMLEntityReaderImpl;
import com.sun.xml.stream.XMLEntityStorage;
import com.sun.xml.stream.XMLNSDocumentScannerImpl;
import com.sun.xml.stream.dtd.nonvalidating.DTDGrammar;
import com.sun.xml.stream.dtd.nonvalidating.XMLNotationDecl;
import com.sun.xml.stream.events.EntityDeclarationImpl;
import com.sun.xml.stream.events.NotationDeclarationImpl;
import com.sun.xml.stream.xerces.util.NamespaceContextWrapper;
import com.sun.xml.stream.xerces.util.SymbolTable;
import com.sun.xml.stream.xerces.util.XMLChar;
import com.sun.xml.stream.xerces.util.XMLStringBuffer;
import com.sun.xml.stream.xerces.xni.QName;
import com.sun.xml.stream.xerces.xni.XNIException;
import com.sun.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLReaderImpl
implements XMLStreamReader {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String READER_IN_DEFINED_STATE = "http://java.sun.com/xml/stream/properties/reader-in-defined-state";
    private SymbolTable fSymbolTable = new SymbolTable();
    protected XMLNSDocumentScannerImpl fScanner = new XMLNSDocumentScannerImpl();
    protected NamespaceContextWrapper fNamespaceContextWrapper = new NamespaceContextWrapper(this.fScanner.getNamespaceContext());
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected StaxErrorReporter fErrorReporter = new StaxErrorReporter();
    protected XMLEntityReaderImpl fEntityScanner = null;
    protected XMLInputSource fInputSource = null;
    protected PropertyManager fPropertyManager = null;
    private int fEventType;
    static final boolean DEBUG = false;
    private boolean fReuse = true;
    private boolean fReaderInDefinedState = true;
    private boolean fBindNamespaces = true;
    private String fDTDDecl = null;

    public int getAttributeCount() {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLength();
        }
        throw new IllegalStateException();
    }

    public int getColumnNumber() {
        return this.fEntityScanner.getColumnNumber();
    }

    public int getEventType() {
        return this.fEventType;
    }

    public int getLineNumber() {
        return this.fEntityScanner.getLineNumber();
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getDeclaredPrefixCount();
        }
        throw new IllegalStateException("Current event state is " + this.fEventType);
    }

    public int getTextLength() {
        return this.fScanner.getCharacterData().length;
    }

    public int getTextStart() {
        return this.fScanner.getCharacterData().offset;
    }

    public int next() throws XMLStreamException {
        try {
            this.fEventType = this.fScanner.next();
            return this.fEventType;
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException.getMessage(), this.getLocation(), iOException);
        }
        catch (XNIException xNIException) {
            throw new XMLStreamException(xNIException.getMessage(), this.getLocation(), xNIException.getException());
        }
    }

    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return n;
    }

    public void close() throws XMLStreamException {
        this.fReuse = true;
    }

    public void reset() {
        this.fReuse = true;
        this.fEventType = 0;
        this.fEntityManager.reset(this.fPropertyManager);
        this.fScanner.reset(this.fPropertyManager);
        this.fDTDDecl = null;
        this.fEntityScanner = (XMLEntityReaderImpl)this.fEntityManager.getEntityReader();
        this.fReaderInDefinedState = (Boolean)this.fPropertyManager.getProperty(READER_IN_DEFINED_STATE);
        this.fBindNamespaces = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isNamespaceAware");
    }

    public boolean canReuse() {
        return this.fReuse || this.fEventType == 8;
    }

    public boolean hasAttributes() {
        return this.fScanner.getAttributeIterator().getLength() > 0;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8;
    }

    public boolean hasText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12) {
            return this.fScanner.getCharacterData().length > 0;
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return true;
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
                Entity entity = (Entity)hashtable.get(string);
                if (entity == null) {
                    return false;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId() != null;
                }
                return ((Entity.InternalEntity)entity).text != null;
            }
            return false;
        }
        if (this.fEventType == 11) {
            return this.fScanner.fSeenDoctypeDecl;
        }
        return false;
    }

    public boolean hasValue() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3 || this.fEventType == 5 || this.fEventType == 4;
    }

    public boolean isCharacters() {
        return this.fEventType == 4;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isStandalone() {
        return this.fScanner.isStandAlone();
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (this.isCharacters() || this.fEventType == 12) {
            char[] cArray = this.getTextCharacters();
            int n = this.getTextStart();
            int n2 = this.getTextLength();
            int n3 = n;
            while (n3 < n2) {
                if (!XMLChar.isSpace(cArray[n3])) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    public boolean standaloneSet() {
        return this.fScanner.isStandAlone();
    }

    public char[] getTextCharacters() {
        return this.fScanner.getCharacterData().ch;
    }

    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().isSpecified(n);
        }
        throw new IllegalStateException("Current state should have been 1 or \n10 but State found is = " + this.fEventType);
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (cArray == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = this.getTextLength() - n;
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        n4 = n5 < n3 ? n5 : n3;
        System.arraycopy(this.getTextCharacters(), this.getTextStart() + n, cArray, n2, n4);
        return n4;
    }

    protected PropertyManager getPropertyManager() {
        return this.fPropertyManager;
    }

    void init(PropertyManager propertyManager) throws XMLStreamException {
        this.fPropertyManager = propertyManager;
        propertyManager.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        propertyManager.setProperty(ERROR_REPORTER, this.fErrorReporter);
        propertyManager.setProperty(ENTITY_MANAGER, this.fEntityManager);
        this.reset();
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
        this.fScanner.setProperty("stax-properties", propertyManager);
        this.fScanner.setPropertyManager(propertyManager);
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws XMLStreamException {
        this.fReuse = false;
        try {
            this.fScanner.setInputSource(xMLInputSource);
            if (this.fReaderInDefinedState) {
                this.fEventType = this.fScanner.next();
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public String getCharacterEncodingScheme() {
        return this.fScanner.getCharacterEncodingScheme();
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int n = this.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (n == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + n, this.getLocation());
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    public String getEncoding() {
        return this.fEntityScanner.getEncoding();
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        if (this.fEventType == 9) {
            return this.fScanner.getEntityName();
        }
        return null;
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().uri;
        }
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        throw new IllegalStateException("Current state of the parser is " + this.fEventType + " But Expected state is " + 3);
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        throw new IllegalStateException("Current state of the parser is " + this.fEventType + " But Expected state is " + 3);
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().prefix;
        }
        return null;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().toString();
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return this.fScanner.getCharacterData().toString();
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
                Entity entity = (Entity)hashtable.get(string);
                if (entity == null) {
                    return null;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId();
                }
                return ((Entity.InternalEntity)entity).text;
            }
            return null;
        }
        if (this.fEventType == 11) {
            if (this.fDTDDecl != null) {
                return this.fDTDDecl;
            }
            XMLStringBuffer xMLStringBuffer = this.fScanner.getDTDDecl();
            this.fDTDDecl = xMLStringBuffer.toString();
            return this.fDTDDecl;
        }
        throw new IllegalStateException("Current state = " + this.fEventType + " is not among the states required for getText() ");
    }

    public String getValue() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        if (this.fEventType == 5) {
            return this.fScanner.getComment();
        }
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 4) {
            return this.fScanner.getCharacterData().toString();
        }
        return null;
    }

    public String getVersion() {
        return this.fEntityScanner.getVersion();
    }

    public String getAttributeLocalName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLocalName(n);
        }
        throw new IllegalStateException();
    }

    public String getAttributeNamespace(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getURI(n);
        }
        throw new IllegalStateException();
    }

    public String getAttributePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getPrefix(n);
        }
        throw new IllegalStateException();
    }

    public String getAttributeType(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getType(n);
        }
        throw new IllegalStateException();
    }

    public String getAttributeValue(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(n);
        }
        throw new IllegalStateException();
    }

    static final String getEventTypeString(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
        }
        return "UNKNOWN_EVENT_TYPE";
    }

    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            String string = this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n);
            return string.equals("") ? null : string;
        }
        throw new IllegalStateException("Current event state is " + this.fEventType);
    }

    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getURI(this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n));
        }
        throw new IllegalStateException("Current event state is " + this.fEventType);
    }

    static void pr(String string) {
        System.out.println(string);
    }

    protected List getEntityDecls() {
        if (this.fEventType == 11) {
            XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
            Hashtable hashtable = xMLEntityStorage.getDeclaredEntities();
            ArrayList<EntityDeclarationImpl> arrayList = null;
            if (hashtable != null) {
                EntityDeclarationImpl entityDeclarationImpl = null;
                arrayList = new ArrayList<EntityDeclarationImpl>(hashtable.size());
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Entity entity = (Entity)hashtable.get(string);
                    entityDeclarationImpl = new EntityDeclarationImpl();
                    entityDeclarationImpl.setEntityName(string);
                    if (entity.isExternal()) {
                        entityDeclarationImpl.setXMLResourceIdentifier(((Entity.ExternalEntity)entity).entityLocation);
                        entityDeclarationImpl.setNotationName(((Entity.ExternalEntity)entity).notation);
                    } else {
                        entityDeclarationImpl.setEntityReplacementText(((Entity.InternalEntity)entity).text);
                    }
                    arrayList.add(entityDeclarationImpl);
                }
            }
            return arrayList;
        }
        return null;
    }

    protected List getNotationDecls() {
        if (this.fEventType == 11) {
            if (this.fScanner.fDTDScanner == null) {
                return null;
            }
            DTDGrammar dTDGrammar = ((XMLDTDScannerImpl)this.fScanner.fDTDScanner).getGrammar();
            if (dTDGrammar == null) {
                return null;
            }
            List list = dTDGrammar.getNotationDecls();
            Iterator iterator = list.iterator();
            ArrayList<NotationDeclarationImpl> arrayList = new ArrayList<NotationDeclarationImpl>();
            while (iterator.hasNext()) {
                XMLNotationDecl xMLNotationDecl = (XMLNotationDecl)iterator.next();
                if (xMLNotationDecl == null) continue;
                arrayList.add(new NotationDeclarationImpl(xMLNotationDecl));
            }
            return arrayList;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContextWrapper;
    }

    public javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getElementQName());
        }
        throw new IllegalArgumentException("Illegal to call getName() when event type is " + this.fEventType);
    }

    public javax.xml.namespace.QName getAttributeName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getAttributeIterator().getQualifiedName(n));
        }
        throw new IllegalStateException();
    }

    public javax.xml.namespace.QName getAttributeQName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            String string = this.fScanner.getAttributeIterator().getLocalName(n);
            String string2 = this.fScanner.getAttributeIterator().getURI(n);
            return new javax.xml.namespace.QName(string2, string);
        }
        throw new IllegalStateException();
    }

    public Location getLocation() {
        return new Location(){

            public int getCharacterOffset() {
                return XMLReaderImpl.this.fEntityScanner.getCharacterOffset();
            }

            public int getColumnNumber() {
                return XMLReaderImpl.this.fEntityScanner.getColumnNumber();
            }

            public int getLineNumber() {
                return XMLReaderImpl.this.fEntityScanner.getLineNumber();
            }

            public String getLocationURI() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public String getPublicId() {
                return XMLReaderImpl.this.fEntityScanner.getPublicId();
            }

            public String getSystemId() {
                return XMLReaderImpl.this.fEntityScanner.getExpandedSystemId();
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Line number = " + this.getLineNumber());
                stringBuffer.append("\n");
                stringBuffer.append("Column number = " + this.getColumnNumber());
                stringBuffer.append("\n");
                stringBuffer.append("System Id = " + this.getSystemId());
                stringBuffer.append("\n");
                stringBuffer.append("Public Id = " + this.getPublicId());
                stringBuffer.append("\n");
                stringBuffer.append("Location Uri= " + this.getLocationURI());
                stringBuffer.append("\n");
                stringBuffer.append("CharacterOffset = " + this.getCharacterOffset());
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
        };
    }

    public XMLReaderImpl(XMLInputSource xMLInputSource, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(InputStream inputStream, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, inputStream, null);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(Reader reader, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedReader(reader), null);
        this.setInputSource(xMLInputSource);
    }

    public XMLReaderImpl(String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        this.setInputSource(xMLInputSource);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPropertyManager != null) {
            if (string.equals("javax.xml.stream.notations")) {
                return this.getNotationDecls();
            }
            if (string.equals("javax.xml.stream.entities")) {
                return this.getEntityDecls();
            }
            return this.fPropertyManager.getProperty(string);
        }
        return null;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this.fEventType) {
            throw new XMLStreamException("Event type " + XMLReaderImpl.getEventTypeString(n) + " specified did not match with current parser event");
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Namespace URI " + string + " specified did not match with current namespace URI");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("LocalName " + string2 + " specified did not match with current local name");
        }
    }

    public String getNamespaceURI(String string) {
        return this.fScanner.getNamespaceContext().getURI(this.fSymbolTable.addSymbol(string));
    }

    public javax.xml.namespace.QName convertXNIQNametoJavaxQName(QName qName) {
        if (qName.prefix == null) {
            return new javax.xml.namespace.QName(qName.uri, qName.localpart);
        }
        return new javax.xml.namespace.QName(qName.uri, qName.localpart, qName.prefix);
    }

    public XMLReaderImpl(InputStream inputStream, String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedInputStream(inputStream), string);
        this.setInputSource(xMLInputSource);
    }

    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(string, string2);
        }
        throw new IllegalStateException();
    }
}

