/* automatically generated by rust-bindgen 0.65.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE, off_t};

use crate::api::*;


pub mod s2n_fingerprint_type {
    #[doc = " @file fingerprint.h\n\n The following APIs enable applications to calculate fingerprints to\n identify ClientHellos.\n\n The fingerprinting APIs are currently considered unstable. They will be finalized\n and marked as stable after an initial customer integration and feedback."]
    pub type Type = ::libc::c_uint;
    pub const FINGERPRINT_JA3: Type = 0;
}
extern "C" {
    #[doc = " Calculates a fingerprint hash for a given ClientHello.\n\n Currently the only type supported is S2N_FINGERPRINT_JA3, which uses MD5 and\n requires at least 16 bytes of memory.\n\n @param ch The ClientHello to fingerprint.\n @param type The algorithm to use for the fingerprint. Currently only JA3 is supported.\n @param max_hash_size The maximum size of data that may be written to `hash`.\n If too small for the requested hash, an S2N_ERR_T_USAGE error will occur.\n @param hash The location that the requested hash will be written to.\n @param hash_size The actual size of the data written to `hash`.\n @param str_size The actual size of the full string associated with this hash.\n This size can be used to ensure that sufficient memory is provided for the\n output of `s2n_client_hello_get_fingerprint_string`.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_client_hello_get_fingerprint_hash(
        ch: *mut s2n_client_hello,
        type_: s2n_fingerprint_type::Type,
        max_hash_size: u32,
        hash: *mut u8,
        hash_size: *mut u32,
        str_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Calculates a full, variable-length fingerprint string for a given ClientHello.\n\n Because the length of the string is variable and unknown until the string is\n calculated, `s2n_client_hello_get_fingerprint_hash` can be called first to\n determine `max_size` and ensure `output` is sufficiently large.\n\n @param ch The ClientHello to fingerprint.\n @param type The algorithm to use for the fingerprint. Currently only JA3 is supported.\n @param max_size The maximum size of data that may be written to `output`.\n If too small for the requested string, an S2N_ERR_T_USAGE error will occur.\n @param output The location that the requested string will be written to.\n @param output_size The actual size of the data written to `output`.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_client_hello_get_fingerprint_string(
        ch: *mut s2n_client_hello,
        type_: s2n_fingerprint_type::Type,
        max_size: u32,
        output: *mut u8,
        output_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Creates an s2n_client_hello from bytes representing a ClientHello message.\n\n Unlike s2n_connection_get_client_hello, the s2n_client_hello returned by this\n method is owned by the application and must be freed with s2n_client_hello_free.\n\n This method does not support SSLv2 ClientHellos.\n\n @param bytes The raw bytes representing the ClientHello.\n @param size The size of raw_message.\n @returns A new s2n_client_hello on success, or NULL on failure."]
    pub fn s2n_client_hello_parse_message(bytes: *const u8, size: u32) -> *mut s2n_client_hello;
}
extern "C" {
    #[doc = " Frees an s2n_client_hello structure.\n\n This method should be called to free s2n_client_hellos returned by\n s2n_client_hello_parse_message. It will error if passed an s2n_client_hello\n returned by s2n_connection_get_client_hello and owned by the connection.\n\n @param ch The structure to be freed.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_client_hello_free(ch: *mut *mut s2n_client_hello) -> ::libc::c_int;
}
