; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=knl -mattr=+avx512bw -mattr=+avx512vl --show-mc-encoding| FileCheck %s

define <32 x i8> @test_256_1(ptr %addr) {
; CHECK-LABEL: test_256_1:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups (%rdi), %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfc,0x10,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %res = load <32 x i8>, ptr %addr, align 1
  ret <32 x i8>%res
}

define void @test_256_2(ptr %addr, <32 x i8> %data) {
; CHECK-LABEL: test_256_2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups %ymm0, (%rdi) ## EVEX TO VEX Compression encoding: [0xc5,0xfc,0x11,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  store <32 x i8>%data, ptr %addr, align 1
  ret void
}

define <32 x i8> @test_256_3(ptr %addr, <32 x i8> %old, <32 x i8> %mask1) {
; CHECK-LABEL: test_256_3:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmb %ymm1, %ymm1, %k1 ## encoding: [0x62,0xf2,0x75,0x28,0x26,0xc9]
; CHECK-NEXT:    vmovdqu8 (%rdi), %ymm0 {%k1} ## encoding: [0x62,0xf1,0x7f,0x29,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <32 x i8> %mask1, zeroinitializer
  %r = load <32 x i8>, ptr %addr, align 1
  %res = select <32 x i1> %mask, <32 x i8> %r, <32 x i8> %old
  ret <32 x i8>%res
}

define <32 x i8> @test_256_4(ptr %addr, <32 x i8> %mask1) {
; CHECK-LABEL: test_256_4:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmb %ymm0, %ymm0, %k1 ## encoding: [0x62,0xf2,0x7d,0x28,0x26,0xc8]
; CHECK-NEXT:    vmovdqu8 (%rdi), %ymm0 {%k1} {z} ## encoding: [0x62,0xf1,0x7f,0xa9,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <32 x i8> %mask1, zeroinitializer
  %r = load <32 x i8>, ptr %addr, align 1
  %res = select <32 x i1> %mask, <32 x i8> %r, <32 x i8> zeroinitializer
  ret <32 x i8>%res
}

define <16 x i16> @test_256_5(ptr %addr) {
; CHECK-LABEL: test_256_5:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups (%rdi), %ymm0 ## EVEX TO VEX Compression encoding: [0xc5,0xfc,0x10,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %res = load <16 x i16>, ptr %addr, align 1
  ret <16 x i16>%res
}

define void @test_256_6(ptr %addr, <16 x i16> %data) {
; CHECK-LABEL: test_256_6:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups %ymm0, (%rdi) ## EVEX TO VEX Compression encoding: [0xc5,0xfc,0x11,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  store <16 x i16>%data, ptr %addr, align 1
  ret void
}

define <16 x i16> @test_256_7(ptr %addr, <16 x i16> %old, <16 x i16> %mask1) {
; CHECK-LABEL: test_256_7:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmw %ymm1, %ymm1, %k1 ## encoding: [0x62,0xf2,0xf5,0x28,0x26,0xc9]
; CHECK-NEXT:    vmovdqu16 (%rdi), %ymm0 {%k1} ## encoding: [0x62,0xf1,0xff,0x29,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <16 x i16> %mask1, zeroinitializer
  %r = load <16 x i16>, ptr %addr, align 1
  %res = select <16 x i1> %mask, <16 x i16> %r, <16 x i16> %old
  ret <16 x i16>%res
}

define <16 x i16> @test_256_8(ptr %addr, <16 x i16> %mask1) {
; CHECK-LABEL: test_256_8:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmw %ymm0, %ymm0, %k1 ## encoding: [0x62,0xf2,0xfd,0x28,0x26,0xc8]
; CHECK-NEXT:    vmovdqu16 (%rdi), %ymm0 {%k1} {z} ## encoding: [0x62,0xf1,0xff,0xa9,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <16 x i16> %mask1, zeroinitializer
  %r = load <16 x i16>, ptr %addr, align 1
  %res = select <16 x i1> %mask, <16 x i16> %r, <16 x i16> zeroinitializer
  ret <16 x i16>%res
}

define <16 x i8> @test_128_1(ptr %addr) {
; CHECK-LABEL: test_128_1:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups (%rdi), %xmm0 ## EVEX TO VEX Compression encoding: [0xc5,0xf8,0x10,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %res = load <16 x i8>, ptr %addr, align 1
  ret <16 x i8>%res
}

define void @test_128_2(ptr %addr, <16 x i8> %data) {
; CHECK-LABEL: test_128_2:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups %xmm0, (%rdi) ## EVEX TO VEX Compression encoding: [0xc5,0xf8,0x11,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  store <16 x i8>%data, ptr %addr, align 1
  ret void
}

define <16 x i8> @test_128_3(ptr %addr, <16 x i8> %old, <16 x i8> %mask1) {
; CHECK-LABEL: test_128_3:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmb %xmm1, %xmm1, %k1 ## encoding: [0x62,0xf2,0x75,0x08,0x26,0xc9]
; CHECK-NEXT:    vmovdqu8 (%rdi), %xmm0 {%k1} ## encoding: [0x62,0xf1,0x7f,0x09,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <16 x i8> %mask1, zeroinitializer
  %r = load <16 x i8>, ptr %addr, align 1
  %res = select <16 x i1> %mask, <16 x i8> %r, <16 x i8> %old
  ret <16 x i8>%res
}

define <16 x i8> @test_128_4(ptr %addr, <16 x i8> %mask1) {
; CHECK-LABEL: test_128_4:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmb %xmm0, %xmm0, %k1 ## encoding: [0x62,0xf2,0x7d,0x08,0x26,0xc8]
; CHECK-NEXT:    vmovdqu8 (%rdi), %xmm0 {%k1} {z} ## encoding: [0x62,0xf1,0x7f,0x89,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <16 x i8> %mask1, zeroinitializer
  %r = load <16 x i8>, ptr %addr, align 1
  %res = select <16 x i1> %mask, <16 x i8> %r, <16 x i8> zeroinitializer
  ret <16 x i8>%res
}

define <8 x i16> @test_128_5(ptr %addr) {
; CHECK-LABEL: test_128_5:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups (%rdi), %xmm0 ## EVEX TO VEX Compression encoding: [0xc5,0xf8,0x10,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %res = load <8 x i16>, ptr %addr, align 1
  ret <8 x i16>%res
}

define void @test_128_6(ptr %addr, <8 x i16> %data) {
; CHECK-LABEL: test_128_6:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vmovups %xmm0, (%rdi) ## EVEX TO VEX Compression encoding: [0xc5,0xf8,0x11,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  store <8 x i16>%data, ptr %addr, align 1
  ret void
}

define <8 x i16> @test_128_7(ptr %addr, <8 x i16> %old, <8 x i16> %mask1) {
; CHECK-LABEL: test_128_7:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmw %xmm1, %xmm1, %k1 ## encoding: [0x62,0xf2,0xf5,0x08,0x26,0xc9]
; CHECK-NEXT:    vmovdqu16 (%rdi), %xmm0 {%k1} ## encoding: [0x62,0xf1,0xff,0x09,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <8 x i16> %mask1, zeroinitializer
  %r = load <8 x i16>, ptr %addr, align 1
  %res = select <8 x i1> %mask, <8 x i16> %r, <8 x i16> %old
  ret <8 x i16>%res
}

define <8 x i16> @test_128_8(ptr %addr, <8 x i16> %mask1) {
; CHECK-LABEL: test_128_8:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    vptestmw %xmm0, %xmm0, %k1 ## encoding: [0x62,0xf2,0xfd,0x08,0x26,0xc8]
; CHECK-NEXT:    vmovdqu16 (%rdi), %xmm0 {%k1} {z} ## encoding: [0x62,0xf1,0xff,0x89,0x6f,0x07]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %mask = icmp ne <8 x i16> %mask1, zeroinitializer
  %r = load <8 x i16>, ptr %addr, align 1
  %res = select <8 x i1> %mask, <8 x i16> %r, <8 x i16> zeroinitializer
  ret <8 x i16>%res
}

