/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Lifecycle;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.Type;

public final class CacheEntry
implements Serializable {
    Object[] state;
    Class subclass;

    public Class getSubclass() {
        return this.subclass;
    }

    public CacheEntry(Object object, ClassPersister persister, SessionImplementor session) throws HibernateException {
        this.state = this.disassemble(object, persister, session);
        this.subclass = object.getClass();
    }

    private Object[] disassemble(Object object, ClassPersister persister, SessionImplementor session) throws HibernateException {
        Object[] values = persister.getPropertyValues(object);
        Type[] propertyTypes = persister.getPropertyTypes();
        int i = 0;
        while (i < values.length) {
            values[i] = propertyTypes[i].disassemble(values[i], session);
            ++i;
        }
        return values;
    }

    public Object[] assemble(Object instance, Serializable id, ClassPersister persister, SessionImplementor session) throws HibernateException {
        if (this.subclass != persister.getMappedClass()) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return this.assemble(this.state, instance, id, persister, session);
    }

    private Object[] assemble(Object[] values, Object result, Serializable id, ClassPersister persister, SessionImplementor session) throws HibernateException {
        Type[] propertyTypes = persister.getPropertyTypes();
        Object[] assembledProps = new Object[propertyTypes.length];
        int i = 0;
        while (i < values.length) {
            assembledProps[i] = propertyTypes[i].assemble((Serializable)values[i], session, result);
            ++i;
        }
        persister.setPropertyValues(result, assembledProps);
        persister.setIdentifier(result, id);
        if (persister.implementsLifecycle()) {
            ((Lifecycle)result).onLoad(session, id);
        }
        return assembledProps;
    }
}

