/**********************************************************************
 * $mipd_delays example -- C source code using ACC PLI routines
 *
 * C source to modify the delays of a verilog gate primitive. the
 * gate instance and delay values to be added to the existing gate
 * delays are passed as system task arguments.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $mipd_delays(<port_name>, <d1>, <d2>, ... <d9>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_AddDelays_checktf(),
 *              PLIbook_AddDelays_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_MipdDelays_calltf,     /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$mipd_delays",                /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_MipdDelays_calltf()
{
  double delay_array[9]; 
  double rise, fall, toZ;
  handle port_h;
  int i;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

acc_configure(accToHiZDelay, "average");

  acc_configure(accMinTypMaxDelays, "true"); 
  port_h = acc_handle_tfarg(1);
  
  /* most simulators return loconn handle, not port handle */
  if (   (acc_fetch_type(port_h) != accPort)
      && (acc_fetch_type(port_h) != accPortBit) )
    port_h = acc_next_port(port_h, null);
  if (   (acc_fetch_type(port_h) != accPort)
      && (acc_fetch_type(port_h) != accPortBit) ) {
    io_printf("ERR: $mipd_delays could not obtain port handle\n");
    return(0);
  }

  for (i = 0; i < 9; i++)
    delay_array[i] = acc_fetch_tfarg(i+2); 

  acc_replace_delays(port_h, delay_array);

  /* verify new delays took affect */
  acc_configure(accMinTypMaxDelays, "false");
  rise = fall = toZ = 0.0;
  acc_fetch_delays(port_h, &rise, &fall, &toZ);
  io_printf("Port %s new delays: (%1.2f, %1.2f, %1.2f)\n\n",
              acc_fetch_name(port_h),
              rise, fall, toZ);

  return(0);
  acc_close();
}
/*********************************************************************/
