# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_get_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_or_update_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_resource_set_rule_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs/defaultResourceSetRuleConfig')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_resource_set_rules_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/resourceSetRuleConfigs')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class ResourceSetRulesOperations(object):
    """ResourceSetRulesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_resource_set_rule(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a resource set config service model.

        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_resource_set_rule_request(
            template_url=self.get_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def create_or_update_resource_set_rule(
        self,
        resource_set_rule_config,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Creates or updates an resource set config.

        :param resource_set_rule_config:
        :type resource_set_rule_config: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource_set_rule_config = {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = resource_set_rule_config

        request = build_create_or_update_resource_set_rule_request(
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def delete_resource_set_rule(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes a ResourceSetRuleConfig resource.

        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_resource_set_rule_request(
            template_url=self.delete_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def list_resource_set_rules(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """Get a resource set config service model.

        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": "long (optional)",
                    "nextLink": "str (optional)",
                    "value": [
                        {
                            "advancedResourceSet": {
                                "modifiedAt": "datetime (optional)",
                                "resourceSetProcessing": "str (optional)"
                            },
                            "name": "str (optional)",
                            "pathPatternConfig": {
                                "acceptedPatterns": [
                                    {
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "filterType": "str (optional). Default value is \"Pattern\"",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "path": "str"
                                    }
                                ],
                                "complexReplacers": [
                                    {
                                        "createdBy": "str (optional)",
                                        "description": "str (optional)",
                                        "disableRecursiveReplacerApplication": "bool (optional)",
                                        "disabled": "bool (optional)",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional)",
                                        "name": "str (optional)",
                                        "typeName": "str (optional)"
                                    }
                                ],
                                "createdBy": "str",
                                "enableDefaultPatterns": "bool",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "normalizationRules": [
                                    {
                                        "description": "str (optional)",
                                        "disabled": "bool (optional)",
                                        "dynamicReplacement": "bool (optional)",
                                        "entityTypes": [
                                            "str (optional)"
                                        ],
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "regex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "replaceWith": "str (optional)",
                                        "version": "float (optional)"
                                    }
                                ],
                                "regexReplacers": [
                                    {
                                        "condition": "str (optional)",
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "description": "str (optional)",
                                        "disableRecursiveReplacerApplication": "bool (optional)",
                                        "disabled": "bool",
                                        "doNotReplaceRegex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "regex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "replaceWith": "str (optional)"
                                    }
                                ],
                                "rejectedPatterns": [
                                    {
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "filterType": "str (optional). Default value is \"Pattern\"",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "path": "str"
                                    }
                                ],
                                "scopedRules": [
                                    {
                                        "bindingUrl": "str",
                                        "rules": [
                                            {
                                                "displayName": "str (optional)",
                                                "isResourceSet": "bool (optional). Default value is True",
                                                "lastUpdatedTimestamp": "long (optional)",
                                                "name": "str (optional)",
                                                "qualifiedName": "str"
                                            }
                                        ],
                                        "storeType": "str"
                                    }
                                ],
                                "version": "int (optional). Default value is 0"
                            }
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=self.list_resource_set_rules.metadata['url'],
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=next_link,
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_resource_set_rules.metadata = {'url': '/resourceSetRuleConfigs'}  # type: ignore
